/*
 * Decompiled with CFR 0.152.
 */
package java.util.concurrent.atomic;

import java.io.Serializable;
import sun.misc.Unsafe;

public class AtomicReferenceArray<E>
implements Serializable {
    private static final long serialVersionUID = -6209656149925076980L;
    private static final Unsafe unsafe = Unsafe.getUnsafe();
    private static final int base = unsafe.arrayBaseOffset(Object[].class);
    private static final int shift;
    private final Object[] array;

    private long checkedByteOffset(int n) {
        if (n < 0 || n >= this.array.length) {
            throw new IndexOutOfBoundsException("index " + n);
        }
        return AtomicReferenceArray.byteOffset(n);
    }

    private static long byteOffset(int n) {
        return ((long)n << shift) + (long)base;
    }

    public AtomicReferenceArray(int n) {
        this.array = new Object[n];
    }

    public AtomicReferenceArray(E[] EArray) {
        this.array = (Object[])EArray.clone();
    }

    public final int length() {
        return this.array.length;
    }

    public final E get(int n) {
        return this.getRaw(this.checkedByteOffset(n));
    }

    private E getRaw(long l) {
        return (E)unsafe.getObjectVolatile(this.array, l);
    }

    public final void set(int n, E e) {
        unsafe.putObjectVolatile(this.array, this.checkedByteOffset(n), e);
    }

    public final void lazySet(int n, E e) {
        unsafe.putOrderedObject(this.array, this.checkedByteOffset(n), e);
    }

    public final E getAndSet(int n, E e) {
        E e2;
        long l = this.checkedByteOffset(n);
        while (!this.compareAndSetRaw(l, e2 = this.getRaw(l), e)) {
        }
        return e2;
    }

    public final boolean compareAndSet(int n, E e, E e2) {
        return this.compareAndSetRaw(this.checkedByteOffset(n), e, e2);
    }

    private boolean compareAndSetRaw(long l, E e, E e2) {
        return unsafe.compareAndSwapObject(this.array, l, e, e2);
    }

    public final boolean weakCompareAndSet(int n, E e, E e2) {
        return this.compareAndSet(n, e, e2);
    }

    public String toString() {
        int n = this.array.length - 1;
        if (n == -1) {
            return "[]";
        }
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append('[');
        int n2 = 0;
        while (true) {
            stringBuilder.append(this.getRaw(AtomicReferenceArray.byteOffset(n2)));
            if (n2 == n) {
                return stringBuilder.append(']').toString();
            }
            stringBuilder.append(',').append(' ');
            ++n2;
        }
    }

    static {
        int n = unsafe.arrayIndexScale(Object[].class);
        if ((n & n - 1) != 0) {
            throw new Error("data type scale not a power of two");
        }
        shift = 31 - Integer.numberOfLeadingZeros(n);
    }
}

