/*
 * Decompiled with CFR 0.152.
 */
package com.sun.org.apache.xpath.internal.axes;

import com.sun.org.apache.xml.internal.utils.PrefixResolver;
import com.sun.org.apache.xpath.internal.Expression;
import com.sun.org.apache.xpath.internal.ExpressionOwner;
import com.sun.org.apache.xpath.internal.VariableStack;
import com.sun.org.apache.xpath.internal.XPathVisitor;
import com.sun.org.apache.xpath.internal.axes.AxesWalker;
import com.sun.org.apache.xpath.internal.axes.LocPathIterator;
import com.sun.org.apache.xpath.internal.axes.WalkerFactory;
import com.sun.org.apache.xpath.internal.compiler.Compiler;
import java.util.Vector;
import javax.xml.transform.TransformerException;

public class WalkingIterator
extends LocPathIterator
implements ExpressionOwner {
    static final long serialVersionUID = 9110225941815665906L;
    protected AxesWalker m_lastUsedWalker;
    protected AxesWalker m_firstWalker;

    WalkingIterator(Compiler compiler, int n, int n2, boolean bl) throws TransformerException {
        super(compiler, n, n2, bl);
        int n3 = Compiler.getFirstChildPos(n);
        if (bl) {
            this.m_lastUsedWalker = this.m_firstWalker = WalkerFactory.loadWalkers(this, compiler, n3, 0);
        }
    }

    public WalkingIterator(PrefixResolver prefixResolver) {
        super(prefixResolver);
    }

    @Override
    public int getAnalysisBits() {
        int n = 0;
        if (null != this.m_firstWalker) {
            for (AxesWalker axesWalker = this.m_firstWalker; null != axesWalker; axesWalker = axesWalker.getNextWalker()) {
                int n2 = axesWalker.getAnalysisBits();
                n |= n2;
            }
        }
        return n;
    }

    @Override
    public Object clone() throws CloneNotSupportedException {
        WalkingIterator walkingIterator = (WalkingIterator)super.clone();
        if (null != this.m_firstWalker) {
            walkingIterator.m_firstWalker = this.m_firstWalker.cloneDeep(walkingIterator, null);
        }
        return walkingIterator;
    }

    @Override
    public void reset() {
        super.reset();
        if (null != this.m_firstWalker) {
            this.m_lastUsedWalker = this.m_firstWalker;
            this.m_firstWalker.setRoot(this.m_context);
        }
    }

    @Override
    public void setRoot(int n, Object object) {
        super.setRoot(n, object);
        if (null != this.m_firstWalker) {
            this.m_firstWalker.setRoot(n);
            this.m_lastUsedWalker = this.m_firstWalker;
        }
    }

    @Override
    public int nextNode() {
        if (this.m_foundLast) {
            return -1;
        }
        if (-1 == this.m_stackFrame) {
            return this.returnNextNode(this.m_firstWalker.nextNode());
        }
        VariableStack variableStack = this.m_execContext.getVarStack();
        int n = variableStack.getStackFrame();
        variableStack.setStackFrame(this.m_stackFrame);
        int n2 = this.returnNextNode(this.m_firstWalker.nextNode());
        variableStack.setStackFrame(n);
        return n2;
    }

    public final AxesWalker getFirstWalker() {
        return this.m_firstWalker;
    }

    public final void setFirstWalker(AxesWalker axesWalker) {
        this.m_firstWalker = axesWalker;
    }

    public final void setLastUsedWalker(AxesWalker axesWalker) {
        this.m_lastUsedWalker = axesWalker;
    }

    public final AxesWalker getLastUsedWalker() {
        return this.m_lastUsedWalker;
    }

    @Override
    public void detach() {
        if (this.m_allowDetach) {
            for (AxesWalker axesWalker = this.m_firstWalker; null != axesWalker; axesWalker = axesWalker.getNextWalker()) {
                axesWalker.detach();
            }
            this.m_lastUsedWalker = null;
            super.detach();
        }
    }

    @Override
    public void fixupVariables(Vector vector, int n) {
        this.m_predicateIndex = -1;
        for (AxesWalker axesWalker = this.m_firstWalker; null != axesWalker; axesWalker = axesWalker.getNextWalker()) {
            axesWalker.fixupVariables(vector, n);
        }
    }

    @Override
    public void callVisitors(ExpressionOwner expressionOwner, XPathVisitor xPathVisitor) {
        if (xPathVisitor.visitLocationPath(expressionOwner, this) && null != this.m_firstWalker) {
            this.m_firstWalker.callVisitors(this, xPathVisitor);
        }
    }

    @Override
    public Expression getExpression() {
        return this.m_firstWalker;
    }

    @Override
    public void setExpression(Expression expression) {
        expression.exprSetParent(this);
        this.m_firstWalker = (AxesWalker)expression;
    }

    @Override
    public boolean deepEquals(Expression expression) {
        AxesWalker axesWalker;
        if (!super.deepEquals(expression)) {
            return false;
        }
        AxesWalker axesWalker2 = this.m_firstWalker;
        for (axesWalker = ((WalkingIterator)expression).m_firstWalker; null != axesWalker2 && null != axesWalker; axesWalker2 = axesWalker2.getNextWalker(), axesWalker = axesWalker.getNextWalker()) {
            if (axesWalker2.deepEquals(axesWalker)) continue;
            return false;
        }
        return null == axesWalker2 && null == axesWalker;
    }
}

