/*
 * Decompiled with CFR 0.152.
 */
package it.sogei.rcp.pki.manager;

import cryptotools.CertificateUtils;
import cryptotools.PilaRisultatiVerifica;
import cryptotools.Vault;
import cryptotools.initEnv;
import cryptotools.signer;
import cryptotools.verifier;
import it.sogei.rcp.interfaces.IAbsolutePath;
import it.sogei.rcp.pki.Activator;
import it.sogei.rcp.pki.bean.KeyStoreInfo;
import it.sogei.rcp.pki.exception.PkiException;
import it.sogei.rcp.pki.exception.SignException;
import it.sogei.rcp.pki.exception.VerifyException;
import it.sogei.utilities.log4j.LogUtil;
import java.security.cert.X509Certificate;
import org.eclipse.ui.PlatformUI;
import utility.VerifyUtils;

public class Signer {
    private KeyStoreInfo keystore;
    private String policyFilePath;
    private String cryptoFilePath;

    public Signer(KeyStoreInfo keystore) throws PkiException {
        this.keystore = keystore;
        CertificateUtils.installBCProvider();
        try {
            this.cryptoFilePath = Activator.cryptotoolsFileMap.get(PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage().getPerspective().getId());
            initEnv IE = new initEnv();
            initEnv.loadEnv((String)this.cryptoFilePath);
            this.policyFilePath = Activator.policyFileMap.get(PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage().getPerspective().getId());
        }
        catch (Exception e) {
            throw new PkiException("Errore nel caricamento delle configurazioni", e);
        }
    }

    public void sign(IAbsolutePath pathFileToSign, IAbsolutePath pathFileSigned) throws SignException {
        try {
            Vault v = new Vault(this.keystore.getPath().getAbsolutePath(), "PKCS12");
            Vault[] vaults = new Vault[]{v};
            vaults[0].Open(this.keystore.getPassword());
            signer.setVault((Vault)vaults[0]);
            signer.sign((String)pathFileToSign.getAbsolutePath(), (String)pathFileSigned.getAbsolutePath());
        }
        catch (Exception ex) {
            throw new SignException("Errore nella firma del file " + pathFileToSign, ex);
        }
    }

    public void streamSign(IAbsolutePath pathFileToSign, IAbsolutePath pathFileSigned) throws SignException {
        try {
            Vault v = new Vault(this.keystore.getPath().getAbsolutePath(), "PKCS12");
            Vault[] vaults = new Vault[]{v};
            vaults[0].Open(this.keystore.getPassword());
            signer.setVault((Vault)vaults[0]);
            signer.streamSign((String)pathFileToSign.getAbsolutePath(), (String)pathFileSigned.getAbsolutePath(), (boolean)true);
        }
        catch (Exception ex) {
            throw new SignException("Errore nella firma del file " + pathFileToSign, ex);
        }
    }

    public X509Certificate verify(IAbsolutePath pathFileSigned, IAbsolutePath pathFileDesecure) throws VerifyException {
        PilaRisultatiVerifica pila = new PilaRisultatiVerifica();
        try {
            initEnv.loadVerifyEnv((String)"1234", (String)this.policyFilePath);
            String pathFileSignedString = pathFileSigned.getAbsolutePath();
            String pathFileDesecureString = pathFileDesecure.getAbsolutePath();
            verifier.desecure((String)pathFileSignedString, (String)pathFileDesecureString, (PilaRisultatiVerifica)pila);
            PilaRisultatiVerifica ris = pila.copia();
            VerifyUtils.printErrori((PilaRisultatiVerifica)ris);
            X509Certificate cert = pila.topRisultati()[0].getSignerCert();
            if (cert != null) {
                LogUtil.log((Object)this, (int)2, (String)cert.toString());
            }
            return cert;
        }
        catch (Exception ex) {
            throw new VerifyException("Firma non valida per il file " + pathFileSigned.getAbsolutePath(), ex);
        }
    }

    public X509Certificate streamVerify(IAbsolutePath pathFileSigned, IAbsolutePath pathFileDesecure) throws VerifyException {
        PilaRisultatiVerifica pila = new PilaRisultatiVerifica();
        try {
            initEnv.loadVerifyEnv((String)"1234", (String)this.policyFilePath);
            String pathFileSignedString = pathFileSigned.getAbsolutePath();
            String pathFileDesecureString = pathFileDesecure.getAbsolutePath();
            verifier.streamDesecure((String)pathFileSignedString, (String)pathFileDesecureString, (PilaRisultatiVerifica)pila);
            PilaRisultatiVerifica ris = pila.copia();
            VerifyUtils.printErrori((PilaRisultatiVerifica)ris);
            X509Certificate cert = pila.topRisultati()[0].getSignerCert();
            if (cert != null) {
                LogUtil.log((Object)this, (int)2, (String)cert.toString());
            }
            return cert;
        }
        catch (Exception ex) {
            throw new VerifyException("Firma non valida per il file " + pathFileSigned.getAbsolutePath(), ex);
        }
    }
}

