/*
 * Decompiled with CFR 0.152.
 */
package javax.xml.crypto.dsig.spec;

import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;

public class XPathType {
    private Map nsMap;
    private final Filter filter;
    private final String expression;

    public Map getNamespaceMap() {
        return this.nsMap;
    }

    public Filter getFilter() {
        return this.filter;
    }

    public String getExpression() {
        return this.expression;
    }

    public XPathType(String string, Filter filter, Map map) {
        this(string, filter);
        if (map == null) {
            throw new NullPointerException("namespaceMap cannot be null");
        }
        this.nsMap = new HashMap(map);
        Iterator iterator = this.nsMap.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry entry = iterator.next();
            if (entry.getKey() instanceof String && entry.getValue() instanceof String) continue;
            throw new ClassCastException("not a String");
        }
        this.nsMap = Collections.unmodifiableMap(this.nsMap);
    }

    public XPathType(String string, Filter filter) {
        if (string == null) {
            throw new NullPointerException("expression cannot be null");
        }
        if (filter == null) {
            throw new NullPointerException("filter cannot be null");
        }
        this.expression = string;
        this.filter = filter;
        this.nsMap = new HashMap();
    }

    public static class Filter {
        private String operation;
        public static final Filter UNION;
        public static final Filter SUBTRACT;
        public static final Filter INTERSECT;

        public String toString() {
            return this.operation;
        }

        private Filter(String string) {
            this.operation = string;
        }

        static {
            INTERSECT = new Filter("intersect");
            SUBTRACT = new Filter("subtract");
            UNION = new Filter("union");
        }
    }
}

