/*
 * Decompiled with CFR 0.152.
 */
package iaik.xml.crypto.dsig;

import iaik.xml.crypto.dom.DOMStructure;
import iaik.xml.crypto.dom.XmldsigDOMStructure;
import iaik.xml.crypto.dsig.ManifestImpl;
import iaik.xml.crypto.dsig.SignedInfoImpl;
import iaik.xml.crypto.utils.DOMUtils;
import iaik.xml.crypto.utils.KeySelectorImpl;
import iaik.xml.crypto.utils.Utils;
import java.security.Key;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import javax.xml.crypto.KeySelector;
import javax.xml.crypto.KeySelectorException;
import javax.xml.crypto.KeySelectorResult;
import javax.xml.crypto.MarshalException;
import javax.xml.crypto.XMLCryptoContext;
import javax.xml.crypto.dom.DOMCryptoContext;
import javax.xml.crypto.dsig.SignedInfo;
import javax.xml.crypto.dsig.XMLObject;
import javax.xml.crypto.dsig.XMLSignContext;
import javax.xml.crypto.dsig.XMLSignature;
import javax.xml.crypto.dsig.XMLSignatureException;
import javax.xml.crypto.dsig.XMLValidateContext;
import javax.xml.crypto.dsig.dom.DOMSignContext;
import javax.xml.crypto.dsig.keyinfo.KeyInfo;
import org.w3c.dom.Attr;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class XMLSignatureImpl
extends XmldsigDOMStructure
implements XMLSignature {
    static /* synthetic */ Class class$iaik$xml$crypto$dom$DOMCryptoContext;
    static /* synthetic */ Class class$iaik$xml$crypto$dsig$XMLObjectImpl;
    protected boolean validated_ = false;
    protected boolean valid_ = true;
    protected byte[] calculatedSignatureValue_;
    protected KeySelectorResult keySelectorResult_;
    protected List objects_;
    protected KeyInfo keyInfo_;
    protected SignatureValueImpl signatureValue_;
    protected SignedInfoImpl signedInfo_;
    protected String id_;
    public static final int STATE_SIGNED = 4;

    protected boolean validateSignatureValue(XMLValidateContext xMLValidateContext, Key key) throws XMLSignatureException {
        if (this.signatureValue_.getValue() != null) {
            return this.signedInfo_.validateSignatureValue(xMLValidateContext, this.signatureValue_.getValue(), key);
        }
        return false;
    }

    protected boolean validateCore(XMLValidateContext xMLValidateContext) throws XMLSignatureException {
        if (!this.validated_) {
            boolean bl = true;
            if (this.signedInfo_ == null) {
                throw new XMLSignatureException("Reference Validation failed, SignedInfo element is missing");
            }
            bl &= this.signedInfo_.validateReferences(xMLValidateContext);
            if (this.signatureValue_ == null) {
                throw new XMLSignatureException("Signature Validation failed, SignatureValue element is missing");
            }
            this.valid_ = bl &= this.selectKeyAndValidateSignature(xMLValidateContext);
            this.validated_ = true;
        }
        return this.valid_;
    }

    public boolean validate(XMLValidateContext xMLValidateContext) throws XMLSignatureException {
        if (!this.validated_) {
            List list = DOMUtils.distributeNSDeclarations((Element)this.getNode());
            this.valid_ = this.validateCore(xMLValidateContext);
            DOMUtils.withdrawDistributedNSDeclarations((Element)this.getNode(), list);
        }
        return this.valid_;
    }

    protected void unmarshalStructures(NodeList nodeList, DOMCryptoContext dOMCryptoContext) throws MarshalException {
        if (nodeList == null) {
            return;
        }
        int n = 0;
        while (n < nodeList.getLength()) {
            Node node = nodeList.item(n);
            if (node.getNodeType() == 1) {
                if (node.getLocalName().equals("SignatureValue")) {
                    this.signatureValue_ = new SignatureValueImpl(dOMCryptoContext, node);
                } else {
                    DOMStructure dOMStructure = DOMStructure.getInstance(node, dOMCryptoContext);
                    if (dOMStructure != null) {
                        this.putChildStructure(dOMStructure);
                    }
                }
            }
            ++n;
        }
    }

    protected void unmarshalAttributes(NamedNodeMap namedNodeMap, DOMCryptoContext dOMCryptoContext) throws MarshalException {
        super.unmarshalAttributes(namedNodeMap, dOMCryptoContext);
        this.id_ = this.unmarshalIDAttribute(namedNodeMap, dOMCryptoContext, "Id");
    }

    public void unmarshal(DOMCryptoContext dOMCryptoContext) throws MarshalException {
        this.assureDefaults(dOMCryptoContext);
        super.unmarshal(dOMCryptoContext);
        this.state_ = 4;
    }

    public void sign(XMLSignContext xMLSignContext) throws XMLSignatureException, MarshalException {
        DOMSignContext dOMSignContext = (DOMSignContext)xMLSignContext;
        Object object = dOMSignContext.getProperty("iaik.xml.crypto.dsig.sign-over");
        if (Boolean.TRUE.equals(object)) {
            this.clearMarshalling();
        }
        if (this.state_ < 1) {
            this.marshal(dOMSignContext, dOMSignContext.getParent(), dOMSignContext.getNextSibling());
        }
        List list = DOMUtils.distributeNSDeclarations((Element)this.getNode());
        dOMSignContext.put(dOMSignContext, list);
        this.generateCore(dOMSignContext);
        DOMUtils.withdrawDistributedNSDeclarations((Element)this.getNode(), list);
        this.state_ = 4;
    }

    protected boolean selectKeyAndValidateSignature(XMLValidateContext xMLValidateContext) throws XMLSignatureException {
        if (!this.signatureValue_.validated_) {
            try {
                this.selectKey(xMLValidateContext, KeySelector.Purpose.VERIFY);
            }
            catch (KeySelectorException keySelectorException) {
                throw new XMLSignatureException("Signature Validation failed, ", keySelectorException);
            }
            if (this.keySelectorResult_ == null) {
                throw new XMLSignatureException("Signature Validation failed, the given KeySelector returned no valid key");
            }
            this.signatureValue_.valid_ &= this.validateSignatureValue(xMLValidateContext, this.keySelectorResult_.getKey());
        }
        return this.signatureValue_.valid_;
    }

    protected void selectKeyAndGenerateSignature(DOMCryptoContext dOMCryptoContext) throws MarshalException, XMLSignatureException {
        try {
            this.selectKey(dOMCryptoContext, KeySelector.Purpose.SIGN);
        }
        catch (KeySelectorException keySelectorException) {
            throw new XMLSignatureException("Signature Generation failed. " + keySelectorException.getMessage(), keySelectorException);
        }
        Key key = this.keySelectorResult_.getKey();
        if (key == null) {
            throw new XMLSignatureException("Signature Generation failed. The given KeySelector returned no valid key.");
        }
        this.calculateAndMarshalSignatureValue(dOMCryptoContext, key);
    }

    protected void selectKey(XMLCryptoContext xMLCryptoContext, KeySelector.Purpose purpose) throws KeySelectorException, XMLSignatureException {
        KeySelector keySelector = xMLCryptoContext.getKeySelector();
        if (keySelector == null) {
            throw new XMLSignatureException("Failed to select key. No KeySelector provided in XMLCryptoContext.");
        }
        this.keySelectorResult_ = keySelector.select(this.keyInfo_, purpose, this.signedInfo_.getSignatureMethod(), xMLCryptoContext);
        if (this.keySelectorResult_ == null) {
            String string;
            String string2 = "KeySelector returned 'null'.";
            if (keySelector instanceof KeySelectorImpl && (string = ((KeySelectorImpl)keySelector).getFailReason()) != null && !string.equals("")) {
                string2 = string;
            }
            throw new XMLSignatureException("Failed to select key: " + string2);
        }
    }

    protected void putChildStructure(DOMStructure dOMStructure) throws MarshalException {
        super.putChildStructure(dOMStructure);
        if (dOMStructure instanceof SignedInfo) {
            this.signedInfo_ = (SignedInfoImpl)dOMStructure;
            return;
        }
        if (dOMStructure instanceof XMLSignature.SignatureValue) {
            this.signatureValue_ = (SignatureValueImpl)dOMStructure;
            return;
        }
        if (dOMStructure instanceof KeyInfo) {
            this.keyInfo_ = (KeyInfo)((Object)dOMStructure);
            return;
        }
        if (dOMStructure instanceof XMLObject) {
            this.objects_.add(dOMStructure);
            return;
        }
    }

    protected Attr marshalIDAttribute(DOMCryptoContext dOMCryptoContext, Element element) {
        Attr attr = super.marshalIDAttribute(dOMCryptoContext, element);
        if (this.id_ != null) {
            attr = element.getOwnerDocument().createAttributeNS("", "Id");
            attr.setValue(this.id_);
            return attr;
        }
        return null;
    }

    protected void marshalAttributes(DOMCryptoContext dOMCryptoContext, Element element) throws MarshalException {
        super.marshalAttributes(dOMCryptoContext, element);
        Document document = DOMUtils.getOwnerDocument(element);
        String string = null;
        String string2 = null;
        try {
            string = (String)dOMCryptoContext.getProperty("iaik.xml.crypto.dsig.schema-instance");
            string2 = (String)dOMCryptoContext.getProperty("iaik.xml.crypto.xades.schema-instance");
        }
        catch (ClassCastException classCastException) {}
        if (string != null && string.length() > 0 || string2 != null && string2.length() > 0) {
            String string3 = "http://www.w3.org/2001/XMLSchema-instance";
            String string4 = dOMCryptoContext.getNamespacePrefix(string3, null);
            if (string4 == null || string4.length() < 1) {
                dOMCryptoContext.putNamespacePrefix(string3, "xsi");
            }
            DOMUtils.createNSDeclAttribute(dOMCryptoContext, element, string3);
            Attr attr = document.createAttributeNS(string3, String.valueOf(string4) + ":schemaLocation");
            String string5 = string != null ? "http://www.w3.org/2000/09/xmldsig# " + string : "";
            string5 = String.valueOf(string5) + (string5.length() > 0 ? " " : "");
            string5 = String.valueOf(string5) + (string2 != null ? "http://uri.etsi.org/01903/v1.3.2# " + string2 : "");
            attr.setValue(string5);
            element.setAttributeNodeNS(attr);
        }
    }

    public Node marshal(DOMCryptoContext dOMCryptoContext, Node node, Node node2) throws MarshalException {
        this.assureDefaults(dOMCryptoContext);
        return super.marshal(dOMCryptoContext, node, node2);
    }

    public SignedInfo getSignedInfo() {
        return this.signedInfo_;
    }

    public XMLSignature.SignatureValue getSignatureValue() {
        return this.signatureValue_;
    }

    public List getObjects() {
        return Collections.unmodifiableList(this.objects_);
    }

    public String getLocalName() {
        return "Signature";
    }

    public KeySelectorResult getKeySelectorResult() {
        return this.keySelectorResult_;
    }

    public KeyInfo getKeyInfo() {
        return this.keyInfo_;
    }

    public String getId() {
        return this.id_;
    }

    protected List getChildStructures() {
        List list = super.getChildStructures();
        if (this.signedInfo_ != null) {
            list.add(this.signedInfo_);
        }
        if (this.signatureValue_ != null) {
            list.add(this.signatureValue_);
        }
        if (this.keyInfo_ != null) {
            list.add(this.keyInfo_);
        }
        if (!this.objects_.isEmpty()) {
            list.addAll(this.objects_);
        }
        return list;
    }

    protected void generateCore(DOMCryptoContext dOMCryptoContext) throws MarshalException, XMLSignatureException {
        Iterator iterator = this.objects_.iterator();
        while (iterator.hasNext()) {
            XMLObject xMLObject = (XMLObject)iterator.next();
            Iterator iterator2 = xMLObject.getContent().iterator();
            while (iterator2.hasNext()) {
                Object e2 = iterator2.next();
                if (!(e2 instanceof ManifestImpl)) continue;
                ((ManifestImpl)e2).generateReferences(dOMCryptoContext);
            }
        }
        this.signedInfo_.generateReferences(dOMCryptoContext);
        this.selectKeyAndGenerateSignature(dOMCryptoContext);
    }

    static Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    protected void calculateAndMarshalSignatureValue(DOMCryptoContext dOMCryptoContext, Key key) throws MarshalException, XMLSignatureException {
        byte[] byArray = this.signedInfo_.calculateSignatureValue(dOMCryptoContext, key);
        if (Boolean.TRUE.equals(dOMCryptoContext.getProperty("iaik.xml.crypto.dsig.sign-over")) && dOMCryptoContext instanceof DOMSignContext) {
            this.signatureValue_.value_ = null;
        }
        this.signatureValue_.appendValue(dOMCryptoContext, byArray);
    }

    protected void assureDefaults(XMLCryptoContext xMLCryptoContext) {
        if (!(class$iaik$xml$crypto$dom$DOMCryptoContext != null ? class$iaik$xml$crypto$dom$DOMCryptoContext : (class$iaik$xml$crypto$dom$DOMCryptoContext = XMLSignatureImpl.class$("iaik.xml.crypto.dom.DOMCryptoContext"))).isAssignableFrom(xMLCryptoContext.getClass())) {
            iaik.xml.crypto.dom.DOMCryptoContext.setDefaultsIfNotSet(xMLCryptoContext);
        }
    }

    protected XMLSignatureImpl(Node node) throws MarshalException {
        super(node);
    }

    public XMLSignatureImpl(DOMCryptoContext dOMCryptoContext, Node node) throws MarshalException {
        super(node);
        if (dOMCryptoContext == null) {
            throw new NullPointerException("Argument 'context' must not be null.");
        }
        this.objects_ = new ArrayList();
        this.unmarshal(dOMCryptoContext);
        if (this.signedInfo_ == null || this.signatureValue_ == null) {
            throw new MarshalException("The content of element '" + node + "' is not complete.");
        }
    }

    public XMLSignatureImpl(SignedInfoImpl signedInfoImpl, KeyInfo keyInfo, List list, String string, String string2) {
        if (signedInfoImpl == null) {
            throw new NullPointerException("Argument 'signedInfo' must not be null.");
        }
        this.signedInfo_ = signedInfoImpl;
        this.keyInfo_ = keyInfo;
        this.objects_ = Utils.copyList(list, class$iaik$xml$crypto$dsig$XMLObjectImpl != null ? class$iaik$xml$crypto$dsig$XMLObjectImpl : (class$iaik$xml$crypto$dsig$XMLObjectImpl = XMLSignatureImpl.class$("iaik.xml.crypto.dsig.XMLObjectImpl")), "objects", true, true);
        this.id_ = string;
        this.signatureValue_ = new SignatureValueImpl(string2);
    }

    protected class SignatureValueImpl
    extends XmldsigDOMStructure
    implements XMLSignature.SignatureValue {
        protected boolean valid_ = true;
        protected boolean validated_ = false;
        protected byte[] value_;
        protected String id_;

        public boolean validate(XMLValidateContext xMLValidateContext) throws XMLSignatureException {
            if (!this.validated_) {
                List list = DOMUtils.distributeNSDeclarations((Element)this.getNode());
                this.valid_ &= XMLSignatureImpl.this.selectKeyAndValidateSignature(xMLValidateContext);
                DOMUtils.withdrawDistributedNSDeclarations((Element)this.getNode(), list);
            }
            return this.valid_;
        }

        protected void unmarshalElement(DOMCryptoContext dOMCryptoContext, Element element) throws MarshalException {
            super.unmarshalElement(dOMCryptoContext, element);
            this.value_ = DOMStructure.getBytesFromElement(element);
        }

        protected void unmarshalAttributes(NamedNodeMap namedNodeMap, DOMCryptoContext dOMCryptoContext) throws MarshalException {
            super.unmarshalAttributes(namedNodeMap, dOMCryptoContext);
            this.id_ = this.unmarshalIDAttribute(namedNodeMap, dOMCryptoContext, "Id");
        }

        protected Attr marshalIDAttribute(DOMCryptoContext dOMCryptoContext, Element element) {
            Attr attr = super.marshalIDAttribute(dOMCryptoContext, element);
            if (this.id_ != null) {
                attr = element.getOwnerDocument().createAttributeNS("", "Id");
                attr.setValue(this.id_);
                return attr;
            }
            return null;
        }

        protected Element marshalElement(DOMCryptoContext dOMCryptoContext, Node node, Node node2) throws MarshalException {
            Element element = super.marshalElement(dOMCryptoContext, node, node2);
            if (this.value_ != null) {
                DOMStructure.addBytesToElement(element, this.value_, dOMCryptoContext);
            }
            return element;
        }

        public byte[] getValue() {
            return this.value_ != null ? (byte[])this.value_.clone() : null;
        }

        public String getLocalName() {
            return "SignatureValue";
        }

        public String getId() {
            return this.id_;
        }

        public void appendValue(DOMCryptoContext dOMCryptoContext, byte[] byArray) throws MarshalException {
            if (this.state_ < 1) {
                throw new MarshalException("Element hasn't been marshaled yet");
            }
            if (this.value_ != null) {
                throw new MarshalException("Digest value has already been appended");
            }
            this.value_ = byArray;
            DOMStructure.addBytesToElement((Element)this.getNode(), byArray, dOMCryptoContext);
        }

        public SignatureValueImpl(byte[] byArray, String string) {
            this.value_ = byArray;
            this.id_ = string;
        }

        public SignatureValueImpl(DOMCryptoContext dOMCryptoContext, Node node) throws MarshalException {
            super(node);
            if (dOMCryptoContext == null) {
                throw new NullPointerException("Argument 'context' must not be null.");
            }
            this.unmarshal(dOMCryptoContext);
        }

        public SignatureValueImpl(String string) {
            this.id_ = string;
        }
    }
}

