/*
 * Decompiled with CFR 0.152.
 */
package iaik.xml.crypto.alg.mac;

import iaik.xml.crypto.XSecProvider;
import java.security.InvalidAlgorithmParameterException;
import java.security.InvalidKeyException;
import java.security.Key;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import java.security.spec.AlgorithmParameterSpec;
import javax.crypto.Mac;
import javax.crypto.MacSpi;

public abstract class ProxyMac
extends MacSpi {
    Mac mac_;

    protected abstract String getMacName();

    protected void engineUpdate(byte[] byArray, int n, int n2) {
        this.mac_.update(byArray, n, n2);
    }

    protected void engineUpdate(byte by) {
        this.mac_.update(by);
    }

    protected void engineReset() {
        this.mac_.reset();
    }

    protected void engineInit(Key key, AlgorithmParameterSpec algorithmParameterSpec) throws InvalidAlgorithmParameterException, InvalidKeyException {
        this.mac_.init(key, algorithmParameterSpec);
    }

    protected int engineGetMacLength() {
        return this.mac_.getMacLength();
    }

    protected byte[] engineDoFinal() {
        return this.mac_.doFinal();
    }

    protected ProxyMac() throws NoSuchProviderException, NoSuchAlgorithmException {
        String string = this.getMacName();
        String string2 = XSecProvider.getDelegationProvider("Mac." + string);
        if (string2 != null) {
            try {
                this.mac_ = Mac.getInstance(string, string2);
            }
            catch (NoSuchProviderException noSuchProviderException) {
                throw new NoSuchAlgorithmException("MessageDigest." + string + " delegation provider '" + string2 + "' not registered.");
            }
        } else {
            this.mac_ = Mac.getInstance(string);
        }
    }
}

