/*
 * Decompiled with CFR 0.152.
 */
package iaik.cms;

import iaik.asn1.ASN1Object;
import iaik.asn1.DerCoder;
import iaik.asn1.OCTET_STRING;
import iaik.cms.CMSException;
import iaik.cms.CMSParsingException;
import iaik.cms.Content;
import iaik.cms.DataStream;
import iaik.cms.Utils;
import iaik.utils.Util;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;

public class Data
extends DataStream
implements Content {
    private byte[] a;

    public String toString(boolean bl) {
        StringBuffer stringBuffer = new StringBuffer();
        if (this.a != null) {
            stringBuffer.append("Content: " + this.a.length + " bytes");
            if (bl) {
                stringBuffer.append(": " + Util.toString((byte[])this.a, (int)0, (int)15));
                if (this.a.length > 15) {
                    stringBuffer.append("...");
                }
            }
        } else {
            stringBuffer.append("No content!");
        }
        return stringBuffer.toString();
    }

    public ASN1Object toASN1Object() throws CMSException {
        if (this.blockSize_ > 0) {
            return new OCTET_STRING(this.a, this.blockSize_);
        }
        return new OCTET_STRING(this.a);
    }

    public InputStream getInputStream() {
        if (this.a != null) {
            return new ByteArrayInputStream(this.a);
        }
        return this.inputStream_;
    }

    public byte[] getEncoded() throws CMSException {
        try {
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
            DerCoder.encodeTo((ASN1Object)this.toASN1Object(), (OutputStream)byteArrayOutputStream);
            return byteArrayOutputStream.toByteArray();
        }
        catch (IOException iOException) {
            throw new CMSException(iOException.getMessage());
        }
    }

    public byte[] getData() {
        return this.a;
    }

    public void decode(InputStream inputStream) throws CMSParsingException, IOException {
        super.decode(inputStream);
        if (this.inputStream_ != null) {
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream(4096);
            Utils.copyStream(this.inputStream_, byteArrayOutputStream, null);
            this.a = byteArrayOutputStream.toByteArray();
        }
    }

    public void decode(ASN1Object aSN1Object) throws CMSParsingException {
        if (aSN1Object == null) {
            throw new CMSParsingException("Cannot decode a null object!");
        }
        byte[] byArray = DerCoder.encode((ASN1Object)aSN1Object);
        if (byArray == null) {
            throw new CMSParsingException("Parsing error!");
        }
        try {
            this.decode(new ByteArrayInputStream(byArray));
            return;
        }
        catch (IOException iOException) {
            throw new CMSParsingException(iOException.getMessage());
        }
    }

    public Data(byte[] byArray, int n2) {
        this();
        this.a = byArray;
        this.blockSize_ = n2;
    }

    public Data(byte[] byArray) {
        this();
        this.a = byArray;
    }

    public Data(InputStream inputStream) throws CMSParsingException, IOException {
        this();
        this.decode(inputStream);
    }

    public Data(ASN1Object aSN1Object) throws CMSParsingException {
        this();
        this.decode(aSN1Object);
    }

    protected Data() {
        this.blockSize_ = -1;
    }
}

