/*
 * Decompiled with CFR 0.152.
 */
package iaik.security.ecc.spec;

import iaik.security.ecc.math.field.BinaryField;
import iaik.security.ecc.math.field.BinaryFieldFactory;
import iaik.security.ecc.math.field.Field;
import iaik.security.ecc.math.field.FieldElement;
import iaik.security.ecc.math.field.FieldFactory;
import iaik.security.ecc.math.field.PrimeField;
import iaik.security.ecc.math.field.PrimeFieldFactory;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.math.BigInteger;
import java.security.spec.AlgorithmParameterSpec;

public class ECCParameterSpec
implements AlgorithmParameterSpec {
    protected int t_;
    protected BigInteger s_;
    protected BigInteger r_;
    protected FieldElement p_;
    protected String oid_;
    protected BigInteger k_;
    protected FieldElement gy_;
    protected FieldElement gx_;
    protected BigInteger c_;
    protected FieldElement b_;
    protected FieldElement a_;

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("The curve parameter a: \n");
        stringBuffer.append("-----------------------\n");
        stringBuffer.append(this.a_);
        stringBuffer.append("\n\n");
        stringBuffer.append("The curve parameter b: \n");
        stringBuffer.append("-----------------------\n");
        stringBuffer.append(this.b_);
        stringBuffer.append("\n\n");
        stringBuffer.append("The base point's x coordinate gx: \n");
        stringBuffer.append("----------------------------------\n");
        stringBuffer.append(this.gx_);
        stringBuffer.append("\n\n");
        stringBuffer.append("The base point's y coordinate gy: \n");
        stringBuffer.append("----------------------------------\n");
        stringBuffer.append(this.gx_);
        stringBuffer.append("\n\n");
        stringBuffer.append("The base point's order: \n");
        stringBuffer.append("------------------------\n");
        stringBuffer.append(this.r_);
        stringBuffer.append("\n\n");
        return stringBuffer.toString();
    }

    public BigInteger getS() {
        return this.s_;
    }

    public BigInteger getR() {
        return this.r_;
    }

    public FieldElement getP() {
        return this.p_;
    }

    public String getOID() {
        return this.oid_;
    }

    public BigInteger getK() {
        return this.k_;
    }

    public FieldElement getGy() {
        return this.gy_;
    }

    public FieldElement getGx() {
        return this.gx_;
    }

    public BigInteger getC() {
        return this.c_;
    }

    public FieldElement getB() {
        return this.b_;
    }

    public FieldElement getA() {
        return this.a_;
    }

    public ECCParameterSpec(int[] nArray, BigInteger bigInteger, BigInteger bigInteger2, int[] nArray2, int[] nArray3, int[] nArray4, int[] nArray5, String string) {
        try {
            FieldFactory fieldFactory = BinaryFieldFactory.getInstance(nArray);
            Field field = fieldFactory.getField();
            this.p_ = ((BinaryField)field).newElement(nArray);
            this.k_ = bigInteger;
            this.r_ = bigInteger2;
            this.a_ = ((BinaryField)field).newElement(nArray2);
            this.b_ = ((BinaryField)field).newElement(nArray3);
            this.gx_ = ((BinaryField)field).newElement(nArray4);
            this.gy_ = ((BinaryField)field).newElement(nArray5);
            this.oid_ = string;
        }
        catch (Throwable throwable) {
            throw new RuntimeException("Could not create ECCParameterSpec" + throwable.toString());
        }
    }

    public ECCParameterSpec(BigInteger bigInteger, BigInteger bigInteger2, BigInteger bigInteger3, BigInteger bigInteger4, BigInteger bigInteger5, BigInteger bigInteger6, BigInteger bigInteger7, BigInteger bigInteger8, BigInteger bigInteger9, String string) {
        try {
            FieldFactory fieldFactory = PrimeFieldFactory.getInstance(bigInteger);
            Field field = fieldFactory.getField();
            this.p_ = ((PrimeField)field).newElement(bigInteger);
            this.k_ = bigInteger2;
            this.r_ = bigInteger3;
            this.s_ = bigInteger4;
            this.c_ = bigInteger5;
            this.a_ = ((PrimeField)field).newElement(bigInteger6);
            this.b_ = ((PrimeField)field).newElement(bigInteger7);
            this.gx_ = ((PrimeField)field).newElement(bigInteger8);
            this.gy_ = ((PrimeField)field).newElement(bigInteger9);
            this.oid_ = string;
        }
        catch (Throwable throwable) {
            StringWriter stringWriter = new StringWriter();
            throwable.printStackTrace(new PrintWriter(stringWriter));
            throw new RuntimeException("Could not create ECCParameterSpec" + throwable.toString() + "\n" + stringWriter.getBuffer().toString());
        }
    }
}

