/*
 * Decompiled with CFR 0.152.
 */
package com.sun.deploy.ui;

import com.sun.deploy.config.Config;
import com.sun.deploy.resources.ResourceManager;
import com.sun.deploy.security.CertificateDialog;
import com.sun.deploy.trace.Trace;
import com.sun.deploy.ui.AppInfo;
import com.sun.deploy.ui.FancyButton;
import com.sun.deploy.ui.ImageLoader;
import com.sun.deploy.ui.ImageLoaderCallback;
import com.sun.deploy.ui.MoreInfoDialog;
import com.sun.deploy.ui.UIFactory;
import com.sun.deploy.ui.UITextArea;
import com.sun.deploy.util.DialogListener;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Cursor;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Font;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Image;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.io.File;
import java.io.Serializable;
import java.net.URL;
import java.security.cert.Certificate;
import java.security.cert.X509Certificate;
import java.text.Format;
import java.text.MessageFormat;
import java.util.Iterator;
import java.util.TreeMap;
import javax.accessibility.Accessible;
import javax.swing.AbstractAction;
import javax.swing.AbstractButton;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JPasswordField;
import javax.swing.JProgressBar;
import javax.swing.JScrollPane;
import javax.swing.JSeparator;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.KeyStroke;
import javax.swing.SwingUtilities;

public class DialogTemplate
implements ActionListener,
ImageLoaderCallback {
    private JDialog dialog = null;
    private AppInfo ainfo = null;
    private String topText = null;
    private String appTitle = null;
    private String appPublisher = null;
    private URL appURL = null;
    private Frame dummyFrame = null;
    private boolean useErrorIcon = false;
    private boolean useWarningIcon = false;
    private boolean useInfoIcon = false;
    private boolean useMixcodeIcon = false;
    private JLabel progressStatusLabel = null;
    private JPanel topPanel;
    private JPanel centerPanel;
    private JPanel bottomPanel;
    private JLabel topIcon;
    private JLabel securityIcon;
    private JLabel nameInfo;
    private JLabel publisherInfo;
    private JLabel urlInfo;
    private JButton okBtn;
    private JButton cancelBtn;
    private JCheckBox always;
    private JLabel mixedCodeLabel;
    private UITextArea masthead = null;
    private static final int ICON_SIZE = 48;
    private int userAnswer = -1;
    private final int DIALOG_WIDTH = 510;
    private final int MAX_LARGE_SCROLL_WIDTH = 600;
    private final Color BG = Color.white;
    private final String SECURITY_ALERT_HIGH = "com/sun/deploy/resources/image/security_high.png";
    private final String SECURITY_ALERT_LOW = "com/sun/deploy/resources/image/security_low.png";
    private static int MAIN_TEXT_WIDTH = 426;
    private final String OK_ACTION = "OK";
    private final int MAX_BUTTONS = 2;
    private int start;
    private int end;
    private Certificate[] certs;
    private String[] alertStrs;
    private String[] infoStrs;
    private int securityInfoCount;
    private Color originalColor;
    private Cursor handCursor = new Cursor(12);
    private Cursor originalCursor = null;
    protected JProgressBar progressBar = null;
    private boolean stayAliveOnOk = false;
    private String contentString = null;
    private String cacheUpgradeContentString = null;
    private String contentLabel = null;
    private String alwaysString = null;
    private String mixedCodeString = null;
    private boolean contentScroll = false;
    private boolean includeMasthead = true;
    private boolean includeAppInfo = true;
    private boolean largeScroll = false;
    private Throwable throwable = null;
    private JPanel detailPanel = null;
    private char[] pwd = new char[0];
    private String userName;
    private String domain;
    private JTextField pwdName;
    private JTextField pwdDomain;
    private JPasswordField password;
    private JList scrollList;
    private boolean showDetails = false;
    TreeMap clientAuthCertsMap;
    static int minFontSize = ResourceManager.getMinFontSize();
    private boolean majorWarning = false;

    DialogTemplate(AppInfo appInfo, Component component, String string, String string2) {
        Component component2 = this.deriveParent(component, string);
        this.dialog = component2 instanceof Dialog ? new JDialog((Dialog)component2, true) : new JDialog((Frame)component2, true);
        this.dialog.setTitle(string);
        this.ainfo = appInfo;
        this.topText = string2;
        this.appTitle = appInfo.getTitle();
        this.appPublisher = appInfo.getVendor();
        this.appURL = appInfo.getFrom();
    }

    void setSecurityContent(boolean bl, boolean bl2, String string, String string2, String[] stringArray, String[] stringArray2, int n, boolean bl3, Certificate[] certificateArray, int n2, int n3, boolean bl4) {
        this.certs = certificateArray;
        this.start = n2;
        this.end = n3;
        this.alertStrs = stringArray;
        this.infoStrs = stringArray2;
        this.securityInfoCount = n;
        this.majorWarning = bl4;
        if (stringArray != null && stringArray.length > 0) {
            this.useWarningIcon = true;
        }
        try {
            this.dialog.getContentPane().setLayout(new BorderLayout());
            this.dialog.getContentPane().add((Component)this.createTopPanel(false), "North");
            if (Config.isJavaVersionAtLeast16()) {
                this.dialog.setModalityType(Dialog.ModalityType.TOOLKIT_MODAL);
            }
            if (bl) {
                this.alwaysString = ResourceManager.getString("security.dialog.always");
            }
            this.dialog.getContentPane().add((Component)this.createCenterPanel(bl2, string, string2, -1, true), "Center");
            this.dialog.getContentPane().add((Component)this.createBottomPanel(bl3), "South");
            this.dialog.pack();
            this.dialog.setResizable(false);
        }
        catch (Throwable throwable) {
            Trace.ignored(throwable);
        }
    }

    void setSimpleContent(String string, boolean bl, String string2, String string3, String string4, boolean bl2, boolean bl3) {
        this.contentString = string;
        this.contentScroll = bl;
        this.throwable = this.throwable;
        this.detailPanel = this.detailPanel;
        this.includeMasthead = bl2;
        this.includeAppInfo = bl2;
        this.largeScroll = !bl2;
        this.useWarningIcon = bl3;
        if (string2 != null) {
            String[] stringArray = new String[]{string2};
            if (bl3) {
                this.alertStrs = stringArray;
            } else {
                this.infoStrs = stringArray;
            }
        }
        try {
            this.dialog.getContentPane().setLayout(new BorderLayout());
            this.dialog.getContentPane().add((Component)this.createTopPanel(false), "North");
            this.dialog.getContentPane().add((Component)this.createCenterPanel(false, string3, string4, -1, false), "Center");
            this.dialog.getContentPane().add((Component)this.createBottomPanel(false), "South");
            this.dialog.pack();
            boolean bl4 = bl;
            this.dialog.setResizable(bl4);
        }
        catch (Throwable throwable) {
            Trace.ignored(throwable);
        }
    }

    void setMixedCodeContent(String string, boolean bl, String string2, String string3, String string4, String string5, boolean bl2, boolean bl3) {
        this.contentString = string;
        this.contentScroll = bl;
        this.throwable = this.throwable;
        this.detailPanel = this.detailPanel;
        this.includeMasthead = bl2;
        this.includeAppInfo = bl2;
        this.largeScroll = !bl2;
        this.useMixcodeIcon = true;
        this.alertStrs = new String[1];
        String[] stringArray = new String[]{string3};
        this.alertStrs = stringArray;
        this.infoStrs = new String[3];
        String string6 = ResourceManager.getString("security.dialog.mixcode.info1");
        String string7 = ResourceManager.getString("security.dialog.mixcode.info2");
        String string8 = ResourceManager.getString("security.dialog.mixcode.info3");
        String[] stringArray2 = new String[]{string6, string7, string8};
        this.infoStrs = stringArray2;
        try {
            this.dialog.getContentPane().setLayout(new BorderLayout());
            this.dialog.getContentPane().add((Component)this.createTopPanel(false), "North");
            this.mixedCodeString = string2;
            this.dialog.getContentPane().add((Component)this.createCenterPanel(false, string4, string5, -1, true), "Center");
            this.dialog.getContentPane().add((Component)this.createBottomPanel(false), "South");
            this.dialog.pack();
            this.okBtn.requestFocusInWindow();
            boolean bl4 = bl;
            this.dialog.setResizable(bl4);
        }
        catch (Throwable throwable) {
            Trace.ignored(throwable);
        }
    }

    void setListContent(String string, JList jList, boolean bl, String string2, String string3, TreeMap treeMap) {
        this.useWarningIcon = true;
        this.includeAppInfo = false;
        this.clientAuthCertsMap = treeMap;
        this.contentLabel = string;
        this.contentScroll = true;
        this.scrollList = jList;
        this.showDetails = bl;
        try {
            this.dialog.getContentPane().setLayout(new BorderLayout());
            this.dialog.getContentPane().add((Component)this.createTopPanel(false), "North");
            this.dialog.getContentPane().add((Component)this.createCenterPanel(false, string2, string3, -1, true), "Center");
            this.dialog.getContentPane().add((Component)this.createBottomPanel(false), "South");
            this.dialog.pack();
        }
        catch (Throwable throwable) {
            Trace.ignored(throwable);
        }
    }

    void setApiContent(String string, String string2, String string3, boolean bl, String string4, String string5) {
        this.contentString = string;
        this.contentLabel = string2;
        this.contentScroll = string != null;
        this.alwaysString = string3;
        if (string2 == null && string != null) {
            this.infoStrs = new String[1];
            this.infoStrs[0] = string;
            this.contentString = null;
        }
        this.includeMasthead = true;
        this.includeAppInfo = this.contentString == null;
        this.largeScroll = false;
        try {
            this.dialog.getContentPane().setLayout(new BorderLayout());
            this.dialog.getContentPane().add((Component)this.createTopPanel(false), "North");
            this.dialog.getContentPane().add((Component)this.createCenterPanel(false, string4, string5, -1, false), "Center");
            this.dialog.getContentPane().add((Component)this.createBottomPanel(false), "South");
            this.dialog.pack();
            boolean bl2 = this.contentScroll;
            this.dialog.setResizable(bl2);
        }
        catch (Throwable throwable) {
            Trace.ignored(throwable);
        }
    }

    void setErrorContent(String string, String string2, String string3, Throwable throwable, JPanel jPanel, Certificate[] certificateArray, boolean bl) {
        this.contentString = string;
        this.throwable = throwable;
        this.detailPanel = jPanel;
        this.certs = certificateArray;
        if (bl) {
            this.includeAppInfo = false;
        }
        this.useErrorIcon = true;
        try {
            this.dialog.getContentPane().setLayout(new BorderLayout());
            this.dialog.getContentPane().add((Component)this.createTopPanel(false), "North");
            this.dialog.getContentPane().add((Component)this.createCenterPanel(false, string2, string3, -1, true), "Center");
            this.dialog.getContentPane().add((Component)this.createBottomPanel(false), "South");
            this.dialog.pack();
            this.dialog.setResizable(false);
        }
        catch (Throwable throwable2) {
            Trace.ignored(throwable2);
        }
    }

    void setMultiButtonErrorContent(String string, String string2, String string3, String string4) {
        this.useErrorIcon = true;
        try {
            this.dialog.getContentPane().setLayout(new BorderLayout());
            this.dialog.getContentPane().add((Component)this.createTopPanel(false), "North");
            this.dialog.getContentPane().add((Component)this.createInfoPanel(string), "Center");
            this.dialog.getContentPane().add((Component)this.createThreeButtonsPanel(string2, string3, string4, false), "South");
            this.dialog.pack();
            this.dialog.setResizable(false);
        }
        catch (Throwable throwable) {
            Trace.ignored(throwable);
        }
    }

    void setInfoContent(String string, String string2) {
        this.useInfoIcon = true;
        this.contentString = string;
        try {
            this.dialog.getContentPane().setLayout(new BorderLayout());
            this.dialog.getContentPane().add((Component)this.createTopPanel(false), "North");
            this.dialog.getContentPane().add((Component)this.createCenterPanel(false, string2, null, -1, true), "Center");
            this.dialog.pack();
            this.dialog.setResizable(false);
        }
        catch (Throwable throwable) {
            Trace.ignored(throwable);
        }
    }

    void setPasswordContent(String string, boolean bl, boolean bl2, String string2, String string3, boolean bl3, char[] cArray, String string4) {
        try {
            this.dialog.getContentPane().setLayout(new BorderLayout());
            this.dialog.getContentPane().add((Component)this.createPasswordPanel(string, bl, bl2, string2, string3, bl3, cArray, string4), "Center");
            if (Config.isJavaVersionAtLeast16()) {
                this.dialog.setModalityType(Dialog.ModalityType.TOOLKIT_MODAL);
            }
            this.dialog.pack();
            this.dialog.setResizable(false);
        }
        catch (Throwable throwable) {
            Trace.ignored(throwable);
        }
    }

    void setUpdateCheckContent(String string, String string2, String string3, String string4) {
        try {
            this.dialog.getContentPane().setLayout(new BorderLayout());
            this.dialog.getContentPane().add((Component)this.createTopPanel(false), "North");
            this.dialog.getContentPane().add((Component)this.createInfoPanel(string), "Center");
            this.dialog.getContentPane().add((Component)this.createThreeButtonsPanel(string2, string3, string4, true), "South");
            this.dialog.pack();
            this.dialog.setResizable(false);
        }
        catch (Throwable throwable) {
            Trace.ignored(throwable);
        }
    }

    void setProgressContent(String string, String string2, String string3, boolean bl, int n) {
        try {
            this.cacheUpgradeContentString = string3;
            this.dialog.getContentPane().setLayout(new BorderLayout());
            this.dialog.getContentPane().add((Component)this.createTopPanel(false), "North");
            this.dialog.getContentPane().add((Component)this.createCenterPanel(false, string, string2, n, true), "Center");
            if (this.cacheUpgradeContentString == null) {
                this.dialog.getContentPane().add((Component)this.createBottomPanel(false), "South");
            }
            this.dialog.pack();
            this.dialog.setResizable(false);
        }
        catch (Throwable throwable) {
            Trace.ignored(throwable);
        }
    }

    private JPanel createInfoPanel(String string) {
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new FlowLayout(3, 0, 0));
        jPanel.setBorder(BorderFactory.createEmptyBorder(20, 20, 20, 12));
        UITextArea uITextArea = new UITextArea(ResourceManager.getUIFont().getSize(), 478, false);
        uITextArea.setText(string);
        uITextArea.setSize(uITextArea.getPreferredSize());
        jPanel.add(uITextArea);
        return jPanel;
    }

    private JPanel createThreeButtonsPanel(String string, String string2, String string3, boolean bl) {
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new FlowLayout(4, 6, 0));
        jPanel.setBorder(BorderFactory.createEmptyBorder(12, 12, 12, 12));
        JButton jButton = new JButton(this.getMessage(string));
        jButton.setMnemonic(ResourceManager.getVKCode(string + ".mnemonic"));
        jButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                DialogTemplate.this.setUserAnswer(0);
                DialogTemplate.this.setVisible(false);
            }
        });
        jPanel.add(jButton);
        JButton jButton2 = new JButton(this.getMessage(string2));
        jButton2.setMnemonic(ResourceManager.getVKCode(string2 + ".mnemonic"));
        jButton2.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                DialogTemplate.this.setUserAnswer(1);
                DialogTemplate.this.setVisible(false);
            }
        });
        jPanel.add(jButton2);
        JComponent jComponent = null;
        if (string3 != null) {
            jComponent = new JButton(this.getMessage(string3));
            ((AbstractButton)jComponent).setMnemonic(ResourceManager.getVKCode(string3 + ".mnemonic"));
            ((AbstractButton)jComponent).addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent actionEvent) {
                    DialogTemplate.this.setUserAnswer(3);
                    DialogTemplate.this.setVisible(false);
                }
            });
            jPanel.add(jComponent);
        }
        if (bl) {
            jComponent.setToolTipText(ResourceManager.getMessage("autoupdatecheck.masthead"));
        }
        if (jComponent != null) {
            JButton[] jButtonArray = new JButton[]{jButton, jButton2, jComponent};
            DialogTemplate.resizeButtons(jButtonArray);
        } else {
            JButton[] jButtonArray = new JButton[]{jButton, jButton2};
            DialogTemplate.resizeButtons(jButtonArray);
        }
        return jPanel;
    }

    private JPanel createTopPanel(boolean bl) {
        Accessible accessible;
        this.topPanel = new JPanel();
        this.topPanel.setBackground(this.BG);
        GridBagLayout gridBagLayout = new GridBagLayout();
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        this.topPanel.setLayout(gridBagLayout);
        int n = ResourceManager.getUIFont().getSize() + 4;
        this.masthead = new UITextArea(n, MAIN_TEXT_WIDTH, true);
        this.masthead.setText(this.topText);
        Dimension dimension = this.masthead.getPreferredSize();
        this.masthead.setSize(dimension.width, dimension.height);
        this.masthead.setBorder(BorderFactory.createEmptyBorder(6, 12, 6, 6));
        if (bl) {
            if (this.includeMasthead) {
                gridBagConstraints.fill = 2;
                gridBagConstraints.gridwidth = -1;
                gridBagConstraints.anchor = 17;
                gridBagLayout.setConstraints(this.masthead, gridBagConstraints);
                this.topPanel.add(this.masthead);
                accessible = ResourceManager.getIcon("progress.background.image");
                this.masthead.setBackgroundImage(((ImageIcon)accessible).getImage());
            }
        } else if (this.includeMasthead) {
            gridBagConstraints.fill = 2;
            gridBagConstraints.gridwidth = -1;
            gridBagConstraints.anchor = 17;
            gridBagLayout.setConstraints(this.masthead, gridBagConstraints);
            this.topPanel.add(this.masthead);
            this.topPanel.setBackground(Color.white);
            this.topPanel.setForeground(Color.white);
            this.topPanel.setOpaque(true);
            this.topIcon = new JLabel();
            this.topIcon.setHorizontalAlignment(0);
            this.topIcon.setBorder(BorderFactory.createEmptyBorder(6, 6, 6, 12));
            accessible = ResourceManager.getIcon("java48.image");
            if (this.useErrorIcon) {
                accessible = ResourceManager.getIcon("error48.image");
            }
            if (this.useInfoIcon) {
                accessible = ResourceManager.getIcon("info48.image");
            }
            if (this.useMixcodeIcon) {
                accessible = ResourceManager.getIcon("mixcode.image");
            }
            this.topIcon.setIcon((Icon)((Object)accessible));
            if (this.useWarningIcon) {
                accessible = this.majorWarning ? ResourceManager.getIcon("major-warning48.image") : ResourceManager.getIcon("warning48.image");
                this.topIcon.setIcon((Icon)((Object)accessible));
            } else if (this.ainfo.getIconRef() != null) {
                ImageLoader.getInstance().loadImage(this.ainfo.getIconRef(), this.ainfo.getIconVersion(), this);
            }
            gridBagConstraints.fill = 0;
            gridBagConstraints.gridwidth = 0;
            gridBagConstraints.anchor = 13;
            gridBagLayout.setConstraints(this.topIcon, gridBagConstraints);
            this.topPanel.add(this.topIcon);
        }
        accessible = new JSeparator();
        ((JComponent)((Object)accessible)).setPreferredSize(new Dimension(510, 1));
        gridBagConstraints.gridy = 1;
        gridBagConstraints.gridwidth = 0;
        gridBagLayout.setConstraints((Component)((Object)accessible), gridBagConstraints);
        this.topPanel.add((Component)((Object)accessible));
        return this.topPanel;
    }

    private JPanel createCenterPanel(boolean bl, String string, String string2, int n, boolean bl2) {
        JComponent jComponent;
        boolean bl3;
        Serializable serializable;
        Object object;
        Font font = ResourceManager.getUIFont();
        int n2 = DialogTemplate.getSubpanelFontSize();
        Font font2 = font.deriveFont(font.getStyle(), n2);
        this.centerPanel = new JPanel();
        this.centerPanel.setLayout(new BoxLayout(this.centerPanel, 1));
        this.centerPanel.setBorder(BorderFactory.createEmptyBorder(24, 24, 12, 12));
        GridBagLayout gridBagLayout = new GridBagLayout();
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        JPanel jPanel = new JPanel();
        jPanel.setLayout(gridBagLayout);
        jPanel.setBorder(BorderFactory.createEmptyBorder());
        JLabel jLabel = new JLabel(this.getMessage("dialog.template.name"));
        Font font3 = jLabel.getFont().deriveFont(1);
        Font font4 = jLabel.getFont().deriveFont(0);
        jLabel.setFont(font3);
        JLabel jLabel2 = new JLabel(this.getMessage("dialog.template.publisher"));
        jLabel2.setFont(font3);
        JLabel jLabel3 = new JLabel(this.getMessage("dialog.template.from"));
        jLabel3.setFont(font3);
        this.nameInfo = new JLabel();
        this.publisherInfo = new JLabel();
        this.urlInfo = new JLabel();
        this.nameInfo.setFont(font4);
        this.publisherInfo.setFont(font4);
        this.urlInfo.setFont(font4);
        this.nameInfo.putClientProperty("html.disable", Boolean.TRUE);
        this.publisherInfo.putClientProperty("html.disable", Boolean.TRUE);
        this.urlInfo.putClientProperty("html.disable", Boolean.TRUE);
        gridBagConstraints.fill = 2;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(0, 0, 0, 12);
        gridBagConstraints.weightx = 0.0;
        if (this.appTitle != null) {
            gridBagLayout.setConstraints(jLabel, gridBagConstraints);
            jPanel.add(jLabel);
            gridBagConstraints.insets = new Insets(0, 0, 0, 12);
            gridBagConstraints.gridx = -1;
            gridBagConstraints.gridwidth = 0;
            gridBagConstraints.weightx = 1.0;
            gridBagLayout.setConstraints(this.nameInfo, gridBagConstraints);
            jPanel.add(this.nameInfo);
        }
        if (bl2 && this.appPublisher != null) {
            gridBagConstraints.fill = 2;
            gridBagConstraints.insets = new Insets(12, 0, 0, 12);
            gridBagConstraints.gridwidth = 1;
            gridBagConstraints.weightx = 0.0;
            gridBagConstraints.anchor = 17;
            gridBagLayout.setConstraints(jLabel2, gridBagConstraints);
            jPanel.add(jLabel2);
            gridBagConstraints.insets = new Insets(12, 0, 0, 12);
            gridBagConstraints.gridwidth = 0;
            gridBagConstraints.weightx = 1.0;
            gridBagLayout.setConstraints(this.publisherInfo, gridBagConstraints);
            jPanel.add(this.publisherInfo);
        }
        if (this.appTitle != null && this.appURL != null) {
            gridBagConstraints.fill = 2;
            gridBagConstraints.weightx = 0.0;
            gridBagConstraints.gridwidth = 1;
            gridBagConstraints.anchor = 17;
            gridBagConstraints.insets = new Insets(12, 0, 0, 12);
            gridBagLayout.setConstraints(jLabel3, gridBagConstraints);
            jPanel.add(jLabel3);
            gridBagConstraints.insets = new Insets(12, 0, 0, 12);
            gridBagConstraints.gridwidth = 0;
            gridBagConstraints.weightx = 1.0;
            gridBagLayout.setConstraints(this.urlInfo, gridBagConstraints);
            jPanel.add(this.urlInfo);
        }
        this.setInfo(this.appTitle, this.appPublisher, this.appURL);
        JPanel jPanel2 = new JPanel();
        jPanel2.setLayout(new FlowLayout(3, 0, 0));
        JPanel jPanel3 = new JPanel();
        jPanel3.setLayout(new BorderLayout());
        JPanel jPanel4 = new JPanel();
        jPanel4.setLayout(new BorderLayout());
        if (this.alwaysString != null) {
            object = "security.dialog.always";
            this.always = new JCheckBox(this.alwaysString);
            this.always.setMnemonic(ResourceManager.getVKCode((String)object + ".mnemonic"));
            this.always.setSelected(bl);
            this.always.setFont(font4);
            int n3 = this.always.getBorder().getBorderInsets((Component)this.always).left;
            jPanel.setBorder(BorderFactory.createEmptyBorder(0, n3, 0, 0));
            jPanel2.add(this.always);
            jPanel2.setBorder(BorderFactory.createEmptyBorder(0, 0, 12, 0));
        }
        if (this.mixedCodeString != null) {
            this.mixedCodeLabel = new JLabel(this.mixedCodeString);
            this.mixedCodeLabel.setFont(font4);
            object = new JPanel();
            ((Container)object).setLayout(new BorderLayout());
            FancyButton fancyButton = null;
            fancyButton = new FancyButton("dialog.template.more.info");
            serializable = font.deriveFont((float)n2);
            fancyButton.setFont((Font)serializable);
            fancyButton.addMouseListener(new MouseListener(){

                public void mouseClicked(MouseEvent mouseEvent) {
                    if (mouseEvent.getComponent() instanceof FancyButton) {
                        DialogTemplate.this.showMixedcodeMoreInfo();
                    }
                }

                public void mousePressed(MouseEvent mouseEvent) {
                }

                public void mouseReleased(MouseEvent mouseEvent) {
                }

                public void mouseEntered(MouseEvent mouseEvent) {
                }

                public void mouseExited(MouseEvent mouseEvent) {
                }
            });
            fancyButton.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent actionEvent) {
                    DialogTemplate.this.showMixedcodeMoreInfo();
                }
            });
            ((Container)object).add((Component)fancyButton, "West");
            jPanel3.add((Component)this.mixedCodeLabel, "North");
            jPanel3.add((Component)object, "South");
        }
        boolean bl4 = bl3 = n >= 0;
        if (bl3) {
            this.progressBar = new JProgressBar(0, 100);
            this.progressBar.setVisible(n <= 100);
        }
        if (this.contentString != null) {
            JTextArea jTextArea;
            if (this.contentLabel != null) {
                JPanel jPanel5 = new JPanel(new BorderLayout());
                jPanel5.add((Component)new JLabel(this.contentLabel), "West");
                jPanel4.add((Component)jPanel5, "North");
            }
            if (this.contentScroll) {
                final boolean bl5 = this.largeScroll;
                jTextArea = this.largeScroll ? new JTextArea(this.contentString, 20, 80) : new JTextArea(this.contentString, 4, 40);
                jTextArea.setEditable(false);
                jComponent = new JScrollPane(jTextArea, 20, 30){

                    public Dimension getPreferredSize() {
                        Dimension dimension = super.getPreferredSize();
                        if (bl5) {
                            dimension.width = Math.min(dimension.width, 600);
                        }
                        return dimension;
                    }
                };
                jPanel4.add((Component)jComponent, "Center");
            } else {
                jTextArea = new UITextArea(this.contentString);
                jTextArea.setSize(((UITextArea)jTextArea).getPreferredSize());
                jPanel4.add((Component)jTextArea, "Center");
            }
            jPanel4.setBorder(BorderFactory.createEmptyBorder(0, 0, 12, 0));
        }
        if (this.scrollList != null) {
            if (this.contentLabel != null) {
                JPanel jPanel6 = new JPanel(new BorderLayout());
                jPanel6.add((Component)new JLabel(this.contentLabel), "West");
                jPanel4.add((Component)jPanel6, "North");
            }
            if (this.contentScroll) {
                JScrollPane jScrollPane = new JScrollPane(this.scrollList, 20, 30);
                jPanel4.add((Component)jScrollPane, "Center");
            }
            if (this.showDetails) {
                FancyButton fancyButton = new FancyButton("security.more.info.details");
                fancyButton.setFont(font2);
                fancyButton.addMouseListener(new MouseListener(){

                    public void mouseClicked(MouseEvent mouseEvent) {
                        if (mouseEvent.getComponent() instanceof FancyButton) {
                            DialogTemplate.this.showCertificateDetails();
                        }
                    }

                    public void mousePressed(MouseEvent mouseEvent) {
                    }

                    public void mouseReleased(MouseEvent mouseEvent) {
                    }

                    public void mouseEntered(MouseEvent mouseEvent) {
                    }

                    public void mouseExited(MouseEvent mouseEvent) {
                    }
                });
                serializable = new JPanel();
                ((JComponent)serializable).setBorder(BorderFactory.createEmptyBorder(12, 0, 12, 0));
                ((Container)serializable).setLayout(new FlowLayout(4, 0, 0));
                ((Container)serializable).add(fancyButton);
                ((Container)serializable).add(Box.createGlue());
                jPanel4.add((Component)serializable, "South");
            }
        }
        JPanel jPanel7 = new JPanel();
        jPanel7.setLayout(new FlowLayout(4, 0, 0));
        this.okBtn = new JButton(string == null ? "" : this.getMessage(string));
        this.okBtn.addActionListener(this);
        this.okBtn.setActionCommand("OK");
        jPanel7.add(this.okBtn);
        this.okBtn.setVisible(string != null);
        this.cancelBtn = new JButton(string2 == null ? "" : this.getMessage(string2));
        this.cancelBtn.addActionListener(this);
        jPanel7.add(Box.createHorizontalStrut(6));
        jPanel7.add(this.cancelBtn);
        this.cancelBtn.setVisible(string2 != null);
        if (this.okBtn.isVisible()) {
            this.dialog.getRootPane().setDefaultButton(this.okBtn);
        } else if (this.cancelBtn.isVisible()) {
            this.dialog.getRootPane().setDefaultButton(this.cancelBtn);
        }
        serializable = new JButton[]{this.okBtn, this.cancelBtn};
        DialogTemplate.resizeButtons((JButton[])serializable);
        if (this.cacheUpgradeContentString != null) {
            jComponent = new UITextArea(this.cacheUpgradeContentString);
            jComponent.setBorder(null);
            jPanel4.add((Component)jComponent, "North");
            this.centerPanel.add(jPanel4);
            this.centerPanel.add(Box.createVerticalStrut(12));
        } else {
            if (this.includeAppInfo) {
                this.centerPanel.add(jPanel);
                this.centerPanel.add(Box.createVerticalStrut(12));
            }
            if (this.alwaysString != null) {
                this.centerPanel.add(jPanel2);
            }
            if (this.mixedCodeString != null) {
                this.centerPanel.add(jPanel3);
            }
            if (this.contentString != null || this.scrollList != null) {
                this.centerPanel.add(jPanel4);
            }
        }
        jComponent = new JPanel(new BorderLayout());
        this.centerPanel.add(jComponent);
        JPanel jPanel8 = new JPanel(new BorderLayout());
        if (bl3) {
            this.progressStatusLabel = new JLabel(" ");
            this.progressStatusLabel.setFont(font2);
            jComponent.add((Component)this.progressStatusLabel, "West");
            this.progressBar.setBorder(BorderFactory.createEmptyBorder(2, 0, 2, 0));
            jPanel8.add((Component)this.progressBar, "Center");
        }
        jPanel8.add((Component)jPanel7, "East");
        this.centerPanel.add(jPanel8);
        if (Config.isJavaVersionAtLeast13()) {
            this.dialog.getRootPane().getInputMap(2).put(KeyStroke.getKeyStroke(27, 0), "cancel");
            this.dialog.getRootPane().getActionMap().put("cancel", new AbstractAction(){

                public void actionPerformed(ActionEvent actionEvent) {
                    DialogTemplate.this.cancelAction();
                }
            });
        }
        return this.centerPanel;
    }

    private JPanel createBottomPanel(boolean bl) {
        GridBagLayout gridBagLayout = new GridBagLayout();
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 2;
        this.bottomPanel = new JPanel();
        this.bottomPanel.setLayout(gridBagLayout);
        JSeparator jSeparator = new JSeparator();
        jSeparator.setPreferredSize(new Dimension(510, 1));
        gridBagConstraints.fill = 2;
        gridBagConstraints.gridwidth = 0;
        gridBagLayout.setConstraints(jSeparator, gridBagConstraints);
        this.bottomPanel.add(jSeparator);
        if (this.alertStrs != null || this.infoStrs != null) {
            this.securityIcon = new JLabel();
            String string = "com/sun/deploy/resources/image/security_high.png";
            if (this.alertStrs == null || this.alertStrs.length == 0) {
                string = "com/sun/deploy/resources/image/security_low.png";
                if (this.always != null) {
                    this.always.setSelected(true);
                }
            } else if (this.mixedCodeString == null) {
                this.dialog.getRootPane().setDefaultButton(this.cancelBtn);
            }
            this.securityIcon.setIcon(new ImageIcon(ClassLoader.getSystemResource(string)));
            gridBagConstraints.insets = new Insets(12, 12, 12, 20);
            gridBagConstraints.gridy = 1;
            gridBagConstraints.gridwidth = 1;
            gridBagLayout.setConstraints(this.securityIcon, gridBagConstraints);
            this.bottomPanel.add(this.securityIcon);
            Font font = ResourceManager.getUIFont();
            int n = DialogTemplate.getSubpanelFontSize();
            int n2 = 0;
            FancyButton fancyButton = null;
            if (bl) {
                fancyButton = new FancyButton("dialog.template.more.info");
                Font font2 = font.deriveFont((float)n);
                fancyButton.setFont(font2);
                fancyButton.addMouseListener(new MouseListener(){

                    public void mouseClicked(MouseEvent mouseEvent) {
                        if (mouseEvent.getComponent() instanceof FancyButton) {
                            DialogTemplate.this.showMoreInfo();
                        }
                    }

                    public void mousePressed(MouseEvent mouseEvent) {
                    }

                    public void mouseReleased(MouseEvent mouseEvent) {
                    }

                    public void mouseEntered(MouseEvent mouseEvent) {
                    }

                    public void mouseExited(MouseEvent mouseEvent) {
                    }
                });
                fancyButton.addActionListener(new ActionListener(){

                    public void actionPerformed(ActionEvent actionEvent) {
                        DialogTemplate.this.showMoreInfo();
                    }
                });
                n2 = fancyButton.getPreferredSize().width + fancyButton.getInsets().left + fancyButton.getInsets().right;
            }
            int n3 = 486 - this.securityIcon.getPreferredSize().width - 20 - 6 - n2 - 8;
            UITextArea uITextArea = new UITextArea(n, n3, false);
            Font font3 = uITextArea.getFont().deriveFont(0);
            uITextArea.setFont(font3);
            if ((this.alertStrs == null || this.alertStrs.length == 0) && this.infoStrs != null && this.infoStrs.length != 0) {
                uITextArea.setText(this.infoStrs[0] != null ? this.infoStrs[0] : " ");
                uITextArea.setSize(uITextArea.getPreferredSize());
            } else if (this.alertStrs != null && this.alertStrs.length != 0) {
                uITextArea.setText(this.alertStrs[0] != null ? this.alertStrs[0] : " ");
                uITextArea.setSize(uITextArea.getPreferredSize());
            }
            gridBagConstraints.gridwidth = -1;
            gridBagConstraints.insets = new Insets(12, 0, 12, 6);
            gridBagConstraints.weightx = 0.0;
            gridBagLayout.setConstraints(uITextArea, gridBagConstraints);
            this.bottomPanel.add(uITextArea);
            gridBagConstraints.insets = new Insets(12, 0, 12, 12);
            gridBagConstraints.gridwidth = 0;
            if (fancyButton != null) {
                gridBagConstraints.gridx = 22;
                gridBagLayout.setConstraints(fancyButton, gridBagConstraints);
                this.bottomPanel.add(fancyButton);
            }
        } else {
            this.bottomPanel.setBorder(BorderFactory.createEmptyBorder(0, 0, 2, 0));
        }
        return this.bottomPanel;
    }

    private JPanel createPasswordPanel(String string, boolean bl, boolean bl2, String string2, String string3, boolean bl3, char[] cArray, String string4) {
        Serializable serializable;
        Object object;
        Object object2;
        String string5;
        JLabel jLabel = new JLabel();
        JLabel jLabel2 = new JLabel();
        Font font = jLabel.getFont().deriveFont(0);
        Font font2 = jLabel.getFont().deriveFont(1);
        JLabel jLabel3 = new JLabel();
        jLabel3.setIcon(ResourceManager.getIcon("pwd-masthead.png"));
        if (bl) {
            string5 = "password.dialog.username";
            jLabel.setText(this.getMessage(string5));
            jLabel.setDisplayedMnemonic(ResourceManager.getAcceleratorKey(string5));
            this.pwdName = new JTextField();
            this.pwdName.setText(string2);
            jLabel.setLabelFor(this.pwdName);
            jLabel.setFont(font2);
        }
        string5 = "password.dialog.password";
        JLabel jLabel4 = new JLabel(this.getMessage(string5));
        this.password = new JPasswordField();
        this.password.setText(String.valueOf(cArray));
        jLabel4.setLabelFor(this.password);
        jLabel4.setDisplayedMnemonic(ResourceManager.getAcceleratorKey(string5));
        jLabel4.setFont(font2);
        if (bl2) {
            object2 = "password.dialog.domain";
            jLabel2.setText(this.getMessage((String)object2));
            this.pwdDomain = new JTextField();
            this.pwdDomain.setText(string3);
            jLabel2.setLabelFor(this.pwdDomain);
            jLabel2.setDisplayedMnemonic(ResourceManager.getAcceleratorKey((String)object2));
            jLabel2.setFont(font2);
        }
        object2 = new GridBagLayout();
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        JPanel jPanel = new JPanel();
        jPanel.setLayout((LayoutManager)object2);
        gridBagConstraints.fill = 1;
        gridBagConstraints.gridwidth = 0;
        ((GridBagLayout)object2).setConstraints(jLabel3, gridBagConstraints);
        jPanel.add(jLabel3);
        JSeparator jSeparator = new JSeparator();
        ((GridBagLayout)object2).setConstraints(jSeparator, gridBagConstraints);
        jPanel.add(jSeparator);
        UITextArea uITextArea = new UITextArea(jLabel.getFont().getSize(), jLabel3.getPreferredSize().width - 24, false);
        uITextArea.setFont(font);
        uITextArea.setText(string);
        Dimension dimension = uITextArea.getPreferredSize();
        uITextArea.setSize(dimension.width, dimension.height);
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.insets = new Insets(12, 12, 0, 12);
        ((GridBagLayout)object2).setConstraints(uITextArea, gridBagConstraints);
        jPanel.add(uITextArea);
        Insets insets = new Insets(12, 12, 0, 6);
        Insets insets2 = new Insets(12, 0, 0, 12);
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.insets = insets;
        if (bl) {
            ((GridBagLayout)object2).setConstraints(jLabel, gridBagConstraints);
            jPanel.add(jLabel);
            gridBagConstraints.gridwidth = 0;
            gridBagConstraints.insets = insets2;
            ((GridBagLayout)object2).setConstraints(this.pwdName, gridBagConstraints);
            jPanel.add(this.pwdName);
        }
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.insets = insets;
        ((GridBagLayout)object2).setConstraints(jLabel4, gridBagConstraints);
        jPanel.add(jLabel4);
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.insets = insets2;
        ((GridBagLayout)object2).setConstraints(this.password, gridBagConstraints);
        jPanel.add(this.password);
        if (bl2) {
            gridBagConstraints.gridwidth = 1;
            gridBagConstraints.insets = insets;
            ((GridBagLayout)object2).setConstraints(jLabel2, gridBagConstraints);
            jPanel.add(jLabel2);
            gridBagConstraints.gridwidth = 0;
            gridBagConstraints.insets = insets2;
            ((GridBagLayout)object2).setConstraints(this.pwdDomain, gridBagConstraints);
            jPanel.add(this.pwdDomain);
        }
        if (Config.getBooleanProperty("deployment.security.password.cache") && bl3) {
            gridBagConstraints.gridwidth = 0;
            gridBagConstraints.insets = new Insets(12, 8, 0, 12);
            object = "password.dialog.save";
            this.always = new JCheckBox(this.getMessage((String)object));
            if (cArray.length > 0) {
                this.always.setSelected(true);
            } else {
                this.always.setSelected(false);
            }
            ((GridBagLayout)object2).setConstraints(this.always, gridBagConstraints);
            jPanel.add(this.always);
        }
        object = new JPanel();
        ((Container)object).setLayout(new BoxLayout((Container)object, 2));
        this.okBtn = new JButton(this.getMessage("common.ok_btn"));
        this.okBtn.setActionCommand("OK");
        this.okBtn.addActionListener(this);
        this.dialog.getRootPane().setDefaultButton(this.okBtn);
        this.cancelBtn = new JButton(this.getMessage("common.cancel_btn"));
        this.cancelBtn.addActionListener(this);
        this.dialog.getRootPane().getInputMap(2).put(KeyStroke.getKeyStroke(27, 0), "cancel");
        this.dialog.getRootPane().getActionMap().put("cancel", new AbstractAction(){

            public void actionPerformed(ActionEvent actionEvent) {
                DialogTemplate.this.cancelAction();
            }
        });
        JButton[] jButtonArray = new JButton[]{this.okBtn, this.cancelBtn};
        DialogTemplate.resizeButtons(jButtonArray);
        ((Container)object).add(Box.createHorizontalGlue());
        ((Container)object).add(this.okBtn);
        ((Container)object).add(Box.createHorizontalStrut(6));
        ((Container)object).add(this.cancelBtn);
        ((Container)object).add(Box.createHorizontalStrut(12));
        JPanel jPanel2 = null;
        if (string4 != null) {
            jPanel2 = new JPanel();
            jPanel2.setLayout(new FlowLayout(3, 0, 0));
            jPanel2.add(Box.createHorizontalStrut(12));
            serializable = new MessageFormat(this.getMessage("password.dialog.scheme"));
            Object[] objectArray = new Object[]{string4};
            JLabel jLabel5 = new JLabel(((Format)serializable).format(objectArray));
            jLabel5.setFont(font);
            jPanel2.add(jLabel5);
        }
        serializable = new JPanel();
        ((Container)serializable).setLayout(new BoxLayout((Container)serializable, 3));
        ((Container)serializable).add(jPanel);
        ((Container)serializable).add(Box.createVerticalStrut(24));
        ((Container)serializable).add((Component)object);
        ((Container)serializable).add(Box.createVerticalStrut(12));
        if (jPanel2 != null) {
            ((Container)serializable).add(new JSeparator());
            ((Container)serializable).add(Box.createVerticalStrut(12));
            ((Container)serializable).add(jPanel2);
            ((Container)serializable).add(Box.createVerticalStrut(12));
        }
        return serializable;
    }

    void showMoreInfo() {
        MoreInfoDialog moreInfoDialog = this.throwable == null && this.detailPanel == null ? new MoreInfoDialog(this.dialog, this.alertStrs, this.infoStrs, this.securityInfoCount, this.certs, this.start, this.end) : new MoreInfoDialog(this.dialog, this.detailPanel, this.throwable, this.certs);
        moreInfoDialog.setVisible(true);
    }

    void showMixedcodeMoreInfo() {
        MoreInfoDialog moreInfoDialog = new MoreInfoDialog(this.dialog, null, this.infoStrs, 0, null, 0, 0);
        moreInfoDialog.setVisible(true);
    }

    void showCertificateDetails() {
        Certificate[] certificateArray = null;
        Iterator iterator = this.clientAuthCertsMap.values().iterator();
        for (int i = this.scrollList.getSelectedIndex(); i >= 0 && iterator.hasNext(); --i) {
            certificateArray = (X509Certificate[])iterator.next();
        }
        if (certificateArray != null) {
            CertificateDialog.showCertificates(this.dialog, certificateArray, 0, certificateArray.length);
        }
    }

    public void setVisible(boolean bl) {
        if (bl) {
            final DialogListener dialogListener = UIFactory.getDialogListener();
            final JDialog jDialog = this.dialog;
            final Frame frame = this.dummyFrame;
            Runnable runnable = new Runnable(){

                public void run() {
                    if (dialogListener != null) {
                        dialogListener.beforeShow();
                    }
                    jDialog.pack();
                    if (frame != null) {
                        frame.setVisible(true);
                    }
                    jDialog.setVisible(true);
                }
            };
            if (SwingUtilities.isEventDispatchThread()) {
                runnable.run();
            } else {
                try {
                    SwingUtilities.invokeAndWait(runnable);
                }
                catch (Exception exception) {
                    Trace.ignored(exception);
                }
            }
        } else {
            this.dialog.setVisible(false);
            this.dialog.dispose();
            if (this.dummyFrame != null) {
                this.dummyFrame.setVisible(false);
                this.dummyFrame.dispose();
            }
        }
    }

    public void setMasthead(String string, boolean bl) {
        if (this.masthead != null) {
            this.topText = string;
            this.masthead.setText(string);
            if (bl) {
                this.masthead.setBorder(BorderFactory.createEmptyBorder(16, 12, 16, 6));
            } else {
                this.masthead.setBorder(BorderFactory.createEmptyBorder(6, 12, 6, 6));
            }
        }
    }

    public void setIcon(Image image) {
        this.topIcon.setIcon(new ImageIcon(image));
    }

    public static void resizeButtons(JButton[] jButtonArray) {
        int n;
        int n2 = jButtonArray.length;
        int n3 = 50;
        for (n = 0; n < n2; ++n) {
            if (jButtonArray[n].getPreferredSize().width <= n3) continue;
            n3 = jButtonArray[n].getPreferredSize().width;
        }
        for (n = 0; n < n2; ++n) {
            Dimension dimension = jButtonArray[n].getPreferredSize();
            dimension.width = n3;
            jButtonArray[n].setPreferredSize(dimension);
        }
    }

    private String getMessage(String string) {
        return ResourceManager.getMessage(string);
    }

    public void actionPerformed(ActionEvent actionEvent) {
        String string = actionEvent.getActionCommand();
        if (string.equals("OK")) {
            this.userAnswer = 0;
            if (this.always != null && this.always.isSelected()) {
                this.userAnswer = 2;
            }
            if (this.stayAliveOnOk) {
                return;
            }
            if (this.password != null) {
                this.pwd = this.password.getPassword();
            }
            if (this.pwdName != null) {
                this.userName = this.pwdName.getText();
            }
            if (this.pwdDomain != null) {
                this.domain = this.pwdDomain.getText();
            }
            if (this.scrollList != null) {
                this.userAnswer = this.scrollList.getSelectedIndex();
            }
        } else {
            if (this.throwable != null || this.detailPanel != null) {
                this.showMoreInfo();
                return;
            }
            this.userAnswer = 1;
            if (this.scrollList != null) {
                this.userAnswer = -1;
            }
        }
        this.setVisible(false);
    }

    public void cancelAction() {
        this.userAnswer = 1;
        this.setVisible(false);
    }

    public int getUserAnswer() {
        return this.userAnswer;
    }

    void setUserAnswer(int n) {
        this.userAnswer = n;
    }

    char[] getPassword() {
        return this.pwd;
    }

    String getUserName() {
        return this.userName;
    }

    String getDomain() {
        return this.domain;
    }

    public boolean isPasswordSaved() {
        return this.always != null && this.always.isSelected();
    }

    public void progress(int n) {
        if (this.progressBar != null) {
            if (n <= 100) {
                boolean bl = this.progressBar.isVisible();
                this.progressBar.setValue(n);
                this.progressBar.setVisible(true);
                if (!bl) {
                    this.dialog.pack();
                }
            } else {
                this.progressBar.setVisible(false);
            }
        }
    }

    void setMastheadBackground(Image image) {
        if (this.masthead != null) {
            this.masthead.setBackgroundImage(image);
        }
    }

    public void disposeDialog() {
        this.dialog.dispose();
    }

    public Component deriveParent(Component component, String string) {
        if (component == null && Config.getOSName().equals("Windows")) {
            this.dummyFrame = new Frame(string);
            this.dummyFrame.setLocation(-4096, -4096);
            return this.dummyFrame;
        }
        for (Component component2 = component; component2 != null; component2 = component2.getParent()) {
            if (!(component2 instanceof Dialog) && !(component2 instanceof Frame)) continue;
            return component2;
        }
        return null;
    }

    public JDialog getDialog() {
        return this.dialog;
    }

    public void setInfo(String string, String string2, URL uRL) {
        if (this.nameInfo != null) {
            this.nameInfo.setText(string);
        }
        if (this.publisherInfo != null) {
            this.appPublisher = string2;
            this.publisherInfo.setText(string2);
        }
        if (this.urlInfo != null) {
            this.appURL = uRL;
            String string3 = " ";
            String string4 = "";
            if (uRL != null) {
                string3 = uRL.getProtocol() + "://" + uRL.getHost();
                int n = uRL.getPort();
                if (n != -1) {
                    string3 = string3 + ":" + Integer.toString(n);
                }
                string4 = uRL.toString();
            }
            this.urlInfo.setText(string3);
            this.urlInfo.setToolTipText(string4);
        }
    }

    void showOk(boolean bl) {
        JButton[] jButtonArray = new JButton[]{this.okBtn, this.cancelBtn};
        DialogTemplate.resizeButtons(jButtonArray);
        this.okBtn.setVisible(bl);
    }

    void stayAlive() {
        this.stayAliveOnOk = true;
    }

    public void setProgressStatusText(String string) {
        if (this.progressStatusLabel != null) {
            if (string == null || string.length() == 0) {
                string = " ";
            }
            this.progressStatusLabel.setText(string);
        }
    }

    public void imageAvailable(URL uRL, String string, Image image, File file) {
        final int n = image.getWidth(null);
        final int n2 = image.getHeight(null);
        final Image image2 = image;
        final JLabel jLabel = this.topIcon;
        new Thread(new Runnable(){

            public void run() {
                Image image = image2;
                if (48 != n || 48 != n2) {
                    image = image2.getScaledInstance(48, 48, 1);
                }
                jLabel.setIcon(new ImageIcon(image));
            }
        }).start();
    }

    public void finalImageAvailable(URL uRL, String string, Image image, File file) {
        this.imageAvailable(uRL, string, image, file);
    }

    public static int getSubpanelFontSize() {
        Font font = ResourceManager.getUIFont();
        int n = font.getSize() - 2;
        if (Config.getOSName().equalsIgnoreCase("windows")) {
            n = font.getSize() - 1;
        }
        if (n < minFontSize) {
            n = minFontSize;
        }
        return n;
    }
}

