/*
 * Decompiled with CFR 0.152.
 */
package iaik.iso.iso9796;

import iaik.utils.Util;
import java.security.MessageDigest;
import java.security.SecureRandom;
import java.security.spec.AlgorithmParameterSpec;

public class ISO9796P2ParameterSpec
implements AlgorithmParameterSpec {
    private boolean b = true;
    private boolean a = false;
    private int d;
    private int e = -1;
    private MessageDigest f;
    SecureRandom c;

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("Hash engine: " + (this.f == null ? "not set" : this.f.getAlgorithm()) + "\n");
        stringBuffer.append("Hash output length: " + this.d + "\n");
        if (this.e > -1) {
            stringBuffer.append("Hash id: " + Util.toString(this.e) + "\n");
        }
        if (this.a) {
            stringBuffer.append("Explicit trailer\n");
        } else {
            stringBuffer.append("Implicit trailer\n");
        }
        if (this.c != null) {
            stringBuffer.append("Random source: set\n");
        }
        return stringBuffer.toString();
    }

    public void setUseExplicitTrailer(boolean bl) {
        this.a = bl;
    }

    public void setUseAlternativeSignatureFunction(boolean bl) {
        this.b = bl;
    }

    public void setSecureRandom(SecureRandom secureRandom) {
        this.c = secureRandom;
    }

    public void setHashID(int n2) {
        if (n2 < 0 || n2 > 255) {
            throw new IllegalArgumentException("Invalid hash id (" + n2 + "). Has to be in the range from 0 to 255");
        }
        this.e = n2;
    }

    public void setHashEngine(MessageDigest messageDigest, int n2) {
        if (messageDigest == null) {
            throw new NullPointerException("MessageDigest engine must not be null!");
        }
        if (n2 < 0) {
            throw new IllegalArgumentException("Hash length must not be negative!");
        }
        this.f = messageDigest;
        this.d = n2;
    }

    public boolean getUseExplicitTrailer() {
        return this.a;
    }

    public boolean getUseAlternativeSignatureFunction() {
        return this.b;
    }

    public SecureRandom getSecureRandom() {
        return this.c;
    }

    public int getHashLen() {
        return this.d;
    }

    public int getHashID() {
        return this.e;
    }

    public MessageDigest getHashEngine() {
        return this.f;
    }
}

