/*
 * Decompiled with CFR 0.152.
 */
package iaik.x509.ocsp;

import iaik.asn1.ASN1Object;
import iaik.asn1.ASN1Type;
import iaik.asn1.CON_SPEC;
import iaik.asn1.CodingException;
import iaik.asn1.ObjectID;
import iaik.asn1.SEQUENCE;
import iaik.utils.Util;
import iaik.x509.V3Extension;
import iaik.x509.X509ExtensionException;
import iaik.x509.X509ExtensionInitException;
import iaik.x509.ocsp.OCSPExtensions;
import iaik.x509.ocsp.ReqCert;
import iaik.x509.ocsp.extensions.ServiceLocator;
import java.util.Enumeration;

public class Request
implements ASN1Type {
    OCSPExtensions b;
    ReqCert a;

    public String toString(boolean bl) {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("reqCert: {\n");
        Util.printIndented(this.a.toString(), true, "  ", stringBuffer);
        stringBuffer.append("\n}");
        if (this.b != null) {
            if (bl) {
                stringBuffer.append("\n" + this.b);
                stringBuffer.setLength(stringBuffer.length() - 1);
            } else {
                stringBuffer.append("\nExtensions: " + this.b.countExtensions());
            }
        }
        return stringBuffer.toString();
    }

    public String toString() {
        return this.toString(false);
    }

    public ASN1Object toASN1Object() throws CodingException {
        SEQUENCE sEQUENCE = new SEQUENCE();
        sEQUENCE.addComponent(this.a.toASN1Object());
        if (this.b != null) {
            try {
                sEQUENCE.addComponent(new CON_SPEC(0, this.b.toASN1Object(), false));
            }
            catch (X509ExtensionException x509ExtensionException) {
                throw new CodingException(x509ExtensionException.getMessage());
            }
        }
        return sEQUENCE;
    }

    public void setServiceLocator(ServiceLocator serviceLocator) throws X509ExtensionException {
        this.addExtension(serviceLocator);
    }

    public boolean removeExtension(ObjectID objectID) {
        if (this.b == null) {
            return false;
        }
        return this.b.removeExtension(objectID);
    }

    public void removeAllExtensions() {
        if (this.b != null) {
            this.b.removeAllExtensions();
        }
        this.b = null;
    }

    public Enumeration listExtensions() {
        if (this.b == null) {
            return null;
        }
        return this.b.listExtensions();
    }

    public boolean hasUnsupportedCriticalExtension() {
        if (this.b == null) {
            return false;
        }
        return this.b.hasUnsupportedCriticalExtension();
    }

    public boolean hasExtensions() {
        if (this.b == null) {
            return false;
        }
        return this.b.hasExtensions();
    }

    public ServiceLocator getServiceLocator() throws X509ExtensionInitException {
        return (ServiceLocator)this.getExtension(ServiceLocator.oid);
    }

    public ReqCert getReqCert() {
        return this.a;
    }

    public V3Extension getExtension(ObjectID objectID) throws X509ExtensionInitException {
        if (this.b == null) {
            return null;
        }
        return this.b.getExtension(objectID);
    }

    public void decode(ASN1Object aSN1Object) throws CodingException {
        this.a = new ReqCert(aSN1Object.getComponentAt(0));
        if (aSN1Object.countComponents() == 2) {
            try {
                this.b = new OCSPExtensions((ASN1Object)aSN1Object.getComponentAt(1).getValue());
                return;
            }
            catch (X509ExtensionException x509ExtensionException) {
                throw new CodingException(x509ExtensionException.getMessage());
            }
        }
    }

    public int countExtensions() {
        if (this.b == null) {
            return 0;
        }
        return this.b.countExtensions();
    }

    public void addExtension(V3Extension v3Extension) throws X509ExtensionException {
        if (this.b == null) {
            this.b = new OCSPExtensions();
        }
        this.b.addExtension(v3Extension);
    }

    public Request(ReqCert reqCert) {
        if (reqCert == null) {
            throw new NullPointerException("Cannot create OCSP request from null ReqCert!");
        }
        this.a = reqCert;
    }

    public Request(ASN1Object aSN1Object) throws X509ExtensionException, CodingException {
        this.decode(aSN1Object);
    }

    public Request() {
    }
}

