/*
 * Decompiled with CFR 0.152.
 */
package iaik.tsp;

import iaik.asn1.ASN1;
import iaik.asn1.ASN1Object;
import iaik.asn1.CodingException;
import iaik.asn1.DerCoder;
import iaik.asn1.ObjectID;
import iaik.asn1.structures.AlgorithmID;
import iaik.asn1.structures.Attribute;
import iaik.cms.CMSException;
import iaik.cms.CMSParsingException;
import iaik.cms.CertificateIdentifier;
import iaik.cms.Content;
import iaik.cms.ContentInfo;
import iaik.cms.IssuerAndSerialNumber;
import iaik.cms.SecurityProvider;
import iaik.cms.SignedData;
import iaik.cms.SignerInfo;
import iaik.cms.SubjectKeyID;
import iaik.smime.ess.ESSCertID;
import iaik.smime.ess.ESSIssuerSerial;
import iaik.smime.ess.SigningCertificate;
import iaik.tsp.TSTInfo;
import iaik.tsp.TspSigningException;
import iaik.tsp.TspVerificationException;
import iaik.tsp.a;
import iaik.utils.Util;
import iaik.x509.X509Certificate;
import iaik.x509.X509ExtensionException;
import java.security.NoSuchAlgorithmException;
import java.security.PrivateKey;
import java.security.SignatureException;
import java.security.cert.Certificate;
import java.security.cert.CertificateEncodingException;
import java.security.cert.CertificateException;

public class TimeStampToken
extends ContentInfo {
    static /* synthetic */ Class h;
    private SignerInfo c;
    private java.security.cert.X509Certificate[] i;
    private AlgorithmID g = AlgorithmID.sha1;
    private PrivateKey e;
    private java.security.cert.X509Certificate b;
    private SignedData d;
    private TSTInfo a;
    public static final int SUBJECT_KEY_IDENTIFIER = 1;
    public static final int ISSUER_AND_SERIALNUMBER = 0;

    static {
        ContentInfo.register((ObjectID)TSTInfo.ID_CT_TSTINFO, (Class)(h != null ? h : (h = TimeStampToken.b("iaik.tsp.TSTInfo"))));
        iaik.tsp.a.a();
    }

    static Class b(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    private void a(ASN1Object aSN1Object) throws CodingException {
        if (this.getContentType().equals((Object)ObjectID.cms_signedData)) {
            this.d = (SignedData)this.getContent();
            if (!this.d.getEncapsulatedContentType().equals((Object)ObjectID.tstInfo)) {
                throw new CodingException("Can't decode the ASN.1 object");
            }
        } else {
            throw new CodingException("Can't decode the ASN.1 object");
        }
        SignerInfo[] signerInfoArray = new ASN1(this.d.getContent());
        this.a = new TSTInfo(signerInfoArray.toASN1Object());
        if (this.d.getX509Certificates() != null) {
            this.setCertificates((java.security.cert.X509Certificate[])this.d.getX509Certificates());
        }
        if ((signerInfoArray = this.d.getSignerInfos()).length == 1) {
            this.c = signerInfoArray[0];
            this.setHashAlgorithm(this.c.getDigestAlgorithm());
            try {
                this.setSigningCertificate((java.security.cert.X509Certificate)this.d.getCertificate(this.c.getSignerIdentifier()));
                return;
            }
            catch (CMSException cMSException) {
                return;
            }
        }
        throw new CodingException("Illegal count of SignerInfos in the ASN.1 object");
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("<TimeStampToken>\n");
        stringBuffer.append(String.valueOf(this.a.toString()) + "\n");
        stringBuffer.append("</TimeStampToken>");
        return stringBuffer.toString();
    }

    public void verifyTimeStampToken(java.security.cert.X509Certificate x509Certificate) throws TspVerificationException {
        try {
            X509Certificate x509Certificate2;
            try {
                x509Certificate2 = new X509Certificate(x509Certificate.getEncoded());
            }
            catch (CertificateEncodingException certificateEncodingException) {
                throw new TspVerificationException(certificateEncodingException.getMessage());
            }
            catch (CertificateException certificateException) {
                throw new TspVerificationException(certificateException.getMessage());
            }
            this.d.verify(x509Certificate2);
            return;
        }
        catch (SignatureException signatureException) {
            throw new TspVerificationException(signatureException.getMessage());
        }
    }

    public void signTimeStampToken() throws TspSigningException {
        this.signTimeStampToken(null, null, 0);
    }

    public void signTimeStampToken(String string) throws TspSigningException {
        this.signTimeStampToken(string, null, 0);
    }

    public void signTimeStampToken(String string, AlgorithmID algorithmID) throws TspSigningException {
        this.signTimeStampToken(string, algorithmID, 0);
    }

    public void signTimeStampToken(String string, AlgorithmID algorithmID, int n) throws TspSigningException {
        ESSIssuerSerial eSSIssuerSerial;
        IssuerAndSerialNumber issuerAndSerialNumber;
        X509Certificate x509Certificate;
        if (this.b == null) {
            throw new TspSigningException("Signing certificate not set. Use setTSACertificate method first");
        }
        if (this.g == null) {
            throw new TspSigningException("Hash AlgorithmID not set. Use setHashAlgorithm method first");
        }
        if (this.e == null) {
            throw new TspSigningException("PrivateKey not set. Use setTSAPrivateKey method first");
        }
        if (this.a == null) {
            throw new TspSigningException("TSTInfo not set. Use setTSTInfo method first");
        }
        if (n != 0 && n != 1) {
            throw new TspSigningException("Illegal argument for \"certificateIdentifier\" : " + n + " only \"0\" or \"1\"");
        }
        if (this.b instanceof X509Certificate) {
            x509Certificate = (X509Certificate)this.b;
        } else {
            try {
                x509Certificate = new X509Certificate(this.b.getEncoded());
            }
            catch (CertificateEncodingException certificateEncodingException) {
                throw new TspSigningException(certificateEncodingException.getMessage());
            }
            catch (CertificateException certificateException) {
                throw new TspSigningException(certificateException.getMessage());
            }
        }
        if (n == 0) {
            issuerAndSerialNumber = new IssuerAndSerialNumber(x509Certificate);
        } else {
            try {
                issuerAndSerialNumber = new SubjectKeyID(x509Certificate);
            }
            catch (X509ExtensionException x509ExtensionException) {
                throw new TspSigningException("Can't create SubjectKeyIdentifier: " + x509ExtensionException.getMessage());
            }
        }
        SignerInfo signerInfo = algorithmID == null ? new SignerInfo((CertificateIdentifier)issuerAndSerialNumber, this.g, this.e) : new SignerInfo((CertificateIdentifier)issuerAndSerialNumber, this.g, algorithmID, this.e);
        ESSCertID[] eSSCertIDArray = new ESSCertID[]{new ESSCertID()};
        try {
            eSSCertIDArray[0].calculateCertHash(x509Certificate.getEncoded());
        }
        catch (NoSuchAlgorithmException noSuchAlgorithmException) {
            throw new TspSigningException("Can't calculate hash: " + noSuchAlgorithmException.getMessage());
        }
        catch (CertificateEncodingException certificateEncodingException) {
            throw new TspSigningException("Certificate problem: " + certificateEncodingException.toString());
        }
        try {
            eSSIssuerSerial = new ESSIssuerSerial((Certificate)x509Certificate);
        }
        catch (CertificateException certificateException) {
            throw new TspSigningException("Can't create ESSIssuerSerial: " + certificateException.getMessage());
        }
        eSSCertIDArray[0].setIssuerSerial(eSSIssuerSerial);
        SigningCertificate signingCertificate = new SigningCertificate(eSSCertIDArray);
        Attribute[] attributeArray = new Attribute[2];
        attributeArray[0] = new Attribute(ObjectID.contentType, new ASN1Object[]{ObjectID.tstInfo});
        ASN1Object[] aSN1ObjectArray = new ASN1Object[]{signingCertificate.toASN1Object()};
        attributeArray[1] = new Attribute(ObjectID.signingCertificate, aSN1ObjectArray);
        signerInfo.setSignedAttributes(attributeArray);
        if (string != null) {
            this.d.setSecurityProvider(new SecurityProvider(string));
        }
        try {
            this.d.addSignerInfo(signerInfo);
        }
        catch (NoSuchAlgorithmException noSuchAlgorithmException) {
            throw new TspSigningException("Can't sign TimeStampToken: " + noSuchAlgorithmException.toString());
        }
        this.c = signerInfo;
        if (this.i != null && this.i.length != 0) {
            try {
                this.d.setCertificates((Certificate[])Util.convertCertificateChain((Certificate[])this.i));
            }
            catch (CertificateException certificateException) {
                throw new TspSigningException(certificateException.getMessage());
            }
        }
        this.setContent((Content)this.d);
    }

    public java.security.cert.X509Certificate[] getCertificates() {
        return this.i;
    }

    public void setCertificates(java.security.cert.X509Certificate[] x509CertificateArray) throws NullPointerException {
        if (x509CertificateArray == null) {
            throw new NullPointerException("Argument \"certs\" must not be null");
        }
        this.i = x509CertificateArray;
    }

    public SignerInfo getSignerInfo() {
        return this.c;
    }

    public ESSIssuerSerial getIssuerSerial() throws CodingException {
        ESSCertID eSSCertID = this.getCertID();
        if (eSSCertID != null) {
            eSSCertID.getIssuerSerial();
        }
        return null;
    }

    public ESSCertID getCertID() throws CodingException {
        if (this.d == null) {
            return null;
        }
        SignerInfo[] signerInfoArray = this.d.getSignerInfos();
        if (signerInfoArray.length != 1) {
            throw new CodingException("The number of signers is unequal 1.");
        }
        Attribute attribute = signerInfoArray[0].getSignedAttribute(ObjectID.signingCertificate);
        if (!(attribute instanceof Attribute)) {
            throw new CodingException("Cannot find a ESSCertID signed attribute.");
        }
        ASN1Object[] aSN1ObjectArray = attribute.getValue();
        if (aSN1ObjectArray.length != 1) {
            throw new CodingException("ESSCertID has more than one hashed certificates.");
        }
        SigningCertificate signingCertificate = null;
        try {
            signingCertificate = new SigningCertificate(aSN1ObjectArray[0]);
        }
        catch (CodingException codingException) {
            throw new CodingException(codingException.getMessage());
        }
        ESSCertID[] eSSCertIDArray = signingCertificate.getESSCertIDs();
        if (!(eSSCertIDArray instanceof ESSCertID[])) {
            throw new CodingException("There is no ESSCertID in the SignerInfo");
        }
        if (eSSCertIDArray.length != 1) {
            throw new CodingException("The number of ESSCertIDs is unequal 1.");
        }
        return eSSCertIDArray[0];
    }

    public SignedData getSignedData() {
        return this.d;
    }

    public AlgorithmID getHashAlgorithm() {
        return this.g;
    }

    public void setHashAlgorithm(AlgorithmID algorithmID) throws NullPointerException {
        if (algorithmID == null) {
            throw new NullPointerException("Argument \"algorithmId\" must not be null");
        }
        this.g = algorithmID;
    }

    public void setPrivateKey(PrivateKey privateKey) throws NullPointerException {
        if (privateKey == null) {
            throw new NullPointerException("Argument \"privateKey\" must not be null");
        }
        this.e = privateKey;
    }

    public java.security.cert.X509Certificate getSigningCertificate() {
        return this.b;
    }

    public void setSigningCertificate(java.security.cert.X509Certificate x509Certificate) throws NullPointerException {
        if (x509Certificate == null) {
            throw new NullPointerException("Argument \"tsaCertificate\" must not be null");
        }
        this.b = x509Certificate;
    }

    public TSTInfo getTSTInfo() {
        return this.a;
    }

    public TimeStampToken(byte[] byArray) throws CodingException, CMSParsingException {
        this(DerCoder.decode((byte[])byArray));
    }

    public TimeStampToken(ASN1Object aSN1Object) throws CodingException, CMSParsingException {
        super(aSN1Object);
        this.a(aSN1Object);
    }

    public TimeStampToken(TSTInfo tSTInfo) {
        super((Content)tSTInfo);
        this.a = tSTInfo;
        this.d = new SignedData(this.a.getEncoded(), TSTInfo.ID_CT_TSTINFO, 1);
        this.setContent((Content)this.d);
    }
}

