/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derby.impl.drda;

import java.sql.SQLException;
import org.apache.derby.impl.drda.AppRequester;

class FdocaConstants {
    static final int CPT_TRIPLET_TYPE = 127;
    static final int MDD_TRIPLET_TYPE = 120;
    static final int NGDA_TRIPLET_TYPE = 118;
    static final int RLO_TRIPLET_TYPE = 113;
    static final int SDA_TRIPLET_TYPE = 112;
    static final int SDA_MD_TYPE = 1;
    static final int GDA_MD_TYPE = 2;
    static final int ROW_MD_TYPE = 3;
    static final int SQLCADTA_LID = 224;
    static final int SQLDTAGRP_LID = 208;
    static final int NULL_LID = 0;
    static final int INDICATOR_NULLABLE = 0;
    static final int NULL_DATA = 255;
    static final int TYP_NULLIND = 1;
    static final int MAX_ENV_LID = 73;
    static final int MAX_VARS_IN_NGDA = 84;
    static final int FULL_NGDA_SIZE = 255;
    static final int MDD_TRIPLET_SIZE = 7;
    static final int SDA_TRIPLET_SIZE = 12;
    static final int SQLDTA_RLO_SIZE = 6;
    static final int RLO_RPT_GRP_SIZE = 3;
    static final int SQLDTAGRP_SIZE = 3;
    static final int CPT_SIZE = 3;
    static final int FDODSC_FOOTER_SIZE = 6;
    static final int SQLDTAGRP_COL_DSC_SIZE = 3;
    static final int MAX_OVERRIDES = 250;
    static final int MDD_REST_SIZE = 5;
    static final byte[] SQLCADTA_MDD = new byte[]{7, 120, 0, 5, 3, 1, -32};
    static final byte[] SQLDTA_MDD = new byte[]{7, 120, 0, 5, 4, 1, -16};
    static final byte[] SQLDTAGRP_MDD = new byte[]{7, 120, 0, 5, 2, 1, -48};
    static final byte[] SQLCADTA_SQLDTARD_RLO = new byte[]{9, 113, -32, 84, 0, 1, -48, 0, 1, 6, 113, -16, -32, 0, 0};
    static final byte[] SQLDTA_RLO = new byte[]{6, 113, -28, -48, 0, 1};
    static final int SQLCADTA_SQLDTARD_RLO_SIZE = SQLCADTA_SQLDTARD_RLO.length;
    protected static int LONGVARCHAR_MAX_LEN = 32700;
    protected static int LONGVARBINARY_MAX_LEN = 32700;
    protected static int LONGVARCHAR_LEN_NUMBYTES = 2;
    protected static int NUMERIC_MAX_PRECISION;
    protected static int NUMERIC_DEFAULT_PRECISION;
    protected static int NUMERIC_DEFAULT_SCALE;

    FdocaConstants() {
    }

    protected static boolean isNullable(int n) {
        return (n & 1) == 1;
    }

    protected static int mapJdbcTypeToDrdaType(int n, boolean bl, AppRequester appRequester, int[] nArray) throws SQLException {
        int n2 = 0;
        switch (n) {
            case -7: 
            case -6: 
            case 5: 
            case 16: {
                n2 = 5;
                nArray[0] = 2;
                break;
            }
            case 4: {
                n2 = 3;
                nArray[0] = 4;
                break;
            }
            case -5: {
                n2 = 23;
                nArray[0] = 8;
                break;
            }
            case 7: {
                n2 = 13;
                nArray[0] = 4;
                break;
            }
            case 6: 
            case 8: {
                n2 = 11;
                nArray[0] = 8;
                break;
            }
            case 2: 
            case 3: {
                n2 = 15;
                nArray[0] = -1;
                break;
            }
            case 91: {
                n2 = 33;
                nArray[0] = 10;
                break;
            }
            case 92: {
                n2 = 35;
                nArray[0] = 8;
                break;
            }
            case 93: {
                n2 = 37;
                nArray[0] = appRequester.getTimestampLength();
                break;
            }
            case 1: {
                n2 = 63;
                nArray[0] = -1;
                break;
            }
            case 12: {
                n2 = 51;
                nArray[0] = -1;
                break;
            }
            case 2000: {
                if (appRequester.supportsUDTs()) {
                    n2 = 81;
                    nArray[0] = -1;
                    break;
                }
                n2 = 53;
                nArray[0] = LONGVARCHAR_MAX_LEN;
                break;
            }
            case -1: {
                n2 = 53;
                nArray[0] = LONGVARCHAR_MAX_LEN;
                break;
            }
            case -3: 
            case -2: {
                n2 = 41;
                nArray[0] = -1;
                break;
            }
            case -4: {
                n2 = 43;
                nArray[0] = LONGVARBINARY_MAX_LEN;
                break;
            }
            case 2004: {
                n2 = 201;
                nArray[0] = 32772;
                break;
            }
            case 2005: {
                n2 = 207;
                nArray[0] = 32772;
                break;
            }
            case 0: 
            case 1111: 
            case 2001: 
            case 2002: 
            case 2003: 
            case 2006: {
                throw new SQLException("Jdbc type" + n + "not Supported yet");
            }
            default: {
                throw new SQLException("unrecognized sql type: " + n);
            }
        }
        if (!bl) {
            --n2;
        }
        return n2;
    }

    static {
        NUMERIC_DEFAULT_PRECISION = NUMERIC_MAX_PRECISION = 31;
        NUMERIC_DEFAULT_SCALE = 15;
    }
}

