/*
 * Decompiled with CFR 0.152.
 */
package it.sogei.rcp.chunkupload.http;

import it.sogei.rcp.chunkupload.model.OpzioniChunkUploadBean;
import it.sogei.utilities.log4j.LogUtil;
import java.io.BufferedReader;
import java.io.DataOutputStream;
import java.io.FilterOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.ConnectException;
import java.net.HttpURLConnection;
import java.net.URL;
import java.security.SecureRandom;
import java.security.cert.X509Certificate;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.List;
import java.util.Map;
import javax.net.ssl.HostnameVerifier;
import javax.net.ssl.HttpsURLConnection;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLSession;
import javax.net.ssl.TrustManager;
import javax.net.ssl.X509TrustManager;

public class HttpUpload {
    OpzioniChunkUploadBean opzioni = null;
    private static HttpUpload httpUpload;
    private HttpURLConnection httpConn = null;
    private HttpsURLConnection httpsConn = null;
    public Hashtable<String, String> requestPropertyMap;

    private HttpUpload(OpzioniChunkUploadBean opzioni) {
        this.opzioni = opzioni;
        this.println("****** In HttpUpload ***** ", 1);
    }

    public static HttpUpload getInstance(OpzioniChunkUploadBean opzioni) {
        if (httpUpload == null) {
            httpUpload = new HttpUpload(opzioni);
            httpUpload.println("new HttpUpload ", 1);
        } else {
            httpUpload.println("HttpUpload gia instanziato ", 1);
            HttpUpload.httpUpload.opzioni = opzioni;
        }
        return httpUpload;
    }

    public String connect(String method, Hashtable<String, String> requestProperty, URL url) throws Exception {
        String response = "";
        try {
            if (!this.opzioni.getRequestUrlParameter().isEmpty()) {
                httpUpload.println("aggiunta di parametri da opzioni alla url ", 1);
                String newUrl = url.toString();
                Enumeration<String> keys = this.opzioni.getRequestUrlParameter().keys();
                String aKey = "";
                while (keys.hasMoreElements()) {
                    aKey = keys.nextElement();
                    newUrl = String.valueOf(newUrl) + "&" + aKey + "=" + this.opzioni.getRequestUrlParameter().get(aKey);
                }
                url = new URL(newUrl);
            }
            this.println("url: " + url, 1);
            if (url.getProtocol().equals("http")) {
                this.httpConn = (HttpURLConnection)url.openConnection();
                httpUpload.println("metodo: " + method, 1);
                this.httpConn.setRequestMethod(method);
                this.httpConn.setReadTimeout(this.opzioni.getReadTimeout());
                this.httpConn = this.setHttpConnection(this.httpConn, requestProperty);
                response = this.doConnectHttp(this.httpConn);
                httpUpload.println("response doConnectHttp: " + response, 1);
            } else if (url.getProtocol().equals("https")) {
                this.httpsConn = (HttpsURLConnection)url.openConnection();
                httpUpload.println("metodo: " + method, 1);
                this.httpsConn.setRequestMethod(method);
                this.httpsConn.setReadTimeout(this.opzioni.getReadTimeout());
                this.httpsConn = this.setHttpsConnection(this.httpsConn, requestProperty);
                response = this.doConnectHttps(this.httpsConn);
                httpUpload.println("response doConnectHttps: " + response, 1);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new Exception(e.getMessage());
        }
        return response;
    }

    public String upload(String method, Hashtable<String, String> requestProperty, URL url, byte[] buf) throws Exception {
        String response = "";
        try {
            if (!this.opzioni.getRequestUrlParameter().isEmpty()) {
                httpUpload.println("aggiunta di parametri da opzioni alla url ", 1);
                String newUrl = url.toString();
                Enumeration<String> keys = this.opzioni.getRequestUrlParameter().keys();
                String aKey = "";
                while (keys.hasMoreElements()) {
                    aKey = keys.nextElement();
                    newUrl = String.valueOf(newUrl) + "&" + aKey + "=" + this.opzioni.getRequestUrlParameter().get(aKey);
                }
                url = new URL(newUrl);
            }
            this.println("url: " + url, 1);
            if (url.getProtocol().equals("http")) {
                this.httpConn = (HttpURLConnection)url.openConnection();
                this.httpConn.setRequestMethod(method);
                httpUpload.println("metodo: " + method, 1);
                this.httpConn = this.setHttpConnection(this.httpConn, requestProperty);
                httpUpload.println("buffer length doInviaHttp: " + buf.length, 1);
                response = this.doInviaHttp(this.httpConn, buf);
                httpUpload.println("response doInviaHttp: " + response, 1);
            } else if (url.getProtocol().equals("https")) {
                this.httpsConn = (HttpsURLConnection)url.openConnection();
                httpUpload.println("metodo: " + method, 1);
                this.httpsConn.setRequestMethod(method);
                this.httpsConn = this.setHttpsConnection(this.httpsConn, requestProperty);
                httpUpload.println("buffer length doInviaHttps: " + buf.length, 1);
                response = this.doInviaHttps(this.httpsConn, buf);
                httpUpload.println("response doInviaHttps: " + response, 1);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new Exception(e.getMessage());
        }
        return response;
    }

    private HttpURLConnection setHttpConnection(HttpURLConnection httpConn, Hashtable<String, String> requestProperty) throws Exception {
        Enumeration<String> keys = requestProperty.keys();
        String aKey = "";
        while (keys.hasMoreElements()) {
            aKey = keys.nextElement();
            httpConn.setRequestProperty(aKey, requestProperty.get(aKey));
        }
        if (this.opzioni.getResponseHeaderMap() != null && this.opzioni.getResponseHeaderMap().get("Set-Cookie") != null) {
            List<String> responseCookie = this.opzioni.getResponseHeaderMap().get("Set-Cookie");
            for (String cookie : responseCookie) {
                this.httpsConn.addRequestProperty("Cookie", cookie.split(";", 1)[0]);
            }
        }
        return httpConn;
    }

    private HttpsURLConnection setHttpsConnection(HttpsURLConnection httpsConn, Hashtable<String, String> requestProperty) throws Exception {
        httpsConn.setHostnameVerifier(new HostnameVerifier(){

            @Override
            public boolean verify(String hostname, SSLSession session) {
                return true;
            }
        });
        TrustManager[] trustAllCerts = new TrustManager[]{new X509TrustManager(){

            @Override
            public X509Certificate[] getAcceptedIssuers() {
                return null;
            }

            @Override
            public void checkClientTrusted(X509Certificate[] certs, String authType) {
            }

            @Override
            public void checkServerTrusted(X509Certificate[] certs, String authType) {
            }
        }};
        SSLContext sc = SSLContext.getInstance(this.opzioni.getSecurityProtocol());
        sc.init(null, trustAllCerts, new SecureRandom());
        HttpsURLConnection.setDefaultSSLSocketFactory(sc.getSocketFactory());
        httpsConn.setSSLSocketFactory(sc.getSocketFactory());
        Enumeration<String> keys = requestProperty.keys();
        String aKey = "";
        while (keys.hasMoreElements()) {
            aKey = keys.nextElement();
            httpsConn.setRequestProperty(aKey, requestProperty.get(aKey));
        }
        this.println("Response Header Map in opzioni : " + this.opzioni.getResponseHeaderMap(), 1);
        if (this.opzioni.getResponseHeaderMap() != null && this.opzioni.getResponseHeaderMap().get("Set-Cookie") != null) {
            List<String> responseCookie = this.opzioni.getResponseHeaderMap().get("Set-Cookie");
            for (String cookie : responseCookie) {
                httpsConn.addRequestProperty("Cookie", cookie.split(";", 1)[0]);
            }
        }
        this.println("Request properties: " + httpsConn.getRequestProperties(), 1);
        return httpsConn;
    }

    private String doInviaHttp(HttpURLConnection hcon, byte[] buf) throws Exception {
        String response;
        block31: {
            this.println("** doInviaHttp ** ", 1);
            String s = "";
            FilterOutputStream dataoutputstream = null;
            BufferedReader bufferedreader = null;
            InputStream is = null;
            InputStreamReader isr = null;
            this.httpsConn.setDoOutput(true);
            this.httpsConn.setDoInput(true);
            response = "";
            try {
                try {
                    this.println("scrittura OutputStream ", 1);
                    dataoutputstream = new DataOutputStream(hcon.getOutputStream());
                    dataoutputstream.write(buf);
                    ((DataOutputStream)dataoutputstream).flush();
                    dataoutputstream.close();
                    this.println("HttpUpload upload: - ho chiuso lo streaming dei dati", 1);
                    if (hcon.getResponseCode() == 401) {
                        this.println("HttpUpload connect: errore durante la connessione, credenziali invalide, response code: " + hcon.getResponseCode(), 4);
                        Map<String, List<String>> responseMap = hcon.getHeaderFields();
                        this.opzioni.setResponseHeaderMap(responseMap);
                        response = "-34";
                        break block31;
                    }
                    if (hcon.getResponseCode() != 200) {
                        this.println("HttpUpload upload: errore di connessione, response Code: " + hcon.getResponseCode(), 1);
                        Map<String, List<String>> responseMap = hcon.getHeaderFields();
                        this.opzioni.setResponseHeaderMap(responseMap);
                        response = "-2";
                        break block31;
                    }
                    this.println("lettura InpuStream ", 1);
                    is = hcon.getInputStream();
                    isr = new InputStreamReader(is);
                    bufferedreader = new BufferedReader(isr);
                    response = "";
                    while ((s = bufferedreader.readLine()) != null) {
                        response = String.valueOf(response) + s;
                        this.println("HttpUpload connect: Response dal server (offset): " + String.valueOf(s), 1);
                    }
                }
                catch (ConnectException ne) {
                    this.println("Eccezione HttpUpload connect: errore di connessione: " + ne.toString(), 1);
                    response = "-3";
                    ne.printStackTrace();
                    try {
                        if (dataoutputstream != null) {
                            dataoutputstream.close();
                        }
                        if (bufferedreader != null) {
                            bufferedreader.close();
                        }
                        if (is != null) {
                            is.close();
                        }
                        if (hcon != null) {
                            hcon.disconnect();
                        }
                        this.println("17 HttpUpload upload: - ho rilasciato le risorse", 1);
                    }
                    catch (IOException ioe) {
                        ioe.printStackTrace();
                        response = "-2";
                    }
                }
                catch (Exception e) {
                    this.println("Eccezione in HttpUpload upload: " + e.toString(), 4);
                    e.printStackTrace();
                    response = "-2";
                    try {
                        if (dataoutputstream != null) {
                            dataoutputstream.close();
                        }
                        if (bufferedreader != null) {
                            bufferedreader.close();
                        }
                        if (is != null) {
                            is.close();
                        }
                        if (hcon != null) {
                            hcon.disconnect();
                        }
                        this.println("17 HttpUpload upload: - ho rilasciato le risorse", 1);
                    }
                    catch (IOException ioe) {
                        ioe.printStackTrace();
                        response = "-2";
                    }
                }
            }
            finally {
                try {
                    if (dataoutputstream != null) {
                        dataoutputstream.close();
                    }
                    if (bufferedreader != null) {
                        bufferedreader.close();
                    }
                    if (is != null) {
                        is.close();
                    }
                    if (hcon != null) {
                        hcon.disconnect();
                    }
                    this.println("17 HttpUpload upload: - ho rilasciato le risorse", 1);
                }
                catch (IOException ioe) {
                    ioe.printStackTrace();
                    response = "-2";
                }
            }
        }
        return response;
    }

    private String doInviaHttps(HttpsURLConnection hcon, byte[] buf) throws Exception {
        String response;
        block31: {
            this.println("** doInviaHttps ** ", 1);
            String s = "";
            FilterOutputStream dataoutputstream = null;
            BufferedReader bufferedreader = null;
            InputStream is = null;
            InputStreamReader isr = null;
            this.httpsConn.setDoOutput(true);
            this.httpsConn.setDoInput(true);
            response = "";
            try {
                try {
                    this.println("scrittura OutputStream ", 1);
                    dataoutputstream = new DataOutputStream(hcon.getOutputStream());
                    dataoutputstream.write(buf);
                    ((DataOutputStream)dataoutputstream).flush();
                    dataoutputstream.close();
                    this.println("HttpUpload upload: - ho chiuso lo streaming dei dati", 1);
                    if (hcon.getResponseCode() == 401) {
                        this.println("HttpUpload connect: errore durante la connessione, credenziali invalide, response code: " + hcon.getResponseCode(), 4);
                        Map<String, List<String>> responseMap = hcon.getHeaderFields();
                        this.opzioni.setResponseHeaderMap(responseMap);
                        response = "-34";
                        break block31;
                    }
                    if (hcon.getResponseCode() != 200) {
                        this.println("HttpUpload upload: errore di connessione, response Code: " + hcon.getResponseCode(), 1);
                        Map<String, List<String>> responseMap = hcon.getHeaderFields();
                        this.opzioni.setResponseHeaderMap(responseMap);
                        response = "-2";
                        break block31;
                    }
                    this.println("lettura InputStream ", 1);
                    is = hcon.getInputStream();
                    isr = new InputStreamReader(is);
                    bufferedreader = new BufferedReader(isr);
                    this.println("invio - response map : " + this.opzioni.getResponseHeaderMap().toString(), 1);
                    response = "";
                    while ((s = bufferedreader.readLine()) != null) {
                        response = String.valueOf(response) + s;
                        this.println("HttpUpload connect: Response dal server (offset): " + String.valueOf(s), 1);
                    }
                }
                catch (ConnectException ne) {
                    this.println("Eccezione HttpUpload connect: errore di connessione: " + ne.toString(), 1);
                    response = "-3";
                    ne.printStackTrace();
                    try {
                        if (dataoutputstream != null) {
                            dataoutputstream.close();
                            this.println("HttpUpload connect: - dataoutputstream chiuso", 1);
                        }
                        if (bufferedreader != null) {
                            bufferedreader.close();
                            this.println("HttpUpload connect: - bufferedreader chiuso", 1);
                        }
                        if (is != null) {
                            is.close();
                            this.println("HttpUpload connect: - inputstream chiuso", 1);
                        }
                        if (hcon != null) {
                            hcon.disconnect();
                            this.println("HttpUpload connect: - disconnesso", 1);
                        }
                        this.println("HttpUpload connect: - tutte le operazioni di chiusura del finally eseguite", 1);
                    }
                    catch (IOException ioe) {
                        ioe.printStackTrace();
                        this.println("Eccezione in HttpUpload : " + ioe.getMessage(), 4);
                        response = "-2";
                    }
                }
                catch (Exception e) {
                    this.println("Eccezione in HttpUpload upload: " + e.toString(), 4);
                    e.printStackTrace();
                    response = "-2";
                    try {
                        if (dataoutputstream != null) {
                            dataoutputstream.close();
                            this.println("HttpUpload connect: - dataoutputstream chiuso", 1);
                        }
                        if (bufferedreader != null) {
                            bufferedreader.close();
                            this.println("HttpUpload connect: - bufferedreader chiuso", 1);
                        }
                        if (is != null) {
                            is.close();
                            this.println("HttpUpload connect: - inputstream chiuso", 1);
                        }
                        if (hcon != null) {
                            hcon.disconnect();
                            this.println("HttpUpload connect: - disconnesso", 1);
                        }
                        this.println("HttpUpload connect: - tutte le operazioni di chiusura del finally eseguite", 1);
                    }
                    catch (IOException ioe) {
                        ioe.printStackTrace();
                        this.println("Eccezione in HttpUpload : " + ioe.getMessage(), 4);
                        response = "-2";
                    }
                }
            }
            finally {
                try {
                    if (dataoutputstream != null) {
                        dataoutputstream.close();
                        this.println("HttpUpload connect: - dataoutputstream chiuso", 1);
                    }
                    if (bufferedreader != null) {
                        bufferedreader.close();
                        this.println("HttpUpload connect: - bufferedreader chiuso", 1);
                    }
                    if (is != null) {
                        is.close();
                        this.println("HttpUpload connect: - inputstream chiuso", 1);
                    }
                    if (hcon != null) {
                        hcon.disconnect();
                        this.println("HttpUpload connect: - disconnesso", 1);
                    }
                    this.println("HttpUpload connect: - tutte le operazioni di chiusura del finally eseguite", 1);
                }
                catch (IOException ioe) {
                    ioe.printStackTrace();
                    this.println("Eccezione in HttpUpload : " + ioe.getMessage(), 4);
                    response = "-2";
                }
            }
        }
        return response;
    }

    private String doConnectHttp(HttpURLConnection hcon) throws Exception {
        String response;
        block28: {
            this.println("** doConnectHttp ** ", 1);
            response = "";
            String offset = "";
            BufferedReader bufferedreader = null;
            InputStream is = null;
            InputStreamReader isr = null;
            try {
                try {
                    if (hcon.getResponseCode() == 401) {
                        this.println("HttpUpload connect: errore durante la connessione, credenziali invalide, response code: " + hcon.getResponseCode(), 4);
                        Map<String, List<String>> responseMap = hcon.getHeaderFields();
                        this.opzioni.setResponseHeaderMap(responseMap);
                        response = "-34";
                        break block28;
                    }
                    if (hcon.getResponseCode() != 200) {
                        this.println("HttpUpload upload: errore di connessione, response Code: " + hcon.getResponseCode(), 4);
                        Map<String, List<String>> responseMap = hcon.getHeaderFields();
                        this.opzioni.setResponseHeaderMap(responseMap);
                        response = "-2";
                        break block28;
                    }
                    Map<String, List<String>> responseMap = hcon.getHeaderFields();
                    this.opzioni.setResponseHeaderMap(responseMap);
                    this.println("lettura InputStream ", 1);
                    is = hcon.getInputStream();
                    isr = new InputStreamReader(is);
                    bufferedreader = new BufferedReader(isr);
                    while ((offset = bufferedreader.readLine()) != null) {
                        response = String.valueOf(response) + offset;
                        this.println("HttpUpload connect: Response dal server (offset): " + String.valueOf(offset), 1);
                    }
                }
                catch (ConnectException ne) {
                    this.println("Eccezione HttpUpload connect: errore di connessione " + ne.toString(), 1);
                    response = "-3";
                    ne.printStackTrace();
                    try {
                        if (bufferedreader != null) {
                            bufferedreader.close();
                        }
                        if (is != null) {
                            is.close();
                        }
                        if (hcon != null) {
                            hcon.disconnect();
                        }
                        this.println("17 HttpUpload connect - ho rilasciato le risorse", 1);
                    }
                    catch (IOException ioe) {
                        ioe.printStackTrace();
                        this.println("Eccezione in HttpUpload : " + ioe.getMessage(), 4);
                        response = "-2";
                    }
                }
                catch (Exception e) {
                    this.println("Eccezione in HttpUpload connect: " + e.toString(), 4);
                    response = "-2";
                    e.printStackTrace();
                    try {
                        if (bufferedreader != null) {
                            bufferedreader.close();
                        }
                        if (is != null) {
                            is.close();
                        }
                        if (hcon != null) {
                            hcon.disconnect();
                        }
                        this.println("17 HttpUpload connect - ho rilasciato le risorse", 1);
                    }
                    catch (IOException ioe) {
                        ioe.printStackTrace();
                        this.println("Eccezione in HttpUpload : " + ioe.getMessage(), 4);
                        response = "-2";
                    }
                }
            }
            finally {
                try {
                    if (bufferedreader != null) {
                        bufferedreader.close();
                    }
                    if (is != null) {
                        is.close();
                    }
                    if (hcon != null) {
                        hcon.disconnect();
                    }
                    this.println("17 HttpUpload connect - ho rilasciato le risorse", 1);
                }
                catch (IOException ioe) {
                    ioe.printStackTrace();
                    this.println("Eccezione in HttpUpload : " + ioe.getMessage(), 4);
                    response = "-2";
                }
            }
        }
        return response;
    }

    private String doConnectHttps(HttpsURLConnection hcon) throws Exception {
        String response;
        block28: {
            this.println("** doConnectHttps ** ", 1);
            response = "";
            String offset = "";
            BufferedReader bufferedreader = null;
            InputStream is = null;
            InputStreamReader isr = null;
            hcon.setDoOutput(false);
            hcon.setDoInput(true);
            this.println("URL: " + hcon.getURL().toString(), 1);
            try {
                try {
                    if (hcon.getResponseCode() == 401) {
                        this.println("HttpUpload connect: errore durante la connessione, credenziali invalide, response code: " + hcon.getResponseCode(), 4);
                        Map<String, List<String>> responseMap = hcon.getHeaderFields();
                        this.opzioni.setResponseHeaderMap(responseMap);
                        response = "-34";
                        break block28;
                    }
                    if (hcon.getResponseCode() != 200) {
                        this.println("HttpUpload connect: errore durante la connessione, response code: " + hcon.getResponseCode(), 4);
                        Map<String, List<String>> responseMap = hcon.getHeaderFields();
                        this.opzioni.setResponseHeaderMap(responseMap);
                        response = "-2";
                        break block28;
                    }
                    Map<String, List<String>> responseMap = hcon.getHeaderFields();
                    this.opzioni.setResponseHeaderMap(responseMap);
                    this.println("connect - response map: " + this.opzioni.getResponseHeaderMap().toString(), 1);
                    this.println("letturaInputStream", 1);
                    is = hcon.getInputStream();
                    isr = new InputStreamReader(is);
                    bufferedreader = new BufferedReader(isr);
                    while (true) {
                        this.println("HttpUpload connect: in ciclo do-while ", 1);
                        offset = bufferedreader.readLine();
                        if (offset == null) {
                            this.println("HttpUpload connect: in ciclo do-while - offset: " + offset, 1);
                            break;
                        }
                        this.println("HttpUpload connect: in ciclo do-while - response: " + response, 1);
                        response = String.valueOf(response) + offset;
                        this.println("HttpUpload connect:  in ciclo do-while - Response dal server (offset): " + String.valueOf(offset), 1);
                    }
                }
                catch (ConnectException ne) {
                    this.println("Eccezione HttpUpload connect: errore di connessione " + ne.toString(), 1);
                    response = "-3";
                    ne.printStackTrace();
                    try {
                        if (bufferedreader != null) {
                            bufferedreader.close();
                            this.println("HttpUpload connect: - bufferedreader chiuso", 1);
                        }
                        if (is != null) {
                            is.close();
                            this.println("HttpUpload connect: - inputstream chiuso", 1);
                        }
                        if (hcon != null) {
                            hcon.disconnect();
                            this.println("HttpUpload connect: - disconnesso", 1);
                        }
                        this.println("HttpUpload connect: - tutte le operazioni di chiusura del finally eseguite", 1);
                    }
                    catch (IOException ioe) {
                        ioe.printStackTrace();
                        this.println("Eccezione in HttpUpload : " + ioe.getMessage(), 4);
                        response = "-2";
                    }
                }
                catch (Exception e) {
                    this.println("Eccezione in HttpUpload connect: " + e.toString(), 1);
                    response = "-2";
                    e.printStackTrace();
                    try {
                        if (bufferedreader != null) {
                            bufferedreader.close();
                            this.println("HttpUpload connect: - bufferedreader chiuso", 1);
                        }
                        if (is != null) {
                            is.close();
                            this.println("HttpUpload connect: - inputstream chiuso", 1);
                        }
                        if (hcon != null) {
                            hcon.disconnect();
                            this.println("HttpUpload connect: - disconnesso", 1);
                        }
                        this.println("HttpUpload connect: - tutte le operazioni di chiusura del finally eseguite", 1);
                    }
                    catch (IOException ioe) {
                        ioe.printStackTrace();
                        this.println("Eccezione in HttpUpload : " + ioe.getMessage(), 4);
                        response = "-2";
                    }
                }
            }
            finally {
                try {
                    if (bufferedreader != null) {
                        bufferedreader.close();
                        this.println("HttpUpload connect: - bufferedreader chiuso", 1);
                    }
                    if (is != null) {
                        is.close();
                        this.println("HttpUpload connect: - inputstream chiuso", 1);
                    }
                    if (hcon != null) {
                        hcon.disconnect();
                        this.println("HttpUpload connect: - disconnesso", 1);
                    }
                    this.println("HttpUpload connect: - tutte le operazioni di chiusura del finally eseguite", 1);
                }
                catch (IOException ioe) {
                    ioe.printStackTrace();
                    this.println("Eccezione in HttpUpload : " + ioe.getMessage(), 4);
                    response = "-2";
                }
            }
        }
        return response;
    }

    private void println(String log, int level) {
        LogUtil.log((String)"it.sogei.rcp.chunkupload", (int)level, (String)log);
    }
}

