/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.internal.views.markers;

import java.util.Collection;
import java.util.Iterator;
import org.eclipse.jface.action.ContributionItem;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.Separator;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.MenuItem;
import org.eclipse.ui.internal.views.markers.ExtendedMarkersView;
import org.eclipse.ui.internal.views.markers.MarkerFieldFilterGroup;
import org.eclipse.ui.internal.views.markers.MarkersContribution;
import org.eclipse.ui.views.markers.internal.MarkerMessages;

public class FiltersContribution
extends MarkersContribution {
    protected IContributionItem[] getContributionItems() {
        final ExtendedMarkersView view = this.getView();
        if (view == null) {
            return new IContributionItem[0];
        }
        Collection groups = view.getAllFilters();
        if (groups.size() == 0) {
            return new IContributionItem[0];
        }
        Iterator groupsIterator = groups.iterator();
        IContributionItem[] items = new IContributionItem[groups.size() + 2];
        int i = 0;
        while (i < groups.size()) {
            final MarkerFieldFilterGroup group = (MarkerFieldFilterGroup)groupsIterator.next();
            items[i] = new ContributionItem(){

                public void fill(Menu menu, int index) {
                    MenuItem item = new MenuItem(menu, 32);
                    item.setText(group.getName());
                    item.addListener(13, this.getMenuItemListener(group, view));
                    if (view != null && view.isEnabled(group)) {
                        item.setSelection(true);
                    }
                }

                private Listener getMenuItemListener(MarkerFieldFilterGroup group2, ExtendedMarkersView view2) {
                    return new Listener(this, view2, group2){
                        final /* synthetic */ 1 this$1;
                        private final /* synthetic */ ExtendedMarkersView val$view;
                        private final /* synthetic */ MarkerFieldFilterGroup val$group;
                        {
                            this.this$1 = var1_1;
                            this.val$view = extendedMarkersView;
                            this.val$group = markerFieldFilterGroup;
                        }

                        public void handleEvent(Event event) {
                            if (this.val$view != null) {
                                this.val$view.toggleFilter(this.val$group);
                            }
                        }
                    };
                }
            };
            ++i;
        }
        items[groups.size()] = new Separator();
        items[groups.size() + 1] = this.getShowAllContribution();
        return items;
    }

    private IContributionItem getShowAllContribution() {
        return new ContributionItem(){

            public void fill(Menu menu, int index) {
                MenuItem item = new MenuItem(menu, 32);
                item.setText(MarkerMessages.MarkerFilter_showAllCommand_title);
                item.setSelection(this.noFiltersSelected());
                item.addListener(13, new Listener(this){
                    final /* synthetic */ 3 this$1;
                    {
                        this.this$1 = var1_1;
                    }

                    public void handleEvent(Event event) {
                        ExtendedMarkersView view = 3.access$0(this.this$1).getView();
                        if (view != null) {
                            view.disableAllFilters();
                        }
                    }
                });
            }

            private boolean noFiltersSelected() {
                ExtendedMarkersView view = FiltersContribution.this.getView();
                if (view == null) {
                    return true;
                }
                Iterator groupsIterator = view.getAllFilters().iterator();
                while (groupsIterator.hasNext()) {
                    MarkerFieldFilterGroup group = (MarkerFieldFilterGroup)groupsIterator.next();
                    if (!group.isEnabled()) continue;
                    return false;
                }
                return true;
            }

            static /* synthetic */ FiltersContribution access$0(3 var0) {
                return var0.FiltersContribution.this;
            }
        };
    }
}

