/*
 * Decompiled with CFR 0.152.
 */
package javax.xml.crypto.dsig;

import iaik.xsect.com.fourthpass.a;
import java.io.Serializable;
import java.security.InvalidAlgorithmParameterException;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import java.security.Provider;
import java.security.Security;
import java.util.List;
import java.util.Properties;
import javax.xml.crypto.Data;
import javax.xml.crypto.MarshalException;
import javax.xml.crypto.NoSuchMechanismException;
import javax.xml.crypto.URIDereferencer;
import javax.xml.crypto.XMLStructure;
import javax.xml.crypto.dsig.CanonicalizationMethod;
import javax.xml.crypto.dsig.DigestMethod;
import javax.xml.crypto.dsig.Manifest;
import javax.xml.crypto.dsig.Reference;
import javax.xml.crypto.dsig.SignatureMethod;
import javax.xml.crypto.dsig.SignatureProperties;
import javax.xml.crypto.dsig.SignatureProperty;
import javax.xml.crypto.dsig.SignedInfo;
import javax.xml.crypto.dsig.Transform;
import javax.xml.crypto.dsig.XMLObject;
import javax.xml.crypto.dsig.XMLSignature;
import javax.xml.crypto.dsig.XMLSignatureException;
import javax.xml.crypto.dsig.XMLValidateContext;
import javax.xml.crypto.dsig.keyinfo.KeyInfo;
import javax.xml.crypto.dsig.keyinfo.KeyInfoFactory;
import javax.xml.crypto.dsig.spec.C14NMethodParameterSpec;
import javax.xml.crypto.dsig.spec.DigestMethodParameterSpec;
import javax.xml.crypto.dsig.spec.SignatureMethodParameterSpec;
import javax.xml.crypto.dsig.spec.TransformParameterSpec;

public abstract class XMLSignatureFactory {
    private String mechanismType;
    private Provider provider;
    private static final String TYPE = "XMLSignatureFactory";

    public abstract XMLSignature unmarshalXMLSignature(XMLValidateContext var1) throws MarshalException;

    public abstract XMLSignature unmarshalXMLSignature(XMLStructure var1) throws MarshalException;

    public abstract XMLSignature newXMLSignature(SignedInfo var1, KeyInfo var2, List var3, String var4, String var5);

    public abstract XMLSignature newXMLSignature(SignedInfo var1, KeyInfo var2);

    public abstract XMLObject newXMLObject(List var1, String var2, String var3, String var4);

    public abstract Transform newTransform(String var1, TransformParameterSpec var2) throws InvalidAlgorithmParameterException, NoSuchAlgorithmException;

    public abstract Transform newTransform(String var1, XMLStructure var2) throws InvalidAlgorithmParameterException, NoSuchAlgorithmException;

    public abstract SignedInfo newSignedInfo(CanonicalizationMethod var1, SignatureMethod var2, List var3, String var4);

    public abstract SignedInfo newSignedInfo(CanonicalizationMethod var1, SignatureMethod var2, List var3);

    public abstract SignatureProperty newSignatureProperty(List var1, String var2, String var3);

    public abstract SignatureProperties newSignatureProperties(List var1, String var2);

    public abstract SignatureMethod newSignatureMethod(String var1, SignatureMethodParameterSpec var2) throws InvalidAlgorithmParameterException, NoSuchAlgorithmException;

    public abstract Reference newReference(String var1, DigestMethod var2, List var3, Data var4, List var5, String var6, String var7);

    public abstract Reference newReference(String var1, DigestMethod var2, List var3, String var4, String var5, byte[] var6);

    public abstract Reference newReference(String var1, DigestMethod var2, List var3, String var4, String var5);

    public abstract Reference newReference(String var1, DigestMethod var2);

    public abstract Manifest newManifest(List var1, String var2);

    public abstract Manifest newManifest(List var1);

    public abstract DigestMethod newDigestMethod(String var1, DigestMethodParameterSpec var2) throws InvalidAlgorithmParameterException, NoSuchAlgorithmException;

    public abstract CanonicalizationMethod newCanonicalizationMethod(String var1, C14NMethodParameterSpec var2) throws InvalidAlgorithmParameterException, NoSuchAlgorithmException;

    public abstract CanonicalizationMethod newCanonicalizationMethod(String var1, XMLStructure var2) throws InvalidAlgorithmParameterException, NoSuchAlgorithmException;

    public abstract boolean isFeatureSupported(String var1);

    public abstract URIDereferencer getURIDereferencer();

    public final Provider getProvider() {
        return this.provider;
    }

    public final String getMechanismType() {
        return this.mechanismType;
    }

    public final KeyInfoFactory getKeyInfoFactory() {
        return KeyInfoFactory.getInstance(this.getMechanismType(), this.getProvider());
    }

    public static XMLSignatureFactory getInstance(String string, Provider provider) {
        if (string == null) {
            throw new NullPointerException("mechanismType cannot be null");
        }
        if (provider == null) {
            throw new NullPointerException("provider cannot be null");
        }
        try {
            return XMLSignatureFactory.findInstance(string, provider);
        }
        catch (XMLSignatureException xMLSignatureException) {
            throw new NoSuchMechanismException("Cannot find " + string + " mechanism type.", xMLSignatureException);
        }
    }

    public static XMLSignatureFactory getInstance(String string, String string2) throws NoSuchProviderException {
        if (string == null) {
            throw new NullPointerException("mechanismType cannot be null");
        }
        if (string2 == null) {
            throw new NullPointerException("provider cannot be null");
        }
        Provider provider = Security.getProvider(string2);
        if (provider == null) {
            throw new NoSuchProviderException("cannot find provider named " + string2);
        }
        try {
            return XMLSignatureFactory.findInstance(string, provider);
        }
        catch (XMLSignatureException xMLSignatureException) {
            throw new NoSuchMechanismException("Cannot find " + string + " mechanism type.", xMLSignatureException);
        }
    }

    public static XMLSignatureFactory getInstance(String string) {
        if (string == null) {
            throw new NullPointerException("mechanismType cannot be null");
        }
        try {
            return XMLSignatureFactory.findInstance(string, null);
        }
        catch (XMLSignatureException xMLSignatureException) {
            throw new NoSuchMechanismException("Cannot find " + string + " mechanism type.", xMLSignatureException);
        }
    }

    public static XMLSignatureFactory getInstance() {
        return XMLSignatureFactory.getInstance("DOM");
    }

    private static XMLSignatureFactory findInstance(String string, Provider serializable) throws XMLSignatureException {
        Object object;
        Object object2;
        Serializable serializable2;
        Provider[] providerArray;
        String string2 = null;
        if (serializable != null) {
            Provider[] providerArray2 = new Provider[1];
            providerArray = providerArray2;
            providerArray2[0] = serializable;
        } else {
            providerArray = Security.getProviders();
        }
        Provider[] providerArray3 = providerArray;
        int n = 0;
        while (n < providerArray3.length) {
            serializable2 = providerArray3[n];
            object2 = ((Properties)serializable2).getProperty("Alg.Alias.XMLSignatureFactory." + string);
            object = "XMLSignatureFactory." + (String)(object2 != null ? object2 : string);
            String string3 = ((Properties)serializable2).getProperty((String)object);
            if (string3 != null) {
                string2 = string3;
                serializable = serializable2;
                break;
            }
            ++n;
        }
        if (string2 == null) {
            throw new NoSuchMechanismException("Cannot find " + string + " mechanism type.");
        }
        try {
            object2 = serializable.getClass().getClassLoader();
            serializable2 = object2 != null ? ((ClassLoader)object2).loadClass(string2) : a.a(string2);
            object = (XMLSignatureFactory)((Class)serializable2).newInstance();
            ((XMLSignatureFactory)object).mechanismType = string;
            ((XMLSignatureFactory)object).provider = serializable;
            return object;
        }
        catch (ClassCastException classCastException) {
            throw new XMLSignatureException("Class '" + string2 + "' configured for " + TYPE + " " + "(provider: " + serializable.getName() + ")" + " is not a " + TYPE + ".", classCastException);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new XMLSignatureException("Class '" + string2 + "' configured for " + TYPE + " " + "(provider: " + serializable.getName() + ")" + " cannot be found.", classNotFoundException);
        }
        catch (InstantiationException instantiationException) {
            throw new XMLSignatureException("Class '" + string2 + "' configured for " + TYPE + " " + "(provider: " + serializable.getName() + ")" + " cannot be instantiated.", instantiationException);
        }
        catch (IllegalAccessException illegalAccessException) {
            throw new XMLSignatureException("Class '" + string2 + "' configured for " + TYPE + " " + "(provider: " + serializable.getName() + ")" + " cannot be accessed.", illegalAccessException);
        }
        catch (SecurityException securityException) {
            throw new XMLSignatureException("Class '" + string2 + "' configured for " + TYPE + " " + "(provider: " + serializable.getName() + ")" + " cannot be accessed.", securityException);
        }
    }

    protected XMLSignatureFactory() {
    }
}

