/*
 * Decompiled with CFR 0.152.
 */
package iaik.security.ecc.ecdsa;

import iaik.asn1.ASN;
import iaik.asn1.ASN1;
import iaik.asn1.ASN1Object;
import iaik.asn1.BIT_STRING;
import iaik.asn1.CON_SPEC;
import iaik.asn1.INTEGER;
import iaik.asn1.OCTET_STRING;
import iaik.asn1.ObjectID;
import iaik.asn1.SEQUENCE;
import iaik.asn1.structures.AlgorithmID;
import iaik.pkcs.pkcs8.PrivateKeyInfo;
import iaik.security.ecc.ecdsa.ECDSAParameter;
import iaik.security.ecc.ecdsa.ECPublicKey;
import iaik.security.ecc.interfaces.ECDSAParams;
import iaik.security.ecc.interfaces.ECDSAPrivateKey;
import iaik.security.ecc.interfaces.ECDSAPublicKey;
import iaik.security.ecc.math.ecgroup.CoordinateTypes;
import iaik.security.ecc.math.ecgroup.ECGroupException;
import iaik.security.ecc.math.ecgroup.ECPoint;
import iaik.security.ecc.parameter.ECCParameterFactory;
import iaik.security.ecc.spec.ECCParameterSpec;
import iaik.security.ecc.spec.ECDSAPrivateKeySpec;
import iaik.utils.InternalErrorException;
import java.io.IOException;
import java.io.InputStream;
import java.math.BigInteger;
import java.security.InvalidKeyException;

public class ECPrivateKey
extends PrivateKeyInfo
implements ECDSAPrivateKey {
    private ECPoint w_;
    private BigInteger s_;
    private transient ASN1 privateKey_;
    private ECDSAParameter p_;
    protected static final String ALGORITHM = "ECDSA";
    public static final ObjectID OID;
    public static final INTEGER EC_PRIVATE_KEY_VERSION;

    static {
        EC_PRIVATE_KEY_VERSION = new INTEGER(1);
        OID = new ObjectID("1.2.840.10045.2.1");
    }

    private void createECDSAPrivateKey() {
        try {
            SEQUENCE sEQUENCE = new SEQUENCE();
            sEQUENCE.addComponent((ASN1Object)EC_PRIVATE_KEY_VERSION);
            sEQUENCE.addComponent((ASN1Object)new OCTET_STRING(this.s_.toByteArray()));
            if (this.w_ != null) {
                BIT_STRING bIT_STRING = new BIT_STRING((byte[])this.w_.toASN1Object().getValue());
                CON_SPEC cON_SPEC = new CON_SPEC(1, (ASN1Object)bIT_STRING);
                sEQUENCE.addComponent((ASN1Object)cON_SPEC);
            }
            this.privateKey_ = new ASN1((ASN1Object)sEQUENCE);
            this.private_key_algorithm = new AlgorithmID(OID, this.p_.toASN1Object());
        }
        catch (Exception exception) {
            throw new InternalErrorException(exception);
        }
        this.createPrivateKeyInfo();
    }

    protected byte[] encode() {
        return this.privateKey_.toByteArray();
    }

    public String toString() {
        String string = "ECDSA Private Key: " + this.s_.toString() + "\nDomain Parameter: " + this.p_.toString() + "\n";
        if (this.w_ != null) {
            string = string + "\nPublic Key: " + this.w_.toString();
        }
        return string;
    }

    public BigInteger getS() {
        return this.s_;
    }

    public ECDSAPublicKey getPublicKey() {
        return new ECPublicKey(this.p_, this.w_);
    }

    public ECDSAParams getParameter() {
        return this.p_;
    }

    public String getAlgorithm() {
        return ALGORITHM;
    }

    public void decode(byte[] byArray) throws InvalidKeyException {
        block11: {
            try {
                this.privateKey_ = new ASN1(byArray);
            }
            catch (Exception exception) {
                throw new InvalidKeyException(exception.toString());
            }
            ASN1Object aSN1Object = this.private_key_algorithm.getParameter();
            if (aSN1Object == null) {
                throw new InvalidKeyException("No ECDSA Private Key: NoParameters specified");
            }
            try {
                ECCParameterSpec eCCParameterSpec;
                ObjectID objectID;
                if (aSN1Object.isA(ASN.ObjectID)) {
                    objectID = (ObjectID)aSN1Object;
                    eCCParameterSpec = ECCParameterFactory.getInstance().getParameterByOID((String)objectID.getValue());
                    if (eCCParameterSpec == null) {
                        throw new InvalidKeyException("Unknown parameter oid " + objectID.toString());
                    }
                    this.p_ = new ECDSAParameter(eCCParameterSpec, CoordinateTypes.getDefaultCoordinates(eCCParameterSpec.getA().getField().getFieldId()));
                } else {
                    this.p_ = new ECDSAParameter(aSN1Object);
                }
                objectID = (SEQUENCE)this.privateKey_.toASN1Object();
                eCCParameterSpec = (INTEGER)objectID.getComponentAt(0);
                if (!((BigInteger)eCCParameterSpec.getValue()).equals((BigInteger)EC_PRIVATE_KEY_VERSION.getValue())) {
                    throw new InvalidKeyException("Wront private key version nummer");
                }
                OCTET_STRING oCTET_STRING = (OCTET_STRING)objectID.getComponentAt(1);
                this.s_ = new BigInteger((byte[])oCTET_STRING.getValue());
                if (objectID.countComponents() != 3) break block11;
                CON_SPEC cON_SPEC = (CON_SPEC)objectID.getComponentAt(2);
                int n = cON_SPEC.getAsnType().getTag();
                if (n == 1) {
                    BIT_STRING bIT_STRING = (BIT_STRING)cON_SPEC.getValue();
                    this.w_ = new ECPoint((byte[])bIT_STRING.getValue(), this.p_.getG().getCurve());
                    break block11;
                }
                throw new InvalidKeyException("Parameters mustn't be defined in the privateKey section");
            }
            catch (ECGroupException eCGroupException) {
                throw new InvalidKeyException(eCGroupException.toString());
            }
            catch (Throwable throwable) {
                throw new InvalidKeyException(throwable.toString());
            }
        }
    }

    public ECPrivateKey(InputStream inputStream) throws IOException, InvalidKeyException {
        super(inputStream);
    }

    public ECPrivateKey(ECDSAPrivateKeySpec eCDSAPrivateKeySpec) {
        this.p_ = new ECDSAParameter(eCDSAPrivateKeySpec.getG(), eCDSAPrivateKeySpec.getR(), eCDSAPrivateKeySpec.getK());
        this.s_ = eCDSAPrivateKeySpec.getS();
        this.w_ = null;
        this.createECDSAPrivateKey();
    }

    public ECPrivateKey(ECDSAParameter eCDSAParameter, BigInteger bigInteger, ECPoint eCPoint) {
        this.p_ = eCDSAParameter;
        this.s_ = bigInteger;
        this.w_ = eCPoint;
        this.createECDSAPrivateKey();
    }

    public ECPrivateKey(byte[] byArray) throws InvalidKeyException {
        super(byArray);
    }
}

