/*
 * Decompiled with CFR 0.152.
 */
package iaik.pkcs.pkcs12;

import iaik.asn1.ASN1Object;
import iaik.asn1.CodingException;
import iaik.asn1.structures.AlgorithmID;
import iaik.pkcs.PKCSException;
import iaik.pkcs.pkcs12.Attributes;
import iaik.pkcs.pkcs12.AuthenticatedSafe;
import iaik.pkcs.pkcs12.CertificateBag;
import iaik.pkcs.pkcs12.KeyBag;
import iaik.pkcs.pkcs12.PKCS12;
import iaik.pkcs.pkcs12.PKCS8ShroudedKeyBag;
import iaik.pkcs.pkcs12.a;
import iaik.pkcs.pkcs8.EncryptedPrivateKeyInfo;
import iaik.utils.CryptoUtils;
import iaik.utils.Util;
import iaik.x509.X509Certificate;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.security.GeneralSecurityException;
import java.security.InvalidKeyException;
import java.security.Key;
import java.security.KeyStoreException;
import java.security.KeyStoreSpi;
import java.security.NoSuchAlgorithmException;
import java.security.Principal;
import java.security.PrivateKey;
import java.security.ProviderException;
import java.security.UnrecoverableKeyException;
import java.security.cert.Certificate;
import java.security.cert.CertificateException;
import java.util.Date;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;

public class PKCS12KeyStore
extends KeyStoreSpi {
    private Hashtable a = new Hashtable();

    public void engineStore(OutputStream outputStream, char[] cArray) throws CertificateException, NoSuchAlgorithmException, IOException {
        Object object;
        Object[] objectArray;
        Object[] objectArray2;
        Vector<PKCS8ShroudedKeyBag> vector = new Vector<PKCS8ShroudedKeyBag>(2);
        Vector<CertificateBag> vector2 = new Vector<CertificateBag>(4);
        Enumeration enumeration = this.a.keys();
        while (enumeration.hasMoreElements()) {
            objectArray2 = (String)enumeration.nextElement();
            objectArray = (Object[])this.a.get(objectArray2);
            object = objectArray.getKeyBag();
            vector.addElement((PKCS8ShroudedKeyBag)object);
            X509Certificate[] x509CertificateArray = objectArray.getCertificates();
            CertificateBag certificateBag = new CertificateBag(x509CertificateArray[0], (String)objectArray2, objectArray.getKeyID());
            vector2.addElement(certificateBag);
            int n2 = 1;
            while (n2 < x509CertificateArray.length) {
                certificateBag = new CertificateBag(x509CertificateArray[n2]);
                vector2.addElement(certificateBag);
                ++n2;
            }
        }
        objectArray2 = new KeyBag[vector.size()];
        vector.copyInto(objectArray2);
        objectArray = new CertificateBag[vector2.size()];
        vector2.copyInto(objectArray);
        try {
            object = new PKCS12((KeyBag[])objectArray2, (CertificateBag[])objectArray, true);
            ((PKCS12)object).encrypt(cArray);
            ((PKCS12)object).toASN1Object();
            ((PKCS12)object).writeTo(outputStream);
            return;
        }
        catch (PKCSException pKCSException) {
            throw new CertificateException(pKCSException.toString());
        }
    }

    public int engineSize() {
        return this.a.size();
    }

    public void engineSetKeyEntry(String string, byte[] byArray, Certificate[] certificateArray) throws KeyStoreException {
        X509Certificate[] x509CertificateArray;
        PKCS8ShroudedKeyBag pKCS8ShroudedKeyBag;
        Object object;
        if (string == null) {
            throw new NullPointerException("alias must not be null");
        }
        if (byArray == null) {
            throw new NullPointerException("key must not be null");
        }
        if (certificateArray == null) {
            throw new NullPointerException("chain must not be null");
        }
        byte[] byArray2 = this.a();
        try {
            object = new EncryptedPrivateKeyInfo(byArray);
            ASN1Object aSN1Object = ((EncryptedPrivateKeyInfo)object).toASN1Object();
            pKCS8ShroudedKeyBag = new PKCS8ShroudedKeyBag();
            pKCS8ShroudedKeyBag.decode(aSN1Object);
            pKCS8ShroudedKeyBag.setFriendlyName(string);
            pKCS8ShroudedKeyBag.setLocalKeyID(byArray2);
            x509CertificateArray = Util.convertCertificateChain(certificateArray);
        }
        catch (InvalidKeyException invalidKeyException) {
            throw new KeyStoreException(invalidKeyException.toString());
        }
        catch (CodingException codingException) {
            throw new KeyStoreException(codingException.toString());
        }
        catch (CertificateException certificateException) {
            throw new KeyStoreException(certificateException.toString());
        }
        object = new a(pKCS8ShroudedKeyBag, x509CertificateArray, byArray2);
        this.a.put(string, object);
    }

    public void engineSetKeyEntry(String string, Key key, char[] cArray, Certificate[] certificateArray) throws KeyStoreException {
        X509Certificate[] x509CertificateArray;
        PKCS8ShroudedKeyBag pKCS8ShroudedKeyBag;
        Object object;
        if (string == null) {
            throw new NullPointerException("alias must not be null!");
        }
        if (key == null) {
            throw new NullPointerException("key must not be null!");
        }
        if (certificateArray == null) {
            throw new NullPointerException("chain must not be null!");
        }
        byte[] byArray = this.a();
        try {
            object = new KeyBag((PrivateKey)key, string, byArray);
            ((Attributes)object).setLocalKeyID(byArray);
            pKCS8ShroudedKeyBag = new PKCS8ShroudedKeyBag((KeyBag)object);
            pKCS8ShroudedKeyBag.encrypt(cArray, (AlgorithmID)AlgorithmID.pbeWithSHAAnd3_KeyTripleDES_CBC.clone(), 2000);
            x509CertificateArray = Util.convertCertificateChain(certificateArray);
        }
        catch (NoSuchAlgorithmException noSuchAlgorithmException) {
            throw new KeyStoreException(noSuchAlgorithmException.toString());
        }
        catch (CertificateException certificateException) {
            throw new KeyStoreException(certificateException.toString());
        }
        object = new a(pKCS8ShroudedKeyBag, x509CertificateArray, byArray);
        this.a.put(string, object);
    }

    public void engineSetCertificateEntry(String string, Certificate certificate) throws KeyStoreException {
    }

    public void engineLoad(InputStream inputStream, char[] cArray) throws CertificateException, NoSuchAlgorithmException, IOException {
        if (inputStream != null) {
            Certificate[] certificateArray;
            Object[] objectArray;
            PKCS12 pKCS12;
            try {
                pKCS12 = new PKCS12(inputStream);
                if (!pKCS12.verify(cArray)) {
                    throw new IOException("PKCS12 verification error, incorrect password");
                }
            }
            catch (PKCSException pKCSException) {
                throw new IOException(pKCSException.toString());
            }
            AuthenticatedSafe[] authenticatedSafeArray = pKCS12.getAuthenticatedSafes();
            Vector<Object> vector = new Vector<Object>();
            Vector<Object> vector2 = new Vector<Object>();
            int n2 = 0;
            while (n2 < authenticatedSafeArray.length) {
                int n3;
                if (authenticatedSafeArray[n2].a() == 2) {
                    try {
                        authenticatedSafeArray[n2].decrypt(cArray);
                    }
                    catch (Exception exception) {
                        throw new CertificateException("Decryption error: " + exception.toString());
                    }
                    objectArray = authenticatedSafeArray[n2].getSafeBags();
                    n3 = 0;
                    while (n3 < objectArray.length) {
                        if (objectArray[n3] instanceof CertificateBag) {
                            vector2.addElement(objectArray[n3]);
                        } else if (objectArray[n3] instanceof PKCS8ShroudedKeyBag) {
                            try {
                                ((PKCS8ShroudedKeyBag)objectArray[n3]).decrypt(cArray);
                                certificateArray = ((PKCS8ShroudedKeyBag)objectArray[n3]).toASN1Object();
                                PKCS8ShroudedKeyBag pKCS8ShroudedKeyBag = new PKCS8ShroudedKeyBag();
                                pKCS8ShroudedKeyBag.decode((ASN1Object)certificateArray);
                                pKCS8ShroudedKeyBag.setFriendlyName(((Attributes)objectArray[n3]).getFriendlyName());
                                pKCS8ShroudedKeyBag.setLocalKeyID(((Attributes)objectArray[n3]).getLocalKeyID());
                                vector.addElement(pKCS8ShroudedKeyBag);
                            }
                            catch (CodingException codingException) {
                                throw new CertificateException(codingException.toString());
                            }
                            catch (GeneralSecurityException generalSecurityException) {
                                throw new CertificateException(generalSecurityException.toString());
                            }
                        }
                        ++n3;
                    }
                } else {
                    objectArray = authenticatedSafeArray[n2].getSafeBags();
                    n3 = 0;
                    while (n3 < objectArray.length) {
                        if (objectArray[n3] instanceof PKCS8ShroudedKeyBag) {
                            vector.addElement(objectArray[n3]);
                        }
                        ++n3;
                    }
                }
                ++n2;
            }
            objectArray = new PKCS8ShroudedKeyBag[vector.size()];
            vector.copyInto(objectArray);
            Object[] objectArray2 = new CertificateBag[vector2.size()];
            vector2.copyInto(objectArray2);
            certificateArray = CertificateBag.getCertificates((CertificateBag[])objectArray2);
            int n4 = 0;
            while (n4 < objectArray.length) {
                Object object;
                byte[] byArray;
                X509Certificate x509Certificate;
                Object object2;
                Object object3;
                block31: {
                    object3 = objectArray[n4];
                    object2 = null;
                    x509Certificate = null;
                    byArray = ((Attributes)object3).getLocalKeyID();
                    try {
                        if (byArray != null) {
                            int n5 = 0;
                            while (n5 < objectArray2.length) {
                                object = ((Attributes)objectArray2[n5]).getLocalKeyID();
                                if (object != null && CryptoUtils.equalsBlock(object, byArray)) {
                                    object2 = objectArray2[n5];
                                    x509Certificate = ((CertificateBag)object2).getCertificate();
                                    break block31;
                                }
                                ++n5;
                            }
                            break block31;
                        }
                        throw new Exception("No localKeyID defined");
                    }
                    catch (Exception exception) {
                        throw new CertificateException(exception.toString());
                    }
                }
                X509Certificate[] x509CertificateArray = null;
                if (x509Certificate != null) {
                    x509CertificateArray = Util.createCertificateChain(x509Certificate, certificateArray);
                }
                object = new a((PKCS8ShroudedKeyBag)object3, x509CertificateArray, byArray);
                String string = ((Attributes)object3).getFriendlyName();
                if (string == null && object2 != null) {
                    Principal principal;
                    String string2 = ((Attributes)object2).getFriendlyName();
                    if (string2 != null) {
                        string = string2;
                    } else if (x509Certificate != null && (principal = x509Certificate.getSubjectDN()) != null) {
                        string = principal.getName();
                    }
                }
                if (string == null || this.a.containsKey(string)) {
                    string = Integer.toString(n4);
                    int n6 = n4;
                    while (this.a.containsKey(string) && n6 < Integer.MAX_VALUE) {
                        string = Integer.toString(n6);
                        ++n6;
                    }
                }
                this.a.put(string, object);
                ++n4;
            }
        }
    }

    public boolean engineIsKeyEntry(String string) {
        if (string != null) {
            return this.a.containsKey(string);
        }
        return false;
    }

    public boolean engineIsCertificateEntry(String string) {
        return false;
    }

    public Key engineGetKey(String string, char[] cArray) throws UnrecoverableKeyException, NoSuchAlgorithmException {
        if (this.engineContainsAlias(string)) {
            a a2 = (a)this.a.get(string);
            PrivateKey privateKey = null;
            try {
                PKCS8ShroudedKeyBag pKCS8ShroudedKeyBag = a2.getKeyBag();
                ASN1Object aSN1Object = pKCS8ShroudedKeyBag.toASN1Object();
                PKCS8ShroudedKeyBag pKCS8ShroudedKeyBag2 = new PKCS8ShroudedKeyBag();
                pKCS8ShroudedKeyBag2.decode(aSN1Object);
                pKCS8ShroudedKeyBag2.decrypt(cArray);
                privateKey = pKCS8ShroudedKeyBag2.getPrivateKey();
                if (privateKey != null) {
                    return privateKey;
                }
                return null;
            }
            catch (GeneralSecurityException generalSecurityException) {
                throw new UnrecoverableKeyException(generalSecurityException.toString());
            }
            catch (CodingException codingException) {
                throw new UnrecoverableKeyException(codingException.toString());
            }
        }
        return null;
    }

    public Date engineGetCreationDate(String string) {
        block4: {
            if (this.engineContainsAlias(string)) {
                a a2 = (a)this.a.get(string);
                byte[] byArray = a2.getKeyID();
                try {
                    String string2 = new String(byArray, "ASCII");
                    return new Date(Long.parseLong(string2));
                }
                catch (UnsupportedEncodingException unsupportedEncodingException) {
                    throw new ProviderException(unsupportedEncodingException.toString());
                }
                catch (NumberFormatException numberFormatException) {
                    X509Certificate[] x509CertificateArray = a2.getCertificates();
                    if (x509CertificateArray == null || x509CertificateArray.length <= 0) break block4;
                    Date date = x509CertificateArray[0].getNotBefore();
                    return date;
                }
            }
        }
        return null;
    }

    public Certificate[] engineGetCertificateChain(String string) {
        if (this.engineContainsAlias(string)) {
            a a2 = (a)this.a.get(string);
            return a2.getCertificates();
        }
        return null;
    }

    public String engineGetCertificateAlias(Certificate certificate) {
        Enumeration enumeration = this.a.keys();
        while (enumeration.hasMoreElements()) {
            String string = (String)enumeration.nextElement();
            Certificate[] certificateArray = this.engineGetCertificateChain(string);
            if (certificateArray.length <= 0 || !certificateArray[0].equals(certificate)) continue;
            return string;
        }
        return null;
    }

    public Certificate engineGetCertificate(String string) {
        Certificate[] certificateArray = this.engineGetCertificateChain(string);
        if (certificateArray != null) {
            return certificateArray[0];
        }
        return null;
    }

    public void engineDeleteEntry(String string) throws KeyStoreException {
        if (string != null) {
            this.a.remove(string);
        }
    }

    public boolean engineContainsAlias(String string) {
        if (string != null) {
            return this.a.containsKey(string);
        }
        return false;
    }

    public Enumeration engineAliases() {
        return this.a.keys();
    }

    private byte[] a() throws KeyStoreException {
        try {
            long l2 = new Date().getTime();
            String string = Long.toString(l2);
            return string.getBytes("ASCII");
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            throw new KeyStoreException(unsupportedEncodingException.toString());
        }
    }
}

