/*
 * Decompiled with CFR 0.152.
 */
package com.sun.javaws.ui;

import com.sun.deploy.Environment;
import com.sun.deploy.cache.Cache;
import com.sun.deploy.config.Config;
import com.sun.deploy.config.JREInfo;
import com.sun.deploy.config.SecuritySettings;
import com.sun.deploy.model.LocalApplicationProperties;
import com.sun.deploy.net.DownloadEngine;
import com.sun.deploy.resources.ResourceManager;
import com.sun.deploy.trace.Trace;
import com.sun.deploy.trace.TraceLevel;
import com.sun.deploy.ui.AppInfo;
import com.sun.deploy.uitoolkit.ToolkitStore;
import com.sun.deploy.uitoolkit.ui.UIFactory;
import com.sun.deploy.util.SecurityBaseline;
import com.sun.deploy.util.VersionID;
import com.sun.javaws.JnlpxArgs;
import com.sun.javaws.exceptions.ExitException;
import com.sun.javaws.jnl.JREDesc;
import com.sun.javaws.jnl.JavaFXRuntimeDesc;
import com.sun.javaws.jnl.LaunchDesc;
import com.sun.javaws.ui.AutoDownloadPrompt;
import com.sun.javaws.util.JfxHelper;
import java.awt.Component;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;

public class SecureStaticVersioning {
    private static final String SSV2VERSION_KEY = "ssv.version.allowed";
    private static final String SSV2LATEST_VALUE = "ssv.latest.allowed";
    private static final String EXPIRED_VERSION_KEY = "ssv.expired.allowed";
    private static final String UNTRUSTED_KEY = "ssv.untrusted.allowed";
    private static final String RUNLOCAL_KEY = "ssv.run.local.allowed";
    private static final int REASON_CONFIG = 0;
    private static final int REASON_UNSIGNED = 1;
    private static final int REASON_UNAVAIL = 2;
    private static final int REASON_FX = 3;
    private static final int REASON_INVALID = 4;

    private static boolean promptDownload(Object object, LaunchDesc launchDesc, LocalApplicationProperties localApplicationProperties, String string, String string2) {
        String string3 = ResourceManager.getString((String)"deployment.ssv.title");
        String string4 = ResourceManager.getString((String)"deployment.ssv.download.masthead");
        String string5 = ResourceManager.getString((String)"deployment.ssv.download.bullet", (String)string, (String)string2);
        String string6 = ResourceManager.getString((String)"deployment.ssv.download.button");
        String string7 = ResourceManager.getString((String)"common.cancel_btn");
        UIFactory uIFactory = ToolkitStore.getUI();
        AppInfo appInfo = launchDesc.getAppInfo();
        ToolkitStore.getUI();
        int n = uIFactory.showMessageDialog(object, appInfo, 3, string3, null, string4, string5, string6, string7, null);
        ToolkitStore.getUI();
        if (n == 0) {
            if (localApplicationProperties != null) {
                localApplicationProperties.put(SSV2VERSION_KEY, string);
                try {
                    localApplicationProperties.store();
                }
                catch (IOException iOException) {
                    Trace.ignoredException((Exception)iOException);
                }
            }
            return true;
        }
        return false;
    }

    public static boolean promptUse(Component component, AppInfo appInfo, LocalApplicationProperties localApplicationProperties, String string) throws ExitException {
        if (SecuritySettings.isSSVModeNever()) {
            return false;
        }
        if (localApplicationProperties != null && SSV2LATEST_VALUE.equals(localApplicationProperties.get(SSV2VERSION_KEY))) {
            return false;
        }
        if (SecureStaticVersioning.showSSV2Dialog(component, appInfo, string)) {
            if (localApplicationProperties != null) {
                localApplicationProperties.put(SSV2VERSION_KEY, string);
                try {
                    localApplicationProperties.store();
                }
                catch (IOException iOException) {
                    Trace.ignoredException((Exception)iOException);
                }
            }
            return true;
        }
        if (localApplicationProperties != null) {
            localApplicationProperties.put(SSV2VERSION_KEY, SSV2LATEST_VALUE);
            try {
                localApplicationProperties.store();
            }
            catch (IOException iOException) {
                Trace.ignoredException((Exception)iOException);
            }
        }
        return false;
    }

    public static boolean promptRequired(LaunchDesc launchDesc, LocalApplicationProperties localApplicationProperties, boolean bl, String string) {
        if (launchDesc.getSecurityModel() != 0 || !SecureStaticVersioning.isOlderVersion(string) || SecuritySettings.isSSVModeAlways() || SecurityBaseline.satisfiesSecurityBaseline((String)string)) {
            return false;
        }
        if (bl) {
            return true;
        }
        return localApplicationProperties == null || !string.equals(localApplicationProperties.get(SSV2VERSION_KEY));
    }

    public static boolean canAutoDownload(LaunchDesc launchDesc, JREDesc jREDesc, boolean bl) throws ExitException {
        Object object;
        boolean bl2;
        LocalApplicationProperties localApplicationProperties = Cache.getLocalApplicationProperties((URL)launchDesc.getCanonicalHome());
        String string = Config.getStringProperty((String)"deployment.javaws.autodownload");
        if (bl || string != null && string.equalsIgnoreCase("NEVER")) {
            SecureStaticVersioning.showCannotUseDialog(null, launchDesc.getAppInfo(), localApplicationProperties, jREDesc.getVersion(), 0);
            return false;
        }
        if (launchDesc.getSecurityModel() == 0 && SecuritySettings.isSSVModeNever()) {
            return false;
        }
        String string2 = jREDesc.getSource();
        URL uRL = jREDesc.getHref();
        boolean bl3 = bl2 = uRL == null;
        if (bl2) {
            object = Config.getStringProperty((String)"deployment.javaws.installURL");
            try {
                uRL = new URL((String)object);
            }
            catch (MalformedURLException malformedURLException) {
                throw new ExitException(malformedURLException, 3);
            }
        }
        object = launchDesc.getJavaFXRuntimeDescriptor();
        String string3 = DownloadEngine.getAvailableVersion((URL)uRL, (String)jREDesc.getVersion(), (boolean)bl2, (String)JREInfo.getKnownPlatforms(), (String)(object == null ? null : ((JavaFXRuntimeDesc)object).getVersion()));
        if (string3 != null) {
            JREInfo[] jREInfoArray = JREInfo.getAll();
            for (int i = 0; i < jREInfoArray.length; ++i) {
                if (!jREInfoArray[i].getProductVersion().equals((Object)new VersionID(string3))) continue;
                Trace.println((String)("JRE " + string3 + " is already installed " + "in local system, should not auto-install it again"), (TraceLevel)TraceLevel.EXTENSIONS);
                string3 = null;
                break;
            }
        }
        if (string3 != null) {
            if (launchDesc.getSecurityModel() == 0 && !SecurityBaseline.satisfiesSecurityBaseline((String)string3)) {
                string3 = null;
            }
        }
        if (string3 == null) {
            SecureStaticVersioning.showCannotUseDialog(null, launchDesc.getAppInfo(), localApplicationProperties, jREDesc.getVersion(), 2);
            return false;
        }
        if (SecureStaticVersioning.promptRequired(launchDesc, localApplicationProperties, true, string3)) {
            if (!SecureStaticVersioning.promptDownload(null, launchDesc, localApplicationProperties, string3, string2)) {
                return false;
            }
        } else if (string != null && string.equalsIgnoreCase("PROMPT") && !AutoDownloadPrompt.prompt(null, launchDesc)) {
            SecureStaticVersioning.showCannotUseDialog(null, launchDesc.getAppInfo(), localApplicationProperties, jREDesc.getVersion(), 0);
            return false;
        }
        return true;
    }

    public static boolean canUse(LaunchDesc launchDesc, String string) throws ExitException {
        LocalApplicationProperties localApplicationProperties = Cache.getLocalApplicationProperties((URL)launchDesc.getCanonicalHome());
        if (launchDesc.needFX() && !JfxHelper.isCompatibleRuntime(launchDesc.getHomeJRE(), launchDesc.getSelectedJRE())) {
            SecureStaticVersioning.showCannotUseDialog(null, launchDesc.getAppInfo(), localApplicationProperties, string, 3);
            return false;
        }
        if (JnlpxArgs.getIsRelaunch() && !string.equals(launchDesc.getSelectedJRE().getProduct())) {
            return false;
        }
        if (SecureStaticVersioning.promptRequired(launchDesc, localApplicationProperties, false, string)) {
            return SecureStaticVersioning.promptUse(null, launchDesc.getAppInfo(), localApplicationProperties, string);
        }
        return true;
    }

    public static boolean canUse(AppInfo appInfo, String string) throws ExitException {
        if (!SecureStaticVersioning.isOlderVersion(string) || SecuritySettings.isSSVModeAlways() || SecurityBaseline.satisfiesSecurityBaseline((String)string)) {
            return true;
        }
        LocalApplicationProperties localApplicationProperties = null;
        try {
            URL uRL = new URL(appInfo.getFrom().toString() + "/" + appInfo.getTitle());
            localApplicationProperties = Cache.getLocalApplicationProperties((URL)uRL);
        }
        catch (IOException iOException) {
            Trace.ignored((Throwable)iOException);
        }
        if (localApplicationProperties != null && string.equals(localApplicationProperties.get(SSV2VERSION_KEY))) {
            return true;
        }
        return SecureStaticVersioning.promptUse(null, appInfo, localApplicationProperties, string);
    }

    public static void resetAcceptedVersion(URL uRL) {
        LocalApplicationProperties localApplicationProperties = Cache.getLocalApplicationProperties((URL)uRL);
        if (localApplicationProperties != null) {
            localApplicationProperties.put(SSV2VERSION_KEY, null);
            localApplicationProperties.put(EXPIRED_VERSION_KEY, null);
            try {
                localApplicationProperties.store();
            }
            catch (IOException iOException) {
                Trace.ignoredException((Exception)iOException);
            }
        }
    }

    private static boolean isOlderVersion(String string) {
        VersionID versionID;
        VersionID versionID2 = new VersionID(SecurityBaseline.getCurrentVersion() + "+");
        return !versionID2.match(versionID = new VersionID(string));
    }

    private static LocalApplicationProperties getLap(LaunchDesc launchDesc, AppInfo appInfo) {
        LocalApplicationProperties localApplicationProperties = null;
        if (launchDesc == null) {
            try {
                URL uRL = new URL(appInfo.getFrom().toString() + "/" + appInfo.getTitle());
                localApplicationProperties = Cache.getLocalApplicationProperties((URL)uRL);
            }
            catch (IOException iOException) {
                Trace.ignored((Throwable)iOException);
            }
        } else {
            localApplicationProperties = Cache.getLocalApplicationProperties((URL)launchDesc.getCanonicalHome());
        }
        return localApplicationProperties;
    }

    public static void checkSecuritySettings(LaunchDesc launchDesc, AppInfo appInfo) throws ExitException {
        if (launchDesc != null && !launchDesc.isSecure()) {
            return;
        }
        if (JnlpxArgs.getIsRelaunch() && !Environment.isJavawsAppletLifecycle()) {
            return;
        }
        if (!Environment.isWebJava()) {
            return;
        }
        if (SecurityBaseline.isExpired()) {
            SecureStaticVersioning.checkRunExpired(launchDesc, appInfo);
        } else {
            SecureStaticVersioning.checkRunUntrusted(launchDesc, appInfo);
        }
    }

    private static void checkRunUntrusted(LaunchDesc launchDesc, AppInfo appInfo) throws ExitException {
        if (SecuritySettings.isRunUntrustedAlways()) {
            SecureStaticVersioning.checkRunLocal(launchDesc, appInfo);
            return;
        }
        if (SecuritySettings.isRunUntrustedNever()) {
            SecureStaticVersioning.showBlockedDialog(launchDesc, appInfo, "deployment.run.untrusted.never.text");
        }
        String string = JREInfo.getLatest();
        LocalApplicationProperties localApplicationProperties = SecureStaticVersioning.getLap(launchDesc, appInfo);
        if (string != null && localApplicationProperties != null && string.equals(localApplicationProperties.get(UNTRUSTED_KEY))) {
            return;
        }
        if (SecureStaticVersioning.showUntrustedDialog(appInfo) && localApplicationProperties != null && string != null) {
            localApplicationProperties.put(UNTRUSTED_KEY, string);
            try {
                localApplicationProperties.store();
            }
            catch (IOException iOException) {
                Trace.ignoredException((Exception)iOException);
            }
        }
    }

    private static void checkRunExpired(LaunchDesc launchDesc, AppInfo appInfo) throws ExitException {
        if (SecuritySettings.isSSVModeAlways()) {
            SecureStaticVersioning.checkRunLocal(launchDesc, appInfo);
            return;
        }
        if (SecuritySettings.isSSVModeNever()) {
            SecureStaticVersioning.showBlockedDialog(launchDesc, appInfo, "deployment.ssv2.mode.never.text");
        }
        String string = JREInfo.getLatest();
        LocalApplicationProperties localApplicationProperties = SecureStaticVersioning.getLap(launchDesc, appInfo);
        if (string != null && localApplicationProperties != null && string.equals(localApplicationProperties.get(EXPIRED_VERSION_KEY))) {
            return;
        }
        if (SecureStaticVersioning.showExpiredDialog(appInfo, string) && localApplicationProperties != null && string != null) {
            localApplicationProperties.put(EXPIRED_VERSION_KEY, string);
            try {
                localApplicationProperties.store();
            }
            catch (IOException iOException) {
                Trace.ignoredException((Exception)iOException);
            }
        }
    }

    private static void checkRunLocal(LaunchDesc launchDesc, AppInfo appInfo) throws ExitException {
        if (!SecureStaticVersioning.isLocalApp(appInfo)) {
            return;
        }
        if (SecuritySettings.isRunLocalAppletsAlways()) {
            return;
        }
        if (SecuritySettings.isRunLocalAppletsNever()) {
            SecureStaticVersioning.showBlockedDialog(launchDesc, appInfo, "deployment.local.applet.never.text");
            return;
        }
        String string = JREInfo.getLatest();
        LocalApplicationProperties localApplicationProperties = SecureStaticVersioning.getLap(launchDesc, appInfo);
        if (string != null && localApplicationProperties != null && string.equals(localApplicationProperties.get(RUNLOCAL_KEY))) {
            return;
        }
        if (SecureStaticVersioning.showUntrustedDialog(appInfo) && localApplicationProperties != null && string != null) {
            localApplicationProperties.put(RUNLOCAL_KEY, string);
            try {
                localApplicationProperties.store();
            }
            catch (IOException iOException) {
                Trace.ignoredException((Exception)iOException);
            }
        }
    }

    private static boolean isLocalApp(AppInfo appInfo) {
        URL uRL = appInfo.getFrom();
        return uRL != null && uRL.getProtocol().equals("file");
    }

    private static boolean showSSV2Dialog(Component component, AppInfo appInfo, String string) throws ExitException {
        String string2 = ResourceManager.getString((String)"deployment.ssv2.title");
        String string3 = ResourceManager.getString((String)"deployment.ssv2.masthead");
        String string4 = ResourceManager.getString((String)"deployment.ssv2.risk");
        String string5 = ResourceManager.getString((String)"deployment.ssv2.moreText");
        URL uRL = null;
        try {
            uRL = new URL("http://java.com/access_old_java");
        }
        catch (Exception exception) {
            // empty catch block
        }
        String string6 = ResourceManager.getString((String)"deployment.ssv2.choice");
        String string7 = ResourceManager.getString((String)"deployment.ssv2.choice1");
        String string8 = ResourceManager.getString((String)"deployment.ssv2.choice2", (String)string);
        String string9 = ResourceManager.getString((String)"deployment.ssv2.run.button");
        String string10 = ResourceManager.getString((String)"common.cancel_btn");
        int n = ToolkitStore.getUI().showSSVDialog((Object)component, appInfo, string2, string3, string4, string5, uRL, string6, string7, string8, string9, string10);
        ToolkitStore.getUI();
        if (n == 0) {
            return true;
        }
        ToolkitStore.getUI();
        if (n == 2) {
            return false;
        }
        throw new ExitException(null, 0);
    }

    private static void showCannotUseDialog(Component component, AppInfo appInfo, LocalApplicationProperties localApplicationProperties, String string, int n) throws ExitException {
        if (localApplicationProperties != null && SSV2LATEST_VALUE.equals(localApplicationProperties.get(SSV2VERSION_KEY))) {
            return;
        }
        String string2 = ResourceManager.getString((String)"deployment.ssv2.nodl.title");
        String string3 = null;
        switch (n) {
            case 3: {
                string3 = "deployment.ssv2.nodl.fx";
                break;
            }
            case 4: {
                string3 = "deployment.ssv2.nodl.invalid";
                break;
            }
            default: {
                string3 = "deployment.ssv2.nodl.masthead";
            }
        }
        String string4 = ResourceManager.getString((String)string3, (String)string);
        String string5 = ResourceManager.getString((String)"deployment.ssv2.nodl.button");
        String string6 = ResourceManager.getString((String)"common.cancel_btn");
        String string7 = ResourceManager.getString((String)"deployment.ssv2.moreText");
        URL uRL = null;
        try {
            uRL = new URL("http://java.com/access_old_java");
        }
        catch (Exception exception) {
            // empty catch block
        }
        UIFactory uIFactory = ToolkitStore.getUI();
        ToolkitStore.getUI();
        int n2 = uIFactory.showMessageDialog((Object)component, appInfo, 2, string2, string4, null, null, string5, string6, null, uRL, string7);
        ToolkitStore.getUI();
        if (n2 != 0) {
            throw new ExitException(null, 0);
        }
        if (localApplicationProperties != null) {
            localApplicationProperties.put(SSV2VERSION_KEY, SSV2LATEST_VALUE);
            try {
                localApplicationProperties.store();
            }
            catch (IOException iOException) {
                Trace.ignoredException((Exception)iOException);
            }
        }
    }

    public static void showNoCanDo(AppInfo appInfo, String string) throws ExitException {
        if (SecuritySettings.isSSVModeNever()) {
            return;
        }
        LocalApplicationProperties localApplicationProperties = null;
        try {
            URL uRL = new URL(appInfo.getFrom().toString() + "/" + appInfo.getTitle());
            localApplicationProperties = Cache.getLocalApplicationProperties((URL)uRL);
        }
        catch (IOException iOException) {
            Trace.ignored((Throwable)iOException);
        }
        SecureStaticVersioning.showCannotUseDialog(null, appInfo, localApplicationProperties, string, 2);
    }

    private static boolean showUntrustedDialog(AppInfo appInfo) throws ExitException {
        String string = ResourceManager.getString((String)"deployment.ssv.title");
        String string2 = ResourceManager.getString((String)"deployment.ssv.masthead");
        String string3 = ResourceManager.getString((String)"deployment.ssv.untrusted.main");
        String string4 = ResourceManager.getString((String)"deployment.ssv.localapp.main");
        String string5 = ResourceManager.getString((String)"deployment.ssv.location");
        Object var6_6 = null;
        String string6 = ResourceManager.getString((String)"deployment.ssv.prompt");
        String string7 = null;
        String string8 = null;
        String string9 = ResourceManager.getString((String)"deployment.ssv.always");
        String string10 = ResourceManager.getString((String)"deployment.ssv.run");
        String string11 = null;
        String string12 = ResourceManager.getString((String)"deployment.ssv.cancel");
        URL uRL = null;
        String string13 = SecureStaticVersioning.isLocalApp(appInfo) ? string4 : string3;
        UIFactory uIFactory = ToolkitStore.getUI();
        ToolkitStore.getUI();
        int n = uIFactory.showSSV3Dialog(null, appInfo, 2, string, string2, string13, string5, string6, string7, string8, string10, string11, string12, string9, uRL);
        ToolkitStore.getUI();
        if (n == 2) {
            return true;
        }
        ToolkitStore.getUI();
        if (n == 0) {
            return false;
        }
        throw new ExitException(null, 0);
    }

    private static boolean showExpiredDialog(AppInfo appInfo, String string) throws ExitException {
        String string2 = ResourceManager.getString((String)"deployment.ssv.title");
        String string3 = ResourceManager.getString((String)"deployment.ssv.masthead");
        String string4 = SecureStaticVersioning.isLocalApp(appInfo) ? ResourceManager.getString((String)"deployment.ssv.expired.localapp.main") : ResourceManager.getString((String)"deployment.ssv.expired.main");
        String string5 = ResourceManager.getString((String)"deployment.ssv.location");
        String string6 = ResourceManager.getString((String)"deployment.ssv.expired.recommend");
        String string7 = ResourceManager.getString((String)"deployment.ssv.prompt");
        String string8 = null;
        String string9 = null;
        if (SecuritySettings.isSSVModeMultiClick()) {
            string8 = ResourceManager.getString((String)"deployment.ssv.multi.prompt");
            string9 = ResourceManager.getString((String)"deployment.ssv.multi.text");
        }
        String string10 = ResourceManager.getString((String)"deployment.ssv.always");
        String string11 = ResourceManager.getString((String)"deployment.ssv.run");
        String string12 = ResourceManager.getString((String)"deployment.ssv.update");
        String string13 = ResourceManager.getString((String)"deployment.ssv.cancel");
        URL uRL = null;
        try {
            uRL = new URL("http://java.com/download");
        }
        catch (Exception exception) {
            // empty catch block
        }
        UIFactory uIFactory = ToolkitStore.getUI();
        ToolkitStore.getUI();
        int n = uIFactory.showSSV3Dialog(null, appInfo, 2, string2, string3, string4, string5, string7, string8, string9, string11, string12, string13, string10, uRL);
        ToolkitStore.getUI();
        if (n == 2) {
            return true;
        }
        ToolkitStore.getUI();
        if (n == 0) {
            return false;
        }
        throw new ExitException(null, 0);
    }

    public static void showBlockedDialog(LaunchDesc launchDesc, AppInfo appInfo, String string) throws ExitException {
        String string2 = null;
        String string3 = ResourceManager.getString((String)string);
        Trace.println((String)string3, (TraceLevel)TraceLevel.BASIC);
        Trace.println((String)string3, (TraceLevel)TraceLevel.BASIC);
        String string4 = ResourceManager.getString((String)"deployment.blocked.title");
        String string5 = ResourceManager.getString((String)"deployment.blocked.masthead");
        if (string3 == null) {
            string3 = ResourceManager.getString((String)"deployment.blocked.text");
        }
        String string6 = ResourceManager.getString((String)"common.ok_btn");
        String string7 = ResourceManager.getString((String)"common.detail.button");
        ToolkitStore.getUI().showPublisherInfo(null, appInfo, string4, string5, string3, string6, string7, string2);
        throw new ExitException(null, 0);
    }
}

