/*
 * Decompiled with CFR 0.152.
 */
package com.glavsoft.viewer.swing.ssh;

import com.glavsoft.utils.Strings;
import com.glavsoft.viewer.CancelConnectionException;
import com.glavsoft.viewer.swing.ConnectionParams;
import com.glavsoft.viewer.swing.Utils;
import com.glavsoft.viewer.swing.ssh.SshKnownHostsManager;
import com.glavsoft.viewer.swing.ssh.SwingSshUserInfo;
import com.jcraft.jsch.HostKey;
import com.jcraft.jsch.HostKeyRepository;
import com.jcraft.jsch.JSch;
import com.jcraft.jsch.JSchException;
import com.jcraft.jsch.Session;
import com.jcraft.jsch.UserInfo;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.lang.reflect.InvocationTargetException;
import java.util.logging.Logger;
import java.util.prefs.Preferences;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JOptionPane;
import javax.swing.SwingUtilities;

public class SshConnectionManager
implements SshKnownHostsManager {
    public static final String SSH_NODE = "com/glavsoft/viewer/ssh";
    public static final String KNOWN_HOSTS = "known_hosts";
    private Session session;
    private String errorMessage = "";
    private final JFrame parentWindow;
    private JSch jsch;

    public SshConnectionManager(JFrame parentWindow) {
        this.parentWindow = parentWindow;
    }

    public int connect(ConnectionParams connectionParams) throws CancelConnectionException {
        if (Strings.isTrimmedEmpty(connectionParams.sshUserName)) {
            connectionParams.sshUserName = this.getInteractivelySshUserName();
        }
        if (this.session != null && this.session.isConnected()) {
            this.session.disconnect();
        }
        this.jsch = new JSch();
        try {
            this.jsch.setKnownHosts(this.getKnownHostsStream());
        }
        catch (JSchException e) {
            Logger.getLogger(this.getClass().getName()).severe("Cannot set JSCH known hosts: " + e.getMessage());
        }
        int port = 0;
        try {
            this.session = this.jsch.getSession(connectionParams.sshUserName, connectionParams.sshHostName, connectionParams.getSshPortNumber());
            SwingSshUserInfo ui = new SwingSshUserInfo(this.parentWindow);
            this.session.setUserInfo((UserInfo)ui);
            this.session.connect();
            this.sync();
            port = this.session.setPortForwardingL(0, connectionParams.hostName, connectionParams.getPortNumber());
        }
        catch (JSchException e) {
            this.session.disconnect();
            this.errorMessage = e.getMessage();
        }
        return port;
    }

    private String getInteractivelySshUserName() throws CancelConnectionException {
        class Pair {
            int intRes;
            String stringRes;

            Pair() {
            }
        }
        final Pair result = new Pair();
        try {
            SwingUtilities.invokeAndWait(new Runnable(){
                {
                }

                @Override
                public void run() {
                    JOptionPane pane = new JOptionPane("Please enter the user name for SSH connection:", 3, 2);
                    pane.setWantsInput(true);
                    JDialog dialog = pane.createDialog(SshConnectionManager.this.parentWindow, "SSH User Name");
                    Utils.decorateDialog(dialog);
                    dialog.setVisible(true);
                    result.stringRes = pane.getInputValue() != null ? (String)pane.getInputValue() : "";
                    result.intRes = pane.getValue() != null ? (Integer)pane.getValue() : 2;
                    dialog.dispose();
                }
            });
        }
        catch (InterruptedException e) {
            Logger.getLogger(this.getClass().getName()).severe(e.getMessage());
        }
        catch (InvocationTargetException e) {
            Logger.getLogger(this.getClass().getName()).severe(e.getMessage());
        }
        if (result.intRes != 0) {
            throw new CancelConnectionException("No Ssh User Name entered");
        }
        return result.stringRes;
    }

    public boolean isConnected() {
        return this.session.isConnected();
    }

    public String getErrorMessage() {
        return this.errorMessage;
    }

    private InputStream getKnownHostsStream() {
        Preferences sshNode = Preferences.userRoot().node(SSH_NODE);
        return new ByteArrayInputStream(sshNode.getByteArray(KNOWN_HOSTS, new byte[0]));
    }

    @Override
    public void sync() {
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        HostKeyRepository repository = this.jsch.getHostKeyRepository();
        try {
            HostKey[] hostKey = repository.getHostKey();
            if (null == hostKey) {
                return;
            }
            for (HostKey hk : hostKey) {
                String host = hk.getHost();
                String type = hk.getType();
                if (type.equals("UNKNOWN")) {
                    this.write(out, host);
                    this.write(out, "\n");
                    continue;
                }
                this.write(out, host);
                this.write(out, " ");
                this.write(out, type);
                this.write(out, " ");
                this.write(out, hk.getKey());
                this.write(out, "\n");
            }
        }
        catch (IOException e) {
            Logger.getLogger(this.getClass().getName()).severe("Cannot sync JSCH known hosts: " + e.getMessage());
        }
        Preferences sshNode = Preferences.userRoot().node(SSH_NODE);
        sshNode.putByteArray(KNOWN_HOSTS, out.toByteArray());
    }

    private void write(ByteArrayOutputStream out, String str) throws IOException {
        try {
            out.write(str.getBytes("UTF-8"));
        }
        catch (UnsupportedEncodingException e) {
            out.write(str.getBytes());
        }
    }
}

