//go:build !ignore_autogenerated
// +build !ignore_autogenerated

/*
Copyright 2019 The Tekton Authors

Licensed under the Apache License, Version 2.0 (the "License");
you may not use this file except in compliance with the License.
You may obtain a copy of the License at

    http://www.apache.org/licenses/LICENSE-2.0

Unless required by applicable law or agreed to in writing, software
distributed under the License is distributed on an "AS IS" BASIS,
WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
See the License for the specific language governing permissions and
limitations under the License.
*/

// Code generated by openapi-gen. DO NOT EDIT.

// This file was autogenerated by openapi-gen. Do not edit it manually!

package v1beta1

import (
	common "k8s.io/kube-openapi/pkg/common"
	spec "k8s.io/kube-openapi/pkg/validation/spec"
)

func GetOpenAPIDefinitions(ref common.ReferenceCallback) map[string]common.OpenAPIDefinition {
	return map[string]common.OpenAPIDefinition{
		"github.com/tektoncd/triggers/pkg/apis/triggers/v1beta1.ClusterTriggerBinding":        schema_pkg_apis_triggers_v1beta1_ClusterTriggerBinding(ref),
		"github.com/tektoncd/triggers/pkg/apis/triggers/v1beta1.ClusterTriggerBindingList":    schema_pkg_apis_triggers_v1beta1_ClusterTriggerBindingList(ref),
		"github.com/tektoncd/triggers/pkg/apis/triggers/v1beta1.CustomResource":               schema_pkg_apis_triggers_v1beta1_CustomResource(ref),
		"github.com/tektoncd/triggers/pkg/apis/triggers/v1beta1.EventListener":                schema_pkg_apis_triggers_v1beta1_EventListener(ref),
		"github.com/tektoncd/triggers/pkg/apis/triggers/v1beta1.EventListenerConfig":          schema_pkg_apis_triggers_v1beta1_EventListenerConfig(ref),
		"github.com/tektoncd/triggers/pkg/apis/triggers/v1beta1.EventListenerList":            schema_pkg_apis_triggers_v1beta1_EventListenerList(ref),
		"github.com/tektoncd/triggers/pkg/apis/triggers/v1beta1.EventListenerSpec":            schema_pkg_apis_triggers_v1beta1_EventListenerSpec(ref),
		"github.com/tektoncd/triggers/pkg/apis/triggers/v1beta1.EventListenerStatus":          schema_pkg_apis_triggers_v1beta1_EventListenerStatus(ref),
		"github.com/tektoncd/triggers/pkg/apis/triggers/v1beta1.EventListenerTrigger":         schema_pkg_apis_triggers_v1beta1_EventListenerTrigger(ref),
		"github.com/tektoncd/triggers/pkg/apis/triggers/v1beta1.EventListenerTriggerGroup":    schema_pkg_apis_triggers_v1beta1_EventListenerTriggerGroup(ref),
		"github.com/tektoncd/triggers/pkg/apis/triggers/v1beta1.EventListenerTriggerSelector": schema_pkg_apis_triggers_v1beta1_EventListenerTriggerSelector(ref),
		"github.com/tektoncd/triggers/pkg/apis/triggers/v1beta1.InterceptorParams":            schema_pkg_apis_triggers_v1beta1_InterceptorParams(ref),
		"github.com/tektoncd/triggers/pkg/apis/triggers/v1beta1.InterceptorRef":               schema_pkg_apis_triggers_v1beta1_InterceptorRef(ref),
		"github.com/tektoncd/triggers/pkg/apis/triggers/v1beta1.InterceptorRequest":           schema_pkg_apis_triggers_v1beta1_InterceptorRequest(ref),
		"github.com/tektoncd/triggers/pkg/apis/triggers/v1beta1.InterceptorResponse":          schema_pkg_apis_triggers_v1beta1_InterceptorResponse(ref),
		"github.com/tektoncd/triggers/pkg/apis/triggers/v1beta1.KubernetesResource":           schema_pkg_apis_triggers_v1beta1_KubernetesResource(ref),
		"github.com/tektoncd/triggers/pkg/apis/triggers/v1beta1.NamespaceSelector":            schema_pkg_apis_triggers_v1beta1_NamespaceSelector(ref),
		"github.com/tektoncd/triggers/pkg/apis/triggers/v1beta1.Param":                        schema_pkg_apis_triggers_v1beta1_Param(ref),
		"github.com/tektoncd/triggers/pkg/apis/triggers/v1beta1.ParamSpec":                    schema_pkg_apis_triggers_v1beta1_ParamSpec(ref),
		"github.com/tektoncd/triggers/pkg/apis/triggers/v1beta1.Resources":                    schema_pkg_apis_triggers_v1beta1_Resources(ref),
		"github.com/tektoncd/triggers/pkg/apis/triggers/v1beta1.SecretRef":                    schema_pkg_apis_triggers_v1beta1_SecretRef(ref),
		"github.com/tektoncd/triggers/pkg/apis/triggers/v1beta1.Status":                       schema_pkg_apis_triggers_v1beta1_Status(ref),
		"github.com/tektoncd/triggers/pkg/apis/triggers/v1beta1.StatusError":                  schema_pkg_apis_triggers_v1beta1_StatusError(ref),
		"github.com/tektoncd/triggers/pkg/apis/triggers/v1beta1.Trigger":                      schema_pkg_apis_triggers_v1beta1_Trigger(ref),
		"github.com/tektoncd/triggers/pkg/apis/triggers/v1beta1.TriggerBinding":               schema_pkg_apis_triggers_v1beta1_TriggerBinding(ref),
		"github.com/tektoncd/triggers/pkg/apis/triggers/v1beta1.TriggerBindingList":           schema_pkg_apis_triggers_v1beta1_TriggerBindingList(ref),
		"github.com/tektoncd/triggers/pkg/apis/triggers/v1beta1.TriggerBindingSpec":           schema_pkg_apis_triggers_v1beta1_TriggerBindingSpec(ref),
		"github.com/tektoncd/triggers/pkg/apis/triggers/v1beta1.TriggerBindingStatus":         schema_pkg_apis_triggers_v1beta1_TriggerBindingStatus(ref),
		"github.com/tektoncd/triggers/pkg/apis/triggers/v1beta1.TriggerContext":               schema_pkg_apis_triggers_v1beta1_TriggerContext(ref),
		"github.com/tektoncd/triggers/pkg/apis/triggers/v1beta1.TriggerInterceptor":           schema_pkg_apis_triggers_v1beta1_TriggerInterceptor(ref),
		"github.com/tektoncd/triggers/pkg/apis/triggers/v1beta1.TriggerList":                  schema_pkg_apis_triggers_v1beta1_TriggerList(ref),
		"github.com/tektoncd/triggers/pkg/apis/triggers/v1beta1.TriggerResourceTemplate":      schema_pkg_apis_triggers_v1beta1_TriggerResourceTemplate(ref),
		"github.com/tektoncd/triggers/pkg/apis/triggers/v1beta1.TriggerSpec":                  schema_pkg_apis_triggers_v1beta1_TriggerSpec(ref),
		"github.com/tektoncd/triggers/pkg/apis/triggers/v1beta1.TriggerSpecBinding":           schema_pkg_apis_triggers_v1beta1_TriggerSpecBinding(ref),
		"github.com/tektoncd/triggers/pkg/apis/triggers/v1beta1.TriggerSpecTemplate":          schema_pkg_apis_triggers_v1beta1_TriggerSpecTemplate(ref),
		"github.com/tektoncd/triggers/pkg/apis/triggers/v1beta1.TriggerTemplate":              schema_pkg_apis_triggers_v1beta1_TriggerTemplate(ref),
		"github.com/tektoncd/triggers/pkg/apis/triggers/v1beta1.TriggerTemplateList":          schema_pkg_apis_triggers_v1beta1_TriggerTemplateList(ref),
		"github.com/tektoncd/triggers/pkg/apis/triggers/v1beta1.TriggerTemplateSpec":          schema_pkg_apis_triggers_v1beta1_TriggerTemplateSpec(ref),
		"github.com/tektoncd/triggers/pkg/apis/triggers/v1beta1.TriggerTemplateStatus":        schema_pkg_apis_triggers_v1beta1_TriggerTemplateStatus(ref),
		"github.com/tektoncd/triggers/pkg/apis/triggers/v1beta1.WebhookInterceptor":           schema_pkg_apis_triggers_v1beta1_WebhookInterceptor(ref),
	}
}

func schema_pkg_apis_triggers_v1beta1_ClusterTriggerBinding(ref common.ReferenceCallback) common.OpenAPIDefinition {
	return common.OpenAPIDefinition{
		Schema: spec.Schema{
			SchemaProps: spec.SchemaProps{
				Description: "ClusterTriggerBinding is a TriggerBinding with a cluster scope. ClusterTriggerBindings are used to represent TriggerBindings that should be publicly addressable from any namespace in the cluster.",
				Type:        []string{"object"},
				Properties: map[string]spec.Schema{
					"kind": {
						SchemaProps: spec.SchemaProps{
							Description: "Kind is a string value representing the REST resource this object represents. Servers may infer this from the endpoint the client submits requests to. Cannot be updated. In CamelCase. More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#types-kinds",
							Type:        []string{"string"},
							Format:      "",
						},
					},
					"apiVersion": {
						SchemaProps: spec.SchemaProps{
							Description: "APIVersion defines the versioned schema of this representation of an object. Servers should convert recognized schemas to the latest internal value, and may reject unrecognized values. More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#resources",
							Type:        []string{"string"},
							Format:      "",
						},
					},
					"metadata": {
						SchemaProps: spec.SchemaProps{
							Default: map[string]interface{}{},
							Ref:     ref("k8s.io/apimachinery/pkg/apis/meta/v1.ObjectMeta"),
						},
					},
					"spec": {
						SchemaProps: spec.SchemaProps{
							Description: "Spec holds the desired state of the ClusterTriggerBinding from the client",
							Default:     map[string]interface{}{},
							Ref:         ref("github.com/tektoncd/triggers/pkg/apis/triggers/v1beta1.TriggerBindingSpec"),
						},
					},
					"status": {
						SchemaProps: spec.SchemaProps{
							Default: map[string]interface{}{},
							Ref:     ref("github.com/tektoncd/triggers/pkg/apis/triggers/v1beta1.TriggerBindingStatus"),
						},
					},
				},
			},
		},
		Dependencies: []string{
			"github.com/tektoncd/triggers/pkg/apis/triggers/v1beta1.TriggerBindingSpec", "github.com/tektoncd/triggers/pkg/apis/triggers/v1beta1.TriggerBindingStatus", "k8s.io/apimachinery/pkg/apis/meta/v1.ObjectMeta"},
	}
}

func schema_pkg_apis_triggers_v1beta1_ClusterTriggerBindingList(ref common.ReferenceCallback) common.OpenAPIDefinition {
	return common.OpenAPIDefinition{
		Schema: spec.Schema{
			SchemaProps: spec.SchemaProps{
				Description: "ClusterTriggerBindingList contains a list of ClusterTriggerBinding",
				Type:        []string{"object"},
				Properties: map[string]spec.Schema{
					"kind": {
						SchemaProps: spec.SchemaProps{
							Description: "Kind is a string value representing the REST resource this object represents. Servers may infer this from the endpoint the client submits requests to. Cannot be updated. In CamelCase. More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#types-kinds",
							Type:        []string{"string"},
							Format:      "",
						},
					},
					"apiVersion": {
						SchemaProps: spec.SchemaProps{
							Description: "APIVersion defines the versioned schema of this representation of an object. Servers should convert recognized schemas to the latest internal value, and may reject unrecognized values. More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#resources",
							Type:        []string{"string"},
							Format:      "",
						},
					},
					"metadata": {
						SchemaProps: spec.SchemaProps{
							Default: map[string]interface{}{},
							Ref:     ref("k8s.io/apimachinery/pkg/apis/meta/v1.ListMeta"),
						},
					},
					"items": {
						SchemaProps: spec.SchemaProps{
							Type: []string{"array"},
							Items: &spec.SchemaOrArray{
								Schema: &spec.Schema{
									SchemaProps: spec.SchemaProps{
										Default: map[string]interface{}{},
										Ref:     ref("github.com/tektoncd/triggers/pkg/apis/triggers/v1beta1.ClusterTriggerBinding"),
									},
								},
							},
						},
					},
				},
				Required: []string{"items"},
			},
		},
		Dependencies: []string{
			"github.com/tektoncd/triggers/pkg/apis/triggers/v1beta1.ClusterTriggerBinding", "k8s.io/apimachinery/pkg/apis/meta/v1.ListMeta"},
	}
}

func schema_pkg_apis_triggers_v1beta1_CustomResource(ref common.ReferenceCallback) common.OpenAPIDefinition {
	return common.OpenAPIDefinition{
		Schema: spec.Schema{
			SchemaProps: spec.SchemaProps{
				Type: []string{"object"},
			},
		},
	}
}

func schema_pkg_apis_triggers_v1beta1_EventListener(ref common.ReferenceCallback) common.OpenAPIDefinition {
	return common.OpenAPIDefinition{
		Schema: spec.Schema{
			SchemaProps: spec.SchemaProps{
				Description: "EventListener exposes a service to accept HTTP event payloads.",
				Type:        []string{"object"},
				Properties: map[string]spec.Schema{
					"kind": {
						SchemaProps: spec.SchemaProps{
							Description: "Kind is a string value representing the REST resource this object represents. Servers may infer this from the endpoint the client submits requests to. Cannot be updated. In CamelCase. More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#types-kinds",
							Type:        []string{"string"},
							Format:      "",
						},
					},
					"apiVersion": {
						SchemaProps: spec.SchemaProps{
							Description: "APIVersion defines the versioned schema of this representation of an object. Servers should convert recognized schemas to the latest internal value, and may reject unrecognized values. More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#resources",
							Type:        []string{"string"},
							Format:      "",
						},
					},
					"metadata": {
						SchemaProps: spec.SchemaProps{
							Default: map[string]interface{}{},
							Ref:     ref("k8s.io/apimachinery/pkg/apis/meta/v1.ObjectMeta"),
						},
					},
					"spec": {
						SchemaProps: spec.SchemaProps{
							Description: "Spec holds the desired state of the EventListener from the client",
							Default:     map[string]interface{}{},
							Ref:         ref("github.com/tektoncd/triggers/pkg/apis/triggers/v1beta1.EventListenerSpec"),
						},
					},
					"status": {
						SchemaProps: spec.SchemaProps{
							Default: map[string]interface{}{},
							Ref:     ref("github.com/tektoncd/triggers/pkg/apis/triggers/v1beta1.EventListenerStatus"),
						},
					},
				},
			},
		},
		Dependencies: []string{
			"github.com/tektoncd/triggers/pkg/apis/triggers/v1beta1.EventListenerSpec", "github.com/tektoncd/triggers/pkg/apis/triggers/v1beta1.EventListenerStatus", "k8s.io/apimachinery/pkg/apis/meta/v1.ObjectMeta"},
	}
}

func schema_pkg_apis_triggers_v1beta1_EventListenerConfig(ref common.ReferenceCallback) common.OpenAPIDefinition {
	return common.OpenAPIDefinition{
		Schema: spec.Schema{
			SchemaProps: spec.SchemaProps{
				Description: "EventListenerConfig stores configuration for resources generated by the EventListener",
				Type:        []string{"object"},
				Properties: map[string]spec.Schema{
					"generatedName": {
						SchemaProps: spec.SchemaProps{
							Description: "GeneratedResourceName is the name given to all resources reconciled by the EventListener",
							Default:     "",
							Type:        []string{"string"},
							Format:      "",
						},
					},
				},
				Required: []string{"generatedName"},
			},
		},
	}
}

func schema_pkg_apis_triggers_v1beta1_EventListenerList(ref common.ReferenceCallback) common.OpenAPIDefinition {
	return common.OpenAPIDefinition{
		Schema: spec.Schema{
			SchemaProps: spec.SchemaProps{
				Description: "EventListenerList contains a list of TriggerBinding",
				Type:        []string{"object"},
				Properties: map[string]spec.Schema{
					"kind": {
						SchemaProps: spec.SchemaProps{
							Description: "Kind is a string value representing the REST resource this object represents. Servers may infer this from the endpoint the client submits requests to. Cannot be updated. In CamelCase. More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#types-kinds",
							Type:        []string{"string"},
							Format:      "",
						},
					},
					"apiVersion": {
						SchemaProps: spec.SchemaProps{
							Description: "APIVersion defines the versioned schema of this representation of an object. Servers should convert recognized schemas to the latest internal value, and may reject unrecognized values. More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#resources",
							Type:        []string{"string"},
							Format:      "",
						},
					},
					"metadata": {
						SchemaProps: spec.SchemaProps{
							Default: map[string]interface{}{},
							Ref:     ref("k8s.io/apimachinery/pkg/apis/meta/v1.ListMeta"),
						},
					},
					"items": {
						SchemaProps: spec.SchemaProps{
							Type: []string{"array"},
							Items: &spec.SchemaOrArray{
								Schema: &spec.Schema{
									SchemaProps: spec.SchemaProps{
										Default: map[string]interface{}{},
										Ref:     ref("github.com/tektoncd/triggers/pkg/apis/triggers/v1beta1.EventListener"),
									},
								},
							},
						},
					},
				},
				Required: []string{"items"},
			},
		},
		Dependencies: []string{
			"github.com/tektoncd/triggers/pkg/apis/triggers/v1beta1.EventListener", "k8s.io/apimachinery/pkg/apis/meta/v1.ListMeta"},
	}
}

func schema_pkg_apis_triggers_v1beta1_EventListenerSpec(ref common.ReferenceCallback) common.OpenAPIDefinition {
	return common.OpenAPIDefinition{
		Schema: spec.Schema{
			SchemaProps: spec.SchemaProps{
				Description: "EventListenerSpec defines the desired state of the EventListener, represented by a list of Triggers.",
				Type:        []string{"object"},
				Properties: map[string]spec.Schema{
					"serviceAccountName": {
						SchemaProps: spec.SchemaProps{
							Type:   []string{"string"},
							Format: "",
						},
					},
					"triggers": {
						VendorExtensible: spec.VendorExtensible{
							Extensions: spec.Extensions{
								"x-kubernetes-list-type": "atomic",
							},
						},
						SchemaProps: spec.SchemaProps{
							Type: []string{"array"},
							Items: &spec.SchemaOrArray{
								Schema: &spec.Schema{
									SchemaProps: spec.SchemaProps{
										Default: map[string]interface{}{},
										Ref:     ref("github.com/tektoncd/triggers/pkg/apis/triggers/v1beta1.EventListenerTrigger"),
									},
								},
							},
						},
					},
					"triggerGroups": {
						VendorExtensible: spec.VendorExtensible{
							Extensions: spec.Extensions{
								"x-kubernetes-list-type": "atomic",
							},
						},
						SchemaProps: spec.SchemaProps{
							Description: "Trigger groups allow for centralized processing of an interceptor chain",
							Type:        []string{"array"},
							Items: &spec.SchemaOrArray{
								Schema: &spec.Schema{
									SchemaProps: spec.SchemaProps{
										Default: map[string]interface{}{},
										Ref:     ref("github.com/tektoncd/triggers/pkg/apis/triggers/v1beta1.EventListenerTriggerGroup"),
									},
								},
							},
						},
					},
					"namespaceSelector": {
						SchemaProps: spec.SchemaProps{
							Default: map[string]interface{}{},
							Ref:     ref("github.com/tektoncd/triggers/pkg/apis/triggers/v1beta1.NamespaceSelector"),
						},
					},
					"labelSelector": {
						SchemaProps: spec.SchemaProps{
							Ref: ref("k8s.io/apimachinery/pkg/apis/meta/v1.LabelSelector"),
						},
					},
					"resources": {
						SchemaProps: spec.SchemaProps{
							Default: map[string]interface{}{},
							Ref:     ref("github.com/tektoncd/triggers/pkg/apis/triggers/v1beta1.Resources"),
						},
					},
					"cloudEventURI": {
						SchemaProps: spec.SchemaProps{
							Type:   []string{"string"},
							Format: "",
						},
					},
				},
			},
		},
		Dependencies: []string{
			"github.com/tektoncd/triggers/pkg/apis/triggers/v1beta1.EventListenerTrigger", "github.com/tektoncd/triggers/pkg/apis/triggers/v1beta1.EventListenerTriggerGroup", "github.com/tektoncd/triggers/pkg/apis/triggers/v1beta1.NamespaceSelector", "github.com/tektoncd/triggers/pkg/apis/triggers/v1beta1.Resources", "k8s.io/apimachinery/pkg/apis/meta/v1.LabelSelector"},
	}
}

func schema_pkg_apis_triggers_v1beta1_EventListenerStatus(ref common.ReferenceCallback) common.OpenAPIDefinition {
	return common.OpenAPIDefinition{
		Schema: spec.Schema{
			SchemaProps: spec.SchemaProps{
				Description: "EventListenerStatus holds the status of the EventListener",
				Type:        []string{"object"},
				Properties: map[string]spec.Schema{
					"observedGeneration": {
						SchemaProps: spec.SchemaProps{
							Description: "ObservedGeneration is the 'Generation' of the Service that was last processed by the controller.",
							Type:        []string{"integer"},
							Format:      "int64",
						},
					},
					"conditions": {
						VendorExtensible: spec.VendorExtensible{
							Extensions: spec.Extensions{
								"x-kubernetes-patch-merge-key": "type",
								"x-kubernetes-patch-strategy":  "merge",
							},
						},
						SchemaProps: spec.SchemaProps{
							Description: "Conditions the latest available observations of a resource's current state.",
							Type:        []string{"array"},
							Items: &spec.SchemaOrArray{
								Schema: &spec.Schema{
									SchemaProps: spec.SchemaProps{
										Default: map[string]interface{}{},
										Ref:     ref("knative.dev/pkg/apis.Condition"),
									},
								},
							},
						},
					},
					"annotations": {
						SchemaProps: spec.SchemaProps{
							Description: "Annotations is additional Status fields for the Resource to save some additional State as well as convey more information to the user. This is roughly akin to Annotations on any k8s resource, just the reconciler conveying richer information outwards.",
							Type:        []string{"object"},
							AdditionalProperties: &spec.SchemaOrBool{
								Allows: true,
								Schema: &spec.Schema{
									SchemaProps: spec.SchemaProps{
										Default: "",
										Type:    []string{"string"},
										Format:  "",
									},
								},
							},
						},
					},
					"address": {
						SchemaProps: spec.SchemaProps{
							Description: "Address is a single Addressable address. If Addresses is present, Address will be ignored by clients.",
							Ref:         ref("knative.dev/pkg/apis/duck/v1beta1.Addressable"),
						},
					},
					"addresses": {
						SchemaProps: spec.SchemaProps{
							Description: "Addresses is a list of addresses for different protocols (HTTP and HTTPS) If Addresses is present, Address must be ignored by clients.",
							Type:        []string{"array"},
							Items: &spec.SchemaOrArray{
								Schema: &spec.Schema{
									SchemaProps: spec.SchemaProps{
										Default: map[string]interface{}{},
										Ref:     ref("knative.dev/pkg/apis/duck/v1beta1.Addressable"),
									},
								},
							},
						},
					},
					"configuration": {
						SchemaProps: spec.SchemaProps{
							Description: "Configuration stores configuration for the EventListener service",
							Default:     map[string]interface{}{},
							Ref:         ref("github.com/tektoncd/triggers/pkg/apis/triggers/v1beta1.EventListenerConfig"),
						},
					},
				},
				Required: []string{"configuration"},
			},
		},
		Dependencies: []string{
			"github.com/tektoncd/triggers/pkg/apis/triggers/v1beta1.EventListenerConfig", "knative.dev/pkg/apis.Condition", "knative.dev/pkg/apis/duck/v1beta1.Addressable"},
	}
}

func schema_pkg_apis_triggers_v1beta1_EventListenerTrigger(ref common.ReferenceCallback) common.OpenAPIDefinition {
	return common.OpenAPIDefinition{
		Schema: spec.Schema{
			SchemaProps: spec.SchemaProps{
				Description: "EventListenerTrigger represents a connection between TriggerBinding, Params, and TriggerTemplate; TriggerBinding provides extracted values for TriggerTemplate to then create resources from. TriggerRef can also be provided instead of TriggerBinding, Interceptors and TriggerTemplate",
				Type:        []string{"object"},
				Properties: map[string]spec.Schema{
					"bindings": {
						VendorExtensible: spec.VendorExtensible{
							Extensions: spec.Extensions{
								"x-kubernetes-list-type": "atomic",
							},
						},
						SchemaProps: spec.SchemaProps{
							Type: []string{"array"},
							Items: &spec.SchemaOrArray{
								Schema: &spec.Schema{
									SchemaProps: spec.SchemaProps{
										Ref: ref("github.com/tektoncd/triggers/pkg/apis/triggers/v1beta1.TriggerSpecBinding"),
									},
								},
							},
						},
					},
					"template": {
						SchemaProps: spec.SchemaProps{
							Ref: ref("github.com/tektoncd/triggers/pkg/apis/triggers/v1beta1.TriggerSpecTemplate"),
						},
					},
					"triggerRef": {
						SchemaProps: spec.SchemaProps{
							Type:   []string{"string"},
							Format: "",
						},
					},
					"name": {
						SchemaProps: spec.SchemaProps{
							Type:   []string{"string"},
							Format: "",
						},
					},
					"interceptors": {
						VendorExtensible: spec.VendorExtensible{
							Extensions: spec.Extensions{
								"x-kubernetes-list-type": "atomic",
							},
						},
						SchemaProps: spec.SchemaProps{
							Type: []string{"array"},
							Items: &spec.SchemaOrArray{
								Schema: &spec.Schema{
									SchemaProps: spec.SchemaProps{
										Ref: ref("github.com/tektoncd/triggers/pkg/apis/triggers/v1beta1.TriggerInterceptor"),
									},
								},
							},
						},
					},
					"serviceAccountName": {
						SchemaProps: spec.SchemaProps{
							Description: "ServiceAccountName optionally associates credentials with each trigger; more granular authorization for who is allowed to utilize the associated pipeline vs. defaulting to whatever permissions are associated with the entire EventListener and associated sink facilitates multi-tenant model based scenarios",
							Type:        []string{"string"},
							Format:      "",
						},
					},
				},
			},
		},
		Dependencies: []string{
			"github.com/tektoncd/triggers/pkg/apis/triggers/v1beta1.TriggerInterceptor", "github.com/tektoncd/triggers/pkg/apis/triggers/v1beta1.TriggerSpecBinding", "github.com/tektoncd/triggers/pkg/apis/triggers/v1beta1.TriggerSpecTemplate"},
	}
}

func schema_pkg_apis_triggers_v1beta1_EventListenerTriggerGroup(ref common.ReferenceCallback) common.OpenAPIDefinition {
	return common.OpenAPIDefinition{
		Schema: spec.Schema{
			SchemaProps: spec.SchemaProps{
				Description: "EventListenerTriggerGroup defines a group of Triggers that share a common set of interceptors",
				Type:        []string{"object"},
				Properties: map[string]spec.Schema{
					"name": {
						SchemaProps: spec.SchemaProps{
							Default: "",
							Type:    []string{"string"},
							Format:  "",
						},
					},
					"interceptors": {
						VendorExtensible: spec.VendorExtensible{
							Extensions: spec.Extensions{
								"x-kubernetes-list-type": "atomic",
							},
						},
						SchemaProps: spec.SchemaProps{
							Type: []string{"array"},
							Items: &spec.SchemaOrArray{
								Schema: &spec.Schema{
									SchemaProps: spec.SchemaProps{
										Ref: ref("github.com/tektoncd/triggers/pkg/apis/triggers/v1beta1.TriggerInterceptor"),
									},
								},
							},
						},
					},
					"triggerSelector": {
						SchemaProps: spec.SchemaProps{
							Default: map[string]interface{}{},
							Ref:     ref("github.com/tektoncd/triggers/pkg/apis/triggers/v1beta1.EventListenerTriggerSelector"),
						},
					},
				},
				Required: []string{"name", "interceptors", "triggerSelector"},
			},
		},
		Dependencies: []string{
			"github.com/tektoncd/triggers/pkg/apis/triggers/v1beta1.EventListenerTriggerSelector", "github.com/tektoncd/triggers/pkg/apis/triggers/v1beta1.TriggerInterceptor"},
	}
}

func schema_pkg_apis_triggers_v1beta1_EventListenerTriggerSelector(ref common.ReferenceCallback) common.OpenAPIDefinition {
	return common.OpenAPIDefinition{
		Schema: spec.Schema{
			SchemaProps: spec.SchemaProps{
				Description: "EventListenerTriggerSelector  defines ways to select a group of triggers using their metadata",
				Type:        []string{"object"},
				Properties: map[string]spec.Schema{
					"namespaceSelector": {
						SchemaProps: spec.SchemaProps{
							Default: map[string]interface{}{},
							Ref:     ref("github.com/tektoncd/triggers/pkg/apis/triggers/v1beta1.NamespaceSelector"),
						},
					},
					"labelSelector": {
						SchemaProps: spec.SchemaProps{
							Ref: ref("k8s.io/apimachinery/pkg/apis/meta/v1.LabelSelector"),
						},
					},
				},
			},
		},
		Dependencies: []string{
			"github.com/tektoncd/triggers/pkg/apis/triggers/v1beta1.NamespaceSelector", "k8s.io/apimachinery/pkg/apis/meta/v1.LabelSelector"},
	}
}

func schema_pkg_apis_triggers_v1beta1_InterceptorParams(ref common.ReferenceCallback) common.OpenAPIDefinition {
	return common.OpenAPIDefinition{
		Schema: spec.Schema{
			SchemaProps: spec.SchemaProps{
				Description: "InterceptorParams defines a key-value pair that can be passed on an interceptor",
				Type:        []string{"object"},
				Properties: map[string]spec.Schema{
					"name": {
						SchemaProps: spec.SchemaProps{
							Default: "",
							Type:    []string{"string"},
							Format:  "",
						},
					},
					"value": {
						SchemaProps: spec.SchemaProps{
							Default: map[string]interface{}{},
							Ref:     ref("k8s.io/apiextensions-apiserver/pkg/apis/apiextensions/v1.JSON"),
						},
					},
				},
				Required: []string{"name", "value"},
			},
		},
		Dependencies: []string{
			"k8s.io/apiextensions-apiserver/pkg/apis/apiextensions/v1.JSON"},
	}
}

func schema_pkg_apis_triggers_v1beta1_InterceptorRef(ref common.ReferenceCallback) common.OpenAPIDefinition {
	return common.OpenAPIDefinition{
		Schema: spec.Schema{
			SchemaProps: spec.SchemaProps{
				Description: "InterceptorRef provides a Reference to a ClusterInterceptor",
				Type:        []string{"object"},
				Properties: map[string]spec.Schema{
					"name": {
						SchemaProps: spec.SchemaProps{
							Description: "Name of the referent; More info: http://kubernetes.io/docs/user-guide/identifiers#names",
							Type:        []string{"string"},
							Format:      "",
						},
					},
					"kind": {
						SchemaProps: spec.SchemaProps{
							Description: "InterceptorKind indicates the kind of the Interceptor, namespaced or cluster scoped.",
							Type:        []string{"string"},
							Format:      "",
						},
					},
					"apiVersion": {
						SchemaProps: spec.SchemaProps{
							Description: "API version of the referent",
							Type:        []string{"string"},
							Format:      "",
						},
					},
				},
			},
		},
	}
}

func schema_pkg_apis_triggers_v1beta1_InterceptorRequest(ref common.ReferenceCallback) common.OpenAPIDefinition {
	return common.OpenAPIDefinition{
		Schema: spec.Schema{
			SchemaProps: spec.SchemaProps{
				Description: "Do not generate DeepCopy(). See #827",
				Type:        []string{"object"},
				Properties: map[string]spec.Schema{
					"body": {
						SchemaProps: spec.SchemaProps{
							Description: "Body is the incoming HTTP event body. We use a \"string\" representation of the JSON body in order to preserve the body exactly as it was sent (including spaces etc.). This is necessary for some interceptors e.g. GitHub for validating the body with a signature. While []byte can also store an exact representation of the body, `json.Marshal` will compact []byte to a base64 encoded string which means that we will lose the spaces any time we marshal this struct.",
							Type:        []string{"string"},
							Format:      "",
						},
					},
					"header": {
						SchemaProps: spec.SchemaProps{
							Description: "Header are the headers for the incoming HTTP event",
							Type:        []string{"object"},
							AdditionalProperties: &spec.SchemaOrBool{
								Allows: true,
								Schema: &spec.Schema{
									SchemaProps: spec.SchemaProps{
										Type: []string{"array"},
										Items: &spec.SchemaOrArray{
											Schema: &spec.Schema{
												SchemaProps: spec.SchemaProps{
													Default: "",
													Type:    []string{"string"},
													Format:  "",
												},
											},
										},
									},
								},
							},
						},
					},
					"extensions": {
						SchemaProps: spec.SchemaProps{
							Description: "Extensions are extra values that are added by previous interceptors in a chain",
							Type:        []string{"object"},
							AdditionalProperties: &spec.SchemaOrBool{
								Allows: true,
								Schema: &spec.Schema{
									SchemaProps: spec.SchemaProps{
										Type:   []string{"object"},
										Format: "",
									},
								},
							},
						},
					},
					"interceptor_params": {
						SchemaProps: spec.SchemaProps{
							Description: "InterceptorParams are the user specified params for interceptor in the Trigger",
							Type:        []string{"object"},
							AdditionalProperties: &spec.SchemaOrBool{
								Allows: true,
								Schema: &spec.Schema{
									SchemaProps: spec.SchemaProps{
										Type:   []string{"object"},
										Format: "",
									},
								},
							},
						},
					},
					"context": {
						SchemaProps: spec.SchemaProps{
							Description: "Context contains additional metadata about the event being processed",
							Ref:         ref("github.com/tektoncd/triggers/pkg/apis/triggers/v1beta1.TriggerContext"),
						},
					},
				},
				Required: []string{"context"},
			},
		},
		Dependencies: []string{
			"github.com/tektoncd/triggers/pkg/apis/triggers/v1beta1.TriggerContext"},
	}
}

func schema_pkg_apis_triggers_v1beta1_InterceptorResponse(ref common.ReferenceCallback) common.OpenAPIDefinition {
	return common.OpenAPIDefinition{
		Schema: spec.Schema{
			SchemaProps: spec.SchemaProps{
				Description: "Do not generate Deepcopy(). See #827",
				Type:        []string{"object"},
				Properties: map[string]spec.Schema{
					"extensions": {
						SchemaProps: spec.SchemaProps{
							Description: "Extensions are additional fields that is added to the interceptor event.",
							Type:        []string{"object"},
							AdditionalProperties: &spec.SchemaOrBool{
								Allows: true,
								Schema: &spec.Schema{
									SchemaProps: spec.SchemaProps{
										Type:   []string{"object"},
										Format: "",
									},
								},
							},
						},
					},
					"continue": {
						SchemaProps: spec.SchemaProps{
							Description: "Continue indicates if the EventListener should continue processing the Trigger or not",
							Default:     false,
							Type:        []string{"boolean"},
							Format:      "",
						},
					},
					"status": {
						SchemaProps: spec.SchemaProps{
							Description: "Status is an Error status containing details on any interceptor processing errors",
							Default:     map[string]interface{}{},
							Ref:         ref("github.com/tektoncd/triggers/pkg/apis/triggers/v1beta1.Status"),
						},
					},
				},
				Required: []string{"continue", "status"},
			},
		},
		Dependencies: []string{
			"github.com/tektoncd/triggers/pkg/apis/triggers/v1beta1.Status"},
	}
}

func schema_pkg_apis_triggers_v1beta1_KubernetesResource(ref common.ReferenceCallback) common.OpenAPIDefinition {
	return common.OpenAPIDefinition{
		Schema: spec.Schema{
			SchemaProps: spec.SchemaProps{
				Type: []string{"object"},
				Properties: map[string]spec.Schema{
					"replicas": {
						SchemaProps: spec.SchemaProps{
							Type:   []string{"integer"},
							Format: "int32",
						},
					},
					"serviceType": {
						SchemaProps: spec.SchemaProps{
							Type:   []string{"string"},
							Format: "",
						},
					},
					"servicePort": {
						SchemaProps: spec.SchemaProps{
							Type:   []string{"integer"},
							Format: "int32",
						},
					},
					"serviceLoadBalancerClass": {
						SchemaProps: spec.SchemaProps{
							Type:   []string{"string"},
							Format: "",
						},
					},
					"spec": {
						SchemaProps: spec.SchemaProps{
							Default: map[string]interface{}{},
							Ref:     ref("knative.dev/pkg/apis/duck/v1.WithPodSpec"),
						},
					},
				},
			},
		},
		Dependencies: []string{
			"knative.dev/pkg/apis/duck/v1.WithPodSpec"},
	}
}

func schema_pkg_apis_triggers_v1beta1_NamespaceSelector(ref common.ReferenceCallback) common.OpenAPIDefinition {
	return common.OpenAPIDefinition{
		Schema: spec.Schema{
			SchemaProps: spec.SchemaProps{
				Description: "NamespaceSelector is a selector for selecting either all namespaces or a list of namespaces.",
				Type:        []string{"object"},
				Properties: map[string]spec.Schema{
					"matchNames": {
						VendorExtensible: spec.VendorExtensible{
							Extensions: spec.Extensions{
								"x-kubernetes-list-type": "atomic",
							},
						},
						SchemaProps: spec.SchemaProps{
							Description: "List of namespace names.",
							Type:        []string{"array"},
							Items: &spec.SchemaOrArray{
								Schema: &spec.Schema{
									SchemaProps: spec.SchemaProps{
										Default: "",
										Type:    []string{"string"},
										Format:  "",
									},
								},
							},
						},
					},
				},
			},
		},
	}
}

func schema_pkg_apis_triggers_v1beta1_Param(ref common.ReferenceCallback) common.OpenAPIDefinition {
	return common.OpenAPIDefinition{
		Schema: spec.Schema{
			SchemaProps: spec.SchemaProps{
				Description: "Param defines a string value to be used for a ParamSpec with the same name.",
				Type:        []string{"object"},
				Properties: map[string]spec.Schema{
					"name": {
						SchemaProps: spec.SchemaProps{
							Default: "",
							Type:    []string{"string"},
							Format:  "",
						},
					},
					"value": {
						SchemaProps: spec.SchemaProps{
							Default: "",
							Type:    []string{"string"},
							Format:  "",
						},
					},
				},
				Required: []string{"name", "value"},
			},
		},
	}
}

func schema_pkg_apis_triggers_v1beta1_ParamSpec(ref common.ReferenceCallback) common.OpenAPIDefinition {
	return common.OpenAPIDefinition{
		Schema: spec.Schema{
			SchemaProps: spec.SchemaProps{
				Description: "ParamSpec defines an arbitrary named  input whose value can be supplied by a `Param`.",
				Type:        []string{"object"},
				Properties: map[string]spec.Schema{
					"name": {
						SchemaProps: spec.SchemaProps{
							Description: "Name declares the name by which a parameter is referenced.",
							Default:     "",
							Type:        []string{"string"},
							Format:      "",
						},
					},
					"description": {
						SchemaProps: spec.SchemaProps{
							Description: "Description is a user-facing description of the parameter that may be used to populate a UI.",
							Type:        []string{"string"},
							Format:      "",
						},
					},
					"default": {
						SchemaProps: spec.SchemaProps{
							Description: "Default is the value a parameter takes if no input value via a Param is supplied.",
							Type:        []string{"string"},
							Format:      "",
						},
					},
				},
				Required: []string{"name"},
			},
		},
	}
}

func schema_pkg_apis_triggers_v1beta1_Resources(ref common.ReferenceCallback) common.OpenAPIDefinition {
	return common.OpenAPIDefinition{
		Schema: spec.Schema{
			SchemaProps: spec.SchemaProps{
				Type: []string{"object"},
				Properties: map[string]spec.Schema{
					"kubernetesResource": {
						SchemaProps: spec.SchemaProps{
							Ref: ref("github.com/tektoncd/triggers/pkg/apis/triggers/v1beta1.KubernetesResource"),
						},
					},
					"customResource": {
						SchemaProps: spec.SchemaProps{
							Ref: ref("github.com/tektoncd/triggers/pkg/apis/triggers/v1beta1.CustomResource"),
						},
					},
				},
			},
		},
		Dependencies: []string{
			"github.com/tektoncd/triggers/pkg/apis/triggers/v1beta1.CustomResource", "github.com/tektoncd/triggers/pkg/apis/triggers/v1beta1.KubernetesResource"},
	}
}

func schema_pkg_apis_triggers_v1beta1_SecretRef(ref common.ReferenceCallback) common.OpenAPIDefinition {
	return common.OpenAPIDefinition{
		Schema: spec.Schema{
			SchemaProps: spec.SchemaProps{
				Description: "SecretRef contains the information required to reference a single secret string This is needed because the other secretRef types are not cross-namespace and do not actually contain the \"SecretName\" field, which allows us to access a single secret value.",
				Type:        []string{"object"},
				Properties: map[string]spec.Schema{
					"secretKey": {
						SchemaProps: spec.SchemaProps{
							Type:   []string{"string"},
							Format: "",
						},
					},
					"secretName": {
						SchemaProps: spec.SchemaProps{
							Type:   []string{"string"},
							Format: "",
						},
					},
				},
			},
		},
	}
}

func schema_pkg_apis_triggers_v1beta1_Status(ref common.ReferenceCallback) common.OpenAPIDefinition {
	return common.OpenAPIDefinition{
		Schema: spec.Schema{
			SchemaProps: spec.SchemaProps{
				Type: []string{"object"},
				Properties: map[string]spec.Schema{
					"code": {
						SchemaProps: spec.SchemaProps{
							Description: "The status code, which should be an enum value of [google.rpc.Code][google.rpc.Code].",
							Type:        []string{"integer"},
							Format:      "int64",
						},
					},
					"message": {
						SchemaProps: spec.SchemaProps{
							Description: "A developer-facing error message, which should be in English.",
							Type:        []string{"string"},
							Format:      "",
						},
					},
				},
			},
		},
	}
}

func schema_pkg_apis_triggers_v1beta1_StatusError(ref common.ReferenceCallback) common.OpenAPIDefinition {
	return common.OpenAPIDefinition{
		Schema: spec.Schema{
			SchemaProps: spec.SchemaProps{
				Type: []string{"object"},
				Properties: map[string]spec.Schema{
					"s": {
						SchemaProps: spec.SchemaProps{
							Default: map[string]interface{}{},
							Ref:     ref("github.com/tektoncd/triggers/pkg/apis/triggers/v1beta1.Status"),
						},
					},
				},
				Required: []string{"s"},
			},
		},
		Dependencies: []string{
			"github.com/tektoncd/triggers/pkg/apis/triggers/v1beta1.Status"},
	}
}

func schema_pkg_apis_triggers_v1beta1_Trigger(ref common.ReferenceCallback) common.OpenAPIDefinition {
	return common.OpenAPIDefinition{
		Schema: spec.Schema{
			SchemaProps: spec.SchemaProps{
				Description: "Trigger defines a mapping of an input event to parameters. This is used to extract information from events to be passed to TriggerTemplates within a Trigger.",
				Type:        []string{"object"},
				Properties: map[string]spec.Schema{
					"kind": {
						SchemaProps: spec.SchemaProps{
							Description: "Kind is a string value representing the REST resource this object represents. Servers may infer this from the endpoint the client submits requests to. Cannot be updated. In CamelCase. More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#types-kinds",
							Type:        []string{"string"},
							Format:      "",
						},
					},
					"apiVersion": {
						SchemaProps: spec.SchemaProps{
							Description: "APIVersion defines the versioned schema of this representation of an object. Servers should convert recognized schemas to the latest internal value, and may reject unrecognized values. More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#resources",
							Type:        []string{"string"},
							Format:      "",
						},
					},
					"metadata": {
						SchemaProps: spec.SchemaProps{
							Default: map[string]interface{}{},
							Ref:     ref("k8s.io/apimachinery/pkg/apis/meta/v1.ObjectMeta"),
						},
					},
					"spec": {
						SchemaProps: spec.SchemaProps{
							Description: "Spec holds the desired state of the Trigger",
							Default:     map[string]interface{}{},
							Ref:         ref("github.com/tektoncd/triggers/pkg/apis/triggers/v1beta1.TriggerSpec"),
						},
					},
				},
			},
		},
		Dependencies: []string{
			"github.com/tektoncd/triggers/pkg/apis/triggers/v1beta1.TriggerSpec", "k8s.io/apimachinery/pkg/apis/meta/v1.ObjectMeta"},
	}
}

func schema_pkg_apis_triggers_v1beta1_TriggerBinding(ref common.ReferenceCallback) common.OpenAPIDefinition {
	return common.OpenAPIDefinition{
		Schema: spec.Schema{
			SchemaProps: spec.SchemaProps{
				Description: "TriggerBinding defines a mapping of an input event to parameters. This is used to extract information from events to be passed to TriggerTemplates within a Trigger.",
				Type:        []string{"object"},
				Properties: map[string]spec.Schema{
					"kind": {
						SchemaProps: spec.SchemaProps{
							Description: "Kind is a string value representing the REST resource this object represents. Servers may infer this from the endpoint the client submits requests to. Cannot be updated. In CamelCase. More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#types-kinds",
							Type:        []string{"string"},
							Format:      "",
						},
					},
					"apiVersion": {
						SchemaProps: spec.SchemaProps{
							Description: "APIVersion defines the versioned schema of this representation of an object. Servers should convert recognized schemas to the latest internal value, and may reject unrecognized values. More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#resources",
							Type:        []string{"string"},
							Format:      "",
						},
					},
					"metadata": {
						SchemaProps: spec.SchemaProps{
							Default: map[string]interface{}{},
							Ref:     ref("k8s.io/apimachinery/pkg/apis/meta/v1.ObjectMeta"),
						},
					},
					"spec": {
						SchemaProps: spec.SchemaProps{
							Description: "Spec holds the desired state of the TriggerBinding",
							Default:     map[string]interface{}{},
							Ref:         ref("github.com/tektoncd/triggers/pkg/apis/triggers/v1beta1.TriggerBindingSpec"),
						},
					},
					"status": {
						SchemaProps: spec.SchemaProps{
							Default: map[string]interface{}{},
							Ref:     ref("github.com/tektoncd/triggers/pkg/apis/triggers/v1beta1.TriggerBindingStatus"),
						},
					},
				},
			},
		},
		Dependencies: []string{
			"github.com/tektoncd/triggers/pkg/apis/triggers/v1beta1.TriggerBindingSpec", "github.com/tektoncd/triggers/pkg/apis/triggers/v1beta1.TriggerBindingStatus", "k8s.io/apimachinery/pkg/apis/meta/v1.ObjectMeta"},
	}
}

func schema_pkg_apis_triggers_v1beta1_TriggerBindingList(ref common.ReferenceCallback) common.OpenAPIDefinition {
	return common.OpenAPIDefinition{
		Schema: spec.Schema{
			SchemaProps: spec.SchemaProps{
				Description: "TriggerBindingList contains a list of TriggerBindings. We don't use this but it's required for certain codegen features.",
				Type:        []string{"object"},
				Properties: map[string]spec.Schema{
					"kind": {
						SchemaProps: spec.SchemaProps{
							Description: "Kind is a string value representing the REST resource this object represents. Servers may infer this from the endpoint the client submits requests to. Cannot be updated. In CamelCase. More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#types-kinds",
							Type:        []string{"string"},
							Format:      "",
						},
					},
					"apiVersion": {
						SchemaProps: spec.SchemaProps{
							Description: "APIVersion defines the versioned schema of this representation of an object. Servers should convert recognized schemas to the latest internal value, and may reject unrecognized values. More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#resources",
							Type:        []string{"string"},
							Format:      "",
						},
					},
					"metadata": {
						SchemaProps: spec.SchemaProps{
							Default: map[string]interface{}{},
							Ref:     ref("k8s.io/apimachinery/pkg/apis/meta/v1.ListMeta"),
						},
					},
					"items": {
						SchemaProps: spec.SchemaProps{
							Type: []string{"array"},
							Items: &spec.SchemaOrArray{
								Schema: &spec.Schema{
									SchemaProps: spec.SchemaProps{
										Default: map[string]interface{}{},
										Ref:     ref("github.com/tektoncd/triggers/pkg/apis/triggers/v1beta1.TriggerBinding"),
									},
								},
							},
						},
					},
				},
				Required: []string{"items"},
			},
		},
		Dependencies: []string{
			"github.com/tektoncd/triggers/pkg/apis/triggers/v1beta1.TriggerBinding", "k8s.io/apimachinery/pkg/apis/meta/v1.ListMeta"},
	}
}

func schema_pkg_apis_triggers_v1beta1_TriggerBindingSpec(ref common.ReferenceCallback) common.OpenAPIDefinition {
	return common.OpenAPIDefinition{
		Schema: spec.Schema{
			SchemaProps: spec.SchemaProps{
				Description: "TriggerBindingSpec defines the desired state of the TriggerBinding.",
				Type:        []string{"object"},
				Properties: map[string]spec.Schema{
					"params": {
						VendorExtensible: spec.VendorExtensible{
							Extensions: spec.Extensions{
								"x-kubernetes-list-type": "atomic",
							},
						},
						SchemaProps: spec.SchemaProps{
							Description: "Params defines the parameter mapping from the given input event.",
							Type:        []string{"array"},
							Items: &spec.SchemaOrArray{
								Schema: &spec.Schema{
									SchemaProps: spec.SchemaProps{
										Default: map[string]interface{}{},
										Ref:     ref("github.com/tektoncd/triggers/pkg/apis/triggers/v1beta1.Param"),
									},
								},
							},
						},
					},
				},
			},
		},
		Dependencies: []string{
			"github.com/tektoncd/triggers/pkg/apis/triggers/v1beta1.Param"},
	}
}

func schema_pkg_apis_triggers_v1beta1_TriggerBindingStatus(ref common.ReferenceCallback) common.OpenAPIDefinition {
	return common.OpenAPIDefinition{
		Schema: spec.Schema{
			SchemaProps: spec.SchemaProps{
				Description: "TriggerBindingStatus defines the observed state of TriggerBinding.",
				Type:        []string{"object"},
			},
		},
	}
}

func schema_pkg_apis_triggers_v1beta1_TriggerContext(ref common.ReferenceCallback) common.OpenAPIDefinition {
	return common.OpenAPIDefinition{
		Schema: spec.Schema{
			SchemaProps: spec.SchemaProps{
				Type: []string{"object"},
				Properties: map[string]spec.Schema{
					"event_url": {
						SchemaProps: spec.SchemaProps{
							Description: "EventURL is the URL of the incoming event",
							Type:        []string{"string"},
							Format:      "",
						},
					},
					"event_id": {
						SchemaProps: spec.SchemaProps{
							Description: "EventID is a unique ID assigned by Triggers to each event",
							Type:        []string{"string"},
							Format:      "",
						},
					},
					"trigger_id": {
						SchemaProps: spec.SchemaProps{
							Description: "TriggerID is of the form namespace/$ns/triggers/$name",
							Type:        []string{"string"},
							Format:      "",
						},
					},
				},
			},
		},
	}
}

func schema_pkg_apis_triggers_v1beta1_TriggerInterceptor(ref common.ReferenceCallback) common.OpenAPIDefinition {
	return common.OpenAPIDefinition{
		Schema: spec.Schema{
			SchemaProps: spec.SchemaProps{
				Description: "TriggerInterceptor provides a hook to intercept and pre-process events",
				Type:        []string{"object"},
				Properties: map[string]spec.Schema{
					"name": {
						SchemaProps: spec.SchemaProps{
							Description: "Optional name to identify the current interceptor configuration",
							Type:        []string{"string"},
							Format:      "",
						},
					},
					"ref": {
						SchemaProps: spec.SchemaProps{
							Description: "Ref refers to the Interceptor to use",
							Default:     map[string]interface{}{},
							Ref:         ref("github.com/tektoncd/triggers/pkg/apis/triggers/v1beta1.InterceptorRef"),
						},
					},
					"params": {
						VendorExtensible: spec.VendorExtensible{
							Extensions: spec.Extensions{
								"x-kubernetes-list-type": "atomic",
							},
						},
						SchemaProps: spec.SchemaProps{
							Description: "Params are the params to send to the interceptor",
							Type:        []string{"array"},
							Items: &spec.SchemaOrArray{
								Schema: &spec.Schema{
									SchemaProps: spec.SchemaProps{
										Default: map[string]interface{}{},
										Ref:     ref("github.com/tektoncd/triggers/pkg/apis/triggers/v1beta1.InterceptorParams"),
									},
								},
							},
						},
					},
					"webhook": {
						SchemaProps: spec.SchemaProps{
							Description: "WebhookInterceptor refers to an old style webhook interceptor service",
							Ref:         ref("github.com/tektoncd/triggers/pkg/apis/triggers/v1beta1.WebhookInterceptor"),
						},
					},
				},
				Required: []string{"ref"},
			},
		},
		Dependencies: []string{
			"github.com/tektoncd/triggers/pkg/apis/triggers/v1beta1.InterceptorParams", "github.com/tektoncd/triggers/pkg/apis/triggers/v1beta1.InterceptorRef", "github.com/tektoncd/triggers/pkg/apis/triggers/v1beta1.WebhookInterceptor"},
	}
}

func schema_pkg_apis_triggers_v1beta1_TriggerList(ref common.ReferenceCallback) common.OpenAPIDefinition {
	return common.OpenAPIDefinition{
		Schema: spec.Schema{
			SchemaProps: spec.SchemaProps{
				Description: "TriggerList contains a list of Triggers. We don't use this but it's required for certain codegen features.",
				Type:        []string{"object"},
				Properties: map[string]spec.Schema{
					"kind": {
						SchemaProps: spec.SchemaProps{
							Description: "Kind is a string value representing the REST resource this object represents. Servers may infer this from the endpoint the client submits requests to. Cannot be updated. In CamelCase. More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#types-kinds",
							Type:        []string{"string"},
							Format:      "",
						},
					},
					"apiVersion": {
						SchemaProps: spec.SchemaProps{
							Description: "APIVersion defines the versioned schema of this representation of an object. Servers should convert recognized schemas to the latest internal value, and may reject unrecognized values. More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#resources",
							Type:        []string{"string"},
							Format:      "",
						},
					},
					"metadata": {
						SchemaProps: spec.SchemaProps{
							Default: map[string]interface{}{},
							Ref:     ref("k8s.io/apimachinery/pkg/apis/meta/v1.ListMeta"),
						},
					},
					"items": {
						SchemaProps: spec.SchemaProps{
							Type: []string{"array"},
							Items: &spec.SchemaOrArray{
								Schema: &spec.Schema{
									SchemaProps: spec.SchemaProps{
										Default: map[string]interface{}{},
										Ref:     ref("github.com/tektoncd/triggers/pkg/apis/triggers/v1beta1.Trigger"),
									},
								},
							},
						},
					},
				},
				Required: []string{"items"},
			},
		},
		Dependencies: []string{
			"github.com/tektoncd/triggers/pkg/apis/triggers/v1beta1.Trigger", "k8s.io/apimachinery/pkg/apis/meta/v1.ListMeta"},
	}
}

func schema_pkg_apis_triggers_v1beta1_TriggerResourceTemplate(ref common.ReferenceCallback) common.OpenAPIDefinition {
	return common.OpenAPIDefinition{
		Schema: spec.Schema{
			SchemaProps: spec.SchemaProps{
				Description: "TriggerResourceTemplate describes a resource to create",
				Type:        []string{"object"},
			},
		},
	}
}

func schema_pkg_apis_triggers_v1beta1_TriggerSpec(ref common.ReferenceCallback) common.OpenAPIDefinition {
	return common.OpenAPIDefinition{
		Schema: spec.Schema{
			SchemaProps: spec.SchemaProps{
				Description: "TriggerSpec represents a connection between TriggerSpecBinding, and TriggerSpecTemplate; TriggerSpecBinding provides extracted values for TriggerSpecTemplate to then create resources from.",
				Type:        []string{"object"},
				Properties: map[string]spec.Schema{
					"bindings": {
						VendorExtensible: spec.VendorExtensible{
							Extensions: spec.Extensions{
								"x-kubernetes-list-type": "atomic",
							},
						},
						SchemaProps: spec.SchemaProps{
							Type: []string{"array"},
							Items: &spec.SchemaOrArray{
								Schema: &spec.Schema{
									SchemaProps: spec.SchemaProps{
										Ref: ref("github.com/tektoncd/triggers/pkg/apis/triggers/v1beta1.TriggerSpecBinding"),
									},
								},
							},
						},
					},
					"template": {
						SchemaProps: spec.SchemaProps{
							Default: map[string]interface{}{},
							Ref:     ref("github.com/tektoncd/triggers/pkg/apis/triggers/v1beta1.TriggerSpecTemplate"),
						},
					},
					"name": {
						SchemaProps: spec.SchemaProps{
							Type:   []string{"string"},
							Format: "",
						},
					},
					"interceptors": {
						VendorExtensible: spec.VendorExtensible{
							Extensions: spec.Extensions{
								"x-kubernetes-list-type": "atomic",
							},
						},
						SchemaProps: spec.SchemaProps{
							Type: []string{"array"},
							Items: &spec.SchemaOrArray{
								Schema: &spec.Schema{
									SchemaProps: spec.SchemaProps{
										Ref: ref("github.com/tektoncd/triggers/pkg/apis/triggers/v1beta1.TriggerInterceptor"),
									},
								},
							},
						},
					},
					"serviceAccountName": {
						SchemaProps: spec.SchemaProps{
							Description: "ServiceAccountName optionally associates credentials with each trigger; Unlike EventListeners, this should be scoped to the same namespace as the Trigger itself",
							Type:        []string{"string"},
							Format:      "",
						},
					},
				},
				Required: []string{"bindings", "template"},
			},
		},
		Dependencies: []string{
			"github.com/tektoncd/triggers/pkg/apis/triggers/v1beta1.TriggerInterceptor", "github.com/tektoncd/triggers/pkg/apis/triggers/v1beta1.TriggerSpecBinding", "github.com/tektoncd/triggers/pkg/apis/triggers/v1beta1.TriggerSpecTemplate"},
	}
}

func schema_pkg_apis_triggers_v1beta1_TriggerSpecBinding(ref common.ReferenceCallback) common.OpenAPIDefinition {
	return common.OpenAPIDefinition{
		Schema: spec.Schema{
			SchemaProps: spec.SchemaProps{
				Type: []string{"object"},
				Properties: map[string]spec.Schema{
					"name": {
						SchemaProps: spec.SchemaProps{
							Description: "Name is the name of the binding param Mutually exclusive with Ref",
							Type:        []string{"string"},
							Format:      "",
						},
					},
					"value": {
						SchemaProps: spec.SchemaProps{
							Description: "Value is the value of the binding param. Can contain JSONPath Has to be pointer since \"\" is a valid value Required if Name is also specified.",
							Type:        []string{"string"},
							Format:      "",
						},
					},
					"ref": {
						SchemaProps: spec.SchemaProps{
							Description: "Ref is a reference to a TriggerBinding kind. Mutually exclusive with Name",
							Type:        []string{"string"},
							Format:      "",
						},
					},
					"kind": {
						SchemaProps: spec.SchemaProps{
							Description: "Kind can only be provided if Ref is also provided. Defaults to TriggerBinding",
							Type:        []string{"string"},
							Format:      "",
						},
					},
					"apiversion": {
						SchemaProps: spec.SchemaProps{
							Description: "APIVersion of the binding ref",
							Type:        []string{"string"},
							Format:      "",
						},
					},
				},
			},
		},
	}
}

func schema_pkg_apis_triggers_v1beta1_TriggerSpecTemplate(ref common.ReferenceCallback) common.OpenAPIDefinition {
	return common.OpenAPIDefinition{
		Schema: spec.Schema{
			SchemaProps: spec.SchemaProps{
				Type: []string{"object"},
				Properties: map[string]spec.Schema{
					"ref": {
						SchemaProps: spec.SchemaProps{
							Type:   []string{"string"},
							Format: "",
						},
					},
					"apiversion": {
						SchemaProps: spec.SchemaProps{
							Type:   []string{"string"},
							Format: "",
						},
					},
					"spec": {
						SchemaProps: spec.SchemaProps{
							Ref: ref("github.com/tektoncd/triggers/pkg/apis/triggers/v1beta1.TriggerTemplateSpec"),
						},
					},
				},
			},
		},
		Dependencies: []string{
			"github.com/tektoncd/triggers/pkg/apis/triggers/v1beta1.TriggerTemplateSpec"},
	}
}

func schema_pkg_apis_triggers_v1beta1_TriggerTemplate(ref common.ReferenceCallback) common.OpenAPIDefinition {
	return common.OpenAPIDefinition{
		Schema: spec.Schema{
			SchemaProps: spec.SchemaProps{
				Description: "TriggerTemplate takes parameters and uses them to create CRDs",
				Type:        []string{"object"},
				Properties: map[string]spec.Schema{
					"kind": {
						SchemaProps: spec.SchemaProps{
							Description: "Kind is a string value representing the REST resource this object represents. Servers may infer this from the endpoint the client submits requests to. Cannot be updated. In CamelCase. More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#types-kinds",
							Type:        []string{"string"},
							Format:      "",
						},
					},
					"apiVersion": {
						SchemaProps: spec.SchemaProps{
							Description: "APIVersion defines the versioned schema of this representation of an object. Servers should convert recognized schemas to the latest internal value, and may reject unrecognized values. More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#resources",
							Type:        []string{"string"},
							Format:      "",
						},
					},
					"metadata": {
						SchemaProps: spec.SchemaProps{
							Default: map[string]interface{}{},
							Ref:     ref("k8s.io/apimachinery/pkg/apis/meta/v1.ObjectMeta"),
						},
					},
					"spec": {
						SchemaProps: spec.SchemaProps{
							Description: "Spec holds the desired state of the TriggerTemplate from the client",
							Default:     map[string]interface{}{},
							Ref:         ref("github.com/tektoncd/triggers/pkg/apis/triggers/v1beta1.TriggerTemplateSpec"),
						},
					},
					"status": {
						SchemaProps: spec.SchemaProps{
							Default: map[string]interface{}{},
							Ref:     ref("github.com/tektoncd/triggers/pkg/apis/triggers/v1beta1.TriggerTemplateStatus"),
						},
					},
				},
			},
		},
		Dependencies: []string{
			"github.com/tektoncd/triggers/pkg/apis/triggers/v1beta1.TriggerTemplateSpec", "github.com/tektoncd/triggers/pkg/apis/triggers/v1beta1.TriggerTemplateStatus", "k8s.io/apimachinery/pkg/apis/meta/v1.ObjectMeta"},
	}
}

func schema_pkg_apis_triggers_v1beta1_TriggerTemplateList(ref common.ReferenceCallback) common.OpenAPIDefinition {
	return common.OpenAPIDefinition{
		Schema: spec.Schema{
			SchemaProps: spec.SchemaProps{
				Description: "TriggerTemplateList contains a list of TriggerTemplate",
				Type:        []string{"object"},
				Properties: map[string]spec.Schema{
					"kind": {
						SchemaProps: spec.SchemaProps{
							Description: "Kind is a string value representing the REST resource this object represents. Servers may infer this from the endpoint the client submits requests to. Cannot be updated. In CamelCase. More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#types-kinds",
							Type:        []string{"string"},
							Format:      "",
						},
					},
					"apiVersion": {
						SchemaProps: spec.SchemaProps{
							Description: "APIVersion defines the versioned schema of this representation of an object. Servers should convert recognized schemas to the latest internal value, and may reject unrecognized values. More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#resources",
							Type:        []string{"string"},
							Format:      "",
						},
					},
					"metadata": {
						SchemaProps: spec.SchemaProps{
							Default: map[string]interface{}{},
							Ref:     ref("k8s.io/apimachinery/pkg/apis/meta/v1.ListMeta"),
						},
					},
					"items": {
						SchemaProps: spec.SchemaProps{
							Type: []string{"array"},
							Items: &spec.SchemaOrArray{
								Schema: &spec.Schema{
									SchemaProps: spec.SchemaProps{
										Default: map[string]interface{}{},
										Ref:     ref("github.com/tektoncd/triggers/pkg/apis/triggers/v1beta1.TriggerTemplate"),
									},
								},
							},
						},
					},
				},
				Required: []string{"items"},
			},
		},
		Dependencies: []string{
			"github.com/tektoncd/triggers/pkg/apis/triggers/v1beta1.TriggerTemplate", "k8s.io/apimachinery/pkg/apis/meta/v1.ListMeta"},
	}
}

func schema_pkg_apis_triggers_v1beta1_TriggerTemplateSpec(ref common.ReferenceCallback) common.OpenAPIDefinition {
	return common.OpenAPIDefinition{
		Schema: spec.Schema{
			SchemaProps: spec.SchemaProps{
				Description: "TriggerTemplateSpec holds the desired state of TriggerTemplate",
				Type:        []string{"object"},
				Properties: map[string]spec.Schema{
					"params": {
						VendorExtensible: spec.VendorExtensible{
							Extensions: spec.Extensions{
								"x-kubernetes-list-type": "atomic",
							},
						},
						SchemaProps: spec.SchemaProps{
							Type: []string{"array"},
							Items: &spec.SchemaOrArray{
								Schema: &spec.Schema{
									SchemaProps: spec.SchemaProps{
										Default: map[string]interface{}{},
										Ref:     ref("github.com/tektoncd/triggers/pkg/apis/triggers/v1beta1.ParamSpec"),
									},
								},
							},
						},
					},
					"resourcetemplates": {
						VendorExtensible: spec.VendorExtensible{
							Extensions: spec.Extensions{
								"x-kubernetes-list-type": "atomic",
							},
						},
						SchemaProps: spec.SchemaProps{
							Type: []string{"array"},
							Items: &spec.SchemaOrArray{
								Schema: &spec.Schema{
									SchemaProps: spec.SchemaProps{
										Default: map[string]interface{}{},
										Ref:     ref("github.com/tektoncd/triggers/pkg/apis/triggers/v1beta1.TriggerResourceTemplate"),
									},
								},
							},
						},
					},
				},
			},
		},
		Dependencies: []string{
			"github.com/tektoncd/triggers/pkg/apis/triggers/v1beta1.ParamSpec", "github.com/tektoncd/triggers/pkg/apis/triggers/v1beta1.TriggerResourceTemplate"},
	}
}

func schema_pkg_apis_triggers_v1beta1_TriggerTemplateStatus(ref common.ReferenceCallback) common.OpenAPIDefinition {
	return common.OpenAPIDefinition{
		Schema: spec.Schema{
			SchemaProps: spec.SchemaProps{
				Description: "TriggerTemplateStatus describes the desired state of TriggerTemplate",
				Type:        []string{"object"},
			},
		},
	}
}

func schema_pkg_apis_triggers_v1beta1_WebhookInterceptor(ref common.ReferenceCallback) common.OpenAPIDefinition {
	return common.OpenAPIDefinition{
		Schema: spec.Schema{
			SchemaProps: spec.SchemaProps{
				Description: "WebhookInterceptor provides a webhook to intercept and pre-process events",
				Type:        []string{"object"},
				Properties: map[string]spec.Schema{
					"objectRef": {
						SchemaProps: spec.SchemaProps{
							Description: "ObjectRef is a reference to an object that will resolve to a cluster DNS name to use as the EventInterceptor. Either objectRef or url can be specified",
							Ref:         ref("k8s.io/api/core/v1.ObjectReference"),
						},
					},
					"url": {
						SchemaProps: spec.SchemaProps{
							Ref: ref("knative.dev/pkg/apis.URL"),
						},
					},
					"header": {
						VendorExtensible: spec.VendorExtensible{
							Extensions: spec.Extensions{
								"x-kubernetes-list-type": "atomic",
							},
						},
						SchemaProps: spec.SchemaProps{
							Description: "Header is a group of key-value pairs that can be appended to the interceptor request headers. This allows the interceptor to make decisions specific to an EventListenerTrigger.",
							Type:        []string{"array"},
							Items: &spec.SchemaOrArray{
								Schema: &spec.Schema{
									SchemaProps: spec.SchemaProps{
										Default: map[string]interface{}{},
										Ref:     ref("github.com/tektoncd/pipeline/pkg/apis/pipeline/v1beta1.Param"),
									},
								},
							},
						},
					},
				},
			},
		},
		Dependencies: []string{
			"github.com/tektoncd/pipeline/pkg/apis/pipeline/v1beta1.Param", "k8s.io/api/core/v1.ObjectReference", "knative.dev/pkg/apis.URL"},
	}
}
