/*
 * Decompiled with CFR 0.152.
 */
package com.jidesoft.plaf.basic;

import com.jidesoft.plaf.UIDefaultsLookup;
import com.jidesoft.plaf.basic.ThemePainter;
import com.jidesoft.swing.ComponentStateSupport;
import com.jidesoft.swing.JideSwingUtilities;
import com.jidesoft.swing.JideTabbedPane;
import com.jidesoft.utils.ColorUtils;
import com.jidesoft.utils.SecurityUtils;
import java.awt.Color;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Insets;
import java.awt.Rectangle;
import java.awt.Shape;
import javax.swing.ImageIcon;
import javax.swing.JComponent;
import javax.swing.SwingConstants;
import javax.swing.UIManager;
import javax.swing.plaf.ColorUIResource;
import javax.swing.plaf.UIResource;

public class BasicPainter
implements SwingConstants,
ThemePainter {
    private static BasicPainter _instance;
    protected Color _bk0;
    protected Color _bk1;
    protected Color _bk2;
    protected Color _bk3;
    protected Color _borderColor;

    public static ThemePainter getInstance() {
        if (_instance == null) {
            _instance = new BasicPainter();
        }
        return _instance;
    }

    public void installDefaults() {
        if (this._bk0 == null) {
            this._bk0 = UIDefaultsLookup.getColor("JideButton.background");
        }
        if (this._bk1 == null) {
            this._bk1 = UIDefaultsLookup.getColor("JideButton.focusedBackground");
        }
        if (this._bk2 == null) {
            this._bk2 = UIDefaultsLookup.getColor("JideButton.selectedBackground");
        }
        if (this._bk3 == null) {
            this._bk3 = UIDefaultsLookup.getColor("JideButton.selectedAndFocusedBackground");
        }
        if (this._borderColor == null) {
            this._borderColor = UIDefaultsLookup.getColor("JideButton.borderColor");
        }
    }

    public void uninstallDefaults() {
        this._borderColor = null;
        this._bk0 = null;
        this._bk1 = null;
        this._bk2 = null;
        this._bk3 = null;
    }

    @Override
    public Color getGripperForeground() {
        return UIDefaultsLookup.getColor("Gripper.foreground");
    }

    @Override
    public Color getGripperForegroundLt() {
        return UIDefaultsLookup.getColor("JideButton.highlight");
    }

    @Override
    public Color getSeparatorForeground() {
        return UIDefaultsLookup.getColor("JideButton.shadow");
    }

    @Override
    public Color getSeparatorForegroundLt() {
        return UIDefaultsLookup.getColor("JideButton.highlight");
    }

    @Override
    public Color getCollapsiblePaneContentBackground() {
        return UIDefaultsLookup.getColor("CollapsiblePane.contentBackground");
    }

    @Override
    public Color getCollapsiblePaneTitleForeground() {
        return UIDefaultsLookup.getColor("CollapsiblePane.foreground");
    }

    @Override
    public Color getCollapsiblePaneTitleForegroundEmphasized() {
        return UIDefaultsLookup.getColor("CollapsiblePane.emphasizedForeground");
    }

    @Override
    public Color getCollapsiblePaneFocusTitleForegroundEmphasized() {
        return UIDefaultsLookup.getColor("CollapsiblePane.emphasizedForeground");
    }

    @Override
    public Color getCollapsiblePaneFocusTitleForeground() {
        return UIDefaultsLookup.getColor("CollapsiblePane.foreground");
    }

    @Override
    public ImageIcon getCollapsiblePaneUpIcon() {
        return (ImageIcon)UIDefaultsLookup.getIcon("CollapsiblePane.upIcon");
    }

    @Override
    public ImageIcon getCollapsiblePaneDownIcon() {
        return (ImageIcon)UIDefaultsLookup.getIcon("CollapsiblePane.downIcon");
    }

    @Override
    public ImageIcon getCollapsiblePaneUpIconEmphasized() {
        return this.getCollapsiblePaneUpIcon();
    }

    @Override
    public ImageIcon getCollapsiblePaneDownIconEmphasized() {
        return this.getCollapsiblePaneDownIcon();
    }

    @Override
    public ImageIcon getCollapsiblePaneTitleButtonBackground() {
        return (ImageIcon)UIDefaultsLookup.getIcon("CollapsiblePane.titleButtonBackground");
    }

    @Override
    public ImageIcon getCollapsiblePaneTitleButtonBackgroundEmphasized() {
        return (ImageIcon)UIDefaultsLookup.getIcon("CollapsiblePane.titleButtonBackground.emphasized");
    }

    @Override
    public ImageIcon getCollapsiblePaneUpMask() {
        return this.getCollapsiblePaneUpIcon();
    }

    @Override
    public ImageIcon getCollapsiblePaneDownMask() {
        return this.getCollapsiblePaneDownIcon();
    }

    @Override
    public Color getBackgroundDk() {
        return UIDefaultsLookup.getColor("JideButton.background");
    }

    @Override
    public Color getBackgroundLt() {
        return UIDefaultsLookup.getColor("JideButton.background");
    }

    @Override
    public Color getSelectionSelectedDk() {
        return this._bk2;
    }

    @Override
    public Color getSelectionSelectedLt() {
        return this._bk2;
    }

    @Override
    public Color getMenuItemBorderColor() {
        return UIDefaultsLookup.getColor("MenuItem.selectionBorderColor");
    }

    @Override
    public Color getMenuItemBackground() {
        return UIDefaultsLookup.getColor("MenuItem.background");
    }

    @Override
    public Color getCommandBarTitleBarBackground() {
        return UIDefaultsLookup.getColor("CommandBar.titleBarBackground");
    }

    @Override
    public Color getControl() {
        return UIDefaultsLookup.getColor("JideButton.background");
    }

    @Override
    public Color getControlLt() {
        return this.getControlShadow();
    }

    @Override
    public Color getControlDk() {
        return this.getControlShadow();
    }

    @Override
    public Color getControlShadow() {
        return UIDefaultsLookup.getColor("JideButton.shadow");
    }

    @Override
    public Color getTitleBarBackground() {
        return UIDefaultsLookup.getColor("DockableFrame.activeTitleBackground");
    }

    @Override
    public Color getDockableFrameTitleBarActiveForeground() {
        return UIDefaultsLookup.getColor("DockableFrame.activeTitleForeground");
    }

    @Override
    public Color getDockableFrameTitleBarInactiveForeground() {
        return UIDefaultsLookup.getColor("DockableFrame.inactiveTitleForeground");
    }

    @Override
    public Color getOptionPaneBannerForeground() {
        return new ColorUIResource(255, 255, 255);
    }

    @Override
    public Color getTabbedPaneSelectDk() {
        return new ColorUIResource(230, 139, 44);
    }

    @Override
    public Color getTabbedPaneSelectLt() {
        return new ColorUIResource(255, 199, 60);
    }

    @Override
    public Color getTabAreaBackgroundDk() {
        return this.getBackgroundLt();
    }

    @Override
    public Color getTabAreaBackgroundLt() {
        return new ColorUIResource(255, 255, 255);
    }

    @Override
    public Color getOptionPaneBannerDk() {
        return new ColorUIResource(45, 96, 249);
    }

    @Override
    public Color getOptionPaneBannerLt() {
        return new ColorUIResource(0, 52, 206);
    }

    @Override
    public void paintSelectedMenu(JComponent c, Graphics g, Rectangle rect, int orientation, int state) {
        Color oldColor = g.getColor();
        g.setColor(UIDefaultsLookup.getColor("JideButton.darkShadow"));
        g.drawLine(rect.x, rect.y + rect.height, rect.x, rect.y + 1);
        g.drawLine(rect.x + rect.width - 2, rect.y, rect.x + rect.width - 2, rect.y + rect.height);
        if (orientation == 0) {
            g.drawLine(rect.x, rect.y, rect.x + rect.width - 3, rect.y);
        } else {
            g.drawLine(rect.x, rect.y + rect.height - 1, rect.x + rect.width - 3, rect.y + rect.height - 1);
        }
        g.setColor(oldColor);
    }

    @Override
    public void paintMenuItemBackground(JComponent c, Graphics g, Rectangle rect, int orientation, int state) {
        this.paintMenuItemBackground(c, g, rect, orientation, state, true);
    }

    @Override
    public void paintMenuItemBackground(JComponent c, Graphics g, Rectangle rect, int orientation, int state, boolean showBorder) {
        this.paintButtonBackground(c, g, rect, orientation, state, showBorder);
    }

    @Override
    public void paintButtonBackground(JComponent c, Graphics g, Rectangle rect, int orientation, int state) {
        this.paintButtonBackground(c, g, rect, orientation, state, true);
    }

    @Override
    public void paintButtonBackground(JComponent c, Graphics g, Rectangle rect, int orientation, int state, boolean showBorder) {
        this.installDefaults();
        Color background = null;
        switch (state) {
            case 0: {
                background = c.getBackground();
                if (background == null || background instanceof UIResource) {
                    background = this._bk0;
                }
                this.paintBackground(c, g, rect, showBorder ? this._borderColor : null, background, orientation);
                break;
            }
            case 2: {
                if (c instanceof ComponentStateSupport) {
                    background = ((ComponentStateSupport)((Object)c)).getBackgroundOfState(2);
                }
                if (background == null || background instanceof UIResource) {
                    background = this._bk1;
                }
                this.paintBackground(c, g, rect, showBorder ? this._borderColor : null, background, orientation);
                break;
            }
            case 3: {
                if (c instanceof ComponentStateSupport) {
                    background = ((ComponentStateSupport)((Object)c)).getBackgroundOfState(3);
                }
                if (background == null || background instanceof UIResource) {
                    background = this._bk2;
                }
                this.paintBackground(c, g, rect, showBorder ? this._borderColor : null, background, orientation);
                break;
            }
            case 1: {
                if (c instanceof ComponentStateSupport) {
                    background = ((ComponentStateSupport)((Object)c)).getBackgroundOfState(1);
                }
                if (background == null || background instanceof UIResource) {
                    background = this._bk3;
                }
                this.paintBackground(c, g, rect, showBorder ? this._borderColor : null, background, orientation);
            }
        }
    }

    protected void paintBackground(JComponent c, Graphics g, Rectangle rect, Color borderColor, Color background, int orientation) {
        Color oldColor = g.getColor();
        if (borderColor != null) {
            boolean paintDefaultBorder = true;
            Object o = c.getClientProperty("JideButton.paintDefaultBorder");
            if (o instanceof Boolean) {
                paintDefaultBorder = (Boolean)o;
            }
            if (paintDefaultBorder) {
                g.setColor(borderColor);
                Object position = c.getClientProperty("JButton.segmentPosition");
                if (position == null || "only".equals(position)) {
                    g.drawRect(rect.x, rect.y, rect.width - 1, rect.height - 1);
                } else if ("first".equals(position)) {
                    if (orientation == 0) {
                        g.drawRect(rect.x, rect.y, rect.width, rect.height - 1);
                    } else {
                        g.drawRect(rect.x, rect.y, rect.width - 1, rect.height);
                    }
                } else if ("middle".equals(position)) {
                    if (orientation == 0) {
                        g.drawRect(rect.x, rect.y, rect.width, rect.height - 1);
                    } else {
                        g.drawRect(rect.x, rect.y, rect.width - 1, rect.height);
                    }
                } else if ("last".equals(position)) {
                    if (orientation == 0) {
                        g.drawRect(rect.x, rect.y, rect.width - 1, rect.height - 1);
                    } else {
                        g.drawRect(rect.x, rect.y, rect.width - 1, rect.height - 1);
                    }
                }
            }
            g.setColor(background);
            g.fillRect(rect.x + 1, rect.y + 1, rect.width - 2, rect.height - 2);
        } else {
            g.setColor(background);
            g.fillRect(rect.x, rect.y, rect.width, rect.height);
        }
        g.setColor(oldColor);
    }

    @Override
    public void paintChevronBackground(JComponent c, Graphics g, Rectangle rect, int orientation, int state) {
        if (state != 0) {
            this.paintButtonBackground(c, g, rect, orientation, state);
        }
    }

    @Override
    public void paintDividerBackground(JComponent c, Graphics g, Rectangle rect, int orientation, int state) {
        Color oldColor = g.getColor();
        g.setColor(UIDefaultsLookup.getColor("SplitPane.background"));
        g.fillRect(0, 0, rect.width, rect.height);
        g.setColor(oldColor);
    }

    @Override
    public void paintCommandBarBackground(JComponent c, Graphics g, Rectangle rect, int orientation, int state) {
        g.setColor(UIDefaultsLookup.getColor("CommandBar.background"));
        g.fillRoundRect(rect.x, rect.y, rect.width, rect.height, 2, 2);
    }

    @Override
    public void paintFloatingCommandBarBackground(JComponent c, Graphics g, Rectangle rect, int orientation, int state) {
        g.setColor(UIDefaultsLookup.getColor("CommandBar.background"));
        g.fillRect(rect.x, rect.y, rect.width, rect.height);
    }

    @Override
    public void paintMenuShadow(JComponent c, Graphics g, Rectangle rect, int orientation, int state) {
        Color oldColor = g.getColor();
        g.setColor(UIDefaultsLookup.getColor("MenuItem.shadowColor"));
        g.fillRect(0, 0, rect.width, rect.height);
        g.setColor(oldColor);
    }

    @Override
    public void paintContentBackground(JComponent c, Graphics g, Rectangle rect, int orientation, int state) {
        g.setColor(UIDefaultsLookup.getColor("control"));
        g.fillRect(rect.x, rect.y, rect.width, rect.height);
    }

    @Override
    public void paintStatusBarBackground(JComponent c, Graphics g, Rectangle rect, int orientation, int state) {
        this.paintContentBackground(c, g, rect, orientation, state);
    }

    @Override
    public void paintCommandBarTitlePane(JComponent c, Graphics g, Rectangle rect, int orientation, int state) {
        g.setColor(this.getCommandBarTitleBarBackground());
        g.fillRect(rect.x, rect.y, rect.width, rect.height);
    }

    @Override
    public void paintGripper(JComponent c, Graphics g, Rectangle rect, int orientation, int state) {
        int w = Math.min(30, rect.width);
        int h = rect.height;
        g.setColor(this.getGripperForeground());
        if (orientation == 0) {
            if (rect.width <= 30) {
                int MARGIN = 3;
                for (int i = 0; i < (h - 6) / 2; ++i) {
                    g.drawLine(rect.x + 3, rect.y + 3 + i * 2, rect.x + w - 3, rect.y + 3 + i * 2);
                }
            } else {
                int MARGIN = 2;
                for (int i = 0; i < (h - 4) / 2; ++i) {
                    g.drawLine((rect.width - w) / 2, rect.y + 2 + i * 2, (rect.width + w) / 2, rect.y + 2 + i * 2);
                }
            }
        } else {
            int MARGIN = 3;
            int count = (w - 6) / 2;
            for (int i = 0; i < count; ++i) {
                int x = rect.x + rect.width / 2 - count + i * 2;
                g.drawLine(x, rect.y + 3, x, rect.y + h - 3);
            }
        }
    }

    @Override
    public void paintChevronMore(JComponent c, Graphics g, Rectangle rect, int orientation, int state) {
        g.setColor(UIDefaultsLookup.getColor("CommandBar.darkShadow"));
        int y = rect.y + 4;
        for (int i = -2; i <= 2; ++i) {
            int offset = -Math.abs(i);
            g.drawLine(rect.x + 4 + offset, y, rect.x + 5 + offset, y);
            g.drawLine(rect.x + 8 + offset, y, rect.x + 9 + offset, y);
            ++y;
        }
    }

    @Override
    public void paintChevronOption(JComponent c, Graphics g, Rectangle rect, int orientation, int state) {
        int startY;
        int startX;
        if (orientation == 0) {
            startX = rect.x + 3;
            startY = rect.y + rect.height - 7;
        } else {
            startX = rect.x + rect.width - 7;
            startY = rect.y + 3;
        }
        JideSwingUtilities.paintArrow(g, UIDefaultsLookup.getColor("CommandBar.darkShadow"), startX, startY, 5, orientation);
    }

    @Override
    public void paintFloatingChevronOption(JComponent c, Graphics g, Rectangle rect, int orientation, int state) {
        int startX = rect.width / 2 - 4;
        int startY = rect.height / 2 - 2;
        if (state == 2) {
            JideSwingUtilities.paintArrow(g, Color.BLACK, startX, startY, 9, orientation);
        } else {
            JideSwingUtilities.paintArrow(g, Color.WHITE, startX, startY, 9, orientation);
        }
    }

    @Override
    public void paintDockableFrameBackground(JComponent c, Graphics g, Rectangle rect, int orientation, int state) {
        g.setColor(UIDefaultsLookup.getColor("DockableFrame.background"));
        g.fillRect(rect.x, rect.y, rect.width, rect.height);
    }

    @Override
    public void paintDockableFrameTitlePane(JComponent c, Graphics g, Rectangle rect, int orientation, int state) {
        int x = rect.x;
        int y = rect.y;
        int w = rect.width - 1;
        int h = rect.height;
        if (c.getBorder() != null) {
            Insets insets = c.getBorder().getBorderInsets(c);
            x += insets.left;
            y += insets.top;
            w -= insets.right + insets.left;
            h -= insets.top + insets.bottom;
        }
        rect = new Rectangle(x + 1, y + 1, w - 1, h - 1);
        if (state == 3) {
            g.setColor(UIDefaultsLookup.getColor("DockableFrame.activeTitleBorderColor"));
            if ("true".equals(SecurityUtils.getProperty("shadingtheme", "false"))) {
                g.drawRoundRect(x, y, w, h, 2, 2);
            } else {
                g.drawRect(x, y, w, h);
            }
            g.setColor(UIDefaultsLookup.getColor("DockableFrame.activeTitleBackground"));
            g.fillRect(rect.x, rect.y, rect.width, rect.height);
        } else {
            g.setColor(UIDefaultsLookup.getColor("DockableFrame.inactiveTitleBorderColor"));
            g.drawRoundRect(x, y, w, h, 2, 2);
            g.setColor(UIDefaultsLookup.getColor("DockableFrame.inactiveTitleBackground"));
            g.fillRect(rect.x, rect.y, rect.width, rect.height);
        }
        if ("true".equals(SecurityUtils.getProperty("shadingtheme", "false"))) {
            JideSwingUtilities.fillGradient(g, rect, 0);
        }
    }

    @Override
    public void paintCollapsiblePaneTitlePaneBackground(JComponent c, Graphics g, Rectangle rect, int orientation, int state) {
        if (!(c.getBackground() instanceof UIResource)) {
            g.setColor(c.getBackground());
        } else {
            g.setColor(UIDefaultsLookup.getColor("CollapsiblePane.background"));
        }
        g.fillRect(rect.x, rect.y, rect.width, rect.height);
    }

    @Override
    public void paintCollapsiblePaneTitlePaneBackgroundEmphasized(JComponent c, Graphics g, Rectangle rect, int orientation, int state) {
        if (!(c.getBackground() instanceof UIResource)) {
            g.setColor(c.getBackground());
        } else {
            g.setColor(UIDefaultsLookup.getColor("CollapsiblePane.emphasizedBackground"));
        }
        g.fillRect(rect.x, rect.y, rect.width, rect.height);
    }

    @Override
    public void paintCollapsiblePanesBackground(JComponent c, Graphics g, Rectangle rect, int orientation, int state) {
        if (!(c.getBackground() instanceof UIResource)) {
            g.setColor(c.getBackground());
            g.fillRect(rect.x, rect.y, rect.width, rect.height);
        } else {
            g.setColor(UIDefaultsLookup.getColor("TextField.background"));
            g.fillRect(rect.x, rect.y, rect.width, rect.height);
        }
    }

    @Override
    public void paintCollapsiblePaneTitlePaneBackgroundPlainEmphasized(JComponent c, Graphics g, Rectangle rect, int orientation, int state) {
        g.setColor(UIDefaultsLookup.getColor("CollapsiblePane.emphasizedBackground"));
        g.drawLine(rect.x, rect.y + rect.height - 1, rect.x + rect.width, rect.y + rect.height - 1);
    }

    @Override
    public void paintCollapsiblePaneTitlePaneBackgroundPlain(JComponent c, Graphics g, Rectangle rect, int orientation, int state) {
        if (!(c.getBackground() instanceof UIResource)) {
            g.setColor(c.getBackground());
        } else {
            g.setColor(UIDefaultsLookup.getColor("CollapsiblePane.background"));
        }
        switch (orientation) {
            case 3: {
                g.drawLine(rect.x + rect.width - 1, rect.y, rect.x + rect.width - 1, rect.y + rect.height - 1);
                break;
            }
            case 7: {
                g.drawLine(rect.x, rect.y, rect.x, rect.y + rect.height - 1);
                break;
            }
            case 1: {
                g.drawLine(rect.x, rect.y, rect.x + rect.width, rect.y);
            }
            default: {
                g.drawLine(rect.x, rect.y + rect.height - 1, rect.x + rect.width, rect.y + rect.height - 1);
            }
        }
    }

    @Override
    public void paintCollapsiblePaneTitlePaneBackgroundSeparatorEmphasized(JComponent c, Graphics g, Rectangle rect, int orientation, int state) {
        g.setColor(UIManager.getColor("CollapsiblePane.emphasizedBackground"));
        g.fillRect(rect.x, rect.y, rect.x + rect.width, rect.height);
    }

    @Override
    public void paintCollapsiblePaneTitlePaneBackgroundSeparator(JComponent c, Graphics g, Rectangle rect, int orientation, int state) {
        g.setColor(UIManager.getColor("CollapsiblePane.background"));
        g.fillRect(rect.x, rect.y, rect.x + rect.width, rect.height);
    }

    @Override
    public Color getColor(Object key) {
        return UIDefaultsLookup.getColor(key);
    }

    @Override
    public void paintTabAreaBackground(JComponent c, Graphics g, Rectangle rect, int orientation, int state) {
        if (c.isOpaque() && c instanceof JideTabbedPane) {
            JideTabbedPane tabbedPane = (JideTabbedPane)c;
            int tabShape = tabbedPane.getTabShape();
            int colorTheme = tabbedPane.getColorTheme();
            if (tabShape == 3) {
                g.setColor(UIDefaultsLookup.getColor("control"));
            } else if (colorTheme == 1) {
                g.setColor(UIDefaultsLookup.getColor("control"));
            } else if (colorTheme == 3) {
                g.setColor(UIDefaultsLookup.getColor("JideTabbedPane.tabAreaBackground"));
            } else {
                g.setColor(UIDefaultsLookup.getColor("control"));
            }
            g.fillRect(rect.x, rect.y, rect.width, rect.height);
        }
    }

    @Override
    public void paintTabBackground(JComponent c, Graphics g, Shape region, Color[] colors, int orientation, int state) {
        Graphics2D g2d = (Graphics2D)g.create();
        if (state == 0) {
            Color backgroundStart = colors[0];
            Color backgroundEnd = colors[1];
            if (backgroundEnd != null && backgroundStart != null) {
                int tabPlacement = 1;
                if (c instanceof JideTabbedPane) {
                    tabPlacement = ((JideTabbedPane)c).getTabPlacement();
                }
                switch (tabPlacement) {
                    case 2: {
                        JideSwingUtilities.fillGradient(g2d, region, backgroundStart, backgroundEnd, false);
                        break;
                    }
                    case 4: {
                        JideSwingUtilities.fillGradient(g2d, region, backgroundEnd, backgroundStart, false);
                        break;
                    }
                    case 3: {
                        JideSwingUtilities.fillGradient(g2d, region, backgroundEnd, backgroundStart, true);
                        break;
                    }
                    default: {
                        JideSwingUtilities.fillGradient(g2d, region, backgroundStart, backgroundEnd, true);
                    }
                }
            }
        }
        g2d.dispose();
    }

    @Override
    public void paintTabContentBorder(JComponent c, Graphics g, Rectangle rect, int orientation, int state) {
    }

    @Override
    public void paintSidePaneItemBackground(JComponent c, Graphics g, Rectangle rect, Color[] colors, int orientation, int state) {
        Color startColor = colors != null && colors.length > 0 ? colors[0] : c.getBackground();
        Color endColor = colors != null && colors.length > 1 ? colors[1] : startColor;
        switch (orientation) {
            case 7: {
                JideSwingUtilities.fillGradient((Graphics2D)g, rect, startColor, endColor, false);
                break;
            }
            case 3: {
                JideSwingUtilities.fillGradient((Graphics2D)g, rect, endColor, startColor, false);
                break;
            }
            case 1: {
                JideSwingUtilities.fillGradient((Graphics2D)g, rect, startColor, endColor, true);
                break;
            }
            case 5: {
                JideSwingUtilities.fillGradient((Graphics2D)g, rect, endColor, startColor, true);
            }
        }
    }

    @Override
    public void paintHeaderBoxBackground(JComponent c, Graphics g, Rectangle rect, int orientation, int state) {
        boolean isCellEditor = Boolean.TRUE.equals(c.getClientProperty("HeaderBox.isTableCellEditor"));
        Color baseColor = c.getBackground();
        if (baseColor instanceof UIResource && (baseColor = UIDefaultsLookup.getColor("HeaderBox.background")) == null) {
            baseColor = UIDefaultsLookup.getColor("control");
        }
        if (state == 1 || state == 3 || state == 2) {
            Color color = ColorUtils.getDerivedColor(baseColor, 0.48f);
            if (isCellEditor) {
                g.setColor(color);
                g.fillRect(rect.x, rect.y, rect.width, rect.height);
            } else {
                g.setColor(color);
                g.fillRoundRect(rect.x, rect.y, rect.width - 1, rect.height - 1, 4, 4);
                g.setColor(ColorUtils.getDerivedColor(baseColor, 0.4f));
                g.drawRoundRect(rect.x, rect.y, rect.width - 1, rect.height - 1, 6, 6);
            }
            g.setColor(ColorUtils.getDerivedColor(baseColor, 0.45f));
            g.drawLine(rect.x + 1, rect.y + rect.height - 3, rect.x + rect.width - 2, rect.y + rect.height - 3);
            g.setColor(ColorUtils.getDerivedColor(baseColor, 0.43f));
            g.drawLine(rect.x + 2, rect.y + rect.height - 2, rect.x + rect.width - 3, rect.y + rect.height - 2);
            g.setColor(ColorUtils.getDerivedColor(baseColor, 0.4f));
            g.drawLine(rect.x + 3, rect.y + rect.height - 1, rect.x + rect.width - 4, rect.y + rect.height - 1);
        } else {
            if (isCellEditor) {
                g.setColor(baseColor);
                g.fillRect(rect.x, rect.y, rect.width - 1, rect.height - 1);
            } else {
                g.setColor(baseColor);
                g.fillRoundRect(rect.x, rect.y, rect.width - 1, rect.height - 1, 2, 2);
                g.setColor(ColorUtils.getDerivedColor(baseColor, 0.42f));
                g.drawRoundRect(rect.x, rect.y, rect.width - 1, rect.height - 1, 2, 4);
            }
            g.setColor(ColorUtils.getDerivedColor(baseColor, 0.48f));
            g.drawLine(rect.x + 1, rect.y + rect.height - 3, rect.x + rect.width - 2, rect.y + rect.height - 3);
            g.setColor(ColorUtils.getDerivedColor(baseColor, 0.47f));
            g.drawLine(rect.x + 1, rect.y + rect.height - 2, rect.x + rect.width - 2, rect.y + rect.height - 2);
            if (isCellEditor) {
                g.setColor(new Color(198, 197, 178));
                g.drawLine(rect.x + rect.width - 3, rect.y + 4, rect.x + rect.width - 3, rect.y + rect.height - 7);
                g.setColor(Color.WHITE);
                g.drawLine(rect.x + rect.width - 2, rect.y + 4, rect.x + rect.width - 2, rect.y + rect.height - 7);
            }
        }
    }
}

