/*
 * Decompiled with CFR 0.152.
 */
package com.sshtools.j2ssh.transport.publickey;

import com.sshtools.j2ssh.configuration.ConfigurationLoader;
import com.sshtools.j2ssh.io.ByteArrayReader;
import com.sshtools.j2ssh.io.ByteArrayWriter;
import com.sshtools.j2ssh.transport.publickey.Base64EncodedFileFormat;
import com.sshtools.j2ssh.transport.publickey.InvalidSshKeyException;
import com.sshtools.j2ssh.transport.publickey.SshPrivateKeyFormat;
import com.sshtools.j2ssh.util.Hash;
import java.io.IOException;
import java.security.Key;
import java.security.NoSuchAlgorithmException;
import javax.crypto.Cipher;
import javax.crypto.SecretKey;
import javax.crypto.SecretKeyFactory;
import javax.crypto.spec.DESedeKeySpec;
import javax.crypto.spec.IvParameterSpec;

public class SshtoolsPrivateKeyFormat
extends Base64EncodedFileFormat
implements SshPrivateKeyFormat {
    private static String BEGIN = "---- BEGIN SSHTOOLS ENCRYPTED PRIVATE KEY ----";
    private static String END = "---- END SSHTOOLS ENCRYPTED PRIVATE KEY ----";
    private int cookie = 1391688382;

    public SshtoolsPrivateKeyFormat(String subject, String comment) {
        super(BEGIN, END);
        this.setHeaderValue("Subject", subject);
        this.setHeaderValue("Comment", comment);
    }

    public SshtoolsPrivateKeyFormat() {
        super(BEGIN, END);
    }

    public String getFormatType() {
        return "SSHTools-PrivateKey-" + super.getFormatType();
    }

    public boolean isPassphraseProtected(byte[] formattedKey) {
        String type;
        block4: {
            ByteArrayReader bar = new ByteArrayReader(this.getKeyBlob(formattedKey));
            type = bar.readString();
            if (!type.equals("none")) break block4;
            return false;
        }
        try {
            if (type.equalsIgnoreCase("3des-cbc")) {
                return true;
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return false;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public byte[] decryptKeyblob(byte[] formattedKey, String passphrase) throws InvalidSshKeyException {
        try {
            byte[] keyblob = this.getKeyBlob(formattedKey);
            ByteArrayReader bar = new ByteArrayReader(keyblob);
            String type = bar.readString();
            if (!type.equalsIgnoreCase("3des-cbc")) return bar.readBinaryString();
            byte[] keydata = this.makePassphraseKey(passphrase);
            byte[] iv = new byte[8];
            if (type.equals("3DES-CBC")) {
                bar.read(iv);
            }
            keyblob = bar.readBinaryString();
            Cipher cipher = Cipher.getInstance("DESede/CBC/PKCS5Padding");
            DESedeKeySpec keyspec = new DESedeKeySpec(keydata);
            SecretKey key = SecretKeyFactory.getInstance("DESede").generateSecret(keyspec);
            cipher.init(2, (Key)key, new IvParameterSpec(iv, 0, cipher.getBlockSize()));
            ByteArrayReader data = new ByteArrayReader(cipher.doFinal(keyblob));
            if (data.readInt() != (long)this.cookie) throw new InvalidSshKeyException("The host key is invalid, check the passphrase supplied");
            return data.readBinaryString();
        }
        catch (Exception aoe) {
            throw new InvalidSshKeyException("Failed to read host key");
        }
    }

    public byte[] encryptKeyblob(byte[] keyblob, String passphrase) {
        try {
            ByteArrayWriter baw = new ByteArrayWriter();
            String type = "none";
            if (passphrase != null && !passphrase.trim().equals("")) {
                type = "3DES-CBC";
                byte[] keydata = this.makePassphraseKey(passphrase);
                byte[] iv = new byte[8];
                ConfigurationLoader.getRND().nextBytes(iv);
                Cipher cipher = Cipher.getInstance("DESede/CBC/PKCS5Padding");
                DESedeKeySpec keyspec = new DESedeKeySpec(keydata);
                SecretKey key = SecretKeyFactory.getInstance("DESede").generateSecret(keyspec);
                cipher.init(1, (Key)key, new IvParameterSpec(iv, 0, cipher.getBlockSize()));
                ByteArrayWriter data = new ByteArrayWriter();
                baw.writeString(type);
                baw.write(iv);
                data.writeInt(this.cookie);
                data.writeBinaryString(keyblob);
                baw.writeBinaryString(cipher.doFinal(data.toByteArray()));
                return this.formatKey(baw.toByteArray());
            }
            baw.writeString(type);
            baw.writeBinaryString(keyblob);
            return this.formatKey(baw.toByteArray());
        }
        catch (Exception ioe) {
            return null;
        }
    }

    public boolean supportsAlgorithm(String algorithm) {
        return true;
    }

    private byte[] makePassphraseKey(String passphrase) {
        try {
            Hash md5 = new Hash("MD5");
            md5.putBytes(passphrase.getBytes());
            byte[] key1 = md5.doFinal();
            md5.reset();
            md5.putBytes(passphrase.getBytes());
            md5.putBytes(key1);
            byte[] key2 = md5.doFinal();
            byte[] key = new byte[32];
            System.arraycopy(key1, 0, key, 0, 16);
            System.arraycopy(key2, 0, key, 16, 16);
            return key;
        }
        catch (NoSuchAlgorithmException nsae) {
            return null;
        }
    }
}

