/*
 * Decompiled with CFR 0.152.
 */
package com.sshtools.j2ssh.connection;

import com.sshtools.j2ssh.io.ByteArrayReader;
import com.sshtools.j2ssh.io.ByteArrayWriter;
import com.sshtools.j2ssh.transport.InvalidMessageException;
import com.sshtools.j2ssh.transport.SshMessage;
import java.io.IOException;

public class SshMsgChannelOpen
extends SshMessage {
    protected static final int SSH_MSG_CHANNEL_OPEN = 90;
    private String channelType;
    private byte[] channelData;
    private long initialWindowSize;
    private long maximumPacketSize;
    private long senderChannelId;

    public SshMsgChannelOpen(String channelType, long senderChannelId, long initialWindowSize, long maximumPacketSize, byte[] channelData) {
        super(90);
        this.channelType = channelType;
        this.senderChannelId = senderChannelId;
        this.initialWindowSize = initialWindowSize;
        this.maximumPacketSize = maximumPacketSize;
        this.channelData = channelData;
    }

    public SshMsgChannelOpen() {
        super(90);
    }

    public byte[] getChannelData() {
        return this.channelData;
    }

    public String getChannelType() {
        return this.channelType;
    }

    public long getInitialWindowSize() {
        return this.initialWindowSize;
    }

    public long getMaximumPacketSize() {
        return this.maximumPacketSize;
    }

    public String getMessageName() {
        return "SSH_MSG_CHANNEL_OPEN";
    }

    public long getSenderChannelId() {
        return this.senderChannelId;
    }

    protected void constructByteArray(ByteArrayWriter baw) throws InvalidMessageException {
        try {
            baw.writeString(this.channelType);
            baw.writeInt(this.senderChannelId);
            baw.writeInt(this.initialWindowSize);
            baw.writeInt(this.maximumPacketSize);
            if (this.channelData != null) {
                baw.write(this.channelData);
            }
        }
        catch (IOException ioe) {
            throw new InvalidMessageException("Could not write message data");
        }
    }

    protected void constructMessage(ByteArrayReader bar) throws InvalidMessageException {
        try {
            this.channelType = bar.readString();
            this.senderChannelId = bar.readInt();
            this.initialWindowSize = bar.readInt();
            this.maximumPacketSize = bar.readInt();
            if (bar.available() > 0) {
                this.channelData = new byte[bar.available()];
                bar.read(this.channelData);
            }
        }
        catch (IOException ioe) {
            throw new InvalidMessageException("Invalid message data");
        }
    }
}

