/*
 * Decompiled with CFR 0.152.
 */
package com.sshtools.common.keygen;

import com.sshtools.common.ui.NumericTextField;
import com.sshtools.common.ui.UIUtil;
import com.sshtools.common.ui.XTextField;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.GridLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JPasswordField;
import javax.swing.JProgressBar;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;

public class KeygenPanel
extends JPanel
implements DocumentListener,
ActionListener {
    public static final int GENERATE_KEY_PAIR = 0;
    public static final int CONVERT_IETF_SECSH_TO_OPENSSH = 1;
    public static final int CONVERT_OPENSSH_TO_IETF_SECSH = 2;
    public static final int CHANGE_PASSPHRASE = 3;
    private JButton browseInput;
    private JButton browseOutput;
    private JComboBox action;
    private JComboBox type;
    private JLabel bitsLabel;
    private JLabel inputFileLabel;
    private JLabel newPassphraseLabel;
    private JLabel oldPassphraseLabel;
    private JLabel outputFileLabel;
    private JLabel typeLabel;
    private JPasswordField newPassphrase;
    private JPasswordField oldPassphrase;
    private JProgressBar strength;
    private XTextField inputFile;
    private XTextField outputFile;
    private NumericTextField bits;

    public KeygenPanel() {
        JPanel keyPanel = new JPanel(new GridBagLayout());
        keyPanel.setBorder(BorderFactory.createTitledBorder("Key"));
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.fill = 0;
        gbc.anchor = 17;
        Insets normalInsets = new Insets(0, 2, 4, 2);
        Insets indentedInsets = new Insets(0, 26, 4, 2);
        gbc.insets = normalInsets;
        gbc.weightx = 0.0;
        UIUtil.jGridBagAdd(keyPanel, new JLabel("Action"), gbc, 1);
        gbc.weightx = 1.0;
        this.action = new JComboBox<String>(new String[]{"Generate key pair", "Convert IETF SECSH to OpenSSH", "Convert OpenSSH to IETF SECSH", "Change passphrase"});
        this.action.addActionListener(this);
        gbc.weightx = 2.0;
        UIUtil.jGridBagAdd(keyPanel, this.action, gbc, -1);
        gbc.weightx = 0.0;
        UIUtil.jGridBagAdd(keyPanel, new JLabel(), gbc, 0);
        gbc.insets = indentedInsets;
        this.inputFileLabel = new JLabel("Input File");
        UIUtil.jGridBagAdd(keyPanel, this.inputFileLabel, gbc, 1);
        gbc.insets = normalInsets;
        gbc.weightx = 1.0;
        this.inputFile = new XTextField(20);
        UIUtil.jGridBagAdd(keyPanel, this.inputFile, gbc, -1);
        this.inputFileLabel.setLabelFor(this.inputFile);
        gbc.weightx = 0.0;
        this.browseInput = new JButton("Browse");
        this.browseInput.setMnemonic('b');
        this.browseInput.addActionListener(this);
        UIUtil.jGridBagAdd(keyPanel, this.browseInput, gbc, 0);
        gbc.insets = indentedInsets;
        this.outputFileLabel = new JLabel("Output File");
        UIUtil.jGridBagAdd(keyPanel, this.outputFileLabel, gbc, 1);
        gbc.insets = normalInsets;
        gbc.weightx = 1.0;
        this.outputFile = new XTextField(20);
        UIUtil.jGridBagAdd(keyPanel, this.outputFile, gbc, -1);
        gbc.weightx = 0.0;
        this.outputFileLabel.setLabelFor(this.outputFile);
        this.browseOutput = new JButton("Browse");
        this.browseOutput.setMnemonic('r');
        this.browseOutput.addActionListener(this);
        UIUtil.jGridBagAdd(keyPanel, this.browseOutput, gbc, 0);
        gbc.insets = indentedInsets;
        this.oldPassphraseLabel = new JLabel("Old Passphrase");
        UIUtil.jGridBagAdd(keyPanel, this.oldPassphraseLabel, gbc, 1);
        gbc.insets = normalInsets;
        gbc.weightx = 2.0;
        this.oldPassphrase = new JPasswordField(20);
        this.oldPassphrase.setBackground(Color.white);
        this.oldPassphrase.getDocument().addDocumentListener(this);
        this.oldPassphraseLabel.setLabelFor(this.oldPassphrase);
        UIUtil.jGridBagAdd(keyPanel, this.oldPassphrase, gbc, -1);
        UIUtil.jGridBagAdd(keyPanel, new JLabel(), gbc, 0);
        gbc.insets = indentedInsets;
        this.newPassphraseLabel = new JLabel("New Passphrase");
        UIUtil.jGridBagAdd(keyPanel, this.newPassphraseLabel, gbc, 1);
        gbc.insets = normalInsets;
        gbc.weightx = 2.0;
        this.newPassphrase = new JPasswordField(20);
        this.newPassphrase.setBackground(Color.white);
        this.newPassphrase.getDocument().addDocumentListener(this);
        this.newPassphraseLabel.setLabelFor(this.newPassphrase);
        UIUtil.jGridBagAdd(keyPanel, this.newPassphrase, gbc, -1);
        UIUtil.jGridBagAdd(keyPanel, new JLabel(), gbc, 0);
        gbc.insets = indentedInsets;
        this.bitsLabel = new JLabel("Bits");
        UIUtil.jGridBagAdd(keyPanel, this.bitsLabel, gbc, 1);
        gbc.weightx = 2.0;
        gbc.insets = normalInsets;
        this.bits = new NumericTextField(new Integer(512), new Integer(1024), new Integer(1024));
        this.bitsLabel.setLabelFor(this.bits);
        UIUtil.jGridBagAdd(keyPanel, this.bits, gbc, -1);
        UIUtil.jGridBagAdd(keyPanel, new JLabel(), gbc, 0);
        gbc.insets = indentedInsets;
        this.typeLabel = new JLabel("Type");
        UIUtil.jGridBagAdd(keyPanel, this.typeLabel, gbc, 1);
        gbc.insets = normalInsets;
        gbc.weightx = 2.0;
        this.type = new JComboBox<String>(new String[]{"DSA", "RSA"});
        this.type.setFont(this.inputFile.getFont());
        UIUtil.jGridBagAdd(keyPanel, this.type, gbc, -1);
        UIUtil.jGridBagAdd(keyPanel, new JLabel(), gbc, 0);
        this.strength = new JProgressBar(0, 40);
        this.strength.setStringPainted(true);
        JPanel strengthPanel = new JPanel(new GridLayout(1, 1));
        strengthPanel.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createTitledBorder("Passphrase strength"), BorderFactory.createEmptyBorder(4, 4, 4, 4)));
        strengthPanel.add(this.strength);
        this.setLayout(new BorderLayout());
        this.add((Component)keyPanel, "Center");
        this.add((Component)strengthPanel, "South");
        this.calculateStrength();
        this.setAvailableActions();
    }

    public int getAction() {
        return this.action.getSelectedIndex();
    }

    public int getBits() {
        return (Integer)this.bits.getValue();
    }

    public String getInputFilename() {
        return this.inputFile.getText();
    }

    public char[] getNewPassphrase() {
        return this.newPassphrase.getPassword();
    }

    public char[] getOldPassphrase() {
        return this.oldPassphrase.getPassword();
    }

    public String getOutputFilename() {
        return this.outputFile.getText();
    }

    public String getType() {
        return (String)this.type.getSelectedItem();
    }

    public void actionPerformed(ActionEvent evt) {
        if (evt.getSource() == this.browseOutput) {
            File f = new File(this.outputFile.getText());
            JFileChooser chooser = new JFileChooser(f);
            chooser.setSelectedFile(f);
            chooser.setDialogTitle("Choose output file ..");
            chooser.setFileSelectionMode(0);
            if (chooser.showSaveDialog(this) == 0) {
                this.outputFile.setText(chooser.getSelectedFile().getPath());
            }
        } else if (evt.getSource() == this.browseInput) {
            File f = new File(this.inputFile.getText());
            JFileChooser chooser = new JFileChooser(f);
            chooser.setSelectedFile(f);
            chooser.setDialogTitle("Choose input file ..");
            chooser.setFileSelectionMode(0);
            if (chooser.showOpenDialog(this) == 0) {
                this.inputFile.setText(chooser.getSelectedFile().getPath());
            }
        } else {
            this.setAvailableActions();
        }
    }

    public void changedUpdate(DocumentEvent e) {
        this.calculateStrength();
    }

    public void insertUpdate(DocumentEvent e) {
        this.calculateStrength();
    }

    public void removeUpdate(DocumentEvent e) {
        this.calculateStrength();
    }

    private void setAvailableActions() {
        this.inputFile.setEnabled(this.getAction() == 1 || this.getAction() == 2 || this.getAction() == 3);
        this.inputFileLabel.setEnabled(this.inputFile.isEnabled());
        this.browseInput.setEnabled(this.inputFile.isEnabled());
        this.bits.setEnabled(this.getAction() == 0);
        this.bitsLabel.setEnabled(this.bits.isEnabled());
        this.outputFile.setEnabled(this.getAction() == 1 || this.getAction() == 2 || this.getAction() == 0);
        this.outputFileLabel.setEnabled(this.outputFile.isEnabled());
        this.browseOutput.setEnabled(this.outputFile.isEnabled());
        this.newPassphrase.setEnabled(this.getAction() == 0 || this.getAction() == 3);
        this.newPassphraseLabel.setEnabled(this.newPassphrase.isEnabled());
        this.oldPassphrase.setEnabled(this.getAction() == 3);
        this.oldPassphraseLabel.setEnabled(this.oldPassphrase.isEnabled());
        this.type.setEnabled(this.getAction() == 0);
        this.typeLabel.setEnabled(this.type.isEnabled());
        if (this.inputFile.isEnabled()) {
            this.inputFile.requestFocus();
        } else {
            this.outputFile.requestFocus();
        }
    }

    private void calculateStrength() {
        String t;
        Color f;
        char[] pw = this.newPassphrase.getPassword();
        this.strength.setValue(pw.length < 40 ? pw.length : 40);
        if (pw.length == 0) {
            f = Color.red;
            t = "Empty!!";
        } else {
            StringBuffer buf = new StringBuffer();
            buf.append(pw.length);
            buf.append(" characters - ");
            if (pw.length < 10) {
                f = Color.red;
                buf.append("Weak!");
            } else if (pw.length < 20) {
                f = Color.orange;
                buf.append("Ok");
            } else if (pw.length < 30) {
                f = Color.green.darker();
                buf.append("Strong");
            } else {
                f = Color.green;
                buf.append("Very strong!");
            }
            t = buf.toString();
        }
        this.strength.setString(t);
        this.strength.setForeground(f);
    }
}

