/*
 * Decompiled with CFR 0.152.
 */
package org.parosproxy.paros.extension.history;

import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JList;
import javax.swing.JTree;
import org.parosproxy.paros.extension.ExtensionPopupMenu;
import org.parosproxy.paros.extension.history.ExtensionHistory;
import org.parosproxy.paros.model.HistoryList;
import org.parosproxy.paros.model.HistoryReference;
import org.parosproxy.paros.model.Model;
import org.parosproxy.paros.model.Session;
import org.parosproxy.paros.model.SiteMap;
import org.parosproxy.paros.model.SiteNode;
import org.parosproxy.paros.view.PopupPurgeMenu;

public class PopupMenuPurgeHistory
extends ExtensionPopupMenu {
    private ExtensionHistory extension = null;
    private JTree treeSite = null;

    public PopupMenuPurgeHistory() {
        this.initialize();
    }

    public PopupMenuPurgeHistory(String string) {
        super(string);
    }

    private void initialize() {
        this.setText("Purge (from DB)");
        this.addActionListener(new ActionListener(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void actionPerformed(ActionEvent actionEvent) {
                int n;
                JList jList = PopupMenuPurgeHistory.this.extension.getLogPanel().getListLog();
                Object[] objectArray = jList.getSelectedValues();
                if (objectArray.length > 1 && (n = PopupMenuPurgeHistory.this.extension.getView().showConfirmDialog("The history will be purged from database.  Proceed?")) != 0) {
                    return;
                }
                HistoryList historyList = PopupMenuPurgeHistory.this.extension.getHistoryList();
                synchronized (historyList) {
                    for (int i = 0; i < objectArray.length; ++i) {
                        HistoryReference historyReference = (HistoryReference)objectArray[i];
                        PopupMenuPurgeHistory.this.purgeHistory(historyReference);
                    }
                }
            }
        });
    }

    public boolean isEnableForComponent(Component component) {
        if (component.getName() != null && component.getName().equals("ListLog")) {
            try {
                JList jList = (JList)component;
                if (jList.getSelectedIndex() >= 0) {
                    this.setEnabled(true);
                } else {
                    this.setEnabled(false);
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
            return true;
        }
        return false;
    }

    void setExtension(ExtensionHistory extensionHistory) {
        this.extension = extensionHistory;
    }

    private void purgeHistory(HistoryReference historyReference) {
        if (historyReference == null) {
            return;
        }
        this.extension.getHistoryList().removeElement(historyReference);
        historyReference.delete();
        SiteNode siteNode = historyReference.getSiteNode();
        if (siteNode == null) {
            return;
        }
        Session session = Model.getSingleton().getSession();
        SiteMap siteMap = session.getSiteTree();
        if (siteNode.getHistoryReference() == historyReference) {
            PopupPurgeMenu.purge(siteMap, siteNode);
        } else {
            siteNode.getPastHistoryReference().remove(historyReference);
        }
    }
}

