/*
 * Decompiled with CFR 0.152.
 */
package org.parosproxy.paros.db;

import java.sql.CallableStatement;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import org.parosproxy.paros.db.AbstractTable;
import org.parosproxy.paros.db.RecordScan;

public class TableScan
extends AbstractTable {
    private static final String SCANID = "SCANID";
    private static final String SESSIONID = "SESSIONID";
    private static final String SCANNAME = "SCANNAME";
    private static final String SCANTIME = "SCANTIME";
    private PreparedStatement psRead = null;
    private PreparedStatement psInsert1 = null;
    private CallableStatement psInsert2 = null;
    private PreparedStatement psUpdate = null;

    protected void reconnect(Connection connection) throws SQLException {
        this.psRead = connection.prepareStatement("SELECT * FROM SCAN WHERE SCANID = ?");
        this.psInsert1 = connection.prepareStatement("INSERT INTO SCAN (SESSIONID,SCANNAME) VALUES (?, ?)");
        this.psInsert2 = connection.prepareCall("CALL IDENTITY();");
    }

    public synchronized RecordScan getLatestScan() throws SQLException {
        PreparedStatement preparedStatement = this.getConnection().prepareStatement("SELECT * FROM SCAN WHERE SCANID = (SELECT MAX(B.SCANID) FROM SCAN AS B)");
        preparedStatement.execute();
        ResultSet resultSet = preparedStatement.getResultSet();
        RecordScan recordScan = this.build(resultSet);
        resultSet.close();
        preparedStatement.close();
        return recordScan;
    }

    public synchronized RecordScan read(int n) throws SQLException {
        this.psRead.setInt(1, n);
        this.psRead.execute();
        ResultSet resultSet = this.psRead.getResultSet();
        RecordScan recordScan = this.build(resultSet);
        resultSet.close();
        return recordScan;
    }

    public synchronized RecordScan insert(long l, String string) throws SQLException {
        this.psInsert1.setLong(1, l);
        this.psInsert1.setString(2, string);
        this.psInsert1.executeUpdate();
        this.psInsert2.executeQuery();
        ResultSet resultSet = this.psInsert2.getResultSet();
        resultSet.next();
        int n = resultSet.getInt(1);
        resultSet.close();
        return this.read(n);
    }

    private RecordScan build(ResultSet resultSet) throws SQLException {
        RecordScan recordScan = null;
        if (resultSet.next()) {
            recordScan = new RecordScan(resultSet.getInt(SCANID), resultSet.getString(SCANNAME), resultSet.getDate(SCANTIME));
        }
        return recordScan;
    }
}

