/*
 * Decompiled with CFR 0.152.
 */
package org.parosproxy.paros.control;

import java.util.Vector;
import org.parosproxy.paros.core.proxy.CacheProcessingItem;
import org.parosproxy.paros.core.proxy.ProxyListener;
import org.parosproxy.paros.core.proxy.ProxyServer;
import org.parosproxy.paros.core.proxy.ProxyServerSSL;
import org.parosproxy.paros.model.Model;

public class Proxy {
    private Model model = null;
    private ProxyServer proxyServer = null;
    private ProxyServerSSL proxyServerSSL = null;
    private boolean reverseProxy = false;
    private String reverseProxyHost = "";
    private Vector cacheProcessingList = new Vector();

    public Proxy(Model model) {
        this.model = model;
        this.proxyServer = new ProxyServer();
        this.proxyServerSSL = new ProxyServerSSL();
    }

    public void startServer() {
        this.proxyServer.setProxyParam(this.model.getOptionsParam().getProxyParam());
        this.proxyServer.setConnectionParam(this.model.getOptionsParam().getConnectionParam());
        this.proxyServerSSL.setProxyParam(this.model.getOptionsParam().getProxyParam());
        this.proxyServerSSL.setConnectionParam(this.model.getOptionsParam().getConnectionParam());
        if (this.model.getOptionsParam().getProxyParam().isUseReverseProxy()) {
            this.proxyServerSSL.startServer(this.model.getOptionsParam().getProxyParam().getReverseProxyIp(), this.model.getOptionsParam().getProxyParam().getReverseProxyHttpsPort(), false);
            this.proxyServer.startServer(this.model.getOptionsParam().getProxyParam().getReverseProxyIp(), this.model.getOptionsParam().getProxyParam().getReverseProxyHttpPort(), false);
        } else {
            this.proxyServer.startServer(this.model.getOptionsParam().getProxyParam().getProxyIp(), this.model.getOptionsParam().getProxyParam().getProxyPort(), false);
        }
    }

    public void stopServer() {
        if (this.model.getOptionsParam().getProxyParam().isUseReverseProxy()) {
            this.proxyServerSSL.stopServer();
            this.proxyServer.stopServer();
        } else {
            this.proxyServer.stopServer();
        }
    }

    public void setSerialize(boolean bl) {
        this.proxyServer.setSerialize(bl);
        this.proxyServerSSL.setSerialize(bl);
    }

    public void addProxyListener(ProxyListener proxyListener) {
        this.proxyServer.addProxyListener(proxyListener);
        this.proxyServerSSL.addProxyListener(proxyListener);
    }

    public void removeProxyListener(ProxyListener proxyListener) {
        this.proxyServer.removeProxyListener(proxyListener);
        this.proxyServerSSL.removeProxyListener(proxyListener);
    }

    public boolean isReverseProxy() {
        return this.reverseProxy;
    }

    public void setReverseProxy(boolean bl) {
        this.reverseProxy = bl;
    }

    public String getReverseProxyHost() {
        return this.reverseProxyHost;
    }

    public void setReverseProxyHost(String string) {
        this.reverseProxyHost = string;
    }

    public void setEnableCacheProcessing(boolean bl) {
        if (this.proxyServer != null) {
            this.proxyServer.setEnableCacheProcessing(bl);
        }
        if (this.proxyServerSSL != null) {
            this.proxyServerSSL.setEnableCacheProcessing(bl);
        }
    }

    public void addCacheProcessingList(CacheProcessingItem cacheProcessingItem) {
        if (this.proxyServer != null) {
            this.proxyServer.addCacheProcessingList(cacheProcessingItem);
        }
        if (this.proxyServerSSL != null) {
            this.proxyServerSSL.addCacheProcessingList(cacheProcessingItem);
        }
    }
}

