/*
 * Decompiled with CFR 0.152.
 */
package io.vavr.collection;

import io.vavr.collection.Collections;
import io.vavr.collection.Comparators;
import io.vavr.collection.Set;
import io.vavr.collection.SortedSet;
import io.vavr.collection.TreeSet;
import java.util.Comparator;
import java.util.Objects;
import java.util.function.Function;
import java.util.function.Predicate;

public interface BitSet<T>
extends SortedSet<T> {
    public static final long serialVersionUID = 1L;

    @Override
    public BitSet<T> add(T var1);

    public BitSet<T> drop(int var1);

    @Override
    public BitSet<T> filter(Predicate<? super T> var1);

    @Override
    default public boolean hasDefiniteSize() {
        return true;
    }

    @Override
    default public boolean isAsync() {
        return false;
    }

    @Override
    default public boolean isTraversableAgain() {
        return true;
    }

    @Override
    default public boolean isLazy() {
        return false;
    }

    @Override
    public BitSet<T> intersect(Set<? extends T> var1);

    @Override
    default public T last() {
        return Collections.last(this);
    }

    @Override
    default public String stringPrefix() {
        return "BitSet";
    }

    default public <U> SortedSet<U> map(Comparator<? super U> comparator, Function<? super T, ? extends U> mapper) {
        Objects.requireNonNull(mapper, "mapper is null");
        return TreeSet.ofAll(comparator, this.iterator().map(mapper));
    }

    @Override
    default public <U> SortedSet<U> map(Function<? super T, ? extends U> mapper) {
        return this.map(Comparators.naturalComparator(), mapper);
    }

    @Override
    default public BitSet<T> tail() {
        if (this.isEmpty()) {
            throw new UnsupportedOperationException("tail of empty BitSet");
        }
        return this.drop(1);
    }

    @Override
    default public java.util.SortedSet<T> toJavaSet() {
        return this.toJavaSet(ignore -> new java.util.TreeSet(this.comparator()));
    }
}

