/* soapC.cpp
   Generated by gSOAP 2.7.10 from interop_all.h
   Copyright(C) 2000-2008, Robert van Engelen, Genivia Inc. All Rights Reserved.
   This part of the software is released under one of the following licenses:
   GPL, the gSOAP public license, or Genivia's license for commercial use.
*/

#include "soapH.h"

SOAP_SOURCE_STAMP("@(#) soapC.cpp ver 2.7.10 2008-01-21 15:12:54 GMT")


#ifndef WITH_NOGLOBAL

SOAP_FMAC3 void SOAP_FMAC4 soap_serializeheader(struct soap *soap)
{
	if (soap->header)
		soap_serialize_SOAP_ENV__Header(soap, soap->header);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_putheader(struct soap *soap)
{
	if (soap->header)
	{	soap->part = SOAP_IN_HEADER;
		if (soap_out_SOAP_ENV__Header(soap, "SOAP-ENV:Header", 0, soap->header, NULL))
			return soap->error;
		soap->part = SOAP_END_HEADER;
	}
	return SOAP_OK;
}

SOAP_FMAC3 int SOAP_FMAC4 soap_getheader(struct soap *soap)
{
	soap->part = SOAP_IN_HEADER;
	soap->header = soap_in_SOAP_ENV__Header(soap, "SOAP-ENV:Header", NULL, NULL);
	soap->part = SOAP_END_HEADER;
	return soap->header == NULL;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_header(struct soap *soap)
{
	if (!soap->header)
	{	soap->header = soap_new_SOAP_ENV__Header(soap, -1);
		soap_default_SOAP_ENV__Header(soap, soap->header);
	}
}

SOAP_FMAC3 void SOAP_FMAC4 soap_fault(struct soap *soap)
{
	if (!soap->fault)
	{	soap->fault = soap_new_SOAP_ENV__Fault(soap, -1);
		soap_default_SOAP_ENV__Fault(soap, soap->fault);
	}
	if (soap->version == 2 && !soap->fault->SOAP_ENV__Code)
	{	soap->fault->SOAP_ENV__Code = soap_new_SOAP_ENV__Code(soap, -1);
		soap_default_SOAP_ENV__Code(soap, soap->fault->SOAP_ENV__Code);
	}
	if (soap->version == 2 && !soap->fault->SOAP_ENV__Reason)
	{	soap->fault->SOAP_ENV__Reason = soap_new_SOAP_ENV__Reason(soap, -1);
		soap_default_SOAP_ENV__Reason(soap, soap->fault->SOAP_ENV__Reason);
	}
}

SOAP_FMAC3 void SOAP_FMAC4 soap_serializefault(struct soap *soap)
{
	soap_fault(soap);
	if (soap->fault)
		soap_serialize_SOAP_ENV__Fault(soap, soap->fault);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_putfault(struct soap *soap)
{
	if (soap->fault)
		return soap_put_SOAP_ENV__Fault(soap, soap->fault, "SOAP-ENV:Fault", NULL);
	return SOAP_OK;
}

SOAP_FMAC3 int SOAP_FMAC4 soap_getfault(struct soap *soap)
{
	return (soap->fault = soap_get_SOAP_ENV__Fault(soap, NULL, "SOAP-ENV:Fault", NULL)) == NULL;
}

SOAP_FMAC3 const char ** SOAP_FMAC4 soap_faultcode(struct soap *soap)
{
	soap_fault(soap);
	if (soap->version == 2)
		return (const char**)&soap->fault->SOAP_ENV__Code->SOAP_ENV__Value;
	return (const char**)&soap->fault->faultcode;
}

SOAP_FMAC3 const char ** SOAP_FMAC4 soap_faultsubcode(struct soap *soap)
{
	soap_fault(soap);
	if (soap->version == 2)
	{	if (!soap->fault->SOAP_ENV__Code->SOAP_ENV__Subcode)
		{	soap->fault->SOAP_ENV__Code->SOAP_ENV__Subcode = soap_new_SOAP_ENV__Code(soap, -1);
			soap_default_SOAP_ENV__Code(soap, soap->fault->SOAP_ENV__Code->SOAP_ENV__Subcode);
		}
		return (const char**)&soap->fault->SOAP_ENV__Code->SOAP_ENV__Subcode->SOAP_ENV__Value;
	}
	return (const char**)&soap->fault->faultcode;
}

SOAP_FMAC3 const char ** SOAP_FMAC4 soap_faultstring(struct soap *soap)
{
	soap_fault(soap);
	if (soap->version == 2)
		return (const char**)&soap->fault->SOAP_ENV__Reason->SOAP_ENV__Text;
	return (const char**)&soap->fault->faultstring;
}

SOAP_FMAC3 const char ** SOAP_FMAC4 soap_faultdetail(struct soap *soap)
{
	soap_fault(soap);
	if (soap->version == 1)
	{	if (!soap->fault->detail)
		{	soap->fault->detail = (struct SOAP_ENV__Detail*)soap_malloc(soap, sizeof(struct SOAP_ENV__Detail));
			soap_default_SOAP_ENV__Detail(soap, soap->fault->detail);
		}
		return (const char**)&soap->fault->detail->__any;
	}
	if (!soap->fault->SOAP_ENV__Detail)
	{	soap->fault->SOAP_ENV__Detail = soap_new_SOAP_ENV__Detail(soap, -1);
		soap_default_SOAP_ENV__Detail(soap, soap->fault->SOAP_ENV__Detail);
	}
	return (const char**)&soap->fault->SOAP_ENV__Detail->__any;
}

#endif

#ifndef WITH_NOIDREF
SOAP_FMAC3 int SOAP_FMAC4 soap_getindependent(struct soap *soap)
{
	int t;
	for (;;)
		if (!soap_getelement(soap, &t))
			if (soap->error || soap_ignore_element(soap))
				break;
	if (soap->error == SOAP_NO_TAG || soap->error == SOAP_EOF)
		soap->error = SOAP_OK;
	return soap->error;
}
#endif

#ifndef WITH_NOIDREF

#ifdef __cplusplus
extern "C" {
#endif
SOAP_FMAC3 void * SOAP_FMAC4 soap_getelement(struct soap *soap, int *type)
{
	if (soap_peek_element(soap))
		return NULL;
	if (!*soap->id || !(*type = soap_lookup_type(soap, soap->id)))
		*type = soap_lookup_type(soap, soap->href);
	switch (*type)
	{
	case SOAP_TYPE_byte:
		return soap_in_byte(soap, NULL, NULL, "xsd:byte");
	case SOAP_TYPE_int:
		return soap_in_int(soap, NULL, NULL, "xsd:int");
	case SOAP_TYPE_xsd__int:
		return soap_in_xsd__int(soap, NULL, NULL, "xsd:int");
	case SOAP_TYPE_long:
		return soap_in_long(soap, NULL, NULL, "xsd:long");
	case SOAP_TYPE_xsd__float:
		return soap_in_xsd__float(soap, NULL, NULL, "xsd:float");
	case SOAP_TYPE_float:
		return soap_in_float(soap, NULL, NULL, "xsd:float");
	case SOAP_TYPE_unsignedByte:
		return soap_in_unsignedByte(soap, NULL, NULL, "xsd:unsignedByte");
	case SOAP_TYPE_unsignedInt:
		return soap_in_unsignedInt(soap, NULL, NULL, "xsd:unsignedInt");
	case SOAP_TYPE_xsd__boolean:
		return soap_in_xsd__boolean(soap, NULL, NULL, "xsd:boolean");
	case SOAP_TYPE_bool:
		return soap_in_bool(soap, NULL, NULL, "xsd:boolean");
	case SOAP_TYPE_m__echoVoid:
		return soap_in_m__echoVoid(soap, NULL, NULL, "m:echoVoid");
	case SOAP_TYPE_m__echoVoidResponse:
		return soap_in_m__echoVoidResponse(soap, NULL, NULL, "m:echoVoidResponse");
	case SOAP_TYPE_ns__echoNestedArray:
		return soap_in_ns__echoNestedArray(soap, NULL, NULL, "ns:echoNestedArray");
	case SOAP_TYPE_ns__echoNestedArrayResponse:
		return soap_in_ns__echoNestedArrayResponse(soap, NULL, NULL, "ns:echoNestedArrayResponse");
	case SOAP_TYPE_s__SOAPArrayStruct:
		return soap_in_s__SOAPArrayStruct(soap, NULL, NULL, "s:SOAPArrayStruct");
	case SOAP_TYPE_ns__echoNestedStruct:
		return soap_in_ns__echoNestedStruct(soap, NULL, NULL, "ns:echoNestedStruct");
	case SOAP_TYPE_ns__echoNestedStructResponse:
		return soap_in_ns__echoNestedStructResponse(soap, NULL, NULL, "ns:echoNestedStructResponse");
	case SOAP_TYPE_s__SOAPStructStruct:
		return soap_in_s__SOAPStructStruct(soap, NULL, NULL, "s:SOAPStructStruct");
	case SOAP_TYPE_ns__echo2DStringArray:
		return soap_in_ns__echo2DStringArray(soap, NULL, NULL, "ns:echo2DStringArray");
	case SOAP_TYPE_ns__echo2DStringArrayResponse:
		return soap_in_ns__echo2DStringArrayResponse(soap, NULL, NULL, "ns:echo2DStringArrayResponse");
	case SOAP_TYPE_ArrayOfstring2D:
		return soap_in_ArrayOfstring2D(soap, NULL, NULL, "xsd:string");
	case SOAP_TYPE_ns__echoSimpleTypesAsStruct:
		return soap_in_ns__echoSimpleTypesAsStruct(soap, NULL, NULL, "ns:echoSimpleTypesAsStruct");
	case SOAP_TYPE_ns__echoSimpleTypesAsStructResponse:
		return soap_in_ns__echoSimpleTypesAsStructResponse(soap, NULL, NULL, "ns:echoSimpleTypesAsStructResponse");
	case SOAP_TYPE_ns__echoStructAsSimpleTypes:
		return soap_in_ns__echoStructAsSimpleTypes(soap, NULL, NULL, "ns:echoStructAsSimpleTypes");
	case SOAP_TYPE_ns__echoStructAsSimpleTypesResponse:
		return soap_in_ns__echoStructAsSimpleTypesResponse(soap, NULL, NULL, "ns:echoStructAsSimpleTypesResponse");
	case SOAP_TYPE_ns__echoBoolean:
		return soap_in_ns__echoBoolean(soap, NULL, NULL, "ns:echoBoolean");
	case SOAP_TYPE_ns__echoBooleanResponse:
		return soap_in_ns__echoBooleanResponse(soap, NULL, NULL, "ns:echoBooleanResponse");
	case SOAP_TYPE_ns__echoDecimal:
		return soap_in_ns__echoDecimal(soap, NULL, NULL, "ns:echoDecimal");
	case SOAP_TYPE_ns__echoDecimalResponse:
		return soap_in_ns__echoDecimalResponse(soap, NULL, NULL, "ns:echoDecimalResponse");
	case SOAP_TYPE_ns__echoHexBinary:
		return soap_in_ns__echoHexBinary(soap, NULL, NULL, "ns:echoHexBinary");
	case SOAP_TYPE_ns__echoHexBinaryResponse:
		return soap_in_ns__echoHexBinaryResponse(soap, NULL, NULL, "ns:echoHexBinaryResponse");
	case SOAP_TYPE_xsd__hexBinary:
		return soap_in_xsd__hexBinary(soap, NULL, NULL, "xsd:hexBinary");
	case SOAP_TYPE_ns__echoDate:
		return soap_in_ns__echoDate(soap, NULL, NULL, "ns:echoDate");
	case SOAP_TYPE_ns__echoDateResponse:
		return soap_in_ns__echoDateResponse(soap, NULL, NULL, "ns:echoDateResponse");
	case SOAP_TYPE_ns__echoBase64:
		return soap_in_ns__echoBase64(soap, NULL, NULL, "ns:echoBase64");
	case SOAP_TYPE_ns__echoBase64Response:
		return soap_in_ns__echoBase64Response(soap, NULL, NULL, "ns:echoBase64Response");
	case SOAP_TYPE_xsd__base64Binary:
		return soap_in_xsd__base64Binary(soap, NULL, NULL, "xsd:base64Binary");
	case SOAP_TYPE_ns__echoVoid:
		return soap_in_ns__echoVoid(soap, NULL, NULL, "ns:echoVoid");
	case SOAP_TYPE_ns__echoVoidResponse:
		return soap_in_ns__echoVoidResponse(soap, NULL, NULL, "ns:echoVoidResponse");
	case SOAP_TYPE_ns__echoStructArray:
		return soap_in_ns__echoStructArray(soap, NULL, NULL, "ns:echoStructArray");
	case SOAP_TYPE_ns__echoStructArrayResponse:
		return soap_in_ns__echoStructArrayResponse(soap, NULL, NULL, "ns:echoStructArrayResponse");
	case SOAP_TYPE_ArrayOfSOAPStruct:
		return soap_in_ArrayOfSOAPStruct(soap, NULL, NULL, "s:SOAPStruct");
	case SOAP_TYPE_ns__echoStruct:
		return soap_in_ns__echoStruct(soap, NULL, NULL, "ns:echoStruct");
	case SOAP_TYPE_ns__echoStructResponse:
		return soap_in_ns__echoStructResponse(soap, NULL, NULL, "ns:echoStructResponse");
	case SOAP_TYPE_s__SOAPStruct:
		return soap_in_s__SOAPStruct(soap, NULL, NULL, "s:SOAPStruct");
	case SOAP_TYPE_ns__echoFloatArray:
		return soap_in_ns__echoFloatArray(soap, NULL, NULL, "ns:echoFloatArray");
	case SOAP_TYPE_ns__echoFloatArrayResponse:
		return soap_in_ns__echoFloatArrayResponse(soap, NULL, NULL, "ns:echoFloatArrayResponse");
	case SOAP_TYPE_ArrayOffloat:
		return soap_in_ArrayOffloat(soap, NULL, NULL, "xsd:float");
	case SOAP_TYPE_ns__echoFloat:
		return soap_in_ns__echoFloat(soap, NULL, NULL, "ns:echoFloat");
	case SOAP_TYPE_ns__echoFloatResponse:
		return soap_in_ns__echoFloatResponse(soap, NULL, NULL, "ns:echoFloatResponse");
	case SOAP_TYPE_ns__echoIntegerArray:
		return soap_in_ns__echoIntegerArray(soap, NULL, NULL, "ns:echoIntegerArray");
	case SOAP_TYPE_ns__echoIntegerArrayResponse:
		return soap_in_ns__echoIntegerArrayResponse(soap, NULL, NULL, "ns:echoIntegerArrayResponse");
	case SOAP_TYPE_ArrayOfint:
		return soap_in_ArrayOfint(soap, NULL, NULL, "xsd:int");
	case SOAP_TYPE_ns__echoInteger:
		return soap_in_ns__echoInteger(soap, NULL, NULL, "ns:echoInteger");
	case SOAP_TYPE_ns__echoIntegerResponse:
		return soap_in_ns__echoIntegerResponse(soap, NULL, NULL, "ns:echoIntegerResponse");
	case SOAP_TYPE_ns__echoStringArray:
		return soap_in_ns__echoStringArray(soap, NULL, NULL, "ns:echoStringArray");
	case SOAP_TYPE_ns__echoStringArrayResponse:
		return soap_in_ns__echoStringArrayResponse(soap, NULL, NULL, "ns:echoStringArrayResponse");
	case SOAP_TYPE_ArrayOfstring:
		return soap_in_ArrayOfstring(soap, NULL, NULL, "xsd:string");
	case SOAP_TYPE_ns__echoString:
		return soap_in_ns__echoString(soap, NULL, NULL, "ns:echoString");
	case SOAP_TYPE_ns__echoStringResponse:
		return soap_in_ns__echoStringResponse(soap, NULL, NULL, "ns:echoStringResponse");
	case SOAP_TYPE_xsd__decimal:
	{	char **s;
		s = soap_in_xsd__decimal(soap, NULL, NULL, "xsd:decimal");
		return s ? *s : NULL;
	}
	case SOAP_TYPE_xsd__dateTime:
	{	char **s;
		s = soap_in_xsd__dateTime(soap, NULL, NULL, "xsd:dateTime");
		return s ? *s : NULL;
	}
	case SOAP_TYPE_PointerTounsignedByte:
		return soap_in_PointerTounsignedByte(soap, NULL, NULL, "xsd:unsignedByte");
	case SOAP_TYPE_PointerToPointerTos__SOAPStruct:
		return soap_in_PointerToPointerTos__SOAPStruct(soap, NULL, NULL, "s:SOAPStruct");
	case SOAP_TYPE_PointerTos__SOAPStruct:
		return soap_in_PointerTos__SOAPStruct(soap, NULL, NULL, "s:SOAPStruct");
	case SOAP_TYPE_PointerToPointerToxsd__float:
		return soap_in_PointerToPointerToxsd__float(soap, NULL, NULL, "xsd:float");
	case SOAP_TYPE_PointerToxsd__float:
		return soap_in_PointerToxsd__float(soap, NULL, NULL, "xsd:float");
	case SOAP_TYPE_PointerToPointerToxsd__int:
		return soap_in_PointerToPointerToxsd__int(soap, NULL, NULL, "xsd:int");
	case SOAP_TYPE_PointerToxsd__int:
		return soap_in_PointerToxsd__int(soap, NULL, NULL, "xsd:int");
	case SOAP_TYPE_PointerToxsd__string:
		return soap_in_PointerToxsd__string(soap, NULL, NULL, "xsd:string");
	case SOAP_TYPE_xsd__string:
	{	char **s;
		s = soap_in_xsd__string(soap, NULL, NULL, "xsd:string");
		return s ? *s : NULL;
	}
	case SOAP_TYPE_string:
	{	char **s;
		s = soap_in_string(soap, NULL, NULL, "xsd:string");
		return s ? *s : NULL;
	}
	case SOAP_TYPE_Array2Ofint:
		return soap_in_Array2Ofint(soap, NULL, NULL, "xsd:int");
	default:
	{	const char *t = soap->type;
		if (!*t)
			t = soap->tag;
		if (!soap_match_tag(soap, t, "xsd:byte"))
		{	*type = SOAP_TYPE_byte;
			return soap_in_byte(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "xsd:int"))
		{	*type = SOAP_TYPE_int;
			return soap_in_int(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "xsd:int"))
		{	*type = SOAP_TYPE_xsd__int;
			return soap_in_xsd__int(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "xsd:long"))
		{	*type = SOAP_TYPE_long;
			return soap_in_long(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "xsd:float"))
		{	*type = SOAP_TYPE_xsd__float;
			return soap_in_xsd__float(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "xsd:float"))
		{	*type = SOAP_TYPE_float;
			return soap_in_float(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "xsd:unsignedByte"))
		{	*type = SOAP_TYPE_unsignedByte;
			return soap_in_unsignedByte(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "xsd:unsignedInt"))
		{	*type = SOAP_TYPE_unsignedInt;
			return soap_in_unsignedInt(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "xsd:boolean"))
		{	*type = SOAP_TYPE_xsd__boolean;
			return soap_in_xsd__boolean(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "xsd:boolean"))
		{	*type = SOAP_TYPE_bool;
			return soap_in_bool(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "m:echoVoid"))
		{	*type = SOAP_TYPE_m__echoVoid;
			return soap_in_m__echoVoid(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "m:echoVoidResponse"))
		{	*type = SOAP_TYPE_m__echoVoidResponse;
			return soap_in_m__echoVoidResponse(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "ns:echoNestedArray"))
		{	*type = SOAP_TYPE_ns__echoNestedArray;
			return soap_in_ns__echoNestedArray(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "ns:echoNestedArrayResponse"))
		{	*type = SOAP_TYPE_ns__echoNestedArrayResponse;
			return soap_in_ns__echoNestedArrayResponse(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "s:SOAPArrayStruct"))
		{	*type = SOAP_TYPE_s__SOAPArrayStruct;
			return soap_in_s__SOAPArrayStruct(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "ns:echoNestedStruct"))
		{	*type = SOAP_TYPE_ns__echoNestedStruct;
			return soap_in_ns__echoNestedStruct(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "ns:echoNestedStructResponse"))
		{	*type = SOAP_TYPE_ns__echoNestedStructResponse;
			return soap_in_ns__echoNestedStructResponse(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "s:SOAPStructStruct"))
		{	*type = SOAP_TYPE_s__SOAPStructStruct;
			return soap_in_s__SOAPStructStruct(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "ns:echo2DStringArray"))
		{	*type = SOAP_TYPE_ns__echo2DStringArray;
			return soap_in_ns__echo2DStringArray(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "ns:echo2DStringArrayResponse"))
		{	*type = SOAP_TYPE_ns__echo2DStringArrayResponse;
			return soap_in_ns__echo2DStringArrayResponse(soap, NULL, NULL, NULL);
		}
		if (*soap->arrayType && !soap_match_array(soap, "xsd:string"))
		{	*type = SOAP_TYPE_ArrayOfstring2D;
			return soap_in_ArrayOfstring2D(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "ns:echoSimpleTypesAsStruct"))
		{	*type = SOAP_TYPE_ns__echoSimpleTypesAsStruct;
			return soap_in_ns__echoSimpleTypesAsStruct(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "ns:echoSimpleTypesAsStructResponse"))
		{	*type = SOAP_TYPE_ns__echoSimpleTypesAsStructResponse;
			return soap_in_ns__echoSimpleTypesAsStructResponse(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "ns:echoStructAsSimpleTypes"))
		{	*type = SOAP_TYPE_ns__echoStructAsSimpleTypes;
			return soap_in_ns__echoStructAsSimpleTypes(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "ns:echoStructAsSimpleTypesResponse"))
		{	*type = SOAP_TYPE_ns__echoStructAsSimpleTypesResponse;
			return soap_in_ns__echoStructAsSimpleTypesResponse(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "ns:echoBoolean"))
		{	*type = SOAP_TYPE_ns__echoBoolean;
			return soap_in_ns__echoBoolean(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "ns:echoBooleanResponse"))
		{	*type = SOAP_TYPE_ns__echoBooleanResponse;
			return soap_in_ns__echoBooleanResponse(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "ns:echoDecimal"))
		{	*type = SOAP_TYPE_ns__echoDecimal;
			return soap_in_ns__echoDecimal(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "ns:echoDecimalResponse"))
		{	*type = SOAP_TYPE_ns__echoDecimalResponse;
			return soap_in_ns__echoDecimalResponse(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "ns:echoHexBinary"))
		{	*type = SOAP_TYPE_ns__echoHexBinary;
			return soap_in_ns__echoHexBinary(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "ns:echoHexBinaryResponse"))
		{	*type = SOAP_TYPE_ns__echoHexBinaryResponse;
			return soap_in_ns__echoHexBinaryResponse(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "xsd:hexBinary"))
		{	*type = SOAP_TYPE_xsd__hexBinary;
			return soap_in_xsd__hexBinary(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "ns:echoDate"))
		{	*type = SOAP_TYPE_ns__echoDate;
			return soap_in_ns__echoDate(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "ns:echoDateResponse"))
		{	*type = SOAP_TYPE_ns__echoDateResponse;
			return soap_in_ns__echoDateResponse(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "ns:echoBase64"))
		{	*type = SOAP_TYPE_ns__echoBase64;
			return soap_in_ns__echoBase64(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "ns:echoBase64Response"))
		{	*type = SOAP_TYPE_ns__echoBase64Response;
			return soap_in_ns__echoBase64Response(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "xsd:base64Binary"))
		{	*type = SOAP_TYPE_xsd__base64Binary;
			return soap_in_xsd__base64Binary(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "ns:echoVoid"))
		{	*type = SOAP_TYPE_ns__echoVoid;
			return soap_in_ns__echoVoid(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "ns:echoVoidResponse"))
		{	*type = SOAP_TYPE_ns__echoVoidResponse;
			return soap_in_ns__echoVoidResponse(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "ns:echoStructArray"))
		{	*type = SOAP_TYPE_ns__echoStructArray;
			return soap_in_ns__echoStructArray(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "ns:echoStructArrayResponse"))
		{	*type = SOAP_TYPE_ns__echoStructArrayResponse;
			return soap_in_ns__echoStructArrayResponse(soap, NULL, NULL, NULL);
		}
		if (*soap->arrayType && !soap_match_array(soap, "s:SOAPStruct"))
		{	*type = SOAP_TYPE_ArrayOfSOAPStruct;
			return soap_in_ArrayOfSOAPStruct(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "ns:echoStruct"))
		{	*type = SOAP_TYPE_ns__echoStruct;
			return soap_in_ns__echoStruct(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "ns:echoStructResponse"))
		{	*type = SOAP_TYPE_ns__echoStructResponse;
			return soap_in_ns__echoStructResponse(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "s:SOAPStruct"))
		{	*type = SOAP_TYPE_s__SOAPStruct;
			return soap_in_s__SOAPStruct(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "ns:echoFloatArray"))
		{	*type = SOAP_TYPE_ns__echoFloatArray;
			return soap_in_ns__echoFloatArray(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "ns:echoFloatArrayResponse"))
		{	*type = SOAP_TYPE_ns__echoFloatArrayResponse;
			return soap_in_ns__echoFloatArrayResponse(soap, NULL, NULL, NULL);
		}
		if (*soap->arrayType && !soap_match_array(soap, "xsd:float"))
		{	*type = SOAP_TYPE_ArrayOffloat;
			return soap_in_ArrayOffloat(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "ns:echoFloat"))
		{	*type = SOAP_TYPE_ns__echoFloat;
			return soap_in_ns__echoFloat(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "ns:echoFloatResponse"))
		{	*type = SOAP_TYPE_ns__echoFloatResponse;
			return soap_in_ns__echoFloatResponse(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "ns:echoIntegerArray"))
		{	*type = SOAP_TYPE_ns__echoIntegerArray;
			return soap_in_ns__echoIntegerArray(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "ns:echoIntegerArrayResponse"))
		{	*type = SOAP_TYPE_ns__echoIntegerArrayResponse;
			return soap_in_ns__echoIntegerArrayResponse(soap, NULL, NULL, NULL);
		}
		if (*soap->arrayType && !soap_match_array(soap, "xsd:int"))
		{	*type = SOAP_TYPE_ArrayOfint;
			return soap_in_ArrayOfint(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "ns:echoInteger"))
		{	*type = SOAP_TYPE_ns__echoInteger;
			return soap_in_ns__echoInteger(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "ns:echoIntegerResponse"))
		{	*type = SOAP_TYPE_ns__echoIntegerResponse;
			return soap_in_ns__echoIntegerResponse(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "ns:echoStringArray"))
		{	*type = SOAP_TYPE_ns__echoStringArray;
			return soap_in_ns__echoStringArray(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "ns:echoStringArrayResponse"))
		{	*type = SOAP_TYPE_ns__echoStringArrayResponse;
			return soap_in_ns__echoStringArrayResponse(soap, NULL, NULL, NULL);
		}
		if (*soap->arrayType && !soap_match_array(soap, "xsd:string"))
		{	*type = SOAP_TYPE_ArrayOfstring;
			return soap_in_ArrayOfstring(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "ns:echoString"))
		{	*type = SOAP_TYPE_ns__echoString;
			return soap_in_ns__echoString(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "ns:echoStringResponse"))
		{	*type = SOAP_TYPE_ns__echoStringResponse;
			return soap_in_ns__echoStringResponse(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "xsd:decimal"))
		{	char **s;
			*type = SOAP_TYPE_xsd__decimal;
			s = soap_in_xsd__decimal(soap, NULL, NULL, NULL);
			return s ? *s : NULL;
		}
		if (!soap_match_tag(soap, t, "xsd:dateTime"))
		{	char **s;
			*type = SOAP_TYPE_xsd__dateTime;
			s = soap_in_xsd__dateTime(soap, NULL, NULL, NULL);
			return s ? *s : NULL;
		}
		if (!soap_match_tag(soap, t, "xsd:string"))
		{	char **s;
			*type = SOAP_TYPE_xsd__string;
			s = soap_in_xsd__string(soap, NULL, NULL, NULL);
			return s ? *s : NULL;
		}
		if (!soap_match_tag(soap, t, "xsd:string"))
		{	char **s;
			*type = SOAP_TYPE_string;
			s = soap_in_string(soap, NULL, NULL, NULL);
			return s ? *s : NULL;
		}
		if (!soap_match_tag(soap, t, "xsd:int"))
		{	*type = SOAP_TYPE_Array2Ofint;
			return soap_in_Array2Ofint(soap, NULL, NULL, NULL);
		}
		t = soap->tag;
		if (!soap_match_tag(soap, t, "xsd:QName"))
		{	char **s;
			*type = SOAP_TYPE__QName;
			s = soap_in__QName(soap, NULL, NULL, NULL);
			return s ? *s : NULL;
		}
	}
	}
	soap->error = SOAP_TAG_MISMATCH;
	return NULL;
}

#ifdef __cplusplus
}
#endif
#endif

SOAP_FMAC3 int SOAP_FMAC4 soap_ignore_element(struct soap *soap)
{
	if (!soap_peek_element(soap))
	{	int t;
		DBGLOG(TEST, SOAP_MESSAGE(fdebug, "Unexpected element '%s' in input (level=%u, %d)\n", soap->tag, soap->level, soap->body));
		if (soap->mustUnderstand && !soap->other)
			return soap->error = SOAP_MUSTUNDERSTAND;
		if (((soap->mode & SOAP_XML_STRICT) && soap->part != SOAP_IN_HEADER) || !soap_match_tag(soap, soap->tag, "SOAP-ENV:"))
		{	DBGLOG(TEST, SOAP_MESSAGE(fdebug, "REJECTING element '%s'\n", soap->tag));
			return soap->error = SOAP_TAG_MISMATCH;
		}
		if (!*soap->id || !soap_getelement(soap, &t))
		{	soap->peeked = 0;
			if (soap->fignore)
				soap->error = soap->fignore(soap, soap->tag);
			else
				soap->error = SOAP_OK;
			DBGLOG(TEST, if (!soap->error) SOAP_MESSAGE(fdebug, "IGNORING element '%s'\n", soap->tag));
			if (!soap->error && soap->body)
			{	soap->level++;
				while (!soap_ignore_element(soap))
					;
				if (soap->error == SOAP_NO_TAG)
					soap->error = soap_element_end_in(soap, NULL);
			}
		}
	}
	return soap->error;
}

#ifndef WITH_NOIDREF
SOAP_FMAC3 int SOAP_FMAC4 soap_putindependent(struct soap *soap)
{
	int i;
	struct soap_plist *pp;
	if (soap->version == 1 && soap->encodingStyle && !(soap->mode & (SOAP_XML_TREE | SOAP_XML_GRAPH)))
		for (i = 0; i < SOAP_PTRHASH; i++)
			for (pp = soap->pht[i]; pp; pp = pp->next)
				if (pp->mark1 == 2 || pp->mark2 == 2)
					if (soap_putelement(soap, pp->ptr, "id", pp->id, pp->type))
						return soap->error;
	return SOAP_OK;
}
#endif

#ifndef WITH_NOIDREF

#ifdef __cplusplus
extern "C" {
#endif
SOAP_FMAC3 int SOAP_FMAC4 soap_putelement(struct soap *soap, const void *ptr, const char *tag, int id, int type)
{
	switch (type)
	{
	case SOAP_TYPE_byte:
		return soap_out_byte(soap, tag, id, (const char *)ptr, "xsd:byte");
	case SOAP_TYPE_int:
		return soap_out_int(soap, tag, id, (const int *)ptr, "xsd:int");
	case SOAP_TYPE_xsd__int:
		return soap_out_xsd__int(soap, tag, id, (const long *)ptr, "xsd:int");
	case SOAP_TYPE_long:
		return soap_out_long(soap, tag, id, (const long *)ptr, "xsd:long");
	case SOAP_TYPE_xsd__float:
		return soap_out_xsd__float(soap, tag, id, (const float *)ptr, "xsd:float");
	case SOAP_TYPE_float:
		return soap_out_float(soap, tag, id, (const float *)ptr, "xsd:float");
	case SOAP_TYPE_unsignedByte:
		return soap_out_unsignedByte(soap, tag, id, (const unsigned char *)ptr, "xsd:unsignedByte");
	case SOAP_TYPE_unsignedInt:
		return soap_out_unsignedInt(soap, tag, id, (const unsigned int *)ptr, "xsd:unsignedInt");
	case SOAP_TYPE_xsd__boolean:
		return soap_out_xsd__boolean(soap, tag, id, (const bool *)ptr, "xsd:boolean");
	case SOAP_TYPE_bool:
		return soap_out_bool(soap, tag, id, (const bool *)ptr, "xsd:boolean");
	case SOAP_TYPE_m__echoVoid:
		return soap_out_m__echoVoid(soap, tag, id, (const struct m__echoVoid *)ptr, "m:echoVoid");
	case SOAP_TYPE_m__echoVoidResponse:
		return soap_out_m__echoVoidResponse(soap, tag, id, (const struct m__echoVoidResponse *)ptr, "m:echoVoidResponse");
	case SOAP_TYPE_ns__echoNestedArray:
		return soap_out_ns__echoNestedArray(soap, tag, id, (const struct ns__echoNestedArray *)ptr, "ns:echoNestedArray");
	case SOAP_TYPE_ns__echoNestedArrayResponse:
		return soap_out_ns__echoNestedArrayResponse(soap, tag, id, (const struct ns__echoNestedArrayResponse *)ptr, "ns:echoNestedArrayResponse");
	case SOAP_TYPE_s__SOAPArrayStruct:
		return soap_out_s__SOAPArrayStruct(soap, tag, id, (const struct s__SOAPArrayStruct *)ptr, "s:SOAPArrayStruct");
	case SOAP_TYPE_ns__echoNestedStruct:
		return soap_out_ns__echoNestedStruct(soap, tag, id, (const struct ns__echoNestedStruct *)ptr, "ns:echoNestedStruct");
	case SOAP_TYPE_ns__echoNestedStructResponse:
		return soap_out_ns__echoNestedStructResponse(soap, tag, id, (const struct ns__echoNestedStructResponse *)ptr, "ns:echoNestedStructResponse");
	case SOAP_TYPE_s__SOAPStructStruct:
		return soap_out_s__SOAPStructStruct(soap, tag, id, (const struct s__SOAPStructStruct *)ptr, "s:SOAPStructStruct");
	case SOAP_TYPE_ns__echo2DStringArray:
		return soap_out_ns__echo2DStringArray(soap, tag, id, (const struct ns__echo2DStringArray *)ptr, "ns:echo2DStringArray");
	case SOAP_TYPE_ns__echo2DStringArrayResponse:
		return soap_out_ns__echo2DStringArrayResponse(soap, tag, id, (const struct ns__echo2DStringArrayResponse *)ptr, "ns:echo2DStringArrayResponse");
	case SOAP_TYPE_ArrayOfstring2D:
		return soap_out_ArrayOfstring2D(soap, tag, id, (const struct ArrayOfstring2D *)ptr, "xsd:string");
	case SOAP_TYPE_ns__echoSimpleTypesAsStruct:
		return soap_out_ns__echoSimpleTypesAsStruct(soap, tag, id, (const struct ns__echoSimpleTypesAsStruct *)ptr, "ns:echoSimpleTypesAsStruct");
	case SOAP_TYPE_ns__echoSimpleTypesAsStructResponse:
		return soap_out_ns__echoSimpleTypesAsStructResponse(soap, tag, id, (const struct ns__echoSimpleTypesAsStructResponse *)ptr, "ns:echoSimpleTypesAsStructResponse");
	case SOAP_TYPE_ns__echoStructAsSimpleTypes:
		return soap_out_ns__echoStructAsSimpleTypes(soap, tag, id, (const struct ns__echoStructAsSimpleTypes *)ptr, "ns:echoStructAsSimpleTypes");
	case SOAP_TYPE_ns__echoStructAsSimpleTypesResponse:
		return soap_out_ns__echoStructAsSimpleTypesResponse(soap, tag, id, (const struct ns__echoStructAsSimpleTypesResponse *)ptr, "ns:echoStructAsSimpleTypesResponse");
	case SOAP_TYPE_ns__echoBoolean:
		return soap_out_ns__echoBoolean(soap, tag, id, (const struct ns__echoBoolean *)ptr, "ns:echoBoolean");
	case SOAP_TYPE_ns__echoBooleanResponse:
		return soap_out_ns__echoBooleanResponse(soap, tag, id, (const struct ns__echoBooleanResponse *)ptr, "ns:echoBooleanResponse");
	case SOAP_TYPE_ns__echoDecimal:
		return soap_out_ns__echoDecimal(soap, tag, id, (const struct ns__echoDecimal *)ptr, "ns:echoDecimal");
	case SOAP_TYPE_ns__echoDecimalResponse:
		return soap_out_ns__echoDecimalResponse(soap, tag, id, (const struct ns__echoDecimalResponse *)ptr, "ns:echoDecimalResponse");
	case SOAP_TYPE_ns__echoHexBinary:
		return soap_out_ns__echoHexBinary(soap, tag, id, (const struct ns__echoHexBinary *)ptr, "ns:echoHexBinary");
	case SOAP_TYPE_ns__echoHexBinaryResponse:
		return soap_out_ns__echoHexBinaryResponse(soap, tag, id, (const struct ns__echoHexBinaryResponse *)ptr, "ns:echoHexBinaryResponse");
	case SOAP_TYPE_xsd__hexBinary:
		return soap_out_xsd__hexBinary(soap, tag, id, (const struct xsd__hexBinary *)ptr, "xsd:hexBinary");
	case SOAP_TYPE_ns__echoDate:
		return soap_out_ns__echoDate(soap, tag, id, (const struct ns__echoDate *)ptr, "ns:echoDate");
	case SOAP_TYPE_ns__echoDateResponse:
		return soap_out_ns__echoDateResponse(soap, tag, id, (const struct ns__echoDateResponse *)ptr, "ns:echoDateResponse");
	case SOAP_TYPE_ns__echoBase64:
		return soap_out_ns__echoBase64(soap, tag, id, (const struct ns__echoBase64 *)ptr, "ns:echoBase64");
	case SOAP_TYPE_ns__echoBase64Response:
		return soap_out_ns__echoBase64Response(soap, tag, id, (const struct ns__echoBase64Response *)ptr, "ns:echoBase64Response");
	case SOAP_TYPE_xsd__base64Binary:
		return soap_out_xsd__base64Binary(soap, tag, id, (const struct xsd__base64Binary *)ptr, "xsd:base64Binary");
	case SOAP_TYPE_ns__echoVoid:
		return soap_out_ns__echoVoid(soap, tag, id, (const struct ns__echoVoid *)ptr, "ns:echoVoid");
	case SOAP_TYPE_ns__echoVoidResponse:
		return soap_out_ns__echoVoidResponse(soap, tag, id, (const struct ns__echoVoidResponse *)ptr, "ns:echoVoidResponse");
	case SOAP_TYPE_ns__echoStructArray:
		return soap_out_ns__echoStructArray(soap, tag, id, (const struct ns__echoStructArray *)ptr, "ns:echoStructArray");
	case SOAP_TYPE_ns__echoStructArrayResponse:
		return soap_out_ns__echoStructArrayResponse(soap, tag, id, (const struct ns__echoStructArrayResponse *)ptr, "ns:echoStructArrayResponse");
	case SOAP_TYPE_ArrayOfSOAPStruct:
		return soap_out_ArrayOfSOAPStruct(soap, tag, id, (const struct ArrayOfSOAPStruct *)ptr, "s:SOAPStruct");
	case SOAP_TYPE_ns__echoStruct:
		return soap_out_ns__echoStruct(soap, tag, id, (const struct ns__echoStruct *)ptr, "ns:echoStruct");
	case SOAP_TYPE_ns__echoStructResponse:
		return soap_out_ns__echoStructResponse(soap, tag, id, (const struct ns__echoStructResponse *)ptr, "ns:echoStructResponse");
	case SOAP_TYPE_s__SOAPStruct:
		return soap_out_s__SOAPStruct(soap, tag, id, (const struct s__SOAPStruct *)ptr, "s:SOAPStruct");
	case SOAP_TYPE_ns__echoFloatArray:
		return soap_out_ns__echoFloatArray(soap, tag, id, (const struct ns__echoFloatArray *)ptr, "ns:echoFloatArray");
	case SOAP_TYPE_ns__echoFloatArrayResponse:
		return soap_out_ns__echoFloatArrayResponse(soap, tag, id, (const struct ns__echoFloatArrayResponse *)ptr, "ns:echoFloatArrayResponse");
	case SOAP_TYPE_ArrayOffloat:
		return soap_out_ArrayOffloat(soap, tag, id, (const struct ArrayOffloat *)ptr, "xsd:float");
	case SOAP_TYPE_ns__echoFloat:
		return soap_out_ns__echoFloat(soap, tag, id, (const struct ns__echoFloat *)ptr, "ns:echoFloat");
	case SOAP_TYPE_ns__echoFloatResponse:
		return soap_out_ns__echoFloatResponse(soap, tag, id, (const struct ns__echoFloatResponse *)ptr, "ns:echoFloatResponse");
	case SOAP_TYPE_ns__echoIntegerArray:
		return soap_out_ns__echoIntegerArray(soap, tag, id, (const struct ns__echoIntegerArray *)ptr, "ns:echoIntegerArray");
	case SOAP_TYPE_ns__echoIntegerArrayResponse:
		return soap_out_ns__echoIntegerArrayResponse(soap, tag, id, (const struct ns__echoIntegerArrayResponse *)ptr, "ns:echoIntegerArrayResponse");
	case SOAP_TYPE_ArrayOfint:
		return soap_out_ArrayOfint(soap, tag, id, (const struct ArrayOfint *)ptr, "xsd:int");
	case SOAP_TYPE_ns__echoInteger:
		return soap_out_ns__echoInteger(soap, tag, id, (const struct ns__echoInteger *)ptr, "ns:echoInteger");
	case SOAP_TYPE_ns__echoIntegerResponse:
		return soap_out_ns__echoIntegerResponse(soap, tag, id, (const struct ns__echoIntegerResponse *)ptr, "ns:echoIntegerResponse");
	case SOAP_TYPE_ns__echoStringArray:
		return soap_out_ns__echoStringArray(soap, tag, id, (const struct ns__echoStringArray *)ptr, "ns:echoStringArray");
	case SOAP_TYPE_ns__echoStringArrayResponse:
		return soap_out_ns__echoStringArrayResponse(soap, tag, id, (const struct ns__echoStringArrayResponse *)ptr, "ns:echoStringArrayResponse");
	case SOAP_TYPE_ArrayOfstring:
		return soap_out_ArrayOfstring(soap, tag, id, (const struct ArrayOfstring *)ptr, "xsd:string");
	case SOAP_TYPE_ns__echoString:
		return soap_out_ns__echoString(soap, tag, id, (const struct ns__echoString *)ptr, "ns:echoString");
	case SOAP_TYPE_ns__echoStringResponse:
		return soap_out_ns__echoStringResponse(soap, tag, id, (const struct ns__echoStringResponse *)ptr, "ns:echoStringResponse");
	case SOAP_TYPE_xsd__decimal:
		return soap_out_string(soap, tag, id, (char*const*)&ptr, "xsd:decimal");
	case SOAP_TYPE_xsd__dateTime:
		return soap_out_string(soap, tag, id, (char*const*)&ptr, "xsd:dateTime");
	case SOAP_TYPE_PointerTounsignedByte:
		return soap_out_PointerTounsignedByte(soap, tag, id, (unsigned char *const*)ptr, "xsd:unsignedByte");
	case SOAP_TYPE_PointerToPointerTos__SOAPStruct:
		return soap_out_PointerToPointerTos__SOAPStruct(soap, tag, id, (struct s__SOAPStruct **const*)ptr, "s:SOAPStruct");
	case SOAP_TYPE_PointerTos__SOAPStruct:
		return soap_out_PointerTos__SOAPStruct(soap, tag, id, (struct s__SOAPStruct *const*)ptr, "s:SOAPStruct");
	case SOAP_TYPE_PointerToPointerToxsd__float:
		return soap_out_PointerToPointerToxsd__float(soap, tag, id, (float **const*)ptr, "xsd:float");
	case SOAP_TYPE_PointerToxsd__float:
		return soap_out_PointerToxsd__float(soap, tag, id, (float *const*)ptr, "xsd:float");
	case SOAP_TYPE_PointerToPointerToxsd__int:
		return soap_out_PointerToPointerToxsd__int(soap, tag, id, (long **const*)ptr, "xsd:int");
	case SOAP_TYPE_PointerToxsd__int:
		return soap_out_PointerToxsd__int(soap, tag, id, (long *const*)ptr, "xsd:int");
	case SOAP_TYPE_PointerToxsd__string:
		return soap_out_PointerToxsd__string(soap, tag, id, (char **const*)ptr, "xsd:string");
	case SOAP_TYPE_xsd__string:
		return soap_out_string(soap, tag, id, (char*const*)&ptr, "xsd:string");
	case SOAP_TYPE__QName:
		return soap_out_string(soap, "xsd:QName", id, (char*const*)&ptr, NULL);
	case SOAP_TYPE_string:
		return soap_out_string(soap, tag, id, (char*const*)&ptr, "xsd:string");
	case SOAP_TYPE_Array2Ofint:
		return soap_out_Array2Ofint(soap, tag, id, (int (*))ptr, "xsd:int");
	}
	return SOAP_OK;
}

#ifdef __cplusplus
}
#endif
#endif

#ifndef WITH_NOIDREF

#ifdef __cplusplus
extern "C" {
#endif
SOAP_FMAC3 void SOAP_FMAC4 soap_markelement(struct soap *soap, const void *ptr, int type)
{
	(void)soap; (void)ptr; (void)type; /* appease -Wall -Werror */
	switch (type)
	{
	case SOAP_TYPE_m__echoVoid:
		soap_serialize_m__echoVoid(soap, (const struct m__echoVoid *)ptr);
		break;
	case SOAP_TYPE_m__echoVoidResponse:
		soap_serialize_m__echoVoidResponse(soap, (const struct m__echoVoidResponse *)ptr);
		break;
	case SOAP_TYPE_ns__echoNestedArray:
		soap_serialize_ns__echoNestedArray(soap, (const struct ns__echoNestedArray *)ptr);
		break;
	case SOAP_TYPE_ns__echoNestedArrayResponse:
		soap_serialize_ns__echoNestedArrayResponse(soap, (const struct ns__echoNestedArrayResponse *)ptr);
		break;
	case SOAP_TYPE_s__SOAPArrayStruct:
		soap_serialize_s__SOAPArrayStruct(soap, (const struct s__SOAPArrayStruct *)ptr);
		break;
	case SOAP_TYPE_ns__echoNestedStruct:
		soap_serialize_ns__echoNestedStruct(soap, (const struct ns__echoNestedStruct *)ptr);
		break;
	case SOAP_TYPE_ns__echoNestedStructResponse:
		soap_serialize_ns__echoNestedStructResponse(soap, (const struct ns__echoNestedStructResponse *)ptr);
		break;
	case SOAP_TYPE_s__SOAPStructStruct:
		soap_serialize_s__SOAPStructStruct(soap, (const struct s__SOAPStructStruct *)ptr);
		break;
	case SOAP_TYPE_ns__echo2DStringArray:
		soap_serialize_ns__echo2DStringArray(soap, (const struct ns__echo2DStringArray *)ptr);
		break;
	case SOAP_TYPE_ns__echo2DStringArrayResponse:
		soap_serialize_ns__echo2DStringArrayResponse(soap, (const struct ns__echo2DStringArrayResponse *)ptr);
		break;
	case SOAP_TYPE_ArrayOfstring2D:
		soap_serialize_ArrayOfstring2D(soap, (const struct ArrayOfstring2D *)ptr);
		break;
	case SOAP_TYPE_ns__echoSimpleTypesAsStruct:
		soap_serialize_ns__echoSimpleTypesAsStruct(soap, (const struct ns__echoSimpleTypesAsStruct *)ptr);
		break;
	case SOAP_TYPE_ns__echoSimpleTypesAsStructResponse:
		soap_serialize_ns__echoSimpleTypesAsStructResponse(soap, (const struct ns__echoSimpleTypesAsStructResponse *)ptr);
		break;
	case SOAP_TYPE_ns__echoStructAsSimpleTypes:
		soap_serialize_ns__echoStructAsSimpleTypes(soap, (const struct ns__echoStructAsSimpleTypes *)ptr);
		break;
	case SOAP_TYPE_ns__echoStructAsSimpleTypesResponse:
		soap_serialize_ns__echoStructAsSimpleTypesResponse(soap, (const struct ns__echoStructAsSimpleTypesResponse *)ptr);
		break;
	case SOAP_TYPE_ns__echoBoolean:
		soap_serialize_ns__echoBoolean(soap, (const struct ns__echoBoolean *)ptr);
		break;
	case SOAP_TYPE_ns__echoBooleanResponse:
		soap_serialize_ns__echoBooleanResponse(soap, (const struct ns__echoBooleanResponse *)ptr);
		break;
	case SOAP_TYPE_ns__echoDecimal:
		soap_serialize_ns__echoDecimal(soap, (const struct ns__echoDecimal *)ptr);
		break;
	case SOAP_TYPE_ns__echoDecimalResponse:
		soap_serialize_ns__echoDecimalResponse(soap, (const struct ns__echoDecimalResponse *)ptr);
		break;
	case SOAP_TYPE_ns__echoHexBinary:
		soap_serialize_ns__echoHexBinary(soap, (const struct ns__echoHexBinary *)ptr);
		break;
	case SOAP_TYPE_ns__echoHexBinaryResponse:
		soap_serialize_ns__echoHexBinaryResponse(soap, (const struct ns__echoHexBinaryResponse *)ptr);
		break;
	case SOAP_TYPE_xsd__hexBinary:
		soap_serialize_xsd__hexBinary(soap, (const struct xsd__hexBinary *)ptr);
		break;
	case SOAP_TYPE_ns__echoDate:
		soap_serialize_ns__echoDate(soap, (const struct ns__echoDate *)ptr);
		break;
	case SOAP_TYPE_ns__echoDateResponse:
		soap_serialize_ns__echoDateResponse(soap, (const struct ns__echoDateResponse *)ptr);
		break;
	case SOAP_TYPE_ns__echoBase64:
		soap_serialize_ns__echoBase64(soap, (const struct ns__echoBase64 *)ptr);
		break;
	case SOAP_TYPE_ns__echoBase64Response:
		soap_serialize_ns__echoBase64Response(soap, (const struct ns__echoBase64Response *)ptr);
		break;
	case SOAP_TYPE_xsd__base64Binary:
		soap_serialize_xsd__base64Binary(soap, (const struct xsd__base64Binary *)ptr);
		break;
	case SOAP_TYPE_ns__echoVoid:
		soap_serialize_ns__echoVoid(soap, (const struct ns__echoVoid *)ptr);
		break;
	case SOAP_TYPE_ns__echoVoidResponse:
		soap_serialize_ns__echoVoidResponse(soap, (const struct ns__echoVoidResponse *)ptr);
		break;
	case SOAP_TYPE_ns__echoStructArray:
		soap_serialize_ns__echoStructArray(soap, (const struct ns__echoStructArray *)ptr);
		break;
	case SOAP_TYPE_ns__echoStructArrayResponse:
		soap_serialize_ns__echoStructArrayResponse(soap, (const struct ns__echoStructArrayResponse *)ptr);
		break;
	case SOAP_TYPE_ArrayOfSOAPStruct:
		soap_serialize_ArrayOfSOAPStruct(soap, (const struct ArrayOfSOAPStruct *)ptr);
		break;
	case SOAP_TYPE_ns__echoStruct:
		soap_serialize_ns__echoStruct(soap, (const struct ns__echoStruct *)ptr);
		break;
	case SOAP_TYPE_ns__echoStructResponse:
		soap_serialize_ns__echoStructResponse(soap, (const struct ns__echoStructResponse *)ptr);
		break;
	case SOAP_TYPE_s__SOAPStruct:
		soap_serialize_s__SOAPStruct(soap, (const struct s__SOAPStruct *)ptr);
		break;
	case SOAP_TYPE_ns__echoFloatArray:
		soap_serialize_ns__echoFloatArray(soap, (const struct ns__echoFloatArray *)ptr);
		break;
	case SOAP_TYPE_ns__echoFloatArrayResponse:
		soap_serialize_ns__echoFloatArrayResponse(soap, (const struct ns__echoFloatArrayResponse *)ptr);
		break;
	case SOAP_TYPE_ArrayOffloat:
		soap_serialize_ArrayOffloat(soap, (const struct ArrayOffloat *)ptr);
		break;
	case SOAP_TYPE_ns__echoFloat:
		soap_serialize_ns__echoFloat(soap, (const struct ns__echoFloat *)ptr);
		break;
	case SOAP_TYPE_ns__echoFloatResponse:
		soap_serialize_ns__echoFloatResponse(soap, (const struct ns__echoFloatResponse *)ptr);
		break;
	case SOAP_TYPE_ns__echoIntegerArray:
		soap_serialize_ns__echoIntegerArray(soap, (const struct ns__echoIntegerArray *)ptr);
		break;
	case SOAP_TYPE_ns__echoIntegerArrayResponse:
		soap_serialize_ns__echoIntegerArrayResponse(soap, (const struct ns__echoIntegerArrayResponse *)ptr);
		break;
	case SOAP_TYPE_ArrayOfint:
		soap_serialize_ArrayOfint(soap, (const struct ArrayOfint *)ptr);
		break;
	case SOAP_TYPE_ns__echoInteger:
		soap_serialize_ns__echoInteger(soap, (const struct ns__echoInteger *)ptr);
		break;
	case SOAP_TYPE_ns__echoIntegerResponse:
		soap_serialize_ns__echoIntegerResponse(soap, (const struct ns__echoIntegerResponse *)ptr);
		break;
	case SOAP_TYPE_ns__echoStringArray:
		soap_serialize_ns__echoStringArray(soap, (const struct ns__echoStringArray *)ptr);
		break;
	case SOAP_TYPE_ns__echoStringArrayResponse:
		soap_serialize_ns__echoStringArrayResponse(soap, (const struct ns__echoStringArrayResponse *)ptr);
		break;
	case SOAP_TYPE_ArrayOfstring:
		soap_serialize_ArrayOfstring(soap, (const struct ArrayOfstring *)ptr);
		break;
	case SOAP_TYPE_ns__echoString:
		soap_serialize_ns__echoString(soap, (const struct ns__echoString *)ptr);
		break;
	case SOAP_TYPE_ns__echoStringResponse:
		soap_serialize_ns__echoStringResponse(soap, (const struct ns__echoStringResponse *)ptr);
		break;
	case SOAP_TYPE_xsd__decimal:
		soap_serialize_string(soap, (char*const*)&ptr);
		break;
	case SOAP_TYPE_xsd__dateTime:
		soap_serialize_string(soap, (char*const*)&ptr);
		break;
	case SOAP_TYPE_PointerTounsignedByte:
		soap_serialize_PointerTounsignedByte(soap, (unsigned char *const*)ptr);
		break;
	case SOAP_TYPE_PointerToPointerTos__SOAPStruct:
		soap_serialize_PointerToPointerTos__SOAPStruct(soap, (struct s__SOAPStruct **const*)ptr);
		break;
	case SOAP_TYPE_PointerTos__SOAPStruct:
		soap_serialize_PointerTos__SOAPStruct(soap, (struct s__SOAPStruct *const*)ptr);
		break;
	case SOAP_TYPE_PointerToPointerToxsd__float:
		soap_serialize_PointerToPointerToxsd__float(soap, (float **const*)ptr);
		break;
	case SOAP_TYPE_PointerToxsd__float:
		soap_serialize_PointerToxsd__float(soap, (float *const*)ptr);
		break;
	case SOAP_TYPE_PointerToPointerToxsd__int:
		soap_serialize_PointerToPointerToxsd__int(soap, (long **const*)ptr);
		break;
	case SOAP_TYPE_PointerToxsd__int:
		soap_serialize_PointerToxsd__int(soap, (long *const*)ptr);
		break;
	case SOAP_TYPE_PointerToxsd__string:
		soap_serialize_PointerToxsd__string(soap, (char **const*)ptr);
		break;
	case SOAP_TYPE_xsd__string:
		soap_serialize_string(soap, (char*const*)&ptr);
		break;
	case SOAP_TYPE__QName:
		soap_serialize_string(soap, (char*const*)&ptr);
		break;
	case SOAP_TYPE_string:
		soap_serialize_string(soap, (char*const*)&ptr);
		break;
	case SOAP_TYPE_Array2Ofint:
		soap_serialize_Array2Ofint(soap, (int (*))ptr);
		break;
	}
}

#ifdef __cplusplus
}
#endif
#endif

SOAP_FMAC3 void * SOAP_FMAC4 soap_instantiate(struct soap *soap, int t, const char *type, const char *arrayType, size_t *n)
{
	switch (t)
	{
	case SOAP_TYPE_ns__echoStringResponse:
		return (void*)soap_instantiate_ns__echoStringResponse(soap, -1, type, arrayType, n);
	case SOAP_TYPE_ns__echoString:
		return (void*)soap_instantiate_ns__echoString(soap, -1, type, arrayType, n);
	case SOAP_TYPE_ArrayOfstring:
		return (void*)soap_instantiate_ArrayOfstring(soap, -1, type, arrayType, n);
	case SOAP_TYPE_ns__echoStringArrayResponse:
		return (void*)soap_instantiate_ns__echoStringArrayResponse(soap, -1, type, arrayType, n);
	case SOAP_TYPE_ns__echoStringArray:
		return (void*)soap_instantiate_ns__echoStringArray(soap, -1, type, arrayType, n);
	case SOAP_TYPE_ns__echoIntegerResponse:
		return (void*)soap_instantiate_ns__echoIntegerResponse(soap, -1, type, arrayType, n);
	case SOAP_TYPE_ns__echoInteger:
		return (void*)soap_instantiate_ns__echoInteger(soap, -1, type, arrayType, n);
	case SOAP_TYPE_ArrayOfint:
		return (void*)soap_instantiate_ArrayOfint(soap, -1, type, arrayType, n);
	case SOAP_TYPE_ns__echoIntegerArrayResponse:
		return (void*)soap_instantiate_ns__echoIntegerArrayResponse(soap, -1, type, arrayType, n);
	case SOAP_TYPE_ns__echoIntegerArray:
		return (void*)soap_instantiate_ns__echoIntegerArray(soap, -1, type, arrayType, n);
	case SOAP_TYPE_ns__echoFloatResponse:
		return (void*)soap_instantiate_ns__echoFloatResponse(soap, -1, type, arrayType, n);
	case SOAP_TYPE_ns__echoFloat:
		return (void*)soap_instantiate_ns__echoFloat(soap, -1, type, arrayType, n);
	case SOAP_TYPE_ArrayOffloat:
		return (void*)soap_instantiate_ArrayOffloat(soap, -1, type, arrayType, n);
	case SOAP_TYPE_ns__echoFloatArrayResponse:
		return (void*)soap_instantiate_ns__echoFloatArrayResponse(soap, -1, type, arrayType, n);
	case SOAP_TYPE_ns__echoFloatArray:
		return (void*)soap_instantiate_ns__echoFloatArray(soap, -1, type, arrayType, n);
	case SOAP_TYPE_s__SOAPStruct:
		return (void*)soap_instantiate_s__SOAPStruct(soap, -1, type, arrayType, n);
	case SOAP_TYPE_ns__echoStructResponse:
		return (void*)soap_instantiate_ns__echoStructResponse(soap, -1, type, arrayType, n);
	case SOAP_TYPE_ns__echoStruct:
		return (void*)soap_instantiate_ns__echoStruct(soap, -1, type, arrayType, n);
	case SOAP_TYPE_ArrayOfSOAPStruct:
		return (void*)soap_instantiate_ArrayOfSOAPStruct(soap, -1, type, arrayType, n);
	case SOAP_TYPE_ns__echoStructArrayResponse:
		return (void*)soap_instantiate_ns__echoStructArrayResponse(soap, -1, type, arrayType, n);
	case SOAP_TYPE_ns__echoStructArray:
		return (void*)soap_instantiate_ns__echoStructArray(soap, -1, type, arrayType, n);
	case SOAP_TYPE_ns__echoVoidResponse:
		return (void*)soap_instantiate_ns__echoVoidResponse(soap, -1, type, arrayType, n);
	case SOAP_TYPE_ns__echoVoid:
		return (void*)soap_instantiate_ns__echoVoid(soap, -1, type, arrayType, n);
	case SOAP_TYPE_xsd__base64Binary:
		return (void*)soap_instantiate_xsd__base64Binary(soap, -1, type, arrayType, n);
	case SOAP_TYPE_ns__echoBase64Response:
		return (void*)soap_instantiate_ns__echoBase64Response(soap, -1, type, arrayType, n);
	case SOAP_TYPE_ns__echoBase64:
		return (void*)soap_instantiate_ns__echoBase64(soap, -1, type, arrayType, n);
	case SOAP_TYPE_ns__echoDateResponse:
		return (void*)soap_instantiate_ns__echoDateResponse(soap, -1, type, arrayType, n);
	case SOAP_TYPE_ns__echoDate:
		return (void*)soap_instantiate_ns__echoDate(soap, -1, type, arrayType, n);
	case SOAP_TYPE_xsd__hexBinary:
		return (void*)soap_instantiate_xsd__hexBinary(soap, -1, type, arrayType, n);
	case SOAP_TYPE_ns__echoHexBinaryResponse:
		return (void*)soap_instantiate_ns__echoHexBinaryResponse(soap, -1, type, arrayType, n);
	case SOAP_TYPE_ns__echoHexBinary:
		return (void*)soap_instantiate_ns__echoHexBinary(soap, -1, type, arrayType, n);
	case SOAP_TYPE_ns__echoDecimalResponse:
		return (void*)soap_instantiate_ns__echoDecimalResponse(soap, -1, type, arrayType, n);
	case SOAP_TYPE_ns__echoDecimal:
		return (void*)soap_instantiate_ns__echoDecimal(soap, -1, type, arrayType, n);
	case SOAP_TYPE_ns__echoBooleanResponse:
		return (void*)soap_instantiate_ns__echoBooleanResponse(soap, -1, type, arrayType, n);
	case SOAP_TYPE_ns__echoBoolean:
		return (void*)soap_instantiate_ns__echoBoolean(soap, -1, type, arrayType, n);
	case SOAP_TYPE_ns__echoStructAsSimpleTypesResponse:
		return (void*)soap_instantiate_ns__echoStructAsSimpleTypesResponse(soap, -1, type, arrayType, n);
	case SOAP_TYPE_ns__echoStructAsSimpleTypes:
		return (void*)soap_instantiate_ns__echoStructAsSimpleTypes(soap, -1, type, arrayType, n);
	case SOAP_TYPE_ns__echoSimpleTypesAsStructResponse:
		return (void*)soap_instantiate_ns__echoSimpleTypesAsStructResponse(soap, -1, type, arrayType, n);
	case SOAP_TYPE_ns__echoSimpleTypesAsStruct:
		return (void*)soap_instantiate_ns__echoSimpleTypesAsStruct(soap, -1, type, arrayType, n);
	case SOAP_TYPE_ArrayOfstring2D:
		return (void*)soap_instantiate_ArrayOfstring2D(soap, -1, type, arrayType, n);
	case SOAP_TYPE_ns__echo2DStringArrayResponse:
		return (void*)soap_instantiate_ns__echo2DStringArrayResponse(soap, -1, type, arrayType, n);
	case SOAP_TYPE_ns__echo2DStringArray:
		return (void*)soap_instantiate_ns__echo2DStringArray(soap, -1, type, arrayType, n);
	case SOAP_TYPE_s__SOAPStructStruct:
		return (void*)soap_instantiate_s__SOAPStructStruct(soap, -1, type, arrayType, n);
	case SOAP_TYPE_ns__echoNestedStructResponse:
		return (void*)soap_instantiate_ns__echoNestedStructResponse(soap, -1, type, arrayType, n);
	case SOAP_TYPE_ns__echoNestedStruct:
		return (void*)soap_instantiate_ns__echoNestedStruct(soap, -1, type, arrayType, n);
	case SOAP_TYPE_s__SOAPArrayStruct:
		return (void*)soap_instantiate_s__SOAPArrayStruct(soap, -1, type, arrayType, n);
	case SOAP_TYPE_ns__echoNestedArrayResponse:
		return (void*)soap_instantiate_ns__echoNestedArrayResponse(soap, -1, type, arrayType, n);
	case SOAP_TYPE_ns__echoNestedArray:
		return (void*)soap_instantiate_ns__echoNestedArray(soap, -1, type, arrayType, n);
#ifndef WITH_NOGLOBAL
	case SOAP_TYPE_SOAP_ENV__Header:
		return (void*)soap_instantiate_SOAP_ENV__Header(soap, -1, type, arrayType, n);
#endif
	case SOAP_TYPE_m__echoVoidResponse:
		return (void*)soap_instantiate_m__echoVoidResponse(soap, -1, type, arrayType, n);
	case SOAP_TYPE_m__echoVoid:
		return (void*)soap_instantiate_m__echoVoid(soap, -1, type, arrayType, n);
#ifndef WITH_NOGLOBAL
	case SOAP_TYPE_SOAP_ENV__Code:
		return (void*)soap_instantiate_SOAP_ENV__Code(soap, -1, type, arrayType, n);
#endif
#ifndef WITH_NOGLOBAL
	case SOAP_TYPE_SOAP_ENV__Detail:
		return (void*)soap_instantiate_SOAP_ENV__Detail(soap, -1, type, arrayType, n);
#endif
#ifndef WITH_NOGLOBAL
	case SOAP_TYPE_SOAP_ENV__Reason:
		return (void*)soap_instantiate_SOAP_ENV__Reason(soap, -1, type, arrayType, n);
#endif
#ifndef WITH_NOGLOBAL
	case SOAP_TYPE_SOAP_ENV__Fault:
		return (void*)soap_instantiate_SOAP_ENV__Fault(soap, -1, type, arrayType, n);
#endif
	}
	return NULL;
}

SOAP_FMAC3 int SOAP_FMAC4 soap_fdelete(struct soap_clist *p)
{	switch (p->type)
	{
	case SOAP_TYPE_ns__echoStringResponse:
		if (p->size < 0)
			delete (struct ns__echoStringResponse*)p->ptr;
		else
			delete[] (struct ns__echoStringResponse*)p->ptr;
		break;
	case SOAP_TYPE_ns__echoString:
		if (p->size < 0)
			delete (struct ns__echoString*)p->ptr;
		else
			delete[] (struct ns__echoString*)p->ptr;
		break;
	case SOAP_TYPE_ArrayOfstring:
		if (p->size < 0)
			delete (struct ArrayOfstring*)p->ptr;
		else
			delete[] (struct ArrayOfstring*)p->ptr;
		break;
	case SOAP_TYPE_ns__echoStringArrayResponse:
		if (p->size < 0)
			delete (struct ns__echoStringArrayResponse*)p->ptr;
		else
			delete[] (struct ns__echoStringArrayResponse*)p->ptr;
		break;
	case SOAP_TYPE_ns__echoStringArray:
		if (p->size < 0)
			delete (struct ns__echoStringArray*)p->ptr;
		else
			delete[] (struct ns__echoStringArray*)p->ptr;
		break;
	case SOAP_TYPE_ns__echoIntegerResponse:
		if (p->size < 0)
			delete (struct ns__echoIntegerResponse*)p->ptr;
		else
			delete[] (struct ns__echoIntegerResponse*)p->ptr;
		break;
	case SOAP_TYPE_ns__echoInteger:
		if (p->size < 0)
			delete (struct ns__echoInteger*)p->ptr;
		else
			delete[] (struct ns__echoInteger*)p->ptr;
		break;
	case SOAP_TYPE_ArrayOfint:
		if (p->size < 0)
			delete (struct ArrayOfint*)p->ptr;
		else
			delete[] (struct ArrayOfint*)p->ptr;
		break;
	case SOAP_TYPE_ns__echoIntegerArrayResponse:
		if (p->size < 0)
			delete (struct ns__echoIntegerArrayResponse*)p->ptr;
		else
			delete[] (struct ns__echoIntegerArrayResponse*)p->ptr;
		break;
	case SOAP_TYPE_ns__echoIntegerArray:
		if (p->size < 0)
			delete (struct ns__echoIntegerArray*)p->ptr;
		else
			delete[] (struct ns__echoIntegerArray*)p->ptr;
		break;
	case SOAP_TYPE_ns__echoFloatResponse:
		if (p->size < 0)
			delete (struct ns__echoFloatResponse*)p->ptr;
		else
			delete[] (struct ns__echoFloatResponse*)p->ptr;
		break;
	case SOAP_TYPE_ns__echoFloat:
		if (p->size < 0)
			delete (struct ns__echoFloat*)p->ptr;
		else
			delete[] (struct ns__echoFloat*)p->ptr;
		break;
	case SOAP_TYPE_ArrayOffloat:
		if (p->size < 0)
			delete (struct ArrayOffloat*)p->ptr;
		else
			delete[] (struct ArrayOffloat*)p->ptr;
		break;
	case SOAP_TYPE_ns__echoFloatArrayResponse:
		if (p->size < 0)
			delete (struct ns__echoFloatArrayResponse*)p->ptr;
		else
			delete[] (struct ns__echoFloatArrayResponse*)p->ptr;
		break;
	case SOAP_TYPE_ns__echoFloatArray:
		if (p->size < 0)
			delete (struct ns__echoFloatArray*)p->ptr;
		else
			delete[] (struct ns__echoFloatArray*)p->ptr;
		break;
	case SOAP_TYPE_s__SOAPStruct:
		if (p->size < 0)
			delete (struct s__SOAPStruct*)p->ptr;
		else
			delete[] (struct s__SOAPStruct*)p->ptr;
		break;
	case SOAP_TYPE_ns__echoStructResponse:
		if (p->size < 0)
			delete (struct ns__echoStructResponse*)p->ptr;
		else
			delete[] (struct ns__echoStructResponse*)p->ptr;
		break;
	case SOAP_TYPE_ns__echoStruct:
		if (p->size < 0)
			delete (struct ns__echoStruct*)p->ptr;
		else
			delete[] (struct ns__echoStruct*)p->ptr;
		break;
	case SOAP_TYPE_ArrayOfSOAPStruct:
		if (p->size < 0)
			delete (struct ArrayOfSOAPStruct*)p->ptr;
		else
			delete[] (struct ArrayOfSOAPStruct*)p->ptr;
		break;
	case SOAP_TYPE_ns__echoStructArrayResponse:
		if (p->size < 0)
			delete (struct ns__echoStructArrayResponse*)p->ptr;
		else
			delete[] (struct ns__echoStructArrayResponse*)p->ptr;
		break;
	case SOAP_TYPE_ns__echoStructArray:
		if (p->size < 0)
			delete (struct ns__echoStructArray*)p->ptr;
		else
			delete[] (struct ns__echoStructArray*)p->ptr;
		break;
	case SOAP_TYPE_ns__echoVoidResponse:
		if (p->size < 0)
			delete (struct ns__echoVoidResponse*)p->ptr;
		else
			delete[] (struct ns__echoVoidResponse*)p->ptr;
		break;
	case SOAP_TYPE_ns__echoVoid:
		if (p->size < 0)
			delete (struct ns__echoVoid*)p->ptr;
		else
			delete[] (struct ns__echoVoid*)p->ptr;
		break;
	case SOAP_TYPE_xsd__base64Binary:
		if (p->size < 0)
			delete (struct xsd__base64Binary*)p->ptr;
		else
			delete[] (struct xsd__base64Binary*)p->ptr;
		break;
	case SOAP_TYPE_ns__echoBase64Response:
		if (p->size < 0)
			delete (struct ns__echoBase64Response*)p->ptr;
		else
			delete[] (struct ns__echoBase64Response*)p->ptr;
		break;
	case SOAP_TYPE_ns__echoBase64:
		if (p->size < 0)
			delete (struct ns__echoBase64*)p->ptr;
		else
			delete[] (struct ns__echoBase64*)p->ptr;
		break;
	case SOAP_TYPE_ns__echoDateResponse:
		if (p->size < 0)
			delete (struct ns__echoDateResponse*)p->ptr;
		else
			delete[] (struct ns__echoDateResponse*)p->ptr;
		break;
	case SOAP_TYPE_ns__echoDate:
		if (p->size < 0)
			delete (struct ns__echoDate*)p->ptr;
		else
			delete[] (struct ns__echoDate*)p->ptr;
		break;
	case SOAP_TYPE_xsd__hexBinary:
		if (p->size < 0)
			delete (struct xsd__hexBinary*)p->ptr;
		else
			delete[] (struct xsd__hexBinary*)p->ptr;
		break;
	case SOAP_TYPE_ns__echoHexBinaryResponse:
		if (p->size < 0)
			delete (struct ns__echoHexBinaryResponse*)p->ptr;
		else
			delete[] (struct ns__echoHexBinaryResponse*)p->ptr;
		break;
	case SOAP_TYPE_ns__echoHexBinary:
		if (p->size < 0)
			delete (struct ns__echoHexBinary*)p->ptr;
		else
			delete[] (struct ns__echoHexBinary*)p->ptr;
		break;
	case SOAP_TYPE_ns__echoDecimalResponse:
		if (p->size < 0)
			delete (struct ns__echoDecimalResponse*)p->ptr;
		else
			delete[] (struct ns__echoDecimalResponse*)p->ptr;
		break;
	case SOAP_TYPE_ns__echoDecimal:
		if (p->size < 0)
			delete (struct ns__echoDecimal*)p->ptr;
		else
			delete[] (struct ns__echoDecimal*)p->ptr;
		break;
	case SOAP_TYPE_ns__echoBooleanResponse:
		if (p->size < 0)
			delete (struct ns__echoBooleanResponse*)p->ptr;
		else
			delete[] (struct ns__echoBooleanResponse*)p->ptr;
		break;
	case SOAP_TYPE_ns__echoBoolean:
		if (p->size < 0)
			delete (struct ns__echoBoolean*)p->ptr;
		else
			delete[] (struct ns__echoBoolean*)p->ptr;
		break;
	case SOAP_TYPE_ns__echoStructAsSimpleTypesResponse:
		if (p->size < 0)
			delete (struct ns__echoStructAsSimpleTypesResponse*)p->ptr;
		else
			delete[] (struct ns__echoStructAsSimpleTypesResponse*)p->ptr;
		break;
	case SOAP_TYPE_ns__echoStructAsSimpleTypes:
		if (p->size < 0)
			delete (struct ns__echoStructAsSimpleTypes*)p->ptr;
		else
			delete[] (struct ns__echoStructAsSimpleTypes*)p->ptr;
		break;
	case SOAP_TYPE_ns__echoSimpleTypesAsStructResponse:
		if (p->size < 0)
			delete (struct ns__echoSimpleTypesAsStructResponse*)p->ptr;
		else
			delete[] (struct ns__echoSimpleTypesAsStructResponse*)p->ptr;
		break;
	case SOAP_TYPE_ns__echoSimpleTypesAsStruct:
		if (p->size < 0)
			delete (struct ns__echoSimpleTypesAsStruct*)p->ptr;
		else
			delete[] (struct ns__echoSimpleTypesAsStruct*)p->ptr;
		break;
	case SOAP_TYPE_ArrayOfstring2D:
		if (p->size < 0)
			delete (struct ArrayOfstring2D*)p->ptr;
		else
			delete[] (struct ArrayOfstring2D*)p->ptr;
		break;
	case SOAP_TYPE_ns__echo2DStringArrayResponse:
		if (p->size < 0)
			delete (struct ns__echo2DStringArrayResponse*)p->ptr;
		else
			delete[] (struct ns__echo2DStringArrayResponse*)p->ptr;
		break;
	case SOAP_TYPE_ns__echo2DStringArray:
		if (p->size < 0)
			delete (struct ns__echo2DStringArray*)p->ptr;
		else
			delete[] (struct ns__echo2DStringArray*)p->ptr;
		break;
	case SOAP_TYPE_s__SOAPStructStruct:
		if (p->size < 0)
			delete (struct s__SOAPStructStruct*)p->ptr;
		else
			delete[] (struct s__SOAPStructStruct*)p->ptr;
		break;
	case SOAP_TYPE_ns__echoNestedStructResponse:
		if (p->size < 0)
			delete (struct ns__echoNestedStructResponse*)p->ptr;
		else
			delete[] (struct ns__echoNestedStructResponse*)p->ptr;
		break;
	case SOAP_TYPE_ns__echoNestedStruct:
		if (p->size < 0)
			delete (struct ns__echoNestedStruct*)p->ptr;
		else
			delete[] (struct ns__echoNestedStruct*)p->ptr;
		break;
	case SOAP_TYPE_s__SOAPArrayStruct:
		if (p->size < 0)
			delete (struct s__SOAPArrayStruct*)p->ptr;
		else
			delete[] (struct s__SOAPArrayStruct*)p->ptr;
		break;
	case SOAP_TYPE_ns__echoNestedArrayResponse:
		if (p->size < 0)
			delete (struct ns__echoNestedArrayResponse*)p->ptr;
		else
			delete[] (struct ns__echoNestedArrayResponse*)p->ptr;
		break;
	case SOAP_TYPE_ns__echoNestedArray:
		if (p->size < 0)
			delete (struct ns__echoNestedArray*)p->ptr;
		else
			delete[] (struct ns__echoNestedArray*)p->ptr;
		break;
	case SOAP_TYPE_SOAP_ENV__Header:
		if (p->size < 0)
			delete (struct SOAP_ENV__Header*)p->ptr;
		else
			delete[] (struct SOAP_ENV__Header*)p->ptr;
		break;
	case SOAP_TYPE_m__echoVoidResponse:
		if (p->size < 0)
			delete (struct m__echoVoidResponse*)p->ptr;
		else
			delete[] (struct m__echoVoidResponse*)p->ptr;
		break;
	case SOAP_TYPE_m__echoVoid:
		if (p->size < 0)
			delete (struct m__echoVoid*)p->ptr;
		else
			delete[] (struct m__echoVoid*)p->ptr;
		break;
	case SOAP_TYPE_SOAP_ENV__Code:
		if (p->size < 0)
			delete (struct SOAP_ENV__Code*)p->ptr;
		else
			delete[] (struct SOAP_ENV__Code*)p->ptr;
		break;
	case SOAP_TYPE_SOAP_ENV__Detail:
		if (p->size < 0)
			delete (struct SOAP_ENV__Detail*)p->ptr;
		else
			delete[] (struct SOAP_ENV__Detail*)p->ptr;
		break;
	case SOAP_TYPE_SOAP_ENV__Reason:
		if (p->size < 0)
			delete (struct SOAP_ENV__Reason*)p->ptr;
		else
			delete[] (struct SOAP_ENV__Reason*)p->ptr;
		break;
	case SOAP_TYPE_SOAP_ENV__Fault:
		if (p->size < 0)
			delete (struct SOAP_ENV__Fault*)p->ptr;
		else
			delete[] (struct SOAP_ENV__Fault*)p->ptr;
		break;
	default:	return SOAP_ERR;
	}
	return SOAP_OK;
}

SOAP_FMAC3 void* SOAP_FMAC4 soap_class_id_enter(struct soap *soap, const char *id, void *p, int t, size_t n, const char *type, const char *arrayType)
{	return soap_id_enter(soap, id, p, t, n, 0, type, arrayType, soap_instantiate);
}

SOAP_FMAC3 void SOAP_FMAC4 soap_default_byte(struct soap *soap, char *a)
{	(void)soap; /* appease -Wall -Werror */
#ifdef SOAP_DEFAULT_byte
	*a = SOAP_DEFAULT_byte;
#else
	*a = (char)0;
#endif
}

SOAP_FMAC3 int SOAP_FMAC4 soap_put_byte(struct soap *soap, const char *a, const char *tag, const char *type)
{
	register int id = soap_embed(soap, (void*)a, NULL, 0, tag, SOAP_TYPE_byte);
	if (soap_out_byte(soap, tag, id, a, type))
		return soap->error;
	return soap_putindependent(soap);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out_byte(struct soap *soap, const char *tag, int id, const char *a, const char *type)
{
	return soap_outbyte(soap, tag, id, a, type, SOAP_TYPE_byte);
}

SOAP_FMAC3 char * SOAP_FMAC4 soap_get_byte(struct soap *soap, char *p, const char *tag, const char *type)
{
	if ((p = soap_in_byte(soap, tag, p, type)))
		if (soap_getindependent(soap))
			return NULL;
	return p;
}

SOAP_FMAC3 char * SOAP_FMAC4 soap_in_byte(struct soap *soap, const char *tag, char *a, const char *type)
{
	return soap_inbyte(soap, tag, a, type, SOAP_TYPE_byte);
}

SOAP_FMAC3 void SOAP_FMAC4 soap_default_int(struct soap *soap, int *a)
{	(void)soap; /* appease -Wall -Werror */
#ifdef SOAP_DEFAULT_int
	*a = SOAP_DEFAULT_int;
#else
	*a = (int)0;
#endif
}

SOAP_FMAC3 int SOAP_FMAC4 soap_put_int(struct soap *soap, const int *a, const char *tag, const char *type)
{
	register int id = soap_embed(soap, (void*)a, NULL, 0, tag, SOAP_TYPE_int);
	if (soap_out_int(soap, tag, id, a, type))
		return soap->error;
	return soap_putindependent(soap);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out_int(struct soap *soap, const char *tag, int id, const int *a, const char *type)
{
	return soap_outint(soap, tag, id, a, type, SOAP_TYPE_int);
}

SOAP_FMAC3 int * SOAP_FMAC4 soap_get_int(struct soap *soap, int *p, const char *tag, const char *type)
{
	if ((p = soap_in_int(soap, tag, p, type)))
		if (soap_getindependent(soap))
			return NULL;
	return p;
}

SOAP_FMAC3 int * SOAP_FMAC4 soap_in_int(struct soap *soap, const char *tag, int *a, const char *type)
{
	return soap_inint(soap, tag, a, type, SOAP_TYPE_int);
}

SOAP_FMAC3 void SOAP_FMAC4 soap_default_xsd__int(struct soap *soap, long *a)
{	soap_default_long(soap, a);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_put_xsd__int(struct soap *soap, const long *a, const char *tag, const char *type)
{
	register int id = soap_embed(soap, (void*)a, NULL, 0, tag, SOAP_TYPE_xsd__int);
	if (soap_out_xsd__int(soap, tag, id, a, type))
		return soap->error;
	return soap_putindependent(soap);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out_xsd__int(struct soap *soap, const char *tag, int id, const long *a, const char *type)
{
	return soap_outlong(soap, tag, id, a, type, SOAP_TYPE_xsd__int);
}

SOAP_FMAC3 long * SOAP_FMAC4 soap_get_xsd__int(struct soap *soap, long *p, const char *tag, const char *type)
{
	if ((p = soap_in_xsd__int(soap, tag, p, type)))
		if (soap_getindependent(soap))
			return NULL;
	return p;
}

SOAP_FMAC3 long * SOAP_FMAC4 soap_in_xsd__int(struct soap *soap, const char *tag, long *a, const char *type)
{
	return soap_inlong(soap, tag, a, type, SOAP_TYPE_xsd__int);
}

SOAP_FMAC3 void SOAP_FMAC4 soap_default_long(struct soap *soap, long *a)
{	(void)soap; /* appease -Wall -Werror */
#ifdef SOAP_DEFAULT_long
	*a = SOAP_DEFAULT_long;
#else
	*a = (long)0;
#endif
}

SOAP_FMAC3 int SOAP_FMAC4 soap_put_long(struct soap *soap, const long *a, const char *tag, const char *type)
{
	register int id = soap_embed(soap, (void*)a, NULL, 0, tag, SOAP_TYPE_long);
	if (soap_out_long(soap, tag, id, a, type))
		return soap->error;
	return soap_putindependent(soap);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out_long(struct soap *soap, const char *tag, int id, const long *a, const char *type)
{
	return soap_outlong(soap, tag, id, a, type, SOAP_TYPE_long);
}

SOAP_FMAC3 long * SOAP_FMAC4 soap_get_long(struct soap *soap, long *p, const char *tag, const char *type)
{
	if ((p = soap_in_long(soap, tag, p, type)))
		if (soap_getindependent(soap))
			return NULL;
	return p;
}

SOAP_FMAC3 long * SOAP_FMAC4 soap_in_long(struct soap *soap, const char *tag, long *a, const char *type)
{
	return soap_inlong(soap, tag, a, type, SOAP_TYPE_long);
}

SOAP_FMAC3 void SOAP_FMAC4 soap_default_xsd__float(struct soap *soap, float *a)
{	soap_default_float(soap, a);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_put_xsd__float(struct soap *soap, const float *a, const char *tag, const char *type)
{
	register int id = soap_embed(soap, (void*)a, NULL, 0, tag, SOAP_TYPE_xsd__float);
	if (soap_out_xsd__float(soap, tag, id, a, type))
		return soap->error;
	return soap_putindependent(soap);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out_xsd__float(struct soap *soap, const char *tag, int id, const float *a, const char *type)
{
	return soap_outfloat(soap, tag, id, a, type, SOAP_TYPE_xsd__float);
}

SOAP_FMAC3 float * SOAP_FMAC4 soap_get_xsd__float(struct soap *soap, float *p, const char *tag, const char *type)
{
	if ((p = soap_in_xsd__float(soap, tag, p, type)))
		if (soap_getindependent(soap))
			return NULL;
	return p;
}

SOAP_FMAC3 float * SOAP_FMAC4 soap_in_xsd__float(struct soap *soap, const char *tag, float *a, const char *type)
{
	return soap_infloat(soap, tag, a, type, SOAP_TYPE_xsd__float);
}

SOAP_FMAC3 void SOAP_FMAC4 soap_default_float(struct soap *soap, float *a)
{	(void)soap; /* appease -Wall -Werror */
#ifdef SOAP_DEFAULT_float
	*a = SOAP_DEFAULT_float;
#else
	*a = (float)0;
#endif
}

SOAP_FMAC3 int SOAP_FMAC4 soap_put_float(struct soap *soap, const float *a, const char *tag, const char *type)
{
	register int id = soap_embed(soap, (void*)a, NULL, 0, tag, SOAP_TYPE_float);
	if (soap_out_float(soap, tag, id, a, type))
		return soap->error;
	return soap_putindependent(soap);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out_float(struct soap *soap, const char *tag, int id, const float *a, const char *type)
{
	return soap_outfloat(soap, tag, id, a, type, SOAP_TYPE_float);
}

SOAP_FMAC3 float * SOAP_FMAC4 soap_get_float(struct soap *soap, float *p, const char *tag, const char *type)
{
	if ((p = soap_in_float(soap, tag, p, type)))
		if (soap_getindependent(soap))
			return NULL;
	return p;
}

SOAP_FMAC3 float * SOAP_FMAC4 soap_in_float(struct soap *soap, const char *tag, float *a, const char *type)
{
	return soap_infloat(soap, tag, a, type, SOAP_TYPE_float);
}

SOAP_FMAC3 void SOAP_FMAC4 soap_default_unsignedByte(struct soap *soap, unsigned char *a)
{	(void)soap; /* appease -Wall -Werror */
#ifdef SOAP_DEFAULT_unsignedByte
	*a = SOAP_DEFAULT_unsignedByte;
#else
	*a = (unsigned char)0;
#endif
}

SOAP_FMAC3 int SOAP_FMAC4 soap_put_unsignedByte(struct soap *soap, const unsigned char *a, const char *tag, const char *type)
{
	register int id = soap_embed(soap, (void*)a, NULL, 0, tag, SOAP_TYPE_unsignedByte);
	if (soap_out_unsignedByte(soap, tag, id, a, type))
		return soap->error;
	return soap_putindependent(soap);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out_unsignedByte(struct soap *soap, const char *tag, int id, const unsigned char *a, const char *type)
{
	return soap_outunsignedByte(soap, tag, id, a, type, SOAP_TYPE_unsignedByte);
}

SOAP_FMAC3 unsigned char * SOAP_FMAC4 soap_get_unsignedByte(struct soap *soap, unsigned char *p, const char *tag, const char *type)
{
	if ((p = soap_in_unsignedByte(soap, tag, p, type)))
		if (soap_getindependent(soap))
			return NULL;
	return p;
}

SOAP_FMAC3 unsigned char * SOAP_FMAC4 soap_in_unsignedByte(struct soap *soap, const char *tag, unsigned char *a, const char *type)
{
	return soap_inunsignedByte(soap, tag, a, type, SOAP_TYPE_unsignedByte);
}

SOAP_FMAC3 void SOAP_FMAC4 soap_default_unsignedInt(struct soap *soap, unsigned int *a)
{	(void)soap; /* appease -Wall -Werror */
#ifdef SOAP_DEFAULT_unsignedInt
	*a = SOAP_DEFAULT_unsignedInt;
#else
	*a = (unsigned int)0;
#endif
}

SOAP_FMAC3 int SOAP_FMAC4 soap_put_unsignedInt(struct soap *soap, const unsigned int *a, const char *tag, const char *type)
{
	register int id = soap_embed(soap, (void*)a, NULL, 0, tag, SOAP_TYPE_unsignedInt);
	if (soap_out_unsignedInt(soap, tag, id, a, type))
		return soap->error;
	return soap_putindependent(soap);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out_unsignedInt(struct soap *soap, const char *tag, int id, const unsigned int *a, const char *type)
{
	return soap_outunsignedInt(soap, tag, id, a, type, SOAP_TYPE_unsignedInt);
}

SOAP_FMAC3 unsigned int * SOAP_FMAC4 soap_get_unsignedInt(struct soap *soap, unsigned int *p, const char *tag, const char *type)
{
	if ((p = soap_in_unsignedInt(soap, tag, p, type)))
		if (soap_getindependent(soap))
			return NULL;
	return p;
}

SOAP_FMAC3 unsigned int * SOAP_FMAC4 soap_in_unsignedInt(struct soap *soap, const char *tag, unsigned int *a, const char *type)
{
	return soap_inunsignedInt(soap, tag, a, type, SOAP_TYPE_unsignedInt);
}

SOAP_FMAC3 void SOAP_FMAC4 soap_default_xsd__boolean(struct soap *soap, bool *a)
{	soap_default_bool(soap, a);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_put_xsd__boolean(struct soap *soap, const bool *a, const char *tag, const char *type)
{
	register int id = soap_embed(soap, (void*)a, NULL, 0, tag, SOAP_TYPE_xsd__boolean);
	if (soap_out_xsd__boolean(soap, tag, id, a, type))
		return soap->error;
	return soap_putindependent(soap);
}

SOAP_FMAC3S const char* SOAP_FMAC4S soap_xsd__boolean2s(struct soap *soap, bool n)
{	return soap_bool2s(soap, n);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out_xsd__boolean(struct soap *soap, const char *tag, int id, const bool *a, const char *type)
{	if (soap_element_begin_out(soap, tag, soap_embedded_id(soap, id, a, SOAP_TYPE_xsd__boolean), type) || soap_send(soap, soap_xsd__boolean2s(soap, *a)))
		return soap->error;
	return soap_element_end_out(soap, tag);
}

SOAP_FMAC3 bool * SOAP_FMAC4 soap_get_xsd__boolean(struct soap *soap, bool *p, const char *tag, const char *type)
{
	if ((p = soap_in_xsd__boolean(soap, tag, p, type)))
		if (soap_getindependent(soap))
			return NULL;
	return p;
}

SOAP_FMAC3S int SOAP_FMAC4S soap_s2xsd__boolean(struct soap *soap, const char *s, bool *a)
{
	return soap_s2bool(soap, s, a);
}

SOAP_FMAC3 bool * SOAP_FMAC4 soap_in_xsd__boolean(struct soap *soap, const char *tag, bool *a, const char *type)
{
	if (soap_element_begin_in(soap, tag, 0, NULL))
		return NULL;
	if (*soap->type && soap_match_tag(soap, soap->type, type) && soap_match_tag(soap, soap->type, ":boolean"))
	{	soap->error = SOAP_TYPE;
		return NULL;
	}
	a = (bool *)soap_id_enter(soap, soap->id, a, SOAP_TYPE_xsd__boolean, sizeof(bool), 0, NULL, NULL, NULL);
	if (!a)
		return NULL;
	if (soap->body && !*soap->href)
	{	if (!a || soap_s2xsd__boolean(soap, soap_value(soap), a) || soap_element_end_in(soap, tag))
			return NULL;
	}
	else
	{	a = (bool *)soap_id_forward(soap, soap->href, (void*)a, 0, SOAP_TYPE_xsd__boolean, 0, sizeof(bool), 0, NULL);
		if (soap->body && soap_element_end_in(soap, tag))
			return NULL;
	}
	return a;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_default_bool(struct soap *soap, bool *a)
{	(void)soap; /* appease -Wall -Werror */
#ifdef SOAP_DEFAULT_bool
	*a = SOAP_DEFAULT_bool;
#else
	*a = (bool)0;
#endif
}

SOAP_FMAC3 int SOAP_FMAC4 soap_put_bool(struct soap *soap, const bool *a, const char *tag, const char *type)
{
	register int id = soap_embed(soap, (void*)a, NULL, 0, tag, SOAP_TYPE_bool);
	if (soap_out_bool(soap, tag, id, a, type))
		return soap->error;
	return soap_putindependent(soap);
}

static const struct soap_code_map soap_codes_bool[] =
{	{ (long)false, "false" },
	{ (long)true, "true" },
	{ 0, NULL }
};

SOAP_FMAC3S const char* SOAP_FMAC4S soap_bool2s(struct soap *soap, bool n)
{	return soap_code_str(soap_codes_bool, n!=0);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out_bool(struct soap *soap, const char *tag, int id, const bool *a, const char *type)
{	if (soap_element_begin_out(soap, tag, soap_embedded_id(soap, id, a, SOAP_TYPE_bool), type) || soap_send(soap, soap_bool2s(soap, *a)))
		return soap->error;
	return soap_element_end_out(soap, tag);
}

SOAP_FMAC3 bool * SOAP_FMAC4 soap_get_bool(struct soap *soap, bool *p, const char *tag, const char *type)
{
	if ((p = soap_in_bool(soap, tag, p, type)))
		if (soap_getindependent(soap))
			return NULL;
	return p;
}

SOAP_FMAC3S int SOAP_FMAC4S soap_s2bool(struct soap *soap, const char *s, bool *a)
{
	const struct soap_code_map *map;
	if (!s)
		return SOAP_OK;
	map = soap_code(soap_codes_bool, s);
	if (map)
		*a = (bool)(map->code != 0);
	else
	{	long n;
		if (soap_s2long(soap, s, &n) || n < 0 || n > 1)
			return soap->error = SOAP_TYPE;
		*a = (bool)(n != 0);
	}
	return SOAP_OK;
}

SOAP_FMAC3 bool * SOAP_FMAC4 soap_in_bool(struct soap *soap, const char *tag, bool *a, const char *type)
{
	if (soap_element_begin_in(soap, tag, 0, NULL))
		return NULL;
	if (*soap->type && soap_match_tag(soap, soap->type, type) && soap_match_tag(soap, soap->type, ":boolean"))
	{	soap->error = SOAP_TYPE;
		return NULL;
	}
	a = (bool *)soap_id_enter(soap, soap->id, a, SOAP_TYPE_bool, sizeof(bool), 0, NULL, NULL, NULL);
	if (!a)
		return NULL;
	if (soap->body && !*soap->href)
	{	if (!a || soap_s2bool(soap, soap_value(soap), a) || soap_element_end_in(soap, tag))
			return NULL;
	}
	else
	{	a = (bool *)soap_id_forward(soap, soap->href, (void*)a, 0, SOAP_TYPE_bool, 0, sizeof(bool), 0, NULL);
		if (soap->body && soap_element_end_in(soap, tag))
			return NULL;
	}
	return a;
}

#ifndef WITH_NOGLOBAL

SOAP_FMAC3 void SOAP_FMAC4 soap_default_SOAP_ENV__Fault(struct soap *soap, struct SOAP_ENV__Fault *a)
{
	(void)soap; (void)a; /* appease -Wall -Werror */
	soap_default__QName(soap, &a->faultcode);
	soap_default_string(soap, &a->faultstring);
	soap_default_string(soap, &a->faultactor);
	a->detail = NULL;
	a->SOAP_ENV__Code = NULL;
	a->SOAP_ENV__Reason = NULL;
	soap_default_string(soap, &a->SOAP_ENV__Node);
	soap_default_string(soap, &a->SOAP_ENV__Role);
	a->SOAP_ENV__Detail = NULL;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_serialize_SOAP_ENV__Fault(struct soap *soap, const struct SOAP_ENV__Fault *a)
{
	(void)soap; (void)a; /* appease -Wall -Werror */
	soap_serialize__QName(soap, &a->faultcode);
	soap_serialize_string(soap, &a->faultstring);
	soap_serialize_string(soap, &a->faultactor);
	soap_serialize_PointerToSOAP_ENV__Detail(soap, &a->detail);
	soap_serialize_PointerToSOAP_ENV__Code(soap, &a->SOAP_ENV__Code);
	soap_serialize_PointerToSOAP_ENV__Reason(soap, &a->SOAP_ENV__Reason);
	soap_serialize_string(soap, &a->SOAP_ENV__Node);
	soap_serialize_string(soap, &a->SOAP_ENV__Role);
	soap_serialize_PointerToSOAP_ENV__Detail(soap, &a->SOAP_ENV__Detail);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_put_SOAP_ENV__Fault(struct soap *soap, const struct SOAP_ENV__Fault *a, const char *tag, const char *type)
{
	register int id = soap_embed(soap, (void*)a, NULL, 0, tag, SOAP_TYPE_SOAP_ENV__Fault);
	if (soap_out_SOAP_ENV__Fault(soap, tag, id, a, type))
		return soap->error;
	return soap_putindependent(soap);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out_SOAP_ENV__Fault(struct soap *soap, const char *tag, int id, const struct SOAP_ENV__Fault *a, const char *type)
{
	const char *soap_tmp_faultcode = soap_QName2s(soap, a->faultcode);
	if (soap_element_begin_out(soap, tag, soap_embedded_id(soap, id, a, SOAP_TYPE_SOAP_ENV__Fault), type))
		return soap->error;
	if (soap_out__QName(soap, "faultcode", -1, (char*const*)&soap_tmp_faultcode, ""))
		return soap->error;
	if (soap_out_string(soap, "faultstring", -1, &a->faultstring, ""))
		return soap->error;
	if (soap_out_string(soap, "faultactor", -1, &a->faultactor, ""))
		return soap->error;
	if (soap_out_PointerToSOAP_ENV__Detail(soap, "detail", -1, &a->detail, ""))
		return soap->error;
	if (soap_out_PointerToSOAP_ENV__Code(soap, "SOAP-ENV:Code", -1, &a->SOAP_ENV__Code, ""))
		return soap->error;
	if (soap_out_PointerToSOAP_ENV__Reason(soap, "SOAP-ENV:Reason", -1, &a->SOAP_ENV__Reason, ""))
		return soap->error;
	if (soap_out_string(soap, "SOAP-ENV:Node", -1, &a->SOAP_ENV__Node, ""))
		return soap->error;
	if (soap_out_string(soap, "SOAP-ENV:Role", -1, &a->SOAP_ENV__Role, ""))
		return soap->error;
	if (soap_out_PointerToSOAP_ENV__Detail(soap, "SOAP-ENV:Detail", -1, &a->SOAP_ENV__Detail, ""))
		return soap->error;
	return soap_element_end_out(soap, tag);
}

SOAP_FMAC3 struct SOAP_ENV__Fault * SOAP_FMAC4 soap_get_SOAP_ENV__Fault(struct soap *soap, struct SOAP_ENV__Fault *p, const char *tag, const char *type)
{
	if ((p = soap_in_SOAP_ENV__Fault(soap, tag, p, type)))
		if (soap_getindependent(soap))
			return NULL;
	return p;
}

SOAP_FMAC3 struct SOAP_ENV__Fault * SOAP_FMAC4 soap_in_SOAP_ENV__Fault(struct soap *soap, const char *tag, struct SOAP_ENV__Fault *a, const char *type)
{
	short soap_flag_faultcode = 1, soap_flag_faultstring = 1, soap_flag_faultactor = 1, soap_flag_detail = 1, soap_flag_SOAP_ENV__Code = 1, soap_flag_SOAP_ENV__Reason = 1, soap_flag_SOAP_ENV__Node = 1, soap_flag_SOAP_ENV__Role = 1, soap_flag_SOAP_ENV__Detail = 1;
	if (soap_element_begin_in(soap, tag, 0, type))
		return NULL;
	a = (struct SOAP_ENV__Fault *)soap_id_enter(soap, soap->id, a, SOAP_TYPE_SOAP_ENV__Fault, sizeof(struct SOAP_ENV__Fault), 0, NULL, NULL, NULL);
	if (!a)
		return NULL;
	soap_default_SOAP_ENV__Fault(soap, a);
	if (soap->body && !*soap->href)
	{
		for (;;)
		{	soap->error = SOAP_TAG_MISMATCH;
			if (soap_flag_faultcode && (soap->error == SOAP_TAG_MISMATCH || soap->error == SOAP_NO_TAG))
				if (soap_in__QName(soap, "faultcode", &a->faultcode, ""))
				{	soap_flag_faultcode--;
					continue;
				}
			if (soap_flag_faultstring && (soap->error == SOAP_TAG_MISMATCH || soap->error == SOAP_NO_TAG))
				if (soap_in_string(soap, "faultstring", &a->faultstring, "xsd:string"))
				{	soap_flag_faultstring--;
					continue;
				}
			if (soap_flag_faultactor && (soap->error == SOAP_TAG_MISMATCH || soap->error == SOAP_NO_TAG))
				if (soap_in_string(soap, "faultactor", &a->faultactor, "xsd:string"))
				{	soap_flag_faultactor--;
					continue;
				}
			if (soap_flag_detail && soap->error == SOAP_TAG_MISMATCH)
				if (soap_in_PointerToSOAP_ENV__Detail(soap, "detail", &a->detail, ""))
				{	soap_flag_detail--;
					continue;
				}
			if (soap_flag_SOAP_ENV__Code && soap->error == SOAP_TAG_MISMATCH)
				if (soap_in_PointerToSOAP_ENV__Code(soap, "SOAP-ENV:Code", &a->SOAP_ENV__Code, ""))
				{	soap_flag_SOAP_ENV__Code--;
					continue;
				}
			if (soap_flag_SOAP_ENV__Reason && soap->error == SOAP_TAG_MISMATCH)
				if (soap_in_PointerToSOAP_ENV__Reason(soap, "SOAP-ENV:Reason", &a->SOAP_ENV__Reason, ""))
				{	soap_flag_SOAP_ENV__Reason--;
					continue;
				}
			if (soap_flag_SOAP_ENV__Node && (soap->error == SOAP_TAG_MISMATCH || soap->error == SOAP_NO_TAG))
				if (soap_in_string(soap, "SOAP-ENV:Node", &a->SOAP_ENV__Node, "xsd:string"))
				{	soap_flag_SOAP_ENV__Node--;
					continue;
				}
			if (soap_flag_SOAP_ENV__Role && (soap->error == SOAP_TAG_MISMATCH || soap->error == SOAP_NO_TAG))
				if (soap_in_string(soap, "SOAP-ENV:Role", &a->SOAP_ENV__Role, "xsd:string"))
				{	soap_flag_SOAP_ENV__Role--;
					continue;
				}
			if (soap_flag_SOAP_ENV__Detail && soap->error == SOAP_TAG_MISMATCH)
				if (soap_in_PointerToSOAP_ENV__Detail(soap, "SOAP-ENV:Detail", &a->SOAP_ENV__Detail, ""))
				{	soap_flag_SOAP_ENV__Detail--;
					continue;
				}
			if (soap->error == SOAP_TAG_MISMATCH)
				soap->error = soap_ignore_element(soap);
			if (soap->error == SOAP_NO_TAG)
				break;
			if (soap->error)
				return NULL;
		}
		if (soap_element_end_in(soap, tag))
			return NULL;
	}
	else
	{	a = (struct SOAP_ENV__Fault *)soap_id_forward(soap, soap->href, (void*)a, 0, SOAP_TYPE_SOAP_ENV__Fault, 0, sizeof(struct SOAP_ENV__Fault), 0, NULL);
		if (soap->body && soap_element_end_in(soap, tag))
			return NULL;
	}
	return a;
}

SOAP_FMAC5 struct SOAP_ENV__Fault * SOAP_FMAC6 soap_new_SOAP_ENV__Fault(struct soap *soap, int n)
{	return soap_instantiate_SOAP_ENV__Fault(soap, n, NULL, NULL, NULL);
}

SOAP_FMAC5 void SOAP_FMAC6 soap_delete_SOAP_ENV__Fault(struct soap *soap, struct SOAP_ENV__Fault *p)
{	soap_delete(soap, p);
}

SOAP_FMAC3 struct SOAP_ENV__Fault * SOAP_FMAC4 soap_instantiate_SOAP_ENV__Fault(struct soap *soap, int n, const char *type, const char *arrayType, size_t *size)
{
	DBGLOG(TEST, SOAP_MESSAGE(fdebug, "soap_instantiate_SOAP_ENV__Fault(%d, %s, %s)\n", n, type?type:"", arrayType?arrayType:""));
	struct soap_clist *cp = soap_link(soap, NULL, SOAP_TYPE_SOAP_ENV__Fault, n, soap_fdelete);
	if (!cp)
		return NULL;
	if (n < 0)
	{	cp->ptr = (void*)new struct SOAP_ENV__Fault;
		if (size)
			*size = sizeof(struct SOAP_ENV__Fault);
	}
	else
	{	cp->ptr = (void*)new struct SOAP_ENV__Fault[n];
		if (!cp->ptr)
		{	soap->error = SOAP_EOM;
			return NULL;
		}
		if (size)
			*size = n * sizeof(struct SOAP_ENV__Fault);
	}
		DBGLOG(TEST, SOAP_MESSAGE(fdebug, "Instantiated location=%p\n", cp->ptr));
	return (struct SOAP_ENV__Fault*)cp->ptr;
}
SOAP_FMAC3 void SOAP_FMAC4 soap_copy_SOAP_ENV__Fault(struct soap *soap, int st, int tt, void *p, size_t len, const void *q, size_t n)
{
	DBGLOG(TEST, SOAP_MESSAGE(fdebug, "Copying struct SOAP_ENV__Fault %p -> %p\n", q, p));
	*(struct SOAP_ENV__Fault*)p = *(struct SOAP_ENV__Fault*)q;
}

#endif

#ifndef WITH_NOGLOBAL

SOAP_FMAC3 void SOAP_FMAC4 soap_default_SOAP_ENV__Reason(struct soap *soap, struct SOAP_ENV__Reason *a)
{
	(void)soap; (void)a; /* appease -Wall -Werror */
	soap_default_string(soap, &a->SOAP_ENV__Text);
}

SOAP_FMAC3 void SOAP_FMAC4 soap_serialize_SOAP_ENV__Reason(struct soap *soap, const struct SOAP_ENV__Reason *a)
{
	(void)soap; (void)a; /* appease -Wall -Werror */
	soap_serialize_string(soap, &a->SOAP_ENV__Text);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_put_SOAP_ENV__Reason(struct soap *soap, const struct SOAP_ENV__Reason *a, const char *tag, const char *type)
{
	register int id = soap_embed(soap, (void*)a, NULL, 0, tag, SOAP_TYPE_SOAP_ENV__Reason);
	if (soap_out_SOAP_ENV__Reason(soap, tag, id, a, type))
		return soap->error;
	return soap_putindependent(soap);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out_SOAP_ENV__Reason(struct soap *soap, const char *tag, int id, const struct SOAP_ENV__Reason *a, const char *type)
{
	if (soap_element_begin_out(soap, tag, soap_embedded_id(soap, id, a, SOAP_TYPE_SOAP_ENV__Reason), type))
		return soap->error;
	if (soap_out_string(soap, "SOAP-ENV:Text", -1, &a->SOAP_ENV__Text, ""))
		return soap->error;
	return soap_element_end_out(soap, tag);
}

SOAP_FMAC3 struct SOAP_ENV__Reason * SOAP_FMAC4 soap_get_SOAP_ENV__Reason(struct soap *soap, struct SOAP_ENV__Reason *p, const char *tag, const char *type)
{
	if ((p = soap_in_SOAP_ENV__Reason(soap, tag, p, type)))
		if (soap_getindependent(soap))
			return NULL;
	return p;
}

SOAP_FMAC3 struct SOAP_ENV__Reason * SOAP_FMAC4 soap_in_SOAP_ENV__Reason(struct soap *soap, const char *tag, struct SOAP_ENV__Reason *a, const char *type)
{
	short soap_flag_SOAP_ENV__Text = 1;
	if (soap_element_begin_in(soap, tag, 0, type))
		return NULL;
	a = (struct SOAP_ENV__Reason *)soap_id_enter(soap, soap->id, a, SOAP_TYPE_SOAP_ENV__Reason, sizeof(struct SOAP_ENV__Reason), 0, NULL, NULL, NULL);
	if (!a)
		return NULL;
	soap_default_SOAP_ENV__Reason(soap, a);
	if (soap->body && !*soap->href)
	{
		for (;;)
		{	soap->error = SOAP_TAG_MISMATCH;
			if (soap_flag_SOAP_ENV__Text && (soap->error == SOAP_TAG_MISMATCH || soap->error == SOAP_NO_TAG))
				if (soap_in_string(soap, "SOAP-ENV:Text", &a->SOAP_ENV__Text, "xsd:string"))
				{	soap_flag_SOAP_ENV__Text--;
					continue;
				}
			if (soap->error == SOAP_TAG_MISMATCH)
				soap->error = soap_ignore_element(soap);
			if (soap->error == SOAP_NO_TAG)
				break;
			if (soap->error)
				return NULL;
		}
		if (soap_element_end_in(soap, tag))
			return NULL;
	}
	else
	{	a = (struct SOAP_ENV__Reason *)soap_id_forward(soap, soap->href, (void*)a, 0, SOAP_TYPE_SOAP_ENV__Reason, 0, sizeof(struct SOAP_ENV__Reason), 0, NULL);
		if (soap->body && soap_element_end_in(soap, tag))
			return NULL;
	}
	return a;
}

SOAP_FMAC5 struct SOAP_ENV__Reason * SOAP_FMAC6 soap_new_SOAP_ENV__Reason(struct soap *soap, int n)
{	return soap_instantiate_SOAP_ENV__Reason(soap, n, NULL, NULL, NULL);
}

SOAP_FMAC5 void SOAP_FMAC6 soap_delete_SOAP_ENV__Reason(struct soap *soap, struct SOAP_ENV__Reason *p)
{	soap_delete(soap, p);
}

SOAP_FMAC3 struct SOAP_ENV__Reason * SOAP_FMAC4 soap_instantiate_SOAP_ENV__Reason(struct soap *soap, int n, const char *type, const char *arrayType, size_t *size)
{
	DBGLOG(TEST, SOAP_MESSAGE(fdebug, "soap_instantiate_SOAP_ENV__Reason(%d, %s, %s)\n", n, type?type:"", arrayType?arrayType:""));
	struct soap_clist *cp = soap_link(soap, NULL, SOAP_TYPE_SOAP_ENV__Reason, n, soap_fdelete);
	if (!cp)
		return NULL;
	if (n < 0)
	{	cp->ptr = (void*)new struct SOAP_ENV__Reason;
		if (size)
			*size = sizeof(struct SOAP_ENV__Reason);
	}
	else
	{	cp->ptr = (void*)new struct SOAP_ENV__Reason[n];
		if (!cp->ptr)
		{	soap->error = SOAP_EOM;
			return NULL;
		}
		if (size)
			*size = n * sizeof(struct SOAP_ENV__Reason);
	}
		DBGLOG(TEST, SOAP_MESSAGE(fdebug, "Instantiated location=%p\n", cp->ptr));
	return (struct SOAP_ENV__Reason*)cp->ptr;
}
SOAP_FMAC3 void SOAP_FMAC4 soap_copy_SOAP_ENV__Reason(struct soap *soap, int st, int tt, void *p, size_t len, const void *q, size_t n)
{
	DBGLOG(TEST, SOAP_MESSAGE(fdebug, "Copying struct SOAP_ENV__Reason %p -> %p\n", q, p));
	*(struct SOAP_ENV__Reason*)p = *(struct SOAP_ENV__Reason*)q;
}

#endif

#ifndef WITH_NOGLOBAL

SOAP_FMAC3 void SOAP_FMAC4 soap_default_SOAP_ENV__Detail(struct soap *soap, struct SOAP_ENV__Detail *a)
{
	(void)soap; (void)a; /* appease -Wall -Werror */
	a->__type = 0;
	a->fault = NULL;
	a->__any = NULL;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_serialize_SOAP_ENV__Detail(struct soap *soap, const struct SOAP_ENV__Detail *a)
{
	(void)soap; (void)a; /* appease -Wall -Werror */
	soap_markelement(soap, a->fault, a->__type);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_put_SOAP_ENV__Detail(struct soap *soap, const struct SOAP_ENV__Detail *a, const char *tag, const char *type)
{
	register int id = soap_embed(soap, (void*)a, NULL, 0, tag, SOAP_TYPE_SOAP_ENV__Detail);
	if (soap_out_SOAP_ENV__Detail(soap, tag, id, a, type))
		return soap->error;
	return soap_putindependent(soap);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out_SOAP_ENV__Detail(struct soap *soap, const char *tag, int id, const struct SOAP_ENV__Detail *a, const char *type)
{
	if (soap_element_begin_out(soap, tag, soap_embedded_id(soap, id, a, SOAP_TYPE_SOAP_ENV__Detail), type))
		return soap->error;
	if (soap_putelement(soap, a->fault, "fault", -1, a->__type))
		return soap->error;
	soap_outliteral(soap, "-any", &a->__any, NULL);
	return soap_element_end_out(soap, tag);
}

SOAP_FMAC3 struct SOAP_ENV__Detail * SOAP_FMAC4 soap_get_SOAP_ENV__Detail(struct soap *soap, struct SOAP_ENV__Detail *p, const char *tag, const char *type)
{
	if ((p = soap_in_SOAP_ENV__Detail(soap, tag, p, type)))
		if (soap_getindependent(soap))
			return NULL;
	return p;
}

SOAP_FMAC3 struct SOAP_ENV__Detail * SOAP_FMAC4 soap_in_SOAP_ENV__Detail(struct soap *soap, const char *tag, struct SOAP_ENV__Detail *a, const char *type)
{
	short soap_flag_fault = 1, soap_flag___any = 1;
	if (soap_element_begin_in(soap, tag, 0, type))
		return NULL;
	a = (struct SOAP_ENV__Detail *)soap_id_enter(soap, soap->id, a, SOAP_TYPE_SOAP_ENV__Detail, sizeof(struct SOAP_ENV__Detail), 0, NULL, NULL, NULL);
	if (!a)
		return NULL;
	soap_default_SOAP_ENV__Detail(soap, a);
	if (soap->body && !*soap->href)
	{
		for (;;)
		{	soap->error = SOAP_TAG_MISMATCH;
			if (soap_flag_fault && soap->error == SOAP_TAG_MISMATCH)
				if ((a->fault = soap_getelement(soap, &a->__type)))
				{	soap_flag_fault = 0;
					continue;
				}
			if (soap_flag___any && (soap->error == SOAP_TAG_MISMATCH || soap->error == SOAP_NO_TAG))
				if (soap_inliteral(soap, "-any", &a->__any))
				{	soap_flag___any--;
					continue;
				}
			if (soap->error == SOAP_TAG_MISMATCH)
				soap->error = soap_ignore_element(soap);
			if (soap->error == SOAP_NO_TAG)
				break;
			if (soap->error)
				return NULL;
		}
		if (soap_element_end_in(soap, tag))
			return NULL;
	}
	else
	{	a = (struct SOAP_ENV__Detail *)soap_id_forward(soap, soap->href, (void*)a, 0, SOAP_TYPE_SOAP_ENV__Detail, 0, sizeof(struct SOAP_ENV__Detail), 0, NULL);
		if (soap->body && soap_element_end_in(soap, tag))
			return NULL;
	}
	return a;
}

SOAP_FMAC5 struct SOAP_ENV__Detail * SOAP_FMAC6 soap_new_SOAP_ENV__Detail(struct soap *soap, int n)
{	return soap_instantiate_SOAP_ENV__Detail(soap, n, NULL, NULL, NULL);
}

SOAP_FMAC5 void SOAP_FMAC6 soap_delete_SOAP_ENV__Detail(struct soap *soap, struct SOAP_ENV__Detail *p)
{	soap_delete(soap, p);
}

SOAP_FMAC3 struct SOAP_ENV__Detail * SOAP_FMAC4 soap_instantiate_SOAP_ENV__Detail(struct soap *soap, int n, const char *type, const char *arrayType, size_t *size)
{
	DBGLOG(TEST, SOAP_MESSAGE(fdebug, "soap_instantiate_SOAP_ENV__Detail(%d, %s, %s)\n", n, type?type:"", arrayType?arrayType:""));
	struct soap_clist *cp = soap_link(soap, NULL, SOAP_TYPE_SOAP_ENV__Detail, n, soap_fdelete);
	if (!cp)
		return NULL;
	if (n < 0)
	{	cp->ptr = (void*)new struct SOAP_ENV__Detail;
		if (size)
			*size = sizeof(struct SOAP_ENV__Detail);
	}
	else
	{	cp->ptr = (void*)new struct SOAP_ENV__Detail[n];
		if (!cp->ptr)
		{	soap->error = SOAP_EOM;
			return NULL;
		}
		if (size)
			*size = n * sizeof(struct SOAP_ENV__Detail);
	}
		DBGLOG(TEST, SOAP_MESSAGE(fdebug, "Instantiated location=%p\n", cp->ptr));
	return (struct SOAP_ENV__Detail*)cp->ptr;
}
SOAP_FMAC3 void SOAP_FMAC4 soap_copy_SOAP_ENV__Detail(struct soap *soap, int st, int tt, void *p, size_t len, const void *q, size_t n)
{
	DBGLOG(TEST, SOAP_MESSAGE(fdebug, "Copying struct SOAP_ENV__Detail %p -> %p\n", q, p));
	*(struct SOAP_ENV__Detail*)p = *(struct SOAP_ENV__Detail*)q;
}

#endif

#ifndef WITH_NOGLOBAL

SOAP_FMAC3 void SOAP_FMAC4 soap_default_SOAP_ENV__Code(struct soap *soap, struct SOAP_ENV__Code *a)
{
	(void)soap; (void)a; /* appease -Wall -Werror */
	soap_default__QName(soap, &a->SOAP_ENV__Value);
	a->SOAP_ENV__Subcode = NULL;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_serialize_SOAP_ENV__Code(struct soap *soap, const struct SOAP_ENV__Code *a)
{
	(void)soap; (void)a; /* appease -Wall -Werror */
	soap_serialize__QName(soap, &a->SOAP_ENV__Value);
	soap_serialize_PointerToSOAP_ENV__Code(soap, &a->SOAP_ENV__Subcode);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_put_SOAP_ENV__Code(struct soap *soap, const struct SOAP_ENV__Code *a, const char *tag, const char *type)
{
	register int id = soap_embed(soap, (void*)a, NULL, 0, tag, SOAP_TYPE_SOAP_ENV__Code);
	if (soap_out_SOAP_ENV__Code(soap, tag, id, a, type))
		return soap->error;
	return soap_putindependent(soap);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out_SOAP_ENV__Code(struct soap *soap, const char *tag, int id, const struct SOAP_ENV__Code *a, const char *type)
{
	const char *soap_tmp_SOAP_ENV__Value = soap_QName2s(soap, a->SOAP_ENV__Value);
	if (soap_element_begin_out(soap, tag, soap_embedded_id(soap, id, a, SOAP_TYPE_SOAP_ENV__Code), type))
		return soap->error;
	if (soap_out__QName(soap, "SOAP-ENV:Value", -1, (char*const*)&soap_tmp_SOAP_ENV__Value, ""))
		return soap->error;
	if (soap_out_PointerToSOAP_ENV__Code(soap, "SOAP-ENV:Subcode", -1, &a->SOAP_ENV__Subcode, ""))
		return soap->error;
	return soap_element_end_out(soap, tag);
}

SOAP_FMAC3 struct SOAP_ENV__Code * SOAP_FMAC4 soap_get_SOAP_ENV__Code(struct soap *soap, struct SOAP_ENV__Code *p, const char *tag, const char *type)
{
	if ((p = soap_in_SOAP_ENV__Code(soap, tag, p, type)))
		if (soap_getindependent(soap))
			return NULL;
	return p;
}

SOAP_FMAC3 struct SOAP_ENV__Code * SOAP_FMAC4 soap_in_SOAP_ENV__Code(struct soap *soap, const char *tag, struct SOAP_ENV__Code *a, const char *type)
{
	short soap_flag_SOAP_ENV__Value = 1, soap_flag_SOAP_ENV__Subcode = 1;
	if (soap_element_begin_in(soap, tag, 0, type))
		return NULL;
	a = (struct SOAP_ENV__Code *)soap_id_enter(soap, soap->id, a, SOAP_TYPE_SOAP_ENV__Code, sizeof(struct SOAP_ENV__Code), 0, NULL, NULL, NULL);
	if (!a)
		return NULL;
	soap_default_SOAP_ENV__Code(soap, a);
	if (soap->body && !*soap->href)
	{
		for (;;)
		{	soap->error = SOAP_TAG_MISMATCH;
			if (soap_flag_SOAP_ENV__Value && (soap->error == SOAP_TAG_MISMATCH || soap->error == SOAP_NO_TAG))
				if (soap_in__QName(soap, "SOAP-ENV:Value", &a->SOAP_ENV__Value, ""))
				{	soap_flag_SOAP_ENV__Value--;
					continue;
				}
			if (soap_flag_SOAP_ENV__Subcode && soap->error == SOAP_TAG_MISMATCH)
				if (soap_in_PointerToSOAP_ENV__Code(soap, "SOAP-ENV:Subcode", &a->SOAP_ENV__Subcode, ""))
				{	soap_flag_SOAP_ENV__Subcode--;
					continue;
				}
			if (soap->error == SOAP_TAG_MISMATCH)
				soap->error = soap_ignore_element(soap);
			if (soap->error == SOAP_NO_TAG)
				break;
			if (soap->error)
				return NULL;
		}
		if (soap_element_end_in(soap, tag))
			return NULL;
	}
	else
	{	a = (struct SOAP_ENV__Code *)soap_id_forward(soap, soap->href, (void*)a, 0, SOAP_TYPE_SOAP_ENV__Code, 0, sizeof(struct SOAP_ENV__Code), 0, NULL);
		if (soap->body && soap_element_end_in(soap, tag))
			return NULL;
	}
	return a;
}

SOAP_FMAC5 struct SOAP_ENV__Code * SOAP_FMAC6 soap_new_SOAP_ENV__Code(struct soap *soap, int n)
{	return soap_instantiate_SOAP_ENV__Code(soap, n, NULL, NULL, NULL);
}

SOAP_FMAC5 void SOAP_FMAC6 soap_delete_SOAP_ENV__Code(struct soap *soap, struct SOAP_ENV__Code *p)
{	soap_delete(soap, p);
}

SOAP_FMAC3 struct SOAP_ENV__Code * SOAP_FMAC4 soap_instantiate_SOAP_ENV__Code(struct soap *soap, int n, const char *type, const char *arrayType, size_t *size)
{
	DBGLOG(TEST, SOAP_MESSAGE(fdebug, "soap_instantiate_SOAP_ENV__Code(%d, %s, %s)\n", n, type?type:"", arrayType?arrayType:""));
	struct soap_clist *cp = soap_link(soap, NULL, SOAP_TYPE_SOAP_ENV__Code, n, soap_fdelete);
	if (!cp)
		return NULL;
	if (n < 0)
	{	cp->ptr = (void*)new struct SOAP_ENV__Code;
		if (size)
			*size = sizeof(struct SOAP_ENV__Code);
	}
	else
	{	cp->ptr = (void*)new struct SOAP_ENV__Code[n];
		if (!cp->ptr)
		{	soap->error = SOAP_EOM;
			return NULL;
		}
		if (size)
			*size = n * sizeof(struct SOAP_ENV__Code);
	}
		DBGLOG(TEST, SOAP_MESSAGE(fdebug, "Instantiated location=%p\n", cp->ptr));
	return (struct SOAP_ENV__Code*)cp->ptr;
}
SOAP_FMAC3 void SOAP_FMAC4 soap_copy_SOAP_ENV__Code(struct soap *soap, int st, int tt, void *p, size_t len, const void *q, size_t n)
{
	DBGLOG(TEST, SOAP_MESSAGE(fdebug, "Copying struct SOAP_ENV__Code %p -> %p\n", q, p));
	*(struct SOAP_ENV__Code*)p = *(struct SOAP_ENV__Code*)q;
}

#endif

SOAP_FMAC3 void SOAP_FMAC4 soap_default_m__echoVoid(struct soap *soap, struct m__echoVoid *a)
{
	(void)soap; (void)a; /* appease -Wall -Werror */
}

SOAP_FMAC3 void SOAP_FMAC4 soap_serialize_m__echoVoid(struct soap *soap, const struct m__echoVoid *a)
{
	(void)soap; (void)a; /* appease -Wall -Werror */
}

SOAP_FMAC3 int SOAP_FMAC4 soap_put_m__echoVoid(struct soap *soap, const struct m__echoVoid *a, const char *tag, const char *type)
{
	register int id = soap_embed(soap, (void*)a, NULL, 0, tag, SOAP_TYPE_m__echoVoid);
	if (soap_out_m__echoVoid(soap, tag, id, a, type))
		return soap->error;
	return soap_putindependent(soap);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out_m__echoVoid(struct soap *soap, const char *tag, int id, const struct m__echoVoid *a, const char *type)
{
	if (soap_element_begin_out(soap, tag, soap_embedded_id(soap, id, a, SOAP_TYPE_m__echoVoid), type))
		return soap->error;
	return soap_element_end_out(soap, tag);
}

SOAP_FMAC3 struct m__echoVoid * SOAP_FMAC4 soap_get_m__echoVoid(struct soap *soap, struct m__echoVoid *p, const char *tag, const char *type)
{
	if ((p = soap_in_m__echoVoid(soap, tag, p, type)))
		if (soap_getindependent(soap))
			return NULL;
	return p;
}

SOAP_FMAC3 struct m__echoVoid * SOAP_FMAC4 soap_in_m__echoVoid(struct soap *soap, const char *tag, struct m__echoVoid *a, const char *type)
{
	if (soap_element_begin_in(soap, tag, 0, type))
		return NULL;
	a = (struct m__echoVoid *)soap_id_enter(soap, soap->id, a, SOAP_TYPE_m__echoVoid, sizeof(struct m__echoVoid), 0, NULL, NULL, NULL);
	if (!a)
		return NULL;
	soap_default_m__echoVoid(soap, a);
	if (soap->body && !*soap->href)
	{
		for (;;)
		{	soap->error = SOAP_TAG_MISMATCH;
			if (soap->error == SOAP_TAG_MISMATCH)
				soap->error = soap_ignore_element(soap);
			if (soap->error == SOAP_NO_TAG)
				break;
			if (soap->error)
				return NULL;
		}
		if (soap_element_end_in(soap, tag))
			return NULL;
	}
	else
	{	a = (struct m__echoVoid *)soap_id_forward(soap, soap->href, (void*)a, 0, SOAP_TYPE_m__echoVoid, 0, sizeof(struct m__echoVoid), 0, NULL);
		if (soap->body && soap_element_end_in(soap, tag))
			return NULL;
	}
	return a;
}

SOAP_FMAC5 struct m__echoVoid * SOAP_FMAC6 soap_new_m__echoVoid(struct soap *soap, int n)
{	return soap_instantiate_m__echoVoid(soap, n, NULL, NULL, NULL);
}

SOAP_FMAC5 void SOAP_FMAC6 soap_delete_m__echoVoid(struct soap *soap, struct m__echoVoid *p)
{	soap_delete(soap, p);
}

SOAP_FMAC3 struct m__echoVoid * SOAP_FMAC4 soap_instantiate_m__echoVoid(struct soap *soap, int n, const char *type, const char *arrayType, size_t *size)
{
	DBGLOG(TEST, SOAP_MESSAGE(fdebug, "soap_instantiate_m__echoVoid(%d, %s, %s)\n", n, type?type:"", arrayType?arrayType:""));
	struct soap_clist *cp = soap_link(soap, NULL, SOAP_TYPE_m__echoVoid, n, soap_fdelete);
	if (!cp)
		return NULL;
	if (n < 0)
	{	cp->ptr = (void*)new struct m__echoVoid;
		if (size)
			*size = sizeof(struct m__echoVoid);
	}
	else
	{	cp->ptr = (void*)new struct m__echoVoid[n];
		if (!cp->ptr)
		{	soap->error = SOAP_EOM;
			return NULL;
		}
		if (size)
			*size = n * sizeof(struct m__echoVoid);
	}
		DBGLOG(TEST, SOAP_MESSAGE(fdebug, "Instantiated location=%p\n", cp->ptr));
	return (struct m__echoVoid*)cp->ptr;
}
SOAP_FMAC3 void SOAP_FMAC4 soap_copy_m__echoVoid(struct soap *soap, int st, int tt, void *p, size_t len, const void *q, size_t n)
{
	DBGLOG(TEST, SOAP_MESSAGE(fdebug, "Copying struct m__echoVoid %p -> %p\n", q, p));
	*(struct m__echoVoid*)p = *(struct m__echoVoid*)q;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_default_m__echoVoidResponse(struct soap *soap, struct m__echoVoidResponse *a)
{
	(void)soap; (void)a; /* appease -Wall -Werror */
}

SOAP_FMAC3 void SOAP_FMAC4 soap_serialize_m__echoVoidResponse(struct soap *soap, const struct m__echoVoidResponse *a)
{
	(void)soap; (void)a; /* appease -Wall -Werror */
}

SOAP_FMAC3 int SOAP_FMAC4 soap_put_m__echoVoidResponse(struct soap *soap, const struct m__echoVoidResponse *a, const char *tag, const char *type)
{
	register int id = soap_embed(soap, (void*)a, NULL, 0, tag, SOAP_TYPE_m__echoVoidResponse);
	if (soap_out_m__echoVoidResponse(soap, tag, id, a, type))
		return soap->error;
	return soap_putindependent(soap);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out_m__echoVoidResponse(struct soap *soap, const char *tag, int id, const struct m__echoVoidResponse *a, const char *type)
{
	if (soap_element_begin_out(soap, tag, soap_embedded_id(soap, id, a, SOAP_TYPE_m__echoVoidResponse), type))
		return soap->error;
	return soap_element_end_out(soap, tag);
}

SOAP_FMAC3 struct m__echoVoidResponse * SOAP_FMAC4 soap_get_m__echoVoidResponse(struct soap *soap, struct m__echoVoidResponse *p, const char *tag, const char *type)
{
	if ((p = soap_in_m__echoVoidResponse(soap, tag, p, type)))
		if (soap_getindependent(soap))
			return NULL;
	return p;
}

SOAP_FMAC3 struct m__echoVoidResponse * SOAP_FMAC4 soap_in_m__echoVoidResponse(struct soap *soap, const char *tag, struct m__echoVoidResponse *a, const char *type)
{
	if (soap_element_begin_in(soap, tag, 0, type))
		return NULL;
	a = (struct m__echoVoidResponse *)soap_id_enter(soap, soap->id, a, SOAP_TYPE_m__echoVoidResponse, sizeof(struct m__echoVoidResponse), 0, NULL, NULL, NULL);
	if (!a)
		return NULL;
	soap_default_m__echoVoidResponse(soap, a);
	if (soap->body && !*soap->href)
	{
		for (;;)
		{	soap->error = SOAP_TAG_MISMATCH;
			if (soap->error == SOAP_TAG_MISMATCH)
				soap->error = soap_ignore_element(soap);
			if (soap->error == SOAP_NO_TAG)
				break;
			if (soap->error)
				return NULL;
		}
		if (soap_element_end_in(soap, tag))
			return NULL;
	}
	else
	{	a = (struct m__echoVoidResponse *)soap_id_forward(soap, soap->href, (void*)a, 0, SOAP_TYPE_m__echoVoidResponse, 0, sizeof(struct m__echoVoidResponse), 0, NULL);
		if (soap->body && soap_element_end_in(soap, tag))
			return NULL;
	}
	return a;
}

SOAP_FMAC5 struct m__echoVoidResponse * SOAP_FMAC6 soap_new_m__echoVoidResponse(struct soap *soap, int n)
{	return soap_instantiate_m__echoVoidResponse(soap, n, NULL, NULL, NULL);
}

SOAP_FMAC5 void SOAP_FMAC6 soap_delete_m__echoVoidResponse(struct soap *soap, struct m__echoVoidResponse *p)
{	soap_delete(soap, p);
}

SOAP_FMAC3 struct m__echoVoidResponse * SOAP_FMAC4 soap_instantiate_m__echoVoidResponse(struct soap *soap, int n, const char *type, const char *arrayType, size_t *size)
{
	DBGLOG(TEST, SOAP_MESSAGE(fdebug, "soap_instantiate_m__echoVoidResponse(%d, %s, %s)\n", n, type?type:"", arrayType?arrayType:""));
	struct soap_clist *cp = soap_link(soap, NULL, SOAP_TYPE_m__echoVoidResponse, n, soap_fdelete);
	if (!cp)
		return NULL;
	if (n < 0)
	{	cp->ptr = (void*)new struct m__echoVoidResponse;
		if (size)
			*size = sizeof(struct m__echoVoidResponse);
	}
	else
	{	cp->ptr = (void*)new struct m__echoVoidResponse[n];
		if (!cp->ptr)
		{	soap->error = SOAP_EOM;
			return NULL;
		}
		if (size)
			*size = n * sizeof(struct m__echoVoidResponse);
	}
		DBGLOG(TEST, SOAP_MESSAGE(fdebug, "Instantiated location=%p\n", cp->ptr));
	return (struct m__echoVoidResponse*)cp->ptr;
}
SOAP_FMAC3 void SOAP_FMAC4 soap_copy_m__echoVoidResponse(struct soap *soap, int st, int tt, void *p, size_t len, const void *q, size_t n)
{
	DBGLOG(TEST, SOAP_MESSAGE(fdebug, "Copying struct m__echoVoidResponse %p -> %p\n", q, p));
	*(struct m__echoVoidResponse*)p = *(struct m__echoVoidResponse*)q;
}

#ifndef WITH_NOGLOBAL

SOAP_FMAC3 void SOAP_FMAC4 soap_default_SOAP_ENV__Header(struct soap *soap, struct SOAP_ENV__Header *a)
{
	(void)soap; (void)a; /* appease -Wall -Werror */
	soap_default_string(soap, &a->h__echoMeStringRequest);
	soap_default_string(soap, &a->h__echoMeStringRequest_);
	soap_default_string(soap, &a->h__echoMeStringResponse);
	a->h__echoMeStructRequest = NULL;
	a->h__echoMeStructRequest_ = NULL;
	a->h__echoMeStructResponse = NULL;
	soap_default_string(soap, &a->h__someUnknownRequest);
	soap_default_string(soap, &a->h__someUnknownRequest_);
}

SOAP_FMAC3 void SOAP_FMAC4 soap_serialize_SOAP_ENV__Header(struct soap *soap, const struct SOAP_ENV__Header *a)
{
	(void)soap; (void)a; /* appease -Wall -Werror */
	soap_serialize_string(soap, &a->h__echoMeStringRequest);
	soap_serialize_string(soap, &a->h__echoMeStringRequest_);
	soap_serialize_string(soap, &a->h__echoMeStringResponse);
	soap_serialize_PointerTos__SOAPStruct(soap, &a->h__echoMeStructRequest);
	soap_serialize_PointerTos__SOAPStruct(soap, &a->h__echoMeStructRequest_);
	soap_serialize_PointerTos__SOAPStruct(soap, &a->h__echoMeStructResponse);
	soap_serialize_string(soap, &a->h__someUnknownRequest);
	soap_serialize_string(soap, &a->h__someUnknownRequest_);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_put_SOAP_ENV__Header(struct soap *soap, const struct SOAP_ENV__Header *a, const char *tag, const char *type)
{
	register int id = soap_embed(soap, (void*)a, NULL, 0, tag, SOAP_TYPE_SOAP_ENV__Header);
	if (soap_out_SOAP_ENV__Header(soap, tag, id, a, type))
		return soap->error;
	return soap_putindependent(soap);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out_SOAP_ENV__Header(struct soap *soap, const char *tag, int id, const struct SOAP_ENV__Header *a, const char *type)
{
	if (soap_element_begin_out(soap, tag, soap_embedded_id(soap, id, a, SOAP_TYPE_SOAP_ENV__Header), type))
		return soap->error;
	if (soap_out_string(soap, "h:echoMeStringRequest", -1, &a->h__echoMeStringRequest, ""))
		return soap->error;
	soap->mustUnderstand = 1;
	if (soap_out_string(soap, "h:echoMeStringRequest", -1, &a->h__echoMeStringRequest_, ""))
		return soap->error;
	if (soap_out_string(soap, "h:echoMeStringResponse", -1, &a->h__echoMeStringResponse, ""))
		return soap->error;
	if (soap_out_PointerTos__SOAPStruct(soap, "h:echoMeStructRequest", -1, &a->h__echoMeStructRequest, ""))
		return soap->error;
	soap->mustUnderstand = 1;
	if (soap_out_PointerTos__SOAPStruct(soap, "h:echoMeStructRequest", -1, &a->h__echoMeStructRequest_, ""))
		return soap->error;
	if (soap_out_PointerTos__SOAPStruct(soap, "h:echoMeStructResponse", -1, &a->h__echoMeStructResponse, ""))
		return soap->error;
	if (soap_out_string(soap, "h:someUnknownRequest", -1, &a->h__someUnknownRequest, ""))
		return soap->error;
	soap->mustUnderstand = 1;
	if (soap_out_string(soap, "h:someUnknownRequest", -1, &a->h__someUnknownRequest_, ""))
		return soap->error;
	return soap_element_end_out(soap, tag);
}

SOAP_FMAC3 struct SOAP_ENV__Header * SOAP_FMAC4 soap_get_SOAP_ENV__Header(struct soap *soap, struct SOAP_ENV__Header *p, const char *tag, const char *type)
{
	if ((p = soap_in_SOAP_ENV__Header(soap, tag, p, type)))
		if (soap_getindependent(soap))
			return NULL;
	return p;
}

SOAP_FMAC3 struct SOAP_ENV__Header * SOAP_FMAC4 soap_in_SOAP_ENV__Header(struct soap *soap, const char *tag, struct SOAP_ENV__Header *a, const char *type)
{
	short soap_flag_h__echoMeStringRequest = 1, soap_flag_h__echoMeStringRequest_ = 1, soap_flag_h__echoMeStringResponse = 1, soap_flag_h__echoMeStructRequest = 1, soap_flag_h__echoMeStructRequest_ = 1, soap_flag_h__echoMeStructResponse = 1, soap_flag_h__someUnknownRequest = 1, soap_flag_h__someUnknownRequest_ = 1;
	if (soap_element_begin_in(soap, tag, 0, type))
		return NULL;
	a = (struct SOAP_ENV__Header *)soap_id_enter(soap, soap->id, a, SOAP_TYPE_SOAP_ENV__Header, sizeof(struct SOAP_ENV__Header), 0, NULL, NULL, NULL);
	if (!a)
		return NULL;
	soap_default_SOAP_ENV__Header(soap, a);
	if (soap->body && !*soap->href)
	{
		for (;;)
		{	soap->error = SOAP_TAG_MISMATCH;
			if (soap_flag_h__echoMeStringRequest && (soap->error == SOAP_TAG_MISMATCH || soap->error == SOAP_NO_TAG))
				if (soap_in_string(soap, "h:echoMeStringRequest", &a->h__echoMeStringRequest, "xsd:string"))
				{	soap_flag_h__echoMeStringRequest--;
					continue;
				}
			if (soap_flag_h__echoMeStringRequest_ && (soap->error == SOAP_TAG_MISMATCH || soap->error == SOAP_NO_TAG))
				if (soap_in_string(soap, "h:echoMeStringRequest", &a->h__echoMeStringRequest_, "xsd:string"))
				{	soap_flag_h__echoMeStringRequest_--;
					continue;
				}
			if (soap_flag_h__echoMeStringResponse && (soap->error == SOAP_TAG_MISMATCH || soap->error == SOAP_NO_TAG))
				if (soap_in_string(soap, "h:echoMeStringResponse", &a->h__echoMeStringResponse, "xsd:string"))
				{	soap_flag_h__echoMeStringResponse--;
					continue;
				}
			if (soap_flag_h__echoMeStructRequest && soap->error == SOAP_TAG_MISMATCH)
				if (soap_in_PointerTos__SOAPStruct(soap, "h:echoMeStructRequest", &a->h__echoMeStructRequest, "s:SOAPStruct"))
				{	soap_flag_h__echoMeStructRequest--;
					continue;
				}
			if (soap_flag_h__echoMeStructRequest_ && soap->error == SOAP_TAG_MISMATCH)
				if (soap_in_PointerTos__SOAPStruct(soap, "h:echoMeStructRequest", &a->h__echoMeStructRequest_, "s:SOAPStruct"))
				{	soap_flag_h__echoMeStructRequest_--;
					continue;
				}
			if (soap_flag_h__echoMeStructResponse && soap->error == SOAP_TAG_MISMATCH)
				if (soap_in_PointerTos__SOAPStruct(soap, "h:echoMeStructResponse", &a->h__echoMeStructResponse, "s:SOAPStruct"))
				{	soap_flag_h__echoMeStructResponse--;
					continue;
				}
			if (soap_flag_h__someUnknownRequest && (soap->error == SOAP_TAG_MISMATCH || soap->error == SOAP_NO_TAG))
				if (soap_in_string(soap, "h:someUnknownRequest", &a->h__someUnknownRequest, "xsd:string"))
				{	soap_flag_h__someUnknownRequest--;
					continue;
				}
			if (soap_flag_h__someUnknownRequest_ && (soap->error == SOAP_TAG_MISMATCH || soap->error == SOAP_NO_TAG))
				if (soap_in_string(soap, "h:someUnknownRequest", &a->h__someUnknownRequest_, "xsd:string"))
				{	soap_flag_h__someUnknownRequest_--;
					continue;
				}
			if (soap->error == SOAP_TAG_MISMATCH)
				soap->error = soap_ignore_element(soap);
			if (soap->error == SOAP_NO_TAG)
				break;
			if (soap->error)
				return NULL;
		}
		if (soap_element_end_in(soap, tag))
			return NULL;
	}
	else
	{	a = (struct SOAP_ENV__Header *)soap_id_forward(soap, soap->href, (void*)a, 0, SOAP_TYPE_SOAP_ENV__Header, 0, sizeof(struct SOAP_ENV__Header), 0, NULL);
		if (soap->body && soap_element_end_in(soap, tag))
			return NULL;
	}
	return a;
}

SOAP_FMAC5 struct SOAP_ENV__Header * SOAP_FMAC6 soap_new_SOAP_ENV__Header(struct soap *soap, int n)
{	return soap_instantiate_SOAP_ENV__Header(soap, n, NULL, NULL, NULL);
}

SOAP_FMAC5 void SOAP_FMAC6 soap_delete_SOAP_ENV__Header(struct soap *soap, struct SOAP_ENV__Header *p)
{	soap_delete(soap, p);
}

SOAP_FMAC3 struct SOAP_ENV__Header * SOAP_FMAC4 soap_instantiate_SOAP_ENV__Header(struct soap *soap, int n, const char *type, const char *arrayType, size_t *size)
{
	DBGLOG(TEST, SOAP_MESSAGE(fdebug, "soap_instantiate_SOAP_ENV__Header(%d, %s, %s)\n", n, type?type:"", arrayType?arrayType:""));
	struct soap_clist *cp = soap_link(soap, NULL, SOAP_TYPE_SOAP_ENV__Header, n, soap_fdelete);
	if (!cp)
		return NULL;
	if (n < 0)
	{	cp->ptr = (void*)new struct SOAP_ENV__Header;
		if (size)
			*size = sizeof(struct SOAP_ENV__Header);
	}
	else
	{	cp->ptr = (void*)new struct SOAP_ENV__Header[n];
		if (!cp->ptr)
		{	soap->error = SOAP_EOM;
			return NULL;
		}
		if (size)
			*size = n * sizeof(struct SOAP_ENV__Header);
	}
		DBGLOG(TEST, SOAP_MESSAGE(fdebug, "Instantiated location=%p\n", cp->ptr));
	return (struct SOAP_ENV__Header*)cp->ptr;
}
SOAP_FMAC3 void SOAP_FMAC4 soap_copy_SOAP_ENV__Header(struct soap *soap, int st, int tt, void *p, size_t len, const void *q, size_t n)
{
	DBGLOG(TEST, SOAP_MESSAGE(fdebug, "Copying struct SOAP_ENV__Header %p -> %p\n", q, p));
	*(struct SOAP_ENV__Header*)p = *(struct SOAP_ENV__Header*)q;
}

#endif

SOAP_FMAC3 void SOAP_FMAC4 soap_default_ns__echoNestedArray(struct soap *soap, struct ns__echoNestedArray *a)
{
	(void)soap; (void)a; /* appease -Wall -Werror */
	soap_default_s__SOAPArrayStruct(soap, &a->_inputStruct);
}

SOAP_FMAC3 void SOAP_FMAC4 soap_serialize_ns__echoNestedArray(struct soap *soap, const struct ns__echoNestedArray *a)
{
	(void)soap; (void)a; /* appease -Wall -Werror */
	soap_serialize_s__SOAPArrayStruct(soap, &a->_inputStruct);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_put_ns__echoNestedArray(struct soap *soap, const struct ns__echoNestedArray *a, const char *tag, const char *type)
{
	register int id = soap_embed(soap, (void*)a, NULL, 0, tag, SOAP_TYPE_ns__echoNestedArray);
	if (soap_out_ns__echoNestedArray(soap, tag, id, a, type))
		return soap->error;
	return soap_putindependent(soap);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out_ns__echoNestedArray(struct soap *soap, const char *tag, int id, const struct ns__echoNestedArray *a, const char *type)
{
	if (soap_element_begin_out(soap, tag, soap_embedded_id(soap, id, a, SOAP_TYPE_ns__echoNestedArray), type))
		return soap->error;
	if (soap_out_s__SOAPArrayStruct(soap, "inputStruct", -1, &a->_inputStruct, ""))
		return soap->error;
	return soap_element_end_out(soap, tag);
}

SOAP_FMAC3 struct ns__echoNestedArray * SOAP_FMAC4 soap_get_ns__echoNestedArray(struct soap *soap, struct ns__echoNestedArray *p, const char *tag, const char *type)
{
	if ((p = soap_in_ns__echoNestedArray(soap, tag, p, type)))
		if (soap_getindependent(soap))
			return NULL;
	return p;
}

SOAP_FMAC3 struct ns__echoNestedArray * SOAP_FMAC4 soap_in_ns__echoNestedArray(struct soap *soap, const char *tag, struct ns__echoNestedArray *a, const char *type)
{
	short soap_flag__inputStruct = 1;
	if (soap_element_begin_in(soap, tag, 0, type))
		return NULL;
	a = (struct ns__echoNestedArray *)soap_id_enter(soap, soap->id, a, SOAP_TYPE_ns__echoNestedArray, sizeof(struct ns__echoNestedArray), 0, NULL, NULL, NULL);
	if (!a)
		return NULL;
	soap_default_ns__echoNestedArray(soap, a);
	if (soap->body && !*soap->href)
	{
		for (;;)
		{	soap->error = SOAP_TAG_MISMATCH;
			if (soap_flag__inputStruct && soap->error == SOAP_TAG_MISMATCH)
				if (soap_in_s__SOAPArrayStruct(soap, NULL, &a->_inputStruct, "s:SOAPArrayStruct"))
				{	soap_flag__inputStruct--;
					continue;
				}
			if (soap->error == SOAP_TAG_MISMATCH)
				soap->error = soap_ignore_element(soap);
			if (soap->error == SOAP_NO_TAG)
				break;
			if (soap->error)
				return NULL;
		}
		if (soap_element_end_in(soap, tag))
			return NULL;
	}
	else
	{	a = (struct ns__echoNestedArray *)soap_id_forward(soap, soap->href, (void*)a, 0, SOAP_TYPE_ns__echoNestedArray, 0, sizeof(struct ns__echoNestedArray), 0, NULL);
		if (soap->body && soap_element_end_in(soap, tag))
			return NULL;
	}
	if ((soap->mode & SOAP_XML_STRICT) && (soap_flag__inputStruct > 0))
	{	soap->error = SOAP_OCCURS;
		return NULL;
	}
	return a;
}

SOAP_FMAC5 struct ns__echoNestedArray * SOAP_FMAC6 soap_new_ns__echoNestedArray(struct soap *soap, int n)
{	return soap_instantiate_ns__echoNestedArray(soap, n, NULL, NULL, NULL);
}

SOAP_FMAC5 void SOAP_FMAC6 soap_delete_ns__echoNestedArray(struct soap *soap, struct ns__echoNestedArray *p)
{	soap_delete(soap, p);
}

SOAP_FMAC3 struct ns__echoNestedArray * SOAP_FMAC4 soap_instantiate_ns__echoNestedArray(struct soap *soap, int n, const char *type, const char *arrayType, size_t *size)
{
	DBGLOG(TEST, SOAP_MESSAGE(fdebug, "soap_instantiate_ns__echoNestedArray(%d, %s, %s)\n", n, type?type:"", arrayType?arrayType:""));
	struct soap_clist *cp = soap_link(soap, NULL, SOAP_TYPE_ns__echoNestedArray, n, soap_fdelete);
	if (!cp)
		return NULL;
	if (n < 0)
	{	cp->ptr = (void*)new struct ns__echoNestedArray;
		if (size)
			*size = sizeof(struct ns__echoNestedArray);
	}
	else
	{	cp->ptr = (void*)new struct ns__echoNestedArray[n];
		if (!cp->ptr)
		{	soap->error = SOAP_EOM;
			return NULL;
		}
		if (size)
			*size = n * sizeof(struct ns__echoNestedArray);
	}
		DBGLOG(TEST, SOAP_MESSAGE(fdebug, "Instantiated location=%p\n", cp->ptr));
	return (struct ns__echoNestedArray*)cp->ptr;
}
SOAP_FMAC3 void SOAP_FMAC4 soap_copy_ns__echoNestedArray(struct soap *soap, int st, int tt, void *p, size_t len, const void *q, size_t n)
{
	DBGLOG(TEST, SOAP_MESSAGE(fdebug, "Copying struct ns__echoNestedArray %p -> %p\n", q, p));
	*(struct ns__echoNestedArray*)p = *(struct ns__echoNestedArray*)q;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_default_ns__echoNestedArrayResponse(struct soap *soap, struct ns__echoNestedArrayResponse *a)
{
	(void)soap; (void)a; /* appease -Wall -Werror */
	soap_default_s__SOAPArrayStruct(soap, &a->_return);
}

SOAP_FMAC3 void SOAP_FMAC4 soap_serialize_ns__echoNestedArrayResponse(struct soap *soap, const struct ns__echoNestedArrayResponse *a)
{
	(void)soap; (void)a; /* appease -Wall -Werror */
	soap_serialize_s__SOAPArrayStruct(soap, &a->_return);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_put_ns__echoNestedArrayResponse(struct soap *soap, const struct ns__echoNestedArrayResponse *a, const char *tag, const char *type)
{
	register int id = soap_embed(soap, (void*)a, NULL, 0, tag, SOAP_TYPE_ns__echoNestedArrayResponse);
	if (soap_out_ns__echoNestedArrayResponse(soap, tag, id, a, type))
		return soap->error;
	return soap_putindependent(soap);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out_ns__echoNestedArrayResponse(struct soap *soap, const char *tag, int id, const struct ns__echoNestedArrayResponse *a, const char *type)
{
	if (soap_element_begin_out(soap, tag, soap_embedded_id(soap, id, a, SOAP_TYPE_ns__echoNestedArrayResponse), type))
		return soap->error;
	if (soap_out_s__SOAPArrayStruct(soap, "return", -1, &a->_return, ""))
		return soap->error;
	return soap_element_end_out(soap, tag);
}

SOAP_FMAC3 struct ns__echoNestedArrayResponse * SOAP_FMAC4 soap_get_ns__echoNestedArrayResponse(struct soap *soap, struct ns__echoNestedArrayResponse *p, const char *tag, const char *type)
{
	if ((p = soap_in_ns__echoNestedArrayResponse(soap, tag, p, type)))
		if (soap_getindependent(soap))
			return NULL;
	return p;
}

SOAP_FMAC3 struct ns__echoNestedArrayResponse * SOAP_FMAC4 soap_in_ns__echoNestedArrayResponse(struct soap *soap, const char *tag, struct ns__echoNestedArrayResponse *a, const char *type)
{
	short soap_flag__return = 1;
	if (soap_element_begin_in(soap, tag, 0, type))
		return NULL;
	a = (struct ns__echoNestedArrayResponse *)soap_id_enter(soap, soap->id, a, SOAP_TYPE_ns__echoNestedArrayResponse, sizeof(struct ns__echoNestedArrayResponse), 0, NULL, NULL, NULL);
	if (!a)
		return NULL;
	soap_default_ns__echoNestedArrayResponse(soap, a);
	if (soap->body && !*soap->href)
	{
		for (;;)
		{	soap->error = SOAP_TAG_MISMATCH;
			if (soap_flag__return && soap->error == SOAP_TAG_MISMATCH)
				if (soap_in_s__SOAPArrayStruct(soap, NULL, &a->_return, "s:SOAPArrayStruct"))
				{	soap_flag__return--;
					continue;
				}
			if (soap->error == SOAP_TAG_MISMATCH)
				soap->error = soap_ignore_element(soap);
			if (soap->error == SOAP_NO_TAG)
				break;
			if (soap->error)
				return NULL;
		}
		if (soap_element_end_in(soap, tag))
			return NULL;
	}
	else
	{	a = (struct ns__echoNestedArrayResponse *)soap_id_forward(soap, soap->href, (void*)a, 0, SOAP_TYPE_ns__echoNestedArrayResponse, 0, sizeof(struct ns__echoNestedArrayResponse), 0, NULL);
		if (soap->body && soap_element_end_in(soap, tag))
			return NULL;
	}
	if ((soap->mode & SOAP_XML_STRICT) && (soap_flag__return > 0))
	{	soap->error = SOAP_OCCURS;
		return NULL;
	}
	return a;
}

SOAP_FMAC5 struct ns__echoNestedArrayResponse * SOAP_FMAC6 soap_new_ns__echoNestedArrayResponse(struct soap *soap, int n)
{	return soap_instantiate_ns__echoNestedArrayResponse(soap, n, NULL, NULL, NULL);
}

SOAP_FMAC5 void SOAP_FMAC6 soap_delete_ns__echoNestedArrayResponse(struct soap *soap, struct ns__echoNestedArrayResponse *p)
{	soap_delete(soap, p);
}

SOAP_FMAC3 struct ns__echoNestedArrayResponse * SOAP_FMAC4 soap_instantiate_ns__echoNestedArrayResponse(struct soap *soap, int n, const char *type, const char *arrayType, size_t *size)
{
	DBGLOG(TEST, SOAP_MESSAGE(fdebug, "soap_instantiate_ns__echoNestedArrayResponse(%d, %s, %s)\n", n, type?type:"", arrayType?arrayType:""));
	struct soap_clist *cp = soap_link(soap, NULL, SOAP_TYPE_ns__echoNestedArrayResponse, n, soap_fdelete);
	if (!cp)
		return NULL;
	if (n < 0)
	{	cp->ptr = (void*)new struct ns__echoNestedArrayResponse;
		if (size)
			*size = sizeof(struct ns__echoNestedArrayResponse);
	}
	else
	{	cp->ptr = (void*)new struct ns__echoNestedArrayResponse[n];
		if (!cp->ptr)
		{	soap->error = SOAP_EOM;
			return NULL;
		}
		if (size)
			*size = n * sizeof(struct ns__echoNestedArrayResponse);
	}
		DBGLOG(TEST, SOAP_MESSAGE(fdebug, "Instantiated location=%p\n", cp->ptr));
	return (struct ns__echoNestedArrayResponse*)cp->ptr;
}
SOAP_FMAC3 void SOAP_FMAC4 soap_copy_ns__echoNestedArrayResponse(struct soap *soap, int st, int tt, void *p, size_t len, const void *q, size_t n)
{
	DBGLOG(TEST, SOAP_MESSAGE(fdebug, "Copying struct ns__echoNestedArrayResponse %p -> %p\n", q, p));
	*(struct ns__echoNestedArrayResponse*)p = *(struct ns__echoNestedArrayResponse*)q;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_default_s__SOAPArrayStruct(struct soap *soap, struct s__SOAPArrayStruct *a)
{
	(void)soap; (void)a; /* appease -Wall -Werror */
	soap_default_xsd__string(soap, &a->varString);
	a->varInt = NULL;
	a->varFloat = NULL;
	soap_default_ArrayOfstring(soap, &a->varArray);
}

SOAP_FMAC3 void SOAP_FMAC4 soap_serialize_s__SOAPArrayStruct(struct soap *soap, const struct s__SOAPArrayStruct *a)
{
	(void)soap; (void)a; /* appease -Wall -Werror */
	soap_serialize_xsd__string(soap, &a->varString);
	soap_serialize_PointerToxsd__int(soap, &a->varInt);
	soap_serialize_PointerToxsd__float(soap, &a->varFloat);
	soap_serialize_ArrayOfstring(soap, &a->varArray);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_put_s__SOAPArrayStruct(struct soap *soap, const struct s__SOAPArrayStruct *a, const char *tag, const char *type)
{
	register int id = soap_embed(soap, (void*)a, NULL, 0, tag, SOAP_TYPE_s__SOAPArrayStruct);
	if (soap_out_s__SOAPArrayStruct(soap, tag, id, a, type))
		return soap->error;
	return soap_putindependent(soap);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out_s__SOAPArrayStruct(struct soap *soap, const char *tag, int id, const struct s__SOAPArrayStruct *a, const char *type)
{
	if (soap_element_begin_out(soap, tag, soap_embedded_id(soap, id, a, SOAP_TYPE_s__SOAPArrayStruct), type))
		return soap->error;
	if (soap_out_xsd__string(soap, "varString", -1, &a->varString, ""))
		return soap->error;
	if (soap_out_PointerToxsd__int(soap, "varInt", -1, &a->varInt, ""))
		return soap->error;
	if (soap_out_PointerToxsd__float(soap, "varFloat", -1, &a->varFloat, ""))
		return soap->error;
	if (soap_out_ArrayOfstring(soap, "varArray", -1, &a->varArray, ""))
		return soap->error;
	return soap_element_end_out(soap, tag);
}

SOAP_FMAC3 struct s__SOAPArrayStruct * SOAP_FMAC4 soap_get_s__SOAPArrayStruct(struct soap *soap, struct s__SOAPArrayStruct *p, const char *tag, const char *type)
{
	if ((p = soap_in_s__SOAPArrayStruct(soap, tag, p, type)))
		if (soap_getindependent(soap))
			return NULL;
	return p;
}

SOAP_FMAC3 struct s__SOAPArrayStruct * SOAP_FMAC4 soap_in_s__SOAPArrayStruct(struct soap *soap, const char *tag, struct s__SOAPArrayStruct *a, const char *type)
{
	short soap_flag_varString = 1, soap_flag_varInt = 1, soap_flag_varFloat = 1, soap_flag_varArray = 1;
	if (soap_element_begin_in(soap, tag, 0, type))
		return NULL;
	a = (struct s__SOAPArrayStruct *)soap_id_enter(soap, soap->id, a, SOAP_TYPE_s__SOAPArrayStruct, sizeof(struct s__SOAPArrayStruct), 0, NULL, NULL, NULL);
	if (!a)
		return NULL;
	soap_default_s__SOAPArrayStruct(soap, a);
	if (soap->body && !*soap->href)
	{
		for (;;)
		{	soap->error = SOAP_TAG_MISMATCH;
			if (soap_flag_varString && (soap->error == SOAP_TAG_MISMATCH || soap->error == SOAP_NO_TAG))
				if (soap_in_xsd__string(soap, "varString", &a->varString, "xsd:string"))
				{	soap_flag_varString--;
					continue;
				}
			if (soap_flag_varInt && soap->error == SOAP_TAG_MISMATCH)
				if (soap_in_PointerToxsd__int(soap, "varInt", &a->varInt, "xsd:int"))
				{	soap_flag_varInt--;
					continue;
				}
			if (soap_flag_varFloat && soap->error == SOAP_TAG_MISMATCH)
				if (soap_in_PointerToxsd__float(soap, "varFloat", &a->varFloat, "xsd:float"))
				{	soap_flag_varFloat--;
					continue;
				}
			if (soap_flag_varArray && soap->error == SOAP_TAG_MISMATCH)
				if (soap_in_ArrayOfstring(soap, "varArray", &a->varArray, "xsd:string"))
				{	soap_flag_varArray--;
					continue;
				}
			if (soap->error == SOAP_TAG_MISMATCH)
				soap->error = soap_ignore_element(soap);
			if (soap->error == SOAP_NO_TAG)
				break;
			if (soap->error)
				return NULL;
		}
		if (soap_element_end_in(soap, tag))
			return NULL;
	}
	else
	{	a = (struct s__SOAPArrayStruct *)soap_id_forward(soap, soap->href, (void*)a, 0, SOAP_TYPE_s__SOAPArrayStruct, 0, sizeof(struct s__SOAPArrayStruct), 0, NULL);
		if (soap->body && soap_element_end_in(soap, tag))
			return NULL;
	}
	if ((soap->mode & SOAP_XML_STRICT) && (soap_flag_varArray > 0))
	{	soap->error = SOAP_OCCURS;
		return NULL;
	}
	return a;
}

SOAP_FMAC5 struct s__SOAPArrayStruct * SOAP_FMAC6 soap_new_s__SOAPArrayStruct(struct soap *soap, int n)
{	return soap_instantiate_s__SOAPArrayStruct(soap, n, NULL, NULL, NULL);
}

SOAP_FMAC5 void SOAP_FMAC6 soap_delete_s__SOAPArrayStruct(struct soap *soap, struct s__SOAPArrayStruct *p)
{	soap_delete(soap, p);
}

SOAP_FMAC3 struct s__SOAPArrayStruct * SOAP_FMAC4 soap_instantiate_s__SOAPArrayStruct(struct soap *soap, int n, const char *type, const char *arrayType, size_t *size)
{
	DBGLOG(TEST, SOAP_MESSAGE(fdebug, "soap_instantiate_s__SOAPArrayStruct(%d, %s, %s)\n", n, type?type:"", arrayType?arrayType:""));
	struct soap_clist *cp = soap_link(soap, NULL, SOAP_TYPE_s__SOAPArrayStruct, n, soap_fdelete);
	if (!cp)
		return NULL;
	if (n < 0)
	{	cp->ptr = (void*)new struct s__SOAPArrayStruct;
		if (size)
			*size = sizeof(struct s__SOAPArrayStruct);
	}
	else
	{	cp->ptr = (void*)new struct s__SOAPArrayStruct[n];
		if (!cp->ptr)
		{	soap->error = SOAP_EOM;
			return NULL;
		}
		if (size)
			*size = n * sizeof(struct s__SOAPArrayStruct);
	}
		DBGLOG(TEST, SOAP_MESSAGE(fdebug, "Instantiated location=%p\n", cp->ptr));
	return (struct s__SOAPArrayStruct*)cp->ptr;
}
SOAP_FMAC3 void SOAP_FMAC4 soap_copy_s__SOAPArrayStruct(struct soap *soap, int st, int tt, void *p, size_t len, const void *q, size_t n)
{
	DBGLOG(TEST, SOAP_MESSAGE(fdebug, "Copying struct s__SOAPArrayStruct %p -> %p\n", q, p));
	*(struct s__SOAPArrayStruct*)p = *(struct s__SOAPArrayStruct*)q;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_default_ns__echoNestedStruct(struct soap *soap, struct ns__echoNestedStruct *a)
{
	(void)soap; (void)a; /* appease -Wall -Werror */
	soap_default_s__SOAPStructStruct(soap, &a->_inputStruct);
}

SOAP_FMAC3 void SOAP_FMAC4 soap_serialize_ns__echoNestedStruct(struct soap *soap, const struct ns__echoNestedStruct *a)
{
	(void)soap; (void)a; /* appease -Wall -Werror */
	soap_serialize_s__SOAPStructStruct(soap, &a->_inputStruct);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_put_ns__echoNestedStruct(struct soap *soap, const struct ns__echoNestedStruct *a, const char *tag, const char *type)
{
	register int id = soap_embed(soap, (void*)a, NULL, 0, tag, SOAP_TYPE_ns__echoNestedStruct);
	if (soap_out_ns__echoNestedStruct(soap, tag, id, a, type))
		return soap->error;
	return soap_putindependent(soap);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out_ns__echoNestedStruct(struct soap *soap, const char *tag, int id, const struct ns__echoNestedStruct *a, const char *type)
{
	if (soap_element_begin_out(soap, tag, soap_embedded_id(soap, id, a, SOAP_TYPE_ns__echoNestedStruct), type))
		return soap->error;
	if (soap_out_s__SOAPStructStruct(soap, "inputStruct", -1, &a->_inputStruct, ""))
		return soap->error;
	return soap_element_end_out(soap, tag);
}

SOAP_FMAC3 struct ns__echoNestedStruct * SOAP_FMAC4 soap_get_ns__echoNestedStruct(struct soap *soap, struct ns__echoNestedStruct *p, const char *tag, const char *type)
{
	if ((p = soap_in_ns__echoNestedStruct(soap, tag, p, type)))
		if (soap_getindependent(soap))
			return NULL;
	return p;
}

SOAP_FMAC3 struct ns__echoNestedStruct * SOAP_FMAC4 soap_in_ns__echoNestedStruct(struct soap *soap, const char *tag, struct ns__echoNestedStruct *a, const char *type)
{
	short soap_flag__inputStruct = 1;
	if (soap_element_begin_in(soap, tag, 0, type))
		return NULL;
	a = (struct ns__echoNestedStruct *)soap_id_enter(soap, soap->id, a, SOAP_TYPE_ns__echoNestedStruct, sizeof(struct ns__echoNestedStruct), 0, NULL, NULL, NULL);
	if (!a)
		return NULL;
	soap_default_ns__echoNestedStruct(soap, a);
	if (soap->body && !*soap->href)
	{
		for (;;)
		{	soap->error = SOAP_TAG_MISMATCH;
			if (soap_flag__inputStruct && soap->error == SOAP_TAG_MISMATCH)
				if (soap_in_s__SOAPStructStruct(soap, NULL, &a->_inputStruct, "s:SOAPStructStruct"))
				{	soap_flag__inputStruct--;
					continue;
				}
			if (soap->error == SOAP_TAG_MISMATCH)
				soap->error = soap_ignore_element(soap);
			if (soap->error == SOAP_NO_TAG)
				break;
			if (soap->error)
				return NULL;
		}
		if (soap_element_end_in(soap, tag))
			return NULL;
	}
	else
	{	a = (struct ns__echoNestedStruct *)soap_id_forward(soap, soap->href, (void*)a, 0, SOAP_TYPE_ns__echoNestedStruct, 0, sizeof(struct ns__echoNestedStruct), 0, NULL);
		if (soap->body && soap_element_end_in(soap, tag))
			return NULL;
	}
	if ((soap->mode & SOAP_XML_STRICT) && (soap_flag__inputStruct > 0))
	{	soap->error = SOAP_OCCURS;
		return NULL;
	}
	return a;
}

SOAP_FMAC5 struct ns__echoNestedStruct * SOAP_FMAC6 soap_new_ns__echoNestedStruct(struct soap *soap, int n)
{	return soap_instantiate_ns__echoNestedStruct(soap, n, NULL, NULL, NULL);
}

SOAP_FMAC5 void SOAP_FMAC6 soap_delete_ns__echoNestedStruct(struct soap *soap, struct ns__echoNestedStruct *p)
{	soap_delete(soap, p);
}

SOAP_FMAC3 struct ns__echoNestedStruct * SOAP_FMAC4 soap_instantiate_ns__echoNestedStruct(struct soap *soap, int n, const char *type, const char *arrayType, size_t *size)
{
	DBGLOG(TEST, SOAP_MESSAGE(fdebug, "soap_instantiate_ns__echoNestedStruct(%d, %s, %s)\n", n, type?type:"", arrayType?arrayType:""));
	struct soap_clist *cp = soap_link(soap, NULL, SOAP_TYPE_ns__echoNestedStruct, n, soap_fdelete);
	if (!cp)
		return NULL;
	if (n < 0)
	{	cp->ptr = (void*)new struct ns__echoNestedStruct;
		if (size)
			*size = sizeof(struct ns__echoNestedStruct);
	}
	else
	{	cp->ptr = (void*)new struct ns__echoNestedStruct[n];
		if (!cp->ptr)
		{	soap->error = SOAP_EOM;
			return NULL;
		}
		if (size)
			*size = n * sizeof(struct ns__echoNestedStruct);
	}
		DBGLOG(TEST, SOAP_MESSAGE(fdebug, "Instantiated location=%p\n", cp->ptr));
	return (struct ns__echoNestedStruct*)cp->ptr;
}
SOAP_FMAC3 void SOAP_FMAC4 soap_copy_ns__echoNestedStruct(struct soap *soap, int st, int tt, void *p, size_t len, const void *q, size_t n)
{
	DBGLOG(TEST, SOAP_MESSAGE(fdebug, "Copying struct ns__echoNestedStruct %p -> %p\n", q, p));
	*(struct ns__echoNestedStruct*)p = *(struct ns__echoNestedStruct*)q;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_default_ns__echoNestedStructResponse(struct soap *soap, struct ns__echoNestedStructResponse *a)
{
	(void)soap; (void)a; /* appease -Wall -Werror */
	soap_default_s__SOAPStructStruct(soap, &a->_return);
}

SOAP_FMAC3 void SOAP_FMAC4 soap_serialize_ns__echoNestedStructResponse(struct soap *soap, const struct ns__echoNestedStructResponse *a)
{
	(void)soap; (void)a; /* appease -Wall -Werror */
	soap_serialize_s__SOAPStructStruct(soap, &a->_return);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_put_ns__echoNestedStructResponse(struct soap *soap, const struct ns__echoNestedStructResponse *a, const char *tag, const char *type)
{
	register int id = soap_embed(soap, (void*)a, NULL, 0, tag, SOAP_TYPE_ns__echoNestedStructResponse);
	if (soap_out_ns__echoNestedStructResponse(soap, tag, id, a, type))
		return soap->error;
	return soap_putindependent(soap);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out_ns__echoNestedStructResponse(struct soap *soap, const char *tag, int id, const struct ns__echoNestedStructResponse *a, const char *type)
{
	if (soap_element_begin_out(soap, tag, soap_embedded_id(soap, id, a, SOAP_TYPE_ns__echoNestedStructResponse), type))
		return soap->error;
	if (soap_out_s__SOAPStructStruct(soap, "return", -1, &a->_return, ""))
		return soap->error;
	return soap_element_end_out(soap, tag);
}

SOAP_FMAC3 struct ns__echoNestedStructResponse * SOAP_FMAC4 soap_get_ns__echoNestedStructResponse(struct soap *soap, struct ns__echoNestedStructResponse *p, const char *tag, const char *type)
{
	if ((p = soap_in_ns__echoNestedStructResponse(soap, tag, p, type)))
		if (soap_getindependent(soap))
			return NULL;
	return p;
}

SOAP_FMAC3 struct ns__echoNestedStructResponse * SOAP_FMAC4 soap_in_ns__echoNestedStructResponse(struct soap *soap, const char *tag, struct ns__echoNestedStructResponse *a, const char *type)
{
	short soap_flag__return = 1;
	if (soap_element_begin_in(soap, tag, 0, type))
		return NULL;
	a = (struct ns__echoNestedStructResponse *)soap_id_enter(soap, soap->id, a, SOAP_TYPE_ns__echoNestedStructResponse, sizeof(struct ns__echoNestedStructResponse), 0, NULL, NULL, NULL);
	if (!a)
		return NULL;
	soap_default_ns__echoNestedStructResponse(soap, a);
	if (soap->body && !*soap->href)
	{
		for (;;)
		{	soap->error = SOAP_TAG_MISMATCH;
			if (soap_flag__return && soap->error == SOAP_TAG_MISMATCH)
				if (soap_in_s__SOAPStructStruct(soap, NULL, &a->_return, "s:SOAPStructStruct"))
				{	soap_flag__return--;
					continue;
				}
			if (soap->error == SOAP_TAG_MISMATCH)
				soap->error = soap_ignore_element(soap);
			if (soap->error == SOAP_NO_TAG)
				break;
			if (soap->error)
				return NULL;
		}
		if (soap_element_end_in(soap, tag))
			return NULL;
	}
	else
	{	a = (struct ns__echoNestedStructResponse *)soap_id_forward(soap, soap->href, (void*)a, 0, SOAP_TYPE_ns__echoNestedStructResponse, 0, sizeof(struct ns__echoNestedStructResponse), 0, NULL);
		if (soap->body && soap_element_end_in(soap, tag))
			return NULL;
	}
	if ((soap->mode & SOAP_XML_STRICT) && (soap_flag__return > 0))
	{	soap->error = SOAP_OCCURS;
		return NULL;
	}
	return a;
}

SOAP_FMAC5 struct ns__echoNestedStructResponse * SOAP_FMAC6 soap_new_ns__echoNestedStructResponse(struct soap *soap, int n)
{	return soap_instantiate_ns__echoNestedStructResponse(soap, n, NULL, NULL, NULL);
}

SOAP_FMAC5 void SOAP_FMAC6 soap_delete_ns__echoNestedStructResponse(struct soap *soap, struct ns__echoNestedStructResponse *p)
{	soap_delete(soap, p);
}

SOAP_FMAC3 struct ns__echoNestedStructResponse * SOAP_FMAC4 soap_instantiate_ns__echoNestedStructResponse(struct soap *soap, int n, const char *type, const char *arrayType, size_t *size)
{
	DBGLOG(TEST, SOAP_MESSAGE(fdebug, "soap_instantiate_ns__echoNestedStructResponse(%d, %s, %s)\n", n, type?type:"", arrayType?arrayType:""));
	struct soap_clist *cp = soap_link(soap, NULL, SOAP_TYPE_ns__echoNestedStructResponse, n, soap_fdelete);
	if (!cp)
		return NULL;
	if (n < 0)
	{	cp->ptr = (void*)new struct ns__echoNestedStructResponse;
		if (size)
			*size = sizeof(struct ns__echoNestedStructResponse);
	}
	else
	{	cp->ptr = (void*)new struct ns__echoNestedStructResponse[n];
		if (!cp->ptr)
		{	soap->error = SOAP_EOM;
			return NULL;
		}
		if (size)
			*size = n * sizeof(struct ns__echoNestedStructResponse);
	}
		DBGLOG(TEST, SOAP_MESSAGE(fdebug, "Instantiated location=%p\n", cp->ptr));
	return (struct ns__echoNestedStructResponse*)cp->ptr;
}
SOAP_FMAC3 void SOAP_FMAC4 soap_copy_ns__echoNestedStructResponse(struct soap *soap, int st, int tt, void *p, size_t len, const void *q, size_t n)
{
	DBGLOG(TEST, SOAP_MESSAGE(fdebug, "Copying struct ns__echoNestedStructResponse %p -> %p\n", q, p));
	*(struct ns__echoNestedStructResponse*)p = *(struct ns__echoNestedStructResponse*)q;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_default_s__SOAPStructStruct(struct soap *soap, struct s__SOAPStructStruct *a)
{
	(void)soap; (void)a; /* appease -Wall -Werror */
	soap_default_xsd__string(soap, &a->varString);
	a->varInt = NULL;
	a->varFloat = NULL;
	a->varStruct = NULL;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_serialize_s__SOAPStructStruct(struct soap *soap, const struct s__SOAPStructStruct *a)
{
	(void)soap; (void)a; /* appease -Wall -Werror */
	soap_serialize_xsd__string(soap, &a->varString);
	soap_serialize_PointerToxsd__int(soap, &a->varInt);
	soap_serialize_PointerToxsd__float(soap, &a->varFloat);
	soap_serialize_PointerTos__SOAPStruct(soap, &a->varStruct);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_put_s__SOAPStructStruct(struct soap *soap, const struct s__SOAPStructStruct *a, const char *tag, const char *type)
{
	register int id = soap_embed(soap, (void*)a, NULL, 0, tag, SOAP_TYPE_s__SOAPStructStruct);
	if (soap_out_s__SOAPStructStruct(soap, tag, id, a, type))
		return soap->error;
	return soap_putindependent(soap);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out_s__SOAPStructStruct(struct soap *soap, const char *tag, int id, const struct s__SOAPStructStruct *a, const char *type)
{
	if (soap_element_begin_out(soap, tag, soap_embedded_id(soap, id, a, SOAP_TYPE_s__SOAPStructStruct), type))
		return soap->error;
	if (soap_out_xsd__string(soap, "varString", -1, &a->varString, ""))
		return soap->error;
	if (soap_out_PointerToxsd__int(soap, "varInt", -1, &a->varInt, ""))
		return soap->error;
	if (soap_out_PointerToxsd__float(soap, "varFloat", -1, &a->varFloat, ""))
		return soap->error;
	if (soap_out_PointerTos__SOAPStruct(soap, "varStruct", -1, &a->varStruct, ""))
		return soap->error;
	return soap_element_end_out(soap, tag);
}

SOAP_FMAC3 struct s__SOAPStructStruct * SOAP_FMAC4 soap_get_s__SOAPStructStruct(struct soap *soap, struct s__SOAPStructStruct *p, const char *tag, const char *type)
{
	if ((p = soap_in_s__SOAPStructStruct(soap, tag, p, type)))
		if (soap_getindependent(soap))
			return NULL;
	return p;
}

SOAP_FMAC3 struct s__SOAPStructStruct * SOAP_FMAC4 soap_in_s__SOAPStructStruct(struct soap *soap, const char *tag, struct s__SOAPStructStruct *a, const char *type)
{
	short soap_flag_varString = 1, soap_flag_varInt = 1, soap_flag_varFloat = 1, soap_flag_varStruct = 1;
	if (soap_element_begin_in(soap, tag, 0, type))
		return NULL;
	a = (struct s__SOAPStructStruct *)soap_id_enter(soap, soap->id, a, SOAP_TYPE_s__SOAPStructStruct, sizeof(struct s__SOAPStructStruct), 0, NULL, NULL, NULL);
	if (!a)
		return NULL;
	soap_default_s__SOAPStructStruct(soap, a);
	if (soap->body && !*soap->href)
	{
		for (;;)
		{	soap->error = SOAP_TAG_MISMATCH;
			if (soap_flag_varString && (soap->error == SOAP_TAG_MISMATCH || soap->error == SOAP_NO_TAG))
				if (soap_in_xsd__string(soap, "varString", &a->varString, "xsd:string"))
				{	soap_flag_varString--;
					continue;
				}
			if (soap_flag_varInt && soap->error == SOAP_TAG_MISMATCH)
				if (soap_in_PointerToxsd__int(soap, "varInt", &a->varInt, "xsd:int"))
				{	soap_flag_varInt--;
					continue;
				}
			if (soap_flag_varFloat && soap->error == SOAP_TAG_MISMATCH)
				if (soap_in_PointerToxsd__float(soap, "varFloat", &a->varFloat, "xsd:float"))
				{	soap_flag_varFloat--;
					continue;
				}
			if (soap_flag_varStruct && soap->error == SOAP_TAG_MISMATCH)
				if (soap_in_PointerTos__SOAPStruct(soap, "varStruct", &a->varStruct, "s:SOAPStruct"))
				{	soap_flag_varStruct--;
					continue;
				}
			if (soap->error == SOAP_TAG_MISMATCH)
				soap->error = soap_ignore_element(soap);
			if (soap->error == SOAP_NO_TAG)
				break;
			if (soap->error)
				return NULL;
		}
		if (soap_element_end_in(soap, tag))
			return NULL;
	}
	else
	{	a = (struct s__SOAPStructStruct *)soap_id_forward(soap, soap->href, (void*)a, 0, SOAP_TYPE_s__SOAPStructStruct, 0, sizeof(struct s__SOAPStructStruct), 0, NULL);
		if (soap->body && soap_element_end_in(soap, tag))
			return NULL;
	}
	return a;
}

SOAP_FMAC5 struct s__SOAPStructStruct * SOAP_FMAC6 soap_new_s__SOAPStructStruct(struct soap *soap, int n)
{	return soap_instantiate_s__SOAPStructStruct(soap, n, NULL, NULL, NULL);
}

SOAP_FMAC5 void SOAP_FMAC6 soap_delete_s__SOAPStructStruct(struct soap *soap, struct s__SOAPStructStruct *p)
{	soap_delete(soap, p);
}

SOAP_FMAC3 struct s__SOAPStructStruct * SOAP_FMAC4 soap_instantiate_s__SOAPStructStruct(struct soap *soap, int n, const char *type, const char *arrayType, size_t *size)
{
	DBGLOG(TEST, SOAP_MESSAGE(fdebug, "soap_instantiate_s__SOAPStructStruct(%d, %s, %s)\n", n, type?type:"", arrayType?arrayType:""));
	struct soap_clist *cp = soap_link(soap, NULL, SOAP_TYPE_s__SOAPStructStruct, n, soap_fdelete);
	if (!cp)
		return NULL;
	if (n < 0)
	{	cp->ptr = (void*)new struct s__SOAPStructStruct;
		if (size)
			*size = sizeof(struct s__SOAPStructStruct);
	}
	else
	{	cp->ptr = (void*)new struct s__SOAPStructStruct[n];
		if (!cp->ptr)
		{	soap->error = SOAP_EOM;
			return NULL;
		}
		if (size)
			*size = n * sizeof(struct s__SOAPStructStruct);
	}
		DBGLOG(TEST, SOAP_MESSAGE(fdebug, "Instantiated location=%p\n", cp->ptr));
	return (struct s__SOAPStructStruct*)cp->ptr;
}
SOAP_FMAC3 void SOAP_FMAC4 soap_copy_s__SOAPStructStruct(struct soap *soap, int st, int tt, void *p, size_t len, const void *q, size_t n)
{
	DBGLOG(TEST, SOAP_MESSAGE(fdebug, "Copying struct s__SOAPStructStruct %p -> %p\n", q, p));
	*(struct s__SOAPStructStruct*)p = *(struct s__SOAPStructStruct*)q;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_default_ns__echo2DStringArray(struct soap *soap, struct ns__echo2DStringArray *a)
{
	(void)soap; (void)a; /* appease -Wall -Werror */
	soap_default_ArrayOfstring2D(soap, &a->_input2DStringArray);
}

SOAP_FMAC3 void SOAP_FMAC4 soap_serialize_ns__echo2DStringArray(struct soap *soap, const struct ns__echo2DStringArray *a)
{
	(void)soap; (void)a; /* appease -Wall -Werror */
	soap_serialize_ArrayOfstring2D(soap, &a->_input2DStringArray);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_put_ns__echo2DStringArray(struct soap *soap, const struct ns__echo2DStringArray *a, const char *tag, const char *type)
{
	register int id = soap_embed(soap, (void*)a, NULL, 0, tag, SOAP_TYPE_ns__echo2DStringArray);
	if (soap_out_ns__echo2DStringArray(soap, tag, id, a, type))
		return soap->error;
	return soap_putindependent(soap);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out_ns__echo2DStringArray(struct soap *soap, const char *tag, int id, const struct ns__echo2DStringArray *a, const char *type)
{
	if (soap_element_begin_out(soap, tag, soap_embedded_id(soap, id, a, SOAP_TYPE_ns__echo2DStringArray), type))
		return soap->error;
	if (soap_out_ArrayOfstring2D(soap, "input2DStringArray", -1, &a->_input2DStringArray, ""))
		return soap->error;
	return soap_element_end_out(soap, tag);
}

SOAP_FMAC3 struct ns__echo2DStringArray * SOAP_FMAC4 soap_get_ns__echo2DStringArray(struct soap *soap, struct ns__echo2DStringArray *p, const char *tag, const char *type)
{
	if ((p = soap_in_ns__echo2DStringArray(soap, tag, p, type)))
		if (soap_getindependent(soap))
			return NULL;
	return p;
}

SOAP_FMAC3 struct ns__echo2DStringArray * SOAP_FMAC4 soap_in_ns__echo2DStringArray(struct soap *soap, const char *tag, struct ns__echo2DStringArray *a, const char *type)
{
	short soap_flag__input2DStringArray = 1;
	if (soap_element_begin_in(soap, tag, 0, type))
		return NULL;
	a = (struct ns__echo2DStringArray *)soap_id_enter(soap, soap->id, a, SOAP_TYPE_ns__echo2DStringArray, sizeof(struct ns__echo2DStringArray), 0, NULL, NULL, NULL);
	if (!a)
		return NULL;
	soap_default_ns__echo2DStringArray(soap, a);
	if (soap->body && !*soap->href)
	{
		for (;;)
		{	soap->error = SOAP_TAG_MISMATCH;
			if (soap_flag__input2DStringArray && soap->error == SOAP_TAG_MISMATCH)
				if (soap_in_ArrayOfstring2D(soap, NULL, &a->_input2DStringArray, "xsd:string"))
				{	soap_flag__input2DStringArray--;
					continue;
				}
			if (soap->error == SOAP_TAG_MISMATCH)
				soap->error = soap_ignore_element(soap);
			if (soap->error == SOAP_NO_TAG)
				break;
			if (soap->error)
				return NULL;
		}
		if (soap_element_end_in(soap, tag))
			return NULL;
	}
	else
	{	a = (struct ns__echo2DStringArray *)soap_id_forward(soap, soap->href, (void*)a, 0, SOAP_TYPE_ns__echo2DStringArray, 0, sizeof(struct ns__echo2DStringArray), 0, NULL);
		if (soap->body && soap_element_end_in(soap, tag))
			return NULL;
	}
	if ((soap->mode & SOAP_XML_STRICT) && (soap_flag__input2DStringArray > 0))
	{	soap->error = SOAP_OCCURS;
		return NULL;
	}
	return a;
}

SOAP_FMAC5 struct ns__echo2DStringArray * SOAP_FMAC6 soap_new_ns__echo2DStringArray(struct soap *soap, int n)
{	return soap_instantiate_ns__echo2DStringArray(soap, n, NULL, NULL, NULL);
}

SOAP_FMAC5 void SOAP_FMAC6 soap_delete_ns__echo2DStringArray(struct soap *soap, struct ns__echo2DStringArray *p)
{	soap_delete(soap, p);
}

SOAP_FMAC3 struct ns__echo2DStringArray * SOAP_FMAC4 soap_instantiate_ns__echo2DStringArray(struct soap *soap, int n, const char *type, const char *arrayType, size_t *size)
{
	DBGLOG(TEST, SOAP_MESSAGE(fdebug, "soap_instantiate_ns__echo2DStringArray(%d, %s, %s)\n", n, type?type:"", arrayType?arrayType:""));
	struct soap_clist *cp = soap_link(soap, NULL, SOAP_TYPE_ns__echo2DStringArray, n, soap_fdelete);
	if (!cp)
		return NULL;
	if (n < 0)
	{	cp->ptr = (void*)new struct ns__echo2DStringArray;
		if (size)
			*size = sizeof(struct ns__echo2DStringArray);
	}
	else
	{	cp->ptr = (void*)new struct ns__echo2DStringArray[n];
		if (!cp->ptr)
		{	soap->error = SOAP_EOM;
			return NULL;
		}
		if (size)
			*size = n * sizeof(struct ns__echo2DStringArray);
	}
		DBGLOG(TEST, SOAP_MESSAGE(fdebug, "Instantiated location=%p\n", cp->ptr));
	return (struct ns__echo2DStringArray*)cp->ptr;
}
SOAP_FMAC3 void SOAP_FMAC4 soap_copy_ns__echo2DStringArray(struct soap *soap, int st, int tt, void *p, size_t len, const void *q, size_t n)
{
	DBGLOG(TEST, SOAP_MESSAGE(fdebug, "Copying struct ns__echo2DStringArray %p -> %p\n", q, p));
	*(struct ns__echo2DStringArray*)p = *(struct ns__echo2DStringArray*)q;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_default_ns__echo2DStringArrayResponse(struct soap *soap, struct ns__echo2DStringArrayResponse *a)
{
	(void)soap; (void)a; /* appease -Wall -Werror */
	soap_default_ArrayOfstring2D(soap, &a->_return);
}

SOAP_FMAC3 void SOAP_FMAC4 soap_serialize_ns__echo2DStringArrayResponse(struct soap *soap, const struct ns__echo2DStringArrayResponse *a)
{
	(void)soap; (void)a; /* appease -Wall -Werror */
	soap_serialize_ArrayOfstring2D(soap, &a->_return);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_put_ns__echo2DStringArrayResponse(struct soap *soap, const struct ns__echo2DStringArrayResponse *a, const char *tag, const char *type)
{
	register int id = soap_embed(soap, (void*)a, NULL, 0, tag, SOAP_TYPE_ns__echo2DStringArrayResponse);
	if (soap_out_ns__echo2DStringArrayResponse(soap, tag, id, a, type))
		return soap->error;
	return soap_putindependent(soap);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out_ns__echo2DStringArrayResponse(struct soap *soap, const char *tag, int id, const struct ns__echo2DStringArrayResponse *a, const char *type)
{
	if (soap_element_begin_out(soap, tag, soap_embedded_id(soap, id, a, SOAP_TYPE_ns__echo2DStringArrayResponse), type))
		return soap->error;
	if (soap_out_ArrayOfstring2D(soap, "return", -1, &a->_return, ""))
		return soap->error;
	return soap_element_end_out(soap, tag);
}

SOAP_FMAC3 struct ns__echo2DStringArrayResponse * SOAP_FMAC4 soap_get_ns__echo2DStringArrayResponse(struct soap *soap, struct ns__echo2DStringArrayResponse *p, const char *tag, const char *type)
{
	if ((p = soap_in_ns__echo2DStringArrayResponse(soap, tag, p, type)))
		if (soap_getindependent(soap))
			return NULL;
	return p;
}

SOAP_FMAC3 struct ns__echo2DStringArrayResponse * SOAP_FMAC4 soap_in_ns__echo2DStringArrayResponse(struct soap *soap, const char *tag, struct ns__echo2DStringArrayResponse *a, const char *type)
{
	short soap_flag__return = 1;
	if (soap_element_begin_in(soap, tag, 0, type))
		return NULL;
	a = (struct ns__echo2DStringArrayResponse *)soap_id_enter(soap, soap->id, a, SOAP_TYPE_ns__echo2DStringArrayResponse, sizeof(struct ns__echo2DStringArrayResponse), 0, NULL, NULL, NULL);
	if (!a)
		return NULL;
	soap_default_ns__echo2DStringArrayResponse(soap, a);
	if (soap->body && !*soap->href)
	{
		for (;;)
		{	soap->error = SOAP_TAG_MISMATCH;
			if (soap_flag__return && soap->error == SOAP_TAG_MISMATCH)
				if (soap_in_ArrayOfstring2D(soap, NULL, &a->_return, "xsd:string"))
				{	soap_flag__return--;
					continue;
				}
			if (soap->error == SOAP_TAG_MISMATCH)
				soap->error = soap_ignore_element(soap);
			if (soap->error == SOAP_NO_TAG)
				break;
			if (soap->error)
				return NULL;
		}
		if (soap_element_end_in(soap, tag))
			return NULL;
	}
	else
	{	a = (struct ns__echo2DStringArrayResponse *)soap_id_forward(soap, soap->href, (void*)a, 0, SOAP_TYPE_ns__echo2DStringArrayResponse, 0, sizeof(struct ns__echo2DStringArrayResponse), 0, NULL);
		if (soap->body && soap_element_end_in(soap, tag))
			return NULL;
	}
	if ((soap->mode & SOAP_XML_STRICT) && (soap_flag__return > 0))
	{	soap->error = SOAP_OCCURS;
		return NULL;
	}
	return a;
}

SOAP_FMAC5 struct ns__echo2DStringArrayResponse * SOAP_FMAC6 soap_new_ns__echo2DStringArrayResponse(struct soap *soap, int n)
{	return soap_instantiate_ns__echo2DStringArrayResponse(soap, n, NULL, NULL, NULL);
}

SOAP_FMAC5 void SOAP_FMAC6 soap_delete_ns__echo2DStringArrayResponse(struct soap *soap, struct ns__echo2DStringArrayResponse *p)
{	soap_delete(soap, p);
}

SOAP_FMAC3 struct ns__echo2DStringArrayResponse * SOAP_FMAC4 soap_instantiate_ns__echo2DStringArrayResponse(struct soap *soap, int n, const char *type, const char *arrayType, size_t *size)
{
	DBGLOG(TEST, SOAP_MESSAGE(fdebug, "soap_instantiate_ns__echo2DStringArrayResponse(%d, %s, %s)\n", n, type?type:"", arrayType?arrayType:""));
	struct soap_clist *cp = soap_link(soap, NULL, SOAP_TYPE_ns__echo2DStringArrayResponse, n, soap_fdelete);
	if (!cp)
		return NULL;
	if (n < 0)
	{	cp->ptr = (void*)new struct ns__echo2DStringArrayResponse;
		if (size)
			*size = sizeof(struct ns__echo2DStringArrayResponse);
	}
	else
	{	cp->ptr = (void*)new struct ns__echo2DStringArrayResponse[n];
		if (!cp->ptr)
		{	soap->error = SOAP_EOM;
			return NULL;
		}
		if (size)
			*size = n * sizeof(struct ns__echo2DStringArrayResponse);
	}
		DBGLOG(TEST, SOAP_MESSAGE(fdebug, "Instantiated location=%p\n", cp->ptr));
	return (struct ns__echo2DStringArrayResponse*)cp->ptr;
}
SOAP_FMAC3 void SOAP_FMAC4 soap_copy_ns__echo2DStringArrayResponse(struct soap *soap, int st, int tt, void *p, size_t len, const void *q, size_t n)
{
	DBGLOG(TEST, SOAP_MESSAGE(fdebug, "Copying struct ns__echo2DStringArrayResponse %p -> %p\n", q, p));
	*(struct ns__echo2DStringArrayResponse*)p = *(struct ns__echo2DStringArrayResponse*)q;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_default_ArrayOfstring2D(struct soap *soap, struct ArrayOfstring2D *a)
{
	a->__ptr = NULL;
	a->__size[0] = 0;
	a->__offset[0] = 0;
	a->__size[1] = 0;
	a->__offset[1] = 0;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_serialize_ArrayOfstring2D(struct soap *soap, struct ArrayOfstring2D const*a)
{
	int i;
	if (a->__ptr && !soap_array_reference(soap, a, (struct soap_array*)&a->__ptr, 2, SOAP_TYPE_ArrayOfstring2D))
		for (i = 0; i < soap_size(a->__size, 2); i++)
		{
			soap_serialize_xsd__string(soap, a->__ptr + i);
		}
}

SOAP_FMAC3 int SOAP_FMAC4 soap_put_ArrayOfstring2D(struct soap *soap, const struct ArrayOfstring2D *a, const char *tag, const char *type)
{
	register int id = soap_embed(soap, (void*)a, (struct soap_array*)&a->__ptr, 2, tag, SOAP_TYPE_ArrayOfstring2D);
	if (soap_out_ArrayOfstring2D(soap, tag, id, a, type))
		return soap->error;
	return soap_putindependent(soap);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out_ArrayOfstring2D(struct soap *soap, const char *tag, int id, const struct ArrayOfstring2D *a, const char *type)
{
	int i, n = soap_size(a->__size, 2);
	char *t = soap_putsizesoffsets(soap, "xsd:string", a->__size, a->__offset, 2);
	id = soap_element_id(soap, tag, id, a, (struct soap_array*)&a->__ptr, 2, type, SOAP_TYPE_ArrayOfstring2D);
	if (id < 0)
		return soap->error;
	if (soap_array_begin_out(soap, tag, id, t, soap_putoffsets(soap, a->__offset, 2)))
		return soap->error;
	for (i = 0; i < n; i++)
	{
		soap->position = 2;
		soap->positions[0] = i/a->__size[1]%a->__size[0];
		soap->positions[1] = i%a->__size[1];
		soap_out_xsd__string(soap, "item", -1, &a->__ptr[i], "");
	}
	soap->position = 0;
	return soap_element_end_out(soap, tag);
}

SOAP_FMAC3 struct ArrayOfstring2D * SOAP_FMAC4 soap_get_ArrayOfstring2D(struct soap *soap, struct ArrayOfstring2D *p, const char *tag, const char *type)
{
	if ((p = soap_in_ArrayOfstring2D(soap, tag, p, type)))
		if (soap_getindependent(soap))
			return NULL;
	return p;
}

SOAP_FMAC3 struct ArrayOfstring2D * SOAP_FMAC4 soap_in_ArrayOfstring2D(struct soap *soap, const char *tag, struct ArrayOfstring2D *a, const char *type)
{	int i, j, n;
	char **p;
	if (soap_element_begin_in(soap, tag, 1, NULL))
		return NULL;
	if (soap_match_array(soap, type))
	{	soap->error = SOAP_TYPE;
		return NULL;
	}
	a = (struct ArrayOfstring2D *)soap_id_enter(soap, soap->id, a, SOAP_TYPE_ArrayOfstring2D, sizeof(struct ArrayOfstring2D), 0, NULL, NULL, NULL);
	if (!a)
		return NULL;
	soap_default_ArrayOfstring2D(soap, a);
	if (soap->body && !*soap->href)
	{
		n = soap_getsizes(soap->arraySize, a->__size, 2);
		n -= j = soap_getoffsets(soap->arrayOffset, a->__size, a->__offset, 2);
		if (n >= 0)
		{	a->__ptr = (char **)soap_malloc(soap, n*sizeof(char *));
			for (i = 0; i < n; i++)
				a->__ptr[i] = NULL;
			for (i = 0; i < n; i++)
			{	soap_peek_element(soap);
				if (soap->position == 2)
				{	i = soap->positions[0]*a->__size[1]+soap->positions[1]-j;
					if (i < 0 || i >= n)
					{	soap->error = SOAP_IOB;
						return NULL;
					}
				}
				if (!soap_in_xsd__string(soap, NULL, a->__ptr + i, "xsd:string"))
				{	if (soap->error != SOAP_NO_TAG)
						return NULL;
					soap->error = SOAP_OK;
					break;
				}
			}
		}
		else
		{	soap_new_block(soap);
			for (a->__size[0] = 0; ; a->__size[0]++)
			{	p = (char **)soap_push_block(soap, sizeof(char *));
				if (!p)
					return NULL;
				*p = NULL;
				if (!soap_in_xsd__string(soap, NULL, p, "xsd:string"))
				{	if (soap->error != SOAP_NO_TAG)
						return NULL;
					soap->error = SOAP_OK;
					break;
				}
			}
			soap_pop_block(soap);
			a->__ptr = (char **)soap_malloc(soap, soap->blist->size);
			soap_save_block(soap, (char*)a->__ptr, 1);
		}
		if (soap_element_end_in(soap, tag))
			return NULL;
	}
	else
	{	a = (struct ArrayOfstring2D *)soap_id_forward(soap, soap->href, (void*)a, 0, SOAP_TYPE_ArrayOfstring2D, 0, sizeof(struct ArrayOfstring2D), 0, NULL);
		if (soap->body && soap_element_end_in(soap, tag))
			return NULL;
	}
	return a;
}

SOAP_FMAC5 struct ArrayOfstring2D * SOAP_FMAC6 soap_new_ArrayOfstring2D(struct soap *soap, int n)
{	return soap_instantiate_ArrayOfstring2D(soap, n, NULL, NULL, NULL);
}

SOAP_FMAC5 void SOAP_FMAC6 soap_delete_ArrayOfstring2D(struct soap *soap, struct ArrayOfstring2D *p)
{	soap_delete(soap, p);
}

SOAP_FMAC3 struct ArrayOfstring2D * SOAP_FMAC4 soap_instantiate_ArrayOfstring2D(struct soap *soap, int n, const char *type, const char *arrayType, size_t *size)
{
	DBGLOG(TEST, SOAP_MESSAGE(fdebug, "soap_instantiate_ArrayOfstring2D(%d, %s, %s)\n", n, type?type:"", arrayType?arrayType:""));
	struct soap_clist *cp = soap_link(soap, NULL, SOAP_TYPE_ArrayOfstring2D, n, soap_fdelete);
	if (!cp)
		return NULL;
	if (n < 0)
	{	cp->ptr = (void*)new struct ArrayOfstring2D;
		if (size)
			*size = sizeof(struct ArrayOfstring2D);
	}
	else
	{	cp->ptr = (void*)new struct ArrayOfstring2D[n];
		if (!cp->ptr)
		{	soap->error = SOAP_EOM;
			return NULL;
		}
		if (size)
			*size = n * sizeof(struct ArrayOfstring2D);
	}
		DBGLOG(TEST, SOAP_MESSAGE(fdebug, "Instantiated location=%p\n", cp->ptr));
	return (struct ArrayOfstring2D*)cp->ptr;
}
SOAP_FMAC3 void SOAP_FMAC4 soap_copy_ArrayOfstring2D(struct soap *soap, int st, int tt, void *p, size_t len, const void *q, size_t n)
{
	DBGLOG(TEST, SOAP_MESSAGE(fdebug, "Copying struct ArrayOfstring2D %p -> %p\n", q, p));
	*(struct ArrayOfstring2D*)p = *(struct ArrayOfstring2D*)q;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_default_ns__echoSimpleTypesAsStruct(struct soap *soap, struct ns__echoSimpleTypesAsStruct *a)
{
	(void)soap; (void)a; /* appease -Wall -Werror */
	soap_default_xsd__string(soap, &a->inputString);
	a->inputInteger = NULL;
	a->inputFloat = NULL;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_serialize_ns__echoSimpleTypesAsStruct(struct soap *soap, const struct ns__echoSimpleTypesAsStruct *a)
{
	(void)soap; (void)a; /* appease -Wall -Werror */
	soap_serialize_xsd__string(soap, &a->inputString);
	soap_serialize_PointerToxsd__int(soap, &a->inputInteger);
	soap_serialize_PointerToxsd__float(soap, &a->inputFloat);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_put_ns__echoSimpleTypesAsStruct(struct soap *soap, const struct ns__echoSimpleTypesAsStruct *a, const char *tag, const char *type)
{
	register int id = soap_embed(soap, (void*)a, NULL, 0, tag, SOAP_TYPE_ns__echoSimpleTypesAsStruct);
	if (soap_out_ns__echoSimpleTypesAsStruct(soap, tag, id, a, type))
		return soap->error;
	return soap_putindependent(soap);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out_ns__echoSimpleTypesAsStruct(struct soap *soap, const char *tag, int id, const struct ns__echoSimpleTypesAsStruct *a, const char *type)
{
	if (soap_element_begin_out(soap, tag, soap_embedded_id(soap, id, a, SOAP_TYPE_ns__echoSimpleTypesAsStruct), type))
		return soap->error;
	if (soap_out_xsd__string(soap, "inputString", -1, &a->inputString, ""))
		return soap->error;
	if (soap_out_PointerToxsd__int(soap, "inputInteger", -1, &a->inputInteger, ""))
		return soap->error;
	if (soap_out_PointerToxsd__float(soap, "inputFloat", -1, &a->inputFloat, ""))
		return soap->error;
	return soap_element_end_out(soap, tag);
}

SOAP_FMAC3 struct ns__echoSimpleTypesAsStruct * SOAP_FMAC4 soap_get_ns__echoSimpleTypesAsStruct(struct soap *soap, struct ns__echoSimpleTypesAsStruct *p, const char *tag, const char *type)
{
	if ((p = soap_in_ns__echoSimpleTypesAsStruct(soap, tag, p, type)))
		if (soap_getindependent(soap))
			return NULL;
	return p;
}

SOAP_FMAC3 struct ns__echoSimpleTypesAsStruct * SOAP_FMAC4 soap_in_ns__echoSimpleTypesAsStruct(struct soap *soap, const char *tag, struct ns__echoSimpleTypesAsStruct *a, const char *type)
{
	short soap_flag_inputString = 1, soap_flag_inputInteger = 1, soap_flag_inputFloat = 1;
	if (soap_element_begin_in(soap, tag, 0, type))
		return NULL;
	a = (struct ns__echoSimpleTypesAsStruct *)soap_id_enter(soap, soap->id, a, SOAP_TYPE_ns__echoSimpleTypesAsStruct, sizeof(struct ns__echoSimpleTypesAsStruct), 0, NULL, NULL, NULL);
	if (!a)
		return NULL;
	soap_default_ns__echoSimpleTypesAsStruct(soap, a);
	if (soap->body && !*soap->href)
	{
		for (;;)
		{	soap->error = SOAP_TAG_MISMATCH;
			if (soap_flag_inputString && (soap->error == SOAP_TAG_MISMATCH || soap->error == SOAP_NO_TAG))
				if (soap_in_xsd__string(soap, "inputString", &a->inputString, "xsd:string"))
				{	soap_flag_inputString--;
					continue;
				}
			if (soap_flag_inputInteger && soap->error == SOAP_TAG_MISMATCH)
				if (soap_in_PointerToxsd__int(soap, "inputInteger", &a->inputInteger, "xsd:int"))
				{	soap_flag_inputInteger--;
					continue;
				}
			if (soap_flag_inputFloat && soap->error == SOAP_TAG_MISMATCH)
				if (soap_in_PointerToxsd__float(soap, "inputFloat", &a->inputFloat, "xsd:float"))
				{	soap_flag_inputFloat--;
					continue;
				}
			if (soap->error == SOAP_TAG_MISMATCH)
				soap->error = soap_ignore_element(soap);
			if (soap->error == SOAP_NO_TAG)
				break;
			if (soap->error)
				return NULL;
		}
		if (soap_element_end_in(soap, tag))
			return NULL;
	}
	else
	{	a = (struct ns__echoSimpleTypesAsStruct *)soap_id_forward(soap, soap->href, (void*)a, 0, SOAP_TYPE_ns__echoSimpleTypesAsStruct, 0, sizeof(struct ns__echoSimpleTypesAsStruct), 0, NULL);
		if (soap->body && soap_element_end_in(soap, tag))
			return NULL;
	}
	return a;
}

SOAP_FMAC5 struct ns__echoSimpleTypesAsStruct * SOAP_FMAC6 soap_new_ns__echoSimpleTypesAsStruct(struct soap *soap, int n)
{	return soap_instantiate_ns__echoSimpleTypesAsStruct(soap, n, NULL, NULL, NULL);
}

SOAP_FMAC5 void SOAP_FMAC6 soap_delete_ns__echoSimpleTypesAsStruct(struct soap *soap, struct ns__echoSimpleTypesAsStruct *p)
{	soap_delete(soap, p);
}

SOAP_FMAC3 struct ns__echoSimpleTypesAsStruct * SOAP_FMAC4 soap_instantiate_ns__echoSimpleTypesAsStruct(struct soap *soap, int n, const char *type, const char *arrayType, size_t *size)
{
	DBGLOG(TEST, SOAP_MESSAGE(fdebug, "soap_instantiate_ns__echoSimpleTypesAsStruct(%d, %s, %s)\n", n, type?type:"", arrayType?arrayType:""));
	struct soap_clist *cp = soap_link(soap, NULL, SOAP_TYPE_ns__echoSimpleTypesAsStruct, n, soap_fdelete);
	if (!cp)
		return NULL;
	if (n < 0)
	{	cp->ptr = (void*)new struct ns__echoSimpleTypesAsStruct;
		if (size)
			*size = sizeof(struct ns__echoSimpleTypesAsStruct);
	}
	else
	{	cp->ptr = (void*)new struct ns__echoSimpleTypesAsStruct[n];
		if (!cp->ptr)
		{	soap->error = SOAP_EOM;
			return NULL;
		}
		if (size)
			*size = n * sizeof(struct ns__echoSimpleTypesAsStruct);
	}
		DBGLOG(TEST, SOAP_MESSAGE(fdebug, "Instantiated location=%p\n", cp->ptr));
	return (struct ns__echoSimpleTypesAsStruct*)cp->ptr;
}
SOAP_FMAC3 void SOAP_FMAC4 soap_copy_ns__echoSimpleTypesAsStruct(struct soap *soap, int st, int tt, void *p, size_t len, const void *q, size_t n)
{
	DBGLOG(TEST, SOAP_MESSAGE(fdebug, "Copying struct ns__echoSimpleTypesAsStruct %p -> %p\n", q, p));
	*(struct ns__echoSimpleTypesAsStruct*)p = *(struct ns__echoSimpleTypesAsStruct*)q;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_default_ns__echoSimpleTypesAsStructResponse(struct soap *soap, struct ns__echoSimpleTypesAsStructResponse *a)
{
	(void)soap; (void)a; /* appease -Wall -Werror */
	soap_default_s__SOAPStruct(soap, &a->_return);
}

SOAP_FMAC3 void SOAP_FMAC4 soap_serialize_ns__echoSimpleTypesAsStructResponse(struct soap *soap, const struct ns__echoSimpleTypesAsStructResponse *a)
{
	(void)soap; (void)a; /* appease -Wall -Werror */
	soap_embedded(soap, &a->_return, SOAP_TYPE_s__SOAPStruct);
	soap_serialize_s__SOAPStruct(soap, &a->_return);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_put_ns__echoSimpleTypesAsStructResponse(struct soap *soap, const struct ns__echoSimpleTypesAsStructResponse *a, const char *tag, const char *type)
{
	register int id = soap_embed(soap, (void*)a, NULL, 0, tag, SOAP_TYPE_ns__echoSimpleTypesAsStructResponse);
	if (soap_out_ns__echoSimpleTypesAsStructResponse(soap, tag, id, a, type))
		return soap->error;
	return soap_putindependent(soap);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out_ns__echoSimpleTypesAsStructResponse(struct soap *soap, const char *tag, int id, const struct ns__echoSimpleTypesAsStructResponse *a, const char *type)
{
	if (soap_element_begin_out(soap, tag, soap_embedded_id(soap, id, a, SOAP_TYPE_ns__echoSimpleTypesAsStructResponse), type))
		return soap->error;
	if (soap_out_s__SOAPStruct(soap, "return", -1, &a->_return, ""))
		return soap->error;
	return soap_element_end_out(soap, tag);
}

SOAP_FMAC3 struct ns__echoSimpleTypesAsStructResponse * SOAP_FMAC4 soap_get_ns__echoSimpleTypesAsStructResponse(struct soap *soap, struct ns__echoSimpleTypesAsStructResponse *p, const char *tag, const char *type)
{
	if ((p = soap_in_ns__echoSimpleTypesAsStructResponse(soap, tag, p, type)))
		if (soap_getindependent(soap))
			return NULL;
	return p;
}

SOAP_FMAC3 struct ns__echoSimpleTypesAsStructResponse * SOAP_FMAC4 soap_in_ns__echoSimpleTypesAsStructResponse(struct soap *soap, const char *tag, struct ns__echoSimpleTypesAsStructResponse *a, const char *type)
{
	short soap_flag__return = 1;
	if (soap_element_begin_in(soap, tag, 0, type))
		return NULL;
	a = (struct ns__echoSimpleTypesAsStructResponse *)soap_id_enter(soap, soap->id, a, SOAP_TYPE_ns__echoSimpleTypesAsStructResponse, sizeof(struct ns__echoSimpleTypesAsStructResponse), 0, NULL, NULL, NULL);
	if (!a)
		return NULL;
	soap_default_ns__echoSimpleTypesAsStructResponse(soap, a);
	if (soap->body && !*soap->href)
	{
		for (;;)
		{	soap->error = SOAP_TAG_MISMATCH;
			if (soap_flag__return && soap->error == SOAP_TAG_MISMATCH)
				if (soap_in_s__SOAPStruct(soap, NULL, &a->_return, "s:SOAPStruct"))
				{	soap_flag__return--;
					continue;
				}
			if (soap->error == SOAP_TAG_MISMATCH)
				soap->error = soap_ignore_element(soap);
			if (soap->error == SOAP_NO_TAG)
				break;
			if (soap->error)
				return NULL;
		}
		if (soap_element_end_in(soap, tag))
			return NULL;
	}
	else
	{	a = (struct ns__echoSimpleTypesAsStructResponse *)soap_id_forward(soap, soap->href, (void*)a, 0, SOAP_TYPE_ns__echoSimpleTypesAsStructResponse, 0, sizeof(struct ns__echoSimpleTypesAsStructResponse), 0, NULL);
		if (soap->body && soap_element_end_in(soap, tag))
			return NULL;
	}
	if ((soap->mode & SOAP_XML_STRICT) && (soap_flag__return > 0))
	{	soap->error = SOAP_OCCURS;
		return NULL;
	}
	return a;
}

SOAP_FMAC5 struct ns__echoSimpleTypesAsStructResponse * SOAP_FMAC6 soap_new_ns__echoSimpleTypesAsStructResponse(struct soap *soap, int n)
{	return soap_instantiate_ns__echoSimpleTypesAsStructResponse(soap, n, NULL, NULL, NULL);
}

SOAP_FMAC5 void SOAP_FMAC6 soap_delete_ns__echoSimpleTypesAsStructResponse(struct soap *soap, struct ns__echoSimpleTypesAsStructResponse *p)
{	soap_delete(soap, p);
}

SOAP_FMAC3 struct ns__echoSimpleTypesAsStructResponse * SOAP_FMAC4 soap_instantiate_ns__echoSimpleTypesAsStructResponse(struct soap *soap, int n, const char *type, const char *arrayType, size_t *size)
{
	DBGLOG(TEST, SOAP_MESSAGE(fdebug, "soap_instantiate_ns__echoSimpleTypesAsStructResponse(%d, %s, %s)\n", n, type?type:"", arrayType?arrayType:""));
	struct soap_clist *cp = soap_link(soap, NULL, SOAP_TYPE_ns__echoSimpleTypesAsStructResponse, n, soap_fdelete);
	if (!cp)
		return NULL;
	if (n < 0)
	{	cp->ptr = (void*)new struct ns__echoSimpleTypesAsStructResponse;
		if (size)
			*size = sizeof(struct ns__echoSimpleTypesAsStructResponse);
	}
	else
	{	cp->ptr = (void*)new struct ns__echoSimpleTypesAsStructResponse[n];
		if (!cp->ptr)
		{	soap->error = SOAP_EOM;
			return NULL;
		}
		if (size)
			*size = n * sizeof(struct ns__echoSimpleTypesAsStructResponse);
	}
		DBGLOG(TEST, SOAP_MESSAGE(fdebug, "Instantiated location=%p\n", cp->ptr));
	return (struct ns__echoSimpleTypesAsStructResponse*)cp->ptr;
}
SOAP_FMAC3 void SOAP_FMAC4 soap_copy_ns__echoSimpleTypesAsStructResponse(struct soap *soap, int st, int tt, void *p, size_t len, const void *q, size_t n)
{
	DBGLOG(TEST, SOAP_MESSAGE(fdebug, "Copying struct ns__echoSimpleTypesAsStructResponse %p -> %p\n", q, p));
	*(struct ns__echoSimpleTypesAsStructResponse*)p = *(struct ns__echoSimpleTypesAsStructResponse*)q;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_default_ns__echoStructAsSimpleTypes(struct soap *soap, struct ns__echoStructAsSimpleTypes *a)
{
	(void)soap; (void)a; /* appease -Wall -Werror */
	soap_default_s__SOAPStruct(soap, &a->_inputStruct);
}

SOAP_FMAC3 void SOAP_FMAC4 soap_serialize_ns__echoStructAsSimpleTypes(struct soap *soap, const struct ns__echoStructAsSimpleTypes *a)
{
	(void)soap; (void)a; /* appease -Wall -Werror */
	soap_embedded(soap, &a->_inputStruct, SOAP_TYPE_s__SOAPStruct);
	soap_serialize_s__SOAPStruct(soap, &a->_inputStruct);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_put_ns__echoStructAsSimpleTypes(struct soap *soap, const struct ns__echoStructAsSimpleTypes *a, const char *tag, const char *type)
{
	register int id = soap_embed(soap, (void*)a, NULL, 0, tag, SOAP_TYPE_ns__echoStructAsSimpleTypes);
	if (soap_out_ns__echoStructAsSimpleTypes(soap, tag, id, a, type))
		return soap->error;
	return soap_putindependent(soap);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out_ns__echoStructAsSimpleTypes(struct soap *soap, const char *tag, int id, const struct ns__echoStructAsSimpleTypes *a, const char *type)
{
	if (soap_element_begin_out(soap, tag, soap_embedded_id(soap, id, a, SOAP_TYPE_ns__echoStructAsSimpleTypes), type))
		return soap->error;
	if (soap_out_s__SOAPStruct(soap, "inputStruct", -1, &a->_inputStruct, ""))
		return soap->error;
	return soap_element_end_out(soap, tag);
}

SOAP_FMAC3 struct ns__echoStructAsSimpleTypes * SOAP_FMAC4 soap_get_ns__echoStructAsSimpleTypes(struct soap *soap, struct ns__echoStructAsSimpleTypes *p, const char *tag, const char *type)
{
	if ((p = soap_in_ns__echoStructAsSimpleTypes(soap, tag, p, type)))
		if (soap_getindependent(soap))
			return NULL;
	return p;
}

SOAP_FMAC3 struct ns__echoStructAsSimpleTypes * SOAP_FMAC4 soap_in_ns__echoStructAsSimpleTypes(struct soap *soap, const char *tag, struct ns__echoStructAsSimpleTypes *a, const char *type)
{
	short soap_flag__inputStruct = 1;
	if (soap_element_begin_in(soap, tag, 0, type))
		return NULL;
	a = (struct ns__echoStructAsSimpleTypes *)soap_id_enter(soap, soap->id, a, SOAP_TYPE_ns__echoStructAsSimpleTypes, sizeof(struct ns__echoStructAsSimpleTypes), 0, NULL, NULL, NULL);
	if (!a)
		return NULL;
	soap_default_ns__echoStructAsSimpleTypes(soap, a);
	if (soap->body && !*soap->href)
	{
		for (;;)
		{	soap->error = SOAP_TAG_MISMATCH;
			if (soap_flag__inputStruct && soap->error == SOAP_TAG_MISMATCH)
				if (soap_in_s__SOAPStruct(soap, NULL, &a->_inputStruct, "s:SOAPStruct"))
				{	soap_flag__inputStruct--;
					continue;
				}
			if (soap->error == SOAP_TAG_MISMATCH)
				soap->error = soap_ignore_element(soap);
			if (soap->error == SOAP_NO_TAG)
				break;
			if (soap->error)
				return NULL;
		}
		if (soap_element_end_in(soap, tag))
			return NULL;
	}
	else
	{	a = (struct ns__echoStructAsSimpleTypes *)soap_id_forward(soap, soap->href, (void*)a, 0, SOAP_TYPE_ns__echoStructAsSimpleTypes, 0, sizeof(struct ns__echoStructAsSimpleTypes), 0, NULL);
		if (soap->body && soap_element_end_in(soap, tag))
			return NULL;
	}
	if ((soap->mode & SOAP_XML_STRICT) && (soap_flag__inputStruct > 0))
	{	soap->error = SOAP_OCCURS;
		return NULL;
	}
	return a;
}

SOAP_FMAC5 struct ns__echoStructAsSimpleTypes * SOAP_FMAC6 soap_new_ns__echoStructAsSimpleTypes(struct soap *soap, int n)
{	return soap_instantiate_ns__echoStructAsSimpleTypes(soap, n, NULL, NULL, NULL);
}

SOAP_FMAC5 void SOAP_FMAC6 soap_delete_ns__echoStructAsSimpleTypes(struct soap *soap, struct ns__echoStructAsSimpleTypes *p)
{	soap_delete(soap, p);
}

SOAP_FMAC3 struct ns__echoStructAsSimpleTypes * SOAP_FMAC4 soap_instantiate_ns__echoStructAsSimpleTypes(struct soap *soap, int n, const char *type, const char *arrayType, size_t *size)
{
	DBGLOG(TEST, SOAP_MESSAGE(fdebug, "soap_instantiate_ns__echoStructAsSimpleTypes(%d, %s, %s)\n", n, type?type:"", arrayType?arrayType:""));
	struct soap_clist *cp = soap_link(soap, NULL, SOAP_TYPE_ns__echoStructAsSimpleTypes, n, soap_fdelete);
	if (!cp)
		return NULL;
	if (n < 0)
	{	cp->ptr = (void*)new struct ns__echoStructAsSimpleTypes;
		if (size)
			*size = sizeof(struct ns__echoStructAsSimpleTypes);
	}
	else
	{	cp->ptr = (void*)new struct ns__echoStructAsSimpleTypes[n];
		if (!cp->ptr)
		{	soap->error = SOAP_EOM;
			return NULL;
		}
		if (size)
			*size = n * sizeof(struct ns__echoStructAsSimpleTypes);
	}
		DBGLOG(TEST, SOAP_MESSAGE(fdebug, "Instantiated location=%p\n", cp->ptr));
	return (struct ns__echoStructAsSimpleTypes*)cp->ptr;
}
SOAP_FMAC3 void SOAP_FMAC4 soap_copy_ns__echoStructAsSimpleTypes(struct soap *soap, int st, int tt, void *p, size_t len, const void *q, size_t n)
{
	DBGLOG(TEST, SOAP_MESSAGE(fdebug, "Copying struct ns__echoStructAsSimpleTypes %p -> %p\n", q, p));
	*(struct ns__echoStructAsSimpleTypes*)p = *(struct ns__echoStructAsSimpleTypes*)q;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_default_ns__echoStructAsSimpleTypesResponse(struct soap *soap, struct ns__echoStructAsSimpleTypesResponse *a)
{
	(void)soap; (void)a; /* appease -Wall -Werror */
	soap_default_xsd__string(soap, &a->_outputString);
	a->_outputInteger = NULL;
	a->_outputFloat = NULL;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_serialize_ns__echoStructAsSimpleTypesResponse(struct soap *soap, const struct ns__echoStructAsSimpleTypesResponse *a)
{
	(void)soap; (void)a; /* appease -Wall -Werror */
	soap_serialize_xsd__string(soap, &a->_outputString);
	soap_serialize_PointerToxsd__int(soap, &a->_outputInteger);
	soap_serialize_PointerToxsd__float(soap, &a->_outputFloat);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_put_ns__echoStructAsSimpleTypesResponse(struct soap *soap, const struct ns__echoStructAsSimpleTypesResponse *a, const char *tag, const char *type)
{
	register int id = soap_embed(soap, (void*)a, NULL, 0, tag, SOAP_TYPE_ns__echoStructAsSimpleTypesResponse);
	if (soap_out_ns__echoStructAsSimpleTypesResponse(soap, tag, id, a, type))
		return soap->error;
	return soap_putindependent(soap);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out_ns__echoStructAsSimpleTypesResponse(struct soap *soap, const char *tag, int id, const struct ns__echoStructAsSimpleTypesResponse *a, const char *type)
{
	if (soap_element_begin_out(soap, tag, soap_embedded_id(soap, id, a, SOAP_TYPE_ns__echoStructAsSimpleTypesResponse), type))
		return soap->error;
	if (soap_out_xsd__string(soap, "outputString", -1, &a->_outputString, ""))
		return soap->error;
	if (soap_out_PointerToxsd__int(soap, "outputInteger", -1, &a->_outputInteger, ""))
		return soap->error;
	if (soap_out_PointerToxsd__float(soap, "outputFloat", -1, &a->_outputFloat, ""))
		return soap->error;
	return soap_element_end_out(soap, tag);
}

SOAP_FMAC3 struct ns__echoStructAsSimpleTypesResponse * SOAP_FMAC4 soap_get_ns__echoStructAsSimpleTypesResponse(struct soap *soap, struct ns__echoStructAsSimpleTypesResponse *p, const char *tag, const char *type)
{
	if ((p = soap_in_ns__echoStructAsSimpleTypesResponse(soap, tag, p, type)))
		if (soap_getindependent(soap))
			return NULL;
	return p;
}

SOAP_FMAC3 struct ns__echoStructAsSimpleTypesResponse * SOAP_FMAC4 soap_in_ns__echoStructAsSimpleTypesResponse(struct soap *soap, const char *tag, struct ns__echoStructAsSimpleTypesResponse *a, const char *type)
{
	short soap_flag__outputString = 1, soap_flag__outputInteger = 1, soap_flag__outputFloat = 1;
	if (soap_element_begin_in(soap, tag, 0, type))
		return NULL;
	a = (struct ns__echoStructAsSimpleTypesResponse *)soap_id_enter(soap, soap->id, a, SOAP_TYPE_ns__echoStructAsSimpleTypesResponse, sizeof(struct ns__echoStructAsSimpleTypesResponse), 0, NULL, NULL, NULL);
	if (!a)
		return NULL;
	soap_default_ns__echoStructAsSimpleTypesResponse(soap, a);
	if (soap->body && !*soap->href)
	{
		for (;;)
		{	soap->error = SOAP_TAG_MISMATCH;
			if (soap_flag__outputString && (soap->error == SOAP_TAG_MISMATCH || soap->error == SOAP_NO_TAG))
				if (soap_in_xsd__string(soap, NULL, &a->_outputString, "xsd:string"))
				{	soap_flag__outputString--;
					continue;
				}
			if (soap_flag__outputInteger && soap->error == SOAP_TAG_MISMATCH)
				if (soap_in_PointerToxsd__int(soap, NULL, &a->_outputInteger, "xsd:int"))
				{	soap_flag__outputInteger--;
					continue;
				}
			if (soap_flag__outputFloat && soap->error == SOAP_TAG_MISMATCH)
				if (soap_in_PointerToxsd__float(soap, NULL, &a->_outputFloat, "xsd:float"))
				{	soap_flag__outputFloat--;
					continue;
				}
			if (soap->error == SOAP_TAG_MISMATCH)
				soap->error = soap_ignore_element(soap);
			if (soap->error == SOAP_NO_TAG)
				break;
			if (soap->error)
				return NULL;
		}
		if (soap_element_end_in(soap, tag))
			return NULL;
	}
	else
	{	a = (struct ns__echoStructAsSimpleTypesResponse *)soap_id_forward(soap, soap->href, (void*)a, 0, SOAP_TYPE_ns__echoStructAsSimpleTypesResponse, 0, sizeof(struct ns__echoStructAsSimpleTypesResponse), 0, NULL);
		if (soap->body && soap_element_end_in(soap, tag))
			return NULL;
	}
	return a;
}

SOAP_FMAC5 struct ns__echoStructAsSimpleTypesResponse * SOAP_FMAC6 soap_new_ns__echoStructAsSimpleTypesResponse(struct soap *soap, int n)
{	return soap_instantiate_ns__echoStructAsSimpleTypesResponse(soap, n, NULL, NULL, NULL);
}

SOAP_FMAC5 void SOAP_FMAC6 soap_delete_ns__echoStructAsSimpleTypesResponse(struct soap *soap, struct ns__echoStructAsSimpleTypesResponse *p)
{	soap_delete(soap, p);
}

SOAP_FMAC3 struct ns__echoStructAsSimpleTypesResponse * SOAP_FMAC4 soap_instantiate_ns__echoStructAsSimpleTypesResponse(struct soap *soap, int n, const char *type, const char *arrayType, size_t *size)
{
	DBGLOG(TEST, SOAP_MESSAGE(fdebug, "soap_instantiate_ns__echoStructAsSimpleTypesResponse(%d, %s, %s)\n", n, type?type:"", arrayType?arrayType:""));
	struct soap_clist *cp = soap_link(soap, NULL, SOAP_TYPE_ns__echoStructAsSimpleTypesResponse, n, soap_fdelete);
	if (!cp)
		return NULL;
	if (n < 0)
	{	cp->ptr = (void*)new struct ns__echoStructAsSimpleTypesResponse;
		if (size)
			*size = sizeof(struct ns__echoStructAsSimpleTypesResponse);
	}
	else
	{	cp->ptr = (void*)new struct ns__echoStructAsSimpleTypesResponse[n];
		if (!cp->ptr)
		{	soap->error = SOAP_EOM;
			return NULL;
		}
		if (size)
			*size = n * sizeof(struct ns__echoStructAsSimpleTypesResponse);
	}
		DBGLOG(TEST, SOAP_MESSAGE(fdebug, "Instantiated location=%p\n", cp->ptr));
	return (struct ns__echoStructAsSimpleTypesResponse*)cp->ptr;
}
SOAP_FMAC3 void SOAP_FMAC4 soap_copy_ns__echoStructAsSimpleTypesResponse(struct soap *soap, int st, int tt, void *p, size_t len, const void *q, size_t n)
{
	DBGLOG(TEST, SOAP_MESSAGE(fdebug, "Copying struct ns__echoStructAsSimpleTypesResponse %p -> %p\n", q, p));
	*(struct ns__echoStructAsSimpleTypesResponse*)p = *(struct ns__echoStructAsSimpleTypesResponse*)q;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_default_ns__echoBoolean(struct soap *soap, struct ns__echoBoolean *a)
{
	(void)soap; (void)a; /* appease -Wall -Werror */
	soap_default_xsd__boolean(soap, &a->inputBoolean);
}

SOAP_FMAC3 void SOAP_FMAC4 soap_serialize_ns__echoBoolean(struct soap *soap, const struct ns__echoBoolean *a)
{
	(void)soap; (void)a; /* appease -Wall -Werror */
}

SOAP_FMAC3 int SOAP_FMAC4 soap_put_ns__echoBoolean(struct soap *soap, const struct ns__echoBoolean *a, const char *tag, const char *type)
{
	register int id = soap_embed(soap, (void*)a, NULL, 0, tag, SOAP_TYPE_ns__echoBoolean);
	if (soap_out_ns__echoBoolean(soap, tag, id, a, type))
		return soap->error;
	return soap_putindependent(soap);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out_ns__echoBoolean(struct soap *soap, const char *tag, int id, const struct ns__echoBoolean *a, const char *type)
{
	if (soap_element_begin_out(soap, tag, soap_embedded_id(soap, id, a, SOAP_TYPE_ns__echoBoolean), type))
		return soap->error;
	if (soap_out_xsd__boolean(soap, "inputBoolean", -1, &a->inputBoolean, ""))
		return soap->error;
	return soap_element_end_out(soap, tag);
}

SOAP_FMAC3 struct ns__echoBoolean * SOAP_FMAC4 soap_get_ns__echoBoolean(struct soap *soap, struct ns__echoBoolean *p, const char *tag, const char *type)
{
	if ((p = soap_in_ns__echoBoolean(soap, tag, p, type)))
		if (soap_getindependent(soap))
			return NULL;
	return p;
}

SOAP_FMAC3 struct ns__echoBoolean * SOAP_FMAC4 soap_in_ns__echoBoolean(struct soap *soap, const char *tag, struct ns__echoBoolean *a, const char *type)
{
	short soap_flag_inputBoolean = 1;
	if (soap_element_begin_in(soap, tag, 0, type))
		return NULL;
	a = (struct ns__echoBoolean *)soap_id_enter(soap, soap->id, a, SOAP_TYPE_ns__echoBoolean, sizeof(struct ns__echoBoolean), 0, NULL, NULL, NULL);
	if (!a)
		return NULL;
	soap_default_ns__echoBoolean(soap, a);
	if (soap->body && !*soap->href)
	{
		for (;;)
		{	soap->error = SOAP_TAG_MISMATCH;
			if (soap_flag_inputBoolean && soap->error == SOAP_TAG_MISMATCH)
				if (soap_in_xsd__boolean(soap, "inputBoolean", &a->inputBoolean, "xsd:boolean"))
				{	soap_flag_inputBoolean--;
					continue;
				}
			if (soap->error == SOAP_TAG_MISMATCH)
				soap->error = soap_ignore_element(soap);
			if (soap->error == SOAP_NO_TAG)
				break;
			if (soap->error)
				return NULL;
		}
		if (soap_element_end_in(soap, tag))
			return NULL;
	}
	else
	{	a = (struct ns__echoBoolean *)soap_id_forward(soap, soap->href, (void*)a, 0, SOAP_TYPE_ns__echoBoolean, 0, sizeof(struct ns__echoBoolean), 0, NULL);
		if (soap->body && soap_element_end_in(soap, tag))
			return NULL;
	}
	if ((soap->mode & SOAP_XML_STRICT) && (soap_flag_inputBoolean > 0))
	{	soap->error = SOAP_OCCURS;
		return NULL;
	}
	return a;
}

SOAP_FMAC5 struct ns__echoBoolean * SOAP_FMAC6 soap_new_ns__echoBoolean(struct soap *soap, int n)
{	return soap_instantiate_ns__echoBoolean(soap, n, NULL, NULL, NULL);
}

SOAP_FMAC5 void SOAP_FMAC6 soap_delete_ns__echoBoolean(struct soap *soap, struct ns__echoBoolean *p)
{	soap_delete(soap, p);
}

SOAP_FMAC3 struct ns__echoBoolean * SOAP_FMAC4 soap_instantiate_ns__echoBoolean(struct soap *soap, int n, const char *type, const char *arrayType, size_t *size)
{
	DBGLOG(TEST, SOAP_MESSAGE(fdebug, "soap_instantiate_ns__echoBoolean(%d, %s, %s)\n", n, type?type:"", arrayType?arrayType:""));
	struct soap_clist *cp = soap_link(soap, NULL, SOAP_TYPE_ns__echoBoolean, n, soap_fdelete);
	if (!cp)
		return NULL;
	if (n < 0)
	{	cp->ptr = (void*)new struct ns__echoBoolean;
		if (size)
			*size = sizeof(struct ns__echoBoolean);
	}
	else
	{	cp->ptr = (void*)new struct ns__echoBoolean[n];
		if (!cp->ptr)
		{	soap->error = SOAP_EOM;
			return NULL;
		}
		if (size)
			*size = n * sizeof(struct ns__echoBoolean);
	}
		DBGLOG(TEST, SOAP_MESSAGE(fdebug, "Instantiated location=%p\n", cp->ptr));
	return (struct ns__echoBoolean*)cp->ptr;
}
SOAP_FMAC3 void SOAP_FMAC4 soap_copy_ns__echoBoolean(struct soap *soap, int st, int tt, void *p, size_t len, const void *q, size_t n)
{
	DBGLOG(TEST, SOAP_MESSAGE(fdebug, "Copying struct ns__echoBoolean %p -> %p\n", q, p));
	*(struct ns__echoBoolean*)p = *(struct ns__echoBoolean*)q;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_default_ns__echoBooleanResponse(struct soap *soap, struct ns__echoBooleanResponse *a)
{
	(void)soap; (void)a; /* appease -Wall -Werror */
	soap_default_xsd__boolean(soap, &a->_return);
}

SOAP_FMAC3 void SOAP_FMAC4 soap_serialize_ns__echoBooleanResponse(struct soap *soap, const struct ns__echoBooleanResponse *a)
{
	(void)soap; (void)a; /* appease -Wall -Werror */
}

SOAP_FMAC3 int SOAP_FMAC4 soap_put_ns__echoBooleanResponse(struct soap *soap, const struct ns__echoBooleanResponse *a, const char *tag, const char *type)
{
	register int id = soap_embed(soap, (void*)a, NULL, 0, tag, SOAP_TYPE_ns__echoBooleanResponse);
	if (soap_out_ns__echoBooleanResponse(soap, tag, id, a, type))
		return soap->error;
	return soap_putindependent(soap);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out_ns__echoBooleanResponse(struct soap *soap, const char *tag, int id, const struct ns__echoBooleanResponse *a, const char *type)
{
	if (soap_element_begin_out(soap, tag, soap_embedded_id(soap, id, a, SOAP_TYPE_ns__echoBooleanResponse), type))
		return soap->error;
	if (soap_out_xsd__boolean(soap, "return", -1, &a->_return, ""))
		return soap->error;
	return soap_element_end_out(soap, tag);
}

SOAP_FMAC3 struct ns__echoBooleanResponse * SOAP_FMAC4 soap_get_ns__echoBooleanResponse(struct soap *soap, struct ns__echoBooleanResponse *p, const char *tag, const char *type)
{
	if ((p = soap_in_ns__echoBooleanResponse(soap, tag, p, type)))
		if (soap_getindependent(soap))
			return NULL;
	return p;
}

SOAP_FMAC3 struct ns__echoBooleanResponse * SOAP_FMAC4 soap_in_ns__echoBooleanResponse(struct soap *soap, const char *tag, struct ns__echoBooleanResponse *a, const char *type)
{
	short soap_flag__return = 1;
	if (soap_element_begin_in(soap, tag, 0, type))
		return NULL;
	a = (struct ns__echoBooleanResponse *)soap_id_enter(soap, soap->id, a, SOAP_TYPE_ns__echoBooleanResponse, sizeof(struct ns__echoBooleanResponse), 0, NULL, NULL, NULL);
	if (!a)
		return NULL;
	soap_default_ns__echoBooleanResponse(soap, a);
	if (soap->body && !*soap->href)
	{
		for (;;)
		{	soap->error = SOAP_TAG_MISMATCH;
			if (soap_flag__return && soap->error == SOAP_TAG_MISMATCH)
				if (soap_in_xsd__boolean(soap, NULL, &a->_return, "xsd:boolean"))
				{	soap_flag__return--;
					continue;
				}
			if (soap->error == SOAP_TAG_MISMATCH)
				soap->error = soap_ignore_element(soap);
			if (soap->error == SOAP_NO_TAG)
				break;
			if (soap->error)
				return NULL;
		}
		if (soap_element_end_in(soap, tag))
			return NULL;
	}
	else
	{	a = (struct ns__echoBooleanResponse *)soap_id_forward(soap, soap->href, (void*)a, 0, SOAP_TYPE_ns__echoBooleanResponse, 0, sizeof(struct ns__echoBooleanResponse), 0, NULL);
		if (soap->body && soap_element_end_in(soap, tag))
			return NULL;
	}
	if ((soap->mode & SOAP_XML_STRICT) && (soap_flag__return > 0))
	{	soap->error = SOAP_OCCURS;
		return NULL;
	}
	return a;
}

SOAP_FMAC5 struct ns__echoBooleanResponse * SOAP_FMAC6 soap_new_ns__echoBooleanResponse(struct soap *soap, int n)
{	return soap_instantiate_ns__echoBooleanResponse(soap, n, NULL, NULL, NULL);
}

SOAP_FMAC5 void SOAP_FMAC6 soap_delete_ns__echoBooleanResponse(struct soap *soap, struct ns__echoBooleanResponse *p)
{	soap_delete(soap, p);
}

SOAP_FMAC3 struct ns__echoBooleanResponse * SOAP_FMAC4 soap_instantiate_ns__echoBooleanResponse(struct soap *soap, int n, const char *type, const char *arrayType, size_t *size)
{
	DBGLOG(TEST, SOAP_MESSAGE(fdebug, "soap_instantiate_ns__echoBooleanResponse(%d, %s, %s)\n", n, type?type:"", arrayType?arrayType:""));
	struct soap_clist *cp = soap_link(soap, NULL, SOAP_TYPE_ns__echoBooleanResponse, n, soap_fdelete);
	if (!cp)
		return NULL;
	if (n < 0)
	{	cp->ptr = (void*)new struct ns__echoBooleanResponse;
		if (size)
			*size = sizeof(struct ns__echoBooleanResponse);
	}
	else
	{	cp->ptr = (void*)new struct ns__echoBooleanResponse[n];
		if (!cp->ptr)
		{	soap->error = SOAP_EOM;
			return NULL;
		}
		if (size)
			*size = n * sizeof(struct ns__echoBooleanResponse);
	}
		DBGLOG(TEST, SOAP_MESSAGE(fdebug, "Instantiated location=%p\n", cp->ptr));
	return (struct ns__echoBooleanResponse*)cp->ptr;
}
SOAP_FMAC3 void SOAP_FMAC4 soap_copy_ns__echoBooleanResponse(struct soap *soap, int st, int tt, void *p, size_t len, const void *q, size_t n)
{
	DBGLOG(TEST, SOAP_MESSAGE(fdebug, "Copying struct ns__echoBooleanResponse %p -> %p\n", q, p));
	*(struct ns__echoBooleanResponse*)p = *(struct ns__echoBooleanResponse*)q;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_default_ns__echoDecimal(struct soap *soap, struct ns__echoDecimal *a)
{
	(void)soap; (void)a; /* appease -Wall -Werror */
	soap_default_xsd__decimal(soap, &a->inputDecimal);
}

SOAP_FMAC3 void SOAP_FMAC4 soap_serialize_ns__echoDecimal(struct soap *soap, const struct ns__echoDecimal *a)
{
	(void)soap; (void)a; /* appease -Wall -Werror */
	soap_serialize_xsd__decimal(soap, &a->inputDecimal);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_put_ns__echoDecimal(struct soap *soap, const struct ns__echoDecimal *a, const char *tag, const char *type)
{
	register int id = soap_embed(soap, (void*)a, NULL, 0, tag, SOAP_TYPE_ns__echoDecimal);
	if (soap_out_ns__echoDecimal(soap, tag, id, a, type))
		return soap->error;
	return soap_putindependent(soap);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out_ns__echoDecimal(struct soap *soap, const char *tag, int id, const struct ns__echoDecimal *a, const char *type)
{
	if (soap_element_begin_out(soap, tag, soap_embedded_id(soap, id, a, SOAP_TYPE_ns__echoDecimal), type))
		return soap->error;
	if (soap_out_xsd__decimal(soap, "inputDecimal", -1, &a->inputDecimal, ""))
		return soap->error;
	return soap_element_end_out(soap, tag);
}

SOAP_FMAC3 struct ns__echoDecimal * SOAP_FMAC4 soap_get_ns__echoDecimal(struct soap *soap, struct ns__echoDecimal *p, const char *tag, const char *type)
{
	if ((p = soap_in_ns__echoDecimal(soap, tag, p, type)))
		if (soap_getindependent(soap))
			return NULL;
	return p;
}

SOAP_FMAC3 struct ns__echoDecimal * SOAP_FMAC4 soap_in_ns__echoDecimal(struct soap *soap, const char *tag, struct ns__echoDecimal *a, const char *type)
{
	short soap_flag_inputDecimal = 1;
	if (soap_element_begin_in(soap, tag, 0, type))
		return NULL;
	a = (struct ns__echoDecimal *)soap_id_enter(soap, soap->id, a, SOAP_TYPE_ns__echoDecimal, sizeof(struct ns__echoDecimal), 0, NULL, NULL, NULL);
	if (!a)
		return NULL;
	soap_default_ns__echoDecimal(soap, a);
	if (soap->body && !*soap->href)
	{
		for (;;)
		{	soap->error = SOAP_TAG_MISMATCH;
			if (soap_flag_inputDecimal && (soap->error == SOAP_TAG_MISMATCH || soap->error == SOAP_NO_TAG))
				if (soap_in_xsd__decimal(soap, "inputDecimal", &a->inputDecimal, "xsd:decimal"))
				{	soap_flag_inputDecimal--;
					continue;
				}
			if (soap->error == SOAP_TAG_MISMATCH)
				soap->error = soap_ignore_element(soap);
			if (soap->error == SOAP_NO_TAG)
				break;
			if (soap->error)
				return NULL;
		}
		if (soap_element_end_in(soap, tag))
			return NULL;
	}
	else
	{	a = (struct ns__echoDecimal *)soap_id_forward(soap, soap->href, (void*)a, 0, SOAP_TYPE_ns__echoDecimal, 0, sizeof(struct ns__echoDecimal), 0, NULL);
		if (soap->body && soap_element_end_in(soap, tag))
			return NULL;
	}
	return a;
}

SOAP_FMAC5 struct ns__echoDecimal * SOAP_FMAC6 soap_new_ns__echoDecimal(struct soap *soap, int n)
{	return soap_instantiate_ns__echoDecimal(soap, n, NULL, NULL, NULL);
}

SOAP_FMAC5 void SOAP_FMAC6 soap_delete_ns__echoDecimal(struct soap *soap, struct ns__echoDecimal *p)
{	soap_delete(soap, p);
}

SOAP_FMAC3 struct ns__echoDecimal * SOAP_FMAC4 soap_instantiate_ns__echoDecimal(struct soap *soap, int n, const char *type, const char *arrayType, size_t *size)
{
	DBGLOG(TEST, SOAP_MESSAGE(fdebug, "soap_instantiate_ns__echoDecimal(%d, %s, %s)\n", n, type?type:"", arrayType?arrayType:""));
	struct soap_clist *cp = soap_link(soap, NULL, SOAP_TYPE_ns__echoDecimal, n, soap_fdelete);
	if (!cp)
		return NULL;
	if (n < 0)
	{	cp->ptr = (void*)new struct ns__echoDecimal;
		if (size)
			*size = sizeof(struct ns__echoDecimal);
	}
	else
	{	cp->ptr = (void*)new struct ns__echoDecimal[n];
		if (!cp->ptr)
		{	soap->error = SOAP_EOM;
			return NULL;
		}
		if (size)
			*size = n * sizeof(struct ns__echoDecimal);
	}
		DBGLOG(TEST, SOAP_MESSAGE(fdebug, "Instantiated location=%p\n", cp->ptr));
	return (struct ns__echoDecimal*)cp->ptr;
}
SOAP_FMAC3 void SOAP_FMAC4 soap_copy_ns__echoDecimal(struct soap *soap, int st, int tt, void *p, size_t len, const void *q, size_t n)
{
	DBGLOG(TEST, SOAP_MESSAGE(fdebug, "Copying struct ns__echoDecimal %p -> %p\n", q, p));
	*(struct ns__echoDecimal*)p = *(struct ns__echoDecimal*)q;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_default_ns__echoDecimalResponse(struct soap *soap, struct ns__echoDecimalResponse *a)
{
	(void)soap; (void)a; /* appease -Wall -Werror */
	soap_default_xsd__decimal(soap, &a->_return);
}

SOAP_FMAC3 void SOAP_FMAC4 soap_serialize_ns__echoDecimalResponse(struct soap *soap, const struct ns__echoDecimalResponse *a)
{
	(void)soap; (void)a; /* appease -Wall -Werror */
	soap_serialize_xsd__decimal(soap, &a->_return);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_put_ns__echoDecimalResponse(struct soap *soap, const struct ns__echoDecimalResponse *a, const char *tag, const char *type)
{
	register int id = soap_embed(soap, (void*)a, NULL, 0, tag, SOAP_TYPE_ns__echoDecimalResponse);
	if (soap_out_ns__echoDecimalResponse(soap, tag, id, a, type))
		return soap->error;
	return soap_putindependent(soap);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out_ns__echoDecimalResponse(struct soap *soap, const char *tag, int id, const struct ns__echoDecimalResponse *a, const char *type)
{
	if (soap_element_begin_out(soap, tag, soap_embedded_id(soap, id, a, SOAP_TYPE_ns__echoDecimalResponse), type))
		return soap->error;
	if (soap_out_xsd__decimal(soap, "return", -1, &a->_return, ""))
		return soap->error;
	return soap_element_end_out(soap, tag);
}

SOAP_FMAC3 struct ns__echoDecimalResponse * SOAP_FMAC4 soap_get_ns__echoDecimalResponse(struct soap *soap, struct ns__echoDecimalResponse *p, const char *tag, const char *type)
{
	if ((p = soap_in_ns__echoDecimalResponse(soap, tag, p, type)))
		if (soap_getindependent(soap))
			return NULL;
	return p;
}

SOAP_FMAC3 struct ns__echoDecimalResponse * SOAP_FMAC4 soap_in_ns__echoDecimalResponse(struct soap *soap, const char *tag, struct ns__echoDecimalResponse *a, const char *type)
{
	short soap_flag__return = 1;
	if (soap_element_begin_in(soap, tag, 0, type))
		return NULL;
	a = (struct ns__echoDecimalResponse *)soap_id_enter(soap, soap->id, a, SOAP_TYPE_ns__echoDecimalResponse, sizeof(struct ns__echoDecimalResponse), 0, NULL, NULL, NULL);
	if (!a)
		return NULL;
	soap_default_ns__echoDecimalResponse(soap, a);
	if (soap->body && !*soap->href)
	{
		for (;;)
		{	soap->error = SOAP_TAG_MISMATCH;
			if (soap_flag__return && (soap->error == SOAP_TAG_MISMATCH || soap->error == SOAP_NO_TAG))
				if (soap_in_xsd__decimal(soap, NULL, &a->_return, "xsd:decimal"))
				{	soap_flag__return--;
					continue;
				}
			if (soap->error == SOAP_TAG_MISMATCH)
				soap->error = soap_ignore_element(soap);
			if (soap->error == SOAP_NO_TAG)
				break;
			if (soap->error)
				return NULL;
		}
		if (soap_element_end_in(soap, tag))
			return NULL;
	}
	else
	{	a = (struct ns__echoDecimalResponse *)soap_id_forward(soap, soap->href, (void*)a, 0, SOAP_TYPE_ns__echoDecimalResponse, 0, sizeof(struct ns__echoDecimalResponse), 0, NULL);
		if (soap->body && soap_element_end_in(soap, tag))
			return NULL;
	}
	if ((soap->mode & SOAP_XML_STRICT) && (soap_flag__return > 0))
	{	soap->error = SOAP_OCCURS;
		return NULL;
	}
	return a;
}

SOAP_FMAC5 struct ns__echoDecimalResponse * SOAP_FMAC6 soap_new_ns__echoDecimalResponse(struct soap *soap, int n)
{	return soap_instantiate_ns__echoDecimalResponse(soap, n, NULL, NULL, NULL);
}

SOAP_FMAC5 void SOAP_FMAC6 soap_delete_ns__echoDecimalResponse(struct soap *soap, struct ns__echoDecimalResponse *p)
{	soap_delete(soap, p);
}

SOAP_FMAC3 struct ns__echoDecimalResponse * SOAP_FMAC4 soap_instantiate_ns__echoDecimalResponse(struct soap *soap, int n, const char *type, const char *arrayType, size_t *size)
{
	DBGLOG(TEST, SOAP_MESSAGE(fdebug, "soap_instantiate_ns__echoDecimalResponse(%d, %s, %s)\n", n, type?type:"", arrayType?arrayType:""));
	struct soap_clist *cp = soap_link(soap, NULL, SOAP_TYPE_ns__echoDecimalResponse, n, soap_fdelete);
	if (!cp)
		return NULL;
	if (n < 0)
	{	cp->ptr = (void*)new struct ns__echoDecimalResponse;
		if (size)
			*size = sizeof(struct ns__echoDecimalResponse);
	}
	else
	{	cp->ptr = (void*)new struct ns__echoDecimalResponse[n];
		if (!cp->ptr)
		{	soap->error = SOAP_EOM;
			return NULL;
		}
		if (size)
			*size = n * sizeof(struct ns__echoDecimalResponse);
	}
		DBGLOG(TEST, SOAP_MESSAGE(fdebug, "Instantiated location=%p\n", cp->ptr));
	return (struct ns__echoDecimalResponse*)cp->ptr;
}
SOAP_FMAC3 void SOAP_FMAC4 soap_copy_ns__echoDecimalResponse(struct soap *soap, int st, int tt, void *p, size_t len, const void *q, size_t n)
{
	DBGLOG(TEST, SOAP_MESSAGE(fdebug, "Copying struct ns__echoDecimalResponse %p -> %p\n", q, p));
	*(struct ns__echoDecimalResponse*)p = *(struct ns__echoDecimalResponse*)q;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_default_ns__echoHexBinary(struct soap *soap, struct ns__echoHexBinary *a)
{
	(void)soap; (void)a; /* appease -Wall -Werror */
	soap_default_xsd__hexBinary(soap, &a->inputHexBinary);
}

SOAP_FMAC3 void SOAP_FMAC4 soap_serialize_ns__echoHexBinary(struct soap *soap, const struct ns__echoHexBinary *a)
{
	(void)soap; (void)a; /* appease -Wall -Werror */
	soap_serialize_xsd__hexBinary(soap, &a->inputHexBinary);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_put_ns__echoHexBinary(struct soap *soap, const struct ns__echoHexBinary *a, const char *tag, const char *type)
{
	register int id = soap_embed(soap, (void*)a, NULL, 0, tag, SOAP_TYPE_ns__echoHexBinary);
	if (soap_out_ns__echoHexBinary(soap, tag, id, a, type))
		return soap->error;
	return soap_putindependent(soap);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out_ns__echoHexBinary(struct soap *soap, const char *tag, int id, const struct ns__echoHexBinary *a, const char *type)
{
	if (soap_element_begin_out(soap, tag, soap_embedded_id(soap, id, a, SOAP_TYPE_ns__echoHexBinary), type))
		return soap->error;
	if (soap_out_xsd__hexBinary(soap, "inputHexBinary", -1, &a->inputHexBinary, ""))
		return soap->error;
	return soap_element_end_out(soap, tag);
}

SOAP_FMAC3 struct ns__echoHexBinary * SOAP_FMAC4 soap_get_ns__echoHexBinary(struct soap *soap, struct ns__echoHexBinary *p, const char *tag, const char *type)
{
	if ((p = soap_in_ns__echoHexBinary(soap, tag, p, type)))
		if (soap_getindependent(soap))
			return NULL;
	return p;
}

SOAP_FMAC3 struct ns__echoHexBinary * SOAP_FMAC4 soap_in_ns__echoHexBinary(struct soap *soap, const char *tag, struct ns__echoHexBinary *a, const char *type)
{
	short soap_flag_inputHexBinary = 1;
	if (soap_element_begin_in(soap, tag, 0, type))
		return NULL;
	a = (struct ns__echoHexBinary *)soap_id_enter(soap, soap->id, a, SOAP_TYPE_ns__echoHexBinary, sizeof(struct ns__echoHexBinary), 0, NULL, NULL, NULL);
	if (!a)
		return NULL;
	soap_default_ns__echoHexBinary(soap, a);
	if (soap->body && !*soap->href)
	{
		for (;;)
		{	soap->error = SOAP_TAG_MISMATCH;
			if (soap_flag_inputHexBinary && soap->error == SOAP_TAG_MISMATCH)
				if (soap_in_xsd__hexBinary(soap, "inputHexBinary", &a->inputHexBinary, "xsd:hexBinary"))
				{	soap_flag_inputHexBinary--;
					continue;
				}
			if (soap->error == SOAP_TAG_MISMATCH)
				soap->error = soap_ignore_element(soap);
			if (soap->error == SOAP_NO_TAG)
				break;
			if (soap->error)
				return NULL;
		}
		if (soap_element_end_in(soap, tag))
			return NULL;
	}
	else
	{	a = (struct ns__echoHexBinary *)soap_id_forward(soap, soap->href, (void*)a, 0, SOAP_TYPE_ns__echoHexBinary, 0, sizeof(struct ns__echoHexBinary), 0, NULL);
		if (soap->body && soap_element_end_in(soap, tag))
			return NULL;
	}
	if ((soap->mode & SOAP_XML_STRICT) && (soap_flag_inputHexBinary > 0))
	{	soap->error = SOAP_OCCURS;
		return NULL;
	}
	return a;
}

SOAP_FMAC5 struct ns__echoHexBinary * SOAP_FMAC6 soap_new_ns__echoHexBinary(struct soap *soap, int n)
{	return soap_instantiate_ns__echoHexBinary(soap, n, NULL, NULL, NULL);
}

SOAP_FMAC5 void SOAP_FMAC6 soap_delete_ns__echoHexBinary(struct soap *soap, struct ns__echoHexBinary *p)
{	soap_delete(soap, p);
}

SOAP_FMAC3 struct ns__echoHexBinary * SOAP_FMAC4 soap_instantiate_ns__echoHexBinary(struct soap *soap, int n, const char *type, const char *arrayType, size_t *size)
{
	DBGLOG(TEST, SOAP_MESSAGE(fdebug, "soap_instantiate_ns__echoHexBinary(%d, %s, %s)\n", n, type?type:"", arrayType?arrayType:""));
	struct soap_clist *cp = soap_link(soap, NULL, SOAP_TYPE_ns__echoHexBinary, n, soap_fdelete);
	if (!cp)
		return NULL;
	if (n < 0)
	{	cp->ptr = (void*)new struct ns__echoHexBinary;
		if (size)
			*size = sizeof(struct ns__echoHexBinary);
	}
	else
	{	cp->ptr = (void*)new struct ns__echoHexBinary[n];
		if (!cp->ptr)
		{	soap->error = SOAP_EOM;
			return NULL;
		}
		if (size)
			*size = n * sizeof(struct ns__echoHexBinary);
	}
		DBGLOG(TEST, SOAP_MESSAGE(fdebug, "Instantiated location=%p\n", cp->ptr));
	return (struct ns__echoHexBinary*)cp->ptr;
}
SOAP_FMAC3 void SOAP_FMAC4 soap_copy_ns__echoHexBinary(struct soap *soap, int st, int tt, void *p, size_t len, const void *q, size_t n)
{
	DBGLOG(TEST, SOAP_MESSAGE(fdebug, "Copying struct ns__echoHexBinary %p -> %p\n", q, p));
	*(struct ns__echoHexBinary*)p = *(struct ns__echoHexBinary*)q;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_default_ns__echoHexBinaryResponse(struct soap *soap, struct ns__echoHexBinaryResponse *a)
{
	(void)soap; (void)a; /* appease -Wall -Werror */
	soap_default_xsd__hexBinary(soap, &a->_return);
}

SOAP_FMAC3 void SOAP_FMAC4 soap_serialize_ns__echoHexBinaryResponse(struct soap *soap, const struct ns__echoHexBinaryResponse *a)
{
	(void)soap; (void)a; /* appease -Wall -Werror */
	soap_serialize_xsd__hexBinary(soap, &a->_return);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_put_ns__echoHexBinaryResponse(struct soap *soap, const struct ns__echoHexBinaryResponse *a, const char *tag, const char *type)
{
	register int id = soap_embed(soap, (void*)a, NULL, 0, tag, SOAP_TYPE_ns__echoHexBinaryResponse);
	if (soap_out_ns__echoHexBinaryResponse(soap, tag, id, a, type))
		return soap->error;
	return soap_putindependent(soap);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out_ns__echoHexBinaryResponse(struct soap *soap, const char *tag, int id, const struct ns__echoHexBinaryResponse *a, const char *type)
{
	if (soap_element_begin_out(soap, tag, soap_embedded_id(soap, id, a, SOAP_TYPE_ns__echoHexBinaryResponse), type))
		return soap->error;
	if (soap_out_xsd__hexBinary(soap, "return", -1, &a->_return, ""))
		return soap->error;
	return soap_element_end_out(soap, tag);
}

SOAP_FMAC3 struct ns__echoHexBinaryResponse * SOAP_FMAC4 soap_get_ns__echoHexBinaryResponse(struct soap *soap, struct ns__echoHexBinaryResponse *p, const char *tag, const char *type)
{
	if ((p = soap_in_ns__echoHexBinaryResponse(soap, tag, p, type)))
		if (soap_getindependent(soap))
			return NULL;
	return p;
}

SOAP_FMAC3 struct ns__echoHexBinaryResponse * SOAP_FMAC4 soap_in_ns__echoHexBinaryResponse(struct soap *soap, const char *tag, struct ns__echoHexBinaryResponse *a, const char *type)
{
	short soap_flag__return = 1;
	if (soap_element_begin_in(soap, tag, 0, type))
		return NULL;
	a = (struct ns__echoHexBinaryResponse *)soap_id_enter(soap, soap->id, a, SOAP_TYPE_ns__echoHexBinaryResponse, sizeof(struct ns__echoHexBinaryResponse), 0, NULL, NULL, NULL);
	if (!a)
		return NULL;
	soap_default_ns__echoHexBinaryResponse(soap, a);
	if (soap->body && !*soap->href)
	{
		for (;;)
		{	soap->error = SOAP_TAG_MISMATCH;
			if (soap_flag__return && soap->error == SOAP_TAG_MISMATCH)
				if (soap_in_xsd__hexBinary(soap, NULL, &a->_return, "xsd:hexBinary"))
				{	soap_flag__return--;
					continue;
				}
			if (soap->error == SOAP_TAG_MISMATCH)
				soap->error = soap_ignore_element(soap);
			if (soap->error == SOAP_NO_TAG)
				break;
			if (soap->error)
				return NULL;
		}
		if (soap_element_end_in(soap, tag))
			return NULL;
	}
	else
	{	a = (struct ns__echoHexBinaryResponse *)soap_id_forward(soap, soap->href, (void*)a, 0, SOAP_TYPE_ns__echoHexBinaryResponse, 0, sizeof(struct ns__echoHexBinaryResponse), 0, NULL);
		if (soap->body && soap_element_end_in(soap, tag))
			return NULL;
	}
	if ((soap->mode & SOAP_XML_STRICT) && (soap_flag__return > 0))
	{	soap->error = SOAP_OCCURS;
		return NULL;
	}
	return a;
}

SOAP_FMAC5 struct ns__echoHexBinaryResponse * SOAP_FMAC6 soap_new_ns__echoHexBinaryResponse(struct soap *soap, int n)
{	return soap_instantiate_ns__echoHexBinaryResponse(soap, n, NULL, NULL, NULL);
}

SOAP_FMAC5 void SOAP_FMAC6 soap_delete_ns__echoHexBinaryResponse(struct soap *soap, struct ns__echoHexBinaryResponse *p)
{	soap_delete(soap, p);
}

SOAP_FMAC3 struct ns__echoHexBinaryResponse * SOAP_FMAC4 soap_instantiate_ns__echoHexBinaryResponse(struct soap *soap, int n, const char *type, const char *arrayType, size_t *size)
{
	DBGLOG(TEST, SOAP_MESSAGE(fdebug, "soap_instantiate_ns__echoHexBinaryResponse(%d, %s, %s)\n", n, type?type:"", arrayType?arrayType:""));
	struct soap_clist *cp = soap_link(soap, NULL, SOAP_TYPE_ns__echoHexBinaryResponse, n, soap_fdelete);
	if (!cp)
		return NULL;
	if (n < 0)
	{	cp->ptr = (void*)new struct ns__echoHexBinaryResponse;
		if (size)
			*size = sizeof(struct ns__echoHexBinaryResponse);
	}
	else
	{	cp->ptr = (void*)new struct ns__echoHexBinaryResponse[n];
		if (!cp->ptr)
		{	soap->error = SOAP_EOM;
			return NULL;
		}
		if (size)
			*size = n * sizeof(struct ns__echoHexBinaryResponse);
	}
		DBGLOG(TEST, SOAP_MESSAGE(fdebug, "Instantiated location=%p\n", cp->ptr));
	return (struct ns__echoHexBinaryResponse*)cp->ptr;
}
SOAP_FMAC3 void SOAP_FMAC4 soap_copy_ns__echoHexBinaryResponse(struct soap *soap, int st, int tt, void *p, size_t len, const void *q, size_t n)
{
	DBGLOG(TEST, SOAP_MESSAGE(fdebug, "Copying struct ns__echoHexBinaryResponse %p -> %p\n", q, p));
	*(struct ns__echoHexBinaryResponse*)p = *(struct ns__echoHexBinaryResponse*)q;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_default_xsd__hexBinary(struct soap *soap, struct xsd__hexBinary *a)
{
	a->__size = 0;
	a->__ptr = NULL;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_serialize_xsd__hexBinary(struct soap *soap, struct xsd__hexBinary const*a)
{
	if (a->__ptr)
		soap_array_reference(soap, a, (struct soap_array*)&a->__ptr, 1, SOAP_TYPE_xsd__hexBinary);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_put_xsd__hexBinary(struct soap *soap, const struct xsd__hexBinary *a, const char *tag, const char *type)
{
	register int id = soap_embed(soap, (void*)a, (struct soap_array*)&a->__ptr, 1, tag, SOAP_TYPE_xsd__hexBinary);
	if (soap_out_xsd__hexBinary(soap, tag, id, a, type))
		return soap->error;
	return soap_putindependent(soap);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out_xsd__hexBinary(struct soap *soap, const char *tag, int id, const struct xsd__hexBinary *a, const char *type)
{
	id = soap_element_id(soap, tag, id, a, (struct soap_array*)&a->__ptr, 1, type, SOAP_TYPE_xsd__hexBinary);
	if (id < 0)
		return soap->error;
	if (soap_element_begin_out(soap, tag, id, type))
		return soap->error;
	if (soap_puthex(soap, a->__ptr, a->__size))
		return soap->error;
	return soap_element_end_out(soap, tag);
}

SOAP_FMAC3 struct xsd__hexBinary * SOAP_FMAC4 soap_get_xsd__hexBinary(struct soap *soap, struct xsd__hexBinary *p, const char *tag, const char *type)
{
	if ((p = soap_in_xsd__hexBinary(soap, tag, p, type)))
		if (soap_getindependent(soap))
			return NULL;
	return p;
}

SOAP_FMAC3 struct xsd__hexBinary * SOAP_FMAC4 soap_in_xsd__hexBinary(struct soap *soap, const char *tag, struct xsd__hexBinary *a, const char *type)
{
	if (soap_element_begin_in(soap, tag, 1, NULL))
		return NULL;
	if (*soap->type && soap_match_tag(soap, soap->type, type) && soap_match_tag(soap, soap->type, ":hexBinary"))
	{	soap->error = SOAP_TYPE;
		return NULL;
	}
	a = (struct xsd__hexBinary *)soap_id_enter(soap, soap->id, a, SOAP_TYPE_xsd__hexBinary, sizeof(struct xsd__hexBinary), 0, NULL, NULL, NULL);
	if (!a)
		return NULL;
	soap_default_xsd__hexBinary(soap, a);
	if (soap->body && !*soap->href)
	{
		a->__ptr = soap_gethex(soap, &a->__size);
		if ((!a->__ptr && soap->error) || soap_element_end_in(soap, tag))
			return NULL;
	}
	else
	{	a = (struct xsd__hexBinary *)soap_id_forward(soap, soap->href, (void*)a, 0, SOAP_TYPE_xsd__hexBinary, 0, sizeof(struct xsd__hexBinary), 0, NULL);
		if (soap->body && soap_element_end_in(soap, tag))
			return NULL;
	}
	return a;
}

SOAP_FMAC5 struct xsd__hexBinary * SOAP_FMAC6 soap_new_xsd__hexBinary(struct soap *soap, int n)
{	return soap_instantiate_xsd__hexBinary(soap, n, NULL, NULL, NULL);
}

SOAP_FMAC5 void SOAP_FMAC6 soap_delete_xsd__hexBinary(struct soap *soap, struct xsd__hexBinary *p)
{	soap_delete(soap, p);
}

SOAP_FMAC3 struct xsd__hexBinary * SOAP_FMAC4 soap_instantiate_xsd__hexBinary(struct soap *soap, int n, const char *type, const char *arrayType, size_t *size)
{
	DBGLOG(TEST, SOAP_MESSAGE(fdebug, "soap_instantiate_xsd__hexBinary(%d, %s, %s)\n", n, type?type:"", arrayType?arrayType:""));
	struct soap_clist *cp = soap_link(soap, NULL, SOAP_TYPE_xsd__hexBinary, n, soap_fdelete);
	if (!cp)
		return NULL;
	if (n < 0)
	{	cp->ptr = (void*)new struct xsd__hexBinary;
		if (size)
			*size = sizeof(struct xsd__hexBinary);
	}
	else
	{	cp->ptr = (void*)new struct xsd__hexBinary[n];
		if (!cp->ptr)
		{	soap->error = SOAP_EOM;
			return NULL;
		}
		if (size)
			*size = n * sizeof(struct xsd__hexBinary);
	}
		DBGLOG(TEST, SOAP_MESSAGE(fdebug, "Instantiated location=%p\n", cp->ptr));
	return (struct xsd__hexBinary*)cp->ptr;
}
SOAP_FMAC3 void SOAP_FMAC4 soap_copy_xsd__hexBinary(struct soap *soap, int st, int tt, void *p, size_t len, const void *q, size_t n)
{
	DBGLOG(TEST, SOAP_MESSAGE(fdebug, "Copying struct xsd__hexBinary %p -> %p\n", q, p));
	*(struct xsd__hexBinary*)p = *(struct xsd__hexBinary*)q;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_default_ns__echoDate(struct soap *soap, struct ns__echoDate *a)
{
	(void)soap; (void)a; /* appease -Wall -Werror */
	soap_default_xsd__dateTime(soap, &a->inputDate);
}

SOAP_FMAC3 void SOAP_FMAC4 soap_serialize_ns__echoDate(struct soap *soap, const struct ns__echoDate *a)
{
	(void)soap; (void)a; /* appease -Wall -Werror */
	soap_serialize_xsd__dateTime(soap, &a->inputDate);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_put_ns__echoDate(struct soap *soap, const struct ns__echoDate *a, const char *tag, const char *type)
{
	register int id = soap_embed(soap, (void*)a, NULL, 0, tag, SOAP_TYPE_ns__echoDate);
	if (soap_out_ns__echoDate(soap, tag, id, a, type))
		return soap->error;
	return soap_putindependent(soap);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out_ns__echoDate(struct soap *soap, const char *tag, int id, const struct ns__echoDate *a, const char *type)
{
	if (soap_element_begin_out(soap, tag, soap_embedded_id(soap, id, a, SOAP_TYPE_ns__echoDate), type))
		return soap->error;
	if (soap_out_xsd__dateTime(soap, "inputDate", -1, &a->inputDate, ""))
		return soap->error;
	return soap_element_end_out(soap, tag);
}

SOAP_FMAC3 struct ns__echoDate * SOAP_FMAC4 soap_get_ns__echoDate(struct soap *soap, struct ns__echoDate *p, const char *tag, const char *type)
{
	if ((p = soap_in_ns__echoDate(soap, tag, p, type)))
		if (soap_getindependent(soap))
			return NULL;
	return p;
}

SOAP_FMAC3 struct ns__echoDate * SOAP_FMAC4 soap_in_ns__echoDate(struct soap *soap, const char *tag, struct ns__echoDate *a, const char *type)
{
	short soap_flag_inputDate = 1;
	if (soap_element_begin_in(soap, tag, 0, type))
		return NULL;
	a = (struct ns__echoDate *)soap_id_enter(soap, soap->id, a, SOAP_TYPE_ns__echoDate, sizeof(struct ns__echoDate), 0, NULL, NULL, NULL);
	if (!a)
		return NULL;
	soap_default_ns__echoDate(soap, a);
	if (soap->body && !*soap->href)
	{
		for (;;)
		{	soap->error = SOAP_TAG_MISMATCH;
			if (soap_flag_inputDate && (soap->error == SOAP_TAG_MISMATCH || soap->error == SOAP_NO_TAG))
				if (soap_in_xsd__dateTime(soap, "inputDate", &a->inputDate, "xsd:dateTime"))
				{	soap_flag_inputDate--;
					continue;
				}
			if (soap->error == SOAP_TAG_MISMATCH)
				soap->error = soap_ignore_element(soap);
			if (soap->error == SOAP_NO_TAG)
				break;
			if (soap->error)
				return NULL;
		}
		if (soap_element_end_in(soap, tag))
			return NULL;
	}
	else
	{	a = (struct ns__echoDate *)soap_id_forward(soap, soap->href, (void*)a, 0, SOAP_TYPE_ns__echoDate, 0, sizeof(struct ns__echoDate), 0, NULL);
		if (soap->body && soap_element_end_in(soap, tag))
			return NULL;
	}
	return a;
}

SOAP_FMAC5 struct ns__echoDate * SOAP_FMAC6 soap_new_ns__echoDate(struct soap *soap, int n)
{	return soap_instantiate_ns__echoDate(soap, n, NULL, NULL, NULL);
}

SOAP_FMAC5 void SOAP_FMAC6 soap_delete_ns__echoDate(struct soap *soap, struct ns__echoDate *p)
{	soap_delete(soap, p);
}

SOAP_FMAC3 struct ns__echoDate * SOAP_FMAC4 soap_instantiate_ns__echoDate(struct soap *soap, int n, const char *type, const char *arrayType, size_t *size)
{
	DBGLOG(TEST, SOAP_MESSAGE(fdebug, "soap_instantiate_ns__echoDate(%d, %s, %s)\n", n, type?type:"", arrayType?arrayType:""));
	struct soap_clist *cp = soap_link(soap, NULL, SOAP_TYPE_ns__echoDate, n, soap_fdelete);
	if (!cp)
		return NULL;
	if (n < 0)
	{	cp->ptr = (void*)new struct ns__echoDate;
		if (size)
			*size = sizeof(struct ns__echoDate);
	}
	else
	{	cp->ptr = (void*)new struct ns__echoDate[n];
		if (!cp->ptr)
		{	soap->error = SOAP_EOM;
			return NULL;
		}
		if (size)
			*size = n * sizeof(struct ns__echoDate);
	}
		DBGLOG(TEST, SOAP_MESSAGE(fdebug, "Instantiated location=%p\n", cp->ptr));
	return (struct ns__echoDate*)cp->ptr;
}
SOAP_FMAC3 void SOAP_FMAC4 soap_copy_ns__echoDate(struct soap *soap, int st, int tt, void *p, size_t len, const void *q, size_t n)
{
	DBGLOG(TEST, SOAP_MESSAGE(fdebug, "Copying struct ns__echoDate %p -> %p\n", q, p));
	*(struct ns__echoDate*)p = *(struct ns__echoDate*)q;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_default_ns__echoDateResponse(struct soap *soap, struct ns__echoDateResponse *a)
{
	(void)soap; (void)a; /* appease -Wall -Werror */
	soap_default_xsd__dateTime(soap, &a->_return);
}

SOAP_FMAC3 void SOAP_FMAC4 soap_serialize_ns__echoDateResponse(struct soap *soap, const struct ns__echoDateResponse *a)
{
	(void)soap; (void)a; /* appease -Wall -Werror */
	soap_serialize_xsd__dateTime(soap, &a->_return);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_put_ns__echoDateResponse(struct soap *soap, const struct ns__echoDateResponse *a, const char *tag, const char *type)
{
	register int id = soap_embed(soap, (void*)a, NULL, 0, tag, SOAP_TYPE_ns__echoDateResponse);
	if (soap_out_ns__echoDateResponse(soap, tag, id, a, type))
		return soap->error;
	return soap_putindependent(soap);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out_ns__echoDateResponse(struct soap *soap, const char *tag, int id, const struct ns__echoDateResponse *a, const char *type)
{
	if (soap_element_begin_out(soap, tag, soap_embedded_id(soap, id, a, SOAP_TYPE_ns__echoDateResponse), type))
		return soap->error;
	if (soap_out_xsd__dateTime(soap, "return", -1, &a->_return, ""))
		return soap->error;
	return soap_element_end_out(soap, tag);
}

SOAP_FMAC3 struct ns__echoDateResponse * SOAP_FMAC4 soap_get_ns__echoDateResponse(struct soap *soap, struct ns__echoDateResponse *p, const char *tag, const char *type)
{
	if ((p = soap_in_ns__echoDateResponse(soap, tag, p, type)))
		if (soap_getindependent(soap))
			return NULL;
	return p;
}

SOAP_FMAC3 struct ns__echoDateResponse * SOAP_FMAC4 soap_in_ns__echoDateResponse(struct soap *soap, const char *tag, struct ns__echoDateResponse *a, const char *type)
{
	short soap_flag__return = 1;
	if (soap_element_begin_in(soap, tag, 0, type))
		return NULL;
	a = (struct ns__echoDateResponse *)soap_id_enter(soap, soap->id, a, SOAP_TYPE_ns__echoDateResponse, sizeof(struct ns__echoDateResponse), 0, NULL, NULL, NULL);
	if (!a)
		return NULL;
	soap_default_ns__echoDateResponse(soap, a);
	if (soap->body && !*soap->href)
	{
		for (;;)
		{	soap->error = SOAP_TAG_MISMATCH;
			if (soap_flag__return && (soap->error == SOAP_TAG_MISMATCH || soap->error == SOAP_NO_TAG))
				if (soap_in_xsd__dateTime(soap, NULL, &a->_return, "xsd:dateTime"))
				{	soap_flag__return--;
					continue;
				}
			if (soap->error == SOAP_TAG_MISMATCH)
				soap->error = soap_ignore_element(soap);
			if (soap->error == SOAP_NO_TAG)
				break;
			if (soap->error)
				return NULL;
		}
		if (soap_element_end_in(soap, tag))
			return NULL;
	}
	else
	{	a = (struct ns__echoDateResponse *)soap_id_forward(soap, soap->href, (void*)a, 0, SOAP_TYPE_ns__echoDateResponse, 0, sizeof(struct ns__echoDateResponse), 0, NULL);
		if (soap->body && soap_element_end_in(soap, tag))
			return NULL;
	}
	if ((soap->mode & SOAP_XML_STRICT) && (soap_flag__return > 0))
	{	soap->error = SOAP_OCCURS;
		return NULL;
	}
	return a;
}

SOAP_FMAC5 struct ns__echoDateResponse * SOAP_FMAC6 soap_new_ns__echoDateResponse(struct soap *soap, int n)
{	return soap_instantiate_ns__echoDateResponse(soap, n, NULL, NULL, NULL);
}

SOAP_FMAC5 void SOAP_FMAC6 soap_delete_ns__echoDateResponse(struct soap *soap, struct ns__echoDateResponse *p)
{	soap_delete(soap, p);
}

SOAP_FMAC3 struct ns__echoDateResponse * SOAP_FMAC4 soap_instantiate_ns__echoDateResponse(struct soap *soap, int n, const char *type, const char *arrayType, size_t *size)
{
	DBGLOG(TEST, SOAP_MESSAGE(fdebug, "soap_instantiate_ns__echoDateResponse(%d, %s, %s)\n", n, type?type:"", arrayType?arrayType:""));
	struct soap_clist *cp = soap_link(soap, NULL, SOAP_TYPE_ns__echoDateResponse, n, soap_fdelete);
	if (!cp)
		return NULL;
	if (n < 0)
	{	cp->ptr = (void*)new struct ns__echoDateResponse;
		if (size)
			*size = sizeof(struct ns__echoDateResponse);
	}
	else
	{	cp->ptr = (void*)new struct ns__echoDateResponse[n];
		if (!cp->ptr)
		{	soap->error = SOAP_EOM;
			return NULL;
		}
		if (size)
			*size = n * sizeof(struct ns__echoDateResponse);
	}
		DBGLOG(TEST, SOAP_MESSAGE(fdebug, "Instantiated location=%p\n", cp->ptr));
	return (struct ns__echoDateResponse*)cp->ptr;
}
SOAP_FMAC3 void SOAP_FMAC4 soap_copy_ns__echoDateResponse(struct soap *soap, int st, int tt, void *p, size_t len, const void *q, size_t n)
{
	DBGLOG(TEST, SOAP_MESSAGE(fdebug, "Copying struct ns__echoDateResponse %p -> %p\n", q, p));
	*(struct ns__echoDateResponse*)p = *(struct ns__echoDateResponse*)q;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_default_ns__echoBase64(struct soap *soap, struct ns__echoBase64 *a)
{
	(void)soap; (void)a; /* appease -Wall -Werror */
	soap_default_xsd__base64Binary(soap, &a->inputBase64);
}

SOAP_FMAC3 void SOAP_FMAC4 soap_serialize_ns__echoBase64(struct soap *soap, const struct ns__echoBase64 *a)
{
	(void)soap; (void)a; /* appease -Wall -Werror */
	soap_serialize_xsd__base64Binary(soap, &a->inputBase64);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_put_ns__echoBase64(struct soap *soap, const struct ns__echoBase64 *a, const char *tag, const char *type)
{
	register int id = soap_embed(soap, (void*)a, NULL, 0, tag, SOAP_TYPE_ns__echoBase64);
	if (soap_out_ns__echoBase64(soap, tag, id, a, type))
		return soap->error;
	return soap_putindependent(soap);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out_ns__echoBase64(struct soap *soap, const char *tag, int id, const struct ns__echoBase64 *a, const char *type)
{
	if (soap_element_begin_out(soap, tag, soap_embedded_id(soap, id, a, SOAP_TYPE_ns__echoBase64), type))
		return soap->error;
	if (soap_out_xsd__base64Binary(soap, "inputBase64", -1, &a->inputBase64, ""))
		return soap->error;
	return soap_element_end_out(soap, tag);
}

SOAP_FMAC3 struct ns__echoBase64 * SOAP_FMAC4 soap_get_ns__echoBase64(struct soap *soap, struct ns__echoBase64 *p, const char *tag, const char *type)
{
	if ((p = soap_in_ns__echoBase64(soap, tag, p, type)))
		if (soap_getindependent(soap))
			return NULL;
	return p;
}

SOAP_FMAC3 struct ns__echoBase64 * SOAP_FMAC4 soap_in_ns__echoBase64(struct soap *soap, const char *tag, struct ns__echoBase64 *a, const char *type)
{
	short soap_flag_inputBase64 = 1;
	if (soap_element_begin_in(soap, tag, 0, type))
		return NULL;
	a = (struct ns__echoBase64 *)soap_id_enter(soap, soap->id, a, SOAP_TYPE_ns__echoBase64, sizeof(struct ns__echoBase64), 0, NULL, NULL, NULL);
	if (!a)
		return NULL;
	soap_default_ns__echoBase64(soap, a);
	if (soap->body && !*soap->href)
	{
		for (;;)
		{	soap->error = SOAP_TAG_MISMATCH;
			if (soap_flag_inputBase64 && soap->error == SOAP_TAG_MISMATCH)
				if (soap_in_xsd__base64Binary(soap, "inputBase64", &a->inputBase64, "xsd:base64Binary"))
				{	soap_flag_inputBase64--;
					continue;
				}
			if (soap->error == SOAP_TAG_MISMATCH)
				soap->error = soap_ignore_element(soap);
			if (soap->error == SOAP_NO_TAG)
				break;
			if (soap->error)
				return NULL;
		}
		if (soap_element_end_in(soap, tag))
			return NULL;
	}
	else
	{	a = (struct ns__echoBase64 *)soap_id_forward(soap, soap->href, (void*)a, 0, SOAP_TYPE_ns__echoBase64, 0, sizeof(struct ns__echoBase64), 0, NULL);
		if (soap->body && soap_element_end_in(soap, tag))
			return NULL;
	}
	if ((soap->mode & SOAP_XML_STRICT) && (soap_flag_inputBase64 > 0))
	{	soap->error = SOAP_OCCURS;
		return NULL;
	}
	return a;
}

SOAP_FMAC5 struct ns__echoBase64 * SOAP_FMAC6 soap_new_ns__echoBase64(struct soap *soap, int n)
{	return soap_instantiate_ns__echoBase64(soap, n, NULL, NULL, NULL);
}

SOAP_FMAC5 void SOAP_FMAC6 soap_delete_ns__echoBase64(struct soap *soap, struct ns__echoBase64 *p)
{	soap_delete(soap, p);
}

SOAP_FMAC3 struct ns__echoBase64 * SOAP_FMAC4 soap_instantiate_ns__echoBase64(struct soap *soap, int n, const char *type, const char *arrayType, size_t *size)
{
	DBGLOG(TEST, SOAP_MESSAGE(fdebug, "soap_instantiate_ns__echoBase64(%d, %s, %s)\n", n, type?type:"", arrayType?arrayType:""));
	struct soap_clist *cp = soap_link(soap, NULL, SOAP_TYPE_ns__echoBase64, n, soap_fdelete);
	if (!cp)
		return NULL;
	if (n < 0)
	{	cp->ptr = (void*)new struct ns__echoBase64;
		if (size)
			*size = sizeof(struct ns__echoBase64);
	}
	else
	{	cp->ptr = (void*)new struct ns__echoBase64[n];
		if (!cp->ptr)
		{	soap->error = SOAP_EOM;
			return NULL;
		}
		if (size)
			*size = n * sizeof(struct ns__echoBase64);
	}
		DBGLOG(TEST, SOAP_MESSAGE(fdebug, "Instantiated location=%p\n", cp->ptr));
	return (struct ns__echoBase64*)cp->ptr;
}
SOAP_FMAC3 void SOAP_FMAC4 soap_copy_ns__echoBase64(struct soap *soap, int st, int tt, void *p, size_t len, const void *q, size_t n)
{
	DBGLOG(TEST, SOAP_MESSAGE(fdebug, "Copying struct ns__echoBase64 %p -> %p\n", q, p));
	*(struct ns__echoBase64*)p = *(struct ns__echoBase64*)q;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_default_ns__echoBase64Response(struct soap *soap, struct ns__echoBase64Response *a)
{
	(void)soap; (void)a; /* appease -Wall -Werror */
	soap_default_xsd__base64Binary(soap, &a->_return);
}

SOAP_FMAC3 void SOAP_FMAC4 soap_serialize_ns__echoBase64Response(struct soap *soap, const struct ns__echoBase64Response *a)
{
	(void)soap; (void)a; /* appease -Wall -Werror */
	soap_serialize_xsd__base64Binary(soap, &a->_return);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_put_ns__echoBase64Response(struct soap *soap, const struct ns__echoBase64Response *a, const char *tag, const char *type)
{
	register int id = soap_embed(soap, (void*)a, NULL, 0, tag, SOAP_TYPE_ns__echoBase64Response);
	if (soap_out_ns__echoBase64Response(soap, tag, id, a, type))
		return soap->error;
	return soap_putindependent(soap);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out_ns__echoBase64Response(struct soap *soap, const char *tag, int id, const struct ns__echoBase64Response *a, const char *type)
{
	if (soap_element_begin_out(soap, tag, soap_embedded_id(soap, id, a, SOAP_TYPE_ns__echoBase64Response), type))
		return soap->error;
	if (soap_out_xsd__base64Binary(soap, "return", -1, &a->_return, ""))
		return soap->error;
	return soap_element_end_out(soap, tag);
}

SOAP_FMAC3 struct ns__echoBase64Response * SOAP_FMAC4 soap_get_ns__echoBase64Response(struct soap *soap, struct ns__echoBase64Response *p, const char *tag, const char *type)
{
	if ((p = soap_in_ns__echoBase64Response(soap, tag, p, type)))
		if (soap_getindependent(soap))
			return NULL;
	return p;
}

SOAP_FMAC3 struct ns__echoBase64Response * SOAP_FMAC4 soap_in_ns__echoBase64Response(struct soap *soap, const char *tag, struct ns__echoBase64Response *a, const char *type)
{
	short soap_flag__return = 1;
	if (soap_element_begin_in(soap, tag, 0, type))
		return NULL;
	a = (struct ns__echoBase64Response *)soap_id_enter(soap, soap->id, a, SOAP_TYPE_ns__echoBase64Response, sizeof(struct ns__echoBase64Response), 0, NULL, NULL, NULL);
	if (!a)
		return NULL;
	soap_default_ns__echoBase64Response(soap, a);
	if (soap->body && !*soap->href)
	{
		for (;;)
		{	soap->error = SOAP_TAG_MISMATCH;
			if (soap_flag__return && soap->error == SOAP_TAG_MISMATCH)
				if (soap_in_xsd__base64Binary(soap, NULL, &a->_return, "xsd:base64Binary"))
				{	soap_flag__return--;
					continue;
				}
			if (soap->error == SOAP_TAG_MISMATCH)
				soap->error = soap_ignore_element(soap);
			if (soap->error == SOAP_NO_TAG)
				break;
			if (soap->error)
				return NULL;
		}
		if (soap_element_end_in(soap, tag))
			return NULL;
	}
	else
	{	a = (struct ns__echoBase64Response *)soap_id_forward(soap, soap->href, (void*)a, 0, SOAP_TYPE_ns__echoBase64Response, 0, sizeof(struct ns__echoBase64Response), 0, NULL);
		if (soap->body && soap_element_end_in(soap, tag))
			return NULL;
	}
	if ((soap->mode & SOAP_XML_STRICT) && (soap_flag__return > 0))
	{	soap->error = SOAP_OCCURS;
		return NULL;
	}
	return a;
}

SOAP_FMAC5 struct ns__echoBase64Response * SOAP_FMAC6 soap_new_ns__echoBase64Response(struct soap *soap, int n)
{	return soap_instantiate_ns__echoBase64Response(soap, n, NULL, NULL, NULL);
}

SOAP_FMAC5 void SOAP_FMAC6 soap_delete_ns__echoBase64Response(struct soap *soap, struct ns__echoBase64Response *p)
{	soap_delete(soap, p);
}

SOAP_FMAC3 struct ns__echoBase64Response * SOAP_FMAC4 soap_instantiate_ns__echoBase64Response(struct soap *soap, int n, const char *type, const char *arrayType, size_t *size)
{
	DBGLOG(TEST, SOAP_MESSAGE(fdebug, "soap_instantiate_ns__echoBase64Response(%d, %s, %s)\n", n, type?type:"", arrayType?arrayType:""));
	struct soap_clist *cp = soap_link(soap, NULL, SOAP_TYPE_ns__echoBase64Response, n, soap_fdelete);
	if (!cp)
		return NULL;
	if (n < 0)
	{	cp->ptr = (void*)new struct ns__echoBase64Response;
		if (size)
			*size = sizeof(struct ns__echoBase64Response);
	}
	else
	{	cp->ptr = (void*)new struct ns__echoBase64Response[n];
		if (!cp->ptr)
		{	soap->error = SOAP_EOM;
			return NULL;
		}
		if (size)
			*size = n * sizeof(struct ns__echoBase64Response);
	}
		DBGLOG(TEST, SOAP_MESSAGE(fdebug, "Instantiated location=%p\n", cp->ptr));
	return (struct ns__echoBase64Response*)cp->ptr;
}
SOAP_FMAC3 void SOAP_FMAC4 soap_copy_ns__echoBase64Response(struct soap *soap, int st, int tt, void *p, size_t len, const void *q, size_t n)
{
	DBGLOG(TEST, SOAP_MESSAGE(fdebug, "Copying struct ns__echoBase64Response %p -> %p\n", q, p));
	*(struct ns__echoBase64Response*)p = *(struct ns__echoBase64Response*)q;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_default_xsd__base64Binary(struct soap *soap, struct xsd__base64Binary *a)
{
	a->__size = 0;
	a->__ptr = NULL;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_serialize_xsd__base64Binary(struct soap *soap, struct xsd__base64Binary const*a)
{
	if (a->__ptr)
		soap_array_reference(soap, a, (struct soap_array*)&a->__ptr, 1, SOAP_TYPE_xsd__base64Binary);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_put_xsd__base64Binary(struct soap *soap, const struct xsd__base64Binary *a, const char *tag, const char *type)
{
	register int id = soap_embed(soap, (void*)a, (struct soap_array*)&a->__ptr, 1, tag, SOAP_TYPE_xsd__base64Binary);
	if (soap_out_xsd__base64Binary(soap, tag, id, a, type))
		return soap->error;
	return soap_putindependent(soap);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out_xsd__base64Binary(struct soap *soap, const char *tag, int id, const struct xsd__base64Binary *a, const char *type)
{
	id = soap_element_id(soap, tag, id, a, (struct soap_array*)&a->__ptr, 1, type, SOAP_TYPE_xsd__base64Binary);
	if (id < 0)
		return soap->error;
	if (soap_element_begin_out(soap, tag, id, type))
		return soap->error;
	if (soap_putbase64(soap, a->__ptr, a->__size))
		return soap->error;
	return soap_element_end_out(soap, tag);
}

SOAP_FMAC3 struct xsd__base64Binary * SOAP_FMAC4 soap_get_xsd__base64Binary(struct soap *soap, struct xsd__base64Binary *p, const char *tag, const char *type)
{
	if ((p = soap_in_xsd__base64Binary(soap, tag, p, type)))
		if (soap_getindependent(soap))
			return NULL;
	return p;
}

SOAP_FMAC3 struct xsd__base64Binary * SOAP_FMAC4 soap_in_xsd__base64Binary(struct soap *soap, const char *tag, struct xsd__base64Binary *a, const char *type)
{
	if (soap_element_begin_in(soap, tag, 1, NULL))
		return NULL;
	if (*soap->type && soap_match_tag(soap, soap->type, type) && soap_match_tag(soap, soap->type, ":base64Binary") && soap_match_tag(soap, soap->type, ":base64"))
	{	soap->error = SOAP_TYPE;
		return NULL;
	}
	a = (struct xsd__base64Binary *)soap_id_enter(soap, soap->id, a, SOAP_TYPE_xsd__base64Binary, sizeof(struct xsd__base64Binary), 0, NULL, NULL, NULL);
	if (!a)
		return NULL;
	soap_default_xsd__base64Binary(soap, a);
	if (soap->body && !*soap->href)
	{
		a->__ptr = soap_getbase64(soap, &a->__size, 0);
		if ((!a->__ptr && soap->error) || soap_element_end_in(soap, tag))
			return NULL;
	}
	else
	{	a = (struct xsd__base64Binary *)soap_id_forward(soap, soap->href, (void*)a, 0, SOAP_TYPE_xsd__base64Binary, 0, sizeof(struct xsd__base64Binary), 0, NULL);
		if (soap->body && soap_element_end_in(soap, tag))
			return NULL;
	}
	return a;
}

SOAP_FMAC5 struct xsd__base64Binary * SOAP_FMAC6 soap_new_xsd__base64Binary(struct soap *soap, int n)
{	return soap_instantiate_xsd__base64Binary(soap, n, NULL, NULL, NULL);
}

SOAP_FMAC5 void SOAP_FMAC6 soap_delete_xsd__base64Binary(struct soap *soap, struct xsd__base64Binary *p)
{	soap_delete(soap, p);
}

SOAP_FMAC3 struct xsd__base64Binary * SOAP_FMAC4 soap_instantiate_xsd__base64Binary(struct soap *soap, int n, const char *type, const char *arrayType, size_t *size)
{
	DBGLOG(TEST, SOAP_MESSAGE(fdebug, "soap_instantiate_xsd__base64Binary(%d, %s, %s)\n", n, type?type:"", arrayType?arrayType:""));
	struct soap_clist *cp = soap_link(soap, NULL, SOAP_TYPE_xsd__base64Binary, n, soap_fdelete);
	if (!cp)
		return NULL;
	if (n < 0)
	{	cp->ptr = (void*)new struct xsd__base64Binary;
		if (size)
			*size = sizeof(struct xsd__base64Binary);
	}
	else
	{	cp->ptr = (void*)new struct xsd__base64Binary[n];
		if (!cp->ptr)
		{	soap->error = SOAP_EOM;
			return NULL;
		}
		if (size)
			*size = n * sizeof(struct xsd__base64Binary);
	}
		DBGLOG(TEST, SOAP_MESSAGE(fdebug, "Instantiated location=%p\n", cp->ptr));
	return (struct xsd__base64Binary*)cp->ptr;
}
SOAP_FMAC3 void SOAP_FMAC4 soap_copy_xsd__base64Binary(struct soap *soap, int st, int tt, void *p, size_t len, const void *q, size_t n)
{
	DBGLOG(TEST, SOAP_MESSAGE(fdebug, "Copying struct xsd__base64Binary %p -> %p\n", q, p));
	*(struct xsd__base64Binary*)p = *(struct xsd__base64Binary*)q;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_default_ns__echoVoid(struct soap *soap, struct ns__echoVoid *a)
{
	(void)soap; (void)a; /* appease -Wall -Werror */
}

SOAP_FMAC3 void SOAP_FMAC4 soap_serialize_ns__echoVoid(struct soap *soap, const struct ns__echoVoid *a)
{
	(void)soap; (void)a; /* appease -Wall -Werror */
}

SOAP_FMAC3 int SOAP_FMAC4 soap_put_ns__echoVoid(struct soap *soap, const struct ns__echoVoid *a, const char *tag, const char *type)
{
	register int id = soap_embed(soap, (void*)a, NULL, 0, tag, SOAP_TYPE_ns__echoVoid);
	if (soap_out_ns__echoVoid(soap, tag, id, a, type))
		return soap->error;
	return soap_putindependent(soap);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out_ns__echoVoid(struct soap *soap, const char *tag, int id, const struct ns__echoVoid *a, const char *type)
{
	if (soap_element_begin_out(soap, tag, soap_embedded_id(soap, id, a, SOAP_TYPE_ns__echoVoid), type))
		return soap->error;
	return soap_element_end_out(soap, tag);
}

SOAP_FMAC3 struct ns__echoVoid * SOAP_FMAC4 soap_get_ns__echoVoid(struct soap *soap, struct ns__echoVoid *p, const char *tag, const char *type)
{
	if ((p = soap_in_ns__echoVoid(soap, tag, p, type)))
		if (soap_getindependent(soap))
			return NULL;
	return p;
}

SOAP_FMAC3 struct ns__echoVoid * SOAP_FMAC4 soap_in_ns__echoVoid(struct soap *soap, const char *tag, struct ns__echoVoid *a, const char *type)
{
	if (soap_element_begin_in(soap, tag, 0, type))
		return NULL;
	a = (struct ns__echoVoid *)soap_id_enter(soap, soap->id, a, SOAP_TYPE_ns__echoVoid, sizeof(struct ns__echoVoid), 0, NULL, NULL, NULL);
	if (!a)
		return NULL;
	soap_default_ns__echoVoid(soap, a);
	if (soap->body && !*soap->href)
	{
		for (;;)
		{	soap->error = SOAP_TAG_MISMATCH;
			if (soap->error == SOAP_TAG_MISMATCH)
				soap->error = soap_ignore_element(soap);
			if (soap->error == SOAP_NO_TAG)
				break;
			if (soap->error)
				return NULL;
		}
		if (soap_element_end_in(soap, tag))
			return NULL;
	}
	else
	{	a = (struct ns__echoVoid *)soap_id_forward(soap, soap->href, (void*)a, 0, SOAP_TYPE_ns__echoVoid, 0, sizeof(struct ns__echoVoid), 0, NULL);
		if (soap->body && soap_element_end_in(soap, tag))
			return NULL;
	}
	return a;
}

SOAP_FMAC5 struct ns__echoVoid * SOAP_FMAC6 soap_new_ns__echoVoid(struct soap *soap, int n)
{	return soap_instantiate_ns__echoVoid(soap, n, NULL, NULL, NULL);
}

SOAP_FMAC5 void SOAP_FMAC6 soap_delete_ns__echoVoid(struct soap *soap, struct ns__echoVoid *p)
{	soap_delete(soap, p);
}

SOAP_FMAC3 struct ns__echoVoid * SOAP_FMAC4 soap_instantiate_ns__echoVoid(struct soap *soap, int n, const char *type, const char *arrayType, size_t *size)
{
	DBGLOG(TEST, SOAP_MESSAGE(fdebug, "soap_instantiate_ns__echoVoid(%d, %s, %s)\n", n, type?type:"", arrayType?arrayType:""));
	struct soap_clist *cp = soap_link(soap, NULL, SOAP_TYPE_ns__echoVoid, n, soap_fdelete);
	if (!cp)
		return NULL;
	if (n < 0)
	{	cp->ptr = (void*)new struct ns__echoVoid;
		if (size)
			*size = sizeof(struct ns__echoVoid);
	}
	else
	{	cp->ptr = (void*)new struct ns__echoVoid[n];
		if (!cp->ptr)
		{	soap->error = SOAP_EOM;
			return NULL;
		}
		if (size)
			*size = n * sizeof(struct ns__echoVoid);
	}
		DBGLOG(TEST, SOAP_MESSAGE(fdebug, "Instantiated location=%p\n", cp->ptr));
	return (struct ns__echoVoid*)cp->ptr;
}
SOAP_FMAC3 void SOAP_FMAC4 soap_copy_ns__echoVoid(struct soap *soap, int st, int tt, void *p, size_t len, const void *q, size_t n)
{
	DBGLOG(TEST, SOAP_MESSAGE(fdebug, "Copying struct ns__echoVoid %p -> %p\n", q, p));
	*(struct ns__echoVoid*)p = *(struct ns__echoVoid*)q;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_default_ns__echoVoidResponse(struct soap *soap, struct ns__echoVoidResponse *a)
{
	(void)soap; (void)a; /* appease -Wall -Werror */
}

SOAP_FMAC3 void SOAP_FMAC4 soap_serialize_ns__echoVoidResponse(struct soap *soap, const struct ns__echoVoidResponse *a)
{
	(void)soap; (void)a; /* appease -Wall -Werror */
}

SOAP_FMAC3 int SOAP_FMAC4 soap_put_ns__echoVoidResponse(struct soap *soap, const struct ns__echoVoidResponse *a, const char *tag, const char *type)
{
	register int id = soap_embed(soap, (void*)a, NULL, 0, tag, SOAP_TYPE_ns__echoVoidResponse);
	if (soap_out_ns__echoVoidResponse(soap, tag, id, a, type))
		return soap->error;
	return soap_putindependent(soap);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out_ns__echoVoidResponse(struct soap *soap, const char *tag, int id, const struct ns__echoVoidResponse *a, const char *type)
{
	if (soap_element_begin_out(soap, tag, soap_embedded_id(soap, id, a, SOAP_TYPE_ns__echoVoidResponse), type))
		return soap->error;
	return soap_element_end_out(soap, tag);
}

SOAP_FMAC3 struct ns__echoVoidResponse * SOAP_FMAC4 soap_get_ns__echoVoidResponse(struct soap *soap, struct ns__echoVoidResponse *p, const char *tag, const char *type)
{
	if ((p = soap_in_ns__echoVoidResponse(soap, tag, p, type)))
		if (soap_getindependent(soap))
			return NULL;
	return p;
}

SOAP_FMAC3 struct ns__echoVoidResponse * SOAP_FMAC4 soap_in_ns__echoVoidResponse(struct soap *soap, const char *tag, struct ns__echoVoidResponse *a, const char *type)
{
	if (soap_element_begin_in(soap, tag, 0, type))
		return NULL;
	a = (struct ns__echoVoidResponse *)soap_id_enter(soap, soap->id, a, SOAP_TYPE_ns__echoVoidResponse, sizeof(struct ns__echoVoidResponse), 0, NULL, NULL, NULL);
	if (!a)
		return NULL;
	soap_default_ns__echoVoidResponse(soap, a);
	if (soap->body && !*soap->href)
	{
		for (;;)
		{	soap->error = SOAP_TAG_MISMATCH;
			if (soap->error == SOAP_TAG_MISMATCH)
				soap->error = soap_ignore_element(soap);
			if (soap->error == SOAP_NO_TAG)
				break;
			if (soap->error)
				return NULL;
		}
		if (soap_element_end_in(soap, tag))
			return NULL;
	}
	else
	{	a = (struct ns__echoVoidResponse *)soap_id_forward(soap, soap->href, (void*)a, 0, SOAP_TYPE_ns__echoVoidResponse, 0, sizeof(struct ns__echoVoidResponse), 0, NULL);
		if (soap->body && soap_element_end_in(soap, tag))
			return NULL;
	}
	return a;
}

SOAP_FMAC5 struct ns__echoVoidResponse * SOAP_FMAC6 soap_new_ns__echoVoidResponse(struct soap *soap, int n)
{	return soap_instantiate_ns__echoVoidResponse(soap, n, NULL, NULL, NULL);
}

SOAP_FMAC5 void SOAP_FMAC6 soap_delete_ns__echoVoidResponse(struct soap *soap, struct ns__echoVoidResponse *p)
{	soap_delete(soap, p);
}

SOAP_FMAC3 struct ns__echoVoidResponse * SOAP_FMAC4 soap_instantiate_ns__echoVoidResponse(struct soap *soap, int n, const char *type, const char *arrayType, size_t *size)
{
	DBGLOG(TEST, SOAP_MESSAGE(fdebug, "soap_instantiate_ns__echoVoidResponse(%d, %s, %s)\n", n, type?type:"", arrayType?arrayType:""));
	struct soap_clist *cp = soap_link(soap, NULL, SOAP_TYPE_ns__echoVoidResponse, n, soap_fdelete);
	if (!cp)
		return NULL;
	if (n < 0)
	{	cp->ptr = (void*)new struct ns__echoVoidResponse;
		if (size)
			*size = sizeof(struct ns__echoVoidResponse);
	}
	else
	{	cp->ptr = (void*)new struct ns__echoVoidResponse[n];
		if (!cp->ptr)
		{	soap->error = SOAP_EOM;
			return NULL;
		}
		if (size)
			*size = n * sizeof(struct ns__echoVoidResponse);
	}
		DBGLOG(TEST, SOAP_MESSAGE(fdebug, "Instantiated location=%p\n", cp->ptr));
	return (struct ns__echoVoidResponse*)cp->ptr;
}
SOAP_FMAC3 void SOAP_FMAC4 soap_copy_ns__echoVoidResponse(struct soap *soap, int st, int tt, void *p, size_t len, const void *q, size_t n)
{
	DBGLOG(TEST, SOAP_MESSAGE(fdebug, "Copying struct ns__echoVoidResponse %p -> %p\n", q, p));
	*(struct ns__echoVoidResponse*)p = *(struct ns__echoVoidResponse*)q;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_default_ns__echoStructArray(struct soap *soap, struct ns__echoStructArray *a)
{
	(void)soap; (void)a; /* appease -Wall -Werror */
	soap_default_ArrayOfSOAPStruct(soap, &a->inputStructArray);
}

SOAP_FMAC3 void SOAP_FMAC4 soap_serialize_ns__echoStructArray(struct soap *soap, const struct ns__echoStructArray *a)
{
	(void)soap; (void)a; /* appease -Wall -Werror */
	soap_serialize_ArrayOfSOAPStruct(soap, &a->inputStructArray);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_put_ns__echoStructArray(struct soap *soap, const struct ns__echoStructArray *a, const char *tag, const char *type)
{
	register int id = soap_embed(soap, (void*)a, NULL, 0, tag, SOAP_TYPE_ns__echoStructArray);
	if (soap_out_ns__echoStructArray(soap, tag, id, a, type))
		return soap->error;
	return soap_putindependent(soap);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out_ns__echoStructArray(struct soap *soap, const char *tag, int id, const struct ns__echoStructArray *a, const char *type)
{
	if (soap_element_begin_out(soap, tag, soap_embedded_id(soap, id, a, SOAP_TYPE_ns__echoStructArray), type))
		return soap->error;
	if (soap_out_ArrayOfSOAPStruct(soap, "inputStructArray", -1, &a->inputStructArray, ""))
		return soap->error;
	return soap_element_end_out(soap, tag);
}

SOAP_FMAC3 struct ns__echoStructArray * SOAP_FMAC4 soap_get_ns__echoStructArray(struct soap *soap, struct ns__echoStructArray *p, const char *tag, const char *type)
{
	if ((p = soap_in_ns__echoStructArray(soap, tag, p, type)))
		if (soap_getindependent(soap))
			return NULL;
	return p;
}

SOAP_FMAC3 struct ns__echoStructArray * SOAP_FMAC4 soap_in_ns__echoStructArray(struct soap *soap, const char *tag, struct ns__echoStructArray *a, const char *type)
{
	short soap_flag_inputStructArray = 1;
	if (soap_element_begin_in(soap, tag, 0, type))
		return NULL;
	a = (struct ns__echoStructArray *)soap_id_enter(soap, soap->id, a, SOAP_TYPE_ns__echoStructArray, sizeof(struct ns__echoStructArray), 0, NULL, NULL, NULL);
	if (!a)
		return NULL;
	soap_default_ns__echoStructArray(soap, a);
	if (soap->body && !*soap->href)
	{
		for (;;)
		{	soap->error = SOAP_TAG_MISMATCH;
			if (soap_flag_inputStructArray && soap->error == SOAP_TAG_MISMATCH)
				if (soap_in_ArrayOfSOAPStruct(soap, "inputStructArray", &a->inputStructArray, "s:SOAPStruct"))
				{	soap_flag_inputStructArray--;
					continue;
				}
			if (soap->error == SOAP_TAG_MISMATCH)
				soap->error = soap_ignore_element(soap);
			if (soap->error == SOAP_NO_TAG)
				break;
			if (soap->error)
				return NULL;
		}
		if (soap_element_end_in(soap, tag))
			return NULL;
	}
	else
	{	a = (struct ns__echoStructArray *)soap_id_forward(soap, soap->href, (void*)a, 0, SOAP_TYPE_ns__echoStructArray, 0, sizeof(struct ns__echoStructArray), 0, NULL);
		if (soap->body && soap_element_end_in(soap, tag))
			return NULL;
	}
	if ((soap->mode & SOAP_XML_STRICT) && (soap_flag_inputStructArray > 0))
	{	soap->error = SOAP_OCCURS;
		return NULL;
	}
	return a;
}

SOAP_FMAC5 struct ns__echoStructArray * SOAP_FMAC6 soap_new_ns__echoStructArray(struct soap *soap, int n)
{	return soap_instantiate_ns__echoStructArray(soap, n, NULL, NULL, NULL);
}

SOAP_FMAC5 void SOAP_FMAC6 soap_delete_ns__echoStructArray(struct soap *soap, struct ns__echoStructArray *p)
{	soap_delete(soap, p);
}

SOAP_FMAC3 struct ns__echoStructArray * SOAP_FMAC4 soap_instantiate_ns__echoStructArray(struct soap *soap, int n, const char *type, const char *arrayType, size_t *size)
{
	DBGLOG(TEST, SOAP_MESSAGE(fdebug, "soap_instantiate_ns__echoStructArray(%d, %s, %s)\n", n, type?type:"", arrayType?arrayType:""));
	struct soap_clist *cp = soap_link(soap, NULL, SOAP_TYPE_ns__echoStructArray, n, soap_fdelete);
	if (!cp)
		return NULL;
	if (n < 0)
	{	cp->ptr = (void*)new struct ns__echoStructArray;
		if (size)
			*size = sizeof(struct ns__echoStructArray);
	}
	else
	{	cp->ptr = (void*)new struct ns__echoStructArray[n];
		if (!cp->ptr)
		{	soap->error = SOAP_EOM;
			return NULL;
		}
		if (size)
			*size = n * sizeof(struct ns__echoStructArray);
	}
		DBGLOG(TEST, SOAP_MESSAGE(fdebug, "Instantiated location=%p\n", cp->ptr));
	return (struct ns__echoStructArray*)cp->ptr;
}
SOAP_FMAC3 void SOAP_FMAC4 soap_copy_ns__echoStructArray(struct soap *soap, int st, int tt, void *p, size_t len, const void *q, size_t n)
{
	DBGLOG(TEST, SOAP_MESSAGE(fdebug, "Copying struct ns__echoStructArray %p -> %p\n", q, p));
	*(struct ns__echoStructArray*)p = *(struct ns__echoStructArray*)q;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_default_ns__echoStructArrayResponse(struct soap *soap, struct ns__echoStructArrayResponse *a)
{
	(void)soap; (void)a; /* appease -Wall -Werror */
	soap_default_ArrayOfSOAPStruct(soap, &a->_return);
}

SOAP_FMAC3 void SOAP_FMAC4 soap_serialize_ns__echoStructArrayResponse(struct soap *soap, const struct ns__echoStructArrayResponse *a)
{
	(void)soap; (void)a; /* appease -Wall -Werror */
	soap_serialize_ArrayOfSOAPStruct(soap, &a->_return);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_put_ns__echoStructArrayResponse(struct soap *soap, const struct ns__echoStructArrayResponse *a, const char *tag, const char *type)
{
	register int id = soap_embed(soap, (void*)a, NULL, 0, tag, SOAP_TYPE_ns__echoStructArrayResponse);
	if (soap_out_ns__echoStructArrayResponse(soap, tag, id, a, type))
		return soap->error;
	return soap_putindependent(soap);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out_ns__echoStructArrayResponse(struct soap *soap, const char *tag, int id, const struct ns__echoStructArrayResponse *a, const char *type)
{
	if (soap_element_begin_out(soap, tag, soap_embedded_id(soap, id, a, SOAP_TYPE_ns__echoStructArrayResponse), type))
		return soap->error;
	if (soap_out_ArrayOfSOAPStruct(soap, "return", -1, &a->_return, ""))
		return soap->error;
	return soap_element_end_out(soap, tag);
}

SOAP_FMAC3 struct ns__echoStructArrayResponse * SOAP_FMAC4 soap_get_ns__echoStructArrayResponse(struct soap *soap, struct ns__echoStructArrayResponse *p, const char *tag, const char *type)
{
	if ((p = soap_in_ns__echoStructArrayResponse(soap, tag, p, type)))
		if (soap_getindependent(soap))
			return NULL;
	return p;
}

SOAP_FMAC3 struct ns__echoStructArrayResponse * SOAP_FMAC4 soap_in_ns__echoStructArrayResponse(struct soap *soap, const char *tag, struct ns__echoStructArrayResponse *a, const char *type)
{
	short soap_flag__return = 1;
	if (soap_element_begin_in(soap, tag, 0, type))
		return NULL;
	a = (struct ns__echoStructArrayResponse *)soap_id_enter(soap, soap->id, a, SOAP_TYPE_ns__echoStructArrayResponse, sizeof(struct ns__echoStructArrayResponse), 0, NULL, NULL, NULL);
	if (!a)
		return NULL;
	soap_default_ns__echoStructArrayResponse(soap, a);
	if (soap->body && !*soap->href)
	{
		for (;;)
		{	soap->error = SOAP_TAG_MISMATCH;
			if (soap_flag__return && soap->error == SOAP_TAG_MISMATCH)
				if (soap_in_ArrayOfSOAPStruct(soap, NULL, &a->_return, "s:SOAPStruct"))
				{	soap_flag__return--;
					continue;
				}
			if (soap->error == SOAP_TAG_MISMATCH)
				soap->error = soap_ignore_element(soap);
			if (soap->error == SOAP_NO_TAG)
				break;
			if (soap->error)
				return NULL;
		}
		if (soap_element_end_in(soap, tag))
			return NULL;
	}
	else
	{	a = (struct ns__echoStructArrayResponse *)soap_id_forward(soap, soap->href, (void*)a, 0, SOAP_TYPE_ns__echoStructArrayResponse, 0, sizeof(struct ns__echoStructArrayResponse), 0, NULL);
		if (soap->body && soap_element_end_in(soap, tag))
			return NULL;
	}
	if ((soap->mode & SOAP_XML_STRICT) && (soap_flag__return > 0))
	{	soap->error = SOAP_OCCURS;
		return NULL;
	}
	return a;
}

SOAP_FMAC5 struct ns__echoStructArrayResponse * SOAP_FMAC6 soap_new_ns__echoStructArrayResponse(struct soap *soap, int n)
{	return soap_instantiate_ns__echoStructArrayResponse(soap, n, NULL, NULL, NULL);
}

SOAP_FMAC5 void SOAP_FMAC6 soap_delete_ns__echoStructArrayResponse(struct soap *soap, struct ns__echoStructArrayResponse *p)
{	soap_delete(soap, p);
}

SOAP_FMAC3 struct ns__echoStructArrayResponse * SOAP_FMAC4 soap_instantiate_ns__echoStructArrayResponse(struct soap *soap, int n, const char *type, const char *arrayType, size_t *size)
{
	DBGLOG(TEST, SOAP_MESSAGE(fdebug, "soap_instantiate_ns__echoStructArrayResponse(%d, %s, %s)\n", n, type?type:"", arrayType?arrayType:""));
	struct soap_clist *cp = soap_link(soap, NULL, SOAP_TYPE_ns__echoStructArrayResponse, n, soap_fdelete);
	if (!cp)
		return NULL;
	if (n < 0)
	{	cp->ptr = (void*)new struct ns__echoStructArrayResponse;
		if (size)
			*size = sizeof(struct ns__echoStructArrayResponse);
	}
	else
	{	cp->ptr = (void*)new struct ns__echoStructArrayResponse[n];
		if (!cp->ptr)
		{	soap->error = SOAP_EOM;
			return NULL;
		}
		if (size)
			*size = n * sizeof(struct ns__echoStructArrayResponse);
	}
		DBGLOG(TEST, SOAP_MESSAGE(fdebug, "Instantiated location=%p\n", cp->ptr));
	return (struct ns__echoStructArrayResponse*)cp->ptr;
}
SOAP_FMAC3 void SOAP_FMAC4 soap_copy_ns__echoStructArrayResponse(struct soap *soap, int st, int tt, void *p, size_t len, const void *q, size_t n)
{
	DBGLOG(TEST, SOAP_MESSAGE(fdebug, "Copying struct ns__echoStructArrayResponse %p -> %p\n", q, p));
	*(struct ns__echoStructArrayResponse*)p = *(struct ns__echoStructArrayResponse*)q;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_default_ArrayOfSOAPStruct(struct soap *soap, struct ArrayOfSOAPStruct *a)
{
	a->__size = 0;
	a->__ptr = NULL;
	a->__offset = 0;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_serialize_ArrayOfSOAPStruct(struct soap *soap, struct ArrayOfSOAPStruct const*a)
{
	int i;
	if (a->__ptr && !soap_array_reference(soap, a, (struct soap_array*)&a->__ptr, 1, SOAP_TYPE_ArrayOfSOAPStruct))
		for (i = 0; i < a->__size; i++)
		{
			soap_serialize_PointerTos__SOAPStruct(soap, a->__ptr + i);
		}
}

SOAP_FMAC3 int SOAP_FMAC4 soap_put_ArrayOfSOAPStruct(struct soap *soap, const struct ArrayOfSOAPStruct *a, const char *tag, const char *type)
{
	register int id = soap_embed(soap, (void*)a, (struct soap_array*)&a->__ptr, 1, tag, SOAP_TYPE_ArrayOfSOAPStruct);
	if (soap_out_ArrayOfSOAPStruct(soap, tag, id, a, type))
		return soap->error;
	return soap_putindependent(soap);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out_ArrayOfSOAPStruct(struct soap *soap, const char *tag, int id, const struct ArrayOfSOAPStruct *a, const char *type)
{
	int i, n = a->__size;
	char *t = soap_putsize(soap, "s:SOAPStruct", n + a->__offset);
	id = soap_element_id(soap, tag, id, a, (struct soap_array*)&a->__ptr, 1, type, SOAP_TYPE_ArrayOfSOAPStruct);
	if (id < 0)
		return soap->error;
	if (soap_array_begin_out(soap, tag, id, t, soap_putoffset(soap, a->__offset)))
		return soap->error;
	for (i = 0; i < n; i++)
	{
		soap->position = 1;
		soap->positions[0] = i;
		soap_out_PointerTos__SOAPStruct(soap, "item", -1, &a->__ptr[i], "");
	}
	soap->position = 0;
	return soap_element_end_out(soap, tag);
}

SOAP_FMAC3 struct ArrayOfSOAPStruct * SOAP_FMAC4 soap_get_ArrayOfSOAPStruct(struct soap *soap, struct ArrayOfSOAPStruct *p, const char *tag, const char *type)
{
	if ((p = soap_in_ArrayOfSOAPStruct(soap, tag, p, type)))
		if (soap_getindependent(soap))
			return NULL;
	return p;
}

SOAP_FMAC3 struct ArrayOfSOAPStruct * SOAP_FMAC4 soap_in_ArrayOfSOAPStruct(struct soap *soap, const char *tag, struct ArrayOfSOAPStruct *a, const char *type)
{	int i, j;
	struct s__SOAPStruct **p;
	if (soap_element_begin_in(soap, tag, 1, NULL))
		return NULL;
	if (soap_match_array(soap, type))
	{	soap->error = SOAP_TYPE;
		return NULL;
	}
	a = (struct ArrayOfSOAPStruct *)soap_id_enter(soap, soap->id, a, SOAP_TYPE_ArrayOfSOAPStruct, sizeof(struct ArrayOfSOAPStruct), 0, NULL, NULL, NULL);
	if (!a)
		return NULL;
	soap_default_ArrayOfSOAPStruct(soap, a);
	if (soap->body && !*soap->href)
	{
		a->__size = soap_getsize(soap->arraySize, soap->arrayOffset, &j);
		a->__offset = j;
		if (a->__size >= 0)
		{	a->__ptr = (struct s__SOAPStruct **)soap_malloc(soap, sizeof(struct s__SOAPStruct *) * a->__size);
			for (i = 0; i < a->__size; i++)
				a->__ptr[i] = NULL;
			for (i = 0; i < a->__size; i++)
			{	soap_peek_element(soap);
				if (soap->position)
				{	i = soap->positions[0]-j;
					if (i < 0 || i >= a->__size)
					{	soap->error = SOAP_IOB;
						return NULL;
					}
				}
				if (!soap_in_PointerTos__SOAPStruct(soap, NULL, a->__ptr + i, "s:SOAPStruct"))
				{	if (soap->error != SOAP_NO_TAG)
						return NULL;
					soap->error = SOAP_OK;
					break;
				}
			}
		}
		else
		{	soap_new_block(soap);
			for (a->__size = 0; ; a->__size++)
			{	p = (struct s__SOAPStruct **)soap_push_block(soap, sizeof(struct s__SOAPStruct *));
				if (!p)
					return NULL;
				*p = NULL;
				if (!soap_in_PointerTos__SOAPStruct(soap, NULL, p, "s:SOAPStruct"))
				{	if (soap->error != SOAP_NO_TAG)
						return NULL;
					soap->error = SOAP_OK;
					break;
				}
			}
			soap_pop_block(soap);
			a->__ptr = (struct s__SOAPStruct **)soap_malloc(soap, soap->blist->size);
			soap_save_block(soap, (char*)a->__ptr, 1);
		}
		if (soap_element_end_in(soap, tag))
			return NULL;
	}
	else
	{	a = (struct ArrayOfSOAPStruct *)soap_id_forward(soap, soap->href, (void*)a, 0, SOAP_TYPE_ArrayOfSOAPStruct, 0, sizeof(struct ArrayOfSOAPStruct), 0, NULL);
		if (soap->body && soap_element_end_in(soap, tag))
			return NULL;
	}
	return a;
}

SOAP_FMAC5 struct ArrayOfSOAPStruct * SOAP_FMAC6 soap_new_ArrayOfSOAPStruct(struct soap *soap, int n)
{	return soap_instantiate_ArrayOfSOAPStruct(soap, n, NULL, NULL, NULL);
}

SOAP_FMAC5 void SOAP_FMAC6 soap_delete_ArrayOfSOAPStruct(struct soap *soap, struct ArrayOfSOAPStruct *p)
{	soap_delete(soap, p);
}

SOAP_FMAC3 struct ArrayOfSOAPStruct * SOAP_FMAC4 soap_instantiate_ArrayOfSOAPStruct(struct soap *soap, int n, const char *type, const char *arrayType, size_t *size)
{
	DBGLOG(TEST, SOAP_MESSAGE(fdebug, "soap_instantiate_ArrayOfSOAPStruct(%d, %s, %s)\n", n, type?type:"", arrayType?arrayType:""));
	struct soap_clist *cp = soap_link(soap, NULL, SOAP_TYPE_ArrayOfSOAPStruct, n, soap_fdelete);
	if (!cp)
		return NULL;
	if (n < 0)
	{	cp->ptr = (void*)new struct ArrayOfSOAPStruct;
		if (size)
			*size = sizeof(struct ArrayOfSOAPStruct);
	}
	else
	{	cp->ptr = (void*)new struct ArrayOfSOAPStruct[n];
		if (!cp->ptr)
		{	soap->error = SOAP_EOM;
			return NULL;
		}
		if (size)
			*size = n * sizeof(struct ArrayOfSOAPStruct);
	}
		DBGLOG(TEST, SOAP_MESSAGE(fdebug, "Instantiated location=%p\n", cp->ptr));
	return (struct ArrayOfSOAPStruct*)cp->ptr;
}
SOAP_FMAC3 void SOAP_FMAC4 soap_copy_ArrayOfSOAPStruct(struct soap *soap, int st, int tt, void *p, size_t len, const void *q, size_t n)
{
	DBGLOG(TEST, SOAP_MESSAGE(fdebug, "Copying struct ArrayOfSOAPStruct %p -> %p\n", q, p));
	*(struct ArrayOfSOAPStruct*)p = *(struct ArrayOfSOAPStruct*)q;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_default_ns__echoStruct(struct soap *soap, struct ns__echoStruct *a)
{
	(void)soap; (void)a; /* appease -Wall -Werror */
	soap_default_s__SOAPStruct(soap, &a->_inputStruct);
}

SOAP_FMAC3 void SOAP_FMAC4 soap_serialize_ns__echoStruct(struct soap *soap, const struct ns__echoStruct *a)
{
	(void)soap; (void)a; /* appease -Wall -Werror */
	soap_embedded(soap, &a->_inputStruct, SOAP_TYPE_s__SOAPStruct);
	soap_serialize_s__SOAPStruct(soap, &a->_inputStruct);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_put_ns__echoStruct(struct soap *soap, const struct ns__echoStruct *a, const char *tag, const char *type)
{
	register int id = soap_embed(soap, (void*)a, NULL, 0, tag, SOAP_TYPE_ns__echoStruct);
	if (soap_out_ns__echoStruct(soap, tag, id, a, type))
		return soap->error;
	return soap_putindependent(soap);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out_ns__echoStruct(struct soap *soap, const char *tag, int id, const struct ns__echoStruct *a, const char *type)
{
	if (soap_element_begin_out(soap, tag, soap_embedded_id(soap, id, a, SOAP_TYPE_ns__echoStruct), type))
		return soap->error;
	if (soap_out_s__SOAPStruct(soap, "inputStruct", -1, &a->_inputStruct, ""))
		return soap->error;
	return soap_element_end_out(soap, tag);
}

SOAP_FMAC3 struct ns__echoStruct * SOAP_FMAC4 soap_get_ns__echoStruct(struct soap *soap, struct ns__echoStruct *p, const char *tag, const char *type)
{
	if ((p = soap_in_ns__echoStruct(soap, tag, p, type)))
		if (soap_getindependent(soap))
			return NULL;
	return p;
}

SOAP_FMAC3 struct ns__echoStruct * SOAP_FMAC4 soap_in_ns__echoStruct(struct soap *soap, const char *tag, struct ns__echoStruct *a, const char *type)
{
	short soap_flag__inputStruct = 1;
	if (soap_element_begin_in(soap, tag, 0, type))
		return NULL;
	a = (struct ns__echoStruct *)soap_id_enter(soap, soap->id, a, SOAP_TYPE_ns__echoStruct, sizeof(struct ns__echoStruct), 0, NULL, NULL, NULL);
	if (!a)
		return NULL;
	soap_default_ns__echoStruct(soap, a);
	if (soap->body && !*soap->href)
	{
		for (;;)
		{	soap->error = SOAP_TAG_MISMATCH;
			if (soap_flag__inputStruct && soap->error == SOAP_TAG_MISMATCH)
				if (soap_in_s__SOAPStruct(soap, NULL, &a->_inputStruct, "s:SOAPStruct"))
				{	soap_flag__inputStruct--;
					continue;
				}
			if (soap->error == SOAP_TAG_MISMATCH)
				soap->error = soap_ignore_element(soap);
			if (soap->error == SOAP_NO_TAG)
				break;
			if (soap->error)
				return NULL;
		}
		if (soap_element_end_in(soap, tag))
			return NULL;
	}
	else
	{	a = (struct ns__echoStruct *)soap_id_forward(soap, soap->href, (void*)a, 0, SOAP_TYPE_ns__echoStruct, 0, sizeof(struct ns__echoStruct), 0, NULL);
		if (soap->body && soap_element_end_in(soap, tag))
			return NULL;
	}
	if ((soap->mode & SOAP_XML_STRICT) && (soap_flag__inputStruct > 0))
	{	soap->error = SOAP_OCCURS;
		return NULL;
	}
	return a;
}

SOAP_FMAC5 struct ns__echoStruct * SOAP_FMAC6 soap_new_ns__echoStruct(struct soap *soap, int n)
{	return soap_instantiate_ns__echoStruct(soap, n, NULL, NULL, NULL);
}

SOAP_FMAC5 void SOAP_FMAC6 soap_delete_ns__echoStruct(struct soap *soap, struct ns__echoStruct *p)
{	soap_delete(soap, p);
}

SOAP_FMAC3 struct ns__echoStruct * SOAP_FMAC4 soap_instantiate_ns__echoStruct(struct soap *soap, int n, const char *type, const char *arrayType, size_t *size)
{
	DBGLOG(TEST, SOAP_MESSAGE(fdebug, "soap_instantiate_ns__echoStruct(%d, %s, %s)\n", n, type?type:"", arrayType?arrayType:""));
	struct soap_clist *cp = soap_link(soap, NULL, SOAP_TYPE_ns__echoStruct, n, soap_fdelete);
	if (!cp)
		return NULL;
	if (n < 0)
	{	cp->ptr = (void*)new struct ns__echoStruct;
		if (size)
			*size = sizeof(struct ns__echoStruct);
	}
	else
	{	cp->ptr = (void*)new struct ns__echoStruct[n];
		if (!cp->ptr)
		{	soap->error = SOAP_EOM;
			return NULL;
		}
		if (size)
			*size = n * sizeof(struct ns__echoStruct);
	}
		DBGLOG(TEST, SOAP_MESSAGE(fdebug, "Instantiated location=%p\n", cp->ptr));
	return (struct ns__echoStruct*)cp->ptr;
}
SOAP_FMAC3 void SOAP_FMAC4 soap_copy_ns__echoStruct(struct soap *soap, int st, int tt, void *p, size_t len, const void *q, size_t n)
{
	DBGLOG(TEST, SOAP_MESSAGE(fdebug, "Copying struct ns__echoStruct %p -> %p\n", q, p));
	*(struct ns__echoStruct*)p = *(struct ns__echoStruct*)q;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_default_ns__echoStructResponse(struct soap *soap, struct ns__echoStructResponse *a)
{
	(void)soap; (void)a; /* appease -Wall -Werror */
	soap_default_s__SOAPStruct(soap, &a->_return);
}

SOAP_FMAC3 void SOAP_FMAC4 soap_serialize_ns__echoStructResponse(struct soap *soap, const struct ns__echoStructResponse *a)
{
	(void)soap; (void)a; /* appease -Wall -Werror */
	soap_embedded(soap, &a->_return, SOAP_TYPE_s__SOAPStruct);
	soap_serialize_s__SOAPStruct(soap, &a->_return);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_put_ns__echoStructResponse(struct soap *soap, const struct ns__echoStructResponse *a, const char *tag, const char *type)
{
	register int id = soap_embed(soap, (void*)a, NULL, 0, tag, SOAP_TYPE_ns__echoStructResponse);
	if (soap_out_ns__echoStructResponse(soap, tag, id, a, type))
		return soap->error;
	return soap_putindependent(soap);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out_ns__echoStructResponse(struct soap *soap, const char *tag, int id, const struct ns__echoStructResponse *a, const char *type)
{
	if (soap_element_begin_out(soap, tag, soap_embedded_id(soap, id, a, SOAP_TYPE_ns__echoStructResponse), type))
		return soap->error;
	if (soap_out_s__SOAPStruct(soap, "return", -1, &a->_return, ""))
		return soap->error;
	return soap_element_end_out(soap, tag);
}

SOAP_FMAC3 struct ns__echoStructResponse * SOAP_FMAC4 soap_get_ns__echoStructResponse(struct soap *soap, struct ns__echoStructResponse *p, const char *tag, const char *type)
{
	if ((p = soap_in_ns__echoStructResponse(soap, tag, p, type)))
		if (soap_getindependent(soap))
			return NULL;
	return p;
}

SOAP_FMAC3 struct ns__echoStructResponse * SOAP_FMAC4 soap_in_ns__echoStructResponse(struct soap *soap, const char *tag, struct ns__echoStructResponse *a, const char *type)
{
	short soap_flag__return = 1;
	if (soap_element_begin_in(soap, tag, 0, type))
		return NULL;
	a = (struct ns__echoStructResponse *)soap_id_enter(soap, soap->id, a, SOAP_TYPE_ns__echoStructResponse, sizeof(struct ns__echoStructResponse), 0, NULL, NULL, NULL);
	if (!a)
		return NULL;
	soap_default_ns__echoStructResponse(soap, a);
	if (soap->body && !*soap->href)
	{
		for (;;)
		{	soap->error = SOAP_TAG_MISMATCH;
			if (soap_flag__return && soap->error == SOAP_TAG_MISMATCH)
				if (soap_in_s__SOAPStruct(soap, NULL, &a->_return, "s:SOAPStruct"))
				{	soap_flag__return--;
					continue;
				}
			if (soap->error == SOAP_TAG_MISMATCH)
				soap->error = soap_ignore_element(soap);
			if (soap->error == SOAP_NO_TAG)
				break;
			if (soap->error)
				return NULL;
		}
		if (soap_element_end_in(soap, tag))
			return NULL;
	}
	else
	{	a = (struct ns__echoStructResponse *)soap_id_forward(soap, soap->href, (void*)a, 0, SOAP_TYPE_ns__echoStructResponse, 0, sizeof(struct ns__echoStructResponse), 0, NULL);
		if (soap->body && soap_element_end_in(soap, tag))
			return NULL;
	}
	if ((soap->mode & SOAP_XML_STRICT) && (soap_flag__return > 0))
	{	soap->error = SOAP_OCCURS;
		return NULL;
	}
	return a;
}

SOAP_FMAC5 struct ns__echoStructResponse * SOAP_FMAC6 soap_new_ns__echoStructResponse(struct soap *soap, int n)
{	return soap_instantiate_ns__echoStructResponse(soap, n, NULL, NULL, NULL);
}

SOAP_FMAC5 void SOAP_FMAC6 soap_delete_ns__echoStructResponse(struct soap *soap, struct ns__echoStructResponse *p)
{	soap_delete(soap, p);
}

SOAP_FMAC3 struct ns__echoStructResponse * SOAP_FMAC4 soap_instantiate_ns__echoStructResponse(struct soap *soap, int n, const char *type, const char *arrayType, size_t *size)
{
	DBGLOG(TEST, SOAP_MESSAGE(fdebug, "soap_instantiate_ns__echoStructResponse(%d, %s, %s)\n", n, type?type:"", arrayType?arrayType:""));
	struct soap_clist *cp = soap_link(soap, NULL, SOAP_TYPE_ns__echoStructResponse, n, soap_fdelete);
	if (!cp)
		return NULL;
	if (n < 0)
	{	cp->ptr = (void*)new struct ns__echoStructResponse;
		if (size)
			*size = sizeof(struct ns__echoStructResponse);
	}
	else
	{	cp->ptr = (void*)new struct ns__echoStructResponse[n];
		if (!cp->ptr)
		{	soap->error = SOAP_EOM;
			return NULL;
		}
		if (size)
			*size = n * sizeof(struct ns__echoStructResponse);
	}
		DBGLOG(TEST, SOAP_MESSAGE(fdebug, "Instantiated location=%p\n", cp->ptr));
	return (struct ns__echoStructResponse*)cp->ptr;
}
SOAP_FMAC3 void SOAP_FMAC4 soap_copy_ns__echoStructResponse(struct soap *soap, int st, int tt, void *p, size_t len, const void *q, size_t n)
{
	DBGLOG(TEST, SOAP_MESSAGE(fdebug, "Copying struct ns__echoStructResponse %p -> %p\n", q, p));
	*(struct ns__echoStructResponse*)p = *(struct ns__echoStructResponse*)q;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_default_s__SOAPStruct(struct soap *soap, struct s__SOAPStruct *a)
{
	(void)soap; (void)a; /* appease -Wall -Werror */
	soap_default_xsd__string(soap, &a->varString);
	a->varInt = NULL;
	a->varFloat = NULL;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_serialize_s__SOAPStruct(struct soap *soap, const struct s__SOAPStruct *a)
{
	(void)soap; (void)a; /* appease -Wall -Werror */
	soap_serialize_xsd__string(soap, &a->varString);
	soap_serialize_PointerToxsd__int(soap, &a->varInt);
	soap_serialize_PointerToxsd__float(soap, &a->varFloat);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_put_s__SOAPStruct(struct soap *soap, const struct s__SOAPStruct *a, const char *tag, const char *type)
{
	register int id = soap_embed(soap, (void*)a, NULL, 0, tag, SOAP_TYPE_s__SOAPStruct);
	if (soap_out_s__SOAPStruct(soap, tag, id, a, type))
		return soap->error;
	return soap_putindependent(soap);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out_s__SOAPStruct(struct soap *soap, const char *tag, int id, const struct s__SOAPStruct *a, const char *type)
{
	if (soap_element_begin_out(soap, tag, soap_embedded_id(soap, id, a, SOAP_TYPE_s__SOAPStruct), type))
		return soap->error;
	if (soap_out_xsd__string(soap, "varString", -1, &a->varString, ""))
		return soap->error;
	if (soap_out_PointerToxsd__int(soap, "varInt", -1, &a->varInt, ""))
		return soap->error;
	if (soap_out_PointerToxsd__float(soap, "varFloat", -1, &a->varFloat, ""))
		return soap->error;
	return soap_element_end_out(soap, tag);
}

SOAP_FMAC3 struct s__SOAPStruct * SOAP_FMAC4 soap_get_s__SOAPStruct(struct soap *soap, struct s__SOAPStruct *p, const char *tag, const char *type)
{
	if ((p = soap_in_s__SOAPStruct(soap, tag, p, type)))
		if (soap_getindependent(soap))
			return NULL;
	return p;
}

SOAP_FMAC3 struct s__SOAPStruct * SOAP_FMAC4 soap_in_s__SOAPStruct(struct soap *soap, const char *tag, struct s__SOAPStruct *a, const char *type)
{
	short soap_flag_varString = 1, soap_flag_varInt = 1, soap_flag_varFloat = 1;
	if (soap_element_begin_in(soap, tag, 0, type))
		return NULL;
	a = (struct s__SOAPStruct *)soap_id_enter(soap, soap->id, a, SOAP_TYPE_s__SOAPStruct, sizeof(struct s__SOAPStruct), 0, NULL, NULL, NULL);
	if (!a)
		return NULL;
	soap_default_s__SOAPStruct(soap, a);
	if (soap->body && !*soap->href)
	{
		for (;;)
		{	soap->error = SOAP_TAG_MISMATCH;
			if (soap_flag_varString && (soap->error == SOAP_TAG_MISMATCH || soap->error == SOAP_NO_TAG))
				if (soap_in_xsd__string(soap, "varString", &a->varString, "xsd:string"))
				{	soap_flag_varString--;
					continue;
				}
			if (soap_flag_varInt && soap->error == SOAP_TAG_MISMATCH)
				if (soap_in_PointerToxsd__int(soap, "varInt", &a->varInt, "xsd:int"))
				{	soap_flag_varInt--;
					continue;
				}
			if (soap_flag_varFloat && soap->error == SOAP_TAG_MISMATCH)
				if (soap_in_PointerToxsd__float(soap, "varFloat", &a->varFloat, "xsd:float"))
				{	soap_flag_varFloat--;
					continue;
				}
			if (soap->error == SOAP_TAG_MISMATCH)
				soap->error = soap_ignore_element(soap);
			if (soap->error == SOAP_NO_TAG)
				break;
			if (soap->error)
				return NULL;
		}
		if (soap_element_end_in(soap, tag))
			return NULL;
	}
	else
	{	a = (struct s__SOAPStruct *)soap_id_forward(soap, soap->href, (void*)a, 0, SOAP_TYPE_s__SOAPStruct, 0, sizeof(struct s__SOAPStruct), 0, NULL);
		if (soap->body && soap_element_end_in(soap, tag))
			return NULL;
	}
	return a;
}

SOAP_FMAC5 struct s__SOAPStruct * SOAP_FMAC6 soap_new_s__SOAPStruct(struct soap *soap, int n)
{	return soap_instantiate_s__SOAPStruct(soap, n, NULL, NULL, NULL);
}

SOAP_FMAC5 void SOAP_FMAC6 soap_delete_s__SOAPStruct(struct soap *soap, struct s__SOAPStruct *p)
{	soap_delete(soap, p);
}

SOAP_FMAC3 struct s__SOAPStruct * SOAP_FMAC4 soap_instantiate_s__SOAPStruct(struct soap *soap, int n, const char *type, const char *arrayType, size_t *size)
{
	DBGLOG(TEST, SOAP_MESSAGE(fdebug, "soap_instantiate_s__SOAPStruct(%d, %s, %s)\n", n, type?type:"", arrayType?arrayType:""));
	struct soap_clist *cp = soap_link(soap, NULL, SOAP_TYPE_s__SOAPStruct, n, soap_fdelete);
	if (!cp)
		return NULL;
	if (n < 0)
	{	cp->ptr = (void*)new struct s__SOAPStruct;
		if (size)
			*size = sizeof(struct s__SOAPStruct);
	}
	else
	{	cp->ptr = (void*)new struct s__SOAPStruct[n];
		if (!cp->ptr)
		{	soap->error = SOAP_EOM;
			return NULL;
		}
		if (size)
			*size = n * sizeof(struct s__SOAPStruct);
	}
		DBGLOG(TEST, SOAP_MESSAGE(fdebug, "Instantiated location=%p\n", cp->ptr));
	return (struct s__SOAPStruct*)cp->ptr;
}
SOAP_FMAC3 void SOAP_FMAC4 soap_copy_s__SOAPStruct(struct soap *soap, int st, int tt, void *p, size_t len, const void *q, size_t n)
{
	DBGLOG(TEST, SOAP_MESSAGE(fdebug, "Copying struct s__SOAPStruct %p -> %p\n", q, p));
	*(struct s__SOAPStruct*)p = *(struct s__SOAPStruct*)q;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_default_ns__echoFloatArray(struct soap *soap, struct ns__echoFloatArray *a)
{
	(void)soap; (void)a; /* appease -Wall -Werror */
	soap_default_ArrayOffloat(soap, &a->inputFloatArray);
}

SOAP_FMAC3 void SOAP_FMAC4 soap_serialize_ns__echoFloatArray(struct soap *soap, const struct ns__echoFloatArray *a)
{
	(void)soap; (void)a; /* appease -Wall -Werror */
	soap_serialize_ArrayOffloat(soap, &a->inputFloatArray);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_put_ns__echoFloatArray(struct soap *soap, const struct ns__echoFloatArray *a, const char *tag, const char *type)
{
	register int id = soap_embed(soap, (void*)a, NULL, 0, tag, SOAP_TYPE_ns__echoFloatArray);
	if (soap_out_ns__echoFloatArray(soap, tag, id, a, type))
		return soap->error;
	return soap_putindependent(soap);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out_ns__echoFloatArray(struct soap *soap, const char *tag, int id, const struct ns__echoFloatArray *a, const char *type)
{
	if (soap_element_begin_out(soap, tag, soap_embedded_id(soap, id, a, SOAP_TYPE_ns__echoFloatArray), type))
		return soap->error;
	if (soap_out_ArrayOffloat(soap, "inputFloatArray", -1, &a->inputFloatArray, ""))
		return soap->error;
	return soap_element_end_out(soap, tag);
}

SOAP_FMAC3 struct ns__echoFloatArray * SOAP_FMAC4 soap_get_ns__echoFloatArray(struct soap *soap, struct ns__echoFloatArray *p, const char *tag, const char *type)
{
	if ((p = soap_in_ns__echoFloatArray(soap, tag, p, type)))
		if (soap_getindependent(soap))
			return NULL;
	return p;
}

SOAP_FMAC3 struct ns__echoFloatArray * SOAP_FMAC4 soap_in_ns__echoFloatArray(struct soap *soap, const char *tag, struct ns__echoFloatArray *a, const char *type)
{
	short soap_flag_inputFloatArray = 1;
	if (soap_element_begin_in(soap, tag, 0, type))
		return NULL;
	a = (struct ns__echoFloatArray *)soap_id_enter(soap, soap->id, a, SOAP_TYPE_ns__echoFloatArray, sizeof(struct ns__echoFloatArray), 0, NULL, NULL, NULL);
	if (!a)
		return NULL;
	soap_default_ns__echoFloatArray(soap, a);
	if (soap->body && !*soap->href)
	{
		for (;;)
		{	soap->error = SOAP_TAG_MISMATCH;
			if (soap_flag_inputFloatArray && soap->error == SOAP_TAG_MISMATCH)
				if (soap_in_ArrayOffloat(soap, "inputFloatArray", &a->inputFloatArray, "xsd:float"))
				{	soap_flag_inputFloatArray--;
					continue;
				}
			if (soap->error == SOAP_TAG_MISMATCH)
				soap->error = soap_ignore_element(soap);
			if (soap->error == SOAP_NO_TAG)
				break;
			if (soap->error)
				return NULL;
		}
		if (soap_element_end_in(soap, tag))
			return NULL;
	}
	else
	{	a = (struct ns__echoFloatArray *)soap_id_forward(soap, soap->href, (void*)a, 0, SOAP_TYPE_ns__echoFloatArray, 0, sizeof(struct ns__echoFloatArray), 0, NULL);
		if (soap->body && soap_element_end_in(soap, tag))
			return NULL;
	}
	if ((soap->mode & SOAP_XML_STRICT) && (soap_flag_inputFloatArray > 0))
	{	soap->error = SOAP_OCCURS;
		return NULL;
	}
	return a;
}

SOAP_FMAC5 struct ns__echoFloatArray * SOAP_FMAC6 soap_new_ns__echoFloatArray(struct soap *soap, int n)
{	return soap_instantiate_ns__echoFloatArray(soap, n, NULL, NULL, NULL);
}

SOAP_FMAC5 void SOAP_FMAC6 soap_delete_ns__echoFloatArray(struct soap *soap, struct ns__echoFloatArray *p)
{	soap_delete(soap, p);
}

SOAP_FMAC3 struct ns__echoFloatArray * SOAP_FMAC4 soap_instantiate_ns__echoFloatArray(struct soap *soap, int n, const char *type, const char *arrayType, size_t *size)
{
	DBGLOG(TEST, SOAP_MESSAGE(fdebug, "soap_instantiate_ns__echoFloatArray(%d, %s, %s)\n", n, type?type:"", arrayType?arrayType:""));
	struct soap_clist *cp = soap_link(soap, NULL, SOAP_TYPE_ns__echoFloatArray, n, soap_fdelete);
	if (!cp)
		return NULL;
	if (n < 0)
	{	cp->ptr = (void*)new struct ns__echoFloatArray;
		if (size)
			*size = sizeof(struct ns__echoFloatArray);
	}
	else
	{	cp->ptr = (void*)new struct ns__echoFloatArray[n];
		if (!cp->ptr)
		{	soap->error = SOAP_EOM;
			return NULL;
		}
		if (size)
			*size = n * sizeof(struct ns__echoFloatArray);
	}
		DBGLOG(TEST, SOAP_MESSAGE(fdebug, "Instantiated location=%p\n", cp->ptr));
	return (struct ns__echoFloatArray*)cp->ptr;
}
SOAP_FMAC3 void SOAP_FMAC4 soap_copy_ns__echoFloatArray(struct soap *soap, int st, int tt, void *p, size_t len, const void *q, size_t n)
{
	DBGLOG(TEST, SOAP_MESSAGE(fdebug, "Copying struct ns__echoFloatArray %p -> %p\n", q, p));
	*(struct ns__echoFloatArray*)p = *(struct ns__echoFloatArray*)q;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_default_ns__echoFloatArrayResponse(struct soap *soap, struct ns__echoFloatArrayResponse *a)
{
	(void)soap; (void)a; /* appease -Wall -Werror */
	soap_default_ArrayOffloat(soap, &a->_return);
}

SOAP_FMAC3 void SOAP_FMAC4 soap_serialize_ns__echoFloatArrayResponse(struct soap *soap, const struct ns__echoFloatArrayResponse *a)
{
	(void)soap; (void)a; /* appease -Wall -Werror */
	soap_serialize_ArrayOffloat(soap, &a->_return);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_put_ns__echoFloatArrayResponse(struct soap *soap, const struct ns__echoFloatArrayResponse *a, const char *tag, const char *type)
{
	register int id = soap_embed(soap, (void*)a, NULL, 0, tag, SOAP_TYPE_ns__echoFloatArrayResponse);
	if (soap_out_ns__echoFloatArrayResponse(soap, tag, id, a, type))
		return soap->error;
	return soap_putindependent(soap);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out_ns__echoFloatArrayResponse(struct soap *soap, const char *tag, int id, const struct ns__echoFloatArrayResponse *a, const char *type)
{
	if (soap_element_begin_out(soap, tag, soap_embedded_id(soap, id, a, SOAP_TYPE_ns__echoFloatArrayResponse), type))
		return soap->error;
	if (soap_out_ArrayOffloat(soap, "return", -1, &a->_return, ""))
		return soap->error;
	return soap_element_end_out(soap, tag);
}

SOAP_FMAC3 struct ns__echoFloatArrayResponse * SOAP_FMAC4 soap_get_ns__echoFloatArrayResponse(struct soap *soap, struct ns__echoFloatArrayResponse *p, const char *tag, const char *type)
{
	if ((p = soap_in_ns__echoFloatArrayResponse(soap, tag, p, type)))
		if (soap_getindependent(soap))
			return NULL;
	return p;
}

SOAP_FMAC3 struct ns__echoFloatArrayResponse * SOAP_FMAC4 soap_in_ns__echoFloatArrayResponse(struct soap *soap, const char *tag, struct ns__echoFloatArrayResponse *a, const char *type)
{
	short soap_flag__return = 1;
	if (soap_element_begin_in(soap, tag, 0, type))
		return NULL;
	a = (struct ns__echoFloatArrayResponse *)soap_id_enter(soap, soap->id, a, SOAP_TYPE_ns__echoFloatArrayResponse, sizeof(struct ns__echoFloatArrayResponse), 0, NULL, NULL, NULL);
	if (!a)
		return NULL;
	soap_default_ns__echoFloatArrayResponse(soap, a);
	if (soap->body && !*soap->href)
	{
		for (;;)
		{	soap->error = SOAP_TAG_MISMATCH;
			if (soap_flag__return && soap->error == SOAP_TAG_MISMATCH)
				if (soap_in_ArrayOffloat(soap, NULL, &a->_return, "xsd:float"))
				{	soap_flag__return--;
					continue;
				}
			if (soap->error == SOAP_TAG_MISMATCH)
				soap->error = soap_ignore_element(soap);
			if (soap->error == SOAP_NO_TAG)
				break;
			if (soap->error)
				return NULL;
		}
		if (soap_element_end_in(soap, tag))
			return NULL;
	}
	else
	{	a = (struct ns__echoFloatArrayResponse *)soap_id_forward(soap, soap->href, (void*)a, 0, SOAP_TYPE_ns__echoFloatArrayResponse, 0, sizeof(struct ns__echoFloatArrayResponse), 0, NULL);
		if (soap->body && soap_element_end_in(soap, tag))
			return NULL;
	}
	if ((soap->mode & SOAP_XML_STRICT) && (soap_flag__return > 0))
	{	soap->error = SOAP_OCCURS;
		return NULL;
	}
	return a;
}

SOAP_FMAC5 struct ns__echoFloatArrayResponse * SOAP_FMAC6 soap_new_ns__echoFloatArrayResponse(struct soap *soap, int n)
{	return soap_instantiate_ns__echoFloatArrayResponse(soap, n, NULL, NULL, NULL);
}

SOAP_FMAC5 void SOAP_FMAC6 soap_delete_ns__echoFloatArrayResponse(struct soap *soap, struct ns__echoFloatArrayResponse *p)
{	soap_delete(soap, p);
}

SOAP_FMAC3 struct ns__echoFloatArrayResponse * SOAP_FMAC4 soap_instantiate_ns__echoFloatArrayResponse(struct soap *soap, int n, const char *type, const char *arrayType, size_t *size)
{
	DBGLOG(TEST, SOAP_MESSAGE(fdebug, "soap_instantiate_ns__echoFloatArrayResponse(%d, %s, %s)\n", n, type?type:"", arrayType?arrayType:""));
	struct soap_clist *cp = soap_link(soap, NULL, SOAP_TYPE_ns__echoFloatArrayResponse, n, soap_fdelete);
	if (!cp)
		return NULL;
	if (n < 0)
	{	cp->ptr = (void*)new struct ns__echoFloatArrayResponse;
		if (size)
			*size = sizeof(struct ns__echoFloatArrayResponse);
	}
	else
	{	cp->ptr = (void*)new struct ns__echoFloatArrayResponse[n];
		if (!cp->ptr)
		{	soap->error = SOAP_EOM;
			return NULL;
		}
		if (size)
			*size = n * sizeof(struct ns__echoFloatArrayResponse);
	}
		DBGLOG(TEST, SOAP_MESSAGE(fdebug, "Instantiated location=%p\n", cp->ptr));
	return (struct ns__echoFloatArrayResponse*)cp->ptr;
}
SOAP_FMAC3 void SOAP_FMAC4 soap_copy_ns__echoFloatArrayResponse(struct soap *soap, int st, int tt, void *p, size_t len, const void *q, size_t n)
{
	DBGLOG(TEST, SOAP_MESSAGE(fdebug, "Copying struct ns__echoFloatArrayResponse %p -> %p\n", q, p));
	*(struct ns__echoFloatArrayResponse*)p = *(struct ns__echoFloatArrayResponse*)q;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_default_ArrayOffloat(struct soap *soap, struct ArrayOffloat *a)
{
	a->__size = 0;
	a->__ptr = NULL;
	a->__offset = 0;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_serialize_ArrayOffloat(struct soap *soap, struct ArrayOffloat const*a)
{
	int i;
	if (a->__ptr && !soap_array_reference(soap, a, (struct soap_array*)&a->__ptr, 1, SOAP_TYPE_ArrayOffloat))
		for (i = 0; i < a->__size; i++)
		{
			soap_serialize_PointerToxsd__float(soap, a->__ptr + i);
		}
}

SOAP_FMAC3 int SOAP_FMAC4 soap_put_ArrayOffloat(struct soap *soap, const struct ArrayOffloat *a, const char *tag, const char *type)
{
	register int id = soap_embed(soap, (void*)a, (struct soap_array*)&a->__ptr, 1, tag, SOAP_TYPE_ArrayOffloat);
	if (soap_out_ArrayOffloat(soap, tag, id, a, type))
		return soap->error;
	return soap_putindependent(soap);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out_ArrayOffloat(struct soap *soap, const char *tag, int id, const struct ArrayOffloat *a, const char *type)
{
	int i, n = a->__size;
	char *t = soap_putsize(soap, "xsd:float", n + a->__offset);
	id = soap_element_id(soap, tag, id, a, (struct soap_array*)&a->__ptr, 1, type, SOAP_TYPE_ArrayOffloat);
	if (id < 0)
		return soap->error;
	if (soap_array_begin_out(soap, tag, id, t, soap_putoffset(soap, a->__offset)))
		return soap->error;
	for (i = 0; i < n; i++)
	{
		soap->position = 1;
		soap->positions[0] = i;
		soap_out_PointerToxsd__float(soap, "item", -1, &a->__ptr[i], "");
	}
	soap->position = 0;
	return soap_element_end_out(soap, tag);
}

SOAP_FMAC3 struct ArrayOffloat * SOAP_FMAC4 soap_get_ArrayOffloat(struct soap *soap, struct ArrayOffloat *p, const char *tag, const char *type)
{
	if ((p = soap_in_ArrayOffloat(soap, tag, p, type)))
		if (soap_getindependent(soap))
			return NULL;
	return p;
}

SOAP_FMAC3 struct ArrayOffloat * SOAP_FMAC4 soap_in_ArrayOffloat(struct soap *soap, const char *tag, struct ArrayOffloat *a, const char *type)
{	int i, j;
	float **p;
	if (soap_element_begin_in(soap, tag, 1, NULL))
		return NULL;
	if (soap_match_array(soap, type))
	{	soap->error = SOAP_TYPE;
		return NULL;
	}
	a = (struct ArrayOffloat *)soap_id_enter(soap, soap->id, a, SOAP_TYPE_ArrayOffloat, sizeof(struct ArrayOffloat), 0, NULL, NULL, NULL);
	if (!a)
		return NULL;
	soap_default_ArrayOffloat(soap, a);
	if (soap->body && !*soap->href)
	{
		a->__size = soap_getsize(soap->arraySize, soap->arrayOffset, &j);
		a->__offset = j;
		if (a->__size >= 0)
		{	a->__ptr = (float **)soap_malloc(soap, sizeof(float *) * a->__size);
			for (i = 0; i < a->__size; i++)
				a->__ptr[i] = NULL;
			for (i = 0; i < a->__size; i++)
			{	soap_peek_element(soap);
				if (soap->position)
				{	i = soap->positions[0]-j;
					if (i < 0 || i >= a->__size)
					{	soap->error = SOAP_IOB;
						return NULL;
					}
				}
				if (!soap_in_PointerToxsd__float(soap, NULL, a->__ptr + i, "xsd:float"))
				{	if (soap->error != SOAP_NO_TAG)
						return NULL;
					soap->error = SOAP_OK;
					break;
				}
			}
		}
		else
		{	soap_new_block(soap);
			for (a->__size = 0; ; a->__size++)
			{	p = (float **)soap_push_block(soap, sizeof(float *));
				if (!p)
					return NULL;
				*p = NULL;
				if (!soap_in_PointerToxsd__float(soap, NULL, p, "xsd:float"))
				{	if (soap->error != SOAP_NO_TAG)
						return NULL;
					soap->error = SOAP_OK;
					break;
				}
			}
			soap_pop_block(soap);
			a->__ptr = (float **)soap_malloc(soap, soap->blist->size);
			soap_save_block(soap, (char*)a->__ptr, 1);
		}
		if (soap_element_end_in(soap, tag))
			return NULL;
	}
	else
	{	a = (struct ArrayOffloat *)soap_id_forward(soap, soap->href, (void*)a, 0, SOAP_TYPE_ArrayOffloat, 0, sizeof(struct ArrayOffloat), 0, NULL);
		if (soap->body && soap_element_end_in(soap, tag))
			return NULL;
	}
	return a;
}

SOAP_FMAC5 struct ArrayOffloat * SOAP_FMAC6 soap_new_ArrayOffloat(struct soap *soap, int n)
{	return soap_instantiate_ArrayOffloat(soap, n, NULL, NULL, NULL);
}

SOAP_FMAC5 void SOAP_FMAC6 soap_delete_ArrayOffloat(struct soap *soap, struct ArrayOffloat *p)
{	soap_delete(soap, p);
}

SOAP_FMAC3 struct ArrayOffloat * SOAP_FMAC4 soap_instantiate_ArrayOffloat(struct soap *soap, int n, const char *type, const char *arrayType, size_t *size)
{
	DBGLOG(TEST, SOAP_MESSAGE(fdebug, "soap_instantiate_ArrayOffloat(%d, %s, %s)\n", n, type?type:"", arrayType?arrayType:""));
	struct soap_clist *cp = soap_link(soap, NULL, SOAP_TYPE_ArrayOffloat, n, soap_fdelete);
	if (!cp)
		return NULL;
	if (n < 0)
	{	cp->ptr = (void*)new struct ArrayOffloat;
		if (size)
			*size = sizeof(struct ArrayOffloat);
	}
	else
	{	cp->ptr = (void*)new struct ArrayOffloat[n];
		if (!cp->ptr)
		{	soap->error = SOAP_EOM;
			return NULL;
		}
		if (size)
			*size = n * sizeof(struct ArrayOffloat);
	}
		DBGLOG(TEST, SOAP_MESSAGE(fdebug, "Instantiated location=%p\n", cp->ptr));
	return (struct ArrayOffloat*)cp->ptr;
}
SOAP_FMAC3 void SOAP_FMAC4 soap_copy_ArrayOffloat(struct soap *soap, int st, int tt, void *p, size_t len, const void *q, size_t n)
{
	DBGLOG(TEST, SOAP_MESSAGE(fdebug, "Copying struct ArrayOffloat %p -> %p\n", q, p));
	*(struct ArrayOffloat*)p = *(struct ArrayOffloat*)q;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_default_ns__echoFloat(struct soap *soap, struct ns__echoFloat *a)
{
	(void)soap; (void)a; /* appease -Wall -Werror */
	soap_default_xsd__float(soap, &a->inputFloat);
}

SOAP_FMAC3 void SOAP_FMAC4 soap_serialize_ns__echoFloat(struct soap *soap, const struct ns__echoFloat *a)
{
	(void)soap; (void)a; /* appease -Wall -Werror */
	soap_embedded(soap, &a->inputFloat, SOAP_TYPE_xsd__float);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_put_ns__echoFloat(struct soap *soap, const struct ns__echoFloat *a, const char *tag, const char *type)
{
	register int id = soap_embed(soap, (void*)a, NULL, 0, tag, SOAP_TYPE_ns__echoFloat);
	if (soap_out_ns__echoFloat(soap, tag, id, a, type))
		return soap->error;
	return soap_putindependent(soap);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out_ns__echoFloat(struct soap *soap, const char *tag, int id, const struct ns__echoFloat *a, const char *type)
{
	if (soap_element_begin_out(soap, tag, soap_embedded_id(soap, id, a, SOAP_TYPE_ns__echoFloat), type))
		return soap->error;
	if (soap_out_xsd__float(soap, "inputFloat", -1, &a->inputFloat, ""))
		return soap->error;
	return soap_element_end_out(soap, tag);
}

SOAP_FMAC3 struct ns__echoFloat * SOAP_FMAC4 soap_get_ns__echoFloat(struct soap *soap, struct ns__echoFloat *p, const char *tag, const char *type)
{
	if ((p = soap_in_ns__echoFloat(soap, tag, p, type)))
		if (soap_getindependent(soap))
			return NULL;
	return p;
}

SOAP_FMAC3 struct ns__echoFloat * SOAP_FMAC4 soap_in_ns__echoFloat(struct soap *soap, const char *tag, struct ns__echoFloat *a, const char *type)
{
	short soap_flag_inputFloat = 1;
	if (soap_element_begin_in(soap, tag, 0, type))
		return NULL;
	a = (struct ns__echoFloat *)soap_id_enter(soap, soap->id, a, SOAP_TYPE_ns__echoFloat, sizeof(struct ns__echoFloat), 0, NULL, NULL, NULL);
	if (!a)
		return NULL;
	soap_default_ns__echoFloat(soap, a);
	if (soap->body && !*soap->href)
	{
		for (;;)
		{	soap->error = SOAP_TAG_MISMATCH;
			if (soap_flag_inputFloat && soap->error == SOAP_TAG_MISMATCH)
				if (soap_in_xsd__float(soap, "inputFloat", &a->inputFloat, "xsd:float"))
				{	soap_flag_inputFloat--;
					continue;
				}
			if (soap->error == SOAP_TAG_MISMATCH)
				soap->error = soap_ignore_element(soap);
			if (soap->error == SOAP_NO_TAG)
				break;
			if (soap->error)
				return NULL;
		}
		if (soap_element_end_in(soap, tag))
			return NULL;
	}
	else
	{	a = (struct ns__echoFloat *)soap_id_forward(soap, soap->href, (void*)a, 0, SOAP_TYPE_ns__echoFloat, 0, sizeof(struct ns__echoFloat), 0, NULL);
		if (soap->body && soap_element_end_in(soap, tag))
			return NULL;
	}
	if ((soap->mode & SOAP_XML_STRICT) && (soap_flag_inputFloat > 0))
	{	soap->error = SOAP_OCCURS;
		return NULL;
	}
	return a;
}

SOAP_FMAC5 struct ns__echoFloat * SOAP_FMAC6 soap_new_ns__echoFloat(struct soap *soap, int n)
{	return soap_instantiate_ns__echoFloat(soap, n, NULL, NULL, NULL);
}

SOAP_FMAC5 void SOAP_FMAC6 soap_delete_ns__echoFloat(struct soap *soap, struct ns__echoFloat *p)
{	soap_delete(soap, p);
}

SOAP_FMAC3 struct ns__echoFloat * SOAP_FMAC4 soap_instantiate_ns__echoFloat(struct soap *soap, int n, const char *type, const char *arrayType, size_t *size)
{
	DBGLOG(TEST, SOAP_MESSAGE(fdebug, "soap_instantiate_ns__echoFloat(%d, %s, %s)\n", n, type?type:"", arrayType?arrayType:""));
	struct soap_clist *cp = soap_link(soap, NULL, SOAP_TYPE_ns__echoFloat, n, soap_fdelete);
	if (!cp)
		return NULL;
	if (n < 0)
	{	cp->ptr = (void*)new struct ns__echoFloat;
		if (size)
			*size = sizeof(struct ns__echoFloat);
	}
	else
	{	cp->ptr = (void*)new struct ns__echoFloat[n];
		if (!cp->ptr)
		{	soap->error = SOAP_EOM;
			return NULL;
		}
		if (size)
			*size = n * sizeof(struct ns__echoFloat);
	}
		DBGLOG(TEST, SOAP_MESSAGE(fdebug, "Instantiated location=%p\n", cp->ptr));
	return (struct ns__echoFloat*)cp->ptr;
}
SOAP_FMAC3 void SOAP_FMAC4 soap_copy_ns__echoFloat(struct soap *soap, int st, int tt, void *p, size_t len, const void *q, size_t n)
{
	DBGLOG(TEST, SOAP_MESSAGE(fdebug, "Copying struct ns__echoFloat %p -> %p\n", q, p));
	*(struct ns__echoFloat*)p = *(struct ns__echoFloat*)q;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_default_ns__echoFloatResponse(struct soap *soap, struct ns__echoFloatResponse *a)
{
	(void)soap; (void)a; /* appease -Wall -Werror */
	soap_default_xsd__float(soap, &a->_return);
}

SOAP_FMAC3 void SOAP_FMAC4 soap_serialize_ns__echoFloatResponse(struct soap *soap, const struct ns__echoFloatResponse *a)
{
	(void)soap; (void)a; /* appease -Wall -Werror */
	soap_embedded(soap, &a->_return, SOAP_TYPE_xsd__float);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_put_ns__echoFloatResponse(struct soap *soap, const struct ns__echoFloatResponse *a, const char *tag, const char *type)
{
	register int id = soap_embed(soap, (void*)a, NULL, 0, tag, SOAP_TYPE_ns__echoFloatResponse);
	if (soap_out_ns__echoFloatResponse(soap, tag, id, a, type))
		return soap->error;
	return soap_putindependent(soap);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out_ns__echoFloatResponse(struct soap *soap, const char *tag, int id, const struct ns__echoFloatResponse *a, const char *type)
{
	if (soap_element_begin_out(soap, tag, soap_embedded_id(soap, id, a, SOAP_TYPE_ns__echoFloatResponse), type))
		return soap->error;
	if (soap_out_xsd__float(soap, "return", -1, &a->_return, ""))
		return soap->error;
	return soap_element_end_out(soap, tag);
}

SOAP_FMAC3 struct ns__echoFloatResponse * SOAP_FMAC4 soap_get_ns__echoFloatResponse(struct soap *soap, struct ns__echoFloatResponse *p, const char *tag, const char *type)
{
	if ((p = soap_in_ns__echoFloatResponse(soap, tag, p, type)))
		if (soap_getindependent(soap))
			return NULL;
	return p;
}

SOAP_FMAC3 struct ns__echoFloatResponse * SOAP_FMAC4 soap_in_ns__echoFloatResponse(struct soap *soap, const char *tag, struct ns__echoFloatResponse *a, const char *type)
{
	short soap_flag__return = 1;
	if (soap_element_begin_in(soap, tag, 0, type))
		return NULL;
	a = (struct ns__echoFloatResponse *)soap_id_enter(soap, soap->id, a, SOAP_TYPE_ns__echoFloatResponse, sizeof(struct ns__echoFloatResponse), 0, NULL, NULL, NULL);
	if (!a)
		return NULL;
	soap_default_ns__echoFloatResponse(soap, a);
	if (soap->body && !*soap->href)
	{
		for (;;)
		{	soap->error = SOAP_TAG_MISMATCH;
			if (soap_flag__return && soap->error == SOAP_TAG_MISMATCH)
				if (soap_in_xsd__float(soap, NULL, &a->_return, "xsd:float"))
				{	soap_flag__return--;
					continue;
				}
			if (soap->error == SOAP_TAG_MISMATCH)
				soap->error = soap_ignore_element(soap);
			if (soap->error == SOAP_NO_TAG)
				break;
			if (soap->error)
				return NULL;
		}
		if (soap_element_end_in(soap, tag))
			return NULL;
	}
	else
	{	a = (struct ns__echoFloatResponse *)soap_id_forward(soap, soap->href, (void*)a, 0, SOAP_TYPE_ns__echoFloatResponse, 0, sizeof(struct ns__echoFloatResponse), 0, NULL);
		if (soap->body && soap_element_end_in(soap, tag))
			return NULL;
	}
	if ((soap->mode & SOAP_XML_STRICT) && (soap_flag__return > 0))
	{	soap->error = SOAP_OCCURS;
		return NULL;
	}
	return a;
}

SOAP_FMAC5 struct ns__echoFloatResponse * SOAP_FMAC6 soap_new_ns__echoFloatResponse(struct soap *soap, int n)
{	return soap_instantiate_ns__echoFloatResponse(soap, n, NULL, NULL, NULL);
}

SOAP_FMAC5 void SOAP_FMAC6 soap_delete_ns__echoFloatResponse(struct soap *soap, struct ns__echoFloatResponse *p)
{	soap_delete(soap, p);
}

SOAP_FMAC3 struct ns__echoFloatResponse * SOAP_FMAC4 soap_instantiate_ns__echoFloatResponse(struct soap *soap, int n, const char *type, const char *arrayType, size_t *size)
{
	DBGLOG(TEST, SOAP_MESSAGE(fdebug, "soap_instantiate_ns__echoFloatResponse(%d, %s, %s)\n", n, type?type:"", arrayType?arrayType:""));
	struct soap_clist *cp = soap_link(soap, NULL, SOAP_TYPE_ns__echoFloatResponse, n, soap_fdelete);
	if (!cp)
		return NULL;
	if (n < 0)
	{	cp->ptr = (void*)new struct ns__echoFloatResponse;
		if (size)
			*size = sizeof(struct ns__echoFloatResponse);
	}
	else
	{	cp->ptr = (void*)new struct ns__echoFloatResponse[n];
		if (!cp->ptr)
		{	soap->error = SOAP_EOM;
			return NULL;
		}
		if (size)
			*size = n * sizeof(struct ns__echoFloatResponse);
	}
		DBGLOG(TEST, SOAP_MESSAGE(fdebug, "Instantiated location=%p\n", cp->ptr));
	return (struct ns__echoFloatResponse*)cp->ptr;
}
SOAP_FMAC3 void SOAP_FMAC4 soap_copy_ns__echoFloatResponse(struct soap *soap, int st, int tt, void *p, size_t len, const void *q, size_t n)
{
	DBGLOG(TEST, SOAP_MESSAGE(fdebug, "Copying struct ns__echoFloatResponse %p -> %p\n", q, p));
	*(struct ns__echoFloatResponse*)p = *(struct ns__echoFloatResponse*)q;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_default_ns__echoIntegerArray(struct soap *soap, struct ns__echoIntegerArray *a)
{
	(void)soap; (void)a; /* appease -Wall -Werror */
	soap_default_ArrayOfint(soap, &a->inputIntegerArray);
}

SOAP_FMAC3 void SOAP_FMAC4 soap_serialize_ns__echoIntegerArray(struct soap *soap, const struct ns__echoIntegerArray *a)
{
	(void)soap; (void)a; /* appease -Wall -Werror */
	soap_serialize_ArrayOfint(soap, &a->inputIntegerArray);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_put_ns__echoIntegerArray(struct soap *soap, const struct ns__echoIntegerArray *a, const char *tag, const char *type)
{
	register int id = soap_embed(soap, (void*)a, NULL, 0, tag, SOAP_TYPE_ns__echoIntegerArray);
	if (soap_out_ns__echoIntegerArray(soap, tag, id, a, type))
		return soap->error;
	return soap_putindependent(soap);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out_ns__echoIntegerArray(struct soap *soap, const char *tag, int id, const struct ns__echoIntegerArray *a, const char *type)
{
	if (soap_element_begin_out(soap, tag, soap_embedded_id(soap, id, a, SOAP_TYPE_ns__echoIntegerArray), type))
		return soap->error;
	if (soap_out_ArrayOfint(soap, "inputIntegerArray", -1, &a->inputIntegerArray, ""))
		return soap->error;
	return soap_element_end_out(soap, tag);
}

SOAP_FMAC3 struct ns__echoIntegerArray * SOAP_FMAC4 soap_get_ns__echoIntegerArray(struct soap *soap, struct ns__echoIntegerArray *p, const char *tag, const char *type)
{
	if ((p = soap_in_ns__echoIntegerArray(soap, tag, p, type)))
		if (soap_getindependent(soap))
			return NULL;
	return p;
}

SOAP_FMAC3 struct ns__echoIntegerArray * SOAP_FMAC4 soap_in_ns__echoIntegerArray(struct soap *soap, const char *tag, struct ns__echoIntegerArray *a, const char *type)
{
	short soap_flag_inputIntegerArray = 1;
	if (soap_element_begin_in(soap, tag, 0, type))
		return NULL;
	a = (struct ns__echoIntegerArray *)soap_id_enter(soap, soap->id, a, SOAP_TYPE_ns__echoIntegerArray, sizeof(struct ns__echoIntegerArray), 0, NULL, NULL, NULL);
	if (!a)
		return NULL;
	soap_default_ns__echoIntegerArray(soap, a);
	if (soap->body && !*soap->href)
	{
		for (;;)
		{	soap->error = SOAP_TAG_MISMATCH;
			if (soap_flag_inputIntegerArray && soap->error == SOAP_TAG_MISMATCH)
				if (soap_in_ArrayOfint(soap, "inputIntegerArray", &a->inputIntegerArray, "xsd:int"))
				{	soap_flag_inputIntegerArray--;
					continue;
				}
			if (soap->error == SOAP_TAG_MISMATCH)
				soap->error = soap_ignore_element(soap);
			if (soap->error == SOAP_NO_TAG)
				break;
			if (soap->error)
				return NULL;
		}
		if (soap_element_end_in(soap, tag))
			return NULL;
	}
	else
	{	a = (struct ns__echoIntegerArray *)soap_id_forward(soap, soap->href, (void*)a, 0, SOAP_TYPE_ns__echoIntegerArray, 0, sizeof(struct ns__echoIntegerArray), 0, NULL);
		if (soap->body && soap_element_end_in(soap, tag))
			return NULL;
	}
	if ((soap->mode & SOAP_XML_STRICT) && (soap_flag_inputIntegerArray > 0))
	{	soap->error = SOAP_OCCURS;
		return NULL;
	}
	return a;
}

SOAP_FMAC5 struct ns__echoIntegerArray * SOAP_FMAC6 soap_new_ns__echoIntegerArray(struct soap *soap, int n)
{	return soap_instantiate_ns__echoIntegerArray(soap, n, NULL, NULL, NULL);
}

SOAP_FMAC5 void SOAP_FMAC6 soap_delete_ns__echoIntegerArray(struct soap *soap, struct ns__echoIntegerArray *p)
{	soap_delete(soap, p);
}

SOAP_FMAC3 struct ns__echoIntegerArray * SOAP_FMAC4 soap_instantiate_ns__echoIntegerArray(struct soap *soap, int n, const char *type, const char *arrayType, size_t *size)
{
	DBGLOG(TEST, SOAP_MESSAGE(fdebug, "soap_instantiate_ns__echoIntegerArray(%d, %s, %s)\n", n, type?type:"", arrayType?arrayType:""));
	struct soap_clist *cp = soap_link(soap, NULL, SOAP_TYPE_ns__echoIntegerArray, n, soap_fdelete);
	if (!cp)
		return NULL;
	if (n < 0)
	{	cp->ptr = (void*)new struct ns__echoIntegerArray;
		if (size)
			*size = sizeof(struct ns__echoIntegerArray);
	}
	else
	{	cp->ptr = (void*)new struct ns__echoIntegerArray[n];
		if (!cp->ptr)
		{	soap->error = SOAP_EOM;
			return NULL;
		}
		if (size)
			*size = n * sizeof(struct ns__echoIntegerArray);
	}
		DBGLOG(TEST, SOAP_MESSAGE(fdebug, "Instantiated location=%p\n", cp->ptr));
	return (struct ns__echoIntegerArray*)cp->ptr;
}
SOAP_FMAC3 void SOAP_FMAC4 soap_copy_ns__echoIntegerArray(struct soap *soap, int st, int tt, void *p, size_t len, const void *q, size_t n)
{
	DBGLOG(TEST, SOAP_MESSAGE(fdebug, "Copying struct ns__echoIntegerArray %p -> %p\n", q, p));
	*(struct ns__echoIntegerArray*)p = *(struct ns__echoIntegerArray*)q;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_default_ns__echoIntegerArrayResponse(struct soap *soap, struct ns__echoIntegerArrayResponse *a)
{
	(void)soap; (void)a; /* appease -Wall -Werror */
	soap_default_ArrayOfint(soap, &a->_return);
}

SOAP_FMAC3 void SOAP_FMAC4 soap_serialize_ns__echoIntegerArrayResponse(struct soap *soap, const struct ns__echoIntegerArrayResponse *a)
{
	(void)soap; (void)a; /* appease -Wall -Werror */
	soap_serialize_ArrayOfint(soap, &a->_return);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_put_ns__echoIntegerArrayResponse(struct soap *soap, const struct ns__echoIntegerArrayResponse *a, const char *tag, const char *type)
{
	register int id = soap_embed(soap, (void*)a, NULL, 0, tag, SOAP_TYPE_ns__echoIntegerArrayResponse);
	if (soap_out_ns__echoIntegerArrayResponse(soap, tag, id, a, type))
		return soap->error;
	return soap_putindependent(soap);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out_ns__echoIntegerArrayResponse(struct soap *soap, const char *tag, int id, const struct ns__echoIntegerArrayResponse *a, const char *type)
{
	if (soap_element_begin_out(soap, tag, soap_embedded_id(soap, id, a, SOAP_TYPE_ns__echoIntegerArrayResponse), type))
		return soap->error;
	if (soap_out_ArrayOfint(soap, "return", -1, &a->_return, ""))
		return soap->error;
	return soap_element_end_out(soap, tag);
}

SOAP_FMAC3 struct ns__echoIntegerArrayResponse * SOAP_FMAC4 soap_get_ns__echoIntegerArrayResponse(struct soap *soap, struct ns__echoIntegerArrayResponse *p, const char *tag, const char *type)
{
	if ((p = soap_in_ns__echoIntegerArrayResponse(soap, tag, p, type)))
		if (soap_getindependent(soap))
			return NULL;
	return p;
}

SOAP_FMAC3 struct ns__echoIntegerArrayResponse * SOAP_FMAC4 soap_in_ns__echoIntegerArrayResponse(struct soap *soap, const char *tag, struct ns__echoIntegerArrayResponse *a, const char *type)
{
	short soap_flag__return = 1;
	if (soap_element_begin_in(soap, tag, 0, type))
		return NULL;
	a = (struct ns__echoIntegerArrayResponse *)soap_id_enter(soap, soap->id, a, SOAP_TYPE_ns__echoIntegerArrayResponse, sizeof(struct ns__echoIntegerArrayResponse), 0, NULL, NULL, NULL);
	if (!a)
		return NULL;
	soap_default_ns__echoIntegerArrayResponse(soap, a);
	if (soap->body && !*soap->href)
	{
		for (;;)
		{	soap->error = SOAP_TAG_MISMATCH;
			if (soap_flag__return && soap->error == SOAP_TAG_MISMATCH)
				if (soap_in_ArrayOfint(soap, NULL, &a->_return, "xsd:int"))
				{	soap_flag__return--;
					continue;
				}
			if (soap->error == SOAP_TAG_MISMATCH)
				soap->error = soap_ignore_element(soap);
			if (soap->error == SOAP_NO_TAG)
				break;
			if (soap->error)
				return NULL;
		}
		if (soap_element_end_in(soap, tag))
			return NULL;
	}
	else
	{	a = (struct ns__echoIntegerArrayResponse *)soap_id_forward(soap, soap->href, (void*)a, 0, SOAP_TYPE_ns__echoIntegerArrayResponse, 0, sizeof(struct ns__echoIntegerArrayResponse), 0, NULL);
		if (soap->body && soap_element_end_in(soap, tag))
			return NULL;
	}
	if ((soap->mode & SOAP_XML_STRICT) && (soap_flag__return > 0))
	{	soap->error = SOAP_OCCURS;
		return NULL;
	}
	return a;
}

SOAP_FMAC5 struct ns__echoIntegerArrayResponse * SOAP_FMAC6 soap_new_ns__echoIntegerArrayResponse(struct soap *soap, int n)
{	return soap_instantiate_ns__echoIntegerArrayResponse(soap, n, NULL, NULL, NULL);
}

SOAP_FMAC5 void SOAP_FMAC6 soap_delete_ns__echoIntegerArrayResponse(struct soap *soap, struct ns__echoIntegerArrayResponse *p)
{	soap_delete(soap, p);
}

SOAP_FMAC3 struct ns__echoIntegerArrayResponse * SOAP_FMAC4 soap_instantiate_ns__echoIntegerArrayResponse(struct soap *soap, int n, const char *type, const char *arrayType, size_t *size)
{
	DBGLOG(TEST, SOAP_MESSAGE(fdebug, "soap_instantiate_ns__echoIntegerArrayResponse(%d, %s, %s)\n", n, type?type:"", arrayType?arrayType:""));
	struct soap_clist *cp = soap_link(soap, NULL, SOAP_TYPE_ns__echoIntegerArrayResponse, n, soap_fdelete);
	if (!cp)
		return NULL;
	if (n < 0)
	{	cp->ptr = (void*)new struct ns__echoIntegerArrayResponse;
		if (size)
			*size = sizeof(struct ns__echoIntegerArrayResponse);
	}
	else
	{	cp->ptr = (void*)new struct ns__echoIntegerArrayResponse[n];
		if (!cp->ptr)
		{	soap->error = SOAP_EOM;
			return NULL;
		}
		if (size)
			*size = n * sizeof(struct ns__echoIntegerArrayResponse);
	}
		DBGLOG(TEST, SOAP_MESSAGE(fdebug, "Instantiated location=%p\n", cp->ptr));
	return (struct ns__echoIntegerArrayResponse*)cp->ptr;
}
SOAP_FMAC3 void SOAP_FMAC4 soap_copy_ns__echoIntegerArrayResponse(struct soap *soap, int st, int tt, void *p, size_t len, const void *q, size_t n)
{
	DBGLOG(TEST, SOAP_MESSAGE(fdebug, "Copying struct ns__echoIntegerArrayResponse %p -> %p\n", q, p));
	*(struct ns__echoIntegerArrayResponse*)p = *(struct ns__echoIntegerArrayResponse*)q;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_default_ArrayOfint(struct soap *soap, struct ArrayOfint *a)
{
	a->__size = 0;
	a->__ptr = NULL;
	a->__offset = 0;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_serialize_ArrayOfint(struct soap *soap, struct ArrayOfint const*a)
{
	int i;
	if (a->__ptr && !soap_array_reference(soap, a, (struct soap_array*)&a->__ptr, 1, SOAP_TYPE_ArrayOfint))
		for (i = 0; i < a->__size; i++)
		{
			soap_serialize_PointerToxsd__int(soap, a->__ptr + i);
		}
}

SOAP_FMAC3 int SOAP_FMAC4 soap_put_ArrayOfint(struct soap *soap, const struct ArrayOfint *a, const char *tag, const char *type)
{
	register int id = soap_embed(soap, (void*)a, (struct soap_array*)&a->__ptr, 1, tag, SOAP_TYPE_ArrayOfint);
	if (soap_out_ArrayOfint(soap, tag, id, a, type))
		return soap->error;
	return soap_putindependent(soap);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out_ArrayOfint(struct soap *soap, const char *tag, int id, const struct ArrayOfint *a, const char *type)
{
	int i, n = a->__size;
	char *t = soap_putsize(soap, "xsd:int", n + a->__offset);
	id = soap_element_id(soap, tag, id, a, (struct soap_array*)&a->__ptr, 1, type, SOAP_TYPE_ArrayOfint);
	if (id < 0)
		return soap->error;
	if (soap_array_begin_out(soap, tag, id, t, soap_putoffset(soap, a->__offset)))
		return soap->error;
	for (i = 0; i < n; i++)
	{
		soap->position = 1;
		soap->positions[0] = i;
		soap_out_PointerToxsd__int(soap, "item", -1, &a->__ptr[i], "");
	}
	soap->position = 0;
	return soap_element_end_out(soap, tag);
}

SOAP_FMAC3 struct ArrayOfint * SOAP_FMAC4 soap_get_ArrayOfint(struct soap *soap, struct ArrayOfint *p, const char *tag, const char *type)
{
	if ((p = soap_in_ArrayOfint(soap, tag, p, type)))
		if (soap_getindependent(soap))
			return NULL;
	return p;
}

SOAP_FMAC3 struct ArrayOfint * SOAP_FMAC4 soap_in_ArrayOfint(struct soap *soap, const char *tag, struct ArrayOfint *a, const char *type)
{	int i, j;
	long **p;
	if (soap_element_begin_in(soap, tag, 1, NULL))
		return NULL;
	if (soap_match_array(soap, type))
	{	soap->error = SOAP_TYPE;
		return NULL;
	}
	a = (struct ArrayOfint *)soap_id_enter(soap, soap->id, a, SOAP_TYPE_ArrayOfint, sizeof(struct ArrayOfint), 0, NULL, NULL, NULL);
	if (!a)
		return NULL;
	soap_default_ArrayOfint(soap, a);
	if (soap->body && !*soap->href)
	{
		a->__size = soap_getsize(soap->arraySize, soap->arrayOffset, &j);
		a->__offset = j;
		if (a->__size >= 0)
		{	a->__ptr = (long **)soap_malloc(soap, sizeof(long *) * a->__size);
			for (i = 0; i < a->__size; i++)
				a->__ptr[i] = NULL;
			for (i = 0; i < a->__size; i++)
			{	soap_peek_element(soap);
				if (soap->position)
				{	i = soap->positions[0]-j;
					if (i < 0 || i >= a->__size)
					{	soap->error = SOAP_IOB;
						return NULL;
					}
				}
				if (!soap_in_PointerToxsd__int(soap, NULL, a->__ptr + i, "xsd:int"))
				{	if (soap->error != SOAP_NO_TAG)
						return NULL;
					soap->error = SOAP_OK;
					break;
				}
			}
		}
		else
		{	soap_new_block(soap);
			for (a->__size = 0; ; a->__size++)
			{	p = (long **)soap_push_block(soap, sizeof(long *));
				if (!p)
					return NULL;
				*p = NULL;
				if (!soap_in_PointerToxsd__int(soap, NULL, p, "xsd:int"))
				{	if (soap->error != SOAP_NO_TAG)
						return NULL;
					soap->error = SOAP_OK;
					break;
				}
			}
			soap_pop_block(soap);
			a->__ptr = (long **)soap_malloc(soap, soap->blist->size);
			soap_save_block(soap, (char*)a->__ptr, 1);
		}
		if (soap_element_end_in(soap, tag))
			return NULL;
	}
	else
	{	a = (struct ArrayOfint *)soap_id_forward(soap, soap->href, (void*)a, 0, SOAP_TYPE_ArrayOfint, 0, sizeof(struct ArrayOfint), 0, NULL);
		if (soap->body && soap_element_end_in(soap, tag))
			return NULL;
	}
	return a;
}

SOAP_FMAC5 struct ArrayOfint * SOAP_FMAC6 soap_new_ArrayOfint(struct soap *soap, int n)
{	return soap_instantiate_ArrayOfint(soap, n, NULL, NULL, NULL);
}

SOAP_FMAC5 void SOAP_FMAC6 soap_delete_ArrayOfint(struct soap *soap, struct ArrayOfint *p)
{	soap_delete(soap, p);
}

SOAP_FMAC3 struct ArrayOfint * SOAP_FMAC4 soap_instantiate_ArrayOfint(struct soap *soap, int n, const char *type, const char *arrayType, size_t *size)
{
	DBGLOG(TEST, SOAP_MESSAGE(fdebug, "soap_instantiate_ArrayOfint(%d, %s, %s)\n", n, type?type:"", arrayType?arrayType:""));
	struct soap_clist *cp = soap_link(soap, NULL, SOAP_TYPE_ArrayOfint, n, soap_fdelete);
	if (!cp)
		return NULL;
	if (n < 0)
	{	cp->ptr = (void*)new struct ArrayOfint;
		if (size)
			*size = sizeof(struct ArrayOfint);
	}
	else
	{	cp->ptr = (void*)new struct ArrayOfint[n];
		if (!cp->ptr)
		{	soap->error = SOAP_EOM;
			return NULL;
		}
		if (size)
			*size = n * sizeof(struct ArrayOfint);
	}
		DBGLOG(TEST, SOAP_MESSAGE(fdebug, "Instantiated location=%p\n", cp->ptr));
	return (struct ArrayOfint*)cp->ptr;
}
SOAP_FMAC3 void SOAP_FMAC4 soap_copy_ArrayOfint(struct soap *soap, int st, int tt, void *p, size_t len, const void *q, size_t n)
{
	DBGLOG(TEST, SOAP_MESSAGE(fdebug, "Copying struct ArrayOfint %p -> %p\n", q, p));
	*(struct ArrayOfint*)p = *(struct ArrayOfint*)q;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_default_ns__echoInteger(struct soap *soap, struct ns__echoInteger *a)
{
	(void)soap; (void)a; /* appease -Wall -Werror */
	soap_default_xsd__int(soap, &a->inputInteger);
}

SOAP_FMAC3 void SOAP_FMAC4 soap_serialize_ns__echoInteger(struct soap *soap, const struct ns__echoInteger *a)
{
	(void)soap; (void)a; /* appease -Wall -Werror */
	soap_embedded(soap, &a->inputInteger, SOAP_TYPE_xsd__int);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_put_ns__echoInteger(struct soap *soap, const struct ns__echoInteger *a, const char *tag, const char *type)
{
	register int id = soap_embed(soap, (void*)a, NULL, 0, tag, SOAP_TYPE_ns__echoInteger);
	if (soap_out_ns__echoInteger(soap, tag, id, a, type))
		return soap->error;
	return soap_putindependent(soap);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out_ns__echoInteger(struct soap *soap, const char *tag, int id, const struct ns__echoInteger *a, const char *type)
{
	if (soap_element_begin_out(soap, tag, soap_embedded_id(soap, id, a, SOAP_TYPE_ns__echoInteger), type))
		return soap->error;
	if (soap_out_xsd__int(soap, "inputInteger", -1, &a->inputInteger, ""))
		return soap->error;
	return soap_element_end_out(soap, tag);
}

SOAP_FMAC3 struct ns__echoInteger * SOAP_FMAC4 soap_get_ns__echoInteger(struct soap *soap, struct ns__echoInteger *p, const char *tag, const char *type)
{
	if ((p = soap_in_ns__echoInteger(soap, tag, p, type)))
		if (soap_getindependent(soap))
			return NULL;
	return p;
}

SOAP_FMAC3 struct ns__echoInteger * SOAP_FMAC4 soap_in_ns__echoInteger(struct soap *soap, const char *tag, struct ns__echoInteger *a, const char *type)
{
	short soap_flag_inputInteger = 1;
	if (soap_element_begin_in(soap, tag, 0, type))
		return NULL;
	a = (struct ns__echoInteger *)soap_id_enter(soap, soap->id, a, SOAP_TYPE_ns__echoInteger, sizeof(struct ns__echoInteger), 0, NULL, NULL, NULL);
	if (!a)
		return NULL;
	soap_default_ns__echoInteger(soap, a);
	if (soap->body && !*soap->href)
	{
		for (;;)
		{	soap->error = SOAP_TAG_MISMATCH;
			if (soap_flag_inputInteger && soap->error == SOAP_TAG_MISMATCH)
				if (soap_in_xsd__int(soap, "inputInteger", &a->inputInteger, "xsd:int"))
				{	soap_flag_inputInteger--;
					continue;
				}
			if (soap->error == SOAP_TAG_MISMATCH)
				soap->error = soap_ignore_element(soap);
			if (soap->error == SOAP_NO_TAG)
				break;
			if (soap->error)
				return NULL;
		}
		if (soap_element_end_in(soap, tag))
			return NULL;
	}
	else
	{	a = (struct ns__echoInteger *)soap_id_forward(soap, soap->href, (void*)a, 0, SOAP_TYPE_ns__echoInteger, 0, sizeof(struct ns__echoInteger), 0, NULL);
		if (soap->body && soap_element_end_in(soap, tag))
			return NULL;
	}
	if ((soap->mode & SOAP_XML_STRICT) && (soap_flag_inputInteger > 0))
	{	soap->error = SOAP_OCCURS;
		return NULL;
	}
	return a;
}

SOAP_FMAC5 struct ns__echoInteger * SOAP_FMAC6 soap_new_ns__echoInteger(struct soap *soap, int n)
{	return soap_instantiate_ns__echoInteger(soap, n, NULL, NULL, NULL);
}

SOAP_FMAC5 void SOAP_FMAC6 soap_delete_ns__echoInteger(struct soap *soap, struct ns__echoInteger *p)
{	soap_delete(soap, p);
}

SOAP_FMAC3 struct ns__echoInteger * SOAP_FMAC4 soap_instantiate_ns__echoInteger(struct soap *soap, int n, const char *type, const char *arrayType, size_t *size)
{
	DBGLOG(TEST, SOAP_MESSAGE(fdebug, "soap_instantiate_ns__echoInteger(%d, %s, %s)\n", n, type?type:"", arrayType?arrayType:""));
	struct soap_clist *cp = soap_link(soap, NULL, SOAP_TYPE_ns__echoInteger, n, soap_fdelete);
	if (!cp)
		return NULL;
	if (n < 0)
	{	cp->ptr = (void*)new struct ns__echoInteger;
		if (size)
			*size = sizeof(struct ns__echoInteger);
	}
	else
	{	cp->ptr = (void*)new struct ns__echoInteger[n];
		if (!cp->ptr)
		{	soap->error = SOAP_EOM;
			return NULL;
		}
		if (size)
			*size = n * sizeof(struct ns__echoInteger);
	}
		DBGLOG(TEST, SOAP_MESSAGE(fdebug, "Instantiated location=%p\n", cp->ptr));
	return (struct ns__echoInteger*)cp->ptr;
}
SOAP_FMAC3 void SOAP_FMAC4 soap_copy_ns__echoInteger(struct soap *soap, int st, int tt, void *p, size_t len, const void *q, size_t n)
{
	DBGLOG(TEST, SOAP_MESSAGE(fdebug, "Copying struct ns__echoInteger %p -> %p\n", q, p));
	*(struct ns__echoInteger*)p = *(struct ns__echoInteger*)q;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_default_ns__echoIntegerResponse(struct soap *soap, struct ns__echoIntegerResponse *a)
{
	(void)soap; (void)a; /* appease -Wall -Werror */
	soap_default_xsd__int(soap, &a->_return);
}

SOAP_FMAC3 void SOAP_FMAC4 soap_serialize_ns__echoIntegerResponse(struct soap *soap, const struct ns__echoIntegerResponse *a)
{
	(void)soap; (void)a; /* appease -Wall -Werror */
	soap_embedded(soap, &a->_return, SOAP_TYPE_xsd__int);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_put_ns__echoIntegerResponse(struct soap *soap, const struct ns__echoIntegerResponse *a, const char *tag, const char *type)
{
	register int id = soap_embed(soap, (void*)a, NULL, 0, tag, SOAP_TYPE_ns__echoIntegerResponse);
	if (soap_out_ns__echoIntegerResponse(soap, tag, id, a, type))
		return soap->error;
	return soap_putindependent(soap);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out_ns__echoIntegerResponse(struct soap *soap, const char *tag, int id, const struct ns__echoIntegerResponse *a, const char *type)
{
	if (soap_element_begin_out(soap, tag, soap_embedded_id(soap, id, a, SOAP_TYPE_ns__echoIntegerResponse), type))
		return soap->error;
	if (soap_out_xsd__int(soap, "return", -1, &a->_return, ""))
		return soap->error;
	return soap_element_end_out(soap, tag);
}

SOAP_FMAC3 struct ns__echoIntegerResponse * SOAP_FMAC4 soap_get_ns__echoIntegerResponse(struct soap *soap, struct ns__echoIntegerResponse *p, const char *tag, const char *type)
{
	if ((p = soap_in_ns__echoIntegerResponse(soap, tag, p, type)))
		if (soap_getindependent(soap))
			return NULL;
	return p;
}

SOAP_FMAC3 struct ns__echoIntegerResponse * SOAP_FMAC4 soap_in_ns__echoIntegerResponse(struct soap *soap, const char *tag, struct ns__echoIntegerResponse *a, const char *type)
{
	short soap_flag__return = 1;
	if (soap_element_begin_in(soap, tag, 0, type))
		return NULL;
	a = (struct ns__echoIntegerResponse *)soap_id_enter(soap, soap->id, a, SOAP_TYPE_ns__echoIntegerResponse, sizeof(struct ns__echoIntegerResponse), 0, NULL, NULL, NULL);
	if (!a)
		return NULL;
	soap_default_ns__echoIntegerResponse(soap, a);
	if (soap->body && !*soap->href)
	{
		for (;;)
		{	soap->error = SOAP_TAG_MISMATCH;
			if (soap_flag__return && soap->error == SOAP_TAG_MISMATCH)
				if (soap_in_xsd__int(soap, NULL, &a->_return, "xsd:int"))
				{	soap_flag__return--;
					continue;
				}
			if (soap->error == SOAP_TAG_MISMATCH)
				soap->error = soap_ignore_element(soap);
			if (soap->error == SOAP_NO_TAG)
				break;
			if (soap->error)
				return NULL;
		}
		if (soap_element_end_in(soap, tag))
			return NULL;
	}
	else
	{	a = (struct ns__echoIntegerResponse *)soap_id_forward(soap, soap->href, (void*)a, 0, SOAP_TYPE_ns__echoIntegerResponse, 0, sizeof(struct ns__echoIntegerResponse), 0, NULL);
		if (soap->body && soap_element_end_in(soap, tag))
			return NULL;
	}
	if ((soap->mode & SOAP_XML_STRICT) && (soap_flag__return > 0))
	{	soap->error = SOAP_OCCURS;
		return NULL;
	}
	return a;
}

SOAP_FMAC5 struct ns__echoIntegerResponse * SOAP_FMAC6 soap_new_ns__echoIntegerResponse(struct soap *soap, int n)
{	return soap_instantiate_ns__echoIntegerResponse(soap, n, NULL, NULL, NULL);
}

SOAP_FMAC5 void SOAP_FMAC6 soap_delete_ns__echoIntegerResponse(struct soap *soap, struct ns__echoIntegerResponse *p)
{	soap_delete(soap, p);
}

SOAP_FMAC3 struct ns__echoIntegerResponse * SOAP_FMAC4 soap_instantiate_ns__echoIntegerResponse(struct soap *soap, int n, const char *type, const char *arrayType, size_t *size)
{
	DBGLOG(TEST, SOAP_MESSAGE(fdebug, "soap_instantiate_ns__echoIntegerResponse(%d, %s, %s)\n", n, type?type:"", arrayType?arrayType:""));
	struct soap_clist *cp = soap_link(soap, NULL, SOAP_TYPE_ns__echoIntegerResponse, n, soap_fdelete);
	if (!cp)
		return NULL;
	if (n < 0)
	{	cp->ptr = (void*)new struct ns__echoIntegerResponse;
		if (size)
			*size = sizeof(struct ns__echoIntegerResponse);
	}
	else
	{	cp->ptr = (void*)new struct ns__echoIntegerResponse[n];
		if (!cp->ptr)
		{	soap->error = SOAP_EOM;
			return NULL;
		}
		if (size)
			*size = n * sizeof(struct ns__echoIntegerResponse);
	}
		DBGLOG(TEST, SOAP_MESSAGE(fdebug, "Instantiated location=%p\n", cp->ptr));
	return (struct ns__echoIntegerResponse*)cp->ptr;
}
SOAP_FMAC3 void SOAP_FMAC4 soap_copy_ns__echoIntegerResponse(struct soap *soap, int st, int tt, void *p, size_t len, const void *q, size_t n)
{
	DBGLOG(TEST, SOAP_MESSAGE(fdebug, "Copying struct ns__echoIntegerResponse %p -> %p\n", q, p));
	*(struct ns__echoIntegerResponse*)p = *(struct ns__echoIntegerResponse*)q;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_default_ns__echoStringArray(struct soap *soap, struct ns__echoStringArray *a)
{
	(void)soap; (void)a; /* appease -Wall -Werror */
	soap_default_ArrayOfstring(soap, &a->inputStringArray);
}

SOAP_FMAC3 void SOAP_FMAC4 soap_serialize_ns__echoStringArray(struct soap *soap, const struct ns__echoStringArray *a)
{
	(void)soap; (void)a; /* appease -Wall -Werror */
	soap_serialize_ArrayOfstring(soap, &a->inputStringArray);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_put_ns__echoStringArray(struct soap *soap, const struct ns__echoStringArray *a, const char *tag, const char *type)
{
	register int id = soap_embed(soap, (void*)a, NULL, 0, tag, SOAP_TYPE_ns__echoStringArray);
	if (soap_out_ns__echoStringArray(soap, tag, id, a, type))
		return soap->error;
	return soap_putindependent(soap);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out_ns__echoStringArray(struct soap *soap, const char *tag, int id, const struct ns__echoStringArray *a, const char *type)
{
	if (soap_element_begin_out(soap, tag, soap_embedded_id(soap, id, a, SOAP_TYPE_ns__echoStringArray), type))
		return soap->error;
	if (soap_out_ArrayOfstring(soap, "inputStringArray", -1, &a->inputStringArray, ""))
		return soap->error;
	return soap_element_end_out(soap, tag);
}

SOAP_FMAC3 struct ns__echoStringArray * SOAP_FMAC4 soap_get_ns__echoStringArray(struct soap *soap, struct ns__echoStringArray *p, const char *tag, const char *type)
{
	if ((p = soap_in_ns__echoStringArray(soap, tag, p, type)))
		if (soap_getindependent(soap))
			return NULL;
	return p;
}

SOAP_FMAC3 struct ns__echoStringArray * SOAP_FMAC4 soap_in_ns__echoStringArray(struct soap *soap, const char *tag, struct ns__echoStringArray *a, const char *type)
{
	short soap_flag_inputStringArray = 1;
	if (soap_element_begin_in(soap, tag, 0, type))
		return NULL;
	a = (struct ns__echoStringArray *)soap_id_enter(soap, soap->id, a, SOAP_TYPE_ns__echoStringArray, sizeof(struct ns__echoStringArray), 0, NULL, NULL, NULL);
	if (!a)
		return NULL;
	soap_default_ns__echoStringArray(soap, a);
	if (soap->body && !*soap->href)
	{
		for (;;)
		{	soap->error = SOAP_TAG_MISMATCH;
			if (soap_flag_inputStringArray && soap->error == SOAP_TAG_MISMATCH)
				if (soap_in_ArrayOfstring(soap, "inputStringArray", &a->inputStringArray, "xsd:string"))
				{	soap_flag_inputStringArray--;
					continue;
				}
			if (soap->error == SOAP_TAG_MISMATCH)
				soap->error = soap_ignore_element(soap);
			if (soap->error == SOAP_NO_TAG)
				break;
			if (soap->error)
				return NULL;
		}
		if (soap_element_end_in(soap, tag))
			return NULL;
	}
	else
	{	a = (struct ns__echoStringArray *)soap_id_forward(soap, soap->href, (void*)a, 0, SOAP_TYPE_ns__echoStringArray, 0, sizeof(struct ns__echoStringArray), 0, NULL);
		if (soap->body && soap_element_end_in(soap, tag))
			return NULL;
	}
	if ((soap->mode & SOAP_XML_STRICT) && (soap_flag_inputStringArray > 0))
	{	soap->error = SOAP_OCCURS;
		return NULL;
	}
	return a;
}

SOAP_FMAC5 struct ns__echoStringArray * SOAP_FMAC6 soap_new_ns__echoStringArray(struct soap *soap, int n)
{	return soap_instantiate_ns__echoStringArray(soap, n, NULL, NULL, NULL);
}

SOAP_FMAC5 void SOAP_FMAC6 soap_delete_ns__echoStringArray(struct soap *soap, struct ns__echoStringArray *p)
{	soap_delete(soap, p);
}

SOAP_FMAC3 struct ns__echoStringArray * SOAP_FMAC4 soap_instantiate_ns__echoStringArray(struct soap *soap, int n, const char *type, const char *arrayType, size_t *size)
{
	DBGLOG(TEST, SOAP_MESSAGE(fdebug, "soap_instantiate_ns__echoStringArray(%d, %s, %s)\n", n, type?type:"", arrayType?arrayType:""));
	struct soap_clist *cp = soap_link(soap, NULL, SOAP_TYPE_ns__echoStringArray, n, soap_fdelete);
	if (!cp)
		return NULL;
	if (n < 0)
	{	cp->ptr = (void*)new struct ns__echoStringArray;
		if (size)
			*size = sizeof(struct ns__echoStringArray);
	}
	else
	{	cp->ptr = (void*)new struct ns__echoStringArray[n];
		if (!cp->ptr)
		{	soap->error = SOAP_EOM;
			return NULL;
		}
		if (size)
			*size = n * sizeof(struct ns__echoStringArray);
	}
		DBGLOG(TEST, SOAP_MESSAGE(fdebug, "Instantiated location=%p\n", cp->ptr));
	return (struct ns__echoStringArray*)cp->ptr;
}
SOAP_FMAC3 void SOAP_FMAC4 soap_copy_ns__echoStringArray(struct soap *soap, int st, int tt, void *p, size_t len, const void *q, size_t n)
{
	DBGLOG(TEST, SOAP_MESSAGE(fdebug, "Copying struct ns__echoStringArray %p -> %p\n", q, p));
	*(struct ns__echoStringArray*)p = *(struct ns__echoStringArray*)q;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_default_ns__echoStringArrayResponse(struct soap *soap, struct ns__echoStringArrayResponse *a)
{
	(void)soap; (void)a; /* appease -Wall -Werror */
	soap_default_ArrayOfstring(soap, &a->_return);
}

SOAP_FMAC3 void SOAP_FMAC4 soap_serialize_ns__echoStringArrayResponse(struct soap *soap, const struct ns__echoStringArrayResponse *a)
{
	(void)soap; (void)a; /* appease -Wall -Werror */
	soap_serialize_ArrayOfstring(soap, &a->_return);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_put_ns__echoStringArrayResponse(struct soap *soap, const struct ns__echoStringArrayResponse *a, const char *tag, const char *type)
{
	register int id = soap_embed(soap, (void*)a, NULL, 0, tag, SOAP_TYPE_ns__echoStringArrayResponse);
	if (soap_out_ns__echoStringArrayResponse(soap, tag, id, a, type))
		return soap->error;
	return soap_putindependent(soap);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out_ns__echoStringArrayResponse(struct soap *soap, const char *tag, int id, const struct ns__echoStringArrayResponse *a, const char *type)
{
	if (soap_element_begin_out(soap, tag, soap_embedded_id(soap, id, a, SOAP_TYPE_ns__echoStringArrayResponse), type))
		return soap->error;
	if (soap_out_ArrayOfstring(soap, "return", -1, &a->_return, ""))
		return soap->error;
	return soap_element_end_out(soap, tag);
}

SOAP_FMAC3 struct ns__echoStringArrayResponse * SOAP_FMAC4 soap_get_ns__echoStringArrayResponse(struct soap *soap, struct ns__echoStringArrayResponse *p, const char *tag, const char *type)
{
	if ((p = soap_in_ns__echoStringArrayResponse(soap, tag, p, type)))
		if (soap_getindependent(soap))
			return NULL;
	return p;
}

SOAP_FMAC3 struct ns__echoStringArrayResponse * SOAP_FMAC4 soap_in_ns__echoStringArrayResponse(struct soap *soap, const char *tag, struct ns__echoStringArrayResponse *a, const char *type)
{
	short soap_flag__return = 1;
	if (soap_element_begin_in(soap, tag, 0, type))
		return NULL;
	a = (struct ns__echoStringArrayResponse *)soap_id_enter(soap, soap->id, a, SOAP_TYPE_ns__echoStringArrayResponse, sizeof(struct ns__echoStringArrayResponse), 0, NULL, NULL, NULL);
	if (!a)
		return NULL;
	soap_default_ns__echoStringArrayResponse(soap, a);
	if (soap->body && !*soap->href)
	{
		for (;;)
		{	soap->error = SOAP_TAG_MISMATCH;
			if (soap_flag__return && soap->error == SOAP_TAG_MISMATCH)
				if (soap_in_ArrayOfstring(soap, NULL, &a->_return, "xsd:string"))
				{	soap_flag__return--;
					continue;
				}
			if (soap->error == SOAP_TAG_MISMATCH)
				soap->error = soap_ignore_element(soap);
			if (soap->error == SOAP_NO_TAG)
				break;
			if (soap->error)
				return NULL;
		}
		if (soap_element_end_in(soap, tag))
			return NULL;
	}
	else
	{	a = (struct ns__echoStringArrayResponse *)soap_id_forward(soap, soap->href, (void*)a, 0, SOAP_TYPE_ns__echoStringArrayResponse, 0, sizeof(struct ns__echoStringArrayResponse), 0, NULL);
		if (soap->body && soap_element_end_in(soap, tag))
			return NULL;
	}
	if ((soap->mode & SOAP_XML_STRICT) && (soap_flag__return > 0))
	{	soap->error = SOAP_OCCURS;
		return NULL;
	}
	return a;
}

SOAP_FMAC5 struct ns__echoStringArrayResponse * SOAP_FMAC6 soap_new_ns__echoStringArrayResponse(struct soap *soap, int n)
{	return soap_instantiate_ns__echoStringArrayResponse(soap, n, NULL, NULL, NULL);
}

SOAP_FMAC5 void SOAP_FMAC6 soap_delete_ns__echoStringArrayResponse(struct soap *soap, struct ns__echoStringArrayResponse *p)
{	soap_delete(soap, p);
}

SOAP_FMAC3 struct ns__echoStringArrayResponse * SOAP_FMAC4 soap_instantiate_ns__echoStringArrayResponse(struct soap *soap, int n, const char *type, const char *arrayType, size_t *size)
{
	DBGLOG(TEST, SOAP_MESSAGE(fdebug, "soap_instantiate_ns__echoStringArrayResponse(%d, %s, %s)\n", n, type?type:"", arrayType?arrayType:""));
	struct soap_clist *cp = soap_link(soap, NULL, SOAP_TYPE_ns__echoStringArrayResponse, n, soap_fdelete);
	if (!cp)
		return NULL;
	if (n < 0)
	{	cp->ptr = (void*)new struct ns__echoStringArrayResponse;
		if (size)
			*size = sizeof(struct ns__echoStringArrayResponse);
	}
	else
	{	cp->ptr = (void*)new struct ns__echoStringArrayResponse[n];
		if (!cp->ptr)
		{	soap->error = SOAP_EOM;
			return NULL;
		}
		if (size)
			*size = n * sizeof(struct ns__echoStringArrayResponse);
	}
		DBGLOG(TEST, SOAP_MESSAGE(fdebug, "Instantiated location=%p\n", cp->ptr));
	return (struct ns__echoStringArrayResponse*)cp->ptr;
}
SOAP_FMAC3 void SOAP_FMAC4 soap_copy_ns__echoStringArrayResponse(struct soap *soap, int st, int tt, void *p, size_t len, const void *q, size_t n)
{
	DBGLOG(TEST, SOAP_MESSAGE(fdebug, "Copying struct ns__echoStringArrayResponse %p -> %p\n", q, p));
	*(struct ns__echoStringArrayResponse*)p = *(struct ns__echoStringArrayResponse*)q;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_default_ArrayOfstring(struct soap *soap, struct ArrayOfstring *a)
{
	a->__size = 0;
	a->__ptr = NULL;
	a->__offset = 0;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_serialize_ArrayOfstring(struct soap *soap, struct ArrayOfstring const*a)
{
	int i;
	if (a->__ptr && !soap_array_reference(soap, a, (struct soap_array*)&a->__ptr, 1, SOAP_TYPE_ArrayOfstring))
		for (i = 0; i < a->__size; i++)
		{
			soap_serialize_xsd__string(soap, a->__ptr + i);
		}
}

SOAP_FMAC3 int SOAP_FMAC4 soap_put_ArrayOfstring(struct soap *soap, const struct ArrayOfstring *a, const char *tag, const char *type)
{
	register int id = soap_embed(soap, (void*)a, (struct soap_array*)&a->__ptr, 1, tag, SOAP_TYPE_ArrayOfstring);
	if (soap_out_ArrayOfstring(soap, tag, id, a, type))
		return soap->error;
	return soap_putindependent(soap);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out_ArrayOfstring(struct soap *soap, const char *tag, int id, const struct ArrayOfstring *a, const char *type)
{
	int i, n = a->__size;
	char *t = soap_putsize(soap, "xsd:string", n + a->__offset);
	id = soap_element_id(soap, tag, id, a, (struct soap_array*)&a->__ptr, 1, type, SOAP_TYPE_ArrayOfstring);
	if (id < 0)
		return soap->error;
	if (soap_array_begin_out(soap, tag, id, t, soap_putoffset(soap, a->__offset)))
		return soap->error;
	for (i = 0; i < n; i++)
	{
		soap->position = 1;
		soap->positions[0] = i;
		soap_out_xsd__string(soap, "item", -1, &a->__ptr[i], "");
	}
	soap->position = 0;
	return soap_element_end_out(soap, tag);
}

SOAP_FMAC3 struct ArrayOfstring * SOAP_FMAC4 soap_get_ArrayOfstring(struct soap *soap, struct ArrayOfstring *p, const char *tag, const char *type)
{
	if ((p = soap_in_ArrayOfstring(soap, tag, p, type)))
		if (soap_getindependent(soap))
			return NULL;
	return p;
}

SOAP_FMAC3 struct ArrayOfstring * SOAP_FMAC4 soap_in_ArrayOfstring(struct soap *soap, const char *tag, struct ArrayOfstring *a, const char *type)
{	int i, j;
	char **p;
	if (soap_element_begin_in(soap, tag, 1, NULL))
		return NULL;
	if (soap_match_array(soap, type))
	{	soap->error = SOAP_TYPE;
		return NULL;
	}
	a = (struct ArrayOfstring *)soap_id_enter(soap, soap->id, a, SOAP_TYPE_ArrayOfstring, sizeof(struct ArrayOfstring), 0, NULL, NULL, NULL);
	if (!a)
		return NULL;
	soap_default_ArrayOfstring(soap, a);
	if (soap->body && !*soap->href)
	{
		a->__size = soap_getsize(soap->arraySize, soap->arrayOffset, &j);
		a->__offset = j;
		if (a->__size >= 0)
		{	a->__ptr = (char **)soap_malloc(soap, sizeof(char *) * a->__size);
			for (i = 0; i < a->__size; i++)
				a->__ptr[i] = NULL;
			for (i = 0; i < a->__size; i++)
			{	soap_peek_element(soap);
				if (soap->position)
				{	i = soap->positions[0]-j;
					if (i < 0 || i >= a->__size)
					{	soap->error = SOAP_IOB;
						return NULL;
					}
				}
				if (!soap_in_xsd__string(soap, NULL, a->__ptr + i, "xsd:string"))
				{	if (soap->error != SOAP_NO_TAG)
						return NULL;
					soap->error = SOAP_OK;
					break;
				}
			}
		}
		else
		{	soap_new_block(soap);
			for (a->__size = 0; ; a->__size++)
			{	p = (char **)soap_push_block(soap, sizeof(char *));
				if (!p)
					return NULL;
				*p = NULL;
				if (!soap_in_xsd__string(soap, NULL, p, "xsd:string"))
				{	if (soap->error != SOAP_NO_TAG)
						return NULL;
					soap->error = SOAP_OK;
					break;
				}
			}
			soap_pop_block(soap);
			a->__ptr = (char **)soap_malloc(soap, soap->blist->size);
			soap_save_block(soap, (char*)a->__ptr, 1);
		}
		if (soap_element_end_in(soap, tag))
			return NULL;
	}
	else
	{	a = (struct ArrayOfstring *)soap_id_forward(soap, soap->href, (void*)a, 0, SOAP_TYPE_ArrayOfstring, 0, sizeof(struct ArrayOfstring), 0, NULL);
		if (soap->body && soap_element_end_in(soap, tag))
			return NULL;
	}
	return a;
}

SOAP_FMAC5 struct ArrayOfstring * SOAP_FMAC6 soap_new_ArrayOfstring(struct soap *soap, int n)
{	return soap_instantiate_ArrayOfstring(soap, n, NULL, NULL, NULL);
}

SOAP_FMAC5 void SOAP_FMAC6 soap_delete_ArrayOfstring(struct soap *soap, struct ArrayOfstring *p)
{	soap_delete(soap, p);
}

SOAP_FMAC3 struct ArrayOfstring * SOAP_FMAC4 soap_instantiate_ArrayOfstring(struct soap *soap, int n, const char *type, const char *arrayType, size_t *size)
{
	DBGLOG(TEST, SOAP_MESSAGE(fdebug, "soap_instantiate_ArrayOfstring(%d, %s, %s)\n", n, type?type:"", arrayType?arrayType:""));
	struct soap_clist *cp = soap_link(soap, NULL, SOAP_TYPE_ArrayOfstring, n, soap_fdelete);
	if (!cp)
		return NULL;
	if (n < 0)
	{	cp->ptr = (void*)new struct ArrayOfstring;
		if (size)
			*size = sizeof(struct ArrayOfstring);
	}
	else
	{	cp->ptr = (void*)new struct ArrayOfstring[n];
		if (!cp->ptr)
		{	soap->error = SOAP_EOM;
			return NULL;
		}
		if (size)
			*size = n * sizeof(struct ArrayOfstring);
	}
		DBGLOG(TEST, SOAP_MESSAGE(fdebug, "Instantiated location=%p\n", cp->ptr));
	return (struct ArrayOfstring*)cp->ptr;
}
SOAP_FMAC3 void SOAP_FMAC4 soap_copy_ArrayOfstring(struct soap *soap, int st, int tt, void *p, size_t len, const void *q, size_t n)
{
	DBGLOG(TEST, SOAP_MESSAGE(fdebug, "Copying struct ArrayOfstring %p -> %p\n", q, p));
	*(struct ArrayOfstring*)p = *(struct ArrayOfstring*)q;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_default_ns__echoString(struct soap *soap, struct ns__echoString *a)
{
	(void)soap; (void)a; /* appease -Wall -Werror */
	soap_default_xsd__string(soap, &a->inputString);
}

SOAP_FMAC3 void SOAP_FMAC4 soap_serialize_ns__echoString(struct soap *soap, const struct ns__echoString *a)
{
	(void)soap; (void)a; /* appease -Wall -Werror */
	soap_serialize_xsd__string(soap, &a->inputString);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_put_ns__echoString(struct soap *soap, const struct ns__echoString *a, const char *tag, const char *type)
{
	register int id = soap_embed(soap, (void*)a, NULL, 0, tag, SOAP_TYPE_ns__echoString);
	if (soap_out_ns__echoString(soap, tag, id, a, type))
		return soap->error;
	return soap_putindependent(soap);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out_ns__echoString(struct soap *soap, const char *tag, int id, const struct ns__echoString *a, const char *type)
{
	if (soap_element_begin_out(soap, tag, soap_embedded_id(soap, id, a, SOAP_TYPE_ns__echoString), type))
		return soap->error;
	if (soap_out_xsd__string(soap, "inputString", -1, &a->inputString, ""))
		return soap->error;
	return soap_element_end_out(soap, tag);
}

SOAP_FMAC3 struct ns__echoString * SOAP_FMAC4 soap_get_ns__echoString(struct soap *soap, struct ns__echoString *p, const char *tag, const char *type)
{
	if ((p = soap_in_ns__echoString(soap, tag, p, type)))
		if (soap_getindependent(soap))
			return NULL;
	return p;
}

SOAP_FMAC3 struct ns__echoString * SOAP_FMAC4 soap_in_ns__echoString(struct soap *soap, const char *tag, struct ns__echoString *a, const char *type)
{
	short soap_flag_inputString = 1;
	if (soap_element_begin_in(soap, tag, 0, type))
		return NULL;
	a = (struct ns__echoString *)soap_id_enter(soap, soap->id, a, SOAP_TYPE_ns__echoString, sizeof(struct ns__echoString), 0, NULL, NULL, NULL);
	if (!a)
		return NULL;
	soap_default_ns__echoString(soap, a);
	if (soap->body && !*soap->href)
	{
		for (;;)
		{	soap->error = SOAP_TAG_MISMATCH;
			if (soap_flag_inputString && (soap->error == SOAP_TAG_MISMATCH || soap->error == SOAP_NO_TAG))
				if (soap_in_xsd__string(soap, "inputString", &a->inputString, "xsd:string"))
				{	soap_flag_inputString--;
					continue;
				}
			if (soap->error == SOAP_TAG_MISMATCH)
				soap->error = soap_ignore_element(soap);
			if (soap->error == SOAP_NO_TAG)
				break;
			if (soap->error)
				return NULL;
		}
		if (soap_element_end_in(soap, tag))
			return NULL;
	}
	else
	{	a = (struct ns__echoString *)soap_id_forward(soap, soap->href, (void*)a, 0, SOAP_TYPE_ns__echoString, 0, sizeof(struct ns__echoString), 0, NULL);
		if (soap->body && soap_element_end_in(soap, tag))
			return NULL;
	}
	return a;
}

SOAP_FMAC5 struct ns__echoString * SOAP_FMAC6 soap_new_ns__echoString(struct soap *soap, int n)
{	return soap_instantiate_ns__echoString(soap, n, NULL, NULL, NULL);
}

SOAP_FMAC5 void SOAP_FMAC6 soap_delete_ns__echoString(struct soap *soap, struct ns__echoString *p)
{	soap_delete(soap, p);
}

SOAP_FMAC3 struct ns__echoString * SOAP_FMAC4 soap_instantiate_ns__echoString(struct soap *soap, int n, const char *type, const char *arrayType, size_t *size)
{
	DBGLOG(TEST, SOAP_MESSAGE(fdebug, "soap_instantiate_ns__echoString(%d, %s, %s)\n", n, type?type:"", arrayType?arrayType:""));
	struct soap_clist *cp = soap_link(soap, NULL, SOAP_TYPE_ns__echoString, n, soap_fdelete);
	if (!cp)
		return NULL;
	if (n < 0)
	{	cp->ptr = (void*)new struct ns__echoString;
		if (size)
			*size = sizeof(struct ns__echoString);
	}
	else
	{	cp->ptr = (void*)new struct ns__echoString[n];
		if (!cp->ptr)
		{	soap->error = SOAP_EOM;
			return NULL;
		}
		if (size)
			*size = n * sizeof(struct ns__echoString);
	}
		DBGLOG(TEST, SOAP_MESSAGE(fdebug, "Instantiated location=%p\n", cp->ptr));
	return (struct ns__echoString*)cp->ptr;
}
SOAP_FMAC3 void SOAP_FMAC4 soap_copy_ns__echoString(struct soap *soap, int st, int tt, void *p, size_t len, const void *q, size_t n)
{
	DBGLOG(TEST, SOAP_MESSAGE(fdebug, "Copying struct ns__echoString %p -> %p\n", q, p));
	*(struct ns__echoString*)p = *(struct ns__echoString*)q;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_default_ns__echoStringResponse(struct soap *soap, struct ns__echoStringResponse *a)
{
	(void)soap; (void)a; /* appease -Wall -Werror */
	soap_default_xsd__string(soap, &a->_return);
}

SOAP_FMAC3 void SOAP_FMAC4 soap_serialize_ns__echoStringResponse(struct soap *soap, const struct ns__echoStringResponse *a)
{
	(void)soap; (void)a; /* appease -Wall -Werror */
	soap_serialize_xsd__string(soap, &a->_return);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_put_ns__echoStringResponse(struct soap *soap, const struct ns__echoStringResponse *a, const char *tag, const char *type)
{
	register int id = soap_embed(soap, (void*)a, NULL, 0, tag, SOAP_TYPE_ns__echoStringResponse);
	if (soap_out_ns__echoStringResponse(soap, tag, id, a, type))
		return soap->error;
	return soap_putindependent(soap);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out_ns__echoStringResponse(struct soap *soap, const char *tag, int id, const struct ns__echoStringResponse *a, const char *type)
{
	if (soap_element_begin_out(soap, tag, soap_embedded_id(soap, id, a, SOAP_TYPE_ns__echoStringResponse), type))
		return soap->error;
	if (soap_out_xsd__string(soap, "return", -1, &a->_return, ""))
		return soap->error;
	return soap_element_end_out(soap, tag);
}

SOAP_FMAC3 struct ns__echoStringResponse * SOAP_FMAC4 soap_get_ns__echoStringResponse(struct soap *soap, struct ns__echoStringResponse *p, const char *tag, const char *type)
{
	if ((p = soap_in_ns__echoStringResponse(soap, tag, p, type)))
		if (soap_getindependent(soap))
			return NULL;
	return p;
}

SOAP_FMAC3 struct ns__echoStringResponse * SOAP_FMAC4 soap_in_ns__echoStringResponse(struct soap *soap, const char *tag, struct ns__echoStringResponse *a, const char *type)
{
	short soap_flag__return = 1;
	if (soap_element_begin_in(soap, tag, 0, type))
		return NULL;
	a = (struct ns__echoStringResponse *)soap_id_enter(soap, soap->id, a, SOAP_TYPE_ns__echoStringResponse, sizeof(struct ns__echoStringResponse), 0, NULL, NULL, NULL);
	if (!a)
		return NULL;
	soap_default_ns__echoStringResponse(soap, a);
	if (soap->body && !*soap->href)
	{
		for (;;)
		{	soap->error = SOAP_TAG_MISMATCH;
			if (soap_flag__return && (soap->error == SOAP_TAG_MISMATCH || soap->error == SOAP_NO_TAG))
				if (soap_in_xsd__string(soap, NULL, &a->_return, "xsd:string"))
				{	soap_flag__return--;
					continue;
				}
			if (soap->error == SOAP_TAG_MISMATCH)
				soap->error = soap_ignore_element(soap);
			if (soap->error == SOAP_NO_TAG)
				break;
			if (soap->error)
				return NULL;
		}
		if (soap_element_end_in(soap, tag))
			return NULL;
	}
	else
	{	a = (struct ns__echoStringResponse *)soap_id_forward(soap, soap->href, (void*)a, 0, SOAP_TYPE_ns__echoStringResponse, 0, sizeof(struct ns__echoStringResponse), 0, NULL);
		if (soap->body && soap_element_end_in(soap, tag))
			return NULL;
	}
	if ((soap->mode & SOAP_XML_STRICT) && (soap_flag__return > 0))
	{	soap->error = SOAP_OCCURS;
		return NULL;
	}
	return a;
}

SOAP_FMAC5 struct ns__echoStringResponse * SOAP_FMAC6 soap_new_ns__echoStringResponse(struct soap *soap, int n)
{	return soap_instantiate_ns__echoStringResponse(soap, n, NULL, NULL, NULL);
}

SOAP_FMAC5 void SOAP_FMAC6 soap_delete_ns__echoStringResponse(struct soap *soap, struct ns__echoStringResponse *p)
{	soap_delete(soap, p);
}

SOAP_FMAC3 struct ns__echoStringResponse * SOAP_FMAC4 soap_instantiate_ns__echoStringResponse(struct soap *soap, int n, const char *type, const char *arrayType, size_t *size)
{
	DBGLOG(TEST, SOAP_MESSAGE(fdebug, "soap_instantiate_ns__echoStringResponse(%d, %s, %s)\n", n, type?type:"", arrayType?arrayType:""));
	struct soap_clist *cp = soap_link(soap, NULL, SOAP_TYPE_ns__echoStringResponse, n, soap_fdelete);
	if (!cp)
		return NULL;
	if (n < 0)
	{	cp->ptr = (void*)new struct ns__echoStringResponse;
		if (size)
			*size = sizeof(struct ns__echoStringResponse);
	}
	else
	{	cp->ptr = (void*)new struct ns__echoStringResponse[n];
		if (!cp->ptr)
		{	soap->error = SOAP_EOM;
			return NULL;
		}
		if (size)
			*size = n * sizeof(struct ns__echoStringResponse);
	}
		DBGLOG(TEST, SOAP_MESSAGE(fdebug, "Instantiated location=%p\n", cp->ptr));
	return (struct ns__echoStringResponse*)cp->ptr;
}
SOAP_FMAC3 void SOAP_FMAC4 soap_copy_ns__echoStringResponse(struct soap *soap, int st, int tt, void *p, size_t len, const void *q, size_t n)
{
	DBGLOG(TEST, SOAP_MESSAGE(fdebug, "Copying struct ns__echoStringResponse %p -> %p\n", q, p));
	*(struct ns__echoStringResponse*)p = *(struct ns__echoStringResponse*)q;
}

#ifndef WITH_NOGLOBAL

SOAP_FMAC3 void SOAP_FMAC4 soap_serialize_PointerToSOAP_ENV__Reason(struct soap *soap, struct SOAP_ENV__Reason *const*a)
{
	if (!soap_reference(soap, *a, SOAP_TYPE_SOAP_ENV__Reason))
		soap_serialize_SOAP_ENV__Reason(soap, *a);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_put_PointerToSOAP_ENV__Reason(struct soap *soap, struct SOAP_ENV__Reason *const*a, const char *tag, const char *type)
{
	register int id = soap_embed(soap, (void*)a, NULL, 0, tag, SOAP_TYPE_PointerToSOAP_ENV__Reason);
	if (soap_out_PointerToSOAP_ENV__Reason(soap, tag, id, a, type))
		return soap->error;
	return soap_putindependent(soap);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out_PointerToSOAP_ENV__Reason(struct soap *soap, const char *tag, int id, struct SOAP_ENV__Reason *const*a, const char *type)
{
	id = soap_element_id(soap, tag, id, *a, NULL, 0, type, SOAP_TYPE_SOAP_ENV__Reason);
	if (id < 0)
		return soap->error;
	return soap_out_SOAP_ENV__Reason(soap, tag, id, *a, type);
}

SOAP_FMAC3 struct SOAP_ENV__Reason ** SOAP_FMAC4 soap_get_PointerToSOAP_ENV__Reason(struct soap *soap, struct SOAP_ENV__Reason **p, const char *tag, const char *type)
{
	if ((p = soap_in_PointerToSOAP_ENV__Reason(soap, tag, p, type)))
		if (soap_getindependent(soap))
			return NULL;
	return p;
}

SOAP_FMAC3 struct SOAP_ENV__Reason ** SOAP_FMAC4 soap_in_PointerToSOAP_ENV__Reason(struct soap *soap, const char *tag, struct SOAP_ENV__Reason **a, const char *type)
{
	if (soap_element_begin_in(soap, tag, 1, NULL))
		return NULL;
	if (!a)
		if (!(a = (struct SOAP_ENV__Reason **)soap_malloc(soap, sizeof(struct SOAP_ENV__Reason *))))
			return NULL;
	*a = NULL;
	if (!soap->null && *soap->href != '#')
	{	soap_revert(soap);
		if (!(*a = soap_in_SOAP_ENV__Reason(soap, tag, *a, type)))
			return NULL;
	}
	else
	{	a = (struct SOAP_ENV__Reason **)soap_id_lookup(soap, soap->href, (void**)a, SOAP_TYPE_SOAP_ENV__Reason, sizeof(struct SOAP_ENV__Reason), 0);
		if (soap->body && soap_element_end_in(soap, tag))
			return NULL;
	}
	return a;
}

#endif

#ifndef WITH_NOGLOBAL

SOAP_FMAC3 void SOAP_FMAC4 soap_serialize_PointerToSOAP_ENV__Detail(struct soap *soap, struct SOAP_ENV__Detail *const*a)
{
	if (!soap_reference(soap, *a, SOAP_TYPE_SOAP_ENV__Detail))
		soap_serialize_SOAP_ENV__Detail(soap, *a);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_put_PointerToSOAP_ENV__Detail(struct soap *soap, struct SOAP_ENV__Detail *const*a, const char *tag, const char *type)
{
	register int id = soap_embed(soap, (void*)a, NULL, 0, tag, SOAP_TYPE_PointerToSOAP_ENV__Detail);
	if (soap_out_PointerToSOAP_ENV__Detail(soap, tag, id, a, type))
		return soap->error;
	return soap_putindependent(soap);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out_PointerToSOAP_ENV__Detail(struct soap *soap, const char *tag, int id, struct SOAP_ENV__Detail *const*a, const char *type)
{
	id = soap_element_id(soap, tag, id, *a, NULL, 0, type, SOAP_TYPE_SOAP_ENV__Detail);
	if (id < 0)
		return soap->error;
	return soap_out_SOAP_ENV__Detail(soap, tag, id, *a, type);
}

SOAP_FMAC3 struct SOAP_ENV__Detail ** SOAP_FMAC4 soap_get_PointerToSOAP_ENV__Detail(struct soap *soap, struct SOAP_ENV__Detail **p, const char *tag, const char *type)
{
	if ((p = soap_in_PointerToSOAP_ENV__Detail(soap, tag, p, type)))
		if (soap_getindependent(soap))
			return NULL;
	return p;
}

SOAP_FMAC3 struct SOAP_ENV__Detail ** SOAP_FMAC4 soap_in_PointerToSOAP_ENV__Detail(struct soap *soap, const char *tag, struct SOAP_ENV__Detail **a, const char *type)
{
	if (soap_element_begin_in(soap, tag, 1, NULL))
		return NULL;
	if (!a)
		if (!(a = (struct SOAP_ENV__Detail **)soap_malloc(soap, sizeof(struct SOAP_ENV__Detail *))))
			return NULL;
	*a = NULL;
	if (!soap->null && *soap->href != '#')
	{	soap_revert(soap);
		if (!(*a = soap_in_SOAP_ENV__Detail(soap, tag, *a, type)))
			return NULL;
	}
	else
	{	a = (struct SOAP_ENV__Detail **)soap_id_lookup(soap, soap->href, (void**)a, SOAP_TYPE_SOAP_ENV__Detail, sizeof(struct SOAP_ENV__Detail), 0);
		if (soap->body && soap_element_end_in(soap, tag))
			return NULL;
	}
	return a;
}

#endif

#ifndef WITH_NOGLOBAL

SOAP_FMAC3 void SOAP_FMAC4 soap_serialize_PointerToSOAP_ENV__Code(struct soap *soap, struct SOAP_ENV__Code *const*a)
{
	if (!soap_reference(soap, *a, SOAP_TYPE_SOAP_ENV__Code))
		soap_serialize_SOAP_ENV__Code(soap, *a);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_put_PointerToSOAP_ENV__Code(struct soap *soap, struct SOAP_ENV__Code *const*a, const char *tag, const char *type)
{
	register int id = soap_embed(soap, (void*)a, NULL, 0, tag, SOAP_TYPE_PointerToSOAP_ENV__Code);
	if (soap_out_PointerToSOAP_ENV__Code(soap, tag, id, a, type))
		return soap->error;
	return soap_putindependent(soap);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out_PointerToSOAP_ENV__Code(struct soap *soap, const char *tag, int id, struct SOAP_ENV__Code *const*a, const char *type)
{
	id = soap_element_id(soap, tag, id, *a, NULL, 0, type, SOAP_TYPE_SOAP_ENV__Code);
	if (id < 0)
		return soap->error;
	return soap_out_SOAP_ENV__Code(soap, tag, id, *a, type);
}

SOAP_FMAC3 struct SOAP_ENV__Code ** SOAP_FMAC4 soap_get_PointerToSOAP_ENV__Code(struct soap *soap, struct SOAP_ENV__Code **p, const char *tag, const char *type)
{
	if ((p = soap_in_PointerToSOAP_ENV__Code(soap, tag, p, type)))
		if (soap_getindependent(soap))
			return NULL;
	return p;
}

SOAP_FMAC3 struct SOAP_ENV__Code ** SOAP_FMAC4 soap_in_PointerToSOAP_ENV__Code(struct soap *soap, const char *tag, struct SOAP_ENV__Code **a, const char *type)
{
	if (soap_element_begin_in(soap, tag, 1, NULL))
		return NULL;
	if (!a)
		if (!(a = (struct SOAP_ENV__Code **)soap_malloc(soap, sizeof(struct SOAP_ENV__Code *))))
			return NULL;
	*a = NULL;
	if (!soap->null && *soap->href != '#')
	{	soap_revert(soap);
		if (!(*a = soap_in_SOAP_ENV__Code(soap, tag, *a, type)))
			return NULL;
	}
	else
	{	a = (struct SOAP_ENV__Code **)soap_id_lookup(soap, soap->href, (void**)a, SOAP_TYPE_SOAP_ENV__Code, sizeof(struct SOAP_ENV__Code), 0);
		if (soap->body && soap_element_end_in(soap, tag))
			return NULL;
	}
	return a;
}

#endif

SOAP_FMAC3 void SOAP_FMAC4 soap_default_xsd__decimal(struct soap *soap, char **a)
{	soap_default_string(soap, a);
}

SOAP_FMAC3 void SOAP_FMAC4 soap_serialize_xsd__decimal(struct soap *soap, char *const*a)
{	soap_serialize_string(soap, a);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_put_xsd__decimal(struct soap *soap, char *const*a, const char *tag, const char *type)
{
	register int id = soap_embed(soap, (void*)a, NULL, 0, tag, SOAP_TYPE_xsd__decimal);
	if (soap_out_xsd__decimal(soap, tag, id, a, type))
		return soap->error;
	return soap_putindependent(soap);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out_xsd__decimal(struct soap *soap, const char *tag, int id, char *const*a, const char *type)
{
	return soap_outstring(soap, tag, id, a, type, SOAP_TYPE_xsd__decimal);
}

SOAP_FMAC3 char ** SOAP_FMAC4 soap_get_xsd__decimal(struct soap *soap, char **p, const char *tag, const char *type)
{
	if ((p = soap_in_xsd__decimal(soap, tag, p, type)))
		if (soap_getindependent(soap))
			return NULL;
	return p;
}

SOAP_FMAC3 char * * SOAP_FMAC4 soap_in_xsd__decimal(struct soap *soap, const char *tag, char **a, const char *type)
{
	return soap_instring(soap, tag, a, type, SOAP_TYPE_xsd__decimal, 1, -1, -1);
}

SOAP_FMAC3 void SOAP_FMAC4 soap_default_xsd__dateTime(struct soap *soap, char **a)
{	soap_default_string(soap, a);
}

SOAP_FMAC3 void SOAP_FMAC4 soap_serialize_xsd__dateTime(struct soap *soap, char *const*a)
{	soap_serialize_string(soap, a);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_put_xsd__dateTime(struct soap *soap, char *const*a, const char *tag, const char *type)
{
	register int id = soap_embed(soap, (void*)a, NULL, 0, tag, SOAP_TYPE_xsd__dateTime);
	if (soap_out_xsd__dateTime(soap, tag, id, a, type))
		return soap->error;
	return soap_putindependent(soap);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out_xsd__dateTime(struct soap *soap, const char *tag, int id, char *const*a, const char *type)
{
	return soap_outstring(soap, tag, id, a, type, SOAP_TYPE_xsd__dateTime);
}

SOAP_FMAC3 char ** SOAP_FMAC4 soap_get_xsd__dateTime(struct soap *soap, char **p, const char *tag, const char *type)
{
	if ((p = soap_in_xsd__dateTime(soap, tag, p, type)))
		if (soap_getindependent(soap))
			return NULL;
	return p;
}

SOAP_FMAC3 char * * SOAP_FMAC4 soap_in_xsd__dateTime(struct soap *soap, const char *tag, char **a, const char *type)
{
	return soap_instring(soap, tag, a, type, SOAP_TYPE_xsd__dateTime, 1, -1, -1);
}

SOAP_FMAC3 void SOAP_FMAC4 soap_serialize_PointerTounsignedByte(struct soap *soap, unsigned char *const*a)
{
	soap_reference(soap, *a, SOAP_TYPE_unsignedByte);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_put_PointerTounsignedByte(struct soap *soap, unsigned char *const*a, const char *tag, const char *type)
{
	register int id = soap_embed(soap, (void*)a, NULL, 0, tag, SOAP_TYPE_PointerTounsignedByte);
	if (soap_out_PointerTounsignedByte(soap, tag, id, a, type))
		return soap->error;
	return soap_putindependent(soap);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out_PointerTounsignedByte(struct soap *soap, const char *tag, int id, unsigned char *const*a, const char *type)
{
	id = soap_element_id(soap, tag, id, *a, NULL, 0, type, SOAP_TYPE_unsignedByte);
	if (id < 0)
		return soap->error;
	return soap_out_unsignedByte(soap, tag, id, *a, type);
}

SOAP_FMAC3 unsigned char ** SOAP_FMAC4 soap_get_PointerTounsignedByte(struct soap *soap, unsigned char **p, const char *tag, const char *type)
{
	if ((p = soap_in_PointerTounsignedByte(soap, tag, p, type)))
		if (soap_getindependent(soap))
			return NULL;
	return p;
}

SOAP_FMAC3 unsigned char ** SOAP_FMAC4 soap_in_PointerTounsignedByte(struct soap *soap, const char *tag, unsigned char **a, const char *type)
{
	if (soap_element_begin_in(soap, tag, 1, NULL))
		return NULL;
	if (!a)
		if (!(a = (unsigned char **)soap_malloc(soap, sizeof(unsigned char *))))
			return NULL;
	*a = NULL;
	if (!soap->null && *soap->href != '#')
	{	soap_revert(soap);
		if (!(*a = soap_in_unsignedByte(soap, tag, *a, type)))
			return NULL;
	}
	else
	{	a = (unsigned char **)soap_id_lookup(soap, soap->href, (void**)a, SOAP_TYPE_unsignedByte, sizeof(unsigned char), 0);
		if (soap->body && soap_element_end_in(soap, tag))
			return NULL;
	}
	return a;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_serialize_PointerToPointerTos__SOAPStruct(struct soap *soap, struct s__SOAPStruct **const*a)
{
	if (!soap_reference(soap, *a, SOAP_TYPE_PointerTos__SOAPStruct))
		soap_serialize_PointerTos__SOAPStruct(soap, *a);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_put_PointerToPointerTos__SOAPStruct(struct soap *soap, struct s__SOAPStruct **const*a, const char *tag, const char *type)
{
	register int id = soap_embed(soap, (void*)a, NULL, 0, tag, SOAP_TYPE_PointerToPointerTos__SOAPStruct);
	if (soap_out_PointerToPointerTos__SOAPStruct(soap, tag, id, a, type))
		return soap->error;
	return soap_putindependent(soap);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out_PointerToPointerTos__SOAPStruct(struct soap *soap, const char *tag, int id, struct s__SOAPStruct **const*a, const char *type)
{
	id = soap_element_id(soap, tag, id, *a, NULL, 0, type, SOAP_TYPE_PointerTos__SOAPStruct);
	if (id < 0)
		return soap->error;
	return soap_out_PointerTos__SOAPStruct(soap, tag, id, *a, type);
}

SOAP_FMAC3 struct s__SOAPStruct *** SOAP_FMAC4 soap_get_PointerToPointerTos__SOAPStruct(struct soap *soap, struct s__SOAPStruct ***p, const char *tag, const char *type)
{
	if ((p = soap_in_PointerToPointerTos__SOAPStruct(soap, tag, p, type)))
		if (soap_getindependent(soap))
			return NULL;
	return p;
}

SOAP_FMAC3 struct s__SOAPStruct *** SOAP_FMAC4 soap_in_PointerToPointerTos__SOAPStruct(struct soap *soap, const char *tag, struct s__SOAPStruct ***a, const char *type)
{
	if (soap_element_begin_in(soap, tag, 1, NULL))
		return NULL;
	if (!a)
		if (!(a = (struct s__SOAPStruct ***)soap_malloc(soap, sizeof(struct s__SOAPStruct **))))
			return NULL;
	*a = NULL;
	if (!soap->null && *soap->href != '#')
	{	soap_revert(soap);
		if (!(*a = soap_in_PointerTos__SOAPStruct(soap, tag, *a, type)))
			return NULL;
	}
	else
	{	a = (struct s__SOAPStruct ***)soap_id_lookup(soap, soap->href, (void**)a, SOAP_TYPE_PointerTos__SOAPStruct, sizeof(struct s__SOAPStruct *), 1);
		if (soap->body && soap_element_end_in(soap, tag))
			return NULL;
	}
	return a;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_serialize_PointerTos__SOAPStruct(struct soap *soap, struct s__SOAPStruct *const*a)
{
	if (!soap_reference(soap, *a, SOAP_TYPE_s__SOAPStruct))
		soap_serialize_s__SOAPStruct(soap, *a);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_put_PointerTos__SOAPStruct(struct soap *soap, struct s__SOAPStruct *const*a, const char *tag, const char *type)
{
	register int id = soap_embed(soap, (void*)a, NULL, 0, tag, SOAP_TYPE_PointerTos__SOAPStruct);
	if (soap_out_PointerTos__SOAPStruct(soap, tag, id, a, type))
		return soap->error;
	return soap_putindependent(soap);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out_PointerTos__SOAPStruct(struct soap *soap, const char *tag, int id, struct s__SOAPStruct *const*a, const char *type)
{
	id = soap_element_id(soap, tag, id, *a, NULL, 0, type, SOAP_TYPE_s__SOAPStruct);
	if (id < 0)
		return soap->error;
	return soap_out_s__SOAPStruct(soap, tag, id, *a, type);
}

SOAP_FMAC3 struct s__SOAPStruct ** SOAP_FMAC4 soap_get_PointerTos__SOAPStruct(struct soap *soap, struct s__SOAPStruct **p, const char *tag, const char *type)
{
	if ((p = soap_in_PointerTos__SOAPStruct(soap, tag, p, type)))
		if (soap_getindependent(soap))
			return NULL;
	return p;
}

SOAP_FMAC3 struct s__SOAPStruct ** SOAP_FMAC4 soap_in_PointerTos__SOAPStruct(struct soap *soap, const char *tag, struct s__SOAPStruct **a, const char *type)
{
	if (soap_element_begin_in(soap, tag, 1, NULL))
		return NULL;
	if (!a)
		if (!(a = (struct s__SOAPStruct **)soap_malloc(soap, sizeof(struct s__SOAPStruct *))))
			return NULL;
	*a = NULL;
	if (!soap->null && *soap->href != '#')
	{	soap_revert(soap);
		if (!(*a = soap_in_s__SOAPStruct(soap, tag, *a, type)))
			return NULL;
	}
	else
	{	a = (struct s__SOAPStruct **)soap_id_lookup(soap, soap->href, (void**)a, SOAP_TYPE_s__SOAPStruct, sizeof(struct s__SOAPStruct), 0);
		if (soap->body && soap_element_end_in(soap, tag))
			return NULL;
	}
	return a;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_serialize_PointerToPointerToxsd__float(struct soap *soap, float **const*a)
{
	if (!soap_reference(soap, *a, SOAP_TYPE_PointerToxsd__float))
		soap_serialize_PointerToxsd__float(soap, *a);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_put_PointerToPointerToxsd__float(struct soap *soap, float **const*a, const char *tag, const char *type)
{
	register int id = soap_embed(soap, (void*)a, NULL, 0, tag, SOAP_TYPE_PointerToPointerToxsd__float);
	if (soap_out_PointerToPointerToxsd__float(soap, tag, id, a, type))
		return soap->error;
	return soap_putindependent(soap);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out_PointerToPointerToxsd__float(struct soap *soap, const char *tag, int id, float **const*a, const char *type)
{
	id = soap_element_id(soap, tag, id, *a, NULL, 0, type, SOAP_TYPE_PointerToxsd__float);
	if (id < 0)
		return soap->error;
	return soap_out_PointerToxsd__float(soap, tag, id, *a, type);
}

SOAP_FMAC3 float *** SOAP_FMAC4 soap_get_PointerToPointerToxsd__float(struct soap *soap, float ***p, const char *tag, const char *type)
{
	if ((p = soap_in_PointerToPointerToxsd__float(soap, tag, p, type)))
		if (soap_getindependent(soap))
			return NULL;
	return p;
}

SOAP_FMAC3 float *** SOAP_FMAC4 soap_in_PointerToPointerToxsd__float(struct soap *soap, const char *tag, float ***a, const char *type)
{
	if (soap_element_begin_in(soap, tag, 1, NULL))
		return NULL;
	if (!a)
		if (!(a = (float ***)soap_malloc(soap, sizeof(float **))))
			return NULL;
	*a = NULL;
	if (!soap->null && *soap->href != '#')
	{	soap_revert(soap);
		if (!(*a = soap_in_PointerToxsd__float(soap, tag, *a, type)))
			return NULL;
	}
	else
	{	a = (float ***)soap_id_lookup(soap, soap->href, (void**)a, SOAP_TYPE_PointerToxsd__float, sizeof(float *), 1);
		if (soap->body && soap_element_end_in(soap, tag))
			return NULL;
	}
	return a;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_serialize_PointerToxsd__float(struct soap *soap, float *const*a)
{
	soap_reference(soap, *a, SOAP_TYPE_xsd__float);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_put_PointerToxsd__float(struct soap *soap, float *const*a, const char *tag, const char *type)
{
	register int id = soap_embed(soap, (void*)a, NULL, 0, tag, SOAP_TYPE_PointerToxsd__float);
	if (soap_out_PointerToxsd__float(soap, tag, id, a, type))
		return soap->error;
	return soap_putindependent(soap);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out_PointerToxsd__float(struct soap *soap, const char *tag, int id, float *const*a, const char *type)
{
	id = soap_element_id(soap, tag, id, *a, NULL, 0, type, SOAP_TYPE_xsd__float);
	if (id < 0)
		return soap->error;
	return soap_out_xsd__float(soap, tag, id, *a, type);
}

SOAP_FMAC3 float ** SOAP_FMAC4 soap_get_PointerToxsd__float(struct soap *soap, float **p, const char *tag, const char *type)
{
	if ((p = soap_in_PointerToxsd__float(soap, tag, p, type)))
		if (soap_getindependent(soap))
			return NULL;
	return p;
}

SOAP_FMAC3 float ** SOAP_FMAC4 soap_in_PointerToxsd__float(struct soap *soap, const char *tag, float **a, const char *type)
{
	if (soap_element_begin_in(soap, tag, 1, NULL))
		return NULL;
	if (!a)
		if (!(a = (float **)soap_malloc(soap, sizeof(float *))))
			return NULL;
	*a = NULL;
	if (!soap->null && *soap->href != '#')
	{	soap_revert(soap);
		if (!(*a = soap_in_xsd__float(soap, tag, *a, type)))
			return NULL;
	}
	else
	{	a = (float **)soap_id_lookup(soap, soap->href, (void**)a, SOAP_TYPE_xsd__float, sizeof(float), 0);
		if (soap->body && soap_element_end_in(soap, tag))
			return NULL;
	}
	return a;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_serialize_PointerToPointerToxsd__int(struct soap *soap, long **const*a)
{
	if (!soap_reference(soap, *a, SOAP_TYPE_PointerToxsd__int))
		soap_serialize_PointerToxsd__int(soap, *a);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_put_PointerToPointerToxsd__int(struct soap *soap, long **const*a, const char *tag, const char *type)
{
	register int id = soap_embed(soap, (void*)a, NULL, 0, tag, SOAP_TYPE_PointerToPointerToxsd__int);
	if (soap_out_PointerToPointerToxsd__int(soap, tag, id, a, type))
		return soap->error;
	return soap_putindependent(soap);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out_PointerToPointerToxsd__int(struct soap *soap, const char *tag, int id, long **const*a, const char *type)
{
	id = soap_element_id(soap, tag, id, *a, NULL, 0, type, SOAP_TYPE_PointerToxsd__int);
	if (id < 0)
		return soap->error;
	return soap_out_PointerToxsd__int(soap, tag, id, *a, type);
}

SOAP_FMAC3 long *** SOAP_FMAC4 soap_get_PointerToPointerToxsd__int(struct soap *soap, long ***p, const char *tag, const char *type)
{
	if ((p = soap_in_PointerToPointerToxsd__int(soap, tag, p, type)))
		if (soap_getindependent(soap))
			return NULL;
	return p;
}

SOAP_FMAC3 long *** SOAP_FMAC4 soap_in_PointerToPointerToxsd__int(struct soap *soap, const char *tag, long ***a, const char *type)
{
	if (soap_element_begin_in(soap, tag, 1, NULL))
		return NULL;
	if (!a)
		if (!(a = (long ***)soap_malloc(soap, sizeof(long **))))
			return NULL;
	*a = NULL;
	if (!soap->null && *soap->href != '#')
	{	soap_revert(soap);
		if (!(*a = soap_in_PointerToxsd__int(soap, tag, *a, type)))
			return NULL;
	}
	else
	{	a = (long ***)soap_id_lookup(soap, soap->href, (void**)a, SOAP_TYPE_PointerToxsd__int, sizeof(long *), 1);
		if (soap->body && soap_element_end_in(soap, tag))
			return NULL;
	}
	return a;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_serialize_PointerToxsd__int(struct soap *soap, long *const*a)
{
	soap_reference(soap, *a, SOAP_TYPE_xsd__int);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_put_PointerToxsd__int(struct soap *soap, long *const*a, const char *tag, const char *type)
{
	register int id = soap_embed(soap, (void*)a, NULL, 0, tag, SOAP_TYPE_PointerToxsd__int);
	if (soap_out_PointerToxsd__int(soap, tag, id, a, type))
		return soap->error;
	return soap_putindependent(soap);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out_PointerToxsd__int(struct soap *soap, const char *tag, int id, long *const*a, const char *type)
{
	id = soap_element_id(soap, tag, id, *a, NULL, 0, type, SOAP_TYPE_xsd__int);
	if (id < 0)
		return soap->error;
	return soap_out_xsd__int(soap, tag, id, *a, type);
}

SOAP_FMAC3 long ** SOAP_FMAC4 soap_get_PointerToxsd__int(struct soap *soap, long **p, const char *tag, const char *type)
{
	if ((p = soap_in_PointerToxsd__int(soap, tag, p, type)))
		if (soap_getindependent(soap))
			return NULL;
	return p;
}

SOAP_FMAC3 long ** SOAP_FMAC4 soap_in_PointerToxsd__int(struct soap *soap, const char *tag, long **a, const char *type)
{
	if (soap_element_begin_in(soap, tag, 1, NULL))
		return NULL;
	if (!a)
		if (!(a = (long **)soap_malloc(soap, sizeof(long *))))
			return NULL;
	*a = NULL;
	if (!soap->null && *soap->href != '#')
	{	soap_revert(soap);
		if (!(*a = soap_in_xsd__int(soap, tag, *a, type)))
			return NULL;
	}
	else
	{	a = (long **)soap_id_lookup(soap, soap->href, (void**)a, SOAP_TYPE_xsd__int, sizeof(long), 0);
		if (soap->body && soap_element_end_in(soap, tag))
			return NULL;
	}
	return a;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_serialize_PointerToxsd__string(struct soap *soap, char **const*a)
{
	if (!soap_reference(soap, *a, SOAP_TYPE_xsd__string))
		soap_serialize_xsd__string(soap, *a);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_put_PointerToxsd__string(struct soap *soap, char **const*a, const char *tag, const char *type)
{
	register int id = soap_embed(soap, (void*)a, NULL, 0, tag, SOAP_TYPE_PointerToxsd__string);
	if (soap_out_PointerToxsd__string(soap, tag, id, a, type))
		return soap->error;
	return soap_putindependent(soap);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out_PointerToxsd__string(struct soap *soap, const char *tag, int id, char **const*a, const char *type)
{
	id = soap_element_id(soap, tag, id, *a, NULL, 0, type, SOAP_TYPE_xsd__string);
	if (id < 0)
		return soap->error;
	return soap_out_xsd__string(soap, tag, id, *a, type);
}

SOAP_FMAC3 char *** SOAP_FMAC4 soap_get_PointerToxsd__string(struct soap *soap, char ***p, const char *tag, const char *type)
{
	if ((p = soap_in_PointerToxsd__string(soap, tag, p, type)))
		if (soap_getindependent(soap))
			return NULL;
	return p;
}

SOAP_FMAC3 char *** SOAP_FMAC4 soap_in_PointerToxsd__string(struct soap *soap, const char *tag, char ***a, const char *type)
{
	if (soap_element_begin_in(soap, tag, 1, NULL))
		return NULL;
	if (!a)
		if (!(a = (char ***)soap_malloc(soap, sizeof(char **))))
			return NULL;
	*a = NULL;
	if (!soap->null && *soap->href != '#')
	{	soap_revert(soap);
		if (!(*a = soap_in_xsd__string(soap, tag, *a, type)))
			return NULL;
	}
	else
	{	a = (char ***)soap_id_lookup(soap, soap->href, (void**)a, SOAP_TYPE_xsd__string, sizeof(char *), 1);
		if (soap->body && soap_element_end_in(soap, tag))
			return NULL;
	}
	return a;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_default_xsd__string(struct soap *soap, char **a)
{	soap_default_string(soap, a);
}

SOAP_FMAC3 void SOAP_FMAC4 soap_serialize_xsd__string(struct soap *soap, char *const*a)
{	soap_serialize_string(soap, a);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_put_xsd__string(struct soap *soap, char *const*a, const char *tag, const char *type)
{
	register int id = soap_embed(soap, (void*)a, NULL, 0, tag, SOAP_TYPE_xsd__string);
	if (soap_out_xsd__string(soap, tag, id, a, type))
		return soap->error;
	return soap_putindependent(soap);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out_xsd__string(struct soap *soap, const char *tag, int id, char *const*a, const char *type)
{
	return soap_outstring(soap, tag, id, a, type, SOAP_TYPE_xsd__string);
}

SOAP_FMAC3 char ** SOAP_FMAC4 soap_get_xsd__string(struct soap *soap, char **p, const char *tag, const char *type)
{
	if ((p = soap_in_xsd__string(soap, tag, p, type)))
		if (soap_getindependent(soap))
			return NULL;
	return p;
}

SOAP_FMAC3 char * * SOAP_FMAC4 soap_in_xsd__string(struct soap *soap, const char *tag, char **a, const char *type)
{
	return soap_instring(soap, tag, a, type, SOAP_TYPE_xsd__string, 1, -1, -1);
}

SOAP_FMAC3 void SOAP_FMAC4 soap_default__QName(struct soap *soap, char **a)
{	soap_default_string(soap, a);
}

SOAP_FMAC3 void SOAP_FMAC4 soap_serialize__QName(struct soap *soap, char *const*a)
{	soap_serialize_string(soap, a);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_put__QName(struct soap *soap, char *const*a, const char *tag, const char *type)
{
	register int id = soap_embed(soap, (void*)a, NULL, 0, tag, SOAP_TYPE__QName);
	if (soap_out__QName(soap, tag, id, a, type))
		return soap->error;
	return soap_putindependent(soap);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out__QName(struct soap *soap, const char *tag, int id, char *const*a, const char *type)
{
	return soap_outstring(soap, tag, id, a, type, SOAP_TYPE__QName);
}

SOAP_FMAC3 char ** SOAP_FMAC4 soap_get__QName(struct soap *soap, char **p, const char *tag, const char *type)
{
	if ((p = soap_in__QName(soap, tag, p, type)))
		if (soap_getindependent(soap))
			return NULL;
	return p;
}

SOAP_FMAC3 char * * SOAP_FMAC4 soap_in__QName(struct soap *soap, const char *tag, char **a, const char *type)
{
	return soap_instring(soap, tag, a, type, SOAP_TYPE__QName, 2, -1, -1);
}

SOAP_FMAC3 void SOAP_FMAC4 soap_default_string(struct soap *soap, char **a)
{	(void)soap; /* appease -Wall -Werror */
#ifdef SOAP_DEFAULT_string
	*a = SOAP_DEFAULT_string;
#else
	*a = (char *)0;
#endif
}

SOAP_FMAC3 void SOAP_FMAC4 soap_serialize_string(struct soap *soap, char *const*a)
{
	soap_reference(soap, *a, SOAP_TYPE_string);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_put_string(struct soap *soap, char *const*a, const char *tag, const char *type)
{
	register int id = soap_embed(soap, (void*)a, NULL, 0, tag, SOAP_TYPE_string);
	if (soap_out_string(soap, tag, id, a, type))
		return soap->error;
	return soap_putindependent(soap);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out_string(struct soap *soap, const char *tag, int id, char *const*a, const char *type)
{
	return soap_outstring(soap, tag, id, a, type, SOAP_TYPE_string);
}

SOAP_FMAC3 char ** SOAP_FMAC4 soap_get_string(struct soap *soap, char **p, const char *tag, const char *type)
{
	if ((p = soap_in_string(soap, tag, p, type)))
		if (soap_getindependent(soap))
			return NULL;
	return p;
}

SOAP_FMAC3 char * * SOAP_FMAC4 soap_in_string(struct soap *soap, const char *tag, char **a, const char *type)
{
	return soap_instring(soap, tag, a, type, SOAP_TYPE_string, 1, -1, -1);
}

SOAP_FMAC3 void SOAP_FMAC4 soap_default_Array2Ofint(struct soap *soap, int a[2])
{
	int i;
	(void)soap; /* appease -Wall -Werror */
	for (i = 0; i < 2; i++)
	soap_default_int(soap, a+i);
}

SOAP_FMAC3 void SOAP_FMAC4 soap_serialize_Array2Ofint(struct soap *soap, int const a[2])
{
	(void)soap; (void)a; /* appease -Wall -Werror */
}

SOAP_FMAC3 int SOAP_FMAC4 soap_put_Array2Ofint(struct soap *soap, int const a[2], const char *tag, const char *type)
{
	register int id = soap_embed(soap, (void*)a, NULL, 0, tag, SOAP_TYPE_Array2Ofint);
	if (soap_out_Array2Ofint(soap, tag, id, a, type))
		return soap->error;
	return soap_putindependent(soap);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out_Array2Ofint(struct soap *soap, const char *tag, int id, int const a[2], const char *type)
{
	int i;
	soap_array_begin_out(soap, tag, soap_embedded_id(soap, id, a, SOAP_TYPE_Array2Ofint), "xsd:int[2]", 0);
	for (i = 0; i < 2; i++)
	{
		soap_out_int(soap, "item", -1, a+i, "");
	}
	return soap_element_end_out(soap, tag);
}

SOAP_FMAC3 int * SOAP_FMAC4 soap_get_Array2Ofint(struct soap *soap, int a[2], const char *tag, const char *type)
{	int (*p);
	if ((p = soap_in_Array2Ofint(soap, tag, a, type)))
		if (soap_getindependent(soap))
			return NULL;
	return p;
}

SOAP_FMAC3 int * SOAP_FMAC4 soap_in_Array2Ofint(struct soap *soap, const char *tag, int a[2], const char *type)
{
	if (soap_element_begin_in(soap, tag, 0, NULL))
		return NULL;
	if (soap_match_array(soap, type))
	{	soap->error = SOAP_TYPE;
		return NULL;
	}
	a = (int (*))soap_id_enter(soap, soap->id, a, SOAP_TYPE_Array2Ofint, sizeof(int[2]), 0, NULL, NULL, NULL);
	if (!a)
		return NULL;
	soap_default_Array2Ofint(soap, a);
	if (soap->body && !*soap->href)
	{	int i;
		for (i = 0; i < 2; i++)
		{	soap_peek_element(soap);
			if (soap->position)
			{	i = soap->positions[0];
				if (i < 0 || i >= 2)
				{	soap->error = SOAP_IOB;
					return NULL;
				}
			}
			if (!soap_in_int(soap, NULL, a+i, "xsd:int"))
			{	if (soap->error != SOAP_NO_TAG)
					return NULL;
				soap->error = SOAP_OK;
				break;
			}
		}
		if (soap->mode & SOAP_C_NOIOB)
			while (soap_element_end_in(soap, tag) == SOAP_SYNTAX_ERROR)
			{	soap->peeked = 1;
				soap_ignore_element(soap);
			}
		else if (soap_element_end_in(soap, tag))
		{	if (soap->error == SOAP_SYNTAX_ERROR)
				soap->error = SOAP_IOB;
			return NULL;
		}
	}
	else
	{	a = (int (*))soap_id_forward(soap, soap->href, (void*)soap_id_enter(soap, soap->id, a, SOAP_TYPE_Array2Ofint, sizeof(int[2]), 0, NULL, NULL, NULL), 0, SOAP_TYPE_Array2Ofint, 0, sizeof(int[2]), 0, NULL);
		if (soap->body && soap_element_end_in(soap, tag))
			return NULL;
	}
	return (int *)a;
}

/* End of soapC.cpp */
