/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.artifacts.transform;

import com.google.common.collect.ImmutableList;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.gradle.api.attributes.Attribute;
import org.gradle.api.attributes.HasAttributes;
import org.gradle.api.internal.artifacts.ivyservice.resolveengine.artifact.BrokenResolvedArtifactSet;
import org.gradle.api.internal.artifacts.ivyservice.resolveengine.artifact.ResolvedArtifactSet;
import org.gradle.api.internal.artifacts.ivyservice.resolveengine.artifact.ResolvedVariant;
import org.gradle.api.internal.artifacts.ivyservice.resolveengine.artifact.ResolvedVariantSet;
import org.gradle.api.internal.artifacts.transform.ArtifactVariantSelector;
import org.gradle.api.internal.artifacts.transform.ConsumerProvidedVariantFinder;
import org.gradle.api.internal.artifacts.transform.TransformUpstreamDependenciesResolverFactory;
import org.gradle.api.internal.artifacts.transform.TransformedVariant;
import org.gradle.api.internal.artifacts.transform.TransformedVariantFactory;
import org.gradle.api.internal.attributes.AttributeContainerInternal;
import org.gradle.api.internal.attributes.AttributeValue;
import org.gradle.api.internal.attributes.AttributesSchemaInternal;
import org.gradle.api.internal.attributes.ImmutableAttributes;
import org.gradle.api.internal.attributes.ImmutableAttributesFactory;
import org.gradle.internal.component.model.AttributeMatcher;
import org.gradle.internal.component.model.AttributeMatchingExplanationBuilder;
import org.gradle.internal.component.resolution.failure.ResolutionFailureHandler;

public class AttributeMatchingArtifactVariantSelector
implements ArtifactVariantSelector {
    private final ConsumerProvidedVariantFinder consumerProvidedVariantFinder;
    private final AttributesSchemaInternal schema;
    private final ImmutableAttributesFactory attributesFactory;
    private final TransformedVariantFactory transformedVariantFactory;
    private final TransformUpstreamDependenciesResolverFactory dependenciesResolverFactory;
    private final ResolutionFailureHandler failureProcessor;

    AttributeMatchingArtifactVariantSelector(ConsumerProvidedVariantFinder consumerProvidedVariantFinder, AttributesSchemaInternal schema, ImmutableAttributesFactory attributesFactory, TransformedVariantFactory transformedVariantFactory, TransformUpstreamDependenciesResolverFactory dependenciesResolverFactory, ResolutionFailureHandler failureProcessor) {
        this.consumerProvidedVariantFinder = consumerProvidedVariantFinder;
        this.schema = schema;
        this.attributesFactory = attributesFactory;
        this.transformedVariantFactory = transformedVariantFactory;
        this.dependenciesResolverFactory = dependenciesResolverFactory;
        this.failureProcessor = failureProcessor;
    }

    @Override
    public ResolvedArtifactSet select(ResolvedVariantSet producer, ImmutableAttributes requestAttributes, boolean allowNoMatchingVariants, ArtifactVariantSelector.ResolvedArtifactTransformer resolvedArtifactTransformer) {
        try {
            return this.doSelect(producer, allowNoMatchingVariants, resolvedArtifactTransformer, AttributeMatchingExplanationBuilder.logging(), requestAttributes);
        }
        catch (Exception t) {
            return new BrokenResolvedArtifactSet((Throwable)((Object)this.failureProcessor.unknownArtifactVariantSelectionFailure(this.schema, producer, requestAttributes, t)));
        }
    }

    private ResolvedArtifactSet doSelect(ResolvedVariantSet producer, boolean allowNoMatchingVariants, ArtifactVariantSelector.ResolvedArtifactTransformer resolvedArtifactTransformer, AttributeMatchingExplanationBuilder explanationBuilder, ImmutableAttributes requestAttributes) {
        AttributeMatcher matcher = this.schema.withProducer(producer.getSchema());
        ImmutableAttributes componentRequested = this.attributesFactory.concat(requestAttributes, producer.getOverriddenAttributes());
        ImmutableList variants = ImmutableList.copyOf(producer.getVariants());
        List matches = matcher.matchMultipleCandidates(variants, componentRequested, explanationBuilder);
        if (matches.size() == 1) {
            return ((ResolvedVariant)matches.get(0)).getArtifacts();
        }
        if (matches.size() > 1) {
            TraceDiscardedVariants newExpBuilder = new TraceDiscardedVariants();
            matches = matcher.matchMultipleCandidates(variants, componentRequested, newExpBuilder);
            throw this.failureProcessor.ambiguousArtifactsFailure(this.schema, matcher, producer, componentRequested, matches);
        }
        List<TransformedVariant> transformedVariants = this.consumerProvidedVariantFinder.findTransformedVariants((List<ResolvedVariant>)variants, componentRequested);
        if (transformedVariants.size() > 1) {
            transformedVariants = AttributeMatchingArtifactVariantSelector.tryDisambiguate(matcher, transformedVariants, componentRequested, explanationBuilder);
        }
        if (transformedVariants.size() == 1) {
            TransformedVariant result = transformedVariants.get(0);
            return resolvedArtifactTransformer.asTransformed(result.getRoot(), result.getTransformedVariantDefinition(), this.dependenciesResolverFactory, this.transformedVariantFactory);
        }
        if (!transformedVariants.isEmpty()) {
            throw this.failureProcessor.ambiguousArtifactTransformsFailure(this.schema, producer, componentRequested, transformedVariants);
        }
        if (allowNoMatchingVariants) {
            return ResolvedArtifactSet.EMPTY;
        }
        throw this.failureProcessor.noCompatibleArtifactFailure(this.schema, matcher, producer, componentRequested, (List<? extends ResolvedVariant>)variants);
    }

    private static List<TransformedVariant> tryDisambiguate(AttributeMatcher matcher, List<TransformedVariant> candidates, ImmutableAttributes componentRequested, AttributeMatchingExplanationBuilder explanationBuilder) {
        List<TransformedVariant> matches = matcher.matchMultipleCandidates(candidates, componentRequested, explanationBuilder);
        if (matches.size() == 1) {
            return matches;
        }
        assert (!matches.isEmpty());
        ArrayList<TransformedVariant> differentTransforms = new ArrayList<TransformedVariant>(1);
        TransformedVariant last = matches.get(matches.size() - 1);
        differentTransforms.add(last);
        for (int i = 0; i < matches.size() - 1; ++i) {
            TransformedVariant current = matches.get(i);
            if (matcher.areMutuallyCompatible(current.getAttributes(), last.getAttributes())) continue;
            differentTransforms.add(current);
        }
        return differentTransforms;
    }

    private static class TraceDiscardedVariants
    implements AttributeMatchingExplanationBuilder {
        private final Set<HasAttributes> discarded = new HashSet<HasAttributes>();

        private TraceDiscardedVariants() {
        }

        @Override
        public boolean canSkipExplanation() {
            return false;
        }

        @Override
        public <T extends HasAttributes> void candidateDoesNotMatchAttributes(T candidate, AttributeContainerInternal requested) {
            this.recordDiscardedCandidate(candidate);
        }

        public <T extends HasAttributes> void recordDiscardedCandidate(T candidate) {
            this.discarded.add(candidate);
        }

        @Override
        public <T extends HasAttributes> void candidateAttributeDoesNotMatch(T candidate, Attribute<?> attribute, Object requestedValue, AttributeValue<?> candidateValue) {
            this.recordDiscardedCandidate(candidate);
        }
    }
}

