/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.plugins.internal;

import java.util.LinkedHashSet;
import java.util.Set;
import org.gradle.api.InvalidUserCodeException;
import org.gradle.api.Project;
import org.gradle.api.capabilities.Capability;
import org.gradle.api.internal.project.ProjectInternal;
import org.gradle.api.plugins.FeatureSpec;
import org.gradle.api.plugins.jvm.internal.DefaultJvmFeature;
import org.gradle.api.plugins.jvm.internal.JvmFeatureInternal;
import org.gradle.api.tasks.SourceSet;
import org.gradle.internal.component.external.model.DefaultImmutableCapability;
import org.gradle.internal.component.external.model.ProjectDerivedCapability;
import org.gradle.internal.deprecation.DeprecationLogger;
import org.gradle.internal.deprecation.DeprecationMessageBuilder;

public class DefaultJavaFeatureSpec
implements FeatureSpec {
    private final String name;
    private final Set<Capability> capabilities = new LinkedHashSet<Capability>(1);
    private final ProjectInternal project;
    private SourceSet sourceSet;
    private boolean withJavadocJar = false;
    private boolean withSourcesJar = false;
    private boolean allowPublication = true;

    public DefaultJavaFeatureSpec(String name, ProjectInternal project) {
        this.name = name;
        this.project = project;
    }

    public void usingSourceSet(SourceSet sourceSet) {
        this.sourceSet = sourceSet;
    }

    public void capability(String group, String name, String version) {
        this.capabilities.add((Capability)new DefaultImmutableCapability(group, name, version));
    }

    public void withJavadocJar() {
        this.withJavadocJar = true;
    }

    public void withSourcesJar() {
        this.withSourcesJar = true;
    }

    public void disablePublication() {
        this.allowPublication = false;
    }

    public boolean isPublished() {
        return this.allowPublication;
    }

    public JvmFeatureInternal create() {
        if (this.sourceSet == null) {
            throw new InvalidUserCodeException("You must specify which source set to use for feature '" + this.name + "'");
        }
        if (this.capabilities.isEmpty()) {
            this.capabilities.add((Capability)new ProjectDerivedCapability((Project)this.project, this.name));
        }
        if (SourceSet.isMain((SourceSet)this.sourceSet)) {
            ((DeprecationMessageBuilder.WithDocumentation)((DeprecationMessageBuilder.DeprecateBehaviour)DeprecationLogger.deprecateBehaviour((String)String.format("The '%s' feature was created using the main source set.", this.name)).withAdvice("The main source set is reserved for production code and should not be used for features. Use another source set instead.")).willBecomeAnErrorInGradle9().withUpgradeGuideSection(8, "deprecate_register_feature_main_source_set")).nagUser();
        }
        DefaultJvmFeature feature = new DefaultJvmFeature(this.name, this.sourceSet, this.capabilities, this.project, true, SourceSet.isMain((SourceSet)this.sourceSet));
        feature.withApi();
        if (this.withJavadocJar) {
            feature.withJavadocJar();
        }
        if (this.withSourcesJar) {
            feature.withSourcesJar();
        }
        return feature;
    }
}

