//----------------------------------------------------------------------------
// $Id: TimeSettingsTest.java 2610 2005-08-01 20:59:02Z enz $
// $Source$
//----------------------------------------------------------------------------

package net.sf.gogui.game;

import net.sf.gogui.utils.ErrorMessage;

//----------------------------------------------------------------------------

public class TimeSettingsTest
    extends junit.framework.TestCase
{
    public static void main(String args[])
    {
        junit.textui.TestRunner.run(suite());
    }

    public static junit.framework.Test suite()
    {
        return new junit.framework.TestSuite(TimeSettingsTest.class);
    }

    public void testParse()
    {
        TimeSettings settings = parse("30");
        assertEquals(settings.getPreByoyomi(), 30 * 60 * 1000);
        assertFalse(settings.getUseByoyomi());
    }

    private TimeSettings parse(String s)
    {
        try
        {
            return TimeSettings.parse(s);
        }
        catch (ErrorMessage e)
        {
            fail();
            return null;
        }
    }
}

//----------------------------------------------------------------------------
