// Code generated by protoc-gen-go. DO NOT EDIT.
// source: query.proto

/*
Package query is a generated protocol buffer package.

It is generated from these files:
	query.proto

It has these top-level messages:
	Target
	VTGateCallerID
	EventToken
	Value
	BindVariable
	BoundQuery
	ExecuteOptions
	Field
	Row
	ResultExtras
	QueryResult
	StreamEvent
	ExecuteRequest
	ExecuteResponse
	ResultWithError
	ExecuteBatchRequest
	ExecuteBatchResponse
	StreamExecuteRequest
	StreamExecuteResponse
	BeginRequest
	BeginResponse
	CommitRequest
	CommitResponse
	RollbackRequest
	RollbackResponse
	PrepareRequest
	PrepareResponse
	CommitPreparedRequest
	CommitPreparedResponse
	RollbackPreparedRequest
	RollbackPreparedResponse
	CreateTransactionRequest
	CreateTransactionResponse
	StartCommitRequest
	StartCommitResponse
	SetRollbackRequest
	SetRollbackResponse
	ConcludeTransactionRequest
	ConcludeTransactionResponse
	ReadTransactionRequest
	ReadTransactionResponse
	BeginExecuteRequest
	BeginExecuteResponse
	BeginExecuteBatchRequest
	BeginExecuteBatchResponse
	MessageStreamRequest
	MessageStreamResponse
	MessageAckRequest
	MessageAckResponse
	SplitQueryRequest
	QuerySplit
	SplitQueryResponse
	StreamHealthRequest
	RealtimeStats
	StreamHealthResponse
	UpdateStreamRequest
	UpdateStreamResponse
	TransactionMetadata
*/
package querypb

import "strconv"

// EnumName is a helper function to simplify printing protocol buffer enums
// by name.  Given an enum map and a value, it returns a useful string.
func EnumName(m map[int32]string, v int32) string {
	s, ok := m[v]
	if ok {
		return s
	}
	return strconv.Itoa(int(v))
}

// Flags sent from the MySQL C API
type MySqlFlag int32

const (
	MySqlFlag_EMPTY                 MySqlFlag = 0
	MySqlFlag_NOT_NULL_FLAG         MySqlFlag = 1
	MySqlFlag_PRI_KEY_FLAG          MySqlFlag = 2
	MySqlFlag_UNIQUE_KEY_FLAG       MySqlFlag = 4
	MySqlFlag_MULTIPLE_KEY_FLAG     MySqlFlag = 8
	MySqlFlag_BLOB_FLAG             MySqlFlag = 16
	MySqlFlag_UNSIGNED_FLAG         MySqlFlag = 32
	MySqlFlag_ZEROFILL_FLAG         MySqlFlag = 64
	MySqlFlag_BINARY_FLAG           MySqlFlag = 128
	MySqlFlag_ENUM_FLAG             MySqlFlag = 256
	MySqlFlag_AUTO_INCREMENT_FLAG   MySqlFlag = 512
	MySqlFlag_TIMESTAMP_FLAG        MySqlFlag = 1024
	MySqlFlag_SET_FLAG              MySqlFlag = 2048
	MySqlFlag_NO_DEFAULT_VALUE_FLAG MySqlFlag = 4096
	MySqlFlag_ON_UPDATE_NOW_FLAG    MySqlFlag = 8192
	MySqlFlag_NUM_FLAG              MySqlFlag = 32768
	MySqlFlag_PART_KEY_FLAG         MySqlFlag = 16384
	MySqlFlag_GROUP_FLAG            MySqlFlag = 32768
	MySqlFlag_UNIQUE_FLAG           MySqlFlag = 65536
	MySqlFlag_BINCMP_FLAG           MySqlFlag = 131072
)

var MySqlFlag_name = map[int32]string{
	0:     "EMPTY",
	1:     "NOT_NULL_FLAG",
	2:     "PRI_KEY_FLAG",
	4:     "UNIQUE_KEY_FLAG",
	8:     "MULTIPLE_KEY_FLAG",
	16:    "BLOB_FLAG",
	32:    "UNSIGNED_FLAG",
	64:    "ZEROFILL_FLAG",
	128:   "BINARY_FLAG",
	256:   "ENUM_FLAG",
	512:   "AUTO_INCREMENT_FLAG",
	1024:  "TIMESTAMP_FLAG",
	2048:  "SET_FLAG",
	4096:  "NO_DEFAULT_VALUE_FLAG",
	8192:  "ON_UPDATE_NOW_FLAG",
	32768: "NUM_FLAG",
	16384: "PART_KEY_FLAG",
	// Duplicate value: 32768: "GROUP_FLAG",
	65536:  "UNIQUE_FLAG",
	131072: "BINCMP_FLAG",
}
var MySqlFlag_value = map[string]int32{
	"EMPTY":                 0,
	"NOT_NULL_FLAG":         1,
	"PRI_KEY_FLAG":          2,
	"UNIQUE_KEY_FLAG":       4,
	"MULTIPLE_KEY_FLAG":     8,
	"BLOB_FLAG":             16,
	"UNSIGNED_FLAG":         32,
	"ZEROFILL_FLAG":         64,
	"BINARY_FLAG":           128,
	"ENUM_FLAG":             256,
	"AUTO_INCREMENT_FLAG":   512,
	"TIMESTAMP_FLAG":        1024,
	"SET_FLAG":              2048,
	"NO_DEFAULT_VALUE_FLAG": 4096,
	"ON_UPDATE_NOW_FLAG":    8192,
	"NUM_FLAG":              32768,
	"PART_KEY_FLAG":         16384,
	"GROUP_FLAG":            32768,
	"UNIQUE_FLAG":           65536,
	"BINCMP_FLAG":           131072,
}

func (x MySqlFlag) String() string {
	return EnumName(MySqlFlag_name, int32(x))
}

// Flag allows us to qualify types by their common properties.
type Flag int32

const (
	Flag_NONE       Flag = 0
	Flag_ISINTEGRAL Flag = 256
	Flag_ISUNSIGNED Flag = 512
	Flag_ISFLOAT    Flag = 1024
	Flag_ISQUOTED   Flag = 2048
	Flag_ISTEXT     Flag = 4096
	Flag_ISBINARY   Flag = 8192
)

var Flag_name = map[int32]string{
	0:    "NONE",
	256:  "ISINTEGRAL",
	512:  "ISUNSIGNED",
	1024: "ISFLOAT",
	2048: "ISQUOTED",
	4096: "ISTEXT",
	8192: "ISBINARY",
}
var Flag_value = map[string]int32{
	"NONE":       0,
	"ISINTEGRAL": 256,
	"ISUNSIGNED": 512,
	"ISFLOAT":    1024,
	"ISQUOTED":   2048,
	"ISTEXT":     4096,
	"ISBINARY":   8192,
}

func (x Flag) String() string {
	return EnumName(Flag_name, int32(x))
}

// Type defines the various supported data types in bind vars
// and query results.
type Type int32

const (
	// NULL_TYPE specifies a NULL type.
	Type_NULL_TYPE Type = 0
	// INT8 specifies a TINYINT type.
	// Properties: 1, IsNumber.
	Type_INT8 Type = 257
	// UINT8 specifies a TINYINT UNSIGNED type.
	// Properties: 2, IsNumber, IsUnsigned.
	Type_UINT8 Type = 770
	// INT16 specifies a SMALLINT type.
	// Properties: 3, IsNumber.
	Type_INT16 Type = 259
	// UINT16 specifies a SMALLINT UNSIGNED type.
	// Properties: 4, IsNumber, IsUnsigned.
	Type_UINT16 Type = 772
	// INT24 specifies a MEDIUMINT type.
	// Properties: 5, IsNumber.
	Type_INT24 Type = 261
	// UINT24 specifies a MEDIUMINT UNSIGNED type.
	// Properties: 6, IsNumber, IsUnsigned.
	Type_UINT24 Type = 774
	// INT32 specifies a INTEGER type.
	// Properties: 7, IsNumber.
	Type_INT32 Type = 263
	// UINT32 specifies a INTEGER UNSIGNED type.
	// Properties: 8, IsNumber, IsUnsigned.
	Type_UINT32 Type = 776
	// INT64 specifies a BIGINT type.
	// Properties: 9, IsNumber.
	Type_INT64 Type = 265
	// UINT64 specifies a BIGINT UNSIGNED type.
	// Properties: 10, IsNumber, IsUnsigned.
	Type_UINT64 Type = 778
	// FLOAT32 specifies a FLOAT type.
	// Properties: 11, IsFloat.
	Type_FLOAT32 Type = 1035
	// FLOAT64 specifies a DOUBLE or REAL type.
	// Properties: 12, IsFloat.
	Type_FLOAT64 Type = 1036
	// TIMESTAMP specifies a TIMESTAMP type.
	// Properties: 13, IsQuoted.
	Type_TIMESTAMP Type = 2061
	// DATE specifies a DATE type.
	// Properties: 14, IsQuoted.
	Type_DATE Type = 2062
	// TIME specifies a TIME type.
	// Properties: 15, IsQuoted.
	Type_TIME Type = 2063
	// DATETIME specifies a DATETIME type.
	// Properties: 16, IsQuoted.
	Type_DATETIME Type = 2064
	// YEAR specifies a YEAR type.
	// Properties: 17, IsNumber, IsUnsigned.
	Type_YEAR Type = 785
	// DECIMAL specifies a DECIMAL or NUMERIC type.
	// Properties: 18, None.
	Type_DECIMAL Type = 18
	// TEXT specifies a TEXT type.
	// Properties: 19, IsQuoted, IsText.
	Type_TEXT Type = 6163
	// BLOB specifies a BLOB type.
	// Properties: 20, IsQuoted, IsBinary.
	Type_BLOB Type = 10260
	// VARCHAR specifies a VARCHAR type.
	// Properties: 21, IsQuoted, IsText.
	Type_VARCHAR Type = 6165
	// VARBINARY specifies a VARBINARY type.
	// Properties: 22, IsQuoted, IsBinary.
	Type_VARBINARY Type = 10262
	// CHAR specifies a CHAR type.
	// Properties: 23, IsQuoted, IsText.
	Type_CHAR Type = 6167
	// BINARY specifies a BINARY type.
	// Properties: 24, IsQuoted, IsBinary.
	Type_BINARY Type = 10264
	// BIT specifies a BIT type.
	// Properties: 25, IsQuoted.
	Type_BIT Type = 2073
	// ENUM specifies an ENUM type.
	// Properties: 26, IsQuoted.
	Type_ENUM Type = 2074
	// SET specifies a SET type.
	// Properties: 27, IsQuoted.
	Type_SET Type = 2075
	// TUPLE specifies a a tuple. This cannot
	// be returned in a QueryResult, but it can
	// be sent as a bind var.
	// Properties: 28, None.
	Type_TUPLE Type = 28
	// GEOMETRY specifies a GEOMETRY type.
	// Properties: 29, IsQuoted.
	Type_GEOMETRY Type = 2077
	// JSON specifies a JSON type.
	// Properties: 30, IsQuoted.
	Type_JSON Type = 2078
	// EXPRESSION specifies a SQL expression.
	// This type is for internal use only.
	// Properties: 31, None.
	Type_EXPRESSION Type = 31
)

var Type_name = map[int32]string{
	0:     "NULL_TYPE",
	257:   "INT8",
	770:   "UINT8",
	259:   "INT16",
	772:   "UINT16",
	261:   "INT24",
	774:   "UINT24",
	263:   "INT32",
	776:   "UINT32",
	265:   "INT64",
	778:   "UINT64",
	1035:  "FLOAT32",
	1036:  "FLOAT64",
	2061:  "TIMESTAMP",
	2062:  "DATE",
	2063:  "TIME",
	2064:  "DATETIME",
	785:   "YEAR",
	18:    "DECIMAL",
	6163:  "TEXT",
	10260: "BLOB",
	6165:  "VARCHAR",
	10262: "VARBINARY",
	6167:  "CHAR",
	10264: "BINARY",
	2073:  "BIT",
	2074:  "ENUM",
	2075:  "SET",
	28:    "TUPLE",
	2077:  "GEOMETRY",
	2078:  "JSON",
	31:    "EXPRESSION",
}
var Type_value = map[string]int32{
	"NULL_TYPE":  0,
	"INT8":       257,
	"UINT8":      770,
	"INT16":      259,
	"UINT16":     772,
	"INT24":      261,
	"UINT24":     774,
	"INT32":      263,
	"UINT32":     776,
	"INT64":      265,
	"UINT64":     778,
	"FLOAT32":    1035,
	"FLOAT64":    1036,
	"TIMESTAMP":  2061,
	"DATE":       2062,
	"TIME":       2063,
	"DATETIME":   2064,
	"YEAR":       785,
	"DECIMAL":    18,
	"TEXT":       6163,
	"BLOB":       10260,
	"VARCHAR":    6165,
	"VARBINARY":  10262,
	"CHAR":       6167,
	"BINARY":     10264,
	"BIT":        2073,
	"ENUM":       2074,
	"SET":        2075,
	"TUPLE":      28,
	"GEOMETRY":   2077,
	"JSON":       2078,
	"EXPRESSION": 31,
}

func (x Type) String() string {
	return EnumName(Type_name, int32(x))
}

// TransactionState represents the state of a distributed transaction.
type TransactionState int32

const (
	TransactionState_UNKNOWN  TransactionState = 0
	TransactionState_PREPARE  TransactionState = 1
	TransactionState_COMMIT   TransactionState = 2
	TransactionState_ROLLBACK TransactionState = 3
)

var TransactionState_name = map[int32]string{
	0: "UNKNOWN",
	1: "PREPARE",
	2: "COMMIT",
	3: "ROLLBACK",
}
var TransactionState_value = map[string]int32{
	"UNKNOWN":  0,
	"PREPARE":  1,
	"COMMIT":   2,
	"ROLLBACK": 3,
}

func (x TransactionState) String() string {
	return EnumName(TransactionState_name, int32(x))
}

type ExecuteOptions_IncludedFields int32

const (
	ExecuteOptions_TYPE_AND_NAME ExecuteOptions_IncludedFields = 0
	ExecuteOptions_TYPE_ONLY     ExecuteOptions_IncludedFields = 1
	ExecuteOptions_ALL           ExecuteOptions_IncludedFields = 2
)

var ExecuteOptions_IncludedFields_name = map[int32]string{
	0: "TYPE_AND_NAME",
	1: "TYPE_ONLY",
	2: "ALL",
}
var ExecuteOptions_IncludedFields_value = map[string]int32{
	"TYPE_AND_NAME": 0,
	"TYPE_ONLY":     1,
	"ALL":           2,
}

func (x ExecuteOptions_IncludedFields) String() string {
	return EnumName(ExecuteOptions_IncludedFields_name, int32(x))
}

type ExecuteOptions_Workload int32

const (
	ExecuteOptions_UNSPECIFIED ExecuteOptions_Workload = 0
	ExecuteOptions_OLTP        ExecuteOptions_Workload = 1
	ExecuteOptions_OLAP        ExecuteOptions_Workload = 2
	ExecuteOptions_DBA         ExecuteOptions_Workload = 3
)

var ExecuteOptions_Workload_name = map[int32]string{
	0: "UNSPECIFIED",
	1: "OLTP",
	2: "OLAP",
	3: "DBA",
}
var ExecuteOptions_Workload_value = map[string]int32{
	"UNSPECIFIED": 0,
	"OLTP":        1,
	"OLAP":        2,
	"DBA":         3,
}

func (x ExecuteOptions_Workload) String() string {
	return EnumName(ExecuteOptions_Workload_name, int32(x))
}

type ExecuteOptions_TransactionIsolation int32

const (
	ExecuteOptions_DEFAULT          ExecuteOptions_TransactionIsolation = 0
	ExecuteOptions_REPEATABLE_READ  ExecuteOptions_TransactionIsolation = 1
	ExecuteOptions_READ_COMMITTED   ExecuteOptions_TransactionIsolation = 2
	ExecuteOptions_READ_UNCOMMITTED ExecuteOptions_TransactionIsolation = 3
	ExecuteOptions_SERIALIZABLE     ExecuteOptions_TransactionIsolation = 4
)

var ExecuteOptions_TransactionIsolation_name = map[int32]string{
	0: "DEFAULT",
	1: "REPEATABLE_READ",
	2: "READ_COMMITTED",
	3: "READ_UNCOMMITTED",
	4: "SERIALIZABLE",
}
var ExecuteOptions_TransactionIsolation_value = map[string]int32{
	"DEFAULT":          0,
	"REPEATABLE_READ":  1,
	"READ_COMMITTED":   2,
	"READ_UNCOMMITTED": 3,
	"SERIALIZABLE":     4,
}

func (x ExecuteOptions_TransactionIsolation) String() string {
	return EnumName(ExecuteOptions_TransactionIsolation_name, int32(x))
}

// The category of one statement.
type StreamEvent_Statement_Category int32

const (
	StreamEvent_Statement_Error StreamEvent_Statement_Category = 0
	StreamEvent_Statement_DML   StreamEvent_Statement_Category = 1
	StreamEvent_Statement_DDL   StreamEvent_Statement_Category = 2
)

var StreamEvent_Statement_Category_name = map[int32]string{
	0: "Error",
	1: "DML",
	2: "DDL",
}
var StreamEvent_Statement_Category_value = map[string]int32{
	"Error": 0,
	"DML":   1,
	"DDL":   2,
}

func (x StreamEvent_Statement_Category) String() string {
	return EnumName(StreamEvent_Statement_Category_name, int32(x))
}

type SplitQueryRequest_Algorithm int32

const (
	SplitQueryRequest_EQUAL_SPLITS SplitQueryRequest_Algorithm = 0
	SplitQueryRequest_FULL_SCAN    SplitQueryRequest_Algorithm = 1
)

var SplitQueryRequest_Algorithm_name = map[int32]string{
	0: "EQUAL_SPLITS",
	1: "FULL_SCAN",
}
var SplitQueryRequest_Algorithm_value = map[string]int32{
	"EQUAL_SPLITS": 0,
	"FULL_SCAN":    1,
}

func (x SplitQueryRequest_Algorithm) String() string {
	return EnumName(SplitQueryRequest_Algorithm_name, int32(x))
}

/*
// Target describes what the client expects the tablet is.
// If the tablet does not match, an error is returned.
type Target struct {
	Keyspace   string              `protobuf:"bytes,1,opt,name=keyspace" json:"keyspace,omitempty"`
	Shard      string              `protobuf:"bytes,2,opt,name=shard" json:"shard,omitempty"`
	TabletType topodata.TabletType `protobuf:"varint,3,opt,name=tablet_type,json=tabletType,enum=topodata.TabletType" json:"tablet_type,omitempty"`
}

func (m *Target) Reset()                    { *m = Target{} }
func (m *Target) String() string            { return "TODO" }



func (m *Target) GetKeyspace() string {
	if m != nil {
		return m.Keyspace
	}
	return ""
}

func (m *Target) GetShard() string {
	if m != nil {
		return m.Shard
	}
	return ""
}

func (m *Target) GetTabletType() topodata.TabletType {
	if m != nil {
		return m.TabletType
	}
	return topodata.TabletType_UNKNOWN
}


// VTGateCallerID is sent by VTGate to VTTablet to describe the
// caller. If possible, this information is secure. For instance,
// if using unique certificates that guarantee that VTGate->VTTablet
// traffic cannot be spoofed, then VTTablet can trust this information,
// and VTTablet will use it for tablet ACLs, for instance.
// Because of this security guarantee, this is different than the CallerID
// structure, which is not secure at all, because it is provided
// by the Vitess client.
type VTGateCallerID struct {
	Username string   `protobuf:"bytes,1,opt,name=username" json:"username,omitempty"`
	Groups   []string `protobuf:"bytes,2,rep,name=groups" json:"groups,omitempty"`
}

func (m *VTGateCallerID) Reset()                    { *m = VTGateCallerID{} }
func (m *VTGateCallerID) String() string            { return "TODO" }



func (m *VTGateCallerID) GetUsername() string {
	if m != nil {
		return m.Username
	}
	return ""
}

func (m *VTGateCallerID) GetGroups() []string {
	if m != nil {
		return m.Groups
	}
	return nil
}

// EventToken is a structure that describes a point in time in a
// replication stream on one shard. The most recent known replication
// position can be retrieved from vttablet when executing a query. It
// is also sent with the replication streams from the binlog service.
type EventToken struct {
	// timestamp is the MySQL timestamp of the statements. Seconds since Epoch.
	Timestamp int64 `protobuf:"varint,1,opt,name=timestamp" json:"timestamp,omitempty"`
	// The shard name that applied the statements. Note this is not set when
	// streaming from a vttablet. It is only used on the client -> vtgate link.
	Shard string `protobuf:"bytes,2,opt,name=shard" json:"shard,omitempty"`
	// The position on the replication stream after this statement was applied.
	// It is not the transaction ID / GTID, but the position / GTIDSet.
	Position string `protobuf:"bytes,3,opt,name=position" json:"position,omitempty"`
}

func (m *EventToken) Reset()                    { *m = EventToken{} }
func (m *EventToken) String() string            { return "TODO" }



func (m *EventToken) GetTimestamp() int64 {
	if m != nil {
		return m.Timestamp
	}
	return 0
}

func (m *EventToken) GetShard() string {
	if m != nil {
		return m.Shard
	}
	return ""
}

func (m *EventToken) GetPosition() string {
	if m != nil {
		return m.Position
	}
	return ""
}
*/

// Value represents a typed value.
type Value struct {
	Type  Type   `protobuf:"varint,1,opt,name=type,enum=query.Type" json:"type,omitempty"`
	Value []byte `protobuf:"bytes,2,opt,name=value,proto3" json:"value,omitempty"`
}

func (m *Value) Reset()         { *m = Value{} }
func (m *Value) String() string { return "TODO" }

func (m *Value) GetType() Type {
	if m != nil {
		return m.Type
	}
	return Type_NULL_TYPE
}

func (m *Value) GetValue() []byte {
	if m != nil {
		return m.Value
	}
	return nil
}

// BindVariable represents a single bind variable in a Query.
type BindVariable struct {
	Type  Type   `protobuf:"varint,1,opt,name=type,enum=query.Type" json:"type,omitempty"`
	Value []byte `protobuf:"bytes,2,opt,name=value,proto3" json:"value,omitempty"`
	// values are set if type is TUPLE.
	Values []*Value `protobuf:"bytes,3,rep,name=values" json:"values,omitempty"`
}

func (m *BindVariable) Reset()         { *m = BindVariable{} }
func (m *BindVariable) String() string { return "TODO" }

func (m *BindVariable) GetType() Type {
	if m != nil {
		return m.Type
	}
	return Type_NULL_TYPE
}

func (m *BindVariable) GetValue() []byte {
	if m != nil {
		return m.Value
	}
	return nil
}

func (m *BindVariable) GetValues() []*Value {
	if m != nil {
		return m.Values
	}
	return nil
}

// BoundQuery is a query with its bind variables
type BoundQuery struct {
	// sql is the SQL query to execute
	Sql string `protobuf:"bytes,1,opt,name=sql" json:"sql,omitempty"`
	// bind_variables is a map of all bind variables to expand in the query.
	// nil values are not allowed. Use NULL_TYPE to express a NULL value.
	BindVariables map[string]*BindVariable `protobuf:"bytes,2,rep,name=bind_variables,json=bindVariables" json:"bind_variables,omitempty" protobuf_key:"bytes,1,opt,name=key" protobuf_val:"bytes,2,opt,name=value"`
}

func (m *BoundQuery) Reset()         { *m = BoundQuery{} }
func (m *BoundQuery) String() string { return "TODO" }

func (m *BoundQuery) GetSql() string {
	if m != nil {
		return m.Sql
	}
	return ""
}

func (m *BoundQuery) GetBindVariables() map[string]*BindVariable {
	if m != nil {
		return m.BindVariables
	}
	return nil
}

/*
// ExecuteOptions is passed around for all Execute calls.
type ExecuteOptions struct {
	// If set, we will try to include an EventToken with the responses.
	IncludeEventToken bool `protobuf:"varint,2,opt,name=include_event_token,json=includeEventToken" json:"include_event_token,omitempty"`
	// If set, the fresher field may be set as a result comparison to this token.
	// This is a shortcut so the application doesn't need to care about
	// comparing EventTokens.
	CompareEventToken *EventToken `protobuf:"bytes,3,opt,name=compare_event_token,json=compareEventToken" json:"compare_event_token,omitempty"`
	// Controls what fields are returned in Field message responses from mysql, i.e.
	// field name, table name, etc. This is an optimization for high-QPS queries where
	// the client knows what it's getting
	IncludedFields ExecuteOptions_IncludedFields `protobuf:"varint,4,opt,name=included_fields,json=includedFields,enum=query.ExecuteOptions_IncludedFields" json:"included_fields,omitempty"`
	// client_rows_found specifies if rows_affected should return
	// rows found instead of rows affected. Behavior is defined
	// by MySQL's CLIENT_FOUND_ROWS flag.
	ClientFoundRows bool `protobuf:"varint,5,opt,name=client_found_rows,json=clientFoundRows" json:"client_found_rows,omitempty"`
	// workload specifies the type of workload:
	// OLTP: DMLs allowed, results have row count limit, and
	// query timeouts are shorter.
	// OLAP: DMLS not allowed, no limit on row count, timeouts
	// can be as high as desired.
	// DBA: no limit on rowcount or timeout, all queries allowed
	// but intended for long DMLs and DDLs.
	Workload ExecuteOptions_Workload `protobuf:"varint,6,opt,name=workload,enum=query.ExecuteOptions_Workload" json:"workload,omitempty"`
	// sql_select_limit sets an implicit limit on all select statements. Since
	// vitess also sets a rowcount limit on queries, the smallest value wins.
	SqlSelectLimit       int64                               `protobuf:"varint,8,opt,name=sql_select_limit,json=sqlSelectLimit" json:"sql_select_limit,omitempty"`
	TransactionIsolation ExecuteOptions_TransactionIsolation `protobuf:"varint,9,opt,name=transaction_isolation,json=transactionIsolation,enum=query.ExecuteOptions_TransactionIsolation" json:"transaction_isolation,omitempty"`
}

func (m *ExecuteOptions) Reset()                    { *m = ExecuteOptions{} }
func (m *ExecuteOptions) String() string            { return "TODO" }



func (m *ExecuteOptions) GetIncludeEventToken() bool {
	if m != nil {
		return m.IncludeEventToken
	}
	return false
}

func (m *ExecuteOptions) GetCompareEventToken() *EventToken {
	if m != nil {
		return m.CompareEventToken
	}
	return nil
}

func (m *ExecuteOptions) GetIncludedFields() ExecuteOptions_IncludedFields {
	if m != nil {
		return m.IncludedFields
	}
	return ExecuteOptions_TYPE_AND_NAME
}

func (m *ExecuteOptions) GetClientFoundRows() bool {
	if m != nil {
		return m.ClientFoundRows
	}
	return false
}

func (m *ExecuteOptions) GetWorkload() ExecuteOptions_Workload {
	if m != nil {
		return m.Workload
	}
	return ExecuteOptions_UNSPECIFIED
}

func (m *ExecuteOptions) GetSqlSelectLimit() int64 {
	if m != nil {
		return m.SqlSelectLimit
	}
	return 0
}

func (m *ExecuteOptions) GetTransactionIsolation() ExecuteOptions_TransactionIsolation {
	if m != nil {
		return m.TransactionIsolation
	}
	return ExecuteOptions_DEFAULT
}

// Field describes a single column returned by a query
type Field struct {
	// name of the field as returned by mysql C API
	Name string `protobuf:"bytes,1,opt,name=name" json:"name,omitempty"`
	// vitess-defined type. Conversion function is in sqltypes package.
	Type Type `protobuf:"varint,2,opt,name=type,enum=query.Type" json:"type,omitempty"`
	// Remaining fields from mysql C API.
	// These fields are only populated when ExecuteOptions.included_fields
	// is set to IncludedFields.ALL.
	Table    string `protobuf:"bytes,3,opt,name=table" json:"table,omitempty"`
	OrgTable string `protobuf:"bytes,4,opt,name=org_table,json=orgTable" json:"org_table,omitempty"`
	Database string `protobuf:"bytes,5,opt,name=database" json:"database,omitempty"`
	OrgName  string `protobuf:"bytes,6,opt,name=org_name,json=orgName" json:"org_name,omitempty"`
	// column_length is really a uint32. All 32 bits can be used.
	ColumnLength uint32 `protobuf:"varint,7,opt,name=column_length,json=columnLength" json:"column_length,omitempty"`
	// charset is actually a uint16. Only the lower 16 bits are used.
	Charset uint32 `protobuf:"varint,8,opt,name=charset" json:"charset,omitempty"`
	// decimals is actualy a uint8. Only the lower 8 bits are used.
	Decimals uint32 `protobuf:"varint,9,opt,name=decimals" json:"decimals,omitempty"`
	// flags is actually a uint16. Only the lower 16 bits are used.
	Flags uint32 `protobuf:"varint,10,opt,name=flags" json:"flags,omitempty"`
}

func (m *Field) Reset()                    { *m = Field{} }
func (m *Field) String() string            { return "TODO" }



func (m *Field) GetName() string {
	if m != nil {
		return m.Name
	}
	return ""
}

func (m *Field) GetType() Type {
	if m != nil {
		return m.Type
	}
	return Type_NULL_TYPE
}

func (m *Field) GetTable() string {
	if m != nil {
		return m.Table
	}
	return ""
}

func (m *Field) GetOrgTable() string {
	if m != nil {
		return m.OrgTable
	}
	return ""
}

func (m *Field) GetDatabase() string {
	if m != nil {
		return m.Database
	}
	return ""
}

func (m *Field) GetOrgName() string {
	if m != nil {
		return m.OrgName
	}
	return ""
}

func (m *Field) GetColumnLength() uint32 {
	if m != nil {
		return m.ColumnLength
	}
	return 0
}

func (m *Field) GetCharset() uint32 {
	if m != nil {
		return m.Charset
	}
	return 0
}

func (m *Field) GetDecimals() uint32 {
	if m != nil {
		return m.Decimals
	}
	return 0
}

func (m *Field) GetFlags() uint32 {
	if m != nil {
		return m.Flags
	}
	return 0
}

// Row is a database row.
type Row struct {
	// lengths contains the length of each value in values.
	// A length of -1 means that the field is NULL. While
	// reading values, you have to accummulate the length
	// to know the offset where the next value begins in values.
	Lengths []int64 `protobuf:"zigzag64,1,rep,packed,name=lengths" json:"lengths,omitempty"`
	// values contains a concatenation of all values in the row.
	Values []byte `protobuf:"bytes,2,opt,name=values,proto3" json:"values,omitempty"`
}

func (m *Row) Reset()                    { *m = Row{} }
func (m *Row) String() string            { return "TODO" }



func (m *Row) GetLengths() []int64 {
	if m != nil {
		return m.Lengths
	}
	return nil
}

func (m *Row) GetValues() []byte {
	if m != nil {
		return m.Values
	}
	return nil
}

// ResultExtras contains optional out-of-band information. Usually the
// extras are requested by adding ExecuteOptions flags.
type ResultExtras struct {
	// event_token is populated if the include_event_token flag is set
	// in ExecuteOptions.
	EventToken *EventToken `protobuf:"bytes,1,opt,name=event_token,json=eventToken" json:"event_token,omitempty"`
	// If set, it means the data returned with this result is fresher
	// than the compare_token passed in the ExecuteOptions.
	Fresher bool `protobuf:"varint,2,opt,name=fresher" json:"fresher,omitempty"`
}

func (m *ResultExtras) Reset()                    { *m = ResultExtras{} }
func (m *ResultExtras) String() string            { return "TODO" }



func (m *ResultExtras) GetEventToken() *EventToken {
	if m != nil {
		return m.EventToken
	}
	return nil
}

func (m *ResultExtras) GetFresher() bool {
	if m != nil {
		return m.Fresher
	}
	return false
}

// QueryResult is returned by Execute and ExecuteStream.
//
// As returned by Execute, len(fields) is always equal to len(row)
// (for each row in rows).
//
// As returned by StreamExecute, the first QueryResult has the fields
// set, and subsequent QueryResult have rows set. And as Execute,
// len(QueryResult[0].fields) is always equal to len(row) (for each
// row in rows for each QueryResult in QueryResult[1:]).
type QueryResult struct {
	Fields       []*Field      `protobuf:"bytes,1,rep,name=fields" json:"fields,omitempty"`
	RowsAffected uint64        `protobuf:"varint,2,opt,name=rows_affected,json=rowsAffected" json:"rows_affected,omitempty"`
	InsertId     uint64        `protobuf:"varint,3,opt,name=insert_id,json=insertId" json:"insert_id,omitempty"`
	Rows         []*Row        `protobuf:"bytes,4,rep,name=rows" json:"rows,omitempty"`
	Extras       *ResultExtras `protobuf:"bytes,5,opt,name=extras" json:"extras,omitempty"`
}

func (m *QueryResult) Reset()                    { *m = QueryResult{} }
func (m *QueryResult) String() string            { return "TODO" }



func (m *QueryResult) GetFields() []*Field {
	if m != nil {
		return m.Fields
	}
	return nil
}

func (m *QueryResult) GetRowsAffected() uint64 {
	if m != nil {
		return m.RowsAffected
	}
	return 0
}

func (m *QueryResult) GetInsertId() uint64 {
	if m != nil {
		return m.InsertId
	}
	return 0
}

func (m *QueryResult) GetRows() []*Row {
	if m != nil {
		return m.Rows
	}
	return nil
}

func (m *QueryResult) GetExtras() *ResultExtras {
	if m != nil {
		return m.Extras
	}
	return nil
}

// StreamEvent describes a set of transformations that happened as a
// single transactional unit on a server. It is streamed back by the
// Update Stream calls.
type StreamEvent struct {
	// The statements in this transaction.
	Statements []*StreamEvent_Statement `protobuf:"bytes,1,rep,name=statements" json:"statements,omitempty"`
	// The Event Token for this event.
	EventToken *EventToken `protobuf:"bytes,2,opt,name=event_token,json=eventToken" json:"event_token,omitempty"`
}

func (m *StreamEvent) Reset()                    { *m = StreamEvent{} }
func (m *StreamEvent) String() string            { return "TODO" }



func (m *StreamEvent) GetStatements() []*StreamEvent_Statement {
	if m != nil {
		return m.Statements
	}
	return nil
}

func (m *StreamEvent) GetEventToken() *EventToken {
	if m != nil {
		return m.EventToken
	}
	return nil
}

// One individual Statement in a transaction.
type StreamEvent_Statement struct {
	Category StreamEvent_Statement_Category `protobuf:"varint,1,opt,name=category,enum=query.StreamEvent_Statement_Category" json:"category,omitempty"`
	// table_name, primary_key_fields and primary_key_values are set for DML.
	TableName        string   `protobuf:"bytes,2,opt,name=table_name,json=tableName" json:"table_name,omitempty"`
	PrimaryKeyFields []*Field `protobuf:"bytes,3,rep,name=primary_key_fields,json=primaryKeyFields" json:"primary_key_fields,omitempty"`
	PrimaryKeyValues []*Row   `protobuf:"bytes,4,rep,name=primary_key_values,json=primaryKeyValues" json:"primary_key_values,omitempty"`
	// sql is set for all queries.
	// FIXME(alainjobart) we may not need it for DMLs.
	Sql []byte `protobuf:"bytes,5,opt,name=sql,proto3" json:"sql,omitempty"`
}

func (m *StreamEvent_Statement) Reset()                    { *m = StreamEvent_Statement{} }
func (m *StreamEvent_Statement) String() string            { return "TODO" }



func (m *StreamEvent_Statement) GetCategory() StreamEvent_Statement_Category {
	if m != nil {
		return m.Category
	}
	return StreamEvent_Statement_Error
}

func (m *StreamEvent_Statement) GetTableName() string {
	if m != nil {
		return m.TableName
	}
	return ""
}

func (m *StreamEvent_Statement) GetPrimaryKeyFields() []*Field {
	if m != nil {
		return m.PrimaryKeyFields
	}
	return nil
}

func (m *StreamEvent_Statement) GetPrimaryKeyValues() []*Row {
	if m != nil {
		return m.PrimaryKeyValues
	}
	return nil
}

func (m *StreamEvent_Statement) GetSql() []byte {
	if m != nil {
		return m.Sql
	}
	return nil
}


// ExecuteRequest is the payload to Execute
type ExecuteRequest struct {
	EffectiveCallerId *vtrpc.CallerID `protobuf:"bytes,1,opt,name=effective_caller_id,json=effectiveCallerId" json:"effective_caller_id,omitempty"`
	ImmediateCallerId *VTGateCallerID `protobuf:"bytes,2,opt,name=immediate_caller_id,json=immediateCallerId" json:"immediate_caller_id,omitempty"`
	Target            *Target         `protobuf:"bytes,3,opt,name=target" json:"target,omitempty"`
	Query             *BoundQuery     `protobuf:"bytes,4,opt,name=query" json:"query,omitempty"`
	TransactionId     int64           `protobuf:"varint,5,opt,name=transaction_id,json=transactionId" json:"transaction_id,omitempty"`
	Options           *ExecuteOptions `protobuf:"bytes,6,opt,name=options" json:"options,omitempty"`
}

func (m *ExecuteRequest) Reset()                    { *m = ExecuteRequest{} }
func (m *ExecuteRequest) String() string            { return "TODO" }



func (m *ExecuteRequest) GetEffectiveCallerId() *vtrpc.CallerID {
	if m != nil {
		return m.EffectiveCallerId
	}
	return nil
}

func (m *ExecuteRequest) GetImmediateCallerId() *VTGateCallerID {
	if m != nil {
		return m.ImmediateCallerId
	}
	return nil
}

func (m *ExecuteRequest) GetTarget() *Target {
	if m != nil {
		return m.Target
	}
	return nil
}

func (m *ExecuteRequest) GetQuery() *BoundQuery {
	if m != nil {
		return m.Query
	}
	return nil
}

func (m *ExecuteRequest) GetTransactionId() int64 {
	if m != nil {
		return m.TransactionId
	}
	return 0
}

func (m *ExecuteRequest) GetOptions() *ExecuteOptions {
	if m != nil {
		return m.Options
	}
	return nil
}

// ExecuteResponse is the returned value from Execute
type ExecuteResponse struct {
	Result *QueryResult `protobuf:"bytes,1,opt,name=result" json:"result,omitempty"`
}

func (m *ExecuteResponse) Reset()                    { *m = ExecuteResponse{} }
func (m *ExecuteResponse) String() string            { return "TODO" }



func (m *ExecuteResponse) GetResult() *QueryResult {
	if m != nil {
		return m.Result
	}
	return nil
}

// ResultWithError represents a query response
// in the form of result or error but not both.
// TODO: To be used in ExecuteBatchResponse and BeginExecuteBatchResponse.
type ResultWithError struct {
	// error contains an query level error, only set if result is unset.
	Error *vtrpc.RPCError `protobuf:"bytes,1,opt,name=error" json:"error,omitempty"`
	// result contains the query result, only set if error is unset.
	Result *QueryResult `protobuf:"bytes,2,opt,name=result" json:"result,omitempty"`
}

func (m *ResultWithError) Reset()                    { *m = ResultWithError{} }
func (m *ResultWithError) String() string            { return "TODO" }



func (m *ResultWithError) GetError() *vtrpc.RPCError {
	if m != nil {
		return m.Error
	}
	return nil
}

func (m *ResultWithError) GetResult() *QueryResult {
	if m != nil {
		return m.Result
	}
	return nil
}

// ExecuteBatchRequest is the payload to ExecuteBatch
type ExecuteBatchRequest struct {
	EffectiveCallerId *vtrpc.CallerID `protobuf:"bytes,1,opt,name=effective_caller_id,json=effectiveCallerId" json:"effective_caller_id,omitempty"`
	ImmediateCallerId *VTGateCallerID `protobuf:"bytes,2,opt,name=immediate_caller_id,json=immediateCallerId" json:"immediate_caller_id,omitempty"`
	Target            *Target         `protobuf:"bytes,3,opt,name=target" json:"target,omitempty"`
	Queries           []*BoundQuery   `protobuf:"bytes,4,rep,name=queries" json:"queries,omitempty"`
	AsTransaction     bool            `protobuf:"varint,5,opt,name=as_transaction,json=asTransaction" json:"as_transaction,omitempty"`
	TransactionId     int64           `protobuf:"varint,6,opt,name=transaction_id,json=transactionId" json:"transaction_id,omitempty"`
	Options           *ExecuteOptions `protobuf:"bytes,7,opt,name=options" json:"options,omitempty"`
}

func (m *ExecuteBatchRequest) Reset()                    { *m = ExecuteBatchRequest{} }
func (m *ExecuteBatchRequest) String() string            { return "TODO" }



func (m *ExecuteBatchRequest) GetEffectiveCallerId() *vtrpc.CallerID {
	if m != nil {
		return m.EffectiveCallerId
	}
	return nil
}

func (m *ExecuteBatchRequest) GetImmediateCallerId() *VTGateCallerID {
	if m != nil {
		return m.ImmediateCallerId
	}
	return nil
}

func (m *ExecuteBatchRequest) GetTarget() *Target {
	if m != nil {
		return m.Target
	}
	return nil
}

func (m *ExecuteBatchRequest) GetQueries() []*BoundQuery {
	if m != nil {
		return m.Queries
	}
	return nil
}

func (m *ExecuteBatchRequest) GetAsTransaction() bool {
	if m != nil {
		return m.AsTransaction
	}
	return false
}

func (m *ExecuteBatchRequest) GetTransactionId() int64 {
	if m != nil {
		return m.TransactionId
	}
	return 0
}

func (m *ExecuteBatchRequest) GetOptions() *ExecuteOptions {
	if m != nil {
		return m.Options
	}
	return nil
}

// ExecuteBatchResponse is the returned value from ExecuteBatch
type ExecuteBatchResponse struct {
	Results []*QueryResult `protobuf:"bytes,1,rep,name=results" json:"results,omitempty"`
}

func (m *ExecuteBatchResponse) Reset()                    { *m = ExecuteBatchResponse{} }
func (m *ExecuteBatchResponse) String() string            { return "TODO" }



func (m *ExecuteBatchResponse) GetResults() []*QueryResult {
	if m != nil {
		return m.Results
	}
	return nil
}

// StreamExecuteRequest is the payload to StreamExecute
type StreamExecuteRequest struct {
	EffectiveCallerId *vtrpc.CallerID `protobuf:"bytes,1,opt,name=effective_caller_id,json=effectiveCallerId" json:"effective_caller_id,omitempty"`
	ImmediateCallerId *VTGateCallerID `protobuf:"bytes,2,opt,name=immediate_caller_id,json=immediateCallerId" json:"immediate_caller_id,omitempty"`
	Target            *Target         `protobuf:"bytes,3,opt,name=target" json:"target,omitempty"`
	Query             *BoundQuery     `protobuf:"bytes,4,opt,name=query" json:"query,omitempty"`
	Options           *ExecuteOptions `protobuf:"bytes,5,opt,name=options" json:"options,omitempty"`
}

func (m *StreamExecuteRequest) Reset()                    { *m = StreamExecuteRequest{} }
func (m *StreamExecuteRequest) String() string            { return "TODO" }



func (m *StreamExecuteRequest) GetEffectiveCallerId() *vtrpc.CallerID {
	if m != nil {
		return m.EffectiveCallerId
	}
	return nil
}

func (m *StreamExecuteRequest) GetImmediateCallerId() *VTGateCallerID {
	if m != nil {
		return m.ImmediateCallerId
	}
	return nil
}

func (m *StreamExecuteRequest) GetTarget() *Target {
	if m != nil {
		return m.Target
	}
	return nil
}

func (m *StreamExecuteRequest) GetQuery() *BoundQuery {
	if m != nil {
		return m.Query
	}
	return nil
}

func (m *StreamExecuteRequest) GetOptions() *ExecuteOptions {
	if m != nil {
		return m.Options
	}
	return nil
}

// StreamExecuteResponse is the returned value from StreamExecute
type StreamExecuteResponse struct {
	Result *QueryResult `protobuf:"bytes,1,opt,name=result" json:"result,omitempty"`
}

func (m *StreamExecuteResponse) Reset()                    { *m = StreamExecuteResponse{} }
func (m *StreamExecuteResponse) String() string            { return "TODO" }



func (m *StreamExecuteResponse) GetResult() *QueryResult {
	if m != nil {
		return m.Result
	}
	return nil
}

// BeginRequest is the payload to Begin
type BeginRequest struct {
	EffectiveCallerId *vtrpc.CallerID `protobuf:"bytes,1,opt,name=effective_caller_id,json=effectiveCallerId" json:"effective_caller_id,omitempty"`
	ImmediateCallerId *VTGateCallerID `protobuf:"bytes,2,opt,name=immediate_caller_id,json=immediateCallerId" json:"immediate_caller_id,omitempty"`
	Target            *Target         `protobuf:"bytes,3,opt,name=target" json:"target,omitempty"`
	Options           *ExecuteOptions `protobuf:"bytes,4,opt,name=options" json:"options,omitempty"`
}

func (m *BeginRequest) Reset()                    { *m = BeginRequest{} }
func (m *BeginRequest) String() string            { return "TODO" }



func (m *BeginRequest) GetEffectiveCallerId() *vtrpc.CallerID {
	if m != nil {
		return m.EffectiveCallerId
	}
	return nil
}

func (m *BeginRequest) GetImmediateCallerId() *VTGateCallerID {
	if m != nil {
		return m.ImmediateCallerId
	}
	return nil
}

func (m *BeginRequest) GetTarget() *Target {
	if m != nil {
		return m.Target
	}
	return nil
}

func (m *BeginRequest) GetOptions() *ExecuteOptions {
	if m != nil {
		return m.Options
	}
	return nil
}

// BeginResponse is the returned value from Begin
type BeginResponse struct {
	TransactionId int64 `protobuf:"varint,1,opt,name=transaction_id,json=transactionId" json:"transaction_id,omitempty"`
}

func (m *BeginResponse) Reset()                    { *m = BeginResponse{} }
func (m *BeginResponse) String() string            { return "TODO" }



func (m *BeginResponse) GetTransactionId() int64 {
	if m != nil {
		return m.TransactionId
	}
	return 0
}

// CommitRequest is the payload to Commit
type CommitRequest struct {
	EffectiveCallerId *vtrpc.CallerID `protobuf:"bytes,1,opt,name=effective_caller_id,json=effectiveCallerId" json:"effective_caller_id,omitempty"`
	ImmediateCallerId *VTGateCallerID `protobuf:"bytes,2,opt,name=immediate_caller_id,json=immediateCallerId" json:"immediate_caller_id,omitempty"`
	Target            *Target         `protobuf:"bytes,3,opt,name=target" json:"target,omitempty"`
	TransactionId     int64           `protobuf:"varint,4,opt,name=transaction_id,json=transactionId" json:"transaction_id,omitempty"`
}

func (m *CommitRequest) Reset()                    { *m = CommitRequest{} }
func (m *CommitRequest) String() string            { return "TODO" }



func (m *CommitRequest) GetEffectiveCallerId() *vtrpc.CallerID {
	if m != nil {
		return m.EffectiveCallerId
	}
	return nil
}

func (m *CommitRequest) GetImmediateCallerId() *VTGateCallerID {
	if m != nil {
		return m.ImmediateCallerId
	}
	return nil
}

func (m *CommitRequest) GetTarget() *Target {
	if m != nil {
		return m.Target
	}
	return nil
}

func (m *CommitRequest) GetTransactionId() int64 {
	if m != nil {
		return m.TransactionId
	}
	return 0
}

// CommitResponse is the returned value from Commit
type CommitResponse struct {
}

func (m *CommitResponse) Reset()                    { *m = CommitResponse{} }
func (m *CommitResponse) String() string            { return "TODO" }



// RollbackRequest is the payload to Rollback
type RollbackRequest struct {
	EffectiveCallerId *vtrpc.CallerID `protobuf:"bytes,1,opt,name=effective_caller_id,json=effectiveCallerId" json:"effective_caller_id,omitempty"`
	ImmediateCallerId *VTGateCallerID `protobuf:"bytes,2,opt,name=immediate_caller_id,json=immediateCallerId" json:"immediate_caller_id,omitempty"`
	Target            *Target         `protobuf:"bytes,3,opt,name=target" json:"target,omitempty"`
	TransactionId     int64           `protobuf:"varint,4,opt,name=transaction_id,json=transactionId" json:"transaction_id,omitempty"`
}

func (m *RollbackRequest) Reset()                    { *m = RollbackRequest{} }
func (m *RollbackRequest) String() string            { return "TODO" }



func (m *RollbackRequest) GetEffectiveCallerId() *vtrpc.CallerID {
	if m != nil {
		return m.EffectiveCallerId
	}
	return nil
}

func (m *RollbackRequest) GetImmediateCallerId() *VTGateCallerID {
	if m != nil {
		return m.ImmediateCallerId
	}
	return nil
}

func (m *RollbackRequest) GetTarget() *Target {
	if m != nil {
		return m.Target
	}
	return nil
}

func (m *RollbackRequest) GetTransactionId() int64 {
	if m != nil {
		return m.TransactionId
	}
	return 0
}

// RollbackResponse is the returned value from Rollback
type RollbackResponse struct {
}

func (m *RollbackResponse) Reset()                    { *m = RollbackResponse{} }
func (m *RollbackResponse) String() string            { return "TODO" }



// PrepareRequest is the payload to Prepare
type PrepareRequest struct {
	EffectiveCallerId *vtrpc.CallerID `protobuf:"bytes,1,opt,name=effective_caller_id,json=effectiveCallerId" json:"effective_caller_id,omitempty"`
	ImmediateCallerId *VTGateCallerID `protobuf:"bytes,2,opt,name=immediate_caller_id,json=immediateCallerId" json:"immediate_caller_id,omitempty"`
	Target            *Target         `protobuf:"bytes,3,opt,name=target" json:"target,omitempty"`
	TransactionId     int64           `protobuf:"varint,4,opt,name=transaction_id,json=transactionId" json:"transaction_id,omitempty"`
	Dtid              string          `protobuf:"bytes,5,opt,name=dtid" json:"dtid,omitempty"`
}

func (m *PrepareRequest) Reset()                    { *m = PrepareRequest{} }
func (m *PrepareRequest) String() string            { return "TODO" }



func (m *PrepareRequest) GetEffectiveCallerId() *vtrpc.CallerID {
	if m != nil {
		return m.EffectiveCallerId
	}
	return nil
}

func (m *PrepareRequest) GetImmediateCallerId() *VTGateCallerID {
	if m != nil {
		return m.ImmediateCallerId
	}
	return nil
}

func (m *PrepareRequest) GetTarget() *Target {
	if m != nil {
		return m.Target
	}
	return nil
}

func (m *PrepareRequest) GetTransactionId() int64 {
	if m != nil {
		return m.TransactionId
	}
	return 0
}

func (m *PrepareRequest) GetDtid() string {
	if m != nil {
		return m.Dtid
	}
	return ""
}

// PrepareResponse is the returned value from Prepare
type PrepareResponse struct {
}

func (m *PrepareResponse) Reset()                    { *m = PrepareResponse{} }
func (m *PrepareResponse) String() string            { return "TODO" }



// CommitPreparedRequest is the payload to CommitPrepared
type CommitPreparedRequest struct {
	EffectiveCallerId *vtrpc.CallerID `protobuf:"bytes,1,opt,name=effective_caller_id,json=effectiveCallerId" json:"effective_caller_id,omitempty"`
	ImmediateCallerId *VTGateCallerID `protobuf:"bytes,2,opt,name=immediate_caller_id,json=immediateCallerId" json:"immediate_caller_id,omitempty"`
	Target            *Target         `protobuf:"bytes,3,opt,name=target" json:"target,omitempty"`
	Dtid              string          `protobuf:"bytes,4,opt,name=dtid" json:"dtid,omitempty"`
}

func (m *CommitPreparedRequest) Reset()                    { *m = CommitPreparedRequest{} }
func (m *CommitPreparedRequest) String() string            { return "TODO" }



func (m *CommitPreparedRequest) GetEffectiveCallerId() *vtrpc.CallerID {
	if m != nil {
		return m.EffectiveCallerId
	}
	return nil
}

func (m *CommitPreparedRequest) GetImmediateCallerId() *VTGateCallerID {
	if m != nil {
		return m.ImmediateCallerId
	}
	return nil
}

func (m *CommitPreparedRequest) GetTarget() *Target {
	if m != nil {
		return m.Target
	}
	return nil
}

func (m *CommitPreparedRequest) GetDtid() string {
	if m != nil {
		return m.Dtid
	}
	return ""
}

// CommitPreparedResponse is the returned value from CommitPrepared
type CommitPreparedResponse struct {
}

func (m *CommitPreparedResponse) Reset()                    { *m = CommitPreparedResponse{} }
func (m *CommitPreparedResponse) String() string            { return "TODO" }



// RollbackPreparedRequest is the payload to RollbackPrepared
type RollbackPreparedRequest struct {
	EffectiveCallerId *vtrpc.CallerID `protobuf:"bytes,1,opt,name=effective_caller_id,json=effectiveCallerId" json:"effective_caller_id,omitempty"`
	ImmediateCallerId *VTGateCallerID `protobuf:"bytes,2,opt,name=immediate_caller_id,json=immediateCallerId" json:"immediate_caller_id,omitempty"`
	Target            *Target         `protobuf:"bytes,3,opt,name=target" json:"target,omitempty"`
	TransactionId     int64           `protobuf:"varint,4,opt,name=transaction_id,json=transactionId" json:"transaction_id,omitempty"`
	Dtid              string          `protobuf:"bytes,5,opt,name=dtid" json:"dtid,omitempty"`
}

func (m *RollbackPreparedRequest) Reset()                    { *m = RollbackPreparedRequest{} }
func (m *RollbackPreparedRequest) String() string            { return "TODO" }



func (m *RollbackPreparedRequest) GetEffectiveCallerId() *vtrpc.CallerID {
	if m != nil {
		return m.EffectiveCallerId
	}
	return nil
}

func (m *RollbackPreparedRequest) GetImmediateCallerId() *VTGateCallerID {
	if m != nil {
		return m.ImmediateCallerId
	}
	return nil
}

func (m *RollbackPreparedRequest) GetTarget() *Target {
	if m != nil {
		return m.Target
	}
	return nil
}

func (m *RollbackPreparedRequest) GetTransactionId() int64 {
	if m != nil {
		return m.TransactionId
	}
	return 0
}

func (m *RollbackPreparedRequest) GetDtid() string {
	if m != nil {
		return m.Dtid
	}
	return ""
}

// RollbackPreparedResponse is the returned value from RollbackPrepared
type RollbackPreparedResponse struct {
}

func (m *RollbackPreparedResponse) Reset()                    { *m = RollbackPreparedResponse{} }
func (m *RollbackPreparedResponse) String() string            { return "TODO" }



// CreateTransactionRequest is the payload to CreateTransaction
type CreateTransactionRequest struct {
	EffectiveCallerId *vtrpc.CallerID `protobuf:"bytes,1,opt,name=effective_caller_id,json=effectiveCallerId" json:"effective_caller_id,omitempty"`
	ImmediateCallerId *VTGateCallerID `protobuf:"bytes,2,opt,name=immediate_caller_id,json=immediateCallerId" json:"immediate_caller_id,omitempty"`
	Target            *Target         `protobuf:"bytes,3,opt,name=target" json:"target,omitempty"`
	Dtid              string          `protobuf:"bytes,4,opt,name=dtid" json:"dtid,omitempty"`
	Participants      []*Target       `protobuf:"bytes,5,rep,name=participants" json:"participants,omitempty"`
}

func (m *CreateTransactionRequest) Reset()                    { *m = CreateTransactionRequest{} }
func (m *CreateTransactionRequest) String() string            { return "TODO" }



func (m *CreateTransactionRequest) GetEffectiveCallerId() *vtrpc.CallerID {
	if m != nil {
		return m.EffectiveCallerId
	}
	return nil
}

func (m *CreateTransactionRequest) GetImmediateCallerId() *VTGateCallerID {
	if m != nil {
		return m.ImmediateCallerId
	}
	return nil
}

func (m *CreateTransactionRequest) GetTarget() *Target {
	if m != nil {
		return m.Target
	}
	return nil
}

func (m *CreateTransactionRequest) GetDtid() string {
	if m != nil {
		return m.Dtid
	}
	return ""
}

func (m *CreateTransactionRequest) GetParticipants() []*Target {
	if m != nil {
		return m.Participants
	}
	return nil
}

// CreateTransactionResponse is the returned value from CreateTransaction
type CreateTransactionResponse struct {
}

func (m *CreateTransactionResponse) Reset()                    { *m = CreateTransactionResponse{} }
func (m *CreateTransactionResponse) String() string            { return "TODO" }



// StartCommitRequest is the payload to StartCommit
type StartCommitRequest struct {
	EffectiveCallerId *vtrpc.CallerID `protobuf:"bytes,1,opt,name=effective_caller_id,json=effectiveCallerId" json:"effective_caller_id,omitempty"`
	ImmediateCallerId *VTGateCallerID `protobuf:"bytes,2,opt,name=immediate_caller_id,json=immediateCallerId" json:"immediate_caller_id,omitempty"`
	Target            *Target         `protobuf:"bytes,3,opt,name=target" json:"target,omitempty"`
	TransactionId     int64           `protobuf:"varint,4,opt,name=transaction_id,json=transactionId" json:"transaction_id,omitempty"`
	Dtid              string          `protobuf:"bytes,5,opt,name=dtid" json:"dtid,omitempty"`
}

func (m *StartCommitRequest) Reset()                    { *m = StartCommitRequest{} }
func (m *StartCommitRequest) String() string            { return "TODO" }



func (m *StartCommitRequest) GetEffectiveCallerId() *vtrpc.CallerID {
	if m != nil {
		return m.EffectiveCallerId
	}
	return nil
}

func (m *StartCommitRequest) GetImmediateCallerId() *VTGateCallerID {
	if m != nil {
		return m.ImmediateCallerId
	}
	return nil
}

func (m *StartCommitRequest) GetTarget() *Target {
	if m != nil {
		return m.Target
	}
	return nil
}

func (m *StartCommitRequest) GetTransactionId() int64 {
	if m != nil {
		return m.TransactionId
	}
	return 0
}

func (m *StartCommitRequest) GetDtid() string {
	if m != nil {
		return m.Dtid
	}
	return ""
}

// StartCommitResponse is the returned value from StartCommit
type StartCommitResponse struct {
}

func (m *StartCommitResponse) Reset()                    { *m = StartCommitResponse{} }
func (m *StartCommitResponse) String() string            { return "TODO" }



// SetRollbackRequest is the payload to SetRollback
type SetRollbackRequest struct {
	EffectiveCallerId *vtrpc.CallerID `protobuf:"bytes,1,opt,name=effective_caller_id,json=effectiveCallerId" json:"effective_caller_id,omitempty"`
	ImmediateCallerId *VTGateCallerID `protobuf:"bytes,2,opt,name=immediate_caller_id,json=immediateCallerId" json:"immediate_caller_id,omitempty"`
	Target            *Target         `protobuf:"bytes,3,opt,name=target" json:"target,omitempty"`
	TransactionId     int64           `protobuf:"varint,4,opt,name=transaction_id,json=transactionId" json:"transaction_id,omitempty"`
	Dtid              string          `protobuf:"bytes,5,opt,name=dtid" json:"dtid,omitempty"`
}

func (m *SetRollbackRequest) Reset()                    { *m = SetRollbackRequest{} }
func (m *SetRollbackRequest) String() string            { return "TODO" }



func (m *SetRollbackRequest) GetEffectiveCallerId() *vtrpc.CallerID {
	if m != nil {
		return m.EffectiveCallerId
	}
	return nil
}

func (m *SetRollbackRequest) GetImmediateCallerId() *VTGateCallerID {
	if m != nil {
		return m.ImmediateCallerId
	}
	return nil
}

func (m *SetRollbackRequest) GetTarget() *Target {
	if m != nil {
		return m.Target
	}
	return nil
}

func (m *SetRollbackRequest) GetTransactionId() int64 {
	if m != nil {
		return m.TransactionId
	}
	return 0
}

func (m *SetRollbackRequest) GetDtid() string {
	if m != nil {
		return m.Dtid
	}
	return ""
}

// SetRollbackResponse is the returned value from SetRollback
type SetRollbackResponse struct {
}

func (m *SetRollbackResponse) Reset()                    { *m = SetRollbackResponse{} }
func (m *SetRollbackResponse) String() string            { return "TODO" }



// ConcludeTransactionRequest is the payload to ConcludeTransaction
type ConcludeTransactionRequest struct {
	EffectiveCallerId *vtrpc.CallerID `protobuf:"bytes,1,opt,name=effective_caller_id,json=effectiveCallerId" json:"effective_caller_id,omitempty"`
	ImmediateCallerId *VTGateCallerID `protobuf:"bytes,2,opt,name=immediate_caller_id,json=immediateCallerId" json:"immediate_caller_id,omitempty"`
	Target            *Target         `protobuf:"bytes,3,opt,name=target" json:"target,omitempty"`
	Dtid              string          `protobuf:"bytes,4,opt,name=dtid" json:"dtid,omitempty"`
}

func (m *ConcludeTransactionRequest) Reset()                    { *m = ConcludeTransactionRequest{} }
func (m *ConcludeTransactionRequest) String() string            { return "TODO" }



func (m *ConcludeTransactionRequest) GetEffectiveCallerId() *vtrpc.CallerID {
	if m != nil {
		return m.EffectiveCallerId
	}
	return nil
}

func (m *ConcludeTransactionRequest) GetImmediateCallerId() *VTGateCallerID {
	if m != nil {
		return m.ImmediateCallerId
	}
	return nil
}

func (m *ConcludeTransactionRequest) GetTarget() *Target {
	if m != nil {
		return m.Target
	}
	return nil
}

func (m *ConcludeTransactionRequest) GetDtid() string {
	if m != nil {
		return m.Dtid
	}
	return ""
}

// ConcludeTransactionResponse is the returned value from ConcludeTransaction
type ConcludeTransactionResponse struct {
}

func (m *ConcludeTransactionResponse) Reset()                    { *m = ConcludeTransactionResponse{} }
func (m *ConcludeTransactionResponse) String() string            { return "TODO" }



// ReadTransactionRequest is the payload to ReadTransaction
type ReadTransactionRequest struct {
	EffectiveCallerId *vtrpc.CallerID `protobuf:"bytes,1,opt,name=effective_caller_id,json=effectiveCallerId" json:"effective_caller_id,omitempty"`
	ImmediateCallerId *VTGateCallerID `protobuf:"bytes,2,opt,name=immediate_caller_id,json=immediateCallerId" json:"immediate_caller_id,omitempty"`
	Target            *Target         `protobuf:"bytes,3,opt,name=target" json:"target,omitempty"`
	Dtid              string          `protobuf:"bytes,4,opt,name=dtid" json:"dtid,omitempty"`
}

func (m *ReadTransactionRequest) Reset()                    { *m = ReadTransactionRequest{} }
func (m *ReadTransactionRequest) String() string            { return "TODO" }



func (m *ReadTransactionRequest) GetEffectiveCallerId() *vtrpc.CallerID {
	if m != nil {
		return m.EffectiveCallerId
	}
	return nil
}

func (m *ReadTransactionRequest) GetImmediateCallerId() *VTGateCallerID {
	if m != nil {
		return m.ImmediateCallerId
	}
	return nil
}

func (m *ReadTransactionRequest) GetTarget() *Target {
	if m != nil {
		return m.Target
	}
	return nil
}

func (m *ReadTransactionRequest) GetDtid() string {
	if m != nil {
		return m.Dtid
	}
	return ""
}

// ReadTransactionResponse is the returned value from ReadTransaction
type ReadTransactionResponse struct {
	Metadata *TransactionMetadata `protobuf:"bytes,1,opt,name=metadata" json:"metadata,omitempty"`
}

func (m *ReadTransactionResponse) Reset()                    { *m = ReadTransactionResponse{} }
func (m *ReadTransactionResponse) String() string            { return "TODO" }



func (m *ReadTransactionResponse) GetMetadata() *TransactionMetadata {
	if m != nil {
		return m.Metadata
	}
	return nil
}

// BeginExecuteRequest is the payload to BeginExecute
type BeginExecuteRequest struct {
	EffectiveCallerId *vtrpc.CallerID `protobuf:"bytes,1,opt,name=effective_caller_id,json=effectiveCallerId" json:"effective_caller_id,omitempty"`
	ImmediateCallerId *VTGateCallerID `protobuf:"bytes,2,opt,name=immediate_caller_id,json=immediateCallerId" json:"immediate_caller_id,omitempty"`
	Target            *Target         `protobuf:"bytes,3,opt,name=target" json:"target,omitempty"`
	Query             *BoundQuery     `protobuf:"bytes,4,opt,name=query" json:"query,omitempty"`
	Options           *ExecuteOptions `protobuf:"bytes,5,opt,name=options" json:"options,omitempty"`
}

func (m *BeginExecuteRequest) Reset()                    { *m = BeginExecuteRequest{} }
func (m *BeginExecuteRequest) String() string            { return "TODO" }



func (m *BeginExecuteRequest) GetEffectiveCallerId() *vtrpc.CallerID {
	if m != nil {
		return m.EffectiveCallerId
	}
	return nil
}

func (m *BeginExecuteRequest) GetImmediateCallerId() *VTGateCallerID {
	if m != nil {
		return m.ImmediateCallerId
	}
	return nil
}

func (m *BeginExecuteRequest) GetTarget() *Target {
	if m != nil {
		return m.Target
	}
	return nil
}

func (m *BeginExecuteRequest) GetQuery() *BoundQuery {
	if m != nil {
		return m.Query
	}
	return nil
}

func (m *BeginExecuteRequest) GetOptions() *ExecuteOptions {
	if m != nil {
		return m.Options
	}
	return nil
}

// BeginExecuteResponse is the returned value from BeginExecute
type BeginExecuteResponse struct {
	// error contains an application level error if necessary. Note the
	// transaction_id may be set, even when an error is returned, if the begin
	// worked but the execute failed.
	Error  *vtrpc.RPCError `protobuf:"bytes,1,opt,name=error" json:"error,omitempty"`
	Result *QueryResult    `protobuf:"bytes,2,opt,name=result" json:"result,omitempty"`
	// transaction_id might be non-zero even if an error is present.
	TransactionId int64 `protobuf:"varint,3,opt,name=transaction_id,json=transactionId" json:"transaction_id,omitempty"`
}

func (m *BeginExecuteResponse) Reset()                    { *m = BeginExecuteResponse{} }
func (m *BeginExecuteResponse) String() string            { return "TODO" }



func (m *BeginExecuteResponse) GetError() *vtrpc.RPCError {
	if m != nil {
		return m.Error
	}
	return nil
}

func (m *BeginExecuteResponse) GetResult() *QueryResult {
	if m != nil {
		return m.Result
	}
	return nil
}

func (m *BeginExecuteResponse) GetTransactionId() int64 {
	if m != nil {
		return m.TransactionId
	}
	return 0
}

// BeginExecuteBatchRequest is the payload to BeginExecuteBatch
type BeginExecuteBatchRequest struct {
	EffectiveCallerId *vtrpc.CallerID `protobuf:"bytes,1,opt,name=effective_caller_id,json=effectiveCallerId" json:"effective_caller_id,omitempty"`
	ImmediateCallerId *VTGateCallerID `protobuf:"bytes,2,opt,name=immediate_caller_id,json=immediateCallerId" json:"immediate_caller_id,omitempty"`
	Target            *Target         `protobuf:"bytes,3,opt,name=target" json:"target,omitempty"`
	Queries           []*BoundQuery   `protobuf:"bytes,4,rep,name=queries" json:"queries,omitempty"`
	AsTransaction     bool            `protobuf:"varint,5,opt,name=as_transaction,json=asTransaction" json:"as_transaction,omitempty"`
	Options           *ExecuteOptions `protobuf:"bytes,6,opt,name=options" json:"options,omitempty"`
}

func (m *BeginExecuteBatchRequest) Reset()                    { *m = BeginExecuteBatchRequest{} }
func (m *BeginExecuteBatchRequest) String() string            { return "TODO" }



func (m *BeginExecuteBatchRequest) GetEffectiveCallerId() *vtrpc.CallerID {
	if m != nil {
		return m.EffectiveCallerId
	}
	return nil
}

func (m *BeginExecuteBatchRequest) GetImmediateCallerId() *VTGateCallerID {
	if m != nil {
		return m.ImmediateCallerId
	}
	return nil
}

func (m *BeginExecuteBatchRequest) GetTarget() *Target {
	if m != nil {
		return m.Target
	}
	return nil
}

func (m *BeginExecuteBatchRequest) GetQueries() []*BoundQuery {
	if m != nil {
		return m.Queries
	}
	return nil
}

func (m *BeginExecuteBatchRequest) GetAsTransaction() bool {
	if m != nil {
		return m.AsTransaction
	}
	return false
}

func (m *BeginExecuteBatchRequest) GetOptions() *ExecuteOptions {
	if m != nil {
		return m.Options
	}
	return nil
}

// BeginExecuteBatchResponse is the returned value from BeginExecuteBatch
type BeginExecuteBatchResponse struct {
	// error contains an application level error if necessary. Note the
	// transaction_id may be set, even when an error is returned, if the begin
	// worked but the execute failed.
	Error   *vtrpc.RPCError `protobuf:"bytes,1,opt,name=error" json:"error,omitempty"`
	Results []*QueryResult  `protobuf:"bytes,2,rep,name=results" json:"results,omitempty"`
	// transaction_id might be non-zero even if an error is present.
	TransactionId int64 `protobuf:"varint,3,opt,name=transaction_id,json=transactionId" json:"transaction_id,omitempty"`
}

func (m *BeginExecuteBatchResponse) Reset()                    { *m = BeginExecuteBatchResponse{} }
func (m *BeginExecuteBatchResponse) String() string            { return "TODO" }



func (m *BeginExecuteBatchResponse) GetError() *vtrpc.RPCError {
	if m != nil {
		return m.Error
	}
	return nil
}

func (m *BeginExecuteBatchResponse) GetResults() []*QueryResult {
	if m != nil {
		return m.Results
	}
	return nil
}

func (m *BeginExecuteBatchResponse) GetTransactionId() int64 {
	if m != nil {
		return m.TransactionId
	}
	return 0
}

// MessageStreamRequest is the request payload for MessageStream.
type MessageStreamRequest struct {
	EffectiveCallerId *vtrpc.CallerID `protobuf:"bytes,1,opt,name=effective_caller_id,json=effectiveCallerId" json:"effective_caller_id,omitempty"`
	ImmediateCallerId *VTGateCallerID `protobuf:"bytes,2,opt,name=immediate_caller_id,json=immediateCallerId" json:"immediate_caller_id,omitempty"`
	Target            *Target         `protobuf:"bytes,3,opt,name=target" json:"target,omitempty"`
	// name is the message table name.
	Name string `protobuf:"bytes,4,opt,name=name" json:"name,omitempty"`
}

func (m *MessageStreamRequest) Reset()                    { *m = MessageStreamRequest{} }
func (m *MessageStreamRequest) String() string            { return "TODO" }



func (m *MessageStreamRequest) GetEffectiveCallerId() *vtrpc.CallerID {
	if m != nil {
		return m.EffectiveCallerId
	}
	return nil
}

func (m *MessageStreamRequest) GetImmediateCallerId() *VTGateCallerID {
	if m != nil {
		return m.ImmediateCallerId
	}
	return nil
}

func (m *MessageStreamRequest) GetTarget() *Target {
	if m != nil {
		return m.Target
	}
	return nil
}

func (m *MessageStreamRequest) GetName() string {
	if m != nil {
		return m.Name
	}
	return ""
}

// MessageStreamResponse is a response for MessageStream.
type MessageStreamResponse struct {
	Result *QueryResult `protobuf:"bytes,1,opt,name=result" json:"result,omitempty"`
}

func (m *MessageStreamResponse) Reset()                    { *m = MessageStreamResponse{} }
func (m *MessageStreamResponse) String() string            { return "TODO" }



func (m *MessageStreamResponse) GetResult() *QueryResult {
	if m != nil {
		return m.Result
	}
	return nil
}

// MessageAckRequest is the request payload for MessageAck.
type MessageAckRequest struct {
	EffectiveCallerId *vtrpc.CallerID `protobuf:"bytes,1,opt,name=effective_caller_id,json=effectiveCallerId" json:"effective_caller_id,omitempty"`
	ImmediateCallerId *VTGateCallerID `protobuf:"bytes,2,opt,name=immediate_caller_id,json=immediateCallerId" json:"immediate_caller_id,omitempty"`
	Target            *Target         `protobuf:"bytes,3,opt,name=target" json:"target,omitempty"`
	// name is the message table name.
	Name string   `protobuf:"bytes,4,opt,name=name" json:"name,omitempty"`
	Ids  []*Value `protobuf:"bytes,5,rep,name=ids" json:"ids,omitempty"`
}

func (m *MessageAckRequest) Reset()                    { *m = MessageAckRequest{} }
func (m *MessageAckRequest) String() string            { return "TODO" }



func (m *MessageAckRequest) GetEffectiveCallerId() *vtrpc.CallerID {
	if m != nil {
		return m.EffectiveCallerId
	}
	return nil
}

func (m *MessageAckRequest) GetImmediateCallerId() *VTGateCallerID {
	if m != nil {
		return m.ImmediateCallerId
	}
	return nil
}

func (m *MessageAckRequest) GetTarget() *Target {
	if m != nil {
		return m.Target
	}
	return nil
}

func (m *MessageAckRequest) GetName() string {
	if m != nil {
		return m.Name
	}
	return ""
}

func (m *MessageAckRequest) GetIds() []*Value {
	if m != nil {
		return m.Ids
	}
	return nil
}

// MessageAckResponse is the response for MessageAck.
type MessageAckResponse struct {
	// result contains the result of the ack operation.
	// Since this acts like a DML, only
	// RowsAffected is returned in the result.
	Result *QueryResult `protobuf:"bytes,1,opt,name=result" json:"result,omitempty"`
}

func (m *MessageAckResponse) Reset()                    { *m = MessageAckResponse{} }
func (m *MessageAckResponse) String() string            { return "TODO" }



func (m *MessageAckResponse) GetResult() *QueryResult {
	if m != nil {
		return m.Result
	}
	return nil
}

// SplitQueryRequest is the payload for SplitQuery sent by VTGate to a VTTablet.
// See vtgate.SplitQueryRequest for more details.
type SplitQueryRequest struct {
	EffectiveCallerId *vtrpc.CallerID `protobuf:"bytes,1,opt,name=effective_caller_id,json=effectiveCallerId" json:"effective_caller_id,omitempty"`
	ImmediateCallerId *VTGateCallerID `protobuf:"bytes,2,opt,name=immediate_caller_id,json=immediateCallerId" json:"immediate_caller_id,omitempty"`
	Target            *Target         `protobuf:"bytes,3,opt,name=target" json:"target,omitempty"`
	Query             *BoundQuery     `protobuf:"bytes,4,opt,name=query" json:"query,omitempty"`
	SplitColumn       []string        `protobuf:"bytes,5,rep,name=split_column,json=splitColumn" json:"split_column,omitempty"`
	// Exactly one of the following must be nonzero.
	SplitCount          int64                       `protobuf:"varint,6,opt,name=split_count,json=splitCount" json:"split_count,omitempty"`
	NumRowsPerQueryPart int64                       `protobuf:"varint,8,opt,name=num_rows_per_query_part,json=numRowsPerQueryPart" json:"num_rows_per_query_part,omitempty"`
	Algorithm           SplitQueryRequest_Algorithm `protobuf:"varint,9,opt,name=algorithm,enum=query.SplitQueryRequest_Algorithm" json:"algorithm,omitempty"`
}

func (m *SplitQueryRequest) Reset()                    { *m = SplitQueryRequest{} }
func (m *SplitQueryRequest) String() string            { return "TODO" }



func (m *SplitQueryRequest) GetEffectiveCallerId() *vtrpc.CallerID {
	if m != nil {
		return m.EffectiveCallerId
	}
	return nil
}

func (m *SplitQueryRequest) GetImmediateCallerId() *VTGateCallerID {
	if m != nil {
		return m.ImmediateCallerId
	}
	return nil
}

func (m *SplitQueryRequest) GetTarget() *Target {
	if m != nil {
		return m.Target
	}
	return nil
}

func (m *SplitQueryRequest) GetQuery() *BoundQuery {
	if m != nil {
		return m.Query
	}
	return nil
}

func (m *SplitQueryRequest) GetSplitColumn() []string {
	if m != nil {
		return m.SplitColumn
	}
	return nil
}

func (m *SplitQueryRequest) GetSplitCount() int64 {
	if m != nil {
		return m.SplitCount
	}
	return 0
}

func (m *SplitQueryRequest) GetNumRowsPerQueryPart() int64 {
	if m != nil {
		return m.NumRowsPerQueryPart
	}
	return 0
}

func (m *SplitQueryRequest) GetAlgorithm() SplitQueryRequest_Algorithm {
	if m != nil {
		return m.Algorithm
	}
	return SplitQueryRequest_EQUAL_SPLITS
}

// QuerySplit represents one query to execute on the tablet
type QuerySplit struct {
	// query is the query to execute
	Query *BoundQuery `protobuf:"bytes,1,opt,name=query" json:"query,omitempty"`
	// row_count is the approximate row count the query will return
	RowCount int64 `protobuf:"varint,2,opt,name=row_count,json=rowCount" json:"row_count,omitempty"`
}

func (m *QuerySplit) Reset()                    { *m = QuerySplit{} }
func (m *QuerySplit) String() string            { return "TODO" }



func (m *QuerySplit) GetQuery() *BoundQuery {
	if m != nil {
		return m.Query
	}
	return nil
}

func (m *QuerySplit) GetRowCount() int64 {
	if m != nil {
		return m.RowCount
	}
	return 0
}

// SplitQueryResponse is returned by SplitQuery and represents all the queries
// to execute in order to get the entire data set.
type SplitQueryResponse struct {
	Queries []*QuerySplit `protobuf:"bytes,1,rep,name=queries" json:"queries,omitempty"`
}

func (m *SplitQueryResponse) Reset()                    { *m = SplitQueryResponse{} }
func (m *SplitQueryResponse) String() string            { return "TODO" }



func (m *SplitQueryResponse) GetQueries() []*QuerySplit {
	if m != nil {
		return m.Queries
	}
	return nil
}

// StreamHealthRequest is the payload for StreamHealth
type StreamHealthRequest struct {
}

func (m *StreamHealthRequest) Reset()                    { *m = StreamHealthRequest{} }
func (m *StreamHealthRequest) String() string            { return "TODO" }



// RealtimeStats contains information about the tablet status
type RealtimeStats struct {
	// health_error is the last error we got from health check,
	// or empty is the server is healthy. This is used for subset selection,
	// we do not send queries to servers that are not healthy.
	HealthError string `protobuf:"bytes,1,opt,name=health_error,json=healthError" json:"health_error,omitempty"`
	// seconds_behind_master is populated for slaves only. It indicates
	// how far behind on (MySQL) replication a slave currently is.  It is used
	// by clients for subset selection (so we don't try to send traffic
	// to tablets that are too far behind).
	// NOTE: This field must not be evaluated if "health_error" is not empty.
	// TODO(mberlin): Let's switch it to int64 instead?
	SecondsBehindMaster uint32 `protobuf:"varint,2,opt,name=seconds_behind_master,json=secondsBehindMaster" json:"seconds_behind_master,omitempty"`
	// bin_log_players_count is the number of currently running binlog players.
	// if the value is 0, it means that filtered replication is currently not
	// running on the tablet. If >0, filtered replication is running.
	// NOTE: This field must not be evaluated if "health_error" is not empty.
	BinlogPlayersCount int32 `protobuf:"varint,3,opt,name=binlog_players_count,json=binlogPlayersCount" json:"binlog_players_count,omitempty"`
	// seconds_behind_master_filtered_replication is populated for the receiving
	// master of an ongoing filtered replication only.
	// It specifies how far the receiving master lags behind the sending master.
	// NOTE: This field must not be evaluated if "health_error" is not empty.
	// NOTE: This field must not be evaluated if "bin_log_players_count" is 0.
	SecondsBehindMasterFilteredReplication int64 `protobuf:"varint,4,opt,name=seconds_behind_master_filtered_replication,json=secondsBehindMasterFilteredReplication" json:"seconds_behind_master_filtered_replication,omitempty"`
	// cpu_usage is used for load-based balancing
	CpuUsage float64 `protobuf:"fixed64,5,opt,name=cpu_usage,json=cpuUsage" json:"cpu_usage,omitempty"`
	// qps is the average QPS (queries per second) rate in the last XX seconds
	// where XX is usually 60 (See query_service_stats.go).
	Qps float64 `protobuf:"fixed64,6,opt,name=qps" json:"qps,omitempty"`
}

func (m *RealtimeStats) Reset()                    { *m = RealtimeStats{} }
func (m *RealtimeStats) String() string            { return "TODO" }



func (m *RealtimeStats) GetHealthError() string {
	if m != nil {
		return m.HealthError
	}
	return ""
}

func (m *RealtimeStats) GetSecondsBehindMaster() uint32 {
	if m != nil {
		return m.SecondsBehindMaster
	}
	return 0
}

func (m *RealtimeStats) GetBinlogPlayersCount() int32 {
	if m != nil {
		return m.BinlogPlayersCount
	}
	return 0
}

func (m *RealtimeStats) GetSecondsBehindMasterFilteredReplication() int64 {
	if m != nil {
		return m.SecondsBehindMasterFilteredReplication
	}
	return 0
}

func (m *RealtimeStats) GetCpuUsage() float64 {
	if m != nil {
		return m.CpuUsage
	}
	return 0
}

func (m *RealtimeStats) GetQps() float64 {
	if m != nil {
		return m.Qps
	}
	return 0
}

// StreamHealthResponse is streamed by StreamHealth on a regular basis
type StreamHealthResponse struct {
	// target is the current server type. Only queries with that exact Target
	// record will be accepted.
	Target *Target `protobuf:"bytes,1,opt,name=target" json:"target,omitempty"`
	// serving is true iff the tablet is serving. A tablet may not be serving
	// if filtered replication is enabled on a master for instance,
	// or if a replica should not be used because the keyspace is being resharded.
	Serving bool `protobuf:"varint,2,opt,name=serving" json:"serving,omitempty"`
	// tablet_externally_reparented_timestamp can be interpreted as the last time
	// we knew that this tablet was the MASTER of this shard.
	//
	// It is used by vtgate when determining the current MASTER of a shard.
	// If vtgate sees more than one MASTER tablet, this timestamp is used
	// as tiebreaker where the MASTER with the highest timestamp wins.
	// Another usage of this timestamp is in go/vt/vtgate/buffer to detect the end
	// of a reparent (failover) and stop buffering.
	//
	// In practice, this field is set to:
	// a) the last time the RPC tabletmanager.TabletExternallyReparented was
	//    called on this tablet (usually done by an external failover tool e.g.
	//    Orchestrator). The failover tool can call this as long as we are the
	//    master i.e. even ages after the last reparent occurred.
	// OR
	// b) the last time an active reparent was executed through a vtctl command
	//    (InitShardMaster, PlannedReparentShard, EmergencyReparentShard)
	// OR
	// c) the last time vttablet was started and it initialized its tablet type
	//    as MASTER because it was recorded as the shard's current master in the
	//    topology (see go/vt/vttablet/tabletmanager/init_tablet.go)
	// OR
	// d) 0 if the vttablet was never a MASTER.
	TabletExternallyReparentedTimestamp int64 `protobuf:"varint,3,opt,name=tablet_externally_reparented_timestamp,json=tabletExternallyReparentedTimestamp" json:"tablet_externally_reparented_timestamp,omitempty"`
	// realtime_stats contains information about the tablet status
	RealtimeStats *RealtimeStats `protobuf:"bytes,4,opt,name=realtime_stats,json=realtimeStats" json:"realtime_stats,omitempty"`
	// tablet_alias is the alias of the sending tablet. The discovery/healthcheck.go
	// code uses it to verify that it's talking to the correct tablet and that it
	// hasn't changed in the meantime e.g. due to tablet restarts where ports or
	// ips have been reused but assigned differently.
	TabletAlias *topodata.TabletAlias `protobuf:"bytes,5,opt,name=tablet_alias,json=tabletAlias" json:"tablet_alias,omitempty"`
}

func (m *StreamHealthResponse) Reset()                    { *m = StreamHealthResponse{} }
func (m *StreamHealthResponse) String() string            { return "TODO" }



func (m *StreamHealthResponse) GetTarget() *Target {
	if m != nil {
		return m.Target
	}
	return nil
}

func (m *StreamHealthResponse) GetServing() bool {
	if m != nil {
		return m.Serving
	}
	return false
}

func (m *StreamHealthResponse) GetTabletExternallyReparentedTimestamp() int64 {
	if m != nil {
		return m.TabletExternallyReparentedTimestamp
	}
	return 0
}

func (m *StreamHealthResponse) GetRealtimeStats() *RealtimeStats {
	if m != nil {
		return m.RealtimeStats
	}
	return nil
}

func (m *StreamHealthResponse) GetTabletAlias() *topodata.TabletAlias {
	if m != nil {
		return m.TabletAlias
	}
	return nil
}

// UpdateStreamRequest is the payload for UpdateStream. At most one of
// position and timestamp can be set. If neither is set, we will start
// streaming from the current binlog position.
type UpdateStreamRequest struct {
	EffectiveCallerId *vtrpc.CallerID `protobuf:"bytes,1,opt,name=effective_caller_id,json=effectiveCallerId" json:"effective_caller_id,omitempty"`
	ImmediateCallerId *VTGateCallerID `protobuf:"bytes,2,opt,name=immediate_caller_id,json=immediateCallerId" json:"immediate_caller_id,omitempty"`
	Target            *Target         `protobuf:"bytes,3,opt,name=target" json:"target,omitempty"`
	// If position is set, we will start the streaming from that replication
	// position. Incompatible with timestamp.
	Position string `protobuf:"bytes,4,opt,name=position" json:"position,omitempty"`
	// If timestamp is set, we will start the streaming from the first
	// event in the binlogs that have that timestamp. Incompatible with position.
	Timestamp int64 `protobuf:"varint,5,opt,name=timestamp" json:"timestamp,omitempty"`
}

func (m *UpdateStreamRequest) Reset()                    { *m = UpdateStreamRequest{} }
func (m *UpdateStreamRequest) String() string            { return "TODO" }



func (m *UpdateStreamRequest) GetEffectiveCallerId() *vtrpc.CallerID {
	if m != nil {
		return m.EffectiveCallerId
	}
	return nil
}

func (m *UpdateStreamRequest) GetImmediateCallerId() *VTGateCallerID {
	if m != nil {
		return m.ImmediateCallerId
	}
	return nil
}

func (m *UpdateStreamRequest) GetTarget() *Target {
	if m != nil {
		return m.Target
	}
	return nil
}

func (m *UpdateStreamRequest) GetPosition() string {
	if m != nil {
		return m.Position
	}
	return ""
}

func (m *UpdateStreamRequest) GetTimestamp() int64 {
	if m != nil {
		return m.Timestamp
	}
	return 0
}

// UpdateStreamResponse is returned by UpdateStream
type UpdateStreamResponse struct {
	Event *StreamEvent `protobuf:"bytes,1,opt,name=event" json:"event,omitempty"`
}

func (m *UpdateStreamResponse) Reset()                    { *m = UpdateStreamResponse{} }
func (m *UpdateStreamResponse) String() string            { return "TODO" }



func (m *UpdateStreamResponse) GetEvent() *StreamEvent {
	if m != nil {
		return m.Event
	}
	return nil
}

// TransactionMetadata contains the metadata for a distributed transaction.
type TransactionMetadata struct {
	Dtid         string           `protobuf:"bytes,1,opt,name=dtid" json:"dtid,omitempty"`
	State        TransactionState `protobuf:"varint,2,opt,name=state,enum=query.TransactionState" json:"state,omitempty"`
	TimeCreated  int64            `protobuf:"varint,3,opt,name=time_created,json=timeCreated" json:"time_created,omitempty"`
	Participants []*Target        `protobuf:"bytes,4,rep,name=participants" json:"participants,omitempty"`
}

func (m *TransactionMetadata) Reset()                    { *m = TransactionMetadata{} }
func (m *TransactionMetadata) String() string            { return "TODO" }



func (m *TransactionMetadata) GetDtid() string {
	if m != nil {
		return m.Dtid
	}
	return ""
}

func (m *TransactionMetadata) GetState() TransactionState {
	if m != nil {
		return m.State
	}
	return TransactionState_UNKNOWN
}

func (m *TransactionMetadata) GetTimeCreated() int64 {
	if m != nil {
		return m.TimeCreated
	}
	return 0
}

func (m *TransactionMetadata) GetParticipants() []*Target {
	if m != nil {
		return m.Participants
	}
	return nil
}

func init() {
	proto.RegisterType((*Target)(nil), "query.Target")
	proto.RegisterType((*VTGateCallerID)(nil), "query.VTGateCallerID")
	proto.RegisterType((*EventToken)(nil), "query.EventToken")
	proto.RegisterType((*Value)(nil), "query.Value")
	proto.RegisterType((*BindVariable)(nil), "query.BindVariable")
	proto.RegisterType((*BoundQuery)(nil), "query.BoundQuery")
	proto.RegisterType((*ExecuteOptions)(nil), "query.ExecuteOptions")
	proto.RegisterType((*Field)(nil), "query.Field")
	proto.RegisterType((*Row)(nil), "query.Row")
	proto.RegisterType((*ResultExtras)(nil), "query.ResultExtras")
	proto.RegisterType((*QueryResult)(nil), "query.QueryResult")
	proto.RegisterType((*StreamEvent)(nil), "query.StreamEvent")
	proto.RegisterType((*StreamEvent_Statement)(nil), "query.StreamEvent.Statement")
	proto.RegisterType((*ExecuteRequest)(nil), "query.ExecuteRequest")
	proto.RegisterType((*ExecuteResponse)(nil), "query.ExecuteResponse")
	proto.RegisterType((*ResultWithError)(nil), "query.ResultWithError")
	proto.RegisterType((*ExecuteBatchRequest)(nil), "query.ExecuteBatchRequest")
	proto.RegisterType((*ExecuteBatchResponse)(nil), "query.ExecuteBatchResponse")
	proto.RegisterType((*StreamExecuteRequest)(nil), "query.StreamExecuteRequest")
	proto.RegisterType((*StreamExecuteResponse)(nil), "query.StreamExecuteResponse")
	proto.RegisterType((*BeginRequest)(nil), "query.BeginRequest")
	proto.RegisterType((*BeginResponse)(nil), "query.BeginResponse")
	proto.RegisterType((*CommitRequest)(nil), "query.CommitRequest")
	proto.RegisterType((*CommitResponse)(nil), "query.CommitResponse")
	proto.RegisterType((*RollbackRequest)(nil), "query.RollbackRequest")
	proto.RegisterType((*RollbackResponse)(nil), "query.RollbackResponse")
	proto.RegisterType((*PrepareRequest)(nil), "query.PrepareRequest")
	proto.RegisterType((*PrepareResponse)(nil), "query.PrepareResponse")
	proto.RegisterType((*CommitPreparedRequest)(nil), "query.CommitPreparedRequest")
	proto.RegisterType((*CommitPreparedResponse)(nil), "query.CommitPreparedResponse")
	proto.RegisterType((*RollbackPreparedRequest)(nil), "query.RollbackPreparedRequest")
	proto.RegisterType((*RollbackPreparedResponse)(nil), "query.RollbackPreparedResponse")
	proto.RegisterType((*CreateTransactionRequest)(nil), "query.CreateTransactionRequest")
	proto.RegisterType((*CreateTransactionResponse)(nil), "query.CreateTransactionResponse")
	proto.RegisterType((*StartCommitRequest)(nil), "query.StartCommitRequest")
	proto.RegisterType((*StartCommitResponse)(nil), "query.StartCommitResponse")
	proto.RegisterType((*SetRollbackRequest)(nil), "query.SetRollbackRequest")
	proto.RegisterType((*SetRollbackResponse)(nil), "query.SetRollbackResponse")
	proto.RegisterType((*ConcludeTransactionRequest)(nil), "query.ConcludeTransactionRequest")
	proto.RegisterType((*ConcludeTransactionResponse)(nil), "query.ConcludeTransactionResponse")
	proto.RegisterType((*ReadTransactionRequest)(nil), "query.ReadTransactionRequest")
	proto.RegisterType((*ReadTransactionResponse)(nil), "query.ReadTransactionResponse")
	proto.RegisterType((*BeginExecuteRequest)(nil), "query.BeginExecuteRequest")
	proto.RegisterType((*BeginExecuteResponse)(nil), "query.BeginExecuteResponse")
	proto.RegisterType((*BeginExecuteBatchRequest)(nil), "query.BeginExecuteBatchRequest")
	proto.RegisterType((*BeginExecuteBatchResponse)(nil), "query.BeginExecuteBatchResponse")
	proto.RegisterType((*MessageStreamRequest)(nil), "query.MessageStreamRequest")
	proto.RegisterType((*MessageStreamResponse)(nil), "query.MessageStreamResponse")
	proto.RegisterType((*MessageAckRequest)(nil), "query.MessageAckRequest")
	proto.RegisterType((*MessageAckResponse)(nil), "query.MessageAckResponse")
	proto.RegisterType((*SplitQueryRequest)(nil), "query.SplitQueryRequest")
	proto.RegisterType((*QuerySplit)(nil), "query.QuerySplit")
	proto.RegisterType((*SplitQueryResponse)(nil), "query.SplitQueryResponse")
	proto.RegisterType((*StreamHealthRequest)(nil), "query.StreamHealthRequest")
	proto.RegisterType((*RealtimeStats)(nil), "query.RealtimeStats")
	proto.RegisterType((*StreamHealthResponse)(nil), "query.StreamHealthResponse")
	proto.RegisterType((*UpdateStreamRequest)(nil), "query.UpdateStreamRequest")
	proto.RegisterType((*UpdateStreamResponse)(nil), "query.UpdateStreamResponse")
	proto.RegisterType((*TransactionMetadata)(nil), "query.TransactionMetadata")
	proto.RegisterEnum("query.MySqlFlag", MySqlFlag_name, MySqlFlag_value)
	proto.RegisterEnum("query.Flag", Flag_name, Flag_value)
	proto.RegisterEnum("query.Type", Type_name, Type_value)
	proto.RegisterEnum("query.TransactionState", TransactionState_name, TransactionState_value)
	proto.RegisterEnum("query.ExecuteOptions_IncludedFields", ExecuteOptions_IncludedFields_name, ExecuteOptions_IncludedFields_value)
	proto.RegisterEnum("query.ExecuteOptions_Workload", ExecuteOptions_Workload_name, ExecuteOptions_Workload_value)
	proto.RegisterEnum("query.ExecuteOptions_TransactionIsolation", ExecuteOptions_TransactionIsolation_name, ExecuteOptions_TransactionIsolation_value)
	proto.RegisterEnum("query.StreamEvent_Statement_Category", StreamEvent_Statement_Category_name, StreamEvent_Statement_Category_value)
	proto.RegisterEnum("query.SplitQueryRequest_Algorithm", SplitQueryRequest_Algorithm_name, SplitQueryRequest_Algorithm_value)
}

*/
