# How to create a network

Apart from creating containers, `Testcontainers for Go` allows you to create networks. This is useful when you need to connect multiple containers to the same network.

- Since testcontainers-go <a href="https://github.com/testcontainers/testcontainers-go/releases/tag/v0.27.0"><span class="tc-version">:material-tag: v0.27.0</span></a>

For that, please import the `testcontainers/network` package.

```go
import "github.com/testcontainers/testcontainers-go/network"
```

Then, you can create a network using the `network.New` function. This function receives a variadic list of options that can be used to configure the network.

- `WithAttachable()`
- `WithCheckDuplicate()`
- `WithDriver(driver string)`
- `WithEnableIPv6()`
- `WithInternal()`
- `WithLabels(labels map[string]string)`
- `WithIPAMConfig(config *network.IPAMConfig)`

It's important to mention that the name of the network is automatically generated by the library, and it's not possible to set it manually. However, you can retrieve the name of the network using the `Name` field of the `DockerNetwork` struct returned by the `New` function.

## Usage example

<!--codeinclude-->
[Creating a network](../../network/examples_test.go) inside_block:createNetwork
[Creating a network with options](../../network/examples_test.go) inside_block:newNetworkWithOptions
<!--/codeinclude--> 