// Copyright (c) 2016, 2018, 2025, Oracle and/or its affiliates.  All rights reserved.
// This software is dual-licensed to you under the Universal Permissive License (UPL) 1.0 as shown at https://oss.oracle.com/licenses/upl or Apache License 2.0 as shown at http://www.apache.org/licenses/LICENSE-2.0. You may choose either license.
// Code generated. DO NOT EDIT.

// Identity Domains API
//
// Use the Identity Domains API to manage resources within an identity domain, for example, users, dynamic resource groups, groups, and identity providers. For information about managing resources within identity domains, see Identity and Access Management (with identity domains) (https://docs.oracle.com/iaas/Content/Identity/home.htm).
// Use this pattern to construct endpoints for identity domains: `https://<domainURL>/admin/v1/`. See Finding an Identity Domain URL (https://docs.oracle.com/en-us/iaas/Content/Identity/api-getstarted/locate-identity-domain-url.htm) to locate the domain URL you need.
// Use the table of contents and search tool to explore the Identity Domains API.
//

package identitydomains

import (
	"fmt"
	"github.com/oracle/oci-go-sdk/v65/common"
	"strings"
)

// SelfRegistrationProfileUserAttributes User Attributes
type SelfRegistrationProfileUserAttributes struct {

	// name of the attribute
	// **SCIM++ Properties:**
	//  - caseExact: true
	//  - idcsSearchable: true
	//  - multiValued: false
	//  - mutability: readWrite
	//  - required: true
	//  - returned: default
	//  - type: string
	//  - uniqueness: none
	Value *string `mandatory:"true" json:"value"`

	// **SCIM++ Properties:**
	// - idcsSearchable: true
	// - multiValued: false
	// - mutability: readWrite
	// - required: true
	// - returned: default
	// - type: integer
	// - uniqueness: none
	// Sequence Number for the attribute
	SeqNumber *int `mandatory:"true" json:"seqNumber"`

	// **SCIM++ Properties:**
	// - idcsSearchable: true
	// - multiValued: false
	// - mutability: readWrite
	// - required: false
	// - returned: default
	// - type: string
	// - uniqueness: none
	// Fully Qualified Attribute Name
	FullyQualifiedAttributeName *string `mandatory:"false" json:"fullyQualifiedAttributeName"`

	// If this attribute can be deleted
	// **SCIM++ Properties:**
	//  - idcsSearchable: false
	//  - multiValued: false
	//  - mutability: readOnly
	//  - required: false
	//  - returned: default
	//  - type: boolean
	//  - uniqueness: none
	Deletable *bool `mandatory:"false" json:"deletable"`

	// Metadata of the user attribute
	// **Added In:** 18.1.6
	// **SCIM++ Properties:**
	//  - multiValued: false
	//  - mutability: readOnly
	//  - required: false
	//  - returned: default
	//  - type: string
	//  - uniqueness: none
	Metadata *string `mandatory:"false" json:"metadata"`
}

func (m SelfRegistrationProfileUserAttributes) String() string {
	return common.PointerString(m)
}

// ValidateEnumValue returns an error when providing an unsupported enum value
// This function is being called during constructing API request process
// Not recommended for calling this function directly
func (m SelfRegistrationProfileUserAttributes) ValidateEnumValue() (bool, error) {
	errMessage := []string{}

	if len(errMessage) > 0 {
		return true, fmt.Errorf(strings.Join(errMessage, "\n"))
	}
	return false, nil
}
