// Copyright (c) 2016, 2018, 2024, Oracle and/or its affiliates.  All rights reserved.
// This software is dual-licensed to you under the Universal Permissive License (UPL) 1.0 as shown at https://oss.oracle.com/licenses/upl or Apache License 2.0 as shown at http://www.apache.org/licenses/LICENSE-2.0. You may choose either license.
// Code generated. DO NOT EDIT.

package vulnerabilityscanning

import (
	"fmt"
	"github.com/oracle/oci-go-sdk/v65/common"
	"net/http"
	"strings"
)

// ListHostVulnerabilitiesRequest wrapper for the ListHostVulnerabilities operation
//
// # See also
//
// Click https://docs.cloud.oracle.com/en-us/iaas/tools/go-sdk-examples/latest/vulnerabilityscanning/ListHostVulnerabilities.go.html to see an example of how to use ListHostVulnerabilitiesRequest.
type ListHostVulnerabilitiesRequest struct {

	// The ID of the compartment in which to list resources.
	CompartmentId *string `mandatory:"true" contributesTo:"query" name:"compartmentId"`

	// The maximum number of items to return.
	Limit *int `mandatory:"false" contributesTo:"query" name:"limit"`

	// The page token representing the page at which to start retrieving results. This is usually retrieved from a previous list call.
	Page *string `mandatory:"false" contributesTo:"query" name:"page"`

	// A filter to return only resources that have a severity that matches the given severity
	Severity ListHostVulnerabilitiesSeverityEnum `mandatory:"false" contributesTo:"query" name:"severity" omitEmpty:"true"`

	// A filter to return only resources that match the entire name given.
	Name *string `mandatory:"false" contributesTo:"query" name:"name"`

	// Parameter to filter by CVE reference number for vulnerabilities
	CveReference *string `mandatory:"false" contributesTo:"query" name:"cveReference"`

	// The field to filter vulnerabilities based on its type. Only one value can be provided.
	VulnerabilityType ListHostVulnerabilitiesVulnerabilityTypeEnum `mandatory:"false" contributesTo:"query" name:"vulnerabilityType" omitEmpty:"true"`

	// The sort order to use, either 'ASC' or 'DESC'.
	SortOrder ListHostVulnerabilitiesSortOrderEnum `mandatory:"false" contributesTo:"query" name:"sortOrder" omitEmpty:"true"`

	// The field to sort by. Only one sort order may be provided. Default order for 'name' is Ascending. Default order for other values is descending. If no value is specified name is default.
	SortBy ListHostVulnerabilitiesSortByEnum `mandatory:"false" contributesTo:"query" name:"sortBy" omitEmpty:"true"`

	// The client request ID for tracing.
	OpcRequestId *string `mandatory:"false" contributesTo:"header" name:"opc-request-id"`

	// Metadata about the request. This information will not be transmitted to the service, but
	// represents information that the SDK will consume to drive retry behavior.
	RequestMetadata common.RequestMetadata
}

func (request ListHostVulnerabilitiesRequest) String() string {
	return common.PointerString(request)
}

// HTTPRequest implements the OCIRequest interface
func (request ListHostVulnerabilitiesRequest) HTTPRequest(method, path string, binaryRequestBody *common.OCIReadSeekCloser, extraHeaders map[string]string) (http.Request, error) {

	_, err := request.ValidateEnumValue()
	if err != nil {
		return http.Request{}, err
	}
	return common.MakeDefaultHTTPRequestWithTaggedStructAndExtraHeaders(method, path, request, extraHeaders)
}

// BinaryRequestBody implements the OCIRequest interface
func (request ListHostVulnerabilitiesRequest) BinaryRequestBody() (*common.OCIReadSeekCloser, bool) {

	return nil, false

}

// RetryPolicy implements the OCIRetryableRequest interface. This retrieves the specified retry policy.
func (request ListHostVulnerabilitiesRequest) RetryPolicy() *common.RetryPolicy {
	return request.RequestMetadata.RetryPolicy
}

// ValidateEnumValue returns an error when providing an unsupported enum value
// This function is being called during constructing API request process
// Not recommended for calling this function directly
func (request ListHostVulnerabilitiesRequest) ValidateEnumValue() (bool, error) {
	errMessage := []string{}
	if _, ok := GetMappingListHostVulnerabilitiesSeverityEnum(string(request.Severity)); !ok && request.Severity != "" {
		errMessage = append(errMessage, fmt.Sprintf("unsupported enum value for Severity: %s. Supported values are: %s.", request.Severity, strings.Join(GetListHostVulnerabilitiesSeverityEnumStringValues(), ",")))
	}
	if _, ok := GetMappingListHostVulnerabilitiesVulnerabilityTypeEnum(string(request.VulnerabilityType)); !ok && request.VulnerabilityType != "" {
		errMessage = append(errMessage, fmt.Sprintf("unsupported enum value for VulnerabilityType: %s. Supported values are: %s.", request.VulnerabilityType, strings.Join(GetListHostVulnerabilitiesVulnerabilityTypeEnumStringValues(), ",")))
	}
	if _, ok := GetMappingListHostVulnerabilitiesSortOrderEnum(string(request.SortOrder)); !ok && request.SortOrder != "" {
		errMessage = append(errMessage, fmt.Sprintf("unsupported enum value for SortOrder: %s. Supported values are: %s.", request.SortOrder, strings.Join(GetListHostVulnerabilitiesSortOrderEnumStringValues(), ",")))
	}
	if _, ok := GetMappingListHostVulnerabilitiesSortByEnum(string(request.SortBy)); !ok && request.SortBy != "" {
		errMessage = append(errMessage, fmt.Sprintf("unsupported enum value for SortBy: %s. Supported values are: %s.", request.SortBy, strings.Join(GetListHostVulnerabilitiesSortByEnumStringValues(), ",")))
	}
	if len(errMessage) > 0 {
		return true, fmt.Errorf(strings.Join(errMessage, "\n"))
	}
	return false, nil
}

// ListHostVulnerabilitiesResponse wrapper for the ListHostVulnerabilities operation
type ListHostVulnerabilitiesResponse struct {

	// The underlying http response
	RawResponse *http.Response

	// A list of HostVulnerabilitySummaryCollection instances
	HostVulnerabilitySummaryCollection `presentIn:"body"`

	// Unique Oracle-assigned identifier for the request. If you need to contact
	// Oracle about a particular request, please provide the request ID.
	OpcRequestId *string `presentIn:"header" name:"opc-request-id"`

	// For pagination of a list of items. When paging through a list, if this header appears in the response,
	// then a partial list might have been returned. Include this value as the `page` parameter for the
	// subsequent GET request to get the next batch of items.
	OpcNextPage *string `presentIn:"header" name:"opc-next-page"`
}

func (response ListHostVulnerabilitiesResponse) String() string {
	return common.PointerString(response)
}

// HTTPResponse implements the OCIResponse interface
func (response ListHostVulnerabilitiesResponse) HTTPResponse() *http.Response {
	return response.RawResponse
}

// ListHostVulnerabilitiesSeverityEnum Enum with underlying type: string
type ListHostVulnerabilitiesSeverityEnum string

// Set of constants representing the allowable values for ListHostVulnerabilitiesSeverityEnum
const (
	ListHostVulnerabilitiesSeverityNone     ListHostVulnerabilitiesSeverityEnum = "NONE"
	ListHostVulnerabilitiesSeverityLow      ListHostVulnerabilitiesSeverityEnum = "LOW"
	ListHostVulnerabilitiesSeverityMedium   ListHostVulnerabilitiesSeverityEnum = "MEDIUM"
	ListHostVulnerabilitiesSeverityHigh     ListHostVulnerabilitiesSeverityEnum = "HIGH"
	ListHostVulnerabilitiesSeverityCritical ListHostVulnerabilitiesSeverityEnum = "CRITICAL"
)

var mappingListHostVulnerabilitiesSeverityEnum = map[string]ListHostVulnerabilitiesSeverityEnum{
	"NONE":     ListHostVulnerabilitiesSeverityNone,
	"LOW":      ListHostVulnerabilitiesSeverityLow,
	"MEDIUM":   ListHostVulnerabilitiesSeverityMedium,
	"HIGH":     ListHostVulnerabilitiesSeverityHigh,
	"CRITICAL": ListHostVulnerabilitiesSeverityCritical,
}

var mappingListHostVulnerabilitiesSeverityEnumLowerCase = map[string]ListHostVulnerabilitiesSeverityEnum{
	"none":     ListHostVulnerabilitiesSeverityNone,
	"low":      ListHostVulnerabilitiesSeverityLow,
	"medium":   ListHostVulnerabilitiesSeverityMedium,
	"high":     ListHostVulnerabilitiesSeverityHigh,
	"critical": ListHostVulnerabilitiesSeverityCritical,
}

// GetListHostVulnerabilitiesSeverityEnumValues Enumerates the set of values for ListHostVulnerabilitiesSeverityEnum
func GetListHostVulnerabilitiesSeverityEnumValues() []ListHostVulnerabilitiesSeverityEnum {
	values := make([]ListHostVulnerabilitiesSeverityEnum, 0)
	for _, v := range mappingListHostVulnerabilitiesSeverityEnum {
		values = append(values, v)
	}
	return values
}

// GetListHostVulnerabilitiesSeverityEnumStringValues Enumerates the set of values in String for ListHostVulnerabilitiesSeverityEnum
func GetListHostVulnerabilitiesSeverityEnumStringValues() []string {
	return []string{
		"NONE",
		"LOW",
		"MEDIUM",
		"HIGH",
		"CRITICAL",
	}
}

// GetMappingListHostVulnerabilitiesSeverityEnum performs case Insensitive comparison on enum value and return the desired enum
func GetMappingListHostVulnerabilitiesSeverityEnum(val string) (ListHostVulnerabilitiesSeverityEnum, bool) {
	enum, ok := mappingListHostVulnerabilitiesSeverityEnumLowerCase[strings.ToLower(val)]
	return enum, ok
}

// ListHostVulnerabilitiesVulnerabilityTypeEnum Enum with underlying type: string
type ListHostVulnerabilitiesVulnerabilityTypeEnum string

// Set of constants representing the allowable values for ListHostVulnerabilitiesVulnerabilityTypeEnum
const (
	ListHostVulnerabilitiesVulnerabilityTypeCve     ListHostVulnerabilitiesVulnerabilityTypeEnum = "CVE"
	ListHostVulnerabilitiesVulnerabilityTypeProblem ListHostVulnerabilitiesVulnerabilityTypeEnum = "PROBLEM"
)

var mappingListHostVulnerabilitiesVulnerabilityTypeEnum = map[string]ListHostVulnerabilitiesVulnerabilityTypeEnum{
	"CVE":     ListHostVulnerabilitiesVulnerabilityTypeCve,
	"PROBLEM": ListHostVulnerabilitiesVulnerabilityTypeProblem,
}

var mappingListHostVulnerabilitiesVulnerabilityTypeEnumLowerCase = map[string]ListHostVulnerabilitiesVulnerabilityTypeEnum{
	"cve":     ListHostVulnerabilitiesVulnerabilityTypeCve,
	"problem": ListHostVulnerabilitiesVulnerabilityTypeProblem,
}

// GetListHostVulnerabilitiesVulnerabilityTypeEnumValues Enumerates the set of values for ListHostVulnerabilitiesVulnerabilityTypeEnum
func GetListHostVulnerabilitiesVulnerabilityTypeEnumValues() []ListHostVulnerabilitiesVulnerabilityTypeEnum {
	values := make([]ListHostVulnerabilitiesVulnerabilityTypeEnum, 0)
	for _, v := range mappingListHostVulnerabilitiesVulnerabilityTypeEnum {
		values = append(values, v)
	}
	return values
}

// GetListHostVulnerabilitiesVulnerabilityTypeEnumStringValues Enumerates the set of values in String for ListHostVulnerabilitiesVulnerabilityTypeEnum
func GetListHostVulnerabilitiesVulnerabilityTypeEnumStringValues() []string {
	return []string{
		"CVE",
		"PROBLEM",
	}
}

// GetMappingListHostVulnerabilitiesVulnerabilityTypeEnum performs case Insensitive comparison on enum value and return the desired enum
func GetMappingListHostVulnerabilitiesVulnerabilityTypeEnum(val string) (ListHostVulnerabilitiesVulnerabilityTypeEnum, bool) {
	enum, ok := mappingListHostVulnerabilitiesVulnerabilityTypeEnumLowerCase[strings.ToLower(val)]
	return enum, ok
}

// ListHostVulnerabilitiesSortOrderEnum Enum with underlying type: string
type ListHostVulnerabilitiesSortOrderEnum string

// Set of constants representing the allowable values for ListHostVulnerabilitiesSortOrderEnum
const (
	ListHostVulnerabilitiesSortOrderAsc  ListHostVulnerabilitiesSortOrderEnum = "ASC"
	ListHostVulnerabilitiesSortOrderDesc ListHostVulnerabilitiesSortOrderEnum = "DESC"
)

var mappingListHostVulnerabilitiesSortOrderEnum = map[string]ListHostVulnerabilitiesSortOrderEnum{
	"ASC":  ListHostVulnerabilitiesSortOrderAsc,
	"DESC": ListHostVulnerabilitiesSortOrderDesc,
}

var mappingListHostVulnerabilitiesSortOrderEnumLowerCase = map[string]ListHostVulnerabilitiesSortOrderEnum{
	"asc":  ListHostVulnerabilitiesSortOrderAsc,
	"desc": ListHostVulnerabilitiesSortOrderDesc,
}

// GetListHostVulnerabilitiesSortOrderEnumValues Enumerates the set of values for ListHostVulnerabilitiesSortOrderEnum
func GetListHostVulnerabilitiesSortOrderEnumValues() []ListHostVulnerabilitiesSortOrderEnum {
	values := make([]ListHostVulnerabilitiesSortOrderEnum, 0)
	for _, v := range mappingListHostVulnerabilitiesSortOrderEnum {
		values = append(values, v)
	}
	return values
}

// GetListHostVulnerabilitiesSortOrderEnumStringValues Enumerates the set of values in String for ListHostVulnerabilitiesSortOrderEnum
func GetListHostVulnerabilitiesSortOrderEnumStringValues() []string {
	return []string{
		"ASC",
		"DESC",
	}
}

// GetMappingListHostVulnerabilitiesSortOrderEnum performs case Insensitive comparison on enum value and return the desired enum
func GetMappingListHostVulnerabilitiesSortOrderEnum(val string) (ListHostVulnerabilitiesSortOrderEnum, bool) {
	enum, ok := mappingListHostVulnerabilitiesSortOrderEnumLowerCase[strings.ToLower(val)]
	return enum, ok
}

// ListHostVulnerabilitiesSortByEnum Enum with underlying type: string
type ListHostVulnerabilitiesSortByEnum string

// Set of constants representing the allowable values for ListHostVulnerabilitiesSortByEnum
const (
	ListHostVulnerabilitiesSortByName          ListHostVulnerabilitiesSortByEnum = "name"
	ListHostVulnerabilitiesSortBySeverity      ListHostVulnerabilitiesSortByEnum = "severity"
	ListHostVulnerabilitiesSortByImpactedhosts ListHostVulnerabilitiesSortByEnum = "impactedHosts"
	ListHostVulnerabilitiesSortByFirstdetected ListHostVulnerabilitiesSortByEnum = "firstDetected"
	ListHostVulnerabilitiesSortByLastdetected  ListHostVulnerabilitiesSortByEnum = "lastDetected"
)

var mappingListHostVulnerabilitiesSortByEnum = map[string]ListHostVulnerabilitiesSortByEnum{
	"name":          ListHostVulnerabilitiesSortByName,
	"severity":      ListHostVulnerabilitiesSortBySeverity,
	"impactedHosts": ListHostVulnerabilitiesSortByImpactedhosts,
	"firstDetected": ListHostVulnerabilitiesSortByFirstdetected,
	"lastDetected":  ListHostVulnerabilitiesSortByLastdetected,
}

var mappingListHostVulnerabilitiesSortByEnumLowerCase = map[string]ListHostVulnerabilitiesSortByEnum{
	"name":          ListHostVulnerabilitiesSortByName,
	"severity":      ListHostVulnerabilitiesSortBySeverity,
	"impactedhosts": ListHostVulnerabilitiesSortByImpactedhosts,
	"firstdetected": ListHostVulnerabilitiesSortByFirstdetected,
	"lastdetected":  ListHostVulnerabilitiesSortByLastdetected,
}

// GetListHostVulnerabilitiesSortByEnumValues Enumerates the set of values for ListHostVulnerabilitiesSortByEnum
func GetListHostVulnerabilitiesSortByEnumValues() []ListHostVulnerabilitiesSortByEnum {
	values := make([]ListHostVulnerabilitiesSortByEnum, 0)
	for _, v := range mappingListHostVulnerabilitiesSortByEnum {
		values = append(values, v)
	}
	return values
}

// GetListHostVulnerabilitiesSortByEnumStringValues Enumerates the set of values in String for ListHostVulnerabilitiesSortByEnum
func GetListHostVulnerabilitiesSortByEnumStringValues() []string {
	return []string{
		"name",
		"severity",
		"impactedHosts",
		"firstDetected",
		"lastDetected",
	}
}

// GetMappingListHostVulnerabilitiesSortByEnum performs case Insensitive comparison on enum value and return the desired enum
func GetMappingListHostVulnerabilitiesSortByEnum(val string) (ListHostVulnerabilitiesSortByEnum, bool) {
	enum, ok := mappingListHostVulnerabilitiesSortByEnumLowerCase[strings.ToLower(val)]
	return enum, ok
}
