// Code generated by go-swagger; DO NOT EDIT.

package vault_service

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"fmt"
	"io"

	"github.com/go-openapi/runtime"
	"github.com/go-openapi/strfmt"

	cloud "github.com/hashicorp/hcp-sdk-go/clients/cloud-shared/v1/models"
	"github.com/hashicorp/hcp-sdk-go/clients/cloud-vault-service/stable/2020-11-25/models"
)

// UpdatePathsFilterReader is a Reader for the UpdatePathsFilter structure.
type UpdatePathsFilterReader struct {
	formats strfmt.Registry
}

// ReadResponse reads a server response into the received o.
func (o *UpdatePathsFilterReader) ReadResponse(response runtime.ClientResponse, consumer runtime.Consumer) (interface{}, error) {
	switch response.Code() {
	case 200:
		result := NewUpdatePathsFilterOK()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return result, nil
	default:
		result := NewUpdatePathsFilterDefault(response.Code())
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		if response.Code()/100 == 2 {
			return result, nil
		}
		return nil, result
	}
}

// NewUpdatePathsFilterOK creates a UpdatePathsFilterOK with default headers values
func NewUpdatePathsFilterOK() *UpdatePathsFilterOK {
	return &UpdatePathsFilterOK{}
}

/*
UpdatePathsFilterOK describes a response with status code 200, with default header values.

A successful response.
*/
type UpdatePathsFilterOK struct {
	Payload *models.HashicorpCloudVault20201125UpdatePathsFilterResponse
}

// IsSuccess returns true when this update paths filter o k response has a 2xx status code
func (o *UpdatePathsFilterOK) IsSuccess() bool {
	return true
}

// IsRedirect returns true when this update paths filter o k response has a 3xx status code
func (o *UpdatePathsFilterOK) IsRedirect() bool {
	return false
}

// IsClientError returns true when this update paths filter o k response has a 4xx status code
func (o *UpdatePathsFilterOK) IsClientError() bool {
	return false
}

// IsServerError returns true when this update paths filter o k response has a 5xx status code
func (o *UpdatePathsFilterOK) IsServerError() bool {
	return false
}

// IsCode returns true when this update paths filter o k response a status code equal to that given
func (o *UpdatePathsFilterOK) IsCode(code int) bool {
	return code == 200
}

func (o *UpdatePathsFilterOK) Error() string {
	return fmt.Sprintf("[POST /vault/2020-11-25/organizations/{location.organization_id}/projects/{location.project_id}/clusters/{cluster_id}/paths-filter/update][%d] updatePathsFilterOK  %+v", 200, o.Payload)
}

func (o *UpdatePathsFilterOK) String() string {
	return fmt.Sprintf("[POST /vault/2020-11-25/organizations/{location.organization_id}/projects/{location.project_id}/clusters/{cluster_id}/paths-filter/update][%d] updatePathsFilterOK  %+v", 200, o.Payload)
}

func (o *UpdatePathsFilterOK) GetPayload() *models.HashicorpCloudVault20201125UpdatePathsFilterResponse {
	return o.Payload
}

func (o *UpdatePathsFilterOK) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	o.Payload = new(models.HashicorpCloudVault20201125UpdatePathsFilterResponse)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}

// NewUpdatePathsFilterDefault creates a UpdatePathsFilterDefault with default headers values
func NewUpdatePathsFilterDefault(code int) *UpdatePathsFilterDefault {
	return &UpdatePathsFilterDefault{
		_statusCode: code,
	}
}

/*
UpdatePathsFilterDefault describes a response with status code -1, with default header values.

An unexpected error response.
*/
type UpdatePathsFilterDefault struct {
	_statusCode int

	Payload *cloud.GrpcGatewayRuntimeError
}

// Code gets the status code for the update paths filter default response
func (o *UpdatePathsFilterDefault) Code() int {
	return o._statusCode
}

// IsSuccess returns true when this update paths filter default response has a 2xx status code
func (o *UpdatePathsFilterDefault) IsSuccess() bool {
	return o._statusCode/100 == 2
}

// IsRedirect returns true when this update paths filter default response has a 3xx status code
func (o *UpdatePathsFilterDefault) IsRedirect() bool {
	return o._statusCode/100 == 3
}

// IsClientError returns true when this update paths filter default response has a 4xx status code
func (o *UpdatePathsFilterDefault) IsClientError() bool {
	return o._statusCode/100 == 4
}

// IsServerError returns true when this update paths filter default response has a 5xx status code
func (o *UpdatePathsFilterDefault) IsServerError() bool {
	return o._statusCode/100 == 5
}

// IsCode returns true when this update paths filter default response a status code equal to that given
func (o *UpdatePathsFilterDefault) IsCode(code int) bool {
	return o._statusCode == code
}

func (o *UpdatePathsFilterDefault) Error() string {
	return fmt.Sprintf("[POST /vault/2020-11-25/organizations/{location.organization_id}/projects/{location.project_id}/clusters/{cluster_id}/paths-filter/update][%d] UpdatePathsFilter default  %+v", o._statusCode, o.Payload)
}

func (o *UpdatePathsFilterDefault) String() string {
	return fmt.Sprintf("[POST /vault/2020-11-25/organizations/{location.organization_id}/projects/{location.project_id}/clusters/{cluster_id}/paths-filter/update][%d] UpdatePathsFilter default  %+v", o._statusCode, o.Payload)
}

func (o *UpdatePathsFilterDefault) GetPayload() *cloud.GrpcGatewayRuntimeError {
	return o.Payload
}

func (o *UpdatePathsFilterDefault) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	o.Payload = new(cloud.GrpcGatewayRuntimeError)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}
