package scsp

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// UpdateRingStatus invokes the scsp.UpdateRingStatus API synchronously
func (client *Client) UpdateRingStatus(request *UpdateRingStatusRequest) (response *UpdateRingStatusResponse, err error) {
	response = CreateUpdateRingStatusResponse()
	err = client.DoAction(request, response)
	return
}

// UpdateRingStatusWithChan invokes the scsp.UpdateRingStatus API asynchronously
func (client *Client) UpdateRingStatusWithChan(request *UpdateRingStatusRequest) (<-chan *UpdateRingStatusResponse, <-chan error) {
	responseChan := make(chan *UpdateRingStatusResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.UpdateRingStatus(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// UpdateRingStatusWithCallback invokes the scsp.UpdateRingStatus API asynchronously
func (client *Client) UpdateRingStatusWithCallback(request *UpdateRingStatusRequest, callback func(response *UpdateRingStatusResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *UpdateRingStatusResponse
		var err error
		defer close(result)
		response, err = client.UpdateRingStatus(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// UpdateRingStatusRequest is the request struct for api UpdateRingStatus
type UpdateRingStatusRequest struct {
	*requests.RpcRequest
	InstanceId    string `position:"Body"`
	Extra         string `position:"Body"`
	CallOutStatus string `position:"Body"`
	UniqueBizId   string `position:"Body"`
}

// UpdateRingStatusResponse is the response struct for api UpdateRingStatus
type UpdateRingStatusResponse struct {
	*responses.BaseResponse
	Message        string `json:"Message" xml:"Message"`
	RequestId      string `json:"RequestId" xml:"RequestId"`
	Data           string `json:"Data" xml:"Data"`
	Code           string `json:"Code" xml:"Code"`
	Success        bool   `json:"Success" xml:"Success"`
	HttpStatusCode int64  `json:"HttpStatusCode" xml:"HttpStatusCode"`
}

// CreateUpdateRingStatusRequest creates a request to invoke UpdateRingStatus API
func CreateUpdateRingStatusRequest() (request *UpdateRingStatusRequest) {
	request = &UpdateRingStatusRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("scsp", "2020-07-02", "UpdateRingStatus", "", "")
	request.Method = requests.POST
	return
}

// CreateUpdateRingStatusResponse creates a response to parse from UpdateRingStatus response
func CreateUpdateRingStatusResponse() (response *UpdateRingStatusResponse) {
	response = &UpdateRingStatusResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
