package scsp

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// AppMessagePush invokes the scsp.AppMessagePush API synchronously
func (client *Client) AppMessagePush(request *AppMessagePushRequest) (response *AppMessagePushResponse, err error) {
	response = CreateAppMessagePushResponse()
	err = client.DoAction(request, response)
	return
}

// AppMessagePushWithChan invokes the scsp.AppMessagePush API asynchronously
func (client *Client) AppMessagePushWithChan(request *AppMessagePushRequest) (<-chan *AppMessagePushResponse, <-chan error) {
	responseChan := make(chan *AppMessagePushResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.AppMessagePush(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// AppMessagePushWithCallback invokes the scsp.AppMessagePush API asynchronously
func (client *Client) AppMessagePushWithCallback(request *AppMessagePushRequest, callback func(response *AppMessagePushResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *AppMessagePushResponse
		var err error
		defer close(result)
		response, err = client.AppMessagePush(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// AppMessagePushRequest is the request struct for api AppMessagePush
type AppMessagePushRequest struct {
	*requests.RpcRequest
	InstanceId     string           `position:"Query"`
	ExpirationTime requests.Integer `position:"Query"`
	UserId         string           `position:"Query"`
	Status         requests.Integer `position:"Query"`
}

// AppMessagePushResponse is the response struct for api AppMessagePush
type AppMessagePushResponse struct {
	*responses.BaseResponse
	RequestId string `json:"RequestId" xml:"RequestId"`
	Data      string `json:"Data" xml:"Data"`
	Code      string `json:"Code" xml:"Code"`
	Message   string `json:"Message" xml:"Message"`
	Success   bool   `json:"Success" xml:"Success"`
}

// CreateAppMessagePushRequest creates a request to invoke AppMessagePush API
func CreateAppMessagePushRequest() (request *AppMessagePushRequest) {
	request = &AppMessagePushRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("scsp", "2020-07-02", "AppMessagePush", "", "")
	request.Method = requests.POST
	return
}

// CreateAppMessagePushResponse creates a response to parse from AppMessagePush response
func CreateAppMessagePushResponse() (response *AppMessagePushResponse) {
	response = &AppMessagePushResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
