package linkface

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// QueryAddUserInfo invokes the linkface.QueryAddUserInfo API synchronously
// api document: https://help.aliyun.com/api/linkface/queryadduserinfo.html
func (client *Client) QueryAddUserInfo(request *QueryAddUserInfoRequest) (response *QueryAddUserInfoResponse, err error) {
	response = CreateQueryAddUserInfoResponse()
	err = client.DoAction(request, response)
	return
}

// QueryAddUserInfoWithChan invokes the linkface.QueryAddUserInfo API asynchronously
// api document: https://help.aliyun.com/api/linkface/queryadduserinfo.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) QueryAddUserInfoWithChan(request *QueryAddUserInfoRequest) (<-chan *QueryAddUserInfoResponse, <-chan error) {
	responseChan := make(chan *QueryAddUserInfoResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.QueryAddUserInfo(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// QueryAddUserInfoWithCallback invokes the linkface.QueryAddUserInfo API asynchronously
// api document: https://help.aliyun.com/api/linkface/queryadduserinfo.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) QueryAddUserInfoWithCallback(request *QueryAddUserInfoRequest, callback func(response *QueryAddUserInfoResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *QueryAddUserInfoResponse
		var err error
		defer close(result)
		response, err = client.QueryAddUserInfo(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// QueryAddUserInfoRequest is the request struct for api QueryAddUserInfo
type QueryAddUserInfoRequest struct {
	*requests.RpcRequest
	IotId      string `position:"Body" name:"IotId"`
	GroupId    string `position:"Body" name:"GroupId"`
	DeviceName string `position:"Body" name:"DeviceName"`
	ProductKey string `position:"Body" name:"ProductKey"`
}

// QueryAddUserInfoResponse is the response struct for api QueryAddUserInfo
type QueryAddUserInfoResponse struct {
	*responses.BaseResponse
	RequestId string `json:"RequestId" xml:"RequestId"`
	Code      int    `json:"Code" xml:"Code"`
	Message   string `json:"Message" xml:"Message"`
	Success   bool   `json:"Success" xml:"Success"`
	Data      Data   `json:"Data" xml:"Data"`
}

// CreateQueryAddUserInfoRequest creates a request to invoke QueryAddUserInfo API
func CreateQueryAddUserInfoRequest() (request *QueryAddUserInfoRequest) {
	request = &QueryAddUserInfoRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("LinkFace", "2018-07-20", "QueryAddUserInfo", "", "")
	return
}

// CreateQueryAddUserInfoResponse creates a response to parse from QueryAddUserInfo response
func CreateQueryAddUserInfoResponse() (response *QueryAddUserInfoResponse) {
	response = &QueryAddUserInfoResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
