package ecs

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// DescribeSpotAdvice invokes the ecs.DescribeSpotAdvice API synchronously
func (client *Client) DescribeSpotAdvice(request *DescribeSpotAdviceRequest) (response *DescribeSpotAdviceResponse, err error) {
	response = CreateDescribeSpotAdviceResponse()
	err = client.DoAction(request, response)
	return
}

// DescribeSpotAdviceWithChan invokes the ecs.DescribeSpotAdvice API asynchronously
func (client *Client) DescribeSpotAdviceWithChan(request *DescribeSpotAdviceRequest) (<-chan *DescribeSpotAdviceResponse, <-chan error) {
	responseChan := make(chan *DescribeSpotAdviceResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.DescribeSpotAdvice(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// DescribeSpotAdviceWithCallback invokes the ecs.DescribeSpotAdvice API asynchronously
func (client *Client) DescribeSpotAdviceWithCallback(request *DescribeSpotAdviceRequest, callback func(response *DescribeSpotAdviceResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *DescribeSpotAdviceResponse
		var err error
		defer close(result)
		response, err = client.DescribeSpotAdvice(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// DescribeSpotAdviceRequest is the request struct for api DescribeSpotAdvice
type DescribeSpotAdviceRequest struct {
	*requests.RpcRequest
	GpuSpec              string           `position:"Query" name:"GpuSpec"`
	ResourceOwnerId      requests.Integer `position:"Query" name:"ResourceOwnerId"`
	Memory               requests.Float   `position:"Query" name:"Memory"`
	IoOptimized          string           `position:"Query" name:"IoOptimized"`
	InstanceTypes        *[]string        `position:"Query" name:"InstanceTypes"  type:"Repeated"`
	MinCores             requests.Integer `position:"Query" name:"MinCores"`
	NetworkType          string           `position:"Query" name:"NetworkType"`
	Cores                requests.Integer `position:"Query" name:"Cores"`
	ResourceOwnerAccount string           `position:"Query" name:"ResourceOwnerAccount"`
	OwnerAccount         string           `position:"Query" name:"OwnerAccount"`
	InstanceTypeFamily   string           `position:"Query" name:"InstanceTypeFamily"`
	OwnerId              requests.Integer `position:"Query" name:"OwnerId"`
	InstanceFamilyLevel  string           `position:"Query" name:"InstanceFamilyLevel"`
	ZoneId               string           `position:"Query" name:"ZoneId"`
	GpuAmount            requests.Integer `position:"Query" name:"GpuAmount"`
	MinMemory            requests.Float   `position:"Query" name:"MinMemory"`
}

// DescribeSpotAdviceResponse is the response struct for api DescribeSpotAdvice
type DescribeSpotAdviceResponse struct {
	*responses.BaseResponse
	RegionId           string             `json:"RegionId" xml:"RegionId"`
	RequestId          string             `json:"RequestId" xml:"RequestId"`
	AvailableSpotZones AvailableSpotZones `json:"AvailableSpotZones" xml:"AvailableSpotZones"`
}

// CreateDescribeSpotAdviceRequest creates a request to invoke DescribeSpotAdvice API
func CreateDescribeSpotAdviceRequest() (request *DescribeSpotAdviceRequest) {
	request = &DescribeSpotAdviceRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("Ecs", "2014-05-26", "DescribeSpotAdvice", "ecs", "openAPI")
	request.Method = requests.POST
	return
}

// CreateDescribeSpotAdviceResponse creates a response to parse from DescribeSpotAdvice response
func CreateDescribeSpotAdviceResponse() (response *DescribeSpotAdviceResponse) {
	response = &DescribeSpotAdviceResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
