// +build go1.9

// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License. See License.txt in the project root for license information.

// This code was auto-generated by:
// github.com/Azure/azure-sdk-for-go/tools/profileBuilder

package attestation

import original "github.com/Azure/azure-sdk-for-go/services/attestation/2020-10-01/attestation"

type CertificateModification = original.CertificateModification

const (
	IsAbsent  CertificateModification = original.IsAbsent
	IsPresent CertificateModification = original.IsPresent
)

type DataType = original.DataType

const (
	Binary DataType = original.Binary
	JSON   DataType = original.JSON
)

type PolicyModification = original.PolicyModification

const (
	Removed PolicyModification = original.Removed
	Updated PolicyModification = original.Updated
)

type Type = original.Type

const (
	OpenEnclave Type = original.OpenEnclave
	SgxEnclave  Type = original.SgxEnclave
	Tpm         Type = original.Tpm
)

type AttestOpenEnclaveRequest = original.AttestOpenEnclaveRequest
type AttestSgxEnclaveRequest = original.AttestSgxEnclaveRequest
type BaseClient = original.BaseClient
type CertificateManagementBody = original.CertificateManagementBody
type Client = original.Client
type CloudError = original.CloudError
type CloudErrorBody = original.CloudErrorBody
type InitTimeData = original.InitTimeData
type JSONWebKey = original.JSONWebKey
type JSONWebKeySet = original.JSONWebKeySet
type MetadataConfigurationClient = original.MetadataConfigurationClient
type PolicyCertificatesClient = original.PolicyCertificatesClient
type PolicyCertificatesModificationResult = original.PolicyCertificatesModificationResult
type PolicyCertificatesModifyResponse = original.PolicyCertificatesModifyResponse
type PolicyCertificatesResponse = original.PolicyCertificatesResponse
type PolicyCertificatesResult = original.PolicyCertificatesResult
type PolicyClient = original.PolicyClient
type PolicyResponse = original.PolicyResponse
type PolicyResult = original.PolicyResult
type Response = original.Response
type Result = original.Result
type RuntimeData = original.RuntimeData
type SetObject = original.SetObject
type SigningCertificatesClient = original.SigningCertificatesClient
type StoredAttestationPolicy = original.StoredAttestationPolicy
type TpmAttestationRequest = original.TpmAttestationRequest
type TpmAttestationResponse = original.TpmAttestationResponse

func New() BaseClient {
	return original.New()
}
func NewClient() Client {
	return original.NewClient()
}
func NewMetadataConfigurationClient() MetadataConfigurationClient {
	return original.NewMetadataConfigurationClient()
}
func NewPolicyCertificatesClient() PolicyCertificatesClient {
	return original.NewPolicyCertificatesClient()
}
func NewPolicyClient() PolicyClient {
	return original.NewPolicyClient()
}
func NewSigningCertificatesClient() SigningCertificatesClient {
	return original.NewSigningCertificatesClient()
}
func NewWithoutDefaults() BaseClient {
	return original.NewWithoutDefaults()
}
func PossibleCertificateModificationValues() []CertificateModification {
	return original.PossibleCertificateModificationValues()
}
func PossibleDataTypeValues() []DataType {
	return original.PossibleDataTypeValues()
}
func PossiblePolicyModificationValues() []PolicyModification {
	return original.PossiblePolicyModificationValues()
}
func PossibleTypeValues() []Type {
	return original.PossibleTypeValues()
}
func UserAgent() string {
	return original.UserAgent() + " profiles/latest"
}
func Version() string {
	return original.Version()
}
