/*
 * Decompiled with CFR 0.152.
 */
package com.sun.media.codec.video.cinepak;

import com.ibm.media.codec.video.VideoCodec;
import com.sun.media.codec.video.cinepak.CineStore;
import java.awt.Dimension;
import javax.media.Buffer;
import javax.media.Format;
import javax.media.ResourceUnavailableException;
import javax.media.format.RGBFormat;
import javax.media.format.VideoFormat;

public class JavaDecoder
extends VideoCodec {
    private static final int rMask = 255;
    private static final int gMask = 65280;
    private static final int bMask = 0xFF0000;
    private int[] refData = null;
    private CineStore fOurStore;

    public JavaDecoder() {
        this.supportedInputFormats = new VideoFormat[]{new VideoFormat("cvid")};
        this.defaultOutputFormats = new VideoFormat[]{new RGBFormat(null, -1, Format.intArray, -1.0f, 32, 255, 65280, 0xFF0000, 1, -1, 0, -1)};
        this.PLUGIN_NAME = "Cinepak Decoder";
    }

    protected Format[] getMatchingOutputFormats(Format in) {
        VideoFormat ivf = (VideoFormat)in;
        Dimension inSize = ivf.getSize();
        int lineStride = inSize.width + 3 & 0xFFFFFFFC;
        int rowStride = inSize.height + 3 & 0xFFFFFFFC;
        this.supportedOutputFormats = new VideoFormat[]{new RGBFormat(new Dimension(inSize), lineStride * rowStride, Format.intArray, ivf.getFrameRate(), 32, 255, 65280, 0xFF0000)};
        return this.supportedOutputFormats;
    }

    public void open() throws ResourceUnavailableException {
        this.initDecoder();
    }

    public void close() {
        this.fOurStore = null;
    }

    public void reset() {
    }

    protected void videoResized() {
        this.initDecoder();
    }

    protected void initDecoder() {
        this.fOurStore = new CineStore();
    }

    public int process(Buffer inputBuffer, Buffer outputBuffer) {
        if (!this.checkInputBuffer(inputBuffer)) {
            return 1;
        }
        if (this.isEOM(inputBuffer)) {
            this.propagateEOM(outputBuffer);
            return 0;
        }
        VideoFormat ivf = (VideoFormat)inputBuffer.getFormat();
        int inLength = inputBuffer.getLength();
        int inMaxLength = ivf.getMaxDataLength();
        int outMaxLength = this.outputFormat.getMaxDataLength();
        byte[] inData = (byte[])inputBuffer.getData();
        int[] outData = this.validateIntArraySize(outputBuffer, outMaxLength);
        if (this.refData == null) {
            this.refData = outData;
            outputBuffer.setData(null);
            outData = this.validateIntArraySize(outputBuffer, outMaxLength);
        }
        outputBuffer.setData(this.refData);
        outputBuffer.setFormat(this.outputFormat);
        this.fOurStore.DoFrame(inputBuffer, outputBuffer, this.fOurStore);
        System.arraycopy(this.refData, 0, outData, 0, outMaxLength);
        outputBuffer.setData(outData);
        this.updateOutput(outputBuffer, this.outputFormat, outMaxLength, 0);
        return 0;
    }
}

