// Copyright 2023 Google LLC
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//     http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// Code generated by protoc-gen-go. DO NOT EDIT.
// versions:
// 	protoc-gen-go v1.31.0
// 	protoc        v4.23.2
// source: google/cloud/vmwareengine/v1/vmwareengine.proto

package vmwareenginepb

import (
	context "context"
	reflect "reflect"
	sync "sync"

	longrunningpb "cloud.google.com/go/longrunning/autogen/longrunningpb"
	_ "google.golang.org/genproto/googleapis/api/annotations"
	grpc "google.golang.org/grpc"
	codes "google.golang.org/grpc/codes"
	status "google.golang.org/grpc/status"
	protoreflect "google.golang.org/protobuf/reflect/protoreflect"
	protoimpl "google.golang.org/protobuf/runtime/protoimpl"
	_ "google.golang.org/protobuf/types/known/emptypb"
	fieldmaskpb "google.golang.org/protobuf/types/known/fieldmaskpb"
	timestamppb "google.golang.org/protobuf/types/known/timestamppb"
)

const (
	// Verify that this generated code is sufficiently up-to-date.
	_ = protoimpl.EnforceVersion(20 - protoimpl.MinVersion)
	// Verify that runtime/protoimpl is sufficiently up-to-date.
	_ = protoimpl.EnforceVersion(protoimpl.MaxVersion - 20)
)

// Request message for
// [VmwareEngine.ListPrivateClouds][google.cloud.vmwareengine.v1.VmwareEngine.ListPrivateClouds]
type ListPrivateCloudsRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. The resource name of the private cloud to be queried for
	// clusters. Resource names are schemeless URIs that follow the conventions in
	// https://cloud.google.com/apis/design/resource_names.
	// For example:
	// `projects/my-project/locations/us-central1-a`
	Parent string `protobuf:"bytes,1,opt,name=parent,proto3" json:"parent,omitempty"`
	// The maximum number of private clouds to return in one page.
	// The service may return fewer than this value.
	// The maximum value is coerced to 1000.
	// The default value of this field is 500.
	PageSize int32 `protobuf:"varint,2,opt,name=page_size,json=pageSize,proto3" json:"page_size,omitempty"`
	// A page token, received from a previous `ListPrivateClouds` call.
	// Provide this to retrieve the subsequent page.
	//
	// When paginating, all other parameters provided to `ListPrivateClouds` must
	// match the call that provided the page token.
	PageToken string `protobuf:"bytes,3,opt,name=page_token,json=pageToken,proto3" json:"page_token,omitempty"`
	// A filter expression that matches resources returned in the response.
	// The expression must specify the field name, a comparison operator, and the
	// value that you want to use for filtering. The value must be a string, a
	// number, or a boolean. The comparison operator must be `=`, `!=`, `>`, or
	// `<`.
	//
	// For example, if you are filtering a list of private clouds, you can exclude
	// the ones named `example-pc` by specifying `name != "example-pc"`.
	//
	// You can also filter nested fields. For example, you could specify
	// `networkConfig.managementCidr = "192.168.0.0/24"` to include private clouds
	// only if they have a matching address in their network configuration.
	//
	// To filter on multiple expressions, provide each separate expression within
	// parentheses. For example:
	// ```
	// (name = "example-pc")
	// (createTime > "2021-04-12T08:15:10.40Z")
	// ```
	//
	// By default, each expression is an `AND` expression. However, you can
	// include `AND` and `OR` expressions explicitly. For example:
	// ```
	// (name = "private-cloud-1") AND
	// (createTime > "2021-04-12T08:15:10.40Z") OR
	// (name = "private-cloud-2")
	// ```
	Filter string `protobuf:"bytes,4,opt,name=filter,proto3" json:"filter,omitempty"`
	// Sorts list results by a certain order. By default, returned results are
	// ordered by `name` in ascending order. You can also sort results in
	// descending order based on the `name` value using `orderBy="name desc"`.
	// Currently, only ordering by `name` is supported.
	OrderBy string `protobuf:"bytes,5,opt,name=order_by,json=orderBy,proto3" json:"order_by,omitempty"`
}

func (x *ListPrivateCloudsRequest) Reset() {
	*x = ListPrivateCloudsRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_vmwareengine_v1_vmwareengine_proto_msgTypes[0]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *ListPrivateCloudsRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ListPrivateCloudsRequest) ProtoMessage() {}

func (x *ListPrivateCloudsRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_vmwareengine_v1_vmwareengine_proto_msgTypes[0]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ListPrivateCloudsRequest.ProtoReflect.Descriptor instead.
func (*ListPrivateCloudsRequest) Descriptor() ([]byte, []int) {
	return file_google_cloud_vmwareengine_v1_vmwareengine_proto_rawDescGZIP(), []int{0}
}

func (x *ListPrivateCloudsRequest) GetParent() string {
	if x != nil {
		return x.Parent
	}
	return ""
}

func (x *ListPrivateCloudsRequest) GetPageSize() int32 {
	if x != nil {
		return x.PageSize
	}
	return 0
}

func (x *ListPrivateCloudsRequest) GetPageToken() string {
	if x != nil {
		return x.PageToken
	}
	return ""
}

func (x *ListPrivateCloudsRequest) GetFilter() string {
	if x != nil {
		return x.Filter
	}
	return ""
}

func (x *ListPrivateCloudsRequest) GetOrderBy() string {
	if x != nil {
		return x.OrderBy
	}
	return ""
}

// Response message for
// [VmwareEngine.ListPrivateClouds][google.cloud.vmwareengine.v1.VmwareEngine.ListPrivateClouds]
type ListPrivateCloudsResponse struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// A list of private clouds.
	PrivateClouds []*PrivateCloud `protobuf:"bytes,1,rep,name=private_clouds,json=privateClouds,proto3" json:"private_clouds,omitempty"`
	// A token, which can be sent as `page_token` to retrieve the next page.
	// If this field is omitted, there are no subsequent pages.
	NextPageToken string `protobuf:"bytes,2,opt,name=next_page_token,json=nextPageToken,proto3" json:"next_page_token,omitempty"`
	// Locations that could not be reached when making an aggregated query using
	// wildcards.
	Unreachable []string `protobuf:"bytes,3,rep,name=unreachable,proto3" json:"unreachable,omitempty"`
}

func (x *ListPrivateCloudsResponse) Reset() {
	*x = ListPrivateCloudsResponse{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_vmwareengine_v1_vmwareengine_proto_msgTypes[1]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *ListPrivateCloudsResponse) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ListPrivateCloudsResponse) ProtoMessage() {}

func (x *ListPrivateCloudsResponse) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_vmwareengine_v1_vmwareengine_proto_msgTypes[1]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ListPrivateCloudsResponse.ProtoReflect.Descriptor instead.
func (*ListPrivateCloudsResponse) Descriptor() ([]byte, []int) {
	return file_google_cloud_vmwareengine_v1_vmwareengine_proto_rawDescGZIP(), []int{1}
}

func (x *ListPrivateCloudsResponse) GetPrivateClouds() []*PrivateCloud {
	if x != nil {
		return x.PrivateClouds
	}
	return nil
}

func (x *ListPrivateCloudsResponse) GetNextPageToken() string {
	if x != nil {
		return x.NextPageToken
	}
	return ""
}

func (x *ListPrivateCloudsResponse) GetUnreachable() []string {
	if x != nil {
		return x.Unreachable
	}
	return nil
}

// Request message for
// [VmwareEngine.GetPrivateCloud][google.cloud.vmwareengine.v1.VmwareEngine.GetPrivateCloud]
type GetPrivateCloudRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. The resource name of the private cloud to retrieve.
	// Resource names are schemeless URIs that follow the conventions in
	// https://cloud.google.com/apis/design/resource_names.
	// For example:
	// `projects/my-project/locations/us-central1-a/privateClouds/my-cloud`
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
}

func (x *GetPrivateCloudRequest) Reset() {
	*x = GetPrivateCloudRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_vmwareengine_v1_vmwareengine_proto_msgTypes[2]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *GetPrivateCloudRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*GetPrivateCloudRequest) ProtoMessage() {}

func (x *GetPrivateCloudRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_vmwareengine_v1_vmwareengine_proto_msgTypes[2]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use GetPrivateCloudRequest.ProtoReflect.Descriptor instead.
func (*GetPrivateCloudRequest) Descriptor() ([]byte, []int) {
	return file_google_cloud_vmwareengine_v1_vmwareengine_proto_rawDescGZIP(), []int{2}
}

func (x *GetPrivateCloudRequest) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

// Request message for
// [VmwareEngine.CreatePrivateCloud][google.cloud.vmwareengine.v1.VmwareEngine.CreatePrivateCloud]
type CreatePrivateCloudRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. The resource name of the location to create the new
	// private cloud in. Resource names are schemeless URIs that follow the
	// conventions in https://cloud.google.com/apis/design/resource_names.
	// For example:
	// `projects/my-project/locations/us-central1-a`
	Parent string `protobuf:"bytes,1,opt,name=parent,proto3" json:"parent,omitempty"`
	// Required. The user-provided identifier of the private cloud to be created.
	// This identifier must be unique among each `PrivateCloud` within the parent
	// and becomes the final token in the name URI.
	// The identifier must meet the following requirements:
	//
	// * Only contains 1-63 alphanumeric characters and hyphens
	// * Begins with an alphabetical character
	// * Ends with a non-hyphen character
	// * Not formatted as a UUID
	// * Complies with [RFC 1034](https://datatracker.ietf.org/doc/html/rfc1034)
	// (section 3.5)
	PrivateCloudId string `protobuf:"bytes,2,opt,name=private_cloud_id,json=privateCloudId,proto3" json:"private_cloud_id,omitempty"`
	// Required. The initial description of the new private cloud.
	PrivateCloud *PrivateCloud `protobuf:"bytes,3,opt,name=private_cloud,json=privateCloud,proto3" json:"private_cloud,omitempty"`
	// Optional. The request ID must be a valid UUID with the exception that zero
	// UUID is not supported (00000000-0000-0000-0000-000000000000).
	RequestId string `protobuf:"bytes,4,opt,name=request_id,json=requestId,proto3" json:"request_id,omitempty"`
	// Optional. True if you want the request to be validated and not executed;
	// false otherwise.
	ValidateOnly bool `protobuf:"varint,5,opt,name=validate_only,json=validateOnly,proto3" json:"validate_only,omitempty"`
}

func (x *CreatePrivateCloudRequest) Reset() {
	*x = CreatePrivateCloudRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_vmwareengine_v1_vmwareengine_proto_msgTypes[3]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *CreatePrivateCloudRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*CreatePrivateCloudRequest) ProtoMessage() {}

func (x *CreatePrivateCloudRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_vmwareengine_v1_vmwareengine_proto_msgTypes[3]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use CreatePrivateCloudRequest.ProtoReflect.Descriptor instead.
func (*CreatePrivateCloudRequest) Descriptor() ([]byte, []int) {
	return file_google_cloud_vmwareengine_v1_vmwareengine_proto_rawDescGZIP(), []int{3}
}

func (x *CreatePrivateCloudRequest) GetParent() string {
	if x != nil {
		return x.Parent
	}
	return ""
}

func (x *CreatePrivateCloudRequest) GetPrivateCloudId() string {
	if x != nil {
		return x.PrivateCloudId
	}
	return ""
}

func (x *CreatePrivateCloudRequest) GetPrivateCloud() *PrivateCloud {
	if x != nil {
		return x.PrivateCloud
	}
	return nil
}

func (x *CreatePrivateCloudRequest) GetRequestId() string {
	if x != nil {
		return x.RequestId
	}
	return ""
}

func (x *CreatePrivateCloudRequest) GetValidateOnly() bool {
	if x != nil {
		return x.ValidateOnly
	}
	return false
}

// Request message for
// [VmwareEngine.UpdatePrivateCloud][google.cloud.vmwareengine.v1.VmwareEngine.UpdatePrivateCloud]
type UpdatePrivateCloudRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. Private cloud description.
	PrivateCloud *PrivateCloud `protobuf:"bytes,1,opt,name=private_cloud,json=privateCloud,proto3" json:"private_cloud,omitempty"`
	// Required. Field mask is used to specify the fields to be overwritten in the
	// `PrivateCloud` resource by the update. The fields specified in `updateMask`
	// are relative to the resource, not the full request. A field will be
	// overwritten if it is in the mask. If the user does not provide a mask then
	// all fields will be overwritten.
	UpdateMask *fieldmaskpb.FieldMask `protobuf:"bytes,2,opt,name=update_mask,json=updateMask,proto3" json:"update_mask,omitempty"`
	// Optional. The request ID must be a valid UUID with the exception that zero
	// UUID is not supported (00000000-0000-0000-0000-000000000000).
	RequestId string `protobuf:"bytes,3,opt,name=request_id,json=requestId,proto3" json:"request_id,omitempty"`
}

func (x *UpdatePrivateCloudRequest) Reset() {
	*x = UpdatePrivateCloudRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_vmwareengine_v1_vmwareengine_proto_msgTypes[4]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *UpdatePrivateCloudRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*UpdatePrivateCloudRequest) ProtoMessage() {}

func (x *UpdatePrivateCloudRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_vmwareengine_v1_vmwareengine_proto_msgTypes[4]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use UpdatePrivateCloudRequest.ProtoReflect.Descriptor instead.
func (*UpdatePrivateCloudRequest) Descriptor() ([]byte, []int) {
	return file_google_cloud_vmwareengine_v1_vmwareengine_proto_rawDescGZIP(), []int{4}
}

func (x *UpdatePrivateCloudRequest) GetPrivateCloud() *PrivateCloud {
	if x != nil {
		return x.PrivateCloud
	}
	return nil
}

func (x *UpdatePrivateCloudRequest) GetUpdateMask() *fieldmaskpb.FieldMask {
	if x != nil {
		return x.UpdateMask
	}
	return nil
}

func (x *UpdatePrivateCloudRequest) GetRequestId() string {
	if x != nil {
		return x.RequestId
	}
	return ""
}

// Request message for
// [VmwareEngine.DeletePrivateCloud][google.cloud.vmwareengine.v1.VmwareEngine.DeletePrivateCloud]
type DeletePrivateCloudRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. The resource name of the private cloud to delete.
	// Resource names are schemeless URIs that follow the conventions in
	// https://cloud.google.com/apis/design/resource_names.
	// For example:
	// `projects/my-project/locations/us-central1-a/privateClouds/my-cloud`
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
	// Optional. The request ID must be a valid UUID with the exception that zero
	// UUID is not supported (00000000-0000-0000-0000-000000000000).
	RequestId string `protobuf:"bytes,2,opt,name=request_id,json=requestId,proto3" json:"request_id,omitempty"`
	// Optional. If set to true, cascade delete is enabled and all children of
	// this private cloud resource are also deleted. When this flag is set to
	// false, the private cloud will not be deleted if there are any children
	// other than the management cluster. The management cluster is always
	// deleted.
	Force bool `protobuf:"varint,3,opt,name=force,proto3" json:"force,omitempty"`
	// Optional. Time delay of the deletion specified in hours. The default value
	// is `3`. Specifying a non-zero value for this field changes the value of
	// `PrivateCloud.state` to `DELETED` and sets `expire_time` to the planned
	// deletion time. Deletion can be cancelled before `expire_time` elapses using
	// [VmwareEngine.UndeletePrivateCloud][google.cloud.vmwareengine.v1.VmwareEngine.UndeletePrivateCloud].
	// Specifying a value of `0` for this field instead begins the deletion
	// process and ceases billing immediately. During the final deletion process,
	// the value of `PrivateCloud.state` becomes `PURGING`.
	DelayHours *int32 `protobuf:"varint,4,opt,name=delay_hours,json=delayHours,proto3,oneof" json:"delay_hours,omitempty"`
}

func (x *DeletePrivateCloudRequest) Reset() {
	*x = DeletePrivateCloudRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_vmwareengine_v1_vmwareengine_proto_msgTypes[5]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *DeletePrivateCloudRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*DeletePrivateCloudRequest) ProtoMessage() {}

func (x *DeletePrivateCloudRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_vmwareengine_v1_vmwareengine_proto_msgTypes[5]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use DeletePrivateCloudRequest.ProtoReflect.Descriptor instead.
func (*DeletePrivateCloudRequest) Descriptor() ([]byte, []int) {
	return file_google_cloud_vmwareengine_v1_vmwareengine_proto_rawDescGZIP(), []int{5}
}

func (x *DeletePrivateCloudRequest) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

func (x *DeletePrivateCloudRequest) GetRequestId() string {
	if x != nil {
		return x.RequestId
	}
	return ""
}

func (x *DeletePrivateCloudRequest) GetForce() bool {
	if x != nil {
		return x.Force
	}
	return false
}

func (x *DeletePrivateCloudRequest) GetDelayHours() int32 {
	if x != nil && x.DelayHours != nil {
		return *x.DelayHours
	}
	return 0
}

// Request message for
// [VmwareEngine.UndeletePrivateCloud][google.cloud.vmwareengine.v1.VmwareEngine.UndeletePrivateCloud]
type UndeletePrivateCloudRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. The resource name of the private cloud scheduled for deletion.
	// Resource names are schemeless URIs that follow the conventions in
	// https://cloud.google.com/apis/design/resource_names.
	// For example:
	// `projects/my-project/locations/us-central1-a/privateClouds/my-cloud`
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
	// Optional. The request ID must be a valid UUID with the exception that zero
	// UUID is not supported (00000000-0000-0000-0000-000000000000).
	RequestId string `protobuf:"bytes,2,opt,name=request_id,json=requestId,proto3" json:"request_id,omitempty"`
}

func (x *UndeletePrivateCloudRequest) Reset() {
	*x = UndeletePrivateCloudRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_vmwareengine_v1_vmwareengine_proto_msgTypes[6]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *UndeletePrivateCloudRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*UndeletePrivateCloudRequest) ProtoMessage() {}

func (x *UndeletePrivateCloudRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_vmwareengine_v1_vmwareengine_proto_msgTypes[6]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use UndeletePrivateCloudRequest.ProtoReflect.Descriptor instead.
func (*UndeletePrivateCloudRequest) Descriptor() ([]byte, []int) {
	return file_google_cloud_vmwareengine_v1_vmwareengine_proto_rawDescGZIP(), []int{6}
}

func (x *UndeletePrivateCloudRequest) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

func (x *UndeletePrivateCloudRequest) GetRequestId() string {
	if x != nil {
		return x.RequestId
	}
	return ""
}

// Request message for
// [VmwareEngine.ListClusters][google.cloud.vmwareengine.v1.VmwareEngine.ListClusters]
type ListClustersRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. The resource name of the private cloud to query for clusters.
	// Resource names are schemeless URIs that follow the conventions in
	// https://cloud.google.com/apis/design/resource_names.
	// For example:
	// `projects/my-project/locations/us-central1-a/privateClouds/my-cloud`
	Parent string `protobuf:"bytes,1,opt,name=parent,proto3" json:"parent,omitempty"`
	// The maximum number of clusters to return in one page.
	// The service may return fewer than this value.
	// The maximum value is coerced to 1000.
	// The default value of this field is 500.
	PageSize int32 `protobuf:"varint,2,opt,name=page_size,json=pageSize,proto3" json:"page_size,omitempty"`
	// A page token, received from a previous `ListClusters` call.
	// Provide this to retrieve the subsequent page.
	//
	// When paginating, all other parameters provided to `ListClusters`
	// must match the call that provided the page token.
	PageToken string `protobuf:"bytes,3,opt,name=page_token,json=pageToken,proto3" json:"page_token,omitempty"`
	//
	// To filter on multiple expressions, provide each separate expression within
	// parentheses. For example:
	// ```
	// (name = "example-cluster")
	// (nodeCount = "3")
	// ```
	//
	// By default, each expression is an `AND` expression. However, you can
	// include `AND` and `OR` expressions explicitly. For example:
	// ```
	// (name = "example-cluster-1") AND
	// (createTime > "2021-04-12T08:15:10.40Z") OR
	// (name = "example-cluster-2")
	// ```
	Filter string `protobuf:"bytes,4,opt,name=filter,proto3" json:"filter,omitempty"`
	// Sorts list results by a certain order. By default, returned results are
	// ordered by `name` in ascending order. You can also sort results in
	// descending order based on the `name` value using `orderBy="name desc"`.
	// Currently, only ordering by `name` is supported.
	OrderBy string `protobuf:"bytes,5,opt,name=order_by,json=orderBy,proto3" json:"order_by,omitempty"`
}

func (x *ListClustersRequest) Reset() {
	*x = ListClustersRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_vmwareengine_v1_vmwareengine_proto_msgTypes[7]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *ListClustersRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ListClustersRequest) ProtoMessage() {}

func (x *ListClustersRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_vmwareengine_v1_vmwareengine_proto_msgTypes[7]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ListClustersRequest.ProtoReflect.Descriptor instead.
func (*ListClustersRequest) Descriptor() ([]byte, []int) {
	return file_google_cloud_vmwareengine_v1_vmwareengine_proto_rawDescGZIP(), []int{7}
}

func (x *ListClustersRequest) GetParent() string {
	if x != nil {
		return x.Parent
	}
	return ""
}

func (x *ListClustersRequest) GetPageSize() int32 {
	if x != nil {
		return x.PageSize
	}
	return 0
}

func (x *ListClustersRequest) GetPageToken() string {
	if x != nil {
		return x.PageToken
	}
	return ""
}

func (x *ListClustersRequest) GetFilter() string {
	if x != nil {
		return x.Filter
	}
	return ""
}

func (x *ListClustersRequest) GetOrderBy() string {
	if x != nil {
		return x.OrderBy
	}
	return ""
}

// Response message for
// [VmwareEngine.ListClusters][google.cloud.vmwareengine.v1.VmwareEngine.ListClusters]
type ListClustersResponse struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// A list of private cloud clusters.
	Clusters []*Cluster `protobuf:"bytes,1,rep,name=clusters,proto3" json:"clusters,omitempty"`
	// A token, which can be sent as `page_token` to retrieve the next page.
	// If this field is omitted, there are no subsequent pages.
	NextPageToken string `protobuf:"bytes,2,opt,name=next_page_token,json=nextPageToken,proto3" json:"next_page_token,omitempty"`
	// Locations that could not be reached when making an aggregated query using
	// wildcards.
	Unreachable []string `protobuf:"bytes,3,rep,name=unreachable,proto3" json:"unreachable,omitempty"`
}

func (x *ListClustersResponse) Reset() {
	*x = ListClustersResponse{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_vmwareengine_v1_vmwareengine_proto_msgTypes[8]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *ListClustersResponse) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ListClustersResponse) ProtoMessage() {}

func (x *ListClustersResponse) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_vmwareengine_v1_vmwareengine_proto_msgTypes[8]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ListClustersResponse.ProtoReflect.Descriptor instead.
func (*ListClustersResponse) Descriptor() ([]byte, []int) {
	return file_google_cloud_vmwareengine_v1_vmwareengine_proto_rawDescGZIP(), []int{8}
}

func (x *ListClustersResponse) GetClusters() []*Cluster {
	if x != nil {
		return x.Clusters
	}
	return nil
}

func (x *ListClustersResponse) GetNextPageToken() string {
	if x != nil {
		return x.NextPageToken
	}
	return ""
}

func (x *ListClustersResponse) GetUnreachable() []string {
	if x != nil {
		return x.Unreachable
	}
	return nil
}

// Request message for
// [VmwareEngine.GetCluster][google.cloud.vmwareengine.v1.VmwareEngine.GetCluster]
type GetClusterRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. The cluster resource name to retrieve.
	// Resource names are schemeless URIs that follow the conventions in
	// https://cloud.google.com/apis/design/resource_names.
	// For example:
	// `projects/my-project/locations/us-central1-a/privateClouds/my-cloud/clusters/my-cluster`
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
}

func (x *GetClusterRequest) Reset() {
	*x = GetClusterRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_vmwareengine_v1_vmwareengine_proto_msgTypes[9]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *GetClusterRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*GetClusterRequest) ProtoMessage() {}

func (x *GetClusterRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_vmwareengine_v1_vmwareengine_proto_msgTypes[9]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use GetClusterRequest.ProtoReflect.Descriptor instead.
func (*GetClusterRequest) Descriptor() ([]byte, []int) {
	return file_google_cloud_vmwareengine_v1_vmwareengine_proto_rawDescGZIP(), []int{9}
}

func (x *GetClusterRequest) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

// Request message for
// [VmwareEngine.CreateCluster][google.cloud.vmwareengine.v1.VmwareEngine.CreateCluster]
type CreateClusterRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. The resource name of the private cloud to create a new cluster
	// in. Resource names are schemeless URIs that follow the conventions in
	// https://cloud.google.com/apis/design/resource_names.
	// For example:
	// `projects/my-project/locations/us-central1-a/privateClouds/my-cloud`
	Parent string `protobuf:"bytes,1,opt,name=parent,proto3" json:"parent,omitempty"`
	// Required. The user-provided identifier of the new `Cluster`.
	// This identifier must be unique among clusters within the parent and becomes
	// the final token in the name URI.
	// The identifier must meet the following requirements:
	//
	// * Only contains 1-63 alphanumeric characters and hyphens
	// * Begins with an alphabetical character
	// * Ends with a non-hyphen character
	// * Not formatted as a UUID
	// * Complies with [RFC 1034](https://datatracker.ietf.org/doc/html/rfc1034)
	// (section 3.5)
	ClusterId string `protobuf:"bytes,2,opt,name=cluster_id,json=clusterId,proto3" json:"cluster_id,omitempty"`
	// Required. The initial description of the new cluster.
	Cluster *Cluster `protobuf:"bytes,3,opt,name=cluster,proto3" json:"cluster,omitempty"`
	// Optional. The request ID must be a valid UUID with the exception that zero
	// UUID is not supported (00000000-0000-0000-0000-000000000000).
	RequestId string `protobuf:"bytes,4,opt,name=request_id,json=requestId,proto3" json:"request_id,omitempty"`
	// Optional. True if you want the request to be validated and not executed;
	// false otherwise.
	ValidateOnly bool `protobuf:"varint,5,opt,name=validate_only,json=validateOnly,proto3" json:"validate_only,omitempty"`
}

func (x *CreateClusterRequest) Reset() {
	*x = CreateClusterRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_vmwareengine_v1_vmwareengine_proto_msgTypes[10]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *CreateClusterRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*CreateClusterRequest) ProtoMessage() {}

func (x *CreateClusterRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_vmwareengine_v1_vmwareengine_proto_msgTypes[10]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use CreateClusterRequest.ProtoReflect.Descriptor instead.
func (*CreateClusterRequest) Descriptor() ([]byte, []int) {
	return file_google_cloud_vmwareengine_v1_vmwareengine_proto_rawDescGZIP(), []int{10}
}

func (x *CreateClusterRequest) GetParent() string {
	if x != nil {
		return x.Parent
	}
	return ""
}

func (x *CreateClusterRequest) GetClusterId() string {
	if x != nil {
		return x.ClusterId
	}
	return ""
}

func (x *CreateClusterRequest) GetCluster() *Cluster {
	if x != nil {
		return x.Cluster
	}
	return nil
}

func (x *CreateClusterRequest) GetRequestId() string {
	if x != nil {
		return x.RequestId
	}
	return ""
}

func (x *CreateClusterRequest) GetValidateOnly() bool {
	if x != nil {
		return x.ValidateOnly
	}
	return false
}

// Request message for
// [VmwareEngine.UpdateCluster][google.cloud.vmwareengine.v1.VmwareEngine.UpdateCluster]
type UpdateClusterRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. Field mask is used to specify the fields to be overwritten in the
	// `Cluster` resource by the update. The fields specified in the `updateMask`
	// are relative to the resource, not the full request. A field will be
	// overwritten if it is in the mask. If the user does not provide a mask then
	// all fields will be overwritten.
	UpdateMask *fieldmaskpb.FieldMask `protobuf:"bytes,1,opt,name=update_mask,json=updateMask,proto3" json:"update_mask,omitempty"`
	// Required. The description of the cluster.
	Cluster *Cluster `protobuf:"bytes,2,opt,name=cluster,proto3" json:"cluster,omitempty"`
	// Optional. The request ID must be a valid UUID with the exception that
	// zero UUID is not supported (00000000-0000-0000-0000-000000000000).
	RequestId string `protobuf:"bytes,3,opt,name=request_id,json=requestId,proto3" json:"request_id,omitempty"`
	// Optional. True if you want the request to be validated and not executed;
	// false otherwise.
	ValidateOnly bool `protobuf:"varint,4,opt,name=validate_only,json=validateOnly,proto3" json:"validate_only,omitempty"`
}

func (x *UpdateClusterRequest) Reset() {
	*x = UpdateClusterRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_vmwareengine_v1_vmwareengine_proto_msgTypes[11]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *UpdateClusterRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*UpdateClusterRequest) ProtoMessage() {}

func (x *UpdateClusterRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_vmwareengine_v1_vmwareengine_proto_msgTypes[11]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use UpdateClusterRequest.ProtoReflect.Descriptor instead.
func (*UpdateClusterRequest) Descriptor() ([]byte, []int) {
	return file_google_cloud_vmwareengine_v1_vmwareengine_proto_rawDescGZIP(), []int{11}
}

func (x *UpdateClusterRequest) GetUpdateMask() *fieldmaskpb.FieldMask {
	if x != nil {
		return x.UpdateMask
	}
	return nil
}

func (x *UpdateClusterRequest) GetCluster() *Cluster {
	if x != nil {
		return x.Cluster
	}
	return nil
}

func (x *UpdateClusterRequest) GetRequestId() string {
	if x != nil {
		return x.RequestId
	}
	return ""
}

func (x *UpdateClusterRequest) GetValidateOnly() bool {
	if x != nil {
		return x.ValidateOnly
	}
	return false
}

// Request message for
// [VmwareEngine.DeleteCluster][google.cloud.vmwareengine.v1.VmwareEngine.DeleteCluster]
type DeleteClusterRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. The resource name of the cluster to delete.
	// Resource names are schemeless URIs that follow the conventions in
	// https://cloud.google.com/apis/design/resource_names.
	// For example:
	// `projects/my-project/locations/us-central1-a/privateClouds/my-cloud/clusters/my-cluster`
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
	// Optional. The request ID must be a valid UUID with the exception that zero
	// UUID is not supported (00000000-0000-0000-0000-000000000000).
	RequestId string `protobuf:"bytes,2,opt,name=request_id,json=requestId,proto3" json:"request_id,omitempty"`
}

func (x *DeleteClusterRequest) Reset() {
	*x = DeleteClusterRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_vmwareengine_v1_vmwareengine_proto_msgTypes[12]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *DeleteClusterRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*DeleteClusterRequest) ProtoMessage() {}

func (x *DeleteClusterRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_vmwareengine_v1_vmwareengine_proto_msgTypes[12]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use DeleteClusterRequest.ProtoReflect.Descriptor instead.
func (*DeleteClusterRequest) Descriptor() ([]byte, []int) {
	return file_google_cloud_vmwareengine_v1_vmwareengine_proto_rawDescGZIP(), []int{12}
}

func (x *DeleteClusterRequest) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

func (x *DeleteClusterRequest) GetRequestId() string {
	if x != nil {
		return x.RequestId
	}
	return ""
}

// Request message for
// [VmwareEngine.ListSubnets][google.cloud.vmwareengine.v1.VmwareEngine.ListSubnets]
type ListSubnetsRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. The resource name of the private cloud to be queried for
	// subnets.
	// Resource names are schemeless URIs that follow the conventions in
	// https://cloud.google.com/apis/design/resource_names.
	// For example:
	// `projects/my-project/locations/us-central1-a/privateClouds/my-cloud`
	Parent string `protobuf:"bytes,1,opt,name=parent,proto3" json:"parent,omitempty"`
	// The maximum number of subnets to return in one page.
	// The service may return fewer than this value.
	// The maximum value is coerced to 1000.
	// The default value of this field is 500.
	PageSize int32 `protobuf:"varint,2,opt,name=page_size,json=pageSize,proto3" json:"page_size,omitempty"`
	// A page token, received from a previous `ListSubnetsRequest` call.
	// Provide this to retrieve the subsequent page.
	//
	// When paginating, all other parameters provided to
	// `ListSubnetsRequest` must match the call that provided the page token.
	PageToken string `protobuf:"bytes,3,opt,name=page_token,json=pageToken,proto3" json:"page_token,omitempty"`
}

func (x *ListSubnetsRequest) Reset() {
	*x = ListSubnetsRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_vmwareengine_v1_vmwareengine_proto_msgTypes[13]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *ListSubnetsRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ListSubnetsRequest) ProtoMessage() {}

func (x *ListSubnetsRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_vmwareengine_v1_vmwareengine_proto_msgTypes[13]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ListSubnetsRequest.ProtoReflect.Descriptor instead.
func (*ListSubnetsRequest) Descriptor() ([]byte, []int) {
	return file_google_cloud_vmwareengine_v1_vmwareengine_proto_rawDescGZIP(), []int{13}
}

func (x *ListSubnetsRequest) GetParent() string {
	if x != nil {
		return x.Parent
	}
	return ""
}

func (x *ListSubnetsRequest) GetPageSize() int32 {
	if x != nil {
		return x.PageSize
	}
	return 0
}

func (x *ListSubnetsRequest) GetPageToken() string {
	if x != nil {
		return x.PageToken
	}
	return ""
}

// Response message for
// [VmwareEngine.ListSubnets][google.cloud.vmwareengine.v1.VmwareEngine.ListSubnets]
type ListSubnetsResponse struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// A list of subnets.
	Subnets []*Subnet `protobuf:"bytes,1,rep,name=subnets,proto3" json:"subnets,omitempty"`
	// A token, which can be sent as `page_token` to retrieve the next page.
	// If this field is omitted, there are no subsequent pages.
	NextPageToken string `protobuf:"bytes,2,opt,name=next_page_token,json=nextPageToken,proto3" json:"next_page_token,omitempty"`
	// Locations that could not be reached when making an aggregated query using
	// wildcards.
	Unreachable []string `protobuf:"bytes,3,rep,name=unreachable,proto3" json:"unreachable,omitempty"`
}

func (x *ListSubnetsResponse) Reset() {
	*x = ListSubnetsResponse{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_vmwareengine_v1_vmwareengine_proto_msgTypes[14]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *ListSubnetsResponse) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ListSubnetsResponse) ProtoMessage() {}

func (x *ListSubnetsResponse) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_vmwareengine_v1_vmwareengine_proto_msgTypes[14]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ListSubnetsResponse.ProtoReflect.Descriptor instead.
func (*ListSubnetsResponse) Descriptor() ([]byte, []int) {
	return file_google_cloud_vmwareengine_v1_vmwareengine_proto_rawDescGZIP(), []int{14}
}

func (x *ListSubnetsResponse) GetSubnets() []*Subnet {
	if x != nil {
		return x.Subnets
	}
	return nil
}

func (x *ListSubnetsResponse) GetNextPageToken() string {
	if x != nil {
		return x.NextPageToken
	}
	return ""
}

func (x *ListSubnetsResponse) GetUnreachable() []string {
	if x != nil {
		return x.Unreachable
	}
	return nil
}

// Request message for
// [VmwareEngine.GetSubnet][google.cloud.vmwareengine.v1.VmwareEngine.GetSubnet]
type GetSubnetRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. The resource name of the subnet to retrieve.
	// Resource names are schemeless URIs that follow the conventions in
	// https://cloud.google.com/apis/design/resource_names.
	// For example:
	// `projects/my-project/locations/us-central1-a/privateClouds/my-cloud/subnets/my-subnet`
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
}

func (x *GetSubnetRequest) Reset() {
	*x = GetSubnetRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_vmwareengine_v1_vmwareengine_proto_msgTypes[15]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *GetSubnetRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*GetSubnetRequest) ProtoMessage() {}

func (x *GetSubnetRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_vmwareengine_v1_vmwareengine_proto_msgTypes[15]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use GetSubnetRequest.ProtoReflect.Descriptor instead.
func (*GetSubnetRequest) Descriptor() ([]byte, []int) {
	return file_google_cloud_vmwareengine_v1_vmwareengine_proto_rawDescGZIP(), []int{15}
}

func (x *GetSubnetRequest) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

// Request message for
// [VmwareEngine.UpdateSubnet][google.cloud.vmwareengine.v1.VmwareEngine.UpdateSubnet]
type UpdateSubnetRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. Field mask is used to specify the fields to be overwritten in the
	// `Subnet` resource by the update.
	// The fields specified in the `update_mask` are relative to the resource, not
	// the full request. A field will be overwritten if it is in the mask. If the
	// user does not provide a mask then all fields will be overwritten.
	UpdateMask *fieldmaskpb.FieldMask `protobuf:"bytes,1,opt,name=update_mask,json=updateMask,proto3" json:"update_mask,omitempty"`
	// Required. Subnet description.
	Subnet *Subnet `protobuf:"bytes,2,opt,name=subnet,proto3" json:"subnet,omitempty"`
}

func (x *UpdateSubnetRequest) Reset() {
	*x = UpdateSubnetRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_vmwareengine_v1_vmwareengine_proto_msgTypes[16]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *UpdateSubnetRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*UpdateSubnetRequest) ProtoMessage() {}

func (x *UpdateSubnetRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_vmwareengine_v1_vmwareengine_proto_msgTypes[16]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use UpdateSubnetRequest.ProtoReflect.Descriptor instead.
func (*UpdateSubnetRequest) Descriptor() ([]byte, []int) {
	return file_google_cloud_vmwareengine_v1_vmwareengine_proto_rawDescGZIP(), []int{16}
}

func (x *UpdateSubnetRequest) GetUpdateMask() *fieldmaskpb.FieldMask {
	if x != nil {
		return x.UpdateMask
	}
	return nil
}

func (x *UpdateSubnetRequest) GetSubnet() *Subnet {
	if x != nil {
		return x.Subnet
	}
	return nil
}

// Represents the metadata of the long-running operation.
type OperationMetadata struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Output only. The time the operation was created.
	CreateTime *timestamppb.Timestamp `protobuf:"bytes,1,opt,name=create_time,json=createTime,proto3" json:"create_time,omitempty"`
	// Output only. The time the operation finished running.
	EndTime *timestamppb.Timestamp `protobuf:"bytes,2,opt,name=end_time,json=endTime,proto3" json:"end_time,omitempty"`
	// Output only. Server-defined resource path for the target of the operation.
	Target string `protobuf:"bytes,3,opt,name=target,proto3" json:"target,omitempty"`
	// Output only. Name of the verb executed by the operation.
	Verb string `protobuf:"bytes,4,opt,name=verb,proto3" json:"verb,omitempty"`
	// Output only. Human-readable status of the operation, if any.
	StatusMessage string `protobuf:"bytes,5,opt,name=status_message,json=statusMessage,proto3" json:"status_message,omitempty"`
	// Output only. True if the user has requested cancellation
	// of the operation; false otherwise.
	// Operations that have successfully been cancelled
	// have [Operation.error][] value with a
	// [google.rpc.Status.code][google.rpc.Status.code] of 1, corresponding to
	// `Code.CANCELLED`.
	RequestedCancellation bool `protobuf:"varint,6,opt,name=requested_cancellation,json=requestedCancellation,proto3" json:"requested_cancellation,omitempty"`
	// Output only. API version used to start the operation.
	ApiVersion string `protobuf:"bytes,7,opt,name=api_version,json=apiVersion,proto3" json:"api_version,omitempty"`
}

func (x *OperationMetadata) Reset() {
	*x = OperationMetadata{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_vmwareengine_v1_vmwareengine_proto_msgTypes[17]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *OperationMetadata) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*OperationMetadata) ProtoMessage() {}

func (x *OperationMetadata) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_vmwareengine_v1_vmwareengine_proto_msgTypes[17]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use OperationMetadata.ProtoReflect.Descriptor instead.
func (*OperationMetadata) Descriptor() ([]byte, []int) {
	return file_google_cloud_vmwareengine_v1_vmwareengine_proto_rawDescGZIP(), []int{17}
}

func (x *OperationMetadata) GetCreateTime() *timestamppb.Timestamp {
	if x != nil {
		return x.CreateTime
	}
	return nil
}

func (x *OperationMetadata) GetEndTime() *timestamppb.Timestamp {
	if x != nil {
		return x.EndTime
	}
	return nil
}

func (x *OperationMetadata) GetTarget() string {
	if x != nil {
		return x.Target
	}
	return ""
}

func (x *OperationMetadata) GetVerb() string {
	if x != nil {
		return x.Verb
	}
	return ""
}

func (x *OperationMetadata) GetStatusMessage() string {
	if x != nil {
		return x.StatusMessage
	}
	return ""
}

func (x *OperationMetadata) GetRequestedCancellation() bool {
	if x != nil {
		return x.RequestedCancellation
	}
	return false
}

func (x *OperationMetadata) GetApiVersion() string {
	if x != nil {
		return x.ApiVersion
	}
	return ""
}

// Request message for
// [VmwareEngine.ListNodeTypes][google.cloud.vmwareengine.v1.VmwareEngine.ListNodeTypes]
type ListNodeTypesRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. The resource name of the location to be queried for node types.
	// Resource names are schemeless URIs that follow the conventions in
	// https://cloud.google.com/apis/design/resource_names.
	// For example:
	// `projects/my-project/locations/us-central1-a`
	Parent string `protobuf:"bytes,1,opt,name=parent,proto3" json:"parent,omitempty"`
	// The maximum number of node types to return in one page.
	// The service may return fewer than this value.
	// The maximum value is coerced to 1000.
	// The default value of this field is 500.
	PageSize int32 `protobuf:"varint,2,opt,name=page_size,json=pageSize,proto3" json:"page_size,omitempty"`
	// A page token, received from a previous `ListNodeTypes` call.
	// Provide this to retrieve the subsequent page.
	//
	// When paginating, all other parameters provided to
	// `ListNodeTypes` must match the call that provided the page token.
	PageToken string `protobuf:"bytes,3,opt,name=page_token,json=pageToken,proto3" json:"page_token,omitempty"`
	// A filter expression that matches resources returned in the response.
	// The expression must specify the field name, a comparison
	// operator, and the value that you want to use for filtering. The value
	// must be a string, a number, or a boolean. The comparison operator
	// must be `=`, `!=`, `>`, or `<`.
	//
	// For example, if you are filtering a list of node types, you can
	// exclude the ones named `standard-72` by specifying
	// `name != "standard-72"`.
	//
	// To filter on multiple expressions, provide each separate expression within
	// parentheses. For example:
	// ```
	// (name = "standard-72")
	// (virtual_cpu_count > 2)
	// ```
	//
	// By default, each expression is an `AND` expression. However, you
	// can include `AND` and `OR` expressions explicitly.
	// For example:
	// ```
	// (name = "standard-96") AND
	// (virtual_cpu_count > 2) OR
	// (name = "standard-72")
	// ```
	Filter string `protobuf:"bytes,4,opt,name=filter,proto3" json:"filter,omitempty"`
}

func (x *ListNodeTypesRequest) Reset() {
	*x = ListNodeTypesRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_vmwareengine_v1_vmwareengine_proto_msgTypes[18]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *ListNodeTypesRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ListNodeTypesRequest) ProtoMessage() {}

func (x *ListNodeTypesRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_vmwareengine_v1_vmwareengine_proto_msgTypes[18]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ListNodeTypesRequest.ProtoReflect.Descriptor instead.
func (*ListNodeTypesRequest) Descriptor() ([]byte, []int) {
	return file_google_cloud_vmwareengine_v1_vmwareengine_proto_rawDescGZIP(), []int{18}
}

func (x *ListNodeTypesRequest) GetParent() string {
	if x != nil {
		return x.Parent
	}
	return ""
}

func (x *ListNodeTypesRequest) GetPageSize() int32 {
	if x != nil {
		return x.PageSize
	}
	return 0
}

func (x *ListNodeTypesRequest) GetPageToken() string {
	if x != nil {
		return x.PageToken
	}
	return ""
}

func (x *ListNodeTypesRequest) GetFilter() string {
	if x != nil {
		return x.Filter
	}
	return ""
}

// Response message for
// [VmwareEngine.ListNodeTypes][google.cloud.vmwareengine.v1.VmwareEngine.ListNodeTypes]
type ListNodeTypesResponse struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// A list of Node Types.
	NodeTypes []*NodeType `protobuf:"bytes,1,rep,name=node_types,json=nodeTypes,proto3" json:"node_types,omitempty"`
	// A token, which can be sent as `page_token` to retrieve the next page.
	// If this field is omitted, there are no subsequent pages.
	NextPageToken string `protobuf:"bytes,2,opt,name=next_page_token,json=nextPageToken,proto3" json:"next_page_token,omitempty"`
	// Locations that could not be reached when making an aggregated query using
	// wildcards.
	Unreachable []string `protobuf:"bytes,3,rep,name=unreachable,proto3" json:"unreachable,omitempty"`
}

func (x *ListNodeTypesResponse) Reset() {
	*x = ListNodeTypesResponse{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_vmwareengine_v1_vmwareengine_proto_msgTypes[19]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *ListNodeTypesResponse) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ListNodeTypesResponse) ProtoMessage() {}

func (x *ListNodeTypesResponse) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_vmwareengine_v1_vmwareengine_proto_msgTypes[19]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ListNodeTypesResponse.ProtoReflect.Descriptor instead.
func (*ListNodeTypesResponse) Descriptor() ([]byte, []int) {
	return file_google_cloud_vmwareengine_v1_vmwareengine_proto_rawDescGZIP(), []int{19}
}

func (x *ListNodeTypesResponse) GetNodeTypes() []*NodeType {
	if x != nil {
		return x.NodeTypes
	}
	return nil
}

func (x *ListNodeTypesResponse) GetNextPageToken() string {
	if x != nil {
		return x.NextPageToken
	}
	return ""
}

func (x *ListNodeTypesResponse) GetUnreachable() []string {
	if x != nil {
		return x.Unreachable
	}
	return nil
}

// Request message for
// [VmwareEngine.GetNodeType][google.cloud.vmwareengine.v1.VmwareEngine.GetNodeType]
type GetNodeTypeRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. The resource name of the node type to retrieve.
	// Resource names are schemeless URIs that follow the conventions in
	// https://cloud.google.com/apis/design/resource_names.
	// For example:
	// `projects/my-proj/locations/us-central1-a/nodeTypes/standard-72`
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
}

func (x *GetNodeTypeRequest) Reset() {
	*x = GetNodeTypeRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_vmwareengine_v1_vmwareengine_proto_msgTypes[20]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *GetNodeTypeRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*GetNodeTypeRequest) ProtoMessage() {}

func (x *GetNodeTypeRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_vmwareengine_v1_vmwareengine_proto_msgTypes[20]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use GetNodeTypeRequest.ProtoReflect.Descriptor instead.
func (*GetNodeTypeRequest) Descriptor() ([]byte, []int) {
	return file_google_cloud_vmwareengine_v1_vmwareengine_proto_rawDescGZIP(), []int{20}
}

func (x *GetNodeTypeRequest) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

// Request message for
// [VmwareEngine.ShowNsxCredentials][google.cloud.vmwareengine.v1.VmwareEngine.ShowNsxCredentials]
type ShowNsxCredentialsRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. The resource name of the private cloud
	// to be queried for credentials.
	// Resource names are schemeless URIs that follow the conventions in
	// https://cloud.google.com/apis/design/resource_names.
	// For example:
	// `projects/my-project/locations/us-central1-a/privateClouds/my-cloud`
	PrivateCloud string `protobuf:"bytes,1,opt,name=private_cloud,json=privateCloud,proto3" json:"private_cloud,omitempty"`
}

func (x *ShowNsxCredentialsRequest) Reset() {
	*x = ShowNsxCredentialsRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_vmwareengine_v1_vmwareengine_proto_msgTypes[21]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *ShowNsxCredentialsRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ShowNsxCredentialsRequest) ProtoMessage() {}

func (x *ShowNsxCredentialsRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_vmwareengine_v1_vmwareengine_proto_msgTypes[21]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ShowNsxCredentialsRequest.ProtoReflect.Descriptor instead.
func (*ShowNsxCredentialsRequest) Descriptor() ([]byte, []int) {
	return file_google_cloud_vmwareengine_v1_vmwareengine_proto_rawDescGZIP(), []int{21}
}

func (x *ShowNsxCredentialsRequest) GetPrivateCloud() string {
	if x != nil {
		return x.PrivateCloud
	}
	return ""
}

// Request message for
// [VmwareEngine.ShowVcenterCredentials][google.cloud.vmwareengine.v1.VmwareEngine.ShowVcenterCredentials]
type ShowVcenterCredentialsRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. The resource name of the private cloud
	// to be queried for credentials.
	// Resource names are schemeless URIs that follow the conventions in
	// https://cloud.google.com/apis/design/resource_names.
	// For example:
	// `projects/my-project/locations/us-central1-a/privateClouds/my-cloud`
	PrivateCloud string `protobuf:"bytes,1,opt,name=private_cloud,json=privateCloud,proto3" json:"private_cloud,omitempty"`
}

func (x *ShowVcenterCredentialsRequest) Reset() {
	*x = ShowVcenterCredentialsRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_vmwareengine_v1_vmwareengine_proto_msgTypes[22]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *ShowVcenterCredentialsRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ShowVcenterCredentialsRequest) ProtoMessage() {}

func (x *ShowVcenterCredentialsRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_vmwareengine_v1_vmwareengine_proto_msgTypes[22]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ShowVcenterCredentialsRequest.ProtoReflect.Descriptor instead.
func (*ShowVcenterCredentialsRequest) Descriptor() ([]byte, []int) {
	return file_google_cloud_vmwareengine_v1_vmwareengine_proto_rawDescGZIP(), []int{22}
}

func (x *ShowVcenterCredentialsRequest) GetPrivateCloud() string {
	if x != nil {
		return x.PrivateCloud
	}
	return ""
}

// Request message for
// [VmwareEngine.ResetNsxCredentials][google.cloud.vmwareengine.v1.VmwareEngine.ResetNsxCredentials]
type ResetNsxCredentialsRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. The resource name of the private cloud
	// to reset credentials for.
	// Resource names are schemeless URIs that follow the conventions in
	// https://cloud.google.com/apis/design/resource_names.
	// For example:
	// `projects/my-project/locations/us-central1-a/privateClouds/my-cloud`
	PrivateCloud string `protobuf:"bytes,1,opt,name=private_cloud,json=privateCloud,proto3" json:"private_cloud,omitempty"`
	// Optional. A request ID to identify requests. Specify a unique request ID
	// so that if you must retry your request, the server will know to ignore
	// the request if it has already been completed. The server guarantees that a
	// request doesn't result in creation of duplicate commitments for at least 60
	// minutes.
	//
	// For example, consider a situation where you make an initial request and the
	// request times out. If you make the request again with the same request
	// ID, the server can check if original operation with the same request ID
	// was received, and if so, will ignore the second request. This prevents
	// clients from accidentally creating duplicate commitments.
	//
	// The request ID must be a valid UUID with the exception that zero UUID is
	// not supported (00000000-0000-0000-0000-000000000000).
	RequestId string `protobuf:"bytes,2,opt,name=request_id,json=requestId,proto3" json:"request_id,omitempty"`
}

func (x *ResetNsxCredentialsRequest) Reset() {
	*x = ResetNsxCredentialsRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_vmwareengine_v1_vmwareengine_proto_msgTypes[23]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *ResetNsxCredentialsRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ResetNsxCredentialsRequest) ProtoMessage() {}

func (x *ResetNsxCredentialsRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_vmwareengine_v1_vmwareengine_proto_msgTypes[23]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ResetNsxCredentialsRequest.ProtoReflect.Descriptor instead.
func (*ResetNsxCredentialsRequest) Descriptor() ([]byte, []int) {
	return file_google_cloud_vmwareengine_v1_vmwareengine_proto_rawDescGZIP(), []int{23}
}

func (x *ResetNsxCredentialsRequest) GetPrivateCloud() string {
	if x != nil {
		return x.PrivateCloud
	}
	return ""
}

func (x *ResetNsxCredentialsRequest) GetRequestId() string {
	if x != nil {
		return x.RequestId
	}
	return ""
}

// Request message for
// [VmwareEngine.ResetVcenterCredentials][google.cloud.vmwareengine.v1.VmwareEngine.ResetVcenterCredentials]
type ResetVcenterCredentialsRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. The resource name of the private cloud
	// to reset credentials for.
	// Resource names are schemeless URIs that follow the conventions in
	// https://cloud.google.com/apis/design/resource_names.
	// For example:
	// `projects/my-project/locations/us-central1-a/privateClouds/my-cloud`
	PrivateCloud string `protobuf:"bytes,1,opt,name=private_cloud,json=privateCloud,proto3" json:"private_cloud,omitempty"`
	// Optional. A request ID to identify requests. Specify a unique request ID
	// so that if you must retry your request, the server will know to ignore
	// the request if it has already been completed. The server guarantees that a
	// request doesn't result in creation of duplicate commitments for at least 60
	// minutes.
	//
	// For example, consider a situation where you make an initial request and the
	// request times out. If you make the request again with the same request
	// ID, the server can check if original operation with the same request ID
	// was received, and if so, will ignore the second request. This prevents
	// clients from accidentally creating duplicate commitments.
	//
	// The request ID must be a valid UUID with the exception that zero UUID is
	// not supported (00000000-0000-0000-0000-000000000000).
	RequestId string `protobuf:"bytes,2,opt,name=request_id,json=requestId,proto3" json:"request_id,omitempty"`
}

func (x *ResetVcenterCredentialsRequest) Reset() {
	*x = ResetVcenterCredentialsRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_vmwareengine_v1_vmwareengine_proto_msgTypes[24]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *ResetVcenterCredentialsRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ResetVcenterCredentialsRequest) ProtoMessage() {}

func (x *ResetVcenterCredentialsRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_vmwareengine_v1_vmwareengine_proto_msgTypes[24]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ResetVcenterCredentialsRequest.ProtoReflect.Descriptor instead.
func (*ResetVcenterCredentialsRequest) Descriptor() ([]byte, []int) {
	return file_google_cloud_vmwareengine_v1_vmwareengine_proto_rawDescGZIP(), []int{24}
}

func (x *ResetVcenterCredentialsRequest) GetPrivateCloud() string {
	if x != nil {
		return x.PrivateCloud
	}
	return ""
}

func (x *ResetVcenterCredentialsRequest) GetRequestId() string {
	if x != nil {
		return x.RequestId
	}
	return ""
}

// Response message for
// [VmwareEngine.ListHcxActivationKeys][google.cloud.vmwareengine.v1.VmwareEngine.ListHcxActivationKeys]
type ListHcxActivationKeysResponse struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// List of HCX activation keys.
	HcxActivationKeys []*HcxActivationKey `protobuf:"bytes,1,rep,name=hcx_activation_keys,json=hcxActivationKeys,proto3" json:"hcx_activation_keys,omitempty"`
	// A token, which can be sent as `page_token` to retrieve the next page.
	// If this field is omitted, there are no subsequent pages.
	NextPageToken string `protobuf:"bytes,2,opt,name=next_page_token,json=nextPageToken,proto3" json:"next_page_token,omitempty"`
	// Locations that could not be reached when making an aggregated query using
	// wildcards.
	Unreachable []string `protobuf:"bytes,3,rep,name=unreachable,proto3" json:"unreachable,omitempty"`
}

func (x *ListHcxActivationKeysResponse) Reset() {
	*x = ListHcxActivationKeysResponse{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_vmwareengine_v1_vmwareengine_proto_msgTypes[25]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *ListHcxActivationKeysResponse) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ListHcxActivationKeysResponse) ProtoMessage() {}

func (x *ListHcxActivationKeysResponse) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_vmwareengine_v1_vmwareengine_proto_msgTypes[25]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ListHcxActivationKeysResponse.ProtoReflect.Descriptor instead.
func (*ListHcxActivationKeysResponse) Descriptor() ([]byte, []int) {
	return file_google_cloud_vmwareengine_v1_vmwareengine_proto_rawDescGZIP(), []int{25}
}

func (x *ListHcxActivationKeysResponse) GetHcxActivationKeys() []*HcxActivationKey {
	if x != nil {
		return x.HcxActivationKeys
	}
	return nil
}

func (x *ListHcxActivationKeysResponse) GetNextPageToken() string {
	if x != nil {
		return x.NextPageToken
	}
	return ""
}

func (x *ListHcxActivationKeysResponse) GetUnreachable() []string {
	if x != nil {
		return x.Unreachable
	}
	return nil
}

// Request message for
// [VmwareEngine.ListHcxActivationKeys][google.cloud.vmwareengine.v1.VmwareEngine.ListHcxActivationKeys]
type ListHcxActivationKeysRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. The resource name of the private cloud
	// to be queried for HCX activation keys.
	// Resource names are schemeless URIs that follow the conventions in
	// https://cloud.google.com/apis/design/resource_names.
	// For example:
	// `projects/my-project/locations/us-central1/privateClouds/my-cloud`
	Parent string `protobuf:"bytes,1,opt,name=parent,proto3" json:"parent,omitempty"`
	// The maximum number of HCX activation keys to return in one page.
	// The service may return fewer than this value.
	// The maximum value is coerced to 1000.
	// The default value of this field is 500.
	PageSize int32 `protobuf:"varint,2,opt,name=page_size,json=pageSize,proto3" json:"page_size,omitempty"`
	// A page token, received from a previous `ListHcxActivationKeys` call.
	// Provide this to retrieve the subsequent page.
	//
	// When paginating, all other parameters provided to
	// `ListHcxActivationKeys` must match the call that provided the page
	// token.
	PageToken string `protobuf:"bytes,3,opt,name=page_token,json=pageToken,proto3" json:"page_token,omitempty"`
}

func (x *ListHcxActivationKeysRequest) Reset() {
	*x = ListHcxActivationKeysRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_vmwareengine_v1_vmwareengine_proto_msgTypes[26]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *ListHcxActivationKeysRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ListHcxActivationKeysRequest) ProtoMessage() {}

func (x *ListHcxActivationKeysRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_vmwareengine_v1_vmwareengine_proto_msgTypes[26]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ListHcxActivationKeysRequest.ProtoReflect.Descriptor instead.
func (*ListHcxActivationKeysRequest) Descriptor() ([]byte, []int) {
	return file_google_cloud_vmwareengine_v1_vmwareengine_proto_rawDescGZIP(), []int{26}
}

func (x *ListHcxActivationKeysRequest) GetParent() string {
	if x != nil {
		return x.Parent
	}
	return ""
}

func (x *ListHcxActivationKeysRequest) GetPageSize() int32 {
	if x != nil {
		return x.PageSize
	}
	return 0
}

func (x *ListHcxActivationKeysRequest) GetPageToken() string {
	if x != nil {
		return x.PageToken
	}
	return ""
}

// Request message for [VmwareEngine.GetHcxActivationKeys][]
type GetHcxActivationKeyRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. The resource name of the HCX activation key to retrieve.
	// Resource names are schemeless URIs that follow the conventions in
	// https://cloud.google.com/apis/design/resource_names.
	// For example:
	// `projects/my-project/locations/us-central1/privateClouds/my-cloud/hcxActivationKeys/my-key`
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
}

func (x *GetHcxActivationKeyRequest) Reset() {
	*x = GetHcxActivationKeyRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_vmwareengine_v1_vmwareengine_proto_msgTypes[27]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *GetHcxActivationKeyRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*GetHcxActivationKeyRequest) ProtoMessage() {}

func (x *GetHcxActivationKeyRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_vmwareengine_v1_vmwareengine_proto_msgTypes[27]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use GetHcxActivationKeyRequest.ProtoReflect.Descriptor instead.
func (*GetHcxActivationKeyRequest) Descriptor() ([]byte, []int) {
	return file_google_cloud_vmwareengine_v1_vmwareengine_proto_rawDescGZIP(), []int{27}
}

func (x *GetHcxActivationKeyRequest) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

// Request message for
// [VmwareEngine.CreateHcxActivationKey][google.cloud.vmwareengine.v1.VmwareEngine.CreateHcxActivationKey]
type CreateHcxActivationKeyRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. The resource name of the private cloud to create the key for.
	// Resource names are schemeless URIs that follow the conventions in
	// https://cloud.google.com/apis/design/resource_names.
	// For example:
	// `projects/my-project/locations/us-central1/privateClouds/my-cloud`
	Parent string `protobuf:"bytes,1,opt,name=parent,proto3" json:"parent,omitempty"`
	// Required. The initial description of a new HCX activation key. When
	// creating a new key, this field must be an empty object.
	HcxActivationKey *HcxActivationKey `protobuf:"bytes,2,opt,name=hcx_activation_key,json=hcxActivationKey,proto3" json:"hcx_activation_key,omitempty"`
	// Required. The user-provided identifier of the `HcxActivationKey` to be
	// created. This identifier must be unique among `HcxActivationKey` resources
	// within the parent and becomes the final token in the name URI.
	// The identifier must meet the following requirements:
	//
	// * Only contains 1-63 alphanumeric characters and hyphens
	// * Begins with an alphabetical character
	// * Ends with a non-hyphen character
	// * Not formatted as a UUID
	// * Complies with [RFC 1034](https://datatracker.ietf.org/doc/html/rfc1034)
	// (section 3.5)
	HcxActivationKeyId string `protobuf:"bytes,3,opt,name=hcx_activation_key_id,json=hcxActivationKeyId,proto3" json:"hcx_activation_key_id,omitempty"`
	// A request ID to identify requests. Specify a unique request ID
	// so that if you must retry your request, the server will know to ignore
	// the request if it has already been completed. The server guarantees that a
	// request doesn't result in creation of duplicate commitments for at least 60
	// minutes.
	//
	// For example, consider a situation where you make an initial request and the
	// request times out. If you make the request again with the same request ID,
	// the server can check if original operation with the same request ID was
	// received, and if so, will ignore the second request. This prevents clients
	// from accidentally creating duplicate commitments.
	//
	// The request ID must be a valid UUID with the exception that zero UUID is
	// not supported (00000000-0000-0000-0000-000000000000).
	RequestId string `protobuf:"bytes,4,opt,name=request_id,json=requestId,proto3" json:"request_id,omitempty"`
}

func (x *CreateHcxActivationKeyRequest) Reset() {
	*x = CreateHcxActivationKeyRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_vmwareengine_v1_vmwareengine_proto_msgTypes[28]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *CreateHcxActivationKeyRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*CreateHcxActivationKeyRequest) ProtoMessage() {}

func (x *CreateHcxActivationKeyRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_vmwareengine_v1_vmwareengine_proto_msgTypes[28]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use CreateHcxActivationKeyRequest.ProtoReflect.Descriptor instead.
func (*CreateHcxActivationKeyRequest) Descriptor() ([]byte, []int) {
	return file_google_cloud_vmwareengine_v1_vmwareengine_proto_rawDescGZIP(), []int{28}
}

func (x *CreateHcxActivationKeyRequest) GetParent() string {
	if x != nil {
		return x.Parent
	}
	return ""
}

func (x *CreateHcxActivationKeyRequest) GetHcxActivationKey() *HcxActivationKey {
	if x != nil {
		return x.HcxActivationKey
	}
	return nil
}

func (x *CreateHcxActivationKeyRequest) GetHcxActivationKeyId() string {
	if x != nil {
		return x.HcxActivationKeyId
	}
	return ""
}

func (x *CreateHcxActivationKeyRequest) GetRequestId() string {
	if x != nil {
		return x.RequestId
	}
	return ""
}

// Request message for
// [VmwareEngine.ListNetworkPolicies][google.cloud.vmwareengine.v1.VmwareEngine.ListNetworkPolicies]
type ListNetworkPoliciesRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. The resource name of the location (region) to query for
	// network policies. Resource names are schemeless URIs that follow the
	// conventions in https://cloud.google.com/apis/design/resource_names. For
	// example: `projects/my-project/locations/us-central1`
	Parent string `protobuf:"bytes,1,opt,name=parent,proto3" json:"parent,omitempty"`
	// The maximum number of network policies to return in one page.
	// The service may return fewer than this value.
	// The maximum value is coerced to 1000.
	// The default value of this field is 500.
	PageSize int32 `protobuf:"varint,2,opt,name=page_size,json=pageSize,proto3" json:"page_size,omitempty"`
	// A page token, received from a previous `ListNetworkPolicies` call.
	// Provide this to retrieve the subsequent page.
	//
	// When paginating, all other parameters provided to
	// `ListNetworkPolicies` must match the call that provided the page
	// token.
	PageToken string `protobuf:"bytes,3,opt,name=page_token,json=pageToken,proto3" json:"page_token,omitempty"`
	// A filter expression that matches resources returned in the response.
	// The expression must specify the field name, a comparison
	// operator, and the value that you want to use for filtering. The value
	// must be a string, a number, or a boolean. The comparison operator
	// must be `=`, `!=`, `>`, or `<`.
	//
	// For example, if you are filtering a list of network policies, you can
	// exclude the ones named `example-policy` by specifying
	// `name != "example-policy"`.
	//
	// To filter on multiple expressions, provide each separate expression within
	// parentheses. For example:
	// ```
	// (name = "example-policy")
	// (createTime > "2021-04-12T08:15:10.40Z")
	// ```
	//
	// By default, each expression is an `AND` expression. However, you
	// can include `AND` and `OR` expressions explicitly.
	// For example:
	// ```
	// (name = "example-policy-1") AND
	// (createTime > "2021-04-12T08:15:10.40Z") OR
	// (name = "example-policy-2")
	// ```
	Filter string `protobuf:"bytes,4,opt,name=filter,proto3" json:"filter,omitempty"`
	// Sorts list results by a certain order. By default, returned results
	// are ordered by `name` in ascending order.
	// You can also sort results in descending order based on the `name` value
	// using `orderBy="name desc"`.
	// Currently, only ordering by `name` is supported.
	OrderBy string `protobuf:"bytes,5,opt,name=order_by,json=orderBy,proto3" json:"order_by,omitempty"`
}

func (x *ListNetworkPoliciesRequest) Reset() {
	*x = ListNetworkPoliciesRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_vmwareengine_v1_vmwareengine_proto_msgTypes[29]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *ListNetworkPoliciesRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ListNetworkPoliciesRequest) ProtoMessage() {}

func (x *ListNetworkPoliciesRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_vmwareengine_v1_vmwareengine_proto_msgTypes[29]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ListNetworkPoliciesRequest.ProtoReflect.Descriptor instead.
func (*ListNetworkPoliciesRequest) Descriptor() ([]byte, []int) {
	return file_google_cloud_vmwareengine_v1_vmwareengine_proto_rawDescGZIP(), []int{29}
}

func (x *ListNetworkPoliciesRequest) GetParent() string {
	if x != nil {
		return x.Parent
	}
	return ""
}

func (x *ListNetworkPoliciesRequest) GetPageSize() int32 {
	if x != nil {
		return x.PageSize
	}
	return 0
}

func (x *ListNetworkPoliciesRequest) GetPageToken() string {
	if x != nil {
		return x.PageToken
	}
	return ""
}

func (x *ListNetworkPoliciesRequest) GetFilter() string {
	if x != nil {
		return x.Filter
	}
	return ""
}

func (x *ListNetworkPoliciesRequest) GetOrderBy() string {
	if x != nil {
		return x.OrderBy
	}
	return ""
}

// Response message for
// [VmwareEngine.ListNetworkPolicies][google.cloud.vmwareengine.v1.VmwareEngine.ListNetworkPolicies]
type ListNetworkPoliciesResponse struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// A list of network policies.
	NetworkPolicies []*NetworkPolicy `protobuf:"bytes,1,rep,name=network_policies,json=networkPolicies,proto3" json:"network_policies,omitempty"`
	// A token, which can be send as `page_token` to retrieve the next page.
	// If this field is omitted, there are no subsequent pages.
	NextPageToken string `protobuf:"bytes,2,opt,name=next_page_token,json=nextPageToken,proto3" json:"next_page_token,omitempty"`
	// Locations that could not be reached when making an aggregated query using
	// wildcards.
	Unreachable []string `protobuf:"bytes,3,rep,name=unreachable,proto3" json:"unreachable,omitempty"`
}

func (x *ListNetworkPoliciesResponse) Reset() {
	*x = ListNetworkPoliciesResponse{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_vmwareengine_v1_vmwareengine_proto_msgTypes[30]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *ListNetworkPoliciesResponse) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ListNetworkPoliciesResponse) ProtoMessage() {}

func (x *ListNetworkPoliciesResponse) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_vmwareengine_v1_vmwareengine_proto_msgTypes[30]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ListNetworkPoliciesResponse.ProtoReflect.Descriptor instead.
func (*ListNetworkPoliciesResponse) Descriptor() ([]byte, []int) {
	return file_google_cloud_vmwareengine_v1_vmwareengine_proto_rawDescGZIP(), []int{30}
}

func (x *ListNetworkPoliciesResponse) GetNetworkPolicies() []*NetworkPolicy {
	if x != nil {
		return x.NetworkPolicies
	}
	return nil
}

func (x *ListNetworkPoliciesResponse) GetNextPageToken() string {
	if x != nil {
		return x.NextPageToken
	}
	return ""
}

func (x *ListNetworkPoliciesResponse) GetUnreachable() []string {
	if x != nil {
		return x.Unreachable
	}
	return nil
}

// Request message for
// [VmwareEngine.GetNetworkPolicy][google.cloud.vmwareengine.v1.VmwareEngine.GetNetworkPolicy]
type GetNetworkPolicyRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. The resource name of the network policy to retrieve.
	// Resource names are schemeless URIs that follow the conventions in
	// https://cloud.google.com/apis/design/resource_names.
	// For example:
	// `projects/my-project/locations/us-central1/networkPolicies/my-network-policy`
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
}

func (x *GetNetworkPolicyRequest) Reset() {
	*x = GetNetworkPolicyRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_vmwareengine_v1_vmwareengine_proto_msgTypes[31]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *GetNetworkPolicyRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*GetNetworkPolicyRequest) ProtoMessage() {}

func (x *GetNetworkPolicyRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_vmwareengine_v1_vmwareengine_proto_msgTypes[31]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use GetNetworkPolicyRequest.ProtoReflect.Descriptor instead.
func (*GetNetworkPolicyRequest) Descriptor() ([]byte, []int) {
	return file_google_cloud_vmwareengine_v1_vmwareengine_proto_rawDescGZIP(), []int{31}
}

func (x *GetNetworkPolicyRequest) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

// Request message for
// [VmwareEngine.UpdateNetworkPolicy][google.cloud.vmwareengine.v1.VmwareEngine.UpdateNetworkPolicy]
type UpdateNetworkPolicyRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. Network policy description.
	NetworkPolicy *NetworkPolicy `protobuf:"bytes,1,opt,name=network_policy,json=networkPolicy,proto3" json:"network_policy,omitempty"`
	// Required. Field mask is used to specify the fields to be overwritten in the
	// `NetworkPolicy` resource by the update.
	// The fields specified in the `update_mask` are relative to the resource, not
	// the full request. A field will be overwritten if it is in the mask. If the
	// user does not provide a mask then all fields will be overwritten.
	UpdateMask *fieldmaskpb.FieldMask `protobuf:"bytes,2,opt,name=update_mask,json=updateMask,proto3" json:"update_mask,omitempty"`
	// Optional. A request ID to identify requests. Specify a unique request ID
	// so that if you must retry your request, the server will know to ignore
	// the request if it has already been completed. The server guarantees that a
	// request doesn't result in creation of duplicate commitments for at least 60
	// minutes.
	//
	// For example, consider a situation where you make an initial request and the
	// request times out. If you make the request again with the same request
	// ID, the server can check if original operation with the same request ID
	// was received, and if so, will ignore the second request. This prevents
	// clients from accidentally creating duplicate commitments.
	//
	// The request ID must be a valid UUID with the exception that zero UUID is
	// not supported (00000000-0000-0000-0000-000000000000).
	RequestId string `protobuf:"bytes,3,opt,name=request_id,json=requestId,proto3" json:"request_id,omitempty"`
}

func (x *UpdateNetworkPolicyRequest) Reset() {
	*x = UpdateNetworkPolicyRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_vmwareengine_v1_vmwareengine_proto_msgTypes[32]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *UpdateNetworkPolicyRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*UpdateNetworkPolicyRequest) ProtoMessage() {}

func (x *UpdateNetworkPolicyRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_vmwareengine_v1_vmwareengine_proto_msgTypes[32]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use UpdateNetworkPolicyRequest.ProtoReflect.Descriptor instead.
func (*UpdateNetworkPolicyRequest) Descriptor() ([]byte, []int) {
	return file_google_cloud_vmwareengine_v1_vmwareengine_proto_rawDescGZIP(), []int{32}
}

func (x *UpdateNetworkPolicyRequest) GetNetworkPolicy() *NetworkPolicy {
	if x != nil {
		return x.NetworkPolicy
	}
	return nil
}

func (x *UpdateNetworkPolicyRequest) GetUpdateMask() *fieldmaskpb.FieldMask {
	if x != nil {
		return x.UpdateMask
	}
	return nil
}

func (x *UpdateNetworkPolicyRequest) GetRequestId() string {
	if x != nil {
		return x.RequestId
	}
	return ""
}

// Request message for
// [VmwareEngine.CreateNetworkPolicy][google.cloud.vmwareengine.v1.VmwareEngine.CreateNetworkPolicy]
type CreateNetworkPolicyRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. The resource name of the location (region)
	// to create the new network policy in.
	// Resource names are schemeless URIs that follow the conventions in
	// https://cloud.google.com/apis/design/resource_names.
	// For example:
	//  `projects/my-project/locations/us-central1`
	Parent string `protobuf:"bytes,1,opt,name=parent,proto3" json:"parent,omitempty"`
	// Required. The user-provided identifier of the network policy to be created.
	// This identifier must be unique within parent
	// `projects/{my-project}/locations/{us-central1}/networkPolicies` and becomes
	// the final token in the name URI.
	// The identifier must meet the following requirements:
	//
	// * Only contains 1-63 alphanumeric characters and hyphens
	// * Begins with an alphabetical character
	// * Ends with a non-hyphen character
	// * Not formatted as a UUID
	// * Complies with [RFC 1034](https://datatracker.ietf.org/doc/html/rfc1034)
	// (section 3.5)
	NetworkPolicyId string `protobuf:"bytes,2,opt,name=network_policy_id,json=networkPolicyId,proto3" json:"network_policy_id,omitempty"`
	// Required. The network policy configuration to use in the request.
	NetworkPolicy *NetworkPolicy `protobuf:"bytes,3,opt,name=network_policy,json=networkPolicy,proto3" json:"network_policy,omitempty"`
	// Optional. A request ID to identify requests. Specify a unique request ID
	// so that if you must retry your request, the server will know to ignore
	// the request if it has already been completed. The server guarantees that a
	// request doesn't result in creation of duplicate commitments for at least 60
	// minutes.
	//
	// For example, consider a situation where you make an initial request and the
	// request times out. If you make the request again with the same request
	// ID, the server can check if original operation with the same request ID
	// was received, and if so, will ignore the second request. This prevents
	// clients from accidentally creating duplicate commitments.
	//
	// The request ID must be a valid UUID with the exception that zero UUID is
	// not supported (00000000-0000-0000-0000-000000000000).
	RequestId string `protobuf:"bytes,4,opt,name=request_id,json=requestId,proto3" json:"request_id,omitempty"`
}

func (x *CreateNetworkPolicyRequest) Reset() {
	*x = CreateNetworkPolicyRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_vmwareengine_v1_vmwareengine_proto_msgTypes[33]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *CreateNetworkPolicyRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*CreateNetworkPolicyRequest) ProtoMessage() {}

func (x *CreateNetworkPolicyRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_vmwareengine_v1_vmwareengine_proto_msgTypes[33]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use CreateNetworkPolicyRequest.ProtoReflect.Descriptor instead.
func (*CreateNetworkPolicyRequest) Descriptor() ([]byte, []int) {
	return file_google_cloud_vmwareengine_v1_vmwareengine_proto_rawDescGZIP(), []int{33}
}

func (x *CreateNetworkPolicyRequest) GetParent() string {
	if x != nil {
		return x.Parent
	}
	return ""
}

func (x *CreateNetworkPolicyRequest) GetNetworkPolicyId() string {
	if x != nil {
		return x.NetworkPolicyId
	}
	return ""
}

func (x *CreateNetworkPolicyRequest) GetNetworkPolicy() *NetworkPolicy {
	if x != nil {
		return x.NetworkPolicy
	}
	return nil
}

func (x *CreateNetworkPolicyRequest) GetRequestId() string {
	if x != nil {
		return x.RequestId
	}
	return ""
}

// Request message for
// [VmwareEngine.DeleteNetworkPolicy][google.cloud.vmwareengine.v1.VmwareEngine.DeleteNetworkPolicy]
type DeleteNetworkPolicyRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. The resource name of the network policy to delete.
	// Resource names are schemeless URIs that follow the conventions in
	// https://cloud.google.com/apis/design/resource_names.
	// For example:
	// `projects/my-project/locations/us-central1/networkPolicies/my-network-policy`
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
	// Optional. A request ID to identify requests. Specify a unique request ID
	// so that if you must retry your request, the server will know to ignore
	// the request if it has already been completed. The server guarantees that a
	// request doesn't result in creation of duplicate commitments for at least 60
	// minutes.
	//
	// For example, consider a situation where you make an initial request and the
	// request times out. If you make the request again with the same request
	// ID, the server can check if original operation with the same request ID
	// was received, and if so, will ignore the second request. This prevents
	// clients from accidentally creating duplicate commitments.
	//
	// The request ID must be a valid UUID with the exception that zero UUID is
	// not supported (00000000-0000-0000-0000-000000000000).
	RequestId string `protobuf:"bytes,2,opt,name=request_id,json=requestId,proto3" json:"request_id,omitempty"`
}

func (x *DeleteNetworkPolicyRequest) Reset() {
	*x = DeleteNetworkPolicyRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_vmwareengine_v1_vmwareengine_proto_msgTypes[34]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *DeleteNetworkPolicyRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*DeleteNetworkPolicyRequest) ProtoMessage() {}

func (x *DeleteNetworkPolicyRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_vmwareengine_v1_vmwareengine_proto_msgTypes[34]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use DeleteNetworkPolicyRequest.ProtoReflect.Descriptor instead.
func (*DeleteNetworkPolicyRequest) Descriptor() ([]byte, []int) {
	return file_google_cloud_vmwareengine_v1_vmwareengine_proto_rawDescGZIP(), []int{34}
}

func (x *DeleteNetworkPolicyRequest) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

func (x *DeleteNetworkPolicyRequest) GetRequestId() string {
	if x != nil {
		return x.RequestId
	}
	return ""
}

// Request message for
// [VmwareEngine.CreateVmwareEngineNetwork][google.cloud.vmwareengine.v1.VmwareEngine.CreateVmwareEngineNetwork]
type CreateVmwareEngineNetworkRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. The resource name of the location to create the new VMware Engine
	// network in. A VMware Engine network of type
	// `LEGACY` is a regional resource, and a VMware
	// Engine network of type `STANDARD` is a global resource.
	// Resource names are schemeless URIs that follow the conventions in
	// https://cloud.google.com/apis/design/resource_names. For example:
	// `projects/my-project/locations/global`
	Parent string `protobuf:"bytes,1,opt,name=parent,proto3" json:"parent,omitempty"`
	// Required. The user-provided identifier of the new VMware Engine network.
	// This identifier must be unique among VMware Engine network resources
	// within the parent and becomes the final token in the name URI. The
	// identifier must meet the following requirements:
	//
	// * For networks of type LEGACY, adheres to the format:
	// `{region-id}-default`. Replace `{region-id}` with the region where you want
	// to create the VMware Engine network. For example, "us-central1-default".
	// * Only contains 1-63 alphanumeric characters and hyphens
	// * Begins with an alphabetical character
	// * Ends with a non-hyphen character
	// * Not formatted as a UUID
	// * Complies with [RFC 1034](https://datatracker.ietf.org/doc/html/rfc1034)
	// (section 3.5)
	VmwareEngineNetworkId string `protobuf:"bytes,2,opt,name=vmware_engine_network_id,json=vmwareEngineNetworkId,proto3" json:"vmware_engine_network_id,omitempty"`
	// Required. The initial description of the new VMware Engine network.
	VmwareEngineNetwork *VmwareEngineNetwork `protobuf:"bytes,3,opt,name=vmware_engine_network,json=vmwareEngineNetwork,proto3" json:"vmware_engine_network,omitempty"`
	// Optional. A request ID to identify requests. Specify a unique request ID
	// so that if you must retry your request, the server will know to ignore
	// the request if it has already been completed. The server guarantees that a
	// request doesn't result in creation of duplicate commitments for at least 60
	// minutes.
	//
	// For example, consider a situation where you make an initial request and the
	// request times out. If you make the request again with the same request
	// ID, the server can check if original operation with the same request ID
	// was received, and if so, will ignore the second request. This prevents
	// clients from accidentally creating duplicate commitments.
	//
	// The request ID must be a valid UUID with the exception that zero UUID is
	// not supported (00000000-0000-0000-0000-000000000000).
	RequestId string `protobuf:"bytes,4,opt,name=request_id,json=requestId,proto3" json:"request_id,omitempty"`
}

func (x *CreateVmwareEngineNetworkRequest) Reset() {
	*x = CreateVmwareEngineNetworkRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_vmwareengine_v1_vmwareengine_proto_msgTypes[35]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *CreateVmwareEngineNetworkRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*CreateVmwareEngineNetworkRequest) ProtoMessage() {}

func (x *CreateVmwareEngineNetworkRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_vmwareengine_v1_vmwareengine_proto_msgTypes[35]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use CreateVmwareEngineNetworkRequest.ProtoReflect.Descriptor instead.
func (*CreateVmwareEngineNetworkRequest) Descriptor() ([]byte, []int) {
	return file_google_cloud_vmwareengine_v1_vmwareengine_proto_rawDescGZIP(), []int{35}
}

func (x *CreateVmwareEngineNetworkRequest) GetParent() string {
	if x != nil {
		return x.Parent
	}
	return ""
}

func (x *CreateVmwareEngineNetworkRequest) GetVmwareEngineNetworkId() string {
	if x != nil {
		return x.VmwareEngineNetworkId
	}
	return ""
}

func (x *CreateVmwareEngineNetworkRequest) GetVmwareEngineNetwork() *VmwareEngineNetwork {
	if x != nil {
		return x.VmwareEngineNetwork
	}
	return nil
}

func (x *CreateVmwareEngineNetworkRequest) GetRequestId() string {
	if x != nil {
		return x.RequestId
	}
	return ""
}

// Request message for
// [VmwareEngine.UpdateVmwareEngineNetwork][google.cloud.vmwareengine.v1.VmwareEngine.UpdateVmwareEngineNetwork]
type UpdateVmwareEngineNetworkRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. VMware Engine network description.
	VmwareEngineNetwork *VmwareEngineNetwork `protobuf:"bytes,1,opt,name=vmware_engine_network,json=vmwareEngineNetwork,proto3" json:"vmware_engine_network,omitempty"`
	// Required. Field mask is used to specify the fields to be overwritten in the
	// VMware Engine network resource by the update.
	// The fields specified in the `update_mask` are relative to the resource, not
	// the full request. A field will be overwritten if it is in the mask. If the
	// user does not provide a mask then all fields will be overwritten. Only the
	// following fields can be updated: `description`.
	UpdateMask *fieldmaskpb.FieldMask `protobuf:"bytes,2,opt,name=update_mask,json=updateMask,proto3" json:"update_mask,omitempty"`
	// Optional. A request ID to identify requests. Specify a unique request ID
	// so that if you must retry your request, the server will know to ignore
	// the request if it has already been completed. The server guarantees that a
	// request doesn't result in creation of duplicate commitments for at least 60
	// minutes.
	//
	// For example, consider a situation where you make an initial request and the
	// request times out. If you make the request again with the same request
	// ID, the server can check if original operation with the same request ID
	// was received, and if so, will ignore the second request. This prevents
	// clients from accidentally creating duplicate commitments.
	//
	// The request ID must be a valid UUID with the exception that zero UUID is
	// not supported (00000000-0000-0000-0000-000000000000).
	RequestId string `protobuf:"bytes,3,opt,name=request_id,json=requestId,proto3" json:"request_id,omitempty"`
}

func (x *UpdateVmwareEngineNetworkRequest) Reset() {
	*x = UpdateVmwareEngineNetworkRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_vmwareengine_v1_vmwareengine_proto_msgTypes[36]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *UpdateVmwareEngineNetworkRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*UpdateVmwareEngineNetworkRequest) ProtoMessage() {}

func (x *UpdateVmwareEngineNetworkRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_vmwareengine_v1_vmwareengine_proto_msgTypes[36]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use UpdateVmwareEngineNetworkRequest.ProtoReflect.Descriptor instead.
func (*UpdateVmwareEngineNetworkRequest) Descriptor() ([]byte, []int) {
	return file_google_cloud_vmwareengine_v1_vmwareengine_proto_rawDescGZIP(), []int{36}
}

func (x *UpdateVmwareEngineNetworkRequest) GetVmwareEngineNetwork() *VmwareEngineNetwork {
	if x != nil {
		return x.VmwareEngineNetwork
	}
	return nil
}

func (x *UpdateVmwareEngineNetworkRequest) GetUpdateMask() *fieldmaskpb.FieldMask {
	if x != nil {
		return x.UpdateMask
	}
	return nil
}

func (x *UpdateVmwareEngineNetworkRequest) GetRequestId() string {
	if x != nil {
		return x.RequestId
	}
	return ""
}

// Request message for
// [VmwareEngine.DeleteVmwareEngineNetwork][google.cloud.vmwareengine.v1.VmwareEngine.DeleteVmwareEngineNetwork]
type DeleteVmwareEngineNetworkRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. The resource name of the VMware Engine network to be deleted.
	// Resource names are schemeless URIs that follow the conventions in
	// https://cloud.google.com/apis/design/resource_names.
	// For example:
	// `projects/my-project/locations/global/vmwareEngineNetworks/my-network`
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
	// Optional. A request ID to identify requests. Specify a unique request ID
	// so that if you must retry your request, the server will know to ignore
	// the request if it has already been completed. The server guarantees that a
	// request doesn't result in creation of duplicate commitments for at least 60
	// minutes.
	//
	// For example, consider a situation where you make an initial request and the
	// request times out. If you make the request again with the same request
	// ID, the server can check if original operation with the same request ID
	// was received, and if so, will ignore the second request. This prevents
	// clients from accidentally creating duplicate commitments.
	//
	// The request ID must be a valid UUID with the exception that zero UUID is
	// not supported (00000000-0000-0000-0000-000000000000).
	RequestId string `protobuf:"bytes,2,opt,name=request_id,json=requestId,proto3" json:"request_id,omitempty"`
	// Optional. Checksum used to ensure that the user-provided value is up to
	// date before the server processes the request. The server compares provided
	// checksum with the current checksum of the resource. If the user-provided
	// value is out of date, this request returns an `ABORTED` error.
	Etag string `protobuf:"bytes,3,opt,name=etag,proto3" json:"etag,omitempty"`
}

func (x *DeleteVmwareEngineNetworkRequest) Reset() {
	*x = DeleteVmwareEngineNetworkRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_vmwareengine_v1_vmwareengine_proto_msgTypes[37]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *DeleteVmwareEngineNetworkRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*DeleteVmwareEngineNetworkRequest) ProtoMessage() {}

func (x *DeleteVmwareEngineNetworkRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_vmwareengine_v1_vmwareengine_proto_msgTypes[37]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use DeleteVmwareEngineNetworkRequest.ProtoReflect.Descriptor instead.
func (*DeleteVmwareEngineNetworkRequest) Descriptor() ([]byte, []int) {
	return file_google_cloud_vmwareengine_v1_vmwareengine_proto_rawDescGZIP(), []int{37}
}

func (x *DeleteVmwareEngineNetworkRequest) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

func (x *DeleteVmwareEngineNetworkRequest) GetRequestId() string {
	if x != nil {
		return x.RequestId
	}
	return ""
}

func (x *DeleteVmwareEngineNetworkRequest) GetEtag() string {
	if x != nil {
		return x.Etag
	}
	return ""
}

// Request message for
// [VmwareEngine.GetVmwareEngineNetwork][google.cloud.vmwareengine.v1.VmwareEngine.GetVmwareEngineNetwork]
type GetVmwareEngineNetworkRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. The resource name of the VMware Engine network to retrieve.
	// Resource names are schemeless URIs that follow the conventions in
	// https://cloud.google.com/apis/design/resource_names.
	// For example:
	// `projects/my-project/locations/global/vmwareEngineNetworks/my-network`
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
}

func (x *GetVmwareEngineNetworkRequest) Reset() {
	*x = GetVmwareEngineNetworkRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_vmwareengine_v1_vmwareengine_proto_msgTypes[38]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *GetVmwareEngineNetworkRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*GetVmwareEngineNetworkRequest) ProtoMessage() {}

func (x *GetVmwareEngineNetworkRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_vmwareengine_v1_vmwareengine_proto_msgTypes[38]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use GetVmwareEngineNetworkRequest.ProtoReflect.Descriptor instead.
func (*GetVmwareEngineNetworkRequest) Descriptor() ([]byte, []int) {
	return file_google_cloud_vmwareengine_v1_vmwareengine_proto_rawDescGZIP(), []int{38}
}

func (x *GetVmwareEngineNetworkRequest) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

// Request message for
// [VmwareEngine.ListVmwareEngineNetworks][google.cloud.vmwareengine.v1.VmwareEngine.ListVmwareEngineNetworks]
type ListVmwareEngineNetworksRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. The resource name of the location to query for
	// VMware Engine networks. Resource names are schemeless URIs that follow the
	// conventions in https://cloud.google.com/apis/design/resource_names. For
	// example: `projects/my-project/locations/global`
	Parent string `protobuf:"bytes,1,opt,name=parent,proto3" json:"parent,omitempty"`
	// The maximum number of results to return in one page.
	// The maximum value is coerced to 1000.
	// The default value of this field is 500.
	PageSize int32 `protobuf:"varint,2,opt,name=page_size,json=pageSize,proto3" json:"page_size,omitempty"`
	// A page token, received from a previous `ListVmwareEngineNetworks` call.
	// Provide this to retrieve the subsequent page.
	//
	// When paginating, all other parameters provided to
	// `ListVmwareEngineNetworks` must match the call that provided the page
	// token.
	PageToken string `protobuf:"bytes,3,opt,name=page_token,json=pageToken,proto3" json:"page_token,omitempty"`
	// A filter expression that matches resources returned in the response.
	// The expression must specify the field name, a comparison
	// operator, and the value that you want to use for filtering. The value
	// must be a string, a number, or a boolean. The comparison operator
	// must be `=`, `!=`, `>`, or `<`.
	//
	// For example, if you are filtering a list of network peerings, you can
	// exclude the ones named `example-network` by specifying
	// `name != "example-network"`.
	//
	// To filter on multiple expressions, provide each separate expression within
	// parentheses. For example:
	// ```
	// (name = "example-network")
	// (createTime > "2021-04-12T08:15:10.40Z")
	// ```
	//
	// By default, each expression is an `AND` expression. However, you
	// can include `AND` and `OR` expressions explicitly.
	// For example:
	// ```
	// (name = "example-network-1") AND
	// (createTime > "2021-04-12T08:15:10.40Z") OR
	// (name = "example-network-2")
	// ```
	Filter string `protobuf:"bytes,4,opt,name=filter,proto3" json:"filter,omitempty"`
	// Sorts list results by a certain order. By default, returned results
	// are ordered by `name` in ascending order.
	// You can also sort results in descending order based on the `name` value
	// using `orderBy="name desc"`.
	// Currently, only ordering by `name` is supported.
	OrderBy string `protobuf:"bytes,5,opt,name=order_by,json=orderBy,proto3" json:"order_by,omitempty"`
}

func (x *ListVmwareEngineNetworksRequest) Reset() {
	*x = ListVmwareEngineNetworksRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_vmwareengine_v1_vmwareengine_proto_msgTypes[39]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *ListVmwareEngineNetworksRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ListVmwareEngineNetworksRequest) ProtoMessage() {}

func (x *ListVmwareEngineNetworksRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_vmwareengine_v1_vmwareengine_proto_msgTypes[39]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ListVmwareEngineNetworksRequest.ProtoReflect.Descriptor instead.
func (*ListVmwareEngineNetworksRequest) Descriptor() ([]byte, []int) {
	return file_google_cloud_vmwareengine_v1_vmwareengine_proto_rawDescGZIP(), []int{39}
}

func (x *ListVmwareEngineNetworksRequest) GetParent() string {
	if x != nil {
		return x.Parent
	}
	return ""
}

func (x *ListVmwareEngineNetworksRequest) GetPageSize() int32 {
	if x != nil {
		return x.PageSize
	}
	return 0
}

func (x *ListVmwareEngineNetworksRequest) GetPageToken() string {
	if x != nil {
		return x.PageToken
	}
	return ""
}

func (x *ListVmwareEngineNetworksRequest) GetFilter() string {
	if x != nil {
		return x.Filter
	}
	return ""
}

func (x *ListVmwareEngineNetworksRequest) GetOrderBy() string {
	if x != nil {
		return x.OrderBy
	}
	return ""
}

// Response message for
// [VmwareEngine.ListVmwareEngineNetworks][google.cloud.vmwareengine.v1.VmwareEngine.ListVmwareEngineNetworks]
type ListVmwareEngineNetworksResponse struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// A list of VMware Engine networks.
	VmwareEngineNetworks []*VmwareEngineNetwork `protobuf:"bytes,1,rep,name=vmware_engine_networks,json=vmwareEngineNetworks,proto3" json:"vmware_engine_networks,omitempty"`
	// A token, which can be sent as `page_token` to retrieve the next page.
	// If this field is omitted, there are no subsequent pages.
	NextPageToken string `protobuf:"bytes,2,opt,name=next_page_token,json=nextPageToken,proto3" json:"next_page_token,omitempty"`
	// Unreachable resources.
	Unreachable []string `protobuf:"bytes,3,rep,name=unreachable,proto3" json:"unreachable,omitempty"`
}

func (x *ListVmwareEngineNetworksResponse) Reset() {
	*x = ListVmwareEngineNetworksResponse{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_vmwareengine_v1_vmwareengine_proto_msgTypes[40]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *ListVmwareEngineNetworksResponse) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ListVmwareEngineNetworksResponse) ProtoMessage() {}

func (x *ListVmwareEngineNetworksResponse) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_vmwareengine_v1_vmwareengine_proto_msgTypes[40]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ListVmwareEngineNetworksResponse.ProtoReflect.Descriptor instead.
func (*ListVmwareEngineNetworksResponse) Descriptor() ([]byte, []int) {
	return file_google_cloud_vmwareengine_v1_vmwareengine_proto_rawDescGZIP(), []int{40}
}

func (x *ListVmwareEngineNetworksResponse) GetVmwareEngineNetworks() []*VmwareEngineNetwork {
	if x != nil {
		return x.VmwareEngineNetworks
	}
	return nil
}

func (x *ListVmwareEngineNetworksResponse) GetNextPageToken() string {
	if x != nil {
		return x.NextPageToken
	}
	return ""
}

func (x *ListVmwareEngineNetworksResponse) GetUnreachable() []string {
	if x != nil {
		return x.Unreachable
	}
	return nil
}

// Request message for
// [VmwareEngine.CreatePrivateConnection][google.cloud.vmwareengine.v1.VmwareEngine.CreatePrivateConnection]
type CreatePrivateConnectionRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. The resource name of the location to create the new private
	// connection in. Private connection is a regional resource.
	// Resource names are schemeless URIs that follow the conventions in
	// https://cloud.google.com/apis/design/resource_names. For example:
	// `projects/my-project/locations/us-central1`
	Parent string `protobuf:"bytes,1,opt,name=parent,proto3" json:"parent,omitempty"`
	// Required. The user-provided identifier of the new private connection.
	// This identifier must be unique among private connection resources
	// within the parent and becomes the final token in the name URI. The
	// identifier must meet the following requirements:
	//
	// * Only contains 1-63 alphanumeric characters and hyphens
	// * Begins with an alphabetical character
	// * Ends with a non-hyphen character
	// * Not formatted as a UUID
	// * Complies with [RFC 1034](https://datatracker.ietf.org/doc/html/rfc1034)
	// (section 3.5)
	PrivateConnectionId string `protobuf:"bytes,2,opt,name=private_connection_id,json=privateConnectionId,proto3" json:"private_connection_id,omitempty"`
	// Required. The initial description of the new private connection.
	PrivateConnection *PrivateConnection `protobuf:"bytes,3,opt,name=private_connection,json=privateConnection,proto3" json:"private_connection,omitempty"`
	// Optional. A request ID to identify requests. Specify a unique request ID
	// so that if you must retry your request, the server will know to ignore
	// the request if it has already been completed. The server guarantees that a
	// request doesn't result in creation of duplicate commitments for at least 60
	// minutes.
	//
	// For example, consider a situation where you make an initial request and the
	// request times out. If you make the request again with the same request
	// ID, the server can check if original operation with the same request ID
	// was received, and if so, will ignore the second request. This prevents
	// clients from accidentally creating duplicate commitments.
	//
	// The request ID must be a valid UUID with the exception that zero UUID is
	// not supported (00000000-0000-0000-0000-000000000000).
	RequestId string `protobuf:"bytes,4,opt,name=request_id,json=requestId,proto3" json:"request_id,omitempty"`
}

func (x *CreatePrivateConnectionRequest) Reset() {
	*x = CreatePrivateConnectionRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_vmwareengine_v1_vmwareengine_proto_msgTypes[41]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *CreatePrivateConnectionRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*CreatePrivateConnectionRequest) ProtoMessage() {}

func (x *CreatePrivateConnectionRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_vmwareengine_v1_vmwareengine_proto_msgTypes[41]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use CreatePrivateConnectionRequest.ProtoReflect.Descriptor instead.
func (*CreatePrivateConnectionRequest) Descriptor() ([]byte, []int) {
	return file_google_cloud_vmwareengine_v1_vmwareengine_proto_rawDescGZIP(), []int{41}
}

func (x *CreatePrivateConnectionRequest) GetParent() string {
	if x != nil {
		return x.Parent
	}
	return ""
}

func (x *CreatePrivateConnectionRequest) GetPrivateConnectionId() string {
	if x != nil {
		return x.PrivateConnectionId
	}
	return ""
}

func (x *CreatePrivateConnectionRequest) GetPrivateConnection() *PrivateConnection {
	if x != nil {
		return x.PrivateConnection
	}
	return nil
}

func (x *CreatePrivateConnectionRequest) GetRequestId() string {
	if x != nil {
		return x.RequestId
	}
	return ""
}

// Request message for
// [VmwareEngine.GetPrivateConnection][google.cloud.vmwareengine.v1.VmwareEngine.GetPrivateConnection]
type GetPrivateConnectionRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. The resource name of the private connection to retrieve.
	// Resource names are schemeless URIs that follow the conventions in
	// https://cloud.google.com/apis/design/resource_names.
	// For example:
	// `projects/my-project/locations/us-central1/privateConnections/my-connection`
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
}

func (x *GetPrivateConnectionRequest) Reset() {
	*x = GetPrivateConnectionRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_vmwareengine_v1_vmwareengine_proto_msgTypes[42]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *GetPrivateConnectionRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*GetPrivateConnectionRequest) ProtoMessage() {}

func (x *GetPrivateConnectionRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_vmwareengine_v1_vmwareengine_proto_msgTypes[42]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use GetPrivateConnectionRequest.ProtoReflect.Descriptor instead.
func (*GetPrivateConnectionRequest) Descriptor() ([]byte, []int) {
	return file_google_cloud_vmwareengine_v1_vmwareengine_proto_rawDescGZIP(), []int{42}
}

func (x *GetPrivateConnectionRequest) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

// Request message for
// [VmwareEngine.ListPrivateConnections][google.cloud.vmwareengine.v1.VmwareEngine.ListPrivateConnections]
type ListPrivateConnectionsRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. The resource name of the location to query for
	// private connections. Resource names are schemeless URIs that follow the
	// conventions in https://cloud.google.com/apis/design/resource_names. For
	// example: `projects/my-project/locations/us-central1`
	Parent string `protobuf:"bytes,1,opt,name=parent,proto3" json:"parent,omitempty"`
	// The maximum number of private connections to return in one page.
	// The maximum value is coerced to 1000.
	// The default value of this field is 500.
	PageSize int32 `protobuf:"varint,2,opt,name=page_size,json=pageSize,proto3" json:"page_size,omitempty"`
	// A page token, received from a previous `ListPrivateConnections` call.
	// Provide this to retrieve the subsequent page.
	//
	// When paginating, all other parameters provided to
	// `ListPrivateConnections` must match the call that provided the page
	// token.
	PageToken string `protobuf:"bytes,3,opt,name=page_token,json=pageToken,proto3" json:"page_token,omitempty"`
	// A filter expression that matches resources returned in the response.
	// The expression must specify the field name, a comparison
	// operator, and the value that you want to use for filtering. The value
	// must be a string, a number, or a boolean. The comparison operator
	// must be `=`, `!=`, `>`, or `<`.
	//
	// For example, if you are filtering a list of private connections, you can
	// exclude the ones named `example-connection` by specifying
	// `name != "example-connection"`.
	//
	// To filter on multiple expressions, provide each separate expression within
	// parentheses. For example:
	// ```
	// (name = "example-connection")
	// (createTime > "2022-09-22T08:15:10.40Z")
	// ```
	//
	// By default, each expression is an `AND` expression. However, you
	// can include `AND` and `OR` expressions explicitly.
	// For example:
	// ```
	// (name = "example-connection-1") AND
	// (createTime > "2021-04-12T08:15:10.40Z") OR
	// (name = "example-connection-2")
	// ```
	Filter string `protobuf:"bytes,4,opt,name=filter,proto3" json:"filter,omitempty"`
	// Sorts list results by a certain order. By default, returned results
	// are ordered by `name` in ascending order.
	// You can also sort results in descending order based on the `name` value
	// using `orderBy="name desc"`.
	// Currently, only ordering by `name` is supported.
	OrderBy string `protobuf:"bytes,5,opt,name=order_by,json=orderBy,proto3" json:"order_by,omitempty"`
}

func (x *ListPrivateConnectionsRequest) Reset() {
	*x = ListPrivateConnectionsRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_vmwareengine_v1_vmwareengine_proto_msgTypes[43]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *ListPrivateConnectionsRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ListPrivateConnectionsRequest) ProtoMessage() {}

func (x *ListPrivateConnectionsRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_vmwareengine_v1_vmwareengine_proto_msgTypes[43]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ListPrivateConnectionsRequest.ProtoReflect.Descriptor instead.
func (*ListPrivateConnectionsRequest) Descriptor() ([]byte, []int) {
	return file_google_cloud_vmwareengine_v1_vmwareengine_proto_rawDescGZIP(), []int{43}
}

func (x *ListPrivateConnectionsRequest) GetParent() string {
	if x != nil {
		return x.Parent
	}
	return ""
}

func (x *ListPrivateConnectionsRequest) GetPageSize() int32 {
	if x != nil {
		return x.PageSize
	}
	return 0
}

func (x *ListPrivateConnectionsRequest) GetPageToken() string {
	if x != nil {
		return x.PageToken
	}
	return ""
}

func (x *ListPrivateConnectionsRequest) GetFilter() string {
	if x != nil {
		return x.Filter
	}
	return ""
}

func (x *ListPrivateConnectionsRequest) GetOrderBy() string {
	if x != nil {
		return x.OrderBy
	}
	return ""
}

// Response message for
// [VmwareEngine.ListPrivateConnections][google.cloud.vmwareengine.v1.VmwareEngine.ListPrivateConnections]
type ListPrivateConnectionsResponse struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// A list of private connections.
	PrivateConnections []*PrivateConnection `protobuf:"bytes,1,rep,name=private_connections,json=privateConnections,proto3" json:"private_connections,omitempty"`
	// A token, which can be sent as `page_token` to retrieve the next page.
	// If this field is omitted, there are no subsequent pages.
	NextPageToken string `protobuf:"bytes,2,opt,name=next_page_token,json=nextPageToken,proto3" json:"next_page_token,omitempty"`
	// Unreachable resources.
	Unreachable []string `protobuf:"bytes,3,rep,name=unreachable,proto3" json:"unreachable,omitempty"`
}

func (x *ListPrivateConnectionsResponse) Reset() {
	*x = ListPrivateConnectionsResponse{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_vmwareengine_v1_vmwareengine_proto_msgTypes[44]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *ListPrivateConnectionsResponse) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ListPrivateConnectionsResponse) ProtoMessage() {}

func (x *ListPrivateConnectionsResponse) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_vmwareengine_v1_vmwareengine_proto_msgTypes[44]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ListPrivateConnectionsResponse.ProtoReflect.Descriptor instead.
func (*ListPrivateConnectionsResponse) Descriptor() ([]byte, []int) {
	return file_google_cloud_vmwareengine_v1_vmwareengine_proto_rawDescGZIP(), []int{44}
}

func (x *ListPrivateConnectionsResponse) GetPrivateConnections() []*PrivateConnection {
	if x != nil {
		return x.PrivateConnections
	}
	return nil
}

func (x *ListPrivateConnectionsResponse) GetNextPageToken() string {
	if x != nil {
		return x.NextPageToken
	}
	return ""
}

func (x *ListPrivateConnectionsResponse) GetUnreachable() []string {
	if x != nil {
		return x.Unreachable
	}
	return nil
}

// Request message for
// [VmwareEngine.UpdatePrivateConnection][google.cloud.vmwareengine.v1.VmwareEngine.UpdatePrivateConnection]
type UpdatePrivateConnectionRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. Private connection description.
	PrivateConnection *PrivateConnection `protobuf:"bytes,1,opt,name=private_connection,json=privateConnection,proto3" json:"private_connection,omitempty"`
	// Required. Field mask is used to specify the fields to be overwritten in the
	// `PrivateConnection` resource by the update.
	// The fields specified in the `update_mask` are relative to the resource, not
	// the full request. A field will be overwritten if it is in the mask. If the
	// user does not provide a mask then all fields will be overwritten.
	UpdateMask *fieldmaskpb.FieldMask `protobuf:"bytes,2,opt,name=update_mask,json=updateMask,proto3" json:"update_mask,omitempty"`
	// Optional. A request ID to identify requests. Specify a unique request ID
	// so that if you must retry your request, the server will know to ignore
	// the request if it has already been completed. The server guarantees that a
	// request doesn't result in creation of duplicate commitments for at least 60
	// minutes.
	//
	// For example, consider a situation where you make an initial request and the
	// request times out. If you make the request again with the same request
	// ID, the server can check if original operation with the same request ID
	// was received, and if so, will ignore the second request. This prevents
	// clients from accidentally creating duplicate commitments.
	//
	// The request ID must be a valid UUID with the exception that zero UUID is
	// not supported (00000000-0000-0000-0000-000000000000).
	RequestId string `protobuf:"bytes,3,opt,name=request_id,json=requestId,proto3" json:"request_id,omitempty"`
}

func (x *UpdatePrivateConnectionRequest) Reset() {
	*x = UpdatePrivateConnectionRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_vmwareengine_v1_vmwareengine_proto_msgTypes[45]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *UpdatePrivateConnectionRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*UpdatePrivateConnectionRequest) ProtoMessage() {}

func (x *UpdatePrivateConnectionRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_vmwareengine_v1_vmwareengine_proto_msgTypes[45]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use UpdatePrivateConnectionRequest.ProtoReflect.Descriptor instead.
func (*UpdatePrivateConnectionRequest) Descriptor() ([]byte, []int) {
	return file_google_cloud_vmwareengine_v1_vmwareengine_proto_rawDescGZIP(), []int{45}
}

func (x *UpdatePrivateConnectionRequest) GetPrivateConnection() *PrivateConnection {
	if x != nil {
		return x.PrivateConnection
	}
	return nil
}

func (x *UpdatePrivateConnectionRequest) GetUpdateMask() *fieldmaskpb.FieldMask {
	if x != nil {
		return x.UpdateMask
	}
	return nil
}

func (x *UpdatePrivateConnectionRequest) GetRequestId() string {
	if x != nil {
		return x.RequestId
	}
	return ""
}

// Request message for
// [VmwareEngine.DeletePrivateConnection][google.cloud.vmwareengine.v1.VmwareEngine.DeletePrivateConnection]
type DeletePrivateConnectionRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. The resource name of the private connection to be deleted.
	// Resource names are schemeless URIs that follow the conventions in
	// https://cloud.google.com/apis/design/resource_names.
	// For example:
	// `projects/my-project/locations/us-central1/privateConnections/my-connection`
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
	// Optional. A request ID to identify requests. Specify a unique request ID
	// so that if you must retry your request, the server will know to ignore
	// the request if it has already been completed. The server guarantees that a
	// request doesn't result in creation of duplicate commitments for at least 60
	// minutes.
	//
	// For example, consider a situation where you make an initial request and the
	// request times out. If you make the request again with the same request
	// ID, the server can check if original operation with the same request ID
	// was received, and if so, will ignore the second request. This prevents
	// clients from accidentally creating duplicate commitments.
	//
	// The request ID must be a valid UUID with the exception that zero UUID is
	// not supported (00000000-0000-0000-0000-000000000000).
	RequestId string `protobuf:"bytes,2,opt,name=request_id,json=requestId,proto3" json:"request_id,omitempty"`
}

func (x *DeletePrivateConnectionRequest) Reset() {
	*x = DeletePrivateConnectionRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_vmwareengine_v1_vmwareengine_proto_msgTypes[46]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *DeletePrivateConnectionRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*DeletePrivateConnectionRequest) ProtoMessage() {}

func (x *DeletePrivateConnectionRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_vmwareengine_v1_vmwareengine_proto_msgTypes[46]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use DeletePrivateConnectionRequest.ProtoReflect.Descriptor instead.
func (*DeletePrivateConnectionRequest) Descriptor() ([]byte, []int) {
	return file_google_cloud_vmwareengine_v1_vmwareengine_proto_rawDescGZIP(), []int{46}
}

func (x *DeletePrivateConnectionRequest) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

func (x *DeletePrivateConnectionRequest) GetRequestId() string {
	if x != nil {
		return x.RequestId
	}
	return ""
}

// Request message for
// [VmwareEngine.ListPrivateConnectionPeeringRoutes][google.cloud.vmwareengine.v1.VmwareEngine.ListPrivateConnectionPeeringRoutes]
type ListPrivateConnectionPeeringRoutesRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. The resource name of the private connection to retrieve peering
	// routes from. Resource names are schemeless URIs that follow the conventions
	// in https://cloud.google.com/apis/design/resource_names. For example:
	// `projects/my-project/locations/us-west1/privateConnections/my-connection`
	Parent string `protobuf:"bytes,1,opt,name=parent,proto3" json:"parent,omitempty"`
	// The maximum number of peering routes to return in one page.
	// The service may return fewer than this value.
	// The maximum value is coerced to 1000.
	// The default value of this field is 500.
	PageSize int32 `protobuf:"varint,2,opt,name=page_size,json=pageSize,proto3" json:"page_size,omitempty"`
	// A page token, received from a previous `ListPrivateConnectionPeeringRoutes`
	// call. Provide this to retrieve the subsequent page. When paginating, all
	// other parameters provided to `ListPrivateConnectionPeeringRoutes` must
	// match the call that provided the page token.
	PageToken string `protobuf:"bytes,3,opt,name=page_token,json=pageToken,proto3" json:"page_token,omitempty"`
}

func (x *ListPrivateConnectionPeeringRoutesRequest) Reset() {
	*x = ListPrivateConnectionPeeringRoutesRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_vmwareengine_v1_vmwareengine_proto_msgTypes[47]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *ListPrivateConnectionPeeringRoutesRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ListPrivateConnectionPeeringRoutesRequest) ProtoMessage() {}

func (x *ListPrivateConnectionPeeringRoutesRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_vmwareengine_v1_vmwareengine_proto_msgTypes[47]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ListPrivateConnectionPeeringRoutesRequest.ProtoReflect.Descriptor instead.
func (*ListPrivateConnectionPeeringRoutesRequest) Descriptor() ([]byte, []int) {
	return file_google_cloud_vmwareengine_v1_vmwareengine_proto_rawDescGZIP(), []int{47}
}

func (x *ListPrivateConnectionPeeringRoutesRequest) GetParent() string {
	if x != nil {
		return x.Parent
	}
	return ""
}

func (x *ListPrivateConnectionPeeringRoutesRequest) GetPageSize() int32 {
	if x != nil {
		return x.PageSize
	}
	return 0
}

func (x *ListPrivateConnectionPeeringRoutesRequest) GetPageToken() string {
	if x != nil {
		return x.PageToken
	}
	return ""
}

// Response message for
// [VmwareEngine.ListPrivateConnectionPeeringRoutes][google.cloud.vmwareengine.v1.VmwareEngine.ListPrivateConnectionPeeringRoutes]
type ListPrivateConnectionPeeringRoutesResponse struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// A list of peering routes.
	PeeringRoutes []*PeeringRoute `protobuf:"bytes,1,rep,name=peering_routes,json=peeringRoutes,proto3" json:"peering_routes,omitempty"`
	// A token, which can be sent as `page_token` to retrieve the next page.
	// If this field is omitted, there are no subsequent pages.
	NextPageToken string `protobuf:"bytes,2,opt,name=next_page_token,json=nextPageToken,proto3" json:"next_page_token,omitempty"`
}

func (x *ListPrivateConnectionPeeringRoutesResponse) Reset() {
	*x = ListPrivateConnectionPeeringRoutesResponse{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_vmwareengine_v1_vmwareengine_proto_msgTypes[48]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *ListPrivateConnectionPeeringRoutesResponse) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ListPrivateConnectionPeeringRoutesResponse) ProtoMessage() {}

func (x *ListPrivateConnectionPeeringRoutesResponse) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_vmwareengine_v1_vmwareengine_proto_msgTypes[48]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ListPrivateConnectionPeeringRoutesResponse.ProtoReflect.Descriptor instead.
func (*ListPrivateConnectionPeeringRoutesResponse) Descriptor() ([]byte, []int) {
	return file_google_cloud_vmwareengine_v1_vmwareengine_proto_rawDescGZIP(), []int{48}
}

func (x *ListPrivateConnectionPeeringRoutesResponse) GetPeeringRoutes() []*PeeringRoute {
	if x != nil {
		return x.PeeringRoutes
	}
	return nil
}

func (x *ListPrivateConnectionPeeringRoutesResponse) GetNextPageToken() string {
	if x != nil {
		return x.NextPageToken
	}
	return ""
}

var File_google_cloud_vmwareengine_v1_vmwareengine_proto protoreflect.FileDescriptor

var file_google_cloud_vmwareengine_v1_vmwareengine_proto_rawDesc = []byte{
	0x0a, 0x2f, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2f, 0x76,
	0x6d, 0x77, 0x61, 0x72, 0x65, 0x65, 0x6e, 0x67, 0x69, 0x6e, 0x65, 0x2f, 0x76, 0x31, 0x2f, 0x76,
	0x6d, 0x77, 0x61, 0x72, 0x65, 0x65, 0x6e, 0x67, 0x69, 0x6e, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74,
	0x6f, 0x12, 0x1c, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e,
	0x76, 0x6d, 0x77, 0x61, 0x72, 0x65, 0x65, 0x6e, 0x67, 0x69, 0x6e, 0x65, 0x2e, 0x76, 0x31, 0x1a,
	0x1c, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x61, 0x70, 0x69, 0x2f, 0x61, 0x6e, 0x6e, 0x6f,
	0x74, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x17, 0x67,
	0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x61, 0x70, 0x69, 0x2f, 0x63, 0x6c, 0x69, 0x65, 0x6e, 0x74,
	0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x1f, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x61,
	0x70, 0x69, 0x2f, 0x66, 0x69, 0x65, 0x6c, 0x64, 0x5f, 0x62, 0x65, 0x68, 0x61, 0x76, 0x69, 0x6f,
	0x72, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x19, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f,
	0x61, 0x70, 0x69, 0x2f, 0x72, 0x65, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x2e, 0x70, 0x72, 0x6f,
	0x74, 0x6f, 0x1a, 0x39, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x63, 0x6c, 0x6f, 0x75, 0x64,
	0x2f, 0x76, 0x6d, 0x77, 0x61, 0x72, 0x65, 0x65, 0x6e, 0x67, 0x69, 0x6e, 0x65, 0x2f, 0x76, 0x31,
	0x2f, 0x76, 0x6d, 0x77, 0x61, 0x72, 0x65, 0x65, 0x6e, 0x67, 0x69, 0x6e, 0x65, 0x5f, 0x72, 0x65,
	0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x73, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x23, 0x67,
	0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x6c, 0x6f, 0x6e, 0x67, 0x72, 0x75, 0x6e, 0x6e, 0x69, 0x6e,
	0x67, 0x2f, 0x6f, 0x70, 0x65, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2e, 0x70, 0x72, 0x6f,
	0x74, 0x6f, 0x1a, 0x1b, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x70, 0x72, 0x6f, 0x74, 0x6f,
	0x62, 0x75, 0x66, 0x2f, 0x65, 0x6d, 0x70, 0x74, 0x79, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a,
	0x20, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66,
	0x2f, 0x66, 0x69, 0x65, 0x6c, 0x64, 0x5f, 0x6d, 0x61, 0x73, 0x6b, 0x2e, 0x70, 0x72, 0x6f, 0x74,
	0x6f, 0x1a, 0x1f, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62,
	0x75, 0x66, 0x2f, 0x74, 0x69, 0x6d, 0x65, 0x73, 0x74, 0x61, 0x6d, 0x70, 0x2e, 0x70, 0x72, 0x6f,
	0x74, 0x6f, 0x22, 0xcc, 0x01, 0x0a, 0x18, 0x4c, 0x69, 0x73, 0x74, 0x50, 0x72, 0x69, 0x76, 0x61,
	0x74, 0x65, 0x43, 0x6c, 0x6f, 0x75, 0x64, 0x73, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12,
	0x41, 0x0a, 0x06, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42,
	0x29, 0xe0, 0x41, 0x02, 0xfa, 0x41, 0x23, 0x0a, 0x21, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f,
	0x6e, 0x73, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f,
	0x6d, 0x2f, 0x4c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x52, 0x06, 0x70, 0x61, 0x72, 0x65,
	0x6e, 0x74, 0x12, 0x1b, 0x0a, 0x09, 0x70, 0x61, 0x67, 0x65, 0x5f, 0x73, 0x69, 0x7a, 0x65, 0x18,
	0x02, 0x20, 0x01, 0x28, 0x05, 0x52, 0x08, 0x70, 0x61, 0x67, 0x65, 0x53, 0x69, 0x7a, 0x65, 0x12,
	0x1d, 0x0a, 0x0a, 0x70, 0x61, 0x67, 0x65, 0x5f, 0x74, 0x6f, 0x6b, 0x65, 0x6e, 0x18, 0x03, 0x20,
	0x01, 0x28, 0x09, 0x52, 0x09, 0x70, 0x61, 0x67, 0x65, 0x54, 0x6f, 0x6b, 0x65, 0x6e, 0x12, 0x16,
	0x0a, 0x06, 0x66, 0x69, 0x6c, 0x74, 0x65, 0x72, 0x18, 0x04, 0x20, 0x01, 0x28, 0x09, 0x52, 0x06,
	0x66, 0x69, 0x6c, 0x74, 0x65, 0x72, 0x12, 0x19, 0x0a, 0x08, 0x6f, 0x72, 0x64, 0x65, 0x72, 0x5f,
	0x62, 0x79, 0x18, 0x05, 0x20, 0x01, 0x28, 0x09, 0x52, 0x07, 0x6f, 0x72, 0x64, 0x65, 0x72, 0x42,
	0x79, 0x22, 0xb8, 0x01, 0x0a, 0x19, 0x4c, 0x69, 0x73, 0x74, 0x50, 0x72, 0x69, 0x76, 0x61, 0x74,
	0x65, 0x43, 0x6c, 0x6f, 0x75, 0x64, 0x73, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x12,
	0x51, 0x0a, 0x0e, 0x70, 0x72, 0x69, 0x76, 0x61, 0x74, 0x65, 0x5f, 0x63, 0x6c, 0x6f, 0x75, 0x64,
	0x73, 0x18, 0x01, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x2a, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65,
	0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x76, 0x6d, 0x77, 0x61, 0x72, 0x65, 0x65, 0x6e, 0x67,
	0x69, 0x6e, 0x65, 0x2e, 0x76, 0x31, 0x2e, 0x50, 0x72, 0x69, 0x76, 0x61, 0x74, 0x65, 0x43, 0x6c,
	0x6f, 0x75, 0x64, 0x52, 0x0d, 0x70, 0x72, 0x69, 0x76, 0x61, 0x74, 0x65, 0x43, 0x6c, 0x6f, 0x75,
	0x64, 0x73, 0x12, 0x26, 0x0a, 0x0f, 0x6e, 0x65, 0x78, 0x74, 0x5f, 0x70, 0x61, 0x67, 0x65, 0x5f,
	0x74, 0x6f, 0x6b, 0x65, 0x6e, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x52, 0x0d, 0x6e, 0x65, 0x78,
	0x74, 0x50, 0x61, 0x67, 0x65, 0x54, 0x6f, 0x6b, 0x65, 0x6e, 0x12, 0x20, 0x0a, 0x0b, 0x75, 0x6e,
	0x72, 0x65, 0x61, 0x63, 0x68, 0x61, 0x62, 0x6c, 0x65, 0x18, 0x03, 0x20, 0x03, 0x28, 0x09, 0x52,
	0x0b, 0x75, 0x6e, 0x72, 0x65, 0x61, 0x63, 0x68, 0x61, 0x62, 0x6c, 0x65, 0x22, 0x5e, 0x0a, 0x16,
	0x47, 0x65, 0x74, 0x50, 0x72, 0x69, 0x76, 0x61, 0x74, 0x65, 0x43, 0x6c, 0x6f, 0x75, 0x64, 0x52,
	0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x44, 0x0a, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x18, 0x01,
	0x20, 0x01, 0x28, 0x09, 0x42, 0x30, 0xe0, 0x41, 0x02, 0xfa, 0x41, 0x2a, 0x0a, 0x28, 0x76, 0x6d,
	0x77, 0x61, 0x72, 0x65, 0x65, 0x6e, 0x67, 0x69, 0x6e, 0x65, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c,
	0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x50, 0x72, 0x69, 0x76, 0x61, 0x74,
	0x65, 0x43, 0x6c, 0x6f, 0x75, 0x64, 0x52, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x22, 0xb1, 0x02, 0x0a,
	0x19, 0x43, 0x72, 0x65, 0x61, 0x74, 0x65, 0x50, 0x72, 0x69, 0x76, 0x61, 0x74, 0x65, 0x43, 0x6c,
	0x6f, 0x75, 0x64, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x41, 0x0a, 0x06, 0x70, 0x61,
	0x72, 0x65, 0x6e, 0x74, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x29, 0xe0, 0x41, 0x02, 0xfa,
	0x41, 0x23, 0x0a, 0x21, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2e, 0x67, 0x6f,
	0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x4c, 0x6f, 0x63,
	0x61, 0x74, 0x69, 0x6f, 0x6e, 0x52, 0x06, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x12, 0x2d, 0x0a,
	0x10, 0x70, 0x72, 0x69, 0x76, 0x61, 0x74, 0x65, 0x5f, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x5f, 0x69,
	0x64, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x02, 0x52, 0x0e, 0x70, 0x72,
	0x69, 0x76, 0x61, 0x74, 0x65, 0x43, 0x6c, 0x6f, 0x75, 0x64, 0x49, 0x64, 0x12, 0x54, 0x0a, 0x0d,
	0x70, 0x72, 0x69, 0x76, 0x61, 0x74, 0x65, 0x5f, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x18, 0x03, 0x20,
	0x01, 0x28, 0x0b, 0x32, 0x2a, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f,
	0x75, 0x64, 0x2e, 0x76, 0x6d, 0x77, 0x61, 0x72, 0x65, 0x65, 0x6e, 0x67, 0x69, 0x6e, 0x65, 0x2e,
	0x76, 0x31, 0x2e, 0x50, 0x72, 0x69, 0x76, 0x61, 0x74, 0x65, 0x43, 0x6c, 0x6f, 0x75, 0x64, 0x42,
	0x03, 0xe0, 0x41, 0x02, 0x52, 0x0c, 0x70, 0x72, 0x69, 0x76, 0x61, 0x74, 0x65, 0x43, 0x6c, 0x6f,
	0x75, 0x64, 0x12, 0x22, 0x0a, 0x0a, 0x72, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x5f, 0x69, 0x64,
	0x18, 0x04, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x52, 0x09, 0x72, 0x65, 0x71,
	0x75, 0x65, 0x73, 0x74, 0x49, 0x64, 0x12, 0x28, 0x0a, 0x0d, 0x76, 0x61, 0x6c, 0x69, 0x64, 0x61,
	0x74, 0x65, 0x5f, 0x6f, 0x6e, 0x6c, 0x79, 0x18, 0x05, 0x20, 0x01, 0x28, 0x08, 0x42, 0x03, 0xe0,
	0x41, 0x01, 0x52, 0x0c, 0x76, 0x61, 0x6c, 0x69, 0x64, 0x61, 0x74, 0x65, 0x4f, 0x6e, 0x6c, 0x79,
	0x22, 0xd7, 0x01, 0x0a, 0x19, 0x55, 0x70, 0x64, 0x61, 0x74, 0x65, 0x50, 0x72, 0x69, 0x76, 0x61,
	0x74, 0x65, 0x43, 0x6c, 0x6f, 0x75, 0x64, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x54,
	0x0a, 0x0d, 0x70, 0x72, 0x69, 0x76, 0x61, 0x74, 0x65, 0x5f, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x18,
	0x01, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x2a, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63,
	0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x76, 0x6d, 0x77, 0x61, 0x72, 0x65, 0x65, 0x6e, 0x67, 0x69, 0x6e,
	0x65, 0x2e, 0x76, 0x31, 0x2e, 0x50, 0x72, 0x69, 0x76, 0x61, 0x74, 0x65, 0x43, 0x6c, 0x6f, 0x75,
	0x64, 0x42, 0x03, 0xe0, 0x41, 0x02, 0x52, 0x0c, 0x70, 0x72, 0x69, 0x76, 0x61, 0x74, 0x65, 0x43,
	0x6c, 0x6f, 0x75, 0x64, 0x12, 0x40, 0x0a, 0x0b, 0x75, 0x70, 0x64, 0x61, 0x74, 0x65, 0x5f, 0x6d,
	0x61, 0x73, 0x6b, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1a, 0x2e, 0x67, 0x6f, 0x6f, 0x67,
	0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x46, 0x69, 0x65, 0x6c,
	0x64, 0x4d, 0x61, 0x73, 0x6b, 0x42, 0x03, 0xe0, 0x41, 0x02, 0x52, 0x0a, 0x75, 0x70, 0x64, 0x61,
	0x74, 0x65, 0x4d, 0x61, 0x73, 0x6b, 0x12, 0x22, 0x0a, 0x0a, 0x72, 0x65, 0x71, 0x75, 0x65, 0x73,
	0x74, 0x5f, 0x69, 0x64, 0x18, 0x03, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x52,
	0x09, 0x72, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x49, 0x64, 0x22, 0xdb, 0x01, 0x0a, 0x19, 0x44,
	0x65, 0x6c, 0x65, 0x74, 0x65, 0x50, 0x72, 0x69, 0x76, 0x61, 0x74, 0x65, 0x43, 0x6c, 0x6f, 0x75,
	0x64, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x44, 0x0a, 0x04, 0x6e, 0x61, 0x6d, 0x65,
	0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x30, 0xe0, 0x41, 0x02, 0xfa, 0x41, 0x2a, 0x0a, 0x28,
	0x76, 0x6d, 0x77, 0x61, 0x72, 0x65, 0x65, 0x6e, 0x67, 0x69, 0x6e, 0x65, 0x2e, 0x67, 0x6f, 0x6f,
	0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x50, 0x72, 0x69, 0x76,
	0x61, 0x74, 0x65, 0x43, 0x6c, 0x6f, 0x75, 0x64, 0x52, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x12, 0x22,
	0x0a, 0x0a, 0x72, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x5f, 0x69, 0x64, 0x18, 0x02, 0x20, 0x01,
	0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x52, 0x09, 0x72, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74,
	0x49, 0x64, 0x12, 0x19, 0x0a, 0x05, 0x66, 0x6f, 0x72, 0x63, 0x65, 0x18, 0x03, 0x20, 0x01, 0x28,
	0x08, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x52, 0x05, 0x66, 0x6f, 0x72, 0x63, 0x65, 0x12, 0x29, 0x0a,
	0x0b, 0x64, 0x65, 0x6c, 0x61, 0x79, 0x5f, 0x68, 0x6f, 0x75, 0x72, 0x73, 0x18, 0x04, 0x20, 0x01,
	0x28, 0x05, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x48, 0x00, 0x52, 0x0a, 0x64, 0x65, 0x6c, 0x61, 0x79,
	0x48, 0x6f, 0x75, 0x72, 0x73, 0x88, 0x01, 0x01, 0x42, 0x0e, 0x0a, 0x0c, 0x5f, 0x64, 0x65, 0x6c,
	0x61, 0x79, 0x5f, 0x68, 0x6f, 0x75, 0x72, 0x73, 0x22, 0x87, 0x01, 0x0a, 0x1b, 0x55, 0x6e, 0x64,
	0x65, 0x6c, 0x65, 0x74, 0x65, 0x50, 0x72, 0x69, 0x76, 0x61, 0x74, 0x65, 0x43, 0x6c, 0x6f, 0x75,
	0x64, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x44, 0x0a, 0x04, 0x6e, 0x61, 0x6d, 0x65,
	0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x30, 0xe0, 0x41, 0x02, 0xfa, 0x41, 0x2a, 0x0a, 0x28,
	0x76, 0x6d, 0x77, 0x61, 0x72, 0x65, 0x65, 0x6e, 0x67, 0x69, 0x6e, 0x65, 0x2e, 0x67, 0x6f, 0x6f,
	0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x50, 0x72, 0x69, 0x76,
	0x61, 0x74, 0x65, 0x43, 0x6c, 0x6f, 0x75, 0x64, 0x52, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x12, 0x22,
	0x0a, 0x0a, 0x72, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x5f, 0x69, 0x64, 0x18, 0x02, 0x20, 0x01,
	0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x52, 0x09, 0x72, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74,
	0x49, 0x64, 0x22, 0xce, 0x01, 0x0a, 0x13, 0x4c, 0x69, 0x73, 0x74, 0x43, 0x6c, 0x75, 0x73, 0x74,
	0x65, 0x72, 0x73, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x48, 0x0a, 0x06, 0x70, 0x61,
	0x72, 0x65, 0x6e, 0x74, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x30, 0xe0, 0x41, 0x02, 0xfa,
	0x41, 0x2a, 0x0a, 0x28, 0x76, 0x6d, 0x77, 0x61, 0x72, 0x65, 0x65, 0x6e, 0x67, 0x69, 0x6e, 0x65,
	0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f,
	0x50, 0x72, 0x69, 0x76, 0x61, 0x74, 0x65, 0x43, 0x6c, 0x6f, 0x75, 0x64, 0x52, 0x06, 0x70, 0x61,
	0x72, 0x65, 0x6e, 0x74, 0x12, 0x1b, 0x0a, 0x09, 0x70, 0x61, 0x67, 0x65, 0x5f, 0x73, 0x69, 0x7a,
	0x65, 0x18, 0x02, 0x20, 0x01, 0x28, 0x05, 0x52, 0x08, 0x70, 0x61, 0x67, 0x65, 0x53, 0x69, 0x7a,
	0x65, 0x12, 0x1d, 0x0a, 0x0a, 0x70, 0x61, 0x67, 0x65, 0x5f, 0x74, 0x6f, 0x6b, 0x65, 0x6e, 0x18,
	0x03, 0x20, 0x01, 0x28, 0x09, 0x52, 0x09, 0x70, 0x61, 0x67, 0x65, 0x54, 0x6f, 0x6b, 0x65, 0x6e,
	0x12, 0x16, 0x0a, 0x06, 0x66, 0x69, 0x6c, 0x74, 0x65, 0x72, 0x18, 0x04, 0x20, 0x01, 0x28, 0x09,
	0x52, 0x06, 0x66, 0x69, 0x6c, 0x74, 0x65, 0x72, 0x12, 0x19, 0x0a, 0x08, 0x6f, 0x72, 0x64, 0x65,
	0x72, 0x5f, 0x62, 0x79, 0x18, 0x05, 0x20, 0x01, 0x28, 0x09, 0x52, 0x07, 0x6f, 0x72, 0x64, 0x65,
	0x72, 0x42, 0x79, 0x22, 0xa3, 0x01, 0x0a, 0x14, 0x4c, 0x69, 0x73, 0x74, 0x43, 0x6c, 0x75, 0x73,
	0x74, 0x65, 0x72, 0x73, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x12, 0x41, 0x0a, 0x08,
	0x63, 0x6c, 0x75, 0x73, 0x74, 0x65, 0x72, 0x73, 0x18, 0x01, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x25,
	0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x76, 0x6d,
	0x77, 0x61, 0x72, 0x65, 0x65, 0x6e, 0x67, 0x69, 0x6e, 0x65, 0x2e, 0x76, 0x31, 0x2e, 0x43, 0x6c,
	0x75, 0x73, 0x74, 0x65, 0x72, 0x52, 0x08, 0x63, 0x6c, 0x75, 0x73, 0x74, 0x65, 0x72, 0x73, 0x12,
	0x26, 0x0a, 0x0f, 0x6e, 0x65, 0x78, 0x74, 0x5f, 0x70, 0x61, 0x67, 0x65, 0x5f, 0x74, 0x6f, 0x6b,
	0x65, 0x6e, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x52, 0x0d, 0x6e, 0x65, 0x78, 0x74, 0x50, 0x61,
	0x67, 0x65, 0x54, 0x6f, 0x6b, 0x65, 0x6e, 0x12, 0x20, 0x0a, 0x0b, 0x75, 0x6e, 0x72, 0x65, 0x61,
	0x63, 0x68, 0x61, 0x62, 0x6c, 0x65, 0x18, 0x03, 0x20, 0x03, 0x28, 0x09, 0x52, 0x0b, 0x75, 0x6e,
	0x72, 0x65, 0x61, 0x63, 0x68, 0x61, 0x62, 0x6c, 0x65, 0x22, 0x54, 0x0a, 0x11, 0x47, 0x65, 0x74,
	0x43, 0x6c, 0x75, 0x73, 0x74, 0x65, 0x72, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x3f,
	0x0a, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x2b, 0xe0, 0x41,
	0x02, 0xfa, 0x41, 0x25, 0x0a, 0x23, 0x76, 0x6d, 0x77, 0x61, 0x72, 0x65, 0x65, 0x6e, 0x67, 0x69,
	0x6e, 0x65, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f,
	0x6d, 0x2f, 0x43, 0x6c, 0x75, 0x73, 0x74, 0x65, 0x72, 0x52, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x22,
	0x98, 0x02, 0x0a, 0x14, 0x43, 0x72, 0x65, 0x61, 0x74, 0x65, 0x43, 0x6c, 0x75, 0x73, 0x74, 0x65,
	0x72, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x48, 0x0a, 0x06, 0x70, 0x61, 0x72, 0x65,
	0x6e, 0x74, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x30, 0xe0, 0x41, 0x02, 0xfa, 0x41, 0x2a,
	0x0a, 0x28, 0x76, 0x6d, 0x77, 0x61, 0x72, 0x65, 0x65, 0x6e, 0x67, 0x69, 0x6e, 0x65, 0x2e, 0x67,
	0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x50, 0x72,
	0x69, 0x76, 0x61, 0x74, 0x65, 0x43, 0x6c, 0x6f, 0x75, 0x64, 0x52, 0x06, 0x70, 0x61, 0x72, 0x65,
	0x6e, 0x74, 0x12, 0x22, 0x0a, 0x0a, 0x63, 0x6c, 0x75, 0x73, 0x74, 0x65, 0x72, 0x5f, 0x69, 0x64,
	0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x02, 0x52, 0x09, 0x63, 0x6c, 0x75,
	0x73, 0x74, 0x65, 0x72, 0x49, 0x64, 0x12, 0x44, 0x0a, 0x07, 0x63, 0x6c, 0x75, 0x73, 0x74, 0x65,
	0x72, 0x18, 0x03, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x25, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65,
	0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x76, 0x6d, 0x77, 0x61, 0x72, 0x65, 0x65, 0x6e, 0x67,
	0x69, 0x6e, 0x65, 0x2e, 0x76, 0x31, 0x2e, 0x43, 0x6c, 0x75, 0x73, 0x74, 0x65, 0x72, 0x42, 0x03,
	0xe0, 0x41, 0x02, 0x52, 0x07, 0x63, 0x6c, 0x75, 0x73, 0x74, 0x65, 0x72, 0x12, 0x22, 0x0a, 0x0a,
	0x72, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x5f, 0x69, 0x64, 0x18, 0x04, 0x20, 0x01, 0x28, 0x09,
	0x42, 0x03, 0xe0, 0x41, 0x01, 0x52, 0x09, 0x72, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x49, 0x64,
	0x12, 0x28, 0x0a, 0x0d, 0x76, 0x61, 0x6c, 0x69, 0x64, 0x61, 0x74, 0x65, 0x5f, 0x6f, 0x6e, 0x6c,
	0x79, 0x18, 0x05, 0x20, 0x01, 0x28, 0x08, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x52, 0x0c, 0x76, 0x61,
	0x6c, 0x69, 0x64, 0x61, 0x74, 0x65, 0x4f, 0x6e, 0x6c, 0x79, 0x22, 0xec, 0x01, 0x0a, 0x14, 0x55,
	0x70, 0x64, 0x61, 0x74, 0x65, 0x43, 0x6c, 0x75, 0x73, 0x74, 0x65, 0x72, 0x52, 0x65, 0x71, 0x75,
	0x65, 0x73, 0x74, 0x12, 0x40, 0x0a, 0x0b, 0x75, 0x70, 0x64, 0x61, 0x74, 0x65, 0x5f, 0x6d, 0x61,
	0x73, 0x6b, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1a, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c,
	0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x46, 0x69, 0x65, 0x6c, 0x64,
	0x4d, 0x61, 0x73, 0x6b, 0x42, 0x03, 0xe0, 0x41, 0x02, 0x52, 0x0a, 0x75, 0x70, 0x64, 0x61, 0x74,
	0x65, 0x4d, 0x61, 0x73, 0x6b, 0x12, 0x44, 0x0a, 0x07, 0x63, 0x6c, 0x75, 0x73, 0x74, 0x65, 0x72,
	0x18, 0x02, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x25, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e,
	0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x76, 0x6d, 0x77, 0x61, 0x72, 0x65, 0x65, 0x6e, 0x67, 0x69,
	0x6e, 0x65, 0x2e, 0x76, 0x31, 0x2e, 0x43, 0x6c, 0x75, 0x73, 0x74, 0x65, 0x72, 0x42, 0x03, 0xe0,
	0x41, 0x02, 0x52, 0x07, 0x63, 0x6c, 0x75, 0x73, 0x74, 0x65, 0x72, 0x12, 0x22, 0x0a, 0x0a, 0x72,
	0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x5f, 0x69, 0x64, 0x18, 0x03, 0x20, 0x01, 0x28, 0x09, 0x42,
	0x03, 0xe0, 0x41, 0x01, 0x52, 0x09, 0x72, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x49, 0x64, 0x12,
	0x28, 0x0a, 0x0d, 0x76, 0x61, 0x6c, 0x69, 0x64, 0x61, 0x74, 0x65, 0x5f, 0x6f, 0x6e, 0x6c, 0x79,
	0x18, 0x04, 0x20, 0x01, 0x28, 0x08, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x52, 0x0c, 0x76, 0x61, 0x6c,
	0x69, 0x64, 0x61, 0x74, 0x65, 0x4f, 0x6e, 0x6c, 0x79, 0x22, 0x7b, 0x0a, 0x14, 0x44, 0x65, 0x6c,
	0x65, 0x74, 0x65, 0x43, 0x6c, 0x75, 0x73, 0x74, 0x65, 0x72, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73,
	0x74, 0x12, 0x3f, 0x0a, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42,
	0x2b, 0xe0, 0x41, 0x02, 0xfa, 0x41, 0x25, 0x0a, 0x23, 0x76, 0x6d, 0x77, 0x61, 0x72, 0x65, 0x65,
	0x6e, 0x67, 0x69, 0x6e, 0x65, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73,
	0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x43, 0x6c, 0x75, 0x73, 0x74, 0x65, 0x72, 0x52, 0x04, 0x6e, 0x61,
	0x6d, 0x65, 0x12, 0x22, 0x0a, 0x0a, 0x72, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x5f, 0x69, 0x64,
	0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x52, 0x09, 0x72, 0x65, 0x71,
	0x75, 0x65, 0x73, 0x74, 0x49, 0x64, 0x22, 0x9a, 0x01, 0x0a, 0x12, 0x4c, 0x69, 0x73, 0x74, 0x53,
	0x75, 0x62, 0x6e, 0x65, 0x74, 0x73, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x48, 0x0a,
	0x06, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x30, 0xe0,
	0x41, 0x02, 0xfa, 0x41, 0x2a, 0x0a, 0x28, 0x76, 0x6d, 0x77, 0x61, 0x72, 0x65, 0x65, 0x6e, 0x67,
	0x69, 0x6e, 0x65, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63,
	0x6f, 0x6d, 0x2f, 0x50, 0x72, 0x69, 0x76, 0x61, 0x74, 0x65, 0x43, 0x6c, 0x6f, 0x75, 0x64, 0x52,
	0x06, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x12, 0x1b, 0x0a, 0x09, 0x70, 0x61, 0x67, 0x65, 0x5f,
	0x73, 0x69, 0x7a, 0x65, 0x18, 0x02, 0x20, 0x01, 0x28, 0x05, 0x52, 0x08, 0x70, 0x61, 0x67, 0x65,
	0x53, 0x69, 0x7a, 0x65, 0x12, 0x1d, 0x0a, 0x0a, 0x70, 0x61, 0x67, 0x65, 0x5f, 0x74, 0x6f, 0x6b,
	0x65, 0x6e, 0x18, 0x03, 0x20, 0x01, 0x28, 0x09, 0x52, 0x09, 0x70, 0x61, 0x67, 0x65, 0x54, 0x6f,
	0x6b, 0x65, 0x6e, 0x22, 0x9f, 0x01, 0x0a, 0x13, 0x4c, 0x69, 0x73, 0x74, 0x53, 0x75, 0x62, 0x6e,
	0x65, 0x74, 0x73, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x12, 0x3e, 0x0a, 0x07, 0x73,
	0x75, 0x62, 0x6e, 0x65, 0x74, 0x73, 0x18, 0x01, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x24, 0x2e, 0x67,
	0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x76, 0x6d, 0x77, 0x61,
	0x72, 0x65, 0x65, 0x6e, 0x67, 0x69, 0x6e, 0x65, 0x2e, 0x76, 0x31, 0x2e, 0x53, 0x75, 0x62, 0x6e,
	0x65, 0x74, 0x52, 0x07, 0x73, 0x75, 0x62, 0x6e, 0x65, 0x74, 0x73, 0x12, 0x26, 0x0a, 0x0f, 0x6e,
	0x65, 0x78, 0x74, 0x5f, 0x70, 0x61, 0x67, 0x65, 0x5f, 0x74, 0x6f, 0x6b, 0x65, 0x6e, 0x18, 0x02,
	0x20, 0x01, 0x28, 0x09, 0x52, 0x0d, 0x6e, 0x65, 0x78, 0x74, 0x50, 0x61, 0x67, 0x65, 0x54, 0x6f,
	0x6b, 0x65, 0x6e, 0x12, 0x20, 0x0a, 0x0b, 0x75, 0x6e, 0x72, 0x65, 0x61, 0x63, 0x68, 0x61, 0x62,
	0x6c, 0x65, 0x18, 0x03, 0x20, 0x03, 0x28, 0x09, 0x52, 0x0b, 0x75, 0x6e, 0x72, 0x65, 0x61, 0x63,
	0x68, 0x61, 0x62, 0x6c, 0x65, 0x22, 0x52, 0x0a, 0x10, 0x47, 0x65, 0x74, 0x53, 0x75, 0x62, 0x6e,
	0x65, 0x74, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x3e, 0x0a, 0x04, 0x6e, 0x61, 0x6d,
	0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x2a, 0xe0, 0x41, 0x02, 0xfa, 0x41, 0x24, 0x0a,
	0x22, 0x76, 0x6d, 0x77, 0x61, 0x72, 0x65, 0x65, 0x6e, 0x67, 0x69, 0x6e, 0x65, 0x2e, 0x67, 0x6f,
	0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x53, 0x75, 0x62,
	0x6e, 0x65, 0x74, 0x52, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x22, 0x9a, 0x01, 0x0a, 0x13, 0x55, 0x70,
	0x64, 0x61, 0x74, 0x65, 0x53, 0x75, 0x62, 0x6e, 0x65, 0x74, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73,
	0x74, 0x12, 0x40, 0x0a, 0x0b, 0x75, 0x70, 0x64, 0x61, 0x74, 0x65, 0x5f, 0x6d, 0x61, 0x73, 0x6b,
	0x18, 0x01, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1a, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e,
	0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x46, 0x69, 0x65, 0x6c, 0x64, 0x4d, 0x61,
	0x73, 0x6b, 0x42, 0x03, 0xe0, 0x41, 0x02, 0x52, 0x0a, 0x75, 0x70, 0x64, 0x61, 0x74, 0x65, 0x4d,
	0x61, 0x73, 0x6b, 0x12, 0x41, 0x0a, 0x06, 0x73, 0x75, 0x62, 0x6e, 0x65, 0x74, 0x18, 0x02, 0x20,
	0x01, 0x28, 0x0b, 0x32, 0x24, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f,
	0x75, 0x64, 0x2e, 0x76, 0x6d, 0x77, 0x61, 0x72, 0x65, 0x65, 0x6e, 0x67, 0x69, 0x6e, 0x65, 0x2e,
	0x76, 0x31, 0x2e, 0x53, 0x75, 0x62, 0x6e, 0x65, 0x74, 0x42, 0x03, 0xe0, 0x41, 0x02, 0x52, 0x06,
	0x73, 0x75, 0x62, 0x6e, 0x65, 0x74, 0x22, 0xd5, 0x02, 0x0a, 0x11, 0x4f, 0x70, 0x65, 0x72, 0x61,
	0x74, 0x69, 0x6f, 0x6e, 0x4d, 0x65, 0x74, 0x61, 0x64, 0x61, 0x74, 0x61, 0x12, 0x40, 0x0a, 0x0b,
	0x63, 0x72, 0x65, 0x61, 0x74, 0x65, 0x5f, 0x74, 0x69, 0x6d, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28,
	0x0b, 0x32, 0x1a, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f,
	0x62, 0x75, 0x66, 0x2e, 0x54, 0x69, 0x6d, 0x65, 0x73, 0x74, 0x61, 0x6d, 0x70, 0x42, 0x03, 0xe0,
	0x41, 0x03, 0x52, 0x0a, 0x63, 0x72, 0x65, 0x61, 0x74, 0x65, 0x54, 0x69, 0x6d, 0x65, 0x12, 0x3a,
	0x0a, 0x08, 0x65, 0x6e, 0x64, 0x5f, 0x74, 0x69, 0x6d, 0x65, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0b,
	0x32, 0x1a, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62,
	0x75, 0x66, 0x2e, 0x54, 0x69, 0x6d, 0x65, 0x73, 0x74, 0x61, 0x6d, 0x70, 0x42, 0x03, 0xe0, 0x41,
	0x03, 0x52, 0x07, 0x65, 0x6e, 0x64, 0x54, 0x69, 0x6d, 0x65, 0x12, 0x1b, 0x0a, 0x06, 0x74, 0x61,
	0x72, 0x67, 0x65, 0x74, 0x18, 0x03, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x03, 0x52,
	0x06, 0x74, 0x61, 0x72, 0x67, 0x65, 0x74, 0x12, 0x17, 0x0a, 0x04, 0x76, 0x65, 0x72, 0x62, 0x18,
	0x04, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x03, 0x52, 0x04, 0x76, 0x65, 0x72, 0x62,
	0x12, 0x2a, 0x0a, 0x0e, 0x73, 0x74, 0x61, 0x74, 0x75, 0x73, 0x5f, 0x6d, 0x65, 0x73, 0x73, 0x61,
	0x67, 0x65, 0x18, 0x05, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x03, 0x52, 0x0d, 0x73,
	0x74, 0x61, 0x74, 0x75, 0x73, 0x4d, 0x65, 0x73, 0x73, 0x61, 0x67, 0x65, 0x12, 0x3a, 0x0a, 0x16,
	0x72, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x65, 0x64, 0x5f, 0x63, 0x61, 0x6e, 0x63, 0x65, 0x6c,
	0x6c, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x18, 0x06, 0x20, 0x01, 0x28, 0x08, 0x42, 0x03, 0xe0, 0x41,
	0x03, 0x52, 0x15, 0x72, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x65, 0x64, 0x43, 0x61, 0x6e, 0x63,
	0x65, 0x6c, 0x6c, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x12, 0x24, 0x0a, 0x0b, 0x61, 0x70, 0x69, 0x5f,
	0x76, 0x65, 0x72, 0x73, 0x69, 0x6f, 0x6e, 0x18, 0x07, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0,
	0x41, 0x03, 0x52, 0x0a, 0x61, 0x70, 0x69, 0x56, 0x65, 0x72, 0x73, 0x69, 0x6f, 0x6e, 0x22, 0xad,
	0x01, 0x0a, 0x14, 0x4c, 0x69, 0x73, 0x74, 0x4e, 0x6f, 0x64, 0x65, 0x54, 0x79, 0x70, 0x65, 0x73,
	0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x41, 0x0a, 0x06, 0x70, 0x61, 0x72, 0x65, 0x6e,
	0x74, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x29, 0xe0, 0x41, 0x02, 0xfa, 0x41, 0x23, 0x0a,
	0x21, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c,
	0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x4c, 0x6f, 0x63, 0x61, 0x74, 0x69,
	0x6f, 0x6e, 0x52, 0x06, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x12, 0x1b, 0x0a, 0x09, 0x70, 0x61,
	0x67, 0x65, 0x5f, 0x73, 0x69, 0x7a, 0x65, 0x18, 0x02, 0x20, 0x01, 0x28, 0x05, 0x52, 0x08, 0x70,
	0x61, 0x67, 0x65, 0x53, 0x69, 0x7a, 0x65, 0x12, 0x1d, 0x0a, 0x0a, 0x70, 0x61, 0x67, 0x65, 0x5f,
	0x74, 0x6f, 0x6b, 0x65, 0x6e, 0x18, 0x03, 0x20, 0x01, 0x28, 0x09, 0x52, 0x09, 0x70, 0x61, 0x67,
	0x65, 0x54, 0x6f, 0x6b, 0x65, 0x6e, 0x12, 0x16, 0x0a, 0x06, 0x66, 0x69, 0x6c, 0x74, 0x65, 0x72,
	0x18, 0x04, 0x20, 0x01, 0x28, 0x09, 0x52, 0x06, 0x66, 0x69, 0x6c, 0x74, 0x65, 0x72, 0x22, 0xa8,
	0x01, 0x0a, 0x15, 0x4c, 0x69, 0x73, 0x74, 0x4e, 0x6f, 0x64, 0x65, 0x54, 0x79, 0x70, 0x65, 0x73,
	0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x12, 0x45, 0x0a, 0x0a, 0x6e, 0x6f, 0x64, 0x65,
	0x5f, 0x74, 0x79, 0x70, 0x65, 0x73, 0x18, 0x01, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x26, 0x2e, 0x67,
	0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x76, 0x6d, 0x77, 0x61,
	0x72, 0x65, 0x65, 0x6e, 0x67, 0x69, 0x6e, 0x65, 0x2e, 0x76, 0x31, 0x2e, 0x4e, 0x6f, 0x64, 0x65,
	0x54, 0x79, 0x70, 0x65, 0x52, 0x09, 0x6e, 0x6f, 0x64, 0x65, 0x54, 0x79, 0x70, 0x65, 0x73, 0x12,
	0x26, 0x0a, 0x0f, 0x6e, 0x65, 0x78, 0x74, 0x5f, 0x70, 0x61, 0x67, 0x65, 0x5f, 0x74, 0x6f, 0x6b,
	0x65, 0x6e, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x52, 0x0d, 0x6e, 0x65, 0x78, 0x74, 0x50, 0x61,
	0x67, 0x65, 0x54, 0x6f, 0x6b, 0x65, 0x6e, 0x12, 0x20, 0x0a, 0x0b, 0x75, 0x6e, 0x72, 0x65, 0x61,
	0x63, 0x68, 0x61, 0x62, 0x6c, 0x65, 0x18, 0x03, 0x20, 0x03, 0x28, 0x09, 0x52, 0x0b, 0x75, 0x6e,
	0x72, 0x65, 0x61, 0x63, 0x68, 0x61, 0x62, 0x6c, 0x65, 0x22, 0x56, 0x0a, 0x12, 0x47, 0x65, 0x74,
	0x4e, 0x6f, 0x64, 0x65, 0x54, 0x79, 0x70, 0x65, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12,
	0x40, 0x0a, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x2c, 0xe0,
	0x41, 0x02, 0xfa, 0x41, 0x26, 0x0a, 0x24, 0x76, 0x6d, 0x77, 0x61, 0x72, 0x65, 0x65, 0x6e, 0x67,
	0x69, 0x6e, 0x65, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63,
	0x6f, 0x6d, 0x2f, 0x4e, 0x6f, 0x64, 0x65, 0x54, 0x79, 0x70, 0x65, 0x52, 0x04, 0x6e, 0x61, 0x6d,
	0x65, 0x22, 0x72, 0x0a, 0x19, 0x53, 0x68, 0x6f, 0x77, 0x4e, 0x73, 0x78, 0x43, 0x72, 0x65, 0x64,
	0x65, 0x6e, 0x74, 0x69, 0x61, 0x6c, 0x73, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x55,
	0x0a, 0x0d, 0x70, 0x72, 0x69, 0x76, 0x61, 0x74, 0x65, 0x5f, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x18,
	0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x30, 0xe0, 0x41, 0x02, 0xfa, 0x41, 0x2a, 0x0a, 0x28, 0x76,
	0x6d, 0x77, 0x61, 0x72, 0x65, 0x65, 0x6e, 0x67, 0x69, 0x6e, 0x65, 0x2e, 0x67, 0x6f, 0x6f, 0x67,
	0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x50, 0x72, 0x69, 0x76, 0x61,
	0x74, 0x65, 0x43, 0x6c, 0x6f, 0x75, 0x64, 0x52, 0x0c, 0x70, 0x72, 0x69, 0x76, 0x61, 0x74, 0x65,
	0x43, 0x6c, 0x6f, 0x75, 0x64, 0x22, 0x76, 0x0a, 0x1d, 0x53, 0x68, 0x6f, 0x77, 0x56, 0x63, 0x65,
	0x6e, 0x74, 0x65, 0x72, 0x43, 0x72, 0x65, 0x64, 0x65, 0x6e, 0x74, 0x69, 0x61, 0x6c, 0x73, 0x52,
	0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x55, 0x0a, 0x0d, 0x70, 0x72, 0x69, 0x76, 0x61, 0x74,
	0x65, 0x5f, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x30, 0xe0,
	0x41, 0x02, 0xfa, 0x41, 0x2a, 0x0a, 0x28, 0x76, 0x6d, 0x77, 0x61, 0x72, 0x65, 0x65, 0x6e, 0x67,
	0x69, 0x6e, 0x65, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63,
	0x6f, 0x6d, 0x2f, 0x50, 0x72, 0x69, 0x76, 0x61, 0x74, 0x65, 0x43, 0x6c, 0x6f, 0x75, 0x64, 0x52,
	0x0c, 0x70, 0x72, 0x69, 0x76, 0x61, 0x74, 0x65, 0x43, 0x6c, 0x6f, 0x75, 0x64, 0x22, 0x97, 0x01,
	0x0a, 0x1a, 0x52, 0x65, 0x73, 0x65, 0x74, 0x4e, 0x73, 0x78, 0x43, 0x72, 0x65, 0x64, 0x65, 0x6e,
	0x74, 0x69, 0x61, 0x6c, 0x73, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x55, 0x0a, 0x0d,
	0x70, 0x72, 0x69, 0x76, 0x61, 0x74, 0x65, 0x5f, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x18, 0x01, 0x20,
	0x01, 0x28, 0x09, 0x42, 0x30, 0xe0, 0x41, 0x02, 0xfa, 0x41, 0x2a, 0x0a, 0x28, 0x76, 0x6d, 0x77,
	0x61, 0x72, 0x65, 0x65, 0x6e, 0x67, 0x69, 0x6e, 0x65, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65,
	0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x50, 0x72, 0x69, 0x76, 0x61, 0x74, 0x65,
	0x43, 0x6c, 0x6f, 0x75, 0x64, 0x52, 0x0c, 0x70, 0x72, 0x69, 0x76, 0x61, 0x74, 0x65, 0x43, 0x6c,
	0x6f, 0x75, 0x64, 0x12, 0x22, 0x0a, 0x0a, 0x72, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x5f, 0x69,
	0x64, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x52, 0x09, 0x72, 0x65,
	0x71, 0x75, 0x65, 0x73, 0x74, 0x49, 0x64, 0x22, 0x9b, 0x01, 0x0a, 0x1e, 0x52, 0x65, 0x73, 0x65,
	0x74, 0x56, 0x63, 0x65, 0x6e, 0x74, 0x65, 0x72, 0x43, 0x72, 0x65, 0x64, 0x65, 0x6e, 0x74, 0x69,
	0x61, 0x6c, 0x73, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x55, 0x0a, 0x0d, 0x70, 0x72,
	0x69, 0x76, 0x61, 0x74, 0x65, 0x5f, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x18, 0x01, 0x20, 0x01, 0x28,
	0x09, 0x42, 0x30, 0xe0, 0x41, 0x02, 0xfa, 0x41, 0x2a, 0x0a, 0x28, 0x76, 0x6d, 0x77, 0x61, 0x72,
	0x65, 0x65, 0x6e, 0x67, 0x69, 0x6e, 0x65, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70,
	0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x50, 0x72, 0x69, 0x76, 0x61, 0x74, 0x65, 0x43, 0x6c,
	0x6f, 0x75, 0x64, 0x52, 0x0c, 0x70, 0x72, 0x69, 0x76, 0x61, 0x74, 0x65, 0x43, 0x6c, 0x6f, 0x75,
	0x64, 0x12, 0x22, 0x0a, 0x0a, 0x72, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x5f, 0x69, 0x64, 0x18,
	0x02, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x52, 0x09, 0x72, 0x65, 0x71, 0x75,
	0x65, 0x73, 0x74, 0x49, 0x64, 0x22, 0xc9, 0x01, 0x0a, 0x1d, 0x4c, 0x69, 0x73, 0x74, 0x48, 0x63,
	0x78, 0x41, 0x63, 0x74, 0x69, 0x76, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x4b, 0x65, 0x79, 0x73, 0x52,
	0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x12, 0x5e, 0x0a, 0x13, 0x68, 0x63, 0x78, 0x5f, 0x61,
	0x63, 0x74, 0x69, 0x76, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x5f, 0x6b, 0x65, 0x79, 0x73, 0x18, 0x01,
	0x20, 0x03, 0x28, 0x0b, 0x32, 0x2e, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c,
	0x6f, 0x75, 0x64, 0x2e, 0x76, 0x6d, 0x77, 0x61, 0x72, 0x65, 0x65, 0x6e, 0x67, 0x69, 0x6e, 0x65,
	0x2e, 0x76, 0x31, 0x2e, 0x48, 0x63, 0x78, 0x41, 0x63, 0x74, 0x69, 0x76, 0x61, 0x74, 0x69, 0x6f,
	0x6e, 0x4b, 0x65, 0x79, 0x52, 0x11, 0x68, 0x63, 0x78, 0x41, 0x63, 0x74, 0x69, 0x76, 0x61, 0x74,
	0x69, 0x6f, 0x6e, 0x4b, 0x65, 0x79, 0x73, 0x12, 0x26, 0x0a, 0x0f, 0x6e, 0x65, 0x78, 0x74, 0x5f,
	0x70, 0x61, 0x67, 0x65, 0x5f, 0x74, 0x6f, 0x6b, 0x65, 0x6e, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09,
	0x52, 0x0d, 0x6e, 0x65, 0x78, 0x74, 0x50, 0x61, 0x67, 0x65, 0x54, 0x6f, 0x6b, 0x65, 0x6e, 0x12,
	0x20, 0x0a, 0x0b, 0x75, 0x6e, 0x72, 0x65, 0x61, 0x63, 0x68, 0x61, 0x62, 0x6c, 0x65, 0x18, 0x03,
	0x20, 0x03, 0x28, 0x09, 0x52, 0x0b, 0x75, 0x6e, 0x72, 0x65, 0x61, 0x63, 0x68, 0x61, 0x62, 0x6c,
	0x65, 0x22, 0xa4, 0x01, 0x0a, 0x1c, 0x4c, 0x69, 0x73, 0x74, 0x48, 0x63, 0x78, 0x41, 0x63, 0x74,
	0x69, 0x76, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x4b, 0x65, 0x79, 0x73, 0x52, 0x65, 0x71, 0x75, 0x65,
	0x73, 0x74, 0x12, 0x48, 0x0a, 0x06, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x18, 0x01, 0x20, 0x01,
	0x28, 0x09, 0x42, 0x30, 0xe0, 0x41, 0x02, 0xfa, 0x41, 0x2a, 0x0a, 0x28, 0x76, 0x6d, 0x77, 0x61,
	0x72, 0x65, 0x65, 0x6e, 0x67, 0x69, 0x6e, 0x65, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61,
	0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x50, 0x72, 0x69, 0x76, 0x61, 0x74, 0x65, 0x43,
	0x6c, 0x6f, 0x75, 0x64, 0x52, 0x06, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x12, 0x1b, 0x0a, 0x09,
	0x70, 0x61, 0x67, 0x65, 0x5f, 0x73, 0x69, 0x7a, 0x65, 0x18, 0x02, 0x20, 0x01, 0x28, 0x05, 0x52,
	0x08, 0x70, 0x61, 0x67, 0x65, 0x53, 0x69, 0x7a, 0x65, 0x12, 0x1d, 0x0a, 0x0a, 0x70, 0x61, 0x67,
	0x65, 0x5f, 0x74, 0x6f, 0x6b, 0x65, 0x6e, 0x18, 0x03, 0x20, 0x01, 0x28, 0x09, 0x52, 0x09, 0x70,
	0x61, 0x67, 0x65, 0x54, 0x6f, 0x6b, 0x65, 0x6e, 0x22, 0x66, 0x0a, 0x1a, 0x47, 0x65, 0x74, 0x48,
	0x63, 0x78, 0x41, 0x63, 0x74, 0x69, 0x76, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x4b, 0x65, 0x79, 0x52,
	0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x48, 0x0a, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x18, 0x01,
	0x20, 0x01, 0x28, 0x09, 0x42, 0x34, 0xe0, 0x41, 0x02, 0xfa, 0x41, 0x2e, 0x0a, 0x2c, 0x76, 0x6d,
	0x77, 0x61, 0x72, 0x65, 0x65, 0x6e, 0x67, 0x69, 0x6e, 0x65, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c,
	0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x48, 0x63, 0x78, 0x41, 0x63, 0x74,
	0x69, 0x76, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x4b, 0x65, 0x79, 0x52, 0x04, 0x6e, 0x61, 0x6d, 0x65,
	0x22, 0xa3, 0x02, 0x0a, 0x1d, 0x43, 0x72, 0x65, 0x61, 0x74, 0x65, 0x48, 0x63, 0x78, 0x41, 0x63,
	0x74, 0x69, 0x76, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x4b, 0x65, 0x79, 0x52, 0x65, 0x71, 0x75, 0x65,
	0x73, 0x74, 0x12, 0x48, 0x0a, 0x06, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x18, 0x01, 0x20, 0x01,
	0x28, 0x09, 0x42, 0x30, 0xe0, 0x41, 0x02, 0xfa, 0x41, 0x2a, 0x0a, 0x28, 0x76, 0x6d, 0x77, 0x61,
	0x72, 0x65, 0x65, 0x6e, 0x67, 0x69, 0x6e, 0x65, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61,
	0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x50, 0x72, 0x69, 0x76, 0x61, 0x74, 0x65, 0x43,
	0x6c, 0x6f, 0x75, 0x64, 0x52, 0x06, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x12, 0x61, 0x0a, 0x12,
	0x68, 0x63, 0x78, 0x5f, 0x61, 0x63, 0x74, 0x69, 0x76, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x5f, 0x6b,
	0x65, 0x79, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x2e, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c,
	0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x76, 0x6d, 0x77, 0x61, 0x72, 0x65, 0x65, 0x6e,
	0x67, 0x69, 0x6e, 0x65, 0x2e, 0x76, 0x31, 0x2e, 0x48, 0x63, 0x78, 0x41, 0x63, 0x74, 0x69, 0x76,
	0x61, 0x74, 0x69, 0x6f, 0x6e, 0x4b, 0x65, 0x79, 0x42, 0x03, 0xe0, 0x41, 0x02, 0x52, 0x10, 0x68,
	0x63, 0x78, 0x41, 0x63, 0x74, 0x69, 0x76, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x4b, 0x65, 0x79, 0x12,
	0x36, 0x0a, 0x15, 0x68, 0x63, 0x78, 0x5f, 0x61, 0x63, 0x74, 0x69, 0x76, 0x61, 0x74, 0x69, 0x6f,
	0x6e, 0x5f, 0x6b, 0x65, 0x79, 0x5f, 0x69, 0x64, 0x18, 0x03, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03,
	0xe0, 0x41, 0x02, 0x52, 0x12, 0x68, 0x63, 0x78, 0x41, 0x63, 0x74, 0x69, 0x76, 0x61, 0x74, 0x69,
	0x6f, 0x6e, 0x4b, 0x65, 0x79, 0x49, 0x64, 0x12, 0x1d, 0x0a, 0x0a, 0x72, 0x65, 0x71, 0x75, 0x65,
	0x73, 0x74, 0x5f, 0x69, 0x64, 0x18, 0x04, 0x20, 0x01, 0x28, 0x09, 0x52, 0x09, 0x72, 0x65, 0x71,
	0x75, 0x65, 0x73, 0x74, 0x49, 0x64, 0x22, 0xd6, 0x01, 0x0a, 0x1a, 0x4c, 0x69, 0x73, 0x74, 0x4e,
	0x65, 0x74, 0x77, 0x6f, 0x72, 0x6b, 0x50, 0x6f, 0x6c, 0x69, 0x63, 0x69, 0x65, 0x73, 0x52, 0x65,
	0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x49, 0x0a, 0x06, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x18,
	0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x31, 0xe0, 0x41, 0x02, 0xfa, 0x41, 0x2b, 0x12, 0x29, 0x76,
	0x6d, 0x77, 0x61, 0x72, 0x65, 0x65, 0x6e, 0x67, 0x69, 0x6e, 0x65, 0x2e, 0x67, 0x6f, 0x6f, 0x67,
	0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x4e, 0x65, 0x74, 0x77, 0x6f,
	0x72, 0x6b, 0x50, 0x6f, 0x6c, 0x69, 0x63, 0x79, 0x52, 0x06, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74,
	0x12, 0x1b, 0x0a, 0x09, 0x70, 0x61, 0x67, 0x65, 0x5f, 0x73, 0x69, 0x7a, 0x65, 0x18, 0x02, 0x20,
	0x01, 0x28, 0x05, 0x52, 0x08, 0x70, 0x61, 0x67, 0x65, 0x53, 0x69, 0x7a, 0x65, 0x12, 0x1d, 0x0a,
	0x0a, 0x70, 0x61, 0x67, 0x65, 0x5f, 0x74, 0x6f, 0x6b, 0x65, 0x6e, 0x18, 0x03, 0x20, 0x01, 0x28,
	0x09, 0x52, 0x09, 0x70, 0x61, 0x67, 0x65, 0x54, 0x6f, 0x6b, 0x65, 0x6e, 0x12, 0x16, 0x0a, 0x06,
	0x66, 0x69, 0x6c, 0x74, 0x65, 0x72, 0x18, 0x04, 0x20, 0x01, 0x28, 0x09, 0x52, 0x06, 0x66, 0x69,
	0x6c, 0x74, 0x65, 0x72, 0x12, 0x19, 0x0a, 0x08, 0x6f, 0x72, 0x64, 0x65, 0x72, 0x5f, 0x62, 0x79,
	0x18, 0x05, 0x20, 0x01, 0x28, 0x09, 0x52, 0x07, 0x6f, 0x72, 0x64, 0x65, 0x72, 0x42, 0x79, 0x22,
	0xbf, 0x01, 0x0a, 0x1b, 0x4c, 0x69, 0x73, 0x74, 0x4e, 0x65, 0x74, 0x77, 0x6f, 0x72, 0x6b, 0x50,
	0x6f, 0x6c, 0x69, 0x63, 0x69, 0x65, 0x73, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x12,
	0x56, 0x0a, 0x10, 0x6e, 0x65, 0x74, 0x77, 0x6f, 0x72, 0x6b, 0x5f, 0x70, 0x6f, 0x6c, 0x69, 0x63,
	0x69, 0x65, 0x73, 0x18, 0x01, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x2b, 0x2e, 0x67, 0x6f, 0x6f, 0x67,
	0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x76, 0x6d, 0x77, 0x61, 0x72, 0x65, 0x65,
	0x6e, 0x67, 0x69, 0x6e, 0x65, 0x2e, 0x76, 0x31, 0x2e, 0x4e, 0x65, 0x74, 0x77, 0x6f, 0x72, 0x6b,
	0x50, 0x6f, 0x6c, 0x69, 0x63, 0x79, 0x52, 0x0f, 0x6e, 0x65, 0x74, 0x77, 0x6f, 0x72, 0x6b, 0x50,
	0x6f, 0x6c, 0x69, 0x63, 0x69, 0x65, 0x73, 0x12, 0x26, 0x0a, 0x0f, 0x6e, 0x65, 0x78, 0x74, 0x5f,
	0x70, 0x61, 0x67, 0x65, 0x5f, 0x74, 0x6f, 0x6b, 0x65, 0x6e, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09,
	0x52, 0x0d, 0x6e, 0x65, 0x78, 0x74, 0x50, 0x61, 0x67, 0x65, 0x54, 0x6f, 0x6b, 0x65, 0x6e, 0x12,
	0x20, 0x0a, 0x0b, 0x75, 0x6e, 0x72, 0x65, 0x61, 0x63, 0x68, 0x61, 0x62, 0x6c, 0x65, 0x18, 0x03,
	0x20, 0x03, 0x28, 0x09, 0x52, 0x0b, 0x75, 0x6e, 0x72, 0x65, 0x61, 0x63, 0x68, 0x61, 0x62, 0x6c,
	0x65, 0x22, 0x60, 0x0a, 0x17, 0x47, 0x65, 0x74, 0x4e, 0x65, 0x74, 0x77, 0x6f, 0x72, 0x6b, 0x50,
	0x6f, 0x6c, 0x69, 0x63, 0x79, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x45, 0x0a, 0x04,
	0x6e, 0x61, 0x6d, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x31, 0xe0, 0x41, 0x02, 0xfa,
	0x41, 0x2b, 0x0a, 0x29, 0x76, 0x6d, 0x77, 0x61, 0x72, 0x65, 0x65, 0x6e, 0x67, 0x69, 0x6e, 0x65,
	0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f,
	0x4e, 0x65, 0x74, 0x77, 0x6f, 0x72, 0x6b, 0x50, 0x6f, 0x6c, 0x69, 0x63, 0x79, 0x52, 0x04, 0x6e,
	0x61, 0x6d, 0x65, 0x22, 0xdb, 0x01, 0x0a, 0x1a, 0x55, 0x70, 0x64, 0x61, 0x74, 0x65, 0x4e, 0x65,
	0x74, 0x77, 0x6f, 0x72, 0x6b, 0x50, 0x6f, 0x6c, 0x69, 0x63, 0x79, 0x52, 0x65, 0x71, 0x75, 0x65,
	0x73, 0x74, 0x12, 0x57, 0x0a, 0x0e, 0x6e, 0x65, 0x74, 0x77, 0x6f, 0x72, 0x6b, 0x5f, 0x70, 0x6f,
	0x6c, 0x69, 0x63, 0x79, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x2b, 0x2e, 0x67, 0x6f, 0x6f,
	0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x76, 0x6d, 0x77, 0x61, 0x72, 0x65,
	0x65, 0x6e, 0x67, 0x69, 0x6e, 0x65, 0x2e, 0x76, 0x31, 0x2e, 0x4e, 0x65, 0x74, 0x77, 0x6f, 0x72,
	0x6b, 0x50, 0x6f, 0x6c, 0x69, 0x63, 0x79, 0x42, 0x03, 0xe0, 0x41, 0x02, 0x52, 0x0d, 0x6e, 0x65,
	0x74, 0x77, 0x6f, 0x72, 0x6b, 0x50, 0x6f, 0x6c, 0x69, 0x63, 0x79, 0x12, 0x40, 0x0a, 0x0b, 0x75,
	0x70, 0x64, 0x61, 0x74, 0x65, 0x5f, 0x6d, 0x61, 0x73, 0x6b, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0b,
	0x32, 0x1a, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62,
	0x75, 0x66, 0x2e, 0x46, 0x69, 0x65, 0x6c, 0x64, 0x4d, 0x61, 0x73, 0x6b, 0x42, 0x03, 0xe0, 0x41,
	0x02, 0x52, 0x0a, 0x75, 0x70, 0x64, 0x61, 0x74, 0x65, 0x4d, 0x61, 0x73, 0x6b, 0x12, 0x22, 0x0a,
	0x0a, 0x72, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x5f, 0x69, 0x64, 0x18, 0x03, 0x20, 0x01, 0x28,
	0x09, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x52, 0x09, 0x72, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x49,
	0x64, 0x22, 0x95, 0x02, 0x0a, 0x1a, 0x43, 0x72, 0x65, 0x61, 0x74, 0x65, 0x4e, 0x65, 0x74, 0x77,
	0x6f, 0x72, 0x6b, 0x50, 0x6f, 0x6c, 0x69, 0x63, 0x79, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74,
	0x12, 0x49, 0x0a, 0x06, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09,
	0x42, 0x31, 0xe0, 0x41, 0x02, 0xfa, 0x41, 0x2b, 0x12, 0x29, 0x76, 0x6d, 0x77, 0x61, 0x72, 0x65,
	0x65, 0x6e, 0x67, 0x69, 0x6e, 0x65, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69,
	0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x4e, 0x65, 0x74, 0x77, 0x6f, 0x72, 0x6b, 0x50, 0x6f, 0x6c,
	0x69, 0x63, 0x79, 0x52, 0x06, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x12, 0x2f, 0x0a, 0x11, 0x6e,
	0x65, 0x74, 0x77, 0x6f, 0x72, 0x6b, 0x5f, 0x70, 0x6f, 0x6c, 0x69, 0x63, 0x79, 0x5f, 0x69, 0x64,
	0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x02, 0x52, 0x0f, 0x6e, 0x65, 0x74,
	0x77, 0x6f, 0x72, 0x6b, 0x50, 0x6f, 0x6c, 0x69, 0x63, 0x79, 0x49, 0x64, 0x12, 0x57, 0x0a, 0x0e,
	0x6e, 0x65, 0x74, 0x77, 0x6f, 0x72, 0x6b, 0x5f, 0x70, 0x6f, 0x6c, 0x69, 0x63, 0x79, 0x18, 0x03,
	0x20, 0x01, 0x28, 0x0b, 0x32, 0x2b, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c,
	0x6f, 0x75, 0x64, 0x2e, 0x76, 0x6d, 0x77, 0x61, 0x72, 0x65, 0x65, 0x6e, 0x67, 0x69, 0x6e, 0x65,
	0x2e, 0x76, 0x31, 0x2e, 0x4e, 0x65, 0x74, 0x77, 0x6f, 0x72, 0x6b, 0x50, 0x6f, 0x6c, 0x69, 0x63,
	0x79, 0x42, 0x03, 0xe0, 0x41, 0x02, 0x52, 0x0d, 0x6e, 0x65, 0x74, 0x77, 0x6f, 0x72, 0x6b, 0x50,
	0x6f, 0x6c, 0x69, 0x63, 0x79, 0x12, 0x22, 0x0a, 0x0a, 0x72, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74,
	0x5f, 0x69, 0x64, 0x18, 0x04, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x52, 0x09,
	0x72, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x49, 0x64, 0x22, 0x87, 0x01, 0x0a, 0x1a, 0x44, 0x65,
	0x6c, 0x65, 0x74, 0x65, 0x4e, 0x65, 0x74, 0x77, 0x6f, 0x72, 0x6b, 0x50, 0x6f, 0x6c, 0x69, 0x63,
	0x79, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x45, 0x0a, 0x04, 0x6e, 0x61, 0x6d, 0x65,
	0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x31, 0xe0, 0x41, 0x02, 0xfa, 0x41, 0x2b, 0x0a, 0x29,
	0x76, 0x6d, 0x77, 0x61, 0x72, 0x65, 0x65, 0x6e, 0x67, 0x69, 0x6e, 0x65, 0x2e, 0x67, 0x6f, 0x6f,
	0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x4e, 0x65, 0x74, 0x77,
	0x6f, 0x72, 0x6b, 0x50, 0x6f, 0x6c, 0x69, 0x63, 0x79, 0x52, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x12,
	0x22, 0x0a, 0x0a, 0x72, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x5f, 0x69, 0x64, 0x18, 0x02, 0x20,
	0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x52, 0x09, 0x72, 0x65, 0x71, 0x75, 0x65, 0x73,
	0x74, 0x49, 0x64, 0x22, 0xc1, 0x02, 0x0a, 0x20, 0x43, 0x72, 0x65, 0x61, 0x74, 0x65, 0x56, 0x6d,
	0x77, 0x61, 0x72, 0x65, 0x45, 0x6e, 0x67, 0x69, 0x6e, 0x65, 0x4e, 0x65, 0x74, 0x77, 0x6f, 0x72,
	0x6b, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x4f, 0x0a, 0x06, 0x70, 0x61, 0x72, 0x65,
	0x6e, 0x74, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x37, 0xe0, 0x41, 0x02, 0xfa, 0x41, 0x31,
	0x12, 0x2f, 0x76, 0x6d, 0x77, 0x61, 0x72, 0x65, 0x65, 0x6e, 0x67, 0x69, 0x6e, 0x65, 0x2e, 0x67,
	0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x56, 0x6d,
	0x77, 0x61, 0x72, 0x65, 0x45, 0x6e, 0x67, 0x69, 0x6e, 0x65, 0x4e, 0x65, 0x74, 0x77, 0x6f, 0x72,
	0x6b, 0x52, 0x06, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x12, 0x3c, 0x0a, 0x18, 0x76, 0x6d, 0x77,
	0x61, 0x72, 0x65, 0x5f, 0x65, 0x6e, 0x67, 0x69, 0x6e, 0x65, 0x5f, 0x6e, 0x65, 0x74, 0x77, 0x6f,
	0x72, 0x6b, 0x5f, 0x69, 0x64, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x02,
	0x52, 0x15, 0x76, 0x6d, 0x77, 0x61, 0x72, 0x65, 0x45, 0x6e, 0x67, 0x69, 0x6e, 0x65, 0x4e, 0x65,
	0x74, 0x77, 0x6f, 0x72, 0x6b, 0x49, 0x64, 0x12, 0x6a, 0x0a, 0x15, 0x76, 0x6d, 0x77, 0x61, 0x72,
	0x65, 0x5f, 0x65, 0x6e, 0x67, 0x69, 0x6e, 0x65, 0x5f, 0x6e, 0x65, 0x74, 0x77, 0x6f, 0x72, 0x6b,
	0x18, 0x03, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x31, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e,
	0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x76, 0x6d, 0x77, 0x61, 0x72, 0x65, 0x65, 0x6e, 0x67, 0x69,
	0x6e, 0x65, 0x2e, 0x76, 0x31, 0x2e, 0x56, 0x6d, 0x77, 0x61, 0x72, 0x65, 0x45, 0x6e, 0x67, 0x69,
	0x6e, 0x65, 0x4e, 0x65, 0x74, 0x77, 0x6f, 0x72, 0x6b, 0x42, 0x03, 0xe0, 0x41, 0x02, 0x52, 0x13,
	0x76, 0x6d, 0x77, 0x61, 0x72, 0x65, 0x45, 0x6e, 0x67, 0x69, 0x6e, 0x65, 0x4e, 0x65, 0x74, 0x77,
	0x6f, 0x72, 0x6b, 0x12, 0x22, 0x0a, 0x0a, 0x72, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x5f, 0x69,
	0x64, 0x18, 0x04, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x52, 0x09, 0x72, 0x65,
	0x71, 0x75, 0x65, 0x73, 0x74, 0x49, 0x64, 0x22, 0xf4, 0x01, 0x0a, 0x20, 0x55, 0x70, 0x64, 0x61,
	0x74, 0x65, 0x56, 0x6d, 0x77, 0x61, 0x72, 0x65, 0x45, 0x6e, 0x67, 0x69, 0x6e, 0x65, 0x4e, 0x65,
	0x74, 0x77, 0x6f, 0x72, 0x6b, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x6a, 0x0a, 0x15,
	0x76, 0x6d, 0x77, 0x61, 0x72, 0x65, 0x5f, 0x65, 0x6e, 0x67, 0x69, 0x6e, 0x65, 0x5f, 0x6e, 0x65,
	0x74, 0x77, 0x6f, 0x72, 0x6b, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x31, 0x2e, 0x67, 0x6f,
	0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x76, 0x6d, 0x77, 0x61, 0x72,
	0x65, 0x65, 0x6e, 0x67, 0x69, 0x6e, 0x65, 0x2e, 0x76, 0x31, 0x2e, 0x56, 0x6d, 0x77, 0x61, 0x72,
	0x65, 0x45, 0x6e, 0x67, 0x69, 0x6e, 0x65, 0x4e, 0x65, 0x74, 0x77, 0x6f, 0x72, 0x6b, 0x42, 0x03,
	0xe0, 0x41, 0x02, 0x52, 0x13, 0x76, 0x6d, 0x77, 0x61, 0x72, 0x65, 0x45, 0x6e, 0x67, 0x69, 0x6e,
	0x65, 0x4e, 0x65, 0x74, 0x77, 0x6f, 0x72, 0x6b, 0x12, 0x40, 0x0a, 0x0b, 0x75, 0x70, 0x64, 0x61,
	0x74, 0x65, 0x5f, 0x6d, 0x61, 0x73, 0x6b, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1a, 0x2e,
	0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e,
	0x46, 0x69, 0x65, 0x6c, 0x64, 0x4d, 0x61, 0x73, 0x6b, 0x42, 0x03, 0xe0, 0x41, 0x02, 0x52, 0x0a,
	0x75, 0x70, 0x64, 0x61, 0x74, 0x65, 0x4d, 0x61, 0x73, 0x6b, 0x12, 0x22, 0x0a, 0x0a, 0x72, 0x65,
	0x71, 0x75, 0x65, 0x73, 0x74, 0x5f, 0x69, 0x64, 0x18, 0x03, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03,
	0xe0, 0x41, 0x01, 0x52, 0x09, 0x72, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x49, 0x64, 0x22, 0xac,
	0x01, 0x0a, 0x20, 0x44, 0x65, 0x6c, 0x65, 0x74, 0x65, 0x56, 0x6d, 0x77, 0x61, 0x72, 0x65, 0x45,
	0x6e, 0x67, 0x69, 0x6e, 0x65, 0x4e, 0x65, 0x74, 0x77, 0x6f, 0x72, 0x6b, 0x52, 0x65, 0x71, 0x75,
	0x65, 0x73, 0x74, 0x12, 0x4b, 0x0a, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28,
	0x09, 0x42, 0x37, 0xe0, 0x41, 0x02, 0xfa, 0x41, 0x31, 0x0a, 0x2f, 0x76, 0x6d, 0x77, 0x61, 0x72,
	0x65, 0x65, 0x6e, 0x67, 0x69, 0x6e, 0x65, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70,
	0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x56, 0x6d, 0x77, 0x61, 0x72, 0x65, 0x45, 0x6e, 0x67,
	0x69, 0x6e, 0x65, 0x4e, 0x65, 0x74, 0x77, 0x6f, 0x72, 0x6b, 0x52, 0x04, 0x6e, 0x61, 0x6d, 0x65,
	0x12, 0x22, 0x0a, 0x0a, 0x72, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x5f, 0x69, 0x64, 0x18, 0x02,
	0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x52, 0x09, 0x72, 0x65, 0x71, 0x75, 0x65,
	0x73, 0x74, 0x49, 0x64, 0x12, 0x17, 0x0a, 0x04, 0x65, 0x74, 0x61, 0x67, 0x18, 0x03, 0x20, 0x01,
	0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x52, 0x04, 0x65, 0x74, 0x61, 0x67, 0x22, 0x6c, 0x0a,
	0x1d, 0x47, 0x65, 0x74, 0x56, 0x6d, 0x77, 0x61, 0x72, 0x65, 0x45, 0x6e, 0x67, 0x69, 0x6e, 0x65,
	0x4e, 0x65, 0x74, 0x77, 0x6f, 0x72, 0x6b, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x4b,
	0x0a, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x37, 0xe0, 0x41,
	0x02, 0xfa, 0x41, 0x31, 0x0a, 0x2f, 0x76, 0x6d, 0x77, 0x61, 0x72, 0x65, 0x65, 0x6e, 0x67, 0x69,
	0x6e, 0x65, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f,
	0x6d, 0x2f, 0x56, 0x6d, 0x77, 0x61, 0x72, 0x65, 0x45, 0x6e, 0x67, 0x69, 0x6e, 0x65, 0x4e, 0x65,
	0x74, 0x77, 0x6f, 0x72, 0x6b, 0x52, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x22, 0xd3, 0x01, 0x0a, 0x1f,
	0x4c, 0x69, 0x73, 0x74, 0x56, 0x6d, 0x77, 0x61, 0x72, 0x65, 0x45, 0x6e, 0x67, 0x69, 0x6e, 0x65,
	0x4e, 0x65, 0x74, 0x77, 0x6f, 0x72, 0x6b, 0x73, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12,
	0x41, 0x0a, 0x06, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42,
	0x29, 0xe0, 0x41, 0x02, 0xfa, 0x41, 0x23, 0x0a, 0x21, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f,
	0x6e, 0x73, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f,
	0x6d, 0x2f, 0x4c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x52, 0x06, 0x70, 0x61, 0x72, 0x65,
	0x6e, 0x74, 0x12, 0x1b, 0x0a, 0x09, 0x70, 0x61, 0x67, 0x65, 0x5f, 0x73, 0x69, 0x7a, 0x65, 0x18,
	0x02, 0x20, 0x01, 0x28, 0x05, 0x52, 0x08, 0x70, 0x61, 0x67, 0x65, 0x53, 0x69, 0x7a, 0x65, 0x12,
	0x1d, 0x0a, 0x0a, 0x70, 0x61, 0x67, 0x65, 0x5f, 0x74, 0x6f, 0x6b, 0x65, 0x6e, 0x18, 0x03, 0x20,
	0x01, 0x28, 0x09, 0x52, 0x09, 0x70, 0x61, 0x67, 0x65, 0x54, 0x6f, 0x6b, 0x65, 0x6e, 0x12, 0x16,
	0x0a, 0x06, 0x66, 0x69, 0x6c, 0x74, 0x65, 0x72, 0x18, 0x04, 0x20, 0x01, 0x28, 0x09, 0x52, 0x06,
	0x66, 0x69, 0x6c, 0x74, 0x65, 0x72, 0x12, 0x19, 0x0a, 0x08, 0x6f, 0x72, 0x64, 0x65, 0x72, 0x5f,
	0x62, 0x79, 0x18, 0x05, 0x20, 0x01, 0x28, 0x09, 0x52, 0x07, 0x6f, 0x72, 0x64, 0x65, 0x72, 0x42,
	0x79, 0x22, 0xd5, 0x01, 0x0a, 0x20, 0x4c, 0x69, 0x73, 0x74, 0x56, 0x6d, 0x77, 0x61, 0x72, 0x65,
	0x45, 0x6e, 0x67, 0x69, 0x6e, 0x65, 0x4e, 0x65, 0x74, 0x77, 0x6f, 0x72, 0x6b, 0x73, 0x52, 0x65,
	0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x12, 0x67, 0x0a, 0x16, 0x76, 0x6d, 0x77, 0x61, 0x72, 0x65,
	0x5f, 0x65, 0x6e, 0x67, 0x69, 0x6e, 0x65, 0x5f, 0x6e, 0x65, 0x74, 0x77, 0x6f, 0x72, 0x6b, 0x73,
	0x18, 0x01, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x31, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e,
	0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x76, 0x6d, 0x77, 0x61, 0x72, 0x65, 0x65, 0x6e, 0x67, 0x69,
	0x6e, 0x65, 0x2e, 0x76, 0x31, 0x2e, 0x56, 0x6d, 0x77, 0x61, 0x72, 0x65, 0x45, 0x6e, 0x67, 0x69,
	0x6e, 0x65, 0x4e, 0x65, 0x74, 0x77, 0x6f, 0x72, 0x6b, 0x52, 0x14, 0x76, 0x6d, 0x77, 0x61, 0x72,
	0x65, 0x45, 0x6e, 0x67, 0x69, 0x6e, 0x65, 0x4e, 0x65, 0x74, 0x77, 0x6f, 0x72, 0x6b, 0x73, 0x12,
	0x26, 0x0a, 0x0f, 0x6e, 0x65, 0x78, 0x74, 0x5f, 0x70, 0x61, 0x67, 0x65, 0x5f, 0x74, 0x6f, 0x6b,
	0x65, 0x6e, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x52, 0x0d, 0x6e, 0x65, 0x78, 0x74, 0x50, 0x61,
	0x67, 0x65, 0x54, 0x6f, 0x6b, 0x65, 0x6e, 0x12, 0x20, 0x0a, 0x0b, 0x75, 0x6e, 0x72, 0x65, 0x61,
	0x63, 0x68, 0x61, 0x62, 0x6c, 0x65, 0x18, 0x03, 0x20, 0x03, 0x28, 0x09, 0x52, 0x0b, 0x75, 0x6e,
	0x72, 0x65, 0x61, 0x63, 0x68, 0x61, 0x62, 0x6c, 0x65, 0x22, 0xb1, 0x02, 0x0a, 0x1e, 0x43, 0x72,
	0x65, 0x61, 0x74, 0x65, 0x50, 0x72, 0x69, 0x76, 0x61, 0x74, 0x65, 0x43, 0x6f, 0x6e, 0x6e, 0x65,
	0x63, 0x74, 0x69, 0x6f, 0x6e, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x4d, 0x0a, 0x06,
	0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x35, 0xe0, 0x41,
	0x02, 0xfa, 0x41, 0x2f, 0x12, 0x2d, 0x76, 0x6d, 0x77, 0x61, 0x72, 0x65, 0x65, 0x6e, 0x67, 0x69,
	0x6e, 0x65, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f,
	0x6d, 0x2f, 0x50, 0x72, 0x69, 0x76, 0x61, 0x74, 0x65, 0x43, 0x6f, 0x6e, 0x6e, 0x65, 0x63, 0x74,
	0x69, 0x6f, 0x6e, 0x52, 0x06, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x12, 0x37, 0x0a, 0x15, 0x70,
	0x72, 0x69, 0x76, 0x61, 0x74, 0x65, 0x5f, 0x63, 0x6f, 0x6e, 0x6e, 0x65, 0x63, 0x74, 0x69, 0x6f,
	0x6e, 0x5f, 0x69, 0x64, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x02, 0x52,
	0x13, 0x70, 0x72, 0x69, 0x76, 0x61, 0x74, 0x65, 0x43, 0x6f, 0x6e, 0x6e, 0x65, 0x63, 0x74, 0x69,
	0x6f, 0x6e, 0x49, 0x64, 0x12, 0x63, 0x0a, 0x12, 0x70, 0x72, 0x69, 0x76, 0x61, 0x74, 0x65, 0x5f,
	0x63, 0x6f, 0x6e, 0x6e, 0x65, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x18, 0x03, 0x20, 0x01, 0x28, 0x0b,
	0x32, 0x2f, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e,
	0x76, 0x6d, 0x77, 0x61, 0x72, 0x65, 0x65, 0x6e, 0x67, 0x69, 0x6e, 0x65, 0x2e, 0x76, 0x31, 0x2e,
	0x50, 0x72, 0x69, 0x76, 0x61, 0x74, 0x65, 0x43, 0x6f, 0x6e, 0x6e, 0x65, 0x63, 0x74, 0x69, 0x6f,
	0x6e, 0x42, 0x03, 0xe0, 0x41, 0x02, 0x52, 0x11, 0x70, 0x72, 0x69, 0x76, 0x61, 0x74, 0x65, 0x43,
	0x6f, 0x6e, 0x6e, 0x65, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x12, 0x22, 0x0a, 0x0a, 0x72, 0x65, 0x71,
	0x75, 0x65, 0x73, 0x74, 0x5f, 0x69, 0x64, 0x18, 0x04, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0,
	0x41, 0x01, 0x52, 0x09, 0x72, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x49, 0x64, 0x22, 0x68, 0x0a,
	0x1b, 0x47, 0x65, 0x74, 0x50, 0x72, 0x69, 0x76, 0x61, 0x74, 0x65, 0x43, 0x6f, 0x6e, 0x6e, 0x65,
	0x63, 0x74, 0x69, 0x6f, 0x6e, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x49, 0x0a, 0x04,
	0x6e, 0x61, 0x6d, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x35, 0xe0, 0x41, 0x02, 0xfa,
	0x41, 0x2f, 0x0a, 0x2d, 0x76, 0x6d, 0x77, 0x61, 0x72, 0x65, 0x65, 0x6e, 0x67, 0x69, 0x6e, 0x65,
	0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f,
	0x50, 0x72, 0x69, 0x76, 0x61, 0x74, 0x65, 0x43, 0x6f, 0x6e, 0x6e, 0x65, 0x63, 0x74, 0x69, 0x6f,
	0x6e, 0x52, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x22, 0xdd, 0x01, 0x0a, 0x1d, 0x4c, 0x69, 0x73, 0x74,
	0x50, 0x72, 0x69, 0x76, 0x61, 0x74, 0x65, 0x43, 0x6f, 0x6e, 0x6e, 0x65, 0x63, 0x74, 0x69, 0x6f,
	0x6e, 0x73, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x4d, 0x0a, 0x06, 0x70, 0x61, 0x72,
	0x65, 0x6e, 0x74, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x35, 0xe0, 0x41, 0x02, 0xfa, 0x41,
	0x2f, 0x12, 0x2d, 0x76, 0x6d, 0x77, 0x61, 0x72, 0x65, 0x65, 0x6e, 0x67, 0x69, 0x6e, 0x65, 0x2e,
	0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x50,
	0x72, 0x69, 0x76, 0x61, 0x74, 0x65, 0x43, 0x6f, 0x6e, 0x6e, 0x65, 0x63, 0x74, 0x69, 0x6f, 0x6e,
	0x52, 0x06, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x12, 0x1b, 0x0a, 0x09, 0x70, 0x61, 0x67, 0x65,
	0x5f, 0x73, 0x69, 0x7a, 0x65, 0x18, 0x02, 0x20, 0x01, 0x28, 0x05, 0x52, 0x08, 0x70, 0x61, 0x67,
	0x65, 0x53, 0x69, 0x7a, 0x65, 0x12, 0x1d, 0x0a, 0x0a, 0x70, 0x61, 0x67, 0x65, 0x5f, 0x74, 0x6f,
	0x6b, 0x65, 0x6e, 0x18, 0x03, 0x20, 0x01, 0x28, 0x09, 0x52, 0x09, 0x70, 0x61, 0x67, 0x65, 0x54,
	0x6f, 0x6b, 0x65, 0x6e, 0x12, 0x16, 0x0a, 0x06, 0x66, 0x69, 0x6c, 0x74, 0x65, 0x72, 0x18, 0x04,
	0x20, 0x01, 0x28, 0x09, 0x52, 0x06, 0x66, 0x69, 0x6c, 0x74, 0x65, 0x72, 0x12, 0x19, 0x0a, 0x08,
	0x6f, 0x72, 0x64, 0x65, 0x72, 0x5f, 0x62, 0x79, 0x18, 0x05, 0x20, 0x01, 0x28, 0x09, 0x52, 0x07,
	0x6f, 0x72, 0x64, 0x65, 0x72, 0x42, 0x79, 0x22, 0xcc, 0x01, 0x0a, 0x1e, 0x4c, 0x69, 0x73, 0x74,
	0x50, 0x72, 0x69, 0x76, 0x61, 0x74, 0x65, 0x43, 0x6f, 0x6e, 0x6e, 0x65, 0x63, 0x74, 0x69, 0x6f,
	0x6e, 0x73, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x12, 0x60, 0x0a, 0x13, 0x70, 0x72,
	0x69, 0x76, 0x61, 0x74, 0x65, 0x5f, 0x63, 0x6f, 0x6e, 0x6e, 0x65, 0x63, 0x74, 0x69, 0x6f, 0x6e,
	0x73, 0x18, 0x01, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x2f, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65,
	0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x76, 0x6d, 0x77, 0x61, 0x72, 0x65, 0x65, 0x6e, 0x67,
	0x69, 0x6e, 0x65, 0x2e, 0x76, 0x31, 0x2e, 0x50, 0x72, 0x69, 0x76, 0x61, 0x74, 0x65, 0x43, 0x6f,
	0x6e, 0x6e, 0x65, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x52, 0x12, 0x70, 0x72, 0x69, 0x76, 0x61, 0x74,
	0x65, 0x43, 0x6f, 0x6e, 0x6e, 0x65, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x12, 0x26, 0x0a, 0x0f,
	0x6e, 0x65, 0x78, 0x74, 0x5f, 0x70, 0x61, 0x67, 0x65, 0x5f, 0x74, 0x6f, 0x6b, 0x65, 0x6e, 0x18,
	0x02, 0x20, 0x01, 0x28, 0x09, 0x52, 0x0d, 0x6e, 0x65, 0x78, 0x74, 0x50, 0x61, 0x67, 0x65, 0x54,
	0x6f, 0x6b, 0x65, 0x6e, 0x12, 0x20, 0x0a, 0x0b, 0x75, 0x6e, 0x72, 0x65, 0x61, 0x63, 0x68, 0x61,
	0x62, 0x6c, 0x65, 0x18, 0x03, 0x20, 0x03, 0x28, 0x09, 0x52, 0x0b, 0x75, 0x6e, 0x72, 0x65, 0x61,
	0x63, 0x68, 0x61, 0x62, 0x6c, 0x65, 0x22, 0xeb, 0x01, 0x0a, 0x1e, 0x55, 0x70, 0x64, 0x61, 0x74,
	0x65, 0x50, 0x72, 0x69, 0x76, 0x61, 0x74, 0x65, 0x43, 0x6f, 0x6e, 0x6e, 0x65, 0x63, 0x74, 0x69,
	0x6f, 0x6e, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x63, 0x0a, 0x12, 0x70, 0x72, 0x69,
	0x76, 0x61, 0x74, 0x65, 0x5f, 0x63, 0x6f, 0x6e, 0x6e, 0x65, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x18,
	0x01, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x2f, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63,
	0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x76, 0x6d, 0x77, 0x61, 0x72, 0x65, 0x65, 0x6e, 0x67, 0x69, 0x6e,
	0x65, 0x2e, 0x76, 0x31, 0x2e, 0x50, 0x72, 0x69, 0x76, 0x61, 0x74, 0x65, 0x43, 0x6f, 0x6e, 0x6e,
	0x65, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x42, 0x03, 0xe0, 0x41, 0x02, 0x52, 0x11, 0x70, 0x72, 0x69,
	0x76, 0x61, 0x74, 0x65, 0x43, 0x6f, 0x6e, 0x6e, 0x65, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x12, 0x40,
	0x0a, 0x0b, 0x75, 0x70, 0x64, 0x61, 0x74, 0x65, 0x5f, 0x6d, 0x61, 0x73, 0x6b, 0x18, 0x02, 0x20,
	0x01, 0x28, 0x0b, 0x32, 0x1a, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f,
	0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x46, 0x69, 0x65, 0x6c, 0x64, 0x4d, 0x61, 0x73, 0x6b, 0x42,
	0x03, 0xe0, 0x41, 0x02, 0x52, 0x0a, 0x75, 0x70, 0x64, 0x61, 0x74, 0x65, 0x4d, 0x61, 0x73, 0x6b,
	0x12, 0x22, 0x0a, 0x0a, 0x72, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x5f, 0x69, 0x64, 0x18, 0x03,
	0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x52, 0x09, 0x72, 0x65, 0x71, 0x75, 0x65,
	0x73, 0x74, 0x49, 0x64, 0x22, 0x8f, 0x01, 0x0a, 0x1e, 0x44, 0x65, 0x6c, 0x65, 0x74, 0x65, 0x50,
	0x72, 0x69, 0x76, 0x61, 0x74, 0x65, 0x43, 0x6f, 0x6e, 0x6e, 0x65, 0x63, 0x74, 0x69, 0x6f, 0x6e,
	0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x49, 0x0a, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x18,
	0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x35, 0xe0, 0x41, 0x02, 0xfa, 0x41, 0x2f, 0x0a, 0x2d, 0x76,
	0x6d, 0x77, 0x61, 0x72, 0x65, 0x65, 0x6e, 0x67, 0x69, 0x6e, 0x65, 0x2e, 0x67, 0x6f, 0x6f, 0x67,
	0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x50, 0x72, 0x69, 0x76, 0x61,
	0x74, 0x65, 0x43, 0x6f, 0x6e, 0x6e, 0x65, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x52, 0x04, 0x6e, 0x61,
	0x6d, 0x65, 0x12, 0x22, 0x0a, 0x0a, 0x72, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x5f, 0x69, 0x64,
	0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x52, 0x09, 0x72, 0x65, 0x71,
	0x75, 0x65, 0x73, 0x74, 0x49, 0x64, 0x22, 0xb6, 0x01, 0x0a, 0x29, 0x4c, 0x69, 0x73, 0x74, 0x50,
	0x72, 0x69, 0x76, 0x61, 0x74, 0x65, 0x43, 0x6f, 0x6e, 0x6e, 0x65, 0x63, 0x74, 0x69, 0x6f, 0x6e,
	0x50, 0x65, 0x65, 0x72, 0x69, 0x6e, 0x67, 0x52, 0x6f, 0x75, 0x74, 0x65, 0x73, 0x52, 0x65, 0x71,
	0x75, 0x65, 0x73, 0x74, 0x12, 0x4d, 0x0a, 0x06, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x18, 0x01,
	0x20, 0x01, 0x28, 0x09, 0x42, 0x35, 0xe0, 0x41, 0x02, 0xfa, 0x41, 0x2f, 0x0a, 0x2d, 0x76, 0x6d,
	0x77, 0x61, 0x72, 0x65, 0x65, 0x6e, 0x67, 0x69, 0x6e, 0x65, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c,
	0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x50, 0x72, 0x69, 0x76, 0x61, 0x74,
	0x65, 0x43, 0x6f, 0x6e, 0x6e, 0x65, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x52, 0x06, 0x70, 0x61, 0x72,
	0x65, 0x6e, 0x74, 0x12, 0x1b, 0x0a, 0x09, 0x70, 0x61, 0x67, 0x65, 0x5f, 0x73, 0x69, 0x7a, 0x65,
	0x18, 0x02, 0x20, 0x01, 0x28, 0x05, 0x52, 0x08, 0x70, 0x61, 0x67, 0x65, 0x53, 0x69, 0x7a, 0x65,
	0x12, 0x1d, 0x0a, 0x0a, 0x70, 0x61, 0x67, 0x65, 0x5f, 0x74, 0x6f, 0x6b, 0x65, 0x6e, 0x18, 0x03,
	0x20, 0x01, 0x28, 0x09, 0x52, 0x09, 0x70, 0x61, 0x67, 0x65, 0x54, 0x6f, 0x6b, 0x65, 0x6e, 0x22,
	0xa7, 0x01, 0x0a, 0x2a, 0x4c, 0x69, 0x73, 0x74, 0x50, 0x72, 0x69, 0x76, 0x61, 0x74, 0x65, 0x43,
	0x6f, 0x6e, 0x6e, 0x65, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x50, 0x65, 0x65, 0x72, 0x69, 0x6e, 0x67,
	0x52, 0x6f, 0x75, 0x74, 0x65, 0x73, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x12, 0x51,
	0x0a, 0x0e, 0x70, 0x65, 0x65, 0x72, 0x69, 0x6e, 0x67, 0x5f, 0x72, 0x6f, 0x75, 0x74, 0x65, 0x73,
	0x18, 0x01, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x2a, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e,
	0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x76, 0x6d, 0x77, 0x61, 0x72, 0x65, 0x65, 0x6e, 0x67, 0x69,
	0x6e, 0x65, 0x2e, 0x76, 0x31, 0x2e, 0x50, 0x65, 0x65, 0x72, 0x69, 0x6e, 0x67, 0x52, 0x6f, 0x75,
	0x74, 0x65, 0x52, 0x0d, 0x70, 0x65, 0x65, 0x72, 0x69, 0x6e, 0x67, 0x52, 0x6f, 0x75, 0x74, 0x65,
	0x73, 0x12, 0x26, 0x0a, 0x0f, 0x6e, 0x65, 0x78, 0x74, 0x5f, 0x70, 0x61, 0x67, 0x65, 0x5f, 0x74,
	0x6f, 0x6b, 0x65, 0x6e, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x52, 0x0d, 0x6e, 0x65, 0x78, 0x74,
	0x50, 0x61, 0x67, 0x65, 0x54, 0x6f, 0x6b, 0x65, 0x6e, 0x32, 0xb0, 0x48, 0x0a, 0x0c, 0x56, 0x6d,
	0x77, 0x61, 0x72, 0x65, 0x45, 0x6e, 0x67, 0x69, 0x6e, 0x65, 0x12, 0xc8, 0x01, 0x0a, 0x11, 0x4c,
	0x69, 0x73, 0x74, 0x50, 0x72, 0x69, 0x76, 0x61, 0x74, 0x65, 0x43, 0x6c, 0x6f, 0x75, 0x64, 0x73,
	0x12, 0x36, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e,
	0x76, 0x6d, 0x77, 0x61, 0x72, 0x65, 0x65, 0x6e, 0x67, 0x69, 0x6e, 0x65, 0x2e, 0x76, 0x31, 0x2e,
	0x4c, 0x69, 0x73, 0x74, 0x50, 0x72, 0x69, 0x76, 0x61, 0x74, 0x65, 0x43, 0x6c, 0x6f, 0x75, 0x64,
	0x73, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x1a, 0x37, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c,
	0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x76, 0x6d, 0x77, 0x61, 0x72, 0x65, 0x65, 0x6e,
	0x67, 0x69, 0x6e, 0x65, 0x2e, 0x76, 0x31, 0x2e, 0x4c, 0x69, 0x73, 0x74, 0x50, 0x72, 0x69, 0x76,
	0x61, 0x74, 0x65, 0x43, 0x6c, 0x6f, 0x75, 0x64, 0x73, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73,
	0x65, 0x22, 0x42, 0xda, 0x41, 0x06, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x82, 0xd3, 0xe4, 0x93,
	0x02, 0x33, 0x12, 0x31, 0x2f, 0x76, 0x31, 0x2f, 0x7b, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x3d,
	0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x73, 0x2f, 0x2a, 0x2f, 0x6c, 0x6f, 0x63, 0x61, 0x74,
	0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x2a, 0x7d, 0x2f, 0x70, 0x72, 0x69, 0x76, 0x61, 0x74, 0x65, 0x43,
	0x6c, 0x6f, 0x75, 0x64, 0x73, 0x12, 0xb5, 0x01, 0x0a, 0x0f, 0x47, 0x65, 0x74, 0x50, 0x72, 0x69,
	0x76, 0x61, 0x74, 0x65, 0x43, 0x6c, 0x6f, 0x75, 0x64, 0x12, 0x34, 0x2e, 0x67, 0x6f, 0x6f, 0x67,
	0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x76, 0x6d, 0x77, 0x61, 0x72, 0x65, 0x65,
	0x6e, 0x67, 0x69, 0x6e, 0x65, 0x2e, 0x76, 0x31, 0x2e, 0x47, 0x65, 0x74, 0x50, 0x72, 0x69, 0x76,
	0x61, 0x74, 0x65, 0x43, 0x6c, 0x6f, 0x75, 0x64, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x1a,
	0x2a, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x76,
	0x6d, 0x77, 0x61, 0x72, 0x65, 0x65, 0x6e, 0x67, 0x69, 0x6e, 0x65, 0x2e, 0x76, 0x31, 0x2e, 0x50,
	0x72, 0x69, 0x76, 0x61, 0x74, 0x65, 0x43, 0x6c, 0x6f, 0x75, 0x64, 0x22, 0x40, 0xda, 0x41, 0x04,
	0x6e, 0x61, 0x6d, 0x65, 0x82, 0xd3, 0xe4, 0x93, 0x02, 0x33, 0x12, 0x31, 0x2f, 0x76, 0x31, 0x2f,
	0x7b, 0x6e, 0x61, 0x6d, 0x65, 0x3d, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x73, 0x2f, 0x2a,
	0x2f, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x2a, 0x2f, 0x70, 0x72, 0x69,
	0x76, 0x61, 0x74, 0x65, 0x43, 0x6c, 0x6f, 0x75, 0x64, 0x73, 0x2f, 0x2a, 0x7d, 0x12, 0x83, 0x02,
	0x0a, 0x12, 0x43, 0x72, 0x65, 0x61, 0x74, 0x65, 0x50, 0x72, 0x69, 0x76, 0x61, 0x74, 0x65, 0x43,
	0x6c, 0x6f, 0x75, 0x64, 0x12, 0x37, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c,
	0x6f, 0x75, 0x64, 0x2e, 0x76, 0x6d, 0x77, 0x61, 0x72, 0x65, 0x65, 0x6e, 0x67, 0x69, 0x6e, 0x65,
	0x2e, 0x76, 0x31, 0x2e, 0x43, 0x72, 0x65, 0x61, 0x74, 0x65, 0x50, 0x72, 0x69, 0x76, 0x61, 0x74,
	0x65, 0x43, 0x6c, 0x6f, 0x75, 0x64, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x1a, 0x1d, 0x2e,
	0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x6c, 0x6f, 0x6e, 0x67, 0x72, 0x75, 0x6e, 0x6e, 0x69,
	0x6e, 0x67, 0x2e, 0x4f, 0x70, 0x65, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x22, 0x94, 0x01, 0xca,
	0x41, 0x21, 0x0a, 0x0c, 0x50, 0x72, 0x69, 0x76, 0x61, 0x74, 0x65, 0x43, 0x6c, 0x6f, 0x75, 0x64,
	0x12, 0x11, 0x4f, 0x70, 0x65, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x4d, 0x65, 0x74, 0x61, 0x64,
	0x61, 0x74, 0x61, 0xda, 0x41, 0x25, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x2c, 0x70, 0x72, 0x69,
	0x76, 0x61, 0x74, 0x65, 0x5f, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2c, 0x70, 0x72, 0x69, 0x76, 0x61,
	0x74, 0x65, 0x5f, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x5f, 0x69, 0x64, 0x82, 0xd3, 0xe4, 0x93, 0x02,
	0x42, 0x3a, 0x0d, 0x70, 0x72, 0x69, 0x76, 0x61, 0x74, 0x65, 0x5f, 0x63, 0x6c, 0x6f, 0x75, 0x64,
	0x22, 0x31, 0x2f, 0x76, 0x31, 0x2f, 0x7b, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x3d, 0x70, 0x72,
	0x6f, 0x6a, 0x65, 0x63, 0x74, 0x73, 0x2f, 0x2a, 0x2f, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f,
	0x6e, 0x73, 0x2f, 0x2a, 0x7d, 0x2f, 0x70, 0x72, 0x69, 0x76, 0x61, 0x74, 0x65, 0x43, 0x6c, 0x6f,
	0x75, 0x64, 0x73, 0x12, 0x85, 0x02, 0x0a, 0x12, 0x55, 0x70, 0x64, 0x61, 0x74, 0x65, 0x50, 0x72,
	0x69, 0x76, 0x61, 0x74, 0x65, 0x43, 0x6c, 0x6f, 0x75, 0x64, 0x12, 0x37, 0x2e, 0x67, 0x6f, 0x6f,
	0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x76, 0x6d, 0x77, 0x61, 0x72, 0x65,
	0x65, 0x6e, 0x67, 0x69, 0x6e, 0x65, 0x2e, 0x76, 0x31, 0x2e, 0x55, 0x70, 0x64, 0x61, 0x74, 0x65,
	0x50, 0x72, 0x69, 0x76, 0x61, 0x74, 0x65, 0x43, 0x6c, 0x6f, 0x75, 0x64, 0x52, 0x65, 0x71, 0x75,
	0x65, 0x73, 0x74, 0x1a, 0x1d, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x6c, 0x6f, 0x6e,
	0x67, 0x72, 0x75, 0x6e, 0x6e, 0x69, 0x6e, 0x67, 0x2e, 0x4f, 0x70, 0x65, 0x72, 0x61, 0x74, 0x69,
	0x6f, 0x6e, 0x22, 0x96, 0x01, 0xca, 0x41, 0x21, 0x0a, 0x0c, 0x50, 0x72, 0x69, 0x76, 0x61, 0x74,
	0x65, 0x43, 0x6c, 0x6f, 0x75, 0x64, 0x12, 0x11, 0x4f, 0x70, 0x65, 0x72, 0x61, 0x74, 0x69, 0x6f,
	0x6e, 0x4d, 0x65, 0x74, 0x61, 0x64, 0x61, 0x74, 0x61, 0xda, 0x41, 0x19, 0x70, 0x72, 0x69, 0x76,
	0x61, 0x74, 0x65, 0x5f, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2c, 0x75, 0x70, 0x64, 0x61, 0x74, 0x65,
	0x5f, 0x6d, 0x61, 0x73, 0x6b, 0x82, 0xd3, 0xe4, 0x93, 0x02, 0x50, 0x3a, 0x0d, 0x70, 0x72, 0x69,
	0x76, 0x61, 0x74, 0x65, 0x5f, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x32, 0x3f, 0x2f, 0x76, 0x31, 0x2f,
	0x7b, 0x70, 0x72, 0x69, 0x76, 0x61, 0x74, 0x65, 0x5f, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x6e,
	0x61, 0x6d, 0x65, 0x3d, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x73, 0x2f, 0x2a, 0x2f, 0x6c,
	0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x2a, 0x2f, 0x70, 0x72, 0x69, 0x76, 0x61,
	0x74, 0x65, 0x43, 0x6c, 0x6f, 0x75, 0x64, 0x73, 0x2f, 0x2a, 0x7d, 0x12, 0xd2, 0x01, 0x0a, 0x12,
	0x44, 0x65, 0x6c, 0x65, 0x74, 0x65, 0x50, 0x72, 0x69, 0x76, 0x61, 0x74, 0x65, 0x43, 0x6c, 0x6f,
	0x75, 0x64, 0x12, 0x37, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75,
	0x64, 0x2e, 0x76, 0x6d, 0x77, 0x61, 0x72, 0x65, 0x65, 0x6e, 0x67, 0x69, 0x6e, 0x65, 0x2e, 0x76,
	0x31, 0x2e, 0x44, 0x65, 0x6c, 0x65, 0x74, 0x65, 0x50, 0x72, 0x69, 0x76, 0x61, 0x74, 0x65, 0x43,
	0x6c, 0x6f, 0x75, 0x64, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x1a, 0x1d, 0x2e, 0x67, 0x6f,
	0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x6c, 0x6f, 0x6e, 0x67, 0x72, 0x75, 0x6e, 0x6e, 0x69, 0x6e, 0x67,
	0x2e, 0x4f, 0x70, 0x65, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x22, 0x64, 0xca, 0x41, 0x21, 0x0a,
	0x0c, 0x50, 0x72, 0x69, 0x76, 0x61, 0x74, 0x65, 0x43, 0x6c, 0x6f, 0x75, 0x64, 0x12, 0x11, 0x4f,
	0x70, 0x65, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x4d, 0x65, 0x74, 0x61, 0x64, 0x61, 0x74, 0x61,
	0xda, 0x41, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x82, 0xd3, 0xe4, 0x93, 0x02, 0x33, 0x2a, 0x31, 0x2f,
	0x76, 0x31, 0x2f, 0x7b, 0x6e, 0x61, 0x6d, 0x65, 0x3d, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74,
	0x73, 0x2f, 0x2a, 0x2f, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x2a, 0x2f,
	0x70, 0x72, 0x69, 0x76, 0x61, 0x74, 0x65, 0x43, 0x6c, 0x6f, 0x75, 0x64, 0x73, 0x2f, 0x2a, 0x7d,
	0x12, 0xe2, 0x01, 0x0a, 0x14, 0x55, 0x6e, 0x64, 0x65, 0x6c, 0x65, 0x74, 0x65, 0x50, 0x72, 0x69,
	0x76, 0x61, 0x74, 0x65, 0x43, 0x6c, 0x6f, 0x75, 0x64, 0x12, 0x39, 0x2e, 0x67, 0x6f, 0x6f, 0x67,
	0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x76, 0x6d, 0x77, 0x61, 0x72, 0x65, 0x65,
	0x6e, 0x67, 0x69, 0x6e, 0x65, 0x2e, 0x76, 0x31, 0x2e, 0x55, 0x6e, 0x64, 0x65, 0x6c, 0x65, 0x74,
	0x65, 0x50, 0x72, 0x69, 0x76, 0x61, 0x74, 0x65, 0x43, 0x6c, 0x6f, 0x75, 0x64, 0x52, 0x65, 0x71,
	0x75, 0x65, 0x73, 0x74, 0x1a, 0x1d, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x6c, 0x6f,
	0x6e, 0x67, 0x72, 0x75, 0x6e, 0x6e, 0x69, 0x6e, 0x67, 0x2e, 0x4f, 0x70, 0x65, 0x72, 0x61, 0x74,
	0x69, 0x6f, 0x6e, 0x22, 0x70, 0xca, 0x41, 0x21, 0x0a, 0x0c, 0x50, 0x72, 0x69, 0x76, 0x61, 0x74,
	0x65, 0x43, 0x6c, 0x6f, 0x75, 0x64, 0x12, 0x11, 0x4f, 0x70, 0x65, 0x72, 0x61, 0x74, 0x69, 0x6f,
	0x6e, 0x4d, 0x65, 0x74, 0x61, 0x64, 0x61, 0x74, 0x61, 0xda, 0x41, 0x04, 0x6e, 0x61, 0x6d, 0x65,
	0x82, 0xd3, 0xe4, 0x93, 0x02, 0x3f, 0x3a, 0x01, 0x2a, 0x22, 0x3a, 0x2f, 0x76, 0x31, 0x2f, 0x7b,
	0x6e, 0x61, 0x6d, 0x65, 0x3d, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x73, 0x2f, 0x2a, 0x2f,
	0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x2a, 0x2f, 0x70, 0x72, 0x69, 0x76,
	0x61, 0x74, 0x65, 0x43, 0x6c, 0x6f, 0x75, 0x64, 0x73, 0x2f, 0x2a, 0x7d, 0x3a, 0x75, 0x6e, 0x64,
	0x65, 0x6c, 0x65, 0x74, 0x65, 0x12, 0xc4, 0x01, 0x0a, 0x0c, 0x4c, 0x69, 0x73, 0x74, 0x43, 0x6c,
	0x75, 0x73, 0x74, 0x65, 0x72, 0x73, 0x12, 0x31, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e,
	0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x76, 0x6d, 0x77, 0x61, 0x72, 0x65, 0x65, 0x6e, 0x67, 0x69,
	0x6e, 0x65, 0x2e, 0x76, 0x31, 0x2e, 0x4c, 0x69, 0x73, 0x74, 0x43, 0x6c, 0x75, 0x73, 0x74, 0x65,
	0x72, 0x73, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x1a, 0x32, 0x2e, 0x67, 0x6f, 0x6f, 0x67,
	0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x76, 0x6d, 0x77, 0x61, 0x72, 0x65, 0x65,
	0x6e, 0x67, 0x69, 0x6e, 0x65, 0x2e, 0x76, 0x31, 0x2e, 0x4c, 0x69, 0x73, 0x74, 0x43, 0x6c, 0x75,
	0x73, 0x74, 0x65, 0x72, 0x73, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x22, 0x4d, 0xda,
	0x41, 0x06, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x82, 0xd3, 0xe4, 0x93, 0x02, 0x3e, 0x12, 0x3c,
	0x2f, 0x76, 0x31, 0x2f, 0x7b, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x3d, 0x70, 0x72, 0x6f, 0x6a,
	0x65, 0x63, 0x74, 0x73, 0x2f, 0x2a, 0x2f, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73,
	0x2f, 0x2a, 0x2f, 0x70, 0x72, 0x69, 0x76, 0x61, 0x74, 0x65, 0x43, 0x6c, 0x6f, 0x75, 0x64, 0x73,
	0x2f, 0x2a, 0x7d, 0x2f, 0x63, 0x6c, 0x75, 0x73, 0x74, 0x65, 0x72, 0x73, 0x12, 0xb1, 0x01, 0x0a,
	0x0a, 0x47, 0x65, 0x74, 0x43, 0x6c, 0x75, 0x73, 0x74, 0x65, 0x72, 0x12, 0x2f, 0x2e, 0x67, 0x6f,
	0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x76, 0x6d, 0x77, 0x61, 0x72,
	0x65, 0x65, 0x6e, 0x67, 0x69, 0x6e, 0x65, 0x2e, 0x76, 0x31, 0x2e, 0x47, 0x65, 0x74, 0x43, 0x6c,
	0x75, 0x73, 0x74, 0x65, 0x72, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x1a, 0x25, 0x2e, 0x67,
	0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x76, 0x6d, 0x77, 0x61,
	0x72, 0x65, 0x65, 0x6e, 0x67, 0x69, 0x6e, 0x65, 0x2e, 0x76, 0x31, 0x2e, 0x43, 0x6c, 0x75, 0x73,
	0x74, 0x65, 0x72, 0x22, 0x4b, 0xda, 0x41, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x82, 0xd3, 0xe4, 0x93,
	0x02, 0x3e, 0x12, 0x3c, 0x2f, 0x76, 0x31, 0x2f, 0x7b, 0x6e, 0x61, 0x6d, 0x65, 0x3d, 0x70, 0x72,
	0x6f, 0x6a, 0x65, 0x63, 0x74, 0x73, 0x2f, 0x2a, 0x2f, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f,
	0x6e, 0x73, 0x2f, 0x2a, 0x2f, 0x70, 0x72, 0x69, 0x76, 0x61, 0x74, 0x65, 0x43, 0x6c, 0x6f, 0x75,
	0x64, 0x73, 0x2f, 0x2a, 0x2f, 0x63, 0x6c, 0x75, 0x73, 0x74, 0x65, 0x72, 0x73, 0x2f, 0x2a, 0x7d,
	0x12, 0xed, 0x01, 0x0a, 0x0d, 0x43, 0x72, 0x65, 0x61, 0x74, 0x65, 0x43, 0x6c, 0x75, 0x73, 0x74,
	0x65, 0x72, 0x12, 0x32, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75,
	0x64, 0x2e, 0x76, 0x6d, 0x77, 0x61, 0x72, 0x65, 0x65, 0x6e, 0x67, 0x69, 0x6e, 0x65, 0x2e, 0x76,
	0x31, 0x2e, 0x43, 0x72, 0x65, 0x61, 0x74, 0x65, 0x43, 0x6c, 0x75, 0x73, 0x74, 0x65, 0x72, 0x52,
	0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x1a, 0x1d, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e,
	0x6c, 0x6f, 0x6e, 0x67, 0x72, 0x75, 0x6e, 0x6e, 0x69, 0x6e, 0x67, 0x2e, 0x4f, 0x70, 0x65, 0x72,
	0x61, 0x74, 0x69, 0x6f, 0x6e, 0x22, 0x88, 0x01, 0xca, 0x41, 0x1c, 0x0a, 0x07, 0x43, 0x6c, 0x75,
	0x73, 0x74, 0x65, 0x72, 0x12, 0x11, 0x4f, 0x70, 0x65, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x4d,
	0x65, 0x74, 0x61, 0x64, 0x61, 0x74, 0x61, 0xda, 0x41, 0x19, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74,
	0x2c, 0x63, 0x6c, 0x75, 0x73, 0x74, 0x65, 0x72, 0x2c, 0x63, 0x6c, 0x75, 0x73, 0x74, 0x65, 0x72,
	0x5f, 0x69, 0x64, 0x82, 0xd3, 0xe4, 0x93, 0x02, 0x47, 0x3a, 0x07, 0x63, 0x6c, 0x75, 0x73, 0x74,
	0x65, 0x72, 0x22, 0x3c, 0x2f, 0x76, 0x31, 0x2f, 0x7b, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x3d,
	0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x73, 0x2f, 0x2a, 0x2f, 0x6c, 0x6f, 0x63, 0x61, 0x74,
	0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x2a, 0x2f, 0x70, 0x72, 0x69, 0x76, 0x61, 0x74, 0x65, 0x43, 0x6c,
	0x6f, 0x75, 0x64, 0x73, 0x2f, 0x2a, 0x7d, 0x2f, 0x63, 0x6c, 0x75, 0x73, 0x74, 0x65, 0x72, 0x73,
	0x12, 0xef, 0x01, 0x0a, 0x0d, 0x55, 0x70, 0x64, 0x61, 0x74, 0x65, 0x43, 0x6c, 0x75, 0x73, 0x74,
	0x65, 0x72, 0x12, 0x32, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75,
	0x64, 0x2e, 0x76, 0x6d, 0x77, 0x61, 0x72, 0x65, 0x65, 0x6e, 0x67, 0x69, 0x6e, 0x65, 0x2e, 0x76,
	0x31, 0x2e, 0x55, 0x70, 0x64, 0x61, 0x74, 0x65, 0x43, 0x6c, 0x75, 0x73, 0x74, 0x65, 0x72, 0x52,
	0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x1a, 0x1d, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e,
	0x6c, 0x6f, 0x6e, 0x67, 0x72, 0x75, 0x6e, 0x6e, 0x69, 0x6e, 0x67, 0x2e, 0x4f, 0x70, 0x65, 0x72,
	0x61, 0x74, 0x69, 0x6f, 0x6e, 0x22, 0x8a, 0x01, 0xca, 0x41, 0x1c, 0x0a, 0x07, 0x43, 0x6c, 0x75,
	0x73, 0x74, 0x65, 0x72, 0x12, 0x11, 0x4f, 0x70, 0x65, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x4d,
	0x65, 0x74, 0x61, 0x64, 0x61, 0x74, 0x61, 0xda, 0x41, 0x13, 0x63, 0x6c, 0x75, 0x73, 0x74, 0x65,
	0x72, 0x2c, 0x75, 0x70, 0x64, 0x61, 0x74, 0x65, 0x5f, 0x6d, 0x61, 0x73, 0x6b, 0x82, 0xd3, 0xe4,
	0x93, 0x02, 0x4f, 0x3a, 0x07, 0x63, 0x6c, 0x75, 0x73, 0x74, 0x65, 0x72, 0x32, 0x44, 0x2f, 0x76,
	0x31, 0x2f, 0x7b, 0x63, 0x6c, 0x75, 0x73, 0x74, 0x65, 0x72, 0x2e, 0x6e, 0x61, 0x6d, 0x65, 0x3d,
	0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x73, 0x2f, 0x2a, 0x2f, 0x6c, 0x6f, 0x63, 0x61, 0x74,
	0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x2a, 0x2f, 0x70, 0x72, 0x69, 0x76, 0x61, 0x74, 0x65, 0x43, 0x6c,
	0x6f, 0x75, 0x64, 0x73, 0x2f, 0x2a, 0x2f, 0x63, 0x6c, 0x75, 0x73, 0x74, 0x65, 0x72, 0x73, 0x2f,
	0x2a, 0x7d, 0x12, 0xdc, 0x01, 0x0a, 0x0d, 0x44, 0x65, 0x6c, 0x65, 0x74, 0x65, 0x43, 0x6c, 0x75,
	0x73, 0x74, 0x65, 0x72, 0x12, 0x32, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c,
	0x6f, 0x75, 0x64, 0x2e, 0x76, 0x6d, 0x77, 0x61, 0x72, 0x65, 0x65, 0x6e, 0x67, 0x69, 0x6e, 0x65,
	0x2e, 0x76, 0x31, 0x2e, 0x44, 0x65, 0x6c, 0x65, 0x74, 0x65, 0x43, 0x6c, 0x75, 0x73, 0x74, 0x65,
	0x72, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x1a, 0x1d, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c,
	0x65, 0x2e, 0x6c, 0x6f, 0x6e, 0x67, 0x72, 0x75, 0x6e, 0x6e, 0x69, 0x6e, 0x67, 0x2e, 0x4f, 0x70,
	0x65, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x22, 0x78, 0xca, 0x41, 0x2a, 0x0a, 0x15, 0x67, 0x6f,
	0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x45, 0x6d,
	0x70, 0x74, 0x79, 0x12, 0x11, 0x4f, 0x70, 0x65, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x4d, 0x65,
	0x74, 0x61, 0x64, 0x61, 0x74, 0x61, 0xda, 0x41, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x82, 0xd3, 0xe4,
	0x93, 0x02, 0x3e, 0x2a, 0x3c, 0x2f, 0x76, 0x31, 0x2f, 0x7b, 0x6e, 0x61, 0x6d, 0x65, 0x3d, 0x70,
	0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x73, 0x2f, 0x2a, 0x2f, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69,
	0x6f, 0x6e, 0x73, 0x2f, 0x2a, 0x2f, 0x70, 0x72, 0x69, 0x76, 0x61, 0x74, 0x65, 0x43, 0x6c, 0x6f,
	0x75, 0x64, 0x73, 0x2f, 0x2a, 0x2f, 0x63, 0x6c, 0x75, 0x73, 0x74, 0x65, 0x72, 0x73, 0x2f, 0x2a,
	0x7d, 0x12, 0xc0, 0x01, 0x0a, 0x0b, 0x4c, 0x69, 0x73, 0x74, 0x53, 0x75, 0x62, 0x6e, 0x65, 0x74,
	0x73, 0x12, 0x30, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64,
	0x2e, 0x76, 0x6d, 0x77, 0x61, 0x72, 0x65, 0x65, 0x6e, 0x67, 0x69, 0x6e, 0x65, 0x2e, 0x76, 0x31,
	0x2e, 0x4c, 0x69, 0x73, 0x74, 0x53, 0x75, 0x62, 0x6e, 0x65, 0x74, 0x73, 0x52, 0x65, 0x71, 0x75,
	0x65, 0x73, 0x74, 0x1a, 0x31, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f,
	0x75, 0x64, 0x2e, 0x76, 0x6d, 0x77, 0x61, 0x72, 0x65, 0x65, 0x6e, 0x67, 0x69, 0x6e, 0x65, 0x2e,
	0x76, 0x31, 0x2e, 0x4c, 0x69, 0x73, 0x74, 0x53, 0x75, 0x62, 0x6e, 0x65, 0x74, 0x73, 0x52, 0x65,
	0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x22, 0x4c, 0xda, 0x41, 0x06, 0x70, 0x61, 0x72, 0x65, 0x6e,
	0x74, 0x82, 0xd3, 0xe4, 0x93, 0x02, 0x3d, 0x12, 0x3b, 0x2f, 0x76, 0x31, 0x2f, 0x7b, 0x70, 0x61,
	0x72, 0x65, 0x6e, 0x74, 0x3d, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x73, 0x2f, 0x2a, 0x2f,
	0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x2a, 0x2f, 0x70, 0x72, 0x69, 0x76,
	0x61, 0x74, 0x65, 0x43, 0x6c, 0x6f, 0x75, 0x64, 0x73, 0x2f, 0x2a, 0x7d, 0x2f, 0x73, 0x75, 0x62,
	0x6e, 0x65, 0x74, 0x73, 0x12, 0xad, 0x01, 0x0a, 0x09, 0x47, 0x65, 0x74, 0x53, 0x75, 0x62, 0x6e,
	0x65, 0x74, 0x12, 0x2e, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75,
	0x64, 0x2e, 0x76, 0x6d, 0x77, 0x61, 0x72, 0x65, 0x65, 0x6e, 0x67, 0x69, 0x6e, 0x65, 0x2e, 0x76,
	0x31, 0x2e, 0x47, 0x65, 0x74, 0x53, 0x75, 0x62, 0x6e, 0x65, 0x74, 0x52, 0x65, 0x71, 0x75, 0x65,
	0x73, 0x74, 0x1a, 0x24, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75,
	0x64, 0x2e, 0x76, 0x6d, 0x77, 0x61, 0x72, 0x65, 0x65, 0x6e, 0x67, 0x69, 0x6e, 0x65, 0x2e, 0x76,
	0x31, 0x2e, 0x53, 0x75, 0x62, 0x6e, 0x65, 0x74, 0x22, 0x4a, 0xda, 0x41, 0x04, 0x6e, 0x61, 0x6d,
	0x65, 0x82, 0xd3, 0xe4, 0x93, 0x02, 0x3d, 0x12, 0x3b, 0x2f, 0x76, 0x31, 0x2f, 0x7b, 0x6e, 0x61,
	0x6d, 0x65, 0x3d, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x73, 0x2f, 0x2a, 0x2f, 0x6c, 0x6f,
	0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x2a, 0x2f, 0x70, 0x72, 0x69, 0x76, 0x61, 0x74,
	0x65, 0x43, 0x6c, 0x6f, 0x75, 0x64, 0x73, 0x2f, 0x2a, 0x2f, 0x73, 0x75, 0x62, 0x6e, 0x65, 0x74,
	0x73, 0x2f, 0x2a, 0x7d, 0x12, 0xe8, 0x01, 0x0a, 0x0c, 0x55, 0x70, 0x64, 0x61, 0x74, 0x65, 0x53,
	0x75, 0x62, 0x6e, 0x65, 0x74, 0x12, 0x31, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63,
	0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x76, 0x6d, 0x77, 0x61, 0x72, 0x65, 0x65, 0x6e, 0x67, 0x69, 0x6e,
	0x65, 0x2e, 0x76, 0x31, 0x2e, 0x55, 0x70, 0x64, 0x61, 0x74, 0x65, 0x53, 0x75, 0x62, 0x6e, 0x65,
	0x74, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x1a, 0x1d, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c,
	0x65, 0x2e, 0x6c, 0x6f, 0x6e, 0x67, 0x72, 0x75, 0x6e, 0x6e, 0x69, 0x6e, 0x67, 0x2e, 0x4f, 0x70,
	0x65, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x22, 0x85, 0x01, 0xca, 0x41, 0x1b, 0x0a, 0x06, 0x53,
	0x75, 0x62, 0x6e, 0x65, 0x74, 0x12, 0x11, 0x4f, 0x70, 0x65, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e,
	0x4d, 0x65, 0x74, 0x61, 0x64, 0x61, 0x74, 0x61, 0xda, 0x41, 0x12, 0x73, 0x75, 0x62, 0x6e, 0x65,
	0x74, 0x2c, 0x75, 0x70, 0x64, 0x61, 0x74, 0x65, 0x5f, 0x6d, 0x61, 0x73, 0x6b, 0x82, 0xd3, 0xe4,
	0x93, 0x02, 0x4c, 0x3a, 0x06, 0x73, 0x75, 0x62, 0x6e, 0x65, 0x74, 0x32, 0x42, 0x2f, 0x76, 0x31,
	0x2f, 0x7b, 0x73, 0x75, 0x62, 0x6e, 0x65, 0x74, 0x2e, 0x6e, 0x61, 0x6d, 0x65, 0x3d, 0x70, 0x72,
	0x6f, 0x6a, 0x65, 0x63, 0x74, 0x73, 0x2f, 0x2a, 0x2f, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f,
	0x6e, 0x73, 0x2f, 0x2a, 0x2f, 0x70, 0x72, 0x69, 0x76, 0x61, 0x74, 0x65, 0x43, 0x6c, 0x6f, 0x75,
	0x64, 0x73, 0x2f, 0x2a, 0x2f, 0x73, 0x75, 0x62, 0x6e, 0x65, 0x74, 0x73, 0x2f, 0x2a, 0x7d, 0x12,
	0xb8, 0x01, 0x0a, 0x0d, 0x4c, 0x69, 0x73, 0x74, 0x4e, 0x6f, 0x64, 0x65, 0x54, 0x79, 0x70, 0x65,
	0x73, 0x12, 0x32, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64,
	0x2e, 0x76, 0x6d, 0x77, 0x61, 0x72, 0x65, 0x65, 0x6e, 0x67, 0x69, 0x6e, 0x65, 0x2e, 0x76, 0x31,
	0x2e, 0x4c, 0x69, 0x73, 0x74, 0x4e, 0x6f, 0x64, 0x65, 0x54, 0x79, 0x70, 0x65, 0x73, 0x52, 0x65,
	0x71, 0x75, 0x65, 0x73, 0x74, 0x1a, 0x33, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63,
	0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x76, 0x6d, 0x77, 0x61, 0x72, 0x65, 0x65, 0x6e, 0x67, 0x69, 0x6e,
	0x65, 0x2e, 0x76, 0x31, 0x2e, 0x4c, 0x69, 0x73, 0x74, 0x4e, 0x6f, 0x64, 0x65, 0x54, 0x79, 0x70,
	0x65, 0x73, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x22, 0x3e, 0xda, 0x41, 0x06, 0x70,
	0x61, 0x72, 0x65, 0x6e, 0x74, 0x82, 0xd3, 0xe4, 0x93, 0x02, 0x2f, 0x12, 0x2d, 0x2f, 0x76, 0x31,
	0x2f, 0x7b, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x3d, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74,
	0x73, 0x2f, 0x2a, 0x2f, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x2a, 0x7d,
	0x2f, 0x6e, 0x6f, 0x64, 0x65, 0x54, 0x79, 0x70, 0x65, 0x73, 0x12, 0xa5, 0x01, 0x0a, 0x0b, 0x47,
	0x65, 0x74, 0x4e, 0x6f, 0x64, 0x65, 0x54, 0x79, 0x70, 0x65, 0x12, 0x30, 0x2e, 0x67, 0x6f, 0x6f,
	0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x76, 0x6d, 0x77, 0x61, 0x72, 0x65,
	0x65, 0x6e, 0x67, 0x69, 0x6e, 0x65, 0x2e, 0x76, 0x31, 0x2e, 0x47, 0x65, 0x74, 0x4e, 0x6f, 0x64,
	0x65, 0x54, 0x79, 0x70, 0x65, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x1a, 0x26, 0x2e, 0x67,
	0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x76, 0x6d, 0x77, 0x61,
	0x72, 0x65, 0x65, 0x6e, 0x67, 0x69, 0x6e, 0x65, 0x2e, 0x76, 0x31, 0x2e, 0x4e, 0x6f, 0x64, 0x65,
	0x54, 0x79, 0x70, 0x65, 0x22, 0x3c, 0xda, 0x41, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x82, 0xd3, 0xe4,
	0x93, 0x02, 0x2f, 0x12, 0x2d, 0x2f, 0x76, 0x31, 0x2f, 0x7b, 0x6e, 0x61, 0x6d, 0x65, 0x3d, 0x70,
	0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x73, 0x2f, 0x2a, 0x2f, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69,
	0x6f, 0x6e, 0x73, 0x2f, 0x2a, 0x2f, 0x6e, 0x6f, 0x64, 0x65, 0x54, 0x79, 0x70, 0x65, 0x73, 0x2f,
	0x2a, 0x7d, 0x12, 0xdf, 0x01, 0x0a, 0x12, 0x53, 0x68, 0x6f, 0x77, 0x4e, 0x73, 0x78, 0x43, 0x72,
	0x65, 0x64, 0x65, 0x6e, 0x74, 0x69, 0x61, 0x6c, 0x73, 0x12, 0x37, 0x2e, 0x67, 0x6f, 0x6f, 0x67,
	0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x76, 0x6d, 0x77, 0x61, 0x72, 0x65, 0x65,
	0x6e, 0x67, 0x69, 0x6e, 0x65, 0x2e, 0x76, 0x31, 0x2e, 0x53, 0x68, 0x6f, 0x77, 0x4e, 0x73, 0x78,
	0x43, 0x72, 0x65, 0x64, 0x65, 0x6e, 0x74, 0x69, 0x61, 0x6c, 0x73, 0x52, 0x65, 0x71, 0x75, 0x65,
	0x73, 0x74, 0x1a, 0x29, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75,
	0x64, 0x2e, 0x76, 0x6d, 0x77, 0x61, 0x72, 0x65, 0x65, 0x6e, 0x67, 0x69, 0x6e, 0x65, 0x2e, 0x76,
	0x31, 0x2e, 0x43, 0x72, 0x65, 0x64, 0x65, 0x6e, 0x74, 0x69, 0x61, 0x6c, 0x73, 0x22, 0x65, 0xda,
	0x41, 0x0d, 0x70, 0x72, 0x69, 0x76, 0x61, 0x74, 0x65, 0x5f, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x82,
	0xd3, 0xe4, 0x93, 0x02, 0x4f, 0x12, 0x4d, 0x2f, 0x76, 0x31, 0x2f, 0x7b, 0x70, 0x72, 0x69, 0x76,
	0x61, 0x74, 0x65, 0x5f, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x3d, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63,
	0x74, 0x73, 0x2f, 0x2a, 0x2f, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x2a,
	0x2f, 0x70, 0x72, 0x69, 0x76, 0x61, 0x74, 0x65, 0x43, 0x6c, 0x6f, 0x75, 0x64, 0x73, 0x2f, 0x2a,
	0x7d, 0x3a, 0x73, 0x68, 0x6f, 0x77, 0x4e, 0x73, 0x78, 0x43, 0x72, 0x65, 0x64, 0x65, 0x6e, 0x74,
	0x69, 0x61, 0x6c, 0x73, 0x12, 0xeb, 0x01, 0x0a, 0x16, 0x53, 0x68, 0x6f, 0x77, 0x56, 0x63, 0x65,
	0x6e, 0x74, 0x65, 0x72, 0x43, 0x72, 0x65, 0x64, 0x65, 0x6e, 0x74, 0x69, 0x61, 0x6c, 0x73, 0x12,
	0x3b, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x76,
	0x6d, 0x77, 0x61, 0x72, 0x65, 0x65, 0x6e, 0x67, 0x69, 0x6e, 0x65, 0x2e, 0x76, 0x31, 0x2e, 0x53,
	0x68, 0x6f, 0x77, 0x56, 0x63, 0x65, 0x6e, 0x74, 0x65, 0x72, 0x43, 0x72, 0x65, 0x64, 0x65, 0x6e,
	0x74, 0x69, 0x61, 0x6c, 0x73, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x1a, 0x29, 0x2e, 0x67,
	0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x76, 0x6d, 0x77, 0x61,
	0x72, 0x65, 0x65, 0x6e, 0x67, 0x69, 0x6e, 0x65, 0x2e, 0x76, 0x31, 0x2e, 0x43, 0x72, 0x65, 0x64,
	0x65, 0x6e, 0x74, 0x69, 0x61, 0x6c, 0x73, 0x22, 0x69, 0xda, 0x41, 0x0d, 0x70, 0x72, 0x69, 0x76,
	0x61, 0x74, 0x65, 0x5f, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x82, 0xd3, 0xe4, 0x93, 0x02, 0x53, 0x12,
	0x51, 0x2f, 0x76, 0x31, 0x2f, 0x7b, 0x70, 0x72, 0x69, 0x76, 0x61, 0x74, 0x65, 0x5f, 0x63, 0x6c,
	0x6f, 0x75, 0x64, 0x3d, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x73, 0x2f, 0x2a, 0x2f, 0x6c,
	0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x2a, 0x2f, 0x70, 0x72, 0x69, 0x76, 0x61,
	0x74, 0x65, 0x43, 0x6c, 0x6f, 0x75, 0x64, 0x73, 0x2f, 0x2a, 0x7d, 0x3a, 0x73, 0x68, 0x6f, 0x77,
	0x56, 0x63, 0x65, 0x6e, 0x74, 0x65, 0x72, 0x43, 0x72, 0x65, 0x64, 0x65, 0x6e, 0x74, 0x69, 0x61,
	0x6c, 0x73, 0x12, 0xfe, 0x01, 0x0a, 0x13, 0x52, 0x65, 0x73, 0x65, 0x74, 0x4e, 0x73, 0x78, 0x43,
	0x72, 0x65, 0x64, 0x65, 0x6e, 0x74, 0x69, 0x61, 0x6c, 0x73, 0x12, 0x38, 0x2e, 0x67, 0x6f, 0x6f,
	0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x76, 0x6d, 0x77, 0x61, 0x72, 0x65,
	0x65, 0x6e, 0x67, 0x69, 0x6e, 0x65, 0x2e, 0x76, 0x31, 0x2e, 0x52, 0x65, 0x73, 0x65, 0x74, 0x4e,
	0x73, 0x78, 0x43, 0x72, 0x65, 0x64, 0x65, 0x6e, 0x74, 0x69, 0x61, 0x6c, 0x73, 0x52, 0x65, 0x71,
	0x75, 0x65, 0x73, 0x74, 0x1a, 0x1d, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x6c, 0x6f,
	0x6e, 0x67, 0x72, 0x75, 0x6e, 0x6e, 0x69, 0x6e, 0x67, 0x2e, 0x4f, 0x70, 0x65, 0x72, 0x61, 0x74,
	0x69, 0x6f, 0x6e, 0x22, 0x8d, 0x01, 0xca, 0x41, 0x21, 0x0a, 0x0c, 0x50, 0x72, 0x69, 0x76, 0x61,
	0x74, 0x65, 0x43, 0x6c, 0x6f, 0x75, 0x64, 0x12, 0x11, 0x4f, 0x70, 0x65, 0x72, 0x61, 0x74, 0x69,
	0x6f, 0x6e, 0x4d, 0x65, 0x74, 0x61, 0x64, 0x61, 0x74, 0x61, 0xda, 0x41, 0x0d, 0x70, 0x72, 0x69,
	0x76, 0x61, 0x74, 0x65, 0x5f, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x82, 0xd3, 0xe4, 0x93, 0x02, 0x53,
	0x3a, 0x01, 0x2a, 0x22, 0x4e, 0x2f, 0x76, 0x31, 0x2f, 0x7b, 0x70, 0x72, 0x69, 0x76, 0x61, 0x74,
	0x65, 0x5f, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x3d, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x73,
	0x2f, 0x2a, 0x2f, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x2a, 0x2f, 0x70,
	0x72, 0x69, 0x76, 0x61, 0x74, 0x65, 0x43, 0x6c, 0x6f, 0x75, 0x64, 0x73, 0x2f, 0x2a, 0x7d, 0x3a,
	0x72, 0x65, 0x73, 0x65, 0x74, 0x4e, 0x73, 0x78, 0x43, 0x72, 0x65, 0x64, 0x65, 0x6e, 0x74, 0x69,
	0x61, 0x6c, 0x73, 0x12, 0x8a, 0x02, 0x0a, 0x17, 0x52, 0x65, 0x73, 0x65, 0x74, 0x56, 0x63, 0x65,
	0x6e, 0x74, 0x65, 0x72, 0x43, 0x72, 0x65, 0x64, 0x65, 0x6e, 0x74, 0x69, 0x61, 0x6c, 0x73, 0x12,
	0x3c, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x76,
	0x6d, 0x77, 0x61, 0x72, 0x65, 0x65, 0x6e, 0x67, 0x69, 0x6e, 0x65, 0x2e, 0x76, 0x31, 0x2e, 0x52,
	0x65, 0x73, 0x65, 0x74, 0x56, 0x63, 0x65, 0x6e, 0x74, 0x65, 0x72, 0x43, 0x72, 0x65, 0x64, 0x65,
	0x6e, 0x74, 0x69, 0x61, 0x6c, 0x73, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x1a, 0x1d, 0x2e,
	0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x6c, 0x6f, 0x6e, 0x67, 0x72, 0x75, 0x6e, 0x6e, 0x69,
	0x6e, 0x67, 0x2e, 0x4f, 0x70, 0x65, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x22, 0x91, 0x01, 0xca,
	0x41, 0x21, 0x0a, 0x0c, 0x50, 0x72, 0x69, 0x76, 0x61, 0x74, 0x65, 0x43, 0x6c, 0x6f, 0x75, 0x64,
	0x12, 0x11, 0x4f, 0x70, 0x65, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x4d, 0x65, 0x74, 0x61, 0x64,
	0x61, 0x74, 0x61, 0xda, 0x41, 0x0d, 0x70, 0x72, 0x69, 0x76, 0x61, 0x74, 0x65, 0x5f, 0x63, 0x6c,
	0x6f, 0x75, 0x64, 0x82, 0xd3, 0xe4, 0x93, 0x02, 0x57, 0x3a, 0x01, 0x2a, 0x22, 0x52, 0x2f, 0x76,
	0x31, 0x2f, 0x7b, 0x70, 0x72, 0x69, 0x76, 0x61, 0x74, 0x65, 0x5f, 0x63, 0x6c, 0x6f, 0x75, 0x64,
	0x3d, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x73, 0x2f, 0x2a, 0x2f, 0x6c, 0x6f, 0x63, 0x61,
	0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x2a, 0x2f, 0x70, 0x72, 0x69, 0x76, 0x61, 0x74, 0x65, 0x43,
	0x6c, 0x6f, 0x75, 0x64, 0x73, 0x2f, 0x2a, 0x7d, 0x3a, 0x72, 0x65, 0x73, 0x65, 0x74, 0x56, 0x63,
	0x65, 0x6e, 0x74, 0x65, 0x72, 0x43, 0x72, 0x65, 0x64, 0x65, 0x6e, 0x74, 0x69, 0x61, 0x6c, 0x73,
	0x12, 0xb2, 0x02, 0x0a, 0x16, 0x43, 0x72, 0x65, 0x61, 0x74, 0x65, 0x48, 0x63, 0x78, 0x41, 0x63,
	0x74, 0x69, 0x76, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x4b, 0x65, 0x79, 0x12, 0x3b, 0x2e, 0x67, 0x6f,
	0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x76, 0x6d, 0x77, 0x61, 0x72,
	0x65, 0x65, 0x6e, 0x67, 0x69, 0x6e, 0x65, 0x2e, 0x76, 0x31, 0x2e, 0x43, 0x72, 0x65, 0x61, 0x74,
	0x65, 0x48, 0x63, 0x78, 0x41, 0x63, 0x74, 0x69, 0x76, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x4b, 0x65,
	0x79, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x1a, 0x1d, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c,
	0x65, 0x2e, 0x6c, 0x6f, 0x6e, 0x67, 0x72, 0x75, 0x6e, 0x6e, 0x69, 0x6e, 0x67, 0x2e, 0x4f, 0x70,
	0x65, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x22, 0xbb, 0x01, 0xca, 0x41, 0x25, 0x0a, 0x10, 0x48,
	0x63, 0x78, 0x41, 0x63, 0x74, 0x69, 0x76, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x4b, 0x65, 0x79, 0x12,
	0x11, 0x4f, 0x70, 0x65, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x4d, 0x65, 0x74, 0x61, 0x64, 0x61,
	0x74, 0x61, 0xda, 0x41, 0x2f, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x2c, 0x68, 0x63, 0x78, 0x5f,
	0x61, 0x63, 0x74, 0x69, 0x76, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x5f, 0x6b, 0x65, 0x79, 0x2c, 0x68,
	0x63, 0x78, 0x5f, 0x61, 0x63, 0x74, 0x69, 0x76, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x5f, 0x6b, 0x65,
	0x79, 0x5f, 0x69, 0x64, 0x82, 0xd3, 0xe4, 0x93, 0x02, 0x5b, 0x3a, 0x12, 0x68, 0x63, 0x78, 0x5f,
	0x61, 0x63, 0x74, 0x69, 0x76, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x5f, 0x6b, 0x65, 0x79, 0x22, 0x45,
	0x2f, 0x76, 0x31, 0x2f, 0x7b, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x3d, 0x70, 0x72, 0x6f, 0x6a,
	0x65, 0x63, 0x74, 0x73, 0x2f, 0x2a, 0x2f, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73,
	0x2f, 0x2a, 0x2f, 0x70, 0x72, 0x69, 0x76, 0x61, 0x74, 0x65, 0x43, 0x6c, 0x6f, 0x75, 0x64, 0x73,
	0x2f, 0x2a, 0x7d, 0x2f, 0x68, 0x63, 0x78, 0x41, 0x63, 0x74, 0x69, 0x76, 0x61, 0x74, 0x69, 0x6f,
	0x6e, 0x4b, 0x65, 0x79, 0x73, 0x12, 0xe8, 0x01, 0x0a, 0x15, 0x4c, 0x69, 0x73, 0x74, 0x48, 0x63,
	0x78, 0x41, 0x63, 0x74, 0x69, 0x76, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x4b, 0x65, 0x79, 0x73, 0x12,
	0x3a, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x76,
	0x6d, 0x77, 0x61, 0x72, 0x65, 0x65, 0x6e, 0x67, 0x69, 0x6e, 0x65, 0x2e, 0x76, 0x31, 0x2e, 0x4c,
	0x69, 0x73, 0x74, 0x48, 0x63, 0x78, 0x41, 0x63, 0x74, 0x69, 0x76, 0x61, 0x74, 0x69, 0x6f, 0x6e,
	0x4b, 0x65, 0x79, 0x73, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x1a, 0x3b, 0x2e, 0x67, 0x6f,
	0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x76, 0x6d, 0x77, 0x61, 0x72,
	0x65, 0x65, 0x6e, 0x67, 0x69, 0x6e, 0x65, 0x2e, 0x76, 0x31, 0x2e, 0x4c, 0x69, 0x73, 0x74, 0x48,
	0x63, 0x78, 0x41, 0x63, 0x74, 0x69, 0x76, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x4b, 0x65, 0x79, 0x73,
	0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x22, 0x56, 0xda, 0x41, 0x06, 0x70, 0x61, 0x72,
	0x65, 0x6e, 0x74, 0x82, 0xd3, 0xe4, 0x93, 0x02, 0x47, 0x12, 0x45, 0x2f, 0x76, 0x31, 0x2f, 0x7b,
	0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x3d, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x73, 0x2f,
	0x2a, 0x2f, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x2a, 0x2f, 0x70, 0x72,
	0x69, 0x76, 0x61, 0x74, 0x65, 0x43, 0x6c, 0x6f, 0x75, 0x64, 0x73, 0x2f, 0x2a, 0x7d, 0x2f, 0x68,
	0x63, 0x78, 0x41, 0x63, 0x74, 0x69, 0x76, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x4b, 0x65, 0x79, 0x73,
	0x12, 0xd5, 0x01, 0x0a, 0x13, 0x47, 0x65, 0x74, 0x48, 0x63, 0x78, 0x41, 0x63, 0x74, 0x69, 0x76,
	0x61, 0x74, 0x69, 0x6f, 0x6e, 0x4b, 0x65, 0x79, 0x12, 0x38, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c,
	0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x76, 0x6d, 0x77, 0x61, 0x72, 0x65, 0x65, 0x6e,
	0x67, 0x69, 0x6e, 0x65, 0x2e, 0x76, 0x31, 0x2e, 0x47, 0x65, 0x74, 0x48, 0x63, 0x78, 0x41, 0x63,
	0x74, 0x69, 0x76, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x4b, 0x65, 0x79, 0x52, 0x65, 0x71, 0x75, 0x65,
	0x73, 0x74, 0x1a, 0x2e, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75,
	0x64, 0x2e, 0x76, 0x6d, 0x77, 0x61, 0x72, 0x65, 0x65, 0x6e, 0x67, 0x69, 0x6e, 0x65, 0x2e, 0x76,
	0x31, 0x2e, 0x48, 0x63, 0x78, 0x41, 0x63, 0x74, 0x69, 0x76, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x4b,
	0x65, 0x79, 0x22, 0x54, 0xda, 0x41, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x82, 0xd3, 0xe4, 0x93, 0x02,
	0x47, 0x12, 0x45, 0x2f, 0x76, 0x31, 0x2f, 0x7b, 0x6e, 0x61, 0x6d, 0x65, 0x3d, 0x70, 0x72, 0x6f,
	0x6a, 0x65, 0x63, 0x74, 0x73, 0x2f, 0x2a, 0x2f, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e,
	0x73, 0x2f, 0x2a, 0x2f, 0x70, 0x72, 0x69, 0x76, 0x61, 0x74, 0x65, 0x43, 0x6c, 0x6f, 0x75, 0x64,
	0x73, 0x2f, 0x2a, 0x2f, 0x68, 0x63, 0x78, 0x41, 0x63, 0x74, 0x69, 0x76, 0x61, 0x74, 0x69, 0x6f,
	0x6e, 0x4b, 0x65, 0x79, 0x73, 0x2f, 0x2a, 0x7d, 0x12, 0xba, 0x01, 0x0a, 0x10, 0x47, 0x65, 0x74,
	0x4e, 0x65, 0x74, 0x77, 0x6f, 0x72, 0x6b, 0x50, 0x6f, 0x6c, 0x69, 0x63, 0x79, 0x12, 0x35, 0x2e,
	0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x76, 0x6d, 0x77,
	0x61, 0x72, 0x65, 0x65, 0x6e, 0x67, 0x69, 0x6e, 0x65, 0x2e, 0x76, 0x31, 0x2e, 0x47, 0x65, 0x74,
	0x4e, 0x65, 0x74, 0x77, 0x6f, 0x72, 0x6b, 0x50, 0x6f, 0x6c, 0x69, 0x63, 0x79, 0x52, 0x65, 0x71,
	0x75, 0x65, 0x73, 0x74, 0x1a, 0x2b, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c,
	0x6f, 0x75, 0x64, 0x2e, 0x76, 0x6d, 0x77, 0x61, 0x72, 0x65, 0x65, 0x6e, 0x67, 0x69, 0x6e, 0x65,
	0x2e, 0x76, 0x31, 0x2e, 0x4e, 0x65, 0x74, 0x77, 0x6f, 0x72, 0x6b, 0x50, 0x6f, 0x6c, 0x69, 0x63,
	0x79, 0x22, 0x42, 0xda, 0x41, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x82, 0xd3, 0xe4, 0x93, 0x02, 0x35,
	0x12, 0x33, 0x2f, 0x76, 0x31, 0x2f, 0x7b, 0x6e, 0x61, 0x6d, 0x65, 0x3d, 0x70, 0x72, 0x6f, 0x6a,
	0x65, 0x63, 0x74, 0x73, 0x2f, 0x2a, 0x2f, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73,
	0x2f, 0x2a, 0x2f, 0x6e, 0x65, 0x74, 0x77, 0x6f, 0x72, 0x6b, 0x50, 0x6f, 0x6c, 0x69, 0x63, 0x69,
	0x65, 0x73, 0x2f, 0x2a, 0x7d, 0x12, 0xd0, 0x01, 0x0a, 0x13, 0x4c, 0x69, 0x73, 0x74, 0x4e, 0x65,
	0x74, 0x77, 0x6f, 0x72, 0x6b, 0x50, 0x6f, 0x6c, 0x69, 0x63, 0x69, 0x65, 0x73, 0x12, 0x38, 0x2e,
	0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x76, 0x6d, 0x77,
	0x61, 0x72, 0x65, 0x65, 0x6e, 0x67, 0x69, 0x6e, 0x65, 0x2e, 0x76, 0x31, 0x2e, 0x4c, 0x69, 0x73,
	0x74, 0x4e, 0x65, 0x74, 0x77, 0x6f, 0x72, 0x6b, 0x50, 0x6f, 0x6c, 0x69, 0x63, 0x69, 0x65, 0x73,
	0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x1a, 0x39, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65,
	0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x76, 0x6d, 0x77, 0x61, 0x72, 0x65, 0x65, 0x6e, 0x67,
	0x69, 0x6e, 0x65, 0x2e, 0x76, 0x31, 0x2e, 0x4c, 0x69, 0x73, 0x74, 0x4e, 0x65, 0x74, 0x77, 0x6f,
	0x72, 0x6b, 0x50, 0x6f, 0x6c, 0x69, 0x63, 0x69, 0x65, 0x73, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e,
	0x73, 0x65, 0x22, 0x44, 0xda, 0x41, 0x06, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x82, 0xd3, 0xe4,
	0x93, 0x02, 0x35, 0x12, 0x33, 0x2f, 0x76, 0x31, 0x2f, 0x7b, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74,
	0x3d, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x73, 0x2f, 0x2a, 0x2f, 0x6c, 0x6f, 0x63, 0x61,
	0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x2a, 0x7d, 0x2f, 0x6e, 0x65, 0x74, 0x77, 0x6f, 0x72, 0x6b,
	0x50, 0x6f, 0x6c, 0x69, 0x63, 0x69, 0x65, 0x73, 0x12, 0x8b, 0x02, 0x0a, 0x13, 0x43, 0x72, 0x65,
	0x61, 0x74, 0x65, 0x4e, 0x65, 0x74, 0x77, 0x6f, 0x72, 0x6b, 0x50, 0x6f, 0x6c, 0x69, 0x63, 0x79,
	0x12, 0x38, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e,
	0x76, 0x6d, 0x77, 0x61, 0x72, 0x65, 0x65, 0x6e, 0x67, 0x69, 0x6e, 0x65, 0x2e, 0x76, 0x31, 0x2e,
	0x43, 0x72, 0x65, 0x61, 0x74, 0x65, 0x4e, 0x65, 0x74, 0x77, 0x6f, 0x72, 0x6b, 0x50, 0x6f, 0x6c,
	0x69, 0x63, 0x79, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x1a, 0x1d, 0x2e, 0x67, 0x6f, 0x6f,
	0x67, 0x6c, 0x65, 0x2e, 0x6c, 0x6f, 0x6e, 0x67, 0x72, 0x75, 0x6e, 0x6e, 0x69, 0x6e, 0x67, 0x2e,
	0x4f, 0x70, 0x65, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x22, 0x9a, 0x01, 0xca, 0x41, 0x22, 0x0a,
	0x0d, 0x4e, 0x65, 0x74, 0x77, 0x6f, 0x72, 0x6b, 0x50, 0x6f, 0x6c, 0x69, 0x63, 0x79, 0x12, 0x11,
	0x4f, 0x70, 0x65, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x4d, 0x65, 0x74, 0x61, 0x64, 0x61, 0x74,
	0x61, 0xda, 0x41, 0x27, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x2c, 0x6e, 0x65, 0x74, 0x77, 0x6f,
	0x72, 0x6b, 0x5f, 0x70, 0x6f, 0x6c, 0x69, 0x63, 0x79, 0x2c, 0x6e, 0x65, 0x74, 0x77, 0x6f, 0x72,
	0x6b, 0x5f, 0x70, 0x6f, 0x6c, 0x69, 0x63, 0x79, 0x5f, 0x69, 0x64, 0x82, 0xd3, 0xe4, 0x93, 0x02,
	0x45, 0x3a, 0x0e, 0x6e, 0x65, 0x74, 0x77, 0x6f, 0x72, 0x6b, 0x5f, 0x70, 0x6f, 0x6c, 0x69, 0x63,
	0x79, 0x22, 0x33, 0x2f, 0x76, 0x31, 0x2f, 0x7b, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x3d, 0x70,
	0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x73, 0x2f, 0x2a, 0x2f, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69,
	0x6f, 0x6e, 0x73, 0x2f, 0x2a, 0x7d, 0x2f, 0x6e, 0x65, 0x74, 0x77, 0x6f, 0x72, 0x6b, 0x50, 0x6f,
	0x6c, 0x69, 0x63, 0x69, 0x65, 0x73, 0x12, 0x8d, 0x02, 0x0a, 0x13, 0x55, 0x70, 0x64, 0x61, 0x74,
	0x65, 0x4e, 0x65, 0x74, 0x77, 0x6f, 0x72, 0x6b, 0x50, 0x6f, 0x6c, 0x69, 0x63, 0x79, 0x12, 0x38,
	0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x76, 0x6d,
	0x77, 0x61, 0x72, 0x65, 0x65, 0x6e, 0x67, 0x69, 0x6e, 0x65, 0x2e, 0x76, 0x31, 0x2e, 0x55, 0x70,
	0x64, 0x61, 0x74, 0x65, 0x4e, 0x65, 0x74, 0x77, 0x6f, 0x72, 0x6b, 0x50, 0x6f, 0x6c, 0x69, 0x63,
	0x79, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x1a, 0x1d, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c,
	0x65, 0x2e, 0x6c, 0x6f, 0x6e, 0x67, 0x72, 0x75, 0x6e, 0x6e, 0x69, 0x6e, 0x67, 0x2e, 0x4f, 0x70,
	0x65, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x22, 0x9c, 0x01, 0xca, 0x41, 0x22, 0x0a, 0x0d, 0x4e,
	0x65, 0x74, 0x77, 0x6f, 0x72, 0x6b, 0x50, 0x6f, 0x6c, 0x69, 0x63, 0x79, 0x12, 0x11, 0x4f, 0x70,
	0x65, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x4d, 0x65, 0x74, 0x61, 0x64, 0x61, 0x74, 0x61, 0xda,
	0x41, 0x1a, 0x6e, 0x65, 0x74, 0x77, 0x6f, 0x72, 0x6b, 0x5f, 0x70, 0x6f, 0x6c, 0x69, 0x63, 0x79,
	0x2c, 0x75, 0x70, 0x64, 0x61, 0x74, 0x65, 0x5f, 0x6d, 0x61, 0x73, 0x6b, 0x82, 0xd3, 0xe4, 0x93,
	0x02, 0x54, 0x3a, 0x0e, 0x6e, 0x65, 0x74, 0x77, 0x6f, 0x72, 0x6b, 0x5f, 0x70, 0x6f, 0x6c, 0x69,
	0x63, 0x79, 0x32, 0x42, 0x2f, 0x76, 0x31, 0x2f, 0x7b, 0x6e, 0x65, 0x74, 0x77, 0x6f, 0x72, 0x6b,
	0x5f, 0x70, 0x6f, 0x6c, 0x69, 0x63, 0x79, 0x2e, 0x6e, 0x61, 0x6d, 0x65, 0x3d, 0x70, 0x72, 0x6f,
	0x6a, 0x65, 0x63, 0x74, 0x73, 0x2f, 0x2a, 0x2f, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e,
	0x73, 0x2f, 0x2a, 0x2f, 0x6e, 0x65, 0x74, 0x77, 0x6f, 0x72, 0x6b, 0x50, 0x6f, 0x6c, 0x69, 0x63,
	0x69, 0x65, 0x73, 0x2f, 0x2a, 0x7d, 0x12, 0xdf, 0x01, 0x0a, 0x13, 0x44, 0x65, 0x6c, 0x65, 0x74,
	0x65, 0x4e, 0x65, 0x74, 0x77, 0x6f, 0x72, 0x6b, 0x50, 0x6f, 0x6c, 0x69, 0x63, 0x79, 0x12, 0x38,
	0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x76, 0x6d,
	0x77, 0x61, 0x72, 0x65, 0x65, 0x6e, 0x67, 0x69, 0x6e, 0x65, 0x2e, 0x76, 0x31, 0x2e, 0x44, 0x65,
	0x6c, 0x65, 0x74, 0x65, 0x4e, 0x65, 0x74, 0x77, 0x6f, 0x72, 0x6b, 0x50, 0x6f, 0x6c, 0x69, 0x63,
	0x79, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x1a, 0x1d, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c,
	0x65, 0x2e, 0x6c, 0x6f, 0x6e, 0x67, 0x72, 0x75, 0x6e, 0x6e, 0x69, 0x6e, 0x67, 0x2e, 0x4f, 0x70,
	0x65, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x22, 0x6f, 0xca, 0x41, 0x2a, 0x0a, 0x15, 0x67, 0x6f,
	0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x45, 0x6d,
	0x70, 0x74, 0x79, 0x12, 0x11, 0x4f, 0x70, 0x65, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x4d, 0x65,
	0x74, 0x61, 0x64, 0x61, 0x74, 0x61, 0xda, 0x41, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x82, 0xd3, 0xe4,
	0x93, 0x02, 0x35, 0x2a, 0x33, 0x2f, 0x76, 0x31, 0x2f, 0x7b, 0x6e, 0x61, 0x6d, 0x65, 0x3d, 0x70,
	0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x73, 0x2f, 0x2a, 0x2f, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69,
	0x6f, 0x6e, 0x73, 0x2f, 0x2a, 0x2f, 0x6e, 0x65, 0x74, 0x77, 0x6f, 0x72, 0x6b, 0x50, 0x6f, 0x6c,
	0x69, 0x63, 0x69, 0x65, 0x73, 0x2f, 0x2a, 0x7d, 0x12, 0xb7, 0x02, 0x0a, 0x19, 0x43, 0x72, 0x65,
	0x61, 0x74, 0x65, 0x56, 0x6d, 0x77, 0x61, 0x72, 0x65, 0x45, 0x6e, 0x67, 0x69, 0x6e, 0x65, 0x4e,
	0x65, 0x74, 0x77, 0x6f, 0x72, 0x6b, 0x12, 0x3e, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e,
	0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x76, 0x6d, 0x77, 0x61, 0x72, 0x65, 0x65, 0x6e, 0x67, 0x69,
	0x6e, 0x65, 0x2e, 0x76, 0x31, 0x2e, 0x43, 0x72, 0x65, 0x61, 0x74, 0x65, 0x56, 0x6d, 0x77, 0x61,
	0x72, 0x65, 0x45, 0x6e, 0x67, 0x69, 0x6e, 0x65, 0x4e, 0x65, 0x74, 0x77, 0x6f, 0x72, 0x6b, 0x52,
	0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x1a, 0x1d, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e,
	0x6c, 0x6f, 0x6e, 0x67, 0x72, 0x75, 0x6e, 0x6e, 0x69, 0x6e, 0x67, 0x2e, 0x4f, 0x70, 0x65, 0x72,
	0x61, 0x74, 0x69, 0x6f, 0x6e, 0x22, 0xba, 0x01, 0xca, 0x41, 0x28, 0x0a, 0x13, 0x56, 0x6d, 0x77,
	0x61, 0x72, 0x65, 0x45, 0x6e, 0x67, 0x69, 0x6e, 0x65, 0x4e, 0x65, 0x74, 0x77, 0x6f, 0x72, 0x6b,
	0x12, 0x11, 0x4f, 0x70, 0x65, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x4d, 0x65, 0x74, 0x61, 0x64,
	0x61, 0x74, 0x61, 0xda, 0x41, 0x35, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x2c, 0x76, 0x6d, 0x77,
	0x61, 0x72, 0x65, 0x5f, 0x65, 0x6e, 0x67, 0x69, 0x6e, 0x65, 0x5f, 0x6e, 0x65, 0x74, 0x77, 0x6f,
	0x72, 0x6b, 0x2c, 0x76, 0x6d, 0x77, 0x61, 0x72, 0x65, 0x5f, 0x65, 0x6e, 0x67, 0x69, 0x6e, 0x65,
	0x5f, 0x6e, 0x65, 0x74, 0x77, 0x6f, 0x72, 0x6b, 0x5f, 0x69, 0x64, 0x82, 0xd3, 0xe4, 0x93, 0x02,
	0x51, 0x3a, 0x15, 0x76, 0x6d, 0x77, 0x61, 0x72, 0x65, 0x5f, 0x65, 0x6e, 0x67, 0x69, 0x6e, 0x65,
	0x5f, 0x6e, 0x65, 0x74, 0x77, 0x6f, 0x72, 0x6b, 0x22, 0x38, 0x2f, 0x76, 0x31, 0x2f, 0x7b, 0x70,
	0x61, 0x72, 0x65, 0x6e, 0x74, 0x3d, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x73, 0x2f, 0x2a,
	0x2f, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x2a, 0x7d, 0x2f, 0x76, 0x6d,
	0x77, 0x61, 0x72, 0x65, 0x45, 0x6e, 0x67, 0x69, 0x6e, 0x65, 0x4e, 0x65, 0x74, 0x77, 0x6f, 0x72,
	0x6b, 0x73, 0x12, 0xb9, 0x02, 0x0a, 0x19, 0x55, 0x70, 0x64, 0x61, 0x74, 0x65, 0x56, 0x6d, 0x77,
	0x61, 0x72, 0x65, 0x45, 0x6e, 0x67, 0x69, 0x6e, 0x65, 0x4e, 0x65, 0x74, 0x77, 0x6f, 0x72, 0x6b,
	0x12, 0x3e, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e,
	0x76, 0x6d, 0x77, 0x61, 0x72, 0x65, 0x65, 0x6e, 0x67, 0x69, 0x6e, 0x65, 0x2e, 0x76, 0x31, 0x2e,
	0x55, 0x70, 0x64, 0x61, 0x74, 0x65, 0x56, 0x6d, 0x77, 0x61, 0x72, 0x65, 0x45, 0x6e, 0x67, 0x69,
	0x6e, 0x65, 0x4e, 0x65, 0x74, 0x77, 0x6f, 0x72, 0x6b, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74,
	0x1a, 0x1d, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x6c, 0x6f, 0x6e, 0x67, 0x72, 0x75,
	0x6e, 0x6e, 0x69, 0x6e, 0x67, 0x2e, 0x4f, 0x70, 0x65, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x22,
	0xbc, 0x01, 0xca, 0x41, 0x28, 0x0a, 0x13, 0x56, 0x6d, 0x77, 0x61, 0x72, 0x65, 0x45, 0x6e, 0x67,
	0x69, 0x6e, 0x65, 0x4e, 0x65, 0x74, 0x77, 0x6f, 0x72, 0x6b, 0x12, 0x11, 0x4f, 0x70, 0x65, 0x72,
	0x61, 0x74, 0x69, 0x6f, 0x6e, 0x4d, 0x65, 0x74, 0x61, 0x64, 0x61, 0x74, 0x61, 0xda, 0x41, 0x21,
	0x76, 0x6d, 0x77, 0x61, 0x72, 0x65, 0x5f, 0x65, 0x6e, 0x67, 0x69, 0x6e, 0x65, 0x5f, 0x6e, 0x65,
	0x74, 0x77, 0x6f, 0x72, 0x6b, 0x2c, 0x75, 0x70, 0x64, 0x61, 0x74, 0x65, 0x5f, 0x6d, 0x61, 0x73,
	0x6b, 0x82, 0xd3, 0xe4, 0x93, 0x02, 0x67, 0x3a, 0x15, 0x76, 0x6d, 0x77, 0x61, 0x72, 0x65, 0x5f,
	0x65, 0x6e, 0x67, 0x69, 0x6e, 0x65, 0x5f, 0x6e, 0x65, 0x74, 0x77, 0x6f, 0x72, 0x6b, 0x32, 0x4e,
	0x2f, 0x76, 0x31, 0x2f, 0x7b, 0x76, 0x6d, 0x77, 0x61, 0x72, 0x65, 0x5f, 0x65, 0x6e, 0x67, 0x69,
	0x6e, 0x65, 0x5f, 0x6e, 0x65, 0x74, 0x77, 0x6f, 0x72, 0x6b, 0x2e, 0x6e, 0x61, 0x6d, 0x65, 0x3d,
	0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x73, 0x2f, 0x2a, 0x2f, 0x6c, 0x6f, 0x63, 0x61, 0x74,
	0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x2a, 0x2f, 0x76, 0x6d, 0x77, 0x61, 0x72, 0x65, 0x45, 0x6e, 0x67,
	0x69, 0x6e, 0x65, 0x4e, 0x65, 0x74, 0x77, 0x6f, 0x72, 0x6b, 0x73, 0x2f, 0x2a, 0x7d, 0x12, 0xf0,
	0x01, 0x0a, 0x19, 0x44, 0x65, 0x6c, 0x65, 0x74, 0x65, 0x56, 0x6d, 0x77, 0x61, 0x72, 0x65, 0x45,
	0x6e, 0x67, 0x69, 0x6e, 0x65, 0x4e, 0x65, 0x74, 0x77, 0x6f, 0x72, 0x6b, 0x12, 0x3e, 0x2e, 0x67,
	0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x76, 0x6d, 0x77, 0x61,
	0x72, 0x65, 0x65, 0x6e, 0x67, 0x69, 0x6e, 0x65, 0x2e, 0x76, 0x31, 0x2e, 0x44, 0x65, 0x6c, 0x65,
	0x74, 0x65, 0x56, 0x6d, 0x77, 0x61, 0x72, 0x65, 0x45, 0x6e, 0x67, 0x69, 0x6e, 0x65, 0x4e, 0x65,
	0x74, 0x77, 0x6f, 0x72, 0x6b, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x1a, 0x1d, 0x2e, 0x67,
	0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x6c, 0x6f, 0x6e, 0x67, 0x72, 0x75, 0x6e, 0x6e, 0x69, 0x6e,
	0x67, 0x2e, 0x4f, 0x70, 0x65, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x22, 0x74, 0xca, 0x41, 0x2a,
	0x0a, 0x15, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75,
	0x66, 0x2e, 0x45, 0x6d, 0x70, 0x74, 0x79, 0x12, 0x11, 0x4f, 0x70, 0x65, 0x72, 0x61, 0x74, 0x69,
	0x6f, 0x6e, 0x4d, 0x65, 0x74, 0x61, 0x64, 0x61, 0x74, 0x61, 0xda, 0x41, 0x04, 0x6e, 0x61, 0x6d,
	0x65, 0x82, 0xd3, 0xe4, 0x93, 0x02, 0x3a, 0x2a, 0x38, 0x2f, 0x76, 0x31, 0x2f, 0x7b, 0x6e, 0x61,
	0x6d, 0x65, 0x3d, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x73, 0x2f, 0x2a, 0x2f, 0x6c, 0x6f,
	0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x2a, 0x2f, 0x76, 0x6d, 0x77, 0x61, 0x72, 0x65,
	0x45, 0x6e, 0x67, 0x69, 0x6e, 0x65, 0x4e, 0x65, 0x74, 0x77, 0x6f, 0x72, 0x6b, 0x73, 0x2f, 0x2a,
	0x7d, 0x12, 0xd1, 0x01, 0x0a, 0x16, 0x47, 0x65, 0x74, 0x56, 0x6d, 0x77, 0x61, 0x72, 0x65, 0x45,
	0x6e, 0x67, 0x69, 0x6e, 0x65, 0x4e, 0x65, 0x74, 0x77, 0x6f, 0x72, 0x6b, 0x12, 0x3b, 0x2e, 0x67,
	0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x76, 0x6d, 0x77, 0x61,
	0x72, 0x65, 0x65, 0x6e, 0x67, 0x69, 0x6e, 0x65, 0x2e, 0x76, 0x31, 0x2e, 0x47, 0x65, 0x74, 0x56,
	0x6d, 0x77, 0x61, 0x72, 0x65, 0x45, 0x6e, 0x67, 0x69, 0x6e, 0x65, 0x4e, 0x65, 0x74, 0x77, 0x6f,
	0x72, 0x6b, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x1a, 0x31, 0x2e, 0x67, 0x6f, 0x6f, 0x67,
	0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x76, 0x6d, 0x77, 0x61, 0x72, 0x65, 0x65,
	0x6e, 0x67, 0x69, 0x6e, 0x65, 0x2e, 0x76, 0x31, 0x2e, 0x56, 0x6d, 0x77, 0x61, 0x72, 0x65, 0x45,
	0x6e, 0x67, 0x69, 0x6e, 0x65, 0x4e, 0x65, 0x74, 0x77, 0x6f, 0x72, 0x6b, 0x22, 0x47, 0xda, 0x41,
	0x04, 0x6e, 0x61, 0x6d, 0x65, 0x82, 0xd3, 0xe4, 0x93, 0x02, 0x3a, 0x12, 0x38, 0x2f, 0x76, 0x31,
	0x2f, 0x7b, 0x6e, 0x61, 0x6d, 0x65, 0x3d, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x73, 0x2f,
	0x2a, 0x2f, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x2a, 0x2f, 0x76, 0x6d,
	0x77, 0x61, 0x72, 0x65, 0x45, 0x6e, 0x67, 0x69, 0x6e, 0x65, 0x4e, 0x65, 0x74, 0x77, 0x6f, 0x72,
	0x6b, 0x73, 0x2f, 0x2a, 0x7d, 0x12, 0xe4, 0x01, 0x0a, 0x18, 0x4c, 0x69, 0x73, 0x74, 0x56, 0x6d,
	0x77, 0x61, 0x72, 0x65, 0x45, 0x6e, 0x67, 0x69, 0x6e, 0x65, 0x4e, 0x65, 0x74, 0x77, 0x6f, 0x72,
	0x6b, 0x73, 0x12, 0x3d, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75,
	0x64, 0x2e, 0x76, 0x6d, 0x77, 0x61, 0x72, 0x65, 0x65, 0x6e, 0x67, 0x69, 0x6e, 0x65, 0x2e, 0x76,
	0x31, 0x2e, 0x4c, 0x69, 0x73, 0x74, 0x56, 0x6d, 0x77, 0x61, 0x72, 0x65, 0x45, 0x6e, 0x67, 0x69,
	0x6e, 0x65, 0x4e, 0x65, 0x74, 0x77, 0x6f, 0x72, 0x6b, 0x73, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73,
	0x74, 0x1a, 0x3e, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64,
	0x2e, 0x76, 0x6d, 0x77, 0x61, 0x72, 0x65, 0x65, 0x6e, 0x67, 0x69, 0x6e, 0x65, 0x2e, 0x76, 0x31,
	0x2e, 0x4c, 0x69, 0x73, 0x74, 0x56, 0x6d, 0x77, 0x61, 0x72, 0x65, 0x45, 0x6e, 0x67, 0x69, 0x6e,
	0x65, 0x4e, 0x65, 0x74, 0x77, 0x6f, 0x72, 0x6b, 0x73, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73,
	0x65, 0x22, 0x49, 0xda, 0x41, 0x06, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x82, 0xd3, 0xe4, 0x93,
	0x02, 0x3a, 0x12, 0x38, 0x2f, 0x76, 0x31, 0x2f, 0x7b, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x3d,
	0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x73, 0x2f, 0x2a, 0x2f, 0x6c, 0x6f, 0x63, 0x61, 0x74,
	0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x2a, 0x7d, 0x2f, 0x76, 0x6d, 0x77, 0x61, 0x72, 0x65, 0x45, 0x6e,
	0x67, 0x69, 0x6e, 0x65, 0x4e, 0x65, 0x74, 0x77, 0x6f, 0x72, 0x6b, 0x73, 0x12, 0xa6, 0x02, 0x0a,
	0x17, 0x43, 0x72, 0x65, 0x61, 0x74, 0x65, 0x50, 0x72, 0x69, 0x76, 0x61, 0x74, 0x65, 0x43, 0x6f,
	0x6e, 0x6e, 0x65, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x12, 0x3c, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c,
	0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x76, 0x6d, 0x77, 0x61, 0x72, 0x65, 0x65, 0x6e,
	0x67, 0x69, 0x6e, 0x65, 0x2e, 0x76, 0x31, 0x2e, 0x43, 0x72, 0x65, 0x61, 0x74, 0x65, 0x50, 0x72,
	0x69, 0x76, 0x61, 0x74, 0x65, 0x43, 0x6f, 0x6e, 0x6e, 0x65, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x52,
	0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x1a, 0x1d, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e,
	0x6c, 0x6f, 0x6e, 0x67, 0x72, 0x75, 0x6e, 0x6e, 0x69, 0x6e, 0x67, 0x2e, 0x4f, 0x70, 0x65, 0x72,
	0x61, 0x74, 0x69, 0x6f, 0x6e, 0x22, 0xad, 0x01, 0xca, 0x41, 0x26, 0x0a, 0x11, 0x50, 0x72, 0x69,
	0x76, 0x61, 0x74, 0x65, 0x43, 0x6f, 0x6e, 0x6e, 0x65, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x12, 0x11,
	0x4f, 0x70, 0x65, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x4d, 0x65, 0x74, 0x61, 0x64, 0x61, 0x74,
	0x61, 0xda, 0x41, 0x2f, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x2c, 0x70, 0x72, 0x69, 0x76, 0x61,
	0x74, 0x65, 0x5f, 0x63, 0x6f, 0x6e, 0x6e, 0x65, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x2c, 0x70, 0x72,
	0x69, 0x76, 0x61, 0x74, 0x65, 0x5f, 0x63, 0x6f, 0x6e, 0x6e, 0x65, 0x63, 0x74, 0x69, 0x6f, 0x6e,
	0x5f, 0x69, 0x64, 0x82, 0xd3, 0xe4, 0x93, 0x02, 0x4c, 0x3a, 0x12, 0x70, 0x72, 0x69, 0x76, 0x61,
	0x74, 0x65, 0x5f, 0x63, 0x6f, 0x6e, 0x6e, 0x65, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x22, 0x36, 0x2f,
	0x76, 0x31, 0x2f, 0x7b, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x3d, 0x70, 0x72, 0x6f, 0x6a, 0x65,
	0x63, 0x74, 0x73, 0x2f, 0x2a, 0x2f, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2f,
	0x2a, 0x7d, 0x2f, 0x70, 0x72, 0x69, 0x76, 0x61, 0x74, 0x65, 0x43, 0x6f, 0x6e, 0x6e, 0x65, 0x63,
	0x74, 0x69, 0x6f, 0x6e, 0x73, 0x12, 0xc9, 0x01, 0x0a, 0x14, 0x47, 0x65, 0x74, 0x50, 0x72, 0x69,
	0x76, 0x61, 0x74, 0x65, 0x43, 0x6f, 0x6e, 0x6e, 0x65, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x12, 0x39,
	0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x76, 0x6d,
	0x77, 0x61, 0x72, 0x65, 0x65, 0x6e, 0x67, 0x69, 0x6e, 0x65, 0x2e, 0x76, 0x31, 0x2e, 0x47, 0x65,
	0x74, 0x50, 0x72, 0x69, 0x76, 0x61, 0x74, 0x65, 0x43, 0x6f, 0x6e, 0x6e, 0x65, 0x63, 0x74, 0x69,
	0x6f, 0x6e, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x1a, 0x2f, 0x2e, 0x67, 0x6f, 0x6f, 0x67,
	0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x76, 0x6d, 0x77, 0x61, 0x72, 0x65, 0x65,
	0x6e, 0x67, 0x69, 0x6e, 0x65, 0x2e, 0x76, 0x31, 0x2e, 0x50, 0x72, 0x69, 0x76, 0x61, 0x74, 0x65,
	0x43, 0x6f, 0x6e, 0x6e, 0x65, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x22, 0x45, 0xda, 0x41, 0x04, 0x6e,
	0x61, 0x6d, 0x65, 0x82, 0xd3, 0xe4, 0x93, 0x02, 0x38, 0x12, 0x36, 0x2f, 0x76, 0x31, 0x2f, 0x7b,
	0x6e, 0x61, 0x6d, 0x65, 0x3d, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x73, 0x2f, 0x2a, 0x2f,
	0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x2a, 0x2f, 0x70, 0x72, 0x69, 0x76,
	0x61, 0x74, 0x65, 0x43, 0x6f, 0x6e, 0x6e, 0x65, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x2a,
	0x7d, 0x12, 0xdc, 0x01, 0x0a, 0x16, 0x4c, 0x69, 0x73, 0x74, 0x50, 0x72, 0x69, 0x76, 0x61, 0x74,
	0x65, 0x43, 0x6f, 0x6e, 0x6e, 0x65, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x12, 0x3b, 0x2e, 0x67,
	0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x76, 0x6d, 0x77, 0x61,
	0x72, 0x65, 0x65, 0x6e, 0x67, 0x69, 0x6e, 0x65, 0x2e, 0x76, 0x31, 0x2e, 0x4c, 0x69, 0x73, 0x74,
	0x50, 0x72, 0x69, 0x76, 0x61, 0x74, 0x65, 0x43, 0x6f, 0x6e, 0x6e, 0x65, 0x63, 0x74, 0x69, 0x6f,
	0x6e, 0x73, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x1a, 0x3c, 0x2e, 0x67, 0x6f, 0x6f, 0x67,
	0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x76, 0x6d, 0x77, 0x61, 0x72, 0x65, 0x65,
	0x6e, 0x67, 0x69, 0x6e, 0x65, 0x2e, 0x76, 0x31, 0x2e, 0x4c, 0x69, 0x73, 0x74, 0x50, 0x72, 0x69,
	0x76, 0x61, 0x74, 0x65, 0x43, 0x6f, 0x6e, 0x6e, 0x65, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x52,
	0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x22, 0x47, 0xda, 0x41, 0x06, 0x70, 0x61, 0x72, 0x65,
	0x6e, 0x74, 0x82, 0xd3, 0xe4, 0x93, 0x02, 0x38, 0x12, 0x36, 0x2f, 0x76, 0x31, 0x2f, 0x7b, 0x70,
	0x61, 0x72, 0x65, 0x6e, 0x74, 0x3d, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x73, 0x2f, 0x2a,
	0x2f, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x2a, 0x7d, 0x2f, 0x70, 0x72,
	0x69, 0x76, 0x61, 0x74, 0x65, 0x43, 0x6f, 0x6e, 0x6e, 0x65, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x73,
	0x12, 0xa8, 0x02, 0x0a, 0x17, 0x55, 0x70, 0x64, 0x61, 0x74, 0x65, 0x50, 0x72, 0x69, 0x76, 0x61,
	0x74, 0x65, 0x43, 0x6f, 0x6e, 0x6e, 0x65, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x12, 0x3c, 0x2e, 0x67,
	0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x76, 0x6d, 0x77, 0x61,
	0x72, 0x65, 0x65, 0x6e, 0x67, 0x69, 0x6e, 0x65, 0x2e, 0x76, 0x31, 0x2e, 0x55, 0x70, 0x64, 0x61,
	0x74, 0x65, 0x50, 0x72, 0x69, 0x76, 0x61, 0x74, 0x65, 0x43, 0x6f, 0x6e, 0x6e, 0x65, 0x63, 0x74,
	0x69, 0x6f, 0x6e, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x1a, 0x1d, 0x2e, 0x67, 0x6f, 0x6f,
	0x67, 0x6c, 0x65, 0x2e, 0x6c, 0x6f, 0x6e, 0x67, 0x72, 0x75, 0x6e, 0x6e, 0x69, 0x6e, 0x67, 0x2e,
	0x4f, 0x70, 0x65, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x22, 0xaf, 0x01, 0xca, 0x41, 0x26, 0x0a,
	0x11, 0x50, 0x72, 0x69, 0x76, 0x61, 0x74, 0x65, 0x43, 0x6f, 0x6e, 0x6e, 0x65, 0x63, 0x74, 0x69,
	0x6f, 0x6e, 0x12, 0x11, 0x4f, 0x70, 0x65, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x4d, 0x65, 0x74,
	0x61, 0x64, 0x61, 0x74, 0x61, 0xda, 0x41, 0x1e, 0x70, 0x72, 0x69, 0x76, 0x61, 0x74, 0x65, 0x5f,
	0x63, 0x6f, 0x6e, 0x6e, 0x65, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x2c, 0x75, 0x70, 0x64, 0x61, 0x74,
	0x65, 0x5f, 0x6d, 0x61, 0x73, 0x6b, 0x82, 0xd3, 0xe4, 0x93, 0x02, 0x5f, 0x3a, 0x12, 0x70, 0x72,
	0x69, 0x76, 0x61, 0x74, 0x65, 0x5f, 0x63, 0x6f, 0x6e, 0x6e, 0x65, 0x63, 0x74, 0x69, 0x6f, 0x6e,
	0x32, 0x49, 0x2f, 0x76, 0x31, 0x2f, 0x7b, 0x70, 0x72, 0x69, 0x76, 0x61, 0x74, 0x65, 0x5f, 0x63,
	0x6f, 0x6e, 0x6e, 0x65, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x2e, 0x6e, 0x61, 0x6d, 0x65, 0x3d, 0x70,
	0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x73, 0x2f, 0x2a, 0x2f, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69,
	0x6f, 0x6e, 0x73, 0x2f, 0x2a, 0x2f, 0x70, 0x72, 0x69, 0x76, 0x61, 0x74, 0x65, 0x43, 0x6f, 0x6e,
	0x6e, 0x65, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x2a, 0x7d, 0x12, 0xea, 0x01, 0x0a, 0x17,
	0x44, 0x65, 0x6c, 0x65, 0x74, 0x65, 0x50, 0x72, 0x69, 0x76, 0x61, 0x74, 0x65, 0x43, 0x6f, 0x6e,
	0x6e, 0x65, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x12, 0x3c, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65,
	0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x76, 0x6d, 0x77, 0x61, 0x72, 0x65, 0x65, 0x6e, 0x67,
	0x69, 0x6e, 0x65, 0x2e, 0x76, 0x31, 0x2e, 0x44, 0x65, 0x6c, 0x65, 0x74, 0x65, 0x50, 0x72, 0x69,
	0x76, 0x61, 0x74, 0x65, 0x43, 0x6f, 0x6e, 0x6e, 0x65, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x52, 0x65,
	0x71, 0x75, 0x65, 0x73, 0x74, 0x1a, 0x1d, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x6c,
	0x6f, 0x6e, 0x67, 0x72, 0x75, 0x6e, 0x6e, 0x69, 0x6e, 0x67, 0x2e, 0x4f, 0x70, 0x65, 0x72, 0x61,
	0x74, 0x69, 0x6f, 0x6e, 0x22, 0x72, 0xca, 0x41, 0x2a, 0x0a, 0x15, 0x67, 0x6f, 0x6f, 0x67, 0x6c,
	0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x45, 0x6d, 0x70, 0x74, 0x79,
	0x12, 0x11, 0x4f, 0x70, 0x65, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x4d, 0x65, 0x74, 0x61, 0x64,
	0x61, 0x74, 0x61, 0xda, 0x41, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x82, 0xd3, 0xe4, 0x93, 0x02, 0x38,
	0x2a, 0x36, 0x2f, 0x76, 0x31, 0x2f, 0x7b, 0x6e, 0x61, 0x6d, 0x65, 0x3d, 0x70, 0x72, 0x6f, 0x6a,
	0x65, 0x63, 0x74, 0x73, 0x2f, 0x2a, 0x2f, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73,
	0x2f, 0x2a, 0x2f, 0x70, 0x72, 0x69, 0x76, 0x61, 0x74, 0x65, 0x43, 0x6f, 0x6e, 0x6e, 0x65, 0x63,
	0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x2a, 0x7d, 0x12, 0x90, 0x02, 0x0a, 0x22, 0x4c, 0x69, 0x73,
	0x74, 0x50, 0x72, 0x69, 0x76, 0x61, 0x74, 0x65, 0x43, 0x6f, 0x6e, 0x6e, 0x65, 0x63, 0x74, 0x69,
	0x6f, 0x6e, 0x50, 0x65, 0x65, 0x72, 0x69, 0x6e, 0x67, 0x52, 0x6f, 0x75, 0x74, 0x65, 0x73, 0x12,
	0x47, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x76,
	0x6d, 0x77, 0x61, 0x72, 0x65, 0x65, 0x6e, 0x67, 0x69, 0x6e, 0x65, 0x2e, 0x76, 0x31, 0x2e, 0x4c,
	0x69, 0x73, 0x74, 0x50, 0x72, 0x69, 0x76, 0x61, 0x74, 0x65, 0x43, 0x6f, 0x6e, 0x6e, 0x65, 0x63,
	0x74, 0x69, 0x6f, 0x6e, 0x50, 0x65, 0x65, 0x72, 0x69, 0x6e, 0x67, 0x52, 0x6f, 0x75, 0x74, 0x65,
	0x73, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x1a, 0x48, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c,
	0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x76, 0x6d, 0x77, 0x61, 0x72, 0x65, 0x65, 0x6e,
	0x67, 0x69, 0x6e, 0x65, 0x2e, 0x76, 0x31, 0x2e, 0x4c, 0x69, 0x73, 0x74, 0x50, 0x72, 0x69, 0x76,
	0x61, 0x74, 0x65, 0x43, 0x6f, 0x6e, 0x6e, 0x65, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x50, 0x65, 0x65,
	0x72, 0x69, 0x6e, 0x67, 0x52, 0x6f, 0x75, 0x74, 0x65, 0x73, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e,
	0x73, 0x65, 0x22, 0x57, 0xda, 0x41, 0x06, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x82, 0xd3, 0xe4,
	0x93, 0x02, 0x48, 0x12, 0x46, 0x2f, 0x76, 0x31, 0x2f, 0x7b, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74,
	0x3d, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x73, 0x2f, 0x2a, 0x2f, 0x6c, 0x6f, 0x63, 0x61,
	0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x2a, 0x2f, 0x70, 0x72, 0x69, 0x76, 0x61, 0x74, 0x65, 0x43,
	0x6f, 0x6e, 0x6e, 0x65, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x2a, 0x7d, 0x2f, 0x70, 0x65,
	0x65, 0x72, 0x69, 0x6e, 0x67, 0x52, 0x6f, 0x75, 0x74, 0x65, 0x73, 0x1a, 0x4f, 0xca, 0x41, 0x1b,
	0x76, 0x6d, 0x77, 0x61, 0x72, 0x65, 0x65, 0x6e, 0x67, 0x69, 0x6e, 0x65, 0x2e, 0x67, 0x6f, 0x6f,
	0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0xd2, 0x41, 0x2e, 0x68, 0x74,
	0x74, 0x70, 0x73, 0x3a, 0x2f, 0x2f, 0x77, 0x77, 0x77, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65,
	0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x61, 0x75, 0x74, 0x68, 0x2f, 0x63, 0x6c,
	0x6f, 0x75, 0x64, 0x2d, 0x70, 0x6c, 0x61, 0x74, 0x66, 0x6f, 0x72, 0x6d, 0x42, 0xae, 0x02, 0xea,
	0x41, 0x4e, 0x0a, 0x1e, 0x63, 0x6f, 0x6d, 0x70, 0x75, 0x74, 0x65, 0x2e, 0x67, 0x6f, 0x6f, 0x67,
	0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x4e, 0x65, 0x74, 0x77, 0x6f,
	0x72, 0x6b, 0x12, 0x2c, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x73, 0x2f, 0x7b, 0x70, 0x72,
	0x6f, 0x6a, 0x65, 0x63, 0x74, 0x7d, 0x2f, 0x67, 0x6c, 0x6f, 0x62, 0x61, 0x6c, 0x2f, 0x6e, 0x65,
	0x74, 0x77, 0x6f, 0x72, 0x6b, 0x73, 0x2f, 0x7b, 0x6e, 0x65, 0x74, 0x77, 0x6f, 0x72, 0x6b, 0x7d,
	0x0a, 0x20, 0x63, 0x6f, 0x6d, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f,
	0x75, 0x64, 0x2e, 0x76, 0x6d, 0x77, 0x61, 0x72, 0x65, 0x65, 0x6e, 0x67, 0x69, 0x6e, 0x65, 0x2e,
	0x76, 0x31, 0x42, 0x11, 0x56, 0x6d, 0x77, 0x61, 0x72, 0x65, 0x65, 0x6e, 0x67, 0x69, 0x6e, 0x65,
	0x50, 0x72, 0x6f, 0x74, 0x6f, 0x50, 0x01, 0x5a, 0x44, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x67,
	0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x67, 0x6f, 0x2f, 0x76, 0x6d, 0x77,
	0x61, 0x72, 0x65, 0x65, 0x6e, 0x67, 0x69, 0x6e, 0x65, 0x2f, 0x61, 0x70, 0x69, 0x76, 0x31, 0x2f,
	0x76, 0x6d, 0x77, 0x61, 0x72, 0x65, 0x65, 0x6e, 0x67, 0x69, 0x6e, 0x65, 0x70, 0x62, 0x3b, 0x76,
	0x6d, 0x77, 0x61, 0x72, 0x65, 0x65, 0x6e, 0x67, 0x69, 0x6e, 0x65, 0x70, 0x62, 0xaa, 0x02, 0x1c,
	0x47, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x43, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x56, 0x6d, 0x77,
	0x61, 0x72, 0x65, 0x45, 0x6e, 0x67, 0x69, 0x6e, 0x65, 0x2e, 0x56, 0x31, 0xca, 0x02, 0x1c, 0x47,
	0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x5c, 0x43, 0x6c, 0x6f, 0x75, 0x64, 0x5c, 0x56, 0x6d, 0x77, 0x61,
	0x72, 0x65, 0x45, 0x6e, 0x67, 0x69, 0x6e, 0x65, 0x5c, 0x56, 0x31, 0xea, 0x02, 0x1f, 0x47, 0x6f,
	0x6f, 0x67, 0x6c, 0x65, 0x3a, 0x3a, 0x43, 0x6c, 0x6f, 0x75, 0x64, 0x3a, 0x3a, 0x56, 0x6d, 0x77,
	0x61, 0x72, 0x65, 0x45, 0x6e, 0x67, 0x69, 0x6e, 0x65, 0x3a, 0x3a, 0x56, 0x31, 0x62, 0x06, 0x70,
	0x72, 0x6f, 0x74, 0x6f, 0x33,
}

var (
	file_google_cloud_vmwareengine_v1_vmwareengine_proto_rawDescOnce sync.Once
	file_google_cloud_vmwareengine_v1_vmwareengine_proto_rawDescData = file_google_cloud_vmwareengine_v1_vmwareengine_proto_rawDesc
)

func file_google_cloud_vmwareengine_v1_vmwareengine_proto_rawDescGZIP() []byte {
	file_google_cloud_vmwareengine_v1_vmwareengine_proto_rawDescOnce.Do(func() {
		file_google_cloud_vmwareengine_v1_vmwareengine_proto_rawDescData = protoimpl.X.CompressGZIP(file_google_cloud_vmwareengine_v1_vmwareengine_proto_rawDescData)
	})
	return file_google_cloud_vmwareengine_v1_vmwareengine_proto_rawDescData
}

var file_google_cloud_vmwareengine_v1_vmwareengine_proto_msgTypes = make([]protoimpl.MessageInfo, 49)
var file_google_cloud_vmwareengine_v1_vmwareengine_proto_goTypes = []interface{}{
	(*ListPrivateCloudsRequest)(nil),                   // 0: google.cloud.vmwareengine.v1.ListPrivateCloudsRequest
	(*ListPrivateCloudsResponse)(nil),                  // 1: google.cloud.vmwareengine.v1.ListPrivateCloudsResponse
	(*GetPrivateCloudRequest)(nil),                     // 2: google.cloud.vmwareengine.v1.GetPrivateCloudRequest
	(*CreatePrivateCloudRequest)(nil),                  // 3: google.cloud.vmwareengine.v1.CreatePrivateCloudRequest
	(*UpdatePrivateCloudRequest)(nil),                  // 4: google.cloud.vmwareengine.v1.UpdatePrivateCloudRequest
	(*DeletePrivateCloudRequest)(nil),                  // 5: google.cloud.vmwareengine.v1.DeletePrivateCloudRequest
	(*UndeletePrivateCloudRequest)(nil),                // 6: google.cloud.vmwareengine.v1.UndeletePrivateCloudRequest
	(*ListClustersRequest)(nil),                        // 7: google.cloud.vmwareengine.v1.ListClustersRequest
	(*ListClustersResponse)(nil),                       // 8: google.cloud.vmwareengine.v1.ListClustersResponse
	(*GetClusterRequest)(nil),                          // 9: google.cloud.vmwareengine.v1.GetClusterRequest
	(*CreateClusterRequest)(nil),                       // 10: google.cloud.vmwareengine.v1.CreateClusterRequest
	(*UpdateClusterRequest)(nil),                       // 11: google.cloud.vmwareengine.v1.UpdateClusterRequest
	(*DeleteClusterRequest)(nil),                       // 12: google.cloud.vmwareengine.v1.DeleteClusterRequest
	(*ListSubnetsRequest)(nil),                         // 13: google.cloud.vmwareengine.v1.ListSubnetsRequest
	(*ListSubnetsResponse)(nil),                        // 14: google.cloud.vmwareengine.v1.ListSubnetsResponse
	(*GetSubnetRequest)(nil),                           // 15: google.cloud.vmwareengine.v1.GetSubnetRequest
	(*UpdateSubnetRequest)(nil),                        // 16: google.cloud.vmwareengine.v1.UpdateSubnetRequest
	(*OperationMetadata)(nil),                          // 17: google.cloud.vmwareengine.v1.OperationMetadata
	(*ListNodeTypesRequest)(nil),                       // 18: google.cloud.vmwareengine.v1.ListNodeTypesRequest
	(*ListNodeTypesResponse)(nil),                      // 19: google.cloud.vmwareengine.v1.ListNodeTypesResponse
	(*GetNodeTypeRequest)(nil),                         // 20: google.cloud.vmwareengine.v1.GetNodeTypeRequest
	(*ShowNsxCredentialsRequest)(nil),                  // 21: google.cloud.vmwareengine.v1.ShowNsxCredentialsRequest
	(*ShowVcenterCredentialsRequest)(nil),              // 22: google.cloud.vmwareengine.v1.ShowVcenterCredentialsRequest
	(*ResetNsxCredentialsRequest)(nil),                 // 23: google.cloud.vmwareengine.v1.ResetNsxCredentialsRequest
	(*ResetVcenterCredentialsRequest)(nil),             // 24: google.cloud.vmwareengine.v1.ResetVcenterCredentialsRequest
	(*ListHcxActivationKeysResponse)(nil),              // 25: google.cloud.vmwareengine.v1.ListHcxActivationKeysResponse
	(*ListHcxActivationKeysRequest)(nil),               // 26: google.cloud.vmwareengine.v1.ListHcxActivationKeysRequest
	(*GetHcxActivationKeyRequest)(nil),                 // 27: google.cloud.vmwareengine.v1.GetHcxActivationKeyRequest
	(*CreateHcxActivationKeyRequest)(nil),              // 28: google.cloud.vmwareengine.v1.CreateHcxActivationKeyRequest
	(*ListNetworkPoliciesRequest)(nil),                 // 29: google.cloud.vmwareengine.v1.ListNetworkPoliciesRequest
	(*ListNetworkPoliciesResponse)(nil),                // 30: google.cloud.vmwareengine.v1.ListNetworkPoliciesResponse
	(*GetNetworkPolicyRequest)(nil),                    // 31: google.cloud.vmwareengine.v1.GetNetworkPolicyRequest
	(*UpdateNetworkPolicyRequest)(nil),                 // 32: google.cloud.vmwareengine.v1.UpdateNetworkPolicyRequest
	(*CreateNetworkPolicyRequest)(nil),                 // 33: google.cloud.vmwareengine.v1.CreateNetworkPolicyRequest
	(*DeleteNetworkPolicyRequest)(nil),                 // 34: google.cloud.vmwareengine.v1.DeleteNetworkPolicyRequest
	(*CreateVmwareEngineNetworkRequest)(nil),           // 35: google.cloud.vmwareengine.v1.CreateVmwareEngineNetworkRequest
	(*UpdateVmwareEngineNetworkRequest)(nil),           // 36: google.cloud.vmwareengine.v1.UpdateVmwareEngineNetworkRequest
	(*DeleteVmwareEngineNetworkRequest)(nil),           // 37: google.cloud.vmwareengine.v1.DeleteVmwareEngineNetworkRequest
	(*GetVmwareEngineNetworkRequest)(nil),              // 38: google.cloud.vmwareengine.v1.GetVmwareEngineNetworkRequest
	(*ListVmwareEngineNetworksRequest)(nil),            // 39: google.cloud.vmwareengine.v1.ListVmwareEngineNetworksRequest
	(*ListVmwareEngineNetworksResponse)(nil),           // 40: google.cloud.vmwareengine.v1.ListVmwareEngineNetworksResponse
	(*CreatePrivateConnectionRequest)(nil),             // 41: google.cloud.vmwareengine.v1.CreatePrivateConnectionRequest
	(*GetPrivateConnectionRequest)(nil),                // 42: google.cloud.vmwareengine.v1.GetPrivateConnectionRequest
	(*ListPrivateConnectionsRequest)(nil),              // 43: google.cloud.vmwareengine.v1.ListPrivateConnectionsRequest
	(*ListPrivateConnectionsResponse)(nil),             // 44: google.cloud.vmwareengine.v1.ListPrivateConnectionsResponse
	(*UpdatePrivateConnectionRequest)(nil),             // 45: google.cloud.vmwareengine.v1.UpdatePrivateConnectionRequest
	(*DeletePrivateConnectionRequest)(nil),             // 46: google.cloud.vmwareengine.v1.DeletePrivateConnectionRequest
	(*ListPrivateConnectionPeeringRoutesRequest)(nil),  // 47: google.cloud.vmwareengine.v1.ListPrivateConnectionPeeringRoutesRequest
	(*ListPrivateConnectionPeeringRoutesResponse)(nil), // 48: google.cloud.vmwareengine.v1.ListPrivateConnectionPeeringRoutesResponse
	(*PrivateCloud)(nil),                               // 49: google.cloud.vmwareengine.v1.PrivateCloud
	(*fieldmaskpb.FieldMask)(nil),                      // 50: google.protobuf.FieldMask
	(*Cluster)(nil),                                    // 51: google.cloud.vmwareengine.v1.Cluster
	(*Subnet)(nil),                                     // 52: google.cloud.vmwareengine.v1.Subnet
	(*timestamppb.Timestamp)(nil),                      // 53: google.protobuf.Timestamp
	(*NodeType)(nil),                                   // 54: google.cloud.vmwareengine.v1.NodeType
	(*HcxActivationKey)(nil),                           // 55: google.cloud.vmwareengine.v1.HcxActivationKey
	(*NetworkPolicy)(nil),                              // 56: google.cloud.vmwareengine.v1.NetworkPolicy
	(*VmwareEngineNetwork)(nil),                        // 57: google.cloud.vmwareengine.v1.VmwareEngineNetwork
	(*PrivateConnection)(nil),                          // 58: google.cloud.vmwareengine.v1.PrivateConnection
	(*PeeringRoute)(nil),                               // 59: google.cloud.vmwareengine.v1.PeeringRoute
	(*longrunningpb.Operation)(nil),                    // 60: google.longrunning.Operation
	(*Credentials)(nil),                                // 61: google.cloud.vmwareengine.v1.Credentials
}
var file_google_cloud_vmwareengine_v1_vmwareengine_proto_depIdxs = []int32{
	49, // 0: google.cloud.vmwareengine.v1.ListPrivateCloudsResponse.private_clouds:type_name -> google.cloud.vmwareengine.v1.PrivateCloud
	49, // 1: google.cloud.vmwareengine.v1.CreatePrivateCloudRequest.private_cloud:type_name -> google.cloud.vmwareengine.v1.PrivateCloud
	49, // 2: google.cloud.vmwareengine.v1.UpdatePrivateCloudRequest.private_cloud:type_name -> google.cloud.vmwareengine.v1.PrivateCloud
	50, // 3: google.cloud.vmwareengine.v1.UpdatePrivateCloudRequest.update_mask:type_name -> google.protobuf.FieldMask
	51, // 4: google.cloud.vmwareengine.v1.ListClustersResponse.clusters:type_name -> google.cloud.vmwareengine.v1.Cluster
	51, // 5: google.cloud.vmwareengine.v1.CreateClusterRequest.cluster:type_name -> google.cloud.vmwareengine.v1.Cluster
	50, // 6: google.cloud.vmwareengine.v1.UpdateClusterRequest.update_mask:type_name -> google.protobuf.FieldMask
	51, // 7: google.cloud.vmwareengine.v1.UpdateClusterRequest.cluster:type_name -> google.cloud.vmwareengine.v1.Cluster
	52, // 8: google.cloud.vmwareengine.v1.ListSubnetsResponse.subnets:type_name -> google.cloud.vmwareengine.v1.Subnet
	50, // 9: google.cloud.vmwareengine.v1.UpdateSubnetRequest.update_mask:type_name -> google.protobuf.FieldMask
	52, // 10: google.cloud.vmwareengine.v1.UpdateSubnetRequest.subnet:type_name -> google.cloud.vmwareengine.v1.Subnet
	53, // 11: google.cloud.vmwareengine.v1.OperationMetadata.create_time:type_name -> google.protobuf.Timestamp
	53, // 12: google.cloud.vmwareengine.v1.OperationMetadata.end_time:type_name -> google.protobuf.Timestamp
	54, // 13: google.cloud.vmwareengine.v1.ListNodeTypesResponse.node_types:type_name -> google.cloud.vmwareengine.v1.NodeType
	55, // 14: google.cloud.vmwareengine.v1.ListHcxActivationKeysResponse.hcx_activation_keys:type_name -> google.cloud.vmwareengine.v1.HcxActivationKey
	55, // 15: google.cloud.vmwareengine.v1.CreateHcxActivationKeyRequest.hcx_activation_key:type_name -> google.cloud.vmwareengine.v1.HcxActivationKey
	56, // 16: google.cloud.vmwareengine.v1.ListNetworkPoliciesResponse.network_policies:type_name -> google.cloud.vmwareengine.v1.NetworkPolicy
	56, // 17: google.cloud.vmwareengine.v1.UpdateNetworkPolicyRequest.network_policy:type_name -> google.cloud.vmwareengine.v1.NetworkPolicy
	50, // 18: google.cloud.vmwareengine.v1.UpdateNetworkPolicyRequest.update_mask:type_name -> google.protobuf.FieldMask
	56, // 19: google.cloud.vmwareengine.v1.CreateNetworkPolicyRequest.network_policy:type_name -> google.cloud.vmwareengine.v1.NetworkPolicy
	57, // 20: google.cloud.vmwareengine.v1.CreateVmwareEngineNetworkRequest.vmware_engine_network:type_name -> google.cloud.vmwareengine.v1.VmwareEngineNetwork
	57, // 21: google.cloud.vmwareengine.v1.UpdateVmwareEngineNetworkRequest.vmware_engine_network:type_name -> google.cloud.vmwareengine.v1.VmwareEngineNetwork
	50, // 22: google.cloud.vmwareengine.v1.UpdateVmwareEngineNetworkRequest.update_mask:type_name -> google.protobuf.FieldMask
	57, // 23: google.cloud.vmwareengine.v1.ListVmwareEngineNetworksResponse.vmware_engine_networks:type_name -> google.cloud.vmwareengine.v1.VmwareEngineNetwork
	58, // 24: google.cloud.vmwareengine.v1.CreatePrivateConnectionRequest.private_connection:type_name -> google.cloud.vmwareengine.v1.PrivateConnection
	58, // 25: google.cloud.vmwareengine.v1.ListPrivateConnectionsResponse.private_connections:type_name -> google.cloud.vmwareengine.v1.PrivateConnection
	58, // 26: google.cloud.vmwareengine.v1.UpdatePrivateConnectionRequest.private_connection:type_name -> google.cloud.vmwareengine.v1.PrivateConnection
	50, // 27: google.cloud.vmwareengine.v1.UpdatePrivateConnectionRequest.update_mask:type_name -> google.protobuf.FieldMask
	59, // 28: google.cloud.vmwareengine.v1.ListPrivateConnectionPeeringRoutesResponse.peering_routes:type_name -> google.cloud.vmwareengine.v1.PeeringRoute
	0,  // 29: google.cloud.vmwareengine.v1.VmwareEngine.ListPrivateClouds:input_type -> google.cloud.vmwareengine.v1.ListPrivateCloudsRequest
	2,  // 30: google.cloud.vmwareengine.v1.VmwareEngine.GetPrivateCloud:input_type -> google.cloud.vmwareengine.v1.GetPrivateCloudRequest
	3,  // 31: google.cloud.vmwareengine.v1.VmwareEngine.CreatePrivateCloud:input_type -> google.cloud.vmwareengine.v1.CreatePrivateCloudRequest
	4,  // 32: google.cloud.vmwareengine.v1.VmwareEngine.UpdatePrivateCloud:input_type -> google.cloud.vmwareengine.v1.UpdatePrivateCloudRequest
	5,  // 33: google.cloud.vmwareengine.v1.VmwareEngine.DeletePrivateCloud:input_type -> google.cloud.vmwareengine.v1.DeletePrivateCloudRequest
	6,  // 34: google.cloud.vmwareengine.v1.VmwareEngine.UndeletePrivateCloud:input_type -> google.cloud.vmwareengine.v1.UndeletePrivateCloudRequest
	7,  // 35: google.cloud.vmwareengine.v1.VmwareEngine.ListClusters:input_type -> google.cloud.vmwareengine.v1.ListClustersRequest
	9,  // 36: google.cloud.vmwareengine.v1.VmwareEngine.GetCluster:input_type -> google.cloud.vmwareengine.v1.GetClusterRequest
	10, // 37: google.cloud.vmwareengine.v1.VmwareEngine.CreateCluster:input_type -> google.cloud.vmwareengine.v1.CreateClusterRequest
	11, // 38: google.cloud.vmwareengine.v1.VmwareEngine.UpdateCluster:input_type -> google.cloud.vmwareengine.v1.UpdateClusterRequest
	12, // 39: google.cloud.vmwareengine.v1.VmwareEngine.DeleteCluster:input_type -> google.cloud.vmwareengine.v1.DeleteClusterRequest
	13, // 40: google.cloud.vmwareengine.v1.VmwareEngine.ListSubnets:input_type -> google.cloud.vmwareengine.v1.ListSubnetsRequest
	15, // 41: google.cloud.vmwareengine.v1.VmwareEngine.GetSubnet:input_type -> google.cloud.vmwareengine.v1.GetSubnetRequest
	16, // 42: google.cloud.vmwareengine.v1.VmwareEngine.UpdateSubnet:input_type -> google.cloud.vmwareengine.v1.UpdateSubnetRequest
	18, // 43: google.cloud.vmwareengine.v1.VmwareEngine.ListNodeTypes:input_type -> google.cloud.vmwareengine.v1.ListNodeTypesRequest
	20, // 44: google.cloud.vmwareengine.v1.VmwareEngine.GetNodeType:input_type -> google.cloud.vmwareengine.v1.GetNodeTypeRequest
	21, // 45: google.cloud.vmwareengine.v1.VmwareEngine.ShowNsxCredentials:input_type -> google.cloud.vmwareengine.v1.ShowNsxCredentialsRequest
	22, // 46: google.cloud.vmwareengine.v1.VmwareEngine.ShowVcenterCredentials:input_type -> google.cloud.vmwareengine.v1.ShowVcenterCredentialsRequest
	23, // 47: google.cloud.vmwareengine.v1.VmwareEngine.ResetNsxCredentials:input_type -> google.cloud.vmwareengine.v1.ResetNsxCredentialsRequest
	24, // 48: google.cloud.vmwareengine.v1.VmwareEngine.ResetVcenterCredentials:input_type -> google.cloud.vmwareengine.v1.ResetVcenterCredentialsRequest
	28, // 49: google.cloud.vmwareengine.v1.VmwareEngine.CreateHcxActivationKey:input_type -> google.cloud.vmwareengine.v1.CreateHcxActivationKeyRequest
	26, // 50: google.cloud.vmwareengine.v1.VmwareEngine.ListHcxActivationKeys:input_type -> google.cloud.vmwareengine.v1.ListHcxActivationKeysRequest
	27, // 51: google.cloud.vmwareengine.v1.VmwareEngine.GetHcxActivationKey:input_type -> google.cloud.vmwareengine.v1.GetHcxActivationKeyRequest
	31, // 52: google.cloud.vmwareengine.v1.VmwareEngine.GetNetworkPolicy:input_type -> google.cloud.vmwareengine.v1.GetNetworkPolicyRequest
	29, // 53: google.cloud.vmwareengine.v1.VmwareEngine.ListNetworkPolicies:input_type -> google.cloud.vmwareengine.v1.ListNetworkPoliciesRequest
	33, // 54: google.cloud.vmwareengine.v1.VmwareEngine.CreateNetworkPolicy:input_type -> google.cloud.vmwareengine.v1.CreateNetworkPolicyRequest
	32, // 55: google.cloud.vmwareengine.v1.VmwareEngine.UpdateNetworkPolicy:input_type -> google.cloud.vmwareengine.v1.UpdateNetworkPolicyRequest
	34, // 56: google.cloud.vmwareengine.v1.VmwareEngine.DeleteNetworkPolicy:input_type -> google.cloud.vmwareengine.v1.DeleteNetworkPolicyRequest
	35, // 57: google.cloud.vmwareengine.v1.VmwareEngine.CreateVmwareEngineNetwork:input_type -> google.cloud.vmwareengine.v1.CreateVmwareEngineNetworkRequest
	36, // 58: google.cloud.vmwareengine.v1.VmwareEngine.UpdateVmwareEngineNetwork:input_type -> google.cloud.vmwareengine.v1.UpdateVmwareEngineNetworkRequest
	37, // 59: google.cloud.vmwareengine.v1.VmwareEngine.DeleteVmwareEngineNetwork:input_type -> google.cloud.vmwareengine.v1.DeleteVmwareEngineNetworkRequest
	38, // 60: google.cloud.vmwareengine.v1.VmwareEngine.GetVmwareEngineNetwork:input_type -> google.cloud.vmwareengine.v1.GetVmwareEngineNetworkRequest
	39, // 61: google.cloud.vmwareengine.v1.VmwareEngine.ListVmwareEngineNetworks:input_type -> google.cloud.vmwareengine.v1.ListVmwareEngineNetworksRequest
	41, // 62: google.cloud.vmwareengine.v1.VmwareEngine.CreatePrivateConnection:input_type -> google.cloud.vmwareengine.v1.CreatePrivateConnectionRequest
	42, // 63: google.cloud.vmwareengine.v1.VmwareEngine.GetPrivateConnection:input_type -> google.cloud.vmwareengine.v1.GetPrivateConnectionRequest
	43, // 64: google.cloud.vmwareengine.v1.VmwareEngine.ListPrivateConnections:input_type -> google.cloud.vmwareengine.v1.ListPrivateConnectionsRequest
	45, // 65: google.cloud.vmwareengine.v1.VmwareEngine.UpdatePrivateConnection:input_type -> google.cloud.vmwareengine.v1.UpdatePrivateConnectionRequest
	46, // 66: google.cloud.vmwareengine.v1.VmwareEngine.DeletePrivateConnection:input_type -> google.cloud.vmwareengine.v1.DeletePrivateConnectionRequest
	47, // 67: google.cloud.vmwareengine.v1.VmwareEngine.ListPrivateConnectionPeeringRoutes:input_type -> google.cloud.vmwareengine.v1.ListPrivateConnectionPeeringRoutesRequest
	1,  // 68: google.cloud.vmwareengine.v1.VmwareEngine.ListPrivateClouds:output_type -> google.cloud.vmwareengine.v1.ListPrivateCloudsResponse
	49, // 69: google.cloud.vmwareengine.v1.VmwareEngine.GetPrivateCloud:output_type -> google.cloud.vmwareengine.v1.PrivateCloud
	60, // 70: google.cloud.vmwareengine.v1.VmwareEngine.CreatePrivateCloud:output_type -> google.longrunning.Operation
	60, // 71: google.cloud.vmwareengine.v1.VmwareEngine.UpdatePrivateCloud:output_type -> google.longrunning.Operation
	60, // 72: google.cloud.vmwareengine.v1.VmwareEngine.DeletePrivateCloud:output_type -> google.longrunning.Operation
	60, // 73: google.cloud.vmwareengine.v1.VmwareEngine.UndeletePrivateCloud:output_type -> google.longrunning.Operation
	8,  // 74: google.cloud.vmwareengine.v1.VmwareEngine.ListClusters:output_type -> google.cloud.vmwareengine.v1.ListClustersResponse
	51, // 75: google.cloud.vmwareengine.v1.VmwareEngine.GetCluster:output_type -> google.cloud.vmwareengine.v1.Cluster
	60, // 76: google.cloud.vmwareengine.v1.VmwareEngine.CreateCluster:output_type -> google.longrunning.Operation
	60, // 77: google.cloud.vmwareengine.v1.VmwareEngine.UpdateCluster:output_type -> google.longrunning.Operation
	60, // 78: google.cloud.vmwareengine.v1.VmwareEngine.DeleteCluster:output_type -> google.longrunning.Operation
	14, // 79: google.cloud.vmwareengine.v1.VmwareEngine.ListSubnets:output_type -> google.cloud.vmwareengine.v1.ListSubnetsResponse
	52, // 80: google.cloud.vmwareengine.v1.VmwareEngine.GetSubnet:output_type -> google.cloud.vmwareengine.v1.Subnet
	60, // 81: google.cloud.vmwareengine.v1.VmwareEngine.UpdateSubnet:output_type -> google.longrunning.Operation
	19, // 82: google.cloud.vmwareengine.v1.VmwareEngine.ListNodeTypes:output_type -> google.cloud.vmwareengine.v1.ListNodeTypesResponse
	54, // 83: google.cloud.vmwareengine.v1.VmwareEngine.GetNodeType:output_type -> google.cloud.vmwareengine.v1.NodeType
	61, // 84: google.cloud.vmwareengine.v1.VmwareEngine.ShowNsxCredentials:output_type -> google.cloud.vmwareengine.v1.Credentials
	61, // 85: google.cloud.vmwareengine.v1.VmwareEngine.ShowVcenterCredentials:output_type -> google.cloud.vmwareengine.v1.Credentials
	60, // 86: google.cloud.vmwareengine.v1.VmwareEngine.ResetNsxCredentials:output_type -> google.longrunning.Operation
	60, // 87: google.cloud.vmwareengine.v1.VmwareEngine.ResetVcenterCredentials:output_type -> google.longrunning.Operation
	60, // 88: google.cloud.vmwareengine.v1.VmwareEngine.CreateHcxActivationKey:output_type -> google.longrunning.Operation
	25, // 89: google.cloud.vmwareengine.v1.VmwareEngine.ListHcxActivationKeys:output_type -> google.cloud.vmwareengine.v1.ListHcxActivationKeysResponse
	55, // 90: google.cloud.vmwareengine.v1.VmwareEngine.GetHcxActivationKey:output_type -> google.cloud.vmwareengine.v1.HcxActivationKey
	56, // 91: google.cloud.vmwareengine.v1.VmwareEngine.GetNetworkPolicy:output_type -> google.cloud.vmwareengine.v1.NetworkPolicy
	30, // 92: google.cloud.vmwareengine.v1.VmwareEngine.ListNetworkPolicies:output_type -> google.cloud.vmwareengine.v1.ListNetworkPoliciesResponse
	60, // 93: google.cloud.vmwareengine.v1.VmwareEngine.CreateNetworkPolicy:output_type -> google.longrunning.Operation
	60, // 94: google.cloud.vmwareengine.v1.VmwareEngine.UpdateNetworkPolicy:output_type -> google.longrunning.Operation
	60, // 95: google.cloud.vmwareengine.v1.VmwareEngine.DeleteNetworkPolicy:output_type -> google.longrunning.Operation
	60, // 96: google.cloud.vmwareengine.v1.VmwareEngine.CreateVmwareEngineNetwork:output_type -> google.longrunning.Operation
	60, // 97: google.cloud.vmwareengine.v1.VmwareEngine.UpdateVmwareEngineNetwork:output_type -> google.longrunning.Operation
	60, // 98: google.cloud.vmwareengine.v1.VmwareEngine.DeleteVmwareEngineNetwork:output_type -> google.longrunning.Operation
	57, // 99: google.cloud.vmwareengine.v1.VmwareEngine.GetVmwareEngineNetwork:output_type -> google.cloud.vmwareengine.v1.VmwareEngineNetwork
	40, // 100: google.cloud.vmwareengine.v1.VmwareEngine.ListVmwareEngineNetworks:output_type -> google.cloud.vmwareengine.v1.ListVmwareEngineNetworksResponse
	60, // 101: google.cloud.vmwareengine.v1.VmwareEngine.CreatePrivateConnection:output_type -> google.longrunning.Operation
	58, // 102: google.cloud.vmwareengine.v1.VmwareEngine.GetPrivateConnection:output_type -> google.cloud.vmwareengine.v1.PrivateConnection
	44, // 103: google.cloud.vmwareengine.v1.VmwareEngine.ListPrivateConnections:output_type -> google.cloud.vmwareengine.v1.ListPrivateConnectionsResponse
	60, // 104: google.cloud.vmwareengine.v1.VmwareEngine.UpdatePrivateConnection:output_type -> google.longrunning.Operation
	60, // 105: google.cloud.vmwareengine.v1.VmwareEngine.DeletePrivateConnection:output_type -> google.longrunning.Operation
	48, // 106: google.cloud.vmwareengine.v1.VmwareEngine.ListPrivateConnectionPeeringRoutes:output_type -> google.cloud.vmwareengine.v1.ListPrivateConnectionPeeringRoutesResponse
	68, // [68:107] is the sub-list for method output_type
	29, // [29:68] is the sub-list for method input_type
	29, // [29:29] is the sub-list for extension type_name
	29, // [29:29] is the sub-list for extension extendee
	0,  // [0:29] is the sub-list for field type_name
}

func init() { file_google_cloud_vmwareengine_v1_vmwareengine_proto_init() }
func file_google_cloud_vmwareengine_v1_vmwareengine_proto_init() {
	if File_google_cloud_vmwareengine_v1_vmwareengine_proto != nil {
		return
	}
	file_google_cloud_vmwareengine_v1_vmwareengine_resources_proto_init()
	if !protoimpl.UnsafeEnabled {
		file_google_cloud_vmwareengine_v1_vmwareengine_proto_msgTypes[0].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*ListPrivateCloudsRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_vmwareengine_v1_vmwareengine_proto_msgTypes[1].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*ListPrivateCloudsResponse); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_vmwareengine_v1_vmwareengine_proto_msgTypes[2].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*GetPrivateCloudRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_vmwareengine_v1_vmwareengine_proto_msgTypes[3].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*CreatePrivateCloudRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_vmwareengine_v1_vmwareengine_proto_msgTypes[4].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*UpdatePrivateCloudRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_vmwareengine_v1_vmwareengine_proto_msgTypes[5].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*DeletePrivateCloudRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_vmwareengine_v1_vmwareengine_proto_msgTypes[6].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*UndeletePrivateCloudRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_vmwareengine_v1_vmwareengine_proto_msgTypes[7].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*ListClustersRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_vmwareengine_v1_vmwareengine_proto_msgTypes[8].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*ListClustersResponse); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_vmwareengine_v1_vmwareengine_proto_msgTypes[9].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*GetClusterRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_vmwareengine_v1_vmwareengine_proto_msgTypes[10].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*CreateClusterRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_vmwareengine_v1_vmwareengine_proto_msgTypes[11].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*UpdateClusterRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_vmwareengine_v1_vmwareengine_proto_msgTypes[12].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*DeleteClusterRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_vmwareengine_v1_vmwareengine_proto_msgTypes[13].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*ListSubnetsRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_vmwareengine_v1_vmwareengine_proto_msgTypes[14].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*ListSubnetsResponse); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_vmwareengine_v1_vmwareengine_proto_msgTypes[15].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*GetSubnetRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_vmwareengine_v1_vmwareengine_proto_msgTypes[16].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*UpdateSubnetRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_vmwareengine_v1_vmwareengine_proto_msgTypes[17].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*OperationMetadata); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_vmwareengine_v1_vmwareengine_proto_msgTypes[18].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*ListNodeTypesRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_vmwareengine_v1_vmwareengine_proto_msgTypes[19].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*ListNodeTypesResponse); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_vmwareengine_v1_vmwareengine_proto_msgTypes[20].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*GetNodeTypeRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_vmwareengine_v1_vmwareengine_proto_msgTypes[21].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*ShowNsxCredentialsRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_vmwareengine_v1_vmwareengine_proto_msgTypes[22].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*ShowVcenterCredentialsRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_vmwareengine_v1_vmwareengine_proto_msgTypes[23].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*ResetNsxCredentialsRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_vmwareengine_v1_vmwareengine_proto_msgTypes[24].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*ResetVcenterCredentialsRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_vmwareengine_v1_vmwareengine_proto_msgTypes[25].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*ListHcxActivationKeysResponse); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_vmwareengine_v1_vmwareengine_proto_msgTypes[26].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*ListHcxActivationKeysRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_vmwareengine_v1_vmwareengine_proto_msgTypes[27].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*GetHcxActivationKeyRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_vmwareengine_v1_vmwareengine_proto_msgTypes[28].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*CreateHcxActivationKeyRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_vmwareengine_v1_vmwareengine_proto_msgTypes[29].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*ListNetworkPoliciesRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_vmwareengine_v1_vmwareengine_proto_msgTypes[30].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*ListNetworkPoliciesResponse); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_vmwareengine_v1_vmwareengine_proto_msgTypes[31].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*GetNetworkPolicyRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_vmwareengine_v1_vmwareengine_proto_msgTypes[32].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*UpdateNetworkPolicyRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_vmwareengine_v1_vmwareengine_proto_msgTypes[33].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*CreateNetworkPolicyRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_vmwareengine_v1_vmwareengine_proto_msgTypes[34].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*DeleteNetworkPolicyRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_vmwareengine_v1_vmwareengine_proto_msgTypes[35].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*CreateVmwareEngineNetworkRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_vmwareengine_v1_vmwareengine_proto_msgTypes[36].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*UpdateVmwareEngineNetworkRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_vmwareengine_v1_vmwareengine_proto_msgTypes[37].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*DeleteVmwareEngineNetworkRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_vmwareengine_v1_vmwareengine_proto_msgTypes[38].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*GetVmwareEngineNetworkRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_vmwareengine_v1_vmwareengine_proto_msgTypes[39].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*ListVmwareEngineNetworksRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_vmwareengine_v1_vmwareengine_proto_msgTypes[40].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*ListVmwareEngineNetworksResponse); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_vmwareengine_v1_vmwareengine_proto_msgTypes[41].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*CreatePrivateConnectionRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_vmwareengine_v1_vmwareengine_proto_msgTypes[42].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*GetPrivateConnectionRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_vmwareengine_v1_vmwareengine_proto_msgTypes[43].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*ListPrivateConnectionsRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_vmwareengine_v1_vmwareengine_proto_msgTypes[44].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*ListPrivateConnectionsResponse); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_vmwareengine_v1_vmwareengine_proto_msgTypes[45].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*UpdatePrivateConnectionRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_vmwareengine_v1_vmwareengine_proto_msgTypes[46].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*DeletePrivateConnectionRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_vmwareengine_v1_vmwareengine_proto_msgTypes[47].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*ListPrivateConnectionPeeringRoutesRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_vmwareengine_v1_vmwareengine_proto_msgTypes[48].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*ListPrivateConnectionPeeringRoutesResponse); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
	}
	file_google_cloud_vmwareengine_v1_vmwareengine_proto_msgTypes[5].OneofWrappers = []interface{}{}
	type x struct{}
	out := protoimpl.TypeBuilder{
		File: protoimpl.DescBuilder{
			GoPackagePath: reflect.TypeOf(x{}).PkgPath(),
			RawDescriptor: file_google_cloud_vmwareengine_v1_vmwareengine_proto_rawDesc,
			NumEnums:      0,
			NumMessages:   49,
			NumExtensions: 0,
			NumServices:   1,
		},
		GoTypes:           file_google_cloud_vmwareengine_v1_vmwareengine_proto_goTypes,
		DependencyIndexes: file_google_cloud_vmwareengine_v1_vmwareengine_proto_depIdxs,
		MessageInfos:      file_google_cloud_vmwareengine_v1_vmwareengine_proto_msgTypes,
	}.Build()
	File_google_cloud_vmwareengine_v1_vmwareengine_proto = out.File
	file_google_cloud_vmwareengine_v1_vmwareengine_proto_rawDesc = nil
	file_google_cloud_vmwareengine_v1_vmwareengine_proto_goTypes = nil
	file_google_cloud_vmwareengine_v1_vmwareengine_proto_depIdxs = nil
}

// Reference imports to suppress errors if they are not otherwise used.
var _ context.Context
var _ grpc.ClientConnInterface

// This is a compile-time assertion to ensure that this generated file
// is compatible with the grpc package it is being compiled against.
const _ = grpc.SupportPackageIsVersion6

// VmwareEngineClient is the client API for VmwareEngine service.
//
// For semantics around ctx use and closing/ending streaming RPCs, please refer to https://godoc.org/google.golang.org/grpc#ClientConn.NewStream.
type VmwareEngineClient interface {
	// Lists `PrivateCloud` resources in a given project and location.
	ListPrivateClouds(ctx context.Context, in *ListPrivateCloudsRequest, opts ...grpc.CallOption) (*ListPrivateCloudsResponse, error)
	// Retrieves a `PrivateCloud` resource by its resource name.
	GetPrivateCloud(ctx context.Context, in *GetPrivateCloudRequest, opts ...grpc.CallOption) (*PrivateCloud, error)
	// Creates a new `PrivateCloud` resource in a given project and location.
	// Private clouds can only be created in zones, regional private clouds are
	// not supported.
	//
	// Creating a private cloud also creates a [management
	// cluster](https://cloud.google.com/vmware-engine/docs/concepts-vmware-components)
	// for that private cloud.
	CreatePrivateCloud(ctx context.Context, in *CreatePrivateCloudRequest, opts ...grpc.CallOption) (*longrunningpb.Operation, error)
	// Modifies a `PrivateCloud` resource. Only the following fields can be
	// updated: `description`.
	// Only fields specified in `updateMask` are applied.
	//
	// During operation processing, the resource is temporarily in the `ACTIVE`
	// state before the operation fully completes. For that period of time, you
	// can't update the resource. Use the operation status to determine when the
	// processing fully completes.
	UpdatePrivateCloud(ctx context.Context, in *UpdatePrivateCloudRequest, opts ...grpc.CallOption) (*longrunningpb.Operation, error)
	// Schedules a `PrivateCloud` resource for deletion.
	//
	// A `PrivateCloud` resource scheduled for deletion has `PrivateCloud.state`
	// set to `DELETED` and `expireTime` set to the time when deletion is final
	// and can no longer be reversed. The delete operation is marked as done
	// as soon as the `PrivateCloud` is successfully scheduled for deletion
	// (this also applies when `delayHours` is set to zero), and the operation is
	// not kept in pending state until `PrivateCloud` is purged.
	// `PrivateCloud` can be restored using `UndeletePrivateCloud` method before
	// the `expireTime` elapses. When `expireTime` is reached, deletion is final
	// and all private cloud resources are irreversibly removed and billing stops.
	// During the final removal process, `PrivateCloud.state` is set to `PURGING`.
	// `PrivateCloud` can be polled using standard `GET` method for the whole
	// period of deletion and purging. It will not be returned only
	// when it is completely purged.
	DeletePrivateCloud(ctx context.Context, in *DeletePrivateCloudRequest, opts ...grpc.CallOption) (*longrunningpb.Operation, error)
	// Restores a private cloud that was previously scheduled for deletion by
	// `DeletePrivateCloud`. A `PrivateCloud` resource scheduled for deletion has
	// `PrivateCloud.state` set to `DELETED` and `PrivateCloud.expireTime` set to
	// the time when deletion can no longer be reversed.
	UndeletePrivateCloud(ctx context.Context, in *UndeletePrivateCloudRequest, opts ...grpc.CallOption) (*longrunningpb.Operation, error)
	// Lists `Cluster` resources in a given private cloud.
	ListClusters(ctx context.Context, in *ListClustersRequest, opts ...grpc.CallOption) (*ListClustersResponse, error)
	// Retrieves a `Cluster` resource by its resource name.
	GetCluster(ctx context.Context, in *GetClusterRequest, opts ...grpc.CallOption) (*Cluster, error)
	// Creates a new cluster in a given private cloud.
	// Creating a new cluster provides additional nodes for
	// use in the parent private cloud and requires sufficient [node
	// quota](https://cloud.google.com/vmware-engine/quotas).
	CreateCluster(ctx context.Context, in *CreateClusterRequest, opts ...grpc.CallOption) (*longrunningpb.Operation, error)
	// Modifies a `Cluster` resource. Only the following fields can be updated:
	// `node_type_configs.*.node_count`. Only fields specified in `updateMask` are
	// applied.
	//
	// During operation processing, the resource is temporarily in the `ACTIVE`
	// state before the operation fully completes. For that period of time, you
	// can't update the resource. Use the operation status to determine when the
	// processing fully completes.
	UpdateCluster(ctx context.Context, in *UpdateClusterRequest, opts ...grpc.CallOption) (*longrunningpb.Operation, error)
	// Deletes a `Cluster` resource. To avoid unintended data loss, migrate or
	// gracefully shut down any workloads running on the cluster before deletion.
	// You cannot delete the management cluster of a private cloud using this
	// method.
	DeleteCluster(ctx context.Context, in *DeleteClusterRequest, opts ...grpc.CallOption) (*longrunningpb.Operation, error)
	// Lists subnets in a given private cloud.
	ListSubnets(ctx context.Context, in *ListSubnetsRequest, opts ...grpc.CallOption) (*ListSubnetsResponse, error)
	// Gets details of a single subnet.
	GetSubnet(ctx context.Context, in *GetSubnetRequest, opts ...grpc.CallOption) (*Subnet, error)
	// Updates the parameters of a single subnet. Only fields specified in
	// `update_mask` are applied.
	//
	// *Note*: This API is synchronous and always returns a successful
	// `google.longrunning.Operation` (LRO). The returned LRO will only have
	// `done` and `response` fields.
	UpdateSubnet(ctx context.Context, in *UpdateSubnetRequest, opts ...grpc.CallOption) (*longrunningpb.Operation, error)
	// Lists node types
	ListNodeTypes(ctx context.Context, in *ListNodeTypesRequest, opts ...grpc.CallOption) (*ListNodeTypesResponse, error)
	// Gets details of a single `NodeType`.
	GetNodeType(ctx context.Context, in *GetNodeTypeRequest, opts ...grpc.CallOption) (*NodeType, error)
	// Gets details of credentials for NSX appliance.
	ShowNsxCredentials(ctx context.Context, in *ShowNsxCredentialsRequest, opts ...grpc.CallOption) (*Credentials, error)
	// Gets details of credentials for Vcenter appliance.
	ShowVcenterCredentials(ctx context.Context, in *ShowVcenterCredentialsRequest, opts ...grpc.CallOption) (*Credentials, error)
	// Resets credentials of the NSX appliance.
	ResetNsxCredentials(ctx context.Context, in *ResetNsxCredentialsRequest, opts ...grpc.CallOption) (*longrunningpb.Operation, error)
	// Resets credentials of the Vcenter appliance.
	ResetVcenterCredentials(ctx context.Context, in *ResetVcenterCredentialsRequest, opts ...grpc.CallOption) (*longrunningpb.Operation, error)
	// Creates a new HCX activation key in a given private cloud.
	CreateHcxActivationKey(ctx context.Context, in *CreateHcxActivationKeyRequest, opts ...grpc.CallOption) (*longrunningpb.Operation, error)
	// Lists `HcxActivationKey` resources in a given private cloud.
	ListHcxActivationKeys(ctx context.Context, in *ListHcxActivationKeysRequest, opts ...grpc.CallOption) (*ListHcxActivationKeysResponse, error)
	// Retrieves a `HcxActivationKey` resource by its resource name.
	GetHcxActivationKey(ctx context.Context, in *GetHcxActivationKeyRequest, opts ...grpc.CallOption) (*HcxActivationKey, error)
	// Retrieves a `NetworkPolicy` resource by its resource name.
	GetNetworkPolicy(ctx context.Context, in *GetNetworkPolicyRequest, opts ...grpc.CallOption) (*NetworkPolicy, error)
	// Lists `NetworkPolicy` resources in a specified project and location.
	ListNetworkPolicies(ctx context.Context, in *ListNetworkPoliciesRequest, opts ...grpc.CallOption) (*ListNetworkPoliciesResponse, error)
	// Creates a new network policy in a given VMware Engine network of a
	// project and location (region). A new network policy cannot be created if
	// another network policy already exists in the same scope.
	CreateNetworkPolicy(ctx context.Context, in *CreateNetworkPolicyRequest, opts ...grpc.CallOption) (*longrunningpb.Operation, error)
	// Modifies a `NetworkPolicy` resource. Only the following fields can be
	// updated: `internet_access`, `external_ip`, `edge_services_cidr`.
	// Only fields specified in `updateMask` are applied. When updating a network
	// policy, the external IP network service can only be disabled if there are
	// no external IP addresses present in the scope of the policy. Also, a
	// `NetworkService` cannot be updated when `NetworkService.state` is set
	// to `RECONCILING`.
	//
	// During operation processing, the resource is temporarily in the `ACTIVE`
	// state before the operation fully completes. For that period of time, you
	// can't update the resource. Use the operation status to determine when the
	// processing fully completes.
	UpdateNetworkPolicy(ctx context.Context, in *UpdateNetworkPolicyRequest, opts ...grpc.CallOption) (*longrunningpb.Operation, error)
	// Deletes a `NetworkPolicy` resource. A network policy cannot be deleted
	// when `NetworkService.state` is set to `RECONCILING` for either its external
	// IP or internet access service.
	DeleteNetworkPolicy(ctx context.Context, in *DeleteNetworkPolicyRequest, opts ...grpc.CallOption) (*longrunningpb.Operation, error)
	// Creates a new VMware Engine network that can be used by a private cloud.
	CreateVmwareEngineNetwork(ctx context.Context, in *CreateVmwareEngineNetworkRequest, opts ...grpc.CallOption) (*longrunningpb.Operation, error)
	// Modifies a VMware Engine network resource. Only the following fields can be
	// updated: `description`. Only fields specified in `updateMask` are
	// applied.
	UpdateVmwareEngineNetwork(ctx context.Context, in *UpdateVmwareEngineNetworkRequest, opts ...grpc.CallOption) (*longrunningpb.Operation, error)
	// Deletes a `VmwareEngineNetwork` resource. You can only delete a VMware
	// Engine network after all resources that refer to it are deleted. For
	// example, a private cloud, a network peering, and a network policy can all
	// refer to the same VMware Engine network.
	DeleteVmwareEngineNetwork(ctx context.Context, in *DeleteVmwareEngineNetworkRequest, opts ...grpc.CallOption) (*longrunningpb.Operation, error)
	// Retrieves a `VmwareEngineNetwork` resource by its resource name. The
	// resource contains details of the VMware Engine network, such as its VMware
	// Engine network type, peered networks in a service project, and state
	// (for example, `CREATING`, `ACTIVE`, `DELETING`).
	GetVmwareEngineNetwork(ctx context.Context, in *GetVmwareEngineNetworkRequest, opts ...grpc.CallOption) (*VmwareEngineNetwork, error)
	// Lists `VmwareEngineNetwork` resources in a given project and location.
	ListVmwareEngineNetworks(ctx context.Context, in *ListVmwareEngineNetworksRequest, opts ...grpc.CallOption) (*ListVmwareEngineNetworksResponse, error)
	// Creates a new private connection that can be used for accessing private
	// Clouds.
	CreatePrivateConnection(ctx context.Context, in *CreatePrivateConnectionRequest, opts ...grpc.CallOption) (*longrunningpb.Operation, error)
	// Retrieves a `PrivateConnection` resource by its resource name. The resource
	// contains details of the private connection, such as connected
	// network, routing mode and state.
	GetPrivateConnection(ctx context.Context, in *GetPrivateConnectionRequest, opts ...grpc.CallOption) (*PrivateConnection, error)
	// Lists `PrivateConnection` resources in a given project and location.
	ListPrivateConnections(ctx context.Context, in *ListPrivateConnectionsRequest, opts ...grpc.CallOption) (*ListPrivateConnectionsResponse, error)
	// Modifies a `PrivateConnection` resource. Only `description` and
	// `routing_mode` fields can be updated. Only fields specified in `updateMask`
	// are applied.
	UpdatePrivateConnection(ctx context.Context, in *UpdatePrivateConnectionRequest, opts ...grpc.CallOption) (*longrunningpb.Operation, error)
	// Deletes a `PrivateConnection` resource. When a private connection is
	// deleted for a VMware Engine network, the connected network becomes
	// inaccessible to that VMware Engine network.
	DeletePrivateConnection(ctx context.Context, in *DeletePrivateConnectionRequest, opts ...grpc.CallOption) (*longrunningpb.Operation, error)
	// Lists the private connection routes exchanged over a peering connection.
	ListPrivateConnectionPeeringRoutes(ctx context.Context, in *ListPrivateConnectionPeeringRoutesRequest, opts ...grpc.CallOption) (*ListPrivateConnectionPeeringRoutesResponse, error)
}

type vmwareEngineClient struct {
	cc grpc.ClientConnInterface
}

func NewVmwareEngineClient(cc grpc.ClientConnInterface) VmwareEngineClient {
	return &vmwareEngineClient{cc}
}

func (c *vmwareEngineClient) ListPrivateClouds(ctx context.Context, in *ListPrivateCloudsRequest, opts ...grpc.CallOption) (*ListPrivateCloudsResponse, error) {
	out := new(ListPrivateCloudsResponse)
	err := c.cc.Invoke(ctx, "/google.cloud.vmwareengine.v1.VmwareEngine/ListPrivateClouds", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *vmwareEngineClient) GetPrivateCloud(ctx context.Context, in *GetPrivateCloudRequest, opts ...grpc.CallOption) (*PrivateCloud, error) {
	out := new(PrivateCloud)
	err := c.cc.Invoke(ctx, "/google.cloud.vmwareengine.v1.VmwareEngine/GetPrivateCloud", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *vmwareEngineClient) CreatePrivateCloud(ctx context.Context, in *CreatePrivateCloudRequest, opts ...grpc.CallOption) (*longrunningpb.Operation, error) {
	out := new(longrunningpb.Operation)
	err := c.cc.Invoke(ctx, "/google.cloud.vmwareengine.v1.VmwareEngine/CreatePrivateCloud", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *vmwareEngineClient) UpdatePrivateCloud(ctx context.Context, in *UpdatePrivateCloudRequest, opts ...grpc.CallOption) (*longrunningpb.Operation, error) {
	out := new(longrunningpb.Operation)
	err := c.cc.Invoke(ctx, "/google.cloud.vmwareengine.v1.VmwareEngine/UpdatePrivateCloud", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *vmwareEngineClient) DeletePrivateCloud(ctx context.Context, in *DeletePrivateCloudRequest, opts ...grpc.CallOption) (*longrunningpb.Operation, error) {
	out := new(longrunningpb.Operation)
	err := c.cc.Invoke(ctx, "/google.cloud.vmwareengine.v1.VmwareEngine/DeletePrivateCloud", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *vmwareEngineClient) UndeletePrivateCloud(ctx context.Context, in *UndeletePrivateCloudRequest, opts ...grpc.CallOption) (*longrunningpb.Operation, error) {
	out := new(longrunningpb.Operation)
	err := c.cc.Invoke(ctx, "/google.cloud.vmwareengine.v1.VmwareEngine/UndeletePrivateCloud", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *vmwareEngineClient) ListClusters(ctx context.Context, in *ListClustersRequest, opts ...grpc.CallOption) (*ListClustersResponse, error) {
	out := new(ListClustersResponse)
	err := c.cc.Invoke(ctx, "/google.cloud.vmwareengine.v1.VmwareEngine/ListClusters", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *vmwareEngineClient) GetCluster(ctx context.Context, in *GetClusterRequest, opts ...grpc.CallOption) (*Cluster, error) {
	out := new(Cluster)
	err := c.cc.Invoke(ctx, "/google.cloud.vmwareengine.v1.VmwareEngine/GetCluster", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *vmwareEngineClient) CreateCluster(ctx context.Context, in *CreateClusterRequest, opts ...grpc.CallOption) (*longrunningpb.Operation, error) {
	out := new(longrunningpb.Operation)
	err := c.cc.Invoke(ctx, "/google.cloud.vmwareengine.v1.VmwareEngine/CreateCluster", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *vmwareEngineClient) UpdateCluster(ctx context.Context, in *UpdateClusterRequest, opts ...grpc.CallOption) (*longrunningpb.Operation, error) {
	out := new(longrunningpb.Operation)
	err := c.cc.Invoke(ctx, "/google.cloud.vmwareengine.v1.VmwareEngine/UpdateCluster", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *vmwareEngineClient) DeleteCluster(ctx context.Context, in *DeleteClusterRequest, opts ...grpc.CallOption) (*longrunningpb.Operation, error) {
	out := new(longrunningpb.Operation)
	err := c.cc.Invoke(ctx, "/google.cloud.vmwareengine.v1.VmwareEngine/DeleteCluster", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *vmwareEngineClient) ListSubnets(ctx context.Context, in *ListSubnetsRequest, opts ...grpc.CallOption) (*ListSubnetsResponse, error) {
	out := new(ListSubnetsResponse)
	err := c.cc.Invoke(ctx, "/google.cloud.vmwareengine.v1.VmwareEngine/ListSubnets", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *vmwareEngineClient) GetSubnet(ctx context.Context, in *GetSubnetRequest, opts ...grpc.CallOption) (*Subnet, error) {
	out := new(Subnet)
	err := c.cc.Invoke(ctx, "/google.cloud.vmwareengine.v1.VmwareEngine/GetSubnet", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *vmwareEngineClient) UpdateSubnet(ctx context.Context, in *UpdateSubnetRequest, opts ...grpc.CallOption) (*longrunningpb.Operation, error) {
	out := new(longrunningpb.Operation)
	err := c.cc.Invoke(ctx, "/google.cloud.vmwareengine.v1.VmwareEngine/UpdateSubnet", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *vmwareEngineClient) ListNodeTypes(ctx context.Context, in *ListNodeTypesRequest, opts ...grpc.CallOption) (*ListNodeTypesResponse, error) {
	out := new(ListNodeTypesResponse)
	err := c.cc.Invoke(ctx, "/google.cloud.vmwareengine.v1.VmwareEngine/ListNodeTypes", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *vmwareEngineClient) GetNodeType(ctx context.Context, in *GetNodeTypeRequest, opts ...grpc.CallOption) (*NodeType, error) {
	out := new(NodeType)
	err := c.cc.Invoke(ctx, "/google.cloud.vmwareengine.v1.VmwareEngine/GetNodeType", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *vmwareEngineClient) ShowNsxCredentials(ctx context.Context, in *ShowNsxCredentialsRequest, opts ...grpc.CallOption) (*Credentials, error) {
	out := new(Credentials)
	err := c.cc.Invoke(ctx, "/google.cloud.vmwareengine.v1.VmwareEngine/ShowNsxCredentials", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *vmwareEngineClient) ShowVcenterCredentials(ctx context.Context, in *ShowVcenterCredentialsRequest, opts ...grpc.CallOption) (*Credentials, error) {
	out := new(Credentials)
	err := c.cc.Invoke(ctx, "/google.cloud.vmwareengine.v1.VmwareEngine/ShowVcenterCredentials", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *vmwareEngineClient) ResetNsxCredentials(ctx context.Context, in *ResetNsxCredentialsRequest, opts ...grpc.CallOption) (*longrunningpb.Operation, error) {
	out := new(longrunningpb.Operation)
	err := c.cc.Invoke(ctx, "/google.cloud.vmwareengine.v1.VmwareEngine/ResetNsxCredentials", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *vmwareEngineClient) ResetVcenterCredentials(ctx context.Context, in *ResetVcenterCredentialsRequest, opts ...grpc.CallOption) (*longrunningpb.Operation, error) {
	out := new(longrunningpb.Operation)
	err := c.cc.Invoke(ctx, "/google.cloud.vmwareengine.v1.VmwareEngine/ResetVcenterCredentials", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *vmwareEngineClient) CreateHcxActivationKey(ctx context.Context, in *CreateHcxActivationKeyRequest, opts ...grpc.CallOption) (*longrunningpb.Operation, error) {
	out := new(longrunningpb.Operation)
	err := c.cc.Invoke(ctx, "/google.cloud.vmwareengine.v1.VmwareEngine/CreateHcxActivationKey", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *vmwareEngineClient) ListHcxActivationKeys(ctx context.Context, in *ListHcxActivationKeysRequest, opts ...grpc.CallOption) (*ListHcxActivationKeysResponse, error) {
	out := new(ListHcxActivationKeysResponse)
	err := c.cc.Invoke(ctx, "/google.cloud.vmwareengine.v1.VmwareEngine/ListHcxActivationKeys", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *vmwareEngineClient) GetHcxActivationKey(ctx context.Context, in *GetHcxActivationKeyRequest, opts ...grpc.CallOption) (*HcxActivationKey, error) {
	out := new(HcxActivationKey)
	err := c.cc.Invoke(ctx, "/google.cloud.vmwareengine.v1.VmwareEngine/GetHcxActivationKey", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *vmwareEngineClient) GetNetworkPolicy(ctx context.Context, in *GetNetworkPolicyRequest, opts ...grpc.CallOption) (*NetworkPolicy, error) {
	out := new(NetworkPolicy)
	err := c.cc.Invoke(ctx, "/google.cloud.vmwareengine.v1.VmwareEngine/GetNetworkPolicy", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *vmwareEngineClient) ListNetworkPolicies(ctx context.Context, in *ListNetworkPoliciesRequest, opts ...grpc.CallOption) (*ListNetworkPoliciesResponse, error) {
	out := new(ListNetworkPoliciesResponse)
	err := c.cc.Invoke(ctx, "/google.cloud.vmwareengine.v1.VmwareEngine/ListNetworkPolicies", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *vmwareEngineClient) CreateNetworkPolicy(ctx context.Context, in *CreateNetworkPolicyRequest, opts ...grpc.CallOption) (*longrunningpb.Operation, error) {
	out := new(longrunningpb.Operation)
	err := c.cc.Invoke(ctx, "/google.cloud.vmwareengine.v1.VmwareEngine/CreateNetworkPolicy", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *vmwareEngineClient) UpdateNetworkPolicy(ctx context.Context, in *UpdateNetworkPolicyRequest, opts ...grpc.CallOption) (*longrunningpb.Operation, error) {
	out := new(longrunningpb.Operation)
	err := c.cc.Invoke(ctx, "/google.cloud.vmwareengine.v1.VmwareEngine/UpdateNetworkPolicy", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *vmwareEngineClient) DeleteNetworkPolicy(ctx context.Context, in *DeleteNetworkPolicyRequest, opts ...grpc.CallOption) (*longrunningpb.Operation, error) {
	out := new(longrunningpb.Operation)
	err := c.cc.Invoke(ctx, "/google.cloud.vmwareengine.v1.VmwareEngine/DeleteNetworkPolicy", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *vmwareEngineClient) CreateVmwareEngineNetwork(ctx context.Context, in *CreateVmwareEngineNetworkRequest, opts ...grpc.CallOption) (*longrunningpb.Operation, error) {
	out := new(longrunningpb.Operation)
	err := c.cc.Invoke(ctx, "/google.cloud.vmwareengine.v1.VmwareEngine/CreateVmwareEngineNetwork", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *vmwareEngineClient) UpdateVmwareEngineNetwork(ctx context.Context, in *UpdateVmwareEngineNetworkRequest, opts ...grpc.CallOption) (*longrunningpb.Operation, error) {
	out := new(longrunningpb.Operation)
	err := c.cc.Invoke(ctx, "/google.cloud.vmwareengine.v1.VmwareEngine/UpdateVmwareEngineNetwork", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *vmwareEngineClient) DeleteVmwareEngineNetwork(ctx context.Context, in *DeleteVmwareEngineNetworkRequest, opts ...grpc.CallOption) (*longrunningpb.Operation, error) {
	out := new(longrunningpb.Operation)
	err := c.cc.Invoke(ctx, "/google.cloud.vmwareengine.v1.VmwareEngine/DeleteVmwareEngineNetwork", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *vmwareEngineClient) GetVmwareEngineNetwork(ctx context.Context, in *GetVmwareEngineNetworkRequest, opts ...grpc.CallOption) (*VmwareEngineNetwork, error) {
	out := new(VmwareEngineNetwork)
	err := c.cc.Invoke(ctx, "/google.cloud.vmwareengine.v1.VmwareEngine/GetVmwareEngineNetwork", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *vmwareEngineClient) ListVmwareEngineNetworks(ctx context.Context, in *ListVmwareEngineNetworksRequest, opts ...grpc.CallOption) (*ListVmwareEngineNetworksResponse, error) {
	out := new(ListVmwareEngineNetworksResponse)
	err := c.cc.Invoke(ctx, "/google.cloud.vmwareengine.v1.VmwareEngine/ListVmwareEngineNetworks", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *vmwareEngineClient) CreatePrivateConnection(ctx context.Context, in *CreatePrivateConnectionRequest, opts ...grpc.CallOption) (*longrunningpb.Operation, error) {
	out := new(longrunningpb.Operation)
	err := c.cc.Invoke(ctx, "/google.cloud.vmwareengine.v1.VmwareEngine/CreatePrivateConnection", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *vmwareEngineClient) GetPrivateConnection(ctx context.Context, in *GetPrivateConnectionRequest, opts ...grpc.CallOption) (*PrivateConnection, error) {
	out := new(PrivateConnection)
	err := c.cc.Invoke(ctx, "/google.cloud.vmwareengine.v1.VmwareEngine/GetPrivateConnection", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *vmwareEngineClient) ListPrivateConnections(ctx context.Context, in *ListPrivateConnectionsRequest, opts ...grpc.CallOption) (*ListPrivateConnectionsResponse, error) {
	out := new(ListPrivateConnectionsResponse)
	err := c.cc.Invoke(ctx, "/google.cloud.vmwareengine.v1.VmwareEngine/ListPrivateConnections", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *vmwareEngineClient) UpdatePrivateConnection(ctx context.Context, in *UpdatePrivateConnectionRequest, opts ...grpc.CallOption) (*longrunningpb.Operation, error) {
	out := new(longrunningpb.Operation)
	err := c.cc.Invoke(ctx, "/google.cloud.vmwareengine.v1.VmwareEngine/UpdatePrivateConnection", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *vmwareEngineClient) DeletePrivateConnection(ctx context.Context, in *DeletePrivateConnectionRequest, opts ...grpc.CallOption) (*longrunningpb.Operation, error) {
	out := new(longrunningpb.Operation)
	err := c.cc.Invoke(ctx, "/google.cloud.vmwareengine.v1.VmwareEngine/DeletePrivateConnection", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *vmwareEngineClient) ListPrivateConnectionPeeringRoutes(ctx context.Context, in *ListPrivateConnectionPeeringRoutesRequest, opts ...grpc.CallOption) (*ListPrivateConnectionPeeringRoutesResponse, error) {
	out := new(ListPrivateConnectionPeeringRoutesResponse)
	err := c.cc.Invoke(ctx, "/google.cloud.vmwareengine.v1.VmwareEngine/ListPrivateConnectionPeeringRoutes", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

// VmwareEngineServer is the server API for VmwareEngine service.
type VmwareEngineServer interface {
	// Lists `PrivateCloud` resources in a given project and location.
	ListPrivateClouds(context.Context, *ListPrivateCloudsRequest) (*ListPrivateCloudsResponse, error)
	// Retrieves a `PrivateCloud` resource by its resource name.
	GetPrivateCloud(context.Context, *GetPrivateCloudRequest) (*PrivateCloud, error)
	// Creates a new `PrivateCloud` resource in a given project and location.
	// Private clouds can only be created in zones, regional private clouds are
	// not supported.
	//
	// Creating a private cloud also creates a [management
	// cluster](https://cloud.google.com/vmware-engine/docs/concepts-vmware-components)
	// for that private cloud.
	CreatePrivateCloud(context.Context, *CreatePrivateCloudRequest) (*longrunningpb.Operation, error)
	// Modifies a `PrivateCloud` resource. Only the following fields can be
	// updated: `description`.
	// Only fields specified in `updateMask` are applied.
	//
	// During operation processing, the resource is temporarily in the `ACTIVE`
	// state before the operation fully completes. For that period of time, you
	// can't update the resource. Use the operation status to determine when the
	// processing fully completes.
	UpdatePrivateCloud(context.Context, *UpdatePrivateCloudRequest) (*longrunningpb.Operation, error)
	// Schedules a `PrivateCloud` resource for deletion.
	//
	// A `PrivateCloud` resource scheduled for deletion has `PrivateCloud.state`
	// set to `DELETED` and `expireTime` set to the time when deletion is final
	// and can no longer be reversed. The delete operation is marked as done
	// as soon as the `PrivateCloud` is successfully scheduled for deletion
	// (this also applies when `delayHours` is set to zero), and the operation is
	// not kept in pending state until `PrivateCloud` is purged.
	// `PrivateCloud` can be restored using `UndeletePrivateCloud` method before
	// the `expireTime` elapses. When `expireTime` is reached, deletion is final
	// and all private cloud resources are irreversibly removed and billing stops.
	// During the final removal process, `PrivateCloud.state` is set to `PURGING`.
	// `PrivateCloud` can be polled using standard `GET` method for the whole
	// period of deletion and purging. It will not be returned only
	// when it is completely purged.
	DeletePrivateCloud(context.Context, *DeletePrivateCloudRequest) (*longrunningpb.Operation, error)
	// Restores a private cloud that was previously scheduled for deletion by
	// `DeletePrivateCloud`. A `PrivateCloud` resource scheduled for deletion has
	// `PrivateCloud.state` set to `DELETED` and `PrivateCloud.expireTime` set to
	// the time when deletion can no longer be reversed.
	UndeletePrivateCloud(context.Context, *UndeletePrivateCloudRequest) (*longrunningpb.Operation, error)
	// Lists `Cluster` resources in a given private cloud.
	ListClusters(context.Context, *ListClustersRequest) (*ListClustersResponse, error)
	// Retrieves a `Cluster` resource by its resource name.
	GetCluster(context.Context, *GetClusterRequest) (*Cluster, error)
	// Creates a new cluster in a given private cloud.
	// Creating a new cluster provides additional nodes for
	// use in the parent private cloud and requires sufficient [node
	// quota](https://cloud.google.com/vmware-engine/quotas).
	CreateCluster(context.Context, *CreateClusterRequest) (*longrunningpb.Operation, error)
	// Modifies a `Cluster` resource. Only the following fields can be updated:
	// `node_type_configs.*.node_count`. Only fields specified in `updateMask` are
	// applied.
	//
	// During operation processing, the resource is temporarily in the `ACTIVE`
	// state before the operation fully completes. For that period of time, you
	// can't update the resource. Use the operation status to determine when the
	// processing fully completes.
	UpdateCluster(context.Context, *UpdateClusterRequest) (*longrunningpb.Operation, error)
	// Deletes a `Cluster` resource. To avoid unintended data loss, migrate or
	// gracefully shut down any workloads running on the cluster before deletion.
	// You cannot delete the management cluster of a private cloud using this
	// method.
	DeleteCluster(context.Context, *DeleteClusterRequest) (*longrunningpb.Operation, error)
	// Lists subnets in a given private cloud.
	ListSubnets(context.Context, *ListSubnetsRequest) (*ListSubnetsResponse, error)
	// Gets details of a single subnet.
	GetSubnet(context.Context, *GetSubnetRequest) (*Subnet, error)
	// Updates the parameters of a single subnet. Only fields specified in
	// `update_mask` are applied.
	//
	// *Note*: This API is synchronous and always returns a successful
	// `google.longrunning.Operation` (LRO). The returned LRO will only have
	// `done` and `response` fields.
	UpdateSubnet(context.Context, *UpdateSubnetRequest) (*longrunningpb.Operation, error)
	// Lists node types
	ListNodeTypes(context.Context, *ListNodeTypesRequest) (*ListNodeTypesResponse, error)
	// Gets details of a single `NodeType`.
	GetNodeType(context.Context, *GetNodeTypeRequest) (*NodeType, error)
	// Gets details of credentials for NSX appliance.
	ShowNsxCredentials(context.Context, *ShowNsxCredentialsRequest) (*Credentials, error)
	// Gets details of credentials for Vcenter appliance.
	ShowVcenterCredentials(context.Context, *ShowVcenterCredentialsRequest) (*Credentials, error)
	// Resets credentials of the NSX appliance.
	ResetNsxCredentials(context.Context, *ResetNsxCredentialsRequest) (*longrunningpb.Operation, error)
	// Resets credentials of the Vcenter appliance.
	ResetVcenterCredentials(context.Context, *ResetVcenterCredentialsRequest) (*longrunningpb.Operation, error)
	// Creates a new HCX activation key in a given private cloud.
	CreateHcxActivationKey(context.Context, *CreateHcxActivationKeyRequest) (*longrunningpb.Operation, error)
	// Lists `HcxActivationKey` resources in a given private cloud.
	ListHcxActivationKeys(context.Context, *ListHcxActivationKeysRequest) (*ListHcxActivationKeysResponse, error)
	// Retrieves a `HcxActivationKey` resource by its resource name.
	GetHcxActivationKey(context.Context, *GetHcxActivationKeyRequest) (*HcxActivationKey, error)
	// Retrieves a `NetworkPolicy` resource by its resource name.
	GetNetworkPolicy(context.Context, *GetNetworkPolicyRequest) (*NetworkPolicy, error)
	// Lists `NetworkPolicy` resources in a specified project and location.
	ListNetworkPolicies(context.Context, *ListNetworkPoliciesRequest) (*ListNetworkPoliciesResponse, error)
	// Creates a new network policy in a given VMware Engine network of a
	// project and location (region). A new network policy cannot be created if
	// another network policy already exists in the same scope.
	CreateNetworkPolicy(context.Context, *CreateNetworkPolicyRequest) (*longrunningpb.Operation, error)
	// Modifies a `NetworkPolicy` resource. Only the following fields can be
	// updated: `internet_access`, `external_ip`, `edge_services_cidr`.
	// Only fields specified in `updateMask` are applied. When updating a network
	// policy, the external IP network service can only be disabled if there are
	// no external IP addresses present in the scope of the policy. Also, a
	// `NetworkService` cannot be updated when `NetworkService.state` is set
	// to `RECONCILING`.
	//
	// During operation processing, the resource is temporarily in the `ACTIVE`
	// state before the operation fully completes. For that period of time, you
	// can't update the resource. Use the operation status to determine when the
	// processing fully completes.
	UpdateNetworkPolicy(context.Context, *UpdateNetworkPolicyRequest) (*longrunningpb.Operation, error)
	// Deletes a `NetworkPolicy` resource. A network policy cannot be deleted
	// when `NetworkService.state` is set to `RECONCILING` for either its external
	// IP or internet access service.
	DeleteNetworkPolicy(context.Context, *DeleteNetworkPolicyRequest) (*longrunningpb.Operation, error)
	// Creates a new VMware Engine network that can be used by a private cloud.
	CreateVmwareEngineNetwork(context.Context, *CreateVmwareEngineNetworkRequest) (*longrunningpb.Operation, error)
	// Modifies a VMware Engine network resource. Only the following fields can be
	// updated: `description`. Only fields specified in `updateMask` are
	// applied.
	UpdateVmwareEngineNetwork(context.Context, *UpdateVmwareEngineNetworkRequest) (*longrunningpb.Operation, error)
	// Deletes a `VmwareEngineNetwork` resource. You can only delete a VMware
	// Engine network after all resources that refer to it are deleted. For
	// example, a private cloud, a network peering, and a network policy can all
	// refer to the same VMware Engine network.
	DeleteVmwareEngineNetwork(context.Context, *DeleteVmwareEngineNetworkRequest) (*longrunningpb.Operation, error)
	// Retrieves a `VmwareEngineNetwork` resource by its resource name. The
	// resource contains details of the VMware Engine network, such as its VMware
	// Engine network type, peered networks in a service project, and state
	// (for example, `CREATING`, `ACTIVE`, `DELETING`).
	GetVmwareEngineNetwork(context.Context, *GetVmwareEngineNetworkRequest) (*VmwareEngineNetwork, error)
	// Lists `VmwareEngineNetwork` resources in a given project and location.
	ListVmwareEngineNetworks(context.Context, *ListVmwareEngineNetworksRequest) (*ListVmwareEngineNetworksResponse, error)
	// Creates a new private connection that can be used for accessing private
	// Clouds.
	CreatePrivateConnection(context.Context, *CreatePrivateConnectionRequest) (*longrunningpb.Operation, error)
	// Retrieves a `PrivateConnection` resource by its resource name. The resource
	// contains details of the private connection, such as connected
	// network, routing mode and state.
	GetPrivateConnection(context.Context, *GetPrivateConnectionRequest) (*PrivateConnection, error)
	// Lists `PrivateConnection` resources in a given project and location.
	ListPrivateConnections(context.Context, *ListPrivateConnectionsRequest) (*ListPrivateConnectionsResponse, error)
	// Modifies a `PrivateConnection` resource. Only `description` and
	// `routing_mode` fields can be updated. Only fields specified in `updateMask`
	// are applied.
	UpdatePrivateConnection(context.Context, *UpdatePrivateConnectionRequest) (*longrunningpb.Operation, error)
	// Deletes a `PrivateConnection` resource. When a private connection is
	// deleted for a VMware Engine network, the connected network becomes
	// inaccessible to that VMware Engine network.
	DeletePrivateConnection(context.Context, *DeletePrivateConnectionRequest) (*longrunningpb.Operation, error)
	// Lists the private connection routes exchanged over a peering connection.
	ListPrivateConnectionPeeringRoutes(context.Context, *ListPrivateConnectionPeeringRoutesRequest) (*ListPrivateConnectionPeeringRoutesResponse, error)
}

// UnimplementedVmwareEngineServer can be embedded to have forward compatible implementations.
type UnimplementedVmwareEngineServer struct {
}

func (*UnimplementedVmwareEngineServer) ListPrivateClouds(context.Context, *ListPrivateCloudsRequest) (*ListPrivateCloudsResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method ListPrivateClouds not implemented")
}
func (*UnimplementedVmwareEngineServer) GetPrivateCloud(context.Context, *GetPrivateCloudRequest) (*PrivateCloud, error) {
	return nil, status.Errorf(codes.Unimplemented, "method GetPrivateCloud not implemented")
}
func (*UnimplementedVmwareEngineServer) CreatePrivateCloud(context.Context, *CreatePrivateCloudRequest) (*longrunningpb.Operation, error) {
	return nil, status.Errorf(codes.Unimplemented, "method CreatePrivateCloud not implemented")
}
func (*UnimplementedVmwareEngineServer) UpdatePrivateCloud(context.Context, *UpdatePrivateCloudRequest) (*longrunningpb.Operation, error) {
	return nil, status.Errorf(codes.Unimplemented, "method UpdatePrivateCloud not implemented")
}
func (*UnimplementedVmwareEngineServer) DeletePrivateCloud(context.Context, *DeletePrivateCloudRequest) (*longrunningpb.Operation, error) {
	return nil, status.Errorf(codes.Unimplemented, "method DeletePrivateCloud not implemented")
}
func (*UnimplementedVmwareEngineServer) UndeletePrivateCloud(context.Context, *UndeletePrivateCloudRequest) (*longrunningpb.Operation, error) {
	return nil, status.Errorf(codes.Unimplemented, "method UndeletePrivateCloud not implemented")
}
func (*UnimplementedVmwareEngineServer) ListClusters(context.Context, *ListClustersRequest) (*ListClustersResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method ListClusters not implemented")
}
func (*UnimplementedVmwareEngineServer) GetCluster(context.Context, *GetClusterRequest) (*Cluster, error) {
	return nil, status.Errorf(codes.Unimplemented, "method GetCluster not implemented")
}
func (*UnimplementedVmwareEngineServer) CreateCluster(context.Context, *CreateClusterRequest) (*longrunningpb.Operation, error) {
	return nil, status.Errorf(codes.Unimplemented, "method CreateCluster not implemented")
}
func (*UnimplementedVmwareEngineServer) UpdateCluster(context.Context, *UpdateClusterRequest) (*longrunningpb.Operation, error) {
	return nil, status.Errorf(codes.Unimplemented, "method UpdateCluster not implemented")
}
func (*UnimplementedVmwareEngineServer) DeleteCluster(context.Context, *DeleteClusterRequest) (*longrunningpb.Operation, error) {
	return nil, status.Errorf(codes.Unimplemented, "method DeleteCluster not implemented")
}
func (*UnimplementedVmwareEngineServer) ListSubnets(context.Context, *ListSubnetsRequest) (*ListSubnetsResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method ListSubnets not implemented")
}
func (*UnimplementedVmwareEngineServer) GetSubnet(context.Context, *GetSubnetRequest) (*Subnet, error) {
	return nil, status.Errorf(codes.Unimplemented, "method GetSubnet not implemented")
}
func (*UnimplementedVmwareEngineServer) UpdateSubnet(context.Context, *UpdateSubnetRequest) (*longrunningpb.Operation, error) {
	return nil, status.Errorf(codes.Unimplemented, "method UpdateSubnet not implemented")
}
func (*UnimplementedVmwareEngineServer) ListNodeTypes(context.Context, *ListNodeTypesRequest) (*ListNodeTypesResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method ListNodeTypes not implemented")
}
func (*UnimplementedVmwareEngineServer) GetNodeType(context.Context, *GetNodeTypeRequest) (*NodeType, error) {
	return nil, status.Errorf(codes.Unimplemented, "method GetNodeType not implemented")
}
func (*UnimplementedVmwareEngineServer) ShowNsxCredentials(context.Context, *ShowNsxCredentialsRequest) (*Credentials, error) {
	return nil, status.Errorf(codes.Unimplemented, "method ShowNsxCredentials not implemented")
}
func (*UnimplementedVmwareEngineServer) ShowVcenterCredentials(context.Context, *ShowVcenterCredentialsRequest) (*Credentials, error) {
	return nil, status.Errorf(codes.Unimplemented, "method ShowVcenterCredentials not implemented")
}
func (*UnimplementedVmwareEngineServer) ResetNsxCredentials(context.Context, *ResetNsxCredentialsRequest) (*longrunningpb.Operation, error) {
	return nil, status.Errorf(codes.Unimplemented, "method ResetNsxCredentials not implemented")
}
func (*UnimplementedVmwareEngineServer) ResetVcenterCredentials(context.Context, *ResetVcenterCredentialsRequest) (*longrunningpb.Operation, error) {
	return nil, status.Errorf(codes.Unimplemented, "method ResetVcenterCredentials not implemented")
}
func (*UnimplementedVmwareEngineServer) CreateHcxActivationKey(context.Context, *CreateHcxActivationKeyRequest) (*longrunningpb.Operation, error) {
	return nil, status.Errorf(codes.Unimplemented, "method CreateHcxActivationKey not implemented")
}
func (*UnimplementedVmwareEngineServer) ListHcxActivationKeys(context.Context, *ListHcxActivationKeysRequest) (*ListHcxActivationKeysResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method ListHcxActivationKeys not implemented")
}
func (*UnimplementedVmwareEngineServer) GetHcxActivationKey(context.Context, *GetHcxActivationKeyRequest) (*HcxActivationKey, error) {
	return nil, status.Errorf(codes.Unimplemented, "method GetHcxActivationKey not implemented")
}
func (*UnimplementedVmwareEngineServer) GetNetworkPolicy(context.Context, *GetNetworkPolicyRequest) (*NetworkPolicy, error) {
	return nil, status.Errorf(codes.Unimplemented, "method GetNetworkPolicy not implemented")
}
func (*UnimplementedVmwareEngineServer) ListNetworkPolicies(context.Context, *ListNetworkPoliciesRequest) (*ListNetworkPoliciesResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method ListNetworkPolicies not implemented")
}
func (*UnimplementedVmwareEngineServer) CreateNetworkPolicy(context.Context, *CreateNetworkPolicyRequest) (*longrunningpb.Operation, error) {
	return nil, status.Errorf(codes.Unimplemented, "method CreateNetworkPolicy not implemented")
}
func (*UnimplementedVmwareEngineServer) UpdateNetworkPolicy(context.Context, *UpdateNetworkPolicyRequest) (*longrunningpb.Operation, error) {
	return nil, status.Errorf(codes.Unimplemented, "method UpdateNetworkPolicy not implemented")
}
func (*UnimplementedVmwareEngineServer) DeleteNetworkPolicy(context.Context, *DeleteNetworkPolicyRequest) (*longrunningpb.Operation, error) {
	return nil, status.Errorf(codes.Unimplemented, "method DeleteNetworkPolicy not implemented")
}
func (*UnimplementedVmwareEngineServer) CreateVmwareEngineNetwork(context.Context, *CreateVmwareEngineNetworkRequest) (*longrunningpb.Operation, error) {
	return nil, status.Errorf(codes.Unimplemented, "method CreateVmwareEngineNetwork not implemented")
}
func (*UnimplementedVmwareEngineServer) UpdateVmwareEngineNetwork(context.Context, *UpdateVmwareEngineNetworkRequest) (*longrunningpb.Operation, error) {
	return nil, status.Errorf(codes.Unimplemented, "method UpdateVmwareEngineNetwork not implemented")
}
func (*UnimplementedVmwareEngineServer) DeleteVmwareEngineNetwork(context.Context, *DeleteVmwareEngineNetworkRequest) (*longrunningpb.Operation, error) {
	return nil, status.Errorf(codes.Unimplemented, "method DeleteVmwareEngineNetwork not implemented")
}
func (*UnimplementedVmwareEngineServer) GetVmwareEngineNetwork(context.Context, *GetVmwareEngineNetworkRequest) (*VmwareEngineNetwork, error) {
	return nil, status.Errorf(codes.Unimplemented, "method GetVmwareEngineNetwork not implemented")
}
func (*UnimplementedVmwareEngineServer) ListVmwareEngineNetworks(context.Context, *ListVmwareEngineNetworksRequest) (*ListVmwareEngineNetworksResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method ListVmwareEngineNetworks not implemented")
}
func (*UnimplementedVmwareEngineServer) CreatePrivateConnection(context.Context, *CreatePrivateConnectionRequest) (*longrunningpb.Operation, error) {
	return nil, status.Errorf(codes.Unimplemented, "method CreatePrivateConnection not implemented")
}
func (*UnimplementedVmwareEngineServer) GetPrivateConnection(context.Context, *GetPrivateConnectionRequest) (*PrivateConnection, error) {
	return nil, status.Errorf(codes.Unimplemented, "method GetPrivateConnection not implemented")
}
func (*UnimplementedVmwareEngineServer) ListPrivateConnections(context.Context, *ListPrivateConnectionsRequest) (*ListPrivateConnectionsResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method ListPrivateConnections not implemented")
}
func (*UnimplementedVmwareEngineServer) UpdatePrivateConnection(context.Context, *UpdatePrivateConnectionRequest) (*longrunningpb.Operation, error) {
	return nil, status.Errorf(codes.Unimplemented, "method UpdatePrivateConnection not implemented")
}
func (*UnimplementedVmwareEngineServer) DeletePrivateConnection(context.Context, *DeletePrivateConnectionRequest) (*longrunningpb.Operation, error) {
	return nil, status.Errorf(codes.Unimplemented, "method DeletePrivateConnection not implemented")
}
func (*UnimplementedVmwareEngineServer) ListPrivateConnectionPeeringRoutes(context.Context, *ListPrivateConnectionPeeringRoutesRequest) (*ListPrivateConnectionPeeringRoutesResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method ListPrivateConnectionPeeringRoutes not implemented")
}

func RegisterVmwareEngineServer(s *grpc.Server, srv VmwareEngineServer) {
	s.RegisterService(&_VmwareEngine_serviceDesc, srv)
}

func _VmwareEngine_ListPrivateClouds_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(ListPrivateCloudsRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(VmwareEngineServer).ListPrivateClouds(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.vmwareengine.v1.VmwareEngine/ListPrivateClouds",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(VmwareEngineServer).ListPrivateClouds(ctx, req.(*ListPrivateCloudsRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _VmwareEngine_GetPrivateCloud_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(GetPrivateCloudRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(VmwareEngineServer).GetPrivateCloud(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.vmwareengine.v1.VmwareEngine/GetPrivateCloud",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(VmwareEngineServer).GetPrivateCloud(ctx, req.(*GetPrivateCloudRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _VmwareEngine_CreatePrivateCloud_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(CreatePrivateCloudRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(VmwareEngineServer).CreatePrivateCloud(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.vmwareengine.v1.VmwareEngine/CreatePrivateCloud",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(VmwareEngineServer).CreatePrivateCloud(ctx, req.(*CreatePrivateCloudRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _VmwareEngine_UpdatePrivateCloud_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(UpdatePrivateCloudRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(VmwareEngineServer).UpdatePrivateCloud(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.vmwareengine.v1.VmwareEngine/UpdatePrivateCloud",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(VmwareEngineServer).UpdatePrivateCloud(ctx, req.(*UpdatePrivateCloudRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _VmwareEngine_DeletePrivateCloud_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(DeletePrivateCloudRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(VmwareEngineServer).DeletePrivateCloud(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.vmwareengine.v1.VmwareEngine/DeletePrivateCloud",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(VmwareEngineServer).DeletePrivateCloud(ctx, req.(*DeletePrivateCloudRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _VmwareEngine_UndeletePrivateCloud_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(UndeletePrivateCloudRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(VmwareEngineServer).UndeletePrivateCloud(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.vmwareengine.v1.VmwareEngine/UndeletePrivateCloud",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(VmwareEngineServer).UndeletePrivateCloud(ctx, req.(*UndeletePrivateCloudRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _VmwareEngine_ListClusters_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(ListClustersRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(VmwareEngineServer).ListClusters(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.vmwareengine.v1.VmwareEngine/ListClusters",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(VmwareEngineServer).ListClusters(ctx, req.(*ListClustersRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _VmwareEngine_GetCluster_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(GetClusterRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(VmwareEngineServer).GetCluster(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.vmwareengine.v1.VmwareEngine/GetCluster",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(VmwareEngineServer).GetCluster(ctx, req.(*GetClusterRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _VmwareEngine_CreateCluster_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(CreateClusterRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(VmwareEngineServer).CreateCluster(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.vmwareengine.v1.VmwareEngine/CreateCluster",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(VmwareEngineServer).CreateCluster(ctx, req.(*CreateClusterRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _VmwareEngine_UpdateCluster_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(UpdateClusterRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(VmwareEngineServer).UpdateCluster(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.vmwareengine.v1.VmwareEngine/UpdateCluster",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(VmwareEngineServer).UpdateCluster(ctx, req.(*UpdateClusterRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _VmwareEngine_DeleteCluster_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(DeleteClusterRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(VmwareEngineServer).DeleteCluster(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.vmwareengine.v1.VmwareEngine/DeleteCluster",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(VmwareEngineServer).DeleteCluster(ctx, req.(*DeleteClusterRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _VmwareEngine_ListSubnets_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(ListSubnetsRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(VmwareEngineServer).ListSubnets(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.vmwareengine.v1.VmwareEngine/ListSubnets",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(VmwareEngineServer).ListSubnets(ctx, req.(*ListSubnetsRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _VmwareEngine_GetSubnet_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(GetSubnetRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(VmwareEngineServer).GetSubnet(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.vmwareengine.v1.VmwareEngine/GetSubnet",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(VmwareEngineServer).GetSubnet(ctx, req.(*GetSubnetRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _VmwareEngine_UpdateSubnet_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(UpdateSubnetRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(VmwareEngineServer).UpdateSubnet(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.vmwareengine.v1.VmwareEngine/UpdateSubnet",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(VmwareEngineServer).UpdateSubnet(ctx, req.(*UpdateSubnetRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _VmwareEngine_ListNodeTypes_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(ListNodeTypesRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(VmwareEngineServer).ListNodeTypes(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.vmwareengine.v1.VmwareEngine/ListNodeTypes",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(VmwareEngineServer).ListNodeTypes(ctx, req.(*ListNodeTypesRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _VmwareEngine_GetNodeType_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(GetNodeTypeRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(VmwareEngineServer).GetNodeType(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.vmwareengine.v1.VmwareEngine/GetNodeType",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(VmwareEngineServer).GetNodeType(ctx, req.(*GetNodeTypeRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _VmwareEngine_ShowNsxCredentials_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(ShowNsxCredentialsRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(VmwareEngineServer).ShowNsxCredentials(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.vmwareengine.v1.VmwareEngine/ShowNsxCredentials",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(VmwareEngineServer).ShowNsxCredentials(ctx, req.(*ShowNsxCredentialsRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _VmwareEngine_ShowVcenterCredentials_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(ShowVcenterCredentialsRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(VmwareEngineServer).ShowVcenterCredentials(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.vmwareengine.v1.VmwareEngine/ShowVcenterCredentials",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(VmwareEngineServer).ShowVcenterCredentials(ctx, req.(*ShowVcenterCredentialsRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _VmwareEngine_ResetNsxCredentials_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(ResetNsxCredentialsRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(VmwareEngineServer).ResetNsxCredentials(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.vmwareengine.v1.VmwareEngine/ResetNsxCredentials",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(VmwareEngineServer).ResetNsxCredentials(ctx, req.(*ResetNsxCredentialsRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _VmwareEngine_ResetVcenterCredentials_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(ResetVcenterCredentialsRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(VmwareEngineServer).ResetVcenterCredentials(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.vmwareengine.v1.VmwareEngine/ResetVcenterCredentials",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(VmwareEngineServer).ResetVcenterCredentials(ctx, req.(*ResetVcenterCredentialsRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _VmwareEngine_CreateHcxActivationKey_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(CreateHcxActivationKeyRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(VmwareEngineServer).CreateHcxActivationKey(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.vmwareengine.v1.VmwareEngine/CreateHcxActivationKey",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(VmwareEngineServer).CreateHcxActivationKey(ctx, req.(*CreateHcxActivationKeyRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _VmwareEngine_ListHcxActivationKeys_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(ListHcxActivationKeysRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(VmwareEngineServer).ListHcxActivationKeys(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.vmwareengine.v1.VmwareEngine/ListHcxActivationKeys",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(VmwareEngineServer).ListHcxActivationKeys(ctx, req.(*ListHcxActivationKeysRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _VmwareEngine_GetHcxActivationKey_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(GetHcxActivationKeyRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(VmwareEngineServer).GetHcxActivationKey(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.vmwareengine.v1.VmwareEngine/GetHcxActivationKey",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(VmwareEngineServer).GetHcxActivationKey(ctx, req.(*GetHcxActivationKeyRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _VmwareEngine_GetNetworkPolicy_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(GetNetworkPolicyRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(VmwareEngineServer).GetNetworkPolicy(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.vmwareengine.v1.VmwareEngine/GetNetworkPolicy",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(VmwareEngineServer).GetNetworkPolicy(ctx, req.(*GetNetworkPolicyRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _VmwareEngine_ListNetworkPolicies_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(ListNetworkPoliciesRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(VmwareEngineServer).ListNetworkPolicies(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.vmwareengine.v1.VmwareEngine/ListNetworkPolicies",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(VmwareEngineServer).ListNetworkPolicies(ctx, req.(*ListNetworkPoliciesRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _VmwareEngine_CreateNetworkPolicy_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(CreateNetworkPolicyRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(VmwareEngineServer).CreateNetworkPolicy(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.vmwareengine.v1.VmwareEngine/CreateNetworkPolicy",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(VmwareEngineServer).CreateNetworkPolicy(ctx, req.(*CreateNetworkPolicyRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _VmwareEngine_UpdateNetworkPolicy_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(UpdateNetworkPolicyRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(VmwareEngineServer).UpdateNetworkPolicy(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.vmwareengine.v1.VmwareEngine/UpdateNetworkPolicy",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(VmwareEngineServer).UpdateNetworkPolicy(ctx, req.(*UpdateNetworkPolicyRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _VmwareEngine_DeleteNetworkPolicy_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(DeleteNetworkPolicyRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(VmwareEngineServer).DeleteNetworkPolicy(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.vmwareengine.v1.VmwareEngine/DeleteNetworkPolicy",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(VmwareEngineServer).DeleteNetworkPolicy(ctx, req.(*DeleteNetworkPolicyRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _VmwareEngine_CreateVmwareEngineNetwork_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(CreateVmwareEngineNetworkRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(VmwareEngineServer).CreateVmwareEngineNetwork(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.vmwareengine.v1.VmwareEngine/CreateVmwareEngineNetwork",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(VmwareEngineServer).CreateVmwareEngineNetwork(ctx, req.(*CreateVmwareEngineNetworkRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _VmwareEngine_UpdateVmwareEngineNetwork_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(UpdateVmwareEngineNetworkRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(VmwareEngineServer).UpdateVmwareEngineNetwork(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.vmwareengine.v1.VmwareEngine/UpdateVmwareEngineNetwork",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(VmwareEngineServer).UpdateVmwareEngineNetwork(ctx, req.(*UpdateVmwareEngineNetworkRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _VmwareEngine_DeleteVmwareEngineNetwork_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(DeleteVmwareEngineNetworkRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(VmwareEngineServer).DeleteVmwareEngineNetwork(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.vmwareengine.v1.VmwareEngine/DeleteVmwareEngineNetwork",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(VmwareEngineServer).DeleteVmwareEngineNetwork(ctx, req.(*DeleteVmwareEngineNetworkRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _VmwareEngine_GetVmwareEngineNetwork_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(GetVmwareEngineNetworkRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(VmwareEngineServer).GetVmwareEngineNetwork(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.vmwareengine.v1.VmwareEngine/GetVmwareEngineNetwork",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(VmwareEngineServer).GetVmwareEngineNetwork(ctx, req.(*GetVmwareEngineNetworkRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _VmwareEngine_ListVmwareEngineNetworks_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(ListVmwareEngineNetworksRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(VmwareEngineServer).ListVmwareEngineNetworks(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.vmwareengine.v1.VmwareEngine/ListVmwareEngineNetworks",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(VmwareEngineServer).ListVmwareEngineNetworks(ctx, req.(*ListVmwareEngineNetworksRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _VmwareEngine_CreatePrivateConnection_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(CreatePrivateConnectionRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(VmwareEngineServer).CreatePrivateConnection(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.vmwareengine.v1.VmwareEngine/CreatePrivateConnection",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(VmwareEngineServer).CreatePrivateConnection(ctx, req.(*CreatePrivateConnectionRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _VmwareEngine_GetPrivateConnection_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(GetPrivateConnectionRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(VmwareEngineServer).GetPrivateConnection(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.vmwareengine.v1.VmwareEngine/GetPrivateConnection",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(VmwareEngineServer).GetPrivateConnection(ctx, req.(*GetPrivateConnectionRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _VmwareEngine_ListPrivateConnections_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(ListPrivateConnectionsRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(VmwareEngineServer).ListPrivateConnections(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.vmwareengine.v1.VmwareEngine/ListPrivateConnections",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(VmwareEngineServer).ListPrivateConnections(ctx, req.(*ListPrivateConnectionsRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _VmwareEngine_UpdatePrivateConnection_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(UpdatePrivateConnectionRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(VmwareEngineServer).UpdatePrivateConnection(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.vmwareengine.v1.VmwareEngine/UpdatePrivateConnection",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(VmwareEngineServer).UpdatePrivateConnection(ctx, req.(*UpdatePrivateConnectionRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _VmwareEngine_DeletePrivateConnection_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(DeletePrivateConnectionRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(VmwareEngineServer).DeletePrivateConnection(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.vmwareengine.v1.VmwareEngine/DeletePrivateConnection",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(VmwareEngineServer).DeletePrivateConnection(ctx, req.(*DeletePrivateConnectionRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _VmwareEngine_ListPrivateConnectionPeeringRoutes_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(ListPrivateConnectionPeeringRoutesRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(VmwareEngineServer).ListPrivateConnectionPeeringRoutes(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.vmwareengine.v1.VmwareEngine/ListPrivateConnectionPeeringRoutes",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(VmwareEngineServer).ListPrivateConnectionPeeringRoutes(ctx, req.(*ListPrivateConnectionPeeringRoutesRequest))
	}
	return interceptor(ctx, in, info, handler)
}

var _VmwareEngine_serviceDesc = grpc.ServiceDesc{
	ServiceName: "google.cloud.vmwareengine.v1.VmwareEngine",
	HandlerType: (*VmwareEngineServer)(nil),
	Methods: []grpc.MethodDesc{
		{
			MethodName: "ListPrivateClouds",
			Handler:    _VmwareEngine_ListPrivateClouds_Handler,
		},
		{
			MethodName: "GetPrivateCloud",
			Handler:    _VmwareEngine_GetPrivateCloud_Handler,
		},
		{
			MethodName: "CreatePrivateCloud",
			Handler:    _VmwareEngine_CreatePrivateCloud_Handler,
		},
		{
			MethodName: "UpdatePrivateCloud",
			Handler:    _VmwareEngine_UpdatePrivateCloud_Handler,
		},
		{
			MethodName: "DeletePrivateCloud",
			Handler:    _VmwareEngine_DeletePrivateCloud_Handler,
		},
		{
			MethodName: "UndeletePrivateCloud",
			Handler:    _VmwareEngine_UndeletePrivateCloud_Handler,
		},
		{
			MethodName: "ListClusters",
			Handler:    _VmwareEngine_ListClusters_Handler,
		},
		{
			MethodName: "GetCluster",
			Handler:    _VmwareEngine_GetCluster_Handler,
		},
		{
			MethodName: "CreateCluster",
			Handler:    _VmwareEngine_CreateCluster_Handler,
		},
		{
			MethodName: "UpdateCluster",
			Handler:    _VmwareEngine_UpdateCluster_Handler,
		},
		{
			MethodName: "DeleteCluster",
			Handler:    _VmwareEngine_DeleteCluster_Handler,
		},
		{
			MethodName: "ListSubnets",
			Handler:    _VmwareEngine_ListSubnets_Handler,
		},
		{
			MethodName: "GetSubnet",
			Handler:    _VmwareEngine_GetSubnet_Handler,
		},
		{
			MethodName: "UpdateSubnet",
			Handler:    _VmwareEngine_UpdateSubnet_Handler,
		},
		{
			MethodName: "ListNodeTypes",
			Handler:    _VmwareEngine_ListNodeTypes_Handler,
		},
		{
			MethodName: "GetNodeType",
			Handler:    _VmwareEngine_GetNodeType_Handler,
		},
		{
			MethodName: "ShowNsxCredentials",
			Handler:    _VmwareEngine_ShowNsxCredentials_Handler,
		},
		{
			MethodName: "ShowVcenterCredentials",
			Handler:    _VmwareEngine_ShowVcenterCredentials_Handler,
		},
		{
			MethodName: "ResetNsxCredentials",
			Handler:    _VmwareEngine_ResetNsxCredentials_Handler,
		},
		{
			MethodName: "ResetVcenterCredentials",
			Handler:    _VmwareEngine_ResetVcenterCredentials_Handler,
		},
		{
			MethodName: "CreateHcxActivationKey",
			Handler:    _VmwareEngine_CreateHcxActivationKey_Handler,
		},
		{
			MethodName: "ListHcxActivationKeys",
			Handler:    _VmwareEngine_ListHcxActivationKeys_Handler,
		},
		{
			MethodName: "GetHcxActivationKey",
			Handler:    _VmwareEngine_GetHcxActivationKey_Handler,
		},
		{
			MethodName: "GetNetworkPolicy",
			Handler:    _VmwareEngine_GetNetworkPolicy_Handler,
		},
		{
			MethodName: "ListNetworkPolicies",
			Handler:    _VmwareEngine_ListNetworkPolicies_Handler,
		},
		{
			MethodName: "CreateNetworkPolicy",
			Handler:    _VmwareEngine_CreateNetworkPolicy_Handler,
		},
		{
			MethodName: "UpdateNetworkPolicy",
			Handler:    _VmwareEngine_UpdateNetworkPolicy_Handler,
		},
		{
			MethodName: "DeleteNetworkPolicy",
			Handler:    _VmwareEngine_DeleteNetworkPolicy_Handler,
		},
		{
			MethodName: "CreateVmwareEngineNetwork",
			Handler:    _VmwareEngine_CreateVmwareEngineNetwork_Handler,
		},
		{
			MethodName: "UpdateVmwareEngineNetwork",
			Handler:    _VmwareEngine_UpdateVmwareEngineNetwork_Handler,
		},
		{
			MethodName: "DeleteVmwareEngineNetwork",
			Handler:    _VmwareEngine_DeleteVmwareEngineNetwork_Handler,
		},
		{
			MethodName: "GetVmwareEngineNetwork",
			Handler:    _VmwareEngine_GetVmwareEngineNetwork_Handler,
		},
		{
			MethodName: "ListVmwareEngineNetworks",
			Handler:    _VmwareEngine_ListVmwareEngineNetworks_Handler,
		},
		{
			MethodName: "CreatePrivateConnection",
			Handler:    _VmwareEngine_CreatePrivateConnection_Handler,
		},
		{
			MethodName: "GetPrivateConnection",
			Handler:    _VmwareEngine_GetPrivateConnection_Handler,
		},
		{
			MethodName: "ListPrivateConnections",
			Handler:    _VmwareEngine_ListPrivateConnections_Handler,
		},
		{
			MethodName: "UpdatePrivateConnection",
			Handler:    _VmwareEngine_UpdatePrivateConnection_Handler,
		},
		{
			MethodName: "DeletePrivateConnection",
			Handler:    _VmwareEngine_DeletePrivateConnection_Handler,
		},
		{
			MethodName: "ListPrivateConnectionPeeringRoutes",
			Handler:    _VmwareEngine_ListPrivateConnectionPeeringRoutes_Handler,
		},
	},
	Streams:  []grpc.StreamDesc{},
	Metadata: "google/cloud/vmwareengine/v1/vmwareengine.proto",
}
