// Copyright 2024 Google LLC
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//     http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// Code generated by protoc-gen-go. DO NOT EDIT.
// versions:
// 	protoc-gen-go v1.34.2
// 	protoc        v4.25.3
// source: google/cloud/dialogflow/cx/v3beta1/conversation_history.proto

package cxpb

import (
	context "context"
	reflect "reflect"
	sync "sync"

	_ "google.golang.org/genproto/googleapis/api/annotations"
	grpc "google.golang.org/grpc"
	codes "google.golang.org/grpc/codes"
	status "google.golang.org/grpc/status"
	protoreflect "google.golang.org/protobuf/reflect/protoreflect"
	protoimpl "google.golang.org/protobuf/runtime/protoimpl"
	durationpb "google.golang.org/protobuf/types/known/durationpb"
	emptypb "google.golang.org/protobuf/types/known/emptypb"
	timestamppb "google.golang.org/protobuf/types/known/timestamppb"
)

const (
	// Verify that this generated code is sufficiently up-to-date.
	_ = protoimpl.EnforceVersion(20 - protoimpl.MinVersion)
	// Verify that runtime/protoimpl is sufficiently up-to-date.
	_ = protoimpl.EnforceVersion(protoimpl.MaxVersion - 20)
)

// Represents the type of a conversation.
type Conversation_Type int32

const (
	// Not specified. This value should never be used.
	Conversation_TYPE_UNSPECIFIED Conversation_Type = 0
	// Audio conversation. A conversation is classified as an audio conversation
	// if any request has STT input audio or any response has TTS output audio.
	Conversation_AUDIO Conversation_Type = 1
	// Text conversation. A conversation is classified as a text conversation
	// if any request has text input and no request has STT input audio and no
	// response has TTS output audio.
	Conversation_TEXT Conversation_Type = 2
	// Default conversation type for a conversation. A conversation is
	// classified as undetermined if none of the requests contain text or audio
	// input (eg. event or intent input).
	Conversation_UNDETERMINED Conversation_Type = 3
)

// Enum value maps for Conversation_Type.
var (
	Conversation_Type_name = map[int32]string{
		0: "TYPE_UNSPECIFIED",
		1: "AUDIO",
		2: "TEXT",
		3: "UNDETERMINED",
	}
	Conversation_Type_value = map[string]int32{
		"TYPE_UNSPECIFIED": 0,
		"AUDIO":            1,
		"TEXT":             2,
		"UNDETERMINED":     3,
	}
)

func (x Conversation_Type) Enum() *Conversation_Type {
	p := new(Conversation_Type)
	*p = x
	return p
}

func (x Conversation_Type) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (Conversation_Type) Descriptor() protoreflect.EnumDescriptor {
	return file_google_cloud_dialogflow_cx_v3beta1_conversation_history_proto_enumTypes[0].Descriptor()
}

func (Conversation_Type) Type() protoreflect.EnumType {
	return &file_google_cloud_dialogflow_cx_v3beta1_conversation_history_proto_enumTypes[0]
}

func (x Conversation_Type) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use Conversation_Type.Descriptor instead.
func (Conversation_Type) EnumDescriptor() ([]byte, []int) {
	return file_google_cloud_dialogflow_cx_v3beta1_conversation_history_proto_rawDescGZIP(), []int{4, 0}
}

// The request message for [Conversations.GetConversation][].
type GetConversationRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. The name of the conversation.
	// Format: `projects/<Project ID>/locations/<Location ID>/agents/<Agent
	// ID>/conversations/<Conversation ID>`.
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
}

func (x *GetConversationRequest) Reset() {
	*x = GetConversationRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_dialogflow_cx_v3beta1_conversation_history_proto_msgTypes[0]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *GetConversationRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*GetConversationRequest) ProtoMessage() {}

func (x *GetConversationRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_dialogflow_cx_v3beta1_conversation_history_proto_msgTypes[0]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use GetConversationRequest.ProtoReflect.Descriptor instead.
func (*GetConversationRequest) Descriptor() ([]byte, []int) {
	return file_google_cloud_dialogflow_cx_v3beta1_conversation_history_proto_rawDescGZIP(), []int{0}
}

func (x *GetConversationRequest) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

// The request message for [Conversations.DeleteConversation][].
type DeleteConversationRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. The name of the conversation.
	// Format: `projects/<Project ID>/locations/<Location ID>/agents/<Agent
	// ID>/conversations/<Conversation ID>`.
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
}

func (x *DeleteConversationRequest) Reset() {
	*x = DeleteConversationRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_dialogflow_cx_v3beta1_conversation_history_proto_msgTypes[1]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *DeleteConversationRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*DeleteConversationRequest) ProtoMessage() {}

func (x *DeleteConversationRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_dialogflow_cx_v3beta1_conversation_history_proto_msgTypes[1]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use DeleteConversationRequest.ProtoReflect.Descriptor instead.
func (*DeleteConversationRequest) Descriptor() ([]byte, []int) {
	return file_google_cloud_dialogflow_cx_v3beta1_conversation_history_proto_rawDescGZIP(), []int{1}
}

func (x *DeleteConversationRequest) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

// The request message for [Conversations.ListConversations][].
type ListConversationsRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. The agent to list all conversations for.
	// Format: `projects/<Project ID>/locations/<Location ID>/agents/<Agent ID>`.
	Parent string `protobuf:"bytes,1,opt,name=parent,proto3" json:"parent,omitempty"`
	// Optional. The filter string. Supports filter by create_time,
	// metrics.has_end_interaction, metrics.has_live_agent_handoff,
	// intents.display_name, pages.display_name and flows.display_name. Timestamps
	// expect an [RFC-3339][https://datatracker.ietf.org/doc/html/rfc3339]
	// formatted string (e.g. 2012-04-21T11:30:00-04:00). UTC offsets are
	// supported. Some examples:
	//  1. By create time:
	//     create_time > "2022-04-21T11:30:00-04:00"
	//  2. By intent display name:
	//     intents.display_name : "billing"
	//  3. By end interaction signal:
	//     metrics.has_end_interaction = true
	Filter string `protobuf:"bytes,2,opt,name=filter,proto3" json:"filter,omitempty"`
	// Optional. The maximum number of items to return in a single page. By
	// default 100 and at most 1000.
	PageSize int32 `protobuf:"varint,3,opt,name=page_size,json=pageSize,proto3" json:"page_size,omitempty"`
	// Optional. The next_page_token value returned from a previous list request.
	PageToken string `protobuf:"bytes,4,opt,name=page_token,json=pageToken,proto3" json:"page_token,omitempty"`
}

func (x *ListConversationsRequest) Reset() {
	*x = ListConversationsRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_dialogflow_cx_v3beta1_conversation_history_proto_msgTypes[2]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *ListConversationsRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ListConversationsRequest) ProtoMessage() {}

func (x *ListConversationsRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_dialogflow_cx_v3beta1_conversation_history_proto_msgTypes[2]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ListConversationsRequest.ProtoReflect.Descriptor instead.
func (*ListConversationsRequest) Descriptor() ([]byte, []int) {
	return file_google_cloud_dialogflow_cx_v3beta1_conversation_history_proto_rawDescGZIP(), []int{2}
}

func (x *ListConversationsRequest) GetParent() string {
	if x != nil {
		return x.Parent
	}
	return ""
}

func (x *ListConversationsRequest) GetFilter() string {
	if x != nil {
		return x.Filter
	}
	return ""
}

func (x *ListConversationsRequest) GetPageSize() int32 {
	if x != nil {
		return x.PageSize
	}
	return 0
}

func (x *ListConversationsRequest) GetPageToken() string {
	if x != nil {
		return x.PageToken
	}
	return ""
}

// The response message for [Conversations.ListConversations][].
type ListConversationsResponse struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The list of conversations. There will be a maximum number of items returned
	// based on the
	// [page_size][google.cloud.dialogflow.cx.v3beta1.ListConversationsRequest.page_size]
	// field. The returned conversations will be sorted by start_time in
	// descending order (newest conversation first).
	Conversations []*Conversation `protobuf:"bytes,1,rep,name=conversations,proto3" json:"conversations,omitempty"`
	// Token to retrieve the next page of results, or empty if there are no more
	// results in the list.
	NextPageToken string `protobuf:"bytes,2,opt,name=next_page_token,json=nextPageToken,proto3" json:"next_page_token,omitempty"`
}

func (x *ListConversationsResponse) Reset() {
	*x = ListConversationsResponse{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_dialogflow_cx_v3beta1_conversation_history_proto_msgTypes[3]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *ListConversationsResponse) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ListConversationsResponse) ProtoMessage() {}

func (x *ListConversationsResponse) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_dialogflow_cx_v3beta1_conversation_history_proto_msgTypes[3]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ListConversationsResponse.ProtoReflect.Descriptor instead.
func (*ListConversationsResponse) Descriptor() ([]byte, []int) {
	return file_google_cloud_dialogflow_cx_v3beta1_conversation_history_proto_rawDescGZIP(), []int{3}
}

func (x *ListConversationsResponse) GetConversations() []*Conversation {
	if x != nil {
		return x.Conversations
	}
	return nil
}

func (x *ListConversationsResponse) GetNextPageToken() string {
	if x != nil {
		return x.NextPageToken
	}
	return ""
}

// Represents a conversation.
type Conversation struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Identifier. The identifier of the conversation.
	// If conversation ID is reused, interactions happened later than 48 hours of
	// the conversation's create time will be ignored. Format:
	// `projects/<ProjectID>/locations/<Location ID>/agents/<Agent
	// ID>/conversations/<Conversation ID>`
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
	// The type of the conversation.
	Type Conversation_Type `protobuf:"varint,2,opt,name=type,proto3,enum=google.cloud.dialogflow.cx.v3beta1.Conversation_Type" json:"type,omitempty"`
	// The language of the conversation, which is the language of the first
	// request in the conversation.
	LanguageCode string `protobuf:"bytes,3,opt,name=language_code,json=languageCode,proto3" json:"language_code,omitempty"`
	// Start time of the conversation, which is the time of the first request of
	// the conversation.
	StartTime *timestamppb.Timestamp `protobuf:"bytes,4,opt,name=start_time,json=startTime,proto3" json:"start_time,omitempty"`
	// Duration of the conversation.
	Duration *durationpb.Duration `protobuf:"bytes,5,opt,name=duration,proto3" json:"duration,omitempty"`
	// Conversation metrics.
	Metrics *Conversation_Metrics `protobuf:"bytes,6,opt,name=metrics,proto3" json:"metrics,omitempty"`
	// All the matched [Intent][google.cloud.dialogflow.cx.v3beta1.Intent] in the
	// conversation. Only `name` and `display_name` are filled in this message.
	Intents []*Intent `protobuf:"bytes,7,rep,name=intents,proto3" json:"intents,omitempty"`
	// All the [Flow][google.cloud.dialogflow.cx.v3beta1.Flow] the conversation
	// has went through. Only `name` and `display_name` are filled in this
	// message.
	Flows []*Flow `protobuf:"bytes,8,rep,name=flows,proto3" json:"flows,omitempty"`
	// All the [Page][google.cloud.dialogflow.cx.v3beta1.Page] the conversation
	// has went through. Only `name` and `display_name` are filled in this
	// message.
	Pages []*Page `protobuf:"bytes,9,rep,name=pages,proto3" json:"pages,omitempty"`
	// Interactions of the conversation.
	// Only populated for `GetConversation` and empty for `ListConversations`.
	Interactions []*Conversation_Interaction `protobuf:"bytes,10,rep,name=interactions,proto3" json:"interactions,omitempty"`
	// Environment of the conversation.
	// Only `name` and `display_name` are filled in this message.
	Environment *Environment `protobuf:"bytes,11,opt,name=environment,proto3" json:"environment,omitempty"`
	// Flow versions used in the conversation.
	FlowVersions map[string]int64 `protobuf:"bytes,12,rep,name=flow_versions,json=flowVersions,proto3" json:"flow_versions,omitempty" protobuf_key:"bytes,1,opt,name=key,proto3" protobuf_val:"varint,2,opt,name=value,proto3"`
}

func (x *Conversation) Reset() {
	*x = Conversation{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_dialogflow_cx_v3beta1_conversation_history_proto_msgTypes[4]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *Conversation) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*Conversation) ProtoMessage() {}

func (x *Conversation) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_dialogflow_cx_v3beta1_conversation_history_proto_msgTypes[4]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use Conversation.ProtoReflect.Descriptor instead.
func (*Conversation) Descriptor() ([]byte, []int) {
	return file_google_cloud_dialogflow_cx_v3beta1_conversation_history_proto_rawDescGZIP(), []int{4}
}

func (x *Conversation) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

func (x *Conversation) GetType() Conversation_Type {
	if x != nil {
		return x.Type
	}
	return Conversation_TYPE_UNSPECIFIED
}

func (x *Conversation) GetLanguageCode() string {
	if x != nil {
		return x.LanguageCode
	}
	return ""
}

func (x *Conversation) GetStartTime() *timestamppb.Timestamp {
	if x != nil {
		return x.StartTime
	}
	return nil
}

func (x *Conversation) GetDuration() *durationpb.Duration {
	if x != nil {
		return x.Duration
	}
	return nil
}

func (x *Conversation) GetMetrics() *Conversation_Metrics {
	if x != nil {
		return x.Metrics
	}
	return nil
}

func (x *Conversation) GetIntents() []*Intent {
	if x != nil {
		return x.Intents
	}
	return nil
}

func (x *Conversation) GetFlows() []*Flow {
	if x != nil {
		return x.Flows
	}
	return nil
}

func (x *Conversation) GetPages() []*Page {
	if x != nil {
		return x.Pages
	}
	return nil
}

func (x *Conversation) GetInteractions() []*Conversation_Interaction {
	if x != nil {
		return x.Interactions
	}
	return nil
}

func (x *Conversation) GetEnvironment() *Environment {
	if x != nil {
		return x.Environment
	}
	return nil
}

func (x *Conversation) GetFlowVersions() map[string]int64 {
	if x != nil {
		return x.FlowVersions
	}
	return nil
}

// Represents metrics for the conversation.
type Conversation_Metrics struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The number of interactions in the conversation.
	InteractionCount int32 `protobuf:"varint,1,opt,name=interaction_count,json=interactionCount,proto3" json:"interaction_count,omitempty"`
	// Duration of all the input's audio in the conversation.
	InputAudioDuration *durationpb.Duration `protobuf:"bytes,2,opt,name=input_audio_duration,json=inputAudioDuration,proto3" json:"input_audio_duration,omitempty"`
	// Duration of all the output's audio in the conversation.
	OutputAudioDuration *durationpb.Duration `protobuf:"bytes,3,opt,name=output_audio_duration,json=outputAudioDuration,proto3" json:"output_audio_duration,omitempty"`
	// Maximum latency of the
	// [Webhook][google.cloud.dialogflow.cx.v3beta1.Webhook] calls in the
	// conversation.
	MaxWebhookLatency *durationpb.Duration `protobuf:"bytes,4,opt,name=max_webhook_latency,json=maxWebhookLatency,proto3" json:"max_webhook_latency,omitempty"`
	// A signal that indicates the interaction with the Dialogflow agent has
	// ended.
	// If any response has the
	// [ResponseMessage.end_interaction][google.cloud.dialogflow.cx.v3beta1.ResponseMessage.end_interaction]
	// signal, this is set to true.
	HasEndInteraction bool `protobuf:"varint,5,opt,name=has_end_interaction,json=hasEndInteraction,proto3" json:"has_end_interaction,omitempty"`
	// Hands off conversation to a human agent.
	// If any response has the
	// [ResponseMessage.live_agent_handoff][google.cloud.dialogflow.cx.v3beta1.ResponseMessage.live_agent_handoff]signal,
	// this is set to true.
	HasLiveAgentHandoff bool `protobuf:"varint,6,opt,name=has_live_agent_handoff,json=hasLiveAgentHandoff,proto3" json:"has_live_agent_handoff,omitempty"`
	// The average confidence all of the
	// [Match][google.cloud.dialogflow.cx.v3beta1.Match] in the conversation.
	// Values range from 0.0 (completely uncertain) to 1.0 (completely certain).
	AverageMatchConfidence float32 `protobuf:"fixed32,7,opt,name=average_match_confidence,json=averageMatchConfidence,proto3" json:"average_match_confidence,omitempty"`
	// Query input counts.
	QueryInputCount *Conversation_Metrics_QueryInputCount `protobuf:"bytes,8,opt,name=query_input_count,json=queryInputCount,proto3" json:"query_input_count,omitempty"`
	// Match type counts.
	MatchTypeCount *Conversation_Metrics_MatchTypeCount `protobuf:"bytes,9,opt,name=match_type_count,json=matchTypeCount,proto3" json:"match_type_count,omitempty"`
}

func (x *Conversation_Metrics) Reset() {
	*x = Conversation_Metrics{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_dialogflow_cx_v3beta1_conversation_history_proto_msgTypes[5]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *Conversation_Metrics) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*Conversation_Metrics) ProtoMessage() {}

func (x *Conversation_Metrics) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_dialogflow_cx_v3beta1_conversation_history_proto_msgTypes[5]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use Conversation_Metrics.ProtoReflect.Descriptor instead.
func (*Conversation_Metrics) Descriptor() ([]byte, []int) {
	return file_google_cloud_dialogflow_cx_v3beta1_conversation_history_proto_rawDescGZIP(), []int{4, 0}
}

func (x *Conversation_Metrics) GetInteractionCount() int32 {
	if x != nil {
		return x.InteractionCount
	}
	return 0
}

func (x *Conversation_Metrics) GetInputAudioDuration() *durationpb.Duration {
	if x != nil {
		return x.InputAudioDuration
	}
	return nil
}

func (x *Conversation_Metrics) GetOutputAudioDuration() *durationpb.Duration {
	if x != nil {
		return x.OutputAudioDuration
	}
	return nil
}

func (x *Conversation_Metrics) GetMaxWebhookLatency() *durationpb.Duration {
	if x != nil {
		return x.MaxWebhookLatency
	}
	return nil
}

func (x *Conversation_Metrics) GetHasEndInteraction() bool {
	if x != nil {
		return x.HasEndInteraction
	}
	return false
}

func (x *Conversation_Metrics) GetHasLiveAgentHandoff() bool {
	if x != nil {
		return x.HasLiveAgentHandoff
	}
	return false
}

func (x *Conversation_Metrics) GetAverageMatchConfidence() float32 {
	if x != nil {
		return x.AverageMatchConfidence
	}
	return 0
}

func (x *Conversation_Metrics) GetQueryInputCount() *Conversation_Metrics_QueryInputCount {
	if x != nil {
		return x.QueryInputCount
	}
	return nil
}

func (x *Conversation_Metrics) GetMatchTypeCount() *Conversation_Metrics_MatchTypeCount {
	if x != nil {
		return x.MatchTypeCount
	}
	return nil
}

// Represents an interaction between an end user and a Dialogflow CX agent
// using V3 (Streaming)DetectIntent API, or an interaction between an end user
// and a Dialogflow CX agent using V2 (Streaming)AnalyzeContent API.
type Conversation_Interaction struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The request of the interaction.
	Request *DetectIntentRequest `protobuf:"bytes,1,opt,name=request,proto3" json:"request,omitempty"`
	// The final response of the interaction.
	Response *DetectIntentResponse `protobuf:"bytes,2,opt,name=response,proto3" json:"response,omitempty"`
	// The partial responses of the interaction. Empty if there is no partial
	// response in the interaction.
	// See the
	// [partial response
	// documentation][https://cloud.google.com/dialogflow/cx/docs/concept/fulfillment#queue].
	PartialResponses []*DetectIntentResponse `protobuf:"bytes,3,rep,name=partial_responses,json=partialResponses,proto3" json:"partial_responses,omitempty"`
	// The input text or the transcript of the input audio in the request.
	RequestUtterances string `protobuf:"bytes,4,opt,name=request_utterances,json=requestUtterances,proto3" json:"request_utterances,omitempty"`
	// The output text or the transcript of the output audio in the responses.
	// If multiple output messages are returned, they will be concatenated into
	// one.
	ResponseUtterances string `protobuf:"bytes,5,opt,name=response_utterances,json=responseUtterances,proto3" json:"response_utterances,omitempty"`
	// The time that the interaction was created.
	CreateTime *timestamppb.Timestamp `protobuf:"bytes,6,opt,name=create_time,json=createTime,proto3" json:"create_time,omitempty"`
	// Missing transition predicted for the interaction. This field is set only
	// if the interaction match type was no-match.
	MissingTransition *Conversation_Interaction_MissingTransition `protobuf:"bytes,8,opt,name=missing_transition,json=missingTransition,proto3" json:"missing_transition,omitempty"`
}

func (x *Conversation_Interaction) Reset() {
	*x = Conversation_Interaction{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_dialogflow_cx_v3beta1_conversation_history_proto_msgTypes[6]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *Conversation_Interaction) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*Conversation_Interaction) ProtoMessage() {}

func (x *Conversation_Interaction) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_dialogflow_cx_v3beta1_conversation_history_proto_msgTypes[6]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use Conversation_Interaction.ProtoReflect.Descriptor instead.
func (*Conversation_Interaction) Descriptor() ([]byte, []int) {
	return file_google_cloud_dialogflow_cx_v3beta1_conversation_history_proto_rawDescGZIP(), []int{4, 1}
}

func (x *Conversation_Interaction) GetRequest() *DetectIntentRequest {
	if x != nil {
		return x.Request
	}
	return nil
}

func (x *Conversation_Interaction) GetResponse() *DetectIntentResponse {
	if x != nil {
		return x.Response
	}
	return nil
}

func (x *Conversation_Interaction) GetPartialResponses() []*DetectIntentResponse {
	if x != nil {
		return x.PartialResponses
	}
	return nil
}

func (x *Conversation_Interaction) GetRequestUtterances() string {
	if x != nil {
		return x.RequestUtterances
	}
	return ""
}

func (x *Conversation_Interaction) GetResponseUtterances() string {
	if x != nil {
		return x.ResponseUtterances
	}
	return ""
}

func (x *Conversation_Interaction) GetCreateTime() *timestamppb.Timestamp {
	if x != nil {
		return x.CreateTime
	}
	return nil
}

func (x *Conversation_Interaction) GetMissingTransition() *Conversation_Interaction_MissingTransition {
	if x != nil {
		return x.MissingTransition
	}
	return nil
}

// Count by types of
// [QueryInput][google.cloud.dialogflow.cx.v3beta1.QueryInput] of the
// requests in the conversation.
type Conversation_Metrics_QueryInputCount struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The number of [TextInput][google.cloud.dialogflow.cx.v3beta1.TextInput]
	// in the conversation.
	TextCount int32 `protobuf:"varint,1,opt,name=text_count,json=textCount,proto3" json:"text_count,omitempty"`
	// The number of
	// [IntentInput][google.cloud.dialogflow.cx.v3beta1.IntentInput] in the
	// conversation.
	IntentCount int32 `protobuf:"varint,2,opt,name=intent_count,json=intentCount,proto3" json:"intent_count,omitempty"`
	// The number of
	// [AudioInput][google.cloud.dialogflow.cx.v3beta1.AudioInput] in the
	// conversation.
	AudioCount int32 `protobuf:"varint,3,opt,name=audio_count,json=audioCount,proto3" json:"audio_count,omitempty"`
	// The number of
	// [EventInput][google.cloud.dialogflow.cx.v3beta1.EventInput] in the
	// conversation.
	EventCount int32 `protobuf:"varint,4,opt,name=event_count,json=eventCount,proto3" json:"event_count,omitempty"`
	// The number of [DtmfInput][google.cloud.dialogflow.cx.v3beta1.DtmfInput]
	// in the conversation.
	DtmfCount int32 `protobuf:"varint,5,opt,name=dtmf_count,json=dtmfCount,proto3" json:"dtmf_count,omitempty"`
}

func (x *Conversation_Metrics_QueryInputCount) Reset() {
	*x = Conversation_Metrics_QueryInputCount{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_dialogflow_cx_v3beta1_conversation_history_proto_msgTypes[8]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *Conversation_Metrics_QueryInputCount) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*Conversation_Metrics_QueryInputCount) ProtoMessage() {}

func (x *Conversation_Metrics_QueryInputCount) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_dialogflow_cx_v3beta1_conversation_history_proto_msgTypes[8]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use Conversation_Metrics_QueryInputCount.ProtoReflect.Descriptor instead.
func (*Conversation_Metrics_QueryInputCount) Descriptor() ([]byte, []int) {
	return file_google_cloud_dialogflow_cx_v3beta1_conversation_history_proto_rawDescGZIP(), []int{4, 0, 0}
}

func (x *Conversation_Metrics_QueryInputCount) GetTextCount() int32 {
	if x != nil {
		return x.TextCount
	}
	return 0
}

func (x *Conversation_Metrics_QueryInputCount) GetIntentCount() int32 {
	if x != nil {
		return x.IntentCount
	}
	return 0
}

func (x *Conversation_Metrics_QueryInputCount) GetAudioCount() int32 {
	if x != nil {
		return x.AudioCount
	}
	return 0
}

func (x *Conversation_Metrics_QueryInputCount) GetEventCount() int32 {
	if x != nil {
		return x.EventCount
	}
	return 0
}

func (x *Conversation_Metrics_QueryInputCount) GetDtmfCount() int32 {
	if x != nil {
		return x.DtmfCount
	}
	return 0
}

// Count by
// [Match.MatchType][google.cloud.dialogflow.cx.v3beta1.Match.MatchType] of
// the matches in the conversation.
type Conversation_Metrics_MatchTypeCount struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The number of matches with type
	// [Match.MatchType.MATCH_TYPE_UNSPECIFIED][google.cloud.dialogflow.cx.v3beta1.Match.MatchType.MATCH_TYPE_UNSPECIFIED].
	UnspecifiedCount int32 `protobuf:"varint,1,opt,name=unspecified_count,json=unspecifiedCount,proto3" json:"unspecified_count,omitempty"`
	// The number of matches with type
	// [Match.MatchType.INTENT][google.cloud.dialogflow.cx.v3beta1.Match.MatchType.INTENT].
	IntentCount int32 `protobuf:"varint,2,opt,name=intent_count,json=intentCount,proto3" json:"intent_count,omitempty"`
	// The number of matches with type
	// [Match.MatchType.DIRECT_INTENT][google.cloud.dialogflow.cx.v3beta1.Match.MatchType.DIRECT_INTENT].
	DirectIntentCount int32 `protobuf:"varint,3,opt,name=direct_intent_count,json=directIntentCount,proto3" json:"direct_intent_count,omitempty"`
	// The number of matches with type
	// [Match.MatchType.PARAMETER_FILLING][google.cloud.dialogflow.cx.v3beta1.Match.MatchType.PARAMETER_FILLING].
	ParameterFillingCount int32 `protobuf:"varint,4,opt,name=parameter_filling_count,json=parameterFillingCount,proto3" json:"parameter_filling_count,omitempty"`
	// The number of matches with type
	// [Match.MatchType.NO_MATCH][google.cloud.dialogflow.cx.v3beta1.Match.MatchType.NO_MATCH].
	NoMatchCount int32 `protobuf:"varint,5,opt,name=no_match_count,json=noMatchCount,proto3" json:"no_match_count,omitempty"`
	// The number of matches with type
	// [Match.MatchType.NO_INPUT][google.cloud.dialogflow.cx.v3beta1.Match.MatchType.NO_INPUT].
	NoInputCount int32 `protobuf:"varint,6,opt,name=no_input_count,json=noInputCount,proto3" json:"no_input_count,omitempty"`
	// The number of matches with type
	// [Match.MatchType.EVENT][google.cloud.dialogflow.cx.v3beta1.Match.MatchType.EVENT].
	EventCount int32 `protobuf:"varint,7,opt,name=event_count,json=eventCount,proto3" json:"event_count,omitempty"`
}

func (x *Conversation_Metrics_MatchTypeCount) Reset() {
	*x = Conversation_Metrics_MatchTypeCount{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_dialogflow_cx_v3beta1_conversation_history_proto_msgTypes[9]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *Conversation_Metrics_MatchTypeCount) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*Conversation_Metrics_MatchTypeCount) ProtoMessage() {}

func (x *Conversation_Metrics_MatchTypeCount) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_dialogflow_cx_v3beta1_conversation_history_proto_msgTypes[9]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use Conversation_Metrics_MatchTypeCount.ProtoReflect.Descriptor instead.
func (*Conversation_Metrics_MatchTypeCount) Descriptor() ([]byte, []int) {
	return file_google_cloud_dialogflow_cx_v3beta1_conversation_history_proto_rawDescGZIP(), []int{4, 0, 1}
}

func (x *Conversation_Metrics_MatchTypeCount) GetUnspecifiedCount() int32 {
	if x != nil {
		return x.UnspecifiedCount
	}
	return 0
}

func (x *Conversation_Metrics_MatchTypeCount) GetIntentCount() int32 {
	if x != nil {
		return x.IntentCount
	}
	return 0
}

func (x *Conversation_Metrics_MatchTypeCount) GetDirectIntentCount() int32 {
	if x != nil {
		return x.DirectIntentCount
	}
	return 0
}

func (x *Conversation_Metrics_MatchTypeCount) GetParameterFillingCount() int32 {
	if x != nil {
		return x.ParameterFillingCount
	}
	return 0
}

func (x *Conversation_Metrics_MatchTypeCount) GetNoMatchCount() int32 {
	if x != nil {
		return x.NoMatchCount
	}
	return 0
}

func (x *Conversation_Metrics_MatchTypeCount) GetNoInputCount() int32 {
	if x != nil {
		return x.NoInputCount
	}
	return 0
}

func (x *Conversation_Metrics_MatchTypeCount) GetEventCount() int32 {
	if x != nil {
		return x.EventCount
	}
	return 0
}

// Information collected for DF CX agents in case NLU predicted an intent
// that was filtered out as being inactive which may indicate a missing
// transition and/or absent functionality.
type Conversation_Interaction_MissingTransition struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Name of the intent that could have triggered.
	IntentDisplayName string `protobuf:"bytes,1,opt,name=intent_display_name,json=intentDisplayName,proto3" json:"intent_display_name,omitempty"`
	// Score of the above intent. The higher it is the more likely a
	// transition was missed on a given page.
	Score float32 `protobuf:"fixed32,2,opt,name=score,proto3" json:"score,omitempty"`
}

func (x *Conversation_Interaction_MissingTransition) Reset() {
	*x = Conversation_Interaction_MissingTransition{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_dialogflow_cx_v3beta1_conversation_history_proto_msgTypes[10]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *Conversation_Interaction_MissingTransition) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*Conversation_Interaction_MissingTransition) ProtoMessage() {}

func (x *Conversation_Interaction_MissingTransition) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_dialogflow_cx_v3beta1_conversation_history_proto_msgTypes[10]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use Conversation_Interaction_MissingTransition.ProtoReflect.Descriptor instead.
func (*Conversation_Interaction_MissingTransition) Descriptor() ([]byte, []int) {
	return file_google_cloud_dialogflow_cx_v3beta1_conversation_history_proto_rawDescGZIP(), []int{4, 1, 0}
}

func (x *Conversation_Interaction_MissingTransition) GetIntentDisplayName() string {
	if x != nil {
		return x.IntentDisplayName
	}
	return ""
}

func (x *Conversation_Interaction_MissingTransition) GetScore() float32 {
	if x != nil {
		return x.Score
	}
	return 0
}

var File_google_cloud_dialogflow_cx_v3beta1_conversation_history_proto protoreflect.FileDescriptor

var file_google_cloud_dialogflow_cx_v3beta1_conversation_history_proto_rawDesc = []byte{
	0x0a, 0x3d, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2f, 0x64,
	0x69, 0x61, 0x6c, 0x6f, 0x67, 0x66, 0x6c, 0x6f, 0x77, 0x2f, 0x63, 0x78, 0x2f, 0x76, 0x33, 0x62,
	0x65, 0x74, 0x61, 0x31, 0x2f, 0x63, 0x6f, 0x6e, 0x76, 0x65, 0x72, 0x73, 0x61, 0x74, 0x69, 0x6f,
	0x6e, 0x5f, 0x68, 0x69, 0x73, 0x74, 0x6f, 0x72, 0x79, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x12,
	0x22, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x64, 0x69,
	0x61, 0x6c, 0x6f, 0x67, 0x66, 0x6c, 0x6f, 0x77, 0x2e, 0x63, 0x78, 0x2e, 0x76, 0x33, 0x62, 0x65,
	0x74, 0x61, 0x31, 0x1a, 0x1c, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x61, 0x70, 0x69, 0x2f,
	0x61, 0x6e, 0x6e, 0x6f, 0x74, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2e, 0x70, 0x72, 0x6f, 0x74,
	0x6f, 0x1a, 0x17, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x61, 0x70, 0x69, 0x2f, 0x63, 0x6c,
	0x69, 0x65, 0x6e, 0x74, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x1f, 0x67, 0x6f, 0x6f, 0x67,
	0x6c, 0x65, 0x2f, 0x61, 0x70, 0x69, 0x2f, 0x66, 0x69, 0x65, 0x6c, 0x64, 0x5f, 0x62, 0x65, 0x68,
	0x61, 0x76, 0x69, 0x6f, 0x72, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x19, 0x67, 0x6f, 0x6f,
	0x67, 0x6c, 0x65, 0x2f, 0x61, 0x70, 0x69, 0x2f, 0x72, 0x65, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65,
	0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x34, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x63,
	0x6c, 0x6f, 0x75, 0x64, 0x2f, 0x64, 0x69, 0x61, 0x6c, 0x6f, 0x67, 0x66, 0x6c, 0x6f, 0x77, 0x2f,
	0x63, 0x78, 0x2f, 0x76, 0x33, 0x62, 0x65, 0x74, 0x61, 0x31, 0x2f, 0x65, 0x6e, 0x76, 0x69, 0x72,
	0x6f, 0x6e, 0x6d, 0x65, 0x6e, 0x74, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x2d, 0x67, 0x6f,
	0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2f, 0x64, 0x69, 0x61, 0x6c, 0x6f,
	0x67, 0x66, 0x6c, 0x6f, 0x77, 0x2f, 0x63, 0x78, 0x2f, 0x76, 0x33, 0x62, 0x65, 0x74, 0x61, 0x31,
	0x2f, 0x66, 0x6c, 0x6f, 0x77, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x2f, 0x67, 0x6f, 0x6f,
	0x67, 0x6c, 0x65, 0x2f, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2f, 0x64, 0x69, 0x61, 0x6c, 0x6f, 0x67,
	0x66, 0x6c, 0x6f, 0x77, 0x2f, 0x63, 0x78, 0x2f, 0x76, 0x33, 0x62, 0x65, 0x74, 0x61, 0x31, 0x2f,
	0x69, 0x6e, 0x74, 0x65, 0x6e, 0x74, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x2d, 0x67, 0x6f,
	0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2f, 0x64, 0x69, 0x61, 0x6c, 0x6f,
	0x67, 0x66, 0x6c, 0x6f, 0x77, 0x2f, 0x63, 0x78, 0x2f, 0x76, 0x33, 0x62, 0x65, 0x74, 0x61, 0x31,
	0x2f, 0x70, 0x61, 0x67, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x30, 0x67, 0x6f, 0x6f,
	0x67, 0x6c, 0x65, 0x2f, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2f, 0x64, 0x69, 0x61, 0x6c, 0x6f, 0x67,
	0x66, 0x6c, 0x6f, 0x77, 0x2f, 0x63, 0x78, 0x2f, 0x76, 0x33, 0x62, 0x65, 0x74, 0x61, 0x31, 0x2f,
	0x73, 0x65, 0x73, 0x73, 0x69, 0x6f, 0x6e, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x1e, 0x67,
	0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2f, 0x64,
	0x75, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x1b, 0x67,
	0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2f, 0x65,
	0x6d, 0x70, 0x74, 0x79, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x1f, 0x67, 0x6f, 0x6f, 0x67,
	0x6c, 0x65, 0x2f, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2f, 0x74, 0x69, 0x6d, 0x65,
	0x73, 0x74, 0x61, 0x6d, 0x70, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x22, 0x5c, 0x0a, 0x16, 0x47,
	0x65, 0x74, 0x43, 0x6f, 0x6e, 0x76, 0x65, 0x72, 0x73, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x52, 0x65,
	0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x42, 0x0a, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x18, 0x01, 0x20,
	0x01, 0x28, 0x09, 0x42, 0x2e, 0xe0, 0x41, 0x02, 0xfa, 0x41, 0x28, 0x0a, 0x26, 0x64, 0x69, 0x61,
	0x6c, 0x6f, 0x67, 0x66, 0x6c, 0x6f, 0x77, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70,
	0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x43, 0x6f, 0x6e, 0x76, 0x65, 0x72, 0x73, 0x61, 0x74,
	0x69, 0x6f, 0x6e, 0x52, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x22, 0x5f, 0x0a, 0x19, 0x44, 0x65, 0x6c,
	0x65, 0x74, 0x65, 0x43, 0x6f, 0x6e, 0x76, 0x65, 0x72, 0x73, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x52,
	0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x42, 0x0a, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x18, 0x01,
	0x20, 0x01, 0x28, 0x09, 0x42, 0x2e, 0xe0, 0x41, 0x02, 0xfa, 0x41, 0x28, 0x0a, 0x26, 0x64, 0x69,
	0x61, 0x6c, 0x6f, 0x67, 0x66, 0x6c, 0x6f, 0x77, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61,
	0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x43, 0x6f, 0x6e, 0x76, 0x65, 0x72, 0x73, 0x61,
	0x74, 0x69, 0x6f, 0x6e, 0x52, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x22, 0xc5, 0x01, 0x0a, 0x18, 0x4c,
	0x69, 0x73, 0x74, 0x43, 0x6f, 0x6e, 0x76, 0x65, 0x72, 0x73, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73,
	0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x46, 0x0a, 0x06, 0x70, 0x61, 0x72, 0x65, 0x6e,
	0x74, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x2e, 0xe0, 0x41, 0x02, 0xfa, 0x41, 0x28, 0x12,
	0x26, 0x64, 0x69, 0x61, 0x6c, 0x6f, 0x67, 0x66, 0x6c, 0x6f, 0x77, 0x2e, 0x67, 0x6f, 0x6f, 0x67,
	0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x43, 0x6f, 0x6e, 0x76, 0x65,
	0x72, 0x73, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x52, 0x06, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x12,
	0x1b, 0x0a, 0x06, 0x66, 0x69, 0x6c, 0x74, 0x65, 0x72, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x42,
	0x03, 0xe0, 0x41, 0x01, 0x52, 0x06, 0x66, 0x69, 0x6c, 0x74, 0x65, 0x72, 0x12, 0x20, 0x0a, 0x09,
	0x70, 0x61, 0x67, 0x65, 0x5f, 0x73, 0x69, 0x7a, 0x65, 0x18, 0x03, 0x20, 0x01, 0x28, 0x05, 0x42,
	0x03, 0xe0, 0x41, 0x01, 0x52, 0x08, 0x70, 0x61, 0x67, 0x65, 0x53, 0x69, 0x7a, 0x65, 0x12, 0x22,
	0x0a, 0x0a, 0x70, 0x61, 0x67, 0x65, 0x5f, 0x74, 0x6f, 0x6b, 0x65, 0x6e, 0x18, 0x04, 0x20, 0x01,
	0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x52, 0x09, 0x70, 0x61, 0x67, 0x65, 0x54, 0x6f, 0x6b,
	0x65, 0x6e, 0x22, 0x9b, 0x01, 0x0a, 0x19, 0x4c, 0x69, 0x73, 0x74, 0x43, 0x6f, 0x6e, 0x76, 0x65,
	0x72, 0x73, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65,
	0x12, 0x56, 0x0a, 0x0d, 0x63, 0x6f, 0x6e, 0x76, 0x65, 0x72, 0x73, 0x61, 0x74, 0x69, 0x6f, 0x6e,
	0x73, 0x18, 0x01, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x30, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65,
	0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x64, 0x69, 0x61, 0x6c, 0x6f, 0x67, 0x66, 0x6c, 0x6f,
	0x77, 0x2e, 0x63, 0x78, 0x2e, 0x76, 0x33, 0x62, 0x65, 0x74, 0x61, 0x31, 0x2e, 0x43, 0x6f, 0x6e,
	0x76, 0x65, 0x72, 0x73, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x52, 0x0d, 0x63, 0x6f, 0x6e, 0x76, 0x65,
	0x72, 0x73, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x12, 0x26, 0x0a, 0x0f, 0x6e, 0x65, 0x78, 0x74,
	0x5f, 0x70, 0x61, 0x67, 0x65, 0x5f, 0x74, 0x6f, 0x6b, 0x65, 0x6e, 0x18, 0x02, 0x20, 0x01, 0x28,
	0x09, 0x52, 0x0d, 0x6e, 0x65, 0x78, 0x74, 0x50, 0x61, 0x67, 0x65, 0x54, 0x6f, 0x6b, 0x65, 0x6e,
	0x22, 0x96, 0x17, 0x0a, 0x0c, 0x43, 0x6f, 0x6e, 0x76, 0x65, 0x72, 0x73, 0x61, 0x74, 0x69, 0x6f,
	0x6e, 0x12, 0x17, 0x0a, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42,
	0x03, 0xe0, 0x41, 0x08, 0x52, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x12, 0x49, 0x0a, 0x04, 0x74, 0x79,
	0x70, 0x65, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0e, 0x32, 0x35, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c,
	0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x64, 0x69, 0x61, 0x6c, 0x6f, 0x67, 0x66, 0x6c,
	0x6f, 0x77, 0x2e, 0x63, 0x78, 0x2e, 0x76, 0x33, 0x62, 0x65, 0x74, 0x61, 0x31, 0x2e, 0x43, 0x6f,
	0x6e, 0x76, 0x65, 0x72, 0x73, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x2e, 0x54, 0x79, 0x70, 0x65, 0x52,
	0x04, 0x74, 0x79, 0x70, 0x65, 0x12, 0x23, 0x0a, 0x0d, 0x6c, 0x61, 0x6e, 0x67, 0x75, 0x61, 0x67,
	0x65, 0x5f, 0x63, 0x6f, 0x64, 0x65, 0x18, 0x03, 0x20, 0x01, 0x28, 0x09, 0x52, 0x0c, 0x6c, 0x61,
	0x6e, 0x67, 0x75, 0x61, 0x67, 0x65, 0x43, 0x6f, 0x64, 0x65, 0x12, 0x39, 0x0a, 0x0a, 0x73, 0x74,
	0x61, 0x72, 0x74, 0x5f, 0x74, 0x69, 0x6d, 0x65, 0x18, 0x04, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1a,
	0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66,
	0x2e, 0x54, 0x69, 0x6d, 0x65, 0x73, 0x74, 0x61, 0x6d, 0x70, 0x52, 0x09, 0x73, 0x74, 0x61, 0x72,
	0x74, 0x54, 0x69, 0x6d, 0x65, 0x12, 0x35, 0x0a, 0x08, 0x64, 0x75, 0x72, 0x61, 0x74, 0x69, 0x6f,
	0x6e, 0x18, 0x05, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x19, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65,
	0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x44, 0x75, 0x72, 0x61, 0x74, 0x69,
	0x6f, 0x6e, 0x52, 0x08, 0x64, 0x75, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x12, 0x52, 0x0a, 0x07,
	0x6d, 0x65, 0x74, 0x72, 0x69, 0x63, 0x73, 0x18, 0x06, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x38, 0x2e,
	0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x64, 0x69, 0x61,
	0x6c, 0x6f, 0x67, 0x66, 0x6c, 0x6f, 0x77, 0x2e, 0x63, 0x78, 0x2e, 0x76, 0x33, 0x62, 0x65, 0x74,
	0x61, 0x31, 0x2e, 0x43, 0x6f, 0x6e, 0x76, 0x65, 0x72, 0x73, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x2e,
	0x4d, 0x65, 0x74, 0x72, 0x69, 0x63, 0x73, 0x52, 0x07, 0x6d, 0x65, 0x74, 0x72, 0x69, 0x63, 0x73,
	0x12, 0x44, 0x0a, 0x07, 0x69, 0x6e, 0x74, 0x65, 0x6e, 0x74, 0x73, 0x18, 0x07, 0x20, 0x03, 0x28,
	0x0b, 0x32, 0x2a, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64,
	0x2e, 0x64, 0x69, 0x61, 0x6c, 0x6f, 0x67, 0x66, 0x6c, 0x6f, 0x77, 0x2e, 0x63, 0x78, 0x2e, 0x76,
	0x33, 0x62, 0x65, 0x74, 0x61, 0x31, 0x2e, 0x49, 0x6e, 0x74, 0x65, 0x6e, 0x74, 0x52, 0x07, 0x69,
	0x6e, 0x74, 0x65, 0x6e, 0x74, 0x73, 0x12, 0x3e, 0x0a, 0x05, 0x66, 0x6c, 0x6f, 0x77, 0x73, 0x18,
	0x08, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x28, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63,
	0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x64, 0x69, 0x61, 0x6c, 0x6f, 0x67, 0x66, 0x6c, 0x6f, 0x77, 0x2e,
	0x63, 0x78, 0x2e, 0x76, 0x33, 0x62, 0x65, 0x74, 0x61, 0x31, 0x2e, 0x46, 0x6c, 0x6f, 0x77, 0x52,
	0x05, 0x66, 0x6c, 0x6f, 0x77, 0x73, 0x12, 0x3e, 0x0a, 0x05, 0x70, 0x61, 0x67, 0x65, 0x73, 0x18,
	0x09, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x28, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63,
	0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x64, 0x69, 0x61, 0x6c, 0x6f, 0x67, 0x66, 0x6c, 0x6f, 0x77, 0x2e,
	0x63, 0x78, 0x2e, 0x76, 0x33, 0x62, 0x65, 0x74, 0x61, 0x31, 0x2e, 0x50, 0x61, 0x67, 0x65, 0x52,
	0x05, 0x70, 0x61, 0x67, 0x65, 0x73, 0x12, 0x60, 0x0a, 0x0c, 0x69, 0x6e, 0x74, 0x65, 0x72, 0x61,
	0x63, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x18, 0x0a, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x3c, 0x2e, 0x67,
	0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x64, 0x69, 0x61, 0x6c,
	0x6f, 0x67, 0x66, 0x6c, 0x6f, 0x77, 0x2e, 0x63, 0x78, 0x2e, 0x76, 0x33, 0x62, 0x65, 0x74, 0x61,
	0x31, 0x2e, 0x43, 0x6f, 0x6e, 0x76, 0x65, 0x72, 0x73, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x2e, 0x49,
	0x6e, 0x74, 0x65, 0x72, 0x61, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x52, 0x0c, 0x69, 0x6e, 0x74, 0x65,
	0x72, 0x61, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x12, 0x51, 0x0a, 0x0b, 0x65, 0x6e, 0x76, 0x69,
	0x72, 0x6f, 0x6e, 0x6d, 0x65, 0x6e, 0x74, 0x18, 0x0b, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x2f, 0x2e,
	0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x64, 0x69, 0x61,
	0x6c, 0x6f, 0x67, 0x66, 0x6c, 0x6f, 0x77, 0x2e, 0x63, 0x78, 0x2e, 0x76, 0x33, 0x62, 0x65, 0x74,
	0x61, 0x31, 0x2e, 0x45, 0x6e, 0x76, 0x69, 0x72, 0x6f, 0x6e, 0x6d, 0x65, 0x6e, 0x74, 0x52, 0x0b,
	0x65, 0x6e, 0x76, 0x69, 0x72, 0x6f, 0x6e, 0x6d, 0x65, 0x6e, 0x74, 0x12, 0x67, 0x0a, 0x0d, 0x66,
	0x6c, 0x6f, 0x77, 0x5f, 0x76, 0x65, 0x72, 0x73, 0x69, 0x6f, 0x6e, 0x73, 0x18, 0x0c, 0x20, 0x03,
	0x28, 0x0b, 0x32, 0x42, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75,
	0x64, 0x2e, 0x64, 0x69, 0x61, 0x6c, 0x6f, 0x67, 0x66, 0x6c, 0x6f, 0x77, 0x2e, 0x63, 0x78, 0x2e,
	0x76, 0x33, 0x62, 0x65, 0x74, 0x61, 0x31, 0x2e, 0x43, 0x6f, 0x6e, 0x76, 0x65, 0x72, 0x73, 0x61,
	0x74, 0x69, 0x6f, 0x6e, 0x2e, 0x46, 0x6c, 0x6f, 0x77, 0x56, 0x65, 0x72, 0x73, 0x69, 0x6f, 0x6e,
	0x73, 0x45, 0x6e, 0x74, 0x72, 0x79, 0x52, 0x0c, 0x66, 0x6c, 0x6f, 0x77, 0x56, 0x65, 0x72, 0x73,
	0x69, 0x6f, 0x6e, 0x73, 0x1a, 0x94, 0x09, 0x0a, 0x07, 0x4d, 0x65, 0x74, 0x72, 0x69, 0x63, 0x73,
	0x12, 0x2b, 0x0a, 0x11, 0x69, 0x6e, 0x74, 0x65, 0x72, 0x61, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x5f,
	0x63, 0x6f, 0x75, 0x6e, 0x74, 0x18, 0x01, 0x20, 0x01, 0x28, 0x05, 0x52, 0x10, 0x69, 0x6e, 0x74,
	0x65, 0x72, 0x61, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x43, 0x6f, 0x75, 0x6e, 0x74, 0x12, 0x4b, 0x0a,
	0x14, 0x69, 0x6e, 0x70, 0x75, 0x74, 0x5f, 0x61, 0x75, 0x64, 0x69, 0x6f, 0x5f, 0x64, 0x75, 0x72,
	0x61, 0x74, 0x69, 0x6f, 0x6e, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x19, 0x2e, 0x67, 0x6f,
	0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x44, 0x75,
	0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x52, 0x12, 0x69, 0x6e, 0x70, 0x75, 0x74, 0x41, 0x75, 0x64,
	0x69, 0x6f, 0x44, 0x75, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x12, 0x4d, 0x0a, 0x15, 0x6f, 0x75,
	0x74, 0x70, 0x75, 0x74, 0x5f, 0x61, 0x75, 0x64, 0x69, 0x6f, 0x5f, 0x64, 0x75, 0x72, 0x61, 0x74,
	0x69, 0x6f, 0x6e, 0x18, 0x03, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x19, 0x2e, 0x67, 0x6f, 0x6f, 0x67,
	0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x44, 0x75, 0x72, 0x61,
	0x74, 0x69, 0x6f, 0x6e, 0x52, 0x13, 0x6f, 0x75, 0x74, 0x70, 0x75, 0x74, 0x41, 0x75, 0x64, 0x69,
	0x6f, 0x44, 0x75, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x12, 0x49, 0x0a, 0x13, 0x6d, 0x61, 0x78,
	0x5f, 0x77, 0x65, 0x62, 0x68, 0x6f, 0x6f, 0x6b, 0x5f, 0x6c, 0x61, 0x74, 0x65, 0x6e, 0x63, 0x79,
	0x18, 0x04, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x19, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e,
	0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x44, 0x75, 0x72, 0x61, 0x74, 0x69, 0x6f,
	0x6e, 0x52, 0x11, 0x6d, 0x61, 0x78, 0x57, 0x65, 0x62, 0x68, 0x6f, 0x6f, 0x6b, 0x4c, 0x61, 0x74,
	0x65, 0x6e, 0x63, 0x79, 0x12, 0x2e, 0x0a, 0x13, 0x68, 0x61, 0x73, 0x5f, 0x65, 0x6e, 0x64, 0x5f,
	0x69, 0x6e, 0x74, 0x65, 0x72, 0x61, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x18, 0x05, 0x20, 0x01, 0x28,
	0x08, 0x52, 0x11, 0x68, 0x61, 0x73, 0x45, 0x6e, 0x64, 0x49, 0x6e, 0x74, 0x65, 0x72, 0x61, 0x63,
	0x74, 0x69, 0x6f, 0x6e, 0x12, 0x33, 0x0a, 0x16, 0x68, 0x61, 0x73, 0x5f, 0x6c, 0x69, 0x76, 0x65,
	0x5f, 0x61, 0x67, 0x65, 0x6e, 0x74, 0x5f, 0x68, 0x61, 0x6e, 0x64, 0x6f, 0x66, 0x66, 0x18, 0x06,
	0x20, 0x01, 0x28, 0x08, 0x52, 0x13, 0x68, 0x61, 0x73, 0x4c, 0x69, 0x76, 0x65, 0x41, 0x67, 0x65,
	0x6e, 0x74, 0x48, 0x61, 0x6e, 0x64, 0x6f, 0x66, 0x66, 0x12, 0x38, 0x0a, 0x18, 0x61, 0x76, 0x65,
	0x72, 0x61, 0x67, 0x65, 0x5f, 0x6d, 0x61, 0x74, 0x63, 0x68, 0x5f, 0x63, 0x6f, 0x6e, 0x66, 0x69,
	0x64, 0x65, 0x6e, 0x63, 0x65, 0x18, 0x07, 0x20, 0x01, 0x28, 0x02, 0x52, 0x16, 0x61, 0x76, 0x65,
	0x72, 0x61, 0x67, 0x65, 0x4d, 0x61, 0x74, 0x63, 0x68, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x64, 0x65,
	0x6e, 0x63, 0x65, 0x12, 0x74, 0x0a, 0x11, 0x71, 0x75, 0x65, 0x72, 0x79, 0x5f, 0x69, 0x6e, 0x70,
	0x75, 0x74, 0x5f, 0x63, 0x6f, 0x75, 0x6e, 0x74, 0x18, 0x08, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x48,
	0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x64, 0x69,
	0x61, 0x6c, 0x6f, 0x67, 0x66, 0x6c, 0x6f, 0x77, 0x2e, 0x63, 0x78, 0x2e, 0x76, 0x33, 0x62, 0x65,
	0x74, 0x61, 0x31, 0x2e, 0x43, 0x6f, 0x6e, 0x76, 0x65, 0x72, 0x73, 0x61, 0x74, 0x69, 0x6f, 0x6e,
	0x2e, 0x4d, 0x65, 0x74, 0x72, 0x69, 0x63, 0x73, 0x2e, 0x51, 0x75, 0x65, 0x72, 0x79, 0x49, 0x6e,
	0x70, 0x75, 0x74, 0x43, 0x6f, 0x75, 0x6e, 0x74, 0x52, 0x0f, 0x71, 0x75, 0x65, 0x72, 0x79, 0x49,
	0x6e, 0x70, 0x75, 0x74, 0x43, 0x6f, 0x75, 0x6e, 0x74, 0x12, 0x71, 0x0a, 0x10, 0x6d, 0x61, 0x74,
	0x63, 0x68, 0x5f, 0x74, 0x79, 0x70, 0x65, 0x5f, 0x63, 0x6f, 0x75, 0x6e, 0x74, 0x18, 0x09, 0x20,
	0x01, 0x28, 0x0b, 0x32, 0x47, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f,
	0x75, 0x64, 0x2e, 0x64, 0x69, 0x61, 0x6c, 0x6f, 0x67, 0x66, 0x6c, 0x6f, 0x77, 0x2e, 0x63, 0x78,
	0x2e, 0x76, 0x33, 0x62, 0x65, 0x74, 0x61, 0x31, 0x2e, 0x43, 0x6f, 0x6e, 0x76, 0x65, 0x72, 0x73,
	0x61, 0x74, 0x69, 0x6f, 0x6e, 0x2e, 0x4d, 0x65, 0x74, 0x72, 0x69, 0x63, 0x73, 0x2e, 0x4d, 0x61,
	0x74, 0x63, 0x68, 0x54, 0x79, 0x70, 0x65, 0x43, 0x6f, 0x75, 0x6e, 0x74, 0x52, 0x0e, 0x6d, 0x61,
	0x74, 0x63, 0x68, 0x54, 0x79, 0x70, 0x65, 0x43, 0x6f, 0x75, 0x6e, 0x74, 0x1a, 0xb4, 0x01, 0x0a,
	0x0f, 0x51, 0x75, 0x65, 0x72, 0x79, 0x49, 0x6e, 0x70, 0x75, 0x74, 0x43, 0x6f, 0x75, 0x6e, 0x74,
	0x12, 0x1d, 0x0a, 0x0a, 0x74, 0x65, 0x78, 0x74, 0x5f, 0x63, 0x6f, 0x75, 0x6e, 0x74, 0x18, 0x01,
	0x20, 0x01, 0x28, 0x05, 0x52, 0x09, 0x74, 0x65, 0x78, 0x74, 0x43, 0x6f, 0x75, 0x6e, 0x74, 0x12,
	0x21, 0x0a, 0x0c, 0x69, 0x6e, 0x74, 0x65, 0x6e, 0x74, 0x5f, 0x63, 0x6f, 0x75, 0x6e, 0x74, 0x18,
	0x02, 0x20, 0x01, 0x28, 0x05, 0x52, 0x0b, 0x69, 0x6e, 0x74, 0x65, 0x6e, 0x74, 0x43, 0x6f, 0x75,
	0x6e, 0x74, 0x12, 0x1f, 0x0a, 0x0b, 0x61, 0x75, 0x64, 0x69, 0x6f, 0x5f, 0x63, 0x6f, 0x75, 0x6e,
	0x74, 0x18, 0x03, 0x20, 0x01, 0x28, 0x05, 0x52, 0x0a, 0x61, 0x75, 0x64, 0x69, 0x6f, 0x43, 0x6f,
	0x75, 0x6e, 0x74, 0x12, 0x1f, 0x0a, 0x0b, 0x65, 0x76, 0x65, 0x6e, 0x74, 0x5f, 0x63, 0x6f, 0x75,
	0x6e, 0x74, 0x18, 0x04, 0x20, 0x01, 0x28, 0x05, 0x52, 0x0a, 0x65, 0x76, 0x65, 0x6e, 0x74, 0x43,
	0x6f, 0x75, 0x6e, 0x74, 0x12, 0x1d, 0x0a, 0x0a, 0x64, 0x74, 0x6d, 0x66, 0x5f, 0x63, 0x6f, 0x75,
	0x6e, 0x74, 0x18, 0x05, 0x20, 0x01, 0x28, 0x05, 0x52, 0x09, 0x64, 0x74, 0x6d, 0x66, 0x43, 0x6f,
	0x75, 0x6e, 0x74, 0x1a, 0xb5, 0x02, 0x0a, 0x0e, 0x4d, 0x61, 0x74, 0x63, 0x68, 0x54, 0x79, 0x70,
	0x65, 0x43, 0x6f, 0x75, 0x6e, 0x74, 0x12, 0x2b, 0x0a, 0x11, 0x75, 0x6e, 0x73, 0x70, 0x65, 0x63,
	0x69, 0x66, 0x69, 0x65, 0x64, 0x5f, 0x63, 0x6f, 0x75, 0x6e, 0x74, 0x18, 0x01, 0x20, 0x01, 0x28,
	0x05, 0x52, 0x10, 0x75, 0x6e, 0x73, 0x70, 0x65, 0x63, 0x69, 0x66, 0x69, 0x65, 0x64, 0x43, 0x6f,
	0x75, 0x6e, 0x74, 0x12, 0x21, 0x0a, 0x0c, 0x69, 0x6e, 0x74, 0x65, 0x6e, 0x74, 0x5f, 0x63, 0x6f,
	0x75, 0x6e, 0x74, 0x18, 0x02, 0x20, 0x01, 0x28, 0x05, 0x52, 0x0b, 0x69, 0x6e, 0x74, 0x65, 0x6e,
	0x74, 0x43, 0x6f, 0x75, 0x6e, 0x74, 0x12, 0x2e, 0x0a, 0x13, 0x64, 0x69, 0x72, 0x65, 0x63, 0x74,
	0x5f, 0x69, 0x6e, 0x74, 0x65, 0x6e, 0x74, 0x5f, 0x63, 0x6f, 0x75, 0x6e, 0x74, 0x18, 0x03, 0x20,
	0x01, 0x28, 0x05, 0x52, 0x11, 0x64, 0x69, 0x72, 0x65, 0x63, 0x74, 0x49, 0x6e, 0x74, 0x65, 0x6e,
	0x74, 0x43, 0x6f, 0x75, 0x6e, 0x74, 0x12, 0x36, 0x0a, 0x17, 0x70, 0x61, 0x72, 0x61, 0x6d, 0x65,
	0x74, 0x65, 0x72, 0x5f, 0x66, 0x69, 0x6c, 0x6c, 0x69, 0x6e, 0x67, 0x5f, 0x63, 0x6f, 0x75, 0x6e,
	0x74, 0x18, 0x04, 0x20, 0x01, 0x28, 0x05, 0x52, 0x15, 0x70, 0x61, 0x72, 0x61, 0x6d, 0x65, 0x74,
	0x65, 0x72, 0x46, 0x69, 0x6c, 0x6c, 0x69, 0x6e, 0x67, 0x43, 0x6f, 0x75, 0x6e, 0x74, 0x12, 0x24,
	0x0a, 0x0e, 0x6e, 0x6f, 0x5f, 0x6d, 0x61, 0x74, 0x63, 0x68, 0x5f, 0x63, 0x6f, 0x75, 0x6e, 0x74,
	0x18, 0x05, 0x20, 0x01, 0x28, 0x05, 0x52, 0x0c, 0x6e, 0x6f, 0x4d, 0x61, 0x74, 0x63, 0x68, 0x43,
	0x6f, 0x75, 0x6e, 0x74, 0x12, 0x24, 0x0a, 0x0e, 0x6e, 0x6f, 0x5f, 0x69, 0x6e, 0x70, 0x75, 0x74,
	0x5f, 0x63, 0x6f, 0x75, 0x6e, 0x74, 0x18, 0x06, 0x20, 0x01, 0x28, 0x05, 0x52, 0x0c, 0x6e, 0x6f,
	0x49, 0x6e, 0x70, 0x75, 0x74, 0x43, 0x6f, 0x75, 0x6e, 0x74, 0x12, 0x1f, 0x0a, 0x0b, 0x65, 0x76,
	0x65, 0x6e, 0x74, 0x5f, 0x63, 0x6f, 0x75, 0x6e, 0x74, 0x18, 0x07, 0x20, 0x01, 0x28, 0x05, 0x52,
	0x0a, 0x65, 0x76, 0x65, 0x6e, 0x74, 0x43, 0x6f, 0x75, 0x6e, 0x74, 0x1a, 0x94, 0x05, 0x0a, 0x0b,
	0x49, 0x6e, 0x74, 0x65, 0x72, 0x61, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x12, 0x51, 0x0a, 0x07, 0x72,
	0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x37, 0x2e, 0x67,
	0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x64, 0x69, 0x61, 0x6c,
	0x6f, 0x67, 0x66, 0x6c, 0x6f, 0x77, 0x2e, 0x63, 0x78, 0x2e, 0x76, 0x33, 0x62, 0x65, 0x74, 0x61,
	0x31, 0x2e, 0x44, 0x65, 0x74, 0x65, 0x63, 0x74, 0x49, 0x6e, 0x74, 0x65, 0x6e, 0x74, 0x52, 0x65,
	0x71, 0x75, 0x65, 0x73, 0x74, 0x52, 0x07, 0x72, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x54,
	0x0a, 0x08, 0x72, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0b,
	0x32, 0x38, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e,
	0x64, 0x69, 0x61, 0x6c, 0x6f, 0x67, 0x66, 0x6c, 0x6f, 0x77, 0x2e, 0x63, 0x78, 0x2e, 0x76, 0x33,
	0x62, 0x65, 0x74, 0x61, 0x31, 0x2e, 0x44, 0x65, 0x74, 0x65, 0x63, 0x74, 0x49, 0x6e, 0x74, 0x65,
	0x6e, 0x74, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x52, 0x08, 0x72, 0x65, 0x73, 0x70,
	0x6f, 0x6e, 0x73, 0x65, 0x12, 0x65, 0x0a, 0x11, 0x70, 0x61, 0x72, 0x74, 0x69, 0x61, 0x6c, 0x5f,
	0x72, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x73, 0x18, 0x03, 0x20, 0x03, 0x28, 0x0b, 0x32,
	0x38, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x64,
	0x69, 0x61, 0x6c, 0x6f, 0x67, 0x66, 0x6c, 0x6f, 0x77, 0x2e, 0x63, 0x78, 0x2e, 0x76, 0x33, 0x62,
	0x65, 0x74, 0x61, 0x31, 0x2e, 0x44, 0x65, 0x74, 0x65, 0x63, 0x74, 0x49, 0x6e, 0x74, 0x65, 0x6e,
	0x74, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x52, 0x10, 0x70, 0x61, 0x72, 0x74, 0x69,
	0x61, 0x6c, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x73, 0x12, 0x2d, 0x0a, 0x12, 0x72,
	0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x5f, 0x75, 0x74, 0x74, 0x65, 0x72, 0x61, 0x6e, 0x63, 0x65,
	0x73, 0x18, 0x04, 0x20, 0x01, 0x28, 0x09, 0x52, 0x11, 0x72, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74,
	0x55, 0x74, 0x74, 0x65, 0x72, 0x61, 0x6e, 0x63, 0x65, 0x73, 0x12, 0x2f, 0x0a, 0x13, 0x72, 0x65,
	0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x5f, 0x75, 0x74, 0x74, 0x65, 0x72, 0x61, 0x6e, 0x63, 0x65,
	0x73, 0x18, 0x05, 0x20, 0x01, 0x28, 0x09, 0x52, 0x12, 0x72, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73,
	0x65, 0x55, 0x74, 0x74, 0x65, 0x72, 0x61, 0x6e, 0x63, 0x65, 0x73, 0x12, 0x3b, 0x0a, 0x0b, 0x63,
	0x72, 0x65, 0x61, 0x74, 0x65, 0x5f, 0x74, 0x69, 0x6d, 0x65, 0x18, 0x06, 0x20, 0x01, 0x28, 0x0b,
	0x32, 0x1a, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62,
	0x75, 0x66, 0x2e, 0x54, 0x69, 0x6d, 0x65, 0x73, 0x74, 0x61, 0x6d, 0x70, 0x52, 0x0a, 0x63, 0x72,
	0x65, 0x61, 0x74, 0x65, 0x54, 0x69, 0x6d, 0x65, 0x12, 0x7d, 0x0a, 0x12, 0x6d, 0x69, 0x73, 0x73,
	0x69, 0x6e, 0x67, 0x5f, 0x74, 0x72, 0x61, 0x6e, 0x73, 0x69, 0x74, 0x69, 0x6f, 0x6e, 0x18, 0x08,
	0x20, 0x01, 0x28, 0x0b, 0x32, 0x4e, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c,
	0x6f, 0x75, 0x64, 0x2e, 0x64, 0x69, 0x61, 0x6c, 0x6f, 0x67, 0x66, 0x6c, 0x6f, 0x77, 0x2e, 0x63,
	0x78, 0x2e, 0x76, 0x33, 0x62, 0x65, 0x74, 0x61, 0x31, 0x2e, 0x43, 0x6f, 0x6e, 0x76, 0x65, 0x72,
	0x73, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x2e, 0x49, 0x6e, 0x74, 0x65, 0x72, 0x61, 0x63, 0x74, 0x69,
	0x6f, 0x6e, 0x2e, 0x4d, 0x69, 0x73, 0x73, 0x69, 0x6e, 0x67, 0x54, 0x72, 0x61, 0x6e, 0x73, 0x69,
	0x74, 0x69, 0x6f, 0x6e, 0x52, 0x11, 0x6d, 0x69, 0x73, 0x73, 0x69, 0x6e, 0x67, 0x54, 0x72, 0x61,
	0x6e, 0x73, 0x69, 0x74, 0x69, 0x6f, 0x6e, 0x1a, 0x59, 0x0a, 0x11, 0x4d, 0x69, 0x73, 0x73, 0x69,
	0x6e, 0x67, 0x54, 0x72, 0x61, 0x6e, 0x73, 0x69, 0x74, 0x69, 0x6f, 0x6e, 0x12, 0x2e, 0x0a, 0x13,
	0x69, 0x6e, 0x74, 0x65, 0x6e, 0x74, 0x5f, 0x64, 0x69, 0x73, 0x70, 0x6c, 0x61, 0x79, 0x5f, 0x6e,
	0x61, 0x6d, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x11, 0x69, 0x6e, 0x74, 0x65, 0x6e,
	0x74, 0x44, 0x69, 0x73, 0x70, 0x6c, 0x61, 0x79, 0x4e, 0x61, 0x6d, 0x65, 0x12, 0x14, 0x0a, 0x05,
	0x73, 0x63, 0x6f, 0x72, 0x65, 0x18, 0x02, 0x20, 0x01, 0x28, 0x02, 0x52, 0x05, 0x73, 0x63, 0x6f,
	0x72, 0x65, 0x1a, 0x3f, 0x0a, 0x11, 0x46, 0x6c, 0x6f, 0x77, 0x56, 0x65, 0x72, 0x73, 0x69, 0x6f,
	0x6e, 0x73, 0x45, 0x6e, 0x74, 0x72, 0x79, 0x12, 0x10, 0x0a, 0x03, 0x6b, 0x65, 0x79, 0x18, 0x01,
	0x20, 0x01, 0x28, 0x09, 0x52, 0x03, 0x6b, 0x65, 0x79, 0x12, 0x14, 0x0a, 0x05, 0x76, 0x61, 0x6c,
	0x75, 0x65, 0x18, 0x02, 0x20, 0x01, 0x28, 0x03, 0x52, 0x05, 0x76, 0x61, 0x6c, 0x75, 0x65, 0x3a,
	0x02, 0x38, 0x01, 0x22, 0x43, 0x0a, 0x04, 0x54, 0x79, 0x70, 0x65, 0x12, 0x14, 0x0a, 0x10, 0x54,
	0x59, 0x50, 0x45, 0x5f, 0x55, 0x4e, 0x53, 0x50, 0x45, 0x43, 0x49, 0x46, 0x49, 0x45, 0x44, 0x10,
	0x00, 0x12, 0x09, 0x0a, 0x05, 0x41, 0x55, 0x44, 0x49, 0x4f, 0x10, 0x01, 0x12, 0x08, 0x0a, 0x04,
	0x54, 0x45, 0x58, 0x54, 0x10, 0x02, 0x12, 0x10, 0x0a, 0x0c, 0x55, 0x4e, 0x44, 0x45, 0x54, 0x45,
	0x52, 0x4d, 0x49, 0x4e, 0x45, 0x44, 0x10, 0x03, 0x3a, 0x9e, 0x01, 0xea, 0x41, 0x9a, 0x01, 0x0a,
	0x26, 0x64, 0x69, 0x61, 0x6c, 0x6f, 0x67, 0x66, 0x6c, 0x6f, 0x77, 0x2e, 0x67, 0x6f, 0x6f, 0x67,
	0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x43, 0x6f, 0x6e, 0x76, 0x65,
	0x72, 0x73, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x12, 0x53, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74,
	0x73, 0x2f, 0x7b, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x7d, 0x2f, 0x6c, 0x6f, 0x63, 0x61,
	0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x7b, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x7d,
	0x2f, 0x61, 0x67, 0x65, 0x6e, 0x74, 0x73, 0x2f, 0x7b, 0x61, 0x67, 0x65, 0x6e, 0x74, 0x7d, 0x2f,
	0x63, 0x6f, 0x6e, 0x76, 0x65, 0x72, 0x73, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x7b, 0x63,
	0x6f, 0x6e, 0x76, 0x65, 0x72, 0x73, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x7d, 0x2a, 0x0d, 0x63, 0x6f,
	0x6e, 0x76, 0x65, 0x72, 0x73, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x32, 0x0c, 0x63, 0x6f, 0x6e,
	0x76, 0x65, 0x72, 0x73, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x32, 0x84, 0x06, 0x0a, 0x13, 0x43, 0x6f,
	0x6e, 0x76, 0x65, 0x72, 0x73, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x48, 0x69, 0x73, 0x74, 0x6f, 0x72,
	0x79, 0x12, 0xe2, 0x01, 0x0a, 0x11, 0x4c, 0x69, 0x73, 0x74, 0x43, 0x6f, 0x6e, 0x76, 0x65, 0x72,
	0x73, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x12, 0x3c, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65,
	0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x64, 0x69, 0x61, 0x6c, 0x6f, 0x67, 0x66, 0x6c, 0x6f,
	0x77, 0x2e, 0x63, 0x78, 0x2e, 0x76, 0x33, 0x62, 0x65, 0x74, 0x61, 0x31, 0x2e, 0x4c, 0x69, 0x73,
	0x74, 0x43, 0x6f, 0x6e, 0x76, 0x65, 0x72, 0x73, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x52, 0x65,
	0x71, 0x75, 0x65, 0x73, 0x74, 0x1a, 0x3d, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63,
	0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x64, 0x69, 0x61, 0x6c, 0x6f, 0x67, 0x66, 0x6c, 0x6f, 0x77, 0x2e,
	0x63, 0x78, 0x2e, 0x76, 0x33, 0x62, 0x65, 0x74, 0x61, 0x31, 0x2e, 0x4c, 0x69, 0x73, 0x74, 0x43,
	0x6f, 0x6e, 0x76, 0x65, 0x72, 0x73, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x52, 0x65, 0x73, 0x70,
	0x6f, 0x6e, 0x73, 0x65, 0x22, 0x50, 0xda, 0x41, 0x06, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x82,
	0xd3, 0xe4, 0x93, 0x02, 0x41, 0x12, 0x3f, 0x2f, 0x76, 0x33, 0x62, 0x65, 0x74, 0x61, 0x31, 0x2f,
	0x7b, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x3d, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x73,
	0x2f, 0x2a, 0x2f, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x2a, 0x2f, 0x61,
	0x67, 0x65, 0x6e, 0x74, 0x73, 0x2f, 0x2a, 0x7d, 0x2f, 0x63, 0x6f, 0x6e, 0x76, 0x65, 0x72, 0x73,
	0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x12, 0xcf, 0x01, 0x0a, 0x0f, 0x47, 0x65, 0x74, 0x43, 0x6f,
	0x6e, 0x76, 0x65, 0x72, 0x73, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x12, 0x3a, 0x2e, 0x67, 0x6f, 0x6f,
	0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x64, 0x69, 0x61, 0x6c, 0x6f, 0x67,
	0x66, 0x6c, 0x6f, 0x77, 0x2e, 0x63, 0x78, 0x2e, 0x76, 0x33, 0x62, 0x65, 0x74, 0x61, 0x31, 0x2e,
	0x47, 0x65, 0x74, 0x43, 0x6f, 0x6e, 0x76, 0x65, 0x72, 0x73, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x52,
	0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x1a, 0x30, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e,
	0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x64, 0x69, 0x61, 0x6c, 0x6f, 0x67, 0x66, 0x6c, 0x6f, 0x77,
	0x2e, 0x63, 0x78, 0x2e, 0x76, 0x33, 0x62, 0x65, 0x74, 0x61, 0x31, 0x2e, 0x43, 0x6f, 0x6e, 0x76,
	0x65, 0x72, 0x73, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x22, 0x4e, 0xda, 0x41, 0x04, 0x6e, 0x61, 0x6d,
	0x65, 0x82, 0xd3, 0xe4, 0x93, 0x02, 0x41, 0x12, 0x3f, 0x2f, 0x76, 0x33, 0x62, 0x65, 0x74, 0x61,
	0x31, 0x2f, 0x7b, 0x6e, 0x61, 0x6d, 0x65, 0x3d, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x73,
	0x2f, 0x2a, 0x2f, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x2a, 0x2f, 0x61,
	0x67, 0x65, 0x6e, 0x74, 0x73, 0x2f, 0x2a, 0x2f, 0x63, 0x6f, 0x6e, 0x76, 0x65, 0x72, 0x73, 0x61,
	0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x2a, 0x7d, 0x12, 0xbb, 0x01, 0x0a, 0x12, 0x44, 0x65, 0x6c,
	0x65, 0x74, 0x65, 0x43, 0x6f, 0x6e, 0x76, 0x65, 0x72, 0x73, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x12,
	0x3d, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x64,
	0x69, 0x61, 0x6c, 0x6f, 0x67, 0x66, 0x6c, 0x6f, 0x77, 0x2e, 0x63, 0x78, 0x2e, 0x76, 0x33, 0x62,
	0x65, 0x74, 0x61, 0x31, 0x2e, 0x44, 0x65, 0x6c, 0x65, 0x74, 0x65, 0x43, 0x6f, 0x6e, 0x76, 0x65,
	0x72, 0x73, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x1a, 0x16,
	0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66,
	0x2e, 0x45, 0x6d, 0x70, 0x74, 0x79, 0x22, 0x4e, 0xda, 0x41, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x82,
	0xd3, 0xe4, 0x93, 0x02, 0x41, 0x2a, 0x3f, 0x2f, 0x76, 0x33, 0x62, 0x65, 0x74, 0x61, 0x31, 0x2f,
	0x7b, 0x6e, 0x61, 0x6d, 0x65, 0x3d, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x73, 0x2f, 0x2a,
	0x2f, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x2a, 0x2f, 0x61, 0x67, 0x65,
	0x6e, 0x74, 0x73, 0x2f, 0x2a, 0x2f, 0x63, 0x6f, 0x6e, 0x76, 0x65, 0x72, 0x73, 0x61, 0x74, 0x69,
	0x6f, 0x6e, 0x73, 0x2f, 0x2a, 0x7d, 0x1a, 0x78, 0xca, 0x41, 0x19, 0x64, 0x69, 0x61, 0x6c, 0x6f,
	0x67, 0x66, 0x6c, 0x6f, 0x77, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73,
	0x2e, 0x63, 0x6f, 0x6d, 0xd2, 0x41, 0x59, 0x68, 0x74, 0x74, 0x70, 0x73, 0x3a, 0x2f, 0x2f, 0x77,
	0x77, 0x77, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f,
	0x6d, 0x2f, 0x61, 0x75, 0x74, 0x68, 0x2f, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2d, 0x70, 0x6c, 0x61,
	0x74, 0x66, 0x6f, 0x72, 0x6d, 0x2c, 0x68, 0x74, 0x74, 0x70, 0x73, 0x3a, 0x2f, 0x2f, 0x77, 0x77,
	0x77, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d,
	0x2f, 0x61, 0x75, 0x74, 0x68, 0x2f, 0x64, 0x69, 0x61, 0x6c, 0x6f, 0x67, 0x66, 0x6c, 0x6f, 0x77,
	0x42, 0xd2, 0x01, 0x0a, 0x26, 0x63, 0x6f, 0x6d, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e,
	0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x64, 0x69, 0x61, 0x6c, 0x6f, 0x67, 0x66, 0x6c, 0x6f, 0x77,
	0x2e, 0x63, 0x78, 0x2e, 0x76, 0x33, 0x62, 0x65, 0x74, 0x61, 0x31, 0x42, 0x18, 0x43, 0x6f, 0x6e,
	0x76, 0x65, 0x72, 0x73, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x48, 0x69, 0x73, 0x74, 0x6f, 0x72, 0x79,
	0x50, 0x72, 0x6f, 0x74, 0x6f, 0x50, 0x01, 0x5a, 0x36, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x67,
	0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x67, 0x6f, 0x2f, 0x64, 0x69, 0x61,
	0x6c, 0x6f, 0x67, 0x66, 0x6c, 0x6f, 0x77, 0x2f, 0x63, 0x78, 0x2f, 0x61, 0x70, 0x69, 0x76, 0x33,
	0x62, 0x65, 0x74, 0x61, 0x31, 0x2f, 0x63, 0x78, 0x70, 0x62, 0x3b, 0x63, 0x78, 0x70, 0x62, 0xf8,
	0x01, 0x01, 0xa2, 0x02, 0x02, 0x44, 0x46, 0xaa, 0x02, 0x22, 0x47, 0x6f, 0x6f, 0x67, 0x6c, 0x65,
	0x2e, 0x43, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x44, 0x69, 0x61, 0x6c, 0x6f, 0x67, 0x66, 0x6c, 0x6f,
	0x77, 0x2e, 0x43, 0x78, 0x2e, 0x56, 0x33, 0x42, 0x65, 0x74, 0x61, 0x31, 0xea, 0x02, 0x26, 0x47,
	0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x3a, 0x3a, 0x43, 0x6c, 0x6f, 0x75, 0x64, 0x3a, 0x3a, 0x44, 0x69,
	0x61, 0x6c, 0x6f, 0x67, 0x66, 0x6c, 0x6f, 0x77, 0x3a, 0x3a, 0x43, 0x58, 0x3a, 0x3a, 0x56, 0x33,
	0x62, 0x65, 0x74, 0x61, 0x31, 0x62, 0x06, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x33,
}

var (
	file_google_cloud_dialogflow_cx_v3beta1_conversation_history_proto_rawDescOnce sync.Once
	file_google_cloud_dialogflow_cx_v3beta1_conversation_history_proto_rawDescData = file_google_cloud_dialogflow_cx_v3beta1_conversation_history_proto_rawDesc
)

func file_google_cloud_dialogflow_cx_v3beta1_conversation_history_proto_rawDescGZIP() []byte {
	file_google_cloud_dialogflow_cx_v3beta1_conversation_history_proto_rawDescOnce.Do(func() {
		file_google_cloud_dialogflow_cx_v3beta1_conversation_history_proto_rawDescData = protoimpl.X.CompressGZIP(file_google_cloud_dialogflow_cx_v3beta1_conversation_history_proto_rawDescData)
	})
	return file_google_cloud_dialogflow_cx_v3beta1_conversation_history_proto_rawDescData
}

var file_google_cloud_dialogflow_cx_v3beta1_conversation_history_proto_enumTypes = make([]protoimpl.EnumInfo, 1)
var file_google_cloud_dialogflow_cx_v3beta1_conversation_history_proto_msgTypes = make([]protoimpl.MessageInfo, 11)
var file_google_cloud_dialogflow_cx_v3beta1_conversation_history_proto_goTypes = []any{
	(Conversation_Type)(0),                             // 0: google.cloud.dialogflow.cx.v3beta1.Conversation.Type
	(*GetConversationRequest)(nil),                     // 1: google.cloud.dialogflow.cx.v3beta1.GetConversationRequest
	(*DeleteConversationRequest)(nil),                  // 2: google.cloud.dialogflow.cx.v3beta1.DeleteConversationRequest
	(*ListConversationsRequest)(nil),                   // 3: google.cloud.dialogflow.cx.v3beta1.ListConversationsRequest
	(*ListConversationsResponse)(nil),                  // 4: google.cloud.dialogflow.cx.v3beta1.ListConversationsResponse
	(*Conversation)(nil),                               // 5: google.cloud.dialogflow.cx.v3beta1.Conversation
	(*Conversation_Metrics)(nil),                       // 6: google.cloud.dialogflow.cx.v3beta1.Conversation.Metrics
	(*Conversation_Interaction)(nil),                   // 7: google.cloud.dialogflow.cx.v3beta1.Conversation.Interaction
	nil,                                                // 8: google.cloud.dialogflow.cx.v3beta1.Conversation.FlowVersionsEntry
	(*Conversation_Metrics_QueryInputCount)(nil),       // 9: google.cloud.dialogflow.cx.v3beta1.Conversation.Metrics.QueryInputCount
	(*Conversation_Metrics_MatchTypeCount)(nil),        // 10: google.cloud.dialogflow.cx.v3beta1.Conversation.Metrics.MatchTypeCount
	(*Conversation_Interaction_MissingTransition)(nil), // 11: google.cloud.dialogflow.cx.v3beta1.Conversation.Interaction.MissingTransition
	(*timestamppb.Timestamp)(nil),                      // 12: google.protobuf.Timestamp
	(*durationpb.Duration)(nil),                        // 13: google.protobuf.Duration
	(*Intent)(nil),                                     // 14: google.cloud.dialogflow.cx.v3beta1.Intent
	(*Flow)(nil),                                       // 15: google.cloud.dialogflow.cx.v3beta1.Flow
	(*Page)(nil),                                       // 16: google.cloud.dialogflow.cx.v3beta1.Page
	(*Environment)(nil),                                // 17: google.cloud.dialogflow.cx.v3beta1.Environment
	(*DetectIntentRequest)(nil),                        // 18: google.cloud.dialogflow.cx.v3beta1.DetectIntentRequest
	(*DetectIntentResponse)(nil),                       // 19: google.cloud.dialogflow.cx.v3beta1.DetectIntentResponse
	(*emptypb.Empty)(nil),                              // 20: google.protobuf.Empty
}
var file_google_cloud_dialogflow_cx_v3beta1_conversation_history_proto_depIdxs = []int32{
	5,  // 0: google.cloud.dialogflow.cx.v3beta1.ListConversationsResponse.conversations:type_name -> google.cloud.dialogflow.cx.v3beta1.Conversation
	0,  // 1: google.cloud.dialogflow.cx.v3beta1.Conversation.type:type_name -> google.cloud.dialogflow.cx.v3beta1.Conversation.Type
	12, // 2: google.cloud.dialogflow.cx.v3beta1.Conversation.start_time:type_name -> google.protobuf.Timestamp
	13, // 3: google.cloud.dialogflow.cx.v3beta1.Conversation.duration:type_name -> google.protobuf.Duration
	6,  // 4: google.cloud.dialogflow.cx.v3beta1.Conversation.metrics:type_name -> google.cloud.dialogflow.cx.v3beta1.Conversation.Metrics
	14, // 5: google.cloud.dialogflow.cx.v3beta1.Conversation.intents:type_name -> google.cloud.dialogflow.cx.v3beta1.Intent
	15, // 6: google.cloud.dialogflow.cx.v3beta1.Conversation.flows:type_name -> google.cloud.dialogflow.cx.v3beta1.Flow
	16, // 7: google.cloud.dialogflow.cx.v3beta1.Conversation.pages:type_name -> google.cloud.dialogflow.cx.v3beta1.Page
	7,  // 8: google.cloud.dialogflow.cx.v3beta1.Conversation.interactions:type_name -> google.cloud.dialogflow.cx.v3beta1.Conversation.Interaction
	17, // 9: google.cloud.dialogflow.cx.v3beta1.Conversation.environment:type_name -> google.cloud.dialogflow.cx.v3beta1.Environment
	8,  // 10: google.cloud.dialogflow.cx.v3beta1.Conversation.flow_versions:type_name -> google.cloud.dialogflow.cx.v3beta1.Conversation.FlowVersionsEntry
	13, // 11: google.cloud.dialogflow.cx.v3beta1.Conversation.Metrics.input_audio_duration:type_name -> google.protobuf.Duration
	13, // 12: google.cloud.dialogflow.cx.v3beta1.Conversation.Metrics.output_audio_duration:type_name -> google.protobuf.Duration
	13, // 13: google.cloud.dialogflow.cx.v3beta1.Conversation.Metrics.max_webhook_latency:type_name -> google.protobuf.Duration
	9,  // 14: google.cloud.dialogflow.cx.v3beta1.Conversation.Metrics.query_input_count:type_name -> google.cloud.dialogflow.cx.v3beta1.Conversation.Metrics.QueryInputCount
	10, // 15: google.cloud.dialogflow.cx.v3beta1.Conversation.Metrics.match_type_count:type_name -> google.cloud.dialogflow.cx.v3beta1.Conversation.Metrics.MatchTypeCount
	18, // 16: google.cloud.dialogflow.cx.v3beta1.Conversation.Interaction.request:type_name -> google.cloud.dialogflow.cx.v3beta1.DetectIntentRequest
	19, // 17: google.cloud.dialogflow.cx.v3beta1.Conversation.Interaction.response:type_name -> google.cloud.dialogflow.cx.v3beta1.DetectIntentResponse
	19, // 18: google.cloud.dialogflow.cx.v3beta1.Conversation.Interaction.partial_responses:type_name -> google.cloud.dialogflow.cx.v3beta1.DetectIntentResponse
	12, // 19: google.cloud.dialogflow.cx.v3beta1.Conversation.Interaction.create_time:type_name -> google.protobuf.Timestamp
	11, // 20: google.cloud.dialogflow.cx.v3beta1.Conversation.Interaction.missing_transition:type_name -> google.cloud.dialogflow.cx.v3beta1.Conversation.Interaction.MissingTransition
	3,  // 21: google.cloud.dialogflow.cx.v3beta1.ConversationHistory.ListConversations:input_type -> google.cloud.dialogflow.cx.v3beta1.ListConversationsRequest
	1,  // 22: google.cloud.dialogflow.cx.v3beta1.ConversationHistory.GetConversation:input_type -> google.cloud.dialogflow.cx.v3beta1.GetConversationRequest
	2,  // 23: google.cloud.dialogflow.cx.v3beta1.ConversationHistory.DeleteConversation:input_type -> google.cloud.dialogflow.cx.v3beta1.DeleteConversationRequest
	4,  // 24: google.cloud.dialogflow.cx.v3beta1.ConversationHistory.ListConversations:output_type -> google.cloud.dialogflow.cx.v3beta1.ListConversationsResponse
	5,  // 25: google.cloud.dialogflow.cx.v3beta1.ConversationHistory.GetConversation:output_type -> google.cloud.dialogflow.cx.v3beta1.Conversation
	20, // 26: google.cloud.dialogflow.cx.v3beta1.ConversationHistory.DeleteConversation:output_type -> google.protobuf.Empty
	24, // [24:27] is the sub-list for method output_type
	21, // [21:24] is the sub-list for method input_type
	21, // [21:21] is the sub-list for extension type_name
	21, // [21:21] is the sub-list for extension extendee
	0,  // [0:21] is the sub-list for field type_name
}

func init() { file_google_cloud_dialogflow_cx_v3beta1_conversation_history_proto_init() }
func file_google_cloud_dialogflow_cx_v3beta1_conversation_history_proto_init() {
	if File_google_cloud_dialogflow_cx_v3beta1_conversation_history_proto != nil {
		return
	}
	file_google_cloud_dialogflow_cx_v3beta1_environment_proto_init()
	file_google_cloud_dialogflow_cx_v3beta1_flow_proto_init()
	file_google_cloud_dialogflow_cx_v3beta1_intent_proto_init()
	file_google_cloud_dialogflow_cx_v3beta1_page_proto_init()
	file_google_cloud_dialogflow_cx_v3beta1_session_proto_init()
	if !protoimpl.UnsafeEnabled {
		file_google_cloud_dialogflow_cx_v3beta1_conversation_history_proto_msgTypes[0].Exporter = func(v any, i int) any {
			switch v := v.(*GetConversationRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_dialogflow_cx_v3beta1_conversation_history_proto_msgTypes[1].Exporter = func(v any, i int) any {
			switch v := v.(*DeleteConversationRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_dialogflow_cx_v3beta1_conversation_history_proto_msgTypes[2].Exporter = func(v any, i int) any {
			switch v := v.(*ListConversationsRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_dialogflow_cx_v3beta1_conversation_history_proto_msgTypes[3].Exporter = func(v any, i int) any {
			switch v := v.(*ListConversationsResponse); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_dialogflow_cx_v3beta1_conversation_history_proto_msgTypes[4].Exporter = func(v any, i int) any {
			switch v := v.(*Conversation); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_dialogflow_cx_v3beta1_conversation_history_proto_msgTypes[5].Exporter = func(v any, i int) any {
			switch v := v.(*Conversation_Metrics); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_dialogflow_cx_v3beta1_conversation_history_proto_msgTypes[6].Exporter = func(v any, i int) any {
			switch v := v.(*Conversation_Interaction); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_dialogflow_cx_v3beta1_conversation_history_proto_msgTypes[8].Exporter = func(v any, i int) any {
			switch v := v.(*Conversation_Metrics_QueryInputCount); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_dialogflow_cx_v3beta1_conversation_history_proto_msgTypes[9].Exporter = func(v any, i int) any {
			switch v := v.(*Conversation_Metrics_MatchTypeCount); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_dialogflow_cx_v3beta1_conversation_history_proto_msgTypes[10].Exporter = func(v any, i int) any {
			switch v := v.(*Conversation_Interaction_MissingTransition); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
	}
	type x struct{}
	out := protoimpl.TypeBuilder{
		File: protoimpl.DescBuilder{
			GoPackagePath: reflect.TypeOf(x{}).PkgPath(),
			RawDescriptor: file_google_cloud_dialogflow_cx_v3beta1_conversation_history_proto_rawDesc,
			NumEnums:      1,
			NumMessages:   11,
			NumExtensions: 0,
			NumServices:   1,
		},
		GoTypes:           file_google_cloud_dialogflow_cx_v3beta1_conversation_history_proto_goTypes,
		DependencyIndexes: file_google_cloud_dialogflow_cx_v3beta1_conversation_history_proto_depIdxs,
		EnumInfos:         file_google_cloud_dialogflow_cx_v3beta1_conversation_history_proto_enumTypes,
		MessageInfos:      file_google_cloud_dialogflow_cx_v3beta1_conversation_history_proto_msgTypes,
	}.Build()
	File_google_cloud_dialogflow_cx_v3beta1_conversation_history_proto = out.File
	file_google_cloud_dialogflow_cx_v3beta1_conversation_history_proto_rawDesc = nil
	file_google_cloud_dialogflow_cx_v3beta1_conversation_history_proto_goTypes = nil
	file_google_cloud_dialogflow_cx_v3beta1_conversation_history_proto_depIdxs = nil
}

// Reference imports to suppress errors if they are not otherwise used.
var _ context.Context
var _ grpc.ClientConnInterface

// This is a compile-time assertion to ensure that this generated file
// is compatible with the grpc package it is being compiled against.
const _ = grpc.SupportPackageIsVersion6

// ConversationHistoryClient is the client API for ConversationHistory service.
//
// For semantics around ctx use and closing/ending streaming RPCs, please refer to https://godoc.org/google.golang.org/grpc#ClientConn.NewStream.
type ConversationHistoryClient interface {
	// Returns the list of all conversations.
	ListConversations(ctx context.Context, in *ListConversationsRequest, opts ...grpc.CallOption) (*ListConversationsResponse, error)
	// Retrieves the specified conversation.
	GetConversation(ctx context.Context, in *GetConversationRequest, opts ...grpc.CallOption) (*Conversation, error)
	// Deletes the specified conversation.
	DeleteConversation(ctx context.Context, in *DeleteConversationRequest, opts ...grpc.CallOption) (*emptypb.Empty, error)
}

type conversationHistoryClient struct {
	cc grpc.ClientConnInterface
}

func NewConversationHistoryClient(cc grpc.ClientConnInterface) ConversationHistoryClient {
	return &conversationHistoryClient{cc}
}

func (c *conversationHistoryClient) ListConversations(ctx context.Context, in *ListConversationsRequest, opts ...grpc.CallOption) (*ListConversationsResponse, error) {
	out := new(ListConversationsResponse)
	err := c.cc.Invoke(ctx, "/google.cloud.dialogflow.cx.v3beta1.ConversationHistory/ListConversations", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *conversationHistoryClient) GetConversation(ctx context.Context, in *GetConversationRequest, opts ...grpc.CallOption) (*Conversation, error) {
	out := new(Conversation)
	err := c.cc.Invoke(ctx, "/google.cloud.dialogflow.cx.v3beta1.ConversationHistory/GetConversation", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *conversationHistoryClient) DeleteConversation(ctx context.Context, in *DeleteConversationRequest, opts ...grpc.CallOption) (*emptypb.Empty, error) {
	out := new(emptypb.Empty)
	err := c.cc.Invoke(ctx, "/google.cloud.dialogflow.cx.v3beta1.ConversationHistory/DeleteConversation", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

// ConversationHistoryServer is the server API for ConversationHistory service.
type ConversationHistoryServer interface {
	// Returns the list of all conversations.
	ListConversations(context.Context, *ListConversationsRequest) (*ListConversationsResponse, error)
	// Retrieves the specified conversation.
	GetConversation(context.Context, *GetConversationRequest) (*Conversation, error)
	// Deletes the specified conversation.
	DeleteConversation(context.Context, *DeleteConversationRequest) (*emptypb.Empty, error)
}

// UnimplementedConversationHistoryServer can be embedded to have forward compatible implementations.
type UnimplementedConversationHistoryServer struct {
}

func (*UnimplementedConversationHistoryServer) ListConversations(context.Context, *ListConversationsRequest) (*ListConversationsResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method ListConversations not implemented")
}
func (*UnimplementedConversationHistoryServer) GetConversation(context.Context, *GetConversationRequest) (*Conversation, error) {
	return nil, status.Errorf(codes.Unimplemented, "method GetConversation not implemented")
}
func (*UnimplementedConversationHistoryServer) DeleteConversation(context.Context, *DeleteConversationRequest) (*emptypb.Empty, error) {
	return nil, status.Errorf(codes.Unimplemented, "method DeleteConversation not implemented")
}

func RegisterConversationHistoryServer(s *grpc.Server, srv ConversationHistoryServer) {
	s.RegisterService(&_ConversationHistory_serviceDesc, srv)
}

func _ConversationHistory_ListConversations_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(ListConversationsRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(ConversationHistoryServer).ListConversations(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.dialogflow.cx.v3beta1.ConversationHistory/ListConversations",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(ConversationHistoryServer).ListConversations(ctx, req.(*ListConversationsRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _ConversationHistory_GetConversation_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(GetConversationRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(ConversationHistoryServer).GetConversation(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.dialogflow.cx.v3beta1.ConversationHistory/GetConversation",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(ConversationHistoryServer).GetConversation(ctx, req.(*GetConversationRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _ConversationHistory_DeleteConversation_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(DeleteConversationRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(ConversationHistoryServer).DeleteConversation(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.dialogflow.cx.v3beta1.ConversationHistory/DeleteConversation",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(ConversationHistoryServer).DeleteConversation(ctx, req.(*DeleteConversationRequest))
	}
	return interceptor(ctx, in, info, handler)
}

var _ConversationHistory_serviceDesc = grpc.ServiceDesc{
	ServiceName: "google.cloud.dialogflow.cx.v3beta1.ConversationHistory",
	HandlerType: (*ConversationHistoryServer)(nil),
	Methods: []grpc.MethodDesc{
		{
			MethodName: "ListConversations",
			Handler:    _ConversationHistory_ListConversations_Handler,
		},
		{
			MethodName: "GetConversation",
			Handler:    _ConversationHistory_GetConversation_Handler,
		},
		{
			MethodName: "DeleteConversation",
			Handler:    _ConversationHistory_DeleteConversation_Handler,
		},
	},
	Streams:  []grpc.StreamDesc{},
	Metadata: "google/cloud/dialogflow/cx/v3beta1/conversation_history.proto",
}
