/*
 * Decompiled with CFR 0.152.
 */
package org.igoweb.igoweb.client.swing;

import java.awt.Graphics;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.AbstractAction;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JPasswordField;
import javax.swing.SwingUtilities;
import org.igoweb.igoweb.client.swing.Motd;
import org.igoweb.igoweb.shared.User;
import org.igoweb.util.swing.AFrame;
import org.igoweb.util.swing.ATextField;
import org.igoweb.util.swing.Defs;
import org.igoweb.util.swing.Errout;
import org.igoweb.util.swing.GCLayout;
import org.igoweb.util.swing.Prefs;
import org.igoweb.util.swing.TBlock;

public class LoginPanel
extends JPanel {
    public static final String SAVE_PASSWORD_PREF = "m'~8UDTe";
    public static final String NAME_PREF = ".Zu`kdP&";
    public static final String PASSWORD_PREF = "W'*Diq8";
    private boolean ready;
    private final ATextField nameIn = new ATextField(10);
    private final JPasswordField passwordIn = new JPasswordField(10);
    private final JButton okBut;
    private final JButton guestBut;
    private final JButton cancelBut;
    private final Motd motd;
    private ActionListener listener;
    private String userName = null;
    private String password = null;
    private boolean isPainted = false;

    public LoginPanel(final ActionListener listener) {
        super(new GCLayout());
        this.setOpaque(false);
        this.ready = true;
        this.listener = listener;
        this.motd = new Motd();
        this.add("xGrow=t,yGrow=t", this.motd);
        JPanel jp = AFrame.createBorderedPanel(new GCLayout());
        this.add("x=0,yGrow=f", jp);
        jp.add("xSpan=2", new TBlock(Defs.getString(-903340698), 25));
        jp.add("x=0,xSpan=1", new JLabel(Defs.getString(-903340680)));
        jp.add("xGrow=t", this.nameIn);
        this.nameIn.setText(Prefs.getString(NAME_PREF, ""));
        jp.add("x=0,xGrow=f", new JLabel(Defs.getString(-903340650)));
        jp.add(this.passwordIn);
        this.passwordIn.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent event) {
                if (LoginPanel.this.passwordIn.getPassword().length == 0) {
                    LoginPanel.this.guestPressed();
                } else {
                    LoginPanel.this.okPressed();
                }
            }
        });
        if (Prefs.getBoolean(SAVE_PASSWORD_PREF, false)) {
            this.passwordIn.setText(Prefs.getString(PASSWORD_PREF, ""));
        }
        JPanel p = new JPanel(new GCLayout());
        p.setOpaque(false);
        this.add("x=0", p);
        this.okBut = new JButton(new AbstractAction(Defs.getString(1436228518)){

            @Override
            public void actionPerformed(ActionEvent event) {
                LoginPanel.this.okPressed();
            }
        });
        p.add("xGrow=t", this.okBut);
        this.guestBut = new JButton(new AbstractAction(Defs.getString(-903340715)){

            @Override
            public void actionPerformed(ActionEvent event) {
                LoginPanel.this.guestPressed();
            }
        });
        p.add(this.guestBut);
        if (Defs.isApp()) {
            this.cancelBut = new JButton(new AbstractAction(Defs.getString(1436228510)){

                @Override
                public void actionPerformed(ActionEvent event) {
                    listener.actionPerformed(new ActionEvent(LoginPanel.this, 1001, "Cancel"));
                }
            });
            p.add(this.cancelBut);
        } else {
            this.cancelBut = null;
        }
    }

    public void setListener(ActionListener newListener) {
        this.listener = newListener;
    }

    private void okPressed() {
        this.login(this.nameIn.getText().trim(), new String(this.passwordIn.getPassword()));
    }

    private void guestPressed() {
        this.login(this.nameIn.getText().trim(), null);
    }

    private void login(String newName, String newPassword) {
        if (User.nameValid(newName)) {
            this.userName = newName;
            this.password = newPassword;
            Prefs.putString(NAME_PREF, newName);
            if (newPassword != null && Prefs.getBoolean(SAVE_PASSWORD_PREF, false)) {
                Prefs.putString(PASSWORD_PREF, newPassword);
            }
            Prefs.putString(NAME_PREF, newName);
            this.setReady(false);
            this.listener.actionPerformed(new ActionEvent(this, 1001, "Login"));
        } else {
            new Errout(Defs.getString(-903340799, new Object[]{newName, new Integer(10)}));
        }
    }

    public void setReady(boolean newReady) {
        if (newReady != this.ready) {
            this.ready = newReady;
            if (this.ready) {
                this.motd.setMotd();
            } else if (!Defs.isApp()) {
                this.motd.setMessage(Defs.getString(-903340759));
            }
            this.okBut.setEnabled(this.ready);
            this.guestBut.setEnabled(this.ready);
            if (this.cancelBut != null) {
                this.cancelBut.setEnabled(this.ready);
            }
        }
    }

    @Override
    public void paint(Graphics g) {
        super.paint(g);
        if (!this.isPainted) {
            this.isPainted = true;
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    LoginPanel.this.nameIn.requestFocus();
                }
            });
        }
    }

    public String getUser() {
        return this.userName;
    }

    public String getPassword() {
        return this.password;
    }
}

