#if 0
gcc -s -O2 -o ~/bin/bystand bystand.c sqlite3.o -ldl -lpthread
exit
#endif

#define BYSTAND_VERSION "bystand/1.2.0"

#define _GNU_SOURCE
#include <err.h>
#include <netdb.h>
#include <signal.h>
#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <sys/socket.h>
#include <sys/types.h>
#include <sys/wait.h>
#include <time.h>
#include <unistd.h>

#ifdef NEED_GNU_COMPAT
#include "gnu_compat.h"
#endif

#ifndef MSG_MORE
#define MSG_MORE 0
#endif

#include "sqlite3.h"
#define countof(x) (sizeof(x)/sizeof(*(x)))

enum {
#define Opt(x) Opt_##x,
#include "bystand_options.inc"
  Opt__MAX
#undef Opt
};
static const char*const optname[Opt__MAX]={
#define Opt(x) #x,
#include "bystand_options.inc"
#undef Opt
};

static void do_command(const char*cmd);
static int do_command_ex(void*user,int argc,char**argv,char**names);

typedef struct {
  sqlite3_stmt*stmt;
  sqlite3_int64 score;
  signed char headers[16];
  char nh;
  char flag; // 0=begin group, 1=within group
} Scoring;

static char buf[0x1004];
static char*option[Opt__MAX];
static int ioption[Opt__MAX];
static sqlite3*db;
static int connection=-1;
static char*home;
static char curgroup[512];
static char unterminated=1;
static short command_length;
static sqlite3_int64 curid;
static int listmore;
static int dlcount;
static sqlite3_stmt*usermacro[128];
static char*select_filter;
static Scoring*scoring;
static int nscoring;
static char*scoringh[128];
static int nscoringh;

static inline void begin_color(const char*s) {
  if(ioption[Opt_Color]) printf("\e[%sm",s);
}
#define end_color() begin_color("")
#define color_printf(c,...) (begin_color(c),printf(__VA_ARGS__),end_color())

static void safe_print(const char*c,const char*d) {
  if(c) begin_color(c);
  while(*d) {
    switch(255&*d) {
      case 32 ... 126:
        putchar(*d);
        break;
      case 1 ... 31:
        begin_color("7");
        putchar('^');
        putchar(*d+'@');
        begin_color("27");
        break;
      default:
        begin_color("7");
        putchar('?');
        begin_color("27");
        break;
    }
    d++;
  }
  if(c) end_color();
}

static int dial(const char*host,const char*port) {
  // return 0 if OK, -1 if error
  int i;
  int fd=-1;
  struct addrinfo ai;
  struct addrinfo*res=0;
  if(connection!=-1) {
    close(connection);
    connection=-1;
  }
  memset(&ai,0,sizeof(struct addrinfo));
  if(!port) port="119";
  if(*port=='!') {
    int sv[2];
    if(socketpair(AF_UNIX,SOCK_STREAM,0,sv)) {
      color_printf("1;31","Can't create socket pair: %m\n");
      return -1;
    }
    i=fork();
    if(i==-1) {
      close(sv[0]);
      close(sv[1]);
      color_printf("1;31","Can't fork: %m\n");
      return -1;
    } else if(!i) {
      close(0);
      close(1);
      close(sv[0]);
      dup2(sv[1],0);
      dup2(sv[1],1);
      execl("/bin/sh","/bin/sh","-c",port+1,(char*)0);
      _exit(1);
    }
    connection=sv[0];
    close(sv[1]);
    return 0;
  }
  ai.ai_flags=AI_ADDRCONFIG|AI_NUMERICSERV;
  ai.ai_family=AF_UNSPEC;
  if(ioption[Opt_InternetVersion]==4) ai.ai_family=AF_INET;
  if(ioption[Opt_InternetVersion]==6) ai.ai_family=AF_INET6;
  ai.ai_socktype=SOCK_STREAM;
  i=getaddrinfo(host,port,&ai,&res);
  if(i) {
    color_printf("1;31","Can't get address info for '%s:%s': %s\n",host,port,gai_strerror(i));
    return -1;
  }
  fd=socket(res->ai_family,res->ai_socktype,res->ai_protocol);
  if(fd==-1) {
    color_printf("1;31","Can't open socket: %m\n");
    freeaddrinfo(res);
    return -1;
  }
  if(connect(fd,res->ai_addr,res->ai_addrlen)) {
    color_printf("1;31","Can't connect to '%s:%s': %m\n",host,port);
    close(fd);
    freeaddrinfo(res);
    return -1;
  }
  freeaddrinfo(res);
  connection=fd;
  return 0;
}

static void hangup(void) {
  if(connection!=-1) close(connection);
  connection=-1;
}

static int send_line(const char*data) {
  size_t m=strlen(data);
  ssize_t s;
  if(connection==-1) return -1;
  if(ioption[Opt_DisplayCommunication]) {
    color_printf("1;33","> ");
    safe_print("33",data);
    putchar('\n');
  }
  while(m>0) {
    s=send(connection,data,m,MSG_MORE|MSG_NOSIGNAL);
    if(s<0) {
      color_printf("1;31","Socket error: %m\n");
      hangup();
      return -1;
    } else if(!s) {
      color_printf("1;31","Connection closed\n");
      hangup();
      return -1;
    }
    data+=s;
    m-=s;
  }
  data="\r\n";
  m=2;
  while(m) {
    s=send(connection,data,m,MSG_NOSIGNAL);
    if(s<0) {
      color_printf("1;31","Socket error: %m\n");
      hangup();
      return -1;
    } else if(!s) {
      color_printf("1;31","Connection closed unexpectedly\n");
      hangup();
      return -1;
    }
    data+=s;
    m-=s;
  }
  return 0;
}

static char*recv_line(void) {
  // returns a SQLite allocated string, or 0 if error
  int m=ioption[Opt_MaxLine]?:0x10000;
  int i;
  ssize_t s;
  sqlite3_str*str=sqlite3_str_new(db);
  if(connection==-1) {
    sqlite3_free(sqlite3_str_finish(str));
    return 0;
  }
  while(m>0) {
    s=recv(connection,buf,m>0x1000?0x1000:m,MSG_PEEK);
    if(s<0) {
      color_printf("1;31","Socket error: %m\n");
      hangup();
      sqlite3_free(sqlite3_str_finish(str));
      return 0;
    } else if(!s) {
      color_printf("1;31","Connection closed unexpectedly while receiving\n");
      hangup();
      sqlite3_free(sqlite3_str_finish(str));
      return 0;
    }
    for(i=0;i<s;i++) {
      if(!buf[i]) {
        color_printf("31","Found null character in received data; disconnecting\n");
        hangup();
        sqlite3_free(sqlite3_str_finish(str));
        return 0;
      }
      if(buf[i]=='\r') goto eol;
    }
    s=recv(connection,buf,s,MSG_WAITALL);
    sqlite3_str_append(str,buf,s);
    m-=s;
  }
  i=0;
  eol:
  s=recv(connection,buf,i+2,MSG_WAITALL);
  if(s!=i+2) {
    if(s<0) color_printf("1;31","Socket error: %m\n");
    color_printf("1;31","Error receiving data; disconnecting (found %d; expected %d)\n",(int)s,i+2);
    hangup();
    sqlite3_free(sqlite3_str_finish(str));
    return 0;
  }
  sqlite3_str_append(str,buf,i);
  if(i=sqlite3_str_errcode(str)) {
    color_printf("31","String builder error: %s (%d)\n",i==SQLITE_NOMEM?"out of memory":i==SQLITE_TOOBIG?"too big":"unspecified error",i);
    return sqlite3_str_finish(str);
  } else {
    // ensure empty lines can be received correctly
    // (because sqlite3_str_finish() returns a null pointer in case of an empty string)
    char*x=sqlite3_str_finish(str);
    if(!x) x=sqlite3_mprintf("");
    if(ioption[Opt_DisplayCommunication]) {
      color_printf("1;33","< ");
      safe_print("33",x);
      putchar('\n');
    }
    return x;
  }
}

static int recv_data(sqlite3_str*obj) {
  int m=ioption[Opt_MaxData]?:200000000;
  int i;
  ssize_t s;
  int t=0; // 0=beginning of line, 1=middle of line, 2=has just read the dot
  char*p;
  if(connection==-1) return -1;
  while(m>0) {
    s=recv(connection,buf,m>0x1000?0x1000:m,MSG_PEEK);
    if(s<0) {
      color_printf("1;31","Socket error: %m\n");
      hangup();
      return -1;
    } else if(!s) {
      color_printf("1;31","Connection closed unexpectedly while receiving\n");
      hangup();
      return -1;
    }
    if(!t && *buf=='.') {
      s=recv(connection,buf,1,MSG_WAITALL);
      t=2;
      continue;
    }
    if(t==2) {
      if(*buf=='\r' || *buf=='\n') {
        if(s<2) color_printf("1;31","Expected at least two characters after a dot, but found only one\n");
        s=recv(connection,buf,s>2?2:s,MSG_WAITALL);
        if(s!=2) {
          if(s<0) color_printf("1;31","Socket error: %m\n");
          color_printf("1;31","Error receiving data; disconnecting (found %d; expected 2)\n",(int)s);
          hangup();
          return -1;
        }
        break;
      }
    }
    p=memchr(buf,'\r',s);
    if(p) {
      s=recv(connection,buf,p+2-buf,MSG_WAITALL);
      if(s!=p+2-buf) {
        if(s<0) color_printf("1;31","Socket error: %m\n");
        color_printf("1;31","Error receiving data; disconnecting (found %d; expected %d)\n",(int)s,(int)(p+2-buf));
        hangup();
        return -1;
      } else if(buf[p-buf]!='\r' || buf[p+1-buf]!='\n') {
        color_printf("31","Incorrect line terminators in received data\n");
        hangup();
        return -1;
      }
      sqlite3_str_append(obj,buf,p-buf);
      sqlite3_str_appendchar(obj,1,'\n');
      t=0;
    } else {
      s=recv(connection,buf,s,MSG_WAITALL);
      sqlite3_str_append(obj,buf,s);
      t=1;
    }
  }
  if(ioption[Opt_DisplayCommunication]) {
    color_printf("1;33","<< ");
    color_printf("35","%d\n",sqlite3_str_length(obj));
  }
  return 0;
}

static int send_data(sqlite3_blob*obj) {
  int pos=0;
  int max=sqlite3_blob_bytes(obj);
  ssize_t s;
  int i;
  char*p;
  char*q;
  int t=0;
  if(connection==-1) return -1;
  if(ioption[Opt_DisplayCommunication]) {
    color_printf("1;33",">> ");
    color_printf("35","%d\n",max);
  }
  *buf='.';
  while(pos<max) {
    if(sqlite3_blob_read(obj,buf+1,i=(max-pos>0xFFF?0xFFF:max-pos),pos)) {
      color_printf("31","SQL blob I/O error: ");
      printf("%s\n",sqlite3_errmsg(db));
      hangup();
      return -1;
    }
    p=buf+(buf[1]=='.'?t:1);
    buf[i+1]=0;
    q=strchrnul(p,'\n');
    i=q-p;
    pos+=i;
    if(p==buf) pos--;
    if(*q=='\n') {
      q[0]='\r';
      q[1]='\n';
      i+=2;
      pos++;
      t=0;
    } else {
      t=1;
    }
    while(i>0) {
      s=send(connection,p,i,MSG_MORE|MSG_NOSIGNAL);
      if(s<0) {
        color_printf("1;31","Socket error: %m\n");
        hangup();
        return -1;
      } else if(!s) {
        color_printf("1;31","Connection closed\n");
        hangup();
        return -1;
      }
      p+=s;
      i-=s;
    }
  }
  if(t) {
    p="\r\n.\r\n";
    i=5;
  } else {
    p=".\r\n";
    i=3;
  }
  while(i>0) {
    s=send(connection,p,i,MSG_NOSIGNAL);
    if(s<0) {
      color_printf("1;31","Socket error: %m\n");
      hangup();
      return -1;
    } else if(!s) {
      color_printf("1;31","Connection closed\n");
      hangup();
      return -1;
    }
    p+=s;
    i-=s;
  }
  return 0;
}

static void init_home(void) {
  char*s;
  if(s=getenv("BYSTAND_DIR")) {
    home=strdup(s);
  } else if(s=getenv("HOME")) {
    home=sqlite3_mprintf("%s/.bystand",s);
  } else {
    errx(1,"Environment variable not defined");
  }
  if(!home) errx(1,"Allocation failed");
}

static void load_user_macros(void) {
  sqlite3_stmt*st;
  const char*t;
  const char*k;
  int c;
  if(sqlite3_prepare_v2(db,"SELECT `KEY`, `VALUE` FROM `CONFIG` WHERE `KEY` GLOB ',?';",-1,&st,0)) {
    errx(1,"Failed to prepare SQL statement for load_user_macros");
  }
  while(sqlite3_step(st)==SQLITE_ROW) {
    if((k=sqlite3_column_text(st,0)) && (t=sqlite3_column_text(st,1))) {
      c=k[1]&127;
      if(usermacro[c]) {
        sqlite3_finalize(usermacro[c]);
        usermacro[c]=0;
      }
      if(sqlite3_prepare_v3(db,t,-1,SQLITE_PREPARE_PERSISTENT,usermacro+c,0)) {
        color_printf("31","Error in macro %c: ",c);
        printf("%s\n",sqlite3_errmsg(db));
      }
    }
  }
  sqlite3_finalize(st);
}

static void add_scoring_headers(int n,int nn) {
  int i,j;
  char b[256];
  char*p;
  sqlite3_stmt*st=scoring[n].stmt;
  const char*s;
  if(nn>16) nn=16;
  for(i=0;i<nn;i++) {
    s=sqlite3_bind_parameter_name(st,i+1);
    if(!s) continue;
    if(*s=='@') {
      scoring[n].headers[i]=-1; // full article
    } else if(*s=='$') {
      if(s[1]=='0' && s[2]=='(') {
        b[snprintf(b,255,"%.251s",s+3)-1]=0;
      } else {
        snprintf(b,255,"%.251s",s+1);
      }
      p=b;
      while(*p) {
        if(*p>='a' && *p<='z') *p+='A'-'a';
        if(*p=='_' && s[2]!='(') *p='-';
        p++;
      }
      for(j=0;j<nscoringh;j++) if(!strcmp(scoringh[j],b)) goto found;
      if(nscoringh==128) errx(1,"Too many header names in scoring file");
      scoringh[j=nscoringh++]=strdup(b);
      if(!scoringh[j]) errx(1,"Allocation failed");
      found:
      scoring[n].headers[i]=j;
    }
  }
}

static void load_scoring(void) {
  int n=0;
  int i;
  char*s=sqlite3_mprintf("%s/scoring",home);
  FILE*fp;
  char*line=0;
  size_t linemax=0;
  if(!s) errx(1,"Allocation failed");
  fp=fopen(s,"r");
  if(!fp) err(1,"Cannot load scoring file");
  sqlite3_free(s);
  while(getline(&line,&linemax,fp)!=-1) if(*line!='#' && *line && *line!='\n') n++;
  rewind(fp);
  scoring=calloc(n,sizeof(Scoring));
  if(!scoring) errx(1,"Allocation failed");
  nscoring=n;
  n=0;
  while(n<nscoring) {
    if(getline(&line,&linemax,fp)==-1) err(1,"Confusion in load_scoring()");
    if(*line!='#' && *line && *line!='\n') {
      scoring[n].score=strtoll(line,&s,10);
      if(*s=='/') scoring[n].flag=1;
      else if(*s==':') scoring[n].flag=0;
      else errx(1,"Syntax error in scoring file: %s",line);
      s++;
      while(*s==' ' || *s=='\t') s++;
      s=sqlite3_mprintf("%s%s",sqlite3_strnicmp("WITH ",s,5)?"SELECT ":"",s);
      if(!s) errx(1,"Allocation failed");
      if(sqlite3_prepare_v3(db,s,-1,SQLITE_PREPARE_PERSISTENT,&scoring[n].stmt,0)) errx(1,"SQL error in scoring file: %s",sqlite3_errmsg(db));
      sqlite3_free(s);
      if(!scoring[n].stmt) errx(1,"Syntax error in scoring file: %s",line);
      i=scoring[n].nh=sqlite3_bind_parameter_count(scoring[n].stmt);
      if(i>16) errx(1,"Too many host parameters in: %s",line);
      if(i) add_scoring_headers(n,i);
      n++;
    }
  }
  free(line);
  fclose(fp);
}

static void load_config(const char*name) {
  sqlite3_stmt*st;
  int i=0;
  int m;
  int n=strlen(name)+1;
  const char*t;
  if(sqlite3_prepare_v2(db,"SELECT `KEY`, `VALUE` FROM `CONFIG` WHERE `KEY` GLOB ?1 || '/*' ORDER BY `KEY`;",-1,&st,0)) {
    errx(1,"Failed to prepare SQL statement for load_config");
  }
  sqlite3_bind_text(st,1,name,-1,0);
  while(sqlite3_step(st)==SQLITE_ROW && i<Opt__MAX) {
    if(t=sqlite3_column_text(st,0)) {
      while(i<Opt__MAX) {
        m=strcmp(t+n,optname[i]);
        if(m>0) i++; else break;
      }
      if(!m) {
        option[i]=strdup(sqlite3_column_text(st,1));
        ioption[i]=sqlite3_column_int(st,1);
        i++;
      }
    }
  }
  sqlite3_finalize(st);
}

static char*get_header(sqlite3_context*cxt,const char*data,int len,const char*name,int nlen) {
  const char*p;
  sqlite3_str*s;
  if(!data || !name) return 0;
  for(;;) {
    if(len<nlen+2 || *data=='\n') return 0;
    if(!sqlite3_strnicmp(data,name,nlen) && data[nlen]==':') break;
    p=memchr(data,'\n',len);
    if(!p) return 0;
    p++;
    len-=p-data;
    data=p;
  }
  data+=nlen+1;
  len-=nlen-1;
  if(!len) return 0;
  if(*data==' ' || *data=='\t' || *data=='\n') data++,len--;
  p=data;
  s=sqlite3_str_new(db);
  while(len) {
    if(*data=='\n') {
      if(len==1) break;
      if(data[1]!=' ' && data[1]!='\t') break;
    } else {
      sqlite3_str_appendchar(s,1,*data);
    }
    data++,len--;
  }
  if(sqlite3_str_errcode(s)) {
    sqlite3_result_error(cxt,sqlite3_errstr(sqlite3_str_errcode(s)),-1);
    sqlite3_result_error_code(cxt,sqlite3_str_errcode(s));
    sqlite3_free(sqlite3_str_finish(s));
    return 0;
  } else {
    return sqlite3_str_finish(s);
  }
}

static int transfer_encoding_of(const char*p,int n) {
  while(*p==' ' || *p=='\t') p++;
  if((*p=='q' || *p=='Q') && !sqlite3_strnicmp("quoted-printable",p,16)) return 1;
  if((*p=='b' || *p=='B') && !sqlite3_strnicmp("base64",p,6)) return 2;
  return 0;
}

static int new_from_template(const char*arg,int followup) {
  FILE*fp;
  FILE*outfp;
  sqlite3_stmt*st;
  char*filename=sqlite3_mprintf("%s/template",home);
  char*line=0;
  size_t linemax=0;
  sqlite3_value*qv[10]={0,0,0,0,0,0,0,0,0,0};
  char b[6]="$0";
  int i,j;
  const char*t;
  if(!filename) errx(1,"Allocation failed");
  fp=fopen(filename,"r");
  if(!fp) {
    color_printf("31","Error: ");
    printf("%m\n");
  }
  sqlite3_free(filename);
  if(!fp) return -1;
  filename=sqlite3_mprintf("%s/article",home);
  if(!filename) errx(1,"Allocation failed");
  outfp=fopen(filename,"w");
  sqlite3_free(filename);
  if(!fp) {
    color_printf("31","Error: ");
    printf("%m\n");
    goto error;
  }
  line_start:
    i=fgetc(fp);
    if(i=='$') {
      i=fgetc(fp);
      if(i=='$') {
        fputc('$',outfp);
        goto line_continue;
      } else if(i>='0' && i<='9') {
        sqlite3_value_free(qv[j=i-'0']);
        qv[j]=0;
        if(getline(&line,&linemax,fp)==-1) goto line_err;
        if(sqlite3_prepare_v2(db,line,-1,&st,0)) {
          color_printf("31","SQL error in template: ");
          printf("%s\n",sqlite3_errmsg(db));
          goto error;
        }
        sqlite3_bind_text(st,sqlite3_bind_parameter_index(st,"$G"),curgroup,-1,0);
        sqlite3_bind_text(st,sqlite3_bind_parameter_index(st,"$A"),arg,-1,SQLITE_TRANSIENT);
        if(followup) sqlite3_bind_int64(st,sqlite3_bind_parameter_index(st,"$N"),curid);
        strcpy(b,"$0");
        for(i=0;i<9;i++) if(qv[i]) {
          b[1]=i+'0';
          sqlite3_bind_value(st,sqlite3_bind_parameter_index(st,b),qv[i]);
        }
        i=sqlite3_step(st);
        if(i==SQLITE_ROW) qv[j]=sqlite3_value_dup(sqlite3_column_value(st,0));
        sqlite3_finalize(st);
        if(i!=SQLITE_ROW && i!=SQLITE_DONE) {
          color_printf("31","SQL error in template: ");
          printf("%s\n",sqlite3_errmsg(db));
          goto error;
        }
      } else if(i=='>') {
        if(fgetc(fp)!='\n') {
          color_printf("31","Error in template: ");
          printf("Extra text after $>\n");
          goto error;
        }
        if(!followup) goto line_start;
        if(sqlite3_prepare_v2(db,"SELECT `DATA` FROM `ART` WHERE `ID` = ?1",-1,&st,0)) {
          color_printf("31","SQL error in template: ");
          printf("%s\n",sqlite3_errmsg(db));
          goto error;
        }
        sqlite3_bind_int64(st,1,curid);
        if(sqlite3_step(st)!=SQLITE_ROW) goto endquote;
        t=sqlite3_column_text(st,0);
        if(!t) t="";
        t=strstr(t,"\n\n");
        if(!t) goto endquote;
        fputc('>',outfp); fputc(' ',outfp);
        while(*t) {
          fputc(i=*t++,outfp);
          if(i=='\n' && *t) {
            if(!ioption[Opt_NoQuoteSignature] || strncmp(t,"-- \n",4)) fputc('>',outfp),fputc(' ',outfp);
            else if(ioption[Opt_NoQuoteSignature]) goto endquote;
          }
        }
        endquote:
        sqlite3_finalize(st);
      } else {
        ungetc(i,fp);
        if(getline(&line,&linemax,fp)==-1) goto line_err;
        if(sqlite3_prepare_v2(db,line,-1,&st,0)) {
          color_printf("31","SQL error in template: ");
          printf("%s\n",sqlite3_errmsg(db));
          goto error;
        }
        sqlite3_bind_text(st,sqlite3_bind_parameter_index(st,"$G"),curgroup,-1,0);
        sqlite3_bind_text(st,sqlite3_bind_parameter_index(st,"$A"),arg,-1,SQLITE_TRANSIENT);
        if(followup) sqlite3_bind_int64(st,sqlite3_bind_parameter_index(st,"$N"),curid);
        strcpy(b,"$0");
        for(i=0;i<9;i++) if(qv[i]) {
          b[1]=i+'0';
          sqlite3_bind_value(st,sqlite3_bind_parameter_index(st,b),qv[i]);
        }
        while((i=sqlite3_step(st))==SQLITE_ROW) {
          if(t=sqlite3_column_text(st,0)) fprintf(outfp,"%s\n",t);
        }
        sqlite3_finalize(st);
        if(i!=SQLITE_DONE) {
          color_printf("31","SQL error in template: ");
          printf("%s\n",sqlite3_errmsg(db));
          goto error;
        }
      }
      goto line_start;
    } else if(i==EOF) {
      goto eof;
    } else {
      fputc(i,outfp);
      if(i=='\n') goto line_start;
    }
  line_continue:
    i=fgetc(fp);
    if(i==EOF) goto eof;
    if(i=='$') {
      i=fgetc(fp);
      if(i=='$') {
        fputc('$',outfp);
      } else if(i>='0' && i<='9') {
        i-='0';
        if(qv[i] && (t=sqlite3_value_text(qv[i]))) fprintf(outfp,"%s",t);
      } else {
        color_printf("31","Error in template: ");
        printf("Unknown symbol: $%c\n",i);
        goto error;
      }
    } else {
      fputc(i,outfp);
      if(i=='\n') goto line_start;
    }
    goto line_continue;
  eof:
  j=0;
  goto done;
  error:
  j=-1;
  done:
  if(fp) fclose(fp);
  if(outfp) fclose(outfp);
  free(line);
  for(i=0;i<10;i++) sqlite3_value_free(qv[i]);
  return j;
  line_err:
  color_printf("31","Error reading line of template file: ");
  printf("%m\n");
  goto error;
}

static void cmd_chdir(const char*arg) {
  while(*arg==' ') ++arg;
  if(chdir(arg)) printf("%m\n");
}

static void cmd_delete(const char*arg) {
  sqlite3_stmt*st;
  int i;
  if(!curid) return;
  if(*arg) {
    printf("No arguments are allowed for delete command");
    return;
  }
  if(sqlite3_prepare_v2(db,"DELETE FROM `ART` WHERE `ID` = ?1;",-1,&st,0)) {
    color_printf("31","SQL error: ");
    printf("%s\n",sqlite3_errmsg(db));
    return;
  }
  sqlite3_bind_int64(st,1,curid);
  while((i=sqlite3_step(st))==SQLITE_ROW);
  sqlite3_finalize(st);
  if(i!=SQLITE_DONE) {
    color_printf("31","SQL error: ");
    printf("%s\n",sqlite3_errmsg(db));
    return;
  }
  curid=0;
}

static void progress(char c,const char*x,int n) {
  static char spin=0;
  spin=(spin+1)&3;
  printf("\e7\e[H\e[1;37;44m%c (%c) %s (%d)\e[K\e[m\e8","/-\\|"[spin],c,x,n);
  fflush(stdout);
}
#define Progress(...) do{ if(ioption[Opt_Progress]) progress(__VA_ARGS__); }while(0)

static int download_one(sqlite3_stmt*st1,const char*art) {
  sqlite3_str*str;
  char*s;
  int i;
  s=sqlite3_mprintf("ARTICLE %s",art);
  if(!s) {
    color_printf("31","Memory allocation error\n");
    return 1;
  }
  send_line(s);
  sqlite3_free(s);
  s=recv_line();
  if(!s) return 1;
  if(strncmp(s,"220",3)) {
    color_printf("31","Unexpected response to ARTICLE: ");
    safe_print(0,s);
    putchar('\n');
    sqlite3_free(s);
    return 1;
  }
  sqlite3_free(s);
  str=sqlite3_str_new(db);
  if(recv_data(str)) {
    sqlite3_free(sqlite3_str_finish(str));
    return 1;
  }
  if(i=sqlite3_str_errcode(str)) {
    sqlite3_free(sqlite3_str_finish(str));
    color_printf("31","SQLite string builder error (%d)\n",i);
    return 1;
  }
  sqlite3_reset(st1);
  s=sqlite3_str_finish(str);
  if(s) {
    sqlite3_bind_text(st1,1,art,-1,SQLITE_TRANSIENT);
    sqlite3_bind_blob(st1,2,s,strlen(s),sqlite3_free);
    while((i=sqlite3_step(st1))==SQLITE_ROW);
    if(i==SQLITE_CONSTRAINT) {
      color_printf("35","%s ",art);
      color_printf(ioption[Opt_FatalConstraintError]?"31":"33","SQL constraint error: ");
      printf("%s\n",sqlite3_errmsg(db));
      if(ioption[Opt_FatalConstraintError]) return 1;
      --dlcount;
    } else if(i!=SQLITE_DONE) {
      color_printf("31","SQL error: ");
      printf("%s\n",sqlite3_errmsg(db));
      return 1;
    }
    ++dlcount;
    Progress('D',"...",dlcount);
    sqlite3_reset(st1);
  }
  return 0;
}

static void do_download(const char*name_in) {
  sqlite3_stmt*st1=0;
  sqlite3_stmt*st2=0;
  sqlite3_stmt*st3=0;
  sqlite3_stmt*st4=0;
  sqlite3_str*str=0;
  char*d=0;
  char*date=0;
  char*name=strdup(name_in); // since it might come from a buffer which will be overwritten later
  char*p;
  char*q;
  int i;
  int c=sqlite3_get_autocommit(db);
  sqlite3_int64 n,nn;
  dlcount=0;
  if(!name) {
    printf("Failed to duplicate string; cannot begin download\n");
    return;
  }
  if(c) sqlite3_exec(db,"BEGIN IMMEDIATE;",0,0,0);
  load_config(name);
  if(sqlite3_prepare_v2(db,"SELECT `NAME`, `PORT`, `LAST`, `WAIT`, COALESCE(`DATE`,'19700101 000000') FROM `SERVERS` WHERE `NAME` = ?1;",-1,&st1,0)) {
    color_printf("31","SQL error: ");
    printf("%s\n",sqlite3_errmsg(db));
    goto done;
  }
  sqlite3_bind_text(st1,1,name,-1,0);
  if(sqlite3_prepare_v2(db,"SELECT `NAME`, `LAST` FROM `NEWSGROUPS` WHERE `SERVER` = ?1;",-1,&st2,0)) {
    color_printf("31","SQL error: ");
    printf("%s\n",sqlite3_errmsg(db));
    goto done;
  }
  sqlite3_bind_text(st2,1,name,-1,0);
  i=sqlite3_step(st1);
  if(i==SQLITE_DONE) {
    color_printf("31","Error: ");
    printf("Server not configured: %s\n",name);
    goto done;
  } else if(i!=SQLITE_ROW) {
    color_printf("31","SQL error: ");
    printf("%s\n",sqlite3_errmsg(db));
    goto done;
  }
  Progress('c',name,0);
  if(dial(sqlite3_column_text(st1,0),sqlite3_column_text(st1,1))) goto done;
  d=recv_line();
  if(!d) goto done;
  Progress('C',name,0);
  if(*d!='2') {
    color_printf("31","Unexpected response to initial connection: ");
    unexpected:
    safe_print(0,d);
    putchar('\n');
    sqlite3_free(d);
    goto done;
  }
  sqlite3_free(d);
  if(send_line("MODE READER")) goto done;
  d=recv_line(); // response of this is irrelevant
  if(!d) goto done;
  sqlite3_free(d);
  sqlite3_exec(db,"DELETE FROM `_DOWNLOADS`;",0,0,0);
  sqlite3_exec(db,"DELETE FROM `_UPDATEGROUPS`;",0,0,0);
  if(sqlite3_prepare_v2(db,"INSERT INTO `_DOWNLOADS` VALUES(?1);",-1,&st3,0)) {
    color_printf("31","SQL error: ");
    printf("%s\n",sqlite3_errmsg(db));
    goto done;
  }
  if(send_line("DATE")) goto done;
  date=recv_line();
  if(!date) goto done;
  if(strncmp(date,"111",3)) {
    color_printf("31","Unexpected response to DATE: ");
    safe_print(0,date);
    putchar('\n');
    goto done;
  }
  if(ioption[Opt_NewNews]) {
    while((i=sqlite3_step(st2))==SQLITE_ROW) {
      d=sqlite3_mprintf("NEWNEWS %s %s GMT",sqlite3_column_text(st2,0),sqlite3_column_text(st1,4));
      send_line(d);
      sqlite3_free(d);
      d=recv_line();
      if(!d) goto done;
      Progress('N',sqlite3_column_text(st2,0),0);
      if(strncmp(d,"230",3)) {
        color_printf("31","Unexpected response to NEWNEWS: ");
        goto unexpected;
      }
      sqlite3_free(d);
      str=sqlite3_str_new(db);
      if(recv_data(str)) goto done;
      d=sqlite3_str_finish(str);
      str=0;
      if(d) {
        p=d;
        while((p=strchr(p,'<')) && (q=strchr(p,'>'))) {
          sqlite3_reset(st3);
          sqlite3_bind_text(st3,1,p,(q-p)+1,0);
          while(sqlite3_step(st3)==SQLITE_ROW);
          p=q;
          // Since an article may be cross-posted, SQLITE_CONSTRAINT errors may occur; such
          // errors are deliberately ignored since it is to be expected in normal operation.
        }
        sqlite3_free(d);
      }
    }
    if(i!=SQLITE_DONE) {
      color_printf("33","SQL error: ");
      printf("%s\n",sqlite3_errmsg(db));
      // Continue; this error is not considered to be fatal
    }
  } else {
    if(sqlite3_prepare_v2(db,"REPLACE INTO `_UPDATEGROUPS` VALUES(?1,?2);",-1,&st4,0)) {
      color_printf("31","SQL error: ");
      printf("%s\n",sqlite3_errmsg(db));
      goto done;
    }
    while((i=sqlite3_step(st2))==SQLITE_ROW) {
      d=sqlite3_mprintf("GROUP %s",sqlite3_column_text(st2,0));
      send_line(d);
      sqlite3_free(d);
      d=recv_line();
      if(!d) goto done;
      if(sscanf(d,"211 %d %lld %lld ",&i,&nn,&n)<3) {
        color_printf("31","Unexpected response to GROUP %s: ",sqlite3_column_text(st2,0));
        goto unexpected;
      }
      --nn; // ensure the lowest numbered article can be read
      sqlite3_free(d);
      if(sqlite3_column_type(st2,1)!=SQLITE_NULL && sqlite3_column_int64(st2,1)>nn) nn=sqlite3_column_int64(st2,1);
      if(n<=0 || n<=nn || !i) continue; // no new articles
      try_again:
      d=sqlite3_mprintf("STAT %lld",n);
      send_line(d);
      sqlite3_free(d);
      d=recv_line();
      if(!d) goto done;
      p=strchr(d,'<');
      q=strchr(d,'>');
      if(i && !strncmp(d,"423",3)) {
        // The high water number is not valid; try requesting a list of article numbers instead
        Progress('G',sqlite3_column_text(st2,0),0);
        d=sqlite3_mprintf("LISTGROUP %s %lld-",sqlite3_column_text(st2,0),sqlite3_column_int64(st2,1)?:1);
        send_line(d);
        sqlite3_free(d);
        d=recv_line();
        if(!d) goto done;
        if(strncmp(d,"211",3)) {
          color_printf("31","Unexpected response to LISTGROUP: ");
          goto unexpected;
        }
        sqlite3_free(d);
        n=0;
        for(;;) {
          d=recv_line();
          if(!d) goto done;
          if(*d=='.') break;
          if(strtoll(d,0,10)>n) n=strtoll(d,0,10);
          Progress('G',sqlite3_column_text(st2,0),n);
          sqlite3_free(d);
        }
        sqlite3_free(d);
        if(n<=nn) continue; // no new articles
        i=0; // remember not to try LISTGROUP again a second time
        goto try_again;
      } else if(strncmp(d,"223",3) || !p || !q || q<p) {
        color_printf("31","Unexpected response to STAT: ");
        goto unexpected;
      }
      sqlite3_reset(st3);
      sqlite3_bind_text(st3,1,p,(q-p)+1,0);
      while(sqlite3_step(st3)==SQLITE_ROW);
      sqlite3_reset(st3);
      sqlite3_free(d);
      sqlite3_bind_text(st4,1,sqlite3_column_text(st2,0),-1,0);
      sqlite3_bind_int64(st4,2,n);
      while(sqlite3_step(st4)==SQLITE_ROW);
      sqlite3_reset(st4);
      sqlite3_clear_bindings(st4);
      while(n>nn) {
        Progress('L',sqlite3_column_text(st2,0),n-nn);
        if(send_line("LAST")) goto done;
        d=recv_line();
        if(!d) goto done;
        if(!strncmp(d,"422",3)) break;
        p=strchr(d,'<');
        q=strchr(d,'>');
        if(sscanf(d,"223 %lld ",&n)<1 || !p || !q || q<p) {
          color_printf("31","Unexpected response to LAST: ");
          goto unexpected;
        }
        if(n<=nn) break;
        sqlite3_reset(st3);
        sqlite3_bind_text(st3,1,p,(q-p)+1,0);
        while(sqlite3_step(st3)==SQLITE_ROW);
        sqlite3_reset(st3);
        sqlite3_free(d);
      }
    }
    sqlite3_finalize(st4);
    st4=0;
    if(i!=SQLITE_DONE) {
      color_printf("33","SQL error: ");
      printf("%s\n",sqlite3_errmsg(db));
      // Continue; this error is not considered to be fatal
    }
  }
  sqlite3_finalize(st3);
  sqlite3_reset(st2);
  if(sqlite3_prepare_v2(db,"SELECT * FROM `_DOWNLOADS`;",-1,&st3,0)) {
    color_printf("31","SQL error: ");
    printf("%s\n",sqlite3_errmsg(db));
    goto done;
  }
  if(sqlite3_prepare_v2(db,"INSERT INTO `INCOMING`(`ID`,`DATA`,`SERVER`) VALUES(?1,?2,?3);",-1,&st4,0)) {
    color_printf("31","SQL error: ");
    printf("%s\n",sqlite3_errmsg(db));
    goto done;
  }
  sqlite3_bind_text(st4,3,name,-1,0);
  while(sqlite3_step(st3)==SQLITE_ROW) {
    if(download_one(st4,sqlite3_column_text(st3,0))) goto done;
  }
  sqlite3_exec(db,"DELETE FROM `_DOWNLOADS`;",0,0,0);
  sqlite3_exec(db,"INSERT INTO `NEWSGROUPS`(`NAME`, `LAST`) SELECT `NAME`, `LAST` FROM `_UPDATEGROUPS` WHERE 1 ON CONFLICT(`NAME`) DO UPDATE SET `LAST` = EXCLUDED.`LAST`;",0,0,0);
  sqlite3_exec(db,"DELETE FROM `_UPDATEGROUPS`;",0,0,0);
  send_line("QUIT");
  sqlite3_finalize(st1);
  if(sqlite3_prepare_v2(db,"UPDATE `SERVERS` SET `LAST` = NOW(), `DATE` = SUBSTR(?2,1,LENGTH(?2)-6)||' '||SUBSTR(?2,LENGTH(?2)-5,6) WHERE `NAME` = ?1;",-1,&st1,0)) goto done;
  sqlite3_bind_text(st1,1,name,-1,0);
  i=strspn(date+3+strspn(date+3," \t"),"0123456789");
  sqlite3_bind_text(st1,2,date+3+strspn(date+3," \t"),i,0);
  while(sqlite3_step(st1)==SQLITE_ROW);
  done:
  hangup();
  sqlite3_finalize(st1);
  sqlite3_finalize(st2);
  sqlite3_finalize(st3);
  sqlite3_finalize(st4);
  free(name);
  if(str) sqlite3_free(sqlite3_str_finish(str));
  sqlite3_free(date);
  if(c) sqlite3_exec(db,"COMMIT;",0,0,0);
  if(ioption[Opt_CountDownloads]) printf("Downloaded %d articles.\n",dlcount);
}

static void cmd_download(const char*arg) {
  sqlite3_stmt*st;
  int i;
  if(*arg) {
    do_download(arg);
  } else {
    if(sqlite3_prepare_v2(db,"SELECT `NAME` FROM `SERVERS` WHERE ?1 > `LAST`+`WAIT` ORDER BY `NAME`;",-1,&st,0)) {
      color_printf("31","SQL error: ");
      printf("%s\n",sqlite3_errmsg(db));
      return;
    }
    sqlite3_bind_int64(st,1,time(0));
    while((i=sqlite3_step(st))==SQLITE_ROW) {
      color_printf("1","(%s)\n",sqlite3_column_text(st,0));
      do_download(sqlite3_column_text(st,0));
    }
    if(i!=SQLITE_DONE) {
      color_printf("31","SQL error: ");
      printf("%s\n",sqlite3_errmsg(db));
    }
    sqlite3_finalize(st);
  }
}

static void cmd_echo(const char*arg) {
  puts(arg);
}

static void cmd_edit(const char*arg) {
  FILE*fp;
  sqlite3_stmt*st;
  int i;
  const unsigned char*data;
  int len;
  sqlite3_str*m;
  if(!option[Opt_Editor]) {
    color_printf("31","Error: ");
    printf("Editor not defined\n");
    return;
  }
  if(*arg==7) {
    snprintf(buf,0x1000,"%s/article",home);
    goto new_article;
  }
  if(sqlite3_prepare_v2(db,"SELECT `DATA`, `POSTED` FROM `ART` WHERE `ID` = ?1;",-1,&st,0)) {
    color_printf("31","SQL error: ");
    printf("%s\n",sqlite3_errmsg(db));
    return;
  }
  sqlite3_bind_int64(st,1,curid);
  i=sqlite3_step(st);
  if(i!=SQLITE_ROW) {
    if(i==SQLITE_DONE) {
      color_printf("31","Error: ");
      printf("Article not found\n");
    } else {
      color_printf("31","SQL error: 3");
      printf("%s\n",sqlite3_errmsg(db));
    }
    goto done;
  }
  if(sqlite3_column_int(st,1)) {
    color_printf("31","Error: ");
    printf("Cannot edit a posted article; duplicate it first\n");
    goto done;
  }
  if(data=sqlite3_column_blob(st,0)) {
    len=sqlite3_column_bytes(st,0);
    snprintf(buf,0x1000,"%s/article",home);
    fp=fopen(buf,"w");
    if(!fp) {
      color_printf("31","I/O error: ");
      printf("%m\n");
      goto done;
    }
    if(fwrite(data,len,1,fp)<=0) {
      color_printf("31","I/O error: ");
      printf("%m\n");
      fclose(fp);
      goto done;
    }
    fclose(fp);
    sqlite3_finalize(st);
    new_article:
    st=0;
    if(i=system(option[Opt_Editor])) {
      if(i==-1) printf("%m\n"); else color_printf("31","Status %d.\n",WEXITSTATUS(i));
      return;
    }
    fp=fopen(buf,"r");
    if(!fp) {
      color_printf("31","I/O error: ");
      printf("%m\n");
      return;
    }
    m=sqlite3_str_new(db);
    for(;;) {
      i=fread(buf,1,0x1000,fp);
      if(i>0) sqlite3_str_append(m,buf,i); else break;
    }
    i=ferror(fp);
    fclose(fp);
    if(i) {
      color_printf("31","I/O error\n");
      sqlite3_free(sqlite3_str_finish(m));
      return;
    }
    i=sqlite3_str_errcode(m);
    len=sqlite3_str_length(m);
    if(i || !len) {
      if(i) printf("Error: %s\n",sqlite3_errstr(i));
      sqlite3_free(sqlite3_str_finish(m));
      return;
    }
    if(sqlite3_prepare_v2(db,"INSERT INTO `EDITED`(`ID`,`DATA`,`POSTED`) VALUES(?1,?2,0);",-1,&st,0)) {
      color_printf("31","SQL error: ");
      printf("%s\n",sqlite3_errmsg(db));
      sqlite3_free(sqlite3_str_finish(m));
      return;
    }
    sqlite3_bind_int64(st,1,curid);
    sqlite3_bind_blob(st,2,sqlite3_str_finish(m),len,sqlite3_free);
    while((i=sqlite3_step(st))==SQLITE_ROW);
    if(i==SQLITE_DONE) goto done;
    color_printf("31","SQL error: ");
    printf("%s\n",sqlite3_errmsg(db));
  }
  done:
  sqlite3_finalize(st);
}

static void export_one(FILE*fp,sqlite3_int64 n,const char*d,int len) {
  const char*p;
  const char*e=d+len;
  fprintf(fp,"From %lld\n",(long long)n);
  while(d<e) {
    p=strchr(d,'\n');
    if(!p) break;
    p++;
    while(p!=e && *p=='>') p++;
    fwrite(d,1,p-d,fp);
    if(e-p>4 && !memcmp(p,"From ",5)) fputc('>',fp);
    d=p;
  }
  if(d!=e) fwrite(d,1,e-d,fp);
  fputc('\n',fp);
}

static void cmd_export(const char*arg) {
  char*s;
  sqlite3_stmt*st=0;
  int i;
  FILE*fp=0;
  const char*d;
  sqlite3_int64 n;
  while(*arg==' ') ++arg;
  if(!*arg) {
    color_printf("31","Error: ");
    printf("Argument required\n");
    return;
  }
  if(*arg=='|') fp=popen(arg+1,"w"); else fp=fopen(arg,"w");
  if(!fp) {
    color_printf("31","I/O error: ");
    printf("%m\n");
    return;
  }
  s=select_filter?:option[Opt_ExportFilter]?:"";
  s=sqlite3_mprintf("select `art`.`id`, `art`.`data` from `art` %s;",s);
  if(!s) errx(1,"Allocation failed");
  if(i=sqlite3_prepare_v2(db,s,-1,&st,0)) {
    color_printf("31","SQL error: ");
    printf("%s\n",sqlite3_errmsg(db));
    goto done;
  }
  sqlite3_bind_int64(st,sqlite3_bind_parameter_index(st,"$N"),curid);
  sqlite3_bind_text(st,sqlite3_bind_parameter_index(st,"$G"),curgroup,-1,0);
  while((i=sqlite3_step(st))==SQLITE_ROW) {
    n=sqlite3_column_int64(st,0);
    d=sqlite3_column_blob(st,1);
    i=sqlite3_column_bytes(st,1);
    if(d && i) export_one(fp,n,d,i);
  }
  if(i!=SQLITE_DONE) {
    color_printf("31","SQL error: ");
    printf("%s\n",sqlite3_errmsg(db));
  }
  done:
  sqlite3_free(s);
  sqlite3_finalize(st);
  if(*arg=='|') pclose(fp); else fclose(fp);
}

static void cmd_filter(const char*arg) {
  if(*arg=='?' || !*arg) {
    if(select_filter) puts(select_filter);
  } else if(*arg=='/') {
    free(select_filter);
    select_filter=0;
  } else {
    free(select_filter);
    select_filter=strdup(arg);
  }
}

static void cmd_followup(const char*arg) {
  int i;
  sqlite3_exec(db,"BEGIN;",0,0,0);
  if(new_from_template(arg,1)) {
    sqlite3_exec(db,"ROLLBACK;",0,0,0);
    return;
  }
  if(i=sqlite3_exec(db,"INSERT INTO `ART`(`POSTED`) VALUES(0);",0,0,0)) {
    color_printf("31","SQL error (%d): ",i);
    printf("%s\n",sqlite3_errmsg(db));
    sqlite3_exec(db,"ROLLBACK;",0,0,0);
    return;
  }
  curid=sqlite3_last_insert_rowid(db);
  cmd_edit("\x07");
  sqlite3_exec(db,"COMMIT;",0,0,0);
}

static void do_download_single(const char*host,const char*port,const char*msgid_in) {
  char*msgid=strdup(msgid_in);
  char*d;
  sqlite3_stmt*st1;
  int c=sqlite3_get_autocommit(db);
  if(!msgid) {
    printf("Failed to duplicate string; cannot begin download\n");
    return;
  }
  if(c) sqlite3_exec(db,"BEGIN IMMEDIATE;",0,0,0);
  load_config(host);
  dlcount=0;
  Progress('c',host,0);
  if(dial(host,port)) goto done;
  d=recv_line();
  Progress('C',host,0);
  if(!d) goto done;
  if(*d!='2') {
    color_printf("31","Unexpected response to initial connection: ");
    safe_print(0,d);
    putchar('\n');
    sqlite3_free(d);
    goto done;
  }
  sqlite3_free(d);
  if(send_line("MODE READER")) goto done;
  d=recv_line(); // response of this is irrelevant
  if(!d) goto done;
  sqlite3_free(d);
  if(sqlite3_prepare_v2(db,"INSERT INTO `INCOMING`(`ID`,`DATA`,`SERVER`) VALUES(?1,?2,?3);",-1,&st1,0)) {
    color_printf("31","SQL error: ");
    printf("%s\n",sqlite3_errmsg(db));
    goto done;
  }
  sqlite3_bind_text(st1,3,host,-1,0);
  download_one(st1,msgid);
  done:
  hangup();
  sqlite3_finalize(st1);
  free(msgid);
  if(c) sqlite3_exec(db,"COMMIT;",0,0,0);
}

static void cmd_get(const char*arg) {
  if(!option[Opt_GetServer]) {
    color_printf("31","Error: ");
    printf("GetServer option not defined\n");
    return;
  }
  while(*arg==' ') arg++;
  if(*arg!='<') {
    color_printf("31","Error: ");
    printf("Invalid message ID\n");
    return;
  }
  do_download_single(option[Opt_GetServer],option[Opt_GetPort],arg);
}

static void cmd_group(const char*arg) {
  while(*arg==' ') arg++;
  if(*arg) strncpy(curgroup,arg,510);
}

static void cmd_headers(const char*arg) {
  sqlite3_stmt*st;
  int i;
  const char*p;
  if(!option[Opt_HeadersQuery]) {
    color_printf("31","Error: ");
    printf("HeadersQuery option not defined\n");
    return;
  }
  if(sqlite3_prepare_v2(db,option[Opt_HeadersQuery],-1,&st,0)) {
    color_printf("31","SQL error: ");
    printf("%s\n",sqlite3_errmsg(db));
    return;
  }
  sqlite3_bind_int64(st,sqlite3_bind_parameter_index(st,"$ID"),curid);
  sqlite3_bind_text(st,sqlite3_bind_parameter_index(st,"$ARG"),arg,-1,0);
  sqlite3_bind_text(st,sqlite3_bind_parameter_index(st,"$GROUP"),curgroup,-1,0);
  sqlite3_bind_int(st,sqlite3_bind_parameter_index(st,"$MORE"),listmore-1);
  while((i=sqlite3_step(st))==SQLITE_ROW) {
    p=sqlite3_column_text(st,1);
    if(p) {
      if(sqlite3_column_int64(st,0)==curid) putchar('>'); else putchar(' ');
      putchar(' ');
      puts(p);
    }
  }
  if(i!=SQLITE_DONE) {
    color_printf("31","SQL error (%d): ",i);
    printf("%s\n",sqlite3_errmsg(db));
  }
  sqlite3_finalize(st);
}

static void cmd_Headers(const char*arg) {
  sqlite3_stmt*st;
  int i;
  const char*p;
  if(!option[Opt_AltHeadersQuery]) {
    color_printf("31","Error: ");
    printf("AltHeadersQuery option not defined\n");
    return;
  }
  if(sqlite3_prepare_v2(db,option[Opt_AltHeadersQuery],-1,&st,0)) {
    color_printf("31","SQL error: ");
    printf("%s\n",sqlite3_errmsg(db));
    return;
  }
  sqlite3_bind_int64(st,sqlite3_bind_parameter_index(st,"$ID"),curid);
  sqlite3_bind_text(st,sqlite3_bind_parameter_index(st,"$ARG"),arg,-1,0);
  sqlite3_bind_text(st,sqlite3_bind_parameter_index(st,"$GROUP"),curgroup,-1,0);
  sqlite3_bind_int(st,sqlite3_bind_parameter_index(st,"$MORE"),listmore-1);
  while((i=sqlite3_step(st))==SQLITE_ROW) {
    p=sqlite3_column_text(st,1);
    if(p) {
      if(sqlite3_column_int64(st,0)==curid) putchar('>'); else putchar(' ');
      putchar(' ');
      puts(p);
    }
  }
  if(i!=SQLITE_DONE) {
    color_printf("31","SQL error (%d): ",i);
    printf("%s\n",sqlite3_errmsg(db));
  }
  sqlite3_finalize(st);
}

static void cmd_list(const char*arg) {
  sqlite3_stmt*st;
  int i;
  if(!*arg) arg="*";
  if(i=sqlite3_prepare_v2(db,"SELECT `NAME` FROM `NEWSGROUPS` WHERE `NAME` GLOB ?1 ORDER BY `NAME`;",-1,&st,0)) {
    color_printf("31","SQL error: ");
    printf("%s\n",sqlite3_errmsg(db));
    return;
  }
  sqlite3_bind_text(st,1,arg,-1,0);
  for(;;) {
    i=sqlite3_step(st);
    if(i==SQLITE_ROW) {
      puts(sqlite3_column_text(st,0));
    } else {
      if(i!=SQLITE_DONE) {
        color_printf("31","SQL error: ");
        printf("%s\n",sqlite3_errmsg(db));
      }
      break;
    }
  }
  sqlite3_finalize(st);
}

static void cmd_List(const char*arg) {
  sqlite3_stmt*st;
  int i;
  if(i=sqlite3_prepare_v2(db,"SELECT DISTINCT GROUP_PREFIX(`NAME`,?1) FROM `NEWSGROUPS` WHERE `NAME` GLOB ?1 || '*' ORDER BY 1;",-1,&st,0)) {
    color_printf("31","SQL error: ");
    printf("%s\n",sqlite3_errmsg(db));
    return;
  }
  sqlite3_bind_text(st,1,arg,-1,0);
  for(;;) {
    i=sqlite3_step(st);
    if(i==SQLITE_ROW) {
      if(sqlite3_column_text(st,0)) puts(sqlite3_column_text(st,0));
    } else {
      if(i!=SQLITE_DONE) {
        color_printf("31","SQL error: ");
        printf("%s\n",sqlite3_errmsg(db));
      }
      break;
    }
  }
  sqlite3_finalize(st);
}

static void cmd_markread(const char*arg) {
  sqlite3_stmt*st;
  if(sqlite3_prepare_v2(db,"UPDATE `ART` SET `READ` = 1 WHERE `ID` = ?1;",-1,&st,0)) {
    color_printf("31","SQL error: ");
    printf("%s\n",sqlite3_errmsg(db));
    return;
  }
  sqlite3_bind_int64(st,1,curid);
  if(sqlite3_step(st)!=SQLITE_DONE) {
    color_printf("31","SQL error: ");
    printf("%s\n",sqlite3_errmsg(db));
  }
  sqlite3_finalize(st);
}

static void cmd_markunread(const char*arg) {
  sqlite3_stmt*st;
  if(sqlite3_prepare_v2(db,"UPDATE `ART` SET `READ` = 0 WHERE `ID` = ?1;",-1,&st,0)) {
    color_printf("31","SQL error: ");
    printf("%s\n",sqlite3_errmsg(db));
    return;
  }
  sqlite3_bind_int64(st,1,curid);
  if(sqlite3_step(st)!=SQLITE_DONE) {
    color_printf("31","SQL error: ");
    printf("%s\n",sqlite3_errmsg(db));
  }
  sqlite3_finalize(st);
}

static void cmd_new(const char*arg) {
  int i;
  sqlite3_exec(db,"BEGIN;",0,0,0);
  if(new_from_template(arg,0)) {
    sqlite3_exec(db,"ROLLBACK;",0,0,0);
    return;
  }
  if(i=sqlite3_exec(db,"INSERT INTO `ART`(`POSTED`) VALUES(0);",0,0,0)) {
    color_printf("31","SQL error (%d): ",i);
    printf("%s\n",sqlite3_errmsg(db));
    sqlite3_exec(db,"ROLLBACK;",0,0,0);
    return;
  }
  curid=sqlite3_last_insert_rowid(db);
  cmd_edit("\x07");
  sqlite3_exec(db,"COMMIT;",0,0,0);
}

static void cmd_noop(const char*arg) {
  // Do nothing
}

static void cmd_pipe(const char*arg) {
  FILE*fp;
  sqlite3_stmt*st;
  int i;
  const unsigned char*data;
  int len;
  sighandler_t ha;
  while(*arg==' ') ++arg;
  if(!*arg) return;
  ha=signal(SIGPIPE,SIG_IGN);
  if(sqlite3_prepare_v2(db,"SELECT `DATA` FROM `ART` WHERE `ID` = ?1;",-1,&st,0)) {
    color_printf("31","SQL error: ");
    printf("%s\n",sqlite3_errmsg(db));
    return;
  }
  sqlite3_bind_int64(st,1,curid);
  i=sqlite3_step(st);
  if(i!=SQLITE_ROW) {
    if(i==SQLITE_DONE) {
      color_printf("31","Error: ");
      printf("Article not found\n");
    } else {
      color_printf("31","SQL error: ");
      printf("%s\n",sqlite3_errmsg(db));
    }
    goto done;
  }
  if(data=sqlite3_column_blob(st,0)) {
    len=sqlite3_column_bytes(st,0);
    fp=popen(arg,"w");
    if(!fp) {
      color_printf("31","Error: ");
      printf("%m\n");
      goto done;
    }
    fwrite(data,1,len,fp);
    pclose(fp);
  }
  done:
  sqlite3_finalize(st);
  if(ha!=SIG_ERR) signal(SIGPIPE,ha);
}

static int do_post(const char*name,const char*port) {
  sqlite3_blob*blob=0;
  char*s;
  int e=-1;
  int i;
  if(!name) return -1;
  if(sqlite3_blob_open(db,"main","ART","DATA",curid,0,&blob)) {
    color_printf("31","Error opening blob: ");
    printf("%s\n",sqlite3_errmsg(db));
    return -1;
  }
  load_config(name);
  if(dial(name,port)) goto error;
  s=recv_line();
  if(!s) goto error;
  i=strncmp(s,"201",3);
  if(i && strncmp(s,"200",3)) {
    safe_print("1;31",s);
    putchar('\n');
    goto error;
  }
  if(!i) {
    safe_print("1;33",s);
    putchar('\n');
  }
  sqlite3_free(s);
  if(!i) {
    if(send_line("MODE READER")) goto error;
    s=recv_line();
    if(!s) goto error;
    if(i=strncmp(s,"200",3)) {
      safe_print("1;31",s);
      putchar('\n');
    }
    sqlite3_free(s);
    if(i) goto error;
  }
  if(send_line("POST")) goto error;
  s=recv_line();
  if(!s) goto error;
  if(i=strncmp(s,"340",3)) {
    safe_print("1;31",s);
    putchar('\n');
  }
  sqlite3_free(s);
  if(i) goto error;
  if(send_data(blob)) goto error;
  s=recv_line();
  if(!s) goto error;
  e=strncmp(s,"240",3);
  safe_print(e?"1;31":"1;32",s);
  putchar('\n');
  sqlite3_free(s);
  send_line("QUIT");
  //done:
  //e=0;
  error:
  sqlite3_blob_close(blob);
  hangup();
  return e;
}

static void cmd_post(const char*arg) {
  int i;
  sqlite3_stmt*st;
  if(!curid) return;
  if(!option[Opt_PostTo]) {
    color_printf("31","Error: ");
    printf("PostTo option is not defined\n");
    return;
  }
  if(sqlite3_exec(db,"BEGIN;",0,0,0)) {
    color_printf("31","Error: ");
    printf("Cannot begin a new transaction; commit or rollback the previous one first\n");
    return;
  }
  if(sqlite3_prepare_v2(db,"SELECT `POSTED` FROM `ART` WHERE `ID` = ?1;",-1,&st,0)) goto sqlerr;
  sqlite3_bind_int64(st,1,curid);
  i=sqlite3_step(st);
  if(i!=SQLITE_ROW) {
    if(i==SQLITE_DONE) {
      color_printf("31","Error: ");
      printf("Article not found\n");
      sqlite3_exec(db,"ROLLBACK;",0,0,0);
      return;
    } else {
      sqlite3_finalize(st);
      goto sqlerr;
    }
  }
  if(sqlite3_column_int(st,0)) {
    color_printf("31","Error: ");
    printf("Article is already posted\n");
    sqlite3_finalize(st);
    sqlite3_exec(db,"ROLLBACK;",0,0,0);
    return;
  }
  sqlite3_finalize(st);
  if(sqlite3_prepare_v2(db,"INSERT INTO `EDITED`(`ID`,`DATA`,`POSTED`) SELECT `ID`,CAST(PREPEND_HEADERS(?1,?2)||`DATA` AS BLOB),1 FROM `ART` WHERE `ID`=?2;",-1,&st,0)) {
    sqlerr:
    color_printf("31","SQL error: ");
    printf("%s\n",sqlite3_errmsg(db));
    sqlite3_exec(db,"ROLLBACK;",0,0,0);
    return;
  }
  sqlite3_bind_text(st,1,arg,-1,0);
  sqlite3_bind_int64(st,2,curid);
  while((i=sqlite3_step(st))==SQLITE_ROW);
  sqlite3_finalize(st);
  if(i!=SQLITE_DONE) goto sqlerr;
  if(sqlite3_prepare_v2(db,option[Opt_PostTo],-1,&st,0)) goto sqlerr;
  if(!st) {
    sqlite3_exec(db,"ROLLBACK;",0,0,0);
    return;
  }
  sqlite3_bind_text(st,sqlite3_bind_parameter_index(st,"$A"),arg,-1,0);
  sqlite3_bind_int64(st,sqlite3_bind_parameter_index(st,"$N"),curid);
  i=sqlite3_step(st);
  if(i==SQLITE_ROW) {
    if(do_post(sqlite3_column_text(st,0),sqlite3_column_text(st,1))) {
      sqlite3_finalize(st);
      sqlite3_exec(db,"ROLLBACK;",0,0,0);
      return;
    }
  } else if(i==SQLITE_DONE) {
    sqlite3_finalize(st);
    color_printf("31","Error: ");
    printf("PostTo query returned zero rows\n");
    sqlite3_exec(db,"ROLLBACK;",0,0,0);
    return;
  } else {
    sqlite3_finalize(st);
    goto sqlerr;
  }
  sqlite3_finalize(st);
  if(sqlite3_exec(db,"COMMIT;",0,0,0)) goto sqlerr;
}

static void cmd_pwd(const char*arg) {
  if(getcwd(buf,0x1000)) puts(buf);
}

static void cmd_quit(const char*arg) {
  unterminated=0;
}

static void cmd_repost(const char*arg) {
  int i;
  sqlite3_stmt*st;
  if(!curid) return;
  while(*arg==' ') arg++;
  if(!*arg) return;
  if(sqlite3_prepare_v2(db,"SELECT `POSTED`, HEADER(`DATA`,'Message-ID') IS NULL FROM `ART` WHERE `ID` = ?1;",-1,&st,0)) goto sqlerr;
  sqlite3_bind_int64(st,1,curid);
  i=sqlite3_step(st);
  if(i!=SQLITE_ROW) {
    if(i==SQLITE_DONE) {
      color_printf("31","Error: ");
      printf("Article not found\n");
      return;
    } else {
      sqlite3_finalize(st);
      sqlerr:
      color_printf("31","SQL error: ");
      printf("%s\n",sqlite3_errmsg(db));
      return;
    }
  }
  if(sqlite3_column_int(st,0)!=1) {
    color_printf("31","Error: ");
    printf("Cannot repost article with this status\n");
    sqlite3_finalize(st);
    return;
  }
  if(sqlite3_column_int(st,1)) {
    color_printf("31","Error: ");
    printf("Cannot repost article without a message ID\n");
    sqlite3_finalize(st);
    return;
  }
  sqlite3_finalize(st);
  if(do_post(arg,option[Opt_RepostPort])) return;
}

static void cmd_set(const char*arg) {
  const char*p=strchrnul(arg,'=');
  int n=p-arg;
  int i;
  if(!*arg) {
    for(i=0;i<Opt__MAX;i++) {
      if(option[i]) {
        printf("%s=",optname[i]);
        color_printf("1","%s\n",option[i]);
      }
    }
    return;
  }
  for(i=0;i<Opt__MAX;i++) {
    if(strlen(optname[i])==n && !strncmp(optname[i],arg,n)) goto found;
  }
  color_printf("31","Error: ");
  printf("Invalid configuration option.\n");
  return;
  found:
  if(*p) {
    free(option[i]);
    option[i]=strdup(p+1);
    ioption[i]=strtol(option[i],0,10);
  } else {
    if(option[i]) printf("%s\n",option[i]);
  }
}

static void cmd_sh(const char*arg) {
  if(system(arg)==-1) printf("%m\n");
}

static void cmd_sql(const char*arg) {
  sqlite3_stmt*st;
  int i;
  if(i=sqlite3_prepare_v2(db,arg,-1,&st,0)) {
    color_printf("31","SQL error: ");
    printf("%s\n",sqlite3_errmsg(db));
  }
  if(!st) return;
  for(;;) {
    i=sqlite3_step(st);
    if(i==SQLITE_ROW) {
      for(i=0;i<sqlite3_data_count(st);i++) {
        if(i) color_printf("36","|");
        switch(sqlite3_column_type(st,i)) {
          case SQLITE_NULL:
            color_printf("35","<NULL>");
            break;
          case SQLITE_INTEGER:
            color_printf("1;32","%lld",(long long)sqlite3_column_int64(st,i));
            break;
          case SQLITE_FLOAT:
            color_printf("1;33","%g",sqlite3_column_double(st,i));
            break;
          case SQLITE_TEXT:
            safe_print("1;37;44",sqlite3_column_text(st,i));
            break;
          case SQLITE_BLOB:
            color_printf("35","<BLOB>");
            break;
        }
      }
      putchar('\n');
    } else {
      if(i!=SQLITE_DONE) {
        color_printf("31","SQL error: ");
        printf("%s\n",sqlite3_errmsg(db));
      }
      break;
    }
  }
  sqlite3_finalize(st);
}

static void cmd_select(const char*arg) {
  cmd_sql(arg-7);
}

static void cmd_Sql(const char*arg) {
  char*sql=strdup(arg);
  if(!sql) {
    printf("Cannot duplicate string\n");
    return;
  }
  if(sqlite3_exec(db,sql,do_command_ex,0,0)) {
    color_printf("31","SQL error: ");
    printf("%s\n",sqlite3_errmsg(db));
  }
  free(sql);
}

static void cmd_unset(const char*arg) {
  int i;
  for(i=0;i<Opt__MAX;i++) {
    if(!strcmp(optname[i],arg)) goto found;
  }
  color_printf("31","Error: ");
  printf("Invalid configuration option.\n");
  return;
  found:
  free(option[i]);
  option[i]=0;
  ioption[i]=0;
}

static void view_quoted_printable_part(FILE*fp,const unsigned char*d,int n) {
  const unsigned char*e=d+n;
  while(d<e) {
    if(*d=='=') {
      d++;
      if(d==e) return;
      if(*d=='\n' || *d==' ') {
        while(d<e && *d==' ') d++;
        if(d<e && *d=='\n') d++;
      } else {
        sscanf(d,"%02X",&n);
        d+=2;
        if(!ioption[Opt_ViewSafe] || *d=='\n' || *d=='\t' || (*d>=32 && *d<127)) {
          fputc(n,fp);
        } else {
          if(ioption[Opt_ViewColors]) fprintf(fp,"\e[7m");
          fputc('!',fp);
          if(ioption[Opt_ViewColors]) fprintf(fp,"\e[m");
        }
      }
    } else if(!ioption[Opt_ViewSafe] || *d=='\n' || *d=='\t' || (*d>=32 && *d<127)) {
      fputc(*d++,fp);
    } else {
      if(ioption[Opt_ViewColors]) fprintf(fp,"\e[7m");
      fputc('?',fp);
      if(ioption[Opt_ViewColors]) fprintf(fp,"\e[m");
      d++;
    }
  }
}

static inline void view_part(FILE*fp,const unsigned char*d,int n) {
  if(ioption[Opt_ViewSafe]) {
    while(n--) {
      if(*d=='\n' || *d=='\t' || (*d>=32 && *d<127)) {
        fputc(*d,fp);
      } else {
        if(ioption[Opt_ViewColors]) fprintf(fp,"\e[7m");
        fputc('?',fp);
        if(ioption[Opt_ViewColors]) fprintf(fp,"\e[m");
      }
      d++;
    }
  } else {
    fwrite(d,1,n,fp);
  }
}

static void view_article(FILE*fp,const unsigned char*data,int len,int allh) {
  sqlite3_stmt*st=0;
  int i;
  const unsigned char*p=data;
  const unsigned char*q=data;
  const unsigned char*end=data+len;
  int enc=0;
  if(!allh) sqlite3_prepare_v2(db,option[Opt_ViewHeaders],-1,&st,0);
  if(!st) allh=1;
  while(q<end) {
    while(p<end-1) {
      if(*p=='\n' && p[1]=='\n') goto end;
      if(*p==':') break;
      p++;
    }
    if(allh) {
      i=1;
    } else {
      sqlite3_reset(st);
      sqlite3_bind_text(st,sqlite3_bind_parameter_index(st,"$NAME"),q,p-q,0);
      i=(sqlite3_step(st)==SQLITE_ROW && sqlite3_column_int(st,0));
    }
    if(ioption[Opt_TransferDecode] && p-q==25 && !sqlite3_strnicmp(q,"Content-Transfer-Encoding",25)) enc=-1;
    if(i) {
      if(ioption[Opt_ViewColors]) fprintf(fp,"\e[33m");
      view_part(fp,q,p-q);
      if(ioption[Opt_ViewColors]) fprintf(fp,"\e[36m");
      fputc(':',fp);
      if(ioption[Opt_ViewColors]) fprintf(fp,"\e[m");
    }
    q=++p;
    while(p<end-1) {
      p++;
      if(p[-1]=='\n') {
        if(*p!='\t' && *p!=' ') break;
      }
    }
    if(enc==-1) enc=transfer_encoding_of(q,p-q);
    if(i) view_part(fp,q,p-q);
    if(*p=='\n') p--;
    q=p;
  }
  end:
  if(st) sqlite3_finalize(st);
  q++;
  if(ioption[Opt_ViewColors]) fprintf(fp,"\e[1;34m---\e[m");
  switch(enc) {
    case 1: view_quoted_printable_part(fp,q,end-q); break;
    default: view_part(fp,q,end-q);
  }
  if(ioption[Opt_ViewColors]) fprintf(fp,"\e[1;35m.\e[m\n");
}

static void cmd_view(const char*arg) {
  FILE*fp;
  sqlite3_stmt*st;
  int i;
  const unsigned char*data;
  int len;
  if(sqlite3_prepare_v2(db,ioption[Opt_AutoMarkRead]?"SELECT `DATA`,`READ` FROM `ART` WHERE `ID` = ?1;":"SELECT `DATA` FROM `ART` WHERE `ID` = ?1;",-1,&st,0)) {
    color_printf("31","SQL error: ");
    printf("%s\n",sqlite3_errmsg(db));
    return;
  }
  sqlite3_bind_int64(st,1,curid);
  i=sqlite3_step(st);
  if(i!=SQLITE_ROW) {
    if(i==SQLITE_DONE) {
      color_printf("31","Error: ");
      printf("Article not found\n");
    } else {
      color_printf("31","SQL error: ");
      printf("%s\n",sqlite3_errmsg(db));
    }
    goto done;
  }
  if(data=sqlite3_column_blob(st,0)) {
    len=sqlite3_column_bytes(st,0);
    if(option[Opt_Pager]) fp=popen(option[Opt_Pager],"w"); else fp=stdout;
    if(ioption[Opt_ViewRaw]) {
      fwrite(data,1,len,fp);
    } else {
      view_article(fp,data,len,!option[Opt_ViewHeaders]);
    }
    if(option[Opt_Pager]) pclose(fp);
  }
  if(ioption[Opt_AutoMarkRead] && !sqlite3_column_int(st,1)) {
    sqlite3_finalize(st);
    if(sqlite3_prepare_v2(db,"UPDATE `ART` SET `READ` = 1 WHERE `ID` = ?1;",-1,&st,0)) {
      color_printf("31","SQL error: ");
      printf("%s\n",sqlite3_errmsg(db));
      return;
    }
    sqlite3_bind_int64(st,1,curid);
    if(sqlite3_step(st)!=SQLITE_DONE) {
      color_printf("31","SQL error: ");
      printf("%s\n",sqlite3_errmsg(db));
    }
  }
  done:
  sqlite3_finalize(st);
}

static void do_macro(sqlite3_stmt*st,const char*arg) {
  int i;
  const char*s;
  sqlite3_reset(st);
  sqlite3_clear_bindings(st);
  sqlite3_bind_text(st,sqlite3_bind_parameter_index(st,"$A"),arg,-1,SQLITE_TRANSIENT);
  sqlite3_bind_text(st,sqlite3_bind_parameter_index(st,"$G"),curgroup,-1,SQLITE_TRANSIENT);
  sqlite3_bind_text(st,sqlite3_bind_parameter_index(st,"$H"),home,-1,0);
  sqlite3_bind_int64(st,sqlite3_bind_parameter_index(st,"$N"),curid);
  while((i=sqlite3_step(st))==SQLITE_ROW) {
    if(s=sqlite3_column_text(st,0)) do_command(s);
  }
  if(i!=SQLITE_DONE) {
    color_printf("31","SQL error: ");
    printf("%s\n",sqlite3_errmsg(db));
  }
  sqlite3_reset(st);
  sqlite3_clear_bindings(st);
}

typedef struct {
  const char*name;
  void(*call)(const char*);
} CommandInfo;

static const CommandInfo cmdinf[]={
  // These commands must be listed in ASCII order.
  {"!",cmd_sh},
  {".",cmd_noop},
  {"H",cmd_Headers},
  {"Headers",cmd_Headers},
  {"L",cmd_List},
  {"List",cmd_List},
  {"Sql",cmd_Sql},
  {"cd",cmd_chdir},
  {"chdir",cmd_chdir},
  {"d",cmd_delete},
  {"delete",cmd_delete},
  {"dl",cmd_download},
  {"download",cmd_download},
  {"e",cmd_edit},
  {"echo",cmd_echo},
  {"edit",cmd_edit},
  {"export",cmd_export},
  {"f",cmd_followup},
  {"fil",cmd_filter},
  {"filter",cmd_filter},
  {"followup",cmd_followup},
  {"g",cmd_group},
  {"get",cmd_get},
  {"group",cmd_group},
  {"h",cmd_headers},
  {"headers",cmd_headers},
  {"l",cmd_list},
  {"list",cmd_list},
  {"markread",cmd_markread},
  {"markunread",cmd_markunread},
  {"mr",cmd_markread},
  {"mu",cmd_markunread},
  {"new",cmd_new},
  {"noop",cmd_noop},
  {"p",cmd_post},
  {"pipe",cmd_pipe},
  {"post",cmd_post},
  {"pwd",cmd_pwd},
  {"q",cmd_quit},
  {"quit",cmd_quit},
  {"repost",cmd_repost},
  {"rp",cmd_repost},
  {"select",cmd_select},
  {"set",cmd_set},
  {"sh",cmd_sh},
  {"sql",cmd_sql},
  {"unset",cmd_unset},
  {"v",cmd_view},
  {"view",cmd_view},
  {"x",cmd_export},
  {"|",cmd_pipe},
};

static int compare_command(const void*a,const void*b) {
  const CommandInfo*x=a;
  const CommandInfo*y=b;
  const char*p=x->name;
  const char*q=y->name;
  int i;
  for(i=0;i<command_length;i++) {
    if(p[i]>q[i]) return 1;
    if(p[i]<q[i]) return -1;
  }
  return -q[command_length];
}

static void do_command(const char*cmd) {
  CommandInfo key;
  CommandInfo*res;
  again:
  while(*cmd==' ' || *cmd=='\t') cmd++;
  if(!*cmd) return;
  key.name=cmd;
  command_length=strchrnul(cmd,' ')-cmd;
  if(*cmd>='0' && *cmd<='9') {
    curid=strtoll(cmd,(char**)&cmd,10);
    if(*cmd) goto again;
    if(ioption[Opt_AutoView]) cmd_view("");
    return;
  } else if((*cmd==',' || *cmd==';') && usermacro[cmd[1]&127]) {
    listmore=0;
    do_macro(usermacro[cmd[1]&127],cmd[2]==' '?cmd+3:cmd+2);
    return;
  }
  res=bsearch(&key,cmdinf,countof(cmdinf),sizeof(CommandInfo),compare_command);
  if(res) {
    if((res->call==cmd_headers || res->call==cmd_Headers) && !cmd[command_length]) listmore++; else listmore=0;
    res->call(cmd[command_length]?cmd+command_length+1:"");
  } else {
    color_printf("31","Error: ");
    printf("Invalid command.\n");
  }
}

static int do_command_ex(void*user,int argc,char**argv,char**names) {
  if(argc && *argv) do_command(*argv);
  return 0;
}

static inline void mainloop(void) {
  char*p;
  int i;
  again:
  color_printf("33","%s",curgroup);
  if(curid) {
    putchar(':');
    color_printf("36","%lld",(long long)curid);
  }
  if(!sqlite3_get_autocommit(db)) color_printf("1;32","=");
  printf("> ");
  if(!fgets(buf,0x1000,stdin)) return;
  p=buf+strlen(buf);
  if(p==buf) goto again;
  if(p[-1]!='\n') while((i=fgetc(stdin)) && (i!='\n' && i!=EOF));
  while(p>buf && (p[-1]=='\n' || p[-1]==' ')) *--p=0;
  do_command(buf);
  if(unterminated) goto again;
}

static void fn_bystand_version(sqlite3_context*cxt,int argc,sqlite3_value**argv) {
  sqlite3_result_text(cxt,BYSTAND_VERSION,-1,0);
}

static void fn_echo_if(sqlite3_context*cxt,int argc,sqlite3_value**argv) {
  const char*s;
  if(sqlite3_value_int(argv[1])) {
    if(s=sqlite3_value_text(argv[0])) color_printf("1;33","# %s\n",s);
  }
}

static void fn_format_date(sqlite3_context*cxt,int argc,sqlite3_value**argv) {
  struct tm tm;
  time_t t;
  char b[64];
  int i;
  if(sqlite3_value_type(*argv)==SQLITE_NULL) return;
  memset(&tm,0,sizeof(tm));
  t=sqlite3_value_int64(*argv);
  if(ioption[Opt_LocalTime]) {
    tzset();
    if(!localtime_r(&t,&tm)) return;
    i=timezone/-60;
    if(tm.tm_isdst>0) i+=60;
    if(i<0) i=-(-i)%60-100*((-i)/60);
    else i=i%60+100*(i/60);
  } else {
    if(!gmtime_r(&t,&tm)) return;
    i=0;
  }
  sprintf(b,"%3.3s, %02d %3.3s %d %02d:%02d:%02d %+05d"
   ,"SunMonTueWedThuFriSat"+3*tm.tm_wday,tm.tm_mday,"JanFebMarAprMayJunJulAugSepOctNovDec"+3*tm.tm_mon,tm.tm_year+1900
   ,tm.tm_hour,tm.tm_min,tm.tm_sec,i);
  sqlite3_result_text(cxt,b,-1,SQLITE_TRANSIENT);
}

static void fn_format_row(sqlite3_context*cxt,int argc,sqlite3_value**argv) {
  int a=1;
  int n=0;
  const char*t;
  sqlite3_str*s;
  const char*f=sqlite3_value_text(*argv);
  if(!f) return;
  s=sqlite3_str_new(0);
  while(*f) {
    switch(*f) {
      case '0' ... '9':
        n=10*n+*f-'0';
        break;
      case '_':
        sqlite3_str_appendchar(s,1,' ');
        break;
      case '"':
        sqlite3_str_appendchar(s,1,*++f);
        break;
      case ',':
        if(a==argc) break;
        switch(sqlite3_value_type(argv[a])) {
          case SQLITE_INTEGER:
          case SQLITE_FLOAT:
            sqlite3_str_appendf(s,"%*lld",n,sqlite3_value_int64(argv[a]));
            break;
          case SQLITE_NULL:
            sqlite3_str_appendchar(s,n,' ');
            break;
          case SQLITE_TEXT:
          case SQLITE_BLOB:
            t=sqlite3_value_text(argv[a]);
            if(!t) t="";
            while(n && *t) {
              sqlite3_str_appendchar(s,1,(*t<32||*t>126)?'?':*t);
              t++,n--;
            }
            if(n) sqlite3_str_appendchar(s,n,' ');
            break;
        }
        a++;
        n=0;
        if(ioption[Opt_Color]) sqlite3_str_appendall(s,"\e[m");
        break;
      case '=':
        sqlite3_str_appendchar(s,n,' ');
        n=0;
        break;
      case '[':
        if(option[Opt_Color]) {
          sqlite3_str_appendchar(s,1,'\e');
          while(*f && *f!=']') sqlite3_str_appendchar(s,1,*f++);
          sqlite3_str_appendchar(s,1,'m');
        } else {
          f=strchrnul(f,']');
        }
        break;
      case '|': case ':':
        sqlite3_str_appendchar(s,1,*f);
        break;
      case '!':
        sqlite3_str_appendall(s,"echo ");
        break;
      case '>':
        if(a==argc) break;
        sqlite3_str_appendchar(s,(n?:1)*sqlite3_value_int(argv[a++]),*++f);
        n=0;
        if(ioption[Opt_Color]) sqlite3_str_appendall(s,"\e[m");
        break;
      case '&':
        if(a==argc) break;
        sqlite3_str_appendall(s,sqlite3_value_text(argv[a++])?:(const unsigned char*)"");
        if(ioption[Opt_Color]) sqlite3_str_appendall(s,"\e[m");
        break;
      default:
        break;
    }
    if(*f) f++;
  }
  if(ioption[Opt_Color]) sqlite3_str_appendall(s,"\e[m");
  if(sqlite3_str_errcode(s)) {
    sqlite3_result_error(cxt,sqlite3_errstr(sqlite3_str_errcode(s)),-1);
    sqlite3_result_error_code(cxt,sqlite3_str_errcode(s));
    sqlite3_free(sqlite3_str_finish(s));
  } else {
    sqlite3_result_text(cxt,sqlite3_str_finish(s),-1,sqlite3_free);
  }
}

static void fn_group_prefix(sqlite3_context*cxt,int argc,sqlite3_value**argv) {
  const char*x=sqlite3_value_text(argv[0]);
  int n=sqlite3_value_bytes(argv[0]);
  int m=sqlite3_value_bytes(argv[1]);
  const char*z;
  if(n<m || !x || !n) {
    sqlite3_result_error(cxt,"Invalid arguments to GROUP_PREFIX function",-1);
    return;
  }
  if(n==m) {
    sqlite3_result_value(cxt,argv[0]);
    return;
  }
  if(z=strchr(x+m,'.')) {
    sqlite3_result_text(cxt,x,(z-x)+1,SQLITE_TRANSIENT);
  } else {
    sqlite3_result_value(cxt,argv[0]);
  }
}

static void fn_header(sqlite3_context*cxt,int argc,sqlite3_value**argv) {
  const char*data=sqlite3_value_blob(argv[0]);
  int len=sqlite3_value_bytes(argv[0]);
  const char*name=sqlite3_value_text(argv[1]);
  int nlen=sqlite3_value_bytes(argv[1]);
  char*s=get_header(cxt,data,len,name,nlen);
  if(s) sqlite3_result_text(cxt,s,-1,sqlite3_free);
}

static void fn_now(sqlite3_context*cxt,int argc,sqlite3_value**argv) {
  sqlite3_result_int64(cxt,time(0));
}

static void fn_parse_date(sqlite3_context*cxt,int argc,sqlite3_value**argv) {
  struct tm tm;
  time_t t;
  const char*b=sqlite3_value_text(*argv);
  const char m[]="JanFebMarAprMayJunJulAugSepOctNovDec";
  char q[8];
  int i,j;
  if(!b) return;
  memset(&tm,0,sizeof(tm));
  q[3]=q[7]=0;
  while(*b==' ' || *b=='\t') b++;
  if(*b<'0' || *b>'9') {
    b=strchr(b,',');
    if(!b) return;
    b++;
  }
  if(sscanf(b," %u %3[A-Za-z] %u %u:%u %n",&tm.tm_mday,q,&tm.tm_year,&tm.tm_hour,&tm.tm_min,&i)<5) return;
  b+=i;
  if(tm.tm_year>1000) tm.tm_year-=1900;
  if(*b==':') {
    if(sscanf(b,":%u %n",&tm.tm_sec,&i)<1) return;
    b+=i;
  }
  if(sscanf(b,"%1[+-]%d",q+4,&j)<2) j=0;
  j-=40*(j/100);
  if(q[4]=='+') j=-j;
  b=strstr(m,q);
  if(!b) return;
  i=b-m;
  if(i%3) return;
  tm.tm_mon=i/3;
  t=timegm(&tm);
  sqlite3_result_int64(cxt,t+j*60);
}

static void fn_prepend_headers(sqlite3_context*cxt,int argc,sqlite3_value**argv) {
  sqlite3_stmt*st;
  sqlite3_str*m;
  const char*s;
  int i;
  if(!option[Opt_PrependHeaders]) {
    sqlite3_result_text(cxt,"",0,0);
    return;
  }
  if(i=sqlite3_prepare_v2(db,option[Opt_PrependHeaders],-1,&st,0)) {
    sqlite3_result_error(cxt,sqlite3_errmsg(db),-1);
    sqlite3_result_error_code(cxt,i);
    return;
  }
  sqlite3_bind_value(st,sqlite3_bind_parameter_index(st,"$A"),argv[0]);
  sqlite3_bind_value(st,sqlite3_bind_parameter_index(st,"$N"),argv[1]);
  m=sqlite3_str_new(db);
  while((i=sqlite3_step(st))==SQLITE_ROW) {
    if(s=sqlite3_column_text(st,0)) {
      sqlite3_str_appendall(m,s);
      sqlite3_str_appendchar(m,1,'\n');
    }
  }
  sqlite3_finalize(st);
  if(i!=SQLITE_DONE) {
    sqlite3_result_error(cxt,sqlite3_errmsg(db),-1);
    sqlite3_result_error_code(cxt,i);
    sqlite3_free(sqlite3_str_finish(m));
    return;
  }
  if(i=sqlite3_str_errcode(m)) {
    if(i==SQLITE_NOMEM) sqlite3_result_error_nomem(cxt);
    else if(i==SQLITE_TOOBIG) sqlite3_result_error_toobig(cxt);
    else sqlite3_result_error(cxt,"String building error",-1);
    sqlite3_free(sqlite3_str_finish(m));
    return;
  }
  if(sqlite3_str_length(m)) {
    sqlite3_result_text(cxt,sqlite3_str_finish(m),-1,sqlite3_free);
  } else {
    sqlite3_free(sqlite3_str_finish(m));
    sqlite3_result_text(cxt,"",0,0);
  }
}

static void fn_reply_to_subject(sqlite3_context*cxt,int argc,sqlite3_value**argv) {
  const char*t=sqlite3_value_text(*argv);
  const char*s;
  if(!t) return;
  if(sqlite3_strnicmp(t,"Re:",3)) {
    s=sqlite3_mprintf("Re: %s",t);
    if(s) sqlite3_result_text(cxt,s,-1,sqlite3_free);
    else sqlite3_result_error_nomem(cxt);
  } else {
    sqlite3_result_value(cxt,*argv);
  }
}

static void fn_right_msgid(sqlite3_context*cxt,int argc,sqlite3_value**argv) {
  const char*s=sqlite3_value_text(*argv);
  const char*p=0;
  const char*q=s;
  if(!s) return;
  while(q && (s=strchr(q,'<'))) if(q=strchr(s,'>')) p=s;
  if(p && q && p<q) sqlite3_result_text(cxt,p,q-p+1,SQLITE_TRANSIENT);
}

static void fn_score(sqlite3_context*cxt,int argc,sqlite3_value**argv) {
  const char*data=sqlite3_value_blob(*argv);
  int len=sqlite3_value_bytes(*argv);
  sqlite3_int64 t=0;
  int q=0;
  static char*h[128];
  int i,n;
  if(!nscoring) load_scoring();
  if(!data || !len) return;
  for(i=0;i<nscoringh;i++) h[i]=get_header(cxt,data,len,scoringh[i],strlen(scoringh[i]));
  for(i=0;i<nscoring;i++) {
    if(scoring[i].flag && !q) continue;
    sqlite3_reset(scoring[i].stmt);
    for(n=0;n<scoring[i].nh;n++) {
      if(scoring[i].headers[n]==-1) sqlite3_bind_blob(scoring[i].stmt,n+1,data,len,0);
      else sqlite3_bind_text(scoring[i].stmt,n+1,h[scoring[i].headers[n]],-1,0);
    }
    n=sqlite3_step(scoring[i].stmt);
    if(n==SQLITE_ROW && sqlite3_column_int(scoring[i].stmt,0)) {
      q=1;
      t+=sqlite3_data_count(scoring[i].stmt)>1?sqlite3_column_int64(scoring[i].stmt,1):scoring[i].score;
    } else if(!scoring[i].flag) {
      q=0;
    }
    sqlite3_reset(scoring[i].stmt);
    sqlite3_clear_bindings(scoring[i].stmt);
  }
  for(i=0;i<nscoringh;i++) sqlite3_free(h[i]);
  sqlite3_result_int64(cxt,t);
}

static void fn_system(sqlite3_context*cxt,int argc,sqlite3_value**argv) {
  const char*t=sqlite3_value_text(*argv);
  int i;
  FILE*fp;
  sqlite3_str*m;
  char b[256];
  if(!t) return;
  fp=popen(t,"r");
  m=sqlite3_str_new(db);
  while((i=fread(b,1,256,fp))>0) sqlite3_str_append(m,b,i);
  pclose(fp);
  if(i=sqlite3_str_errcode(m)) {
    if(i==SQLITE_NOMEM) sqlite3_result_error_nomem(cxt);
    else if(i==SQLITE_TOOBIG) sqlite3_result_error_toobig(cxt);
    else sqlite3_result_error(cxt,"String building error",-1);
    sqlite3_free(sqlite3_str_finish(m));
    return;
  }
  if(sqlite3_str_length(m)) {
    sqlite3_result_text(cxt,sqlite3_str_finish(m),-1,sqlite3_free);
  } else {
    sqlite3_free(sqlite3_str_finish(m));
    sqlite3_result_text(cxt,"",0,0);
  }
}

static void fn_unusenet_server_name(sqlite3_context*cxt,int argc,sqlite3_value**argv) {
  const char*s=sqlite3_value_text(*argv);
  const char*p;
  char*o=0;
  int i,j;
  if(!s) return;
  if(!strncmp(s,"un0.ip.",7)) {
    s+=7;
    i=0;
    j=4;
    while(j && s[i] && i<16) {
      if(s[i]=='.') j--;
      else if(s[i]<'0' || s[i]>'9') return;
      i++;
    }
    if(j==1 && !s[i]) i++,j=0;
    if(j) return;
    sqlite3_result_text(cxt,s,i-1,SQLITE_TRANSIENT);
  } else if(!strncmp(s,"un",2) && s[2]>'0' && s[2]<='9') {
    i=strtol(s+2,(char**)&s,10);
    if(!i) return;
    if(*s++!='.') return;
    o=sqlite3_mprintf("");
    if(!o) goto nomem;
    while(i) {
      if(!*s) return;
      p=strchrnul(s,'.');
      o=sqlite3_mprintf(*o?"%.*s.%z":"%.*s%z",(int)(p-s),s,o);
      if(!o) goto nomem;
      i--;
      s=p+1;
    }
    sqlite3_result_text(cxt,o,-1,sqlite3_free);
  }
  return;
  nomem:
  sqlite3_result_error_nomem(cxt);
}

int main(int argc,char**argv) {
  if(argc>1 && !strcmp(argv[1],"-V")) {
    puts(BYSTAND_VERSION);
    return 0;
  }
  sqlite3_config(SQLITE_CONFIG_SINGLETHREAD);
  sqlite3_initialize();
  init_home();
  snprintf(buf,0x1000,"%s/database",home);
  if(sqlite3_open_v2(buf,&db,SQLITE_OPEN_READWRITE,getenv("BYSTAND_VFS"))) {
    fprintf(stderr,"Cannot open database: %s\n",buf);
    if(db) fprintf(stderr,"(%s)\n",sqlite3_errmsg(db));
    return 1;
  }
  sqlite3_exec(db,"CREATE TEMPORARY TABLE `_DOWNLOADS`(`ID` TEXT PRIMARY KEY) WITHOUT ROWID;",0,0,0);
  sqlite3_exec(db,"CREATE TEMPORARY TABLE `_UPDATEGROUPS`(`NAME` TEXT PRIMARY KEY, `LAST` INT) WITHOUT ROWID;",0,0,0);
  sqlite3_enable_load_extension(db,1);
  sqlite3_create_function(db,"BYSTAND_VERSION",0,SQLITE_UTF8,0,fn_bystand_version,0,0);
  sqlite3_create_function(db,"ECHO_IF",2,SQLITE_UTF8,0,fn_echo_if,0,0);
  sqlite3_create_function(db,"FORMAT_DATE",1,SQLITE_UTF8|SQLITE_DETERMINISTIC,0,fn_format_date,0,0);
  sqlite3_create_function(db,"FORMAT_ROW",-1,SQLITE_UTF8|SQLITE_DETERMINISTIC,0,fn_format_row,0,0);
  sqlite3_create_function(db,"GROUP_PREFIX",2,SQLITE_UTF8|SQLITE_DETERMINISTIC,0,fn_group_prefix,0,0);
  sqlite3_create_function(db,"HEADER",2,SQLITE_UTF8|SQLITE_DETERMINISTIC,0,fn_header,0,0);
  sqlite3_create_function(db,"NOW",0,SQLITE_UTF8,0,fn_now,0,0);
  sqlite3_create_function(db,"PARSE_DATE",1,SQLITE_UTF8|SQLITE_DETERMINISTIC,0,fn_parse_date,0,0);
  sqlite3_create_function(db,"PREPEND_HEADERS",2,SQLITE_UTF8,0,fn_prepend_headers,0,0);
  sqlite3_create_function(db,"REPLY_TO_SUBJECT",1,SQLITE_UTF8|SQLITE_DETERMINISTIC,0,fn_reply_to_subject,0,0);
  sqlite3_create_function(db,"RIGHT_MSGID",1,SQLITE_UTF8|SQLITE_DETERMINISTIC,0,fn_right_msgid,0,0);
  sqlite3_create_function(db,"SCORE",1,SQLITE_UTF8,0,fn_score,0,0);
  sqlite3_create_function(db,"SYSTEM",1,SQLITE_UTF8,0,fn_system,0,0);
  sqlite3_create_function(db,"UNUSENET_SERVER_NAME",1,SQLITE_UTF8|SQLITE_DETERMINISTIC,0,fn_unusenet_server_name,0,0);
  load_config("");
  load_user_macros();
  strncpy(curgroup,option[Opt_StartGroup]?:"*",511);
  if(option[Opt_InitSQL]) {
    if(sqlite3_exec(db,option[Opt_InitSQL],do_command_ex,0,0)) errx(1,"SQL error: %s",sqlite3_errmsg(db));
  }
  sqlite3_enable_load_extension(db,0);
  mainloop();
  if(ioption[Opt_Color]) printf("\e[m");
  putchar('\n');
  return 0;
}
