REM ------------------------------------------------------------
REM   PURPOSE: TEST THE PARAMETER RANGE CHECKS
REM    AUTHOR: HOWARD WULF, AF5NE
REM GENERATED: 02/21/2015 14:08:35
REM  FILENAME: F_TAN_X_N.BAS
REM    SYNTAX: N  = TAN( X )
REM  UNIQUEID: F_TAN_X_N
REM  FUNCTION: TAN
REM 
REM	VARIABLE	DESCRIPTION
REM	I	CURRENT  TESTCASE NUMBER
REM	E	EXPECTED ERROR FLAG
REM	F	ACTUAL   ERROR FLAG
REM	R	EXPECTED FUNCTION RESULT
REM	N	ACTUAL   FUNCTION RESULT
REM	X	ACTUAL   FUNCTION PARAMETER
REM 
RESTORE 2000
REM GET TESTCASE #
READ  I
WHILE I > 0
REM GET TESTCASE DATA
READ  E, R, X
REM DISPLAY TESTCASE DATA
PRINT "TESTCASE #";I,"E=";E,"R=";R, "X=";X
REM EXECUTE TESTCASE
N =  0 
S$ = ""
ON ERROR GOTO 9000
F = 0
999 N  = TAN( X )
ERROR 0
REM DISPLAY TESTCASE RESULTS
PRINT ,"F=";F,"N=";N
REM VERIFY EXPECTED ERROR
IF E <> F THEN
  PRINT "*** TEST FAILED, EXCEPTION MISMATCH ***"
  STOP
END IF
REM VERIFY EXPECTED RESULT
IF R > 0 THEN
  LET RMIN = 0.99 * R
  IF R > MAXNUM / 1.012 THEN
    LET RMAX = MAXNUM
  ELSE
    LET RMAX = 1.01 * R
  END IF
END IF
IF R < 0 THEN
  IF R < - MAXNUM / 1.012 THEN
    LET RMIN = -MAXNUM
  ELSE
    LET RMIN = 1.01 * R
  END IF
  LET RMAX = 0.99 * R
END IF
IF R = 0 THEN
  LET RMIN = -.01
  LET RMAX = +.01
END IF
IF N < RMIN THEN
  PRINT "*** TEST FAILED, RESULT MISMATCH ***"
  STOP
END IF
IF N > RMAX THEN
  PRINT "*** TEST FAILED, RESULT MISMATCH ***"
  STOP
END IF
PRINT "*** TEST PASSED ***"
REM GET NEXT TESTCASE #
READ  I
WEND
PRINT "*** ALL TESTS PASSED ***"
GOTO 9999
1999 REM TESTCASE, EXPECTED ERROR, EXPECTED RESULT, PARAMETERS...
DATA  1 ,  0 ,  0 ,  0 
DATA  2 ,  0 ,  1.55741 ,  1 
DATA  3 ,  0 , -1.55741 , -1 
DATA  4 ,  0 ,  .422793 ,  .4 
DATA  5 ,  0 , -.422793 , -.4 
DATA  6 ,  0 ,  .684137 ,  .6 
DATA  7 ,  0 , -.684137 , -.6 
DATA  8 ,  0 , -.506715 ,  254 
DATA  9 ,  0 ,  .587254 ,  255 
DATA  10 ,  0 ,  25.1116 ,  256 
DATA  11 ,  0 , -.268989 ,  32000 
DATA  12 ,  0 , -.231222 , -.227229 
DATA  13 ,  0 , -.243823 , -.239157 
DATA  14 ,  0 , -.216894 , -.213586 
DATA  15 ,  0 ,  .281798 ,  .274675 
DATA  16 ,  0 ,  .171416 ,  .169766 
DATA  17 ,  0 ,  .33002 ,  .318766 
DATA  18 ,  0 ,  2.06687E-2 ,  2.06658E-2 
DATA  19 ,  0 ,  .190513 ,  .188257 
DATA  20 ,  0 , -.28489 , -.277537 
DATA  21 ,  0 , -.522268 , -.481303 
DATA  22 ,  0 ,  .465368 ,  .43556 
DATA  23 ,  0 , -.214158 , -.210971 
DATA  24 ,  0 , -.489504 , -.455216 
DATA  25 ,  0 , -1.4021 , -110.907 
DATA  26 ,  0 , -2.44216 ,  105.632 
DATA  27 ,  0 , -2.94704 , -114.341 
DATA  28 ,  0 , -.255068 ,  109.706 
DATA  29 ,  0 , -.946165 ,  109.198 
DATA  30 ,  0 ,  1.76081 ,  85.8773 
DATA  31 ,  0 ,  4.17051 , -58.3548 
DATA  32 ,  0 ,  4.79916 ,  29.6397 
DATA  33 ,  0 , -40.0774 , -108.36 
DATA  34 ,  0 ,  .69001 , -46.5199 
DATA  35 ,  0 , -.649944 ,  112.521 
DATA  36 ,  0 ,  7.20066 ,  45.4151 
DATA  37 ,  0 ,  .681256 ,  101.129 
DATA  38 ,  0 , -1.33015 ,  65.0473 
DATA  39 ,  0 ,  3.30892 ,  48.4012 
DATA  40 ,  0 , -.232154 ,  122.294 
DATA  41 ,  0 ,  .469886 , -56.1094 
DATA  42 ,  0 ,  7.32485 , -121.087 
DATA  43 ,  0 , -1.54003 , -123.517 
DATA  44 ,  0 , -.245488 , -97.6301 
DATA  45 ,  0 , -2.34851 , -64.0001 
DATA  46 ,  0 , -.621473 , -25.6888 
DATA  47 ,  0 , -1.27939 ,  14.8006 
DATA  48 ,  0 , -5.71055 , -61.0877 
DATA  49 ,  0 , -.78359 , -66.6381 
DATA  50 ,  0 , -.849158 , -5476.5 
DATA  51 ,  0 , -6.08812 , -21210.3 
DATA  52 ,  0 ,  1.3668 , -28757.2 
DATA  53 ,  0 ,  1.04293 , -28732.2 
DATA  54 ,  0 ,  .636137 ,  12730.3 
DATA  55 ,  0 ,  1.15808 , -1830.69 
DATA  56 ,  0 ,  2.35491 ,  5486.39 
DATA  57 ,  0 ,  6.12711E-2 ,  22405.9 
DATA  58 ,  0 ,  .203591 ,  30809.8 
DATA  59 ,  0 ,  .338894 , -28930.6 
DATA  60 ,  0 , -20.3356 , -6014.53 
DATA  61 ,  0 ,  .935191 ,  17414.6 
DATA  62 ,  0 , -5.73757 , -10538.3 
DATA  63 ,  0 ,  7.03078E-2 , -17536.3 
DATA  64 ,  0 , -.508355 , -8856.62 
DATA  65 ,  0 , -.513537 , -5140.12 
DATA  66 ,  0 ,  8.77242E-2 , -8595.31 
DATA  67 ,  0 ,  .721922 , -3382.87 
DATA  68 ,  0 , -.767322 , -5002.07 
DATA  69 ,  0 , -4.25488 , -5800.72 
DATA  70 ,  0 ,  12.5078 ,  29686.4 
DATA  71 ,  0 ,  2.40816 ,  2571. 
DATA  72 ,  0 , -4.30376 ,  31091. 
DATA  73 ,  0 ,  .107868 ,  14819. 
DATA  74 ,  0 , -1.56543 ,  3790.9 
DATA  75 ,  0 ,  .695559 , -4.2981E+9 
DATA  76 ,  0 , -.462965 , -7.05453E+8 
DATA  77 ,  0 ,  .447665 , -3.10179E+9 
DATA  78 ,  0 ,  4.32945 , -4.86159E+9 
DATA  79 ,  0 , -1.11353 , -8.62908E+8 
DATA  80 ,  0 ,  .412946 , -3.4101E+9 
DATA  81 ,  0 ,  1.27465 ,  3.3889E+9 
DATA  82 ,  0 ,  1.04838 ,  2.49826E+9 
DATA  83 ,  0 , -2.22701 ,  2.3491E+9 
DATA  84 ,  0 , -.801861 ,  1.94745E+8 
DATA  85 ,  0 ,  .160414 ,  2.02475E+9 
DATA  86 ,  0 ,  1.17816 , -2.26748E+9 
DATA  87 ,  0 , -5.61655E-2 , -2.10587E+9 
DATA  88 ,  0 ,  2.82231 ,  4.23585E+9 
DATA  89 ,  0 , -.166401 , -2.66524E+9 
DATA  90 ,  0 , -1.07964 ,  4.01052E+9 
DATA  91 ,  0 ,  .406664 , -4.87912E+9 
DATA  92 ,  0 , -25.4693 ,  1.77556E+9 
DATA  93 ,  0 , -.705126 ,  2.87705E+8 
DATA  94 ,  0 ,  .357809 ,  1.99977E+8 
DATA  95 ,  0 , -.689009 , -3.39941E+9 
DATA  96 ,  0 ,  6.87334 , -3.49119E+9 
DATA  97 ,  0 ,  18.8431 , -2.86324E+9 
DATA  98 ,  0 ,  1.34211 ,  4.20418E+9 
DATA  99 ,  0 , -1.16396 , -3.1518E+9 
DATA  100 ,  0 ,  .971919 ,  4.60615E+9 
DATA 0
9000 REM ERROR HANDLER
IF ERL = 999 THEN
  F = ABS(SGN(ERR))
  RESUME NEXT
END IF
PRINT "*** UNEXPECTED ERROR ON LINE ";ERL;" ***"
9999 END
